import six
from ipywidgets import (
    Widget, DOMWidget, widget_serialization, register
)
from ipywidgets.widgets.trait_types import TypedTuple
from traitlets import (
    Unicode, Int, CInt, Instance, ForwardDeclaredInstance, This, Enum,
    Tuple, List, Dict, Float, CFloat, Bool, Union, Any,
)

from .._base.Three import ThreeWidget
from .._base.uniforms import uniforms_serialization
from ..enums import *
from ..traits import *

from ..core.Object3D import Object3D

from ..lights.HemisphereLight_autogen import HemisphereLight

@register
class HemisphereLightHelper(Object3D):
    """HemisphereLightHelper

    Autogenerated by generate-wrappers.js
    See https://threejs.org/docs/#api/helpers/HemisphereLightHelper
    """

    def __init__(self, light=None, size=1, color="#ffffff", **kwargs):
        kwargs['light'] = light
        kwargs['size'] = size
        kwargs['color'] = color
        super(HemisphereLightHelper, self).__init__(**kwargs)

    _model_name = Unicode('HemisphereLightHelperModel').tag(sync=True)

    light = Instance(HemisphereLight, allow_none=True).tag(sync=True, **widget_serialization)

    size = CFloat(1, allow_none=False).tag(sync=True)

    color = Color("#ffffff", allow_none=True).tag(sync=True)

    type = Unicode("HemisphereLightHelper", allow_none=False).tag(sync=True)


if six.PY3:
    import inspect
    # Include explicit signature since the metaclass screws it up
    HemisphereLightHelper.__signature__ = inspect.signature(HemisphereLightHelper.__init__)
