/*
 * Decompiled with CFR 0.152.
 */
package com.datapps.linkoopdb.jdbc.impl;

import com.datapps.linkoopdb.jdbc.DatabaseURL;
import com.datapps.linkoopdb.jdbc.error.Error;
import com.datapps.linkoopdb.jdbc.impl.JDBCConnection;
import com.datapps.linkoopdb.jdbc.impl.JDBCUtil;
import com.datapps.linkoopdb.jdbc.persist.LdbSqlProperties;
import java.io.UnsupportedEncodingException;
import java.sql.Connection;
import java.sql.Driver;
import java.sql.DriverManager;
import java.sql.DriverPropertyInfo;
import java.sql.SQLException;
import java.sql.SQLFeatureNotSupportedException;
import java.util.Properties;
import java.util.logging.Logger;

public class JDBCDriver
implements Driver {
    public static final JDBCDriver driverInstance = new JDBCDriver();
    public final ThreadLocal<JDBCConnection> threadConnection = new ThreadLocal();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Connection getConnection(String url, Properties info) throws SQLException {
        final LdbSqlProperties props = DatabaseURL.parseURL(url, true, false);
        if (props == null) {
            throw JDBCUtil.invalidArgument();
        }
        if (props.isEmpty()) {
            return null;
        }
        long timeout = 0L;
        if (info != null) {
            timeout = LdbSqlProperties.getIntegerProperty(info, "loginTimeout", 0);
        }
        props.addProperties(info);
        if (timeout == 0L) {
            timeout = DriverManager.getLoginTimeout();
        }
        if (timeout == 0L) {
            try {
                return new JDBCConnection(props);
            }
            catch (UnsupportedEncodingException e) {
                throw Error.error(3456, "UnsupportedEncoding");
            }
        }
        String connType = props.getProperty("connection_type");
        if (DatabaseURL.isInProcessDatabaseType(connType)) {
            try {
                return new JDBCConnection(props);
            }
            catch (UnsupportedEncodingException e) {
                throw Error.error(3456, "UnsupportedEncoding");
            }
        }
        final JDBCConnection[] conn = new JDBCConnection[1];
        final SQLException[] ex = new SQLException[1];
        Thread t = new Thread(){

            @Override
            public void run() {
                try {
                    conn[0] = new JDBCConnection(props);
                }
                catch (SQLException se) {
                    ex[0] = se;
                }
                catch (UnsupportedEncodingException e) {
                    throw Error.error(3456, "UnsupportedEncoding");
                }
            }
        };
        t.start();
        try {
            t.join(1000L * timeout);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        try {
            t.stop();
        }
        catch (Exception exception) {
        }
        finally {
            try {
                t.setContextClassLoader(null);
            }
            catch (Throwable throwable) {}
        }
        if (ex[0] != null) {
            throw ex[0];
        }
        if (conn[0] != null) {
            return conn[0];
        }
        throw JDBCUtil.sqlException(1351);
    }

    @Override
    public Connection connect(String url, Properties info) throws SQLException {
        if (url.regionMatches(true, 0, "jdbc:default:connection", 0, "jdbc:default:connection".length())) {
            JDBCConnection conn = this.threadConnection.get();
            if (conn == null) {
                return null;
            }
            return conn;
        }
        return JDBCDriver.getConnection(url, info);
    }

    @Override
    public boolean acceptsURL(String url) {
        if (url == null) {
            return false;
        }
        if (url.regionMatches(true, 0, "jdbc:linkoopdb:", 0, "jdbc:linkoopdb:".length())) {
            return true;
        }
        return url.regionMatches(true, 0, "jdbc:default:connection", 0, "jdbc:default:connection".length());
    }

    @Override
    public DriverPropertyInfo[] getPropertyInfo(String url, Properties info) {
        if (!this.acceptsURL(url)) {
            return new DriverPropertyInfo[0];
        }
        String[] choices = new String[]{"true", "false"};
        DriverPropertyInfo[] pinfo = new DriverPropertyInfo[6];
        if (info == null) {
            info = new Properties();
        }
        DriverPropertyInfo p = new DriverPropertyInfo("user", null);
        p.value = info.getProperty("user");
        p.required = true;
        pinfo[0] = p;
        p = new DriverPropertyInfo("password", null);
        p.value = info.getProperty("password");
        p.required = true;
        pinfo[1] = p;
        p = new DriverPropertyInfo("get_column_name", null);
        p.value = info.getProperty("get_column_name", "true");
        p.required = false;
        p.choices = choices;
        pinfo[2] = p;
        p = new DriverPropertyInfo("ifexists", null);
        p.value = info.getProperty("ifexists", "false");
        p.required = false;
        p.choices = choices;
        pinfo[3] = p;
        p = new DriverPropertyInfo("default_schema", null);
        p.value = info.getProperty("default_schema", "false");
        p.required = false;
        p.choices = choices;
        pinfo[4] = p;
        p = new DriverPropertyInfo("shutdown", null);
        p.value = info.getProperty("shutdown", "false");
        p.required = false;
        p.choices = choices;
        pinfo[5] = p;
        return pinfo;
    }

    @Override
    public int getMajorVersion() {
        return 1;
    }

    @Override
    public int getMinorVersion() {
        return 0;
    }

    @Override
    public boolean jdbcCompliant() {
        return true;
    }

    @Override
    public Logger getParentLogger() throws SQLFeatureNotSupportedException {
        throw (SQLFeatureNotSupportedException)JDBCUtil.notSupported();
    }

    static {
        try {
            DriverManager.registerDriver(driverInstance);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

