/*
 * Decompiled with CFR 0.152.
 */
package com.datapps.linkoopdb.jdbc.types;

import com.datapps.linkoopdb.jdbc.SessionInterface;
import com.datapps.linkoopdb.jdbc.error.Error;
import com.datapps.linkoopdb.jdbc.impl.JDBCClobClient;
import com.datapps.linkoopdb.jdbc.types.CharacterType;
import com.datapps.linkoopdb.jdbc.types.ClobData;
import com.datapps.linkoopdb.jdbc.types.ClobDataID;
import com.datapps.linkoopdb.jdbc.types.Type;
import java.sql.Clob;

public final class ClobType
extends CharacterType {
    public static final long maxClobPrecision = 0x10000000000L;
    public static final int defaultClobSize = 0x40000000;
    public static final int defaultShortClobSize = 0x1000000;

    public ClobType(long precision) {
        super(40, precision);
    }

    @Override
    public int displaySize() {
        return this.precision > Integer.MAX_VALUE ? Integer.MAX_VALUE : (int)this.precision;
    }

    @Override
    public int getJDBCTypeCode() {
        return 2005;
    }

    @Override
    public Class getJDBCClass() {
        return Clob.class;
    }

    @Override
    public String getJDBCClassName() {
        return "java.sql.Clob";
    }

    @Override
    public int getSQLGenericTypeCode() {
        return this.typeCode;
    }

    @Override
    public String getDefinition() {
        long factor = this.precision;
        String multiplier = null;
        if (this.precision % 1024L == 0L) {
            if (this.precision % 0x40000000L == 0L) {
                factor = this.precision / 0x40000000L;
                multiplier = "G";
            } else if (this.precision % 0x100000L == 0L) {
                factor = this.precision / 0x100000L;
                multiplier = "M";
            } else {
                factor = this.precision / 1024L;
                multiplier = "K";
            }
        }
        StringBuffer sb = new StringBuffer(16);
        sb.append(this.getNameString());
        sb.append('(');
        sb.append(factor);
        if (multiplier != null) {
            sb.append(multiplier);
        }
        sb.append(')');
        return sb.toString();
    }

    @Override
    public long getMaxPrecision() {
        return 0x10000000000L;
    }

    @Override
    public boolean isLobType() {
        return true;
    }

    @Override
    public int compare(SessionInterface session, Object a, Object b) {
        return this.compare(session, a, b, 40);
    }

    @Override
    public int compare(SessionInterface session, Object a, Object b, int opType) {
        if (a == b) {
            return 0;
        }
        if (a == null) {
            return -1;
        }
        if (b == null) {
            return 1;
        }
        return Type.typeHelper.compare(this, session, a, b, opType);
    }

    @Override
    public Object convertToDefaultType(SessionInterface session, Object a) {
        if (a == null) {
            return null;
        }
        if (a instanceof ClobData) {
            return a;
        }
        if (a instanceof String) {
            ClobDataID clob = session.createClob(((String)a).length());
            clob.setString(session, 0L, (String)a);
            return clob;
        }
        throw Error.error(5561);
    }

    @Override
    public String convertToString(Object a) {
        if (a == null) {
            return null;
        }
        return Long.toString(((ClobData)a).getId());
    }

    @Override
    public String convertToSQLString(Object a) {
        if (a == null) {
            return "NULL";
        }
        return this.convertToString(a);
    }

    @Override
    public Object convertJavaToSQL(SessionInterface session, Object a) {
        if (a == null) {
            return null;
        }
        if (a instanceof JDBCClobClient) {
            return ((JDBCClobClient)a).getClob();
        }
        throw Error.error(5561);
    }

    @Override
    public Object convertSQLToJava(SessionInterface session, Object a) {
        if (a == null) {
            return null;
        }
        if (a instanceof ClobDataID) {
            ClobDataID clob = (ClobDataID)a;
            return new JDBCClobClient(session, clob);
        }
        throw Error.error(5561);
    }

    @Override
    public Object convertDbToWorker(SessionInterface session, Object a) {
        if (a == null) {
            return null;
        }
        if (a instanceof String) {
            return a;
        }
        return Long.toString(((ClobDataID)a).getId());
    }

    @Override
    public Object convertWorkerToDb(SessionInterface session, Object a, Type type) {
        if (a == null) {
            return null;
        }
        String str = (String)a;
        ClobDataID clobDataID = session.createClob(str.length() * 2);
        clobDataID.setString(session, 0L, str);
        return clobDataID;
    }

    @Override
    public long position(SessionInterface session, Object data, Object otherData, Type otherType, long start) {
        if (otherType.typeCode == 40) {
            return ((ClobData)data).position(session, (ClobData)otherData, start);
        }
        if (otherType.isCharacterType()) {
            return ((ClobData)data).position(session, (String)otherData, start);
        }
        throw Error.runtimeError(201, "ClobType");
    }
}

