"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.CheckParameterFunction = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const path = require("path");
const aws_iam_1 = require("@aws-cdk/aws-iam");
const aws_lambda_1 = require("@aws-cdk/aws-lambda");
const core_1 = require("@aws-cdk/core");
class CheckParameterFunction extends aws_lambda_1.Function {
    constructor(scope, id, props) {
        super(scope, id, {
            runtime: aws_lambda_1.Runtime.NODEJS_12_X,
            handler: 'index.handler',
            code: aws_lambda_1.Code.fromAsset(path.join(__dirname, 'lambdas', 'check-parameter')),
        });
        if (props.crossAccountRole) {
            this.addToRolePolicy(new aws_iam_1.PolicyStatement({
                resources: [props.crossAccountRole.roleArn],
                actions: ['sts:AssumeRole'],
            }));
        }
        else {
            const parameterArn = core_1.Arn.format({
                service: 'ssm',
                resource: 'parameter',
                resourceName: props.parameterName.startsWith('/') ? props.parameterName.substring(1) : props.parameterName,
                arnFormat: core_1.ArnFormat.SLASH_RESOURCE_NAME,
            }, this.stack);
            this.addToRolePolicy(new aws_iam_1.PolicyStatement({
                resources: [parameterArn],
                actions: ['ssm:GetParameter'],
            }));
        }
    }
}
exports.CheckParameterFunction = CheckParameterFunction;
_a = JSII_RTTI_SYMBOL_1;
CheckParameterFunction[_a] = { fqn: "@cloudcomponents/cdk-codepipeline-check-parameter-action.CheckParameterFunction", version: "1.48.0" };
//# sourceMappingURL=data:application/json;base64,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