"""
    SatNOGS DB

    SatNOGS DB is a crowdsourced database of details about orbital                     satellites and data collected from them.  # noqa: E501

    The version of the OpenAPI document: 1.1
    Contact: dev@satnogs.org
    Generated by: https://openapi-generator.tech
"""


import re  # noqa: F401
import sys  # noqa: F401

from satnogsdbapiclient.api_client import ApiClient, Endpoint as _Endpoint
from satnogsdbapiclient.model_utils import (  # noqa: F401
    check_allowed_values,
    check_validations,
    date,
    datetime,
    file_type,
    none_type,
    validate_and_convert_types
)
from satnogsdbapiclient.model.paginated_telemetry_list import PaginatedTelemetryList
from satnogsdbapiclient.model.telemetry import Telemetry


class TelemetryApi(object):
    """NOTE: This class is auto generated by OpenAPI Generator
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """

    def __init__(self, api_client=None):
        if api_client is None:
            api_client = ApiClient()
        self.api_client = api_client
        self.telemetry_create_endpoint = _Endpoint(
            settings={
                'response_type': None,
                'auth': [
                    'cookieAuth',
                    'tokenAuth'
                ],
                'endpoint_path': '/api/telemetry/',
                'operation_id': 'telemetry_create',
                'http_method': 'POST',
                'servers': None,
            },
            params_map={
                'all': [
                    'format',
                    'version',
                    'observation_id',
                    'station_id',
                ],
                'required': [],
                'nullable': [
                    'observation_id',
                    'station_id',
                ],
                'enum': [
                    'format',
                ],
                'validation': [
                    'version',
                ]
            },
            root_map={
                'validations': {
                    ('version',): {
                        'max_length': 45,
                    },
                },
                'allowed_values': {
                    ('format',): {

                        "JSON": "json",
                        "JSON-LD": "json-ld"
                    },
                },
                'openapi_types': {
                    'format':
                        (str,),
                    'version':
                        (str,),
                    'observation_id':
                        (int, none_type,),
                    'station_id':
                        (int, none_type,),
                },
                'attribute_map': {
                    'format': 'format',
                    'version': 'version',
                    'observation_id': 'observation_id',
                    'station_id': 'station_id',
                },
                'location_map': {
                    'format': 'query',
                    'version': 'form',
                    'observation_id': 'form',
                    'station_id': 'form',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [],
                'content_type': [
                    'application/x-www-form-urlencoded',
                    'multipart/form-data'
                ]
            },
            api_client=api_client
        )
        self.telemetry_list_endpoint = _Endpoint(
            settings={
                'response_type': (PaginatedTelemetryList,),
                'auth': [
                    'cookieAuth',
                    'tokenAuth'
                ],
                'endpoint_path': '/api/telemetry/',
                'operation_id': 'telemetry_list',
                'http_method': 'GET',
                'servers': None,
            },
            params_map={
                'all': [
                    'app_source',
                    'end',
                    'format',
                    'observer',
                    'page',
                    'sat_id',
                    'satellite',
                    'start',
                    'transmitter',
                ],
                'required': [],
                'nullable': [
                ],
                'enum': [
                    'format',
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                    ('format',): {

                        "JSON": "json",
                        "JSON-LD": "json-ld"
                    },
                },
                'openapi_types': {
                    'app_source':
                        (str,),
                    'end':
                        (datetime,),
                    'format':
                        (str,),
                    'observer':
                        (str,),
                    'page':
                        (int,),
                    'sat_id':
                        (str,),
                    'satellite':
                        (str,),
                    'start':
                        (datetime,),
                    'transmitter':
                        (str,),
                },
                'attribute_map': {
                    'app_source': 'app_source',
                    'end': 'end',
                    'format': 'format',
                    'observer': 'observer',
                    'page': 'page',
                    'sat_id': 'sat_id',
                    'satellite': 'satellite',
                    'start': 'start',
                    'transmitter': 'transmitter',
                },
                'location_map': {
                    'app_source': 'query',
                    'end': 'query',
                    'format': 'query',
                    'observer': 'query',
                    'page': 'query',
                    'sat_id': 'query',
                    'satellite': 'query',
                    'start': 'query',
                    'transmitter': 'query',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json',
                    'application/ld+json'
                ],
                'content_type': [],
            },
            api_client=api_client
        )
        self.telemetry_retrieve_endpoint = _Endpoint(
            settings={
                'response_type': (Telemetry,),
                'auth': [
                    'cookieAuth',
                    'tokenAuth'
                ],
                'endpoint_path': '/api/telemetry/{id}/',
                'operation_id': 'telemetry_retrieve',
                'http_method': 'GET',
                'servers': None,
            },
            params_map={
                'all': [
                    'id',
                    'format',
                ],
                'required': [
                    'id',
                ],
                'nullable': [
                ],
                'enum': [
                    'format',
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                    ('format',): {

                        "JSON": "json",
                        "JSON-LD": "json-ld"
                    },
                },
                'openapi_types': {
                    'id':
                        (int,),
                    'format':
                        (str,),
                },
                'attribute_map': {
                    'id': 'id',
                    'format': 'format',
                },
                'location_map': {
                    'id': 'path',
                    'format': 'query',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json',
                    'application/ld+json'
                ],
                'content_type': [],
            },
            api_client=api_client
        )

    def telemetry_create(
        self,
        **kwargs
    ):
        """telemetry_create  # noqa: E501

        Creates a frame of telemetry data from a satellite observation.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.telemetry_create(async_req=True)
        >>> result = thread.get()


        Keyword Args:
            format (str): [optional]
            version (str): [optional]
            observation_id (int, none_type): [optional]
            station_id (int, none_type): [optional]
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            async_req (bool): execute request asynchronously

        Returns:
            None
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_content_type'] = kwargs.get(
            '_content_type')
        kwargs['_host_index'] = kwargs.get('_host_index')
        return self.telemetry_create_endpoint.call_with_http_info(**kwargs)

    def telemetry_list(
        self,
        **kwargs
    ):
        """telemetry_list  # noqa: E501

        View into the Telemetry objects in the SatNOGS DB database. Currently, this table is inclusive of all data collected from satellite downlink observations  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.telemetry_list(async_req=True)
        >>> result = thread.get()


        Keyword Args:
            app_source (str): The submission source for the telemetry frames: manual (a manual                              upload/entry), network (SatNOGS Network observations), or sids                              (legacy API submission). [optional]
            end (datetime): [optional]
            format (str): [optional]
            observer (str): (string) name of the observer (submitter) to retrieve telemetry data                             from. [optional]
            page (int): A page number within the paginated result set.. [optional]
            sat_id (str): Satellite ID. [optional]
            satellite (str): NORAD ID of a satellite to filter telemetry data for. [optional]
            start (datetime): [optional]
            transmitter (str): Not currently in use. [optional]
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            async_req (bool): execute request asynchronously

        Returns:
            PaginatedTelemetryList
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_content_type'] = kwargs.get(
            '_content_type')
        kwargs['_host_index'] = kwargs.get('_host_index')
        return self.telemetry_list_endpoint.call_with_http_info(**kwargs)

    def telemetry_retrieve(
        self,
        id,
        **kwargs
    ):
        """telemetry_retrieve  # noqa: E501

        View into the Telemetry objects in the SatNOGS DB database. Currently, this table is inclusive of all data collected from satellite downlink observations  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.telemetry_retrieve(id, async_req=True)
        >>> result = thread.get()

        Args:
            id (int): A unique integer value identifying this demod data.

        Keyword Args:
            format (str): [optional]
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            async_req (bool): execute request asynchronously

        Returns:
            Telemetry
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_content_type'] = kwargs.get(
            '_content_type')
        kwargs['_host_index'] = kwargs.get('_host_index')
        kwargs['id'] = \
            id
        return self.telemetry_retrieve_endpoint.call_with_http_info(**kwargs)

