"""
    SatNOGS DB

    SatNOGS DB is a crowdsourced database of details about orbital                     satellites and data collected from them.  # noqa: E501

    The version of the OpenAPI document: 1.1
    Contact: dev@satnogs.org
    Generated by: https://openapi-generator.tech
"""


import re  # noqa: F401
import sys  # noqa: F401

from satnogsdbapiclient.api_client import ApiClient, Endpoint as _Endpoint
from satnogsdbapiclient.model_utils import (  # noqa: F401
    check_allowed_values,
    check_validations,
    date,
    datetime,
    file_type,
    none_type,
    validate_and_convert_types
)
from satnogsdbapiclient.model.transmitter import Transmitter
from satnogsdbapiclient.model.transmitter_request import TransmitterRequest


class TransmittersApi(object):
    """NOTE: This class is auto generated by OpenAPI Generator
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """

    def __init__(self, api_client=None):
        if api_client is None:
            api_client = ApiClient()
        self.api_client = api_client
        self.transmitters_create_endpoint = _Endpoint(
            settings={
                'response_type': (Transmitter,),
                'auth': [
                    'cookieAuth',
                    'tokenAuth'
                ],
                'endpoint_path': '/api/transmitters/',
                'operation_id': 'transmitters_create',
                'http_method': 'POST',
                'servers': None,
            },
            params_map={
                'all': [
                    'transmitter_request',
                    'format',
                ],
                'required': [
                    'transmitter_request',
                ],
                'nullable': [
                ],
                'enum': [
                    'format',
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                    ('format',): {

                        "JSON": "json",
                        "JSON-LD": "json-ld"
                    },
                },
                'openapi_types': {
                    'transmitter_request':
                        (TransmitterRequest,),
                    'format':
                        (str,),
                },
                'attribute_map': {
                    'format': 'format',
                },
                'location_map': {
                    'transmitter_request': 'body',
                    'format': 'query',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json',
                    'application/ld+json'
                ],
                'content_type': [
                    'application/ld+json'
                ]
            },
            api_client=api_client
        )
        self.transmitters_list_endpoint = _Endpoint(
            settings={
                'response_type': ([Transmitter],),
                'auth': [
                    'cookieAuth',
                    'tokenAuth'
                ],
                'endpoint_path': '/api/transmitters/',
                'operation_id': 'transmitters_list',
                'http_method': 'GET',
                'servers': None,
            },
            params_map={
                'all': [
                    'alive',
                    'format',
                    'mode',
                    'sat_id',
                    'satellite__norad_cat_id',
                    'service',
                    'status',
                    'type',
                    'uplink_mode',
                    'uuid',
                ],
                'required': [],
                'nullable': [
                ],
                'enum': [
                    'format',
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                    ('format',): {

                        "JSON": "json",
                        "JSON-LD": "json-ld"
                    },
                },
                'openapi_types': {
                    'alive':
                        (bool,),
                    'format':
                        (str,),
                    'mode':
                        (int,),
                    'sat_id':
                        (str,),
                    'satellite__norad_cat_id':
                        (str,),
                    'service':
                        (str,),
                    'status':
                        (str,),
                    'type':
                        (str,),
                    'uplink_mode':
                        (int,),
                    'uuid':
                        (str,),
                },
                'attribute_map': {
                    'alive': 'alive',
                    'format': 'format',
                    'mode': 'mode',
                    'sat_id': 'sat_id',
                    'satellite__norad_cat_id': 'satellite__norad_cat_id',
                    'service': 'service',
                    'status': 'status',
                    'type': 'type',
                    'uplink_mode': 'uplink_mode',
                    'uuid': 'uuid',
                },
                'location_map': {
                    'alive': 'query',
                    'format': 'query',
                    'mode': 'query',
                    'sat_id': 'query',
                    'satellite__norad_cat_id': 'query',
                    'service': 'query',
                    'status': 'query',
                    'type': 'query',
                    'uplink_mode': 'query',
                    'uuid': 'query',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json',
                    'application/ld+json'
                ],
                'content_type': [],
            },
            api_client=api_client
        )
        self.transmitters_retrieve_endpoint = _Endpoint(
            settings={
                'response_type': (Transmitter,),
                'auth': [
                    'cookieAuth',
                    'tokenAuth'
                ],
                'endpoint_path': '/api/transmitters/{uuid}/',
                'operation_id': 'transmitters_retrieve',
                'http_method': 'GET',
                'servers': None,
            },
            params_map={
                'all': [
                    'uuid',
                    'format',
                ],
                'required': [
                    'uuid',
                ],
                'nullable': [
                ],
                'enum': [
                    'format',
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                    ('format',): {

                        "JSON": "json",
                        "JSON-LD": "json-ld"
                    },
                },
                'openapi_types': {
                    'uuid':
                        (str,),
                    'format':
                        (str,),
                },
                'attribute_map': {
                    'uuid': 'uuid',
                    'format': 'format',
                },
                'location_map': {
                    'uuid': 'path',
                    'format': 'query',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json',
                    'application/ld+json'
                ],
                'content_type': [],
            },
            api_client=api_client
        )

    def transmitters_create(
        self,
        transmitter_request,
        **kwargs
    ):
        """transmitters_create  # noqa: E501

        Creates a transmitter suggestion.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.transmitters_create(transmitter_request, async_req=True)
        >>> result = thread.get()

        Args:
            transmitter_request (TransmitterRequest):

        Keyword Args:
            format (str): [optional]
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            async_req (bool): execute request asynchronously

        Returns:
            Transmitter
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_content_type'] = kwargs.get(
            '_content_type')
        kwargs['_host_index'] = kwargs.get('_host_index')
        kwargs['transmitter_request'] = \
            transmitter_request
        return self.transmitters_create_endpoint.call_with_http_info(**kwargs)

    def transmitters_list(
        self,
        **kwargs
    ):
        """transmitters_list  # noqa: E501

        View into the Transmitter entities in the SatNOGS DB database. Transmitters are inclusive of Transceivers and Transponders  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.transmitters_list(async_req=True)
        >>> result = thread.get()


        Keyword Args:
            alive (bool): Alive. [optional]
            format (str): [optional]
            mode (int): [optional]
            sat_id (str): Satellite ID. [optional]
            satellite__norad_cat_id (str): NORAD ID of a satellite to filter telemetry data for. [optional]
            service (str): Filter by transmitter service: Aeronautical Amateur Broadcasting Earth Exploration Fixed Inter-satellite Maritime Meteorological Mobile Radiolocation Radionavigational Space Operation Space Research Standard Frequency and Time Signal Unknown. [optional]
            status (str): Filter by transmitter status: active inactive invalid. [optional]
            type (str): Filter by transmitter type: Transmitter Transceiver Transponder. [optional]
            uplink_mode (int): [optional]
            uuid (str): [optional]
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            async_req (bool): execute request asynchronously

        Returns:
            [Transmitter]
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_content_type'] = kwargs.get(
            '_content_type')
        kwargs['_host_index'] = kwargs.get('_host_index')
        return self.transmitters_list_endpoint.call_with_http_info(**kwargs)

    def transmitters_retrieve(
        self,
        uuid,
        **kwargs
    ):
        """transmitters_retrieve  # noqa: E501

        View into the Transmitter entities in the SatNOGS DB database. Transmitters are inclusive of Transceivers and Transponders  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.transmitters_retrieve(uuid, async_req=True)
        >>> result = thread.get()

        Args:
            uuid (str):

        Keyword Args:
            format (str): [optional]
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            async_req (bool): execute request asynchronously

        Returns:
            Transmitter
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_content_type'] = kwargs.get(
            '_content_type')
        kwargs['_host_index'] = kwargs.get('_host_index')
        kwargs['uuid'] = \
            uuid
        return self.transmitters_retrieve_endpoint.call_with_http_info(**kwargs)

