"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.handler = void 0;
const aws_embedded_metrics_1 = require("aws-embedded-metrics");
const Environments_1 = require("aws-embedded-metrics/lib/environment/Environments");
const jsii_rosetta_1 = require("jsii-rosetta");
const aws = require("../shared/aws.lambda-shared");
const constants = require("../shared/constants");
const env_lambda_shared_1 = require("../shared/env.lambda-shared");
const constants_1 = require("./constants");
aws_embedded_metrics_1.Configuration.environmentOverride = Environments_1.default.Lambda;
aws_embedded_metrics_1.Configuration.namespace = constants_1.METRICS_NAMESPACE;
async function handler(event, _context) {
    var _a;
    console.log('Event:', JSON.stringify(event, null, 2));
    const indexedPackages = new Map();
    const bucket = env_lambda_shared_1.requireEnv('BUCKET_NAME');
    for await (const key of relevantObjectKeys(bucket)) {
        const [, name, version] = constants.STORAGE_KEY_FORMAT_REGEX.exec(key);
        const fullName = `${name}@${version}`;
        if (!indexedPackages.has(fullName)) {
            indexedPackages.set(fullName, {});
        }
        const status = indexedPackages.get(fullName);
        if (key.endsWith(constants.METADATA_KEY_SUFFIX)) {
            status.metadataPresent = true;
        }
        else if (key.endsWith(constants.PACKAGE_KEY_SUFFIX)) {
            status.tarballPresent = true;
        }
        else if (key.endsWith(constants.ASSEMBLY_KEY_SUFFIX)) {
            status.originalAssemblyPresent = true;
        }
        else if (key.endsWith(constants.assemblyKeySuffix(jsii_rosetta_1.TargetLanguage.PYTHON))) {
            status.pythonAssemblyPresent = true;
        }
        else {
            status.unknownObjects = (_a = status.unknownObjects) !== null && _a !== void 0 ? _a : [];
            status.unknownObjects.push(key);
        }
    }
    await aws_embedded_metrics_1.metricScope((metrics) => () => {
        var _a, _b;
        // Clear out default dimensions as we don't need those. See https://github.com/awslabs/aws-embedded-metrics-node/issues/73.
        metrics.setDimensions();
        const missingMetadata = new Array();
        const missingOriginalAssembly = new Array();
        const missingPythonAssembly = new Array();
        const missingTarball = new Array();
        const unknownObjects = new Array();
        for (const [name, status] of indexedPackages.entries()) {
            if (!status.metadataPresent) {
                missingMetadata.push(name);
            }
            if (!status.originalAssemblyPresent) {
                missingOriginalAssembly.push(name);
            }
            if (!status.pythonAssemblyPresent) {
                missingPythonAssembly.push(name);
            }
            if (!status.tarballPresent) {
                missingTarball.push(name);
            }
            if ((_b = (_a = status.unknownObjects) === null || _a === void 0 ? void 0 : _a.length) !== null && _b !== void 0 ? _b : 0 > 0) {
                unknownObjects.push(...status.unknownObjects);
            }
        }
        metrics.setProperty('detail', { missingMetadata, missingOriginalAssembly, missingPythonAssembly, missingTarball, unknownObjects });
        metrics.putMetric("MissingPackageMetadataCount" /* MISSING_METADATA_COUNT */, missingMetadata.length, aws_embedded_metrics_1.Unit.Count);
        metrics.putMetric("MissingOriginalAssemblyCount" /* MISSING_ORIGINAL_ASSEMBLY_COUNT */, missingOriginalAssembly.length, aws_embedded_metrics_1.Unit.Count);
        metrics.putMetric("MissingPythonAssemblyCount" /* MISSING_PYTHON_ASSEMBLY_COUNT */, missingPythonAssembly.length, aws_embedded_metrics_1.Unit.Count);
        metrics.putMetric("MissingPackageTarballCount" /* MISSING_TARBALL_COUNT */, missingTarball.length, aws_embedded_metrics_1.Unit.Count);
        metrics.putMetric("PackageVersionCount" /* PACKAGE_VERSION_COUNT */, indexedPackages.size, aws_embedded_metrics_1.Unit.Count);
        metrics.putMetric("UnknownObjectCount" /* UNKNOWN_OBJECT_COUNT */, unknownObjects.length, aws_embedded_metrics_1.Unit.Count);
    })();
}
exports.handler = handler;
async function* relevantObjectKeys(bucket) {
    var _a;
    const request = {
        Bucket: bucket,
        Prefix: constants.STORAGE_KEY_PREFIX,
    };
    do {
        const response = await aws.s3().listObjectsV2(request).promise();
        for (const { Key } of (_a = response.Contents) !== null && _a !== void 0 ? _a : []) {
            if (Key == null) {
                continue;
            }
            yield Key;
        }
        request.ContinuationToken = response.NextContinuationToken;
    } while (request.ContinuationToken != null);
}
//# sourceMappingURL=data:application/json;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoiY2FuYXJ5LmxhbWJkYS5qcyIsInNvdXJjZVJvb3QiOiIiLCJzb3VyY2VzIjpbIi4uLy4uLy4uL3NyYy9iYWNrZW5kL2ludmVudG9yeS9jYW5hcnkubGFtYmRhLnRzIl0sIm5hbWVzIjpbXSwibWFwcGluZ3MiOiI7OztBQUFBLCtEQUF3RTtBQUN4RSxvRkFBNkU7QUFFN0UsK0NBQThDO0FBQzlDLG1EQUFtRDtBQUNuRCxpREFBaUQ7QUFDakQsbUVBQXlEO0FBQ3pELDJDQUE0RDtBQUU1RCxvQ0FBYSxDQUFDLG1CQUFtQixHQUFHLHNCQUFZLENBQUMsTUFBTSxDQUFDO0FBQ3hELG9DQUFhLENBQUMsU0FBUyxHQUFHLDZCQUFpQixDQUFDO0FBRXJDLEtBQUssVUFBVSxPQUFPLENBQUMsS0FBcUIsRUFBRSxRQUFpQjs7SUFDcEUsT0FBTyxDQUFDLEdBQUcsQ0FBQyxRQUFRLEVBQUUsSUFBSSxDQUFDLFNBQVMsQ0FBQyxLQUFLLEVBQUUsSUFBSSxFQUFFLENBQUMsQ0FBQyxDQUFDLENBQUM7SUFFdEQsTUFBTSxlQUFlLEdBQUcsSUFBSSxHQUFHLEVBQWdDLENBQUM7SUFFaEUsTUFBTSxNQUFNLEdBQUcsOEJBQVUsQ0FBQyxhQUFhLENBQUMsQ0FBQztJQUN6QyxJQUFJLEtBQUssRUFBRSxNQUFNLEdBQUcsSUFBSSxrQkFBa0IsQ0FBQyxNQUFNLENBQUMsRUFBRTtRQUNsRCxNQUFNLENBQUMsRUFBRSxJQUFJLEVBQUUsT0FBTyxDQUFDLEdBQUcsU0FBUyxDQUFDLHdCQUF3QixDQUFDLElBQUksQ0FBQyxHQUFHLENBQUUsQ0FBQztRQUN4RSxNQUFNLFFBQVEsR0FBRyxHQUFHLElBQUksSUFBSSxPQUFPLEVBQUUsQ0FBQztRQUN0QyxJQUFJLENBQUMsZUFBZSxDQUFDLEdBQUcsQ0FBQyxRQUFRLENBQUMsRUFBRTtZQUNsQyxlQUFlLENBQUMsR0FBRyxDQUFDLFFBQVEsRUFBRSxFQUFFLENBQUMsQ0FBQztTQUNuQztRQUNELE1BQU0sTUFBTSxHQUFHLGVBQWUsQ0FBQyxHQUFHLENBQUMsUUFBUSxDQUFFLENBQUM7UUFFOUMsSUFBSSxHQUFHLENBQUMsUUFBUSxDQUFDLFNBQVMsQ0FBQyxtQkFBbUIsQ0FBQyxFQUFFO1lBQy9DLE1BQU0sQ0FBQyxlQUFlLEdBQUcsSUFBSSxDQUFDO1NBQy9CO2FBQU0sSUFBSSxHQUFHLENBQUMsUUFBUSxDQUFDLFNBQVMsQ0FBQyxrQkFBa0IsQ0FBQyxFQUFFO1lBQ3JELE1BQU0sQ0FBQyxjQUFjLEdBQUcsSUFBSSxDQUFDO1NBQzlCO2FBQU0sSUFBSSxHQUFHLENBQUMsUUFBUSxDQUFDLFNBQVMsQ0FBQyxtQkFBbUIsQ0FBQyxFQUFFO1lBQ3RELE1BQU0sQ0FBQyx1QkFBdUIsR0FBRyxJQUFJLENBQUM7U0FDdkM7YUFBTSxJQUFJLEdBQUcsQ0FBQyxRQUFRLENBQUMsU0FBUyxDQUFDLGlCQUFpQixDQUFDLDZCQUFjLENBQUMsTUFBTSxDQUFDLENBQUMsRUFBRTtZQUMzRSxNQUFNLENBQUMscUJBQXFCLEdBQUcsSUFBSSxDQUFDO1NBQ3JDO2FBQU07WUFDTCxNQUFNLENBQUMsY0FBYyxTQUFHLE1BQU0sQ0FBQyxjQUFjLG1DQUFJLEVBQUUsQ0FBQztZQUNwRCxNQUFNLENBQUMsY0FBYyxDQUFDLElBQUksQ0FBQyxHQUFHLENBQUMsQ0FBQztTQUNqQztLQUNGO0lBRUQsTUFBTSxrQ0FBVyxDQUFDLENBQUMsT0FBTyxFQUFFLEVBQUUsQ0FBQyxHQUFHLEVBQUU7O1FBQ2xDLDJIQUEySDtRQUMzSCxPQUFPLENBQUMsYUFBYSxFQUFFLENBQUM7UUFFeEIsTUFBTSxlQUFlLEdBQUcsSUFBSSxLQUFLLEVBQVUsQ0FBQztRQUM1QyxNQUFNLHVCQUF1QixHQUFHLElBQUksS0FBSyxFQUFVLENBQUM7UUFDcEQsTUFBTSxxQkFBcUIsR0FBRyxJQUFJLEtBQUssRUFBVSxDQUFDO1FBQ2xELE1BQU0sY0FBYyxHQUFHLElBQUksS0FBSyxFQUFVLENBQUM7UUFDM0MsTUFBTSxjQUFjLEdBQUcsSUFBSSxLQUFLLEVBQVUsQ0FBQztRQUMzQyxLQUFLLE1BQU0sQ0FBQyxJQUFJLEVBQUUsTUFBTSxDQUFDLElBQUksZUFBZSxDQUFDLE9BQU8sRUFBRSxFQUFFO1lBQ3RELElBQUksQ0FBQyxNQUFNLENBQUMsZUFBZSxFQUFFO2dCQUMzQixlQUFlLENBQUMsSUFBSSxDQUFDLElBQUksQ0FBQyxDQUFDO2FBQzVCO1lBQ0QsSUFBSSxDQUFDLE1BQU0sQ0FBQyx1QkFBdUIsRUFBRTtnQkFDbkMsdUJBQXVCLENBQUMsSUFBSSxDQUFDLElBQUksQ0FBQyxDQUFDO2FBQ3BDO1lBQ0QsSUFBSSxDQUFDLE1BQU0sQ0FBQyxxQkFBcUIsRUFBRTtnQkFDakMscUJBQXFCLENBQUMsSUFBSSxDQUFDLElBQUksQ0FBQyxDQUFDO2FBQ2xDO1lBQ0QsSUFBSSxDQUFDLE1BQU0sQ0FBQyxjQUFjLEVBQUU7Z0JBQzFCLGNBQWMsQ0FBQyxJQUFJLENBQUMsSUFBSSxDQUFDLENBQUM7YUFDM0I7WUFDRCxnQkFBSSxNQUFNLENBQUMsY0FBYywwQ0FBRSxNQUFNLG1DQUFJLENBQUMsR0FBRyxDQUFDLEVBQUU7Z0JBQzFDLGNBQWMsQ0FBQyxJQUFJLENBQUMsR0FBRyxNQUFNLENBQUMsY0FBZSxDQUFDLENBQUM7YUFDaEQ7U0FDRjtRQUVELE9BQU8sQ0FBQyxXQUFXLENBQUMsUUFBUSxFQUFFLEVBQUUsZUFBZSxFQUFFLHVCQUF1QixFQUFFLHFCQUFxQixFQUFFLGNBQWMsRUFBRSxjQUFjLEVBQUUsQ0FBQyxDQUFDO1FBRW5JLE9BQU8sQ0FBQyxTQUFTLDZEQUFvQyxlQUFlLENBQUMsTUFBTSxFQUFFLDJCQUFJLENBQUMsS0FBSyxDQUFDLENBQUM7UUFDekYsT0FBTyxDQUFDLFNBQVMsdUVBQTZDLHVCQUF1QixDQUFDLE1BQU0sRUFBRSwyQkFBSSxDQUFDLEtBQUssQ0FBQyxDQUFDO1FBQzFHLE9BQU8sQ0FBQyxTQUFTLG1FQUEyQyxxQkFBcUIsQ0FBQyxNQUFNLEVBQUUsMkJBQUksQ0FBQyxLQUFLLENBQUMsQ0FBQztRQUN0RyxPQUFPLENBQUMsU0FBUywyREFBbUMsY0FBYyxDQUFDLE1BQU0sRUFBRSwyQkFBSSxDQUFDLEtBQUssQ0FBQyxDQUFDO1FBQ3ZGLE9BQU8sQ0FBQyxTQUFTLG9EQUFtQyxlQUFlLENBQUMsSUFBSSxFQUFFLDJCQUFJLENBQUMsS0FBSyxDQUFDLENBQUM7UUFDdEYsT0FBTyxDQUFDLFNBQVMsa0RBQWtDLGNBQWMsQ0FBQyxNQUFNLEVBQUUsMkJBQUksQ0FBQyxLQUFLLENBQUMsQ0FBQztJQUN4RixDQUFDLENBQUMsRUFBRSxDQUFDO0FBQ1AsQ0FBQztBQWhFRCwwQkFnRUM7QUFFRCxLQUFLLFNBQVMsQ0FBQyxDQUFDLGtCQUFrQixDQUFDLE1BQWM7O0lBQy9DLE1BQU0sT0FBTyxHQUFnQztRQUMzQyxNQUFNLEVBQUUsTUFBTTtRQUNkLE1BQU0sRUFBRSxTQUFTLENBQUMsa0JBQWtCO0tBQ3JDLENBQUM7SUFDRixHQUFHO1FBQ0QsTUFBTSxRQUFRLEdBQUcsTUFBTSxHQUFHLENBQUMsRUFBRSxFQUFFLENBQUMsYUFBYSxDQUFDLE9BQU8sQ0FBQyxDQUFDLE9BQU8sRUFBRSxDQUFDO1FBQ2pFLEtBQUssTUFBTSxFQUFFLEdBQUcsRUFBRSxVQUFJLFFBQVEsQ0FBQyxRQUFRLG1DQUFJLEVBQUUsRUFBRTtZQUM3QyxJQUFJLEdBQUcsSUFBSSxJQUFJLEVBQUU7Z0JBQUUsU0FBUzthQUFFO1lBQzlCLE1BQU0sR0FBRyxDQUFDO1NBQ1g7UUFDRCxPQUFPLENBQUMsaUJBQWlCLEdBQUcsUUFBUSxDQUFDLHFCQUFxQixDQUFDO0tBQzVELFFBQVEsT0FBTyxDQUFDLGlCQUFpQixJQUFJLElBQUksRUFBRTtBQUM5QyxDQUFDIiwic291cmNlc0NvbnRlbnQiOlsiaW1wb3J0IHsgbWV0cmljU2NvcGUsIENvbmZpZ3VyYXRpb24sIFVuaXQgfSBmcm9tICdhd3MtZW1iZWRkZWQtbWV0cmljcyc7XG5pbXBvcnQgRW52aXJvbm1lbnRzIGZyb20gJ2F3cy1lbWJlZGRlZC1tZXRyaWNzL2xpYi9lbnZpcm9ubWVudC9FbnZpcm9ubWVudHMnO1xuaW1wb3J0IHR5cGUgeyBDb250ZXh0LCBTY2hlZHVsZWRFdmVudCB9IGZyb20gJ2F3cy1sYW1iZGEnO1xuaW1wb3J0IHsgVGFyZ2V0TGFuZ3VhZ2UgfSBmcm9tICdqc2lpLXJvc2V0dGEnO1xuaW1wb3J0ICogYXMgYXdzIGZyb20gJy4uL3NoYXJlZC9hd3MubGFtYmRhLXNoYXJlZCc7XG5pbXBvcnQgKiBhcyBjb25zdGFudHMgZnJvbSAnLi4vc2hhcmVkL2NvbnN0YW50cyc7XG5pbXBvcnQgeyByZXF1aXJlRW52IH0gZnJvbSAnLi4vc2hhcmVkL2Vudi5sYW1iZGEtc2hhcmVkJztcbmltcG9ydCB7IE1FVFJJQ1NfTkFNRVNQQUNFLCBNZXRyaWNOYW1lIH0gZnJvbSAnLi9jb25zdGFudHMnO1xuXG5Db25maWd1cmF0aW9uLmVudmlyb25tZW50T3ZlcnJpZGUgPSBFbnZpcm9ubWVudHMuTGFtYmRhO1xuQ29uZmlndXJhdGlvbi5uYW1lc3BhY2UgPSBNRVRSSUNTX05BTUVTUEFDRTtcblxuZXhwb3J0IGFzeW5jIGZ1bmN0aW9uIGhhbmRsZXIoZXZlbnQ6IFNjaGVkdWxlZEV2ZW50LCBfY29udGV4dDogQ29udGV4dCkge1xuICBjb25zb2xlLmxvZygnRXZlbnQ6JywgSlNPTi5zdHJpbmdpZnkoZXZlbnQsIG51bGwsIDIpKTtcblxuICBjb25zdCBpbmRleGVkUGFja2FnZXMgPSBuZXcgTWFwPHN0cmluZywgSW5kZXhlZFBhY2thZ2VTdGF0dXM+KCk7XG5cbiAgY29uc3QgYnVja2V0ID0gcmVxdWlyZUVudignQlVDS0VUX05BTUUnKTtcbiAgZm9yIGF3YWl0IChjb25zdCBrZXkgb2YgcmVsZXZhbnRPYmplY3RLZXlzKGJ1Y2tldCkpIHtcbiAgICBjb25zdCBbLCBuYW1lLCB2ZXJzaW9uXSA9IGNvbnN0YW50cy5TVE9SQUdFX0tFWV9GT1JNQVRfUkVHRVguZXhlYyhrZXkpITtcbiAgICBjb25zdCBmdWxsTmFtZSA9IGAke25hbWV9QCR7dmVyc2lvbn1gO1xuICAgIGlmICghaW5kZXhlZFBhY2thZ2VzLmhhcyhmdWxsTmFtZSkpIHtcbiAgICAgIGluZGV4ZWRQYWNrYWdlcy5zZXQoZnVsbE5hbWUsIHt9KTtcbiAgICB9XG4gICAgY29uc3Qgc3RhdHVzID0gaW5kZXhlZFBhY2thZ2VzLmdldChmdWxsTmFtZSkhO1xuXG4gICAgaWYgKGtleS5lbmRzV2l0aChjb25zdGFudHMuTUVUQURBVEFfS0VZX1NVRkZJWCkpIHtcbiAgICAgIHN0YXR1cy5tZXRhZGF0YVByZXNlbnQgPSB0cnVlO1xuICAgIH0gZWxzZSBpZiAoa2V5LmVuZHNXaXRoKGNvbnN0YW50cy5QQUNLQUdFX0tFWV9TVUZGSVgpKSB7XG4gICAgICBzdGF0dXMudGFyYmFsbFByZXNlbnQgPSB0cnVlO1xuICAgIH0gZWxzZSBpZiAoa2V5LmVuZHNXaXRoKGNvbnN0YW50cy5BU1NFTUJMWV9LRVlfU1VGRklYKSkge1xuICAgICAgc3RhdHVzLm9yaWdpbmFsQXNzZW1ibHlQcmVzZW50ID0gdHJ1ZTtcbiAgICB9IGVsc2UgaWYgKGtleS5lbmRzV2l0aChjb25zdGFudHMuYXNzZW1ibHlLZXlTdWZmaXgoVGFyZ2V0TGFuZ3VhZ2UuUFlUSE9OKSkpIHtcbiAgICAgIHN0YXR1cy5weXRob25Bc3NlbWJseVByZXNlbnQgPSB0cnVlO1xuICAgIH0gZWxzZSB7XG4gICAgICBzdGF0dXMudW5rbm93bk9iamVjdHMgPSBzdGF0dXMudW5rbm93bk9iamVjdHMgPz8gW107XG4gICAgICBzdGF0dXMudW5rbm93bk9iamVjdHMucHVzaChrZXkpO1xuICAgIH1cbiAgfVxuXG4gIGF3YWl0IG1ldHJpY1Njb3BlKChtZXRyaWNzKSA9PiAoKSA9PiB7XG4gICAgLy8gQ2xlYXIgb3V0IGRlZmF1bHQgZGltZW5zaW9ucyBhcyB3ZSBkb24ndCBuZWVkIHRob3NlLiBTZWUgaHR0cHM6Ly9naXRodWIuY29tL2F3c2xhYnMvYXdzLWVtYmVkZGVkLW1ldHJpY3Mtbm9kZS9pc3N1ZXMvNzMuXG4gICAgbWV0cmljcy5zZXREaW1lbnNpb25zKCk7XG5cbiAgICBjb25zdCBtaXNzaW5nTWV0YWRhdGEgPSBuZXcgQXJyYXk8c3RyaW5nPigpO1xuICAgIGNvbnN0IG1pc3NpbmdPcmlnaW5hbEFzc2VtYmx5ID0gbmV3IEFycmF5PHN0cmluZz4oKTtcbiAgICBjb25zdCBtaXNzaW5nUHl0aG9uQXNzZW1ibHkgPSBuZXcgQXJyYXk8c3RyaW5nPigpO1xuICAgIGNvbnN0IG1pc3NpbmdUYXJiYWxsID0gbmV3IEFycmF5PHN0cmluZz4oKTtcbiAgICBjb25zdCB1bmtub3duT2JqZWN0cyA9IG5ldyBBcnJheTxzdHJpbmc+KCk7XG4gICAgZm9yIChjb25zdCBbbmFtZSwgc3RhdHVzXSBvZiBpbmRleGVkUGFja2FnZXMuZW50cmllcygpKSB7XG4gICAgICBpZiAoIXN0YXR1cy5tZXRhZGF0YVByZXNlbnQpIHtcbiAgICAgICAgbWlzc2luZ01ldGFkYXRhLnB1c2gobmFtZSk7XG4gICAgICB9XG4gICAgICBpZiAoIXN0YXR1cy5vcmlnaW5hbEFzc2VtYmx5UHJlc2VudCkge1xuICAgICAgICBtaXNzaW5nT3JpZ2luYWxBc3NlbWJseS5wdXNoKG5hbWUpO1xuICAgICAgfVxuICAgICAgaWYgKCFzdGF0dXMucHl0aG9uQXNzZW1ibHlQcmVzZW50KSB7XG4gICAgICAgIG1pc3NpbmdQeXRob25Bc3NlbWJseS5wdXNoKG5hbWUpO1xuICAgICAgfVxuICAgICAgaWYgKCFzdGF0dXMudGFyYmFsbFByZXNlbnQpIHtcbiAgICAgICAgbWlzc2luZ1RhcmJhbGwucHVzaChuYW1lKTtcbiAgICAgIH1cbiAgICAgIGlmIChzdGF0dXMudW5rbm93bk9iamVjdHM/Lmxlbmd0aCA/PyAwID4gMCkge1xuICAgICAgICB1bmtub3duT2JqZWN0cy5wdXNoKC4uLnN0YXR1cy51bmtub3duT2JqZWN0cyEpO1xuICAgICAgfVxuICAgIH1cblxuICAgIG1ldHJpY3Muc2V0UHJvcGVydHkoJ2RldGFpbCcsIHsgbWlzc2luZ01ldGFkYXRhLCBtaXNzaW5nT3JpZ2luYWxBc3NlbWJseSwgbWlzc2luZ1B5dGhvbkFzc2VtYmx5LCBtaXNzaW5nVGFyYmFsbCwgdW5rbm93bk9iamVjdHMgfSk7XG5cbiAgICBtZXRyaWNzLnB1dE1ldHJpYyhNZXRyaWNOYW1lLk1JU1NJTkdfTUVUQURBVEFfQ09VTlQsIG1pc3NpbmdNZXRhZGF0YS5sZW5ndGgsIFVuaXQuQ291bnQpO1xuICAgIG1ldHJpY3MucHV0TWV0cmljKE1ldHJpY05hbWUuTUlTU0lOR19PUklHSU5BTF9BU1NFTUJMWV9DT1VOVCwgbWlzc2luZ09yaWdpbmFsQXNzZW1ibHkubGVuZ3RoLCBVbml0LkNvdW50KTtcbiAgICBtZXRyaWNzLnB1dE1ldHJpYyhNZXRyaWNOYW1lLk1JU1NJTkdfUFlUSE9OX0FTU0VNQkxZX0NPVU5ULCBtaXNzaW5nUHl0aG9uQXNzZW1ibHkubGVuZ3RoLCBVbml0LkNvdW50KTtcbiAgICBtZXRyaWNzLnB1dE1ldHJpYyhNZXRyaWNOYW1lLk1JU1NJTkdfVEFSQkFMTF9DT1VOVCwgbWlzc2luZ1RhcmJhbGwubGVuZ3RoLCBVbml0LkNvdW50KTtcbiAgICBtZXRyaWNzLnB1dE1ldHJpYyhNZXRyaWNOYW1lLlBBQ0tBR0VfVkVSU0lPTl9DT1VOVCwgaW5kZXhlZFBhY2thZ2VzLnNpemUsIFVuaXQuQ291bnQpO1xuICAgIG1ldHJpY3MucHV0TWV0cmljKE1ldHJpY05hbWUuVU5LTk9XTl9PQkpFQ1RfQ09VTlQsIHVua25vd25PYmplY3RzLmxlbmd0aCwgVW5pdC5Db3VudCk7XG4gIH0pKCk7XG59XG5cbmFzeW5jIGZ1bmN0aW9uKiByZWxldmFudE9iamVjdEtleXMoYnVja2V0OiBzdHJpbmcpOiBBc3luY0dlbmVyYXRvcjxzdHJpbmcsIHZvaWQsIHZvaWQ+IHtcbiAgY29uc3QgcmVxdWVzdDogQVdTLlMzLkxpc3RPYmplY3RzVjJSZXF1ZXN0ID0ge1xuICAgIEJ1Y2tldDogYnVja2V0LFxuICAgIFByZWZpeDogY29uc3RhbnRzLlNUT1JBR0VfS0VZX1BSRUZJWCxcbiAgfTtcbiAgZG8ge1xuICAgIGNvbnN0IHJlc3BvbnNlID0gYXdhaXQgYXdzLnMzKCkubGlzdE9iamVjdHNWMihyZXF1ZXN0KS5wcm9taXNlKCk7XG4gICAgZm9yIChjb25zdCB7IEtleSB9IG9mIHJlc3BvbnNlLkNvbnRlbnRzID8/IFtdKSB7XG4gICAgICBpZiAoS2V5ID09IG51bGwpIHsgY29udGludWU7IH1cbiAgICAgIHlpZWxkIEtleTtcbiAgICB9XG4gICAgcmVxdWVzdC5Db250aW51YXRpb25Ub2tlbiA9IHJlc3BvbnNlLk5leHRDb250aW51YXRpb25Ub2tlbjtcbiAgfSB3aGlsZSAocmVxdWVzdC5Db250aW51YXRpb25Ub2tlbiAhPSBudWxsKTtcbn1cblxuaW50ZXJmYWNlIEluZGV4ZWRQYWNrYWdlU3RhdHVzIHtcbiAgbWV0YWRhdGFQcmVzZW50PzogYm9vbGVhbjtcbiAgb3JpZ2luYWxBc3NlbWJseVByZXNlbnQ/OiBib29sZWFuO1xuICBweXRob25Bc3NlbWJseVByZXNlbnQ/OiBib29sZWFuO1xuICB0YXJiYWxsUHJlc2VudD86IGJvb2xlYW47XG4gIHVua25vd25PYmplY3RzPzogc3RyaW5nW107XG59XG4iXX0=