import { IMetric, MetricProps } from '@aws-cdk/aws-cloudwatch';
import { RetentionDays } from '@aws-cdk/aws-logs';
import { IBucket } from '@aws-cdk/aws-s3';
import { Construct, Duration } from '@aws-cdk/core';
import { Monitoring } from '../../monitoring';
export interface InventoryProps {
    /**
     * The data storage bucket.
     */
    readonly bucket: IBucket;
    /**
     * The `Monitoring` instance to use for reporting this canary's health.
     */
    readonly monitoring: Monitoring;
    /**
     * How long should canary logs be retained?
     */
    readonly logRetention?: RetentionDays;
    /**
     * The rate at which the canary should run.
     *
     * @default Duration.minutes(5)
     */
    readonly scheduleRate?: Duration;
}
/**
 * Periodically computes an inventory of all indexed packages into the storage
 * bucket, and produces metrics with an overview of the index' state.
 */
export declare class Inventory extends Construct {
    private readonly canary;
    constructor(scope: Construct, id: string, props: InventoryProps);
    metricMissingPackageMetadataCount(opts?: MetricProps): IMetric;
    metricMissingOriginalAssemblyCount(opts?: MetricProps): IMetric;
    metricPackageVersionCount(opts?: MetricProps): IMetric;
    metricMissingPythonAssemblyCount(opts?: MetricProps): IMetric;
    metricMissingPackageTarballCount(opts?: MetricProps): IMetric;
    metricUnknownObjectCount(opts?: MetricProps): IMetric;
}
