"use strict";
/*
 * IMPORTANT: This file is used both by bundled lambda functions and by
 * constructs. This means it should not directly or transitively import anything
 * not part of the package's `dependencies`, such as the `aws-sdk`.
 */
Object.defineProperty(exports, "__esModule", { value: true });
exports.ELIGIBLE_LICENSES = exports.STORAGE_KEY_FORMAT_REGEX = exports.CATALOG_KEY = exports.assemblyKeySuffix = exports.ASSEMBLY_KEY_SUFFIX = exports.METADATA_KEY_SUFFIX = exports.PACKAGE_KEY_SUFFIX = exports.STORAGE_KEY_PREFIX = void 0;
/**
 * Key prefix for the package data storage.
 */
exports.STORAGE_KEY_PREFIX = 'data/';
/**
 * Key suffix for storing npm package bundles.
 */
exports.PACKAGE_KEY_SUFFIX = '/package.tgz';
/**
 * Key suffix for storing npm package metadata.
 */
exports.METADATA_KEY_SUFFIX = '/metadata.json';
/**
 * The key suffix for (TypeScript) assembly files
 */
exports.ASSEMBLY_KEY_SUFFIX = '/assembly.json';
/**
 * The key suffix for assemblies in the provided language. This should NOT be
 * used for the TypeScript/JavaScript assembly however.
 */
function assemblyKeySuffix(lang) {
    return `/assembly-${lang}.json`;
}
exports.assemblyKeySuffix = assemblyKeySuffix;
/**
 * The key for the catalog document.
 */
exports.CATALOG_KEY = 'catalog.json';
/**
 * A regular expression that can be used to parse out a storage key.
 */
exports.STORAGE_KEY_FORMAT_REGEX = new RegExp(`^${exports.STORAGE_KEY_PREFIX}((?:@[^/]+/)?[^/]+)/v([^/]+)/.*$`);
// Capture groups:                                                        ┗━━━━━━━━1━━━━━━━━┛  ┗━━2━━┛
/**
 * A list of case-normalized (upper) SPDX license identifiers that are deemed
 * eligible for listing on the Construct Hub.
 *
 * @see https://github.com/cdklabs/construct-hub/issues/145
 */
exports.ELIGIBLE_LICENSES = new Set([
    // Apache Licenses
    'Apache-1.0',
    'Apache-1.1',
    'Apache-2.0',
    // BSD Licenses
    '0BSD',
    'BSD-1-Clause',
    'BSD-2-Clause',
    'BSD-2-Clause-Patent',
    'BSD-2-Clause-Views',
    'BSD-3-Clause',
    'BSD-3-Clause-Attribution',
    'BSD-3-Clause-Clear',
    'BSD-3-Clause-LBNL',
    'BSD-3-Clause-Modification',
    'BSD-3-Clause-No-Military-License',
    'BSD-3-Clause-No-Nuclear-License',
    'BSD-3-Clause-No-Nuclear-License-2014',
    'BSD-3-Clause-No-Nuclear-Warranty',
    'BSD-3-Clause-Open-MPI',
    'BSD-4-Clause',
    'BSD-4-Clause-Shortened',
    'BSD-4-Clause-UC',
    'BSD-Protection',
    'BSD-Source-Code',
    // MIT Licenses
    'MIT',
    'MIT-0',
    'MIT-advertising',
    'MIT-CMU',
    'MIT-enna',
    'MIT-feh',
    'MIT-Modern-Variant',
    'MIT-open-group',
    'MITNFA',
].map((s) => s.toUpperCase()));
//# sourceMappingURL=data:application/json;base64,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