import numpy as np
from pandas._typing import ArrayLike as ArrayLike
from pandas.core import ops as ops
from pandas.core.algorithms import unique as unique

from pandas.core.dtypes.dtypes import ExtensionDtype as ExtensionDtype
from pandas.core.dtypes.generic import ABCExtensionArray as ABCExtensionArray, ABCIndexClass as ABCIndexClass, ABCSeries as ABCSeries
from pandas.core.dtypes.missing import isna as isna
from pandas.core.missing import backfill_1d as backfill_1d, pad_1d as pad_1d
from pandas.core.sorting import nargsort as nargsort
from pandas.errors import AbstractMethodError as AbstractMethodError
from pandas.util._decorators import Appender as Appender, Substitution as Substitution
from pandas.util._validators import validate_fillna_kwargs as validate_fillna_kwargs
from typing import Any, Optional, Sequence, Tuple, Union

def try_cast_to_ea(cls_or_instance: Any, obj: Any, dtype: Optional[Any] = ...) -> Any: ...

class ExtensionArray:
    def __getitem__(self, item: Any) -> None: ...
    def __setitem__(self, key: Union[int, np.ndarray], value: Any) -> None: ...
    def __len__(self) -> int: ...
    def __iter__(self) -> Any: ...
    def to_numpy(self, dtype: Optional[Any] = ..., copy: bool = ..., na_value: Any = ...) -> Any: ...
    @property
    def dtype(self) -> ExtensionDtype: ...
    @property
    def shape(self) -> Tuple[int, ...]: ...
    @property
    def ndim(self) -> int: ...
    @property
    def nbytes(self) -> int: ...
    def astype(self, dtype: Any, copy: bool = ...) -> Any: ...
    def isna(self) -> ArrayLike: ...
    def argsort(self, ascending: bool=..., kind: str=..., *args: Any, **kwargs: Any) -> np.ndarray: ...
    def fillna(self, value: Optional[Any] = ..., method: Optional[Any] = ..., limit: Optional[Any] = ...) -> Any: ...
    def dropna(self) -> Any: ...
    def shift(self, periods: int=..., fill_value: object=...) -> ABCExtensionArray: ...
    def unique(self) -> Any: ...
    def searchsorted(self, value: Any, side: str = ..., sorter: Optional[Any] = ...) -> Any: ...
    def factorize(self, na_sentinel: int=...) -> Tuple[np.ndarray, ABCExtensionArray]: ...
    def repeat(self, repeats: Any, axis: Optional[Any] = ...) -> Any: ...
    def take(self, indices: Sequence[int], allow_fill: bool=..., fill_value: Any = ...) -> ABCExtensionArray: ...
    def copy(self) -> ABCExtensionArray: ...
    def view(self, dtype: Any = ...) -> Union[ABCExtensionArray, np.ndarray]: ...
    def ravel(self, order: Any = ...) -> ABCExtensionArray: ...

class ExtensionOpsMixin: ...
class ExtensionScalarOpsMixin(ExtensionOpsMixin): ...
