from pandas.core.accessor import PandasDelegate as PandasDelegate, delegate_names as delegate_names
from pandas.core.arrays.sparse.array import SparseArray as SparseArray
from pandas.core.arrays.sparse.dtype import SparseDtype as SparseDtype
from pandas.core.dtypes.cast import find_common_type as find_common_type
from typing import Any, Optional

class BaseAccessor:
    def __init__(self, data: Optional[Any] = ...) -> None: ...

class SparseAccessor(BaseAccessor, PandasDelegate):
    @classmethod
    def from_coo(cls, A: Any, dense_index: bool = ...) -> Any: ...
    def to_coo(self, row_levels: Any = ..., column_levels: Any = ..., sort_labels: bool = ...) -> Any: ...
    def to_dense(self) -> Any: ...

class SparseFrameAccessor(BaseAccessor, PandasDelegate):
    @classmethod
    def from_spmatrix(cls, data: Any, index: Optional[Any] = ..., columns: Optional[Any] = ...) -> Any: ...
    def to_dense(self) -> Any: ...
    def to_coo(self) -> Any: ...
    @property
    def density(self) -> float: ...
