from pandas._typing import Axis as Axis, FrameOrSeries as FrameOrSeries, Scalar as Scalar
from pandas.core.base import DataError as DataError, PandasObject as PandasObject, SelectionMixin as SelectionMixin, ShallowMixin as ShallowMixin
from pandas.core.dtypes.common import ensure_float64 as ensure_float64, is_bool as is_bool, is_float_dtype as is_float_dtype, is_integer as is_integer, is_integer_dtype as is_integer_dtype, is_list_like as is_list_like, is_scalar as is_scalar, needs_i8_conversion as needs_i8_conversion
from pandas.core.dtypes.generic import ABCDataFrame as ABCDataFrame, ABCDateOffset as ABCDateOffset, ABCDatetimeIndex as ABCDatetimeIndex, ABCPeriodIndex as ABCPeriodIndex, ABCSeries as ABCSeries, ABCTimedeltaIndex as ABCTimedeltaIndex
from pandas.core.indexes.api import Index as Index, ensure_index as ensure_index
from pandas.core.window.common import WindowGroupByMixin as WindowGroupByMixin, calculate_center_offset as calculate_center_offset, calculate_min_periods as calculate_min_periods, get_weighted_roll_func as get_weighted_roll_func, zsqrt as zsqrt
from pandas.core.window.indexers import BaseIndexer as BaseIndexer, FixedWindowIndexer as FixedWindowIndexer, VariableWindowIndexer as VariableWindowIndexer
from pandas.core.window.numba_ import generate_numba_apply_func as generate_numba_apply_func
from pandas.util._decorators import Appender as Appender, Substitution as Substitution, cache_readonly as cache_readonly
from typing import Any, Dict, Optional, Set, Tuple, Union



class _Window(PandasObject, ShallowMixin, SelectionMixin):
    exclusions: Set[str] = ...
    obj: Any = ...
    on: Any = ...
    closed: Any = ...
    window: Any = ...
    min_periods: Any = ...
    center: Any = ...
    win_type: Any = ...
    win_freq: Any = ...
    axis: Any = ...
    def __init__(self, obj: Any, window: Any = ..., min_periods: Optional[int]=..., center: Optional[bool]=..., win_type: Optional[str]=..., axis: Axis=..., on: Optional[Union[str, Index]]=..., closed: Optional[str]=..., **kwargs: Any) -> None: ...
    @property
    def is_datetimelike(self) -> Optional[bool]: ...
    @property
    def is_freq_type(self) -> bool: ...
    def validate(self) -> None: ...
    def __getattr__(self, attr: str) -> Any: ...
    def __iter__(self) -> Any: ...
    def aggregate(self, func: Any, *args: Any, **kwargs: Any) -> Any: ...
    agg: Any = ...

class Window(_Window):
    def validate(self) -> None: ...
    def aggregate(self, func: Any, *args: Any, **kwargs: Any) -> Any: ...
    agg: Any = ...
    def sum(self, *args: Any, **kwargs: Any) -> Any: ...
    def mean(self, *args: Any, **kwargs: Any) -> Any: ...
    def var(self, ddof: int = ..., *args: Any, **kwargs: Any) -> Any: ...
    def std(self, ddof: int = ..., *args: Any, **kwargs: Any) -> Any: ...

class _Rolling(_Window): ...

class _Rolling_and_Expanding(_Rolling):
    def count(self) -> Any: ...
    def apply(self, func: Any, raw: bool=..., engine: str=..., engine_kwargs: Optional[Dict[str, Any]]=..., args: Optional[Tuple[Any, ...]]=..., kwargs: Optional[Dict[str, Any]]=...) -> Any: ...
    def sum(self, *args: Any, **kwargs: Any) -> Any: ...
    def max(self, *args: Any, **kwargs: Any) -> Any: ...
    def min(self, *args: Any, **kwargs: Any) -> Any: ...
    def mean(self, *args: Any, **kwargs: Any) -> Any: ...
    def median(self, **kwargs: Any) -> Any: ...
    def std(self, ddof: int = ..., *args: Any, **kwargs: Any) -> Any: ...
    def var(self, ddof: int = ..., *args: Any, **kwargs: Any) -> Any: ...
    def skew(self, **kwargs: Any) -> Any: ...
    def kurt(self, **kwargs: Any) -> Any: ...
    def quantile(self, quantile: Any, interpolation: str = ..., **kwargs: Any) -> Any: ...
    def cov(self, other: Optional[Any] = ..., pairwise: Optional[Any] = ..., ddof: int = ..., **kwargs: Any) -> Any: ...
    def corr(self, other: Optional[Any] = ..., pairwise: Optional[Any] = ..., **kwargs: Any) -> Any: ...

class Rolling(_Rolling_and_Expanding):
    def is_datetimelike(self) -> bool: ...
    win_freq: Any = ...
    window: Any = ...
    win_type: str = ...
    min_periods: int = ...
    def validate(self) -> None: ...
    def aggregate(self, func: Any, *args: Any, **kwargs: Any) -> Any: ...
    agg: Any = ...
    def count(self) -> Any: ...
    def apply(self, func: Any, raw: bool = ..., engine: str = ..., engine_kwargs: Optional[Any] = ..., args: Optional[Any] = ..., kwargs: Optional[Any] = ...) -> Any: ...
    def sum(self, *args: Any, **kwargs: Any) -> Any: ...
    def max(self, *args: Any, **kwargs: Any) -> Any: ...
    def min(self, *args: Any, **kwargs: Any) -> Any: ...
    def mean(self, *args: Any, **kwargs: Any) -> Any: ...
    def median(self, **kwargs: Any) -> Any: ...
    def std(self, ddof: int = ..., *args: Any, **kwargs: Any) -> Any: ...
    def var(self, ddof: int = ..., *args: Any, **kwargs: Any) -> Any: ...
    def skew(self, **kwargs: Any) -> Any: ...
    def kurt(self, **kwargs: Any) -> Any: ...
    def quantile(self, quantile: Any, interpolation: str = ..., **kwargs: Any) -> Any: ...
    def cov(self, other: Optional[Any] = ..., pairwise: Optional[Any] = ..., ddof: int = ..., **kwargs: Any) -> Any: ...
    def corr(self, other: Optional[Any] = ..., pairwise: Optional[Any] = ..., **kwargs: Any) -> Any: ...

class RollingGroupby(WindowGroupByMixin, Rolling): ...
