"use strict";
var __classPrivateFieldGet = (this && this.__classPrivateFieldGet) || function (receiver, privateMap) {
    if (!privateMap.has(receiver)) {
        throw new TypeError("attempted to get private field on non-instance");
    }
    return privateMap.get(receiver);
};
var __classPrivateFieldSet = (this && this.__classPrivateFieldSet) || function (receiver, privateMap, value) {
    if (!privateMap.has(receiver)) {
        throw new TypeError("attempted to set private field on non-instance");
    }
    privateMap.set(receiver, value);
    return value;
};
var _externalConnections, _repositoryNpmEndpoint, _s3BucketArn;
Object.defineProperty(exports, "__esModule", { value: true });
exports.Repository = void 0;
const aws_codeartifact_1 = require("@aws-cdk/aws-codeartifact");
const aws_iam_1 = require("@aws-cdk/aws-iam");
const core_1 = require("@aws-cdk/core");
const custom_resources_1 = require("@aws-cdk/custom-resources");
/**
 * A CodeArtifact repository.
 */
class Repository extends core_1.Construct {
    constructor(scope, id, props) {
        var _a, _b, _c, _d;
        super(scope, id);
        _externalConnections.set(this, new Array());
        _repositoryNpmEndpoint.set(this, void 0);
        _s3BucketArn.set(this, void 0);
        if ((props === null || props === void 0 ? void 0 : props.domainExists) && !props.domainName) {
            throw new Error('domainExists cannot be specified if no domainName is provided');
        }
        if ((props === null || props === void 0 ? void 0 : props.upstreams) && !props.domainExists) {
            throw new Error('upstreams can only be specified if domainExists and domainName are provided');
        }
        const domainName = (_a = props === null || props === void 0 ? void 0 : props.domainName) !== null && _a !== void 0 ? _a : this.node.addr;
        const domain = (props === null || props === void 0 ? void 0 : props.domainExists) ? undefined : new aws_codeartifact_1.CfnDomain(this, 'Domain', { domainName });
        const repository = new aws_codeartifact_1.CfnRepository(this, 'Default', {
            description: props === null || props === void 0 ? void 0 : props.description,
            domainName: (_b = domain === null || domain === void 0 ? void 0 : domain.attrName) !== null && _b !== void 0 ? _b : domainName,
            externalConnections: core_1.Lazy.list({ produce: () => __classPrivateFieldGet(this, _externalConnections).length > 0 ? __classPrivateFieldGet(this, _externalConnections) : undefined }),
            repositoryName: (_c = props === null || props === void 0 ? void 0 : props.repositoryName) !== null && _c !== void 0 ? _c : this.node.addr,
            upstreams: props === null || props === void 0 ? void 0 : props.upstreams,
        });
        this.repositoryDomainArn = (_d = domain === null || domain === void 0 ? void 0 : domain.attrArn) !== null && _d !== void 0 ? _d : core_1.Stack.of(this).formatArn({
            service: 'codeartifact',
            resource: 'domain',
            arnFormat: core_1.ArnFormat.SLASH_RESOURCE_NAME,
            resourceName: domainName,
        });
        this.repositoryDomainName = repository.attrDomainName;
        this.repositoryDomainOwner = repository.attrDomainOwner;
        this.repositoryArn = repository.attrArn;
        this.repositoryName = repository.attrName;
    }
    /**
     * Adds an external connection to this repository.
     *
     * @param id the id of the external connection (i.e: `public:npmjs`).
     */
    addExternalConnection(id) {
        if (!__classPrivateFieldGet(this, _externalConnections).includes(id)) {
            __classPrivateFieldGet(this, _externalConnections).push(id);
        }
    }
    /**
     * The npm repository endpoint to use for interacting with this repository.
     */
    get repositoryNpmEndpoint() {
        if (__classPrivateFieldGet(this, _repositoryNpmEndpoint) == null) {
            const serviceCall = {
                service: 'CodeArtifact',
                action: 'getRepositoryEndpoint',
                parameters: {
                    domain: this.repositoryDomainName,
                    domainOwner: this.repositoryDomainOwner,
                    format: 'npm',
                    repository: this.repositoryName,
                },
                physicalResourceId: custom_resources_1.PhysicalResourceId.fromResponse('repositoryEndpoint'),
            };
            const endpoint = new custom_resources_1.AwsCustomResource(this, 'GetEndpoint', {
                onCreate: serviceCall,
                onUpdate: serviceCall,
                policy: custom_resources_1.AwsCustomResourcePolicy.fromSdkCalls({ resources: [this.repositoryArn] }),
                resourceType: 'Custom::CodeArtifactNpmRepositoryEndpoint',
            });
            __classPrivateFieldSet(this, _repositoryNpmEndpoint, endpoint.getResponseField('repositoryEndpoint'));
        }
        return __classPrivateFieldGet(this, _repositoryNpmEndpoint);
    }
    /**
     * The S3 bucket in which CodeArtifact stores the package data. When using
     * VPC Endpoints for CodeArtifact, an S3 Gateway Endpoint must also be
     * available, which allows reading from this bucket.
     */
    get s3BucketArn() {
        if (__classPrivateFieldGet(this, _s3BucketArn) == null) {
            const domainDescription = new custom_resources_1.AwsCustomResource(this, 'DescribeDomain', {
                onCreate: {
                    service: 'CodeArtifact',
                    action: 'describeDomain',
                    parameters: {
                        domain: this.repositoryDomainName,
                        domainOwner: this.repositoryDomainOwner,
                    },
                    physicalResourceId: custom_resources_1.PhysicalResourceId.fromResponse('domain.s3BucketArn'),
                },
                policy: custom_resources_1.AwsCustomResourcePolicy.fromSdkCalls({ resources: [this.repositoryDomainArn] }),
                resourceType: 'Custom::CoreArtifactDomainDescription',
            });
            __classPrivateFieldSet(this, _s3BucketArn, domainDescription.getResponseField('domain.s3BucketArn'));
        }
        return __classPrivateFieldGet(this, _s3BucketArn);
    }
    grantReadFromRepository(grantee) {
        // The Grant API does not allow conditions
        const stsGrantResult = grantee.grantPrincipal.addToPrincipalPolicy(new aws_iam_1.PolicyStatement({
            effect: aws_iam_1.Effect.ALLOW,
            actions: ['sts:GetServiceBearerToken'],
            conditions: { StringEquals: { 'sts:AWSServiceName': 'codeartifact.amazonaws.com' } },
            resources: ['*'],
        }));
        if (!stsGrantResult.statementAdded) {
            return aws_iam_1.Grant.drop(grantee, 'CodeArtifact:ReadFromRepository');
        }
        return aws_iam_1.Grant.addToPrincipal({
            grantee,
            actions: [
                'codeartifact:GetAuthorizationToken',
                'codeartifact:GetRepositoryEndpoint',
                'codeartifact:ReadFromRepository',
            ],
            resourceArns: [this.repositoryDomainArn, this.repositoryArn],
        });
    }
    /**
     * Obtains a view of this repository that is intended to be accessed though
     * VPC endpoints.
     *
     * @param apiEndpoint  an `InterfaceVpcEndpoint` to the `codeartifact.api`
     *                     service.
     * @param repoEndpoint an `InterfaceVpcEndpoint` to the
     *                     `codeartifact.repositories` service.
     *
     * @returns a view of this repository that appropriately grants permissions on
     *          the VPC endpoint policies, too.
     */
    throughVpcEndpoint(apiEndpoint, repoEndpoint) {
        return new Proxy(this, {
            get(target, property, _receiver) {
                if (property === 'grantReadFromRepository') {
                    return decoratedGrantReadFromRepository.bind(target);
                }
                return target[property];
            },
            getOwnPropertyDescriptor(target, property) {
                const realDescriptor = Object.getOwnPropertyDescriptor(target, property);
                if (property === 'grantReadFromRepository') {
                    return {
                        ...realDescriptor,
                        value: decoratedGrantReadFromRepository,
                        get: undefined,
                        set: undefined,
                    };
                }
                return realDescriptor;
            },
        });
        function decoratedGrantReadFromRepository(grantee) {
            const mainGrant = this.grantReadFromRepository(grantee);
            if (mainGrant.success) {
                apiEndpoint.addToPolicy(new aws_iam_1.PolicyStatement({
                    effect: aws_iam_1.Effect.ALLOW,
                    actions: ['sts:GetServiceBearerToken'],
                    conditions: { StringEquals: { 'sts:AWSServiceName': 'codeartifact.amazonaws.com' } },
                    resources: ['*'],
                    principals: [grantee.grantPrincipal],
                }));
                apiEndpoint.addToPolicy(new aws_iam_1.PolicyStatement({
                    effect: aws_iam_1.Effect.ALLOW,
                    actions: ['codeartifact:GetAuthorizationToken', 'codeartifact:GetRepositoryEndpoint'],
                    resources: [this.repositoryDomainArn, this.repositoryArn],
                    principals: [grantee.grantPrincipal],
                }));
                repoEndpoint.addToPolicy(new aws_iam_1.PolicyStatement({
                    effect: aws_iam_1.Effect.ALLOW,
                    actions: ['codeartifact:ReadFromRepository'],
                    resources: [this.repositoryArn],
                    principals: [grantee.grantPrincipal],
                }));
            }
            return mainGrant;
        }
    }
}
exports.Repository = Repository;
_externalConnections = new WeakMap(), _repositoryNpmEndpoint = new WeakMap(), _s3BucketArn = new WeakMap();
//# sourceMappingURL=data:application/json;base64,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