--------------------------------------------------------
--  DDL for Table BIOSAMPLE
--------------------------------------------------------

  CREATE TABLE "BIOSAMPLE" 
   (	"BIOSAMPLE_ID" NUMBER, 
	"BIOSAMPLE_NAME" VARCHAR2(3000), 
	"ADD_DATE" TIMESTAMP (6), 
	"MOD_DATE" TIMESTAMP (6), 
	"MOD_BY" NUMBER(*,0), 
	"DESCRIPTION" VARCHAR2(3000), 
	"ECOSYSTEM" VARCHAR2(1000), 
	"ECOSYSTEM_CATEGORY" VARCHAR2(1000), 
	"ECOSYSTEM_TYPE" VARCHAR2(1000), 
	"ECOSYSTEM_SUBTYPE" VARCHAR2(1000), 
	"SPECIFIC_ECOSYSTEM" VARCHAR2(1000), 
	"SAMPLE_COLLECTION_SITE" VARCHAR2(4000), 
	"ISOLATION_PUBLICATION_ID" NUMBER(*,0), 
	"SAMPLE_ISOLATION_COMMENTS" VARCHAR2(4000), 
	"SAMPLING_STRATEGY" VARCHAR2(1000), 
	"REPLICATE_NUMBER" NUMBER(*,0), 
	"SAMPLE_VOLUME" VARCHAR2(200), 
	"SAMPLE_BIOMASS" VARCHAR2(200), 
	"SAMPLE_CONTACT_NAME" VARCHAR2(255), 
	"SAMPLE_CONTACT_EMAIL" VARCHAR2(128), 
	"GEOGRAPHIC_LOCATION" VARCHAR2(1000), 
	"LAT_LONG_INFERRED" VARCHAR2(64), 
	"SALINITY" VARCHAR2(128), 
	"PRESSURE" VARCHAR2(128), 
	"PH" VARCHAR2(128), 
	"HABITAT" VARCHAR2(1000), 
	"HOST_NAME" VARCHAR2(1000), 
	"HOST_TAXONOMY_ID" NUMBER(*,0), 
	"HOST_GENDER" VARCHAR2(1000), 
	"HOST_RACE" VARCHAR2(1000), 
	"HOST_AGE" VARCHAR2(1000), 
	"HOST_HEALTH_CONDITION" VARCHAR2(1000), 
	"PATIENT_VISIT_NUMBER" NUMBER(*,0), 
	"HOST_MEDICATION" VARCHAR2(1000), 
	"MRN" VARCHAR2(1000), 
	"HOST_BODY_SITE" VARCHAR2(1000), 
	"HOST_BODY_SUBSITE" VARCHAR2(1000), 
	"HOST_BODY_PRODUCT" VARCHAR2(1000), 
	"HOST_SPECIFICITY" VARCHAR2(1000), 
	"HOST_COMMENTS" VARCHAR2(1000), 
	"ACTIVE" VARCHAR2(3) DEFAULT 'Yes', 
	"PROJECT_OID" NUMBER(*,0), 
	"SAMPLE_OID" NUMBER(*,0), 
	"GOLD_ID" VARCHAR2(9), 
	"IS_PUBLIC" VARCHAR2(20) DEFAULT 'No', 
	"SPECIMEN" VARCHAR2(100), 
	"SUBMIT_BIOSAMPLE_NAME" VARCHAR2(2000), 
	"NCBI_TAXONOMY_ID" NUMBER(*,0), 
	"COMMUNITY" VARCHAR2(1000), 
	"LOCATION" VARCHAR2(1000), 
	"IDENTIFIER" VARCHAR2(1000), 
	"ENV_PACKAGE" VARCHAR2(200), 
	"SAMPLE_COLLECTION_DAY" NUMBER(*,0), 
	"SAMPLE_COLLECTION_MONTH" NUMBER(*,0), 
	"SAMPLE_COLLECTION_YEAR" NUMBER(*,0), 
	"SUBMITTER_ID" NUMBER(*,0), 
	"GROWTH_CONDITIONS" VARCHAR2(1000), 
	"JPA_ENTITY" VARCHAR2(100), 
	"OTHER_HOSTS" VARCHAR2(1000), 
	"KNOWN_NON_HOSTS" VARCHAR2(200), 
	"ISOLATION_PUBMED_ID" NUMBER, 
	"HOST_BODY_SITE_ID" NUMBER DEFAULT NULL, 
	"HOST_BODY_SUBSITE_ID" NUMBER DEFAULT NULL, 
	"HOST_BODY_PRODUCT_ID" NUMBER DEFAULT NULL, 
	"IS_DRAFT" VARCHAR2(3) DEFAULT 'No', 
	"SAMPLE_ISOLATION_COUNTRY_ID" NUMBER, 
	"OTHER_ECOSYSTEM" VARCHAR2(250), 
	"LONGHURST_CODE" VARCHAR2(4), 
	"SAMPLE_COLLECTION_HOUR" NUMBER(2,0), 
	"SAMPLE_COLLECTION_MINUTE" NUMBER(2,0), 
	"CHLOROPHYLL_CONCENTRATION" VARCHAR2(50), 
	"NITRATE_CONCENTRATION" VARCHAR2(50), 
	"OXYGEN_CONCENTRATION" VARCHAR2(50), 
	"SALINITY_CONCENTRATION" VARCHAR2(50), 
	"PUBLIC_SP_COUNT" NUMBER DEFAULT 0, 
	"ADMIN_SP_COUNT" NUMBER DEFAULT 0, 
	"PUBLIC_AP_COUNT" NUMBER DEFAULT 0, 
	"ADMIN_AP_COUNT" NUMBER DEFAULT 0, 
	"PUBLIC_DAP_COUNT" NUMBER DEFAULT 0, 
	"ADMIN_DAP_COUNT" NUMBER DEFAULT 0, 
	"CRUISE_LINE_NAME" VARCHAR2(100), 
	"ECOSYSTEM_PATH_ID" NUMBER(38,0), 
	"PROPORT_OCEAN" VARCHAR2(24), 
	"PROPORT_ISOLATION" VARCHAR2(240), 
	"PROPORT_STATION" VARCHAR2(50), 
	"PROPORT_WOA_TEMPERATURE" NUMBER(10,5), 
	"PROPORT_WOA_SALINITY" NUMBER(10,5), 
	"PROPORT_WOA_DISSOLVED_OXYGEN" NUMBER(10,5), 
	"PROPORT_WOA_SILICATE" NUMBER(10,5), 
	"PROPORT_WOA_PHOSPHATE" NUMBER(10,5), 
	"PROPORT_WOA_NITRATE" NUMBER(10,5), 
	"NCBI_TAXONOMY_NAME" VARCHAR2(512), 
	"ITS_GROWTH_CONDITIONS" VARCHAR2(4000), 
	"BIOGAS_FED_SUBSTRATES" VARCHAR2(100), 
	"BIOGAS_RETENTION_TIME" VARCHAR2(40), 
	"BIOGAS_TEMPERATURE" VARCHAR2(40), 
	"BIOGAS_YIELD" VARCHAR2(50), 
	"BIOGAS_VOLATILE_ORGANIC_ACIDS" VARCHAR2(50), 
	"BIOGAS_TOTAL_INORGANIC_CARBON" VARCHAR2(50), 
	"BIOGAS_VOA_TIC" VARCHAR2(50), 
	"BIOGAS_AMMONIUM_NH4" VARCHAR2(50), 
	"BIOGAS_BUTANOL" VARCHAR2(40), 
	"BIOGAS_ETHANOL" VARCHAR2(40), 
	"BIOGAS_PROPANOL" VARCHAR2(40), 
	"BIOGAS_METHANOL" VARCHAR2(40), 
	"BIOGAS_ACETIC_ACID" VARCHAR2(40), 
	"BIOGAS_BUTYL_ACID" VARCHAR2(40), 
	"BIOGAS_ISO_BUTYL_ACID" VARCHAR2(40), 
	"BIOGAS_VALERIC_ACID" VARCHAR2(40), 
	"BIOGAS_ISO_VALERIC_ACID" VARCHAR2(40), 
	"BIOGAS_PROPIONIC_ACID" VARCHAR2(40), 
	"BIOGAS_METHANE_PCT" NUMBER(5,2), 
	"IS_TEST" VARCHAR2(100) DEFAULT 'No', 
	"SAMPLE_CONDUCTIVITY" VARCHAR2(24), 
	"GROWTH_TEMPERATURE" NUMBER, 
	"SUBSURFACE_DEPTH" NUMBER, 
	"LEGACY_DEPTH_DATA" VARCHAR2(256), 
	"LATITUDE_TEST" NUMBER, 
	"LONGITUDE_TEST" NUMBER, 
	"ELEVATION" NUMBER, 
	"ELEVATION2" NUMBER, 
	"TOT_ORG_CARBON" NUMBER, 
	"TOT_NITROGEN" VARCHAR2(250), 
	"LATITUDE" NUMBER, 
	"LONGITUDE" NUMBER, 
	"DEPTH" NUMBER, 
	"DEPTH2" NUMBER, 
	"ALTITUDE" NUMBER, 
	"ALTITUDE2" NUMBER, 
	"SOLUBLE_IRON_MICROMOL" NUMBER, 
	"BICARBONATE_MILLIMOL" NUMBER, 
	"H2S_MILLIMOL" NUMBER, 
	"H2S_PRESENT" VARCHAR2(8), 
	"IRRADIANCE" VARCHAR2(24), 
	"OXYGEN_PRESENCE" VARCHAR2(24), 
	"METHANE_CONC_MILLIMOL" NUMBER, 
	"GROWTH_TEMPERATURE2" NUMBER, 
	"ANNOTATOR_COMMENTS" VARCHAR2(4000), 
	"SUBSURFACE_DEPTH2" NUMBER, 
	"PH1" NUMBER, 
	"PH2" NUMBER, 
	"SOIL_PACKAGE_ID" NUMBER, 
	"WATER_PACKAGE_ID" NUMBER, 
	"GLOBAL_PACKAGE_ID" NUMBER, 
	"ENV_BROAD_SCALE" VARCHAR2(50), 
	"ENV_LOCAL_SCALE" VARCHAR2(50), 
	"ENV_MEDIUM" VARCHAR2(50), 
	"PLANT_PACKAGE_ID" NUMBER, 
	"HYDROCARBON_FS_PACKAGE_ID" NUMBER, 
	"HYDROCARBON_CORE_PACKAGE_ID" NUMBER, 
	"MICROBIAL_MAT_PACKAGE_ID" NUMBER, 
	"SEDIMENT_PACKAGE_ID" NUMBER, 
	"SIZE_FRACTION" VARCHAR2(250), 
	"HEALTH_DISEASE_STAT" VARCHAR2(250), 
	"ITS_VOLUME_UL" NUMBER, 
	"ITS_CONCENTRATION_NG_UL" NUMBER, 
	"ITS_DENSITY_G_ML" NUMBER, 
	"ITS_SAMPLE_GROUP_NAME" VARCHAR2(512), 
	"ITS_ISOTOPE_LABEL" VARCHAR2(128)
   )
