--------------------------------------------------------
--  DDL for Table ORGANISM_V2
--------------------------------------------------------

  CREATE TABLE "ORGANISM_V2" 
   (	"ORGANISM_ID" NUMBER(*,0), 
	"EXEMPLAR_DOI" VARCHAR2(30), 
	"EXEMPLAR_NAME" VARCHAR2(300), 
	"TAXON_DOI" VARCHAR2(30), 
	"CULTURE_COLLECTION_ID" VARCHAR2(2000) DEFAULT NULL, 
	"TYPE_STRAIN" VARCHAR2(35) DEFAULT NULL, 
	"BIOSAFETY_LEVEL" VARCHAR2(35) DEFAULT NULL, 
	"NCBI_TAXONOMY_ID" NUMBER(20,0) DEFAULT NULL, 
	"NCBI_KINGDOM" VARCHAR2(300) DEFAULT NULL, 
	"NCBI_PHYLUM" VARCHAR2(300) DEFAULT NULL, 
	"NCBI_CLASS" VARCHAR2(300) DEFAULT NULL, 
	"NCBI_ORDER" VARCHAR2(300) DEFAULT NULL, 
	"NCBI_FAMILY" VARCHAR2(300) DEFAULT NULL, 
	"NCBI_GENUS" VARCHAR2(300) DEFAULT NULL, 
	"DOMAIN" VARCHAR2(35), 
	"STRAIN_INFO_ID" NUMBER(20,0) DEFAULT NULL, 
	"GENBANK_16S_ID" VARCHAR2(200) DEFAULT NULL, 
	"OXYGEN_REQUIREMENT" VARCHAR2(35) DEFAULT NULL, 
	"CELL_SHAPE" VARCHAR2(35) DEFAULT NULL, 
	"MOTILITY" VARCHAR2(35) DEFAULT NULL, 
	"SPORULATION" VARCHAR2(35) DEFAULT NULL, 
	"TEMPERATURE_RANGE" VARCHAR2(35) DEFAULT NULL, 
	"COLOR" VARCHAR2(35) DEFAULT NULL, 
	"GRAM_STAIN" VARCHAR2(35) DEFAULT NULL, 
	"ADD_DATE" TIMESTAMP (6), 
	"MOD_DATE" TIMESTAMP (6), 
	"MOD_BY" NUMBER(*,0), 
	"COMMON_NAME" VARCHAR2(300), 
	"SYMBIOTIC_RELATIONSHIP" VARCHAR2(200), 
	"SYMBIOTIC_PHYSICAL_INTERACTION" VARCHAR2(200), 
	"SYMBIONT_NAME" VARCHAR2(300), 
	"SYMBIONT_TAXON_ID" NUMBER(*,0), 
	"CELL_LENGTH" VARCHAR2(200), 
	"IS_PUBLIC" VARCHAR2(3), 
	"SUBSPECIES" VARCHAR2(200), 
	"COMMERCIAL" VARCHAR2(20), 
	"COMMERCIAL_COMMENTS" VARCHAR2(500), 
	"OTHER_NAMES" VARCHAR2(1000), 
	"SYNONYM_GROUP_ID" NUMBER DEFAULT NULL, 
	"VIRAL_GROUP" VARCHAR2(100) DEFAULT NULL, 
	"VIRAL_SUBGROUP" VARCHAR2(100) DEFAULT NULL, 
	"IS_DRAFT" VARCHAR2(3), 
	"SUBMITTER_ID" NUMBER, 
	"GOLD_PHYLOGENY" VARCHAR2(100), 
	"CULTURE_TYPE" VARCHAR2(100), 
	"UNCULTURED_TYPE" VARCHAR2(100), 
	"ORGANISM_TYPE" VARCHAR2(32), 
	"CULTURED" VARCHAR2(100), 
	"CLADE" VARCHAR2(100), 
	"MASTER_GROUP_ID" NUMBER, 
	"ECOTYPE" VARCHAR2(50), 
	"BIOSAMPLE_ID" NUMBER, 
	"CARBON_SOURCE" VARCHAR2(100), 
	"IMAGE_ID" NUMBER, 
	"NCBI_BIOSAMPLE_ID" VARCHAR2(128), 
	"ECOSYSTEM" VARCHAR2(1000), 
	"ECOSYSTEM_CATEGORY" VARCHAR2(1000), 
	"ECOSYSTEM_TYPE" VARCHAR2(1000), 
	"ECOSYSTEM_SUBTYPE" VARCHAR2(1000), 
	"SPECIFIC_ECOSYSTEM" VARCHAR2(1000), 
	"OTHER_ECOSYSTEM" VARCHAR2(250), 
	"ECOSYSTEM_PATH_ID" NUMBER(38,0), 
	"SAMPLE_COLLECTION_SITE" VARCHAR2(4000), 
	"ISOLATION_PUBLICATION_ID" NUMBER(*,0), 
	"SAMPLE_ISOLATION_COMMENTS" VARCHAR2(4000), 
	"SAMPLING_STRATEGY" VARCHAR2(1000), 
	"REPLICATE_NUMBER" NUMBER(*,0), 
	"SAMPLE_VOLUME" VARCHAR2(200), 
	"SAMPLE_BIOMASS" VARCHAR2(200), 
	"SAMPLE_CONTACT_NAME" VARCHAR2(1024), 
	"SAMPLE_CONTACT_EMAIL" VARCHAR2(128), 
	"GEOGRAPHIC_LOCATION" VARCHAR2(1000), 
	"LAT_LONG_INFERRED" VARCHAR2(64), 
	"HOST_NAME" VARCHAR2(1000), 
	"HOST_TAXONOMY_ID" NUMBER(*,0), 
	"HOST_GENDER" VARCHAR2(1000), 
	"HOST_RACE" VARCHAR2(1000), 
	"HOST_AGE" VARCHAR2(1000), 
	"HOST_HEALTH_CONDITION" VARCHAR2(1000), 
	"PATIENT_VISIT_NUMBER" NUMBER(*,0), 
	"HOST_MEDICATION" VARCHAR2(1000), 
	"MRN" VARCHAR2(1000), 
	"HOST_BODY_SITE" VARCHAR2(1000), 
	"HOST_BODY_SUBSITE" VARCHAR2(1000), 
	"HOST_BODY_PRODUCT" VARCHAR2(1000), 
	"HOST_SPECIFICITY" VARCHAR2(1000), 
	"HOST_COMMENTS" VARCHAR2(1000), 
	"PROJECT_OID" NUMBER(*,0), 
	"SAMPLE_OID" NUMBER(*,0), 
	"SPECIMEN" VARCHAR2(100), 
	"SUBMIT_BIOSAMPLE_NAME" VARCHAR2(2000), 
	"ENV_PACKAGE" VARCHAR2(200), 
	"SAMPLE_COLLECTION_DAY" NUMBER(*,0), 
	"SAMPLE_COLLECTION_MONTH" NUMBER(*,0), 
	"SAMPLE_COLLECTION_YEAR" NUMBER(*,0), 
	"SAMPLE_COLLECTION_HOUR" NUMBER(2,0), 
	"SAMPLE_COLLECTION_MINUTE" NUMBER(2,0), 
	"GROWTH_CONDITIONS" VARCHAR2(1000), 
	"OTHER_HOSTS" VARCHAR2(1000), 
	"KNOWN_NON_HOSTS" VARCHAR2(200), 
	"ISOLATION_PUBMED_ID" NUMBER, 
	"HOST_BODY_SITE_ID" NUMBER DEFAULT NULL, 
	"HOST_BODY_SUBSITE_ID" NUMBER DEFAULT NULL, 
	"HOST_BODY_PRODUCT_ID" NUMBER DEFAULT NULL, 
	"SAMPLE_ISOLATION_COUNTRY_ID" NUMBER, 
	"LONGHURST_CODE" VARCHAR2(4), 
	"CHLOROPHYLL_CONCENTRATION" VARCHAR2(50), 
	"NITRATE_CONCENTRATION" VARCHAR2(50), 
	"OXYGEN_CONCENTRATION" VARCHAR2(50), 
	"SALINITY_CONCENTRATION" VARCHAR2(50), 
	"CRUISE_LINE_NAME" VARCHAR2(100), 
	"PROPORT_OCEAN" VARCHAR2(24), 
	"PROPORT_ISOLATION" VARCHAR2(240), 
	"PROPORT_STATION" VARCHAR2(50), 
	"PROPORT_WOA_TEMPERATURE" NUMBER(10,5), 
	"PROPORT_WOA_SALINITY" NUMBER(10,5), 
	"PROPORT_WOA_DISSOLVED_OXYGEN" NUMBER(10,5), 
	"PROPORT_WOA_SILICATE" NUMBER(10,5), 
	"PROPORT_WOA_PHOSPHATE" NUMBER(10,5), 
	"PROPORT_WOA_NITRATE" NUMBER(10,5), 
	"ACTIVE" VARCHAR2(3) DEFAULT 'Yes', 
	"ITS_GROWTH_CONDITIONS" VARCHAR2(4000), 
	"GOLD_ID" VARCHAR2(20), 
	"ORGANISM_NAME" VARCHAR2(300 CHAR), 
	"SUBMIT_ORGANISM_NAME" VARCHAR2(300 CHAR), 
	"NCBI_TAXONOMY_NAME" VARCHAR2(1000 CHAR), 
	"GENUS" VARCHAR2(300 CHAR), 
	"GENUS_SYNONYMS" VARCHAR2(2000 CHAR), 
	"SPECIES" VARCHAR2(300 CHAR), 
	"SPECIES_SYNONYMS" VARCHAR2(2000 CHAR), 
	"STRAIN" VARCHAR2(300 CHAR), 
	"SEROVAR" VARCHAR2(512), 
	"COMMENTS" VARCHAR2(2000 CHAR), 
	"NCBI_SPECIES" VARCHAR2(300 CHAR), 
	"SALINITY" VARCHAR2(80 CHAR), 
	"PRESSURE" VARCHAR2(80 CHAR), 
	"PH" VARCHAR2(80 CHAR), 
	"CELL_DIAMETER" VARCHAR2(80 CHAR), 
	"ANNOTATOR_COMMENTS" VARCHAR2(4000), 
	"IS_VIROCELL" VARCHAR2(20) DEFAULT 'Unknown', 
	"STRAININFO_GROUP_ID" NUMBER, 
	"SOURCE" VARCHAR2(20), 
	"GOLD_CLASS" VARCHAR2(150), 
	"GOLD_ORDER" VARCHAR2(150), 
	"GOLD_FAMILY" VARCHAR2(150), 
	"NCBI_SUPERKINGDOM" VARCHAR2(256), 
	"TAXONOMY_STATUS" VARCHAR2(32), 
	"IS_TEST" VARCHAR2(100) DEFAULT 'No', 
	"GROWTH_TEMPERATURE" NUMBER, 
	"SUBSURFACE_DEPTH" VARCHAR2(256), 
	"LEGACY_DEPTH_DATA" VARCHAR2(256), 
	"LATITUDE_TEST" NUMBER, 
	"LONGITUDE_TEST" NUMBER, 
	"ELEVATION" NUMBER, 
	"ELEVATION2" NUMBER, 
	"SOIL_CURR_LAND_USE" VARCHAR2(100), 
	"SOIL_CURR_VEGETATION" VARCHAR2(250), 
	"SOIL_CURR_VEGETATION_METHOD" VARCHAR2(250), 
	"SOIL_PREV_LAND_USE" VARCHAR2(250), 
	"TOT_ORG_CARBON" NUMBER, 
	"TOT_NITROGEN" VARCHAR2(250), 
	"ALTITUDE" NUMBER, 
	"ALTITUDE2" NUMBER, 
	"DEPTH" NUMBER, 
	"DEPTH2" NUMBER, 
	"LONGITUDE" NUMBER, 
	"LATITUDE" NUMBER, 
	"BICARBONATE_MILLIMOL" NUMBER, 
	"SOLUBLE_IRON_MICROMOL" NUMBER, 
	"H2S_MILLIMOL" NUMBER, 
	"H2S_PRESENT" VARCHAR2(8), 
	"IRRADIANCE" VARCHAR2(24), 
	"METHANE_CONC_MILLIMOL" NUMBER, 
	"SAMPLE_CONDUCTIVITY" VARCHAR2(24), 
	"SOIL_SAMPLE_BIOMASS" NUMBER, 
	"SOIL_SAMPLE_VOLUME" NUMBER, 
	"IMG_BREADTH_CALC" NUMBER(7,4), 
	"GROWTH_TEMPERATURE2" NUMBER, 
	"SAMPLE_COLLECTION_TEMPERATURE" NUMBER, 
	"SAMPLE_COLLECTION_TEMPERATURE2" NUMBER, 
	"PUBLIC_SP_COUNT" NUMBER, 
	"ADMIN_SP_COUNT" NUMBER, 
	"PUBLIC_AP_COUNT" NUMBER, 
	"ADMIN_AP_COUNT" NUMBER, 
	"SUBSURFACE_DEPTH1" NUMBER, 
	"SUBSURFACE_DEPTH2" NUMBER, 
	"PH1" NUMBER, 
	"PH2" NUMBER, 
	"SOIL_PACKAGE_ID" NUMBER, 
	"WATER_PACKAGE_ID" NUMBER, 
	"ENV_BROAD_SCALE" VARCHAR2(50), 
	"ENV_LOCAL_SCALE" VARCHAR2(50), 
	"ENV_MEDIUM" VARCHAR2(50), 
	"PLANT_PACKAGE_ID" NUMBER, 
	"HYDROCARBON_FS_PACKAGE_ID" NUMBER, 
	"HYDROCARBON_CORE_PACKAGE_ID" NUMBER, 
	"MICROBIAL_MAT_PACKAGE_ID" NUMBER, 
	"SEDIMENT_PACKAGE_ID" NUMBER, 
	"HEALTH_DISEASE_STAT" VARCHAR2(250), 
	"PATHOGENICITY" VARCHAR2(250), 
	"PLOIDY" VARCHAR2(250), 
	"TAX_CLASS_METHOD" VARCHAR2(250), 
	"PROPAGATION" VARCHAR2(250), 
	"ENCODED_TRAITS" VARCHAR2(250), 
	"VIRUS_ENRICH_APPR" VARCHAR2(250), 
	"TAX_IDENT" VARCHAR2(250)
   )
