###### scratches-algorithms

[![PyPI Version](https://img.shields.io/pypi/v/scratches-algorithms?color=success)](https://pypi.org/project/scratches-algorithms/)
[![Python Version](https://img.shields.io/pypi/pyversions/scratches-algorithms?color=informational)](https://www.python.org/)
[![License](https://img.shields.io/pypi/l/scratches-algorithms?color=red)](https://github.com/notjik/scratches-algorithms/blob/master/LICENSE.md)

[![GitHub Stars](https://img.shields.io/github/stars/notjik/scratches-algorithms?style=social)](https://github.com/notjik/scratches-algorithms/stargazers) \
[![GitHub Forks](https://img.shields.io/github/forks/notjik/scratches-algorithms?style=social)](https://github.com/notjik/scratches-algorithms/network/members) \
[![GitHub Issues](https://img.shields.io/github/issues/notjik/scratches-algorithms?style=social)](https://github.com/notjik/scratches-algorithms/issues) \
[![GitHub Pull Requests](https://img.shields.io/github/issues-pr/notjik/scratches-algorithms?style=social)](https://github.com/notjik/scratches-algorithms/pulls)
<br>
<details style="margin-top: 20px;"><summary> 
<strong>English</strong>
</summary>

<div style="margin-top: 20px; margin-bottom: 30px;">

**Scratches Algorithms** – this package is a Python client library with classic sorting and search algorithms and simple
utilities for working with numbers, number systems and code performance control.

You can find the source code on **[GitHub](https://github.com/notjik/scratches-algorithms)**.

## Installation

Install the current version from **[PyPI](https://pypi.org/project/scratches-algorithms/)**:

```shell
pip install scratches-algorithms
```

## Structure
> + [algorithms](https://github.com/notjik/scratches-algorithms/blob/master/src/scratches_algorithms/algorithms.py)
>   + Sort
>     + bubble
>     + shaker
>     + insertion
>     + selection
>     + counting
>     + merge
>     + quick
>   + Find
>     + linear
>     + binary
> + [utils](https://github.com/notjik/scratches-algorithms/blob/master/src/scratches_algorithms/utils.py)
>   + NumbersProperties
>     + divisors
>     + count_divisors
>     + fibonacci
>     + is_prime
>     + is_square
>   + NumeralSystem
>     + to_base
>   + PerformanceTracking
>     + \_\_init__
>     + \_\_del__
>     + func_timer
>     + get_size

</div>

</details>

<details style="margin-top: 20px;"><summary> 
<strong>Русский</strong>
</summary>

<div style="margin-top: 20px; margin-bottom: 30px;">

**Scratch Algorithms** – это пакет, который представляет собой клиентскую библиотеку Python с классическими алгоритмами
сортировки и поиска и простыми утилитами для работы с числами, системами счисления и контроля производительности кода.

Вы можете найти исходный код на **[Github](https://github.com/notjik/scratches-algorithms)**.

## Установка

Установить текущую версию с **[PyPI](https://pypi.org/project/scratches-algorithms/)**:

```shell
pip install scratch-algorithms
```

## Структура
> + [algorithms](https://github.com/notjik/scratches-algorithms/blob/master/src/scratches_algorithms/algorithms.py)
>   + Sort
>     + bubble
>     + shaker
>     + insertion
>     + selection
>     + counting
>     + merge
>     + quick
>   + Find
>     + linear
>     + binary
> + [utils](https://github.com/notjik/scratches-algorithms/blob/master/src/scratches_algorithms/utils.py)
>   + NumbersProperties
>     + divisors
>     + fibonacci
>     + is_prime
>     + is_square
>   + NumeralSystem
>     + to_base
>   + PerformanceTracking
>     + \_\_init__
>     + \_\_del__
>     + func_timer

</div>

</details>