# Generated by Django 3.0.4 on 2020-03-18 23:15
import datetime

from django.db import migrations, models
from django.utils import timezone


MIN_DATETIME = timezone.make_aware(datetime.datetime.min, timezone.utc)


def create_default_terms(apps, schema_editor):
    PlatformAgreement = apps.get_model('iam.PlatformAgreement')
    PlatformAgreement.objects.create(slug='terms',
        title="Terms of Service", effective=MIN_DATETIME)


def create_default_privacy_policy(apps, schema_editor):
    PlatformAgreement = apps.get_model('iam.PlatformAgreement')
    PlatformAgreement.objects.create(slug='privacy',
        title="Privacy Policy", effective=MIN_DATETIME)


class Migration(migrations.Migration):

    dependencies = [
        ('iam', '0016_auto_20200318_2146'),
    ]

    operations = [
        migrations.CreateModel(
            name='PlatformAgreement',
            fields=[
                ('slug', models.SlugField(db_column='slug', primary_key=True, serialize=False)),
                ('title', models.CharField(db_column='title', max_length=127)),
                ('effective', models.DateTimeField(db_column='effective')),
            ],
            options={
                'verbose_name': 'Platform Agreement',
                'verbose_name_plural': 'Platform Agreements',
                'db_table': 'platformagreements',
                'default_permissions': [],
            },
        ),
        migrations.RunPython(create_default_terms),
        migrations.RunPython(create_default_privacy_policy),
    ]
