"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.GeneratedJavaClientProject = void 0;
/*********************************************************************************************************************
 Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.

 Licensed under the Apache License, Version 2.0 (the "License").
 You may not use this file except in compliance with the License.
 You may obtain a copy of the License at

 http://www.apache.org/licenses/LICENSE-2.0

 Unless required by applicable law or agreed to in writing, software
 distributed under the License is distributed on an "AS IS" BASIS,
 WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 See the License for the specific language governing permissions and
 limitations under the License.
 ******************************************************************************************************************** */
const projen_1 = require("projen");
const java_1 = require("projen/lib/java");
const generated_java_client_source_code_1 = require("./components/generated-java-client-source-code");
const open_api_generator_ignore_file_1 = require("./components/open-api-generator-ignore-file");
const DEPENDENCIES = [
    // Required for open api generated client
    "io.swagger/swagger-annotations@1.6.5",
    "com.google.code.findbugs/jsr305@3.0.2",
    "com.squareup.okhttp3/okhttp@4.9.3",
    "com.squareup.okhttp3/logging-interceptor@4.9.3",
    "com.google.code.gson/gson@2.9.0",
    "io.gsonfire/gson-fire@1.8.5",
    "org.apache.commons/commons-lang3@3.12.0",
    "jakarta.annotation/jakarta.annotation-api@1.3.5",
    "org.openapitools/jackson-databind-nullable@0.2.2",
    "javax.ws.rs/jsr311-api@1.1.1",
    "javax.ws.rs/javax.ws.rs-api@2.1.1",
    // For handler wrappers
    "com.amazonaws/aws-lambda-java-core@1.2.1",
    "com.amazonaws/aws-lambda-java-events@3.11.0",
    // Lombok is used to add the builder pattern to models for neater construction
    "org.projectlombok/lombok@1.18.24",
];
const TEST_DEPENDENCIES = [
    "org.junit.jupiter/junit-jupiter-api@5.8.2",
    "org.mockito/mockito-core@3.12.4",
];
/**
 * Java project containing a java client (and lambda handler wrappers) generated using OpenAPI Generator CLI
 */
class GeneratedJavaClientProject extends java_1.JavaProject {
    constructor(options) {
        super({
            sample: false,
            junit: false,
            ...options,
        });
        // Store whether we've synthesized the project
        this.synthed = false;
        // Ignore files that we will control via projen
        const ignoreFile = new open_api_generator_ignore_file_1.OpenApiGeneratorIgnoreFile(this);
        ignoreFile.addPatterns("pom.xml");
        // Add dependencies
        DEPENDENCIES.forEach((dep) => this.addDependency(dep));
        TEST_DEPENDENCIES.forEach((dep) => this.addTestDependency(dep));
        new generated_java_client_source_code_1.GeneratedJavaClientSourceCode(this, {
            specPath: options.specPath,
            invokeGenerator: options.generateClient,
        });
        // Use a package.json to ensure the client is discoverable by nx
        new projen_1.JsonFile(this, "package.json", {
            obj: {
                name: this.name,
                __pdk__: true,
                version: options.version,
                scripts: Object.fromEntries(this.tasks.all.map((task) => [task.name, `npx projen ${task.name}`])),
            },
            readonly: true,
        });
    }
    /**
     * @inheritDoc
     */
    synth() {
        // Save some time by only synthesizing once. We synthesize this project early so that it's available for the parent
        // project's install phase (pre-synth). Projen will call this method again at the usual time to synthesize this,
        // project, at which point we're already done so can skip.
        if (this.synthed) {
            return;
        }
        super.synth();
        this.synthed = true;
    }
}
exports.GeneratedJavaClientProject = GeneratedJavaClientProject;
//# sourceMappingURL=data:application/json;base64,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