# Digital Logic Functions

**Project implements basic to advance logic functions like gates , flip flops and many more circuits...**

## Contributors:
> [Sunil Lad](https://github.com/Sunillad08)

> [Parth Khanolkar](https://github.com/ParthKhanolkar)


# Circuits and logics to be implemented

### First release : 

- [Bases Conversion](conversion.py) 
    - Binary to Decimal
    - Binary to Hexadecimal
    - Binary to Octal
    - Decimal to Hexadecimal
    - Decimal to Octal
    - Decimal to Binary
    - Octal to Hexadecimal
    - Octal to Decimal
    - Octal to Binary
    - Hexadecimal to Octal
    - Hexadecimal to Decimal
    - Hexadecimal to Binary
    - Binary to BCD 
    - Binary to gray
    - BCD to Binary
    - BCD to gray
    - Gray to Binary
    - Gray to BCD

- [Logic Gates](gates.py)
    - AND gate
    - OR gate
    - NOT gate
    - NAND gate
    - NOR gate
    - XOR gate
    - XNOR gate

- [Flip flops](flipflops.py) 
    - Nand Latch
    - Nor Latch
    - SR flip flop
    - D flip flop
    - JK flip flop
    - JK master slave flip flop
    - T flip flop

- [Combinational Logic Circuits](combination_logic.py)
    - Multiplexer
    - Demultiplexer
    - Encoder
    - Decoder

- [Display terminals](display_terminals.py)
    - Seven segment display

- [Arithmetic Circuits](arithematic_circuit.py)
    - Half adder
    - Full adder
    - Half subtractor
    - Full subtractor
    - Comparator

- [Counter](counters.py)
  - Ring counter
  - Jonhson counter
  - Ripple counter 

- [Shift Registers](shift_registers.py)
  - SISO
  - SIPO
  - PIPO
  - PISO