# -*- coding: utf-8 -*-
from setuptools import setup

packages = \
['user_secrets',
 'user_secrets_tests',
 'user_secrets_tests.management',
 'user_secrets_tests.management.commands',
 'user_secrets_tests.tests',
 'user_secrets_tests.views']

package_data = \
{'': ['*'],
 'user_secrets_tests': ['media/*',
                        'static/*',
                        'templates/admin/*',
                        'templates/demo/*']}

install_requires = \
['cryptography', 'django']

entry_points = \
{'console_scripts': ['dev_server = manage:start_test_server',
                     'publish = user_secrets.publish:publish',
                     'update_rst_readme = user_secrets.publish:update_readme']}

setup_kwargs = {
    'name': 'django-user-secrets',
    'version': '0.2.0',
    'description': 'Store user secrets encrypted into database.',
    'long_description': '===================\ndjango-user-secrets\n===================\n\nStore user secrets encrypted into database.\n\n+--------------------------+-------------------------------------------------+\n| |Build Status on github| | `github.com/jedie/django-user-secrets/actions`_ |\n+--------------------------+-------------------------------------------------+\n\n.. |Build Status on github| image:: https://github.com/jedie/django-user-secrets/workflows/test/badge.svg?branch=master\n.. _github.com/jedie/django-user-secrets/actions: https://github.com/jedie/django-user-secrets/actions\n\nCurrent project state: "Beta"\n\nLicence: GPL v3 or above\n\n--------\nthe idea\n--------\n\nStore a user\'s secrets in the database encrypted with his password.\n\nOnly the user can decrypt the stored data. His password is used for encryption and decryption. This password is only transmitted in plain text when logging in (Django itself only saves a salted hash of the password).\n\nThe intermediate-user-secret is decrypted and stored with the clear text password in RAM after successful login. All user secrets will be encrypted and decrypted with his intermediate-user-secret.\n\nLimitations and/or facts:\n\n* Only the same user can decrypt his own data.\n\n* The decrypted data can only be used during an active session.\n\n* A intermediate-user-secret is used, so that a password can be changed without losing the encrypted data.\n\n-----\nusage\n-----\n\nThe encrypted user secrets are stored via ``EncryptedField`` in the user model. Your project must implement a own ``settings.AUTH_USER_MODEL`` inherith from ``AbstractUserSecretsModel`` e.g.:\n\n`/your_project/your_app/models.py <https://github.com/jedie/django-user-secrets/edit/master/user_secrets_tests/models.py>`_\n\n::\n\n    from user_secrets.model_fields import EncryptedField\n    from user_secrets.models import AbstractUserSecretsModel\n    \n    class UserSecretsModel(AbstractUserSecretsModel):\n        example_secret = EncryptedField(max_length=256, blank=True, null=True)  # can have one or more EncryptedField\'s!\n\nAdd this own user model to the Django Admin and add the own ``EncryptedField``, so the user can fill it in the admin, e.g.:\n\n`/your_project/your_app/admin.py <https://github.com/jedie/django-user-secrets/edit/master/user_secrets_tests/admin.py>`_\n\n::\n\n    from django.contrib import admin\n    from django.utils.translation import gettext_lazy as _\n    \n    from user_secrets.admin import UserSecretsAdmin\n    from user_secrets_tests.models import UserSecretsModel\n    \n    \n    @admin.register(UserSecretsModel)\n    class ExampleModelAdmin(UserSecretsAdmin):\n        fieldsets = (\n            (None, {\'fields\': (\'username\', \'password\')}),\n            (_(\'User Secrets\'), {\'fields\': (\'encrypted_secret\', \'example_secret\')}),  # <<< own fields\n            (_(\'Personal info\'), {\'fields\': (\'first_name\', \'last_name\', \'email\')}),\n            (_(\'Permissions\'), {\n                \'fields\': (\'is_active\', \'is_staff\', \'is_superuser\', \'groups\', \'user_permissions\'),\n            }),\n            (_(\'Important dates\'), {\'fields\': (\'last_login\', \'date_joined\')}),\n        )\n\nIt\'s also possible to implement a own "edit" view just for the ``EncryptedField`` values. Have a look at the demo app view: `/user_secrets_tests/views/edit.py <https://github.com/jedie/django-user-secrets/blob/master/user_secrets_tests/views/edit.py>`_\nFor this you can easy get `a model form <https://github.com/jedie/django-user-secrets/blob/master/user_secrets_tests/forms.py>`_, e.g.:\n\n::\n\n    from user_secrets.forms import UserSecretsBaseModelModelForm\n    from user_secrets_tests.models import UserSecretsModel\n    \n    \n    class ExampleModelForm(UserSecretsBaseModelModelForm):\n        class Meta:\n            model = UserSecretsModel\n            fields = [\'example_secret\']\n\nTo use the stored secret in a view, e.g.:\n\n::\n\n    user = request.user  # get current user\n    example_secret = user.example_secret  # the the example field value (encrypted)\n    # decrypt the example\n    decrypted_value = user_decrypt(user=user, encrypted_data=example_secret)\n    # ...do something with the value...\n\nComplete example is: `/user_secrets_tests/views/display.py <https://github.com/jedie/django-user-secrets/blob/master/user_secrets_tests/views/display.py>`_\n\nNeeded settings:\n\n::\n\n    # The SECRET_KEY should never changed after django-user-secrets are created!\n    SECRET_KEY = \'Use a long random string and keep this value secret!\'\n    \n    INSTALLED_APPS = (\n        #...\n        \'user_secrets.apps.UserSecretsConfig\',\n        #...\n    )\n    \n    # Must point to a own UserModel class\n    # This class must inherit from user_secrets.models.AbstractUserSecretsModel\n    AUTH_USER_MODEL = \'your_app.YourUserModel\'\n    \n    \n    AUTHENTICATION_BACKENDS = [\n        \'user_secrets.auth_backend.UserSecretsAuthBackend\',  # Must be at first\n        \'django.contrib.auth.backends.ModelBackend\'\n    ]\n    \n    \n    CACHES = {\n        \'default\': {  # Can use any backend.\n            \'BACKEND\': \'django.core.cache.backends.locmem.LocMemCache\',\n            \'LOCATION\': \'default\',\n        },\n        \'user_secrets\': {  # Should be use the LocMemCache!\n            \'BACKEND\': \'django.core.cache.backends.locmem.LocMemCache\',\n            \'LOCATION\': \'user_secrets\',\n        }\n    }\n    \n    \n    MIDDLEWARE = (\n        #...\n        \'user_secrets.middleware.UserSecretsMiddleware\',  # inserted after AuthenticationMiddleware\n    )\n\nComplete example is: `/user_secrets_tests/settings.py <https://github.com/jedie/django-user-secrets/blob/master/user_secrets_tests/settings.py>`_\n\n----\nDEMO\n----\n\nPrepare: `install poetry <https://python-poetry.org/docs/#installation>`_ e.g.:\n\n::\n\n    ~$ sudo apt install python3-pip\n    ~$ pip3 install -U pip --user\n    ~$ pip3 install -U poerty --user\n\nClone the sources, e.g.:\n\n::\n\n    ~$ git clone https://github.com/jedie/django-user-secrets.git\n    ~$ cd django-user-secrets\n    \n    # install via poetry:\n    ~/django-user-secrets$ poetry install\n    \n    # Start Django dev. server:\n    ~/django-user-secrets$ poetry run dev_server\n\nYou can also use our Makefile, e.g.:\n\n::\n\n    ~/django-user-secrets$ make help\n    help                 List all commands\n    install-poetry       install or update poetry\n    install              install django-user-secrets via poetry\n    update               update the sources and installation\n    lint                 Run code formatters and linter\n    fix-code-style       Fix code formatting\n    tox-listenvs         List all tox test environments\n    tox                  Run pytest via tox with all environments\n    tox-py36             Run pytest via tox with *python v3.6*\n    tox-py37             Run pytest via tox with *python v3.7*\n    tox-py38             Run pytest via tox with *python v3.8*\n    pytest               Run pytest\n    update-rst-readme    update README.rst from README.creole\n    publish              Release new version to PyPi\n    start-dev-server     Start Django dev. server with the test project\n\nAlternative/Related projects:\n=============================\n\n* `https://github.com/erikvw/django-crypto-fields <https://github.com/erikvw/django-crypto-fields>`_\n\n* `https://github.com/incuna/django-pgcrypto-fields <https://github.com/incuna/django-pgcrypto-fields>`_\n\n* `https://github.com/georgemarshall/django-cryptography <https://github.com/georgemarshall/django-cryptography>`_\n\n(Random order: No prioritization)\n\n-------\nhistory\n-------\n\n* `*dev* <https://github.com/jedie/django-user-secrets/compare/v0.2.0...master>`_ \n\n    * TBC\n\n* `v0.2.0 - 06.07.2020 <https://github.com/jedie/django-user-secrets/compare/v0.1.0...v0.2.0>`_ \n\n    * refactor:\n\n        * Move EncryptedFields into user model and don\'t use a extra model for them\n\n        * Move code parts from demo app into main package\n\n    * Update demo app\n\n    * update README\n\n    * Bugfix Makefile\n\n* `v0.1.0 - 04.07.2020 <https://github.com/jedie/django-user-secrets/compare/d5700b952...v0.1.0>`_ \n\n    * first release on PyPi\n\n------------\n\n``Note: this file is generated from README.creole 2020-07-06 11:30:39 with "python-creole"``',
    'author': 'Jens Diemer',
    'author_email': 'django-user-secrets@jensdiemer.de',
    'maintainer': None,
    'maintainer_email': None,
    'url': 'https://github.com/jedie/django-user-secrets/',
    'packages': packages,
    'package_data': package_data,
    'install_requires': install_requires,
    'entry_points': entry_points,
    'python_requires': '>=3.6,<4.0',
}


setup(**setup_kwargs)
