"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.CodePipelineCheckParameterAction = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const aws_cdk_lib_1 = require("aws-cdk-lib");
const aws_codepipeline_1 = require("aws-cdk-lib/aws-codepipeline");
const aws_codepipeline_actions_1 = require("aws-cdk-lib/aws-codepipeline-actions");
const aws_iam_1 = require("aws-cdk-lib/aws-iam");
const check_parameter_function_1 = require("./check-parameter-function");
/**
 * Represents a reference to a CodePipelineCheckParameterAction.
 */
class CodePipelineCheckParameterAction extends aws_codepipeline_actions_1.Action {
    constructor(props) {
        super({
            ...props,
            category: aws_codepipeline_1.ActionCategory.INVOKE,
            provider: 'Lambda',
            artifactBounds: {
                minInputs: 0,
                maxInputs: 0,
                minOutputs: 0,
                maxOutputs: 0,
            },
        });
        this.props = props;
    }
    /**
     * This is a renamed version of the {@link IAction.bind} method.
     */
    bound(scope, _stage, options) {
        const { parameterName, regExp, logParameter = false, crossAccountRole } = this.props;
        const checkParameterFunction = new check_parameter_function_1.CheckParameterFunction(scope, 'CheckParamterFunction', {
            parameterName,
            crossAccountRole,
        });
        // allow pipeline to list functions
        options.role.addToPrincipalPolicy(new aws_iam_1.PolicyStatement({
            actions: ['lambda:ListFunctions'],
            resources: ['*'],
        }));
        // allow pipeline to invoke this lambda functionn
        options.role.addToPrincipalPolicy(new aws_iam_1.PolicyStatement({
            actions: ['lambda:InvokeFunction'],
            resources: [checkParameterFunction.functionArn],
        }));
        // allow lambda to put job results for this pipeline
        // CodePipeline requires this to be granted to '*'
        // (the Pipeline ARN will not be enough)
        checkParameterFunction.addToRolePolicy(new aws_iam_1.PolicyStatement({
            resources: ['*'],
            actions: ['codepipeline:PutJobSuccessResult', 'codepipeline:PutJobFailureResult'],
        }));
        return {
            configuration: {
                FunctionName: checkParameterFunction.functionName,
                UserParameters: aws_cdk_lib_1.Stack.of(scope).toJsonString({
                    parameterName,
                    regExp: regExp ? regExp.source : undefined,
                    logParameter,
                    crossAccountRole,
                }),
            },
        };
    }
}
exports.CodePipelineCheckParameterAction = CodePipelineCheckParameterAction;
_a = JSII_RTTI_SYMBOL_1;
CodePipelineCheckParameterAction[_a] = { fqn: "@cloudcomponents/cdk-codepipeline-check-parameter-action.CodePipelineCheckParameterAction", version: "2.0.0" };
//# sourceMappingURL=data:application/json;base64,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