/*
 * Copyright (c) 1994 Cygnus Support.
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms are permitted
 * provided that the above copyright notice and this paragraph are
 * duplicated in all such forms and that any documentation,
 * and/or other materials related to such
 * distribution and use acknowledge that the software was developed
 * at Cygnus Support, Inc.  Cygnus Support, Inc. may not be used to
 * endorse or promote products derived from this software without
 * specific prior written permission.
 * THIS SOFTWARE IS PROVIDED ``AS IS'' AND WITHOUT ANY EXPRESS OR
 * IMPLIED WARRANTIES, INCLUDING, WITHOUT LIMITATION, THE IMPLIED
 * WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE.
 */
#include "test.h"
 one_line_type cosf_vec[] = {
{43, 0,123,__LINE__, 0x3fd730de, 0x64830d71, 0xbff33333, 0x33333333},	/* 0.362358=f(-1.2)*/
{41, 0,123,__LINE__, 0x3fd7c946, 0x441c1153, 0xbff30a3d, 0x70a3d70a},	/* 0.37166=f(-1.19)*/
{42, 0,123,__LINE__, 0x3fd86112, 0xb7cbdfc1, 0xbff2e147, 0xae147ae1},	/* 0.380925=f(-1.18)*/
{40, 0,123,__LINE__, 0x3fd8f83e, 0xef92f019, 0xbff2b851, 0xeb851eb8},	/* 0.390152=f(-1.17)*/
{40, 0,123,__LINE__, 0x3fd98ec7, 0x838ee721, 0xbff28f5c, 0x28f5c28f},	/* 0.39934=f(-1.16)*/
{45, 0,123,__LINE__, 0x3fda24a8, 0x9939098a, 0xbff26666, 0x66666666},	/* 0.408487=f(-1.15)*/
{40, 0,123,__LINE__, 0x3fdab9de, 0x5a54487e, 0xbff23d70, 0xa3d70a3d},	/* 0.417595=f(-1.14)*/
{39, 0,123,__LINE__, 0x3fdb4e64, 0xf50666c3, 0xbff2147a, 0xe147ae14},	/* 0.42666=f(-1.13)*/
{39, 0,123,__LINE__, 0x3fdbe238, 0x9bf1011f, 0xbff1eb85, 0x1eb851eb},	/* 0.435682=f(-1.12)*/
{39, 0,123,__LINE__, 0x3fdc7555, 0x864a7958, 0xbff1c28f, 0x5c28f5c2},	/* 0.444662=f(-1.11)*/
{40, 0,123,__LINE__, 0x3fdd07b7, 0xeff6c332, 0xbff19999, 0x99999999},	/* 0.453596=f(-1.1)*/
{43, 0,123,__LINE__, 0x3fdd995c, 0x19a012bd, 0xbff170a3, 0xd70a3d70},	/* 0.462485=f(-1.09)*/
{39, 0,123,__LINE__, 0x3fde2a3e, 0x48cf6b62, 0xbff147ae, 0x147ae147},	/* 0.471328=f(-1.08)*/
{41, 0,123,__LINE__, 0x3fdeba5a, 0xc8050efe, 0xbff11eb8, 0x51eb851e},	/* 0.480124=f(-1.07)*/
{40, 0,123,__LINE__, 0x3fdf49ae, 0x567a24a7, 0xbff0f5c2, 0x8f5c28f5},	/* 0.488872=f(-1.06)*/
{40, 0,123,__LINE__, 0x3fdfd834, 0x68f1e69a, 0xbff0cccc, 0xcccccccc},	/* 0.497571=f(-1.05)*/
{41, 0,123,__LINE__, 0x3fe032f4, 0xe4d5e1c1, 0xbff0a3d7, 0x0a3d70a3},	/* 0.50622=f(-1.04)*/
{40, 0,123,__LINE__, 0x3fe07965, 0x6bfb5f21, 0xbff07ae1, 0x47ae147a},	/* 0.514819=f(-1.03)*/
{41, 0,123,__LINE__, 0x3fe0bf69, 0xfc48a7a9, 0xbff051eb, 0x851eb851},	/* 0.523366=f(-1.02)*/
{42, 0,123,__LINE__, 0x3fe10500, 0xcae083a5, 0xbff028f5, 0xc28f5c28},	/* 0.531861=f(-1.01)*/
{40, 0,123,__LINE__, 0x3fe14a28, 0x0fb506a6, 0xbfefffff, 0xfffffffe},	/* 0.540302=f(-1)*/
{40, 0,123,__LINE__, 0x3fe18ede, 0x05933c42, 0xbfefae14, 0x7ae147ac},	/* 0.54869=f(-0.99)*/
{40, 0,123,__LINE__, 0x3fe1d320, 0xea2ec224, 0xbfef5c28, 0xf5c28f5a},	/* 0.557023=f(-0.98)*/
{40, 0,123,__LINE__, 0x3fe216ee, 0xfe2d4f19, 0xbfef0a3d, 0x70a3d708},	/* 0.5653=f(-0.97)*/
{41, 0,123,__LINE__, 0x3fe25a46, 0x9f68f807, 0xbfeeb851, 0xeb851eb6},	/* 0.57352=f(-0.96)*/
{40, 0,123,__LINE__, 0x3fe29d25, 0xdff0f9d6, 0xbfee6666, 0x66666664},	/* 0.581683=f(-0.95)*/
{43, 0,123,__LINE__, 0x3fe2df8b, 0x23eb3665, 0xbfee147a, 0xe147ae12},	/* 0.589788=f(-0.94)*/
{40, 0,123,__LINE__, 0x3fe32174, 0xb8378a33, 0xbfedc28f, 0x5c28f5c0},	/* 0.597834=f(-0.93)*/
{39, 0,123,__LINE__, 0x3fe362e0, 0xece066b5, 0xbfed70a3, 0xd70a3d6e},	/* 0.60582=f(-0.92)*/
{41, 0,123,__LINE__, 0x3fe3a3ce, 0x1525e134, 0xbfed1eb8, 0x51eb851c},	/* 0.613746=f(-0.91)*/
{41, 0,123,__LINE__, 0x3fe3e43a, 0xa099b03b, 0xbfeccccc, 0xccccccca},	/* 0.62161=f(-0.9)*/
{39, 0,123,__LINE__, 0x3fe42424, 0xb6b2c3a8, 0xbfec7ae1, 0x47ae1478},	/* 0.629412=f(-0.89)*/
{39, 0,123,__LINE__, 0x3fe4638a, 0xcdd7404c, 0xbfec28f5, 0xc28f5c26},	/* 0.637151=f(-0.88)*/
{41, 0,123,__LINE__, 0x3fe4a26b, 0x468ab7c6, 0xbfebd70a, 0x3d70a3d4},	/* 0.644827=f(-0.87)*/
{39, 0,123,__LINE__, 0x3fe4e0c4, 0x84bc68bc, 0xbfeb851e, 0xb851eb82},	/* 0.652437=f(-0.86)*/
{39, 0,123,__LINE__, 0x3fe51e94, 0xefd1cb5c, 0xbfeb3333, 0x33333330},	/* 0.659983=f(-0.85)*/
{39, 0,123,__LINE__, 0x3fe55bdb, 0x0a8524f4, 0xbfeae147, 0xae147ade},	/* 0.667463=f(-0.84)*/
{38, 0,123,__LINE__, 0x3fe59895, 0x13687400, 0xbfea8f5c, 0x28f5c28c},	/* 0.674876=f(-0.83)*/
{40, 0,123,__LINE__, 0x3fe5d4c1, 0x948cc28c, 0xbfea3d70, 0xa3d70a3a},	/* 0.682221=f(-0.82)*/
{40, 0,123,__LINE__, 0x3fe6105f, 0x0398235e, 0xbfe9eb85, 0x1eb851e8},	/* 0.689498=f(-0.81)*/
{42, 0,123,__LINE__, 0x3fe64b6b, 0xd9da4793, 0xbfe99999, 0x99999996},	/* 0.696707=f(-0.8)*/
{40, 0,123,__LINE__, 0x3fe685e6, 0x94567efd, 0xbfe947ae, 0x147ae144},	/* 0.703845=f(-0.79)*/
{36, 0,123,__LINE__, 0x3fe6bfcd, 0xc0000000, 0xbfe8f5c2, 0x8f5c28f2},	/* 0.710914=f(-0.78)*/
{36, 0,123,__LINE__, 0x3fe6f91f, 0xe0000000, 0xbfe8a3d7, 0x0a3d70a0},	/* 0.717911=f(-0.77)*/
{36, 0,123,__LINE__, 0x3fe731db, 0x40000000, 0xbfe851eb, 0x851eb84e},	/* 0.724836=f(-0.76)*/
{37, 0,123,__LINE__, 0x3fe769fe, 0xc0000000, 0xbfe7ffff, 0xfffffffc},	/* 0.731689=f(-0.75)*/
{36, 0,123,__LINE__, 0x3fe7a188, 0xc0000000, 0xbfe7ae14, 0x7ae147aa},	/* 0.738469=f(-0.74)*/
{36, 0,123,__LINE__, 0x3fe7d878, 0x00000000, 0xbfe75c28, 0xf5c28f58},	/* 0.745174=f(-0.73)*/
{37, 0,123,__LINE__, 0x3fe80eca, 0xe0000000, 0xbfe70a3d, 0x70a3d706},	/* 0.751806=f(-0.72)*/
{37, 0,123,__LINE__, 0x3fe84480, 0x20000000, 0xbfe6b851, 0xeb851eb4},	/* 0.758362=f(-0.71)*/
{37, 0,123,__LINE__, 0x3fe87996, 0x60000000, 0xbfe66666, 0x66666662},	/* 0.764842=f(-0.7)*/
{38, 0,123,__LINE__, 0x3fe8ae0c, 0x20000000, 0xbfe6147a, 0xe147ae10},	/* 0.771246=f(-0.69)*/
{36, 0,123,__LINE__, 0x3fe8e1e0, 0x20000000, 0xbfe5c28f, 0x5c28f5be},	/* 0.777573=f(-0.68)*/
{37, 0,123,__LINE__, 0x3fe91511, 0x20000000, 0xbfe570a3, 0xd70a3d6c},	/* 0.783822=f(-0.67)*/
{39, 0,123,__LINE__, 0x3fe9479d, 0xc0000000, 0xbfe51eb8, 0x51eb851a},	/* 0.789992=f(-0.66)*/
{39, 0,123,__LINE__, 0x3fe97984, 0xc0000000, 0xbfe4cccc, 0xccccccc8},	/* 0.796084=f(-0.65)*/
{38, 0,123,__LINE__, 0x3fe9aac4, 0xc0000000, 0xbfe47ae1, 0x47ae1476},	/* 0.802096=f(-0.64)*/
{41, 0,123,__LINE__, 0x3fe9db5c, 0x80000000, 0xbfe428f5, 0xc28f5c24},	/* 0.808028=f(-0.63)*/
{36, 0,123,__LINE__, 0x3fea0b4a, 0xe0000000, 0xbfe3d70a, 0x3d70a3d2},	/* 0.813878=f(-0.62)*/
{36, 0,123,__LINE__, 0x3fea3a8e, 0x80000000, 0xbfe3851e, 0xb851eb80},	/* 0.819648=f(-0.61)*/
{36, 0,123,__LINE__, 0x3fea6926, 0x40000000, 0xbfe33333, 0x3333332e},	/* 0.825336=f(-0.6)*/
{35, 0,123,__LINE__, 0x3fea9711, 0x00000000, 0xbfe2e147, 0xae147adc},	/* 0.830941=f(-0.59)*/
{36, 0,123,__LINE__, 0x3feac44d, 0x60000000, 0xbfe28f5c, 0x28f5c28a},	/* 0.836463=f(-0.58)*/
{36, 0,123,__LINE__, 0x3feaf0da, 0x60000000, 0xbfe23d70, 0xa3d70a38},	/* 0.841901=f(-0.57)*/
{38, 0,123,__LINE__, 0x3feb1cb6, 0xc0000000, 0xbfe1eb85, 0x1eb851e6},	/* 0.847255=f(-0.56)*/
{38, 0,123,__LINE__, 0x3feb47e1, 0x80000000, 0xbfe19999, 0x99999994},	/* 0.852525=f(-0.55)*/
{36, 0,123,__LINE__, 0x3feb7259, 0x80000000, 0xbfe147ae, 0x147ae142},	/* 0.857709=f(-0.54)*/
{37, 0,123,__LINE__, 0x3feb9c1d, 0xa0000000, 0xbfe0f5c2, 0x8f5c28f0},	/* 0.862807=f(-0.53)*/
{38, 0,123,__LINE__, 0x3febc52c, 0xc0000000, 0xbfe0a3d7, 0x0a3d709e},	/* 0.867819=f(-0.52)*/
{36, 0,123,__LINE__, 0x3febed85, 0xe0000000, 0xbfe051eb, 0x851eb84c},	/* 0.872745=f(-0.51)*/
{37, 0,123,__LINE__, 0x3fec1528, 0x00000000, 0xbfdfffff, 0xfffffff4},	/* 0.877583=f(-0.5)*/
{38, 0,123,__LINE__, 0x3fec3c12, 0x20000000, 0xbfdf5c28, 0xf5c28f50},	/* 0.882333=f(-0.49)*/
{36, 0,123,__LINE__, 0x3fec6243, 0x20000000, 0xbfdeb851, 0xeb851eac},	/* 0.886995=f(-0.48)*/
{37, 0,123,__LINE__, 0x3fec87ba, 0x40000000, 0xbfde147a, 0xe147ae08},	/* 0.891568=f(-0.47)*/
{39, 0,123,__LINE__, 0x3fecac76, 0x40000000, 0xbfdd70a3, 0xd70a3d64},	/* 0.896052=f(-0.46)*/
{36, 0,123,__LINE__, 0x3fecd076, 0x80000000, 0xbfdccccc, 0xccccccc0},	/* 0.900447=f(-0.45)*/
{42, 0,123,__LINE__, 0x3fecf3b9, 0xc0000000, 0xbfdc28f5, 0xc28f5c1c},	/* 0.904752=f(-0.44)*/
{36, 0,123,__LINE__, 0x3fed163f, 0x60000000, 0xbfdb851e, 0xb851eb78},	/* 0.908966=f(-0.43)*/
{36, 0,123,__LINE__, 0x3fed3806, 0x40000000, 0xbfdae147, 0xae147ad4},	/* 0.913089=f(-0.42)*/
{38, 0,123,__LINE__, 0x3fed590d, 0xc0000000, 0xbfda3d70, 0xa3d70a30},	/* 0.917121=f(-0.41)*/
{37, 0,123,__LINE__, 0x3fed7954, 0xe0000000, 0xbfd99999, 0x9999998c},	/* 0.921061=f(-0.4)*/
{36, 0,123,__LINE__, 0x3fed98da, 0xe0000000, 0xbfd8f5c2, 0x8f5c28e8},	/* 0.924909=f(-0.39)*/
{37, 0,123,__LINE__, 0x3fedb79e, 0xe0000000, 0xbfd851eb, 0x851eb844},	/* 0.928665=f(-0.38)*/
{37, 0,123,__LINE__, 0x3fedd5a0, 0x20000000, 0xbfd7ae14, 0x7ae147a0},	/* 0.932327=f(-0.37)*/
{38, 0,123,__LINE__, 0x3fedf2dd, 0xe0000000, 0xbfd70a3d, 0x70a3d6fc},	/* 0.935897=f(-0.36)*/
{37, 0,123,__LINE__, 0x3fee0f57, 0x60000000, 0xbfd66666, 0x66666658},	/* 0.939373=f(-0.35)*/
{36, 0,123,__LINE__, 0x3fee2b0b, 0xe0000000, 0xbfd5c28f, 0x5c28f5b4},	/* 0.942755=f(-0.34)*/
{37, 0,123,__LINE__, 0x3fee45fa, 0xa0000000, 0xbfd51eb8, 0x51eb8510},	/* 0.946042=f(-0.33)*/
{36, 0,123,__LINE__, 0x3fee6023, 0x00000000, 0xbfd47ae1, 0x47ae146c},	/* 0.949235=f(-0.32)*/
{39, 0,123,__LINE__, 0x3fee7984, 0x40000000, 0xbfd3d70a, 0x3d70a3c8},	/* 0.952334=f(-0.31)*/
{37, 0,123,__LINE__, 0x3fee921d, 0xe0000000, 0xbfd33333, 0x33333324},	/* 0.955337=f(-0.3)*/
{35, 0,123,__LINE__, 0x3feea9ef, 0x20000000, 0xbfd28f5c, 0x28f5c280},	/* 0.958244=f(-0.29)*/
{37, 0,123,__LINE__, 0x3feec0f7, 0x60000000, 0xbfd1eb85, 0x1eb851dc},	/* 0.961055=f(-0.28)*/
{35, 0,123,__LINE__, 0x3feed736, 0x00000000, 0xbfd147ae, 0x147ae138},	/* 0.963771=f(-0.27)*/
{39, 0,123,__LINE__, 0x3feeecaa, 0xa0000000, 0xbfd0a3d7, 0x0a3d7094},	/* 0.96639=f(-0.26)*/
{37, 0,123,__LINE__, 0x3fef0154, 0xa0000000, 0xbfcfffff, 0xffffffe0},	/* 0.968912=f(-0.25)*/
{44, 0,123,__LINE__, 0x3fef1533, 0x60000000, 0xbfceb851, 0xeb851e98},	/* 0.971338=f(-0.24)*/
{35, 0,123,__LINE__, 0x3fef2846, 0x60000000, 0xbfcd70a3, 0xd70a3d50},	/* 0.973666=f(-0.23)*/
{37, 0,123,__LINE__, 0x3fef3a8d, 0x40000000, 0xbfcc28f5, 0xc28f5c08},	/* 0.975897=f(-0.22)*/
{39, 0,123,__LINE__, 0x3fef4c07, 0x80000000, 0xbfcae147, 0xae147ac0},	/* 0.978031=f(-0.21)*/
{39, 0,123,__LINE__, 0x3fef5cb4, 0xa0000000, 0xbfc99999, 0x99999978},	/* 0.980067=f(-0.2)*/
{36, 0,123,__LINE__, 0x3fef6c94, 0x20000000, 0xbfc851eb, 0x851eb830},	/* 0.982004=f(-0.19)*/
{36, 0,123,__LINE__, 0x3fef7ba5, 0xc0000000, 0xbfc70a3d, 0x70a3d6e8},	/* 0.983844=f(-0.18)*/
{35, 0,123,__LINE__, 0x3fef89e9, 0x20000000, 0xbfc5c28f, 0x5c28f5a0},	/* 0.985585=f(-0.17)*/
{36, 0,123,__LINE__, 0x3fef975d, 0xa0000000, 0xbfc47ae1, 0x47ae1458},	/* 0.987227=f(-0.16)*/
{36, 0,123,__LINE__, 0x3fefa403, 0x40000000, 0xbfc33333, 0x33333310},	/* 0.988771=f(-0.15)*/
{36, 0,123,__LINE__, 0x3fefafd9, 0x80000000, 0xbfc1eb85, 0x1eb851c8},	/* 0.990216=f(-0.14)*/
{36, 0,123,__LINE__, 0x3fefbae0, 0x00000000, 0xbfc0a3d7, 0x0a3d7080},	/* 0.991562=f(-0.13)*/
{38, 0,123,__LINE__, 0x3fefc516, 0xa0000000, 0xbfbeb851, 0xeb851e71},	/* 0.992809=f(-0.12)*/
{37, 0,123,__LINE__, 0x3fefce7d, 0x00000000, 0xbfbc28f5, 0xc28f5be2},	/* 0.993956=f(-0.11)*/
{39, 0,123,__LINE__, 0x3fefd713, 0x00000000, 0xbfb99999, 0x99999953},	/* 0.995004=f(-0.1)*/
{37, 0,123,__LINE__, 0x3fefded8, 0x40000000, 0xbfb70a3d, 0x70a3d6c4},	/* 0.995953=f(-0.09)*/
{38, 0,123,__LINE__, 0x3fefe5cc, 0xc0000000, 0xbfb47ae1, 0x47ae1435},	/* 0.996802=f(-0.08)*/
{36, 0,123,__LINE__, 0x3fefebf0, 0x20000000, 0xbfb1eb85, 0x1eb851a6},	/* 0.997551=f(-0.07)*/
{37, 0,123,__LINE__, 0x3feff142, 0x40000000, 0xbfaeb851, 0xeb851e2d},	/* 0.998201=f(-0.06)*/
{36, 0,123,__LINE__, 0x3feff5c3, 0x20000000, 0xbfa99999, 0x9999990e},	/* 0.99875=f(-0.05)*/
{35, 0,123,__LINE__, 0x3feff972, 0x80000000, 0xbfa47ae1, 0x47ae13ef},	/* 0.9992=f(-0.04)*/
{36, 0,123,__LINE__, 0x3feffc50, 0x60000000, 0xbf9eb851, 0xeb851da0},	/* 0.99955=f(-0.03)*/
{35, 0,123,__LINE__, 0x3feffe5c, 0xa0000000, 0xbf947ae1, 0x47ae1362},	/* 0.9998=f(-0.02)*/
{39, 0,123,__LINE__, 0x3fefff97, 0x20000000, 0xbf847ae1, 0x47ae1249},	/* 0.99995=f(-0.01)*/
{39, 0,123,__LINE__, 0x3ff00000, 0x00000000, 0x3cd19000, 0x00000000},	/* 1=f(9.74915e-16)*/
{39, 0,123,__LINE__, 0x3fefff97, 0x20000000, 0x3f847ae1, 0x47ae16ad},	/* 0.99995=f(0.01)*/
{35, 0,123,__LINE__, 0x3feffe5c, 0xa0000000, 0x3f947ae1, 0x47ae1594},	/* 0.9998=f(0.02)*/
{36, 0,123,__LINE__, 0x3feffc50, 0x60000000, 0x3f9eb851, 0xeb851fd2},	/* 0.99955=f(0.03)*/
{35, 0,123,__LINE__, 0x3feff972, 0x80000000, 0x3fa47ae1, 0x47ae1508},	/* 0.9992=f(0.04)*/
{36, 0,123,__LINE__, 0x3feff5c3, 0x20000000, 0x3fa99999, 0x99999a27},	/* 0.99875=f(0.05)*/
{37, 0,123,__LINE__, 0x3feff142, 0x40000000, 0x3faeb851, 0xeb851f46},	/* 0.998201=f(0.06)*/
{36, 0,123,__LINE__, 0x3fefebf0, 0x20000000, 0x3fb1eb85, 0x1eb85232},	/* 0.997551=f(0.07)*/
{38, 0,123,__LINE__, 0x3fefe5cc, 0xc0000000, 0x3fb47ae1, 0x47ae14c1},	/* 0.996802=f(0.08)*/
{37, 0,123,__LINE__, 0x3fefded8, 0x40000000, 0x3fb70a3d, 0x70a3d750},	/* 0.995953=f(0.09)*/
{39, 0,123,__LINE__, 0x3fefd713, 0x00000000, 0x3fb99999, 0x999999df},	/* 0.995004=f(0.1)*/
{37, 0,123,__LINE__, 0x3fefce7d, 0x00000000, 0x3fbc28f5, 0xc28f5c6e},	/* 0.993956=f(0.11)*/
{38, 0,123,__LINE__, 0x3fefc516, 0xa0000000, 0x3fbeb851, 0xeb851efd},	/* 0.992809=f(0.12)*/
{36, 0,123,__LINE__, 0x3fefbae0, 0x00000000, 0x3fc0a3d7, 0x0a3d70c6},	/* 0.991562=f(0.13)*/
{36, 0,123,__LINE__, 0x3fefafd9, 0x80000000, 0x3fc1eb85, 0x1eb8520e},	/* 0.990216=f(0.14)*/
{36, 0,123,__LINE__, 0x3fefa403, 0x40000000, 0x3fc33333, 0x33333356},	/* 0.988771=f(0.15)*/
{36, 0,123,__LINE__, 0x3fef975d, 0xa0000000, 0x3fc47ae1, 0x47ae149e},	/* 0.987227=f(0.16)*/
{35, 0,123,__LINE__, 0x3fef89e9, 0x20000000, 0x3fc5c28f, 0x5c28f5e6},	/* 0.985585=f(0.17)*/
{36, 0,123,__LINE__, 0x3fef7ba5, 0xc0000000, 0x3fc70a3d, 0x70a3d72e},	/* 0.983844=f(0.18)*/
{36, 0,123,__LINE__, 0x3fef6c94, 0x20000000, 0x3fc851eb, 0x851eb876},	/* 0.982004=f(0.19)*/
{39, 0,123,__LINE__, 0x3fef5cb4, 0xa0000000, 0x3fc99999, 0x999999be},	/* 0.980067=f(0.2)*/
{39, 0,123,__LINE__, 0x3fef4c07, 0x80000000, 0x3fcae147, 0xae147b06},	/* 0.978031=f(0.21)*/
{37, 0,123,__LINE__, 0x3fef3a8d, 0x40000000, 0x3fcc28f5, 0xc28f5c4e},	/* 0.975897=f(0.22)*/
{35, 0,123,__LINE__, 0x3fef2846, 0x60000000, 0x3fcd70a3, 0xd70a3d96},	/* 0.973666=f(0.23)*/
{44, 0,123,__LINE__, 0x3fef1533, 0x60000000, 0x3fceb851, 0xeb851ede},	/* 0.971338=f(0.24)*/
{37, 0,123,__LINE__, 0x3fef0154, 0xa0000000, 0x3fd00000, 0x00000013},	/* 0.968912=f(0.25)*/
{39, 0,123,__LINE__, 0x3feeecaa, 0xa0000000, 0x3fd0a3d7, 0x0a3d70b7},	/* 0.96639=f(0.26)*/
{35, 0,123,__LINE__, 0x3feed736, 0x00000000, 0x3fd147ae, 0x147ae15b},	/* 0.963771=f(0.27)*/
{37, 0,123,__LINE__, 0x3feec0f7, 0x60000000, 0x3fd1eb85, 0x1eb851ff},	/* 0.961055=f(0.28)*/
{35, 0,123,__LINE__, 0x3feea9ef, 0x20000000, 0x3fd28f5c, 0x28f5c2a3},	/* 0.958244=f(0.29)*/
{37, 0,123,__LINE__, 0x3fee921d, 0xe0000000, 0x3fd33333, 0x33333347},	/* 0.955337=f(0.3)*/
{39, 0,123,__LINE__, 0x3fee7984, 0x40000000, 0x3fd3d70a, 0x3d70a3eb},	/* 0.952334=f(0.31)*/
{36, 0,123,__LINE__, 0x3fee6023, 0x00000000, 0x3fd47ae1, 0x47ae148f},	/* 0.949235=f(0.32)*/
{37, 0,123,__LINE__, 0x3fee45fa, 0xa0000000, 0x3fd51eb8, 0x51eb8533},	/* 0.946042=f(0.33)*/
{36, 0,123,__LINE__, 0x3fee2b0b, 0xe0000000, 0x3fd5c28f, 0x5c28f5d7},	/* 0.942755=f(0.34)*/
{37, 0,123,__LINE__, 0x3fee0f57, 0x60000000, 0x3fd66666, 0x6666667b},	/* 0.939373=f(0.35)*/
{38, 0,123,__LINE__, 0x3fedf2dd, 0xe0000000, 0x3fd70a3d, 0x70a3d71f},	/* 0.935897=f(0.36)*/
{37, 0,123,__LINE__, 0x3fedd5a0, 0x20000000, 0x3fd7ae14, 0x7ae147c3},	/* 0.932327=f(0.37)*/
{37, 0,123,__LINE__, 0x3fedb79e, 0xe0000000, 0x3fd851eb, 0x851eb867},	/* 0.928665=f(0.38)*/
{36, 0,123,__LINE__, 0x3fed98da, 0xe0000000, 0x3fd8f5c2, 0x8f5c290b},	/* 0.924909=f(0.39)*/
{37, 0,123,__LINE__, 0x3fed7954, 0xe0000000, 0x3fd99999, 0x999999af},	/* 0.921061=f(0.4)*/
{38, 0,123,__LINE__, 0x3fed590d, 0xc0000000, 0x3fda3d70, 0xa3d70a53},	/* 0.917121=f(0.41)*/
{36, 0,123,__LINE__, 0x3fed3806, 0x40000000, 0x3fdae147, 0xae147af7},	/* 0.913089=f(0.42)*/
{36, 0,123,__LINE__, 0x3fed163f, 0x60000000, 0x3fdb851e, 0xb851eb9b},	/* 0.908966=f(0.43)*/
{42, 0,123,__LINE__, 0x3fecf3b9, 0xc0000000, 0x3fdc28f5, 0xc28f5c3f},	/* 0.904752=f(0.44)*/
{36, 0,123,__LINE__, 0x3fecd076, 0x80000000, 0x3fdccccc, 0xcccccce3},	/* 0.900447=f(0.45)*/
{39, 0,123,__LINE__, 0x3fecac76, 0x40000000, 0x3fdd70a3, 0xd70a3d87},	/* 0.896052=f(0.46)*/
{37, 0,123,__LINE__, 0x3fec87ba, 0x40000000, 0x3fde147a, 0xe147ae2b},	/* 0.891568=f(0.47)*/
{36, 0,123,__LINE__, 0x3fec6243, 0x20000000, 0x3fdeb851, 0xeb851ecf},	/* 0.886995=f(0.48)*/
{38, 0,123,__LINE__, 0x3fec3c12, 0x20000000, 0x3fdf5c28, 0xf5c28f73},	/* 0.882333=f(0.49)*/
{37, 0,123,__LINE__, 0x3fec1528, 0x00000000, 0x3fe00000, 0x0000000b},	/* 0.877583=f(0.5)*/
{36, 0,123,__LINE__, 0x3febed85, 0xe0000000, 0x3fe051eb, 0x851eb85d},	/* 0.872745=f(0.51)*/
{38, 0,123,__LINE__, 0x3febc52c, 0xc0000000, 0x3fe0a3d7, 0x0a3d70af},	/* 0.867819=f(0.52)*/
{37, 0,123,__LINE__, 0x3feb9c1d, 0xa0000000, 0x3fe0f5c2, 0x8f5c2901},	/* 0.862807=f(0.53)*/
{36, 0,123,__LINE__, 0x3feb7259, 0x80000000, 0x3fe147ae, 0x147ae153},	/* 0.857709=f(0.54)*/
{38, 0,123,__LINE__, 0x3feb47e1, 0x80000000, 0x3fe19999, 0x999999a5},	/* 0.852525=f(0.55)*/
{38, 0,123,__LINE__, 0x3feb1cb6, 0xc0000000, 0x3fe1eb85, 0x1eb851f7},	/* 0.847255=f(0.56)*/
{36, 0,123,__LINE__, 0x3feaf0da, 0x60000000, 0x3fe23d70, 0xa3d70a49},	/* 0.841901=f(0.57)*/
{36, 0,123,__LINE__, 0x3feac44d, 0x60000000, 0x3fe28f5c, 0x28f5c29b},	/* 0.836463=f(0.58)*/
{35, 0,123,__LINE__, 0x3fea9711, 0x00000000, 0x3fe2e147, 0xae147aed},	/* 0.830941=f(0.59)*/
{36, 0,123,__LINE__, 0x3fea6926, 0x40000000, 0x3fe33333, 0x3333333f},	/* 0.825336=f(0.6)*/
{36, 0,123,__LINE__, 0x3fea3a8e, 0x80000000, 0x3fe3851e, 0xb851eb91},	/* 0.819648=f(0.61)*/
{36, 0,123,__LINE__, 0x3fea0b4a, 0xe0000000, 0x3fe3d70a, 0x3d70a3e3},	/* 0.813878=f(0.62)*/
{41, 0,123,__LINE__, 0x3fe9db5c, 0x80000000, 0x3fe428f5, 0xc28f5c35},	/* 0.808028=f(0.63)*/
{38, 0,123,__LINE__, 0x3fe9aac4, 0xc0000000, 0x3fe47ae1, 0x47ae1487},	/* 0.802096=f(0.64)*/
{39, 0,123,__LINE__, 0x3fe97984, 0xc0000000, 0x3fe4cccc, 0xccccccd9},	/* 0.796084=f(0.65)*/
{39, 0,123,__LINE__, 0x3fe9479d, 0xc0000000, 0x3fe51eb8, 0x51eb852b},	/* 0.789992=f(0.66)*/
{37, 0,123,__LINE__, 0x3fe91511, 0x20000000, 0x3fe570a3, 0xd70a3d7d},	/* 0.783822=f(0.67)*/
{36, 0,123,__LINE__, 0x3fe8e1e0, 0x20000000, 0x3fe5c28f, 0x5c28f5cf},	/* 0.777573=f(0.68)*/
{38, 0,123,__LINE__, 0x3fe8ae0c, 0x20000000, 0x3fe6147a, 0xe147ae21},	/* 0.771246=f(0.69)*/
{37, 0,123,__LINE__, 0x3fe87996, 0x60000000, 0x3fe66666, 0x66666673},	/* 0.764842=f(0.7)*/
{37, 0,123,__LINE__, 0x3fe84480, 0x20000000, 0x3fe6b851, 0xeb851ec5},	/* 0.758362=f(0.71)*/
{37, 0,123,__LINE__, 0x3fe80eca, 0xe0000000, 0x3fe70a3d, 0x70a3d717},	/* 0.751806=f(0.72)*/
{36, 0,123,__LINE__, 0x3fe7d878, 0x00000000, 0x3fe75c28, 0xf5c28f69},	/* 0.745174=f(0.73)*/
{36, 0,123,__LINE__, 0x3fe7a188, 0xc0000000, 0x3fe7ae14, 0x7ae147bb},	/* 0.738469=f(0.74)*/
{37, 0,123,__LINE__, 0x3fe769fe, 0xc0000000, 0x3fe80000, 0x0000000d},	/* 0.731689=f(0.75)*/
{36, 0,123,__LINE__, 0x3fe731db, 0x40000000, 0x3fe851eb, 0x851eb85f},	/* 0.724836=f(0.76)*/
{36, 0,123,__LINE__, 0x3fe6f91f, 0xe0000000, 0x3fe8a3d7, 0x0a3d70b1},	/* 0.717911=f(0.77)*/
{36, 0,123,__LINE__, 0x3fe6bfcd, 0xc0000000, 0x3fe8f5c2, 0x8f5c2903},	/* 0.710914=f(0.78)*/
{40, 0,123,__LINE__, 0x3fe685e6, 0x94567efd, 0x3fe947ae, 0x147ae155},	/* 0.703845=f(0.79)*/
{42, 0,123,__LINE__, 0x3fe64b6b, 0xd9da4793, 0x3fe99999, 0x999999a7},	/* 0.696707=f(0.8)*/
{40, 0,123,__LINE__, 0x3fe6105f, 0x0398235e, 0x3fe9eb85, 0x1eb851f9},	/* 0.689498=f(0.81)*/
{40, 0,123,__LINE__, 0x3fe5d4c1, 0x948cc28c, 0x3fea3d70, 0xa3d70a4b},	/* 0.682221=f(0.82)*/
{38, 0,123,__LINE__, 0x3fe59895, 0x13687400, 0x3fea8f5c, 0x28f5c29d},	/* 0.674876=f(0.83)*/
{39, 0,123,__LINE__, 0x3fe55bdb, 0x0a8524f4, 0x3feae147, 0xae147aef},	/* 0.667463=f(0.84)*/
{39, 0,123,__LINE__, 0x3fe51e94, 0xefd1cb5c, 0x3feb3333, 0x33333341},	/* 0.659983=f(0.85)*/
{39, 0,123,__LINE__, 0x3fe4e0c4, 0x84bc68bc, 0x3feb851e, 0xb851eb93},	/* 0.652437=f(0.86)*/
{41, 0,123,__LINE__, 0x3fe4a26b, 0x468ab7c6, 0x3febd70a, 0x3d70a3e5},	/* 0.644827=f(0.87)*/
{39, 0,123,__LINE__, 0x3fe4638a, 0xcdd7404c, 0x3fec28f5, 0xc28f5c37},	/* 0.637151=f(0.88)*/
{39, 0,123,__LINE__, 0x3fe42424, 0xb6b2c3a8, 0x3fec7ae1, 0x47ae1489},	/* 0.629412=f(0.89)*/
{41, 0,123,__LINE__, 0x3fe3e43a, 0xa099b03b, 0x3feccccc, 0xccccccdb},	/* 0.62161=f(0.9)*/
{41, 0,123,__LINE__, 0x3fe3a3ce, 0x1525e134, 0x3fed1eb8, 0x51eb852d},	/* 0.613746=f(0.91)*/
{39, 0,123,__LINE__, 0x3fe362e0, 0xece066b5, 0x3fed70a3, 0xd70a3d7f},	/* 0.60582=f(0.92)*/
{40, 0,123,__LINE__, 0x3fe32174, 0xb8378a33, 0x3fedc28f, 0x5c28f5d1},	/* 0.597834=f(0.93)*/
{43, 0,123,__LINE__, 0x3fe2df8b, 0x23eb3665, 0x3fee147a, 0xe147ae23},	/* 0.589788=f(0.94)*/
{40, 0,123,__LINE__, 0x3fe29d25, 0xdff0f9d6, 0x3fee6666, 0x66666675},	/* 0.581683=f(0.95)*/
{41, 0,123,__LINE__, 0x3fe25a46, 0x9f68f807, 0x3feeb851, 0xeb851ec7},	/* 0.57352=f(0.96)*/
{40, 0,123,__LINE__, 0x3fe216ee, 0xfe2d4f19, 0x3fef0a3d, 0x70a3d719},	/* 0.5653=f(0.97)*/
{40, 0,123,__LINE__, 0x3fe1d320, 0xea2ec224, 0x3fef5c28, 0xf5c28f6b},	/* 0.557023=f(0.98)*/
{40, 0,123,__LINE__, 0x3fe18ede, 0x05933c42, 0x3fefae14, 0x7ae147bd},	/* 0.54869=f(0.99)*/
{40, 0,123,__LINE__, 0x3fe14a28, 0x0fb506a6, 0x3ff00000, 0x00000007},	/* 0.540302=f(1)*/
{42, 0,123,__LINE__, 0x3fe10500, 0xcae083a5, 0x3ff028f5, 0xc28f5c30},	/* 0.531861=f(1.01)*/
{41, 0,123,__LINE__, 0x3fe0bf69, 0xfc48a7a9, 0x3ff051eb, 0x851eb859},	/* 0.523366=f(1.02)*/
{40, 0,123,__LINE__, 0x3fe07965, 0x6bfb5f21, 0x3ff07ae1, 0x47ae1482},	/* 0.514819=f(1.03)*/
{41, 0,123,__LINE__, 0x3fe032f4, 0xe4d5e1c1, 0x3ff0a3d7, 0x0a3d70ab},	/* 0.50622=f(1.04)*/
{40, 0,123,__LINE__, 0x3fdfd834, 0x68f1e69a, 0x3ff0cccc, 0xccccccd4},	/* 0.497571=f(1.05)*/
{40, 0,123,__LINE__, 0x3fdf49ae, 0x567a24a7, 0x3ff0f5c2, 0x8f5c28fd},	/* 0.488872=f(1.06)*/
{41, 0,123,__LINE__, 0x3fdeba5a, 0xc8050efe, 0x3ff11eb8, 0x51eb8526},	/* 0.480124=f(1.07)*/
{39, 0,123,__LINE__, 0x3fde2a3e, 0x48cf6b62, 0x3ff147ae, 0x147ae14f},	/* 0.471328=f(1.08)*/
{43, 0,123,__LINE__, 0x3fdd995c, 0x19a012bd, 0x3ff170a3, 0xd70a3d78},	/* 0.462485=f(1.09)*/
{40, 0,123,__LINE__, 0x3fdd07b7, 0xeff6c332, 0x3ff19999, 0x999999a1},	/* 0.453596=f(1.1)*/
{39, 0,123,__LINE__, 0x3fdc7555, 0x864a7958, 0x3ff1c28f, 0x5c28f5ca},	/* 0.444662=f(1.11)*/
{39, 0,123,__LINE__, 0x3fdbe238, 0x9bf1011f, 0x3ff1eb85, 0x1eb851f3},	/* 0.435682=f(1.12)*/
{39, 0,123,__LINE__, 0x3fdb4e64, 0xf50666c3, 0x3ff2147a, 0xe147ae1c},	/* 0.42666=f(1.13)*/
{40, 0,123,__LINE__, 0x3fdab9de, 0x5a54487e, 0x3ff23d70, 0xa3d70a45},	/* 0.417595=f(1.14)*/
{45, 0,123,__LINE__, 0x3fda24a8, 0x9939098a, 0x3ff26666, 0x6666666e},	/* 0.408487=f(1.15)*/
{40, 0,123,__LINE__, 0x3fd98ec7, 0x838ee721, 0x3ff28f5c, 0x28f5c297},	/* 0.39934=f(1.16)*/
{40, 0,123,__LINE__, 0x3fd8f83e, 0xef92f019, 0x3ff2b851, 0xeb851ec0},	/* 0.390152=f(1.17)*/
{42, 0,123,__LINE__, 0x3fd86112, 0xb7cbdfc1, 0x3ff2e147, 0xae147ae9},	/* 0.380925=f(1.18)*/
{41, 0,123,__LINE__, 0x3fd7c946, 0x441c1153, 0x3ff30a3d, 0x70a3d712},	/* 0.37166=f(1.19)*/
{40, 0,123,__LINE__, 0x3fefffff, 0xffffff76, 0xc01921fb, 0x54442d18},	/* 1=f(-6.28319)*/
{36, 0,123,__LINE__, 0xbfefffff, 0xffffffde, 0xc00921fb, 0x54442d18},	/* -1=f(-3.14159)*/
{35, 0,123,__LINE__, 0xbe6777a5, 0xcffffffe, 0xbff921fb, 0x54442d18},	/* -4.37114e-08=f(-1.5708)*/
{39, 0,123,__LINE__, 0x3ff00000, 0x00000000, 0x00000000, 0x00000000},	/* 1=f(0)*/
{64, 0,123,__LINE__, 0xbe6777a5, 0xcffffffe, 0x3ff921fb, 0x54442d18},	/* -4.37114e-08=f(1.5708)*/
{39, 0,123,__LINE__, 0xbfefffff, 0xffffffde, 0x400921fb, 0x54442d18},	/* -1=f(3.14159)*/
{31, 0,123,__LINE__, 0x3e499bc5, 0xc0000000, 0x4012d97c, 0x7f3321d2},	/* 1.19249e-08=f(4.71239)*/
{28, 0,123,__LINE__, 0x3fc3be82, 0xf2505a70, 0xc03e0000, 0x00000000},	/* 0.154251=f(-30)*/
{35, 0,123,__LINE__, 0xbfeffd4d, 0x54785727, 0xc03c4ccc, 0xcccccccd},	/* -0.999671=f(-28.3)*/
{27, 0,123,__LINE__, 0x3fba754b, 0xa78a3763, 0xc03a9999, 0x9999999a},	/* 0.103352=f(-26.6)*/
{32, 0,123,__LINE__, 0x3fef231f, 0xfb56a06e, 0xc038e666, 0x66666667},	/* 0.973038=f(-24.9)*/
{29, 0,123,__LINE__, 0xbfd6a976, 0x0576e390, 0xc0373333, 0x33333334},	/* -0.354093=f(-23.2)*/
{31, 0,123,__LINE__, 0xbfec37a3, 0x48f58c69, 0xc0358000, 0x00000001},	/* -0.881792=f(-21.5)*/
{31, 0,123,__LINE__, 0x3fe29a31, 0x808e133f, 0xc033cccc, 0xccccccce},	/* 0.581322=f(-19.8)*/
{31, 0,123,__LINE__, 0x3fe76c79, 0xfa89b9ae, 0xc0321999, 0x9999999b},	/* 0.731992=f(-18.1)*/
{36, 0,123,__LINE__, 0xbfe8a36a, 0x6a73f49a, 0xc0306666, 0x66666668},	/* -0.769948=f(-16.4)*/
{35, 0,123,__LINE__, 0xbfe1131f, 0x39a70f93, 0xc02d6666, 0x6666666a},	/* -0.533584=f(-14.7)*/
{35, 0,123,__LINE__, 0x3fed09cd, 0xd5260afe, 0xc02a0000, 0x00000004},	/* 0.907447=f(-13)*/
{32, 0,123,__LINE__, 0x3fd32f07, 0xdb024780, 0xc0269999, 0x9999999e},	/* 0.299746=f(-11.3)*/
{36, 0,123,__LINE__, 0xbfef828f, 0xf7793042, 0xc0233333, 0x33333338},	/* -0.984688=f(-9.6)*/
{28, 0,123,__LINE__, 0xbfa78d9a, 0x64ab594b, 0xc01f9999, 0x999999a3},	/* -0.0460022=f(-7.9)*/
{35, 0,123,__LINE__, 0x3fefe3ac, 0x37f786af, 0xc018cccc, 0xccccccd6},	/* 0.996542=f(-6.2)*/
{32, 0,123,__LINE__, 0xbfcafb5b, 0x54583d8b, 0xc0120000, 0x00000009},	/* -0.210796=f(-4.5)*/
{39, 0,123,__LINE__, 0xbfee26af, 0x6ec40db6, 0xc0066666, 0x66666678},	/* -0.942222=f(-2.8)*/
{40, 0,123,__LINE__, 0x3fdd07b7, 0xeff6c332, 0xbff19999, 0x999999bd},	/* 0.453596=f(-1.1)*/
{36, 0,123,__LINE__, 0x3fea6926, 0x40000000, 0x3fe33333, 0x333332ec},	/* 0.825336=f(0.6)*/
{40, 0,123,__LINE__, 0xbfe55222, 0x04192219, 0x40026666, 0x66666654},	/* -0.666276=f(2.3)*/
{38, 0,123,__LINE__, 0xbfe4eaa6, 0x06db24a9, 0x400fffff, 0xffffffee},	/* -0.653644=f(4)*/
{37, 0,123,__LINE__, 0x3feab5f7, 0x5daa1b5a, 0x4016cccc, 0xccccccc4},	/* 0.834713=f(5.7)*/
{36, 0,123,__LINE__, 0x3fdc1128, 0x7364705c, 0x401d9999, 0x99999991},	/* 0.438547=f(7.4)*/
{33, 0,123,__LINE__, 0xbfee53bc, 0x8235a328, 0x40223333, 0x3333332f},	/* -0.947722=f(9.1)*/
{29, 0,123,__LINE__, 0xbfc8dfcb, 0xd6a382fd, 0x40259999, 0x99999995},	/* -0.19433=f(10.8)*/
{36, 0,123,__LINE__, 0x3fefedf6, 0xa822782b, 0x4028ffff, 0xfffffffb},	/* 0.997798=f(12.5)*/
{28, 0,123,__LINE__, 0xbfb0131b, 0x1ad5c1db, 0x402c6666, 0x66666661},	/* -0.0627915=f(14.2)*/
{34, 0,123,__LINE__, 0xbfef6969, 0x58f580cd, 0x402fcccc, 0xccccccc7},	/* -0.981618=f(15.9)*/
{33, 0,123,__LINE__, 0x3fd43526, 0xcff8640d, 0x40319999, 0x99999997},	/* 0.315744=f(17.6)*/
{35, 0,123,__LINE__, 0x3feccee1, 0xde5aee00, 0x40334ccc, 0xccccccca},	/* 0.900254=f(19.3)*/
{34, 0,123,__LINE__, 0xbfe186ff, 0x83773773, 0x4034ffff, 0xfffffffd},	/* -0.547729=f(21)*/
{34, 0,123,__LINE__, 0xbfe84aa0, 0x2141615a, 0x4036b333, 0x33333330},	/* -0.75911=f(22.7)*/
{35, 0,123,__LINE__, 0x3fe7c977, 0xe770f712, 0x40386666, 0x66666663},	/* 0.743343=f(24.4)*/
{35, 0,123,__LINE__, 0x3fe22970, 0x0128f5e4, 0x403a1999, 0x99999996},	/* 0.567558=f(26.1)*/
{36, 0,123,__LINE__, 0xbfec7793, 0xbe7da18f, 0x403bcccc, 0xccccccc9},	/* -0.889597=f(27.8)*/
{34, 0,123,__LINE__, 0xbfd5a705, 0x9eaeab38, 0x403d7fff, 0xfffffffc},	/* -0.338319=f(29.5)*/
{0}
};
void test_cosf(m)   {run_vector_1(m,cosf_vec,(char *)(cosf),"cosf","ff");   }	
