"""Fluent Solver TUI Commands"""
#
# This is an auto-generated file.  DO NOT EDIT!
#
# pylint: disable=line-too-long

from ansys.fluent.core.services.datamodel_tui import PyMenu, TUIMenu



class main_menu(TUIMenu):
    """
    Fluent solver main menu.
    """
    def __init__(self, path, service):
        self.path = path
        self.service = service
        self.setup = self.__class__.setup(path + ["setup"], service)
        self.parallel = self.__class__.parallel(path + ["parallel"], service)
        self.turbo_post = self.__class__.turbo_post(path + ["turbo_post"], service)
        self.mesh = self.__class__.mesh(path + ["mesh"], service)
        self.parameters__and__customization = self.__class__.parameters__and__customization(path + ["parameters__and__customization"], service)
        self.plot = self.__class__.plot(path + ["plot"], service)
        self.report = self.__class__.report(path + ["report"], service)
        self.preferences = self.__class__.preferences(path + ["preferences"], service)
        self.server = self.__class__.server(path + ["server"], service)
        self.file = self.__class__.file(path + ["file"], service)
        self.results = self.__class__.results(path + ["results"], service)
        self.views = self.__class__.views(path + ["views"], service)
        self.define = self.__class__.define(path + ["define"], service)
        self.surface = self.__class__.surface(path + ["surface"], service)
        self.adjoint = self.__class__.adjoint(path + ["adjoint"], service)
        self.solution = self.__class__.solution(path + ["solution"], service)
        self.turbo_workflow = self.__class__.turbo_workflow(path + ["turbo_workflow"], service)
        self.solve = self.__class__.solve(path + ["solve"], service)
        self.icing = self.__class__.icing(path + ["icing"], service)
        self.simulation_reports = self.__class__.simulation_reports(path + ["simulation_reports"], service)
        self.display = self.__class__.display(path + ["display"], service)
        self.parametric_study = self.__class__.parametric_study(path + ["parametric_study"], service)
        super().__init__(path, service)
    def close_fluent(self, *args, **kwargs):
        """
        Exit program.
        """
        return PyMenu(self.service, "/close_fluent").execute(*args, **kwargs)
    def print_license_usage(self, *args, **kwargs):
        """
        Print license usage information.
        """
        return PyMenu(self.service, "/print_license_usage").execute(*args, **kwargs)
    def switch_to_meshing_mode(self, *args, **kwargs):
        """
        Switches from the solution mode to the meshing mode. This text command is only available if you have not yet read a mesh or a case file.
        """
        return PyMenu(self.service, "/switch_to_meshing_mode").execute(*args, **kwargs)
    def exit(self, *args, **kwargs):
        """
        Exit program.
        """
        return PyMenu(self.service, "/exit").execute(*args, **kwargs)

    class setup(TUIMenu):
        """
        Enter setup menu.
        """
        def __init__(self, path, service):
            self.path = path
            self.service = service
            self.dynamic_mesh = self.__class__.dynamic_mesh(path + ["dynamic_mesh"], service)
            self.mixing_planes = self.__class__.mixing_planes(path + ["mixing_planes"], service)
            self.materials = self.__class__.materials(path + ["materials"], service)
            self.turbo_model = self.__class__.turbo_model(path + ["turbo_model"], service)
            self.operating_conditions = self.__class__.operating_conditions(path + ["operating_conditions"], service)
            self.reference_frames = self.__class__.reference_frames(path + ["reference_frames"], service)
            self.reference_values = self.__class__.reference_values(path + ["reference_values"], service)
            self.boundary_conditions = self.__class__.boundary_conditions(path + ["boundary_conditions"], service)
            self.models = self.__class__.models(path + ["models"], service)
            self.mesh_interfaces = self.__class__.mesh_interfaces(path + ["mesh_interfaces"], service)
            self.overset_interfaces = self.__class__.overset_interfaces(path + ["overset_interfaces"], service)
            self.named_expressions = self.__class__.named_expressions(path + ["named_expressions"], service)
            self.gap_model = self.__class__.gap_model(path + ["gap_model"], service)
            self.expert = self.__class__.expert(path + ["expert"], service)
            super().__init__(path, service)

        class dynamic_mesh(TUIMenu):
            """
            Enter the dynamic mesh menu.
            """
            def __init__(self, path, service):
                self.path = path
                self.service = service
                self.zones = self.__class__.zones(path + ["zones"], service)
                self.controls = self.__class__.controls(path + ["controls"], service)
                self.transient_settings = self.__class__.transient_settings(path + ["transient_settings"], service)
                self.actions = self.__class__.actions(path + ["actions"], service)
                self.events = self.__class__.events(path + ["events"], service)
                super().__init__(path, service)
            def dynamic_mesh(self, *args, **kwargs):
                """
                Enable/disable the dynamic mesh solver and options.
                """
                return PyMenu(self.service, "/setup/dynamic_mesh/dynamic_mesh").execute(*args, **kwargs)

            class zones(TUIMenu):
                """
                Enter the dynamic mesh zones menu.
                """
                def __init__(self, path, service):
                    self.path = path
                    self.service = service
                    super().__init__(path, service)
                def insert_interior_layer(self, *args, **kwargs):
                    """
                    Insert new layer cell zone at specified location.
                    """
                    return PyMenu(self.service, "/setup/dynamic_mesh/zones/insert_interior_layer").execute(*args, **kwargs)
                def remove_boundary_layer(self, *args, **kwargs):
                    """
                    Remove cell zone.
                    """
                    return PyMenu(self.service, "/setup/dynamic_mesh/zones/remove_boundary_layer").execute(*args, **kwargs)
                def create(self, *args, **kwargs):
                    """
                    Create dynamic zone.
                    """
                    return PyMenu(self.service, "/setup/dynamic_mesh/zones/create").execute(*args, **kwargs)
                def list(self, *args, **kwargs):
                    """
                    List dynamic zones.
                    """
                    return PyMenu(self.service, "/setup/dynamic_mesh/zones/list").execute(*args, **kwargs)
                def remove_interior_layer(self, *args, **kwargs):
                    """
                    Remove interior layer cell zone.
                    """
                    return PyMenu(self.service, "/setup/dynamic_mesh/zones/remove_interior_layer").execute(*args, **kwargs)
                def delete(self, *args, **kwargs):
                    """
                    Delete dynamic zone.
                    """
                    return PyMenu(self.service, "/setup/dynamic_mesh/zones/delete").execute(*args, **kwargs)
                def insert_boundary_layer(self, *args, **kwargs):
                    """
                    Insert new cell zone.
                    """
                    return PyMenu(self.service, "/setup/dynamic_mesh/zones/insert_boundary_layer").execute(*args, **kwargs)

            class controls(TUIMenu):
                """
                Enter the dynamic mesh control menu.
                """
                def __init__(self, path, service):
                    self.path = path
                    self.service = service
                    self.remeshing_parameters = self.__class__.remeshing_parameters(path + ["remeshing_parameters"], service)
                    self.implicit_update_parameters = self.__class__.implicit_update_parameters(path + ["implicit_update_parameters"], service)
                    self.layering_parameters = self.__class__.layering_parameters(path + ["layering_parameters"], service)
                    self.periodic_displacement_parameters = self.__class__.periodic_displacement_parameters(path + ["periodic_displacement_parameters"], service)
                    self.in_cylinder_parameters = self.__class__.in_cylinder_parameters(path + ["in_cylinder_parameters"], service)
                    self.contact_parameters = self.__class__.contact_parameters(path + ["contact_parameters"], service)
                    self.smoothing_parameters = self.__class__.smoothing_parameters(path + ["smoothing_parameters"], service)
                    self.six_dof_parameters = self.__class__.six_dof_parameters(path + ["six_dof_parameters"], service)
                    super().__init__(path, service)
                def smoothing(self, *args, **kwargs):
                    """
                    Enable/disable dynamic mesh smoothing.
                    """
                    return PyMenu(self.service, "/setup/dynamic_mesh/controls/smoothing").execute(*args, **kwargs)
                def remeshing(self, *args, **kwargs):
                    """
                    Enable/disable local remeshing in tri/tet and mixed cell zones.
                    """
                    return PyMenu(self.service, "/setup/dynamic_mesh/controls/remeshing").execute(*args, **kwargs)
                def steady_pseudo_time_control(self, *args, **kwargs):
                    """
                    Enable/disable pseudo time step control in user interface.
                    """
                    return PyMenu(self.service, "/setup/dynamic_mesh/controls/steady_pseudo_time_control").execute(*args, **kwargs)
                def in_cylinder_output(self, *args, **kwargs):
                    """
                    Enable/disable in-cylinder output.
                    """
                    return PyMenu(self.service, "/setup/dynamic_mesh/controls/in_cylinder_output").execute(*args, **kwargs)
                def layering(self, *args, **kwargs):
                    """
                    Enable/disable dynamic-layering in quad/hex cell zones.
                    """
                    return PyMenu(self.service, "/setup/dynamic_mesh/controls/layering").execute(*args, **kwargs)

                class remeshing_parameters(TUIMenu):
                    """
                    Enter the dynamic mesh remeshing menu.
                    """
                    def __init__(self, path, service):
                        self.path = path
                        self.service = service
                        self.prism_controls = self.__class__.prism_controls(path + ["prism_controls"], service)
                        self.sizing_controls = self.__class__.sizing_controls(path + ["sizing_controls"], service)
                        self.prism_layer_parameters = self.__class__.prism_layer_parameters(path + ["prism_layer_parameters"], service)
                        super().__init__(path, service)
                    def sizing_funct_variation(self, *args, **kwargs):
                        """
                        Set the maximum sizing function increase/decrease in the interior.
                        """
                        return PyMenu(self.service, "/setup/dynamic_mesh/controls/remeshing_parameters/sizing_funct_variation").execute(*args, **kwargs)
                    def remeshing_methods(self, *args, **kwargs):
                        """
                        Enable/disable remeshing methods.
                        """
                        return PyMenu(self.service, "/setup/dynamic_mesh/controls/remeshing_parameters/remeshing_methods").execute(*args, **kwargs)
                    def sizing_funct_defaults(self, *args, **kwargs):
                        """
                        Set sizing function defaults.
                        """
                        return PyMenu(self.service, "/setup/dynamic_mesh/controls/remeshing_parameters/sizing_funct_defaults").execute(*args, **kwargs)
                    def cell_skew_max(self, *args, **kwargs):
                        """
                        Set the cell skewness threshold above which cells will be remeshed.
                        """
                        return PyMenu(self.service, "/setup/dynamic_mesh/controls/remeshing_parameters/cell_skew_max").execute(*args, **kwargs)
                    def poly_remeshing(self, *args, **kwargs):
                        """
                        Enable/disable poly remeshing.
                        """
                        return PyMenu(self.service, "/setup/dynamic_mesh/controls/remeshing_parameters/poly_remeshing").execute(*args, **kwargs)
                    def retain_size_distribution(self, *args, **kwargs):
                        """
                        Enable/disable retaining of size distribution.
                        """
                        return PyMenu(self.service, "/setup/dynamic_mesh/controls/remeshing_parameters/retain_size_distribution").execute(*args, **kwargs)
                    def sizing_funct_rate(self, *args, **kwargs):
                        """
                        Determine how far from the boundary the increase/decrease happens.
                        """
                        return PyMenu(self.service, "/setup/dynamic_mesh/controls/remeshing_parameters/sizing_funct_rate").execute(*args, **kwargs)
                    def unified_remeshing(self, *args, **kwargs):
                        """
                        Enable/disable unified remeshing.
                        """
                        return PyMenu(self.service, "/setup/dynamic_mesh/controls/remeshing_parameters/unified_remeshing").execute(*args, **kwargs)
                    def remeshing_after_moving(self, *args, **kwargs):
                        """
                        Enable/disable optional remeshing after mesh motion to meet skewness threshold.
                        Steady state dynamic mesh only.
                        """
                        return PyMenu(self.service, "/setup/dynamic_mesh/controls/remeshing_parameters/remeshing_after_moving").execute(*args, **kwargs)
                    def parallel_remeshing(self, *args, **kwargs):
                        """
                        Enable/disable parallel remeshing for zone remeshing.
                        """
                        return PyMenu(self.service, "/setup/dynamic_mesh/controls/remeshing_parameters/parallel_remeshing").execute(*args, **kwargs)
                    def sizing_function(self, *args, **kwargs):
                        """
                        Enable/disable sizing function to control size based remeshing.
                        """
                        return PyMenu(self.service, "/setup/dynamic_mesh/controls/remeshing_parameters/sizing_function").execute(*args, **kwargs)
                    def zone_remeshing(self, *args, **kwargs):
                        """
                        Enable/disable cell zone remeshing method.
                        """
                        return PyMenu(self.service, "/setup/dynamic_mesh/controls/remeshing_parameters/zone_remeshing").execute(*args, **kwargs)
                    def length_min(self, *args, **kwargs):
                        """
                        Set the length threshold below which cells will be remeshed.
                        """
                        return PyMenu(self.service, "/setup/dynamic_mesh/controls/remeshing_parameters/length_min").execute(*args, **kwargs)
                    def face_skew_max(self, *args, **kwargs):
                        """
                        Set the face skewness threshold above which faces will be remeshed.
                        """
                        return PyMenu(self.service, "/setup/dynamic_mesh/controls/remeshing_parameters/face_skew_max").execute(*args, **kwargs)
                    def length_max(self, *args, **kwargs):
                        """
                        Set the length threshold above which cells will be remeshed.
                        """
                        return PyMenu(self.service, "/setup/dynamic_mesh/controls/remeshing_parameters/length_max").execute(*args, **kwargs)
                    def size_remesh_interval(self, *args, **kwargs):
                        """
                        Set the interval (in time steps) when remeshing based on size is done.
                        """
                        return PyMenu(self.service, "/setup/dynamic_mesh/controls/remeshing_parameters/size_remesh_interval").execute(*args, **kwargs)
                    def sizing_funct_resolution(self, *args, **kwargs):
                        """
                        Set the sizing function resolution with respect to shortest boundary.
                        """
                        return PyMenu(self.service, "/setup/dynamic_mesh/controls/remeshing_parameters/sizing_funct_resolution").execute(*args, **kwargs)

                    class prism_controls(TUIMenu):
                        """
                        Specify optional prism controls.
                        """
                        def __init__(self, path, service):
                            self.path = path
                            self.service = service
                            super().__init__(path, service)
                        def list_properties(self, *args, **kwargs):
                            """
                            List properties of an object.
                            """
                            return PyMenu(self.service, "/setup/dynamic_mesh/controls/remeshing_parameters/prism_controls/list_properties").execute(*args, **kwargs)
                        def add(self, *args, **kwargs):
                            """
                            Add a new object.
                            """
                            return PyMenu(self.service, "/setup/dynamic_mesh/controls/remeshing_parameters/prism_controls/add").execute(*args, **kwargs)
                        def list(self, *args, **kwargs):
                            """
                            List objects.
                            """
                            return PyMenu(self.service, "/setup/dynamic_mesh/controls/remeshing_parameters/prism_controls/list").execute(*args, **kwargs)
                        def edit(self, *args, **kwargs):
                            """
                            Edit an object.
                            """
                            return PyMenu(self.service, "/setup/dynamic_mesh/controls/remeshing_parameters/prism_controls/edit").execute(*args, **kwargs)
                        def delete(self, *args, **kwargs):
                            """
                            Delete an object.
                            """
                            return PyMenu(self.service, "/setup/dynamic_mesh/controls/remeshing_parameters/prism_controls/delete").execute(*args, **kwargs)

                    class sizing_controls(TUIMenu):
                        """
                        Specify optional sizing controls.
                        """
                        def __init__(self, path, service):
                            self.path = path
                            self.service = service
                            super().__init__(path, service)
                        def list(self, *args, **kwargs):
                            """
                            List objects.
                            """
                            return PyMenu(self.service, "/setup/dynamic_mesh/controls/remeshing_parameters/sizing_controls/list").execute(*args, **kwargs)
                        def add(self, *args, **kwargs):
                            """
                            Add a new object.
                            """
                            return PyMenu(self.service, "/setup/dynamic_mesh/controls/remeshing_parameters/sizing_controls/add").execute(*args, **kwargs)
                        def list_properties(self, *args, **kwargs):
                            """
                            List properties of an object.
                            """
                            return PyMenu(self.service, "/setup/dynamic_mesh/controls/remeshing_parameters/sizing_controls/list_properties").execute(*args, **kwargs)
                        def edit(self, *args, **kwargs):
                            """
                            Edit an object.
                            """
                            return PyMenu(self.service, "/setup/dynamic_mesh/controls/remeshing_parameters/sizing_controls/edit").execute(*args, **kwargs)
                        def delete(self, *args, **kwargs):
                            """
                            Delete an object.
                            """
                            return PyMenu(self.service, "/setup/dynamic_mesh/controls/remeshing_parameters/sizing_controls/delete").execute(*args, **kwargs)

                    class prism_layer_parameters(TUIMenu):
                        """
                        Enter the dynamic mesh prism remeshing menu.
                        """
                        def __init__(self, path, service):
                            self.path = path
                            self.service = service
                            super().__init__(path, service)
                        def number_of_layers(self, *args, **kwargs):
                            """
                            Set the number of elements in the prism layer.
                            """
                            return PyMenu(self.service, "/setup/dynamic_mesh/controls/remeshing_parameters/prism_layer_parameters/number_of_layers").execute(*args, **kwargs)
                        def growth_rate(self, *args, **kwargs):
                            """
                            Set the geometric growth rate of the prism layer.
                            """
                            return PyMenu(self.service, "/setup/dynamic_mesh/controls/remeshing_parameters/prism_layer_parameters/growth_rate").execute(*args, **kwargs)
                        def first_height(self, *args, **kwargs):
                            """
                            Set first cell height in the prism layer.
                            """
                            return PyMenu(self.service, "/setup/dynamic_mesh/controls/remeshing_parameters/prism_layer_parameters/first_height").execute(*args, **kwargs)

                class implicit_update_parameters(TUIMenu):
                    """
                    Enter the dynamic mesh implicit update menu.
                    """
                    def __init__(self, path, service):
                        self.path = path
                        self.service = service
                        super().__init__(path, service)
                    def update_interval(self, *args, **kwargs):
                        """
                        Specify update interval of implicit update.
                        """
                        return PyMenu(self.service, "/setup/dynamic_mesh/controls/implicit_update_parameters/update_interval").execute(*args, **kwargs)
                    def motion_relaxation(self, *args, **kwargs):
                        """
                        Specify motion relaxation of implicit update.
                        """
                        return PyMenu(self.service, "/setup/dynamic_mesh/controls/implicit_update_parameters/motion_relaxation").execute(*args, **kwargs)
                    def residual_criteria(self, *args, **kwargs):
                        """
                        Specify residual criteria of implicit update.
                        """
                        return PyMenu(self.service, "/setup/dynamic_mesh/controls/implicit_update_parameters/residual_criteria").execute(*args, **kwargs)

                class layering_parameters(TUIMenu):
                    """
                    Enter the dynamic mesh layering menu.
                    """
                    def __init__(self, path, service):
                        self.path = path
                        self.service = service
                        super().__init__(path, service)
                    def collapse_factor(self, *args, **kwargs):
                        """
                        Set the factor determining when to collapse dynamic layers.
                        """
                        return PyMenu(self.service, "/setup/dynamic_mesh/controls/layering_parameters/collapse_factor").execute(*args, **kwargs)
                    def constant_height(self, *args, **kwargs):
                        """
                        Enable/disable layering based on constant height, else layering based on constant ratio.
                        """
                        return PyMenu(self.service, "/setup/dynamic_mesh/controls/layering_parameters/constant_height").execute(*args, **kwargs)
                    def split_factor(self, *args, **kwargs):
                        """
                        Set the factor determining when to split dynamic layers.
                        """
                        return PyMenu(self.service, "/setup/dynamic_mesh/controls/layering_parameters/split_factor").execute(*args, **kwargs)

                class periodic_displacement_parameters(TUIMenu):
                    """
                    Enter the dynamic mesh periodic displacement menu.
                    """
                    def __init__(self, path, service):
                        self.path = path
                        self.service = service
                        super().__init__(path, service)
                    def delete_all_groups(self, *args, **kwargs):
                        """
                        Delete All Periodic Displacement Groups.
                        """
                        return PyMenu(self.service, "/setup/dynamic_mesh/controls/periodic_displacement_parameters/delete_all_groups").execute(*args, **kwargs)
                    def delete_all_displacements(self, *args, **kwargs):
                        """
                        Delete All Periodic Displacements.
                        """
                        return PyMenu(self.service, "/setup/dynamic_mesh/controls/periodic_displacement_parameters/delete_all_displacements").execute(*args, **kwargs)
                    def delete_displacement(self, *args, **kwargs):
                        """
                        Delete Periodic Displacement.
                        """
                        return PyMenu(self.service, "/setup/dynamic_mesh/controls/periodic_displacement_parameters/delete_displacement").execute(*args, **kwargs)
                    def edit_group(self, *args, **kwargs):
                        """
                        Edit Periodic Displacement Group.
                        """
                        return PyMenu(self.service, "/setup/dynamic_mesh/controls/periodic_displacement_parameters/edit_group").execute(*args, **kwargs)
                    def set_active_displacement(self, *args, **kwargs):
                        """
                        Set Active Periodic Displacement in Group.
                        """
                        return PyMenu(self.service, "/setup/dynamic_mesh/controls/periodic_displacement_parameters/set_active_displacement").execute(*args, **kwargs)
                    def create_group(self, *args, **kwargs):
                        """
                        Create Periodic Displacement Group.
                        """
                        return PyMenu(self.service, "/setup/dynamic_mesh/controls/periodic_displacement_parameters/create_group").execute(*args, **kwargs)
                    def delete_group(self, *args, **kwargs):
                        """
                        Delete Periodic Displacement Group.
                        """
                        return PyMenu(self.service, "/setup/dynamic_mesh/controls/periodic_displacement_parameters/delete_group").execute(*args, **kwargs)
                    def list_groups(self, *args, **kwargs):
                        """
                        List Periodic Displacement Groups.
                        """
                        return PyMenu(self.service, "/setup/dynamic_mesh/controls/periodic_displacement_parameters/list_groups").execute(*args, **kwargs)
                    def copy_displacement(self, *args, **kwargs):
                        """
                        Copy Periodic Displacement.
                        """
                        return PyMenu(self.service, "/setup/dynamic_mesh/controls/periodic_displacement_parameters/copy_displacement").execute(*args, **kwargs)
                    def edit_displacement(self, *args, **kwargs):
                        """
                        Edit Periodic Displacement.
                        """
                        return PyMenu(self.service, "/setup/dynamic_mesh/controls/periodic_displacement_parameters/edit_displacement").execute(*args, **kwargs)
                    def create_displacement(self, *args, **kwargs):
                        """
                        Create Periodic Displacement.
                        """
                        return PyMenu(self.service, "/setup/dynamic_mesh/controls/periodic_displacement_parameters/create_displacement").execute(*args, **kwargs)
                    def list_displacements(self, *args, **kwargs):
                        """
                        List Periodic Displacements.
                        """
                        return PyMenu(self.service, "/setup/dynamic_mesh/controls/periodic_displacement_parameters/list_displacements").execute(*args, **kwargs)

                class in_cylinder_parameters(TUIMenu):
                    """
                    Enter the dynamic mesh in-cylinder menu.
                    """
                    def __init__(self, path, service):
                        self.path = path
                        self.service = service
                        super().__init__(path, service)
                    def starting_crank_angle(self, *args, **kwargs):
                        """
                        Specify the starting crank angle.
                        """
                        return PyMenu(self.service, "/setup/dynamic_mesh/controls/in_cylinder_parameters/starting_crank_angle").execute(*args, **kwargs)
                    def print_plot_lift(self, *args, **kwargs):
                        """
                        Print or plot valve lift curve.
                        """
                        return PyMenu(self.service, "/setup/dynamic_mesh/controls/in_cylinder_parameters/print_plot_lift").execute(*args, **kwargs)
                    def max_crank_angle_step(self, *args, **kwargs):
                        """
                        Specify the maximum crank angle step size.
                        """
                        return PyMenu(self.service, "/setup/dynamic_mesh/controls/in_cylinder_parameters/max_crank_angle_step").execute(*args, **kwargs)
                    def position_starting_mesh(self, *args, **kwargs):
                        """
                        Move mesh from top dead center to starting crank angle.
                        """
                        return PyMenu(self.service, "/setup/dynamic_mesh/controls/in_cylinder_parameters/position_starting_mesh").execute(*args, **kwargs)
                    def crank_angle_step(self, *args, **kwargs):
                        """
                        Specify the crank angle step size.
                        """
                        return PyMenu(self.service, "/setup/dynamic_mesh/controls/in_cylinder_parameters/crank_angle_step").execute(*args, **kwargs)
                    def modify_lift(self, *args, **kwargs):
                        """
                        Modify the lift curve (shift or scale).
                        """
                        return PyMenu(self.service, "/setup/dynamic_mesh/controls/in_cylinder_parameters/modify_lift").execute(*args, **kwargs)
                    def crank_period(self, *args, **kwargs):
                        """
                        Specify the crank period.
                        """
                        return PyMenu(self.service, "/setup/dynamic_mesh/controls/in_cylinder_parameters/crank_period").execute(*args, **kwargs)
                    def piston_data(self, *args, **kwargs):
                        """
                        Specify the crank radius, connecting rod length, and piston pin offset.
                        """
                        return PyMenu(self.service, "/setup/dynamic_mesh/controls/in_cylinder_parameters/piston_data").execute(*args, **kwargs)
                    def piston_stroke_cutoff(self, *args, **kwargs):
                        """
                        Specify the cut off point for in-cylinder piston.
                        """
                        return PyMenu(self.service, "/setup/dynamic_mesh/controls/in_cylinder_parameters/piston_stroke_cutoff").execute(*args, **kwargs)
                    def minimum_lift(self, *args, **kwargs):
                        """
                        Specify the minimum lift for in-cylinder valves.
                        """
                        return PyMenu(self.service, "/setup/dynamic_mesh/controls/in_cylinder_parameters/minimum_lift").execute(*args, **kwargs)

                class contact_parameters(TUIMenu):
                    """
                    Enter the dynamic mesh contact detection menu.
                    """
                    def __init__(self, path, service):
                        self.path = path
                        self.service = service
                        self.flow_control_parameters = self.__class__.flow_control_parameters(path + ["flow_control_parameters"], service)
                        super().__init__(path, service)
                    def contact_method(self, *args, **kwargs):
                        """
                        Select the method used for flow control in the contact region.
                        """
                        return PyMenu(self.service, "/setup/dynamic_mesh/controls/contact_parameters/contact_method").execute(*args, **kwargs)
                    def update_contact_marks(self, *args, **kwargs):
                        """
                        Update which cells are marked in order to block flow in the contact region.
                        """
                        return PyMenu(self.service, "/setup/dynamic_mesh/controls/contact_parameters/update_contact_marks").execute(*args, **kwargs)
                    def verbosity(self, *args, **kwargs):
                        """
                        Set the verbosity for contact-detection.
                        """
                        return PyMenu(self.service, "/setup/dynamic_mesh/controls/contact_parameters/verbosity").execute(*args, **kwargs)
                    def contact_udf(self, *args, **kwargs):
                        """
                        Select UDF to be invoked when contact is detected.
                        """
                        return PyMenu(self.service, "/setup/dynamic_mesh/controls/contact_parameters/contact_udf").execute(*args, **kwargs)
                    def contact_threshold(self, *args, **kwargs):
                        """
                        Specify threshold distance for contact detection.
                        """
                        return PyMenu(self.service, "/setup/dynamic_mesh/controls/contact_parameters/contact_threshold").execute(*args, **kwargs)
                    def flow_control(self, *args, **kwargs):
                        """
                        Enable/disable flow control.
                        """
                        return PyMenu(self.service, "/setup/dynamic_mesh/controls/contact_parameters/flow_control").execute(*args, **kwargs)
                    def render_contact_cells(self, *args, **kwargs):
                        """
                        Set the option to include contact-cells in post-processing.
                        """
                        return PyMenu(self.service, "/setup/dynamic_mesh/controls/contact_parameters/render_contact_cells").execute(*args, **kwargs)
                    def contact_face_zones(self, *args, **kwargs):
                        """
                        Select face zones involved in contact detection.
                        """
                        return PyMenu(self.service, "/setup/dynamic_mesh/controls/contact_parameters/contact_face_zones").execute(*args, **kwargs)

                    class flow_control_parameters(TUIMenu):
                        """
                        Enter the flow control menu.
                        """
                        def __init__(self, path, service):
                            self.path = path
                            self.service = service
                            super().__init__(path, service)
                        def delete_flow_control_zone(self, *args, **kwargs):
                            """
                            Delete a flow control zone.
                            """
                            return PyMenu(self.service, "/setup/dynamic_mesh/controls/contact_parameters/flow_control_parameters/delete_flow_control_zone").execute(*args, **kwargs)
                        def create_flow_control_zone(self, *args, **kwargs):
                            """
                            Create a flow control zone.
                            """
                            return PyMenu(self.service, "/setup/dynamic_mesh/controls/contact_parameters/flow_control_parameters/create_flow_control_zone").execute(*args, **kwargs)
                        def solution_stabilization(self, *args, **kwargs):
                            """
                            Enable/disable the performance of additional iterations per time step and
                            the application of solution controls to improve the stability of the solver.
                            """
                            return PyMenu(self.service, "/setup/dynamic_mesh/controls/contact_parameters/flow_control_parameters/solution_stabilization").execute(*args, **kwargs)

                class smoothing_parameters(TUIMenu):
                    """
                    Enter the dynamic mesh smoothing menu.
                    """
                    def __init__(self, path, service):
                        self.path = path
                        self.service = service
                        super().__init__(path, service)
                    def diffusion_fvm(self, *args, **kwargs):
                        """
                        Set the numerical method used for diffusion-based smoothing.
                        """
                        return PyMenu(self.service, "/setup/dynamic_mesh/controls/smoothing_parameters/diffusion_fvm").execute(*args, **kwargs)
                    def boundary_distance_method(self, *args, **kwargs):
                        """
                        Set the method used to evaluate the boundary distance for the
                        diffusion coefficient calculation.
                        """
                        return PyMenu(self.service, "/setup/dynamic_mesh/controls/smoothing_parameters/boundary_distance_method").execute(*args, **kwargs)
                    def smoothing_method(self, *args, **kwargs):
                        """
                        Specify the smoothing method used by the dynamic mesh model.
                        """
                        return PyMenu(self.service, "/setup/dynamic_mesh/controls/smoothing_parameters/smoothing_method").execute(*args, **kwargs)
                    def spring_on_all_elements(self, *args, **kwargs):
                        """
                        Enable/disable spring-based smoothing for all cell shapes.
                        """
                        return PyMenu(self.service, "/setup/dynamic_mesh/controls/smoothing_parameters/spring_on_all_elements").execute(*args, **kwargs)
                    def skew_smooth_all_deforming_boundaries(self, *args, **kwargs):
                        """
                        Enable/disable skewness smoothing for all deforming
                        dynamic boundary zones. If disabled, only the deforming dynamic boundary zones are
                        smoothed which have smoothing explicitly enabled or use local face remeshing.
                        """
                        return PyMenu(self.service, "/setup/dynamic_mesh/controls/smoothing_parameters/skew_smooth_all_deforming_boundaries").execute(*args, **kwargs)
                    def laplace_node_relaxation(self, *args, **kwargs):
                        """
                        Set the Laplace boundary node relaxation factor.
                        """
                        return PyMenu(self.service, "/setup/dynamic_mesh/controls/smoothing_parameters/laplace_node_relaxation").execute(*args, **kwargs)
                    def max_iter(self, *args, **kwargs):
                        """
                        Set the maximum number of iterations for spring-based solver.
                        """
                        return PyMenu(self.service, "/setup/dynamic_mesh/controls/smoothing_parameters/max_iter").execute(*args, **kwargs)
                    def convergence_tolerance(self, *args, **kwargs):
                        """
                        Set the convergence tolerance for spring-based solver.
                        """
                        return PyMenu(self.service, "/setup/dynamic_mesh/controls/smoothing_parameters/convergence_tolerance").execute(*args, **kwargs)
                    def spring_on_simplex_elements(self, *args, **kwargs):
                        """
                        Enable/disable spring-based smoothing for tri/tet elements in mixed element zones.
                        """
                        return PyMenu(self.service, "/setup/dynamic_mesh/controls/smoothing_parameters/spring_on_simplex_elements").execute(*args, **kwargs)
                    def bnd_node_relaxation(self, *args, **kwargs):
                        """
                        Set the spring boundary node relaxation factor.
                        """
                        return PyMenu(self.service, "/setup/dynamic_mesh/controls/smoothing_parameters/bnd_node_relaxation").execute(*args, **kwargs)
                    def relative_convergence_tolerance(self, *args, **kwargs):
                        """
                        Set the relative residual convergence tolerance for diffusion-based (FVM) smoothing.
                        """
                        return PyMenu(self.service, "/setup/dynamic_mesh/controls/smoothing_parameters/relative_convergence_tolerance").execute(*args, **kwargs)
                    def amg_stabilization(self, *args, **kwargs):
                        """
                        Set the AMG stabilization method for mesh smoothing (FEM).
                        """
                        return PyMenu(self.service, "/setup/dynamic_mesh/controls/smoothing_parameters/amg_stabilization").execute(*args, **kwargs)
                    def poisson_ratio(self, *args, **kwargs):
                        """
                        Set the Poisson's ratio used by the linearly elastic solid model.
                        """
                        return PyMenu(self.service, "/setup/dynamic_mesh/controls/smoothing_parameters/poisson_ratio").execute(*args, **kwargs)
                    def smooth_from_reference_position(self, *args, **kwargs):
                        """
                        Enable smoothing from reference position.
                        """
                        return PyMenu(self.service, "/setup/dynamic_mesh/controls/smoothing_parameters/smooth_from_reference_position").execute(*args, **kwargs)
                    def verbosity(self, *args, **kwargs):
                        """
                        Set the verbosity for spring smoothing.
                        """
                        return PyMenu(self.service, "/setup/dynamic_mesh/controls/smoothing_parameters/verbosity").execute(*args, **kwargs)
                    def bnd_stiffness_factor(self, *args, **kwargs):
                        """
                        Set the stiffness factor for springs connected to boundary nodes.
                        """
                        return PyMenu(self.service, "/setup/dynamic_mesh/controls/smoothing_parameters/bnd_stiffness_factor").execute(*args, **kwargs)
                    def diffusion_coeff_function(self, *args, **kwargs):
                        """
                        Specify whether the diffusion coefficient is based on the
                        boundary distance or the cell volume.
                        """
                        return PyMenu(self.service, "/setup/dynamic_mesh/controls/smoothing_parameters/diffusion_coeff_function").execute(*args, **kwargs)
                    def skew_smooth_cell_skew_max(self, *args, **kwargs):
                        """
                        Set the cell skewness threshold above which cells will be smoothed
                        using the skewness method.
                        """
                        return PyMenu(self.service, "/setup/dynamic_mesh/controls/smoothing_parameters/skew_smooth_cell_skew_max").execute(*args, **kwargs)
                    def diffusion_coeff_parameter(self, *args, **kwargs):
                        """
                        Set the diffusion coefficient parameter used for diffusion-based smoothing.
                        """
                        return PyMenu(self.service, "/setup/dynamic_mesh/controls/smoothing_parameters/diffusion_coeff_parameter").execute(*args, **kwargs)
                    def skew_smooth_niter(self, *args, **kwargs):
                        """
                        Set the number of skewness-based smoothing cycles.
                        """
                        return PyMenu(self.service, "/setup/dynamic_mesh/controls/smoothing_parameters/skew_smooth_niter").execute(*args, **kwargs)
                    def constant_factor(self, *args, **kwargs):
                        """
                        Set the spring constant relaxation factor.
                        """
                        return PyMenu(self.service, "/setup/dynamic_mesh/controls/smoothing_parameters/constant_factor").execute(*args, **kwargs)
                    def skew_smooth_face_skew_max(self, *args, **kwargs):
                        """
                        Set the face skewness threshold above which deforming boundary faces
                        will be smoothed using the skewness method.
                        """
                        return PyMenu(self.service, "/setup/dynamic_mesh/controls/smoothing_parameters/skew_smooth_face_skew_max").execute(*args, **kwargs)

                class six_dof_parameters(TUIMenu):
                    """
                    Enter the dynamic mesh six-dof menu.
                    """
                    def __init__(self, path, service):
                        self.path = path
                        self.service = service
                        super().__init__(path, service)
                    def y_component_of_gravity(self, *args, **kwargs):
                        """
                        Specify y-component-of-gravity.
                        """
                        return PyMenu(self.service, "/setup/dynamic_mesh/controls/six_dof_parameters/y_component_of_gravity").execute(*args, **kwargs)
                    def z_component_of_gravity(self, *args, **kwargs):
                        """
                        Specify z-component-of-gravity.
                        """
                        return PyMenu(self.service, "/setup/dynamic_mesh/controls/six_dof_parameters/z_component_of_gravity").execute(*args, **kwargs)
                    def second_order(self, *args, **kwargs):
                        """
                        Enable/disable second order six DOF solver.
                        """
                        return PyMenu(self.service, "/setup/dynamic_mesh/controls/six_dof_parameters/second_order").execute(*args, **kwargs)
                    def create_properties(self, *args, **kwargs):
                        """
                        Create a set of Six DOF Properties.
                        """
                        return PyMenu(self.service, "/setup/dynamic_mesh/controls/six_dof_parameters/create_properties").execute(*args, **kwargs)
                    def list_properties(self, *args, **kwargs):
                        """
                        List Six DOF Properties.
                        """
                        return PyMenu(self.service, "/setup/dynamic_mesh/controls/six_dof_parameters/list_properties").execute(*args, **kwargs)
                    def x_component_of_gravity(self, *args, **kwargs):
                        """
                        Specify x-component-of-gravity.
                        """
                        return PyMenu(self.service, "/setup/dynamic_mesh/controls/six_dof_parameters/x_component_of_gravity").execute(*args, **kwargs)
                    def motion_history(self, *args, **kwargs):
                        """
                        Enable/disable writing position/orientation of six DOF zones to file.
                        """
                        return PyMenu(self.service, "/setup/dynamic_mesh/controls/six_dof_parameters/motion_history").execute(*args, **kwargs)
                    def motion_history_file_name(self, *args, **kwargs):
                        """
                        Location of six DOF motion history file.
                        """
                        return PyMenu(self.service, "/setup/dynamic_mesh/controls/six_dof_parameters/motion_history_file_name").execute(*args, **kwargs)
                    def delete_properties(self, *args, **kwargs):
                        """
                        Delete a set of Six DOF Properties.
                        """
                        return PyMenu(self.service, "/setup/dynamic_mesh/controls/six_dof_parameters/delete_properties").execute(*args, **kwargs)

            class transient_settings(TUIMenu):
                """
                Enter the dynamic mesh transient settings menu.
                """
                def __init__(self, path, service):
                    self.path = path
                    self.service = service
                    super().__init__(path, service)
                def allow_second_order(self, *args, **kwargs):
                    """
                    Enable/disable 2nd order transient scheme for dynamic mesh cases.
                    """
                    return PyMenu(self.service, "/setup/dynamic_mesh/transient_settings/allow_second_order").execute(*args, **kwargs)
                def verbosity(self, *args, **kwargs):
                    """
                    Enable/disable transient scheme verbosity for dynamic mesh cases.
                    """
                    return PyMenu(self.service, "/setup/dynamic_mesh/transient_settings/verbosity").execute(*args, **kwargs)

            class actions(TUIMenu):
                """
                Enter the dynamic mesh actions menu.
                """
                def __init__(self, path, service):
                    self.path = path
                    self.service = service
                    super().__init__(path, service)
                def remesh_cell_zone(self, *args, **kwargs):
                    """
                    Manually remesh cell zone with option to remesh adjacent dynamic face zones.
                    """
                    return PyMenu(self.service, "/setup/dynamic_mesh/actions/remesh_cell_zone").execute(*args, **kwargs)

            class events(TUIMenu):
                """
                Enter the dynamic mesh events menu.
                """
                def __init__(self, path, service):
                    self.path = path
                    self.service = service
                    super().__init__(path, service)
                def export_event_file(self, *args, **kwargs):
                    """
                    Export dynamic mesh events to file.
                    """
                    return PyMenu(self.service, "/setup/dynamic_mesh/events/export_event_file").execute(*args, **kwargs)
                def import_event_file(self, *args, **kwargs):
                    """
                    Import dynamic mesh event file.
                    """
                    return PyMenu(self.service, "/setup/dynamic_mesh/events/import_event_file").execute(*args, **kwargs)

        class mixing_planes(TUIMenu):
            """
            Enter the mixing planes menu.
            """
            def __init__(self, path, service):
                self.path = path
                self.service = service
                self.set = self.__class__.set(path + ["set"], service)
                super().__init__(path, service)
            def create(self, *args, **kwargs):
                """
                Create a mixing plane.
                """
                return PyMenu(self.service, "/setup/mixing_planes/create").execute(*args, **kwargs)
            def delete(self, *args, **kwargs):
                """
                Delete a mixing plane.
                """
                return PyMenu(self.service, "/setup/mixing_planes/delete").execute(*args, **kwargs)
            def list(self, *args, **kwargs):
                """
                List defined mixing plane(s).
                """
                return PyMenu(self.service, "/setup/mixing_planes/list").execute(*args, **kwargs)

            class set(TUIMenu):
                """
                Enter the mixing plane set menu.
                """
                def __init__(self, path, service):
                    self.path = path
                    self.service = service
                    self.conserve_swirl = self.__class__.conserve_swirl(path + ["conserve_swirl"], service)
                    self.conserve_total_enthalpy = self.__class__.conserve_total_enthalpy(path + ["conserve_total_enthalpy"], service)
                    super().__init__(path, service)
                def fix_pressure_level(self, *args, **kwargs):
                    """
                    Set fix pressure level using define/reference-pressure-location.
                    """
                    return PyMenu(self.service, "/setup/mixing_planes/set/fix_pressure_level").execute(*args, **kwargs)
                def under_relaxation(self, *args, **kwargs):
                    """
                    Set mixing plane under-relaxation factor.
                    """
                    return PyMenu(self.service, "/setup/mixing_planes/set/under_relaxation").execute(*args, **kwargs)
                def averaging_method(self, *args, **kwargs):
                    """
                    Set mixing plane profile averaging method.
                    """
                    return PyMenu(self.service, "/setup/mixing_planes/set/averaging_method").execute(*args, **kwargs)

                class conserve_swirl(TUIMenu):
                    """
                    Enter the mixing plane conserve-swirl menu.
                    """
                    def __init__(self, path, service):
                        self.path = path
                        self.service = service
                        super().__init__(path, service)
                    def report_swirl_integration(self, *args, **kwargs):
                        """
                        Report swirl integration (torque) on inflow and outflow zones.
                        """
                        return PyMenu(self.service, "/setup/mixing_planes/set/conserve_swirl/report_swirl_integration").execute(*args, **kwargs)
                    def enable(self, *args, **kwargs):
                        """
                        Enable/disable swirl conservation in mixing plane.
                        """
                        return PyMenu(self.service, "/setup/mixing_planes/set/conserve_swirl/enable").execute(*args, **kwargs)
                    def verbosity(self, *args, **kwargs):
                        """
                        Enable/disable verbosity in swirl conservation calculations.
                        """
                        return PyMenu(self.service, "/setup/mixing_planes/set/conserve_swirl/verbosity").execute(*args, **kwargs)

                class conserve_total_enthalpy(TUIMenu):
                    """
                    Enter the menu to set total enthalpy conservation in mixing plane menu.
                    """
                    def __init__(self, path, service):
                        self.path = path
                        self.service = service
                        super().__init__(path, service)
                    def verbosity(self, *args, **kwargs):
                        """
                        Enable/disable verbosity in total-enthalpy conservation calculations.
                        """
                        return PyMenu(self.service, "/setup/mixing_planes/set/conserve_total_enthalpy/verbosity").execute(*args, **kwargs)
                    def enable(self, *args, **kwargs):
                        """
                        Enable/disable total enthalpy conservation in mixing plane.
                        """
                        return PyMenu(self.service, "/setup/mixing_planes/set/conserve_total_enthalpy/enable").execute(*args, **kwargs)

        class materials(TUIMenu):
            """
            Enter the materials menu.
            """
            def __init__(self, path, service):
                self.path = path
                self.service = service
                self.data_base = self.__class__.data_base(path + ["data_base"], service)
                super().__init__(path, service)
            def list_materials(self, *args, **kwargs):
                """
                List all locally-stored materials.
                """
                return PyMenu(self.service, "/setup/materials/list_materials").execute(*args, **kwargs)
            def delete(self, *args, **kwargs):
                """
                Delete a material from local storage.
                """
                return PyMenu(self.service, "/setup/materials/delete").execute(*args, **kwargs)
            def change_create(self, *args, **kwargs):
                """
                Change the properties of a locally-stored material or create a new material.
                """
                return PyMenu(self.service, "/setup/materials/change_create").execute(*args, **kwargs)
            def list_properties(self, *args, **kwargs):
                """
                List the properties of a locally-stored material.
                """
                return PyMenu(self.service, "/setup/materials/list_properties").execute(*args, **kwargs)
            def copy(self, *args, **kwargs):
                """
                Copy a material from the database.
                """
                return PyMenu(self.service, "/setup/materials/copy").execute(*args, **kwargs)
            def copy_by_formula(self, *args, **kwargs):
                """
                Copy a material from the database by formula.
                """
                return PyMenu(self.service, "/setup/materials/copy_by_formula").execute(*args, **kwargs)

            class data_base(TUIMenu):
                """
                Enter the database menu.
                """
                def __init__(self, path, service):
                    self.path = path
                    self.service = service
                    super().__init__(path, service)
                def new(self, *args, **kwargs):
                    """
                    Define a new material.
                    """
                    return PyMenu(self.service, "/setup/materials/data_base/new").execute(*args, **kwargs)
                def edit(self, *args, **kwargs):
                    """
                    Edit a material.
                    """
                    return PyMenu(self.service, "/setup/materials/data_base/edit").execute(*args, **kwargs)
                def list_properties(self, *args, **kwargs):
                    """
                    List the properties of a material in the database.
                    """
                    return PyMenu(self.service, "/setup/materials/data_base/list_properties").execute(*args, **kwargs)
                def list_materials(self, *args, **kwargs):
                    """
                    List all materials in the database.
                    """
                    return PyMenu(self.service, "/setup/materials/data_base/list_materials").execute(*args, **kwargs)
                def database_type(self, *args, **kwargs):
                    """
                    Set the database type.
                    """
                    return PyMenu(self.service, "/setup/materials/data_base/database_type").execute(*args, **kwargs)
                def save(self, *args, **kwargs):
                    """
                    Save user-defined database.
                    """
                    return PyMenu(self.service, "/setup/materials/data_base/save").execute(*args, **kwargs)

        class turbo_model(TUIMenu):
            """
            Turbo features menu.
            """
            def __init__(self, path, service):
                self.path = path
                self.service = service
                self.turbo_topology = self.__class__.turbo_topology(path + ["turbo_topology"], service)
                self.general_turbo_interface_settings = self.__class__.general_turbo_interface_settings(path + ["general_turbo_interface_settings"], service)
                self.blade_flutter_harmonics = self.__class__.blade_flutter_harmonics(path + ["blade_flutter_harmonics"], service)
                super().__init__(path, service)
            def list_phaselag_state(self, *args, **kwargs):
                """
                List all phaselag related case settings.
                """
                return PyMenu(self.service, "/setup/turbo_model/list_phaselag_state").execute(*args, **kwargs)
            def list_turbomachine_description(self, *args, **kwargs):
                """
                List turbomachine description.
                """
                return PyMenu(self.service, "/setup/turbo_model/list_turbomachine_description").execute(*args, **kwargs)
            def create_graphics_spectral_content(self, *args, **kwargs):
                """
                Define post-processing related spectral content.
                """
                return PyMenu(self.service, "/setup/turbo_model/create_graphics_spectral_content").execute(*args, **kwargs)
            def list_graphics_spectral_content(self, *args, **kwargs):
                """
                List post-processing related spectral content.
                """
                return PyMenu(self.service, "/setup/turbo_model/list_graphics_spectral_content").execute(*args, **kwargs)
            def delete_graphics_spectral_content(self, *args, **kwargs):
                """
                Delete post-processing related spectral content.
                """
                return PyMenu(self.service, "/setup/turbo_model/delete_graphics_spectral_content").execute(*args, **kwargs)
            def enable_turbo_model(self, *args, **kwargs):
                """
                Enable/disable turbo model menu.
                """
                return PyMenu(self.service, "/setup/turbo_model/enable_turbo_model").execute(*args, **kwargs)
            def turbo_create(self, *args, **kwargs):
                """
                Create a general turbo interface.
                """
                return PyMenu(self.service, "/setup/turbo_model/turbo_create").execute(*args, **kwargs)
            def make_phaselag_from_boundaries(self, *args, **kwargs):
                """
                Make interface zones phase lagged.
                """
                return PyMenu(self.service, "/setup/turbo_model/make_phaselag_from_boundaries").execute(*args, **kwargs)
            def delete_turbomachine_description(self, *args, **kwargs):
                """
                Delete turbomachine description.
                """
                return PyMenu(self.service, "/setup/turbo_model/delete_turbomachine_description").execute(*args, **kwargs)
            def turbo_interface_check(self, *args, **kwargs):
                """
                Check General Turbo Interface and Phase-lag.
                """
                return PyMenu(self.service, "/setup/turbo_model/turbo_interface_check").execute(*args, **kwargs)
            def phaselag_extra_settings(self, *args, **kwargs):
                """
                Define phaselag related extra settings.
                """
                return PyMenu(self.service, "/setup/turbo_model/phaselag_extra_settings").execute(*args, **kwargs)
            def append_graphics_spectral_content(self, *args, **kwargs):
                """
                Define post-processing related spectral content.
                """
                return PyMenu(self.service, "/setup/turbo_model/append_graphics_spectral_content").execute(*args, **kwargs)
            def append_phaselag_spectral_content(self, *args, **kwargs):
                """
                Define phaselag related spectral content.
                """
                return PyMenu(self.service, "/setup/turbo_model/append_phaselag_spectral_content").execute(*args, **kwargs)
            def delete_phaselag_spectral_content(self, *args, **kwargs):
                """
                Delete phaselag related spectral content.
                """
                return PyMenu(self.service, "/setup/turbo_model/delete_phaselag_spectral_content").execute(*args, **kwargs)
            def separate_nonoverlapping_interface_boundary(self, *args, **kwargs):
                """
                Split a general turbo interface non-overlapping zone.
                """
                return PyMenu(self.service, "/setup/turbo_model/separate_nonoverlapping_interface_boundary").execute(*args, **kwargs)
            def graphics_extra_settings(self, *args, **kwargs):
                """
                Define phaselag related extra settings.
                """
                return PyMenu(self.service, "/setup/turbo_model/graphics_extra_settings").execute(*args, **kwargs)
            def make_phaselag_from_periodic(self, *args, **kwargs):
                """
                Convert periodic interface to phase lagged.
                """
                return PyMenu(self.service, "/setup/turbo_model/make_phaselag_from_periodic").execute(*args, **kwargs)
            def create_turbomachine_description(self, *args, **kwargs):
                """
                Define turbomachine description.
                """
                return PyMenu(self.service, "/setup/turbo_model/create_turbomachine_description").execute(*args, **kwargs)
            def blade_flutter_row(self, *args, **kwargs):
                """
                Define the periodic displacement row.
                """
                return PyMenu(self.service, "/setup/turbo_model/blade_flutter_row").execute(*args, **kwargs)
            def create_phaselag_spectral_content(self, *args, **kwargs):
                """
                Define phaselag related spectral content.
                """
                return PyMenu(self.service, "/setup/turbo_model/create_phaselag_spectral_content").execute(*args, **kwargs)
            def isentropic_efficiency(self, *args, **kwargs):
                """
                Compute isentropic efficiency using general property functions for enthalpy.
                """
                return PyMenu(self.service, "/setup/turbo_model/isentropic_efficiency").execute(*args, **kwargs)

            class turbo_topology(TUIMenu):
                """
                Define turbo topology.
                """
                def __init__(self, path, service):
                    self.path = path
                    self.service = service
                    super().__init__(path, service)
                def delete(self, *args, **kwargs):
                    """
                    Delete a turbo topology.
                    """
                    return PyMenu(self.service, "/setup/turbo_model/turbo_topology/delete").execute(*args, **kwargs)
                def define_topology(self, *args, **kwargs):
                    """
                    Define a turbo topology.
                    """
                    return PyMenu(self.service, "/setup/turbo_model/turbo_topology/define_topology").execute(*args, **kwargs)
                def projection_method(self, *args, **kwargs):
                    """
                    Set 2D projection method.
                    """
                    return PyMenu(self.service, "/setup/turbo_model/turbo_topology/projection_method").execute(*args, **kwargs)
                def mesh_method(self, *args, **kwargs):
                    """
                    Set turbo structured mesh generation method.
                    """
                    return PyMenu(self.service, "/setup/turbo_model/turbo_topology/mesh_method").execute(*args, **kwargs)
                def search_method(self, *args, **kwargs):
                    """
                    Set search method for a topology.
                    """
                    return PyMenu(self.service, "/setup/turbo_model/turbo_topology/search_method").execute(*args, **kwargs)

            class general_turbo_interface_settings(TUIMenu):
                """
                Set General Turbo Interface options.
                """
                def __init__(self, path, service):
                    self.path = path
                    self.service = service
                    self.mixing_plane_model_settings = self.__class__.mixing_plane_model_settings(path + ["mixing_plane_model_settings"], service)
                    super().__init__(path, service)
                def expert(self, *args, **kwargs):
                    """
                    Set the expert parameters for turbo interfaces.
                    """
                    return PyMenu(self.service, "/setup/turbo_model/general_turbo_interface_settings/expert").execute(*args, **kwargs)

                class mixing_plane_model_settings(TUIMenu):
                    """
                    Set the mixing plane model settings.
                    """
                    def __init__(self, path, service):
                        self.path = path
                        self.service = service
                        super().__init__(path, service)
                    def averaging_method(self, *args, **kwargs):
                        """
                        Set the averaging method for the mixing.
                        """
                        return PyMenu(self.service, "/setup/turbo_model/general_turbo_interface_settings/mixing_plane_model_settings/averaging_method").execute(*args, **kwargs)
                    def list_mixing_planes(self, *args, **kwargs):
                        """
                        List the settings of mixing planes in the case.
                        """
                        return PyMenu(self.service, "/setup/turbo_model/general_turbo_interface_settings/mixing_plane_model_settings/list_mixing_planes").execute(*args, **kwargs)
                    def number_of_bands(self, *args, **kwargs):
                        """
                        Set the maximum number of bands to be used for mixing.
                        """
                        return PyMenu(self.service, "/setup/turbo_model/general_turbo_interface_settings/mixing_plane_model_settings/number_of_bands").execute(*args, **kwargs)
                    def bands_type(self, *args, **kwargs):
                        """
                        To set the mixing plane bands type.
                        """
                        return PyMenu(self.service, "/setup/turbo_model/general_turbo_interface_settings/mixing_plane_model_settings/bands_type").execute(*args, **kwargs)
                    def mixing_set_constraint(self, *args, **kwargs):
                        """
                        To set the mixing of primitive or total variable approach.
                        """
                        return PyMenu(self.service, "/setup/turbo_model/general_turbo_interface_settings/mixing_plane_model_settings/mixing_set_constraint").execute(*args, **kwargs)

            class blade_flutter_harmonics(TUIMenu):
                """
                Enter the blade flutter harmonics menu.
                """
                def __init__(self, path, service):
                    self.path = path
                    self.service = service
                    super().__init__(path, service)
                def write_aerodamping_vs_nodal_diameter(self, *args, **kwargs):
                    """
                    Reads report definition file and Writes influence coefficient aerodynamic damping values vs nodal diameter.
                    """
                    return PyMenu(self.service, "/setup/turbo_model/blade_flutter_harmonics/write_aerodamping_vs_nodal_diameter").execute(*args, **kwargs)
                def enable_harmonic_exports(self, *args, **kwargs):
                    """
                    Calculates/Deletes flutter harmonic export data.
                    """
                    return PyMenu(self.service, "/setup/turbo_model/blade_flutter_harmonics/enable_harmonic_exports").execute(*args, **kwargs)
                def write_harmonic_exports(self, *args, **kwargs):
                    """
                    Writes harmonic export data.
                    """
                    return PyMenu(self.service, "/setup/turbo_model/blade_flutter_harmonics/write_harmonic_exports").execute(*args, **kwargs)

        class operating_conditions(TUIMenu):
            """
            Enter the define operating conditions menu.
            """
            def __init__(self, path, service):
                self.path = path
                self.service = service
                super().__init__(path, service)
            def operating_density(self, *args, **kwargs):
                """
                Multiphase flow Operating Density menu.
                """
                return PyMenu(self.service, "/setup/operating_conditions/operating_density").execute(*args, **kwargs)
            def reference_pressure_method(self, *args, **kwargs):
                """
                Choosing reference pressure type.
                """
                return PyMenu(self.service, "/setup/operating_conditions/reference_pressure_method").execute(*args, **kwargs)
            def operating_temperature(self, *args, **kwargs):
                """
                Set the operating temperature for Boussinesq.
                """
                return PyMenu(self.service, "/setup/operating_conditions/operating_temperature").execute(*args, **kwargs)
            def operating_pressure(self, *args, **kwargs):
                """
                Set the operating pressure.
                """
                return PyMenu(self.service, "/setup/operating_conditions/operating_pressure").execute(*args, **kwargs)
            def gravity(self, *args, **kwargs):
                """
                Set gravitational acceleration.
                """
                return PyMenu(self.service, "/setup/operating_conditions/gravity").execute(*args, **kwargs)
            def used_ref_pressure_location(self, *args, **kwargs):
                """
                See the actual coordinates of reference pressure used.
                """
                return PyMenu(self.service, "/setup/operating_conditions/used_ref_pressure_location").execute(*args, **kwargs)
            def use_inlet_temperature_for_operating_density(self, *args, **kwargs):
                """
                Use Inlet Temperature to calculate Opearating Density.
                """
                return PyMenu(self.service, "/setup/operating_conditions/use_inlet_temperature_for_operating_density").execute(*args, **kwargs)
            def gravity_mrf_behavior(self, *args, **kwargs):
                """
                Enable/disable the fix of gravity vector in a stationary reference frame.
                """
                return PyMenu(self.service, "/setup/operating_conditions/gravity_mrf_behavior").execute(*args, **kwargs)
            def set_state(self, *args, **kwargs):
                """
                Select state for real gas EOS subcritical condition.
                """
                return PyMenu(self.service, "/setup/operating_conditions/set_state").execute(*args, **kwargs)
            def reference_pressure_location(self, *args, **kwargs):
                """
                Set coordinates of reference pressure.
                """
                return PyMenu(self.service, "/setup/operating_conditions/reference_pressure_location").execute(*args, **kwargs)

        class reference_frames(TUIMenu):
            """
            Manage reference frames.
            """
            def __init__(self, path, service):
                self.path = path
                self.service = service
                super().__init__(path, service)
            def delete(self, *args, **kwargs):
                """
                Delete an object.
                """
                return PyMenu(self.service, "/setup/reference_frames/delete").execute(*args, **kwargs)
            def list(self, *args, **kwargs):
                """
                List objects.
                """
                return PyMenu(self.service, "/setup/reference_frames/list").execute(*args, **kwargs)
            def hide(self, *args, **kwargs):
                """
                Hide Reference Frame.
                """
                return PyMenu(self.service, "/setup/reference_frames/hide").execute(*args, **kwargs)
            def display(self, *args, **kwargs):
                """
                Display Reference Frame.
                """
                return PyMenu(self.service, "/setup/reference_frames/display").execute(*args, **kwargs)
            def display_edit(self, *args, **kwargs):
                """
                Display and edit reference frame from graphics.
                """
                return PyMenu(self.service, "/setup/reference_frames/display_edit").execute(*args, **kwargs)
            def list_properties(self, *args, **kwargs):
                """
                List properties of an object.
                """
                return PyMenu(self.service, "/setup/reference_frames/list_properties").execute(*args, **kwargs)
            def add(self, *args, **kwargs):
                """
                Add a new object.
                """
                return PyMenu(self.service, "/setup/reference_frames/add").execute(*args, **kwargs)
            def edit(self, *args, **kwargs):
                """
                Edit an object.
                """
                return PyMenu(self.service, "/setup/reference_frames/edit").execute(*args, **kwargs)

        class reference_values(TUIMenu):
            """
            Reference value menu.
            """
            def __init__(self, path, service):
                self.path = path
                self.service = service
                self.compute = self.__class__.compute(path + ["compute"], service)
                super().__init__(path, service)
            def area(self, *args, **kwargs):
                """
                Set reference area for normalization.
                """
                return PyMenu(self.service, "/setup/reference_values/area").execute(*args, **kwargs)
            def temperature(self, *args, **kwargs):
                """
                Set reference temperature for normalization.
                """
                return PyMenu(self.service, "/setup/reference_values/temperature").execute(*args, **kwargs)
            def list(self, *args, **kwargs):
                """
                List current reference values.
                """
                return PyMenu(self.service, "/setup/reference_values/list").execute(*args, **kwargs)
            def viscosity(self, *args, **kwargs):
                """
                Set reference viscosity for normalization.
                """
                return PyMenu(self.service, "/setup/reference_values/viscosity").execute(*args, **kwargs)
            def enthalpy(self, *args, **kwargs):
                """
                Set reference enthalpy for enthalpy damping and normalization.
                """
                return PyMenu(self.service, "/setup/reference_values/enthalpy").execute(*args, **kwargs)
            def length(self, *args, **kwargs):
                """
                Set reference length for normalization.
                """
                return PyMenu(self.service, "/setup/reference_values/length").execute(*args, **kwargs)
            def velocity(self, *args, **kwargs):
                """
                Set reference velocity for normalization.
                """
                return PyMenu(self.service, "/setup/reference_values/velocity").execute(*args, **kwargs)
            def depth(self, *args, **kwargs):
                """
                Set reference depth for volume calculation.
                """
                return PyMenu(self.service, "/setup/reference_values/depth").execute(*args, **kwargs)
            def pressure(self, *args, **kwargs):
                """
                Set reference pressure for normalization.
                """
                return PyMenu(self.service, "/setup/reference_values/pressure").execute(*args, **kwargs)
            def yplus(self, *args, **kwargs):
                """
                Set reference yplus for normalization.
                """
                return PyMenu(self.service, "/setup/reference_values/yplus").execute(*args, **kwargs)
            def zone(self, *args, **kwargs):
                """
                Set reference zone.
                """
                return PyMenu(self.service, "/setup/reference_values/zone").execute(*args, **kwargs)
            def density(self, *args, **kwargs):
                """
                Set reference density for normalization.
                """
                return PyMenu(self.service, "/setup/reference_values/density").execute(*args, **kwargs)

            class compute(TUIMenu):
                """
                Enter the compute menu.
                """
                def __init__(self, path, service):
                    self.path = path
                    self.service = service
                    super().__init__(path, service)
                def porous_jump(self, *args, **kwargs):
                    """
                    Compute reference values from a zone of this type.
                    """
                    return PyMenu(self.service, "/setup/reference_values/compute/porous_jump").execute(*args, **kwargs)
                def overset(self, *args, **kwargs):
                    """
                    Compute reference values from a zone of this type.
                    """
                    return PyMenu(self.service, "/setup/reference_values/compute/overset").execute(*args, **kwargs)
                def solid(self, *args, **kwargs):
                    """
                    Compute reference values from a zone of this type.
                    """
                    return PyMenu(self.service, "/setup/reference_values/compute/solid").execute(*args, **kwargs)
                def outlet_vent(self, *args, **kwargs):
                    """
                    Compute reference values from a zone of this type.
                    """
                    return PyMenu(self.service, "/setup/reference_values/compute/outlet_vent").execute(*args, **kwargs)
                def interface(self, *args, **kwargs):
                    """
                    Compute reference values from a zone of this type.
                    """
                    return PyMenu(self.service, "/setup/reference_values/compute/interface").execute(*args, **kwargs)
                def periodic(self, *args, **kwargs):
                    """
                    Compute reference values from a zone of this type.
                    """
                    return PyMenu(self.service, "/setup/reference_values/compute/periodic").execute(*args, **kwargs)
                def geometry(self, *args, **kwargs):
                    """
                    Compute reference values from a zone of this type.
                    """
                    return PyMenu(self.service, "/setup/reference_values/compute/geometry").execute(*args, **kwargs)
                def degassing(self, *args, **kwargs):
                    """
                    Compute reference values from a zone of this type.
                    """
                    return PyMenu(self.service, "/setup/reference_values/compute/degassing").execute(*args, **kwargs)
                def inlet_vent(self, *args, **kwargs):
                    """
                    Compute reference values from a zone of this type.
                    """
                    return PyMenu(self.service, "/setup/reference_values/compute/inlet_vent").execute(*args, **kwargs)
                def network_end(self, *args, **kwargs):
                    """
                    Compute reference values from a zone of this type.
                    """
                    return PyMenu(self.service, "/setup/reference_values/compute/network_end").execute(*args, **kwargs)
                def pressure_inlet(self, *args, **kwargs):
                    """
                    Compute reference values from a zone of this type.
                    """
                    return PyMenu(self.service, "/setup/reference_values/compute/pressure_inlet").execute(*args, **kwargs)
                def fluid(self, *args, **kwargs):
                    """
                    Compute reference values from a zone of this type.
                    """
                    return PyMenu(self.service, "/setup/reference_values/compute/fluid").execute(*args, **kwargs)
                def recirculation_inlet(self, *args, **kwargs):
                    """
                    Compute reference values from a zone of this type.
                    """
                    return PyMenu(self.service, "/setup/reference_values/compute/recirculation_inlet").execute(*args, **kwargs)
                def interior(self, *args, **kwargs):
                    """
                    Compute reference values from a zone of this type.
                    """
                    return PyMenu(self.service, "/setup/reference_values/compute/interior").execute(*args, **kwargs)
                def network(self, *args, **kwargs):
                    """
                    Compute reference values from a zone of this type.
                    """
                    return PyMenu(self.service, "/setup/reference_values/compute/network").execute(*args, **kwargs)
                def fan(self, *args, **kwargs):
                    """
                    Compute reference values from a zone of this type.
                    """
                    return PyMenu(self.service, "/setup/reference_values/compute/fan").execute(*args, **kwargs)
                def outflow(self, *args, **kwargs):
                    """
                    Compute reference values from a zone of this type.
                    """
                    return PyMenu(self.service, "/setup/reference_values/compute/outflow").execute(*args, **kwargs)
                def shadow(self, *args, **kwargs):
                    """
                    Compute reference values from a zone of this type.
                    """
                    return PyMenu(self.service, "/setup/reference_values/compute/shadow").execute(*args, **kwargs)
                def velocity_inlet(self, *args, **kwargs):
                    """
                    Compute reference values from a zone of this type.
                    """
                    return PyMenu(self.service, "/setup/reference_values/compute/velocity_inlet").execute(*args, **kwargs)
                def radiator(self, *args, **kwargs):
                    """
                    Compute reference values from a zone of this type.
                    """
                    return PyMenu(self.service, "/setup/reference_values/compute/radiator").execute(*args, **kwargs)
                def wall(self, *args, **kwargs):
                    """
                    Compute reference values from a zone of this type.
                    """
                    return PyMenu(self.service, "/setup/reference_values/compute/wall").execute(*args, **kwargs)
                def pressure_outlet(self, *args, **kwargs):
                    """
                    Compute reference values from a zone of this type.
                    """
                    return PyMenu(self.service, "/setup/reference_values/compute/pressure_outlet").execute(*args, **kwargs)
                def mass_flow_inlet(self, *args, **kwargs):
                    """
                    Compute reference values from a zone of this type.
                    """
                    return PyMenu(self.service, "/setup/reference_values/compute/mass_flow_inlet").execute(*args, **kwargs)
                def dummy_entry(self, *args, **kwargs):
                    """
                    .
                    """
                    return PyMenu(self.service, "/setup/reference_values/compute/dummy_entry").execute(*args, **kwargs)
                def rans_les_interface(self, *args, **kwargs):
                    """
                    Compute reference values from a zone of this type.
                    """
                    return PyMenu(self.service, "/setup/reference_values/compute/rans_les_interface").execute(*args, **kwargs)
                def intake_fan(self, *args, **kwargs):
                    """
                    Compute reference values from a zone of this type.
                    """
                    return PyMenu(self.service, "/setup/reference_values/compute/intake_fan").execute(*args, **kwargs)
                def axis(self, *args, **kwargs):
                    """
                    Compute reference values from a zone of this type.
                    """
                    return PyMenu(self.service, "/setup/reference_values/compute/axis").execute(*args, **kwargs)
                def symmetry(self, *args, **kwargs):
                    """
                    Compute reference values from a zone of this type.
                    """
                    return PyMenu(self.service, "/setup/reference_values/compute/symmetry").execute(*args, **kwargs)
                def exhaust_fan(self, *args, **kwargs):
                    """
                    Compute reference values from a zone of this type.
                    """
                    return PyMenu(self.service, "/setup/reference_values/compute/exhaust_fan").execute(*args, **kwargs)
                def pressure_far_field(self, *args, **kwargs):
                    """
                    Compute reference values from a zone of this type.
                    """
                    return PyMenu(self.service, "/setup/reference_values/compute/pressure_far_field").execute(*args, **kwargs)
                def mass_flow_outlet(self, *args, **kwargs):
                    """
                    Compute reference values from a zone of this type.
                    """
                    return PyMenu(self.service, "/setup/reference_values/compute/mass_flow_outlet").execute(*args, **kwargs)
                def recirculation_outlet(self, *args, **kwargs):
                    """
                    Compute reference values from a zone of this type.
                    """
                    return PyMenu(self.service, "/setup/reference_values/compute/recirculation_outlet").execute(*args, **kwargs)

        class boundary_conditions(TUIMenu):
            """
            Enter the boudary conditions menu.
            """
            def __init__(self, path, service):
                self.path = path
                self.service = service
                self.set = self.__class__.set(path + ["set"], service)
                self.rename_zone = self.__class__.rename_zone(path + ["rename_zone"], service)
                self.query = self.__class__.query(path + ["query"], service)
                self.expert = self.__class__.expert(path + ["expert"], service)
                self.modify_zones = self.__class__.modify_zones(path + ["modify_zones"], service)
                self.bc_settings = self.__class__.bc_settings(path + ["bc_settings"], service)
                self.profiles = self.__class__.profiles(path + ["profiles"], service)
                super().__init__(path, service)
            def interface(self, *args, **kwargs):
                """
                Set boundary conditions for a zone of this type.
                """
                return PyMenu(self.service, "/setup/boundary_conditions/interface").execute(*args, **kwargs)
            def intake_fan(self, *args, **kwargs):
                """
                Set boundary conditions for a zone of this type.
                """
                return PyMenu(self.service, "/setup/boundary_conditions/intake_fan").execute(*args, **kwargs)
            def periodic(self, *args, **kwargs):
                """
                Set boundary conditions for a zone of this type.
                """
                return PyMenu(self.service, "/setup/boundary_conditions/periodic").execute(*args, **kwargs)
            def zone_type(self, *args, **kwargs):
                """
                Set a zone's type.
                """
                return PyMenu(self.service, "/setup/boundary_conditions/zone_type").execute(*args, **kwargs)
            def pressure_far_field(self, *args, **kwargs):
                """
                Set boundary conditions for a zone of this type.
                """
                return PyMenu(self.service, "/setup/boundary_conditions/pressure_far_field").execute(*args, **kwargs)
            def geometry(self, *args, **kwargs):
                """
                Set boundary conditions for a zone of this type.
                """
                return PyMenu(self.service, "/setup/boundary_conditions/geometry").execute(*args, **kwargs)
            def shadow(self, *args, **kwargs):
                """
                Set boundary conditions for a zone of this type.
                """
                return PyMenu(self.service, "/setup/boundary_conditions/shadow").execute(*args, **kwargs)
            def fluid(self, *args, **kwargs):
                """
                Set boundary conditions for a zone of this type.
                """
                return PyMenu(self.service, "/setup/boundary_conditions/fluid").execute(*args, **kwargs)
            def outflow(self, *args, **kwargs):
                """
                Set boundary conditions for a zone of this type.
                """
                return PyMenu(self.service, "/setup/boundary_conditions/outflow").execute(*args, **kwargs)
            def inlet_vent(self, *args, **kwargs):
                """
                Set boundary conditions for a zone of this type.
                """
                return PyMenu(self.service, "/setup/boundary_conditions/inlet_vent").execute(*args, **kwargs)
            def radiator(self, *args, **kwargs):
                """
                Set boundary conditions for a zone of this type.
                """
                return PyMenu(self.service, "/setup/boundary_conditions/radiator").execute(*args, **kwargs)
            def list_zones(self, *args, **kwargs):
                """
                List zone IDs, types, kinds, and names.
                """
                return PyMenu(self.service, "/setup/boundary_conditions/list_zones").execute(*args, **kwargs)
            def mass_flow_outlet(self, *args, **kwargs):
                """
                Set boundary conditions for a zone of this type.
                """
                return PyMenu(self.service, "/setup/boundary_conditions/mass_flow_outlet").execute(*args, **kwargs)
            def copy_bc(self, *args, **kwargs):
                """
                Copy boundary conditions to another zone.
                """
                return PyMenu(self.service, "/setup/boundary_conditions/copy_bc").execute(*args, **kwargs)
            def symmetry(self, *args, **kwargs):
                """
                Set boundary conditions for a zone of this type.
                """
                return PyMenu(self.service, "/setup/boundary_conditions/symmetry").execute(*args, **kwargs)
            def recirculation_outlet(self, *args, **kwargs):
                """
                Set boundary conditions for a zone of this type.
                """
                return PyMenu(self.service, "/setup/boundary_conditions/recirculation_outlet").execute(*args, **kwargs)
            def zone_name(self, *args, **kwargs):
                """
                Give a zone a new name.
                """
                return PyMenu(self.service, "/setup/boundary_conditions/zone_name").execute(*args, **kwargs)
            def porous_jump(self, *args, **kwargs):
                """
                Set boundary conditions for a zone of this type.
                """
                return PyMenu(self.service, "/setup/boundary_conditions/porous_jump").execute(*args, **kwargs)
            def degassing(self, *args, **kwargs):
                """
                Set boundary conditions for a zone of this type.
                """
                return PyMenu(self.service, "/setup/boundary_conditions/degassing").execute(*args, **kwargs)
            def network_end(self, *args, **kwargs):
                """
                Set boundary conditions for a zone of this type.
                """
                return PyMenu(self.service, "/setup/boundary_conditions/network_end").execute(*args, **kwargs)
            def recirculation_inlet(self, *args, **kwargs):
                """
                Set boundary conditions for a zone of this type.
                """
                return PyMenu(self.service, "/setup/boundary_conditions/recirculation_inlet").execute(*args, **kwargs)
            def rans_les_interface(self, *args, **kwargs):
                """
                Set boundary conditions for a zone of this type.
                """
                return PyMenu(self.service, "/setup/boundary_conditions/rans_les_interface").execute(*args, **kwargs)
            def mass_flow_inlet(self, *args, **kwargs):
                """
                Set boundary conditions for a zone of this type.
                """
                return PyMenu(self.service, "/setup/boundary_conditions/mass_flow_inlet").execute(*args, **kwargs)
            def overset(self, *args, **kwargs):
                """
                Set boundary conditions for a zone of this type.
                """
                return PyMenu(self.service, "/setup/boundary_conditions/overset").execute(*args, **kwargs)
            def solid(self, *args, **kwargs):
                """
                Set boundary conditions for a zone of this type.
                """
                return PyMenu(self.service, "/setup/boundary_conditions/solid").execute(*args, **kwargs)
            def outlet_vent(self, *args, **kwargs):
                """
                Set boundary conditions for a zone of this type.
                """
                return PyMenu(self.service, "/setup/boundary_conditions/outlet_vent").execute(*args, **kwargs)
            def axis(self, *args, **kwargs):
                """
                Set boundary conditions for a zone of this type.
                """
                return PyMenu(self.service, "/setup/boundary_conditions/axis").execute(*args, **kwargs)
            def velocity_inlet(self, *args, **kwargs):
                """
                Set boundary conditions for a zone of this type.
                """
                return PyMenu(self.service, "/setup/boundary_conditions/velocity_inlet").execute(*args, **kwargs)
            def pressure_inlet(self, *args, **kwargs):
                """
                Set boundary conditions for a zone of this type.
                """
                return PyMenu(self.service, "/setup/boundary_conditions/pressure_inlet").execute(*args, **kwargs)
            def pressure_outlet(self, *args, **kwargs):
                """
                Set boundary conditions for a zone of this type.
                """
                return PyMenu(self.service, "/setup/boundary_conditions/pressure_outlet").execute(*args, **kwargs)
            def wall(self, *args, **kwargs):
                """
                Set boundary conditions for a zone of this type.
                """
                return PyMenu(self.service, "/setup/boundary_conditions/wall").execute(*args, **kwargs)
            def fan(self, *args, **kwargs):
                """
                Set boundary conditions for a zone of this type.
                """
                return PyMenu(self.service, "/setup/boundary_conditions/fan").execute(*args, **kwargs)
            def network(self, *args, **kwargs):
                """
                Set boundary conditions for a zone of this type.
                """
                return PyMenu(self.service, "/setup/boundary_conditions/network").execute(*args, **kwargs)
            def exhaust_fan(self, *args, **kwargs):
                """
                Set boundary conditions for a zone of this type.
                """
                return PyMenu(self.service, "/setup/boundary_conditions/exhaust_fan").execute(*args, **kwargs)
            def interior(self, *args, **kwargs):
                """
                Set boundary conditions for a zone of this type.
                """
                return PyMenu(self.service, "/setup/boundary_conditions/interior").execute(*args, **kwargs)

            class set(TUIMenu):
                """
                Enter the set boundary conditions menu.
                """
                def __init__(self, path, service):
                    self.path = path
                    self.service = service
                    super().__init__(path, service)
                def symmetry(self, *args, **kwargs):
                    """
                    Set boundary conditions for a zone or multiple zones of this type.
                    """
                    return PyMenu(self.service, "/setup/boundary_conditions/set/symmetry").execute(*args, **kwargs)
                def shadow(self, *args, **kwargs):
                    """
                    Set boundary conditions for a zone or multiple zones of this type.
                    """
                    return PyMenu(self.service, "/setup/boundary_conditions/set/shadow").execute(*args, **kwargs)
                def exhaust_fan(self, *args, **kwargs):
                    """
                    Set boundary conditions for a zone or multiple zones of this type.
                    """
                    return PyMenu(self.service, "/setup/boundary_conditions/set/exhaust_fan").execute(*args, **kwargs)
                def radiator(self, *args, **kwargs):
                    """
                    Set boundary conditions for a zone or multiple zones of this type.
                    """
                    return PyMenu(self.service, "/setup/boundary_conditions/set/radiator").execute(*args, **kwargs)
                def outflow(self, *args, **kwargs):
                    """
                    Set boundary conditions for a zone or multiple zones of this type.
                    """
                    return PyMenu(self.service, "/setup/boundary_conditions/set/outflow").execute(*args, **kwargs)
                def network_end(self, *args, **kwargs):
                    """
                    Set boundary conditions for a zone or multiple zones of this type.
                    """
                    return PyMenu(self.service, "/setup/boundary_conditions/set/network_end").execute(*args, **kwargs)
                def velocity_inlet(self, *args, **kwargs):
                    """
                    Set boundary conditions for a zone or multiple zones of this type.
                    """
                    return PyMenu(self.service, "/setup/boundary_conditions/set/velocity_inlet").execute(*args, **kwargs)
                def recirculation_outlet(self, *args, **kwargs):
                    """
                    Set boundary conditions for a zone or multiple zones of this type.
                    """
                    return PyMenu(self.service, "/setup/boundary_conditions/set/recirculation_outlet").execute(*args, **kwargs)
                def rans_les_interface(self, *args, **kwargs):
                    """
                    Set boundary conditions for a zone or multiple zones of this type.
                    """
                    return PyMenu(self.service, "/setup/boundary_conditions/set/rans_les_interface").execute(*args, **kwargs)
                def interior(self, *args, **kwargs):
                    """
                    Set boundary conditions for a zone or multiple zones of this type.
                    """
                    return PyMenu(self.service, "/setup/boundary_conditions/set/interior").execute(*args, **kwargs)
                def interface(self, *args, **kwargs):
                    """
                    Set boundary conditions for a zone or multiple zones of this type.
                    """
                    return PyMenu(self.service, "/setup/boundary_conditions/set/interface").execute(*args, **kwargs)
                def mass_flow_inlet(self, *args, **kwargs):
                    """
                    Set boundary conditions for a zone or multiple zones of this type.
                    """
                    return PyMenu(self.service, "/setup/boundary_conditions/set/mass_flow_inlet").execute(*args, **kwargs)
                def axis(self, *args, **kwargs):
                    """
                    Set boundary conditions for a zone or multiple zones of this type.
                    """
                    return PyMenu(self.service, "/setup/boundary_conditions/set/axis").execute(*args, **kwargs)
                def geometry(self, *args, **kwargs):
                    """
                    Set boundary conditions for a zone or multiple zones of this type.
                    """
                    return PyMenu(self.service, "/setup/boundary_conditions/set/geometry").execute(*args, **kwargs)
                def wall(self, *args, **kwargs):
                    """
                    Set boundary conditions for a zone or multiple zones of this type.
                    """
                    return PyMenu(self.service, "/setup/boundary_conditions/set/wall").execute(*args, **kwargs)
                def fluid(self, *args, **kwargs):
                    """
                    Set boundary conditions for a zone or multiple zones of this type.
                    """
                    return PyMenu(self.service, "/setup/boundary_conditions/set/fluid").execute(*args, **kwargs)
                def pressure_outlet(self, *args, **kwargs):
                    """
                    Set boundary conditions for a zone or multiple zones of this type.
                    """
                    return PyMenu(self.service, "/setup/boundary_conditions/set/pressure_outlet").execute(*args, **kwargs)
                def pressure_far_field(self, *args, **kwargs):
                    """
                    Set boundary conditions for a zone or multiple zones of this type.
                    """
                    return PyMenu(self.service, "/setup/boundary_conditions/set/pressure_far_field").execute(*args, **kwargs)
                def solid(self, *args, **kwargs):
                    """
                    Set boundary conditions for a zone or multiple zones of this type.
                    """
                    return PyMenu(self.service, "/setup/boundary_conditions/set/solid").execute(*args, **kwargs)
                def porous_jump(self, *args, **kwargs):
                    """
                    Set boundary conditions for a zone or multiple zones of this type.
                    """
                    return PyMenu(self.service, "/setup/boundary_conditions/set/porous_jump").execute(*args, **kwargs)
                def overset(self, *args, **kwargs):
                    """
                    Set boundary conditions for a zone or multiple zones of this type.
                    """
                    return PyMenu(self.service, "/setup/boundary_conditions/set/overset").execute(*args, **kwargs)
                def pressure_inlet(self, *args, **kwargs):
                    """
                    Set boundary conditions for a zone or multiple zones of this type.
                    """
                    return PyMenu(self.service, "/setup/boundary_conditions/set/pressure_inlet").execute(*args, **kwargs)
                def degassing(self, *args, **kwargs):
                    """
                    Set boundary conditions for a zone or multiple zones of this type.
                    """
                    return PyMenu(self.service, "/setup/boundary_conditions/set/degassing").execute(*args, **kwargs)
                def network(self, *args, **kwargs):
                    """
                    Set boundary conditions for a zone or multiple zones of this type.
                    """
                    return PyMenu(self.service, "/setup/boundary_conditions/set/network").execute(*args, **kwargs)
                def intake_fan(self, *args, **kwargs):
                    """
                    Set boundary conditions for a zone or multiple zones of this type.
                    """
                    return PyMenu(self.service, "/setup/boundary_conditions/set/intake_fan").execute(*args, **kwargs)
                def mass_flow_outlet(self, *args, **kwargs):
                    """
                    Set boundary conditions for a zone or multiple zones of this type.
                    """
                    return PyMenu(self.service, "/setup/boundary_conditions/set/mass_flow_outlet").execute(*args, **kwargs)
                def outlet_vent(self, *args, **kwargs):
                    """
                    Set boundary conditions for a zone or multiple zones of this type.
                    """
                    return PyMenu(self.service, "/setup/boundary_conditions/set/outlet_vent").execute(*args, **kwargs)
                def fan(self, *args, **kwargs):
                    """
                    Set boundary conditions for a zone or multiple zones of this type.
                    """
                    return PyMenu(self.service, "/setup/boundary_conditions/set/fan").execute(*args, **kwargs)
                def inlet_vent(self, *args, **kwargs):
                    """
                    Set boundary conditions for a zone or multiple zones of this type.
                    """
                    return PyMenu(self.service, "/setup/boundary_conditions/set/inlet_vent").execute(*args, **kwargs)
                def periodic(self, *args, **kwargs):
                    """
                    Set boundary conditions for a zone or multiple zones of this type.
                    """
                    return PyMenu(self.service, "/setup/boundary_conditions/set/periodic").execute(*args, **kwargs)
                def recirculation_inlet(self, *args, **kwargs):
                    """
                    Set boundary conditions for a zone or multiple zones of this type.
                    """
                    return PyMenu(self.service, "/setup/boundary_conditions/set/recirculation_inlet").execute(*args, **kwargs)

            class rename_zone(TUIMenu):
                """
                Enter zone rename menu.
                """
                def __init__(self, path, service):
                    self.path = path
                    self.service = service
                    super().__init__(path, service)
                def rename_by_adjacency(self, *args, **kwargs):
                    """
                    Rename zone to adjacent zones.
                    """
                    return PyMenu(self.service, "/setup/boundary_conditions/rename_zone/rename_by_adjacency").execute(*args, **kwargs)
                def rename_to_default(self, *args, **kwargs):
                    """
                    Rename zone to default name.
                    """
                    return PyMenu(self.service, "/setup/boundary_conditions/rename_zone/rename_to_default").execute(*args, **kwargs)
                def add_suffix_or_prefix(self, *args, **kwargs):
                    """
                    Add suffix or prefix to zone name.
                    """
                    return PyMenu(self.service, "/setup/boundary_conditions/rename_zone/add_suffix_or_prefix").execute(*args, **kwargs)

            class query(TUIMenu):
                """
                Enter zone query menu.
                """
                def __init__(self, path, service):
                    self.path = path
                    self.service = service
                    super().__init__(path, service)
                def network_end(self, *args, **kwargs):
                    """
                    Show boundary conditions for a zone of this type.
                    """
                    return PyMenu(self.service, "/setup/boundary_conditions/query/network_end").execute(*args, **kwargs)
                def interior(self, *args, **kwargs):
                    """
                    Show boundary conditions for a zone of this type.
                    """
                    return PyMenu(self.service, "/setup/boundary_conditions/query/interior").execute(*args, **kwargs)
                def recirculation_inlet(self, *args, **kwargs):
                    """
                    Show boundary conditions for a zone of this type.
                    """
                    return PyMenu(self.service, "/setup/boundary_conditions/query/recirculation_inlet").execute(*args, **kwargs)
                def interface(self, *args, **kwargs):
                    """
                    Show boundary conditions for a zone of this type.
                    """
                    return PyMenu(self.service, "/setup/boundary_conditions/query/interface").execute(*args, **kwargs)
                def outflow(self, *args, **kwargs):
                    """
                    Show boundary conditions for a zone of this type.
                    """
                    return PyMenu(self.service, "/setup/boundary_conditions/query/outflow").execute(*args, **kwargs)
                def geometry(self, *args, **kwargs):
                    """
                    Show boundary conditions for a zone of this type.
                    """
                    return PyMenu(self.service, "/setup/boundary_conditions/query/geometry").execute(*args, **kwargs)
                def outlet_vent(self, *args, **kwargs):
                    """
                    Show boundary conditions for a zone of this type.
                    """
                    return PyMenu(self.service, "/setup/boundary_conditions/query/outlet_vent").execute(*args, **kwargs)
                def shadow(self, *args, **kwargs):
                    """
                    Show boundary conditions for a zone of this type.
                    """
                    return PyMenu(self.service, "/setup/boundary_conditions/query/shadow").execute(*args, **kwargs)
                def pressure_outlet(self, *args, **kwargs):
                    """
                    Show boundary conditions for a zone of this type.
                    """
                    return PyMenu(self.service, "/setup/boundary_conditions/query/pressure_outlet").execute(*args, **kwargs)
                def list_boundary_conditions(self, *args, **kwargs):
                    """
                    List boundary conditions.
                    """
                    return PyMenu(self.service, "/setup/boundary_conditions/query/list_boundary_conditions").execute(*args, **kwargs)
                def pressure_inlet(self, *args, **kwargs):
                    """
                    Show boundary conditions for a zone of this type.
                    """
                    return PyMenu(self.service, "/setup/boundary_conditions/query/pressure_inlet").execute(*args, **kwargs)
                def solid(self, *args, **kwargs):
                    """
                    Show boundary conditions for a zone of this type.
                    """
                    return PyMenu(self.service, "/setup/boundary_conditions/query/solid").execute(*args, **kwargs)
                def wall(self, *args, **kwargs):
                    """
                    Show boundary conditions for a zone of this type.
                    """
                    return PyMenu(self.service, "/setup/boundary_conditions/query/wall").execute(*args, **kwargs)
                def list_cell_zone_conditions(self, *args, **kwargs):
                    """
                    List cell zone conditions.
                    """
                    return PyMenu(self.service, "/setup/boundary_conditions/query/list_cell_zone_conditions").execute(*args, **kwargs)
                def degassing(self, *args, **kwargs):
                    """
                    Show boundary conditions for a zone of this type.
                    """
                    return PyMenu(self.service, "/setup/boundary_conditions/query/degassing").execute(*args, **kwargs)
                def list_queries(self, *args, **kwargs):
                    """
                    List all saved queries.
                    """
                    return PyMenu(self.service, "/setup/boundary_conditions/query/list_queries").execute(*args, **kwargs)
                def radiator(self, *args, **kwargs):
                    """
                    Show boundary conditions for a zone of this type.
                    """
                    return PyMenu(self.service, "/setup/boundary_conditions/query/radiator").execute(*args, **kwargs)
                def mass_flow_inlet(self, *args, **kwargs):
                    """
                    Show boundary conditions for a zone of this type.
                    """
                    return PyMenu(self.service, "/setup/boundary_conditions/query/mass_flow_inlet").execute(*args, **kwargs)
                def symmetry(self, *args, **kwargs):
                    """
                    Show boundary conditions for a zone of this type.
                    """
                    return PyMenu(self.service, "/setup/boundary_conditions/query/symmetry").execute(*args, **kwargs)
                def delete_query(self, *args, **kwargs):
                    """
                    Delete saved query.
                    """
                    return PyMenu(self.service, "/setup/boundary_conditions/query/delete_query").execute(*args, **kwargs)
                def inlet_vent(self, *args, **kwargs):
                    """
                    Show boundary conditions for a zone of this type.
                    """
                    return PyMenu(self.service, "/setup/boundary_conditions/query/inlet_vent").execute(*args, **kwargs)
                def list_named_selection(self, *args, **kwargs):
                    """
                    List named selection of zone type.
                    """
                    return PyMenu(self.service, "/setup/boundary_conditions/query/list_named_selection").execute(*args, **kwargs)
                def velocity_inlet(self, *args, **kwargs):
                    """
                    Show boundary conditions for a zone of this type.
                    """
                    return PyMenu(self.service, "/setup/boundary_conditions/query/velocity_inlet").execute(*args, **kwargs)
                def overset(self, *args, **kwargs):
                    """
                    Show boundary conditions for a zone of this type.
                    """
                    return PyMenu(self.service, "/setup/boundary_conditions/query/overset").execute(*args, **kwargs)
                def periodic(self, *args, **kwargs):
                    """
                    Show boundary conditions for a zone of this type.
                    """
                    return PyMenu(self.service, "/setup/boundary_conditions/query/periodic").execute(*args, **kwargs)
                def pressure_far_field(self, *args, **kwargs):
                    """
                    Show boundary conditions for a zone of this type.
                    """
                    return PyMenu(self.service, "/setup/boundary_conditions/query/pressure_far_field").execute(*args, **kwargs)
                def recirculation_outlet(self, *args, **kwargs):
                    """
                    Show boundary conditions for a zone of this type.
                    """
                    return PyMenu(self.service, "/setup/boundary_conditions/query/recirculation_outlet").execute(*args, **kwargs)
                def exhaust_fan(self, *args, **kwargs):
                    """
                    Show boundary conditions for a zone of this type.
                    """
                    return PyMenu(self.service, "/setup/boundary_conditions/query/exhaust_fan").execute(*args, **kwargs)
                def network(self, *args, **kwargs):
                    """
                    Show boundary conditions for a zone of this type.
                    """
                    return PyMenu(self.service, "/setup/boundary_conditions/query/network").execute(*args, **kwargs)
                def intake_fan(self, *args, **kwargs):
                    """
                    Show boundary conditions for a zone of this type.
                    """
                    return PyMenu(self.service, "/setup/boundary_conditions/query/intake_fan").execute(*args, **kwargs)
                def rans_les_interface(self, *args, **kwargs):
                    """
                    Show boundary conditions for a zone of this type.
                    """
                    return PyMenu(self.service, "/setup/boundary_conditions/query/rans_les_interface").execute(*args, **kwargs)
                def mass_flow_outlet(self, *args, **kwargs):
                    """
                    Show boundary conditions for a zone of this type.
                    """
                    return PyMenu(self.service, "/setup/boundary_conditions/query/mass_flow_outlet").execute(*args, **kwargs)
                def fan(self, *args, **kwargs):
                    """
                    Show boundary conditions for a zone of this type.
                    """
                    return PyMenu(self.service, "/setup/boundary_conditions/query/fan").execute(*args, **kwargs)
                def named_zone_list(self, *args, **kwargs):
                    """
                    Create named list of zones.
                    """
                    return PyMenu(self.service, "/setup/boundary_conditions/query/named_zone_list").execute(*args, **kwargs)
                def axis(self, *args, **kwargs):
                    """
                    Show boundary conditions for a zone of this type.
                    """
                    return PyMenu(self.service, "/setup/boundary_conditions/query/axis").execute(*args, **kwargs)
                def fluid(self, *args, **kwargs):
                    """
                    Show boundary conditions for a zone of this type.
                    """
                    return PyMenu(self.service, "/setup/boundary_conditions/query/fluid").execute(*args, **kwargs)
                def porous_jump(self, *args, **kwargs):
                    """
                    Show boundary conditions for a zone of this type.
                    """
                    return PyMenu(self.service, "/setup/boundary_conditions/query/porous_jump").execute(*args, **kwargs)

            class expert(TUIMenu):
                """
                Enter expert bc menu.
                """
                def __init__(self, path, service):
                    self.path = path
                    self.service = service
                    self.perforated_walls = self.__class__.perforated_walls(path + ["perforated_walls"], service)
                    self.impedance_data_fitting = self.__class__.impedance_data_fitting(path + ["impedance_data_fitting"], service)
                    self.periodic_conditions = self.__class__.periodic_conditions(path + ["periodic_conditions"], service)
                    self.non_reflecting_bc = self.__class__.non_reflecting_bc(path + ["non_reflecting_bc"], service)
                    super().__init__(path, service)
                def open_channel_wave_settings(self, *args, **kwargs):
                    """
                    Open channel wave input analysis.
                    """
                    return PyMenu(self.service, "/setup/boundary_conditions/expert/open_channel_wave_settings").execute(*args, **kwargs)
                def openchannel_threads(self, *args, **kwargs):
                    """
                    List open channel group IDs, names, types, and variables.
                    """
                    return PyMenu(self.service, "/setup/boundary_conditions/expert/openchannel_threads").execute(*args, **kwargs)
                def target_mass_flow_rate_settings(self, *args, **kwargs):
                    """
                    Enter the targeted mass flow rate setting menu.
                    """
                    return PyMenu(self.service, "/setup/boundary_conditions/expert/target_mass_flow_rate_settings").execute(*args, **kwargs)
                def non_overlapping_zone_name(self, *args, **kwargs):
                    """
                    Get non-overlapping zone name from the associated interface zone.
                    """
                    return PyMenu(self.service, "/setup/boundary_conditions/expert/non_overlapping_zone_name").execute(*args, **kwargs)

                class perforated_walls(TUIMenu):
                    """
                    Enter the perforated walls setting menu.
                    """
                    def __init__(self, path, service):
                        self.path = path
                        self.service = service
                        super().__init__(path, service)
                    def read_input_file(self, *args, **kwargs):
                        """
                        Read an input file.
                        """
                        return PyMenu(self.service, "/setup/boundary_conditions/expert/perforated_walls/read_input_file").execute(*args, **kwargs)
                    def model_setup(self, *args, **kwargs):
                        """
                        Set up perforated walls.
                        """
                        return PyMenu(self.service, "/setup/boundary_conditions/expert/perforated_walls/model_setup").execute(*args, **kwargs)

                class impedance_data_fitting(TUIMenu):
                    """
                    Enter the impedance data fitting menu.
                    """
                    def __init__(self, path, service):
                        self.path = path
                        self.service = service
                        super().__init__(path, service)
                    def iterations(self, *args, **kwargs):
                        """
                        Set the number of iterations for the fitting algorithm.
                        """
                        return PyMenu(self.service, "/setup/boundary_conditions/expert/impedance_data_fitting/iterations").execute(*args, **kwargs)
                    def verbosity(self, *args, **kwargs):
                        """
                        Set verbosity level [0, 1] for fitting algorithm.
                        """
                        return PyMenu(self.service, "/setup/boundary_conditions/expert/impedance_data_fitting/verbosity").execute(*args, **kwargs)
                    def reflection_data(self, *args, **kwargs):
                        """
                        Read experimental reflection coefficient data and output impedance parameters for a boundary condition.
                        """
                        return PyMenu(self.service, "/setup/boundary_conditions/expert/impedance_data_fitting/reflection_data").execute(*args, **kwargs)
                    def absorption_data(self, *args, **kwargs):
                        """
                        Read experimental absorption coefficient data and output impedance parameters for a boundary condition.
                        """
                        return PyMenu(self.service, "/setup/boundary_conditions/expert/impedance_data_fitting/absorption_data").execute(*args, **kwargs)
                    def convergence_tolerance(self, *args, **kwargs):
                        """
                        Set the convergence tolerance for the fitting algorithm.
                        """
                        return PyMenu(self.service, "/setup/boundary_conditions/expert/impedance_data_fitting/convergence_tolerance").execute(*args, **kwargs)
                    def residue_tolerance(self, *args, **kwargs):
                        """
                        Set the residue tolerance for the fitting algorithm.
                        """
                        return PyMenu(self.service, "/setup/boundary_conditions/expert/impedance_data_fitting/residue_tolerance").execute(*args, **kwargs)
                    def impedance_data(self, *args, **kwargs):
                        """
                        Read experimental impedance data and output impedance parameters for a boundary condition.
                        """
                        return PyMenu(self.service, "/setup/boundary_conditions/expert/impedance_data_fitting/impedance_data").execute(*args, **kwargs)
                    def import_parameters(self, *args, **kwargs):
                        """
                        Import impedance parameters into boundary condition.
                        """
                        return PyMenu(self.service, "/setup/boundary_conditions/expert/impedance_data_fitting/import_parameters").execute(*args, **kwargs)

                class periodic_conditions(TUIMenu):
                    """
                    Enter the periodic conditions menu.
                    """
                    def __init__(self, path, service):
                        self.path = path
                        self.service = service
                        super().__init__(path, service)
                    def pressure_gradient_specification(self, *args, **kwargs):
                        """
                        Enable/disable specification of pressure gradient at the periodic boundary.
                        """
                        return PyMenu(self.service, "/setup/boundary_conditions/expert/periodic_conditions/pressure_gradient_specification").execute(*args, **kwargs)
                    def massflow_rate_specification(self, *args, **kwargs):
                        """
                        Enable/disable specification of mass flow rate at the periodic boundary.
                        """
                        return PyMenu(self.service, "/setup/boundary_conditions/expert/periodic_conditions/massflow_rate_specification").execute(*args, **kwargs)

                class non_reflecting_bc(TUIMenu):
                    """
                    Enter the non-reflecting b.c. menu.
                    """
                    def __init__(self, path, service):
                        self.path = path
                        self.service = service
                        self.general_nrbc = self.__class__.general_nrbc(path + ["general_nrbc"], service)
                        self.turbo_specific_nrbc = self.__class__.turbo_specific_nrbc(path + ["turbo_specific_nrbc"], service)
                        super().__init__(path, service)

                    class general_nrbc(TUIMenu):
                        """
                        Enter the menu for setting general non-reflecting boundary conditions.
                        """
                        def __init__(self, path, service):
                            self.path = path
                            self.service = service
                            self.set = self.__class__.set(path + ["set"], service)
                            super().__init__(path, service)

                        class set(TUIMenu):
                            """
                            Enter the general non-reflecting b.c. menu.
                            """
                            def __init__(self, path, service):
                                self.path = path
                                self.service = service
                                super().__init__(path, service)
                            def verbosity(self, *args, **kwargs):
                                """
                                Print boundary equations convergence info.
                                """
                                return PyMenu(self.service, "/setup/boundary_conditions/expert/non_reflecting_bc/general_nrbc/set/verbosity").execute(*args, **kwargs)
                            def tangential_source(self, *args, **kwargs):
                                """
                                Include or not NRBC tangential source (default value #t).
                                """
                                return PyMenu(self.service, "/setup/boundary_conditions/expert/non_reflecting_bc/general_nrbc/set/tangential_source").execute(*args, **kwargs)
                            def relax(self, *args, **kwargs):
                                """
                                Set NRBC relaxation factor (default value 0.5).
                                """
                                return PyMenu(self.service, "/setup/boundary_conditions/expert/non_reflecting_bc/general_nrbc/set/relax").execute(*args, **kwargs)
                            def sigma(self, *args, **kwargs):
                                """
                                Set nrbc sigma factor (default value 0.15).
                                """
                                return PyMenu(self.service, "/setup/boundary_conditions/expert/non_reflecting_bc/general_nrbc/set/sigma").execute(*args, **kwargs)
                            def sigma2(self, *args, **kwargs):
                                """
                                Set nrbc sigma2 factor (default value 5.0).
                                """
                                return PyMenu(self.service, "/setup/boundary_conditions/expert/non_reflecting_bc/general_nrbc/set/sigma2").execute(*args, **kwargs)

                    class turbo_specific_nrbc(TUIMenu):
                        """
                        Enter the turbo-specific n.r.b.c. menu.
                        """
                        def __init__(self, path, service):
                            self.path = path
                            self.service = service
                            self.set = self.__class__.set(path + ["set"], service)
                            super().__init__(path, service)
                        def enable(self, *args, **kwargs):
                            """
                            Enable/disable turbo-specific non-reflecting b.c.'s.
                            """
                            return PyMenu(self.service, "/setup/boundary_conditions/expert/non_reflecting_bc/turbo_specific_nrbc/enable").execute(*args, **kwargs)
                        def initialize(self, *args, **kwargs):
                            """
                            Initialize turbo-specific non-reflecting b.c.'s.
                            """
                            return PyMenu(self.service, "/setup/boundary_conditions/expert/non_reflecting_bc/turbo_specific_nrbc/initialize").execute(*args, **kwargs)
                        def show_status(self, *args, **kwargs):
                            """
                            Show current status of turbo-specific non-reflecting b.c.'s.
                            """
                            return PyMenu(self.service, "/setup/boundary_conditions/expert/non_reflecting_bc/turbo_specific_nrbc/show_status").execute(*args, **kwargs)

                        class set(TUIMenu):
                            """
                            Enter the set menu for turbo-specific non-reflecting b.c. parameters.
                            """
                            def __init__(self, path, service):
                                self.path = path
                                self.service = service
                                super().__init__(path, service)
                            def verbosity(self, *args, **kwargs):
                                """
                                Set turbo-specific non-reflecting b.c. verbosity level.
                                0 : silent
                                1 : basic info. default
                                2 : detailed info. for debugging
                                .
                                """
                                return PyMenu(self.service, "/setup/boundary_conditions/expert/non_reflecting_bc/turbo_specific_nrbc/set/verbosity").execute(*args, **kwargs)
                            def discretization(self, *args, **kwargs):
                                """
                                Enable use of higher-order reconstruction at boundaries if available.
                                """
                                return PyMenu(self.service, "/setup/boundary_conditions/expert/non_reflecting_bc/turbo_specific_nrbc/set/discretization").execute(*args, **kwargs)
                            def under_relaxation(self, *args, **kwargs):
                                """
                                Set turbo-specific non-reflecting b.c. under-relaxation factor.
                                specify < 0 => use P/a_ave
                                specify = 0 => use 1/N
                                specify > 0 => use specified.
                                """
                                return PyMenu(self.service, "/setup/boundary_conditions/expert/non_reflecting_bc/turbo_specific_nrbc/set/under_relaxation").execute(*args, **kwargs)

            class modify_zones(TUIMenu):
                """
                Enter the modify zones menu.
                """
                def __init__(self, path, service):
                    self.path = path
                    self.service = service
                    super().__init__(path, service)
                def rotate_zone(self, *args, **kwargs):
                    """
                    Rotate nodal coordinates of input cell zones.
                    """
                    return PyMenu(self.service, "/setup/boundary_conditions/modify_zones/rotate_zone").execute(*args, **kwargs)
                def create_all_shell_threads(self, *args, **kwargs):
                    """
                    Mark all finite thickness wall for shell creation. Shell zones will be created at the start of iterations.
                    """
                    return PyMenu(self.service, "/setup/boundary_conditions/modify_zones/create_all_shell_threads").execute(*args, **kwargs)
                def change_zone_phase(self, *args, **kwargs):
                    """
                    Change the realgas phase for a zone.
                    """
                    return PyMenu(self.service, "/setup/boundary_conditions/modify_zones/change_zone_phase").execute(*args, **kwargs)
                def copy_move_cell_zone(self, *args, **kwargs):
                    """
                    Copy and translate or rotate a cell zone.
                    """
                    return PyMenu(self.service, "/setup/boundary_conditions/modify_zones/copy_move_cell_zone").execute(*args, **kwargs)
                def slit_periodic(self, *args, **kwargs):
                    """
                    Slit a periodic zone into two symmetry zones.
                    """
                    return PyMenu(self.service, "/setup/boundary_conditions/modify_zones/slit_periodic").execute(*args, **kwargs)
                def orient_face_zone(self, *args, **kwargs):
                    """
                    Orient the face zone.
                    """
                    return PyMenu(self.service, "/setup/boundary_conditions/modify_zones/orient_face_zone").execute(*args, **kwargs)
                def matching_tolerance(self, *args, **kwargs):
                    """
                    Set the normalized tolerance used for finding coincident nodes.
                    """
                    return PyMenu(self.service, "/setup/boundary_conditions/modify_zones/matching_tolerance").execute(*args, **kwargs)
                def deactivate_cell_zone(self, *args, **kwargs):
                    """
                    Deactivate cell thread.
                    """
                    return PyMenu(self.service, "/setup/boundary_conditions/modify_zones/deactivate_cell_zone").execute(*args, **kwargs)
                def append_mesh(self, *args, **kwargs):
                    """
                    Append new mesh.
                    """
                    return PyMenu(self.service, "/setup/boundary_conditions/modify_zones/append_mesh").execute(*args, **kwargs)
                def mrf_to_sliding_mesh(self, *args, **kwargs):
                    """
                    Change motion specification from MRF to moving mesh.
                    """
                    return PyMenu(self.service, "/setup/boundary_conditions/modify_zones/mrf_to_sliding_mesh").execute(*args, **kwargs)
                def delete_all_shells(self, *args, **kwargs):
                    """
                    Delete all shell zones and switch off shell conduction on all the walls. These zones can be recreated using the command recreate-all-shells.
                    """
                    return PyMenu(self.service, "/setup/boundary_conditions/modify_zones/delete_all_shells").execute(*args, **kwargs)
                def append_mesh_data(self, *args, **kwargs):
                    """
                    Append new mesh with data.
                    """
                    return PyMenu(self.service, "/setup/boundary_conditions/modify_zones/append_mesh_data").execute(*args, **kwargs)
                def translate_zone(self, *args, **kwargs):
                    """
                    Translate nodal coordinates of input cell zones.
                    """
                    return PyMenu(self.service, "/setup/boundary_conditions/modify_zones/translate_zone").execute(*args, **kwargs)
                def change_zone_state(self, *args, **kwargs):
                    """
                    Change the realgas material state for a zone.
                    """
                    return PyMenu(self.service, "/setup/boundary_conditions/modify_zones/change_zone_state").execute(*args, **kwargs)
                def delete_cell_zone(self, *args, **kwargs):
                    """
                    Delete a cell thread.
                    """
                    return PyMenu(self.service, "/setup/boundary_conditions/modify_zones/delete_cell_zone").execute(*args, **kwargs)
                def make_periodic(self, *args, **kwargs):
                    """
                    Attempt to establish conformal periodic face zone connectivity.
                    """
                    return PyMenu(self.service, "/setup/boundary_conditions/modify_zones/make_periodic").execute(*args, **kwargs)
                def create_periodic_interface(self, *args, **kwargs):
                    """
                    Create a conformal or non-conformal periodic interface.
                    """
                    return PyMenu(self.service, "/setup/boundary_conditions/modify_zones/create_periodic_interface").execute(*args, **kwargs)
                def merge_zones(self, *args, **kwargs):
                    """
                    Merge zones of the same type and condition into one.
                    """
                    return PyMenu(self.service, "/setup/boundary_conditions/modify_zones/merge_zones").execute(*args, **kwargs)
                def scale_zone(self, *args, **kwargs):
                    """
                    Scale nodal coordinates of input cell zones.
                    """
                    return PyMenu(self.service, "/setup/boundary_conditions/modify_zones/scale_zone").execute(*args, **kwargs)
                def copy_mesh_to_mrf_motion(self, *args, **kwargs):
                    """
                    Copy motion variable values for origin, axis and velocities from Mesh Motion to Frame Motion.
                    """
                    return PyMenu(self.service, "/setup/boundary_conditions/modify_zones/copy_mesh_to_mrf_motion").execute(*args, **kwargs)
                def zone_type(self, *args, **kwargs):
                    """
                    Set a zone's type.
                    """
                    return PyMenu(self.service, "/setup/boundary_conditions/modify_zones/zone_type").execute(*args, **kwargs)
                def activate_cell_zone(self, *args, **kwargs):
                    """
                    Activate a cell thread.
                    """
                    return PyMenu(self.service, "/setup/boundary_conditions/modify_zones/activate_cell_zone").execute(*args, **kwargs)
                def zone_name(self, *args, **kwargs):
                    """
                    Give a zone a new name.
                    """
                    return PyMenu(self.service, "/setup/boundary_conditions/modify_zones/zone_name").execute(*args, **kwargs)
                def replace_zone(self, *args, **kwargs):
                    """
                    Replace a cell zone.
                    """
                    return PyMenu(self.service, "/setup/boundary_conditions/modify_zones/replace_zone").execute(*args, **kwargs)
                def sep_cell_zone_mark(self, *args, **kwargs):
                    """
                    Separate a cell zone based on cell marking.
                    """
                    return PyMenu(self.service, "/setup/boundary_conditions/modify_zones/sep_cell_zone_mark").execute(*args, **kwargs)
                def copy_mrf_to_mesh_motion(self, *args, **kwargs):
                    """
                    Copy motion variable values for origin, axis and velocities from Frame Motion to Mesh Motion.
                    """
                    return PyMenu(self.service, "/setup/boundary_conditions/modify_zones/copy_mrf_to_mesh_motion").execute(*args, **kwargs)
                def sep_face_zone_region(self, *args, **kwargs):
                    """
                    Separate a face zone based on contiguous regions.
                    """
                    return PyMenu(self.service, "/setup/boundary_conditions/modify_zones/sep_face_zone_region").execute(*args, **kwargs)
                def slit_interior_between_diff_solids(self, *args, **kwargs):
                    """
                    Slit interior created between different solids into coupled walls.
                    """
                    return PyMenu(self.service, "/setup/boundary_conditions/modify_zones/slit_interior_between_diff_solids").execute(*args, **kwargs)
                def sep_face_zone_face(self, *args, **kwargs):
                    """
                    Separate each face in a zone into unique zone.
                    """
                    return PyMenu(self.service, "/setup/boundary_conditions/modify_zones/sep_face_zone_face").execute(*args, **kwargs)
                def slit_face_zone(self, *args, **kwargs):
                    """
                    Slit a two-sided wall into two connected wall zones.
                    """
                    return PyMenu(self.service, "/setup/boundary_conditions/modify_zones/slit_face_zone").execute(*args, **kwargs)
                def sep_face_zone_angle(self, *args, **kwargs):
                    """
                    Separate a face zone based on significant angle.
                    """
                    return PyMenu(self.service, "/setup/boundary_conditions/modify_zones/sep_face_zone_angle").execute(*args, **kwargs)
                def extrude_face_zone_delta(self, *args, **kwargs):
                    """
                    Extrude a face thread a specified distance based on a list of deltas.
                    """
                    return PyMenu(self.service, "/setup/boundary_conditions/modify_zones/extrude_face_zone_delta").execute(*args, **kwargs)
                def recreate_all_shells(self, *args, **kwargs):
                    """
                    Create shell on all the walls where which were deleted using the command delete-all-shells.
                    """
                    return PyMenu(self.service, "/setup/boundary_conditions/modify_zones/recreate_all_shells").execute(*args, **kwargs)
                def sep_face_zone_mark(self, *args, **kwargs):
                    """
                    Separate a face zone based on cell marking.
                    """
                    return PyMenu(self.service, "/setup/boundary_conditions/modify_zones/sep_face_zone_mark").execute(*args, **kwargs)
                def list_zones(self, *args, **kwargs):
                    """
                    List zone IDs, types, kinds, and names.
                    """
                    return PyMenu(self.service, "/setup/boundary_conditions/modify_zones/list_zones").execute(*args, **kwargs)
                def extrude_face_zone_para(self, *args, **kwargs):
                    """
                    Extrude a face thread a specified distance based on a distance and a list of parametric locations between 0 and 1 (eg. 0 0.2 0.4 0.8 1.0).
                    """
                    return PyMenu(self.service, "/setup/boundary_conditions/modify_zones/extrude_face_zone_para").execute(*args, **kwargs)
                def fuse_face_zones(self, *args, **kwargs):
                    """
                    Attempt to fuse zones by removing duplicate faces and nodes.
                    """
                    return PyMenu(self.service, "/setup/boundary_conditions/modify_zones/fuse_face_zones").execute(*args, **kwargs)
                def convert_all_solid_mrf_to_solid_motion(self, *args, **kwargs):
                    """
                    Change all solid zones motion specification from MRF to solid motion.
                    """
                    return PyMenu(self.service, "/setup/boundary_conditions/modify_zones/convert_all_solid_mrf_to_solid_motion").execute(*args, **kwargs)
                def sep_cell_zone_region(self, *args, **kwargs):
                    """
                    Separate a cell zone based on contiguous regions.
                    """
                    return PyMenu(self.service, "/setup/boundary_conditions/modify_zones/sep_cell_zone_region").execute(*args, **kwargs)

            class bc_settings(TUIMenu):
                """
                .
                """
                def __init__(self, path, service):
                    self.path = path
                    self.service = service
                    self.pressure_far_field = self.__class__.pressure_far_field(path + ["pressure_far_field"], service)
                    super().__init__(path, service)
                def mass_flow(self, *args, **kwargs):
                    """
                    Select method for setting the mass flow rate.
                    """
                    return PyMenu(self.service, "/setup/boundary_conditions/bc_settings/mass_flow").execute(*args, **kwargs)
                def pressure_outlet(self, *args, **kwargs):
                    """
                    Select pressure specification method on pressure-outlet boundaries.
                    """
                    return PyMenu(self.service, "/setup/boundary_conditions/bc_settings/pressure_outlet").execute(*args, **kwargs)

                class pressure_far_field(TUIMenu):
                    """
                    Select presure-far-field boundary-condition options.
                    """
                    def __init__(self, path, service):
                        self.path = path
                        self.service = service
                        super().__init__(path, service)
                    def type(self, *args, **kwargs):
                        """
                        Choose pressure-far-field boundary-condition type.
                        """
                        return PyMenu(self.service, "/setup/boundary_conditions/bc_settings/pressure_far_field/type").execute(*args, **kwargs)
                    def riemann_invariants_tangency_correction(self, *args, **kwargs):
                        """
                        Apply a local correction where the flow is tangential to the boundary.
                        """
                        return PyMenu(self.service, "/setup/boundary_conditions/bc_settings/pressure_far_field/riemann_invariants_tangency_correction").execute(*args, **kwargs)

            class profiles(TUIMenu):
                """
                Enter the boundary profiles menu.
                """
                def __init__(self, path, service):
                    self.path = path
                    self.service = service
                    super().__init__(path, service)
                def set_preference_profile_point_cloud_data(self, *args, **kwargs):
                    """
                    Set Preference Profile Point Cloud Data e.g., Point marker symbol,size,color.
                    """
                    return PyMenu(self.service, "/setup/boundary_conditions/profiles/set_preference_profile_point_cloud_data").execute(*args, **kwargs)
                def list_profiles(self, *args, **kwargs):
                    """
                    List all profiles.
                    """
                    return PyMenu(self.service, "/setup/boundary_conditions/profiles/list_profiles").execute(*args, **kwargs)
                def display_profile_surface(self, *args, **kwargs):
                    """
                    Display a profile.
                    """
                    return PyMenu(self.service, "/setup/boundary_conditions/profiles/display_profile_surface").execute(*args, **kwargs)
                def orient_profile(self, *args, **kwargs):
                    """
                    Orient Profile.
                    """
                    return PyMenu(self.service, "/setup/boundary_conditions/profiles/orient_profile").execute(*args, **kwargs)
                def replicate_profile(self, *args, **kwargs):
                    """
                    Replicate Profile.
                    """
                    return PyMenu(self.service, "/setup/boundary_conditions/profiles/replicate_profile").execute(*args, **kwargs)
                def update_interval(self, *args, **kwargs):
                    """
                    Set interval between updates of dynamic profiles.
                    """
                    return PyMenu(self.service, "/setup/boundary_conditions/profiles/update_interval").execute(*args, **kwargs)
                def list_profile_parameters(self, *args, **kwargs):
                    """
                    List the parameters of a particular profile.
                    """
                    return PyMenu(self.service, "/setup/boundary_conditions/profiles/list_profile_parameters").execute(*args, **kwargs)
                def interpolation_method(self, *args, **kwargs):
                    """
                    Choose the method for interpolation of profiles.
                    """
                    return PyMenu(self.service, "/setup/boundary_conditions/profiles/interpolation_method").execute(*args, **kwargs)
                def overlay_profile_surface(self, *args, **kwargs):
                    """
                    Overlay Profile Surface.
                    """
                    return PyMenu(self.service, "/setup/boundary_conditions/profiles/overlay_profile_surface").execute(*args, **kwargs)
                def delete(self, *args, **kwargs):
                    """
                    Delete a profile.
                    """
                    return PyMenu(self.service, "/setup/boundary_conditions/profiles/delete").execute(*args, **kwargs)
                def display_profile_point_cloud_data(self, *args, **kwargs):
                    """
                    Display Profile Point Cloud Data.
                    """
                    return PyMenu(self.service, "/setup/boundary_conditions/profiles/display_profile_point_cloud_data").execute(*args, **kwargs)
                def overlay_profile_point_cloud_data(self, *args, **kwargs):
                    """
                    Overlay Profile Point Cloud Data.
                    """
                    return PyMenu(self.service, "/setup/boundary_conditions/profiles/overlay_profile_point_cloud_data").execute(*args, **kwargs)
                def delete_all(self, *args, **kwargs):
                    """
                    Delete all boundary-profiles.
                    """
                    return PyMenu(self.service, "/setup/boundary_conditions/profiles/delete_all").execute(*args, **kwargs)
                def link_profile_to_reference_frame(self, *args, **kwargs):
                    """
                    Link profile to a reference frame.
                    """
                    return PyMenu(self.service, "/setup/boundary_conditions/profiles/link_profile_to_reference_frame").execute(*args, **kwargs)
                def list_profile_fields(self, *args, **kwargs):
                    """
                    List the fields of a particular profile.
                    """
                    return PyMenu(self.service, "/setup/boundary_conditions/profiles/list_profile_fields").execute(*args, **kwargs)
                def morphing(self, *args, **kwargs):
                    """
                    Enable/disable profile morphing options in Orient Profile panel.
                    """
                    return PyMenu(self.service, "/setup/boundary_conditions/profiles/morphing").execute(*args, **kwargs)

        class models(TUIMenu):
            """
            Enter the models menu to configure the solver.
            """
            def __init__(self, path, service):
                self.path = path
                self.service = service
                self.shell_conduction = self.__class__.shell_conduction(path + ["shell_conduction"], service)
                self.viscous = self.__class__.viscous(path + ["viscous"], service)
                self.optics = self.__class__.optics(path + ["optics"], service)
                self.acoustics = self.__class__.acoustics(path + ["acoustics"], service)
                self.solver = self.__class__.solver(path + ["solver"], service)
                self.heat_exchanger = self.__class__.heat_exchanger(path + ["heat_exchanger"], service)
                self.electrolysis = self.__class__.electrolysis(path + ["electrolysis"], service)
                self.system_coupling_settings = self.__class__.system_coupling_settings(path + ["system_coupling_settings"], service)
                self.multiphase = self.__class__.multiphase(path + ["multiphase"], service)
                self.two_temperature = self.__class__.two_temperature(path + ["two_temperature"], service)
                self.radiation = self.__class__.radiation(path + ["radiation"], service)
                self.nox_parameters = self.__class__.nox_parameters(path + ["nox_parameters"], service)
                self.eulerian_wallfilm = self.__class__.eulerian_wallfilm(path + ["eulerian_wallfilm"], service)
                self.soot_parameters = self.__class__.soot_parameters(path + ["soot_parameters"], service)
                self.cht = self.__class__.cht(path + ["cht"], service)
                self.species = self.__class__.species(path + ["species"], service)
                self.structure = self.__class__.structure(path + ["structure"], service)
                self.dpm = self.__class__.dpm(path + ["dpm"], service)
                super().__init__(path, service)
            def nox(self, *args, **kwargs):
                """
                Enable/disable the NOx model.
                """
                return PyMenu(self.service, "/setup/models/nox").execute(*args, **kwargs)
            def vbm(self, *args, **kwargs):
                """
                Enable/disable Virtual Blade Model.
                """
                return PyMenu(self.service, "/setup/models/vbm").execute(*args, **kwargs)
            def crevice_model(self, *args, **kwargs):
                """
                Enable/disable the crevice model.
                """
                return PyMenu(self.service, "/setup/models/crevice_model").execute(*args, **kwargs)
            def swirl(self, *args, **kwargs):
                """
                Enable/disable axisymmetric swirl velocity.
                """
                return PyMenu(self.service, "/setup/models/swirl").execute(*args, **kwargs)
            def potential_and_li_ion_battery(self, *args, **kwargs):
                """
                Enable/disable the electric-potential model.
                """
                return PyMenu(self.service, "/setup/models/potential_and_li_ion_battery").execute(*args, **kwargs)
            def addon_module(self, *args, **kwargs):
                """
                Load addon module.
                """
                return PyMenu(self.service, "/setup/models/addon_module").execute(*args, **kwargs)
            def frozen_flux(self, *args, **kwargs):
                """
                Enable/disable frozen flux formulation for transient flows.
                """
                return PyMenu(self.service, "/setup/models/frozen_flux").execute(*args, **kwargs)
            def crevice_model_controls(self, *args, **kwargs):
                """
                Enter the crevice model controls menu.
                """
                return PyMenu(self.service, "/setup/models/crevice_model_controls").execute(*args, **kwargs)
            def soot(self, *args, **kwargs):
                """
                Enable/disable the soot model.
                """
                return PyMenu(self.service, "/setup/models/soot").execute(*args, **kwargs)
            def energy(self, *args, **kwargs):
                """
                Enable/disable the energy model.
                """
                return PyMenu(self.service, "/setup/models/energy").execute(*args, **kwargs)
            def unsteady_global_time(self, *args, **kwargs):
                """
                Enable/disable the unsteady global-time-step solution model.
                """
                return PyMenu(self.service, "/setup/models/unsteady_global_time").execute(*args, **kwargs)
            def unsteady_2nd_order_bounded(self, *args, **kwargs):
                """
                Enable/disable bounded second-order unsteady formulation.
                """
                return PyMenu(self.service, "/setup/models/unsteady_2nd_order_bounded").execute(*args, **kwargs)
            def unsteady_structure_newmark(self, *args, **kwargs):
                """
                Enable/disable Newmark unsteady solution model.
                """
                return PyMenu(self.service, "/setup/models/unsteady_structure_newmark").execute(*args, **kwargs)
            def virtual_blade_model(self, *args, **kwargs):
                """
                Enter VBM model menu.
                """
                return PyMenu(self.service, "/setup/models/virtual_blade_model").execute(*args, **kwargs)
            def noniterative_time_advance(self, *args, **kwargs):
                """
                Enable/disable the noniterative time advancement scheme.
                """
                return PyMenu(self.service, "/setup/models/noniterative_time_advance").execute(*args, **kwargs)
            def axisymmetric(self, *args, **kwargs):
                """
                Enable/disable the axisymmetric model.
                """
                return PyMenu(self.service, "/setup/models/axisymmetric").execute(*args, **kwargs)
            def unsteady_structure_euler(self, *args, **kwargs):
                """
                Enable/disable Backward Euler unsteady solution model.
                """
                return PyMenu(self.service, "/setup/models/unsteady_structure_euler").execute(*args, **kwargs)
            def steady(self, *args, **kwargs):
                """
                Enable/disable the steady solution model.
                """
                return PyMenu(self.service, "/setup/models/steady").execute(*args, **kwargs)
            def unsteady_2nd_order(self, *args, **kwargs):
                """
                Enable/disable the second-order unsteady solution model.
                """
                return PyMenu(self.service, "/setup/models/unsteady_2nd_order").execute(*args, **kwargs)
            def ablation(self, *args, **kwargs):
                """
                Enable/disable ablation model.
                """
                return PyMenu(self.service, "/setup/models/ablation").execute(*args, **kwargs)
            def solidification_melting(self, *args, **kwargs):
                """
                Enable/disable the solidification and melting model.
                """
                return PyMenu(self.service, "/setup/models/solidification_melting").execute(*args, **kwargs)
            def unsteady_1st_order(self, *args, **kwargs):
                """
                Enable/disable first-order unsteady solution model.
                """
                return PyMenu(self.service, "/setup/models/unsteady_1st_order").execute(*args, **kwargs)
            def battery_model(self, *args, **kwargs):
                """
                Enter battery model menu.
                """
                return PyMenu(self.service, "/setup/models/battery_model").execute(*args, **kwargs)

            class shell_conduction(TUIMenu):
                """
                Enter the shell conduction model menu.
                """
                def __init__(self, path, service):
                    self.path = path
                    self.service = service
                    super().__init__(path, service)
                def settings(self, *args, **kwargs):
                    """
                    Enter Multi-layer Shell Conduction data.
                    """
                    return PyMenu(self.service, "/setup/models/shell_conduction/settings").execute(*args, **kwargs)
                def write_csv(self, *args, **kwargs):
                    """
                    Write shell conduction settings to a csv file.
                    """
                    return PyMenu(self.service, "/setup/models/shell_conduction/write_csv").execute(*args, **kwargs)
                def enhanced_encapsulation(self, *args, **kwargs):
                    """
                    Enable/disable enhanced encapsulation for shell conduction and S2S models. This is not applicable if coupled sliding interface walls exists.
                    """
                    return PyMenu(self.service, "/setup/models/shell_conduction/enhanced_encapsulation").execute(*args, **kwargs)
                def read_csv(self, *args, **kwargs):
                    """
                    Read shell conduction settings from a csv file.
                    """
                    return PyMenu(self.service, "/setup/models/shell_conduction/read_csv").execute(*args, **kwargs)
                def multi_layer_shell(self, *args, **kwargs):
                    """
                    Enable/disable multi layer shell conduction model.
                    """
                    return PyMenu(self.service, "/setup/models/shell_conduction/multi_layer_shell").execute(*args, **kwargs)
                def save_shell_zones(self, *args, **kwargs):
                    """
                    Enable/Disable saving shell zones to case file.
                    """
                    return PyMenu(self.service, "/setup/models/shell_conduction/save_shell_zones").execute(*args, **kwargs)

            class viscous(TUIMenu):
                """
                Enter the viscous model menu.
                """
                def __init__(self, path, service):
                    self.path = path
                    self.service = service
                    self.transition_model_options = self.__class__.transition_model_options(path + ["transition_model_options"], service)
                    self.multiphase_turbulence = self.__class__.multiphase_turbulence(path + ["multiphase_turbulence"], service)
                    self.geko_options = self.__class__.geko_options(path + ["geko_options"], service)
                    self.near_wall_treatment = self.__class__.near_wall_treatment(path + ["near_wall_treatment"], service)
                    self.turbulence_expert = self.__class__.turbulence_expert(path + ["turbulence_expert"], service)
                    super().__init__(path, service)
                def rsm_omega_based(self, *args, **kwargs):
                    """
                    Enable/disable the Stress-omega model.
                    """
                    return PyMenu(self.service, "/setup/models/viscous/rsm_omega_based").execute(*args, **kwargs)
                def ke_rng(self, *args, **kwargs):
                    """
                    Enable/disable the RNG k-epsilon turbulence model.
                    """
                    return PyMenu(self.service, "/setup/models/viscous/ke_rng").execute(*args, **kwargs)
                def laminar(self, *args, **kwargs):
                    """
                    Enable/disable the laminar flow model.
                    """
                    return PyMenu(self.service, "/setup/models/viscous/laminar").execute(*args, **kwargs)
                def large_eddy_simulation(self, *args, **kwargs):
                    """
                    Enable/disable large eddy simulation.
                    """
                    return PyMenu(self.service, "/setup/models/viscous/large_eddy_simulation").execute(*args, **kwargs)
                def les_subgrid_tke(self, *args, **kwargs):
                    """
                    Enable/disable the kinetic energy transport subgrid-scale model.
                    """
                    return PyMenu(self.service, "/setup/models/viscous/les_subgrid_tke").execute(*args, **kwargs)
                def rsm_solve_tke(self, *args, **kwargs):
                    """
                    Enable/disable the solution of T.K.E. in RSM model.
                    """
                    return PyMenu(self.service, "/setup/models/viscous/rsm_solve_tke").execute(*args, **kwargs)
                def curvature_correction_ccurv(self, *args, **kwargs):
                    """
                    Set the curvature correction coefficient CCURV.
                    """
                    return PyMenu(self.service, "/setup/models/viscous/curvature_correction_ccurv").execute(*args, **kwargs)
                def les_subgrid_wale(self, *args, **kwargs):
                    """
                    Enable/disable the WALE subgrid-scale model.
                    """
                    return PyMenu(self.service, "/setup/models/viscous/les_subgrid_wale").execute(*args, **kwargs)
                def les_dynamic_scalar_flux(self, *args, **kwargs):
                    """
                    Enable/disable the dynamic sub-grid scale turbulent Schmidt Number.
                    """
                    return PyMenu(self.service, "/setup/models/viscous/les_dynamic_scalar_flux").execute(*args, **kwargs)
                def ke_standard(self, *args, **kwargs):
                    """
                    Enable/disable the standard k-epsilon turbulence model.
                    """
                    return PyMenu(self.service, "/setup/models/viscous/ke_standard").execute(*args, **kwargs)
                def des_limiter_option(self, *args, **kwargs):
                    """
                    Select DES limiter option.
                    """
                    return PyMenu(self.service, "/setup/models/viscous/des_limiter_option").execute(*args, **kwargs)
                def kw_geko(self, *args, **kwargs):
                    """
                    Enable/disable the GEKO turbulence model.
                    """
                    return PyMenu(self.service, "/setup/models/viscous/kw_geko").execute(*args, **kwargs)
                def ke_realizable(self, *args, **kwargs):
                    """
                    Enable/disable the realizable k-epsilon turbulence model.
                    """
                    return PyMenu(self.service, "/setup/models/viscous/ke_realizable").execute(*args, **kwargs)
                def ke1e(self, *args, **kwargs):
                    """
                    Enable/disable the KE1E turbulence model.
                    """
                    return PyMenu(self.service, "/setup/models/viscous/ke1e").execute(*args, **kwargs)
                def les_subgrid_dynamic_fvar(self, *args, **kwargs):
                    """
                    Enable/disable the dynamic subgrid-scale mixture fraction variance model.
                    """
                    return PyMenu(self.service, "/setup/models/viscous/les_subgrid_dynamic_fvar").execute(*args, **kwargs)
                def rsm_bsl_based(self, *args, **kwargs):
                    """
                    Enable/disable the Stress-BSL model.
                    """
                    return PyMenu(self.service, "/setup/models/viscous/rsm_bsl_based").execute(*args, **kwargs)
                def rsm_wall_echo(self, *args, **kwargs):
                    """
                    Enable/disable wall-echo effects in RSM model.
                    """
                    return PyMenu(self.service, "/setup/models/viscous/rsm_wall_echo").execute(*args, **kwargs)
                def zero_equation_hvac(self, *args, **kwargs):
                    """
                    Enable/disable the zero-equation HVAC turbulence model.
                    """
                    return PyMenu(self.service, "/setup/models/viscous/zero_equation_hvac").execute(*args, **kwargs)
                def les_subgrid_smagorinsky(self, *args, **kwargs):
                    """
                    Enable/disable the Smagorinsky-Lilly subgrid-scale model.
                    """
                    return PyMenu(self.service, "/setup/models/viscous/les_subgrid_smagorinsky").execute(*args, **kwargs)
                def transition_sst(self, *args, **kwargs):
                    """
                    Enable/disable the transition SST turbulence model.
                    """
                    return PyMenu(self.service, "/setup/models/viscous/transition_sst").execute(*args, **kwargs)
                def sa_damping(self, *args, **kwargs):
                    """
                    Enable/disable the full low-Reynolds number form of Spalart-Allmaras model.
                    """
                    return PyMenu(self.service, "/setup/models/viscous/sa_damping").execute(*args, **kwargs)
                def sa_enhanced_wall_treatment(self, *args, **kwargs):
                    """
                    Enable/disable the enhanced wall treatment for the Spalart-Allmaras model.
                    If disabled, no smooth blending between the viscous sublayer and the
                    log-law formulation is employed, as was done in versions previous to Fluent14.
                    """
                    return PyMenu(self.service, "/setup/models/viscous/sa_enhanced_wall_treatment").execute(*args, **kwargs)
                def kw_standard(self, *args, **kwargs):
                    """
                    Enable/disable the standard k-omega turbulence model.
                    """
                    return PyMenu(self.service, "/setup/models/viscous/kw_standard").execute(*args, **kwargs)
                def turb_compressibility(self, *args, **kwargs):
                    """
                    Enable/disable the compressibility correction option.
                    """
                    return PyMenu(self.service, "/setup/models/viscous/turb_compressibility").execute(*args, **kwargs)
                def v2f(self, *args, **kwargs):
                    """
                    Enable/disable the V2F turbulence model.
                    """
                    return PyMenu(self.service, "/setup/models/viscous/v2f").execute(*args, **kwargs)
                def spalart_allmaras(self, *args, **kwargs):
                    """
                    Enable/disable the Spalart-Allmaras turbulence model.
                    """
                    return PyMenu(self.service, "/setup/models/viscous/spalart_allmaras").execute(*args, **kwargs)
                def les_subgrid_rng(self, *args, **kwargs):
                    """
                    Enable/disable the RNG subgrid-scale model.
                    """
                    return PyMenu(self.service, "/setup/models/viscous/les_subgrid_rng").execute(*args, **kwargs)
                def rsm_ssg_pressure_strain(self, *args, **kwargs):
                    """
                    Enable/disable the quadratic pressure-strain model in RSM.
                    """
                    return PyMenu(self.service, "/setup/models/viscous/rsm_ssg_pressure_strain").execute(*args, **kwargs)
                def mixing_length(self, *args, **kwargs):
                    """
                    Enable/disable the mixing-length (algebraic) turbulence model.
                    """
                    return PyMenu(self.service, "/setup/models/viscous/mixing_length").execute(*args, **kwargs)
                def sas(self, *args, **kwargs):
                    """
                    Enable/disable the SAS turbulence model.
                    """
                    return PyMenu(self.service, "/setup/models/viscous/sas").execute(*args, **kwargs)
                def reynolds_stress_model(self, *args, **kwargs):
                    """
                    Enable/disable the RSM turbulence model.
                    """
                    return PyMenu(self.service, "/setup/models/viscous/reynolds_stress_model").execute(*args, **kwargs)
                def turb_buoyancy_effects(self, *args, **kwargs):
                    """
                    Select buoyancy effects on turbulence.
                    """
                    return PyMenu(self.service, "/setup/models/viscous/turb_buoyancy_effects").execute(*args, **kwargs)
                def trans_sst_roughness_correlation(self, *args, **kwargs):
                    """
                    Enable/disable the Transition-SST roughness correlation option.
                    """
                    return PyMenu(self.service, "/setup/models/viscous/trans_sst_roughness_correlation").execute(*args, **kwargs)
                def ke_easm(self, *args, **kwargs):
                    """
                    Enable/disable the EASM k-epsilon turbulence model.
                    """
                    return PyMenu(self.service, "/setup/models/viscous/ke_easm").execute(*args, **kwargs)
                def inviscid(self, *args, **kwargs):
                    """
                    Enable/disable the inviscid flow model.
                    """
                    return PyMenu(self.service, "/setup/models/viscous/inviscid").execute(*args, **kwargs)
                def les_subgrid_wmles_s_minus_omega(self, *args, **kwargs):
                    """
                    Enable/disable the WMLES S-Omega subgrid-scale model.
                    """
                    return PyMenu(self.service, "/setup/models/viscous/les_subgrid_wmles_s_minus_omega").execute(*args, **kwargs)
                def add_transition_model(self, *args, **kwargs):
                    """
                    Enable/disable a transition model to account for transitional effects.
                    """
                    return PyMenu(self.service, "/setup/models/viscous/add_transition_model").execute(*args, **kwargs)
                def user_defined(self, *args, **kwargs):
                    """
                    Select user-defined functions to define the turbulent viscosity and the turbulent Prandtl and Schmidt numbers.
                    """
                    return PyMenu(self.service, "/setup/models/viscous/user_defined").execute(*args, **kwargs)
                def user_defined_transition(self, *args, **kwargs):
                    """
                    Set user-defined transition correlations.
                    """
                    return PyMenu(self.service, "/setup/models/viscous/user_defined_transition").execute(*args, **kwargs)
                def kw_bsl(self, *args, **kwargs):
                    """
                    Enable/disable the BSL k-omega turbulence model.
                    """
                    return PyMenu(self.service, "/setup/models/viscous/kw_bsl").execute(*args, **kwargs)
                def corner_flow_correction_ccorner(self, *args, **kwargs):
                    """
                    Set the corner flow correction coefficient CCORNER.
                    """
                    return PyMenu(self.service, "/setup/models/viscous/corner_flow_correction_ccorner").execute(*args, **kwargs)
                def detached_eddy_simulation(self, *args, **kwargs):
                    """
                    Enable/disable detached eddy simulation.
                    """
                    return PyMenu(self.service, "/setup/models/viscous/detached_eddy_simulation").execute(*args, **kwargs)
                def rsm_linear_pressure_strain(self, *args, **kwargs):
                    """
                    Enable/disable the linear pressure-strain model in RSM.
                    """
                    return PyMenu(self.service, "/setup/models/viscous/rsm_linear_pressure_strain").execute(*args, **kwargs)
                def rng_swirl_model(self, *args, **kwargs):
                    """
                    Enable/disable swirl corrections for rng-model.
                    """
                    return PyMenu(self.service, "/setup/models/viscous/rng_swirl_model").execute(*args, **kwargs)
                def kw_sst(self, *args, **kwargs):
                    """
                    Enable/disable the SST k-omega turbulence model.
                    """
                    return PyMenu(self.service, "/setup/models/viscous/kw_sst").execute(*args, **kwargs)
                def sa_alternate_prod(self, *args, **kwargs):
                    """
                    Enable/disable strain/vorticity production in Spalart-Allmaras model.
                    """
                    return PyMenu(self.service, "/setup/models/viscous/sa_alternate_prod").execute(*args, **kwargs)
                def low_pressure_boundary_slip(self, *args, **kwargs):
                    """
                    Enable/disable the slip boundary formulation for low-pressure gas systems.
                    """
                    return PyMenu(self.service, "/setup/models/viscous/low_pressure_boundary_slip").execute(*args, **kwargs)
                def curvature_correction(self, *args, **kwargs):
                    """
                    Enable/disable the curvature correction.
                    """
                    return PyMenu(self.service, "/setup/models/viscous/curvature_correction").execute(*args, **kwargs)
                def les_dynamic_energy_flux(self, *args, **kwargs):
                    """
                    Enable/disable the dynamic sub-grid scale turbulent Prandtl Number.
                    """
                    return PyMenu(self.service, "/setup/models/viscous/les_dynamic_energy_flux").execute(*args, **kwargs)
                def kw_easm(self, *args, **kwargs):
                    """
                    Enable/disable the EASM k-omega turbulence model.
                    """
                    return PyMenu(self.service, "/setup/models/viscous/kw_easm").execute(*args, **kwargs)
                def corner_flow_correction(self, *args, **kwargs):
                    """
                    Enable/disable the corner flow correction.
                    """
                    return PyMenu(self.service, "/setup/models/viscous/corner_flow_correction").execute(*args, **kwargs)
                def k_kl_w(self, *args, **kwargs):
                    """
                    Enable/disable the k-kl-omega turbulence model.
                    """
                    return PyMenu(self.service, "/setup/models/viscous/k_kl_w").execute(*args, **kwargs)
                def les_subgrid_wmles(self, *args, **kwargs):
                    """
                    Enable/disable the WMLES subgrid-scale model.
                    """
                    return PyMenu(self.service, "/setup/models/viscous/les_subgrid_wmles").execute(*args, **kwargs)
                def rsm_or_earsm_geko_option(self, *args, **kwargs):
                    """
                    Enable/disable the GEKO option for RSM or EARSM.
                    """
                    return PyMenu(self.service, "/setup/models/viscous/rsm_or_earsm_geko_option").execute(*args, **kwargs)
                def kw_low_re_correction(self, *args, **kwargs):
                    """
                    Enable/disable the k-omega low Re option.
                    """
                    return PyMenu(self.service, "/setup/models/viscous/kw_low_re_correction").execute(*args, **kwargs)
                def kw_shear_correction(self, *args, **kwargs):
                    """
                    Enable/disable the k-omega shear-flow correction option.
                    """
                    return PyMenu(self.service, "/setup/models/viscous/kw_shear_correction").execute(*args, **kwargs)
                def rng_differential_visc(self, *args, **kwargs):
                    """
                    Enable/disable the differential-viscosity model.
                    """
                    return PyMenu(self.service, "/setup/models/viscous/rng_differential_visc").execute(*args, **kwargs)
                def kw_wj_bsl_earsm(self, *args, **kwargs):
                    """
                    Enable/disable the EASM k-omega turbulence model.
                    """
                    return PyMenu(self.service, "/setup/models/viscous/kw_wj_bsl_earsm").execute(*args, **kwargs)

                class transition_model_options(TUIMenu):
                    """
                    Enter the transition model options menu.
                    """
                    def __init__(self, path, service):
                        self.path = path
                        self.service = service
                        super().__init__(path, service)
                    def cfpg_hightu(self, *args, **kwargs):
                        """
                        Set the algebraic transition model coefficient CFPG_HIGHTU.
                        """
                        return PyMenu(self.service, "/setup/models/viscous/transition_model_options/cfpg_hightu").execute(*args, **kwargs)
                    def cbubble_c2(self, *args, **kwargs):
                        """
                        Set the algebraic transition model coefficient CBUBBLE_C2.
                        """
                        return PyMenu(self.service, "/setup/models/viscous/transition_model_options/cbubble_c2").execute(*args, **kwargs)
                    def crossflow_transition(self, *args, **kwargs):
                        """
                        Enable/disable crossflow transition for the intermittency transition model.
                        """
                        return PyMenu(self.service, "/setup/models/viscous/transition_model_options/crossflow_transition").execute(*args, **kwargs)
                    def ctu_hightu(self, *args, **kwargs):
                        """
                        Set the algebraic transition model coefficient CTU_HIGHTU.
                        """
                        return PyMenu(self.service, "/setup/models/viscous/transition_model_options/ctu_hightu").execute(*args, **kwargs)
                    def capg_lowtu(self, *args, **kwargs):
                        """
                        Set the algebraic transition model coefficient CAPG_LOWTU.
                        """
                        return PyMenu(self.service, "/setup/models/viscous/transition_model_options/capg_lowtu").execute(*args, **kwargs)
                    def cbubble_c1(self, *args, **kwargs):
                        """
                        Set the algebraic transition model coefficient CBUBBLE_C1.
                        """
                        return PyMenu(self.service, "/setup/models/viscous/transition_model_options/cbubble_c1").execute(*args, **kwargs)
                    def clambda_scale(self, *args, **kwargs):
                        """
                        Set the algebraic transition model coefficient CLAMBDA_SCALE.
                        """
                        return PyMenu(self.service, "/setup/models/viscous/transition_model_options/clambda_scale").execute(*args, **kwargs)
                    def rec_c1(self, *args, **kwargs):
                        """
                        Set the algebraic transition model coefficient REC_C1.
                        """
                        return PyMenu(self.service, "/setup/models/viscous/transition_model_options/rec_c1").execute(*args, **kwargs)
                    def rv1_switch(self, *args, **kwargs):
                        """
                        Set the algebraic transition model coefficient RV1_SWITCH.
                        """
                        return PyMenu(self.service, "/setup/models/viscous/transition_model_options/rv1_switch").execute(*args, **kwargs)
                    def rec_max(self, *args, **kwargs):
                        """
                        Set the algebraic transition model coefficient REC_MAX.
                        """
                        return PyMenu(self.service, "/setup/models/viscous/transition_model_options/rec_max").execute(*args, **kwargs)
                    def critical_reynolds_number_correlation(self, *args, **kwargs):
                        """
                        Set the critical Reynolds number correlation.
                        """
                        return PyMenu(self.service, "/setup/models/viscous/transition_model_options/critical_reynolds_number_correlation").execute(*args, **kwargs)
                    def capg_hightu(self, *args, **kwargs):
                        """
                        Set the algebraic transition model coefficient CAPG_HIGHTU.
                        """
                        return PyMenu(self.service, "/setup/models/viscous/transition_model_options/capg_hightu").execute(*args, **kwargs)
                    def cfpg_lowtu(self, *args, **kwargs):
                        """
                        Set the algebraic transition model coefficient CFPG_LOWTU.
                        """
                        return PyMenu(self.service, "/setup/models/viscous/transition_model_options/cfpg_lowtu").execute(*args, **kwargs)
                    def rec_c2(self, *args, **kwargs):
                        """
                        Set the algebraic transition model coefficient REC_C2.
                        """
                        return PyMenu(self.service, "/setup/models/viscous/transition_model_options/rec_c2").execute(*args, **kwargs)
                    def ctu_lowtu(self, *args, **kwargs):
                        """
                        Set the algebraic transition model coefficient CTU_LOWTU.
                        """
                        return PyMenu(self.service, "/setup/models/viscous/transition_model_options/ctu_lowtu").execute(*args, **kwargs)

                class multiphase_turbulence(TUIMenu):
                    """
                    Enter the multiphase turbulence menu.
                    """
                    def __init__(self, path, service):
                        self.path = path
                        self.service = service
                        super().__init__(path, service)
                    def turbulence_multiphase_models(self, *args, **kwargs):
                        """
                        Select the k-epsilon multiphase model.
                        """
                        return PyMenu(self.service, "/setup/models/viscous/multiphase_turbulence/turbulence_multiphase_models").execute(*args, **kwargs)
                    def multiphase_options(self, *args, **kwargs):
                        """
                        Enable/disable multiphase options.
                        """
                        return PyMenu(self.service, "/setup/models/viscous/multiphase_turbulence/multiphase_options").execute(*args, **kwargs)
                    def subgrid_turbulence_contribution_aiad(self, *args, **kwargs):
                        """
                        Enable/disable the Subgrid Turbulence Contribution for the AIAD model.
                        """
                        return PyMenu(self.service, "/setup/models/viscous/multiphase_turbulence/subgrid_turbulence_contribution_aiad").execute(*args, **kwargs)
                    def rsm_multiphase_models(self, *args, **kwargs):
                        """
                        Enable/disable the Reynolds Stress multiphase model.
                        """
                        return PyMenu(self.service, "/setup/models/viscous/multiphase_turbulence/rsm_multiphase_models").execute(*args, **kwargs)

                class geko_options(TUIMenu):
                    """
                    Enter the GEKO options menu.
                    """
                    def __init__(self, path, service):
                        self.path = path
                        self.service = service
                        super().__init__(path, service)
                    def cjet_aux(self, *args, **kwargs):
                        """
                        Set the GEKO model coefficient CJET_AUX.
                        """
                        return PyMenu(self.service, "/setup/models/viscous/geko_options/cjet_aux").execute(*args, **kwargs)
                    def geko_defaults(self, *args, **kwargs):
                        """
                        Set GEKO options to default.
                        """
                        return PyMenu(self.service, "/setup/models/viscous/geko_options/geko_defaults").execute(*args, **kwargs)
                    def cbf_tur(self, *args, **kwargs):
                        """
                        Set the GEKO model coefficient CBF_TUR.
                        """
                        return PyMenu(self.service, "/setup/models/viscous/geko_options/cbf_tur").execute(*args, **kwargs)
                    def wall_distance_free(self, *args, **kwargs):
                        """
                        Enable/disable wall-distance-free version of GEKO model.
                        """
                        return PyMenu(self.service, "/setup/models/viscous/geko_options/wall_distance_free").execute(*args, **kwargs)
                    def creal(self, *args, **kwargs):
                        """
                        Set the GEKO model coefficient CREAL.
                        """
                        return PyMenu(self.service, "/setup/models/viscous/geko_options/creal").execute(*args, **kwargs)
                    def csep(self, *args, **kwargs):
                        """
                        Set the GEKO model coefficient CSEP.
                        """
                        return PyMenu(self.service, "/setup/models/viscous/geko_options/csep").execute(*args, **kwargs)
                    def blending_function(self, *args, **kwargs):
                        """
                        Set the GEKO model blending function.
                        """
                        return PyMenu(self.service, "/setup/models/viscous/geko_options/blending_function").execute(*args, **kwargs)
                    def cjet(self, *args, **kwargs):
                        """
                        Set the GEKO model coefficient CJET.
                        """
                        return PyMenu(self.service, "/setup/models/viscous/geko_options/cjet").execute(*args, **kwargs)
                    def cnw_sub(self, *args, **kwargs):
                        """
                        Set the GEKO model coefficient CNW_SUB.
                        """
                        return PyMenu(self.service, "/setup/models/viscous/geko_options/cnw_sub").execute(*args, **kwargs)
                    def cbf_lam(self, *args, **kwargs):
                        """
                        Set the GEKO model coefficient CBF_LAM.
                        """
                        return PyMenu(self.service, "/setup/models/viscous/geko_options/cbf_lam").execute(*args, **kwargs)
                    def cnw(self, *args, **kwargs):
                        """
                        Set the GEKO model coefficient CNW.
                        """
                        return PyMenu(self.service, "/setup/models/viscous/geko_options/cnw").execute(*args, **kwargs)
                    def cmix(self, *args, **kwargs):
                        """
                        Set the GEKO model coefficient CMIX.
                        """
                        return PyMenu(self.service, "/setup/models/viscous/geko_options/cmix").execute(*args, **kwargs)

                class near_wall_treatment(TUIMenu):
                    """
                    Enter the near wall treatment menu.
                    """
                    def __init__(self, path, service):
                        self.path = path
                        self.service = service
                        super().__init__(path, service)
                    def wf_thermal_effects(self, *args, **kwargs):
                        """
                        Enable/disable wall function thermal effects.
                        """
                        return PyMenu(self.service, "/setup/models/viscous/near_wall_treatment/wf_thermal_effects").execute(*args, **kwargs)
                    def user_defined_wall_functions(self, *args, **kwargs):
                        """
                        Enable user defined wall functions.
                        """
                        return PyMenu(self.service, "/setup/models/viscous/near_wall_treatment/user_defined_wall_functions").execute(*args, **kwargs)
                    def menter_lechner(self, *args, **kwargs):
                        """
                        Enable/disable near wall treatment Menter-Lechner.
                        """
                        return PyMenu(self.service, "/setup/models/viscous/near_wall_treatment/menter_lechner").execute(*args, **kwargs)
                    def enhanced_wall_treatment(self, *args, **kwargs):
                        """
                        Enable/disable enhanced wall functions.
                        """
                        return PyMenu(self.service, "/setup/models/viscous/near_wall_treatment/enhanced_wall_treatment").execute(*args, **kwargs)
                    def wall_omega_treatment(self, *args, **kwargs):
                        """
                        Set wall omega treatment.
                        """
                        return PyMenu(self.service, "/setup/models/viscous/near_wall_treatment/wall_omega_treatment").execute(*args, **kwargs)
                    def scalable_wall_functions(self, *args, **kwargs):
                        """
                        Enable/disable scalable wall functions.
                        """
                        return PyMenu(self.service, "/setup/models/viscous/near_wall_treatment/scalable_wall_functions").execute(*args, **kwargs)
                    def werner_wengle_wall_fn(self, *args, **kwargs):
                        """
                        Enable/disable Werner-Wengle wall functions.
                        """
                        return PyMenu(self.service, "/setup/models/viscous/near_wall_treatment/werner_wengle_wall_fn").execute(*args, **kwargs)
                    def non_equilibrium_wall_fn(self, *args, **kwargs):
                        """
                        Enable/disable non-equilibrium wall functions.
                        """
                        return PyMenu(self.service, "/setup/models/viscous/near_wall_treatment/non_equilibrium_wall_fn").execute(*args, **kwargs)
                    def wf_pressure_gradient_effects(self, *args, **kwargs):
                        """
                        Enable/disable wall function pressure-gradient effects.
                        """
                        return PyMenu(self.service, "/setup/models/viscous/near_wall_treatment/wf_pressure_gradient_effects").execute(*args, **kwargs)

                class turbulence_expert(TUIMenu):
                    """
                    Enter the turbulence expert menu.
                    """
                    def __init__(self, path, service):
                        self.path = path
                        self.service = service
                        super().__init__(path, service)
                    def turb_add_sbes_sdes(self, *args, **kwargs):
                        """
                        Enable/disable SBES / SDES with the current turbulence model.
                        """
                        return PyMenu(self.service, "/setup/models/viscous/turbulence_expert/turb_add_sbes_sdes").execute(*args, **kwargs)
                    def sbes_les_subgrid_dynamic_fvar(self, *args, **kwargs):
                        """
                        Enable/disable the dynamic subgrid-scale mixture fraction variance model.
                        """
                        return PyMenu(self.service, "/setup/models/viscous/turbulence_expert/sbes_les_subgrid_dynamic_fvar").execute(*args, **kwargs)
                    def kato_launder_model(self, *args, **kwargs):
                        """
                        Enable/disable Kato-Launder modification for production.
                        """
                        return PyMenu(self.service, "/setup/models/viscous/turbulence_expert/kato_launder_model").execute(*args, **kwargs)
                    def low_re_ke(self, *args, **kwargs):
                        """
                        Enable/disable the low-Re k-epsilon turbulence model.
                        """
                        return PyMenu(self.service, "/setup/models/viscous/turbulence_expert/low_re_ke").execute(*args, **kwargs)
                    def production_limiter(self, *args, **kwargs):
                        """
                        Enable/disable the Production Limiter.
                        """
                        return PyMenu(self.service, "/setup/models/viscous/turbulence_expert/production_limiter").execute(*args, **kwargs)
                    def kw_vorticity_based_production(self, *args, **kwargs):
                        """
                        Enable/disable vorticity based production.
                        """
                        return PyMenu(self.service, "/setup/models/viscous/turbulence_expert/kw_vorticity_based_production").execute(*args, **kwargs)
                    def low_re_ke_index(self, *args, **kwargs):
                        """
                        Enable/disable the low-Re k-epsilon model version.
                        """
                        return PyMenu(self.service, "/setup/models/viscous/turbulence_expert/low_re_ke_index").execute(*args, **kwargs)
                    def sbes_sgs_option(self, *args, **kwargs):
                        """
                        Select SBES subgrid-scale model.
                        """
                        return PyMenu(self.service, "/setup/models/viscous/turbulence_expert/sbes_sgs_option").execute(*args, **kwargs)
                    def turb_non_newtonian(self, *args, **kwargs):
                        """
                        Enable/disable turbulence for non-Newtonian fluids.
                        """
                        return PyMenu(self.service, "/setup/models/viscous/turbulence_expert/turb_non_newtonian").execute(*args, **kwargs)
                    def sbes_sdes_hybrid_model(self, *args, **kwargs):
                        """
                        Select the SBES / SDES hybrid model.
                        """
                        return PyMenu(self.service, "/setup/models/viscous/turbulence_expert/sbes_sdes_hybrid_model").execute(*args, **kwargs)
                    def kw_add_sas(self, *args, **kwargs):
                        """
                        Enable/disable the SAS-mode with the current turbulence model.
                        """
                        return PyMenu(self.service, "/setup/models/viscous/turbulence_expert/kw_add_sas").execute(*args, **kwargs)
                    def kw_add_des(self, *args, **kwargs):
                        """
                        Enable/disable DES-mode with the current turbulence model.
                        """
                        return PyMenu(self.service, "/setup/models/viscous/turbulence_expert/kw_add_des").execute(*args, **kwargs)
                    def thermal_p_function(self, *args, **kwargs):
                        """
                        Enable/disable the Jayatilleke P function.
                        """
                        return PyMenu(self.service, "/setup/models/viscous/turbulence_expert/thermal_p_function").execute(*args, **kwargs)
                    def rke_cmu_rotation_term(self, *args, **kwargs):
                        """
                        Enable/disable inclusion of omega in the Cmu definition.
                        """
                        return PyMenu(self.service, "/setup/models/viscous/turbulence_expert/rke_cmu_rotation_term").execute(*args, **kwargs)
                    def sbes_update_interval_k_omega(self, *args, **kwargs):
                        """
                        Set an integer value how often the k and omega equations are updated in a transient SBES run.
                        """
                        return PyMenu(self.service, "/setup/models/viscous/turbulence_expert/sbes_update_interval_k_omega").execute(*args, **kwargs)
                    def non_newtonian_modification(self, *args, **kwargs):
                        """
                        Enable/disable non-Newtonian modification for Lam-Bremhorst model.
                        """
                        return PyMenu(self.service, "/setup/models/viscous/turbulence_expert/non_newtonian_modification").execute(*args, **kwargs)
                    def turb_pk_compressible(self, *args, **kwargs):
                        """
                        Enable/disable turbulent production due to compressible divergence.
                        """
                        return PyMenu(self.service, "/setup/models/viscous/turbulence_expert/turb_pk_compressible").execute(*args, **kwargs)
                    def restore_sst_v61(self, *args, **kwargs):
                        """
                        Enable/disable SST formulation of v6.1.
                        """
                        return PyMenu(self.service, "/setup/models/viscous/turbulence_expert/restore_sst_v61").execute(*args, **kwargs)
                    def turbulence_damping(self, *args, **kwargs):
                        """
                        Enable/disable turbulence damping and set turbulence damping parameters.
                        """
                        return PyMenu(self.service, "/setup/models/viscous/turbulence_expert/turbulence_damping").execute(*args, **kwargs)

            class optics(TUIMenu):
                """
                Enter the optics model menu.
                """
                def __init__(self, path, service):
                    self.path = path
                    self.service = service
                    self.statistics = self.__class__.statistics(path + ["statistics"], service)
                    self.beams = self.__class__.beams(path + ["beams"], service)
                    super().__init__(path, service)
                def enable(self, *args, **kwargs):
                    """
                    .
                    """
                    return PyMenu(self.service, "/setup/models/optics/enable").execute(*args, **kwargs)
                def report(self, *args, **kwargs):
                    """
                    .
                    """
                    return PyMenu(self.service, "/setup/models/optics/report").execute(*args, **kwargs)
                def verbosity(self, *args, **kwargs):
                    """
                    .
                    """
                    return PyMenu(self.service, "/setup/models/optics/verbosity").execute(*args, **kwargs)
                def sampling_iterations(self, *args, **kwargs):
                    """
                    .
                    """
                    return PyMenu(self.service, "/setup/models/optics/sampling_iterations").execute(*args, **kwargs)
                def index_of_refraction(self, *args, **kwargs):
                    """
                    .
                    """
                    return PyMenu(self.service, "/setup/models/optics/index_of_refraction").execute(*args, **kwargs)

                class statistics(TUIMenu):
                    """
                    .
                    """
                    def __init__(self, path, service):
                        self.path = path
                        self.service = service
                        super().__init__(path, service)
                    def reset_statistics(self, *args, **kwargs):
                        """
                        .
                        """
                        return PyMenu(self.service, "/setup/models/optics/statistics/reset_statistics").execute(*args, **kwargs)
                    def statistics_controls(self, *args, **kwargs):
                        """
                        .
                        """
                        return PyMenu(self.service, "/setup/models/optics/statistics/statistics_controls").execute(*args, **kwargs)

                class beams(TUIMenu):
                    """
                    .
                    """
                    def __init__(self, path, service):
                        self.path = path
                        self.service = service
                        super().__init__(path, service)
                    def list_beam_parameters(self, *args, **kwargs):
                        """
                        .
                        """
                        return PyMenu(self.service, "/setup/models/optics/beams/list_beam_parameters").execute(*args, **kwargs)
                    def delete(self, *args, **kwargs):
                        """
                        Delete object.
                        """
                        return PyMenu(self.service, "/setup/models/optics/beams/delete").execute(*args, **kwargs)
                    def add(self, *args, **kwargs):
                        """
                        Create a new beams object.
                        """
                        return PyMenu(self.service, "/setup/models/optics/beams/add").execute(*args, **kwargs)
                    def copy(self, *args, **kwargs):
                        """
                        .
                        """
                        return PyMenu(self.service, "/setup/models/optics/beams/copy").execute(*args, **kwargs)
                    def edit(self, *args, **kwargs):
                        """
                        Edit beams object.
                        """
                        return PyMenu(self.service, "/setup/models/optics/beams/edit").execute(*args, **kwargs)
                    def rename(self, *args, **kwargs):
                        """
                        Rename object.
                        """
                        return PyMenu(self.service, "/setup/models/optics/beams/rename").execute(*args, **kwargs)

            class acoustics(TUIMenu):
                """
                Enter the acoustics model menu.
                """
                def __init__(self, path, service):
                    self.path = path
                    self.service = service
                    self.wave_equation_options = self.__class__.wave_equation_options(path + ["wave_equation_options"], service)
                    self.sources_fft = self.__class__.sources_fft(path + ["sources_fft"], service)
                    self.far_field_parameters = self.__class__.far_field_parameters(path + ["far_field_parameters"], service)
                    self.sponge_layers = self.__class__.sponge_layers(path + ["sponge_layers"], service)
                    super().__init__(path, service)
                def broad_band_noise(self, *args, **kwargs):
                    """
                    Enable/disable the broadband noise model.
                    """
                    return PyMenu(self.service, "/setup/models/acoustics/broad_band_noise").execute(*args, **kwargs)
                def moving_receiver(self, *args, **kwargs):
                    """
                    Enable/disable moving receiver option.
                    """
                    return PyMenu(self.service, "/setup/models/acoustics/moving_receiver").execute(*args, **kwargs)
                def modal_analysis(self, *args, **kwargs):
                    """
                    Enable/disable the modal analysis model.
                    """
                    return PyMenu(self.service, "/setup/models/acoustics/modal_analysis").execute(*args, **kwargs)
                def export_volumetric_sources(self, *args, **kwargs):
                    """
                    Enable/disable the export of fluid zones.
                    """
                    return PyMenu(self.service, "/setup/models/acoustics/export_volumetric_sources").execute(*args, **kwargs)
                def auto_prune(self, *args, **kwargs):
                    """
                    Enable/disable auto prune of the receiver signal(s) during read-and-compute.
                    """
                    return PyMenu(self.service, "/setup/models/acoustics/auto_prune").execute(*args, **kwargs)
                def ffowcs_williams(self, *args, **kwargs):
                    """
                    Enable/disable the Ffowcs-Williams-and-Hawkings model.
                    """
                    return PyMenu(self.service, "/setup/models/acoustics/ffowcs_williams").execute(*args, **kwargs)
                def off(self, *args, **kwargs):
                    """
                    Enable/disable the acoustics model.
                    """
                    return PyMenu(self.service, "/setup/models/acoustics/off").execute(*args, **kwargs)
                def read_compute_write(self, *args, **kwargs):
                    """
                    Read acoustic source data files and compute sound pressure.
                    """
                    return PyMenu(self.service, "/setup/models/acoustics/read_compute_write").execute(*args, **kwargs)
                def receivers(self, *args, **kwargs):
                    """
                    Set acoustic receivers.
                    """
                    return PyMenu(self.service, "/setup/models/acoustics/receivers").execute(*args, **kwargs)
                def compute_write(self, *args, **kwargs):
                    """
                    Compute sound pressure.
                    """
                    return PyMenu(self.service, "/setup/models/acoustics/compute_write").execute(*args, **kwargs)
                def wave_equation(self, *args, **kwargs):
                    """
                    Enable/disable the wave equation model.
                    """
                    return PyMenu(self.service, "/setup/models/acoustics/wave_equation").execute(*args, **kwargs)
                def cylindrical_export(self, *args, **kwargs):
                    """
                    Enable/disable the export data in cylindrical coordinates.
                    """
                    return PyMenu(self.service, "/setup/models/acoustics/cylindrical_export").execute(*args, **kwargs)
                def display_frequencies(self, *args, **kwargs):
                    """
                    Display resonance frequencies.
                    """
                    return PyMenu(self.service, "/setup/models/acoustics/display_frequencies").execute(*args, **kwargs)
                def export_source_data_cgns(self, *args, **kwargs):
                    """
                    Export acoustic source data in CGNS format.
                    """
                    return PyMenu(self.service, "/setup/models/acoustics/export_source_data_cgns").execute(*args, **kwargs)
                def export_source_data(self, *args, **kwargs):
                    """
                    Enable export acoustic source data in ASD format during the wave equation model run.
                    """
                    return PyMenu(self.service, "/setup/models/acoustics/export_source_data").execute(*args, **kwargs)
                def write_centroid_info(self, *args, **kwargs):
                    """
                    Write centroid info.
                    """
                    return PyMenu(self.service, "/setup/models/acoustics/write_centroid_info").execute(*args, **kwargs)
                def sources(self, *args, **kwargs):
                    """
                    Set acoustic sources.
                    """
                    return PyMenu(self.service, "/setup/models/acoustics/sources").execute(*args, **kwargs)
                def export_volumetric_sources_cgns(self, *args, **kwargs):
                    """
                    Enable/disable the export of fluid zones.
                    """
                    return PyMenu(self.service, "/setup/models/acoustics/export_volumetric_sources_cgns").execute(*args, **kwargs)
                def convective_effects(self, *args, **kwargs):
                    """
                    Enable/disable convective effects option.
                    """
                    return PyMenu(self.service, "/setup/models/acoustics/convective_effects").execute(*args, **kwargs)
                def display_flow_time(self, *args, **kwargs):
                    """
                    Enable/disable the display of flow time during read-and-compute.
                    """
                    return PyMenu(self.service, "/setup/models/acoustics/display_flow_time").execute(*args, **kwargs)
                def write_acoustic_signals(self, *args, **kwargs):
                    """
                    Write on-the-fly sound pressure.
                    """
                    return PyMenu(self.service, "/setup/models/acoustics/write_acoustic_signals").execute(*args, **kwargs)
                def acoustic_modal_analysis(self, *args, **kwargs):
                    """
                    Iterate linear acoustic solver to compute the resonance frequencies and the acoustic modes.
                    """
                    return PyMenu(self.service, "/setup/models/acoustics/acoustic_modal_analysis").execute(*args, **kwargs)

                class wave_equation_options(TUIMenu):
                    """
                    Enter the options menu for the wave equation model.
                    """
                    def __init__(self, path, service):
                        self.path = path
                        self.service = service
                        self.basic_shapes = self.__class__.basic_shapes(path + ["basic_shapes"], service)
                        self.remote_receivers_options = self.__class__.remote_receivers_options(path + ["remote_receivers_options"], service)
                        super().__init__(path, service)
                    def source_mask_udf(self, *args, **kwargs):
                        """
                        Select user-defined function for sound source masking.
                        """
                        return PyMenu(self.service, "/setup/models/acoustics/wave_equation_options/source_mask_udf").execute(*args, **kwargs)
                    def sponge_layer_base_level(self, *args, **kwargs):
                        """
                        Specify artificial viscosity base level applied everywhere.
                        """
                        return PyMenu(self.service, "/setup/models/acoustics/wave_equation_options/sponge_layer_base_level").execute(*args, **kwargs)
                    def sponge_layer_factor(self, *args, **kwargs):
                        """
                        Specify artificial viscosity factor for sponge layer.
                        """
                        return PyMenu(self.service, "/setup/models/acoustics/wave_equation_options/sponge_layer_factor").execute(*args, **kwargs)
                    def remote_receivers(self, *args, **kwargs):
                        """
                        Activate the Kirchhoff's integral method for remote receivers.
                        """
                        return PyMenu(self.service, "/setup/models/acoustics/wave_equation_options/remote_receivers").execute(*args, **kwargs)
                    def sponge_layer_udf(self, *args, **kwargs):
                        """
                        Select user-defined function for sponge layer.
                        """
                        return PyMenu(self.service, "/setup/models/acoustics/wave_equation_options/sponge_layer_udf").execute(*args, **kwargs)
                    def time_filter_source(self, *args, **kwargs):
                        """
                        Activate time-filtering of sound sources.
                        """
                        return PyMenu(self.service, "/setup/models/acoustics/wave_equation_options/time_filter_source").execute(*args, **kwargs)

                    class basic_shapes(TUIMenu):
                        """
                        Enter the basic shapes menu to build source mask and sponge layer
                        geometry shapes using cell registers.
                        """
                        def __init__(self, path, service):
                            self.path = path
                            self.service = service
                            super().__init__(path, service)
                        def remove_source_mask_shape(self, *args, **kwargs):
                            """
                            Remove a region register from the source mask.
                            """
                            return PyMenu(self.service, "/setup/models/acoustics/wave_equation_options/basic_shapes/remove_source_mask_shape").execute(*args, **kwargs)
                        def add_source_mask_shape(self, *args, **kwargs):
                            """
                            Add a region register for the source mask.
                            """
                            return PyMenu(self.service, "/setup/models/acoustics/wave_equation_options/basic_shapes/add_source_mask_shape").execute(*args, **kwargs)
                        def list_sponge_layer_shapes(self, *args, **kwargs):
                            """
                            List all active sponge layer registers.
                            """
                            return PyMenu(self.service, "/setup/models/acoustics/wave_equation_options/basic_shapes/list_sponge_layer_shapes").execute(*args, **kwargs)
                        def list_region_registers(self, *args, **kwargs):
                            """
                            List all available region registers (hex/cylinder/sphere).
                            """
                            return PyMenu(self.service, "/setup/models/acoustics/wave_equation_options/basic_shapes/list_region_registers").execute(*args, **kwargs)
                        def list_source_mask_shapes(self, *args, **kwargs):
                            """
                            List all active source mask registers.
                            """
                            return PyMenu(self.service, "/setup/models/acoustics/wave_equation_options/basic_shapes/list_source_mask_shapes").execute(*args, **kwargs)
                        def add_sponge_layer_shape(self, *args, **kwargs):
                            """
                            Add a region register for the sponge layer.
                            """
                            return PyMenu(self.service, "/setup/models/acoustics/wave_equation_options/basic_shapes/add_sponge_layer_shape").execute(*args, **kwargs)
                        def remove_sponge_layer_shape(self, *args, **kwargs):
                            """
                            Remove a region register from the sponge layer.
                            """
                            return PyMenu(self.service, "/setup/models/acoustics/wave_equation_options/basic_shapes/remove_sponge_layer_shape").execute(*args, **kwargs)

                    class remote_receivers_options(TUIMenu):
                        """
                        Enter the menu to set up the Kirchhoff's integral method and output its results.
                        """
                        def __init__(self, path, service):
                            self.path = path
                            self.service = service
                            super().__init__(path, service)
                        def write_signals(self, *args, **kwargs):
                            """
                            Write signals calculated at receiver locations.
                            """
                            return PyMenu(self.service, "/setup/models/acoustics/wave_equation_options/remote_receivers_options/write_signals").execute(*args, **kwargs)
                        def integration_surface(self, *args, **kwargs):
                            """
                            Select Kirchhoff's integration surface.
                            """
                            return PyMenu(self.service, "/setup/models/acoustics/wave_equation_options/remote_receivers_options/integration_surface").execute(*args, **kwargs)

                class sources_fft(TUIMenu):
                    """
                    Enter the acoustic sources FFT menu.
                    """
                    def __init__(self, path, service):
                        self.path = path
                        self.service = service
                        self.fft_surface_variables = self.__class__.fft_surface_variables(path + ["fft_surface_variables"], service)
                        super().__init__(path, service)
                    def clean_up_storage_area(self, *args, **kwargs):
                        """
                        Clean up storage area.
                        """
                        return PyMenu(self.service, "/setup/models/acoustics/sources_fft/clean_up_storage_area").execute(*args, **kwargs)
                    def read_asd_files(self, *args, **kwargs):
                        """
                        Read ASD files.
                        """
                        return PyMenu(self.service, "/setup/models/acoustics/sources_fft/read_asd_files").execute(*args, **kwargs)
                    def compute_fft_fields(self, *args, **kwargs):
                        """
                        Compute FFT fields.
                        """
                        return PyMenu(self.service, "/setup/models/acoustics/sources_fft/compute_fft_fields").execute(*args, **kwargs)
                    def write_cgns_files(self, *args, **kwargs):
                        """
                        Write CGNS files.
                        """
                        return PyMenu(self.service, "/setup/models/acoustics/sources_fft/write_cgns_files").execute(*args, **kwargs)

                    class fft_surface_variables(TUIMenu):
                        """
                        Enter the FFT surface variables menu.
                        """
                        def __init__(self, path, service):
                            self.path = path
                            self.service = service
                            super().__init__(path, service)
                        def create_set_of_modes(self, *args, **kwargs):
                            """
                            Create set of modes.
                            """
                            return PyMenu(self.service, "/setup/models/acoustics/sources_fft/fft_surface_variables/create_set_of_modes").execute(*args, **kwargs)
                        def create_octave_bands(self, *args, **kwargs):
                            """
                            Create octave bands.
                            """
                            return PyMenu(self.service, "/setup/models/acoustics/sources_fft/fft_surface_variables/create_octave_bands").execute(*args, **kwargs)
                        def create_third_bands(self, *args, **kwargs):
                            """
                            Create third bands.
                            """
                            return PyMenu(self.service, "/setup/models/acoustics/sources_fft/fft_surface_variables/create_third_bands").execute(*args, **kwargs)
                        def remove_variables(self, *args, **kwargs):
                            """
                            Remove variables.
                            """
                            return PyMenu(self.service, "/setup/models/acoustics/sources_fft/fft_surface_variables/remove_variables").execute(*args, **kwargs)
                        def create_constant_width_bands(self, *args, **kwargs):
                            """
                            Create constant-width bands.
                            """
                            return PyMenu(self.service, "/setup/models/acoustics/sources_fft/fft_surface_variables/create_constant_width_bands").execute(*args, **kwargs)

                class far_field_parameters(TUIMenu):
                    """
                    Enter the far field parameters menu for the wave equation model.
                    """
                    def __init__(self, path, service):
                        self.path = path
                        self.service = service
                        super().__init__(path, service)
                    def far_field_sound_speed(self, *args, **kwargs):
                        """
                        Specify far field speed of sound.
                        """
                        return PyMenu(self.service, "/setup/models/acoustics/far_field_parameters/far_field_sound_speed").execute(*args, **kwargs)
                    def far_field_density(self, *args, **kwargs):
                        """
                        Specify far field density.
                        """
                        return PyMenu(self.service, "/setup/models/acoustics/far_field_parameters/far_field_density").execute(*args, **kwargs)

                class sponge_layers(TUIMenu):
                    """
                    Manage sponge layers where density is blended to eliminate reflections from boundary zones.
                    """
                    def __init__(self, path, service):
                        self.path = path
                        self.service = service
                        super().__init__(path, service)
                    def list_active(self, *args, **kwargs):
                        """
                        List the names of the active sponge layer definitions.
                        """
                        return PyMenu(self.service, "/setup/models/acoustics/sponge_layers/list_active").execute(*args, **kwargs)
                    def list_properties(self, *args, **kwargs):
                        """
                        List the properties of a sponge layer definition.
                        """
                        return PyMenu(self.service, "/setup/models/acoustics/sponge_layers/list_properties").execute(*args, **kwargs)
                    def delete(self, *args, **kwargs):
                        """
                        Delete a sponge layer definition.
                        """
                        return PyMenu(self.service, "/setup/models/acoustics/sponge_layers/delete").execute(*args, **kwargs)
                    def list(self, *args, **kwargs):
                        """
                        List the names of the sponge layer definitions.
                        """
                        return PyMenu(self.service, "/setup/models/acoustics/sponge_layers/list").execute(*args, **kwargs)
                    def add(self, *args, **kwargs):
                        """
                        Add a new sponge layer definition.
                        """
                        return PyMenu(self.service, "/setup/models/acoustics/sponge_layers/add").execute(*args, **kwargs)
                    def deactivate(self, *args, **kwargs):
                        """
                        Deactivate a sponge layer definition.
                        """
                        return PyMenu(self.service, "/setup/models/acoustics/sponge_layers/deactivate").execute(*args, **kwargs)
                    def edit(self, *args, **kwargs):
                        """
                        Edit a sponge layer definition.
                        """
                        return PyMenu(self.service, "/setup/models/acoustics/sponge_layers/edit").execute(*args, **kwargs)
                    def activate(self, *args, **kwargs):
                        """
                        Activate a sponge object.
                        """
                        return PyMenu(self.service, "/setup/models/acoustics/sponge_layers/activate").execute(*args, **kwargs)

            class solver(TUIMenu):
                """
                Enter the menu to select the solver.
                """
                def __init__(self, path, service):
                    self.path = path
                    self.service = service
                    super().__init__(path, service)
                def adjust_solver_defaults_based_on_setup(self, *args, **kwargs):
                    """
                    Enable/disable adjustment of solver defaults based on setup.
                    """
                    return PyMenu(self.service, "/setup/models/solver/adjust_solver_defaults_based_on_setup").execute(*args, **kwargs)
                def density_based_implicit(self, *args, **kwargs):
                    """
                    Enable/disable the coupled-implicit solver.
                    """
                    return PyMenu(self.service, "/setup/models/solver/density_based_implicit").execute(*args, **kwargs)
                def density_based_explicit(self, *args, **kwargs):
                    """
                    Enable/disable the coupled-explicit solver.
                    """
                    return PyMenu(self.service, "/setup/models/solver/density_based_explicit").execute(*args, **kwargs)
                def pressure_based(self, *args, **kwargs):
                    """
                    Enable/disable the segregated solver.
                    """
                    return PyMenu(self.service, "/setup/models/solver/pressure_based").execute(*args, **kwargs)

            class heat_exchanger(TUIMenu):
                """
                Enter the heat exchanger menu.
                """
                def __init__(self, path, service):
                    self.path = path
                    self.service = service
                    self.macro_model = self.__class__.macro_model(path + ["macro_model"], service)
                    self.dual_cell_model = self.__class__.dual_cell_model(path + ["dual_cell_model"], service)
                    super().__init__(path, service)

                class macro_model(TUIMenu):
                    """
                    Enter the heat macro-model menu.
                    """
                    def __init__(self, path, service):
                        self.path = path
                        self.service = service
                        super().__init__(path, service)
                    def heat_exchanger_report(self, *args, **kwargs):
                        """
                        Report heat-exchanger information.
                        """
                        return PyMenu(self.service, "/setup/models/heat_exchanger/macro_model/heat_exchanger_report").execute(*args, **kwargs)
                    def write_NTU(self, *args, **kwargs):
                        """
                        Write NTU vs primary mass flow rate for each auxiliary mass flow rate.
                        """
                        return PyMenu(self.service, "/setup/models/heat_exchanger/macro_model/write_NTU").execute(*args, **kwargs)
                    def heat_exchanger(self, *args, **kwargs):
                        """
                        Enable/disable heat-exchanger model.
                        """
                        return PyMenu(self.service, "/setup/models/heat_exchanger/macro_model/heat_exchanger").execute(*args, **kwargs)
                    def heat_exchanger_group(self, *args, **kwargs):
                        """
                        Define heat-exchanger group.
                        """
                        return PyMenu(self.service, "/setup/models/heat_exchanger/macro_model/heat_exchanger_group").execute(*args, **kwargs)
                    def heat_exchanger_zone(self, *args, **kwargs):
                        """
                        Define heat-exchanger zone.
                        """
                        return PyMenu(self.service, "/setup/models/heat_exchanger/macro_model/heat_exchanger_zone").execute(*args, **kwargs)
                    def heat_exchanger_macro_report(self, *args, **kwargs):
                        """
                        Report heat-exchanger information for all the macros.
                        """
                        return PyMenu(self.service, "/setup/models/heat_exchanger/macro_model/heat_exchanger_macro_report").execute(*args, **kwargs)
                    def delete_heat_exchanger_group(self, *args, **kwargs):
                        """
                        Delete heat-exchanger group.
                        """
                        return PyMenu(self.service, "/setup/models/heat_exchanger/macro_model/delete_heat_exchanger_group").execute(*args, **kwargs)
                    def plot_NTU(self, *args, **kwargs):
                        """
                        Plot NTU vs primary mass flow rate for each auxiliary mass flow rate.
                        """
                        return PyMenu(self.service, "/setup/models/heat_exchanger/macro_model/plot_NTU").execute(*args, **kwargs)
                    def heat_exchanger_model(self, *args, **kwargs):
                        """
                        Define heat-exchanger core model.
                        """
                        return PyMenu(self.service, "/setup/models/heat_exchanger/macro_model/heat_exchanger_model").execute(*args, **kwargs)

                class dual_cell_model(TUIMenu):
                    """
                    Enter the dual cell model menu.
                    """
                    def __init__(self, path, service):
                        self.path = path
                        self.service = service
                        super().__init__(path, service)
                    def alternative_formulation(self, *args, **kwargs):
                        """
                        Enable/disable alternative formulation for heat transfer calculations.
                        """
                        return PyMenu(self.service, "/setup/models/heat_exchanger/dual_cell_model/alternative_formulation").execute(*args, **kwargs)
                    def write_NTU(self, *args, **kwargs):
                        """
                        Write NTU vs primary mass flow rate for each auxiliary mass flow rate.
                        """
                        return PyMenu(self.service, "/setup/models/heat_exchanger/dual_cell_model/write_NTU").execute(*args, **kwargs)
                    def modify_heat_exchanger(self, *args, **kwargs):
                        """
                        Modify heat-exchanger.
                        """
                        return PyMenu(self.service, "/setup/models/heat_exchanger/dual_cell_model/modify_heat_exchanger").execute(*args, **kwargs)
                    def plot_NTU(self, *args, **kwargs):
                        """
                        Plot NTU vs primary mass flow rate for each auxiliary mass flow rate.
                        """
                        return PyMenu(self.service, "/setup/models/heat_exchanger/dual_cell_model/plot_NTU").execute(*args, **kwargs)
                    def heat_exchanger(self, *args, **kwargs):
                        """
                        Enable/disable the dual cell heat-exchanger model.
                        """
                        return PyMenu(self.service, "/setup/models/heat_exchanger/dual_cell_model/heat_exchanger").execute(*args, **kwargs)
                    def add_heat_exchanger(self, *args, **kwargs):
                        """
                        Add heat-exchanger.
                        """
                        return PyMenu(self.service, "/setup/models/heat_exchanger/dual_cell_model/add_heat_exchanger").execute(*args, **kwargs)
                    def delete_heat_exchanger(self, *args, **kwargs):
                        """
                        Delete heat-exchanger.
                        """
                        return PyMenu(self.service, "/setup/models/heat_exchanger/dual_cell_model/delete_heat_exchanger").execute(*args, **kwargs)

            class electrolysis(TUIMenu):
                """
                Enter the electrolysis model setup menu.
                """
                def __init__(self, path, service):
                    self.path = path
                    self.service = service
                    self.anode_setup = self.__class__.anode_setup(path + ["anode_setup"], service)
                    self.membrane_setup = self.__class__.membrane_setup(path + ["membrane_setup"], service)
                    self.cathode_setup = self.__class__.cathode_setup(path + ["cathode_setup"], service)
                    super().__init__(path, service)
                def parameters(self, *args, **kwargs):
                    """
                    Specify electrolysis model parameters.
                    """
                    return PyMenu(self.service, "/setup/models/electrolysis/parameters").execute(*args, **kwargs)
                def model_options(self, *args, **kwargs):
                    """
                    Specify electrolysis model options.
                    """
                    return PyMenu(self.service, "/setup/models/electrolysis/model_options").execute(*args, **kwargs)
                def electrical_tabs_setup(self, *args, **kwargs):
                    """
                    Specify settings for the electrical tabs.
                    """
                    return PyMenu(self.service, "/setup/models/electrolysis/electrical_tabs_setup").execute(*args, **kwargs)

                class anode_setup(TUIMenu):
                    """
                    Enter the menu for the anode controls.
                    """
                    def __init__(self, path, service):
                        self.path = path
                        self.service = service
                        super().__init__(path, service)
                    def flow_channel(self, *args, **kwargs):
                        """
                        Set parameters for the flow channel.
                        """
                        return PyMenu(self.service, "/setup/models/electrolysis/anode_setup/flow_channel").execute(*args, **kwargs)
                    def catalyst_layer(self, *args, **kwargs):
                        """
                        Set parameters for the catalyst layer.
                        """
                        return PyMenu(self.service, "/setup/models/electrolysis/anode_setup/catalyst_layer").execute(*args, **kwargs)
                    def porous_layer(self, *args, **kwargs):
                        """
                        Set parameters for the porous layer.
                        """
                        return PyMenu(self.service, "/setup/models/electrolysis/anode_setup/porous_layer").execute(*args, **kwargs)
                    def current_collector(self, *args, **kwargs):
                        """
                        Set parameters for the current collector.
                        """
                        return PyMenu(self.service, "/setup/models/electrolysis/anode_setup/current_collector").execute(*args, **kwargs)
                    def electrolyte(self, *args, **kwargs):
                        """
                        Set parameters for the electrolyte.
                        """
                        return PyMenu(self.service, "/setup/models/electrolysis/anode_setup/electrolyte").execute(*args, **kwargs)

                class membrane_setup(TUIMenu):
                    """
                    Specify parameters for electrolyte.
                    """
                    def __init__(self, path, service):
                        self.path = path
                        self.service = service
                        super().__init__(path, service)
                    def catalyst_layer(self, *args, **kwargs):
                        """
                        Set parameters for the catalyst layer.
                        """
                        return PyMenu(self.service, "/setup/models/electrolysis/membrane_setup/catalyst_layer").execute(*args, **kwargs)
                    def flow_channel(self, *args, **kwargs):
                        """
                        Set parameters for the flow channel.
                        """
                        return PyMenu(self.service, "/setup/models/electrolysis/membrane_setup/flow_channel").execute(*args, **kwargs)
                    def porous_layer(self, *args, **kwargs):
                        """
                        Set parameters for the porous layer.
                        """
                        return PyMenu(self.service, "/setup/models/electrolysis/membrane_setup/porous_layer").execute(*args, **kwargs)
                    def electrolyte(self, *args, **kwargs):
                        """
                        Set parameters for the electrolyte.
                        """
                        return PyMenu(self.service, "/setup/models/electrolysis/membrane_setup/electrolyte").execute(*args, **kwargs)
                    def current_collector(self, *args, **kwargs):
                        """
                        Set parameters for the current collector.
                        """
                        return PyMenu(self.service, "/setup/models/electrolysis/membrane_setup/current_collector").execute(*args, **kwargs)

                class cathode_setup(TUIMenu):
                    """
                    Enter the menu for the cathode controls.
                    """
                    def __init__(self, path, service):
                        self.path = path
                        self.service = service
                        super().__init__(path, service)
                    def flow_channel(self, *args, **kwargs):
                        """
                        Set parameters for the flow channel.
                        """
                        return PyMenu(self.service, "/setup/models/electrolysis/cathode_setup/flow_channel").execute(*args, **kwargs)
                    def current_collector(self, *args, **kwargs):
                        """
                        Set parameters for the current collector.
                        """
                        return PyMenu(self.service, "/setup/models/electrolysis/cathode_setup/current_collector").execute(*args, **kwargs)
                    def porous_layer(self, *args, **kwargs):
                        """
                        Set parameters for the porous layer.
                        """
                        return PyMenu(self.service, "/setup/models/electrolysis/cathode_setup/porous_layer").execute(*args, **kwargs)
                    def electrolyte(self, *args, **kwargs):
                        """
                        Set parameters for the electrolyte.
                        """
                        return PyMenu(self.service, "/setup/models/electrolysis/cathode_setup/electrolyte").execute(*args, **kwargs)
                    def catalyst_layer(self, *args, **kwargs):
                        """
                        Set parameters for the catalyst layer.
                        """
                        return PyMenu(self.service, "/setup/models/electrolysis/cathode_setup/catalyst_layer").execute(*args, **kwargs)

            class system_coupling_settings(TUIMenu):
                """
                Enter the system coupling model menu.
                """
                def __init__(self, path, service):
                    self.path = path
                    self.service = service
                    self.htc = self.__class__.htc(path + ["htc"], service)
                    super().__init__(path, service)
                def use_face_or_element_based_data_transfer(self, *args, **kwargs):
                    """
                    Enable/disable face based data transfer.
                    """
                    return PyMenu(self.service, "/setup/models/system_coupling_settings/use_face_or_element_based_data_transfer").execute(*args, **kwargs)
                def specify_system_coupling_volumetric_cell_zones(self, *args, **kwargs):
                    """
                    Enable/disable volumetric cell zones.
                    """
                    return PyMenu(self.service, "/setup/models/system_coupling_settings/specify_system_coupling_volumetric_cell_zones").execute(*args, **kwargs)
                def update_rigid_body_mesh_motion_before_mesh_transfer(self, *args, **kwargs):
                    """
                    SC Enable/disable mesh motion.
                    """
                    return PyMenu(self.service, "/setup/models/system_coupling_settings/update_rigid_body_mesh_motion_before_mesh_transfer").execute(*args, **kwargs)

                class htc(TUIMenu):
                    """
                    Enter the heat transfer coeficient menu.
                    """
                    def __init__(self, path, service):
                        self.path = path
                        self.service = service
                        self.htc_calculation_method = self.__class__.htc_calculation_method(path + ["htc_calculation_method"], service)
                        self.unsteady_statistics = self.__class__.unsteady_statistics(path + ["unsteady_statistics"], service)
                        super().__init__(path, service)

                    class htc_calculation_method(TUIMenu):
                        """
                        Enter the htc calculation menu.
                        """
                        def __init__(self, path, service):
                            self.path = path
                            self.service = service
                            super().__init__(path, service)
                        def use_wall_function_based_htc(self, *args, **kwargs):
                            """
                            Enable/disable wall function based htc computation.
                            """
                            return PyMenu(self.service, "/setup/models/system_coupling_settings/htc/htc_calculation_method/use_wall_function_based_htc").execute(*args, **kwargs)
                        def use_yplus_based_htc_calculation(self, *args, **kwargs):
                            """
                            Enable/disable yplus in htc computation.
                            """
                            return PyMenu(self.service, "/setup/models/system_coupling_settings/htc/htc_calculation_method/use_yplus_based_htc_calculation").execute(*args, **kwargs)
                        def use_tref_in_htc_calculation(self, *args, **kwargs):
                            """
                            Enable/disable tref in htc computation.
                            """
                            return PyMenu(self.service, "/setup/models/system_coupling_settings/htc/htc_calculation_method/use_tref_in_htc_calculation").execute(*args, **kwargs)

                    class unsteady_statistics(TUIMenu):
                        """
                        Enter the unsteady statistics menu.
                        """
                        def __init__(self, path, service):
                            self.path = path
                            self.service = service
                            super().__init__(path, service)
                        def sc_enable_sub_stepping_option_per_coupling_step(self, *args, **kwargs):
                            """
                            Enable/disable sub stepping option per coupling step.
                            """
                            return PyMenu(self.service, "/setup/models/system_coupling_settings/htc/unsteady_statistics/sc_enable_sub_stepping_option_per_coupling_step").execute(*args, **kwargs)

            class multiphase(TUIMenu):
                """
                Define multiphase model menu.
                """
                def __init__(self, path, service):
                    self.path = path
                    self.service = service
                    self.explicit_expert_options = self.__class__.explicit_expert_options(path + ["explicit_expert_options"], service)
                    self.hybrid_models = self.__class__.hybrid_models(path + ["hybrid_models"], service)
                    self.wet_steam = self.__class__.wet_steam(path + ["wet_steam"], service)
                    self.population_balance = self.__class__.population_balance(path + ["population_balance"], service)
                    self.sub_models = self.__class__.sub_models(path + ["sub_models"], service)
                    self.phases = self.__class__.phases(path + ["phases"], service)
                    self.flow_regime_modeling = self.__class__.flow_regime_modeling(path + ["flow_regime_modeling"], service)
                    super().__init__(path, service)
                def volume_fraction_parameters(self, *args, **kwargs):
                    """
                    Volume fraction parameters.
                    """
                    return PyMenu(self.service, "/setup/models/multiphase/volume_fraction_parameters").execute(*args, **kwargs)
                def coupled_level_set(self, *args, **kwargs):
                    """
                    Coupled level set.
                    """
                    return PyMenu(self.service, "/setup/models/multiphase/coupled_level_set").execute(*args, **kwargs)
                def regime_transition_modeling(self, *args, **kwargs):
                    """
                    Regime-transition-modeling-options.
                    """
                    return PyMenu(self.service, "/setup/models/multiphase/regime_transition_modeling").execute(*args, **kwargs)
                def vof_sub_models(self, *args, **kwargs):
                    """
                    VOF sub-models.
                    """
                    return PyMenu(self.service, "/setup/models/multiphase/vof_sub_models").execute(*args, **kwargs)
                def mixture_parameters(self, *args, **kwargs):
                    """
                    Mixture parameters.
                    """
                    return PyMenu(self.service, "/setup/models/multiphase/mixture_parameters").execute(*args, **kwargs)
                def model(self, *args, **kwargs):
                    """
                    Specify multiphase model.
                    """
                    return PyMenu(self.service, "/setup/models/multiphase/model").execute(*args, **kwargs)
                def interface_modeling_options(self, *args, **kwargs):
                    """
                    Interface Modeling Options.
                    """
                    return PyMenu(self.service, "/setup/models/multiphase/interface_modeling_options").execute(*args, **kwargs)
                def number_of_phases(self, *args, **kwargs):
                    """
                    Specify the number of phases.
                    """
                    return PyMenu(self.service, "/setup/models/multiphase/number_of_phases").execute(*args, **kwargs)
                def body_force_formulation(self, *args, **kwargs):
                    """
                    Body force formulation.
                    """
                    return PyMenu(self.service, "/setup/models/multiphase/body_force_formulation").execute(*args, **kwargs)

                class explicit_expert_options(TUIMenu):
                    """
                    Expert options for explicit formulation.
                    """
                    def __init__(self, path, service):
                        self.path = path
                        self.service = service
                        self.volume_fraction_filtering = self.__class__.volume_fraction_filtering(path + ["volume_fraction_filtering"], service)
                        super().__init__(path, service)
                    def sub_time_step_method(self, *args, **kwargs):
                        """
                        Select sub-time step method for the time integration in explicit formulation.
                        """
                        return PyMenu(self.service, "/setup/models/multiphase/explicit_expert_options/sub_time_step_method").execute(*args, **kwargs)
                    def solve_vof_every_iter(self, *args, **kwargs):
                        """
                        Solve volume fraction equation every iteration for explicit formulation.
                        """
                        return PyMenu(self.service, "/setup/models/multiphase/explicit_expert_options/solve_vof_every_iter").execute(*args, **kwargs)

                    class volume_fraction_filtering(TUIMenu):
                        """
                        Advanced volume fraction filtering controls for explicit formulation.
                        """
                        def __init__(self, path, service):
                            self.path = path
                            self.service = service
                            super().__init__(path, service)
                        def vol_frac_cutoff(self, *args, **kwargs):
                            """
                            Enter node-averaged volume fraction cutoff.
                            """
                            return PyMenu(self.service, "/setup/models/multiphase/explicit_expert_options/volume_fraction_filtering/vol_frac_cutoff").execute(*args, **kwargs)
                        def filtering_options(self, *args, **kwargs):
                            """
                            Select volume fraction filtering method.
                            """
                            return PyMenu(self.service, "/setup/models/multiphase/explicit_expert_options/volume_fraction_filtering/filtering_options").execute(*args, **kwargs)
                        def enable(self, *args, **kwargs):
                            """
                            Enable volume fraction filtering treatment.
                            """
                            return PyMenu(self.service, "/setup/models/multiphase/explicit_expert_options/volume_fraction_filtering/enable").execute(*args, **kwargs)

                class hybrid_models(TUIMenu):
                    """
                    Enter the menu to select hybrid models.
                    """
                    def __init__(self, path, service):
                        self.path = path
                        self.service = service
                        super().__init__(path, service)
                    def multi_fluid_vof(self, *args, **kwargs):
                        """
                        Enable the multi-fluid VOF model.
                        """
                        return PyMenu(self.service, "/setup/models/multiphase/hybrid_models/multi_fluid_vof").execute(*args, **kwargs)
                    def ddpm(self, *args, **kwargs):
                        """
                        Enable the dense discrete phase model.
                        """
                        return PyMenu(self.service, "/setup/models/multiphase/hybrid_models/ddpm").execute(*args, **kwargs)

                class wet_steam(TUIMenu):
                    """
                    Enter the wet steam model menu.
                    """
                    def __init__(self, path, service):
                        self.path = path
                        self.service = service
                        self.set = self.__class__.set(path + ["set"], service)
                        super().__init__(path, service)
                    def compile_user_defined_wetsteam_functions(self, *args, **kwargs):
                        """
                        Compile user-defined wet steam library.
                        """
                        return PyMenu(self.service, "/setup/models/multiphase/wet_steam/compile_user_defined_wetsteam_functions").execute(*args, **kwargs)
                    def load_unload_user_defined_wetsteam_library(self, *args, **kwargs):
                        """
                        Load or unload user-defined wet steam library.
                        """
                        return PyMenu(self.service, "/setup/models/multiphase/wet_steam/load_unload_user_defined_wetsteam_library").execute(*args, **kwargs)
                    def enable(self, *args, **kwargs):
                        """
                        Enable/disable the wet steam model.
                        """
                        return PyMenu(self.service, "/setup/models/multiphase/wet_steam/enable").execute(*args, **kwargs)

                    class set(TUIMenu):
                        """
                        Enter the set menu for setting wet steam model options.
                        """
                        def __init__(self, path, service):
                            self.path = path
                            self.service = service
                            super().__init__(path, service)
                        def max_liquid_mass_fraction(self, *args, **kwargs):
                            """
                            Set the maximum limit on the condensed liquid-phase mass-fraction to prevent divergence.
                            """
                            return PyMenu(self.service, "/setup/models/multiphase/wet_steam/set/max_liquid_mass_fraction").execute(*args, **kwargs)
                        def zonal_phase_change(self, *args, **kwargs):
                            """
                            Select cell zones where phase change process is active.
                            """
                            return PyMenu(self.service, "/setup/models/multiphase/wet_steam/set/zonal_phase_change").execute(*args, **kwargs)
                        def rgp_tables(self, *args, **kwargs):
                            """
                            Select which properties to use: build-in or from RGP tables.
                            """
                            return PyMenu(self.service, "/setup/models/multiphase/wet_steam/set/rgp_tables").execute(*args, **kwargs)
                        def virial_equation(self, *args, **kwargs):
                            """
                            Select the formulation of the virial equation of state and associated equations for thermodynamic properties of steam.
                            """
                            return PyMenu(self.service, "/setup/models/multiphase/wet_steam/set/virial_equation").execute(*args, **kwargs)
                        def droplet_growth_rate(self, *args, **kwargs):
                            """
                            Select the formula to model the droplet growth rate.
                            """
                            return PyMenu(self.service, "/setup/models/multiphase/wet_steam/set/droplet_growth_rate").execute(*args, **kwargs)
                        def stagnation_conditions(self, *args, **kwargs):
                            """
                            If the gas phase is selected, zero wetness is assumed when evaluating total or static values of pressure and temperature.
                            """
                            return PyMenu(self.service, "/setup/models/multiphase/wet_steam/set/stagnation_conditions").execute(*args, **kwargs)

                class population_balance(TUIMenu):
                    """
                    Enter the population balance model menu.
                    """
                    def __init__(self, path, service):
                        self.path = path
                        self.service = service
                        self.phenomena = self.__class__.phenomena(path + ["phenomena"], service)
                        self.expert = self.__class__.expert(path + ["expert"], service)
                        super().__init__(path, service)
                    def include_expansion(self, *args, **kwargs):
                        """
                        Set expansion.
                        """
                        return PyMenu(self.service, "/setup/models/multiphase/population_balance/include_expansion").execute(*args, **kwargs)
                    def size_calculator(self, *args, **kwargs):
                        """
                        Calculate fluid particle diameters using different methods.
                        """
                        return PyMenu(self.service, "/setup/models/multiphase/population_balance/size_calculator").execute(*args, **kwargs)
                    def model(self, *args, **kwargs):
                        """
                        Select the population balance model.
                        """
                        return PyMenu(self.service, "/setup/models/multiphase/population_balance/model").execute(*args, **kwargs)

                    class phenomena(TUIMenu):
                        """
                        Enter the phenomena menu for population balance.
                        """
                        def __init__(self, path, service):
                            self.path = path
                            self.service = service
                            super().__init__(path, service)
                        def nucleation(self, *args, **kwargs):
                            """
                            Set the nucleantion rate.
                            """
                            return PyMenu(self.service, "/setup/models/multiphase/population_balance/phenomena/nucleation").execute(*args, **kwargs)
                        def breakage_aggregation_vof_cutoff(self, *args, **kwargs):
                            """
                            Control vof cut-off for breakage and aggregation.
                            """
                            return PyMenu(self.service, "/setup/models/multiphase/population_balance/phenomena/breakage_aggregation_vof_cutoff").execute(*args, **kwargs)
                        def aggregation(self, *args, **kwargs):
                            """
                            Set the aggregation kernel.
                            """
                            return PyMenu(self.service, "/setup/models/multiphase/population_balance/phenomena/aggregation").execute(*args, **kwargs)
                        def aggregation_factor(self, *args, **kwargs):
                            """
                            Set a factor which controls the intensity of the selected aggregation kernel.
                            """
                            return PyMenu(self.service, "/setup/models/multiphase/population_balance/phenomena/aggregation_factor").execute(*args, **kwargs)
                        def breakage_factor(self, *args, **kwargs):
                            """
                            Set a factor which controls the intensity of the selected breakage kernel.
                            """
                            return PyMenu(self.service, "/setup/models/multiphase/population_balance/phenomena/breakage_factor").execute(*args, **kwargs)
                        def breakage(self, *args, **kwargs):
                            """
                            Set the breakage kernel.
                            """
                            return PyMenu(self.service, "/setup/models/multiphase/population_balance/phenomena/breakage").execute(*args, **kwargs)
                        def growth(self, *args, **kwargs):
                            """
                            Set the growth rate.
                            """
                            return PyMenu(self.service, "/setup/models/multiphase/population_balance/phenomena/growth").execute(*args, **kwargs)

                    class expert(TUIMenu):
                        """
                        Enter the expert menu for quadrature-based population balance method.
                        """
                        def __init__(self, path, service):
                            self.path = path
                            self.service = service
                            self.qmom = self.__class__.qmom(path + ["qmom"], service)
                            super().__init__(path, service)

                        class qmom(TUIMenu):
                            """
                            .
                            """
                            def __init__(self, path, service):
                                self.path = path
                                self.service = service
                                super().__init__(path, service)
                            def print_realizable_moment_warning(self, *args, **kwargs):
                                """
                                Print the information for realizable moments in the population balance model.
                                """
                                return PyMenu(self.service, "/setup/models/multiphase/population_balance/expert/qmom/print_realizable_moment_warning").execute(*args, **kwargs)
                            def realizable_moments(self, *args, **kwargs):
                                """
                                Set the population balance model.
                                """
                                return PyMenu(self.service, "/setup/models/multiphase/population_balance/expert/qmom/realizable_moments").execute(*args, **kwargs)
                            def inversion_algorithm(self, *args, **kwargs):
                                """
                                Select the inversion algorithm for quadrature-based population balance method.
                                """
                                return PyMenu(self.service, "/setup/models/multiphase/population_balance/expert/qmom/inversion_algorithm").execute(*args, **kwargs)
                            def retain_qmom_sources_for_low_vof(self, *args, **kwargs):
                                """
                                Retain qmom source calculation for low secondary phase vof.
                                """
                                return PyMenu(self.service, "/setup/models/multiphase/population_balance/expert/qmom/retain_qmom_sources_for_low_vof").execute(*args, **kwargs)

                class sub_models(TUIMenu):
                    """
                    Enter the menu to select sub-models.
                    """
                    def __init__(self, path, service):
                        self.path = path
                        self.service = service
                        self.boiling_options = self.__class__.boiling_options(path + ["boiling_options"], service)
                        super().__init__(path, service)
                    def boiling(self, *args, **kwargs):
                        """
                        Activate boiling model.
                        """
                        return PyMenu(self.service, "/setup/models/multiphase/sub_models/boiling").execute(*args, **kwargs)

                    class boiling_options(TUIMenu):
                        """
                        Set boiling options.
                        """
                        def __init__(self, path, service):
                            self.path = path
                            self.service = service
                            super().__init__(path, service)
                        def nlbf_model(self, *args, **kwargs):
                            """
                            Set the non-local boundary field correction.
                            """
                            return PyMenu(self.service, "/setup/models/multiphase/sub_models/boiling_options/nlbf_model").execute(*args, **kwargs)
                        def options(self, *args, **kwargs):
                            """
                            Choose the type of boiling model.
                            """
                            return PyMenu(self.service, "/setup/models/multiphase/sub_models/boiling_options/options").execute(*args, **kwargs)

                class phases(TUIMenu):
                    """
                    Enter the phases menu.
                    """
                    def __init__(self, path, service):
                        self.path = path
                        self.service = service
                        self.iac_expert = self.__class__.iac_expert(path + ["iac_expert"], service)
                        self.set_domain_properties = self.__class__.set_domain_properties(path + ["set_domain_properties"], service)
                        super().__init__(path, service)

                    class iac_expert(TUIMenu):
                        """
                        Enter the IAC expert setting menu.
                        """
                        def __init__(self, path, service):
                            self.path = path
                            self.service = service
                            super().__init__(path, service)
                        def ishii_kim_model(self, *args, **kwargs):
                            """
                            Set ik model coefficients.
                            """
                            return PyMenu(self.service, "/setup/models/multiphase/phases/iac_expert/ishii_kim_model").execute(*args, **kwargs)
                        def hibiki_ishii_model(self, *args, **kwargs):
                            """
                            Set hi model coefficients.
                            """
                            return PyMenu(self.service, "/setup/models/multiphase/phases/iac_expert/hibiki_ishii_model").execute(*args, **kwargs)
                        def iac_pseudo_time_step(self, *args, **kwargs):
                            """
                            Set iac pseudo-time.
                            """
                            return PyMenu(self.service, "/setup/models/multiphase/phases/iac_expert/iac_pseudo_time_step").execute(*args, **kwargs)
                        def yao_morel_model(self, *args, **kwargs):
                            """
                            Set ym model coefficients.
                            """
                            return PyMenu(self.service, "/setup/models/multiphase/phases/iac_expert/yao_morel_model").execute(*args, **kwargs)

                    class set_domain_properties(TUIMenu):
                        """
                        Enter the menu to set domain properties.
                        """
                        def __init__(self, path, service):
                            self.path = path
                            self.service = service
                            self.interaction_domain = self.__class__.interaction_domain(path + ["interaction_domain"], service)
                            super().__init__(path, service)
                        def phase_domains(self, *args, **kwargs):
                            """
                            Enter the menu to select a specific phase domain.
                            """
                            return PyMenu(self.service, "/setup/models/multiphase/phases/set_domain_properties/phase_domains").execute(*args, **kwargs)
                        def change_phases_names(self, *args, **kwargs):
                            """
                            Change names for all defined phases?.
                            """
                            return PyMenu(self.service, "/setup/models/multiphase/phases/set_domain_properties/change_phases_names").execute(*args, **kwargs)

                        class interaction_domain(TUIMenu):
                            """
                            Enter the menu to set the interaction domain properties.
                            """
                            def __init__(self, path, service):
                                self.path = path
                                self.service = service
                                self.model_transition = self.__class__.model_transition(path + ["model_transition"], service)
                                self.interfacial_area = self.__class__.interfacial_area(path + ["interfacial_area"], service)
                                self.heat_mass_reactions = self.__class__.heat_mass_reactions(path + ["heat_mass_reactions"], service)
                                self.numerics = self.__class__.numerics(path + ["numerics"], service)
                                self.forces = self.__class__.forces(path + ["forces"], service)
                                super().__init__(path, service)

                            class model_transition(TUIMenu):
                                """
                                Enter the menu to set model transition mechanisms.
                                """
                                def __init__(self, path, service):
                                    self.path = path
                                    self.service = service
                                    self.interphase_discretization = self.__class__.interphase_discretization(path + ["interphase_discretization"], service)
                                    self.interphase_viscous_dissipation = self.__class__.interphase_viscous_dissipation(path + ["interphase_viscous_dissipation"], service)
                                    self.virtual_mass = self.__class__.virtual_mass(path + ["virtual_mass"], service)
                                    self.surface_tension = self.__class__.surface_tension(path + ["surface_tension"], service)
                                    self.cavitation = self.__class__.cavitation(path + ["cavitation"], service)
                                    self.lift = self.__class__.lift(path + ["lift"], service)
                                    super().__init__(path, service)
                                def slip_velocity(self, *args, **kwargs):
                                    """
                                    Specify the slip velocity function for each secondary phase with respect to the primary phase.
                                    """
                                    return PyMenu(self.service, "/setup/models/multiphase/phases/set_domain_properties/interaction_domain/model_transition/slip_velocity").execute(*args, **kwargs)
                                def heat_coeff(self, *args, **kwargs):
                                    """
                                    Specify the heat transfer coefficient function between each pair of phases.
                                    """
                                    return PyMenu(self.service, "/setup/models/multiphase/phases/set_domain_properties/interaction_domain/model_transition/heat_coeff").execute(*args, **kwargs)
                                def drag(self, *args, **kwargs):
                                    """
                                    Specify the drag function for each pair of phases. It also enables drag modification and allow specifying the drag factor.
                                    """
                                    return PyMenu(self.service, "/setup/models/multiphase/phases/set_domain_properties/interaction_domain/model_transition/drag").execute(*args, **kwargs)
                                def turbulence_interaction(self, *args, **kwargs):
                                    """
                                    Specify the turbulence interaction model for each primary-secondary phase pair.
                                    """
                                    return PyMenu(self.service, "/setup/models/multiphase/phases/set_domain_properties/interaction_domain/model_transition/turbulence_interaction").execute(*args, **kwargs)
                                def interfacial_area(self, *args, **kwargs):
                                    """
                                    Set the interfacial area parameters for each pair of phases.
                                    """
                                    return PyMenu(self.service, "/setup/models/multiphase/phases/set_domain_properties/interaction_domain/model_transition/interfacial_area").execute(*args, **kwargs)
                                def wall_lubrication(self, *args, **kwargs):
                                    """
                                    Specify the wall lubrication model for each primary-secondary phase pair.
                                    """
                                    return PyMenu(self.service, "/setup/models/multiphase/phases/set_domain_properties/interaction_domain/model_transition/wall_lubrication").execute(*args, **kwargs)
                                def reactions(self, *args, **kwargs):
                                    """
                                    Define multiple heterogeneous reactions and stoichiometry.
                                    """
                                    return PyMenu(self.service, "/setup/models/multiphase/phases/set_domain_properties/interaction_domain/model_transition/reactions").execute(*args, **kwargs)
                                def mass_transfer(self, *args, **kwargs):
                                    """
                                    Specify the mass transfer mechanisms.
                                    """
                                    return PyMenu(self.service, "/setup/models/multiphase/phases/set_domain_properties/interaction_domain/model_transition/mass_transfer").execute(*args, **kwargs)
                                def restitution(self, *args, **kwargs):
                                    """
                                    Specify the restitution coefficient for collisions between each pair of granular phases and for collisions between particles of the same granular phase.
                                    """
                                    return PyMenu(self.service, "/setup/models/multiphase/phases/set_domain_properties/interaction_domain/model_transition/restitution").execute(*args, **kwargs)
                                def turbulent_dispersion(self, *args, **kwargs):
                                    """
                                    Specify the turbulent dispersion model for each primary-secondary phase pair.
                                    """
                                    return PyMenu(self.service, "/setup/models/multiphase/phases/set_domain_properties/interaction_domain/model_transition/turbulent_dispersion").execute(*args, **kwargs)
                                def model_transition(self, *args, **kwargs):
                                    """
                                    Set the model transition mechanism.
                                    """
                                    return PyMenu(self.service, "/setup/models/multiphase/phases/set_domain_properties/interaction_domain/model_transition/model_transition").execute(*args, **kwargs)

                                class interphase_discretization(TUIMenu):
                                    """
                                    Enter the menu to set interphase discretization models.
                                    """
                                    def __init__(self, path, service):
                                        self.path = path
                                        self.service = service
                                        super().__init__(path, service)
                                    def vmass_implicit(self, *args, **kwargs):
                                        """
                                        Enable the implicit method for the virtual mass force?.
                                        """
                                        return PyMenu(self.service, "/setup/models/multiphase/phases/set_domain_properties/interaction_domain/model_transition/interphase_discretization/vmass_implicit").execute(*args, **kwargs)
                                    def cavitation(self, *args, **kwargs):
                                        """
                                        Set the vaporization pressure, the surface tension coefficient, and the non-condensable gas mass fraction.
                                        """
                                        return PyMenu(self.service, "/setup/models/multiphase/phases/set_domain_properties/interaction_domain/model_transition/interphase_discretization/cavitation").execute(*args, **kwargs)
                                    def sfc_model_type(self, *args, **kwargs):
                                        """
                                        Select the surface tension model.
                                        """
                                        return PyMenu(self.service, "/setup/models/multiphase/phases/set_domain_properties/interaction_domain/model_transition/interphase_discretization/sfc_model_type").execute(*args, **kwargs)
                                    def wall_adhesion(self, *args, **kwargs):
                                        """
                                        Enable the specification for a wall adhesion angle?.
                                        """
                                        return PyMenu(self.service, "/setup/models/multiphase/phases/set_domain_properties/interaction_domain/model_transition/interphase_discretization/wall_adhesion").execute(*args, **kwargs)
                                    def interphase_discr(self, *args, **kwargs):
                                        """
                                        Enable the phase localized compressive discretization scheme where the degree of diffusion/sharpness is controlled through the value of the slope limiters?.
                                        """
                                        return PyMenu(self.service, "/setup/models/multiphase/phases/set_domain_properties/interaction_domain/model_transition/interphase_discretization/interphase_discr").execute(*args, **kwargs)
                                    def slope_limiter(self, *args, **kwargs):
                                        """
                                        Specify the slope limiter to set a specific discretization scheme. 0: first order upwind, 1: second order reconstruction bounded by the global minimum/maximum of the volume fraction, 2: compressive. Value between 0 and 2: blended scheme.
                                        """
                                        return PyMenu(self.service, "/setup/models/multiphase/phases/set_domain_properties/interaction_domain/model_transition/interphase_discretization/slope_limiter").execute(*args, **kwargs)
                                    def vmass_coeff(self, *args, **kwargs):
                                        """
                                        Specify the virtual mass coefficient for each pair of phases.
                                        """
                                        return PyMenu(self.service, "/setup/models/multiphase/phases/set_domain_properties/interaction_domain/model_transition/interphase_discretization/vmass_coeff").execute(*args, **kwargs)
                                    def virtual_mass(self, *args, **kwargs):
                                        """
                                        Include the virtual mass force that is present when a secondary phase accelerates relative to the primary phase?.
                                        """
                                        return PyMenu(self.service, "/setup/models/multiphase/phases/set_domain_properties/interaction_domain/model_transition/interphase_discretization/virtual_mass").execute(*args, **kwargs)
                                    def interphase_visc_disp(self, *args, **kwargs):
                                        """
                                        Enable the interfacial viscous dissipation method, which introduces an artificial viscous damping term in the momentum equation?.
                                        """
                                        return PyMenu(self.service, "/setup/models/multiphase/phases/set_domain_properties/interaction_domain/model_transition/interphase_discretization/interphase_visc_disp").execute(*args, **kwargs)
                                    def sfc_modeling(self, *args, **kwargs):
                                        """
                                        Include the effects of surface tension along the fluid-fluid interface?.
                                        """
                                        return PyMenu(self.service, "/setup/models/multiphase/phases/set_domain_properties/interaction_domain/model_transition/interphase_discretization/sfc_modeling").execute(*args, **kwargs)
                                    def lift_shaver_podowski(self, *args, **kwargs):
                                        """
                                        Include the Shaver-Podowski correction for Lift.
                                        """
                                        return PyMenu(self.service, "/setup/models/multiphase/phases/set_domain_properties/interaction_domain/model_transition/interphase_discretization/lift_shaver_podowski").execute(*args, **kwargs)
                                    def lift_montoya(self, *args, **kwargs):
                                        """
                                        Include the Montoya correction for Lift.
                                        """
                                        return PyMenu(self.service, "/setup/models/multiphase/phases/set_domain_properties/interaction_domain/model_transition/interphase_discretization/lift_montoya").execute(*args, **kwargs)
                                    def sfc_tension_coeff(self, *args, **kwargs):
                                        """
                                        Specify the surface tension coefficient for each pair of phases.
                                        """
                                        return PyMenu(self.service, "/setup/models/multiphase/phases/set_domain_properties/interaction_domain/model_transition/interphase_discretization/sfc_tension_coeff").execute(*args, **kwargs)
                                    def lift(self, *args, **kwargs):
                                        """
                                        .
                                        """
                                        return PyMenu(self.service, "/setup/models/multiphase/phases/set_domain_properties/interaction_domain/model_transition/interphase_discretization/lift").execute(*args, **kwargs)
                                    def vmass_implicit_options(self, *args, **kwargs):
                                        """
                                        Select the virtual mass implicit option.
                                        """
                                        return PyMenu(self.service, "/setup/models/multiphase/phases/set_domain_properties/interaction_domain/model_transition/interphase_discretization/vmass_implicit_options").execute(*args, **kwargs)
                                    def visc_disp_factor(self, *args, **kwargs):
                                        """
                                        Set the dissipation intensity.
                                        """
                                        return PyMenu(self.service, "/setup/models/multiphase/phases/set_domain_properties/interaction_domain/model_transition/interphase_discretization/visc_disp_factor").execute(*args, **kwargs)
                                    def jump_adhesion(self, *args, **kwargs):
                                        """
                                        Enable the treatment of the contact angle specification at the porous jump boundary?.
                                        """
                                        return PyMenu(self.service, "/setup/models/multiphase/phases/set_domain_properties/interaction_domain/model_transition/interphase_discretization/jump_adhesion").execute(*args, **kwargs)

                                class interphase_viscous_dissipation(TUIMenu):
                                    """
                                    Enter the menu to set interphase viscous dissipation related models.
                                    """
                                    def __init__(self, path, service):
                                        self.path = path
                                        self.service = service
                                        super().__init__(path, service)
                                    def virtual_mass(self, *args, **kwargs):
                                        """
                                        Include the virtual mass force that is present when a secondary phase accelerates relative to the primary phase?.
                                        """
                                        return PyMenu(self.service, "/setup/models/multiphase/phases/set_domain_properties/interaction_domain/model_transition/interphase_viscous_dissipation/virtual_mass").execute(*args, **kwargs)
                                    def lift_montoya(self, *args, **kwargs):
                                        """
                                        Include the Montoya correction for Lift.
                                        """
                                        return PyMenu(self.service, "/setup/models/multiphase/phases/set_domain_properties/interaction_domain/model_transition/interphase_viscous_dissipation/lift_montoya").execute(*args, **kwargs)
                                    def lift(self, *args, **kwargs):
                                        """
                                        .
                                        """
                                        return PyMenu(self.service, "/setup/models/multiphase/phases/set_domain_properties/interaction_domain/model_transition/interphase_viscous_dissipation/lift").execute(*args, **kwargs)
                                    def lift_shaver_podowski(self, *args, **kwargs):
                                        """
                                        Include the Shaver-Podowski correction for Lift.
                                        """
                                        return PyMenu(self.service, "/setup/models/multiphase/phases/set_domain_properties/interaction_domain/model_transition/interphase_viscous_dissipation/lift_shaver_podowski").execute(*args, **kwargs)
                                    def vmass_implicit(self, *args, **kwargs):
                                        """
                                        Enable the implicit method for the virtual mass force?.
                                        """
                                        return PyMenu(self.service, "/setup/models/multiphase/phases/set_domain_properties/interaction_domain/model_transition/interphase_viscous_dissipation/vmass_implicit").execute(*args, **kwargs)
                                    def interphase_visc_disp(self, *args, **kwargs):
                                        """
                                        Enable the interfacial viscous dissipation method, which introduces an artificial viscous damping term in the momentum equation?.
                                        """
                                        return PyMenu(self.service, "/setup/models/multiphase/phases/set_domain_properties/interaction_domain/model_transition/interphase_viscous_dissipation/interphase_visc_disp").execute(*args, **kwargs)
                                    def visc_disp_factor(self, *args, **kwargs):
                                        """
                                        Set the dissipation intensity.
                                        """
                                        return PyMenu(self.service, "/setup/models/multiphase/phases/set_domain_properties/interaction_domain/model_transition/interphase_viscous_dissipation/visc_disp_factor").execute(*args, **kwargs)
                                    def jump_adhesion(self, *args, **kwargs):
                                        """
                                        Enable the treatment of the contact angle specification at the porous jump boundary?.
                                        """
                                        return PyMenu(self.service, "/setup/models/multiphase/phases/set_domain_properties/interaction_domain/model_transition/interphase_viscous_dissipation/jump_adhesion").execute(*args, **kwargs)
                                    def sfc_tension_coeff(self, *args, **kwargs):
                                        """
                                        Specify the surface tension coefficient for each pair of phases.
                                        """
                                        return PyMenu(self.service, "/setup/models/multiphase/phases/set_domain_properties/interaction_domain/model_transition/interphase_viscous_dissipation/sfc_tension_coeff").execute(*args, **kwargs)
                                    def sfc_model_type(self, *args, **kwargs):
                                        """
                                        Select the surface tension model.
                                        """
                                        return PyMenu(self.service, "/setup/models/multiphase/phases/set_domain_properties/interaction_domain/model_transition/interphase_viscous_dissipation/sfc_model_type").execute(*args, **kwargs)
                                    def wall_adhesion(self, *args, **kwargs):
                                        """
                                        Enable the specification for a wall adhesion angle?.
                                        """
                                        return PyMenu(self.service, "/setup/models/multiphase/phases/set_domain_properties/interaction_domain/model_transition/interphase_viscous_dissipation/wall_adhesion").execute(*args, **kwargs)
                                    def vmass_coeff(self, *args, **kwargs):
                                        """
                                        Specify the virtual mass coefficient for each pair of phases.
                                        """
                                        return PyMenu(self.service, "/setup/models/multiphase/phases/set_domain_properties/interaction_domain/model_transition/interphase_viscous_dissipation/vmass_coeff").execute(*args, **kwargs)
                                    def slope_limiter(self, *args, **kwargs):
                                        """
                                        Specify the slope limiter to set a specific discretization scheme. 0: first order upwind, 1: second order reconstruction bounded by the global minimum/maximum of the volume fraction, 2: compressive. Value between 0 and 2: blended scheme.
                                        """
                                        return PyMenu(self.service, "/setup/models/multiphase/phases/set_domain_properties/interaction_domain/model_transition/interphase_viscous_dissipation/slope_limiter").execute(*args, **kwargs)
                                    def vmass_implicit_options(self, *args, **kwargs):
                                        """
                                        Select the virtual mass implicit option.
                                        """
                                        return PyMenu(self.service, "/setup/models/multiphase/phases/set_domain_properties/interaction_domain/model_transition/interphase_viscous_dissipation/vmass_implicit_options").execute(*args, **kwargs)
                                    def cavitation(self, *args, **kwargs):
                                        """
                                        Set the vaporization pressure, the surface tension coefficient, and the non-condensable gas mass fraction.
                                        """
                                        return PyMenu(self.service, "/setup/models/multiphase/phases/set_domain_properties/interaction_domain/model_transition/interphase_viscous_dissipation/cavitation").execute(*args, **kwargs)
                                    def sfc_modeling(self, *args, **kwargs):
                                        """
                                        Include the effects of surface tension along the fluid-fluid interface?.
                                        """
                                        return PyMenu(self.service, "/setup/models/multiphase/phases/set_domain_properties/interaction_domain/model_transition/interphase_viscous_dissipation/sfc_modeling").execute(*args, **kwargs)
                                    def interphase_discr(self, *args, **kwargs):
                                        """
                                        Enable the phase localized compressive discretization scheme where the degree of diffusion/sharpness is controlled through the value of the slope limiters?.
                                        """
                                        return PyMenu(self.service, "/setup/models/multiphase/phases/set_domain_properties/interaction_domain/model_transition/interphase_viscous_dissipation/interphase_discr").execute(*args, **kwargs)

                                class virtual_mass(TUIMenu):
                                    """
                                    Enter the menu to set virtual mass models.
                                    """
                                    def __init__(self, path, service):
                                        self.path = path
                                        self.service = service
                                        super().__init__(path, service)
                                    def jump_adhesion(self, *args, **kwargs):
                                        """
                                        Enable the treatment of the contact angle specification at the porous jump boundary?.
                                        """
                                        return PyMenu(self.service, "/setup/models/multiphase/phases/set_domain_properties/interaction_domain/model_transition/virtual_mass/jump_adhesion").execute(*args, **kwargs)
                                    def interphase_visc_disp(self, *args, **kwargs):
                                        """
                                        Enable the interfacial viscous dissipation method, which introduces an artificial viscous damping term in the momentum equation?.
                                        """
                                        return PyMenu(self.service, "/setup/models/multiphase/phases/set_domain_properties/interaction_domain/model_transition/virtual_mass/interphase_visc_disp").execute(*args, **kwargs)
                                    def cavitation(self, *args, **kwargs):
                                        """
                                        Set the vaporization pressure, the surface tension coefficient, and the non-condensable gas mass fraction.
                                        """
                                        return PyMenu(self.service, "/setup/models/multiphase/phases/set_domain_properties/interaction_domain/model_transition/virtual_mass/cavitation").execute(*args, **kwargs)
                                    def vmass_implicit(self, *args, **kwargs):
                                        """
                                        Enable the implicit method for the virtual mass force?.
                                        """
                                        return PyMenu(self.service, "/setup/models/multiphase/phases/set_domain_properties/interaction_domain/model_transition/virtual_mass/vmass_implicit").execute(*args, **kwargs)
                                    def vmass_coeff(self, *args, **kwargs):
                                        """
                                        Specify the virtual mass coefficient for each pair of phases.
                                        """
                                        return PyMenu(self.service, "/setup/models/multiphase/phases/set_domain_properties/interaction_domain/model_transition/virtual_mass/vmass_coeff").execute(*args, **kwargs)
                                    def vmass_implicit_options(self, *args, **kwargs):
                                        """
                                        Select the virtual mass implicit option.
                                        """
                                        return PyMenu(self.service, "/setup/models/multiphase/phases/set_domain_properties/interaction_domain/model_transition/virtual_mass/vmass_implicit_options").execute(*args, **kwargs)
                                    def sfc_model_type(self, *args, **kwargs):
                                        """
                                        Select the surface tension model.
                                        """
                                        return PyMenu(self.service, "/setup/models/multiphase/phases/set_domain_properties/interaction_domain/model_transition/virtual_mass/sfc_model_type").execute(*args, **kwargs)
                                    def interphase_discr(self, *args, **kwargs):
                                        """
                                        Enable the phase localized compressive discretization scheme where the degree of diffusion/sharpness is controlled through the value of the slope limiters?.
                                        """
                                        return PyMenu(self.service, "/setup/models/multiphase/phases/set_domain_properties/interaction_domain/model_transition/virtual_mass/interphase_discr").execute(*args, **kwargs)
                                    def sfc_tension_coeff(self, *args, **kwargs):
                                        """
                                        Specify the surface tension coefficient for each pair of phases.
                                        """
                                        return PyMenu(self.service, "/setup/models/multiphase/phases/set_domain_properties/interaction_domain/model_transition/virtual_mass/sfc_tension_coeff").execute(*args, **kwargs)
                                    def visc_disp_factor(self, *args, **kwargs):
                                        """
                                        Set the dissipation intensity.
                                        """
                                        return PyMenu(self.service, "/setup/models/multiphase/phases/set_domain_properties/interaction_domain/model_transition/virtual_mass/visc_disp_factor").execute(*args, **kwargs)
                                    def lift(self, *args, **kwargs):
                                        """
                                        .
                                        """
                                        return PyMenu(self.service, "/setup/models/multiphase/phases/set_domain_properties/interaction_domain/model_transition/virtual_mass/lift").execute(*args, **kwargs)
                                    def sfc_modeling(self, *args, **kwargs):
                                        """
                                        Include the effects of surface tension along the fluid-fluid interface?.
                                        """
                                        return PyMenu(self.service, "/setup/models/multiphase/phases/set_domain_properties/interaction_domain/model_transition/virtual_mass/sfc_modeling").execute(*args, **kwargs)
                                    def wall_adhesion(self, *args, **kwargs):
                                        """
                                        Enable the specification for a wall adhesion angle?.
                                        """
                                        return PyMenu(self.service, "/setup/models/multiphase/phases/set_domain_properties/interaction_domain/model_transition/virtual_mass/wall_adhesion").execute(*args, **kwargs)
                                    def lift_montoya(self, *args, **kwargs):
                                        """
                                        Include the Montoya correction for Lift.
                                        """
                                        return PyMenu(self.service, "/setup/models/multiphase/phases/set_domain_properties/interaction_domain/model_transition/virtual_mass/lift_montoya").execute(*args, **kwargs)
                                    def slope_limiter(self, *args, **kwargs):
                                        """
                                        Specify the slope limiter to set a specific discretization scheme. 0: first order upwind, 1: second order reconstruction bounded by the global minimum/maximum of the volume fraction, 2: compressive. Value between 0 and 2: blended scheme.
                                        """
                                        return PyMenu(self.service, "/setup/models/multiphase/phases/set_domain_properties/interaction_domain/model_transition/virtual_mass/slope_limiter").execute(*args, **kwargs)
                                    def virtual_mass(self, *args, **kwargs):
                                        """
                                        Include the virtual mass force that is present when a secondary phase accelerates relative to the primary phase?.
                                        """
                                        return PyMenu(self.service, "/setup/models/multiphase/phases/set_domain_properties/interaction_domain/model_transition/virtual_mass/virtual_mass").execute(*args, **kwargs)
                                    def lift_shaver_podowski(self, *args, **kwargs):
                                        """
                                        Include the Shaver-Podowski correction for Lift.
                                        """
                                        return PyMenu(self.service, "/setup/models/multiphase/phases/set_domain_properties/interaction_domain/model_transition/virtual_mass/lift_shaver_podowski").execute(*args, **kwargs)

                                class surface_tension(TUIMenu):
                                    """
                                    Enter the menu to set surface tension models.
                                    """
                                    def __init__(self, path, service):
                                        self.path = path
                                        self.service = service
                                        super().__init__(path, service)
                                    def sfc_model_type(self, *args, **kwargs):
                                        """
                                        Select the surface tension model.
                                        """
                                        return PyMenu(self.service, "/setup/models/multiphase/phases/set_domain_properties/interaction_domain/model_transition/surface_tension/sfc_model_type").execute(*args, **kwargs)
                                    def sfc_tension_coeff(self, *args, **kwargs):
                                        """
                                        Specify the surface tension coefficient for each pair of phases.
                                        """
                                        return PyMenu(self.service, "/setup/models/multiphase/phases/set_domain_properties/interaction_domain/model_transition/surface_tension/sfc_tension_coeff").execute(*args, **kwargs)
                                    def interphase_visc_disp(self, *args, **kwargs):
                                        """
                                        Enable the interfacial viscous dissipation method, which introduces an artificial viscous damping term in the momentum equation?.
                                        """
                                        return PyMenu(self.service, "/setup/models/multiphase/phases/set_domain_properties/interaction_domain/model_transition/surface_tension/interphase_visc_disp").execute(*args, **kwargs)
                                    def vmass_coeff(self, *args, **kwargs):
                                        """
                                        Specify the virtual mass coefficient for each pair of phases.
                                        """
                                        return PyMenu(self.service, "/setup/models/multiphase/phases/set_domain_properties/interaction_domain/model_transition/surface_tension/vmass_coeff").execute(*args, **kwargs)
                                    def cavitation(self, *args, **kwargs):
                                        """
                                        Set the vaporization pressure, the surface tension coefficient, and the non-condensable gas mass fraction.
                                        """
                                        return PyMenu(self.service, "/setup/models/multiphase/phases/set_domain_properties/interaction_domain/model_transition/surface_tension/cavitation").execute(*args, **kwargs)
                                    def sfc_modeling(self, *args, **kwargs):
                                        """
                                        Include the effects of surface tension along the fluid-fluid interface?.
                                        """
                                        return PyMenu(self.service, "/setup/models/multiphase/phases/set_domain_properties/interaction_domain/model_transition/surface_tension/sfc_modeling").execute(*args, **kwargs)
                                    def vmass_implicit_options(self, *args, **kwargs):
                                        """
                                        Select the virtual mass implicit option.
                                        """
                                        return PyMenu(self.service, "/setup/models/multiphase/phases/set_domain_properties/interaction_domain/model_transition/surface_tension/vmass_implicit_options").execute(*args, **kwargs)
                                    def slope_limiter(self, *args, **kwargs):
                                        """
                                        Specify the slope limiter to set a specific discretization scheme. 0: first order upwind, 1: second order reconstruction bounded by the global minimum/maximum of the volume fraction, 2: compressive. Value between 0 and 2: blended scheme.
                                        """
                                        return PyMenu(self.service, "/setup/models/multiphase/phases/set_domain_properties/interaction_domain/model_transition/surface_tension/slope_limiter").execute(*args, **kwargs)
                                    def visc_disp_factor(self, *args, **kwargs):
                                        """
                                        Set the dissipation intensity.
                                        """
                                        return PyMenu(self.service, "/setup/models/multiphase/phases/set_domain_properties/interaction_domain/model_transition/surface_tension/visc_disp_factor").execute(*args, **kwargs)
                                    def vmass_implicit(self, *args, **kwargs):
                                        """
                                        Enable the implicit method for the virtual mass force?.
                                        """
                                        return PyMenu(self.service, "/setup/models/multiphase/phases/set_domain_properties/interaction_domain/model_transition/surface_tension/vmass_implicit").execute(*args, **kwargs)
                                    def jump_adhesion(self, *args, **kwargs):
                                        """
                                        Enable the treatment of the contact angle specification at the porous jump boundary?.
                                        """
                                        return PyMenu(self.service, "/setup/models/multiphase/phases/set_domain_properties/interaction_domain/model_transition/surface_tension/jump_adhesion").execute(*args, **kwargs)
                                    def interphase_discr(self, *args, **kwargs):
                                        """
                                        Enable the phase localized compressive discretization scheme where the degree of diffusion/sharpness is controlled through the value of the slope limiters?.
                                        """
                                        return PyMenu(self.service, "/setup/models/multiphase/phases/set_domain_properties/interaction_domain/model_transition/surface_tension/interphase_discr").execute(*args, **kwargs)
                                    def lift_montoya(self, *args, **kwargs):
                                        """
                                        Include the Montoya correction for Lift.
                                        """
                                        return PyMenu(self.service, "/setup/models/multiphase/phases/set_domain_properties/interaction_domain/model_transition/surface_tension/lift_montoya").execute(*args, **kwargs)
                                    def wall_adhesion(self, *args, **kwargs):
                                        """
                                        Enable the specification for a wall adhesion angle?.
                                        """
                                        return PyMenu(self.service, "/setup/models/multiphase/phases/set_domain_properties/interaction_domain/model_transition/surface_tension/wall_adhesion").execute(*args, **kwargs)
                                    def lift_shaver_podowski(self, *args, **kwargs):
                                        """
                                        Include the Shaver-Podowski correction for Lift.
                                        """
                                        return PyMenu(self.service, "/setup/models/multiphase/phases/set_domain_properties/interaction_domain/model_transition/surface_tension/lift_shaver_podowski").execute(*args, **kwargs)
                                    def virtual_mass(self, *args, **kwargs):
                                        """
                                        Include the virtual mass force that is present when a secondary phase accelerates relative to the primary phase?.
                                        """
                                        return PyMenu(self.service, "/setup/models/multiphase/phases/set_domain_properties/interaction_domain/model_transition/surface_tension/virtual_mass").execute(*args, **kwargs)
                                    def lift(self, *args, **kwargs):
                                        """
                                        .
                                        """
                                        return PyMenu(self.service, "/setup/models/multiphase/phases/set_domain_properties/interaction_domain/model_transition/surface_tension/lift").execute(*args, **kwargs)

                                class cavitation(TUIMenu):
                                    """
                                    Enter the menu to set cavitation models.
                                    """
                                    def __init__(self, path, service):
                                        self.path = path
                                        self.service = service
                                        super().__init__(path, service)
                                    def vmass_implicit(self, *args, **kwargs):
                                        """
                                        Enable the implicit method for the virtual mass force?.
                                        """
                                        return PyMenu(self.service, "/setup/models/multiphase/phases/set_domain_properties/interaction_domain/model_transition/cavitation/vmass_implicit").execute(*args, **kwargs)
                                    def lift_montoya(self, *args, **kwargs):
                                        """
                                        Include the Montoya correction for Lift.
                                        """
                                        return PyMenu(self.service, "/setup/models/multiphase/phases/set_domain_properties/interaction_domain/model_transition/cavitation/lift_montoya").execute(*args, **kwargs)
                                    def jump_adhesion(self, *args, **kwargs):
                                        """
                                        Enable the treatment of the contact angle specification at the porous jump boundary?.
                                        """
                                        return PyMenu(self.service, "/setup/models/multiphase/phases/set_domain_properties/interaction_domain/model_transition/cavitation/jump_adhesion").execute(*args, **kwargs)
                                    def sfc_model_type(self, *args, **kwargs):
                                        """
                                        Select the surface tension model.
                                        """
                                        return PyMenu(self.service, "/setup/models/multiphase/phases/set_domain_properties/interaction_domain/model_transition/cavitation/sfc_model_type").execute(*args, **kwargs)
                                    def wall_adhesion(self, *args, **kwargs):
                                        """
                                        Enable the specification for a wall adhesion angle?.
                                        """
                                        return PyMenu(self.service, "/setup/models/multiphase/phases/set_domain_properties/interaction_domain/model_transition/cavitation/wall_adhesion").execute(*args, **kwargs)
                                    def sfc_modeling(self, *args, **kwargs):
                                        """
                                        Include the effects of surface tension along the fluid-fluid interface?.
                                        """
                                        return PyMenu(self.service, "/setup/models/multiphase/phases/set_domain_properties/interaction_domain/model_transition/cavitation/sfc_modeling").execute(*args, **kwargs)
                                    def lift_shaver_podowski(self, *args, **kwargs):
                                        """
                                        Include the Shaver-Podowski correction for Lift.
                                        """
                                        return PyMenu(self.service, "/setup/models/multiphase/phases/set_domain_properties/interaction_domain/model_transition/cavitation/lift_shaver_podowski").execute(*args, **kwargs)
                                    def vmass_coeff(self, *args, **kwargs):
                                        """
                                        Specify the virtual mass coefficient for each pair of phases.
                                        """
                                        return PyMenu(self.service, "/setup/models/multiphase/phases/set_domain_properties/interaction_domain/model_transition/cavitation/vmass_coeff").execute(*args, **kwargs)
                                    def interphase_discr(self, *args, **kwargs):
                                        """
                                        Enable the phase localized compressive discretization scheme where the degree of diffusion/sharpness is controlled through the value of the slope limiters?.
                                        """
                                        return PyMenu(self.service, "/setup/models/multiphase/phases/set_domain_properties/interaction_domain/model_transition/cavitation/interphase_discr").execute(*args, **kwargs)
                                    def sfc_tension_coeff(self, *args, **kwargs):
                                        """
                                        Specify the surface tension coefficient for each pair of phases.
                                        """
                                        return PyMenu(self.service, "/setup/models/multiphase/phases/set_domain_properties/interaction_domain/model_transition/cavitation/sfc_tension_coeff").execute(*args, **kwargs)
                                    def vmass_implicit_options(self, *args, **kwargs):
                                        """
                                        Select the virtual mass implicit option.
                                        """
                                        return PyMenu(self.service, "/setup/models/multiphase/phases/set_domain_properties/interaction_domain/model_transition/cavitation/vmass_implicit_options").execute(*args, **kwargs)
                                    def lift(self, *args, **kwargs):
                                        """
                                        .
                                        """
                                        return PyMenu(self.service, "/setup/models/multiphase/phases/set_domain_properties/interaction_domain/model_transition/cavitation/lift").execute(*args, **kwargs)
                                    def visc_disp_factor(self, *args, **kwargs):
                                        """
                                        Set the dissipation intensity.
                                        """
                                        return PyMenu(self.service, "/setup/models/multiphase/phases/set_domain_properties/interaction_domain/model_transition/cavitation/visc_disp_factor").execute(*args, **kwargs)
                                    def slope_limiter(self, *args, **kwargs):
                                        """
                                        Specify the slope limiter to set a specific discretization scheme. 0: first order upwind, 1: second order reconstruction bounded by the global minimum/maximum of the volume fraction, 2: compressive. Value between 0 and 2: blended scheme.
                                        """
                                        return PyMenu(self.service, "/setup/models/multiphase/phases/set_domain_properties/interaction_domain/model_transition/cavitation/slope_limiter").execute(*args, **kwargs)
                                    def interphase_visc_disp(self, *args, **kwargs):
                                        """
                                        Enable the interfacial viscous dissipation method, which introduces an artificial viscous damping term in the momentum equation?.
                                        """
                                        return PyMenu(self.service, "/setup/models/multiphase/phases/set_domain_properties/interaction_domain/model_transition/cavitation/interphase_visc_disp").execute(*args, **kwargs)
                                    def cavitation(self, *args, **kwargs):
                                        """
                                        Set the vaporization pressure, the surface tension coefficient, and the non-condensable gas mass fraction.
                                        """
                                        return PyMenu(self.service, "/setup/models/multiphase/phases/set_domain_properties/interaction_domain/model_transition/cavitation/cavitation").execute(*args, **kwargs)
                                    def virtual_mass(self, *args, **kwargs):
                                        """
                                        Include the virtual mass force that is present when a secondary phase accelerates relative to the primary phase?.
                                        """
                                        return PyMenu(self.service, "/setup/models/multiphase/phases/set_domain_properties/interaction_domain/model_transition/cavitation/virtual_mass").execute(*args, **kwargs)

                                class lift(TUIMenu):
                                    """
                                    Enter the menu to set lift models.
                                    """
                                    def __init__(self, path, service):
                                        self.path = path
                                        self.service = service
                                        super().__init__(path, service)
                                    def lift_montoya(self, *args, **kwargs):
                                        """
                                        Include the Montoya correction for Lift.
                                        """
                                        return PyMenu(self.service, "/setup/models/multiphase/phases/set_domain_properties/interaction_domain/model_transition/lift/lift_montoya").execute(*args, **kwargs)
                                    def visc_disp_factor(self, *args, **kwargs):
                                        """
                                        Set the dissipation intensity.
                                        """
                                        return PyMenu(self.service, "/setup/models/multiphase/phases/set_domain_properties/interaction_domain/model_transition/lift/visc_disp_factor").execute(*args, **kwargs)
                                    def jump_adhesion(self, *args, **kwargs):
                                        """
                                        Enable the treatment of the contact angle specification at the porous jump boundary?.
                                        """
                                        return PyMenu(self.service, "/setup/models/multiphase/phases/set_domain_properties/interaction_domain/model_transition/lift/jump_adhesion").execute(*args, **kwargs)
                                    def vmass_implicit(self, *args, **kwargs):
                                        """
                                        Enable the implicit method for the virtual mass force?.
                                        """
                                        return PyMenu(self.service, "/setup/models/multiphase/phases/set_domain_properties/interaction_domain/model_transition/lift/vmass_implicit").execute(*args, **kwargs)
                                    def interphase_visc_disp(self, *args, **kwargs):
                                        """
                                        Enable the interfacial viscous dissipation method, which introduces an artificial viscous damping term in the momentum equation?.
                                        """
                                        return PyMenu(self.service, "/setup/models/multiphase/phases/set_domain_properties/interaction_domain/model_transition/lift/interphase_visc_disp").execute(*args, **kwargs)
                                    def lift(self, *args, **kwargs):
                                        """
                                        .
                                        """
                                        return PyMenu(self.service, "/setup/models/multiphase/phases/set_domain_properties/interaction_domain/model_transition/lift/lift").execute(*args, **kwargs)
                                    def slope_limiter(self, *args, **kwargs):
                                        """
                                        Specify the slope limiter to set a specific discretization scheme. 0: first order upwind, 1: second order reconstruction bounded by the global minimum/maximum of the volume fraction, 2: compressive. Value between 0 and 2: blended scheme.
                                        """
                                        return PyMenu(self.service, "/setup/models/multiphase/phases/set_domain_properties/interaction_domain/model_transition/lift/slope_limiter").execute(*args, **kwargs)
                                    def cavitation(self, *args, **kwargs):
                                        """
                                        Set the vaporization pressure, the surface tension coefficient, and the non-condensable gas mass fraction.
                                        """
                                        return PyMenu(self.service, "/setup/models/multiphase/phases/set_domain_properties/interaction_domain/model_transition/lift/cavitation").execute(*args, **kwargs)
                                    def sfc_tension_coeff(self, *args, **kwargs):
                                        """
                                        Specify the surface tension coefficient for each pair of phases.
                                        """
                                        return PyMenu(self.service, "/setup/models/multiphase/phases/set_domain_properties/interaction_domain/model_transition/lift/sfc_tension_coeff").execute(*args, **kwargs)
                                    def vmass_implicit_options(self, *args, **kwargs):
                                        """
                                        Select the virtual mass implicit option.
                                        """
                                        return PyMenu(self.service, "/setup/models/multiphase/phases/set_domain_properties/interaction_domain/model_transition/lift/vmass_implicit_options").execute(*args, **kwargs)
                                    def lift_shaver_podowski(self, *args, **kwargs):
                                        """
                                        Include the Shaver-Podowski correction for Lift.
                                        """
                                        return PyMenu(self.service, "/setup/models/multiphase/phases/set_domain_properties/interaction_domain/model_transition/lift/lift_shaver_podowski").execute(*args, **kwargs)
                                    def sfc_modeling(self, *args, **kwargs):
                                        """
                                        Include the effects of surface tension along the fluid-fluid interface?.
                                        """
                                        return PyMenu(self.service, "/setup/models/multiphase/phases/set_domain_properties/interaction_domain/model_transition/lift/sfc_modeling").execute(*args, **kwargs)
                                    def sfc_model_type(self, *args, **kwargs):
                                        """
                                        Select the surface tension model.
                                        """
                                        return PyMenu(self.service, "/setup/models/multiphase/phases/set_domain_properties/interaction_domain/model_transition/lift/sfc_model_type").execute(*args, **kwargs)
                                    def interphase_discr(self, *args, **kwargs):
                                        """
                                        Enable the phase localized compressive discretization scheme where the degree of diffusion/sharpness is controlled through the value of the slope limiters?.
                                        """
                                        return PyMenu(self.service, "/setup/models/multiphase/phases/set_domain_properties/interaction_domain/model_transition/lift/interphase_discr").execute(*args, **kwargs)
                                    def wall_adhesion(self, *args, **kwargs):
                                        """
                                        Enable the specification for a wall adhesion angle?.
                                        """
                                        return PyMenu(self.service, "/setup/models/multiphase/phases/set_domain_properties/interaction_domain/model_transition/lift/wall_adhesion").execute(*args, **kwargs)
                                    def vmass_coeff(self, *args, **kwargs):
                                        """
                                        Specify the virtual mass coefficient for each pair of phases.
                                        """
                                        return PyMenu(self.service, "/setup/models/multiphase/phases/set_domain_properties/interaction_domain/model_transition/lift/vmass_coeff").execute(*args, **kwargs)
                                    def virtual_mass(self, *args, **kwargs):
                                        """
                                        Include the virtual mass force that is present when a secondary phase accelerates relative to the primary phase?.
                                        """
                                        return PyMenu(self.service, "/setup/models/multiphase/phases/set_domain_properties/interaction_domain/model_transition/lift/virtual_mass").execute(*args, **kwargs)

                            class interfacial_area(TUIMenu):
                                """
                                Enter the menu to set interfacial area models.
                                """
                                def __init__(self, path, service):
                                    self.path = path
                                    self.service = service
                                    self.interphase_discretization = self.__class__.interphase_discretization(path + ["interphase_discretization"], service)
                                    self.interphase_viscous_dissipation = self.__class__.interphase_viscous_dissipation(path + ["interphase_viscous_dissipation"], service)
                                    self.surface_tension = self.__class__.surface_tension(path + ["surface_tension"], service)
                                    self.virtual_mass = self.__class__.virtual_mass(path + ["virtual_mass"], service)
                                    self.cavitation = self.__class__.cavitation(path + ["cavitation"], service)
                                    self.lift = self.__class__.lift(path + ["lift"], service)
                                    super().__init__(path, service)
                                def reactions(self, *args, **kwargs):
                                    """
                                    Define multiple heterogeneous reactions and stoichiometry.
                                    """
                                    return PyMenu(self.service, "/setup/models/multiphase/phases/set_domain_properties/interaction_domain/interfacial_area/reactions").execute(*args, **kwargs)
                                def model_transition(self, *args, **kwargs):
                                    """
                                    Set the model transition mechanism.
                                    """
                                    return PyMenu(self.service, "/setup/models/multiphase/phases/set_domain_properties/interaction_domain/interfacial_area/model_transition").execute(*args, **kwargs)
                                def interfacial_area(self, *args, **kwargs):
                                    """
                                    Set the interfacial area parameters for each pair of phases.
                                    """
                                    return PyMenu(self.service, "/setup/models/multiphase/phases/set_domain_properties/interaction_domain/interfacial_area/interfacial_area").execute(*args, **kwargs)
                                def heat_coeff(self, *args, **kwargs):
                                    """
                                    Specify the heat transfer coefficient function between each pair of phases.
                                    """
                                    return PyMenu(self.service, "/setup/models/multiphase/phases/set_domain_properties/interaction_domain/interfacial_area/heat_coeff").execute(*args, **kwargs)
                                def turbulent_dispersion(self, *args, **kwargs):
                                    """
                                    Specify the turbulent dispersion model for each primary-secondary phase pair.
                                    """
                                    return PyMenu(self.service, "/setup/models/multiphase/phases/set_domain_properties/interaction_domain/interfacial_area/turbulent_dispersion").execute(*args, **kwargs)
                                def turbulence_interaction(self, *args, **kwargs):
                                    """
                                    Specify the turbulence interaction model for each primary-secondary phase pair.
                                    """
                                    return PyMenu(self.service, "/setup/models/multiphase/phases/set_domain_properties/interaction_domain/interfacial_area/turbulence_interaction").execute(*args, **kwargs)
                                def restitution(self, *args, **kwargs):
                                    """
                                    Specify the restitution coefficient for collisions between each pair of granular phases and for collisions between particles of the same granular phase.
                                    """
                                    return PyMenu(self.service, "/setup/models/multiphase/phases/set_domain_properties/interaction_domain/interfacial_area/restitution").execute(*args, **kwargs)
                                def drag(self, *args, **kwargs):
                                    """
                                    Specify the drag function for each pair of phases. It also enables drag modification and allow specifying the drag factor.
                                    """
                                    return PyMenu(self.service, "/setup/models/multiphase/phases/set_domain_properties/interaction_domain/interfacial_area/drag").execute(*args, **kwargs)
                                def slip_velocity(self, *args, **kwargs):
                                    """
                                    Specify the slip velocity function for each secondary phase with respect to the primary phase.
                                    """
                                    return PyMenu(self.service, "/setup/models/multiphase/phases/set_domain_properties/interaction_domain/interfacial_area/slip_velocity").execute(*args, **kwargs)
                                def wall_lubrication(self, *args, **kwargs):
                                    """
                                    Specify the wall lubrication model for each primary-secondary phase pair.
                                    """
                                    return PyMenu(self.service, "/setup/models/multiphase/phases/set_domain_properties/interaction_domain/interfacial_area/wall_lubrication").execute(*args, **kwargs)
                                def mass_transfer(self, *args, **kwargs):
                                    """
                                    Specify the mass transfer mechanisms.
                                    """
                                    return PyMenu(self.service, "/setup/models/multiphase/phases/set_domain_properties/interaction_domain/interfacial_area/mass_transfer").execute(*args, **kwargs)

                                class interphase_discretization(TUIMenu):
                                    """
                                    Enter the menu to set interphase discretization models.
                                    """
                                    def __init__(self, path, service):
                                        self.path = path
                                        self.service = service
                                        super().__init__(path, service)
                                    def sfc_tension_coeff(self, *args, **kwargs):
                                        """
                                        Specify the surface tension coefficient for each pair of phases.
                                        """
                                        return PyMenu(self.service, "/setup/models/multiphase/phases/set_domain_properties/interaction_domain/interfacial_area/interphase_discretization/sfc_tension_coeff").execute(*args, **kwargs)
                                    def virtual_mass(self, *args, **kwargs):
                                        """
                                        Include the virtual mass force that is present when a secondary phase accelerates relative to the primary phase?.
                                        """
                                        return PyMenu(self.service, "/setup/models/multiphase/phases/set_domain_properties/interaction_domain/interfacial_area/interphase_discretization/virtual_mass").execute(*args, **kwargs)
                                    def sfc_model_type(self, *args, **kwargs):
                                        """
                                        Select the surface tension model.
                                        """
                                        return PyMenu(self.service, "/setup/models/multiphase/phases/set_domain_properties/interaction_domain/interfacial_area/interphase_discretization/sfc_model_type").execute(*args, **kwargs)
                                    def lift_montoya(self, *args, **kwargs):
                                        """
                                        Include the Montoya correction for Lift.
                                        """
                                        return PyMenu(self.service, "/setup/models/multiphase/phases/set_domain_properties/interaction_domain/interfacial_area/interphase_discretization/lift_montoya").execute(*args, **kwargs)
                                    def lift_shaver_podowski(self, *args, **kwargs):
                                        """
                                        Include the Shaver-Podowski correction for Lift.
                                        """
                                        return PyMenu(self.service, "/setup/models/multiphase/phases/set_domain_properties/interaction_domain/interfacial_area/interphase_discretization/lift_shaver_podowski").execute(*args, **kwargs)
                                    def vmass_coeff(self, *args, **kwargs):
                                        """
                                        Specify the virtual mass coefficient for each pair of phases.
                                        """
                                        return PyMenu(self.service, "/setup/models/multiphase/phases/set_domain_properties/interaction_domain/interfacial_area/interphase_discretization/vmass_coeff").execute(*args, **kwargs)
                                    def interphase_visc_disp(self, *args, **kwargs):
                                        """
                                        Enable the interfacial viscous dissipation method, which introduces an artificial viscous damping term in the momentum equation?.
                                        """
                                        return PyMenu(self.service, "/setup/models/multiphase/phases/set_domain_properties/interaction_domain/interfacial_area/interphase_discretization/interphase_visc_disp").execute(*args, **kwargs)
                                    def slope_limiter(self, *args, **kwargs):
                                        """
                                        Specify the slope limiter to set a specific discretization scheme. 0: first order upwind, 1: second order reconstruction bounded by the global minimum/maximum of the volume fraction, 2: compressive. Value between 0 and 2: blended scheme.
                                        """
                                        return PyMenu(self.service, "/setup/models/multiphase/phases/set_domain_properties/interaction_domain/interfacial_area/interphase_discretization/slope_limiter").execute(*args, **kwargs)
                                    def jump_adhesion(self, *args, **kwargs):
                                        """
                                        Enable the treatment of the contact angle specification at the porous jump boundary?.
                                        """
                                        return PyMenu(self.service, "/setup/models/multiphase/phases/set_domain_properties/interaction_domain/interfacial_area/interphase_discretization/jump_adhesion").execute(*args, **kwargs)
                                    def vmass_implicit(self, *args, **kwargs):
                                        """
                                        Enable the implicit method for the virtual mass force?.
                                        """
                                        return PyMenu(self.service, "/setup/models/multiphase/phases/set_domain_properties/interaction_domain/interfacial_area/interphase_discretization/vmass_implicit").execute(*args, **kwargs)
                                    def visc_disp_factor(self, *args, **kwargs):
                                        """
                                        Set the dissipation intensity.
                                        """
                                        return PyMenu(self.service, "/setup/models/multiphase/phases/set_domain_properties/interaction_domain/interfacial_area/interphase_discretization/visc_disp_factor").execute(*args, **kwargs)
                                    def sfc_modeling(self, *args, **kwargs):
                                        """
                                        Include the effects of surface tension along the fluid-fluid interface?.
                                        """
                                        return PyMenu(self.service, "/setup/models/multiphase/phases/set_domain_properties/interaction_domain/interfacial_area/interphase_discretization/sfc_modeling").execute(*args, **kwargs)
                                    def cavitation(self, *args, **kwargs):
                                        """
                                        Set the vaporization pressure, the surface tension coefficient, and the non-condensable gas mass fraction.
                                        """
                                        return PyMenu(self.service, "/setup/models/multiphase/phases/set_domain_properties/interaction_domain/interfacial_area/interphase_discretization/cavitation").execute(*args, **kwargs)
                                    def wall_adhesion(self, *args, **kwargs):
                                        """
                                        Enable the specification for a wall adhesion angle?.
                                        """
                                        return PyMenu(self.service, "/setup/models/multiphase/phases/set_domain_properties/interaction_domain/interfacial_area/interphase_discretization/wall_adhesion").execute(*args, **kwargs)
                                    def lift(self, *args, **kwargs):
                                        """
                                        .
                                        """
                                        return PyMenu(self.service, "/setup/models/multiphase/phases/set_domain_properties/interaction_domain/interfacial_area/interphase_discretization/lift").execute(*args, **kwargs)
                                    def interphase_discr(self, *args, **kwargs):
                                        """
                                        Enable the phase localized compressive discretization scheme where the degree of diffusion/sharpness is controlled through the value of the slope limiters?.
                                        """
                                        return PyMenu(self.service, "/setup/models/multiphase/phases/set_domain_properties/interaction_domain/interfacial_area/interphase_discretization/interphase_discr").execute(*args, **kwargs)
                                    def vmass_implicit_options(self, *args, **kwargs):
                                        """
                                        Select the virtual mass implicit option.
                                        """
                                        return PyMenu(self.service, "/setup/models/multiphase/phases/set_domain_properties/interaction_domain/interfacial_area/interphase_discretization/vmass_implicit_options").execute(*args, **kwargs)

                                class interphase_viscous_dissipation(TUIMenu):
                                    """
                                    Enter the menu to set interphase viscous dissipation related models.
                                    """
                                    def __init__(self, path, service):
                                        self.path = path
                                        self.service = service
                                        super().__init__(path, service)
                                    def lift_shaver_podowski(self, *args, **kwargs):
                                        """
                                        Include the Shaver-Podowski correction for Lift.
                                        """
                                        return PyMenu(self.service, "/setup/models/multiphase/phases/set_domain_properties/interaction_domain/interfacial_area/interphase_viscous_dissipation/lift_shaver_podowski").execute(*args, **kwargs)
                                    def virtual_mass(self, *args, **kwargs):
                                        """
                                        Include the virtual mass force that is present when a secondary phase accelerates relative to the primary phase?.
                                        """
                                        return PyMenu(self.service, "/setup/models/multiphase/phases/set_domain_properties/interaction_domain/interfacial_area/interphase_viscous_dissipation/virtual_mass").execute(*args, **kwargs)
                                    def lift_montoya(self, *args, **kwargs):
                                        """
                                        Include the Montoya correction for Lift.
                                        """
                                        return PyMenu(self.service, "/setup/models/multiphase/phases/set_domain_properties/interaction_domain/interfacial_area/interphase_viscous_dissipation/lift_montoya").execute(*args, **kwargs)
                                    def interphase_visc_disp(self, *args, **kwargs):
                                        """
                                        Enable the interfacial viscous dissipation method, which introduces an artificial viscous damping term in the momentum equation?.
                                        """
                                        return PyMenu(self.service, "/setup/models/multiphase/phases/set_domain_properties/interaction_domain/interfacial_area/interphase_viscous_dissipation/interphase_visc_disp").execute(*args, **kwargs)
                                    def lift(self, *args, **kwargs):
                                        """
                                        .
                                        """
                                        return PyMenu(self.service, "/setup/models/multiphase/phases/set_domain_properties/interaction_domain/interfacial_area/interphase_viscous_dissipation/lift").execute(*args, **kwargs)
                                    def sfc_tension_coeff(self, *args, **kwargs):
                                        """
                                        Specify the surface tension coefficient for each pair of phases.
                                        """
                                        return PyMenu(self.service, "/setup/models/multiphase/phases/set_domain_properties/interaction_domain/interfacial_area/interphase_viscous_dissipation/sfc_tension_coeff").execute(*args, **kwargs)
                                    def vmass_implicit(self, *args, **kwargs):
                                        """
                                        Enable the implicit method for the virtual mass force?.
                                        """
                                        return PyMenu(self.service, "/setup/models/multiphase/phases/set_domain_properties/interaction_domain/interfacial_area/interphase_viscous_dissipation/vmass_implicit").execute(*args, **kwargs)
                                    def vmass_implicit_options(self, *args, **kwargs):
                                        """
                                        Select the virtual mass implicit option.
                                        """
                                        return PyMenu(self.service, "/setup/models/multiphase/phases/set_domain_properties/interaction_domain/interfacial_area/interphase_viscous_dissipation/vmass_implicit_options").execute(*args, **kwargs)
                                    def jump_adhesion(self, *args, **kwargs):
                                        """
                                        Enable the treatment of the contact angle specification at the porous jump boundary?.
                                        """
                                        return PyMenu(self.service, "/setup/models/multiphase/phases/set_domain_properties/interaction_domain/interfacial_area/interphase_viscous_dissipation/jump_adhesion").execute(*args, **kwargs)
                                    def cavitation(self, *args, **kwargs):
                                        """
                                        Set the vaporization pressure, the surface tension coefficient, and the non-condensable gas mass fraction.
                                        """
                                        return PyMenu(self.service, "/setup/models/multiphase/phases/set_domain_properties/interaction_domain/interfacial_area/interphase_viscous_dissipation/cavitation").execute(*args, **kwargs)
                                    def wall_adhesion(self, *args, **kwargs):
                                        """
                                        Enable the specification for a wall adhesion angle?.
                                        """
                                        return PyMenu(self.service, "/setup/models/multiphase/phases/set_domain_properties/interaction_domain/interfacial_area/interphase_viscous_dissipation/wall_adhesion").execute(*args, **kwargs)
                                    def slope_limiter(self, *args, **kwargs):
                                        """
                                        Specify the slope limiter to set a specific discretization scheme. 0: first order upwind, 1: second order reconstruction bounded by the global minimum/maximum of the volume fraction, 2: compressive. Value between 0 and 2: blended scheme.
                                        """
                                        return PyMenu(self.service, "/setup/models/multiphase/phases/set_domain_properties/interaction_domain/interfacial_area/interphase_viscous_dissipation/slope_limiter").execute(*args, **kwargs)
                                    def interphase_discr(self, *args, **kwargs):
                                        """
                                        Enable the phase localized compressive discretization scheme where the degree of diffusion/sharpness is controlled through the value of the slope limiters?.
                                        """
                                        return PyMenu(self.service, "/setup/models/multiphase/phases/set_domain_properties/interaction_domain/interfacial_area/interphase_viscous_dissipation/interphase_discr").execute(*args, **kwargs)
                                    def vmass_coeff(self, *args, **kwargs):
                                        """
                                        Specify the virtual mass coefficient for each pair of phases.
                                        """
                                        return PyMenu(self.service, "/setup/models/multiphase/phases/set_domain_properties/interaction_domain/interfacial_area/interphase_viscous_dissipation/vmass_coeff").execute(*args, **kwargs)
                                    def sfc_modeling(self, *args, **kwargs):
                                        """
                                        Include the effects of surface tension along the fluid-fluid interface?.
                                        """
                                        return PyMenu(self.service, "/setup/models/multiphase/phases/set_domain_properties/interaction_domain/interfacial_area/interphase_viscous_dissipation/sfc_modeling").execute(*args, **kwargs)
                                    def sfc_model_type(self, *args, **kwargs):
                                        """
                                        Select the surface tension model.
                                        """
                                        return PyMenu(self.service, "/setup/models/multiphase/phases/set_domain_properties/interaction_domain/interfacial_area/interphase_viscous_dissipation/sfc_model_type").execute(*args, **kwargs)
                                    def visc_disp_factor(self, *args, **kwargs):
                                        """
                                        Set the dissipation intensity.
                                        """
                                        return PyMenu(self.service, "/setup/models/multiphase/phases/set_domain_properties/interaction_domain/interfacial_area/interphase_viscous_dissipation/visc_disp_factor").execute(*args, **kwargs)

                                class surface_tension(TUIMenu):
                                    """
                                    Enter the menu to set surface tension models.
                                    """
                                    def __init__(self, path, service):
                                        self.path = path
                                        self.service = service
                                        super().__init__(path, service)
                                    def interphase_discr(self, *args, **kwargs):
                                        """
                                        Enable the phase localized compressive discretization scheme where the degree of diffusion/sharpness is controlled through the value of the slope limiters?.
                                        """
                                        return PyMenu(self.service, "/setup/models/multiphase/phases/set_domain_properties/interaction_domain/interfacial_area/surface_tension/interphase_discr").execute(*args, **kwargs)
                                    def lift_montoya(self, *args, **kwargs):
                                        """
                                        Include the Montoya correction for Lift.
                                        """
                                        return PyMenu(self.service, "/setup/models/multiphase/phases/set_domain_properties/interaction_domain/interfacial_area/surface_tension/lift_montoya").execute(*args, **kwargs)
                                    def jump_adhesion(self, *args, **kwargs):
                                        """
                                        Enable the treatment of the contact angle specification at the porous jump boundary?.
                                        """
                                        return PyMenu(self.service, "/setup/models/multiphase/phases/set_domain_properties/interaction_domain/interfacial_area/surface_tension/jump_adhesion").execute(*args, **kwargs)
                                    def virtual_mass(self, *args, **kwargs):
                                        """
                                        Include the virtual mass force that is present when a secondary phase accelerates relative to the primary phase?.
                                        """
                                        return PyMenu(self.service, "/setup/models/multiphase/phases/set_domain_properties/interaction_domain/interfacial_area/surface_tension/virtual_mass").execute(*args, **kwargs)
                                    def cavitation(self, *args, **kwargs):
                                        """
                                        Set the vaporization pressure, the surface tension coefficient, and the non-condensable gas mass fraction.
                                        """
                                        return PyMenu(self.service, "/setup/models/multiphase/phases/set_domain_properties/interaction_domain/interfacial_area/surface_tension/cavitation").execute(*args, **kwargs)
                                    def sfc_tension_coeff(self, *args, **kwargs):
                                        """
                                        Specify the surface tension coefficient for each pair of phases.
                                        """
                                        return PyMenu(self.service, "/setup/models/multiphase/phases/set_domain_properties/interaction_domain/interfacial_area/surface_tension/sfc_tension_coeff").execute(*args, **kwargs)
                                    def lift(self, *args, **kwargs):
                                        """
                                        .
                                        """
                                        return PyMenu(self.service, "/setup/models/multiphase/phases/set_domain_properties/interaction_domain/interfacial_area/surface_tension/lift").execute(*args, **kwargs)
                                    def wall_adhesion(self, *args, **kwargs):
                                        """
                                        Enable the specification for a wall adhesion angle?.
                                        """
                                        return PyMenu(self.service, "/setup/models/multiphase/phases/set_domain_properties/interaction_domain/interfacial_area/surface_tension/wall_adhesion").execute(*args, **kwargs)
                                    def vmass_implicit(self, *args, **kwargs):
                                        """
                                        Enable the implicit method for the virtual mass force?.
                                        """
                                        return PyMenu(self.service, "/setup/models/multiphase/phases/set_domain_properties/interaction_domain/interfacial_area/surface_tension/vmass_implicit").execute(*args, **kwargs)
                                    def sfc_modeling(self, *args, **kwargs):
                                        """
                                        Include the effects of surface tension along the fluid-fluid interface?.
                                        """
                                        return PyMenu(self.service, "/setup/models/multiphase/phases/set_domain_properties/interaction_domain/interfacial_area/surface_tension/sfc_modeling").execute(*args, **kwargs)
                                    def lift_shaver_podowski(self, *args, **kwargs):
                                        """
                                        Include the Shaver-Podowski correction for Lift.
                                        """
                                        return PyMenu(self.service, "/setup/models/multiphase/phases/set_domain_properties/interaction_domain/interfacial_area/surface_tension/lift_shaver_podowski").execute(*args, **kwargs)
                                    def visc_disp_factor(self, *args, **kwargs):
                                        """
                                        Set the dissipation intensity.
                                        """
                                        return PyMenu(self.service, "/setup/models/multiphase/phases/set_domain_properties/interaction_domain/interfacial_area/surface_tension/visc_disp_factor").execute(*args, **kwargs)
                                    def slope_limiter(self, *args, **kwargs):
                                        """
                                        Specify the slope limiter to set a specific discretization scheme. 0: first order upwind, 1: second order reconstruction bounded by the global minimum/maximum of the volume fraction, 2: compressive. Value between 0 and 2: blended scheme.
                                        """
                                        return PyMenu(self.service, "/setup/models/multiphase/phases/set_domain_properties/interaction_domain/interfacial_area/surface_tension/slope_limiter").execute(*args, **kwargs)
                                    def vmass_coeff(self, *args, **kwargs):
                                        """
                                        Specify the virtual mass coefficient for each pair of phases.
                                        """
                                        return PyMenu(self.service, "/setup/models/multiphase/phases/set_domain_properties/interaction_domain/interfacial_area/surface_tension/vmass_coeff").execute(*args, **kwargs)
                                    def interphase_visc_disp(self, *args, **kwargs):
                                        """
                                        Enable the interfacial viscous dissipation method, which introduces an artificial viscous damping term in the momentum equation?.
                                        """
                                        return PyMenu(self.service, "/setup/models/multiphase/phases/set_domain_properties/interaction_domain/interfacial_area/surface_tension/interphase_visc_disp").execute(*args, **kwargs)
                                    def vmass_implicit_options(self, *args, **kwargs):
                                        """
                                        Select the virtual mass implicit option.
                                        """
                                        return PyMenu(self.service, "/setup/models/multiphase/phases/set_domain_properties/interaction_domain/interfacial_area/surface_tension/vmass_implicit_options").execute(*args, **kwargs)
                                    def sfc_model_type(self, *args, **kwargs):
                                        """
                                        Select the surface tension model.
                                        """
                                        return PyMenu(self.service, "/setup/models/multiphase/phases/set_domain_properties/interaction_domain/interfacial_area/surface_tension/sfc_model_type").execute(*args, **kwargs)

                                class virtual_mass(TUIMenu):
                                    """
                                    Enter the menu to set virtual mass models.
                                    """
                                    def __init__(self, path, service):
                                        self.path = path
                                        self.service = service
                                        super().__init__(path, service)
                                    def lift_montoya(self, *args, **kwargs):
                                        """
                                        Include the Montoya correction for Lift.
                                        """
                                        return PyMenu(self.service, "/setup/models/multiphase/phases/set_domain_properties/interaction_domain/interfacial_area/virtual_mass/lift_montoya").execute(*args, **kwargs)
                                    def sfc_model_type(self, *args, **kwargs):
                                        """
                                        Select the surface tension model.
                                        """
                                        return PyMenu(self.service, "/setup/models/multiphase/phases/set_domain_properties/interaction_domain/interfacial_area/virtual_mass/sfc_model_type").execute(*args, **kwargs)
                                    def interphase_discr(self, *args, **kwargs):
                                        """
                                        Enable the phase localized compressive discretization scheme where the degree of diffusion/sharpness is controlled through the value of the slope limiters?.
                                        """
                                        return PyMenu(self.service, "/setup/models/multiphase/phases/set_domain_properties/interaction_domain/interfacial_area/virtual_mass/interphase_discr").execute(*args, **kwargs)
                                    def interphase_visc_disp(self, *args, **kwargs):
                                        """
                                        Enable the interfacial viscous dissipation method, which introduces an artificial viscous damping term in the momentum equation?.
                                        """
                                        return PyMenu(self.service, "/setup/models/multiphase/phases/set_domain_properties/interaction_domain/interfacial_area/virtual_mass/interphase_visc_disp").execute(*args, **kwargs)
                                    def vmass_implicit_options(self, *args, **kwargs):
                                        """
                                        Select the virtual mass implicit option.
                                        """
                                        return PyMenu(self.service, "/setup/models/multiphase/phases/set_domain_properties/interaction_domain/interfacial_area/virtual_mass/vmass_implicit_options").execute(*args, **kwargs)
                                    def lift(self, *args, **kwargs):
                                        """
                                        .
                                        """
                                        return PyMenu(self.service, "/setup/models/multiphase/phases/set_domain_properties/interaction_domain/interfacial_area/virtual_mass/lift").execute(*args, **kwargs)
                                    def vmass_implicit(self, *args, **kwargs):
                                        """
                                        Enable the implicit method for the virtual mass force?.
                                        """
                                        return PyMenu(self.service, "/setup/models/multiphase/phases/set_domain_properties/interaction_domain/interfacial_area/virtual_mass/vmass_implicit").execute(*args, **kwargs)
                                    def sfc_modeling(self, *args, **kwargs):
                                        """
                                        Include the effects of surface tension along the fluid-fluid interface?.
                                        """
                                        return PyMenu(self.service, "/setup/models/multiphase/phases/set_domain_properties/interaction_domain/interfacial_area/virtual_mass/sfc_modeling").execute(*args, **kwargs)
                                    def sfc_tension_coeff(self, *args, **kwargs):
                                        """
                                        Specify the surface tension coefficient for each pair of phases.
                                        """
                                        return PyMenu(self.service, "/setup/models/multiphase/phases/set_domain_properties/interaction_domain/interfacial_area/virtual_mass/sfc_tension_coeff").execute(*args, **kwargs)
                                    def vmass_coeff(self, *args, **kwargs):
                                        """
                                        Specify the virtual mass coefficient for each pair of phases.
                                        """
                                        return PyMenu(self.service, "/setup/models/multiphase/phases/set_domain_properties/interaction_domain/interfacial_area/virtual_mass/vmass_coeff").execute(*args, **kwargs)
                                    def wall_adhesion(self, *args, **kwargs):
                                        """
                                        Enable the specification for a wall adhesion angle?.
                                        """
                                        return PyMenu(self.service, "/setup/models/multiphase/phases/set_domain_properties/interaction_domain/interfacial_area/virtual_mass/wall_adhesion").execute(*args, **kwargs)
                                    def visc_disp_factor(self, *args, **kwargs):
                                        """
                                        Set the dissipation intensity.
                                        """
                                        return PyMenu(self.service, "/setup/models/multiphase/phases/set_domain_properties/interaction_domain/interfacial_area/virtual_mass/visc_disp_factor").execute(*args, **kwargs)
                                    def jump_adhesion(self, *args, **kwargs):
                                        """
                                        Enable the treatment of the contact angle specification at the porous jump boundary?.
                                        """
                                        return PyMenu(self.service, "/setup/models/multiphase/phases/set_domain_properties/interaction_domain/interfacial_area/virtual_mass/jump_adhesion").execute(*args, **kwargs)
                                    def virtual_mass(self, *args, **kwargs):
                                        """
                                        Include the virtual mass force that is present when a secondary phase accelerates relative to the primary phase?.
                                        """
                                        return PyMenu(self.service, "/setup/models/multiphase/phases/set_domain_properties/interaction_domain/interfacial_area/virtual_mass/virtual_mass").execute(*args, **kwargs)
                                    def slope_limiter(self, *args, **kwargs):
                                        """
                                        Specify the slope limiter to set a specific discretization scheme. 0: first order upwind, 1: second order reconstruction bounded by the global minimum/maximum of the volume fraction, 2: compressive. Value between 0 and 2: blended scheme.
                                        """
                                        return PyMenu(self.service, "/setup/models/multiphase/phases/set_domain_properties/interaction_domain/interfacial_area/virtual_mass/slope_limiter").execute(*args, **kwargs)
                                    def cavitation(self, *args, **kwargs):
                                        """
                                        Set the vaporization pressure, the surface tension coefficient, and the non-condensable gas mass fraction.
                                        """
                                        return PyMenu(self.service, "/setup/models/multiphase/phases/set_domain_properties/interaction_domain/interfacial_area/virtual_mass/cavitation").execute(*args, **kwargs)
                                    def lift_shaver_podowski(self, *args, **kwargs):
                                        """
                                        Include the Shaver-Podowski correction for Lift.
                                        """
                                        return PyMenu(self.service, "/setup/models/multiphase/phases/set_domain_properties/interaction_domain/interfacial_area/virtual_mass/lift_shaver_podowski").execute(*args, **kwargs)

                                class cavitation(TUIMenu):
                                    """
                                    Enter the menu to set cavitation models.
                                    """
                                    def __init__(self, path, service):
                                        self.path = path
                                        self.service = service
                                        super().__init__(path, service)
                                    def cavitation(self, *args, **kwargs):
                                        """
                                        Set the vaporization pressure, the surface tension coefficient, and the non-condensable gas mass fraction.
                                        """
                                        return PyMenu(self.service, "/setup/models/multiphase/phases/set_domain_properties/interaction_domain/interfacial_area/cavitation/cavitation").execute(*args, **kwargs)
                                    def vmass_implicit(self, *args, **kwargs):
                                        """
                                        Enable the implicit method for the virtual mass force?.
                                        """
                                        return PyMenu(self.service, "/setup/models/multiphase/phases/set_domain_properties/interaction_domain/interfacial_area/cavitation/vmass_implicit").execute(*args, **kwargs)
                                    def lift_montoya(self, *args, **kwargs):
                                        """
                                        Include the Montoya correction for Lift.
                                        """
                                        return PyMenu(self.service, "/setup/models/multiphase/phases/set_domain_properties/interaction_domain/interfacial_area/cavitation/lift_montoya").execute(*args, **kwargs)
                                    def vmass_coeff(self, *args, **kwargs):
                                        """
                                        Specify the virtual mass coefficient for each pair of phases.
                                        """
                                        return PyMenu(self.service, "/setup/models/multiphase/phases/set_domain_properties/interaction_domain/interfacial_area/cavitation/vmass_coeff").execute(*args, **kwargs)
                                    def visc_disp_factor(self, *args, **kwargs):
                                        """
                                        Set the dissipation intensity.
                                        """
                                        return PyMenu(self.service, "/setup/models/multiphase/phases/set_domain_properties/interaction_domain/interfacial_area/cavitation/visc_disp_factor").execute(*args, **kwargs)
                                    def jump_adhesion(self, *args, **kwargs):
                                        """
                                        Enable the treatment of the contact angle specification at the porous jump boundary?.
                                        """
                                        return PyMenu(self.service, "/setup/models/multiphase/phases/set_domain_properties/interaction_domain/interfacial_area/cavitation/jump_adhesion").execute(*args, **kwargs)
                                    def lift_shaver_podowski(self, *args, **kwargs):
                                        """
                                        Include the Shaver-Podowski correction for Lift.
                                        """
                                        return PyMenu(self.service, "/setup/models/multiphase/phases/set_domain_properties/interaction_domain/interfacial_area/cavitation/lift_shaver_podowski").execute(*args, **kwargs)
                                    def wall_adhesion(self, *args, **kwargs):
                                        """
                                        Enable the specification for a wall adhesion angle?.
                                        """
                                        return PyMenu(self.service, "/setup/models/multiphase/phases/set_domain_properties/interaction_domain/interfacial_area/cavitation/wall_adhesion").execute(*args, **kwargs)
                                    def lift(self, *args, **kwargs):
                                        """
                                        .
                                        """
                                        return PyMenu(self.service, "/setup/models/multiphase/phases/set_domain_properties/interaction_domain/interfacial_area/cavitation/lift").execute(*args, **kwargs)
                                    def sfc_tension_coeff(self, *args, **kwargs):
                                        """
                                        Specify the surface tension coefficient for each pair of phases.
                                        """
                                        return PyMenu(self.service, "/setup/models/multiphase/phases/set_domain_properties/interaction_domain/interfacial_area/cavitation/sfc_tension_coeff").execute(*args, **kwargs)
                                    def sfc_modeling(self, *args, **kwargs):
                                        """
                                        Include the effects of surface tension along the fluid-fluid interface?.
                                        """
                                        return PyMenu(self.service, "/setup/models/multiphase/phases/set_domain_properties/interaction_domain/interfacial_area/cavitation/sfc_modeling").execute(*args, **kwargs)
                                    def interphase_discr(self, *args, **kwargs):
                                        """
                                        Enable the phase localized compressive discretization scheme where the degree of diffusion/sharpness is controlled through the value of the slope limiters?.
                                        """
                                        return PyMenu(self.service, "/setup/models/multiphase/phases/set_domain_properties/interaction_domain/interfacial_area/cavitation/interphase_discr").execute(*args, **kwargs)
                                    def interphase_visc_disp(self, *args, **kwargs):
                                        """
                                        Enable the interfacial viscous dissipation method, which introduces an artificial viscous damping term in the momentum equation?.
                                        """
                                        return PyMenu(self.service, "/setup/models/multiphase/phases/set_domain_properties/interaction_domain/interfacial_area/cavitation/interphase_visc_disp").execute(*args, **kwargs)
                                    def vmass_implicit_options(self, *args, **kwargs):
                                        """
                                        Select the virtual mass implicit option.
                                        """
                                        return PyMenu(self.service, "/setup/models/multiphase/phases/set_domain_properties/interaction_domain/interfacial_area/cavitation/vmass_implicit_options").execute(*args, **kwargs)
                                    def virtual_mass(self, *args, **kwargs):
                                        """
                                        Include the virtual mass force that is present when a secondary phase accelerates relative to the primary phase?.
                                        """
                                        return PyMenu(self.service, "/setup/models/multiphase/phases/set_domain_properties/interaction_domain/interfacial_area/cavitation/virtual_mass").execute(*args, **kwargs)
                                    def slope_limiter(self, *args, **kwargs):
                                        """
                                        Specify the slope limiter to set a specific discretization scheme. 0: first order upwind, 1: second order reconstruction bounded by the global minimum/maximum of the volume fraction, 2: compressive. Value between 0 and 2: blended scheme.
                                        """
                                        return PyMenu(self.service, "/setup/models/multiphase/phases/set_domain_properties/interaction_domain/interfacial_area/cavitation/slope_limiter").execute(*args, **kwargs)
                                    def sfc_model_type(self, *args, **kwargs):
                                        """
                                        Select the surface tension model.
                                        """
                                        return PyMenu(self.service, "/setup/models/multiphase/phases/set_domain_properties/interaction_domain/interfacial_area/cavitation/sfc_model_type").execute(*args, **kwargs)

                                class lift(TUIMenu):
                                    """
                                    Enter the menu to set lift models.
                                    """
                                    def __init__(self, path, service):
                                        self.path = path
                                        self.service = service
                                        super().__init__(path, service)
                                    def virtual_mass(self, *args, **kwargs):
                                        """
                                        Include the virtual mass force that is present when a secondary phase accelerates relative to the primary phase?.
                                        """
                                        return PyMenu(self.service, "/setup/models/multiphase/phases/set_domain_properties/interaction_domain/interfacial_area/lift/virtual_mass").execute(*args, **kwargs)
                                    def interphase_discr(self, *args, **kwargs):
                                        """
                                        Enable the phase localized compressive discretization scheme where the degree of diffusion/sharpness is controlled through the value of the slope limiters?.
                                        """
                                        return PyMenu(self.service, "/setup/models/multiphase/phases/set_domain_properties/interaction_domain/interfacial_area/lift/interphase_discr").execute(*args, **kwargs)
                                    def lift_shaver_podowski(self, *args, **kwargs):
                                        """
                                        Include the Shaver-Podowski correction for Lift.
                                        """
                                        return PyMenu(self.service, "/setup/models/multiphase/phases/set_domain_properties/interaction_domain/interfacial_area/lift/lift_shaver_podowski").execute(*args, **kwargs)
                                    def interphase_visc_disp(self, *args, **kwargs):
                                        """
                                        Enable the interfacial viscous dissipation method, which introduces an artificial viscous damping term in the momentum equation?.
                                        """
                                        return PyMenu(self.service, "/setup/models/multiphase/phases/set_domain_properties/interaction_domain/interfacial_area/lift/interphase_visc_disp").execute(*args, **kwargs)
                                    def vmass_implicit_options(self, *args, **kwargs):
                                        """
                                        Select the virtual mass implicit option.
                                        """
                                        return PyMenu(self.service, "/setup/models/multiphase/phases/set_domain_properties/interaction_domain/interfacial_area/lift/vmass_implicit_options").execute(*args, **kwargs)
                                    def lift_montoya(self, *args, **kwargs):
                                        """
                                        Include the Montoya correction for Lift.
                                        """
                                        return PyMenu(self.service, "/setup/models/multiphase/phases/set_domain_properties/interaction_domain/interfacial_area/lift/lift_montoya").execute(*args, **kwargs)
                                    def lift(self, *args, **kwargs):
                                        """
                                        .
                                        """
                                        return PyMenu(self.service, "/setup/models/multiphase/phases/set_domain_properties/interaction_domain/interfacial_area/lift/lift").execute(*args, **kwargs)
                                    def sfc_tension_coeff(self, *args, **kwargs):
                                        """
                                        Specify the surface tension coefficient for each pair of phases.
                                        """
                                        return PyMenu(self.service, "/setup/models/multiphase/phases/set_domain_properties/interaction_domain/interfacial_area/lift/sfc_tension_coeff").execute(*args, **kwargs)
                                    def vmass_coeff(self, *args, **kwargs):
                                        """
                                        Specify the virtual mass coefficient for each pair of phases.
                                        """
                                        return PyMenu(self.service, "/setup/models/multiphase/phases/set_domain_properties/interaction_domain/interfacial_area/lift/vmass_coeff").execute(*args, **kwargs)
                                    def vmass_implicit(self, *args, **kwargs):
                                        """
                                        Enable the implicit method for the virtual mass force?.
                                        """
                                        return PyMenu(self.service, "/setup/models/multiphase/phases/set_domain_properties/interaction_domain/interfacial_area/lift/vmass_implicit").execute(*args, **kwargs)
                                    def cavitation(self, *args, **kwargs):
                                        """
                                        Set the vaporization pressure, the surface tension coefficient, and the non-condensable gas mass fraction.
                                        """
                                        return PyMenu(self.service, "/setup/models/multiphase/phases/set_domain_properties/interaction_domain/interfacial_area/lift/cavitation").execute(*args, **kwargs)
                                    def sfc_modeling(self, *args, **kwargs):
                                        """
                                        Include the effects of surface tension along the fluid-fluid interface?.
                                        """
                                        return PyMenu(self.service, "/setup/models/multiphase/phases/set_domain_properties/interaction_domain/interfacial_area/lift/sfc_modeling").execute(*args, **kwargs)
                                    def slope_limiter(self, *args, **kwargs):
                                        """
                                        Specify the slope limiter to set a specific discretization scheme. 0: first order upwind, 1: second order reconstruction bounded by the global minimum/maximum of the volume fraction, 2: compressive. Value between 0 and 2: blended scheme.
                                        """
                                        return PyMenu(self.service, "/setup/models/multiphase/phases/set_domain_properties/interaction_domain/interfacial_area/lift/slope_limiter").execute(*args, **kwargs)
                                    def wall_adhesion(self, *args, **kwargs):
                                        """
                                        Enable the specification for a wall adhesion angle?.
                                        """
                                        return PyMenu(self.service, "/setup/models/multiphase/phases/set_domain_properties/interaction_domain/interfacial_area/lift/wall_adhesion").execute(*args, **kwargs)
                                    def jump_adhesion(self, *args, **kwargs):
                                        """
                                        Enable the treatment of the contact angle specification at the porous jump boundary?.
                                        """
                                        return PyMenu(self.service, "/setup/models/multiphase/phases/set_domain_properties/interaction_domain/interfacial_area/lift/jump_adhesion").execute(*args, **kwargs)
                                    def sfc_model_type(self, *args, **kwargs):
                                        """
                                        Select the surface tension model.
                                        """
                                        return PyMenu(self.service, "/setup/models/multiphase/phases/set_domain_properties/interaction_domain/interfacial_area/lift/sfc_model_type").execute(*args, **kwargs)
                                    def visc_disp_factor(self, *args, **kwargs):
                                        """
                                        Set the dissipation intensity.
                                        """
                                        return PyMenu(self.service, "/setup/models/multiphase/phases/set_domain_properties/interaction_domain/interfacial_area/lift/visc_disp_factor").execute(*args, **kwargs)

                            class heat_mass_reactions(TUIMenu):
                                """
                                Enter the menu to set heat, mass-transfer, or reaction related models.
                                """
                                def __init__(self, path, service):
                                    self.path = path
                                    self.service = service
                                    self.virtual_mass = self.__class__.virtual_mass(path + ["virtual_mass"], service)
                                    self.cavitation = self.__class__.cavitation(path + ["cavitation"], service)
                                    self.interphase_discretization = self.__class__.interphase_discretization(path + ["interphase_discretization"], service)
                                    self.lift = self.__class__.lift(path + ["lift"], service)
                                    self.surface_tension = self.__class__.surface_tension(path + ["surface_tension"], service)
                                    self.interphase_viscous_dissipation = self.__class__.interphase_viscous_dissipation(path + ["interphase_viscous_dissipation"], service)
                                    super().__init__(path, service)
                                def slip_velocity(self, *args, **kwargs):
                                    """
                                    Specify the slip velocity function for each secondary phase with respect to the primary phase.
                                    """
                                    return PyMenu(self.service, "/setup/models/multiphase/phases/set_domain_properties/interaction_domain/heat_mass_reactions/slip_velocity").execute(*args, **kwargs)
                                def interfacial_area(self, *args, **kwargs):
                                    """
                                    Set the interfacial area parameters for each pair of phases.
                                    """
                                    return PyMenu(self.service, "/setup/models/multiphase/phases/set_domain_properties/interaction_domain/heat_mass_reactions/interfacial_area").execute(*args, **kwargs)
                                def turbulence_interaction(self, *args, **kwargs):
                                    """
                                    Specify the turbulence interaction model for each primary-secondary phase pair.
                                    """
                                    return PyMenu(self.service, "/setup/models/multiphase/phases/set_domain_properties/interaction_domain/heat_mass_reactions/turbulence_interaction").execute(*args, **kwargs)
                                def heat_coeff(self, *args, **kwargs):
                                    """
                                    Specify the heat transfer coefficient function between each pair of phases.
                                    """
                                    return PyMenu(self.service, "/setup/models/multiphase/phases/set_domain_properties/interaction_domain/heat_mass_reactions/heat_coeff").execute(*args, **kwargs)
                                def wall_lubrication(self, *args, **kwargs):
                                    """
                                    Specify the wall lubrication model for each primary-secondary phase pair.
                                    """
                                    return PyMenu(self.service, "/setup/models/multiphase/phases/set_domain_properties/interaction_domain/heat_mass_reactions/wall_lubrication").execute(*args, **kwargs)
                                def mass_transfer(self, *args, **kwargs):
                                    """
                                    Specify the mass transfer mechanisms.
                                    """
                                    return PyMenu(self.service, "/setup/models/multiphase/phases/set_domain_properties/interaction_domain/heat_mass_reactions/mass_transfer").execute(*args, **kwargs)
                                def drag(self, *args, **kwargs):
                                    """
                                    Specify the drag function for each pair of phases. It also enables drag modification and allow specifying the drag factor.
                                    """
                                    return PyMenu(self.service, "/setup/models/multiphase/phases/set_domain_properties/interaction_domain/heat_mass_reactions/drag").execute(*args, **kwargs)
                                def reactions(self, *args, **kwargs):
                                    """
                                    Define multiple heterogeneous reactions and stoichiometry.
                                    """
                                    return PyMenu(self.service, "/setup/models/multiphase/phases/set_domain_properties/interaction_domain/heat_mass_reactions/reactions").execute(*args, **kwargs)
                                def restitution(self, *args, **kwargs):
                                    """
                                    Specify the restitution coefficient for collisions between each pair of granular phases and for collisions between particles of the same granular phase.
                                    """
                                    return PyMenu(self.service, "/setup/models/multiphase/phases/set_domain_properties/interaction_domain/heat_mass_reactions/restitution").execute(*args, **kwargs)
                                def turbulent_dispersion(self, *args, **kwargs):
                                    """
                                    Specify the turbulent dispersion model for each primary-secondary phase pair.
                                    """
                                    return PyMenu(self.service, "/setup/models/multiphase/phases/set_domain_properties/interaction_domain/heat_mass_reactions/turbulent_dispersion").execute(*args, **kwargs)
                                def model_transition(self, *args, **kwargs):
                                    """
                                    Set the model transition mechanism.
                                    """
                                    return PyMenu(self.service, "/setup/models/multiphase/phases/set_domain_properties/interaction_domain/heat_mass_reactions/model_transition").execute(*args, **kwargs)

                                class virtual_mass(TUIMenu):
                                    """
                                    Enter the menu to set virtual mass models.
                                    """
                                    def __init__(self, path, service):
                                        self.path = path
                                        self.service = service
                                        super().__init__(path, service)
                                    def sfc_tension_coeff(self, *args, **kwargs):
                                        """
                                        Specify the surface tension coefficient for each pair of phases.
                                        """
                                        return PyMenu(self.service, "/setup/models/multiphase/phases/set_domain_properties/interaction_domain/heat_mass_reactions/virtual_mass/sfc_tension_coeff").execute(*args, **kwargs)
                                    def vmass_coeff(self, *args, **kwargs):
                                        """
                                        Specify the virtual mass coefficient for each pair of phases.
                                        """
                                        return PyMenu(self.service, "/setup/models/multiphase/phases/set_domain_properties/interaction_domain/heat_mass_reactions/virtual_mass/vmass_coeff").execute(*args, **kwargs)
                                    def lift_shaver_podowski(self, *args, **kwargs):
                                        """
                                        Include the Shaver-Podowski correction for Lift.
                                        """
                                        return PyMenu(self.service, "/setup/models/multiphase/phases/set_domain_properties/interaction_domain/heat_mass_reactions/virtual_mass/lift_shaver_podowski").execute(*args, **kwargs)
                                    def vmass_implicit(self, *args, **kwargs):
                                        """
                                        Enable the implicit method for the virtual mass force?.
                                        """
                                        return PyMenu(self.service, "/setup/models/multiphase/phases/set_domain_properties/interaction_domain/heat_mass_reactions/virtual_mass/vmass_implicit").execute(*args, **kwargs)
                                    def lift_montoya(self, *args, **kwargs):
                                        """
                                        Include the Montoya correction for Lift.
                                        """
                                        return PyMenu(self.service, "/setup/models/multiphase/phases/set_domain_properties/interaction_domain/heat_mass_reactions/virtual_mass/lift_montoya").execute(*args, **kwargs)
                                    def virtual_mass(self, *args, **kwargs):
                                        """
                                        Include the virtual mass force that is present when a secondary phase accelerates relative to the primary phase?.
                                        """
                                        return PyMenu(self.service, "/setup/models/multiphase/phases/set_domain_properties/interaction_domain/heat_mass_reactions/virtual_mass/virtual_mass").execute(*args, **kwargs)
                                    def slope_limiter(self, *args, **kwargs):
                                        """
                                        Specify the slope limiter to set a specific discretization scheme. 0: first order upwind, 1: second order reconstruction bounded by the global minimum/maximum of the volume fraction, 2: compressive. Value between 0 and 2: blended scheme.
                                        """
                                        return PyMenu(self.service, "/setup/models/multiphase/phases/set_domain_properties/interaction_domain/heat_mass_reactions/virtual_mass/slope_limiter").execute(*args, **kwargs)
                                    def lift(self, *args, **kwargs):
                                        """
                                        .
                                        """
                                        return PyMenu(self.service, "/setup/models/multiphase/phases/set_domain_properties/interaction_domain/heat_mass_reactions/virtual_mass/lift").execute(*args, **kwargs)
                                    def interphase_visc_disp(self, *args, **kwargs):
                                        """
                                        Enable the interfacial viscous dissipation method, which introduces an artificial viscous damping term in the momentum equation?.
                                        """
                                        return PyMenu(self.service, "/setup/models/multiphase/phases/set_domain_properties/interaction_domain/heat_mass_reactions/virtual_mass/interphase_visc_disp").execute(*args, **kwargs)
                                    def wall_adhesion(self, *args, **kwargs):
                                        """
                                        Enable the specification for a wall adhesion angle?.
                                        """
                                        return PyMenu(self.service, "/setup/models/multiphase/phases/set_domain_properties/interaction_domain/heat_mass_reactions/virtual_mass/wall_adhesion").execute(*args, **kwargs)
                                    def cavitation(self, *args, **kwargs):
                                        """
                                        Set the vaporization pressure, the surface tension coefficient, and the non-condensable gas mass fraction.
                                        """
                                        return PyMenu(self.service, "/setup/models/multiphase/phases/set_domain_properties/interaction_domain/heat_mass_reactions/virtual_mass/cavitation").execute(*args, **kwargs)
                                    def jump_adhesion(self, *args, **kwargs):
                                        """
                                        Enable the treatment of the contact angle specification at the porous jump boundary?.
                                        """
                                        return PyMenu(self.service, "/setup/models/multiphase/phases/set_domain_properties/interaction_domain/heat_mass_reactions/virtual_mass/jump_adhesion").execute(*args, **kwargs)
                                    def visc_disp_factor(self, *args, **kwargs):
                                        """
                                        Set the dissipation intensity.
                                        """
                                        return PyMenu(self.service, "/setup/models/multiphase/phases/set_domain_properties/interaction_domain/heat_mass_reactions/virtual_mass/visc_disp_factor").execute(*args, **kwargs)
                                    def interphase_discr(self, *args, **kwargs):
                                        """
                                        Enable the phase localized compressive discretization scheme where the degree of diffusion/sharpness is controlled through the value of the slope limiters?.
                                        """
                                        return PyMenu(self.service, "/setup/models/multiphase/phases/set_domain_properties/interaction_domain/heat_mass_reactions/virtual_mass/interphase_discr").execute(*args, **kwargs)
                                    def sfc_modeling(self, *args, **kwargs):
                                        """
                                        Include the effects of surface tension along the fluid-fluid interface?.
                                        """
                                        return PyMenu(self.service, "/setup/models/multiphase/phases/set_domain_properties/interaction_domain/heat_mass_reactions/virtual_mass/sfc_modeling").execute(*args, **kwargs)
                                    def sfc_model_type(self, *args, **kwargs):
                                        """
                                        Select the surface tension model.
                                        """
                                        return PyMenu(self.service, "/setup/models/multiphase/phases/set_domain_properties/interaction_domain/heat_mass_reactions/virtual_mass/sfc_model_type").execute(*args, **kwargs)
                                    def vmass_implicit_options(self, *args, **kwargs):
                                        """
                                        Select the virtual mass implicit option.
                                        """
                                        return PyMenu(self.service, "/setup/models/multiphase/phases/set_domain_properties/interaction_domain/heat_mass_reactions/virtual_mass/vmass_implicit_options").execute(*args, **kwargs)

                                class cavitation(TUIMenu):
                                    """
                                    Enter the menu to set cavitation models.
                                    """
                                    def __init__(self, path, service):
                                        self.path = path
                                        self.service = service
                                        super().__init__(path, service)
                                    def lift_shaver_podowski(self, *args, **kwargs):
                                        """
                                        Include the Shaver-Podowski correction for Lift.
                                        """
                                        return PyMenu(self.service, "/setup/models/multiphase/phases/set_domain_properties/interaction_domain/heat_mass_reactions/cavitation/lift_shaver_podowski").execute(*args, **kwargs)
                                    def vmass_implicit_options(self, *args, **kwargs):
                                        """
                                        Select the virtual mass implicit option.
                                        """
                                        return PyMenu(self.service, "/setup/models/multiphase/phases/set_domain_properties/interaction_domain/heat_mass_reactions/cavitation/vmass_implicit_options").execute(*args, **kwargs)
                                    def lift(self, *args, **kwargs):
                                        """
                                        .
                                        """
                                        return PyMenu(self.service, "/setup/models/multiphase/phases/set_domain_properties/interaction_domain/heat_mass_reactions/cavitation/lift").execute(*args, **kwargs)
                                    def sfc_tension_coeff(self, *args, **kwargs):
                                        """
                                        Specify the surface tension coefficient for each pair of phases.
                                        """
                                        return PyMenu(self.service, "/setup/models/multiphase/phases/set_domain_properties/interaction_domain/heat_mass_reactions/cavitation/sfc_tension_coeff").execute(*args, **kwargs)
                                    def visc_disp_factor(self, *args, **kwargs):
                                        """
                                        Set the dissipation intensity.
                                        """
                                        return PyMenu(self.service, "/setup/models/multiphase/phases/set_domain_properties/interaction_domain/heat_mass_reactions/cavitation/visc_disp_factor").execute(*args, **kwargs)
                                    def wall_adhesion(self, *args, **kwargs):
                                        """
                                        Enable the specification for a wall adhesion angle?.
                                        """
                                        return PyMenu(self.service, "/setup/models/multiphase/phases/set_domain_properties/interaction_domain/heat_mass_reactions/cavitation/wall_adhesion").execute(*args, **kwargs)
                                    def sfc_model_type(self, *args, **kwargs):
                                        """
                                        Select the surface tension model.
                                        """
                                        return PyMenu(self.service, "/setup/models/multiphase/phases/set_domain_properties/interaction_domain/heat_mass_reactions/cavitation/sfc_model_type").execute(*args, **kwargs)
                                    def jump_adhesion(self, *args, **kwargs):
                                        """
                                        Enable the treatment of the contact angle specification at the porous jump boundary?.
                                        """
                                        return PyMenu(self.service, "/setup/models/multiphase/phases/set_domain_properties/interaction_domain/heat_mass_reactions/cavitation/jump_adhesion").execute(*args, **kwargs)
                                    def cavitation(self, *args, **kwargs):
                                        """
                                        Set the vaporization pressure, the surface tension coefficient, and the non-condensable gas mass fraction.
                                        """
                                        return PyMenu(self.service, "/setup/models/multiphase/phases/set_domain_properties/interaction_domain/heat_mass_reactions/cavitation/cavitation").execute(*args, **kwargs)
                                    def vmass_implicit(self, *args, **kwargs):
                                        """
                                        Enable the implicit method for the virtual mass force?.
                                        """
                                        return PyMenu(self.service, "/setup/models/multiphase/phases/set_domain_properties/interaction_domain/heat_mass_reactions/cavitation/vmass_implicit").execute(*args, **kwargs)
                                    def sfc_modeling(self, *args, **kwargs):
                                        """
                                        Include the effects of surface tension along the fluid-fluid interface?.
                                        """
                                        return PyMenu(self.service, "/setup/models/multiphase/phases/set_domain_properties/interaction_domain/heat_mass_reactions/cavitation/sfc_modeling").execute(*args, **kwargs)
                                    def lift_montoya(self, *args, **kwargs):
                                        """
                                        Include the Montoya correction for Lift.
                                        """
                                        return PyMenu(self.service, "/setup/models/multiphase/phases/set_domain_properties/interaction_domain/heat_mass_reactions/cavitation/lift_montoya").execute(*args, **kwargs)
                                    def vmass_coeff(self, *args, **kwargs):
                                        """
                                        Specify the virtual mass coefficient for each pair of phases.
                                        """
                                        return PyMenu(self.service, "/setup/models/multiphase/phases/set_domain_properties/interaction_domain/heat_mass_reactions/cavitation/vmass_coeff").execute(*args, **kwargs)
                                    def slope_limiter(self, *args, **kwargs):
                                        """
                                        Specify the slope limiter to set a specific discretization scheme. 0: first order upwind, 1: second order reconstruction bounded by the global minimum/maximum of the volume fraction, 2: compressive. Value between 0 and 2: blended scheme.
                                        """
                                        return PyMenu(self.service, "/setup/models/multiphase/phases/set_domain_properties/interaction_domain/heat_mass_reactions/cavitation/slope_limiter").execute(*args, **kwargs)
                                    def interphase_visc_disp(self, *args, **kwargs):
                                        """
                                        Enable the interfacial viscous dissipation method, which introduces an artificial viscous damping term in the momentum equation?.
                                        """
                                        return PyMenu(self.service, "/setup/models/multiphase/phases/set_domain_properties/interaction_domain/heat_mass_reactions/cavitation/interphase_visc_disp").execute(*args, **kwargs)
                                    def virtual_mass(self, *args, **kwargs):
                                        """
                                        Include the virtual mass force that is present when a secondary phase accelerates relative to the primary phase?.
                                        """
                                        return PyMenu(self.service, "/setup/models/multiphase/phases/set_domain_properties/interaction_domain/heat_mass_reactions/cavitation/virtual_mass").execute(*args, **kwargs)
                                    def interphase_discr(self, *args, **kwargs):
                                        """
                                        Enable the phase localized compressive discretization scheme where the degree of diffusion/sharpness is controlled through the value of the slope limiters?.
                                        """
                                        return PyMenu(self.service, "/setup/models/multiphase/phases/set_domain_properties/interaction_domain/heat_mass_reactions/cavitation/interphase_discr").execute(*args, **kwargs)

                                class interphase_discretization(TUIMenu):
                                    """
                                    Enter the menu to set interphase discretization models.
                                    """
                                    def __init__(self, path, service):
                                        self.path = path
                                        self.service = service
                                        super().__init__(path, service)
                                    def slope_limiter(self, *args, **kwargs):
                                        """
                                        Specify the slope limiter to set a specific discretization scheme. 0: first order upwind, 1: second order reconstruction bounded by the global minimum/maximum of the volume fraction, 2: compressive. Value between 0 and 2: blended scheme.
                                        """
                                        return PyMenu(self.service, "/setup/models/multiphase/phases/set_domain_properties/interaction_domain/heat_mass_reactions/interphase_discretization/slope_limiter").execute(*args, **kwargs)
                                    def vmass_implicit_options(self, *args, **kwargs):
                                        """
                                        Select the virtual mass implicit option.
                                        """
                                        return PyMenu(self.service, "/setup/models/multiphase/phases/set_domain_properties/interaction_domain/heat_mass_reactions/interphase_discretization/vmass_implicit_options").execute(*args, **kwargs)
                                    def lift(self, *args, **kwargs):
                                        """
                                        .
                                        """
                                        return PyMenu(self.service, "/setup/models/multiphase/phases/set_domain_properties/interaction_domain/heat_mass_reactions/interphase_discretization/lift").execute(*args, **kwargs)
                                    def interphase_visc_disp(self, *args, **kwargs):
                                        """
                                        Enable the interfacial viscous dissipation method, which introduces an artificial viscous damping term in the momentum equation?.
                                        """
                                        return PyMenu(self.service, "/setup/models/multiphase/phases/set_domain_properties/interaction_domain/heat_mass_reactions/interphase_discretization/interphase_visc_disp").execute(*args, **kwargs)
                                    def lift_shaver_podowski(self, *args, **kwargs):
                                        """
                                        Include the Shaver-Podowski correction for Lift.
                                        """
                                        return PyMenu(self.service, "/setup/models/multiphase/phases/set_domain_properties/interaction_domain/heat_mass_reactions/interphase_discretization/lift_shaver_podowski").execute(*args, **kwargs)
                                    def sfc_modeling(self, *args, **kwargs):
                                        """
                                        Include the effects of surface tension along the fluid-fluid interface?.
                                        """
                                        return PyMenu(self.service, "/setup/models/multiphase/phases/set_domain_properties/interaction_domain/heat_mass_reactions/interphase_discretization/sfc_modeling").execute(*args, **kwargs)
                                    def visc_disp_factor(self, *args, **kwargs):
                                        """
                                        Set the dissipation intensity.
                                        """
                                        return PyMenu(self.service, "/setup/models/multiphase/phases/set_domain_properties/interaction_domain/heat_mass_reactions/interphase_discretization/visc_disp_factor").execute(*args, **kwargs)
                                    def virtual_mass(self, *args, **kwargs):
                                        """
                                        Include the virtual mass force that is present when a secondary phase accelerates relative to the primary phase?.
                                        """
                                        return PyMenu(self.service, "/setup/models/multiphase/phases/set_domain_properties/interaction_domain/heat_mass_reactions/interphase_discretization/virtual_mass").execute(*args, **kwargs)
                                    def wall_adhesion(self, *args, **kwargs):
                                        """
                                        Enable the specification for a wall adhesion angle?.
                                        """
                                        return PyMenu(self.service, "/setup/models/multiphase/phases/set_domain_properties/interaction_domain/heat_mass_reactions/interphase_discretization/wall_adhesion").execute(*args, **kwargs)
                                    def sfc_tension_coeff(self, *args, **kwargs):
                                        """
                                        Specify the surface tension coefficient for each pair of phases.
                                        """
                                        return PyMenu(self.service, "/setup/models/multiphase/phases/set_domain_properties/interaction_domain/heat_mass_reactions/interphase_discretization/sfc_tension_coeff").execute(*args, **kwargs)
                                    def sfc_model_type(self, *args, **kwargs):
                                        """
                                        Select the surface tension model.
                                        """
                                        return PyMenu(self.service, "/setup/models/multiphase/phases/set_domain_properties/interaction_domain/heat_mass_reactions/interphase_discretization/sfc_model_type").execute(*args, **kwargs)
                                    def vmass_implicit(self, *args, **kwargs):
                                        """
                                        Enable the implicit method for the virtual mass force?.
                                        """
                                        return PyMenu(self.service, "/setup/models/multiphase/phases/set_domain_properties/interaction_domain/heat_mass_reactions/interphase_discretization/vmass_implicit").execute(*args, **kwargs)
                                    def vmass_coeff(self, *args, **kwargs):
                                        """
                                        Specify the virtual mass coefficient for each pair of phases.
                                        """
                                        return PyMenu(self.service, "/setup/models/multiphase/phases/set_domain_properties/interaction_domain/heat_mass_reactions/interphase_discretization/vmass_coeff").execute(*args, **kwargs)
                                    def lift_montoya(self, *args, **kwargs):
                                        """
                                        Include the Montoya correction for Lift.
                                        """
                                        return PyMenu(self.service, "/setup/models/multiphase/phases/set_domain_properties/interaction_domain/heat_mass_reactions/interphase_discretization/lift_montoya").execute(*args, **kwargs)
                                    def interphase_discr(self, *args, **kwargs):
                                        """
                                        Enable the phase localized compressive discretization scheme where the degree of diffusion/sharpness is controlled through the value of the slope limiters?.
                                        """
                                        return PyMenu(self.service, "/setup/models/multiphase/phases/set_domain_properties/interaction_domain/heat_mass_reactions/interphase_discretization/interphase_discr").execute(*args, **kwargs)
                                    def jump_adhesion(self, *args, **kwargs):
                                        """
                                        Enable the treatment of the contact angle specification at the porous jump boundary?.
                                        """
                                        return PyMenu(self.service, "/setup/models/multiphase/phases/set_domain_properties/interaction_domain/heat_mass_reactions/interphase_discretization/jump_adhesion").execute(*args, **kwargs)
                                    def cavitation(self, *args, **kwargs):
                                        """
                                        Set the vaporization pressure, the surface tension coefficient, and the non-condensable gas mass fraction.
                                        """
                                        return PyMenu(self.service, "/setup/models/multiphase/phases/set_domain_properties/interaction_domain/heat_mass_reactions/interphase_discretization/cavitation").execute(*args, **kwargs)

                                class lift(TUIMenu):
                                    """
                                    Enter the menu to set lift models.
                                    """
                                    def __init__(self, path, service):
                                        self.path = path
                                        self.service = service
                                        super().__init__(path, service)
                                    def virtual_mass(self, *args, **kwargs):
                                        """
                                        Include the virtual mass force that is present when a secondary phase accelerates relative to the primary phase?.
                                        """
                                        return PyMenu(self.service, "/setup/models/multiphase/phases/set_domain_properties/interaction_domain/heat_mass_reactions/lift/virtual_mass").execute(*args, **kwargs)
                                    def interphase_visc_disp(self, *args, **kwargs):
                                        """
                                        Enable the interfacial viscous dissipation method, which introduces an artificial viscous damping term in the momentum equation?.
                                        """
                                        return PyMenu(self.service, "/setup/models/multiphase/phases/set_domain_properties/interaction_domain/heat_mass_reactions/lift/interphase_visc_disp").execute(*args, **kwargs)
                                    def sfc_modeling(self, *args, **kwargs):
                                        """
                                        Include the effects of surface tension along the fluid-fluid interface?.
                                        """
                                        return PyMenu(self.service, "/setup/models/multiphase/phases/set_domain_properties/interaction_domain/heat_mass_reactions/lift/sfc_modeling").execute(*args, **kwargs)
                                    def wall_adhesion(self, *args, **kwargs):
                                        """
                                        Enable the specification for a wall adhesion angle?.
                                        """
                                        return PyMenu(self.service, "/setup/models/multiphase/phases/set_domain_properties/interaction_domain/heat_mass_reactions/lift/wall_adhesion").execute(*args, **kwargs)
                                    def interphase_discr(self, *args, **kwargs):
                                        """
                                        Enable the phase localized compressive discretization scheme where the degree of diffusion/sharpness is controlled through the value of the slope limiters?.
                                        """
                                        return PyMenu(self.service, "/setup/models/multiphase/phases/set_domain_properties/interaction_domain/heat_mass_reactions/lift/interphase_discr").execute(*args, **kwargs)
                                    def vmass_implicit_options(self, *args, **kwargs):
                                        """
                                        Select the virtual mass implicit option.
                                        """
                                        return PyMenu(self.service, "/setup/models/multiphase/phases/set_domain_properties/interaction_domain/heat_mass_reactions/lift/vmass_implicit_options").execute(*args, **kwargs)
                                    def sfc_tension_coeff(self, *args, **kwargs):
                                        """
                                        Specify the surface tension coefficient for each pair of phases.
                                        """
                                        return PyMenu(self.service, "/setup/models/multiphase/phases/set_domain_properties/interaction_domain/heat_mass_reactions/lift/sfc_tension_coeff").execute(*args, **kwargs)
                                    def lift(self, *args, **kwargs):
                                        """
                                        .
                                        """
                                        return PyMenu(self.service, "/setup/models/multiphase/phases/set_domain_properties/interaction_domain/heat_mass_reactions/lift/lift").execute(*args, **kwargs)
                                    def vmass_coeff(self, *args, **kwargs):
                                        """
                                        Specify the virtual mass coefficient for each pair of phases.
                                        """
                                        return PyMenu(self.service, "/setup/models/multiphase/phases/set_domain_properties/interaction_domain/heat_mass_reactions/lift/vmass_coeff").execute(*args, **kwargs)
                                    def lift_shaver_podowski(self, *args, **kwargs):
                                        """
                                        Include the Shaver-Podowski correction for Lift.
                                        """
                                        return PyMenu(self.service, "/setup/models/multiphase/phases/set_domain_properties/interaction_domain/heat_mass_reactions/lift/lift_shaver_podowski").execute(*args, **kwargs)
                                    def cavitation(self, *args, **kwargs):
                                        """
                                        Set the vaporization pressure, the surface tension coefficient, and the non-condensable gas mass fraction.
                                        """
                                        return PyMenu(self.service, "/setup/models/multiphase/phases/set_domain_properties/interaction_domain/heat_mass_reactions/lift/cavitation").execute(*args, **kwargs)
                                    def jump_adhesion(self, *args, **kwargs):
                                        """
                                        Enable the treatment of the contact angle specification at the porous jump boundary?.
                                        """
                                        return PyMenu(self.service, "/setup/models/multiphase/phases/set_domain_properties/interaction_domain/heat_mass_reactions/lift/jump_adhesion").execute(*args, **kwargs)
                                    def lift_montoya(self, *args, **kwargs):
                                        """
                                        Include the Montoya correction for Lift.
                                        """
                                        return PyMenu(self.service, "/setup/models/multiphase/phases/set_domain_properties/interaction_domain/heat_mass_reactions/lift/lift_montoya").execute(*args, **kwargs)
                                    def slope_limiter(self, *args, **kwargs):
                                        """
                                        Specify the slope limiter to set a specific discretization scheme. 0: first order upwind, 1: second order reconstruction bounded by the global minimum/maximum of the volume fraction, 2: compressive. Value between 0 and 2: blended scheme.
                                        """
                                        return PyMenu(self.service, "/setup/models/multiphase/phases/set_domain_properties/interaction_domain/heat_mass_reactions/lift/slope_limiter").execute(*args, **kwargs)
                                    def visc_disp_factor(self, *args, **kwargs):
                                        """
                                        Set the dissipation intensity.
                                        """
                                        return PyMenu(self.service, "/setup/models/multiphase/phases/set_domain_properties/interaction_domain/heat_mass_reactions/lift/visc_disp_factor").execute(*args, **kwargs)
                                    def vmass_implicit(self, *args, **kwargs):
                                        """
                                        Enable the implicit method for the virtual mass force?.
                                        """
                                        return PyMenu(self.service, "/setup/models/multiphase/phases/set_domain_properties/interaction_domain/heat_mass_reactions/lift/vmass_implicit").execute(*args, **kwargs)
                                    def sfc_model_type(self, *args, **kwargs):
                                        """
                                        Select the surface tension model.
                                        """
                                        return PyMenu(self.service, "/setup/models/multiphase/phases/set_domain_properties/interaction_domain/heat_mass_reactions/lift/sfc_model_type").execute(*args, **kwargs)

                                class surface_tension(TUIMenu):
                                    """
                                    Enter the menu to set surface tension models.
                                    """
                                    def __init__(self, path, service):
                                        self.path = path
                                        self.service = service
                                        super().__init__(path, service)
                                    def lift_shaver_podowski(self, *args, **kwargs):
                                        """
                                        Include the Shaver-Podowski correction for Lift.
                                        """
                                        return PyMenu(self.service, "/setup/models/multiphase/phases/set_domain_properties/interaction_domain/heat_mass_reactions/surface_tension/lift_shaver_podowski").execute(*args, **kwargs)
                                    def interphase_visc_disp(self, *args, **kwargs):
                                        """
                                        Enable the interfacial viscous dissipation method, which introduces an artificial viscous damping term in the momentum equation?.
                                        """
                                        return PyMenu(self.service, "/setup/models/multiphase/phases/set_domain_properties/interaction_domain/heat_mass_reactions/surface_tension/interphase_visc_disp").execute(*args, **kwargs)
                                    def interphase_discr(self, *args, **kwargs):
                                        """
                                        Enable the phase localized compressive discretization scheme where the degree of diffusion/sharpness is controlled through the value of the slope limiters?.
                                        """
                                        return PyMenu(self.service, "/setup/models/multiphase/phases/set_domain_properties/interaction_domain/heat_mass_reactions/surface_tension/interphase_discr").execute(*args, **kwargs)
                                    def vmass_implicit_options(self, *args, **kwargs):
                                        """
                                        Select the virtual mass implicit option.
                                        """
                                        return PyMenu(self.service, "/setup/models/multiphase/phases/set_domain_properties/interaction_domain/heat_mass_reactions/surface_tension/vmass_implicit_options").execute(*args, **kwargs)
                                    def sfc_model_type(self, *args, **kwargs):
                                        """
                                        Select the surface tension model.
                                        """
                                        return PyMenu(self.service, "/setup/models/multiphase/phases/set_domain_properties/interaction_domain/heat_mass_reactions/surface_tension/sfc_model_type").execute(*args, **kwargs)
                                    def sfc_tension_coeff(self, *args, **kwargs):
                                        """
                                        Specify the surface tension coefficient for each pair of phases.
                                        """
                                        return PyMenu(self.service, "/setup/models/multiphase/phases/set_domain_properties/interaction_domain/heat_mass_reactions/surface_tension/sfc_tension_coeff").execute(*args, **kwargs)
                                    def lift_montoya(self, *args, **kwargs):
                                        """
                                        Include the Montoya correction for Lift.
                                        """
                                        return PyMenu(self.service, "/setup/models/multiphase/phases/set_domain_properties/interaction_domain/heat_mass_reactions/surface_tension/lift_montoya").execute(*args, **kwargs)
                                    def vmass_implicit(self, *args, **kwargs):
                                        """
                                        Enable the implicit method for the virtual mass force?.
                                        """
                                        return PyMenu(self.service, "/setup/models/multiphase/phases/set_domain_properties/interaction_domain/heat_mass_reactions/surface_tension/vmass_implicit").execute(*args, **kwargs)
                                    def visc_disp_factor(self, *args, **kwargs):
                                        """
                                        Set the dissipation intensity.
                                        """
                                        return PyMenu(self.service, "/setup/models/multiphase/phases/set_domain_properties/interaction_domain/heat_mass_reactions/surface_tension/visc_disp_factor").execute(*args, **kwargs)
                                    def vmass_coeff(self, *args, **kwargs):
                                        """
                                        Specify the virtual mass coefficient for each pair of phases.
                                        """
                                        return PyMenu(self.service, "/setup/models/multiphase/phases/set_domain_properties/interaction_domain/heat_mass_reactions/surface_tension/vmass_coeff").execute(*args, **kwargs)
                                    def sfc_modeling(self, *args, **kwargs):
                                        """
                                        Include the effects of surface tension along the fluid-fluid interface?.
                                        """
                                        return PyMenu(self.service, "/setup/models/multiphase/phases/set_domain_properties/interaction_domain/heat_mass_reactions/surface_tension/sfc_modeling").execute(*args, **kwargs)
                                    def cavitation(self, *args, **kwargs):
                                        """
                                        Set the vaporization pressure, the surface tension coefficient, and the non-condensable gas mass fraction.
                                        """
                                        return PyMenu(self.service, "/setup/models/multiphase/phases/set_domain_properties/interaction_domain/heat_mass_reactions/surface_tension/cavitation").execute(*args, **kwargs)
                                    def virtual_mass(self, *args, **kwargs):
                                        """
                                        Include the virtual mass force that is present when a secondary phase accelerates relative to the primary phase?.
                                        """
                                        return PyMenu(self.service, "/setup/models/multiphase/phases/set_domain_properties/interaction_domain/heat_mass_reactions/surface_tension/virtual_mass").execute(*args, **kwargs)
                                    def jump_adhesion(self, *args, **kwargs):
                                        """
                                        Enable the treatment of the contact angle specification at the porous jump boundary?.
                                        """
                                        return PyMenu(self.service, "/setup/models/multiphase/phases/set_domain_properties/interaction_domain/heat_mass_reactions/surface_tension/jump_adhesion").execute(*args, **kwargs)
                                    def wall_adhesion(self, *args, **kwargs):
                                        """
                                        Enable the specification for a wall adhesion angle?.
                                        """
                                        return PyMenu(self.service, "/setup/models/multiphase/phases/set_domain_properties/interaction_domain/heat_mass_reactions/surface_tension/wall_adhesion").execute(*args, **kwargs)
                                    def lift(self, *args, **kwargs):
                                        """
                                        .
                                        """
                                        return PyMenu(self.service, "/setup/models/multiphase/phases/set_domain_properties/interaction_domain/heat_mass_reactions/surface_tension/lift").execute(*args, **kwargs)
                                    def slope_limiter(self, *args, **kwargs):
                                        """
                                        Specify the slope limiter to set a specific discretization scheme. 0: first order upwind, 1: second order reconstruction bounded by the global minimum/maximum of the volume fraction, 2: compressive. Value between 0 and 2: blended scheme.
                                        """
                                        return PyMenu(self.service, "/setup/models/multiphase/phases/set_domain_properties/interaction_domain/heat_mass_reactions/surface_tension/slope_limiter").execute(*args, **kwargs)

                                class interphase_viscous_dissipation(TUIMenu):
                                    """
                                    Enter the menu to set interphase viscous dissipation related models.
                                    """
                                    def __init__(self, path, service):
                                        self.path = path
                                        self.service = service
                                        super().__init__(path, service)
                                    def lift_montoya(self, *args, **kwargs):
                                        """
                                        Include the Montoya correction for Lift.
                                        """
                                        return PyMenu(self.service, "/setup/models/multiphase/phases/set_domain_properties/interaction_domain/heat_mass_reactions/interphase_viscous_dissipation/lift_montoya").execute(*args, **kwargs)
                                    def interphase_visc_disp(self, *args, **kwargs):
                                        """
                                        Enable the interfacial viscous dissipation method, which introduces an artificial viscous damping term in the momentum equation?.
                                        """
                                        return PyMenu(self.service, "/setup/models/multiphase/phases/set_domain_properties/interaction_domain/heat_mass_reactions/interphase_viscous_dissipation/interphase_visc_disp").execute(*args, **kwargs)
                                    def visc_disp_factor(self, *args, **kwargs):
                                        """
                                        Set the dissipation intensity.
                                        """
                                        return PyMenu(self.service, "/setup/models/multiphase/phases/set_domain_properties/interaction_domain/heat_mass_reactions/interphase_viscous_dissipation/visc_disp_factor").execute(*args, **kwargs)
                                    def sfc_model_type(self, *args, **kwargs):
                                        """
                                        Select the surface tension model.
                                        """
                                        return PyMenu(self.service, "/setup/models/multiphase/phases/set_domain_properties/interaction_domain/heat_mass_reactions/interphase_viscous_dissipation/sfc_model_type").execute(*args, **kwargs)
                                    def interphase_discr(self, *args, **kwargs):
                                        """
                                        Enable the phase localized compressive discretization scheme where the degree of diffusion/sharpness is controlled through the value of the slope limiters?.
                                        """
                                        return PyMenu(self.service, "/setup/models/multiphase/phases/set_domain_properties/interaction_domain/heat_mass_reactions/interphase_viscous_dissipation/interphase_discr").execute(*args, **kwargs)
                                    def virtual_mass(self, *args, **kwargs):
                                        """
                                        Include the virtual mass force that is present when a secondary phase accelerates relative to the primary phase?.
                                        """
                                        return PyMenu(self.service, "/setup/models/multiphase/phases/set_domain_properties/interaction_domain/heat_mass_reactions/interphase_viscous_dissipation/virtual_mass").execute(*args, **kwargs)
                                    def lift(self, *args, **kwargs):
                                        """
                                        .
                                        """
                                        return PyMenu(self.service, "/setup/models/multiphase/phases/set_domain_properties/interaction_domain/heat_mass_reactions/interphase_viscous_dissipation/lift").execute(*args, **kwargs)
                                    def sfc_modeling(self, *args, **kwargs):
                                        """
                                        Include the effects of surface tension along the fluid-fluid interface?.
                                        """
                                        return PyMenu(self.service, "/setup/models/multiphase/phases/set_domain_properties/interaction_domain/heat_mass_reactions/interphase_viscous_dissipation/sfc_modeling").execute(*args, **kwargs)
                                    def sfc_tension_coeff(self, *args, **kwargs):
                                        """
                                        Specify the surface tension coefficient for each pair of phases.
                                        """
                                        return PyMenu(self.service, "/setup/models/multiphase/phases/set_domain_properties/interaction_domain/heat_mass_reactions/interphase_viscous_dissipation/sfc_tension_coeff").execute(*args, **kwargs)
                                    def lift_shaver_podowski(self, *args, **kwargs):
                                        """
                                        Include the Shaver-Podowski correction for Lift.
                                        """
                                        return PyMenu(self.service, "/setup/models/multiphase/phases/set_domain_properties/interaction_domain/heat_mass_reactions/interphase_viscous_dissipation/lift_shaver_podowski").execute(*args, **kwargs)
                                    def jump_adhesion(self, *args, **kwargs):
                                        """
                                        Enable the treatment of the contact angle specification at the porous jump boundary?.
                                        """
                                        return PyMenu(self.service, "/setup/models/multiphase/phases/set_domain_properties/interaction_domain/heat_mass_reactions/interphase_viscous_dissipation/jump_adhesion").execute(*args, **kwargs)
                                    def vmass_implicit(self, *args, **kwargs):
                                        """
                                        Enable the implicit method for the virtual mass force?.
                                        """
                                        return PyMenu(self.service, "/setup/models/multiphase/phases/set_domain_properties/interaction_domain/heat_mass_reactions/interphase_viscous_dissipation/vmass_implicit").execute(*args, **kwargs)
                                    def vmass_implicit_options(self, *args, **kwargs):
                                        """
                                        Select the virtual mass implicit option.
                                        """
                                        return PyMenu(self.service, "/setup/models/multiphase/phases/set_domain_properties/interaction_domain/heat_mass_reactions/interphase_viscous_dissipation/vmass_implicit_options").execute(*args, **kwargs)
                                    def vmass_coeff(self, *args, **kwargs):
                                        """
                                        Specify the virtual mass coefficient for each pair of phases.
                                        """
                                        return PyMenu(self.service, "/setup/models/multiphase/phases/set_domain_properties/interaction_domain/heat_mass_reactions/interphase_viscous_dissipation/vmass_coeff").execute(*args, **kwargs)
                                    def cavitation(self, *args, **kwargs):
                                        """
                                        Set the vaporization pressure, the surface tension coefficient, and the non-condensable gas mass fraction.
                                        """
                                        return PyMenu(self.service, "/setup/models/multiphase/phases/set_domain_properties/interaction_domain/heat_mass_reactions/interphase_viscous_dissipation/cavitation").execute(*args, **kwargs)
                                    def wall_adhesion(self, *args, **kwargs):
                                        """
                                        Enable the specification for a wall adhesion angle?.
                                        """
                                        return PyMenu(self.service, "/setup/models/multiphase/phases/set_domain_properties/interaction_domain/heat_mass_reactions/interphase_viscous_dissipation/wall_adhesion").execute(*args, **kwargs)
                                    def slope_limiter(self, *args, **kwargs):
                                        """
                                        Specify the slope limiter to set a specific discretization scheme. 0: first order upwind, 1: second order reconstruction bounded by the global minimum/maximum of the volume fraction, 2: compressive. Value between 0 and 2: blended scheme.
                                        """
                                        return PyMenu(self.service, "/setup/models/multiphase/phases/set_domain_properties/interaction_domain/heat_mass_reactions/interphase_viscous_dissipation/slope_limiter").execute(*args, **kwargs)

                            class numerics(TUIMenu):
                                """
                                Enter the menu to set numerics models.
                                """
                                def __init__(self, path, service):
                                    self.path = path
                                    self.service = service
                                    self.surface_tension = self.__class__.surface_tension(path + ["surface_tension"], service)
                                    self.interphase_viscous_dissipation = self.__class__.interphase_viscous_dissipation(path + ["interphase_viscous_dissipation"], service)
                                    self.virtual_mass = self.__class__.virtual_mass(path + ["virtual_mass"], service)
                                    self.cavitation = self.__class__.cavitation(path + ["cavitation"], service)
                                    self.interphase_discretization = self.__class__.interphase_discretization(path + ["interphase_discretization"], service)
                                    self.lift = self.__class__.lift(path + ["lift"], service)
                                    super().__init__(path, service)
                                def model_transition(self, *args, **kwargs):
                                    """
                                    Set the model transition mechanism.
                                    """
                                    return PyMenu(self.service, "/setup/models/multiphase/phases/set_domain_properties/interaction_domain/numerics/model_transition").execute(*args, **kwargs)
                                def reactions(self, *args, **kwargs):
                                    """
                                    Define multiple heterogeneous reactions and stoichiometry.
                                    """
                                    return PyMenu(self.service, "/setup/models/multiphase/phases/set_domain_properties/interaction_domain/numerics/reactions").execute(*args, **kwargs)
                                def slip_velocity(self, *args, **kwargs):
                                    """
                                    Specify the slip velocity function for each secondary phase with respect to the primary phase.
                                    """
                                    return PyMenu(self.service, "/setup/models/multiphase/phases/set_domain_properties/interaction_domain/numerics/slip_velocity").execute(*args, **kwargs)
                                def mass_transfer(self, *args, **kwargs):
                                    """
                                    Specify the mass transfer mechanisms.
                                    """
                                    return PyMenu(self.service, "/setup/models/multiphase/phases/set_domain_properties/interaction_domain/numerics/mass_transfer").execute(*args, **kwargs)
                                def wall_lubrication(self, *args, **kwargs):
                                    """
                                    Specify the wall lubrication model for each primary-secondary phase pair.
                                    """
                                    return PyMenu(self.service, "/setup/models/multiphase/phases/set_domain_properties/interaction_domain/numerics/wall_lubrication").execute(*args, **kwargs)
                                def turbulent_dispersion(self, *args, **kwargs):
                                    """
                                    Specify the turbulent dispersion model for each primary-secondary phase pair.
                                    """
                                    return PyMenu(self.service, "/setup/models/multiphase/phases/set_domain_properties/interaction_domain/numerics/turbulent_dispersion").execute(*args, **kwargs)
                                def restitution(self, *args, **kwargs):
                                    """
                                    Specify the restitution coefficient for collisions between each pair of granular phases and for collisions between particles of the same granular phase.
                                    """
                                    return PyMenu(self.service, "/setup/models/multiphase/phases/set_domain_properties/interaction_domain/numerics/restitution").execute(*args, **kwargs)
                                def interfacial_area(self, *args, **kwargs):
                                    """
                                    Set the interfacial area parameters for each pair of phases.
                                    """
                                    return PyMenu(self.service, "/setup/models/multiphase/phases/set_domain_properties/interaction_domain/numerics/interfacial_area").execute(*args, **kwargs)
                                def turbulence_interaction(self, *args, **kwargs):
                                    """
                                    Specify the turbulence interaction model for each primary-secondary phase pair.
                                    """
                                    return PyMenu(self.service, "/setup/models/multiphase/phases/set_domain_properties/interaction_domain/numerics/turbulence_interaction").execute(*args, **kwargs)
                                def drag(self, *args, **kwargs):
                                    """
                                    Specify the drag function for each pair of phases. It also enables drag modification and allow specifying the drag factor.
                                    """
                                    return PyMenu(self.service, "/setup/models/multiphase/phases/set_domain_properties/interaction_domain/numerics/drag").execute(*args, **kwargs)
                                def heat_coeff(self, *args, **kwargs):
                                    """
                                    Specify the heat transfer coefficient function between each pair of phases.
                                    """
                                    return PyMenu(self.service, "/setup/models/multiphase/phases/set_domain_properties/interaction_domain/numerics/heat_coeff").execute(*args, **kwargs)

                                class surface_tension(TUIMenu):
                                    """
                                    Enter the menu to set surface tension models.
                                    """
                                    def __init__(self, path, service):
                                        self.path = path
                                        self.service = service
                                        super().__init__(path, service)
                                    def jump_adhesion(self, *args, **kwargs):
                                        """
                                        Enable the treatment of the contact angle specification at the porous jump boundary?.
                                        """
                                        return PyMenu(self.service, "/setup/models/multiphase/phases/set_domain_properties/interaction_domain/numerics/surface_tension/jump_adhesion").execute(*args, **kwargs)
                                    def sfc_tension_coeff(self, *args, **kwargs):
                                        """
                                        Specify the surface tension coefficient for each pair of phases.
                                        """
                                        return PyMenu(self.service, "/setup/models/multiphase/phases/set_domain_properties/interaction_domain/numerics/surface_tension/sfc_tension_coeff").execute(*args, **kwargs)
                                    def slope_limiter(self, *args, **kwargs):
                                        """
                                        Specify the slope limiter to set a specific discretization scheme. 0: first order upwind, 1: second order reconstruction bounded by the global minimum/maximum of the volume fraction, 2: compressive. Value between 0 and 2: blended scheme.
                                        """
                                        return PyMenu(self.service, "/setup/models/multiphase/phases/set_domain_properties/interaction_domain/numerics/surface_tension/slope_limiter").execute(*args, **kwargs)
                                    def sfc_model_type(self, *args, **kwargs):
                                        """
                                        Select the surface tension model.
                                        """
                                        return PyMenu(self.service, "/setup/models/multiphase/phases/set_domain_properties/interaction_domain/numerics/surface_tension/sfc_model_type").execute(*args, **kwargs)
                                    def interphase_discr(self, *args, **kwargs):
                                        """
                                        Enable the phase localized compressive discretization scheme where the degree of diffusion/sharpness is controlled through the value of the slope limiters?.
                                        """
                                        return PyMenu(self.service, "/setup/models/multiphase/phases/set_domain_properties/interaction_domain/numerics/surface_tension/interphase_discr").execute(*args, **kwargs)
                                    def interphase_visc_disp(self, *args, **kwargs):
                                        """
                                        Enable the interfacial viscous dissipation method, which introduces an artificial viscous damping term in the momentum equation?.
                                        """
                                        return PyMenu(self.service, "/setup/models/multiphase/phases/set_domain_properties/interaction_domain/numerics/surface_tension/interphase_visc_disp").execute(*args, **kwargs)
                                    def visc_disp_factor(self, *args, **kwargs):
                                        """
                                        Set the dissipation intensity.
                                        """
                                        return PyMenu(self.service, "/setup/models/multiphase/phases/set_domain_properties/interaction_domain/numerics/surface_tension/visc_disp_factor").execute(*args, **kwargs)
                                    def wall_adhesion(self, *args, **kwargs):
                                        """
                                        Enable the specification for a wall adhesion angle?.
                                        """
                                        return PyMenu(self.service, "/setup/models/multiphase/phases/set_domain_properties/interaction_domain/numerics/surface_tension/wall_adhesion").execute(*args, **kwargs)
                                    def lift_shaver_podowski(self, *args, **kwargs):
                                        """
                                        Include the Shaver-Podowski correction for Lift.
                                        """
                                        return PyMenu(self.service, "/setup/models/multiphase/phases/set_domain_properties/interaction_domain/numerics/surface_tension/lift_shaver_podowski").execute(*args, **kwargs)
                                    def lift_montoya(self, *args, **kwargs):
                                        """
                                        Include the Montoya correction for Lift.
                                        """
                                        return PyMenu(self.service, "/setup/models/multiphase/phases/set_domain_properties/interaction_domain/numerics/surface_tension/lift_montoya").execute(*args, **kwargs)
                                    def sfc_modeling(self, *args, **kwargs):
                                        """
                                        Include the effects of surface tension along the fluid-fluid interface?.
                                        """
                                        return PyMenu(self.service, "/setup/models/multiphase/phases/set_domain_properties/interaction_domain/numerics/surface_tension/sfc_modeling").execute(*args, **kwargs)
                                    def virtual_mass(self, *args, **kwargs):
                                        """
                                        Include the virtual mass force that is present when a secondary phase accelerates relative to the primary phase?.
                                        """
                                        return PyMenu(self.service, "/setup/models/multiphase/phases/set_domain_properties/interaction_domain/numerics/surface_tension/virtual_mass").execute(*args, **kwargs)
                                    def vmass_coeff(self, *args, **kwargs):
                                        """
                                        Specify the virtual mass coefficient for each pair of phases.
                                        """
                                        return PyMenu(self.service, "/setup/models/multiphase/phases/set_domain_properties/interaction_domain/numerics/surface_tension/vmass_coeff").execute(*args, **kwargs)
                                    def vmass_implicit(self, *args, **kwargs):
                                        """
                                        Enable the implicit method for the virtual mass force?.
                                        """
                                        return PyMenu(self.service, "/setup/models/multiphase/phases/set_domain_properties/interaction_domain/numerics/surface_tension/vmass_implicit").execute(*args, **kwargs)
                                    def cavitation(self, *args, **kwargs):
                                        """
                                        Set the vaporization pressure, the surface tension coefficient, and the non-condensable gas mass fraction.
                                        """
                                        return PyMenu(self.service, "/setup/models/multiphase/phases/set_domain_properties/interaction_domain/numerics/surface_tension/cavitation").execute(*args, **kwargs)
                                    def lift(self, *args, **kwargs):
                                        """
                                        .
                                        """
                                        return PyMenu(self.service, "/setup/models/multiphase/phases/set_domain_properties/interaction_domain/numerics/surface_tension/lift").execute(*args, **kwargs)
                                    def vmass_implicit_options(self, *args, **kwargs):
                                        """
                                        Select the virtual mass implicit option.
                                        """
                                        return PyMenu(self.service, "/setup/models/multiphase/phases/set_domain_properties/interaction_domain/numerics/surface_tension/vmass_implicit_options").execute(*args, **kwargs)

                                class interphase_viscous_dissipation(TUIMenu):
                                    """
                                    Enter the menu to set interphase viscous dissipation related models.
                                    """
                                    def __init__(self, path, service):
                                        self.path = path
                                        self.service = service
                                        super().__init__(path, service)
                                    def vmass_implicit(self, *args, **kwargs):
                                        """
                                        Enable the implicit method for the virtual mass force?.
                                        """
                                        return PyMenu(self.service, "/setup/models/multiphase/phases/set_domain_properties/interaction_domain/numerics/interphase_viscous_dissipation/vmass_implicit").execute(*args, **kwargs)
                                    def jump_adhesion(self, *args, **kwargs):
                                        """
                                        Enable the treatment of the contact angle specification at the porous jump boundary?.
                                        """
                                        return PyMenu(self.service, "/setup/models/multiphase/phases/set_domain_properties/interaction_domain/numerics/interphase_viscous_dissipation/jump_adhesion").execute(*args, **kwargs)
                                    def interphase_discr(self, *args, **kwargs):
                                        """
                                        Enable the phase localized compressive discretization scheme where the degree of diffusion/sharpness is controlled through the value of the slope limiters?.
                                        """
                                        return PyMenu(self.service, "/setup/models/multiphase/phases/set_domain_properties/interaction_domain/numerics/interphase_viscous_dissipation/interphase_discr").execute(*args, **kwargs)
                                    def sfc_tension_coeff(self, *args, **kwargs):
                                        """
                                        Specify the surface tension coefficient for each pair of phases.
                                        """
                                        return PyMenu(self.service, "/setup/models/multiphase/phases/set_domain_properties/interaction_domain/numerics/interphase_viscous_dissipation/sfc_tension_coeff").execute(*args, **kwargs)
                                    def lift(self, *args, **kwargs):
                                        """
                                        .
                                        """
                                        return PyMenu(self.service, "/setup/models/multiphase/phases/set_domain_properties/interaction_domain/numerics/interphase_viscous_dissipation/lift").execute(*args, **kwargs)
                                    def wall_adhesion(self, *args, **kwargs):
                                        """
                                        Enable the specification for a wall adhesion angle?.
                                        """
                                        return PyMenu(self.service, "/setup/models/multiphase/phases/set_domain_properties/interaction_domain/numerics/interphase_viscous_dissipation/wall_adhesion").execute(*args, **kwargs)
                                    def vmass_implicit_options(self, *args, **kwargs):
                                        """
                                        Select the virtual mass implicit option.
                                        """
                                        return PyMenu(self.service, "/setup/models/multiphase/phases/set_domain_properties/interaction_domain/numerics/interphase_viscous_dissipation/vmass_implicit_options").execute(*args, **kwargs)
                                    def lift_shaver_podowski(self, *args, **kwargs):
                                        """
                                        Include the Shaver-Podowski correction for Lift.
                                        """
                                        return PyMenu(self.service, "/setup/models/multiphase/phases/set_domain_properties/interaction_domain/numerics/interphase_viscous_dissipation/lift_shaver_podowski").execute(*args, **kwargs)
                                    def virtual_mass(self, *args, **kwargs):
                                        """
                                        Include the virtual mass force that is present when a secondary phase accelerates relative to the primary phase?.
                                        """
                                        return PyMenu(self.service, "/setup/models/multiphase/phases/set_domain_properties/interaction_domain/numerics/interphase_viscous_dissipation/virtual_mass").execute(*args, **kwargs)
                                    def sfc_modeling(self, *args, **kwargs):
                                        """
                                        Include the effects of surface tension along the fluid-fluid interface?.
                                        """
                                        return PyMenu(self.service, "/setup/models/multiphase/phases/set_domain_properties/interaction_domain/numerics/interphase_viscous_dissipation/sfc_modeling").execute(*args, **kwargs)
                                    def interphase_visc_disp(self, *args, **kwargs):
                                        """
                                        Enable the interfacial viscous dissipation method, which introduces an artificial viscous damping term in the momentum equation?.
                                        """
                                        return PyMenu(self.service, "/setup/models/multiphase/phases/set_domain_properties/interaction_domain/numerics/interphase_viscous_dissipation/interphase_visc_disp").execute(*args, **kwargs)
                                    def cavitation(self, *args, **kwargs):
                                        """
                                        Set the vaporization pressure, the surface tension coefficient, and the non-condensable gas mass fraction.
                                        """
                                        return PyMenu(self.service, "/setup/models/multiphase/phases/set_domain_properties/interaction_domain/numerics/interphase_viscous_dissipation/cavitation").execute(*args, **kwargs)
                                    def slope_limiter(self, *args, **kwargs):
                                        """
                                        Specify the slope limiter to set a specific discretization scheme. 0: first order upwind, 1: second order reconstruction bounded by the global minimum/maximum of the volume fraction, 2: compressive. Value between 0 and 2: blended scheme.
                                        """
                                        return PyMenu(self.service, "/setup/models/multiphase/phases/set_domain_properties/interaction_domain/numerics/interphase_viscous_dissipation/slope_limiter").execute(*args, **kwargs)
                                    def vmass_coeff(self, *args, **kwargs):
                                        """
                                        Specify the virtual mass coefficient for each pair of phases.
                                        """
                                        return PyMenu(self.service, "/setup/models/multiphase/phases/set_domain_properties/interaction_domain/numerics/interphase_viscous_dissipation/vmass_coeff").execute(*args, **kwargs)
                                    def visc_disp_factor(self, *args, **kwargs):
                                        """
                                        Set the dissipation intensity.
                                        """
                                        return PyMenu(self.service, "/setup/models/multiphase/phases/set_domain_properties/interaction_domain/numerics/interphase_viscous_dissipation/visc_disp_factor").execute(*args, **kwargs)
                                    def lift_montoya(self, *args, **kwargs):
                                        """
                                        Include the Montoya correction for Lift.
                                        """
                                        return PyMenu(self.service, "/setup/models/multiphase/phases/set_domain_properties/interaction_domain/numerics/interphase_viscous_dissipation/lift_montoya").execute(*args, **kwargs)
                                    def sfc_model_type(self, *args, **kwargs):
                                        """
                                        Select the surface tension model.
                                        """
                                        return PyMenu(self.service, "/setup/models/multiphase/phases/set_domain_properties/interaction_domain/numerics/interphase_viscous_dissipation/sfc_model_type").execute(*args, **kwargs)

                                class virtual_mass(TUIMenu):
                                    """
                                    Enter the menu to set virtual mass models.
                                    """
                                    def __init__(self, path, service):
                                        self.path = path
                                        self.service = service
                                        super().__init__(path, service)
                                    def slope_limiter(self, *args, **kwargs):
                                        """
                                        Specify the slope limiter to set a specific discretization scheme. 0: first order upwind, 1: second order reconstruction bounded by the global minimum/maximum of the volume fraction, 2: compressive. Value between 0 and 2: blended scheme.
                                        """
                                        return PyMenu(self.service, "/setup/models/multiphase/phases/set_domain_properties/interaction_domain/numerics/virtual_mass/slope_limiter").execute(*args, **kwargs)
                                    def lift_shaver_podowski(self, *args, **kwargs):
                                        """
                                        Include the Shaver-Podowski correction for Lift.
                                        """
                                        return PyMenu(self.service, "/setup/models/multiphase/phases/set_domain_properties/interaction_domain/numerics/virtual_mass/lift_shaver_podowski").execute(*args, **kwargs)
                                    def vmass_implicit(self, *args, **kwargs):
                                        """
                                        Enable the implicit method for the virtual mass force?.
                                        """
                                        return PyMenu(self.service, "/setup/models/multiphase/phases/set_domain_properties/interaction_domain/numerics/virtual_mass/vmass_implicit").execute(*args, **kwargs)
                                    def cavitation(self, *args, **kwargs):
                                        """
                                        Set the vaporization pressure, the surface tension coefficient, and the non-condensable gas mass fraction.
                                        """
                                        return PyMenu(self.service, "/setup/models/multiphase/phases/set_domain_properties/interaction_domain/numerics/virtual_mass/cavitation").execute(*args, **kwargs)
                                    def sfc_modeling(self, *args, **kwargs):
                                        """
                                        Include the effects of surface tension along the fluid-fluid interface?.
                                        """
                                        return PyMenu(self.service, "/setup/models/multiphase/phases/set_domain_properties/interaction_domain/numerics/virtual_mass/sfc_modeling").execute(*args, **kwargs)
                                    def sfc_tension_coeff(self, *args, **kwargs):
                                        """
                                        Specify the surface tension coefficient for each pair of phases.
                                        """
                                        return PyMenu(self.service, "/setup/models/multiphase/phases/set_domain_properties/interaction_domain/numerics/virtual_mass/sfc_tension_coeff").execute(*args, **kwargs)
                                    def lift_montoya(self, *args, **kwargs):
                                        """
                                        Include the Montoya correction for Lift.
                                        """
                                        return PyMenu(self.service, "/setup/models/multiphase/phases/set_domain_properties/interaction_domain/numerics/virtual_mass/lift_montoya").execute(*args, **kwargs)
                                    def vmass_coeff(self, *args, **kwargs):
                                        """
                                        Specify the virtual mass coefficient for each pair of phases.
                                        """
                                        return PyMenu(self.service, "/setup/models/multiphase/phases/set_domain_properties/interaction_domain/numerics/virtual_mass/vmass_coeff").execute(*args, **kwargs)
                                    def lift(self, *args, **kwargs):
                                        """
                                        .
                                        """
                                        return PyMenu(self.service, "/setup/models/multiphase/phases/set_domain_properties/interaction_domain/numerics/virtual_mass/lift").execute(*args, **kwargs)
                                    def interphase_visc_disp(self, *args, **kwargs):
                                        """
                                        Enable the interfacial viscous dissipation method, which introduces an artificial viscous damping term in the momentum equation?.
                                        """
                                        return PyMenu(self.service, "/setup/models/multiphase/phases/set_domain_properties/interaction_domain/numerics/virtual_mass/interphase_visc_disp").execute(*args, **kwargs)
                                    def virtual_mass(self, *args, **kwargs):
                                        """
                                        Include the virtual mass force that is present when a secondary phase accelerates relative to the primary phase?.
                                        """
                                        return PyMenu(self.service, "/setup/models/multiphase/phases/set_domain_properties/interaction_domain/numerics/virtual_mass/virtual_mass").execute(*args, **kwargs)
                                    def vmass_implicit_options(self, *args, **kwargs):
                                        """
                                        Select the virtual mass implicit option.
                                        """
                                        return PyMenu(self.service, "/setup/models/multiphase/phases/set_domain_properties/interaction_domain/numerics/virtual_mass/vmass_implicit_options").execute(*args, **kwargs)
                                    def visc_disp_factor(self, *args, **kwargs):
                                        """
                                        Set the dissipation intensity.
                                        """
                                        return PyMenu(self.service, "/setup/models/multiphase/phases/set_domain_properties/interaction_domain/numerics/virtual_mass/visc_disp_factor").execute(*args, **kwargs)
                                    def jump_adhesion(self, *args, **kwargs):
                                        """
                                        Enable the treatment of the contact angle specification at the porous jump boundary?.
                                        """
                                        return PyMenu(self.service, "/setup/models/multiphase/phases/set_domain_properties/interaction_domain/numerics/virtual_mass/jump_adhesion").execute(*args, **kwargs)
                                    def interphase_discr(self, *args, **kwargs):
                                        """
                                        Enable the phase localized compressive discretization scheme where the degree of diffusion/sharpness is controlled through the value of the slope limiters?.
                                        """
                                        return PyMenu(self.service, "/setup/models/multiphase/phases/set_domain_properties/interaction_domain/numerics/virtual_mass/interphase_discr").execute(*args, **kwargs)
                                    def wall_adhesion(self, *args, **kwargs):
                                        """
                                        Enable the specification for a wall adhesion angle?.
                                        """
                                        return PyMenu(self.service, "/setup/models/multiphase/phases/set_domain_properties/interaction_domain/numerics/virtual_mass/wall_adhesion").execute(*args, **kwargs)
                                    def sfc_model_type(self, *args, **kwargs):
                                        """
                                        Select the surface tension model.
                                        """
                                        return PyMenu(self.service, "/setup/models/multiphase/phases/set_domain_properties/interaction_domain/numerics/virtual_mass/sfc_model_type").execute(*args, **kwargs)

                                class cavitation(TUIMenu):
                                    """
                                    Enter the menu to set cavitation models.
                                    """
                                    def __init__(self, path, service):
                                        self.path = path
                                        self.service = service
                                        super().__init__(path, service)
                                    def lift(self, *args, **kwargs):
                                        """
                                        .
                                        """
                                        return PyMenu(self.service, "/setup/models/multiphase/phases/set_domain_properties/interaction_domain/numerics/cavitation/lift").execute(*args, **kwargs)
                                    def visc_disp_factor(self, *args, **kwargs):
                                        """
                                        Set the dissipation intensity.
                                        """
                                        return PyMenu(self.service, "/setup/models/multiphase/phases/set_domain_properties/interaction_domain/numerics/cavitation/visc_disp_factor").execute(*args, **kwargs)
                                    def virtual_mass(self, *args, **kwargs):
                                        """
                                        Include the virtual mass force that is present when a secondary phase accelerates relative to the primary phase?.
                                        """
                                        return PyMenu(self.service, "/setup/models/multiphase/phases/set_domain_properties/interaction_domain/numerics/cavitation/virtual_mass").execute(*args, **kwargs)
                                    def wall_adhesion(self, *args, **kwargs):
                                        """
                                        Enable the specification for a wall adhesion angle?.
                                        """
                                        return PyMenu(self.service, "/setup/models/multiphase/phases/set_domain_properties/interaction_domain/numerics/cavitation/wall_adhesion").execute(*args, **kwargs)
                                    def interphase_visc_disp(self, *args, **kwargs):
                                        """
                                        Enable the interfacial viscous dissipation method, which introduces an artificial viscous damping term in the momentum equation?.
                                        """
                                        return PyMenu(self.service, "/setup/models/multiphase/phases/set_domain_properties/interaction_domain/numerics/cavitation/interphase_visc_disp").execute(*args, **kwargs)
                                    def lift_shaver_podowski(self, *args, **kwargs):
                                        """
                                        Include the Shaver-Podowski correction for Lift.
                                        """
                                        return PyMenu(self.service, "/setup/models/multiphase/phases/set_domain_properties/interaction_domain/numerics/cavitation/lift_shaver_podowski").execute(*args, **kwargs)
                                    def vmass_implicit_options(self, *args, **kwargs):
                                        """
                                        Select the virtual mass implicit option.
                                        """
                                        return PyMenu(self.service, "/setup/models/multiphase/phases/set_domain_properties/interaction_domain/numerics/cavitation/vmass_implicit_options").execute(*args, **kwargs)
                                    def sfc_model_type(self, *args, **kwargs):
                                        """
                                        Select the surface tension model.
                                        """
                                        return PyMenu(self.service, "/setup/models/multiphase/phases/set_domain_properties/interaction_domain/numerics/cavitation/sfc_model_type").execute(*args, **kwargs)
                                    def vmass_coeff(self, *args, **kwargs):
                                        """
                                        Specify the virtual mass coefficient for each pair of phases.
                                        """
                                        return PyMenu(self.service, "/setup/models/multiphase/phases/set_domain_properties/interaction_domain/numerics/cavitation/vmass_coeff").execute(*args, **kwargs)
                                    def slope_limiter(self, *args, **kwargs):
                                        """
                                        Specify the slope limiter to set a specific discretization scheme. 0: first order upwind, 1: second order reconstruction bounded by the global minimum/maximum of the volume fraction, 2: compressive. Value between 0 and 2: blended scheme.
                                        """
                                        return PyMenu(self.service, "/setup/models/multiphase/phases/set_domain_properties/interaction_domain/numerics/cavitation/slope_limiter").execute(*args, **kwargs)
                                    def jump_adhesion(self, *args, **kwargs):
                                        """
                                        Enable the treatment of the contact angle specification at the porous jump boundary?.
                                        """
                                        return PyMenu(self.service, "/setup/models/multiphase/phases/set_domain_properties/interaction_domain/numerics/cavitation/jump_adhesion").execute(*args, **kwargs)
                                    def vmass_implicit(self, *args, **kwargs):
                                        """
                                        Enable the implicit method for the virtual mass force?.
                                        """
                                        return PyMenu(self.service, "/setup/models/multiphase/phases/set_domain_properties/interaction_domain/numerics/cavitation/vmass_implicit").execute(*args, **kwargs)
                                    def sfc_tension_coeff(self, *args, **kwargs):
                                        """
                                        Specify the surface tension coefficient for each pair of phases.
                                        """
                                        return PyMenu(self.service, "/setup/models/multiphase/phases/set_domain_properties/interaction_domain/numerics/cavitation/sfc_tension_coeff").execute(*args, **kwargs)
                                    def lift_montoya(self, *args, **kwargs):
                                        """
                                        Include the Montoya correction for Lift.
                                        """
                                        return PyMenu(self.service, "/setup/models/multiphase/phases/set_domain_properties/interaction_domain/numerics/cavitation/lift_montoya").execute(*args, **kwargs)
                                    def cavitation(self, *args, **kwargs):
                                        """
                                        Set the vaporization pressure, the surface tension coefficient, and the non-condensable gas mass fraction.
                                        """
                                        return PyMenu(self.service, "/setup/models/multiphase/phases/set_domain_properties/interaction_domain/numerics/cavitation/cavitation").execute(*args, **kwargs)
                                    def interphase_discr(self, *args, **kwargs):
                                        """
                                        Enable the phase localized compressive discretization scheme where the degree of diffusion/sharpness is controlled through the value of the slope limiters?.
                                        """
                                        return PyMenu(self.service, "/setup/models/multiphase/phases/set_domain_properties/interaction_domain/numerics/cavitation/interphase_discr").execute(*args, **kwargs)
                                    def sfc_modeling(self, *args, **kwargs):
                                        """
                                        Include the effects of surface tension along the fluid-fluid interface?.
                                        """
                                        return PyMenu(self.service, "/setup/models/multiphase/phases/set_domain_properties/interaction_domain/numerics/cavitation/sfc_modeling").execute(*args, **kwargs)

                                class interphase_discretization(TUIMenu):
                                    """
                                    Enter the menu to set interphase discretization models.
                                    """
                                    def __init__(self, path, service):
                                        self.path = path
                                        self.service = service
                                        super().__init__(path, service)
                                    def interphase_visc_disp(self, *args, **kwargs):
                                        """
                                        Enable the interfacial viscous dissipation method, which introduces an artificial viscous damping term in the momentum equation?.
                                        """
                                        return PyMenu(self.service, "/setup/models/multiphase/phases/set_domain_properties/interaction_domain/numerics/interphase_discretization/interphase_visc_disp").execute(*args, **kwargs)
                                    def sfc_modeling(self, *args, **kwargs):
                                        """
                                        Include the effects of surface tension along the fluid-fluid interface?.
                                        """
                                        return PyMenu(self.service, "/setup/models/multiphase/phases/set_domain_properties/interaction_domain/numerics/interphase_discretization/sfc_modeling").execute(*args, **kwargs)
                                    def lift_shaver_podowski(self, *args, **kwargs):
                                        """
                                        Include the Shaver-Podowski correction for Lift.
                                        """
                                        return PyMenu(self.service, "/setup/models/multiphase/phases/set_domain_properties/interaction_domain/numerics/interphase_discretization/lift_shaver_podowski").execute(*args, **kwargs)
                                    def sfc_tension_coeff(self, *args, **kwargs):
                                        """
                                        Specify the surface tension coefficient for each pair of phases.
                                        """
                                        return PyMenu(self.service, "/setup/models/multiphase/phases/set_domain_properties/interaction_domain/numerics/interphase_discretization/sfc_tension_coeff").execute(*args, **kwargs)
                                    def visc_disp_factor(self, *args, **kwargs):
                                        """
                                        Set the dissipation intensity.
                                        """
                                        return PyMenu(self.service, "/setup/models/multiphase/phases/set_domain_properties/interaction_domain/numerics/interphase_discretization/visc_disp_factor").execute(*args, **kwargs)
                                    def lift_montoya(self, *args, **kwargs):
                                        """
                                        Include the Montoya correction for Lift.
                                        """
                                        return PyMenu(self.service, "/setup/models/multiphase/phases/set_domain_properties/interaction_domain/numerics/interphase_discretization/lift_montoya").execute(*args, **kwargs)
                                    def jump_adhesion(self, *args, **kwargs):
                                        """
                                        Enable the treatment of the contact angle specification at the porous jump boundary?.
                                        """
                                        return PyMenu(self.service, "/setup/models/multiphase/phases/set_domain_properties/interaction_domain/numerics/interphase_discretization/jump_adhesion").execute(*args, **kwargs)
                                    def cavitation(self, *args, **kwargs):
                                        """
                                        Set the vaporization pressure, the surface tension coefficient, and the non-condensable gas mass fraction.
                                        """
                                        return PyMenu(self.service, "/setup/models/multiphase/phases/set_domain_properties/interaction_domain/numerics/interphase_discretization/cavitation").execute(*args, **kwargs)
                                    def vmass_implicit_options(self, *args, **kwargs):
                                        """
                                        Select the virtual mass implicit option.
                                        """
                                        return PyMenu(self.service, "/setup/models/multiphase/phases/set_domain_properties/interaction_domain/numerics/interphase_discretization/vmass_implicit_options").execute(*args, **kwargs)
                                    def vmass_coeff(self, *args, **kwargs):
                                        """
                                        Specify the virtual mass coefficient for each pair of phases.
                                        """
                                        return PyMenu(self.service, "/setup/models/multiphase/phases/set_domain_properties/interaction_domain/numerics/interphase_discretization/vmass_coeff").execute(*args, **kwargs)
                                    def vmass_implicit(self, *args, **kwargs):
                                        """
                                        Enable the implicit method for the virtual mass force?.
                                        """
                                        return PyMenu(self.service, "/setup/models/multiphase/phases/set_domain_properties/interaction_domain/numerics/interphase_discretization/vmass_implicit").execute(*args, **kwargs)
                                    def sfc_model_type(self, *args, **kwargs):
                                        """
                                        Select the surface tension model.
                                        """
                                        return PyMenu(self.service, "/setup/models/multiphase/phases/set_domain_properties/interaction_domain/numerics/interphase_discretization/sfc_model_type").execute(*args, **kwargs)
                                    def lift(self, *args, **kwargs):
                                        """
                                        .
                                        """
                                        return PyMenu(self.service, "/setup/models/multiphase/phases/set_domain_properties/interaction_domain/numerics/interphase_discretization/lift").execute(*args, **kwargs)
                                    def wall_adhesion(self, *args, **kwargs):
                                        """
                                        Enable the specification for a wall adhesion angle?.
                                        """
                                        return PyMenu(self.service, "/setup/models/multiphase/phases/set_domain_properties/interaction_domain/numerics/interphase_discretization/wall_adhesion").execute(*args, **kwargs)
                                    def slope_limiter(self, *args, **kwargs):
                                        """
                                        Specify the slope limiter to set a specific discretization scheme. 0: first order upwind, 1: second order reconstruction bounded by the global minimum/maximum of the volume fraction, 2: compressive. Value between 0 and 2: blended scheme.
                                        """
                                        return PyMenu(self.service, "/setup/models/multiphase/phases/set_domain_properties/interaction_domain/numerics/interphase_discretization/slope_limiter").execute(*args, **kwargs)
                                    def virtual_mass(self, *args, **kwargs):
                                        """
                                        Include the virtual mass force that is present when a secondary phase accelerates relative to the primary phase?.
                                        """
                                        return PyMenu(self.service, "/setup/models/multiphase/phases/set_domain_properties/interaction_domain/numerics/interphase_discretization/virtual_mass").execute(*args, **kwargs)
                                    def interphase_discr(self, *args, **kwargs):
                                        """
                                        Enable the phase localized compressive discretization scheme where the degree of diffusion/sharpness is controlled through the value of the slope limiters?.
                                        """
                                        return PyMenu(self.service, "/setup/models/multiphase/phases/set_domain_properties/interaction_domain/numerics/interphase_discretization/interphase_discr").execute(*args, **kwargs)

                                class lift(TUIMenu):
                                    """
                                    Enter the menu to set lift models.
                                    """
                                    def __init__(self, path, service):
                                        self.path = path
                                        self.service = service
                                        super().__init__(path, service)
                                    def virtual_mass(self, *args, **kwargs):
                                        """
                                        Include the virtual mass force that is present when a secondary phase accelerates relative to the primary phase?.
                                        """
                                        return PyMenu(self.service, "/setup/models/multiphase/phases/set_domain_properties/interaction_domain/numerics/lift/virtual_mass").execute(*args, **kwargs)
                                    def interphase_discr(self, *args, **kwargs):
                                        """
                                        Enable the phase localized compressive discretization scheme where the degree of diffusion/sharpness is controlled through the value of the slope limiters?.
                                        """
                                        return PyMenu(self.service, "/setup/models/multiphase/phases/set_domain_properties/interaction_domain/numerics/lift/interphase_discr").execute(*args, **kwargs)
                                    def lift(self, *args, **kwargs):
                                        """
                                        .
                                        """
                                        return PyMenu(self.service, "/setup/models/multiphase/phases/set_domain_properties/interaction_domain/numerics/lift/lift").execute(*args, **kwargs)
                                    def cavitation(self, *args, **kwargs):
                                        """
                                        Set the vaporization pressure, the surface tension coefficient, and the non-condensable gas mass fraction.
                                        """
                                        return PyMenu(self.service, "/setup/models/multiphase/phases/set_domain_properties/interaction_domain/numerics/lift/cavitation").execute(*args, **kwargs)
                                    def sfc_modeling(self, *args, **kwargs):
                                        """
                                        Include the effects of surface tension along the fluid-fluid interface?.
                                        """
                                        return PyMenu(self.service, "/setup/models/multiphase/phases/set_domain_properties/interaction_domain/numerics/lift/sfc_modeling").execute(*args, **kwargs)
                                    def interphase_visc_disp(self, *args, **kwargs):
                                        """
                                        Enable the interfacial viscous dissipation method, which introduces an artificial viscous damping term in the momentum equation?.
                                        """
                                        return PyMenu(self.service, "/setup/models/multiphase/phases/set_domain_properties/interaction_domain/numerics/lift/interphase_visc_disp").execute(*args, **kwargs)
                                    def vmass_coeff(self, *args, **kwargs):
                                        """
                                        Specify the virtual mass coefficient for each pair of phases.
                                        """
                                        return PyMenu(self.service, "/setup/models/multiphase/phases/set_domain_properties/interaction_domain/numerics/lift/vmass_coeff").execute(*args, **kwargs)
                                    def vmass_implicit(self, *args, **kwargs):
                                        """
                                        Enable the implicit method for the virtual mass force?.
                                        """
                                        return PyMenu(self.service, "/setup/models/multiphase/phases/set_domain_properties/interaction_domain/numerics/lift/vmass_implicit").execute(*args, **kwargs)
                                    def jump_adhesion(self, *args, **kwargs):
                                        """
                                        Enable the treatment of the contact angle specification at the porous jump boundary?.
                                        """
                                        return PyMenu(self.service, "/setup/models/multiphase/phases/set_domain_properties/interaction_domain/numerics/lift/jump_adhesion").execute(*args, **kwargs)
                                    def lift_shaver_podowski(self, *args, **kwargs):
                                        """
                                        Include the Shaver-Podowski correction for Lift.
                                        """
                                        return PyMenu(self.service, "/setup/models/multiphase/phases/set_domain_properties/interaction_domain/numerics/lift/lift_shaver_podowski").execute(*args, **kwargs)
                                    def sfc_tension_coeff(self, *args, **kwargs):
                                        """
                                        Specify the surface tension coefficient for each pair of phases.
                                        """
                                        return PyMenu(self.service, "/setup/models/multiphase/phases/set_domain_properties/interaction_domain/numerics/lift/sfc_tension_coeff").execute(*args, **kwargs)
                                    def vmass_implicit_options(self, *args, **kwargs):
                                        """
                                        Select the virtual mass implicit option.
                                        """
                                        return PyMenu(self.service, "/setup/models/multiphase/phases/set_domain_properties/interaction_domain/numerics/lift/vmass_implicit_options").execute(*args, **kwargs)
                                    def visc_disp_factor(self, *args, **kwargs):
                                        """
                                        Set the dissipation intensity.
                                        """
                                        return PyMenu(self.service, "/setup/models/multiphase/phases/set_domain_properties/interaction_domain/numerics/lift/visc_disp_factor").execute(*args, **kwargs)
                                    def wall_adhesion(self, *args, **kwargs):
                                        """
                                        Enable the specification for a wall adhesion angle?.
                                        """
                                        return PyMenu(self.service, "/setup/models/multiphase/phases/set_domain_properties/interaction_domain/numerics/lift/wall_adhesion").execute(*args, **kwargs)
                                    def slope_limiter(self, *args, **kwargs):
                                        """
                                        Specify the slope limiter to set a specific discretization scheme. 0: first order upwind, 1: second order reconstruction bounded by the global minimum/maximum of the volume fraction, 2: compressive. Value between 0 and 2: blended scheme.
                                        """
                                        return PyMenu(self.service, "/setup/models/multiphase/phases/set_domain_properties/interaction_domain/numerics/lift/slope_limiter").execute(*args, **kwargs)
                                    def sfc_model_type(self, *args, **kwargs):
                                        """
                                        Select the surface tension model.
                                        """
                                        return PyMenu(self.service, "/setup/models/multiphase/phases/set_domain_properties/interaction_domain/numerics/lift/sfc_model_type").execute(*args, **kwargs)
                                    def lift_montoya(self, *args, **kwargs):
                                        """
                                        Include the Montoya correction for Lift.
                                        """
                                        return PyMenu(self.service, "/setup/models/multiphase/phases/set_domain_properties/interaction_domain/numerics/lift/lift_montoya").execute(*args, **kwargs)

                            class forces(TUIMenu):
                                """
                                Enter the menu to set interfacial forces related models.
                                """
                                def __init__(self, path, service):
                                    self.path = path
                                    self.service = service
                                    self.virtual_mass = self.__class__.virtual_mass(path + ["virtual_mass"], service)
                                    self.interphase_discretization = self.__class__.interphase_discretization(path + ["interphase_discretization"], service)
                                    self.lift = self.__class__.lift(path + ["lift"], service)
                                    self.cavitation = self.__class__.cavitation(path + ["cavitation"], service)
                                    self.interphase_viscous_dissipation = self.__class__.interphase_viscous_dissipation(path + ["interphase_viscous_dissipation"], service)
                                    self.surface_tension = self.__class__.surface_tension(path + ["surface_tension"], service)
                                    super().__init__(path, service)
                                def restitution(self, *args, **kwargs):
                                    """
                                    Specify the restitution coefficient for collisions between each pair of granular phases and for collisions between particles of the same granular phase.
                                    """
                                    return PyMenu(self.service, "/setup/models/multiphase/phases/set_domain_properties/interaction_domain/forces/restitution").execute(*args, **kwargs)
                                def drag(self, *args, **kwargs):
                                    """
                                    Specify the drag function for each pair of phases. It also enables drag modification and allow specifying the drag factor.
                                    """
                                    return PyMenu(self.service, "/setup/models/multiphase/phases/set_domain_properties/interaction_domain/forces/drag").execute(*args, **kwargs)
                                def reactions(self, *args, **kwargs):
                                    """
                                    Define multiple heterogeneous reactions and stoichiometry.
                                    """
                                    return PyMenu(self.service, "/setup/models/multiphase/phases/set_domain_properties/interaction_domain/forces/reactions").execute(*args, **kwargs)
                                def turbulence_interaction(self, *args, **kwargs):
                                    """
                                    Specify the turbulence interaction model for each primary-secondary phase pair.
                                    """
                                    return PyMenu(self.service, "/setup/models/multiphase/phases/set_domain_properties/interaction_domain/forces/turbulence_interaction").execute(*args, **kwargs)
                                def mass_transfer(self, *args, **kwargs):
                                    """
                                    Specify the mass transfer mechanisms.
                                    """
                                    return PyMenu(self.service, "/setup/models/multiphase/phases/set_domain_properties/interaction_domain/forces/mass_transfer").execute(*args, **kwargs)
                                def slip_velocity(self, *args, **kwargs):
                                    """
                                    Specify the slip velocity function for each secondary phase with respect to the primary phase.
                                    """
                                    return PyMenu(self.service, "/setup/models/multiphase/phases/set_domain_properties/interaction_domain/forces/slip_velocity").execute(*args, **kwargs)
                                def heat_coeff(self, *args, **kwargs):
                                    """
                                    Specify the heat transfer coefficient function between each pair of phases.
                                    """
                                    return PyMenu(self.service, "/setup/models/multiphase/phases/set_domain_properties/interaction_domain/forces/heat_coeff").execute(*args, **kwargs)
                                def turbulent_dispersion(self, *args, **kwargs):
                                    """
                                    Specify the turbulent dispersion model for each primary-secondary phase pair.
                                    """
                                    return PyMenu(self.service, "/setup/models/multiphase/phases/set_domain_properties/interaction_domain/forces/turbulent_dispersion").execute(*args, **kwargs)
                                def model_transition(self, *args, **kwargs):
                                    """
                                    Set the model transition mechanism.
                                    """
                                    return PyMenu(self.service, "/setup/models/multiphase/phases/set_domain_properties/interaction_domain/forces/model_transition").execute(*args, **kwargs)
                                def interfacial_area(self, *args, **kwargs):
                                    """
                                    Set the interfacial area parameters for each pair of phases.
                                    """
                                    return PyMenu(self.service, "/setup/models/multiphase/phases/set_domain_properties/interaction_domain/forces/interfacial_area").execute(*args, **kwargs)
                                def wall_lubrication(self, *args, **kwargs):
                                    """
                                    Specify the wall lubrication model for each primary-secondary phase pair.
                                    """
                                    return PyMenu(self.service, "/setup/models/multiphase/phases/set_domain_properties/interaction_domain/forces/wall_lubrication").execute(*args, **kwargs)

                                class virtual_mass(TUIMenu):
                                    """
                                    Enter the menu to set virtual mass models.
                                    """
                                    def __init__(self, path, service):
                                        self.path = path
                                        self.service = service
                                        super().__init__(path, service)
                                    def cavitation(self, *args, **kwargs):
                                        """
                                        Set the vaporization pressure, the surface tension coefficient, and the non-condensable gas mass fraction.
                                        """
                                        return PyMenu(self.service, "/setup/models/multiphase/phases/set_domain_properties/interaction_domain/forces/virtual_mass/cavitation").execute(*args, **kwargs)
                                    def interphase_visc_disp(self, *args, **kwargs):
                                        """
                                        Enable the interfacial viscous dissipation method, which introduces an artificial viscous damping term in the momentum equation?.
                                        """
                                        return PyMenu(self.service, "/setup/models/multiphase/phases/set_domain_properties/interaction_domain/forces/virtual_mass/interphase_visc_disp").execute(*args, **kwargs)
                                    def slope_limiter(self, *args, **kwargs):
                                        """
                                        Specify the slope limiter to set a specific discretization scheme. 0: first order upwind, 1: second order reconstruction bounded by the global minimum/maximum of the volume fraction, 2: compressive. Value between 0 and 2: blended scheme.
                                        """
                                        return PyMenu(self.service, "/setup/models/multiphase/phases/set_domain_properties/interaction_domain/forces/virtual_mass/slope_limiter").execute(*args, **kwargs)
                                    def lift(self, *args, **kwargs):
                                        """
                                        .
                                        """
                                        return PyMenu(self.service, "/setup/models/multiphase/phases/set_domain_properties/interaction_domain/forces/virtual_mass/lift").execute(*args, **kwargs)
                                    def lift_montoya(self, *args, **kwargs):
                                        """
                                        Include the Montoya correction for Lift.
                                        """
                                        return PyMenu(self.service, "/setup/models/multiphase/phases/set_domain_properties/interaction_domain/forces/virtual_mass/lift_montoya").execute(*args, **kwargs)
                                    def jump_adhesion(self, *args, **kwargs):
                                        """
                                        Enable the treatment of the contact angle specification at the porous jump boundary?.
                                        """
                                        return PyMenu(self.service, "/setup/models/multiphase/phases/set_domain_properties/interaction_domain/forces/virtual_mass/jump_adhesion").execute(*args, **kwargs)
                                    def interphase_discr(self, *args, **kwargs):
                                        """
                                        Enable the phase localized compressive discretization scheme where the degree of diffusion/sharpness is controlled through the value of the slope limiters?.
                                        """
                                        return PyMenu(self.service, "/setup/models/multiphase/phases/set_domain_properties/interaction_domain/forces/virtual_mass/interphase_discr").execute(*args, **kwargs)
                                    def vmass_implicit_options(self, *args, **kwargs):
                                        """
                                        Select the virtual mass implicit option.
                                        """
                                        return PyMenu(self.service, "/setup/models/multiphase/phases/set_domain_properties/interaction_domain/forces/virtual_mass/vmass_implicit_options").execute(*args, **kwargs)
                                    def vmass_implicit(self, *args, **kwargs):
                                        """
                                        Enable the implicit method for the virtual mass force?.
                                        """
                                        return PyMenu(self.service, "/setup/models/multiphase/phases/set_domain_properties/interaction_domain/forces/virtual_mass/vmass_implicit").execute(*args, **kwargs)
                                    def visc_disp_factor(self, *args, **kwargs):
                                        """
                                        Set the dissipation intensity.
                                        """
                                        return PyMenu(self.service, "/setup/models/multiphase/phases/set_domain_properties/interaction_domain/forces/virtual_mass/visc_disp_factor").execute(*args, **kwargs)
                                    def sfc_tension_coeff(self, *args, **kwargs):
                                        """
                                        Specify the surface tension coefficient for each pair of phases.
                                        """
                                        return PyMenu(self.service, "/setup/models/multiphase/phases/set_domain_properties/interaction_domain/forces/virtual_mass/sfc_tension_coeff").execute(*args, **kwargs)
                                    def lift_shaver_podowski(self, *args, **kwargs):
                                        """
                                        Include the Shaver-Podowski correction for Lift.
                                        """
                                        return PyMenu(self.service, "/setup/models/multiphase/phases/set_domain_properties/interaction_domain/forces/virtual_mass/lift_shaver_podowski").execute(*args, **kwargs)
                                    def sfc_modeling(self, *args, **kwargs):
                                        """
                                        Include the effects of surface tension along the fluid-fluid interface?.
                                        """
                                        return PyMenu(self.service, "/setup/models/multiphase/phases/set_domain_properties/interaction_domain/forces/virtual_mass/sfc_modeling").execute(*args, **kwargs)
                                    def sfc_model_type(self, *args, **kwargs):
                                        """
                                        Select the surface tension model.
                                        """
                                        return PyMenu(self.service, "/setup/models/multiphase/phases/set_domain_properties/interaction_domain/forces/virtual_mass/sfc_model_type").execute(*args, **kwargs)
                                    def virtual_mass(self, *args, **kwargs):
                                        """
                                        Include the virtual mass force that is present when a secondary phase accelerates relative to the primary phase?.
                                        """
                                        return PyMenu(self.service, "/setup/models/multiphase/phases/set_domain_properties/interaction_domain/forces/virtual_mass/virtual_mass").execute(*args, **kwargs)
                                    def wall_adhesion(self, *args, **kwargs):
                                        """
                                        Enable the specification for a wall adhesion angle?.
                                        """
                                        return PyMenu(self.service, "/setup/models/multiphase/phases/set_domain_properties/interaction_domain/forces/virtual_mass/wall_adhesion").execute(*args, **kwargs)
                                    def vmass_coeff(self, *args, **kwargs):
                                        """
                                        Specify the virtual mass coefficient for each pair of phases.
                                        """
                                        return PyMenu(self.service, "/setup/models/multiphase/phases/set_domain_properties/interaction_domain/forces/virtual_mass/vmass_coeff").execute(*args, **kwargs)

                                class interphase_discretization(TUIMenu):
                                    """
                                    Enter the menu to set interphase discretization models.
                                    """
                                    def __init__(self, path, service):
                                        self.path = path
                                        self.service = service
                                        super().__init__(path, service)
                                    def visc_disp_factor(self, *args, **kwargs):
                                        """
                                        Set the dissipation intensity.
                                        """
                                        return PyMenu(self.service, "/setup/models/multiphase/phases/set_domain_properties/interaction_domain/forces/interphase_discretization/visc_disp_factor").execute(*args, **kwargs)
                                    def vmass_implicit(self, *args, **kwargs):
                                        """
                                        Enable the implicit method for the virtual mass force?.
                                        """
                                        return PyMenu(self.service, "/setup/models/multiphase/phases/set_domain_properties/interaction_domain/forces/interphase_discretization/vmass_implicit").execute(*args, **kwargs)
                                    def lift(self, *args, **kwargs):
                                        """
                                        .
                                        """
                                        return PyMenu(self.service, "/setup/models/multiphase/phases/set_domain_properties/interaction_domain/forces/interphase_discretization/lift").execute(*args, **kwargs)
                                    def vmass_implicit_options(self, *args, **kwargs):
                                        """
                                        Select the virtual mass implicit option.
                                        """
                                        return PyMenu(self.service, "/setup/models/multiphase/phases/set_domain_properties/interaction_domain/forces/interphase_discretization/vmass_implicit_options").execute(*args, **kwargs)
                                    def virtual_mass(self, *args, **kwargs):
                                        """
                                        Include the virtual mass force that is present when a secondary phase accelerates relative to the primary phase?.
                                        """
                                        return PyMenu(self.service, "/setup/models/multiphase/phases/set_domain_properties/interaction_domain/forces/interphase_discretization/virtual_mass").execute(*args, **kwargs)
                                    def wall_adhesion(self, *args, **kwargs):
                                        """
                                        Enable the specification for a wall adhesion angle?.
                                        """
                                        return PyMenu(self.service, "/setup/models/multiphase/phases/set_domain_properties/interaction_domain/forces/interphase_discretization/wall_adhesion").execute(*args, **kwargs)
                                    def cavitation(self, *args, **kwargs):
                                        """
                                        Set the vaporization pressure, the surface tension coefficient, and the non-condensable gas mass fraction.
                                        """
                                        return PyMenu(self.service, "/setup/models/multiphase/phases/set_domain_properties/interaction_domain/forces/interphase_discretization/cavitation").execute(*args, **kwargs)
                                    def lift_montoya(self, *args, **kwargs):
                                        """
                                        Include the Montoya correction for Lift.
                                        """
                                        return PyMenu(self.service, "/setup/models/multiphase/phases/set_domain_properties/interaction_domain/forces/interphase_discretization/lift_montoya").execute(*args, **kwargs)
                                    def vmass_coeff(self, *args, **kwargs):
                                        """
                                        Specify the virtual mass coefficient for each pair of phases.
                                        """
                                        return PyMenu(self.service, "/setup/models/multiphase/phases/set_domain_properties/interaction_domain/forces/interphase_discretization/vmass_coeff").execute(*args, **kwargs)
                                    def sfc_model_type(self, *args, **kwargs):
                                        """
                                        Select the surface tension model.
                                        """
                                        return PyMenu(self.service, "/setup/models/multiphase/phases/set_domain_properties/interaction_domain/forces/interphase_discretization/sfc_model_type").execute(*args, **kwargs)
                                    def interphase_visc_disp(self, *args, **kwargs):
                                        """
                                        Enable the interfacial viscous dissipation method, which introduces an artificial viscous damping term in the momentum equation?.
                                        """
                                        return PyMenu(self.service, "/setup/models/multiphase/phases/set_domain_properties/interaction_domain/forces/interphase_discretization/interphase_visc_disp").execute(*args, **kwargs)
                                    def sfc_modeling(self, *args, **kwargs):
                                        """
                                        Include the effects of surface tension along the fluid-fluid interface?.
                                        """
                                        return PyMenu(self.service, "/setup/models/multiphase/phases/set_domain_properties/interaction_domain/forces/interphase_discretization/sfc_modeling").execute(*args, **kwargs)
                                    def jump_adhesion(self, *args, **kwargs):
                                        """
                                        Enable the treatment of the contact angle specification at the porous jump boundary?.
                                        """
                                        return PyMenu(self.service, "/setup/models/multiphase/phases/set_domain_properties/interaction_domain/forces/interphase_discretization/jump_adhesion").execute(*args, **kwargs)
                                    def sfc_tension_coeff(self, *args, **kwargs):
                                        """
                                        Specify the surface tension coefficient for each pair of phases.
                                        """
                                        return PyMenu(self.service, "/setup/models/multiphase/phases/set_domain_properties/interaction_domain/forces/interphase_discretization/sfc_tension_coeff").execute(*args, **kwargs)
                                    def interphase_discr(self, *args, **kwargs):
                                        """
                                        Enable the phase localized compressive discretization scheme where the degree of diffusion/sharpness is controlled through the value of the slope limiters?.
                                        """
                                        return PyMenu(self.service, "/setup/models/multiphase/phases/set_domain_properties/interaction_domain/forces/interphase_discretization/interphase_discr").execute(*args, **kwargs)
                                    def slope_limiter(self, *args, **kwargs):
                                        """
                                        Specify the slope limiter to set a specific discretization scheme. 0: first order upwind, 1: second order reconstruction bounded by the global minimum/maximum of the volume fraction, 2: compressive. Value between 0 and 2: blended scheme.
                                        """
                                        return PyMenu(self.service, "/setup/models/multiphase/phases/set_domain_properties/interaction_domain/forces/interphase_discretization/slope_limiter").execute(*args, **kwargs)
                                    def lift_shaver_podowski(self, *args, **kwargs):
                                        """
                                        Include the Shaver-Podowski correction for Lift.
                                        """
                                        return PyMenu(self.service, "/setup/models/multiphase/phases/set_domain_properties/interaction_domain/forces/interphase_discretization/lift_shaver_podowski").execute(*args, **kwargs)

                                class lift(TUIMenu):
                                    """
                                    Enter the menu to set lift models.
                                    """
                                    def __init__(self, path, service):
                                        self.path = path
                                        self.service = service
                                        super().__init__(path, service)
                                    def interphase_visc_disp(self, *args, **kwargs):
                                        """
                                        Enable the interfacial viscous dissipation method, which introduces an artificial viscous damping term in the momentum equation?.
                                        """
                                        return PyMenu(self.service, "/setup/models/multiphase/phases/set_domain_properties/interaction_domain/forces/lift/interphase_visc_disp").execute(*args, **kwargs)
                                    def sfc_modeling(self, *args, **kwargs):
                                        """
                                        Include the effects of surface tension along the fluid-fluid interface?.
                                        """
                                        return PyMenu(self.service, "/setup/models/multiphase/phases/set_domain_properties/interaction_domain/forces/lift/sfc_modeling").execute(*args, **kwargs)
                                    def vmass_implicit_options(self, *args, **kwargs):
                                        """
                                        Select the virtual mass implicit option.
                                        """
                                        return PyMenu(self.service, "/setup/models/multiphase/phases/set_domain_properties/interaction_domain/forces/lift/vmass_implicit_options").execute(*args, **kwargs)
                                    def visc_disp_factor(self, *args, **kwargs):
                                        """
                                        Set the dissipation intensity.
                                        """
                                        return PyMenu(self.service, "/setup/models/multiphase/phases/set_domain_properties/interaction_domain/forces/lift/visc_disp_factor").execute(*args, **kwargs)
                                    def lift_montoya(self, *args, **kwargs):
                                        """
                                        Include the Montoya correction for Lift.
                                        """
                                        return PyMenu(self.service, "/setup/models/multiphase/phases/set_domain_properties/interaction_domain/forces/lift/lift_montoya").execute(*args, **kwargs)
                                    def virtual_mass(self, *args, **kwargs):
                                        """
                                        Include the virtual mass force that is present when a secondary phase accelerates relative to the primary phase?.
                                        """
                                        return PyMenu(self.service, "/setup/models/multiphase/phases/set_domain_properties/interaction_domain/forces/lift/virtual_mass").execute(*args, **kwargs)
                                    def lift_shaver_podowski(self, *args, **kwargs):
                                        """
                                        Include the Shaver-Podowski correction for Lift.
                                        """
                                        return PyMenu(self.service, "/setup/models/multiphase/phases/set_domain_properties/interaction_domain/forces/lift/lift_shaver_podowski").execute(*args, **kwargs)
                                    def lift(self, *args, **kwargs):
                                        """
                                        .
                                        """
                                        return PyMenu(self.service, "/setup/models/multiphase/phases/set_domain_properties/interaction_domain/forces/lift/lift").execute(*args, **kwargs)
                                    def sfc_model_type(self, *args, **kwargs):
                                        """
                                        Select the surface tension model.
                                        """
                                        return PyMenu(self.service, "/setup/models/multiphase/phases/set_domain_properties/interaction_domain/forces/lift/sfc_model_type").execute(*args, **kwargs)
                                    def interphase_discr(self, *args, **kwargs):
                                        """
                                        Enable the phase localized compressive discretization scheme where the degree of diffusion/sharpness is controlled through the value of the slope limiters?.
                                        """
                                        return PyMenu(self.service, "/setup/models/multiphase/phases/set_domain_properties/interaction_domain/forces/lift/interphase_discr").execute(*args, **kwargs)
                                    def sfc_tension_coeff(self, *args, **kwargs):
                                        """
                                        Specify the surface tension coefficient for each pair of phases.
                                        """
                                        return PyMenu(self.service, "/setup/models/multiphase/phases/set_domain_properties/interaction_domain/forces/lift/sfc_tension_coeff").execute(*args, **kwargs)
                                    def cavitation(self, *args, **kwargs):
                                        """
                                        Set the vaporization pressure, the surface tension coefficient, and the non-condensable gas mass fraction.
                                        """
                                        return PyMenu(self.service, "/setup/models/multiphase/phases/set_domain_properties/interaction_domain/forces/lift/cavitation").execute(*args, **kwargs)
                                    def slope_limiter(self, *args, **kwargs):
                                        """
                                        Specify the slope limiter to set a specific discretization scheme. 0: first order upwind, 1: second order reconstruction bounded by the global minimum/maximum of the volume fraction, 2: compressive. Value between 0 and 2: blended scheme.
                                        """
                                        return PyMenu(self.service, "/setup/models/multiphase/phases/set_domain_properties/interaction_domain/forces/lift/slope_limiter").execute(*args, **kwargs)
                                    def wall_adhesion(self, *args, **kwargs):
                                        """
                                        Enable the specification for a wall adhesion angle?.
                                        """
                                        return PyMenu(self.service, "/setup/models/multiphase/phases/set_domain_properties/interaction_domain/forces/lift/wall_adhesion").execute(*args, **kwargs)
                                    def vmass_implicit(self, *args, **kwargs):
                                        """
                                        Enable the implicit method for the virtual mass force?.
                                        """
                                        return PyMenu(self.service, "/setup/models/multiphase/phases/set_domain_properties/interaction_domain/forces/lift/vmass_implicit").execute(*args, **kwargs)
                                    def jump_adhesion(self, *args, **kwargs):
                                        """
                                        Enable the treatment of the contact angle specification at the porous jump boundary?.
                                        """
                                        return PyMenu(self.service, "/setup/models/multiphase/phases/set_domain_properties/interaction_domain/forces/lift/jump_adhesion").execute(*args, **kwargs)
                                    def vmass_coeff(self, *args, **kwargs):
                                        """
                                        Specify the virtual mass coefficient for each pair of phases.
                                        """
                                        return PyMenu(self.service, "/setup/models/multiphase/phases/set_domain_properties/interaction_domain/forces/lift/vmass_coeff").execute(*args, **kwargs)

                                class cavitation(TUIMenu):
                                    """
                                    Enter the menu to set cavitation models.
                                    """
                                    def __init__(self, path, service):
                                        self.path = path
                                        self.service = service
                                        super().__init__(path, service)
                                    def sfc_tension_coeff(self, *args, **kwargs):
                                        """
                                        Specify the surface tension coefficient for each pair of phases.
                                        """
                                        return PyMenu(self.service, "/setup/models/multiphase/phases/set_domain_properties/interaction_domain/forces/cavitation/sfc_tension_coeff").execute(*args, **kwargs)
                                    def vmass_coeff(self, *args, **kwargs):
                                        """
                                        Specify the virtual mass coefficient for each pair of phases.
                                        """
                                        return PyMenu(self.service, "/setup/models/multiphase/phases/set_domain_properties/interaction_domain/forces/cavitation/vmass_coeff").execute(*args, **kwargs)
                                    def interphase_discr(self, *args, **kwargs):
                                        """
                                        Enable the phase localized compressive discretization scheme where the degree of diffusion/sharpness is controlled through the value of the slope limiters?.
                                        """
                                        return PyMenu(self.service, "/setup/models/multiphase/phases/set_domain_properties/interaction_domain/forces/cavitation/interphase_discr").execute(*args, **kwargs)
                                    def jump_adhesion(self, *args, **kwargs):
                                        """
                                        Enable the treatment of the contact angle specification at the porous jump boundary?.
                                        """
                                        return PyMenu(self.service, "/setup/models/multiphase/phases/set_domain_properties/interaction_domain/forces/cavitation/jump_adhesion").execute(*args, **kwargs)
                                    def vmass_implicit_options(self, *args, **kwargs):
                                        """
                                        Select the virtual mass implicit option.
                                        """
                                        return PyMenu(self.service, "/setup/models/multiphase/phases/set_domain_properties/interaction_domain/forces/cavitation/vmass_implicit_options").execute(*args, **kwargs)
                                    def vmass_implicit(self, *args, **kwargs):
                                        """
                                        Enable the implicit method for the virtual mass force?.
                                        """
                                        return PyMenu(self.service, "/setup/models/multiphase/phases/set_domain_properties/interaction_domain/forces/cavitation/vmass_implicit").execute(*args, **kwargs)
                                    def lift_montoya(self, *args, **kwargs):
                                        """
                                        Include the Montoya correction for Lift.
                                        """
                                        return PyMenu(self.service, "/setup/models/multiphase/phases/set_domain_properties/interaction_domain/forces/cavitation/lift_montoya").execute(*args, **kwargs)
                                    def lift(self, *args, **kwargs):
                                        """
                                        .
                                        """
                                        return PyMenu(self.service, "/setup/models/multiphase/phases/set_domain_properties/interaction_domain/forces/cavitation/lift").execute(*args, **kwargs)
                                    def virtual_mass(self, *args, **kwargs):
                                        """
                                        Include the virtual mass force that is present when a secondary phase accelerates relative to the primary phase?.
                                        """
                                        return PyMenu(self.service, "/setup/models/multiphase/phases/set_domain_properties/interaction_domain/forces/cavitation/virtual_mass").execute(*args, **kwargs)
                                    def sfc_modeling(self, *args, **kwargs):
                                        """
                                        Include the effects of surface tension along the fluid-fluid interface?.
                                        """
                                        return PyMenu(self.service, "/setup/models/multiphase/phases/set_domain_properties/interaction_domain/forces/cavitation/sfc_modeling").execute(*args, **kwargs)
                                    def interphase_visc_disp(self, *args, **kwargs):
                                        """
                                        Enable the interfacial viscous dissipation method, which introduces an artificial viscous damping term in the momentum equation?.
                                        """
                                        return PyMenu(self.service, "/setup/models/multiphase/phases/set_domain_properties/interaction_domain/forces/cavitation/interphase_visc_disp").execute(*args, **kwargs)
                                    def sfc_model_type(self, *args, **kwargs):
                                        """
                                        Select the surface tension model.
                                        """
                                        return PyMenu(self.service, "/setup/models/multiphase/phases/set_domain_properties/interaction_domain/forces/cavitation/sfc_model_type").execute(*args, **kwargs)
                                    def cavitation(self, *args, **kwargs):
                                        """
                                        Set the vaporization pressure, the surface tension coefficient, and the non-condensable gas mass fraction.
                                        """
                                        return PyMenu(self.service, "/setup/models/multiphase/phases/set_domain_properties/interaction_domain/forces/cavitation/cavitation").execute(*args, **kwargs)
                                    def lift_shaver_podowski(self, *args, **kwargs):
                                        """
                                        Include the Shaver-Podowski correction for Lift.
                                        """
                                        return PyMenu(self.service, "/setup/models/multiphase/phases/set_domain_properties/interaction_domain/forces/cavitation/lift_shaver_podowski").execute(*args, **kwargs)
                                    def visc_disp_factor(self, *args, **kwargs):
                                        """
                                        Set the dissipation intensity.
                                        """
                                        return PyMenu(self.service, "/setup/models/multiphase/phases/set_domain_properties/interaction_domain/forces/cavitation/visc_disp_factor").execute(*args, **kwargs)
                                    def slope_limiter(self, *args, **kwargs):
                                        """
                                        Specify the slope limiter to set a specific discretization scheme. 0: first order upwind, 1: second order reconstruction bounded by the global minimum/maximum of the volume fraction, 2: compressive. Value between 0 and 2: blended scheme.
                                        """
                                        return PyMenu(self.service, "/setup/models/multiphase/phases/set_domain_properties/interaction_domain/forces/cavitation/slope_limiter").execute(*args, **kwargs)
                                    def wall_adhesion(self, *args, **kwargs):
                                        """
                                        Enable the specification for a wall adhesion angle?.
                                        """
                                        return PyMenu(self.service, "/setup/models/multiphase/phases/set_domain_properties/interaction_domain/forces/cavitation/wall_adhesion").execute(*args, **kwargs)

                                class interphase_viscous_dissipation(TUIMenu):
                                    """
                                    Enter the menu to set interphase viscous dissipation related models.
                                    """
                                    def __init__(self, path, service):
                                        self.path = path
                                        self.service = service
                                        super().__init__(path, service)
                                    def vmass_coeff(self, *args, **kwargs):
                                        """
                                        Specify the virtual mass coefficient for each pair of phases.
                                        """
                                        return PyMenu(self.service, "/setup/models/multiphase/phases/set_domain_properties/interaction_domain/forces/interphase_viscous_dissipation/vmass_coeff").execute(*args, **kwargs)
                                    def lift_shaver_podowski(self, *args, **kwargs):
                                        """
                                        Include the Shaver-Podowski correction for Lift.
                                        """
                                        return PyMenu(self.service, "/setup/models/multiphase/phases/set_domain_properties/interaction_domain/forces/interphase_viscous_dissipation/lift_shaver_podowski").execute(*args, **kwargs)
                                    def wall_adhesion(self, *args, **kwargs):
                                        """
                                        Enable the specification for a wall adhesion angle?.
                                        """
                                        return PyMenu(self.service, "/setup/models/multiphase/phases/set_domain_properties/interaction_domain/forces/interphase_viscous_dissipation/wall_adhesion").execute(*args, **kwargs)
                                    def interphase_discr(self, *args, **kwargs):
                                        """
                                        Enable the phase localized compressive discretization scheme where the degree of diffusion/sharpness is controlled through the value of the slope limiters?.
                                        """
                                        return PyMenu(self.service, "/setup/models/multiphase/phases/set_domain_properties/interaction_domain/forces/interphase_viscous_dissipation/interphase_discr").execute(*args, **kwargs)
                                    def lift(self, *args, **kwargs):
                                        """
                                        .
                                        """
                                        return PyMenu(self.service, "/setup/models/multiphase/phases/set_domain_properties/interaction_domain/forces/interphase_viscous_dissipation/lift").execute(*args, **kwargs)
                                    def virtual_mass(self, *args, **kwargs):
                                        """
                                        Include the virtual mass force that is present when a secondary phase accelerates relative to the primary phase?.
                                        """
                                        return PyMenu(self.service, "/setup/models/multiphase/phases/set_domain_properties/interaction_domain/forces/interphase_viscous_dissipation/virtual_mass").execute(*args, **kwargs)
                                    def sfc_tension_coeff(self, *args, **kwargs):
                                        """
                                        Specify the surface tension coefficient for each pair of phases.
                                        """
                                        return PyMenu(self.service, "/setup/models/multiphase/phases/set_domain_properties/interaction_domain/forces/interphase_viscous_dissipation/sfc_tension_coeff").execute(*args, **kwargs)
                                    def sfc_modeling(self, *args, **kwargs):
                                        """
                                        Include the effects of surface tension along the fluid-fluid interface?.
                                        """
                                        return PyMenu(self.service, "/setup/models/multiphase/phases/set_domain_properties/interaction_domain/forces/interphase_viscous_dissipation/sfc_modeling").execute(*args, **kwargs)
                                    def interphase_visc_disp(self, *args, **kwargs):
                                        """
                                        Enable the interfacial viscous dissipation method, which introduces an artificial viscous damping term in the momentum equation?.
                                        """
                                        return PyMenu(self.service, "/setup/models/multiphase/phases/set_domain_properties/interaction_domain/forces/interphase_viscous_dissipation/interphase_visc_disp").execute(*args, **kwargs)
                                    def jump_adhesion(self, *args, **kwargs):
                                        """
                                        Enable the treatment of the contact angle specification at the porous jump boundary?.
                                        """
                                        return PyMenu(self.service, "/setup/models/multiphase/phases/set_domain_properties/interaction_domain/forces/interphase_viscous_dissipation/jump_adhesion").execute(*args, **kwargs)
                                    def vmass_implicit(self, *args, **kwargs):
                                        """
                                        Enable the implicit method for the virtual mass force?.
                                        """
                                        return PyMenu(self.service, "/setup/models/multiphase/phases/set_domain_properties/interaction_domain/forces/interphase_viscous_dissipation/vmass_implicit").execute(*args, **kwargs)
                                    def slope_limiter(self, *args, **kwargs):
                                        """
                                        Specify the slope limiter to set a specific discretization scheme. 0: first order upwind, 1: second order reconstruction bounded by the global minimum/maximum of the volume fraction, 2: compressive. Value between 0 and 2: blended scheme.
                                        """
                                        return PyMenu(self.service, "/setup/models/multiphase/phases/set_domain_properties/interaction_domain/forces/interphase_viscous_dissipation/slope_limiter").execute(*args, **kwargs)
                                    def cavitation(self, *args, **kwargs):
                                        """
                                        Set the vaporization pressure, the surface tension coefficient, and the non-condensable gas mass fraction.
                                        """
                                        return PyMenu(self.service, "/setup/models/multiphase/phases/set_domain_properties/interaction_domain/forces/interphase_viscous_dissipation/cavitation").execute(*args, **kwargs)
                                    def vmass_implicit_options(self, *args, **kwargs):
                                        """
                                        Select the virtual mass implicit option.
                                        """
                                        return PyMenu(self.service, "/setup/models/multiphase/phases/set_domain_properties/interaction_domain/forces/interphase_viscous_dissipation/vmass_implicit_options").execute(*args, **kwargs)
                                    def visc_disp_factor(self, *args, **kwargs):
                                        """
                                        Set the dissipation intensity.
                                        """
                                        return PyMenu(self.service, "/setup/models/multiphase/phases/set_domain_properties/interaction_domain/forces/interphase_viscous_dissipation/visc_disp_factor").execute(*args, **kwargs)
                                    def lift_montoya(self, *args, **kwargs):
                                        """
                                        Include the Montoya correction for Lift.
                                        """
                                        return PyMenu(self.service, "/setup/models/multiphase/phases/set_domain_properties/interaction_domain/forces/interphase_viscous_dissipation/lift_montoya").execute(*args, **kwargs)
                                    def sfc_model_type(self, *args, **kwargs):
                                        """
                                        Select the surface tension model.
                                        """
                                        return PyMenu(self.service, "/setup/models/multiphase/phases/set_domain_properties/interaction_domain/forces/interphase_viscous_dissipation/sfc_model_type").execute(*args, **kwargs)

                                class surface_tension(TUIMenu):
                                    """
                                    Enter the menu to set surface tension models.
                                    """
                                    def __init__(self, path, service):
                                        self.path = path
                                        self.service = service
                                        super().__init__(path, service)
                                    def sfc_tension_coeff(self, *args, **kwargs):
                                        """
                                        Specify the surface tension coefficient for each pair of phases.
                                        """
                                        return PyMenu(self.service, "/setup/models/multiphase/phases/set_domain_properties/interaction_domain/forces/surface_tension/sfc_tension_coeff").execute(*args, **kwargs)
                                    def cavitation(self, *args, **kwargs):
                                        """
                                        Set the vaporization pressure, the surface tension coefficient, and the non-condensable gas mass fraction.
                                        """
                                        return PyMenu(self.service, "/setup/models/multiphase/phases/set_domain_properties/interaction_domain/forces/surface_tension/cavitation").execute(*args, **kwargs)
                                    def sfc_modeling(self, *args, **kwargs):
                                        """
                                        Include the effects of surface tension along the fluid-fluid interface?.
                                        """
                                        return PyMenu(self.service, "/setup/models/multiphase/phases/set_domain_properties/interaction_domain/forces/surface_tension/sfc_modeling").execute(*args, **kwargs)
                                    def slope_limiter(self, *args, **kwargs):
                                        """
                                        Specify the slope limiter to set a specific discretization scheme. 0: first order upwind, 1: second order reconstruction bounded by the global minimum/maximum of the volume fraction, 2: compressive. Value between 0 and 2: blended scheme.
                                        """
                                        return PyMenu(self.service, "/setup/models/multiphase/phases/set_domain_properties/interaction_domain/forces/surface_tension/slope_limiter").execute(*args, **kwargs)
                                    def visc_disp_factor(self, *args, **kwargs):
                                        """
                                        Set the dissipation intensity.
                                        """
                                        return PyMenu(self.service, "/setup/models/multiphase/phases/set_domain_properties/interaction_domain/forces/surface_tension/visc_disp_factor").execute(*args, **kwargs)
                                    def sfc_model_type(self, *args, **kwargs):
                                        """
                                        Select the surface tension model.
                                        """
                                        return PyMenu(self.service, "/setup/models/multiphase/phases/set_domain_properties/interaction_domain/forces/surface_tension/sfc_model_type").execute(*args, **kwargs)
                                    def interphase_discr(self, *args, **kwargs):
                                        """
                                        Enable the phase localized compressive discretization scheme where the degree of diffusion/sharpness is controlled through the value of the slope limiters?.
                                        """
                                        return PyMenu(self.service, "/setup/models/multiphase/phases/set_domain_properties/interaction_domain/forces/surface_tension/interphase_discr").execute(*args, **kwargs)
                                    def lift(self, *args, **kwargs):
                                        """
                                        .
                                        """
                                        return PyMenu(self.service, "/setup/models/multiphase/phases/set_domain_properties/interaction_domain/forces/surface_tension/lift").execute(*args, **kwargs)
                                    def lift_montoya(self, *args, **kwargs):
                                        """
                                        Include the Montoya correction for Lift.
                                        """
                                        return PyMenu(self.service, "/setup/models/multiphase/phases/set_domain_properties/interaction_domain/forces/surface_tension/lift_montoya").execute(*args, **kwargs)
                                    def lift_shaver_podowski(self, *args, **kwargs):
                                        """
                                        Include the Shaver-Podowski correction for Lift.
                                        """
                                        return PyMenu(self.service, "/setup/models/multiphase/phases/set_domain_properties/interaction_domain/forces/surface_tension/lift_shaver_podowski").execute(*args, **kwargs)
                                    def vmass_implicit(self, *args, **kwargs):
                                        """
                                        Enable the implicit method for the virtual mass force?.
                                        """
                                        return PyMenu(self.service, "/setup/models/multiphase/phases/set_domain_properties/interaction_domain/forces/surface_tension/vmass_implicit").execute(*args, **kwargs)
                                    def vmass_implicit_options(self, *args, **kwargs):
                                        """
                                        Select the virtual mass implicit option.
                                        """
                                        return PyMenu(self.service, "/setup/models/multiphase/phases/set_domain_properties/interaction_domain/forces/surface_tension/vmass_implicit_options").execute(*args, **kwargs)
                                    def virtual_mass(self, *args, **kwargs):
                                        """
                                        Include the virtual mass force that is present when a secondary phase accelerates relative to the primary phase?.
                                        """
                                        return PyMenu(self.service, "/setup/models/multiphase/phases/set_domain_properties/interaction_domain/forces/surface_tension/virtual_mass").execute(*args, **kwargs)
                                    def jump_adhesion(self, *args, **kwargs):
                                        """
                                        Enable the treatment of the contact angle specification at the porous jump boundary?.
                                        """
                                        return PyMenu(self.service, "/setup/models/multiphase/phases/set_domain_properties/interaction_domain/forces/surface_tension/jump_adhesion").execute(*args, **kwargs)
                                    def interphase_visc_disp(self, *args, **kwargs):
                                        """
                                        Enable the interfacial viscous dissipation method, which introduces an artificial viscous damping term in the momentum equation?.
                                        """
                                        return PyMenu(self.service, "/setup/models/multiphase/phases/set_domain_properties/interaction_domain/forces/surface_tension/interphase_visc_disp").execute(*args, **kwargs)
                                    def vmass_coeff(self, *args, **kwargs):
                                        """
                                        Specify the virtual mass coefficient for each pair of phases.
                                        """
                                        return PyMenu(self.service, "/setup/models/multiphase/phases/set_domain_properties/interaction_domain/forces/surface_tension/vmass_coeff").execute(*args, **kwargs)
                                    def wall_adhesion(self, *args, **kwargs):
                                        """
                                        Enable the specification for a wall adhesion angle?.
                                        """
                                        return PyMenu(self.service, "/setup/models/multiphase/phases/set_domain_properties/interaction_domain/forces/surface_tension/wall_adhesion").execute(*args, **kwargs)

                class flow_regime_modeling(TUIMenu):
                    """
                    Flow Regime Modeling.
                    """
                    def __init__(self, path, service):
                        self.path = path
                        self.service = service
                        self.aiad_parameters = self.__class__.aiad_parameters(path + ["aiad_parameters"], service)
                        super().__init__(path, service)
                    def enable(self, *args, **kwargs):
                        """
                        Enable flow regime modeling framework including phase state and morphology.
                        """
                        return PyMenu(self.service, "/setup/models/multiphase/flow_regime_modeling/enable").execute(*args, **kwargs)

                    class aiad_parameters(TUIMenu):
                        """
                        AIAD parameters.
                        """
                        def __init__(self, path, service):
                            self.path = path
                            self.service = service
                            super().__init__(path, service)
                        def ncells_fs(self, *args, **kwargs):
                            """
                            Parameter for determining interfacial width.
                            """
                            return PyMenu(self.service, "/setup/models/multiphase/flow_regime_modeling/aiad_parameters/ncells_fs").execute(*args, **kwargs)
                        def critical_vf(self, *args, **kwargs):
                            """
                            Critical volume fraction for bubbly and droplet flow blending factors.
                            """
                            return PyMenu(self.service, "/setup/models/multiphase/flow_regime_modeling/aiad_parameters/critical_vf").execute(*args, **kwargs)
                        def delta_vf(self, *args, **kwargs):
                            """
                            Parameter for transition width for bubbly and droplet flow blending factors.
                            """
                            return PyMenu(self.service, "/setup/models/multiphase/flow_regime_modeling/aiad_parameters/delta_vf").execute(*args, **kwargs)
                        def delta_grad(self, *args, **kwargs):
                            """
                            Parameter for determining transition width for free surface blending factor.
                            """
                            return PyMenu(self.service, "/setup/models/multiphase/flow_regime_modeling/aiad_parameters/delta_grad").execute(*args, **kwargs)

            class two_temperature(TUIMenu):
                """
                Define two-temperature model menu.
                """
                def __init__(self, path, service):
                    self.path = path
                    self.service = service
                    super().__init__(path, service)
                def weak_ionization(self, *args, **kwargs):
                    """
                    Apply weak ionization in the two-temperature model.
                    """
                    return PyMenu(self.service, "/setup/models/two_temperature/weak_ionization").execute(*args, **kwargs)
                def nasa9_enhancement(self, *args, **kwargs):
                    """
                    Apply nasa9 robustness enhancements in the two-temperature model.
                    """
                    return PyMenu(self.service, "/setup/models/two_temperature/nasa9_enhancement").execute(*args, **kwargs)
                def set_verbosity(self, *args, **kwargs):
                    """
                    Set two-temperature model verbosity option.
                    """
                    return PyMenu(self.service, "/setup/models/two_temperature/set_verbosity").execute(*args, **kwargs)
                def robustness_enhancement(self, *args, **kwargs):
                    """
                    Apply robustness enhancements in the two-temperature model.
                    """
                    return PyMenu(self.service, "/setup/models/two_temperature/robustness_enhancement").execute(*args, **kwargs)
                def enable(self, *args, **kwargs):
                    """
                    Enable/disable the two-temperature model.
                    """
                    return PyMenu(self.service, "/setup/models/two_temperature/enable").execute(*args, **kwargs)

            class radiation(TUIMenu):
                """
                Enter the radiation models menu.
                """
                def __init__(self, path, service):
                    self.path = path
                    self.service = service
                    self.dtrm_parameters = self.__class__.dtrm_parameters(path + ["dtrm_parameters"], service)
                    self.s2s_parameters = self.__class__.s2s_parameters(path + ["s2s_parameters"], service)
                    self.solar_parameters = self.__class__.solar_parameters(path + ["solar_parameters"], service)
                    super().__init__(path, service)
                def s2s(self, *args, **kwargs):
                    """
                    Enable/disable the S2S radiation model.
                    """
                    return PyMenu(self.service, "/setup/models/radiation/s2s").execute(*args, **kwargs)
                def discrete_ordinates(self, *args, **kwargs):
                    """
                    Enable/disable the discrete ordinates radiation model.
                    """
                    return PyMenu(self.service, "/setup/models/radiation/discrete_ordinates").execute(*args, **kwargs)
                def wsggm_cell_based(self, *args, **kwargs):
                    """
                    Enable/disable WSGGM cell based method.
                    """
                    return PyMenu(self.service, "/setup/models/radiation/wsggm_cell_based").execute(*args, **kwargs)
                def method_partially_specular_wall(self, *args, **kwargs):
                    """
                    Set method for partially specular wall with discrete ordinate model.
                    """
                    return PyMenu(self.service, "/setup/models/radiation/method_partially_specular_wall").execute(*args, **kwargs)
                def solar(self, *args, **kwargs):
                    """
                    Enable/disable the solar model.
                    """
                    return PyMenu(self.service, "/setup/models/radiation/solar").execute(*args, **kwargs)
                def p1(self, *args, **kwargs):
                    """
                    Enable/disable the P1 radiation model.
                    """
                    return PyMenu(self.service, "/setup/models/radiation/p1").execute(*args, **kwargs)
                def montecarlo(self, *args, **kwargs):
                    """
                    Enable/disable the Monte Carlo radiation model.
                    """
                    return PyMenu(self.service, "/setup/models/radiation/montecarlo").execute(*args, **kwargs)
                def do_coupling(self, *args, **kwargs):
                    """
                    Enabled DO Energy Coupling.
                    """
                    return PyMenu(self.service, "/setup/models/radiation/do_coupling").execute(*args, **kwargs)
                def apply_full_solar_irradiation(self, *args, **kwargs):
                    """
                    Enable/disable application of solar irradiation to first band with DO model.
                    """
                    return PyMenu(self.service, "/setup/models/radiation/apply_full_solar_irradiation").execute(*args, **kwargs)
                def non_gray_model_parameters(self, *args, **kwargs):
                    """
                    Set parameters for non-gray model.
                    """
                    return PyMenu(self.service, "/setup/models/radiation/non_gray_model_parameters").execute(*args, **kwargs)
                def mc_model_parameters(self, *args, **kwargs):
                    """
                    Set parameters for montecarlo radiation model.
                    """
                    return PyMenu(self.service, "/setup/models/radiation/mc_model_parameters").execute(*args, **kwargs)
                def solar_calculator(self, *args, **kwargs):
                    """
                    Calculate sun direction and intensity.
                    """
                    return PyMenu(self.service, "/setup/models/radiation/solar_calculator").execute(*args, **kwargs)
                def solar_irradiation(self, *args, **kwargs):
                    """
                    Enable/disable the Solar irradiation model.
                    """
                    return PyMenu(self.service, "/setup/models/radiation/solar_irradiation").execute(*args, **kwargs)
                def blending_factor(self, *args, **kwargs):
                    """
                    Set numeric option for Discrete Ordinate model.
                    """
                    return PyMenu(self.service, "/setup/models/radiation/blending_factor").execute(*args, **kwargs)
                def discrete_transfer(self, *args, **kwargs):
                    """
                    Enable/disable discrete the transfer radiation model.
                    """
                    return PyMenu(self.service, "/setup/models/radiation/discrete_transfer").execute(*args, **kwargs)
                def do_acceleration(self, *args, **kwargs):
                    """
                    Enable/disable acceleration of computation of DO model.
                    """
                    return PyMenu(self.service, "/setup/models/radiation/do_acceleration").execute(*args, **kwargs)
                def mc_under_relaxation(self, *args, **kwargs):
                    """
                    Set under-relaxation factor for montecarlo radiation sources used in the energy equation.
                    """
                    return PyMenu(self.service, "/setup/models/radiation/mc_under_relaxation").execute(*args, **kwargs)
                def radiation_iteration_parameters(self, *args, **kwargs):
                    """
                    Set iteration parameters for radiation models.
                    """
                    return PyMenu(self.service, "/setup/models/radiation/radiation_iteration_parameters").execute(*args, **kwargs)
                def fast_second_order_discrete_ordinate(self, *args, **kwargs):
                    """
                    Enable/disable the fast-second-order option for Discrete Ordinate Model.
                    """
                    return PyMenu(self.service, "/setup/models/radiation/fast_second_order_discrete_ordinate").execute(*args, **kwargs)
                def target_cells_per_volume_cluster(self, *args, **kwargs):
                    """
                    Enter cells per volume cluster for Monte Carlo radiation model.
                    """
                    return PyMenu(self.service, "/setup/models/radiation/target_cells_per_volume_cluster").execute(*args, **kwargs)
                def radiation_model_parameters(self, *args, **kwargs):
                    """
                    Set parameters for radiation models.
                    """
                    return PyMenu(self.service, "/setup/models/radiation/radiation_model_parameters").execute(*args, **kwargs)
                def rosseland(self, *args, **kwargs):
                    """
                    Enable/disable the Rosseland radiation model.
                    """
                    return PyMenu(self.service, "/setup/models/radiation/rosseland").execute(*args, **kwargs)
                def solution_method_for_do_coupling(self, *args, **kwargs):
                    """
                    Enable the solution method for DO/Energy  Coupling.
                    """
                    return PyMenu(self.service, "/setup/models/radiation/solution_method_for_do_coupling").execute(*args, **kwargs)
                def beta_radiation_features(self, *args, **kwargs):
                    """
                    Enable Radiation Models with Non-Iterative Time Advancement (NITA) as Beta features in FL12.0.
                    """
                    return PyMenu(self.service, "/setup/models/radiation/beta_radiation_features").execute(*args, **kwargs)

                class dtrm_parameters(TUIMenu):
                    """
                    Enter the DTRM parameters menu.
                    """
                    def __init__(self, path, service):
                        self.path = path
                        self.service = service
                        super().__init__(path, service)
                    def make_globs(self, *args, **kwargs):
                        """
                        Make globs (coarser mesh) for radiation.
                        """
                        return PyMenu(self.service, "/setup/models/radiation/dtrm_parameters/make_globs").execute(*args, **kwargs)
                    def controls(self, *args, **kwargs):
                        """
                        Set DTRM solution controls.
                        """
                        return PyMenu(self.service, "/setup/models/radiation/dtrm_parameters/controls").execute(*args, **kwargs)
                    def check_ray_file(self, *args, **kwargs):
                        """
                        Read DTRM rays file.
                        """
                        return PyMenu(self.service, "/setup/models/radiation/dtrm_parameters/check_ray_file").execute(*args, **kwargs)
                    def ray_trace(self, *args, **kwargs):
                        """
                        Create DTRM rays for radiation.
                        """
                        return PyMenu(self.service, "/setup/models/radiation/dtrm_parameters/ray_trace").execute(*args, **kwargs)

                class s2s_parameters(TUIMenu):
                    """
                    Enter the S2S parameters menu.
                    """
                    def __init__(self, path, service):
                        self.path = path
                        self.service = service
                        super().__init__(path, service)
                    def compute_vf_accelerated(self, *args, **kwargs):
                        """
                        Compute/Write view factors from existing surface clusters.
                        """
                        return PyMenu(self.service, "/setup/models/radiation/s2s_parameters/compute_vf_accelerated").execute(*args, **kwargs)
                    def print_thread_clusters(self, *args, **kwargs):
                        """
                        Prints the following for all boundary threads: thread-id, number of faces, faces per surface cluster, and the number of surface clusters.
                        """
                        return PyMenu(self.service, "/setup/models/radiation/s2s_parameters/print_thread_clusters").execute(*args, **kwargs)
                    def compute_write_vf(self, *args, **kwargs):
                        """
                        Compute/write surface clusters and view factors for S2S radiation model.
                        """
                        return PyMenu(self.service, "/setup/models/radiation/s2s_parameters/compute_write_vf").execute(*args, **kwargs)
                    def enable_mesh_interface_clustering(self, *args, **kwargs):
                        """
                        Enable clustering on mesh interfaces?.
                        """
                        return PyMenu(self.service, "/setup/models/radiation/s2s_parameters/enable_mesh_interface_clustering").execute(*args, **kwargs)
                    def split_angle(self, *args, **kwargs):
                        """
                        Set the split angle for the clustering algorithm.
                        """
                        return PyMenu(self.service, "/setup/models/radiation/s2s_parameters/split_angle").execute(*args, **kwargs)
                    def compute_vf_only(self, *args, **kwargs):
                        """
                        Compute/write view factors only.
                        """
                        return PyMenu(self.service, "/setup/models/radiation/s2s_parameters/compute_vf_only").execute(*args, **kwargs)
                    def set_vf_parameters(self, *args, **kwargs):
                        """
                        Set the parameters needed for the view factor calculations.
                        """
                        return PyMenu(self.service, "/setup/models/radiation/s2s_parameters/set_vf_parameters").execute(*args, **kwargs)
                    def set_global_faces_per_surface_cluster(self, *args, **kwargs):
                        """
                        Set global value of faces per surface cluster for all boundary zones.
                        """
                        return PyMenu(self.service, "/setup/models/radiation/s2s_parameters/set_global_faces_per_surface_cluster").execute(*args, **kwargs)
                    def read_vf_file(self, *args, **kwargs):
                        """
                        Read an S2S file.
                        """
                        return PyMenu(self.service, "/setup/models/radiation/s2s_parameters/read_vf_file").execute(*args, **kwargs)
                    def print_zonewise_radiation(self, *args, **kwargs):
                        """
                        Prints the zonewise incoming radiation, viewfactors, and average temperature.
                        """
                        return PyMenu(self.service, "/setup/models/radiation/s2s_parameters/print_zonewise_radiation").execute(*args, **kwargs)
                    def non_participating_boundary_zones_temperature(self, *args, **kwargs):
                        """
                        Set temperature for the non-participating boundary zones.
                        """
                        return PyMenu(self.service, "/setup/models/radiation/s2s_parameters/non_participating_boundary_zones_temperature").execute(*args, **kwargs)
                    def compute_clusters_and_vf_accelerated(self, *args, **kwargs):
                        """
                        Compute/Write surface cluster first and then view factors.
                        """
                        return PyMenu(self.service, "/setup/models/radiation/s2s_parameters/compute_clusters_and_vf_accelerated").execute(*args, **kwargs)
                    def use_old_cluster_algorithm(self, *args, **kwargs):
                        """
                        Use the old surface clustering algorithm.
                        """
                        return PyMenu(self.service, "/setup/models/radiation/s2s_parameters/use_old_cluster_algorithm").execute(*args, **kwargs)
                    def compute_fpsc_values(self, *args, **kwargs):
                        """
                        Compute only fpsc values based on current settings.
                        """
                        return PyMenu(self.service, "/setup/models/radiation/s2s_parameters/compute_fpsc_values").execute(*args, **kwargs)
                    def use_new_cluster_algorithm(self, *args, **kwargs):
                        """
                        Use the new surface clustering algorithm.
                        """
                        return PyMenu(self.service, "/setup/models/radiation/s2s_parameters/use_new_cluster_algorithm").execute(*args, **kwargs)

                class solar_parameters(TUIMenu):
                    """
                    Enter the solar parameters menu.
                    """
                    def __init__(self, path, service):
                        self.path = path
                        self.service = service
                        super().__init__(path, service)
                    def solar_thread_control(self, *args, **kwargs):
                        """
                        Solar thread control.
                        """
                        return PyMenu(self.service, "/setup/models/radiation/solar_parameters/solar_thread_control").execute(*args, **kwargs)
                    def illumination_parameters(self, *args, **kwargs):
                        """
                        Set illumination parameters.
                        """
                        return PyMenu(self.service, "/setup/models/radiation/solar_parameters/illumination_parameters").execute(*args, **kwargs)
                    def ground_reflectivity(self, *args, **kwargs):
                        """
                        Set ground reflectivity parameters.
                        """
                        return PyMenu(self.service, "/setup/models/radiation/solar_parameters/ground_reflectivity").execute(*args, **kwargs)
                    def sun_direction_vector(self, *args, **kwargs):
                        """
                        Set sun direction vector.
                        """
                        return PyMenu(self.service, "/setup/models/radiation/solar_parameters/sun_direction_vector").execute(*args, **kwargs)
                    def scattering_fraction(self, *args, **kwargs):
                        """
                        Set scattering fraction parameters.
                        """
                        return PyMenu(self.service, "/setup/models/radiation/solar_parameters/scattering_fraction").execute(*args, **kwargs)
                    def autosave_solar_data(self, *args, **kwargs):
                        """
                        Set autosave solar data parameters.
                        """
                        return PyMenu(self.service, "/setup/models/radiation/solar_parameters/autosave_solar_data").execute(*args, **kwargs)
                    def autoread_solar_data(self, *args, **kwargs):
                        """
                        Set autoread solar data parameters.
                        """
                        return PyMenu(self.service, "/setup/models/radiation/solar_parameters/autoread_solar_data").execute(*args, **kwargs)
                    def use_direction_from_sol_calc(self, *args, **kwargs):
                        """
                        Set direction computed from solar calculator.
                        """
                        return PyMenu(self.service, "/setup/models/radiation/solar_parameters/use_direction_from_sol_calc").execute(*args, **kwargs)
                    def sol_on_demand(self, *args, **kwargs):
                        """
                        Enable  solar load on demand.
                        """
                        return PyMenu(self.service, "/setup/models/radiation/solar_parameters/sol_on_demand").execute(*args, **kwargs)
                    def sol_camera_pos(self, *args, **kwargs):
                        """
                        Set camera position based on sun direction vector.
                        """
                        return PyMenu(self.service, "/setup/models/radiation/solar_parameters/sol_camera_pos").execute(*args, **kwargs)
                    def quad_tree_parameters(self, *args, **kwargs):
                        """
                        Set quad-tree refinement parameters.
                        """
                        return PyMenu(self.service, "/setup/models/radiation/solar_parameters/quad_tree_parameters").execute(*args, **kwargs)
                    def iteration_parameters(self, *args, **kwargs):
                        """
                        Set update parameters.
                        """
                        return PyMenu(self.service, "/setup/models/radiation/solar_parameters/iteration_parameters").execute(*args, **kwargs)
                    def sol_adjacent_fluidcells(self, *args, **kwargs):
                        """
                        Enable solar load for adjacent fluid cells.
                        """
                        return PyMenu(self.service, "/setup/models/radiation/solar_parameters/sol_adjacent_fluidcells").execute(*args, **kwargs)

            class nox_parameters(TUIMenu):
                """
                Enter the NOx parameters menu.
                """
                def __init__(self, path, service):
                    self.path = path
                    self.service = service
                    super().__init__(path, service)
                def nox_turbulence_interaction(self, *args, **kwargs):
                    """
                    Set NOx-turbulence interaction model.
                    """
                    return PyMenu(self.service, "/setup/models/nox_parameters/nox_turbulence_interaction").execute(*args, **kwargs)
                def inlet_diffusion(self, *args, **kwargs):
                    """
                    Enable/disable inclusion of diffusion at inlets.
                    """
                    return PyMenu(self.service, "/setup/models/nox_parameters/inlet_diffusion").execute(*args, **kwargs)
                def nox_expert(self, *args, **kwargs):
                    """
                    Select additional nox equations.
                    """
                    return PyMenu(self.service, "/setup/models/nox_parameters/nox_expert").execute(*args, **kwargs)
                def nox_chemistry(self, *args, **kwargs):
                    """
                    Select NOx chemistry model.
                    """
                    return PyMenu(self.service, "/setup/models/nox_parameters/nox_chemistry").execute(*args, **kwargs)

            class eulerian_wallfilm(TUIMenu):
                """
                Enter the Eulerian wall film model menu.
                """
                def __init__(self, path, service):
                    self.path = path
                    self.service = service
                    self.implicit_options = self.__class__.implicit_options(path + ["implicit_options"], service)
                    self.coupled_solution = self.__class__.coupled_solution(path + ["coupled_solution"], service)
                    super().__init__(path, service)
                def list_film_walls(self, *args, **kwargs):
                    """
                    List film walls.
                    """
                    return PyMenu(self.service, "/setup/models/eulerian_wallfilm/list_film_walls").execute(*args, **kwargs)
                def enable_film_vof_transition_message(self, *args, **kwargs):
                    """
                    Enable film-VOF transition message.
                    """
                    return PyMenu(self.service, "/setup/models/eulerian_wallfilm/enable_film_vof_transition_message").execute(*args, **kwargs)
                def model_options(self, *args, **kwargs):
                    """
                    Set Eulerian wall film model options.
                    """
                    return PyMenu(self.service, "/setup/models/eulerian_wallfilm/model_options").execute(*args, **kwargs)
                def initialize_wallfilm_model(self, *args, **kwargs):
                    """
                    Initialize Eulerian wall film model.
                    """
                    return PyMenu(self.service, "/setup/models/eulerian_wallfilm/initialize_wallfilm_model").execute(*args, **kwargs)
                def solve_wallfilm_equation(self, *args, **kwargs):
                    """
                    Activate Eulerian wall film equations.
                    """
                    return PyMenu(self.service, "/setup/models/eulerian_wallfilm/solve_wallfilm_equation").execute(*args, **kwargs)
                def enable_wallfilm_model(self, *args, **kwargs):
                    """
                    Enable Eulerian wall film model.
                    """
                    return PyMenu(self.service, "/setup/models/eulerian_wallfilm/enable_wallfilm_model").execute(*args, **kwargs)
                def film_material(self, *args, **kwargs):
                    """
                    Set film material and properties.
                    """
                    return PyMenu(self.service, "/setup/models/eulerian_wallfilm/film_material").execute(*args, **kwargs)
                def solution_options(self, *args, **kwargs):
                    """
                    Set Eulerian wall film model solution options.
                    """
                    return PyMenu(self.service, "/setup/models/eulerian_wallfilm/solution_options").execute(*args, **kwargs)

                class implicit_options(TUIMenu):
                    """
                    Enter Implicit Scheme Option (beta).
                    """
                    def __init__(self, path, service):
                        self.path = path
                        self.service = service
                        super().__init__(path, service)
                    def relative_error_residual(self, *args, **kwargs):
                        """
                        Enable relative error residual.
                        """
                        return PyMenu(self.service, "/setup/models/eulerian_wallfilm/implicit_options/relative_error_residual").execute(*args, **kwargs)
                    def new_implicit_scheme(self, *args, **kwargs):
                        """
                        Enable alternative implicit scheme.
                        """
                        return PyMenu(self.service, "/setup/models/eulerian_wallfilm/implicit_options/new_implicit_scheme").execute(*args, **kwargs)

                class coupled_solution(TUIMenu):
                    """
                    Enter Eulerian wall film coupled solution menu.
                    """
                    def __init__(self, path, service):
                        self.path = path
                        self.service = service
                        super().__init__(path, service)
                    def enable_curvature_smoothing(self, *args, **kwargs):
                        """
                        Enable Eulerian wall film curvature smoothing.
                        """
                        return PyMenu(self.service, "/setup/models/eulerian_wallfilm/coupled_solution/enable_curvature_smoothing").execute(*args, **kwargs)
                    def enable_coupled_solution(self, *args, **kwargs):
                        """
                        Enable Eulerian wall film coupled solution.
                        """
                        return PyMenu(self.service, "/setup/models/eulerian_wallfilm/coupled_solution/enable_coupled_solution").execute(*args, **kwargs)

            class soot_parameters(TUIMenu):
                """
                Enter the soot parameters menu.
                """
                def __init__(self, path, service):
                    self.path = path
                    self.service = service
                    super().__init__(path, service)
                def soot_process_parameters(self, *args, **kwargs):
                    """
                    Set soot process parameters.
                    """
                    return PyMenu(self.service, "/setup/models/soot_parameters/soot_process_parameters").execute(*args, **kwargs)
                def inlet_diffusion(self, *args, **kwargs):
                    """
                    Enable/disable inclusion of diffusion at inlets.
                    """
                    return PyMenu(self.service, "/setup/models/soot_parameters/inlet_diffusion").execute(*args, **kwargs)
                def soot_turbulence_interaction(self, *args, **kwargs):
                    """
                    Set Soot-turbulence interaction model.
                    """
                    return PyMenu(self.service, "/setup/models/soot_parameters/soot_turbulence_interaction").execute(*args, **kwargs)
                def soot_radiation_interaction(self, *args, **kwargs):
                    """
                    Enable/disable the soot-radiation interaction model.
                    """
                    return PyMenu(self.service, "/setup/models/soot_parameters/soot_radiation_interaction").execute(*args, **kwargs)
                def modify_schmidt_number(self, *args, **kwargs):
                    """
                    Change Turbulent Schmidt Number for Soot/Nuclei Equations.
                    """
                    return PyMenu(self.service, "/setup/models/soot_parameters/modify_schmidt_number").execute(*args, **kwargs)
                def soot_model_udfs(self, *args, **kwargs):
                    """
                    User defined functions for soot model.
                    """
                    return PyMenu(self.service, "/setup/models/soot_parameters/soot_model_udfs").execute(*args, **kwargs)
                def soot_model_parameters(self, *args, **kwargs):
                    """
                    Enter the soot model parameters menu.
                    """
                    return PyMenu(self.service, "/setup/models/soot_parameters/soot_model_parameters").execute(*args, **kwargs)

            class cht(TUIMenu):
                """
                Enter the mapped interface model menu.
                """
                def __init__(self, path, service):
                    self.path = path
                    self.service = service
                    self.explicit_time_averaged_coupling = self.__class__.explicit_time_averaged_coupling(path + ["explicit_time_averaged_coupling"], service)
                    super().__init__(path, service)
                def implicit_coupling(self, *args, **kwargs):
                    """
                    Enable/disable implicit coupling for mapped interface.
                    """
                    return PyMenu(self.service, "/setup/models/cht/implicit_coupling").execute(*args, **kwargs)
                def write_mi_type_wall(self, *args, **kwargs):
                    """
                    Write mapped interface settings to a scv file.
                    """
                    return PyMenu(self.service, "/setup/models/cht/write_mi_type_wall").execute(*args, **kwargs)
                def read_mi_type_wall(self, *args, **kwargs):
                    """
                    Read mapped interface data settings from a csv file.
                    """
                    return PyMenu(self.service, "/setup/models/cht/read_mi_type_wall").execute(*args, **kwargs)

                class explicit_time_averaged_coupling(TUIMenu):
                    """
                    Enter the explcit time averaged thermal coupling menu.
                    """
                    def __init__(self, path, service):
                        self.path = path
                        self.service = service
                        super().__init__(path, service)
                    def coupling_controls(self, *args, **kwargs):
                        """
                        Specify explcit coupling controls.
                        """
                        return PyMenu(self.service, "/setup/models/cht/explicit_time_averaged_coupling/coupling_controls").execute(*args, **kwargs)
                    def mapped_interfaces(self, *args, **kwargs):
                        """
                        Select fluid-solid mapped interfaces for explicit coupling using time averaged thermal variables.
                        """
                        return PyMenu(self.service, "/setup/models/cht/explicit_time_averaged_coupling/mapped_interfaces").execute(*args, **kwargs)
                    def conformal_coupled_walls(self, *args, **kwargs):
                        """
                        Select fluid-solid coupled walls (without shell) for explicit coupling using time averaged thermal variables.
                        """
                        return PyMenu(self.service, "/setup/models/cht/explicit_time_averaged_coupling/conformal_coupled_walls").execute(*args, **kwargs)
                    def fuse_explicit_cht_zones(self, *args, **kwargs):
                        """
                        Fuse slitted conformal coupled walls marked for transient explicit thermal coupling.
                        """
                        return PyMenu(self.service, "/setup/models/cht/explicit_time_averaged_coupling/fuse_explicit_cht_zones").execute(*args, **kwargs)

            class species(TUIMenu):
                """
                Enter the species models menu.
                """
                def __init__(self, path, service):
                    self.path = path
                    self.service = service
                    self.CHEMKIN_CFD_parameters = self.__class__.CHEMKIN_CFD_parameters(path + ["CHEMKIN_CFD_parameters"], service)
                    super().__init__(path, service)
                def volumetric_reactions(self, *args, **kwargs):
                    """
                    Enable/disable volumetric reactions.
                    """
                    return PyMenu(self.service, "/setup/models/species/volumetric_reactions").execute(*args, **kwargs)
                def liquid_micro_mixing(self, *args, **kwargs):
                    """
                    Enable/disable liquid micro mixing option.
                    """
                    return PyMenu(self.service, "/setup/models/species/liquid_micro_mixing").execute(*args, **kwargs)
                def decoupled_detailed_chemistry(self, *args, **kwargs):
                    """
                    Enable/disable the Decoupled Detailed Chemistry model.
                    """
                    return PyMenu(self.service, "/setup/models/species/decoupled_detailed_chemistry").execute(*args, **kwargs)
                def diffusion_energy_source(self, *args, **kwargs):
                    """
                    Enable/disable diffusion energy source.
                    """
                    return PyMenu(self.service, "/setup/models/species/diffusion_energy_source").execute(*args, **kwargs)
                def reacting_channel_model_options(self, *args, **kwargs):
                    """
                    Set Reacting Channel Model parameters.
                    """
                    return PyMenu(self.service, "/setup/models/species/reacting_channel_model_options").execute(*args, **kwargs)
                def ignition_model_controls(self, *args, **kwargs):
                    """
                    Set ignition model parameters.
                    """
                    return PyMenu(self.service, "/setup/models/species/ignition_model_controls").execute(*args, **kwargs)
                def re_calc_par_premix_props(self, *args, **kwargs):
                    """
                    Re-calculate partially-premixed properties.
                    """
                    return PyMenu(self.service, "/setup/models/species/re_calc_par_premix_props").execute(*args, **kwargs)
                def ignition_model(self, *args, **kwargs):
                    """
                    Enable/disable the ignition model.
                    """
                    return PyMenu(self.service, "/setup/models/species/ignition_model").execute(*args, **kwargs)
                def premixed_model(self, *args, **kwargs):
                    """
                    Set premixed combustion model.
                    """
                    return PyMenu(self.service, "/setup/models/species/premixed_model").execute(*args, **kwargs)
                def clear_isat_table(self, *args, **kwargs):
                    """
                    Clear the ISAT table.
                    """
                    return PyMenu(self.service, "/setup/models/species/clear_isat_table").execute(*args, **kwargs)
                def mass_deposition_source(self, *args, **kwargs):
                    """
                    Enable/disable mass deposition source due to surface reactions.
                    """
                    return PyMenu(self.service, "/setup/models/species/mass_deposition_source").execute(*args, **kwargs)
                def inert_transport_model(self, *args, **kwargs):
                    """
                    Enable/disable the inert transport model.
                    """
                    return PyMenu(self.service, "/setup/models/species/inert_transport_model").execute(*args, **kwargs)
                def mixing_model(self, *args, **kwargs):
                    """
                    Set PDF transport mixing model.
                    """
                    return PyMenu(self.service, "/setup/models/species/mixing_model").execute(*args, **kwargs)
                def non_premixed_combustion(self, *args, **kwargs):
                    """
                    Enable/disable the non-premixed combustion model.
                    """
                    return PyMenu(self.service, "/setup/models/species/non_premixed_combustion").execute(*args, **kwargs)
                def species_migration(self, *args, **kwargs):
                    """
                    Enable/disable ion species migration in electric field.
                    """
                    return PyMenu(self.service, "/setup/models/species/species_migration").execute(*args, **kwargs)
                def surf_reaction_aggressiveness_factor(self, *args, **kwargs):
                    """
                    Set the surface reaction aggressiveness factor.
                    """
                    return PyMenu(self.service, "/setup/models/species/surf_reaction_aggressiveness_factor").execute(*args, **kwargs)
                def particle_surface_reactions(self, *args, **kwargs):
                    """
                    Enable/disable particle surface reactions.
                    """
                    return PyMenu(self.service, "/setup/models/species/particle_surface_reactions").execute(*args, **kwargs)
                def partially_premixed_combustion_grids(self, *args, **kwargs):
                    """
                    Set user specified grid parameters for PDF and flamelet.
                    """
                    return PyMenu(self.service, "/setup/models/species/partially_premixed_combustion_grids").execute(*args, **kwargs)
                def import_flamelet_for_restart(self, *args, **kwargs):
                    """
                    Import Flamelet File for Restart.
                    """
                    return PyMenu(self.service, "/setup/models/species/import_flamelet_for_restart").execute(*args, **kwargs)
                def surf_reaction_netm_params(self, *args, **kwargs):
                    """
                    Set the surface reaction parameters for the Non-Equilibrium Thermal Model.
                    """
                    return PyMenu(self.service, "/setup/models/species/surf_reaction_netm_params").execute(*args, **kwargs)
                def set_turb_chem_interaction(self, *args, **kwargs):
                    """
                    Set Eddy-Dissipation Concept model constants.
                    """
                    return PyMenu(self.service, "/setup/models/species/set_turb_chem_interaction").execute(*args, **kwargs)
                def off(self, *args, **kwargs):
                    """
                    Enable/disable solution of species models.
                    """
                    return PyMenu(self.service, "/setup/models/species/off").execute(*args, **kwargs)
                def init_unsteady_flamelet_prob(self, *args, **kwargs):
                    """
                    Initialize Unsteady Flamelet Probability.
                    """
                    return PyMenu(self.service, "/setup/models/species/init_unsteady_flamelet_prob").execute(*args, **kwargs)
                def species_transport_expert(self, *args, **kwargs):
                    """
                    Set species transport expert options.
                    """
                    return PyMenu(self.service, "/setup/models/species/species_transport_expert").execute(*args, **kwargs)
                def pdf_transport_expert(self, *args, **kwargs):
                    """
                    Enable/disable PDF transport expert user.
                    """
                    return PyMenu(self.service, "/setup/models/species/pdf_transport_expert").execute(*args, **kwargs)
                def partially_premixed_combustion(self, *args, **kwargs):
                    """
                    Enable/disable partially premixed combustion model.
                    """
                    return PyMenu(self.service, "/setup/models/species/partially_premixed_combustion").execute(*args, **kwargs)
                def set_premixed_combustion(self, *args, **kwargs):
                    """
                    Set premixed combustion parameters.
                    """
                    return PyMenu(self.service, "/setup/models/species/set_premixed_combustion").execute(*args, **kwargs)
                def CHEMKIN_CFD(self, *args, **kwargs):
                    """
                    Enable/disable CHEMKIN-CFD.
                    """
                    return PyMenu(self.service, "/setup/models/species/CHEMKIN_CFD").execute(*args, **kwargs)
                def coal_calculator(self, *args, **kwargs):
                    """
                    Set up coal modeling inputs.
                    """
                    return PyMenu(self.service, "/setup/models/species/coal_calculator").execute(*args, **kwargs)
                def reactor_network_model(self, *args, **kwargs):
                    """
                    Enable/disable the Reactor Network model.
                    """
                    return PyMenu(self.service, "/setup/models/species/reactor_network_model").execute(*args, **kwargs)
                def heat_of_surface_reactions(self, *args, **kwargs):
                    """
                    Enable/disable heat of surface reactions.
                    """
                    return PyMenu(self.service, "/setup/models/species/heat_of_surface_reactions").execute(*args, **kwargs)
                def multicomponent_diffusion(self, *args, **kwargs):
                    """
                    Enable/disable multicomponent diffusion.
                    """
                    return PyMenu(self.service, "/setup/models/species/multicomponent_diffusion").execute(*args, **kwargs)
                def full_tabulation(self, *args, **kwargs):
                    """
                    Enable/disable building of a full 2 mixture fraction table.
                    """
                    return PyMenu(self.service, "/setup/models/species/full_tabulation").execute(*args, **kwargs)
                def stiff_chemistry(self, *args, **kwargs):
                    """
                    Enable/disable stiff chemistry option.
                    """
                    return PyMenu(self.service, "/setup/models/species/stiff_chemistry").execute(*args, **kwargs)
                def wall_surface_reactions(self, *args, **kwargs):
                    """
                    Enable/disable wall surface reactions.
                    """
                    return PyMenu(self.service, "/setup/models/species/wall_surface_reactions").execute(*args, **kwargs)
                def reacting_channel_model(self, *args, **kwargs):
                    """
                    Enable/Disable the Reacting Channel Model.
                    """
                    return PyMenu(self.service, "/setup/models/species/reacting_channel_model").execute(*args, **kwargs)
                def combustion_expert(self, *args, **kwargs):
                    """
                    Set combustion expert parameters.
                    """
                    return PyMenu(self.service, "/setup/models/species/combustion_expert").execute(*args, **kwargs)
                def non_premixed_combustion_parameters(self, *args, **kwargs):
                    """
                    Set PDF parameters.
                    """
                    return PyMenu(self.service, "/setup/models/species/non_premixed_combustion_parameters").execute(*args, **kwargs)
                def liquid_energy_diffusion(self, *args, **kwargs):
                    """
                    Enable/disable energy diffusion for liquid regime.
                    """
                    return PyMenu(self.service, "/setup/models/species/liquid_energy_diffusion").execute(*args, **kwargs)
                def partially_premixed_combustion_expert(self, *args, **kwargs):
                    """
                    Set PDF expert parameters.
                    """
                    return PyMenu(self.service, "/setup/models/species/partially_premixed_combustion_expert").execute(*args, **kwargs)
                def partially_premixed_combustion_parameters(self, *args, **kwargs):
                    """
                    Set PDF parameters.
                    """
                    return PyMenu(self.service, "/setup/models/species/partially_premixed_combustion_parameters").execute(*args, **kwargs)
                def non_premixed_combustion_expert(self, *args, **kwargs):
                    """
                    Set PDF expert parameters.
                    """
                    return PyMenu(self.service, "/setup/models/species/non_premixed_combustion_expert").execute(*args, **kwargs)
                def spark_model(self, *args, **kwargs):
                    """
                    Set spark model parameters.
                    """
                    return PyMenu(self.service, "/setup/models/species/spark_model").execute(*args, **kwargs)
                def set_multi_regime_fgm(self, *args, **kwargs):
                    """
                    Set-multi-regim-fgm-parameters.
                    """
                    return PyMenu(self.service, "/setup/models/species/set_multi_regime_fgm").execute(*args, **kwargs)
                def epdf_energy(self, *args, **kwargs):
                    """
                    Enable/disable EPDF energy  option.
                    """
                    return PyMenu(self.service, "/setup/models/species/epdf_energy").execute(*args, **kwargs)
                def thermal_diffusion(self, *args, **kwargs):
                    """
                    Enable/disable thermal diffusion.
                    """
                    return PyMenu(self.service, "/setup/models/species/thermal_diffusion").execute(*args, **kwargs)
                def integration_parameters(self, *args, **kwargs):
                    """
                    Set ISAT parameters.
                    """
                    return PyMenu(self.service, "/setup/models/species/integration_parameters").execute(*args, **kwargs)
                def flamelet_expert(self, *args, **kwargs):
                    """
                    Set flamelet expert parameters.
                    """
                    return PyMenu(self.service, "/setup/models/species/flamelet_expert").execute(*args, **kwargs)
                def inlet_diffusion(self, *args, **kwargs):
                    """
                    Enable/disable inclusion of diffusion at inlets.
                    """
                    return PyMenu(self.service, "/setup/models/species/inlet_diffusion").execute(*args, **kwargs)
                def partially_premixed_properties(self, *args, **kwargs):
                    """
                    Set/Change partially premixed mixture properties.
                    """
                    return PyMenu(self.service, "/setup/models/species/partially_premixed_properties").execute(*args, **kwargs)
                def pdf_transport(self, *args, **kwargs):
                    """
                    Enable/disable the composition PDF transport combustion model.
                    """
                    return PyMenu(self.service, "/setup/models/species/pdf_transport").execute(*args, **kwargs)
                def inert_transport_controls(self, *args, **kwargs):
                    """
                    Set inert transport model parameters.
                    """
                    return PyMenu(self.service, "/setup/models/species/inert_transport_controls").execute(*args, **kwargs)
                def species_transport(self, *args, **kwargs):
                    """
                    Enable/disable the species transport model.
                    """
                    return PyMenu(self.service, "/setup/models/species/species_transport").execute(*args, **kwargs)
                def thickened_flame_model(self, *args, **kwargs):
                    """
                    Enable/disable the Relaxation to Chemical Equilibrium model.
                    """
                    return PyMenu(self.service, "/setup/models/species/thickened_flame_model").execute(*args, **kwargs)
                def premixed_combustion(self, *args, **kwargs):
                    """
                    Enable/disable the premixed combustion model.
                    """
                    return PyMenu(self.service, "/setup/models/species/premixed_combustion").execute(*args, **kwargs)
                def save_gradients(self, *args, **kwargs):
                    """
                    Enable/disable storage of species mass fraction gradients.
                    """
                    return PyMenu(self.service, "/setup/models/species/save_gradients").execute(*args, **kwargs)
                def relax_to_equil(self, *args, **kwargs):
                    """
                    Enable/disable the Relaxation to Chemical Equilibrium model.
                    """
                    return PyMenu(self.service, "/setup/models/species/relax_to_equil").execute(*args, **kwargs)
                def electro_chemical_surface_reactions(self, *args, **kwargs):
                    """
                    Enable/disable electrochemical surface reactions.
                    """
                    return PyMenu(self.service, "/setup/models/species/electro_chemical_surface_reactions").execute(*args, **kwargs)
                def combustion_numerics(self, *args, **kwargs):
                    """
                    Set combustion numerics options.
                    """
                    return PyMenu(self.service, "/setup/models/species/combustion_numerics").execute(*args, **kwargs)
                def reaction_diffusion_balance(self, *args, **kwargs):
                    """
                    Enable/disable reaction diffusion balance at reacting surface for surface reactions.
                    """
                    return PyMenu(self.service, "/setup/models/species/reaction_diffusion_balance").execute(*args, **kwargs)

                class CHEMKIN_CFD_parameters(TUIMenu):
                    """
                    Enter the expert CHEMKIN-CFD parameters menu.
                    """
                    def __init__(self, path, service):
                        self.path = path
                        self.service = service
                        super().__init__(path, service)
                    def delete_cell_monitors(self, *args, **kwargs):
                        """
                        Delete cell monitors.
                        """
                        return PyMenu(self.service, "/setup/models/species/CHEMKIN_CFD_parameters/delete_cell_monitors").execute(*args, **kwargs)
                    def add_cell_monitor(self, *args, **kwargs):
                        """
                        Add a monitor cell for debug output.
                        """
                        return PyMenu(self.service, "/setup/models/species/CHEMKIN_CFD_parameters/add_cell_monitor").execute(*args, **kwargs)
                    def advanced_options(self, *args, **kwargs):
                        """
                        Set advanced parameter options.
                        """
                        return PyMenu(self.service, "/setup/models/species/CHEMKIN_CFD_parameters/advanced_options").execute(*args, **kwargs)
                    def basic_options(self, *args, **kwargs):
                        """
                        Set basic parameter options.
                        """
                        return PyMenu(self.service, "/setup/models/species/CHEMKIN_CFD_parameters/basic_options").execute(*args, **kwargs)
                    def list_cell_monitors(self, *args, **kwargs):
                        """
                        List cell monitors.
                        """
                        return PyMenu(self.service, "/setup/models/species/CHEMKIN_CFD_parameters/list_cell_monitors").execute(*args, **kwargs)

            class structure(TUIMenu):
                """
                Enter the structure model menu.
                """
                def __init__(self, path, service):
                    self.path = path
                    self.service = service
                    self.expert = self.__class__.expert(path + ["expert"], service)
                    self.controls = self.__class__.controls(path + ["controls"], service)
                    super().__init__(path, service)
                def linear_elasticity(self, *args, **kwargs):
                    """
                    Enable the linear elasticity model.
                    """
                    return PyMenu(self.service, "/setup/models/structure/linear_elasticity").execute(*args, **kwargs)
                def nonlinear_elasticity(self, *args, **kwargs):
                    """
                    Enable the nonlinear elasticity model.
                    """
                    return PyMenu(self.service, "/setup/models/structure/nonlinear_elasticity").execute(*args, **kwargs)
                def structure_off(self, *args, **kwargs):
                    """
                    Disable the structural model.
                    """
                    return PyMenu(self.service, "/setup/models/structure/structure_off").execute(*args, **kwargs)
                def thermal_effects(self, *args, **kwargs):
                    """
                    Enable structure thermal effects.
                    """
                    return PyMenu(self.service, "/setup/models/structure/thermal_effects").execute(*args, **kwargs)

                class expert(TUIMenu):
                    """
                    Enter the structure expert menu.
                    """
                    def __init__(self, path, service):
                        self.path = path
                        self.service = service
                        super().__init__(path, service)
                    def include_viscous_fsi_force(self, *args, **kwargs):
                        """
                        Enable inclusion of viscous fsi force.
                        """
                        return PyMenu(self.service, "/setup/models/structure/expert/include_viscous_fsi_force").execute(*args, **kwargs)
                    def include_pop_in_fsi_force(self, *args, **kwargs):
                        """
                        Enable inclusion of operating p into fsi force.
                        """
                        return PyMenu(self.service, "/setup/models/structure/expert/include_pop_in_fsi_force").execute(*args, **kwargs)
                    def explicit_fsi_force(self, *args, **kwargs):
                        """
                        Enable explicit fsi force.
                        """
                        return PyMenu(self.service, "/setup/models/structure/expert/explicit_fsi_force").execute(*args, **kwargs)
                    def steady_2way_fsi(self, *args, **kwargs):
                        """
                        Enable steady 2-way fsi workflow.
                        """
                        return PyMenu(self.service, "/setup/models/structure/expert/steady_2way_fsi").execute(*args, **kwargs)
                    def starting_t_re_initialization(self, *args, **kwargs):
                        """
                        Set starting T-field re-initialization method.
                        """
                        return PyMenu(self.service, "/setup/models/structure/expert/starting_t_re_initialization").execute(*args, **kwargs)

                class controls(TUIMenu):
                    """
                    Enter the structure controls menu.
                    """
                    def __init__(self, path, service):
                        self.path = path
                        self.service = service
                        super().__init__(path, service)
                    def unsteady_damping_rayleigh(self, *args, **kwargs):
                        """
                        Enable/disable Newmark unsteady solution model.
                        """
                        return PyMenu(self.service, "/setup/models/structure/controls/unsteady_damping_rayleigh").execute(*args, **kwargs)
                    def max_iter(self, *args, **kwargs):
                        """
                        Set the maximum number of iterations for structural solver.
                        """
                        return PyMenu(self.service, "/setup/models/structure/controls/max_iter").execute(*args, **kwargs)
                    def amg_stabilization(self, *args, **kwargs):
                        """
                        Set the AMG stabilization method for structural solver.
                        """
                        return PyMenu(self.service, "/setup/models/structure/controls/amg_stabilization").execute(*args, **kwargs)
                    def numerical_damping_factor(self, *args, **kwargs):
                        """
                        Set structure damping parameters.
                        """
                        return PyMenu(self.service, "/setup/models/structure/controls/numerical_damping_factor").execute(*args, **kwargs)
                    def enhanced_strain(self, *args, **kwargs):
                        """
                        Enable enhanced strain element.
                        """
                        return PyMenu(self.service, "/setup/models/structure/controls/enhanced_strain").execute(*args, **kwargs)

            class dpm(TUIMenu):
                """
                Enter the dispersed phase model menu.
                """
                def __init__(self, path, service):
                    self.path = path
                    self.service = service
                    self.options = self.__class__.options(path + ["options"], service)
                    self.splash_options = self.__class__.splash_options(path + ["splash_options"], service)
                    self.numerics = self.__class__.numerics(path + ["numerics"], service)
                    self.interaction = self.__class__.interaction(path + ["interaction"], service)
                    self.stripping_options = self.__class__.stripping_options(path + ["stripping_options"], service)
                    self.parallel = self.__class__.parallel(path + ["parallel"], service)
                    self.collisions = self.__class__.collisions(path + ["collisions"], service)
                    self.erosion_dynamic_mesh = self.__class__.erosion_dynamic_mesh(path + ["erosion_dynamic_mesh"], service)
                    super().__init__(path, service)
                def injections(self, *args, **kwargs):
                    """
                    Enter the injections menu.
                    """
                    return PyMenu(self.service, "/setup/models/dpm/injections").execute(*args, **kwargs)
                def fill_injection_material_sources(self, *args, **kwargs):
                    """
                    Initialize the DPM sources corresponding to each material.
                    """
                    return PyMenu(self.service, "/setup/models/dpm/fill_injection_material_sources").execute(*args, **kwargs)
                def unsteady_tracking(self, *args, **kwargs):
                    """
                    Enable/disable unsteady particle tracking.
                    """
                    return PyMenu(self.service, "/setup/models/dpm/unsteady_tracking").execute(*args, **kwargs)
                def spray_model(self, *args, **kwargs):
                    """
                    Enter the spray model menu.
                    """
                    return PyMenu(self.service, "/setup/models/dpm/spray_model").execute(*args, **kwargs)
                def clear_particles_from_domain(self, *args, **kwargs):
                    """
                    Remove/keep all particles currently in the domain.
                    """
                    return PyMenu(self.service, "/setup/models/dpm/clear_particles_from_domain").execute(*args, **kwargs)
                def user_defined(self, *args, **kwargs):
                    """
                    Set DPM user-defined functions.
                    """
                    return PyMenu(self.service, "/setup/models/dpm/user_defined").execute(*args, **kwargs)

                class options(TUIMenu):
                    """
                    Enter the options menu to set optional DPM models.
                    """
                    def __init__(self, path, service):
                        self.path = path
                        self.service = service
                        super().__init__(path, service)
                    def use_absolute_pressure_for_vaporization(self, *args, **kwargs):
                        """
                        Enable/disable using Absolute Pressure for Vaporization.
                        """
                        return PyMenu(self.service, "/setup/models/dpm/options/use_absolute_pressure_for_vaporization").execute(*args, **kwargs)
                    def stagger_radius(self, *args, **kwargs):
                        """
                        Provide a stagger radius for non atomizer injections.
                        """
                        return PyMenu(self.service, "/setup/models/dpm/options/stagger_radius").execute(*args, **kwargs)
                    def brownian_motion(self, *args, **kwargs):
                        """
                        Enable/disable Brownian motion of particles.
                        """
                        return PyMenu(self.service, "/setup/models/dpm/options/brownian_motion").execute(*args, **kwargs)
                    def stagger_temporally(self, *args, **kwargs):
                        """
                        Stagger transient parcels for their first time step?.
                        """
                        return PyMenu(self.service, "/setup/models/dpm/options/stagger_temporally").execute(*args, **kwargs)
                    def track_in_absolute_frame(self, *args, **kwargs):
                        """
                        Enable/disable tracking in absolute frame.
                        """
                        return PyMenu(self.service, "/setup/models/dpm/options/track_in_absolute_frame").execute(*args, **kwargs)
                    def erosion_accretion(self, *args, **kwargs):
                        """
                        Enable/disable erosion/accretion.
                        """
                        return PyMenu(self.service, "/setup/models/dpm/options/erosion_accretion").execute(*args, **kwargs)
                    def include_lwf_particles_in_dpm_concentration(self, *args, **kwargs):
                        """
                        Include LWF particle mass in DPM Concentration.
                        """
                        return PyMenu(self.service, "/setup/models/dpm/options/include_lwf_particles_in_dpm_concentration").execute(*args, **kwargs)
                    def vaporization_options(self, *args, **kwargs):
                        """
                        Set Vaporization options.
                        """
                        return PyMenu(self.service, "/setup/models/dpm/options/vaporization_options").execute(*args, **kwargs)
                    def set_minimum_particle_diameter(self, *args, **kwargs):
                        """
                        Set the minimum particle diameter.
                        """
                        return PyMenu(self.service, "/setup/models/dpm/options/set_minimum_particle_diameter").execute(*args, **kwargs)
                    def enable_contour_plots(self, *args, **kwargs):
                        """
                        Enable contour and vector plots of particle data.
                        """
                        return PyMenu(self.service, "/setup/models/dpm/options/enable_contour_plots").execute(*args, **kwargs)
                    def maximum_udf_species(self, *args, **kwargs):
                        """
                        Maximum number of species that can interact with particles in the DPM UDFs.
                        """
                        return PyMenu(self.service, "/setup/models/dpm/options/maximum_udf_species").execute(*args, **kwargs)
                    def saffman_lift_force(self, *args, **kwargs):
                        """
                        Enable/disable Saffman lift force.
                        """
                        return PyMenu(self.service, "/setup/models/dpm/options/saffman_lift_force").execute(*args, **kwargs)
                    def convective_film_heat_transfer(self, *args, **kwargs):
                        """
                        Enable/disable convection/conduction film to wall heat transfer model.
                        """
                        return PyMenu(self.service, "/setup/models/dpm/options/convective_film_heat_transfer").execute(*args, **kwargs)
                    def staggering_factor(self, *args, **kwargs):
                        """
                        Set the staggering factor between 0 and 1 to control the amount of staggering.
                        """
                        return PyMenu(self.service, "/setup/models/dpm/options/staggering_factor").execute(*args, **kwargs)
                    def current_positions_in_sample_file_format(self, *args, **kwargs):
                        """
                        Write the current positions (step-by-step history report for unsteady tracking) in the sampling file format.
                        """
                        return PyMenu(self.service, "/setup/models/dpm/options/current_positions_in_sample_file_format").execute(*args, **kwargs)
                    def two_way_coupling(self, *args, **kwargs):
                        """
                        Enable/disable calculation of DPM sources in TKE equation.
                        """
                        return PyMenu(self.service, "/setup/models/dpm/options/two_way_coupling").execute(*args, **kwargs)
                    def lowest_volatiles_mass_fraction(self, *args, **kwargs):
                        """
                        Set the lowest volatiles mass fraction.
                        """
                        return PyMenu(self.service, "/setup/models/dpm/options/lowest_volatiles_mass_fraction").execute(*args, **kwargs)
                    def treat_multicomponent_saturation_temperature_failure(self, *args, **kwargs):
                        """
                        Dump multicomponent particle mass if the saturation temperature cannot be determined.
                        """
                        return PyMenu(self.service, "/setup/models/dpm/options/treat_multicomponent_saturation_temperature_failure").execute(*args, **kwargs)
                    def init_erosion_accretion_rate(self, *args, **kwargs):
                        """
                        Initialize erosion/accretion rates with Zero.
                        """
                        return PyMenu(self.service, "/setup/models/dpm/options/init_erosion_accretion_rate").execute(*args, **kwargs)
                    def uniform_mass_distribution_for_injections(self, *args, **kwargs):
                        """
                        A uniform mass distribution will be enabled for all solid cone and atomizer injections.
                        """
                        return PyMenu(self.service, "/setup/models/dpm/options/uniform_mass_distribution_for_injections").execute(*args, **kwargs)
                    def remove_wall_film_temperature_limiter(self, *args, **kwargs):
                        """
                        Remove the wall film temperature limiter.
                        """
                        return PyMenu(self.service, "/setup/models/dpm/options/remove_wall_film_temperature_limiter").execute(*args, **kwargs)
                    def virtual_mass_force(self, *args, **kwargs):
                        """
                        Enable/disable virtual mass force.
                        """
                        return PyMenu(self.service, "/setup/models/dpm/options/virtual_mass_force").execute(*args, **kwargs)
                    def particle_radiation(self, *args, **kwargs):
                        """
                        Enable/disable particle radiation.
                        """
                        return PyMenu(self.service, "/setup/models/dpm/options/particle_radiation").execute(*args, **kwargs)
                    def pressure_gradient_force(self, *args, **kwargs):
                        """
                        Enable/disable pressure gradient force.
                        """
                        return PyMenu(self.service, "/setup/models/dpm/options/pressure_gradient_force").execute(*args, **kwargs)
                    def stagger_spatially_standard_injections(self, *args, **kwargs):
                        """
                        Spatially stagger non-atomizer injections?.
                        """
                        return PyMenu(self.service, "/setup/models/dpm/options/stagger_spatially_standard_injections").execute(*args, **kwargs)
                    def step_report_sig_figures(self, *args, **kwargs):
                        """
                        Set significant figures in the step-by-step report.
                        """
                        return PyMenu(self.service, "/setup/models/dpm/options/step_report_sig_figures").execute(*args, **kwargs)
                    def thermophoretic_force(self, *args, **kwargs):
                        """
                        Enable/disable thermophoretic force.
                        """
                        return PyMenu(self.service, "/setup/models/dpm/options/thermophoretic_force").execute(*args, **kwargs)
                    def set_thermolysis_limit(self, *args, **kwargs):
                        """
                        Set the thermolysis limit.
                        """
                        return PyMenu(self.service, "/setup/models/dpm/options/set_thermolysis_limit").execute(*args, **kwargs)
                    def scr_urea_deposition_risk_analysis(self, *args, **kwargs):
                        """
                        Options to activate and configure the SCR urea deposition risk analysis.
                        """
                        return PyMenu(self.service, "/setup/models/dpm/options/scr_urea_deposition_risk_analysis").execute(*args, **kwargs)
                    def vaporization_heat_transfer_averaging(self, *args, **kwargs):
                        """
                        Enable/disable correction for Vaporization heat transfer.
                        """
                        return PyMenu(self.service, "/setup/models/dpm/options/vaporization_heat_transfer_averaging").execute(*args, **kwargs)
                    def ensemble_average(self, *args, **kwargs):
                        """
                        Set ensemble average cloud properties.
                        """
                        return PyMenu(self.service, "/setup/models/dpm/options/ensemble_average").execute(*args, **kwargs)
                    def stagger_spatially_atomizer_injections(self, *args, **kwargs):
                        """
                        Spatially stagger atomizer injections?.
                        """
                        return PyMenu(self.service, "/setup/models/dpm/options/stagger_spatially_atomizer_injections").execute(*args, **kwargs)
                    def allow_supercritical_pressure_vaporization(self, *args, **kwargs):
                        """
                        Skip the pressure dependent boiling point calculation to allow supercritical pressure conditions for vaporization.
                        """
                        return PyMenu(self.service, "/setup/models/dpm/options/allow_supercritical_pressure_vaporization").execute(*args, **kwargs)

                class splash_options(TUIMenu):
                    """
                    Enter the splash options menu to set optional parameters.
                    """
                    def __init__(self, path, service):
                        self.path = path
                        self.service = service
                        super().__init__(path, service)
                    def orourke_splash_fraction(self, *args, **kwargs):
                        """
                        Select splash fraction method.
                        """
                        return PyMenu(self.service, "/setup/models/dpm/splash_options/orourke_splash_fraction").execute(*args, **kwargs)
                    def splash_pdf_limiting(self, *args, **kwargs):
                        """
                        Select splash pdf limiting method.
                        """
                        return PyMenu(self.service, "/setup/models/dpm/splash_options/splash_pdf_limiting").execute(*args, **kwargs)

                class numerics(TUIMenu):
                    """
                    Enter the numerics menu to set numerical solution parameters.
                    """
                    def __init__(self, path, service):
                        self.path = path
                        self.service = service
                        self.high_resolution_tracking = self.__class__.high_resolution_tracking(path + ["high_resolution_tracking"], service)
                        super().__init__(path, service)
                    def predictor_corrector(self, *args, **kwargs):
                        """
                        Enable predictor/corrector approach to track particles.
                        """
                        return PyMenu(self.service, "/setup/models/dpm/numerics/predictor_corrector").execute(*args, **kwargs)
                    def automated_scheme_selection(self, *args, **kwargs):
                        """
                        Enable/disable the adaptation of integration step length based on a maximum error.
                        """
                        return PyMenu(self.service, "/setup/models/dpm/numerics/automated_scheme_selection").execute(*args, **kwargs)
                    def average_source_terms(self, *args, **kwargs):
                        """
                        Average DPM source terms on nodes.
                        """
                        return PyMenu(self.service, "/setup/models/dpm/numerics/average_source_terms").execute(*args, **kwargs)
                    def mppic_settings(self, *args, **kwargs):
                        """
                        Enable PIC and MPPIC to compute DPM and DDPM source terms.
                        """
                        return PyMenu(self.service, "/setup/models/dpm/numerics/mppic_settings").execute(*args, **kwargs)
                    def enhanced_packing_limit_numerics(self, *args, **kwargs):
                        """
                        Enable enhanced packing limit numerics to avoid exceeding of packing limit for granular phases.
                        """
                        return PyMenu(self.service, "/setup/models/dpm/numerics/enhanced_packing_limit_numerics").execute(*args, **kwargs)
                    def underrelax_film_height(self, *args, **kwargs):
                        """
                        Define underrelaxation factor for film height.
                        """
                        return PyMenu(self.service, "/setup/models/dpm/numerics/underrelax_film_height").execute(*args, **kwargs)
                    def tracking_scheme(self, *args, **kwargs):
                        """
                        Specify a tracking scheme.
                        """
                        return PyMenu(self.service, "/setup/models/dpm/numerics/tracking_scheme").execute(*args, **kwargs)
                    def vaporization_limiting_factors(self, *args, **kwargs):
                        """
                        Set Vaporization Fractional Change Limits.
                        """
                        return PyMenu(self.service, "/setup/models/dpm/numerics/vaporization_limiting_factors").execute(*args, **kwargs)
                    def error_control(self, *args, **kwargs):
                        """
                        Set the adapt integration step length based on a maximum error.
                        """
                        return PyMenu(self.service, "/setup/models/dpm/numerics/error_control").execute(*args, **kwargs)
                    def minimum_liquid_fraction(self, *args, **kwargs):
                        """
                        Evaporate droplet completely when the remaining mass is below this fraction of initial mass.
                        """
                        return PyMenu(self.service, "/setup/models/dpm/numerics/minimum_liquid_fraction").execute(*args, **kwargs)
                    def tracking_parameters(self, *args, **kwargs):
                        """
                        Set parameters for the (initial) tracking step length.
                        """
                        return PyMenu(self.service, "/setup/models/dpm/numerics/tracking_parameters").execute(*args, **kwargs)
                    def verbosity(self, *args, **kwargs):
                        """
                        Adjust the DPM tracker's verbosity level.
                        """
                        return PyMenu(self.service, "/setup/models/dpm/numerics/verbosity").execute(*args, **kwargs)
                    def drag_law(self, *args, **kwargs):
                        """
                        Set the drag law.
                        """
                        return PyMenu(self.service, "/setup/models/dpm/numerics/drag_law").execute(*args, **kwargs)
                    def average_each_step(self, *args, **kwargs):
                        """
                        Do the averaging after each integration step for higher accuracy at a higher cost.
                        """
                        return PyMenu(self.service, "/setup/models/dpm/numerics/average_each_step").execute(*args, **kwargs)
                    def enable_node_based_averaging(self, *args, **kwargs):
                        """
                        Enable node based averaging of DPM variables.
                        """
                        return PyMenu(self.service, "/setup/models/dpm/numerics/enable_node_based_averaging").execute(*args, **kwargs)
                    def dynamic_interaction(self, *args, **kwargs):
                        """
                        Enable/disable dynamic interaction range.
                        """
                        return PyMenu(self.service, "/setup/models/dpm/numerics/dynamic_interaction").execute(*args, **kwargs)
                    def average_DDPM_variables(self, *args, **kwargs):
                        """
                        Average DDPM specific variables like volume fractions and velocities on nodes.
                        """
                        return PyMenu(self.service, "/setup/models/dpm/numerics/average_DDPM_variables").execute(*args, **kwargs)
                    def tracking_statistics(self, *args, **kwargs):
                        """
                        Control the format of the one-line tracking statistics printed after every DPM tracking pass.
                        """
                        return PyMenu(self.service, "/setup/models/dpm/numerics/tracking_statistics").execute(*args, **kwargs)
                    def coupled_heat_mass_update(self, *args, **kwargs):
                        """
                        Enable/disable coupled heat and mass update.
                        """
                        return PyMenu(self.service, "/setup/models/dpm/numerics/coupled_heat_mass_update").execute(*args, **kwargs)
                    def average_kernel(self, *args, **kwargs):
                        """
                        Specify a kernel for the averaging.
                        """
                        return PyMenu(self.service, "/setup/models/dpm/numerics/average_kernel").execute(*args, **kwargs)
                    def gaussian_factor(self, *args, **kwargs):
                        """
                        Set a factor for the gaussian kernel for node-based averaging.~%Large values give small size, small values give large size of kernel.
                        """
                        return PyMenu(self.service, "/setup/models/dpm/numerics/gaussian_factor").execute(*args, **kwargs)
                    def granular_stress_tensor(self, *args, **kwargs):
                        """
                        Enable granular stress tensor to be considered with solid pressure gradient as collision force.
                        """
                        return PyMenu(self.service, "/setup/models/dpm/numerics/granular_stress_tensor").execute(*args, **kwargs)

                    class high_resolution_tracking(TUIMenu):
                        """
                        Enter the high resolution tracking menu.
                        """
                        def __init__(self, path, service):
                            self.path = path
                            self.service = service
                            self.particle_relocation = self.__class__.particle_relocation(path + ["particle_relocation"], service)
                            self.barycentric_interpolation = self.__class__.barycentric_interpolation(path + ["barycentric_interpolation"], service)
                            super().__init__(path, service)
                        def use_quad_face_centroid(self, *args, **kwargs):
                            """
                            Use quad face centroids when creating subtets.
                            """
                            return PyMenu(self.service, "/setup/models/dpm/numerics/high_resolution_tracking/use_quad_face_centroid").execute(*args, **kwargs)
                        def remove_stuck_particles(self, *args, **kwargs):
                            """
                            Remove particles that are stuck at edges or faces.
                            """
                            return PyMenu(self.service, "/setup/models/dpm/numerics/high_resolution_tracking/remove_stuck_particles").execute(*args, **kwargs)
                        def check_subtet_validity(self, *args, **kwargs):
                            """
                            Test for inverted subtets due to warped cells.
                            """
                            return PyMenu(self.service, "/setup/models/dpm/numerics/high_resolution_tracking/check_subtet_validity").execute(*args, **kwargs)
                        def enable_high_resolution_tracking(self, *args, **kwargs):
                            """
                            Enable high resolution tracking.
                            """
                            return PyMenu(self.service, "/setup/models/dpm/numerics/high_resolution_tracking/enable_high_resolution_tracking").execute(*args, **kwargs)
                        def use_velocity_based_error_control(self, *args, **kwargs):
                            """
                            Use adaptive time stepping based upon the particle velocity.
                            """
                            return PyMenu(self.service, "/setup/models/dpm/numerics/high_resolution_tracking/use_velocity_based_error_control").execute(*args, **kwargs)
                        def boundary_layer_tracking(self, *args, **kwargs):
                            """
                            Adjust the particle timestep to account for high aspect ratio cells.
                            """
                            return PyMenu(self.service, "/setup/models/dpm/numerics/high_resolution_tracking/boundary_layer_tracking").execute(*args, **kwargs)
                        def project_wall_film_particles_to_film(self, *args, **kwargs):
                            """
                            Project existing particles to film to track using high resolution tracking?.
                            """
                            return PyMenu(self.service, "/setup/models/dpm/numerics/high_resolution_tracking/project_wall_film_particles_to_film").execute(*args, **kwargs)
                        def always_use_face_centroid_with_periodics(self, *args, **kwargs):
                            """
                            Use quad face centroids when creating subtets if the case contains periodic boundaries.
                            """
                            return PyMenu(self.service, "/setup/models/dpm/numerics/high_resolution_tracking/always_use_face_centroid_with_periodics").execute(*args, **kwargs)
                        def use_barycentric_sampling(self, *args, **kwargs):
                            """
                            Use barycentric coordinates when sampling at planes.
                            """
                            return PyMenu(self.service, "/setup/models/dpm/numerics/high_resolution_tracking/use_barycentric_sampling").execute(*args, **kwargs)
                        def enable_automatic_intersection_tolerance(self, *args, **kwargs):
                            """
                            Enable automatic scaling of subtet intersection tolerance.
                            """
                            return PyMenu(self.service, "/setup/models/dpm/numerics/high_resolution_tracking/enable_automatic_intersection_tolerance").execute(*args, **kwargs)
                        def enable_barycentric_intersections(self, *args, **kwargs):
                            """
                            Use barycentric coordinates for intersection calculations.
                            """
                            return PyMenu(self.service, "/setup/models/dpm/numerics/high_resolution_tracking/enable_barycentric_intersections").execute(*args, **kwargs)
                        def sliding_interface_crossover_fraction(self, *args, **kwargs):
                            """
                            Move the particle a fraction of the distance to the subtet center when crossing a sliding interface.
                            """
                            return PyMenu(self.service, "/setup/models/dpm/numerics/high_resolution_tracking/sliding_interface_crossover_fraction").execute(*args, **kwargs)
                        def set_subtet_intersection_tolerance(self, *args, **kwargs):
                            """
                            Set the tolerance for subtet intersection calculations.
                            """
                            return PyMenu(self.service, "/setup/models/dpm/numerics/high_resolution_tracking/set_subtet_intersection_tolerance").execute(*args, **kwargs)
                        def set_film_spreading_parameter(self, *args, **kwargs):
                            """
                            Set the spreading parameter for Lagrangian wallfilm particles.
                            """
                            return PyMenu(self.service, "/setup/models/dpm/numerics/high_resolution_tracking/set_film_spreading_parameter").execute(*args, **kwargs)
                        def use_particle_timestep_for_intersection_tolerance(self, *args, **kwargs):
                            """
                            Use the particle timestep for the axisymmetric subtet intersection tolerance.
                            """
                            return PyMenu(self.service, "/setup/models/dpm/numerics/high_resolution_tracking/use_particle_timestep_for_intersection_tolerance").execute(*args, **kwargs)

                        class particle_relocation(TUIMenu):
                            """
                            Enter the particle relocation menu.
                            """
                            def __init__(self, path, service):
                                self.path = path
                                self.service = service
                                super().__init__(path, service)
                            def enhanced_wallfilm_location_method(self, *args, **kwargs):
                                """
                                Enable enhanced method of locating film particles on faces.
                                """
                                return PyMenu(self.service, "/setup/models/dpm/numerics/high_resolution_tracking/particle_relocation/enhanced_wallfilm_location_method").execute(*args, **kwargs)
                            def use_legacy_particle_location_method(self, *args, **kwargs):
                                """
                                Enable legacy method of locating particles in cells.
                                """
                                return PyMenu(self.service, "/setup/models/dpm/numerics/high_resolution_tracking/particle_relocation/use_legacy_particle_location_method").execute(*args, **kwargs)
                            def enhanced_cell_relocation_method(self, *args, **kwargs):
                                """
                                Enable enhanced method of locating particles in cells.
                                """
                                return PyMenu(self.service, "/setup/models/dpm/numerics/high_resolution_tracking/particle_relocation/enhanced_cell_relocation_method").execute(*args, **kwargs)
                            def wallfilm_relocation_tolerance_scale_factor(self, *args, **kwargs):
                                """
                                Set the relocation tolerance scaling factor for wallfilm particles after remeshing.
                                """
                                return PyMenu(self.service, "/setup/models/dpm/numerics/high_resolution_tracking/particle_relocation/wallfilm_relocation_tolerance_scale_factor").execute(*args, **kwargs)
                            def overset_relocation_robustness_level(self, *args, **kwargs):
                                """
                                Set the robustness level for particle relocation in overset meshes.
                                """
                                return PyMenu(self.service, "/setup/models/dpm/numerics/high_resolution_tracking/particle_relocation/overset_relocation_robustness_level").execute(*args, **kwargs)
                            def load_legacy_particles(self, *args, **kwargs):
                                """
                                Load particles that were tracked without high-resolution tracking enabled.
                                """
                                return PyMenu(self.service, "/setup/models/dpm/numerics/high_resolution_tracking/particle_relocation/load_legacy_particles").execute(*args, **kwargs)

                        class barycentric_interpolation(TUIMenu):
                            """
                            Enter the barycentric interpolation menu.
                            """
                            def __init__(self, path, service):
                                self.path = path
                                self.service = service
                                super().__init__(path, service)
                            def interpolate_flow_density(self, *args, **kwargs):
                                """
                                Enable interpolation of flow density to the particle position.
                                """
                                return PyMenu(self.service, "/setup/models/dpm/numerics/high_resolution_tracking/barycentric_interpolation/interpolate_flow_density").execute(*args, **kwargs)
                            def enable_transient_variable_interpolation(self, *args, **kwargs):
                                """
                                Enable transient variable interpolation.
                                """
                                return PyMenu(self.service, "/setup/models/dpm/numerics/high_resolution_tracking/barycentric_interpolation/enable_transient_variable_interpolation").execute(*args, **kwargs)
                            def zero_nodal_velocity_on_walls(self, *args, **kwargs):
                                """
                                Set the nodal velocity on all walls to zero.
                                """
                                return PyMenu(self.service, "/setup/models/dpm/numerics/high_resolution_tracking/barycentric_interpolation/zero_nodal_velocity_on_walls").execute(*args, **kwargs)
                            def nodal_reconstruction_frequency(self, *args, **kwargs):
                                """
                                Update nodal reconstruction every N'th DPM iteration.
                                """
                                return PyMenu(self.service, "/setup/models/dpm/numerics/high_resolution_tracking/barycentric_interpolation/nodal_reconstruction_frequency").execute(*args, **kwargs)
                            def precompute_pdf_species(self, *args, **kwargs):
                                """
                                Precompute cell values of PDF species mass fractions prior to particle tracking.
                                """
                                return PyMenu(self.service, "/setup/models/dpm/numerics/high_resolution_tracking/barycentric_interpolation/precompute_pdf_species").execute(*args, **kwargs)
                            def interpolate_temperature(self, *args, **kwargs):
                                """
                                Enable interpolation of temperature to the particle position.
                                """
                                return PyMenu(self.service, "/setup/models/dpm/numerics/high_resolution_tracking/barycentric_interpolation/interpolate_temperature").execute(*args, **kwargs)
                            def interpolate_flow_solution_gradients(self, *args, **kwargs):
                                """
                                Enable interpolation of flow solution gradients.
                                """
                                return PyMenu(self.service, "/setup/models/dpm/numerics/high_resolution_tracking/barycentric_interpolation/interpolate_flow_solution_gradients").execute(*args, **kwargs)
                            def user_interpolation_function(self, *args, **kwargs):
                                """
                                Enter user interpolation function.
                                """
                                return PyMenu(self.service, "/setup/models/dpm/numerics/high_resolution_tracking/barycentric_interpolation/user_interpolation_function").execute(*args, **kwargs)
                            def interpolate_flow_cp(self, *args, **kwargs):
                                """
                                Enable interpolation of flow specific heat to the particle position.
                                """
                                return PyMenu(self.service, "/setup/models/dpm/numerics/high_resolution_tracking/barycentric_interpolation/interpolate_flow_cp").execute(*args, **kwargs)
                            def interpolate_flow_viscosity(self, *args, **kwargs):
                                """
                                Enable interpolation of flow viscosity to the particle position.
                                """
                                return PyMenu(self.service, "/setup/models/dpm/numerics/high_resolution_tracking/barycentric_interpolation/interpolate_flow_viscosity").execute(*args, **kwargs)
                            def interpolate_wallfilm_properties(self, *args, **kwargs):
                                """
                                Enable interpolation of wallfilm properties to the particle position.
                                """
                                return PyMenu(self.service, "/setup/models/dpm/numerics/high_resolution_tracking/barycentric_interpolation/interpolate_wallfilm_properties").execute(*args, **kwargs)

                class interaction(TUIMenu):
                    """
                    Enter the interaction menu to set parameters for coupled discrete phase calculations.
                    """
                    def __init__(self, path, service):
                        self.path = path
                        self.service = service
                        super().__init__(path, service)
                    def linearized_dpm_mixture_fraction_source_terms(self, *args, **kwargs):
                        """
                        Perform a linearization of mixture fraction source terms.
                        """
                        return PyMenu(self.service, "/setup/models/dpm/interaction/linearized_dpm_mixture_fraction_source_terms").execute(*args, **kwargs)
                    def linearized_dpm_source_terms(self, *args, **kwargs):
                        """
                        Perform a linearization of all DPM source terms to increase numerical robustness.
                        """
                        return PyMenu(self.service, "/setup/models/dpm/interaction/linearized_dpm_source_terms").execute(*args, **kwargs)
                    def implicit_source_term_coupling(self, *args, **kwargs):
                        """
                        Enable/disable implicit treatment for all DPM source terms.
                        """
                        return PyMenu(self.service, "/setup/models/dpm/interaction/implicit_source_term_coupling").execute(*args, **kwargs)
                    def update_dpm_sources_every_flow_iteration(self, *args, **kwargs):
                        """
                        Enable/disable the update of DPM source terms every flow iteration.
                        (if not, the terms will be updated every DPM iteration).
                        """
                        return PyMenu(self.service, "/setup/models/dpm/interaction/update_dpm_sources_every_flow_iteration").execute(*args, **kwargs)
                    def ddpm_iad_particle(self, *args, **kwargs):
                        """
                        Enable/disable the non-default interfacial area method IA-particle.
                        """
                        return PyMenu(self.service, "/setup/models/dpm/interaction/ddpm_iad_particle").execute(*args, **kwargs)
                    def max_vf_allowed_for_blocking(self, *args, **kwargs):
                        """
                        Maximum DPM volume fraction used in continuous flow.
                        """
                        return PyMenu(self.service, "/setup/models/dpm/interaction/max_vf_allowed_for_blocking").execute(*args, **kwargs)
                    def enable_flow_blocking_by_particles(self, *args, **kwargs):
                        """
                        Enable/disable inclusion of DPM volume fraction in continuous flow.
                        """
                        return PyMenu(self.service, "/setup/models/dpm/interaction/enable_flow_blocking_by_particles").execute(*args, **kwargs)
                    def linearized_dpm_species_source_terms(self, *args, **kwargs):
                        """
                        Perform linearization of species source terms.
                        """
                        return PyMenu(self.service, "/setup/models/dpm/interaction/linearized_dpm_species_source_terms").execute(*args, **kwargs)
                    def linearized_dpm_source_terms_limiter(self, *args, **kwargs):
                        """
                        Relative limit for DPM source linear coefficient with respect to fluid linear Ap coefficient.
                        """
                        return PyMenu(self.service, "/setup/models/dpm/interaction/linearized_dpm_source_terms_limiter").execute(*args, **kwargs)
                    def enable_source_scaling_due_to_flow_blocking(self, *args, **kwargs):
                        """
                        Enable/disable scaling of DPM source terms due to inclusion of DPM volume fraction in continuous flow.
                        """
                        return PyMenu(self.service, "/setup/models/dpm/interaction/enable_source_scaling_due_to_flow_blocking").execute(*args, **kwargs)
                    def enable_drag_scaling_due_to_flow_blocking(self, *args, **kwargs):
                        """
                        Enable/disable scaling of DPM drag coefficient due to inclusion of DPM volume fraction in continuous flow.
                        """
                        return PyMenu(self.service, "/setup/models/dpm/interaction/enable_drag_scaling_due_to_flow_blocking").execute(*args, **kwargs)
                    def dpm_iteration_interval(self, *args, **kwargs):
                        """
                        Set the number of continuous phase iterations per DPM iteration.
                        """
                        return PyMenu(self.service, "/setup/models/dpm/interaction/dpm_iteration_interval").execute(*args, **kwargs)
                    def linear_growth_of_dpm_source_term(self, *args, **kwargs):
                        """
                        Enable/disable the linear growth of DPM source terms every DPM iteration.
                        .
                        """
                        return PyMenu(self.service, "/setup/models/dpm/interaction/linear_growth_of_dpm_source_term").execute(*args, **kwargs)
                    def choice_of_eulerian_phase_for_interaction(self, *args, **kwargs):
                        """
                        Enable/disable the option to choose for every injection the Eulerian phase for the DPM continuous phase interaction.
                        """
                        return PyMenu(self.service, "/setup/models/dpm/interaction/choice_of_eulerian_phase_for_interaction").execute(*args, **kwargs)
                    def implicit_momentum_coupling(self, *args, **kwargs):
                        """
                        Enable/disable implicit treatment for the DPM momentum source terms.
                        """
                        return PyMenu(self.service, "/setup/models/dpm/interaction/implicit_momentum_coupling").execute(*args, **kwargs)
                    def replace_dpm_mass_source_by_mixture_fraction(self, *args, **kwargs):
                        """
                        Recalculate the mixture fraction source terms as function of the primary mixture fraction?.
                        """
                        return PyMenu(self.service, "/setup/models/dpm/interaction/replace_dpm_mass_source_by_mixture_fraction").execute(*args, **kwargs)
                    def min_vf_threshold_for_dpm_src_scaling(self, *args, **kwargs):
                        """
                        Minimum DPM volume fraction below which no DPM source scaling is applied.
                        """
                        return PyMenu(self.service, "/setup/models/dpm/interaction/min_vf_threshold_for_dpm_src_scaling").execute(*args, **kwargs)
                    def underrelaxation_factor(self, *args, **kwargs):
                        """
                        Set the under-relaxation factor.
                        """
                        return PyMenu(self.service, "/setup/models/dpm/interaction/underrelaxation_factor").execute(*args, **kwargs)
                    def reset_sources_at_timestep(self, *args, **kwargs):
                        """
                        Enable/disable flush of DPM source terms at beginning of every time step.
                        """
                        return PyMenu(self.service, "/setup/models/dpm/interaction/reset_sources_at_timestep").execute(*args, **kwargs)
                    def keep_linearized_dpm_source_terms_constant(self, *args, **kwargs):
                        """
                        Keep linearized DPM source terms constant until the next DPM Update.
                        """
                        return PyMenu(self.service, "/setup/models/dpm/interaction/keep_linearized_dpm_source_terms_constant").execute(*args, **kwargs)
                    def ddpm_energy_coupling_via_source_term(self, *args, **kwargs):
                        """
                        Energy coupling in DDPM established via source term.
                        """
                        return PyMenu(self.service, "/setup/models/dpm/interaction/ddpm_energy_coupling_via_source_term").execute(*args, **kwargs)
                    def ddpm_enhanced_inter_phase_exchange(self, *args, **kwargs):
                        """
                        Enhanced Eulerian inter-phase exchange.
                        """
                        return PyMenu(self.service, "/setup/models/dpm/interaction/ddpm_enhanced_inter_phase_exchange").execute(*args, **kwargs)
                    def coupled_calculations(self, *args, **kwargs):
                        """
                        Enable/disable coupling of continuous and discrete phase calculations.
                        """
                        return PyMenu(self.service, "/setup/models/dpm/interaction/coupled_calculations").execute(*args, **kwargs)

                class stripping_options(TUIMenu):
                    """
                    Enter the stripping options menu to set optional parameters.
                    """
                    def __init__(self, path, service):
                        self.path = path
                        self.service = service
                        super().__init__(path, service)
                    def diameter_coefficient(self, *args, **kwargs):
                        """
                        Set the stripping diameter coefficient.
                        """
                        return PyMenu(self.service, "/setup/models/dpm/stripping_options/diameter_coefficient").execute(*args, **kwargs)
                    def mass_coefficient(self, *args, **kwargs):
                        """
                        Set the stripping mass coefficient.
                        """
                        return PyMenu(self.service, "/setup/models/dpm/stripping_options/mass_coefficient").execute(*args, **kwargs)

                class parallel(TUIMenu):
                    """
                    Enter the parallel menu.
                    """
                    def __init__(self, path, service):
                        self.path = path
                        self.service = service
                        self.expert = self.__class__.expert(path + ["expert"], service)
                        super().__init__(path, service)
                    def fix_source_term_accumulation_order(self, *args, **kwargs):
                        """
                        Enforce deterministic order of source term accumulation.
                        """
                        return PyMenu(self.service, "/setup/models/dpm/parallel/fix_source_term_accumulation_order").execute(*args, **kwargs)
                    def report(self, *args, **kwargs):
                        """
                        Print particle workpile statistics.
                        """
                        return PyMenu(self.service, "/setup/models/dpm/parallel/report").execute(*args, **kwargs)
                    def hybrid_2domain(self, *args, **kwargs):
                        """
                        Use DPM domain to simulate particles.
                        """
                        return PyMenu(self.service, "/setup/models/dpm/parallel/hybrid_2domain").execute(*args, **kwargs)
                    def n_threads(self, *args, **kwargs):
                        """
                        Set the number of processors to use for DPM.
                        """
                        return PyMenu(self.service, "/setup/models/dpm/parallel/n_threads").execute(*args, **kwargs)
                    def hybrid_collision_variant(self, *args, **kwargs):
                        """
                        Further reduce the residual risk of dead-locks in the experimental feature that
                        allows 'hybrid' DPM parallel tracking with the collision / coalescence model.
                        """
                        return PyMenu(self.service, "/setup/models/dpm/parallel/hybrid_collision_variant").execute(*args, **kwargs)
                    def hybrid_collision_unidirectional(self, *args, **kwargs):
                        """
                        A faster, yet potentially somewhat less accurate, modification to the beta feature
                        that allows 'hybrid' DPM parallel tracking with the collision / coalescence model.
                        """
                        return PyMenu(self.service, "/setup/models/dpm/parallel/hybrid_collision_unidirectional").execute(*args, **kwargs)
                    def enable_workpile(self, *args, **kwargs):
                        """
                        Enable/disable the particle workpile algorithm.
                        """
                        return PyMenu(self.service, "/setup/models/dpm/parallel/enable_workpile").execute(*args, **kwargs)
                    def use_message_passing(self, *args, **kwargs):
                        """
                        Set DPM parallel-mode to message passing.
                        """
                        return PyMenu(self.service, "/setup/models/dpm/parallel/use_message_passing").execute(*args, **kwargs)
                    def hybrid_collision_model(self, *args, **kwargs):
                        """
                        An EXPERIMENTAL feature to allow 'hybrid' DPM parallel tracking with the collision / coalescence model.
                        """
                        return PyMenu(self.service, "/setup/models/dpm/parallel/hybrid_collision_model").execute(*args, **kwargs)
                    def hybrid_workpile(self, *args, **kwargs):
                        """
                        Optimize multi-thread load balancing within each partition in hybrid-parallel DPM tracking.
                        """
                        return PyMenu(self.service, "/setup/models/dpm/parallel/hybrid_workpile").execute(*args, **kwargs)
                    def use_hybrid(self, *args, **kwargs):
                        """
                        Set DPM parallel-mode to hybrid.
                        """
                        return PyMenu(self.service, "/setup/models/dpm/parallel/use_hybrid").execute(*args, **kwargs)
                    def use_shared_memory(self, *args, **kwargs):
                        """
                        Set DPM parallel-mode to shared memory.
                        """
                        return PyMenu(self.service, "/setup/models/dpm/parallel/use_shared_memory").execute(*args, **kwargs)

                    class expert(TUIMenu):
                        """
                        Enter the menu to set expert DPM parallel options.
                        """
                        def __init__(self, path, service):
                            self.path = path
                            self.service = service
                            super().__init__(path, service)
                        def partition_method_hybrid_2domain(self, *args, **kwargs):
                            """
                            Set DPM Domain partition method.
                            """
                            return PyMenu(self.service, "/setup/models/dpm/parallel/expert/partition_method_hybrid_2domain").execute(*args, **kwargs)

                class collisions(TUIMenu):
                    """
                    Enter the DEM collisions menu.
                    """
                    def __init__(self, path, service):
                        self.path = path
                        self.service = service
                        self.collision_partners = self.__class__.collision_partners(path + ["collision_partners"], service)
                        super().__init__(path, service)
                    def dem_collisions(self, *args, **kwargs):
                        """
                        Enable/disable the DEM collision model.
                        """
                        return PyMenu(self.service, "/setup/models/dpm/collisions/dem_collisions").execute(*args, **kwargs)
                    def collision_mesh(self, *args, **kwargs):
                        """
                        Input for the collision mesh.
                        """
                        return PyMenu(self.service, "/setup/models/dpm/collisions/collision_mesh").execute(*args, **kwargs)
                    def list_all_pair_settings(self, *args, **kwargs):
                        """
                        For each pair of collision partners, lists the collision laws and their parameters.
                        """
                        return PyMenu(self.service, "/setup/models/dpm/collisions/list_all_pair_settings").execute(*args, **kwargs)
                    def collision_pair_settings(self, *args, **kwargs):
                        """
                        Supply settings for collisions to a pair of collision partners.
                        """
                        return PyMenu(self.service, "/setup/models/dpm/collisions/collision_pair_settings").execute(*args, **kwargs)
                    def max_particle_velocity(self, *args, **kwargs):
                        """
                        Set the maximum particle velocity that may arise from collisions.
                        """
                        return PyMenu(self.service, "/setup/models/dpm/collisions/max_particle_velocity").execute(*args, **kwargs)

                    class collision_partners(TUIMenu):
                        """
                        Manage collision partners.
                        """
                        def __init__(self, path, service):
                            self.path = path
                            self.service = service
                            super().__init__(path, service)
                        def create(self, *args, **kwargs):
                            """
                            Create a collision partner.
                            """
                            return PyMenu(self.service, "/setup/models/dpm/collisions/collision_partners/create").execute(*args, **kwargs)
                        def copy(self, *args, **kwargs):
                            """
                            Copy a collision partner.
                            """
                            return PyMenu(self.service, "/setup/models/dpm/collisions/collision_partners/copy").execute(*args, **kwargs)
                        def list(self, *args, **kwargs):
                            """
                            Lists all known collision partners.
                            """
                            return PyMenu(self.service, "/setup/models/dpm/collisions/collision_partners/list").execute(*args, **kwargs)
                        def rename(self, *args, **kwargs):
                            """
                            Rename a collision partner.
                            """
                            return PyMenu(self.service, "/setup/models/dpm/collisions/collision_partners/rename").execute(*args, **kwargs)
                        def delete(self, *args, **kwargs):
                            """
                            Delete a collision partner.
                            """
                            return PyMenu(self.service, "/setup/models/dpm/collisions/collision_partners/delete").execute(*args, **kwargs)

                class erosion_dynamic_mesh(TUIMenu):
                    """
                    Enter the erosion-dynamic mesh interactions menu.
                    """
                    def __init__(self, path, service):
                        self.path = path
                        self.service = service
                        self.general_parameters = self.__class__.general_parameters(path + ["general_parameters"], service)
                        self.run_parameters = self.__class__.run_parameters(path + ["run_parameters"], service)
                        super().__init__(path, service)
                    def enable_erosion_dynamic_mesh_coupling(self, *args, **kwargs):
                        """
                        Enable mesh deformation due to wall erosion.
                        """
                        return PyMenu(self.service, "/setup/models/dpm/erosion_dynamic_mesh/enable_erosion_dynamic_mesh_coupling").execute(*args, **kwargs)
                    def run_simulation(self, *args, **kwargs):
                        """
                        Perform coupled erosion-dynamic mesh simulation.
                        """
                        return PyMenu(self.service, "/setup/models/dpm/erosion_dynamic_mesh/run_simulation").execute(*args, **kwargs)

                    class general_parameters(TUIMenu):
                        """
                        Enter the erosion-dynamic mesh setup menu.
                        """
                        def __init__(self, path, service):
                            self.path = path
                            self.service = service
                            super().__init__(path, service)
                        def erosion_settings(self, *args, **kwargs):
                            """
                            Set erosion modelling specific settings.
                            """
                            return PyMenu(self.service, "/setup/models/dpm/erosion_dynamic_mesh/general_parameters/erosion_settings").execute(*args, **kwargs)
                        def participating_walls(self, *args, **kwargs):
                            """
                            Specify all participating walls.
                            """
                            return PyMenu(self.service, "/setup/models/dpm/erosion_dynamic_mesh/general_parameters/participating_walls").execute(*args, **kwargs)
                        def dynamic_mesh_settings(self, *args, **kwargs):
                            """
                            Perform dynamic mesh related setup.
                            """
                            return PyMenu(self.service, "/setup/models/dpm/erosion_dynamic_mesh/general_parameters/dynamic_mesh_settings").execute(*args, **kwargs)

                    class run_parameters(TUIMenu):
                        """
                        Enter the erosion-dynamic mesh run menu.
                        """
                        def __init__(self, path, service):
                            self.path = path
                            self.service = service
                            super().__init__(path, service)
                        def mesh_motion_time_step(self, *args, **kwargs):
                            """
                            Set the mesh motion time stepping parameters and method.
                            """
                            return PyMenu(self.service, "/setup/models/dpm/erosion_dynamic_mesh/run_parameters/mesh_motion_time_step").execute(*args, **kwargs)
                        def simulation_termination(self, *args, **kwargs):
                            """
                            Set total time of erosion.
                            """
                            return PyMenu(self.service, "/setup/models/dpm/erosion_dynamic_mesh/run_parameters/simulation_termination").execute(*args, **kwargs)
                        def autosave_files(self, *args, **kwargs):
                            """
                            Set the iteration increment to save data files.
                            """
                            return PyMenu(self.service, "/setup/models/dpm/erosion_dynamic_mesh/run_parameters/autosave_files").execute(*args, **kwargs)
                        def autosave_graphics(self, *args, **kwargs):
                            """
                            Set the iteration increment to save graphics files.
                            """
                            return PyMenu(self.service, "/setup/models/dpm/erosion_dynamic_mesh/run_parameters/autosave_graphics").execute(*args, **kwargs)
                        def flow_simulation_control(self, *args, **kwargs):
                            """
                            Set number of iterations per flow simulation step.
                            """
                            return PyMenu(self.service, "/setup/models/dpm/erosion_dynamic_mesh/run_parameters/flow_simulation_control").execute(*args, **kwargs)

        class mesh_interfaces(TUIMenu):
            """
            Enter the mesh-interfaces menu.
            """
            def __init__(self, path, service):
                self.path = path
                self.service = service
                self.mapped_interface_options = self.__class__.mapped_interface_options(path + ["mapped_interface_options"], service)
                self.non_conformal_interface_numerics = self.__class__.non_conformal_interface_numerics(path + ["non_conformal_interface_numerics"], service)
                self.auto_options = self.__class__.auto_options(path + ["auto_options"], service)
                super().__init__(path, service)
            def verbosity(self, *args, **kwargs):
                """
                Set mesh interface verbosity.
                """
                return PyMenu(self.service, "/setup/mesh_interfaces/verbosity").execute(*args, **kwargs)
            def create(self, *args, **kwargs):
                """
                Create a mesh interface.
                """
                return PyMenu(self.service, "/setup/mesh_interfaces/create").execute(*args, **kwargs)
            def improve_quality(self, *args, **kwargs):
                """
                Improve mesh interface quality.
                """
                return PyMenu(self.service, "/setup/mesh_interfaces/improve_quality").execute(*args, **kwargs)
            def make_phaselag_from_boundaries(self, *args, **kwargs):
                """
                Make interface zones phase lagged.
                """
                return PyMenu(self.service, "/setup/mesh_interfaces/make_phaselag_from_boundaries").execute(*args, **kwargs)
            def edit(self, *args, **kwargs):
                """
                Edit a mesh interface.
                """
                return PyMenu(self.service, "/setup/mesh_interfaces/edit").execute(*args, **kwargs)
            def delete_all(self, *args, **kwargs):
                """
                Delete all mesh interfaces.
                """
                return PyMenu(self.service, "/setup/mesh_interfaces/delete_all").execute(*args, **kwargs)
            def delete(self, *args, **kwargs):
                """
                Delete a mesh interface.
                """
                return PyMenu(self.service, "/setup/mesh_interfaces/delete").execute(*args, **kwargs)
            def auto_pairing(self, *args, **kwargs):
                """
                Automatically pair and create mesh interfaces for some or all interface zones.
                """
                return PyMenu(self.service, "/setup/mesh_interfaces/auto_pairing").execute(*args, **kwargs)
            def transfer_motion_across_interfaces(self, *args, **kwargs):
                """
                Transfer motion from one side of the interface to the other when only one side undergoes user-defined or system-coupling motion.
                """
                return PyMenu(self.service, "/setup/mesh_interfaces/transfer_motion_across_interfaces").execute(*args, **kwargs)
            def list(self, *args, **kwargs):
                """
                List all mesh-interfaces.
                """
                return PyMenu(self.service, "/setup/mesh_interfaces/list").execute(*args, **kwargs)
            def make_periodic(self, *args, **kwargs):
                """
                Make interface zones periodic.
                """
                return PyMenu(self.service, "/setup/mesh_interfaces/make_periodic").execute(*args, **kwargs)
            def one_to_one_pairing(self, *args, **kwargs):
                """
                Use the default one-to-one interface creation method?.
                """
                return PyMenu(self.service, "/setup/mesh_interfaces/one_to_one_pairing").execute(*args, **kwargs)
            def enable_si_with_nodes(self, *args, **kwargs):
                """
                Enable sliding interfaces with nodes.
                """
                return PyMenu(self.service, "/setup/mesh_interfaces/enable_si_with_nodes").execute(*args, **kwargs)
            def non_overlapping_zone_name(self, *args, **kwargs):
                """
                Get non-overlapping zone name from the associated interface zone.
                """
                return PyMenu(self.service, "/setup/mesh_interfaces/non_overlapping_zone_name").execute(*args, **kwargs)
            def enforce_coupled_wall_between_solids(self, *args, **kwargs):
                """
                Create coupled wall interface between solids.
                """
                return PyMenu(self.service, "/setup/mesh_interfaces/enforce_coupled_wall_between_solids").execute(*args, **kwargs)
            def enable_visualization_of_interfaces(self, *args, **kwargs):
                """
                Display facets on mesh interfaces.
                """
                return PyMenu(self.service, "/setup/mesh_interfaces/enable_visualization_of_interfaces").execute(*args, **kwargs)
            def remove_left_handed_interface_faces(self, *args, **kwargs):
                """
                Remove left-handed faces during mesh interface creation.
                """
                return PyMenu(self.service, "/setup/mesh_interfaces/remove_left_handed_interface_faces").execute(*args, **kwargs)
            def turbo_create(self, *args, **kwargs):
                """
                Create a general turbo interface.
                """
                return PyMenu(self.service, "/setup/mesh_interfaces/turbo_create").execute(*args, **kwargs)
            def make_phaselag_from_periodic(self, *args, **kwargs):
                """
                Convert periodic interface to phase lagged.
                """
                return PyMenu(self.service, "/setup/mesh_interfaces/make_phaselag_from_periodic").execute(*args, **kwargs)
            def enforce_continuity_after_bc(self, *args, **kwargs):
                """
                Across the interface, enforces continuity over boundary condition.
                """
                return PyMenu(self.service, "/setup/mesh_interfaces/enforce_continuity_after_bc").execute(*args, **kwargs)
            def display(self, *args, **kwargs):
                """
                Display specified mesh interface zone.
                """
                return PyMenu(self.service, "/setup/mesh_interfaces/display").execute(*args, **kwargs)

            class mapped_interface_options(TUIMenu):
                """
                Enter the mapped-interface-options menu.
                """
                def __init__(self, path, service):
                    self.path = path
                    self.service = service
                    super().__init__(path, service)
                def convert_to_mapped_interface(self, *args, **kwargs):
                    """
                    Convert non-conformal mesh interface to mapped mesh interfaces.
                    """
                    return PyMenu(self.service, "/setup/mesh_interfaces/mapped_interface_options/convert_to_mapped_interface").execute(*args, **kwargs)
                def tolerance(self, *args, **kwargs):
                    """
                    Specification of mapped interface tolerance.
                    """
                    return PyMenu(self.service, "/setup/mesh_interfaces/mapped_interface_options/tolerance").execute(*args, **kwargs)
                def solution_controls(self, *args, **kwargs):
                    """
                    Specification of mapped frequency and under-relaxation factor for mapped interfaces.
                    """
                    return PyMenu(self.service, "/setup/mesh_interfaces/mapped_interface_options/solution_controls").execute(*args, **kwargs)

            class non_conformal_interface_numerics(TUIMenu):
                """
                Setting non-conformal numerics options.
                """
                def __init__(self, path, service):
                    self.path = path
                    self.service = service
                    super().__init__(path, service)
                def change_numerics(self, *args, **kwargs):
                    """
                    Enable modified non-conformal interface numerics.
                    """
                    return PyMenu(self.service, "/setup/mesh_interfaces/non_conformal_interface_numerics/change_numerics").execute(*args, **kwargs)

            class auto_options(TUIMenu):
                """
                Enter auto-options menu.
                """
                def __init__(self, path, service):
                    self.path = path
                    self.service = service
                    super().__init__(path, service)
                def set_one_to_one_pairing_tolerance(self, *args, **kwargs):
                    """
                    Enable/disable one-to-one auto pairing tolerance.
                    """
                    return PyMenu(self.service, "/setup/mesh_interfaces/auto_options/set_one_to_one_pairing_tolerance").execute(*args, **kwargs)
                def pairing_between_interface_zones_only(self, *args, **kwargs):
                    """
                    Pairing between interface zones only.
                    """
                    return PyMenu(self.service, "/setup/mesh_interfaces/auto_options/pairing_between_interface_zones_only").execute(*args, **kwargs)
                def set_default_name_prefix(self, *args, **kwargs):
                    """
                    Specification of auto pairing default name prefix.
                    """
                    return PyMenu(self.service, "/setup/mesh_interfaces/auto_options/set_default_name_prefix").execute(*args, **kwargs)
                def keep_empty_interface(self, *args, **kwargs):
                    """
                    Keep empty interfaces during one-to-one mesh interface creation.
                    """
                    return PyMenu(self.service, "/setup/mesh_interfaces/auto_options/keep_empty_interface").execute(*args, **kwargs)
                def naming_option(self, *args, **kwargs):
                    """
                    Specify whether or not to include an informative suffix to the mesh interface name.
                    """
                    return PyMenu(self.service, "/setup/mesh_interfaces/auto_options/naming_option").execute(*args, **kwargs)
                def pairing_between_different_cell_zones_only(self, *args, **kwargs):
                    """
                    Pairing between interface zones from different cell zones only.
                    """
                    return PyMenu(self.service, "/setup/mesh_interfaces/auto_options/pairing_between_different_cell_zones_only").execute(*args, **kwargs)
                def proximity_tolerance(self, *args, **kwargs):
                    """
                    Specification of auto pairing tolerance.
                    """
                    return PyMenu(self.service, "/setup/mesh_interfaces/auto_options/proximity_tolerance").execute(*args, **kwargs)

        class overset_interfaces(TUIMenu):
            """
            Enter the overset-interfaces menu.
            """
            def __init__(self, path, service):
                self.path = path
                self.service = service
                self.cut_control = self.__class__.cut_control(path + ["cut_control"], service)
                self.options = self.__class__.options(path + ["options"], service)
                self.adapt = self.__class__.adapt(path + ["adapt"], service)
                super().__init__(path, service)
            def grid_priorities(self, *args, **kwargs):
                """
                Edit grid priorities for an overset interface.
                """
                return PyMenu(self.service, "/setup/overset_interfaces/grid_priorities").execute(*args, **kwargs)
            def list(self, *args, **kwargs):
                """
                List all overset interfaces.
                """
                return PyMenu(self.service, "/setup/overset_interfaces/list").execute(*args, **kwargs)
            def mark_cell_change(self, *args, **kwargs):
                """
                Mark overset interface related cell type change.
                """
                return PyMenu(self.service, "/setup/overset_interfaces/mark_cell_change").execute(*args, **kwargs)
            def write_dci_to_case(self, *args, **kwargs):
                """
                Save domain connectivity information (DCI) to case file.
                """
                return PyMenu(self.service, "/setup/overset_interfaces/write_dci_to_case").execute(*args, **kwargs)
            def set_mark_bounds(self, *args, **kwargs):
                """
                Set bounds (center, radius) for overset cell marking.
                """
                return PyMenu(self.service, "/setup/overset_interfaces/set_mark_bounds").execute(*args, **kwargs)
            def find_all_bounding_cells(self, *args, **kwargs):
                """
                Find bounding cells for all cell centroids.
                """
                return PyMenu(self.service, "/setup/overset_interfaces/find_all_bounding_cells").execute(*args, **kwargs)
            def check(self, *args, **kwargs):
                """
                Check all overset interfaces.
                """
                return PyMenu(self.service, "/setup/overset_interfaces/check").execute(*args, **kwargs)
            def create(self, *args, **kwargs):
                """
                Create an overset interface.
                """
                return PyMenu(self.service, "/setup/overset_interfaces/create").execute(*args, **kwargs)
            def update_from_dci(self, *args, **kwargs):
                """
                Update all overset intrfaces from stored domain connectivity information (DCI).
                """
                return PyMenu(self.service, "/setup/overset_interfaces/update_from_dci").execute(*args, **kwargs)
            def delete(self, *args, **kwargs):
                """
                Delete an overset interface.
                """
                return PyMenu(self.service, "/setup/overset_interfaces/delete").execute(*args, **kwargs)
            def debug_hole_cut(self, *args, **kwargs):
                """
                Debugging tool for overset hole cutting.
                """
                return PyMenu(self.service, "/setup/overset_interfaces/debug_hole_cut").execute(*args, **kwargs)
            def clear_all(self, *args, **kwargs):
                """
                Clear all overset interfaces.
                """
                return PyMenu(self.service, "/setup/overset_interfaces/clear_all").execute(*args, **kwargs)
            def mark_cells(self, *args, **kwargs):
                """
                Mark overset interface related cell types.
                """
                return PyMenu(self.service, "/setup/overset_interfaces/mark_cells").execute(*args, **kwargs)
            def display_cells(self, *args, **kwargs):
                """
                Display the marked overset cells.
                """
                return PyMenu(self.service, "/setup/overset_interfaces/display_cells").execute(*args, **kwargs)
            def free_dci(self, *args, **kwargs):
                """
                Free overset domain connectivity information (DCI).
                """
                return PyMenu(self.service, "/setup/overset_interfaces/free_dci").execute(*args, **kwargs)
            def intersect(self, *args, **kwargs):
                """
                Intersect an overset interface.
                """
                return PyMenu(self.service, "/setup/overset_interfaces/intersect").execute(*args, **kwargs)
            def intersect_all(self, *args, **kwargs):
                """
                Intersect all overset interfaces.
                """
                return PyMenu(self.service, "/setup/overset_interfaces/intersect_all").execute(*args, **kwargs)
            def write_cell_types(self, *args, **kwargs):
                """
                Write overset cell types into file.
                """
                return PyMenu(self.service, "/setup/overset_interfaces/write_cell_types").execute(*args, **kwargs)
            def clear(self, *args, **kwargs):
                """
                Clear an overset interface.
                """
                return PyMenu(self.service, "/setup/overset_interfaces/clear").execute(*args, **kwargs)
            def read_dci_from_case(self, *args, **kwargs):
                """
                Read domain connectivity information (DCI) from case file.
                """
                return PyMenu(self.service, "/setup/overset_interfaces/read_dci_from_case").execute(*args, **kwargs)
            def write_dci(self, *args, **kwargs):
                """
                Save domain connectivity information (DCI) to a text file.
                """
                return PyMenu(self.service, "/setup/overset_interfaces/write_dci").execute(*args, **kwargs)
            def fill_dci(self, *args, **kwargs):
                """
                Fill overset domain connectivity information (DCI).
                """
                return PyMenu(self.service, "/setup/overset_interfaces/fill_dci").execute(*args, **kwargs)
            def find_bounding_cell(self, *args, **kwargs):
                """
                Find bounding cell for given cell or search point.
                """
                return PyMenu(self.service, "/setup/overset_interfaces/find_bounding_cell").execute(*args, **kwargs)
            def delete_all(self, *args, **kwargs):
                """
                Delete all overset interfaces.
                """
                return PyMenu(self.service, "/setup/overset_interfaces/delete_all").execute(*args, **kwargs)

            class cut_control(TUIMenu):
                """
                Enter the overset hole cut control menu.
                """
                def __init__(self, path, service):
                    self.path = path
                    self.service = service
                    self.cut_seeds = self.__class__.cut_seeds(path + ["cut_seeds"], service)
                    super().__init__(path, service)
                def delete(self, *args, **kwargs):
                    """
                    Delete hole cut control for a boundary zone.
                    """
                    return PyMenu(self.service, "/setup/overset_interfaces/cut_control/delete").execute(*args, **kwargs)
                def add(self, *args, **kwargs):
                    """
                    Add hole cut control for a boundary zone.
                    """
                    return PyMenu(self.service, "/setup/overset_interfaces/cut_control/add").execute(*args, **kwargs)
                def list(self, *args, **kwargs):
                    """
                    List the defined hole cut controls.
                    """
                    return PyMenu(self.service, "/setup/overset_interfaces/cut_control/list").execute(*args, **kwargs)
                def delete_all(self, *args, **kwargs):
                    """
                    Delete the hole cut controls for all boundary zones.
                    """
                    return PyMenu(self.service, "/setup/overset_interfaces/cut_control/delete_all").execute(*args, **kwargs)

                class cut_seeds(TUIMenu):
                    """
                    Enter the overset hole cut seed menu.
                    """
                    def __init__(self, path, service):
                        self.path = path
                        self.service = service
                        super().__init__(path, service)
                    def delete(self, *args, **kwargs):
                        """
                        Delete a hole cut seed.
                        """
                        return PyMenu(self.service, "/setup/overset_interfaces/cut_control/cut_seeds/delete").execute(*args, **kwargs)
                    def list(self, *args, **kwargs):
                        """
                        List the defined hole cut seeds.
                        """
                        return PyMenu(self.service, "/setup/overset_interfaces/cut_control/cut_seeds/list").execute(*args, **kwargs)
                    def add(self, *args, **kwargs):
                        """
                        Add a hole cut seed.
                        """
                        return PyMenu(self.service, "/setup/overset_interfaces/cut_control/cut_seeds/add").execute(*args, **kwargs)
                    def delete_all(self, *args, **kwargs):
                        """
                        Delete all hole cut seeds.
                        """
                        return PyMenu(self.service, "/setup/overset_interfaces/cut_control/cut_seeds/delete_all").execute(*args, **kwargs)
                    def cut_seeds_for_all_component_zones(self, *args, **kwargs):
                        """
                        Enable that all component zones get a cut seed.
                        """
                        return PyMenu(self.service, "/setup/overset_interfaces/cut_control/cut_seeds/cut_seeds_for_all_component_zones").execute(*args, **kwargs)

            class options(TUIMenu):
                """
                Enter the overset interface options menu.
                """
                def __init__(self, path, service):
                    self.path = path
                    self.service = service
                    super().__init__(path, service)
                def solve_island_removal(self, *args, **kwargs):
                    """
                    Set method used to control the removal of isolated patches of solve cells.
                    """
                    return PyMenu(self.service, "/setup/overset_interfaces/options/solve_island_removal").execute(*args, **kwargs)
                def transient_caching(self, *args, **kwargs):
                    """
                    Set options to control caching of entities in transient overset simulations.
                    """
                    return PyMenu(self.service, "/setup/overset_interfaces/options/transient_caching").execute(*args, **kwargs)
                def modified_donor_search(self, *args, **kwargs):
                    """
                    Enable modified and more extensive donor search.
                    """
                    return PyMenu(self.service, "/setup/overset_interfaces/options/modified_donor_search").execute(*args, **kwargs)
                def dead_cell_update(self, *args, **kwargs):
                    """
                    Enable dead cell update in moving or dynamic mesh simulations.
                    """
                    return PyMenu(self.service, "/setup/overset_interfaces/options/dead_cell_update").execute(*args, **kwargs)
                def overlap_boundaries(self, *args, **kwargs):
                    """
                    Enable overset topologies with overlap boundaries.
                    """
                    return PyMenu(self.service, "/setup/overset_interfaces/options/overlap_boundaries").execute(*args, **kwargs)
                def auto_create(self, *args, **kwargs):
                    """
                    Enable automatic creation of default overset interface.
                    """
                    return PyMenu(self.service, "/setup/overset_interfaces/options/auto_create").execute(*args, **kwargs)
                def parallel(self, *args, **kwargs):
                    """
                    Set options to control running overset in parallel.
                    """
                    return PyMenu(self.service, "/setup/overset_interfaces/options/parallel").execute(*args, **kwargs)
                def node_connected_donors(self, *args, **kwargs):
                    """
                    Enable node or face connected donor cells.
                    """
                    return PyMenu(self.service, "/setup/overset_interfaces/options/node_connected_donors").execute(*args, **kwargs)
                def mesh_interfaces(self, *args, **kwargs):
                    """
                    Allow mesh interfaces inside overset cell zones.
                    """
                    return PyMenu(self.service, "/setup/overset_interfaces/options/mesh_interfaces").execute(*args, **kwargs)
                def expert(self, *args, **kwargs):
                    """
                    Enable additional overset options and tools.
                    """
                    return PyMenu(self.service, "/setup/overset_interfaces/options/expert").execute(*args, **kwargs)
                def render_receptor_cells(self, *args, **kwargs):
                    """
                    Set the option to include receptor cells in postprocessing.
                    """
                    return PyMenu(self.service, "/setup/overset_interfaces/options/render_receptor_cells").execute(*args, **kwargs)
                def update_before_case_write(self, *args, **kwargs):
                    """
                    Enable update of overset interfaces before writing case file (CFF format only).
                    """
                    return PyMenu(self.service, "/setup/overset_interfaces/options/update_before_case_write").execute(*args, **kwargs)
                def modified_hole_cutting(self, *args, **kwargs):
                    """
                    Enable modified hole cutting parameters.
                    """
                    return PyMenu(self.service, "/setup/overset_interfaces/options/modified_hole_cutting").execute(*args, **kwargs)
                def minimize_overlap(self, *args, **kwargs):
                    """
                    Enable overlap minimization for overset interfaces.
                    """
                    return PyMenu(self.service, "/setup/overset_interfaces/options/minimize_overlap").execute(*args, **kwargs)
                def partial_cut_faces(self, *args, **kwargs):
                    """
                    Enable enhanced hole cutting where cut faces partially overlap.
                    """
                    return PyMenu(self.service, "/setup/overset_interfaces/options/partial_cut_faces").execute(*args, **kwargs)
                def verbosity(self, *args, **kwargs):
                    """
                    Set overset mesh reporting verbosity.
                    """
                    return PyMenu(self.service, "/setup/overset_interfaces/options/verbosity").execute(*args, **kwargs)
                def donor_priority_method(self, *args, **kwargs):
                    """
                    Set method used to evaludate the cell donor priority.
                    """
                    return PyMenu(self.service, "/setup/overset_interfaces/options/donor_priority_method").execute(*args, **kwargs)

            class adapt(TUIMenu):
                """
                Enter the overset adaption menu.
                """
                def __init__(self, path, service):
                    self.path = path
                    self.service = service
                    self.set = self.__class__.set(path + ["set"], service)
                    super().__init__(path, service)
                def adapt_mesh(self, *args, **kwargs):
                    """
                    Mark and adapt the mesh to remove orphan cells and large donor-receptor cell size differences.
                    """
                    return PyMenu(self.service, "/setup/overset_interfaces/adapt/adapt_mesh").execute(*args, **kwargs)
                def mark_adaption(self, *args, **kwargs):
                    """
                    Mark cells for overset orphan adaption and donor-receptor size differences.
                    """
                    return PyMenu(self.service, "/setup/overset_interfaces/adapt/mark_adaption").execute(*args, **kwargs)

                class set(TUIMenu):
                    """
                    Enter the overset adaption set menu.
                    """
                    def __init__(self, path, service):
                        self.path = path
                        self.service = service
                        super().__init__(path, service)
                    def mark_orphans(self, *args, **kwargs):
                        """
                        Enable the option to adapt for orphan reduction.
                        """
                        return PyMenu(self.service, "/setup/overset_interfaces/adapt/set/mark_orphans").execute(*args, **kwargs)
                    def length_ratio_max(self, *args, **kwargs):
                        """
                        Set the length scale ratio threshold used to determine which cells are marked for adaption based on donor-receptor cell size differences.
                        """
                        return PyMenu(self.service, "/setup/overset_interfaces/adapt/set/length_ratio_max").execute(*args, **kwargs)
                    def buffer_layers(self, *args, **kwargs):
                        """
                        Set the number of cell layers marked in addition to the cells marked for orphan adaption.
                        """
                        return PyMenu(self.service, "/setup/overset_interfaces/adapt/set/buffer_layers").execute(*args, **kwargs)
                    def gap_resolution(self, *args, **kwargs):
                        """
                        Set the target (minimum) gap resolution used when marking cells for gap adaption.
                        """
                        return PyMenu(self.service, "/setup/overset_interfaces/adapt/set/gap_resolution").execute(*args, **kwargs)
                    def mark_gaps(self, *args, **kwargs):
                        """
                        Enable the option to adapt underresolved gaps.
                        """
                        return PyMenu(self.service, "/setup/overset_interfaces/adapt/set/mark_gaps").execute(*args, **kwargs)
                    def automatic(self, *args, **kwargs):
                        """
                        Enable the option to automatically adapt overset meshes during solution update.
                        """
                        return PyMenu(self.service, "/setup/overset_interfaces/adapt/set/automatic").execute(*args, **kwargs)
                    def adaption_sweeps(self, *args, **kwargs):
                        """
                        Set the number of adaption sweeps per overset adaption.
                        """
                        return PyMenu(self.service, "/setup/overset_interfaces/adapt/set/adaption_sweeps").execute(*args, **kwargs)
                    def maximum_refinement_level(self, *args, **kwargs):
                        """
                        Set the maximum level of refinement in overset adaption.
                        """
                        return PyMenu(self.service, "/setup/overset_interfaces/adapt/set/maximum_refinement_level").execute(*args, **kwargs)
                    def anisotropic(self, *args, **kwargs):
                        """
                        Enable the option to use anisotropic adaption in prismatic cells.
                        """
                        return PyMenu(self.service, "/setup/overset_interfaces/adapt/set/anisotropic").execute(*args, **kwargs)
                    def mark_size(self, *args, **kwargs):
                        """
                        Enable the option to adapt for donor-receptor cell size differences.
                        """
                        return PyMenu(self.service, "/setup/overset_interfaces/adapt/set/mark_size").execute(*args, **kwargs)
                    def mark_fixed_orphans(self, *args, **kwargs):
                        """
                        Enable the option to adapt for orphans which were removed by accepting neighbor donors.
                        """
                        return PyMenu(self.service, "/setup/overset_interfaces/adapt/set/mark_fixed_orphans").execute(*args, **kwargs)
                    def mark_coarsening(self, *args, **kwargs):
                        """
                        Enable the option to coarsen the mesh during overset adaption.
                        """
                        return PyMenu(self.service, "/setup/overset_interfaces/adapt/set/mark_coarsening").execute(*args, **kwargs)

        class named_expressions(TUIMenu):
            """
            Manage named expressions.
            """
            def __init__(self, path, service):
                self.path = path
                self.service = service
                super().__init__(path, service)
            def list(self, *args, **kwargs):
                """
                List objects.
                """
                return PyMenu(self.service, "/setup/named_expressions/list").execute(*args, **kwargs)
            def list_properties(self, *args, **kwargs):
                """
                List properties of an object.
                """
                return PyMenu(self.service, "/setup/named_expressions/list_properties").execute(*args, **kwargs)
            def add(self, *args, **kwargs):
                """
                Add a new object.
                """
                return PyMenu(self.service, "/setup/named_expressions/add").execute(*args, **kwargs)
            def edit(self, *args, **kwargs):
                """
                Edit an object.
                """
                return PyMenu(self.service, "/setup/named_expressions/edit").execute(*args, **kwargs)
            def import_from_tsv(self, *args, **kwargs):
                """
                Export expressions.
                """
                return PyMenu(self.service, "/setup/named_expressions/import_from_tsv").execute(*args, **kwargs)
            def export_to_tsv(self, *args, **kwargs):
                """
                Export expressions.
                """
                return PyMenu(self.service, "/setup/named_expressions/export_to_tsv").execute(*args, **kwargs)
            def copy(self, *args, **kwargs):
                """
                Copy expression.
                """
                return PyMenu(self.service, "/setup/named_expressions/copy").execute(*args, **kwargs)
            def delete(self, *args, **kwargs):
                """
                Delete an object.
                """
                return PyMenu(self.service, "/setup/named_expressions/delete").execute(*args, **kwargs)
            def compute(self, *args, **kwargs):
                """
                Compute expression.
                """
                return PyMenu(self.service, "/setup/named_expressions/compute").execute(*args, **kwargs)

        class gap_model(TUIMenu):
            """
            Enter the narrow-gaps menu.
            """
            def __init__(self, path, service):
                self.path = path
                self.service = service
                self.advanced_options = self.__class__.advanced_options(path + ["advanced_options"], service)
                super().__init__(path, service)
            def delete_all(self, *args, **kwargs):
                """
                Delete all of the exiting gap objects.
                """
                return PyMenu(self.service, "/setup/gap_model/delete_all").execute(*args, **kwargs)
            def render_gap_regions(self, *args, **kwargs):
                """
                Update gap regions for postprocessing.
                """
                return PyMenu(self.service, "/setup/gap_model/render_gap_regions").execute(*args, **kwargs)
            def list_gap_face_zones(self, *args, **kwargs):
                """
                List name of the gap face zones that can be used for gaps creation.
                """
                return PyMenu(self.service, "/setup/gap_model/list_gap_face_zones").execute(*args, **kwargs)
            def delete(self, *args, **kwargs):
                """
                Delete an exiting gap object.
                """
                return PyMenu(self.service, "/setup/gap_model/delete").execute(*args, **kwargs)
            def list_gap_regions(self, *args, **kwargs):
                """
                List gap regions.
                """
                return PyMenu(self.service, "/setup/gap_model/list_gap_regions").execute(*args, **kwargs)
            def create(self, *args, **kwargs):
                """
                Create a gap object.
                """
                return PyMenu(self.service, "/setup/gap_model/create").execute(*args, **kwargs)
            def edit(self, *args, **kwargs):
                """
                Edit an exiting gap object.
                """
                return PyMenu(self.service, "/setup/gap_model/edit").execute(*args, **kwargs)
            def enable(self, *args, **kwargs):
                """
                Enable/Disable gap model.
                """
                return PyMenu(self.service, "/setup/gap_model/enable").execute(*args, **kwargs)
            def list_gap_cell_zones(self, *args, **kwargs):
                """
                List name of the gap cells zones that can be used as exclided cell zones in gaps creation.
                """
                return PyMenu(self.service, "/setup/gap_model/list_gap_cell_zones").execute(*args, **kwargs)

            class advanced_options(TUIMenu):
                """
                Show options.
                """
                def __init__(self, path, service):
                    self.path = path
                    self.service = service
                    super().__init__(path, service)
                def revert_controls_to_default(self, *args, **kwargs):
                    """
                    Revert gap stabilization and any related solver settings to default.
                    """
                    return PyMenu(self.service, "/setup/gap_model/advanced_options/revert_controls_to_default").execute(*args, **kwargs)
                def cell_check_distance_factor(self, *args, **kwargs):
                    """
                    Enter value of the cell distance factor.
                    """
                    return PyMenu(self.service, "/setup/gap_model/advanced_options/cell_check_distance_factor").execute(*args, **kwargs)
                def sponge_layer(self, *args, **kwargs):
                    """
                    Set advanced settings for gap sponge layer.
                    """
                    return PyMenu(self.service, "/setup/gap_model/advanced_options/sponge_layer").execute(*args, **kwargs)
                def render_flow_modeling_gaps(self, *args, **kwargs):
                    """
                    Render solution inside flow modeling gap cells.
                    """
                    return PyMenu(self.service, "/setup/gap_model/advanced_options/render_flow_modeling_gaps").execute(*args, **kwargs)
                def solution_stabilization(self, *args, **kwargs):
                    """
                    Set solution stabilization level for gap model.
                    """
                    return PyMenu(self.service, "/setup/gap_model/advanced_options/solution_stabilization").execute(*args, **kwargs)
                def include_coupled_walls(self, *args, **kwargs):
                    """
                    Include coupled walls in gap face zones.
                    """
                    return PyMenu(self.service, "/setup/gap_model/advanced_options/include_coupled_walls").execute(*args, **kwargs)
                def reduce_gap_regions(self, *args, **kwargs):
                    """
                    Using a more restrictive algorithm for marking cells in gap regions.
                    """
                    return PyMenu(self.service, "/setup/gap_model/advanced_options/reduce_gap_regions").execute(*args, **kwargs)
                def fill_data_in_gap_regions(self, *args, **kwargs):
                    """
                    Interpolate solution data into the whole gap regions.
                    """
                    return PyMenu(self.service, "/setup/gap_model/advanced_options/fill_data_in_gap_regions").execute(*args, **kwargs)
                def precise_gap_marking(self, *args, **kwargs):
                    """
                    Mark cells in gap regions using more accurate search algorithm.
                    """
                    return PyMenu(self.service, "/setup/gap_model/advanced_options/precise_gap_marking").execute(*args, **kwargs)
                def extend_gap_regions(self, *args, **kwargs):
                    """
                    Extend gap regions for better convergence.
                    """
                    return PyMenu(self.service, "/setup/gap_model/advanced_options/extend_gap_regions").execute(*args, **kwargs)
                def verbosity(self, *args, **kwargs):
                    """
                    Set the verbosity for gap model.
                    """
                    return PyMenu(self.service, "/setup/gap_model/advanced_options/verbosity").execute(*args, **kwargs)
                def flow_blocking_stabilization_parameters(self, *args, **kwargs):
                    """
                    Adjust stabilization settings for the sponge layer used for blocked gap regions.
                    """
                    return PyMenu(self.service, "/setup/gap_model/advanced_options/flow_blocking_stabilization_parameters").execute(*args, **kwargs)
                def enhanced_data_interpolation(self, *args, **kwargs):
                    """
                    Use enhanced data interpolation for updating information in gap regions.
                    """
                    return PyMenu(self.service, "/setup/gap_model/advanced_options/enhanced_data_interpolation").execute(*args, **kwargs)
                def expert(self, *args, **kwargs):
                    """
                    Enable expert options for gap model.
                    """
                    return PyMenu(self.service, "/setup/gap_model/advanced_options/expert").execute(*args, **kwargs)
                def update_gap_regions(self, *args, **kwargs):
                    """
                    Update gap regions and gap model solution information.
                    """
                    return PyMenu(self.service, "/setup/gap_model/advanced_options/update_gap_regions").execute(*args, **kwargs)
                def alternative_marking(self, *args, **kwargs):
                    """
                    Mark gap regions using an alternative marking algorithm.
                    """
                    return PyMenu(self.service, "/setup/gap_model/advanced_options/alternative_marking").execute(*args, **kwargs)
                def clear_gap_regions(self, *args, **kwargs):
                    """
                    Clear gap model solution information and marks.
                    """
                    return PyMenu(self.service, "/setup/gap_model/advanced_options/clear_gap_regions").execute(*args, **kwargs)
                def render_gap_interface(self, *args, **kwargs):
                    """
                    Render gap interface.
                    """
                    return PyMenu(self.service, "/setup/gap_model/advanced_options/render_gap_interface").execute(*args, **kwargs)
                def check_cfl_condition(self, *args, **kwargs):
                    """
                    Check time step size for better convergence.
                    """
                    return PyMenu(self.service, "/setup/gap_model/advanced_options/check_cfl_condition").execute(*args, **kwargs)

        class expert(TUIMenu):
            """
            Enter expert setup menu.
            """
            def __init__(self, path, service):
                self.path = path
                self.service = service
                self.spectral = self.__class__.spectral(path + ["spectral"], service)
                super().__init__(path, service)
            def stiff_chemistry(self, *args, **kwargs):
                """
                Set solver options for stiff-chemistry solutions.
                """
                return PyMenu(self.service, "/setup/expert/stiff_chemistry").execute(*args, **kwargs)
            def beta_feature_access(self, *args, **kwargs):
                """
                Enable access to beta features in the interface.
                """
                return PyMenu(self.service, "/setup/expert/beta_feature_access").execute(*args, **kwargs)
            def enable_mesh_morpher_optimizer(self, *args, **kwargs):
                """
                Enable use of mesh morpher/optimizer.
                """
                return PyMenu(self.service, "/setup/expert/enable_mesh_morpher_optimizer").execute(*args, **kwargs)
            def heterogeneous_stiff_chemistry(self, *args, **kwargs):
                """
                Set heterogeneous stiff-chemistry solver.
                """
                return PyMenu(self.service, "/setup/expert/heterogeneous_stiff_chemistry").execute(*args, **kwargs)

            class spectral(TUIMenu):
                """
                Enter the Spectral menu.
                """
                def __init__(self, path, service):
                    self.path = path
                    self.service = service
                    super().__init__(path, service)
                def delete_harmonic_exports(self, *args, **kwargs):
                    """
                    Deletes Harmonic Export data.
                    """
                    return PyMenu(self.service, "/setup/expert/spectral/delete_harmonic_exports").execute(*args, **kwargs)
                def calculate_harmonic_exports(self, *args, **kwargs):
                    """
                    Calculates Harmonic Export data.
                    """
                    return PyMenu(self.service, "/setup/expert/spectral/calculate_harmonic_exports").execute(*args, **kwargs)
                def delete_fourier_coefficients(self, *args, **kwargs):
                    """
                    Deletes Fourier coefficient data.
                    """
                    return PyMenu(self.service, "/setup/expert/spectral/delete_fourier_coefficients").execute(*args, **kwargs)
                def calculate_fourier_coefficients(self, *args, **kwargs):
                    """
                    Calculates Fourier coefficient data.
                    """
                    return PyMenu(self.service, "/setup/expert/spectral/calculate_fourier_coefficients").execute(*args, **kwargs)

    class parallel(TUIMenu):
        """
        Enter the parallel processing menu.
        """
        def __init__(self, path, service):
            self.path = path
            self.service = service
            self.gpgpu = self.__class__.gpgpu(path + ["gpgpu"], service)
            super().__init__(path, service)
        def bandwidth(self, *args, **kwargs):
            """
            Shows network bandwidth.
            """
            return PyMenu(self.service, "/parallel/bandwidth").execute(*args, **kwargs)
        def check_verbosity(self, *args, **kwargs):
            """
            Sets verbosity output of the parallel check. Higher verbosity corresponds to more detailed information.
            """
            return PyMenu(self.service, "/parallel/check_verbosity").execute(*args, **kwargs)
        def latency(self, *args, **kwargs):
            """
            Shows network latency.
            """
            return PyMenu(self.service, "/parallel/latency").execute(*args, **kwargs)
        def timer(self, *args, **kwargs):
            """
            Enters the timer menu.
            """
            return PyMenu(self.service, "/parallel/timer").execute(*args, **kwargs)
        def multidomain(self, *args, **kwargs):
            """
            Enters the multidomain architecture menu.
            """
            return PyMenu(self.service, "/parallel/multidomain").execute(*args, **kwargs)
        def partition(self, *args, **kwargs):
            """
            Enters the partition domain menu.
            """
            return PyMenu(self.service, "/parallel/partition").execute(*args, **kwargs)
        def network(self, *args, **kwargs):
            """
            Enter the network configuration menu.
            """
            return PyMenu(self.service, "/parallel/network").execute(*args, **kwargs)
        def show_connectivity(self, *args, **kwargs):
            """
            Prints the network connectivity for the selected compute node.
            """
            return PyMenu(self.service, "/parallel/show_connectivity").execute(*args, **kwargs)
        def check(self, *args, **kwargs):
            """
            Performs checks of various factors that affect parallel performance.
            """
            return PyMenu(self.service, "/parallel/check").execute(*args, **kwargs)
        def thread_number_control(self, *args, **kwargs):
            """
            Thread number control.
            """
            return PyMenu(self.service, "/parallel/thread_number_control").execute(*args, **kwargs)
        def load_balance(self, *args, **kwargs):
            """
            Enters the load balancing parameters menu.
            """
            return PyMenu(self.service, "/parallel/load_balance").execute(*args, **kwargs)
        def set(self, *args, **kwargs):
            """
            Enters the set parallel parameters menu.
            """
            return PyMenu(self.service, "/parallel/set").execute(*args, **kwargs)

        class gpgpu(TUIMenu):
            """
            Enters the GPGPU menu.
            """
            def __init__(self, path, service):
                self.path = path
                self.service = service
                super().__init__(path, service)
            def select(self, *args, **kwargs):
                """
                Selects which GPGPUs to use for AMG acceleration.
                """
                return PyMenu(self.service, "/parallel/gpgpu/select").execute(*args, **kwargs)
            def show(self, *args, **kwargs):
                """
                Lists the available GPGPUs. GPGPUs selected for use are indicated by the presence of an asterisk (\*).
                """
                return PyMenu(self.service, "/parallel/gpgpu/show").execute(*args, **kwargs)

    class turbo_post(TUIMenu):
        """
        Enter the turbo menu.
        """
        def __init__(self, path, service):
            self.path = path
            self.service = service
            super().__init__(path, service)
        def write_report(self, *args, **kwargs):
            """
            Writes the turbo report to file.
            """
            return PyMenu(self.service, "/turbo_post/write_report").execute(*args, **kwargs)
        def compute_report(self, *args, **kwargs):
            """
            Computes turbomachinery quantities.
            """
            return PyMenu(self.service, "/turbo_post/compute_report").execute(*args, **kwargs)
        def avg_contours(self, *args, **kwargs):
            """
            Displays average contours.
            """
            return PyMenu(self.service, "/turbo_post/avg_contours").execute(*args, **kwargs)
        def xy_plot_avg(self, *args, **kwargs):
            """
            Displays average XY plots.
            """
            return PyMenu(self.service, "/turbo_post/xy_plot_avg").execute(*args, **kwargs)
        def current_topology(self, *args, **kwargs):
            """
            Sets the current turbo topology for global use.
            """
            return PyMenu(self.service, "/turbo_post/current_topology").execute(*args, **kwargs)
        def two_d_contours(self, *args, **kwargs):
            """
            Display 2d contours.
            """
            return PyMenu(self.service, "/turbo_post/two_d_contours").execute(*args, **kwargs)

    class mesh(TUIMenu):
        """
        Enter the mesh menu.
        """
        def __init__(self, path, service):
            self.path = path
            self.service = service
            self.surface_mesh = self.__class__.surface_mesh(path + ["surface_mesh"], service)
            self.geometry = self.__class__.geometry(path + ["geometry"], service)
            self.reorder = self.__class__.reorder(path + ["reorder"], service)
            self.modify_zones = self.__class__.modify_zones(path + ["modify_zones"], service)
            self.adapt = self.__class__.adapt(path + ["adapt"], service)
            self.polyhedra = self.__class__.polyhedra(path + ["polyhedra"], service)
            self.repair_improve = self.__class__.repair_improve(path + ["repair_improve"], service)
            super().__init__(path, service)
        def units(self, *args, **kwargs):
            """
            Set unit conversion factors.
            """
            return PyMenu(self.service, "/mesh/units").execute(*args, **kwargs)
        def swap_mesh_faces(self, *args, **kwargs):
            """
            Swaps mesh faces.
            """
            return PyMenu(self.service, "/mesh/swap_mesh_faces").execute(*args, **kwargs)
        def adjacency(self, *args, **kwargs):
            """
            Views and renames face zones adjacent to selected cell  zones.
            """
            return PyMenu(self.service, "/mesh/adjacency").execute(*args, **kwargs)
        def smooth_mesh(self, *args, **kwargs):
            """
            Smooths the mesh using quality-based, Laplacian, or skewness methods.
            """
            return PyMenu(self.service, "/mesh/smooth_mesh").execute(*args, **kwargs)
        def translate(self, *args, **kwargs):
            """
            Prompts for the translation offset in each of the active Cartesian coordinate directions.
            """
            return PyMenu(self.service, "/mesh/translate").execute(*args, **kwargs)
        def redistribute_boundary_layer(self, *args, **kwargs):
            """
            Redistributes the nodes in a boundary layer zone to achieve a desired growth rate after anisotropic adaption.
            """
            return PyMenu(self.service, "/mesh/redistribute_boundary_layer").execute(*args, **kwargs)
        def check(self, *args, **kwargs):
            """
            Performs various mesh consistency checks and displays a report in the console that lists the domain extents, the volume statistics, the face area statistics, and any warnings, as well as details about the various checks and mesh failures (depending on the setting specified for mesh/check-verbosity).
            """
            return PyMenu(self.service, "/mesh/check").execute(*args, **kwargs)
        def mesh_info(self, *args, **kwargs):
            """
            Prints zone information size.
            """
            return PyMenu(self.service, "/mesh/mesh_info").execute(*args, **kwargs)
        def show_periodic_shadow_zones(self, *args, **kwargs):
            """
            Option to show periodic shadow zones in user interface.
            """
            return PyMenu(self.service, "/mesh/show_periodic_shadow_zones").execute(*args, **kwargs)
        def set_unit_system(self, *args, **kwargs):
            """
            To apply standard set of units to all quantities.
            """
            return PyMenu(self.service, "/mesh/set_unit_system").execute(*args, **kwargs)
        def rotate(self, *args, **kwargs):
            """
            Rotates the mesh.
            """
            return PyMenu(self.service, "/mesh/rotate").execute(*args, **kwargs)
        def enhanced_orthogonal_quality(self, *args, **kwargs):
            """
            Enables / disables an enhanced definition when calculating the orthogonal quality. When enabled, the orthogonal quality is defined using a variety quality measures, including: the orthogonality of a face relative to a vector between the face and cell centroids; a metric that detects poor cell shape at a local edge (such as twisting and/or concavity); and the variation of normals between the faces that can be constructed from the cell face. This enhanced definition is optimal for evaluating thin prism cells.
            """
            return PyMenu(self.service, "/mesh/enhanced_orthogonal_quality").execute(*args, **kwargs)
        def replace(self, *args, **kwargs):
            """
            Replace mesh and interpolate data.
            """
            return PyMenu(self.service, "/mesh/replace").execute(*args, **kwargs)
        def size_info(self, *args, **kwargs):
            """
            Prints mesh size.
            """
            return PyMenu(self.service, "/mesh/size_info").execute(*args, **kwargs)
        def memory_usage(self, *args, **kwargs):
            """
            Reports solver memory use.
            """
            return PyMenu(self.service, "/mesh/memory_usage").execute(*args, **kwargs)
        def check_verbosity(self, *args, **kwargs):
            """
            Sets the level of details that will be added to the mesh check report generated by mesh/check. A value of 0 (the default) notes when checks are being performed, but does not list them individually. A value of 1 lists the individual checks as they are performed. A value of 2 enables the availability of additional mesh field variables, lists the individual checks as they are performed, and provides additional details (for example, the location of the problem, the affected cells).  The check-verbosity text command can also be used to set the level of detail displayed in the mesh quality report generated by mesh/quality. A value of 0 (the default) or 1 lists the minimum orthogonal quality and the maximum aspect ratio. A value of 2 adds information about the zones that contain the cells with the lowest quality, and additional metrics such as the maximum cell squish index and the minimum expansion ratio.
            """
            return PyMenu(self.service, "/mesh/check_verbosity").execute(*args, **kwargs)
        def quality(self, *args, **kwargs):
            """
            Displays information about the quality of the mesh in the console, including the minimum orthogonal quality and the maximum aspect ratio. The level of detail displayed depends on the setting specified for mesh/check-verbosity.
            """
            return PyMenu(self.service, "/mesh/quality").execute(*args, **kwargs)
        def scale(self, *args, **kwargs):
            """
            Prompts for the scaling factors in each of the active Cartesian coordinate directions.
            """
            return PyMenu(self.service, "/mesh/scale").execute(*args, **kwargs)
        def check_before_solve(self, *args, **kwargs):
            """
            The default value for mesh/check-before-solve is “no”. If mesh/check-before-solve is set to “yes”, a mesh check operation will be invoked prior to starting solver. If grid check fails, solver will be interrupted, and relevant information will be printed in the Fluent console.
            """
            return PyMenu(self.service, "/mesh/check_before_solve").execute(*args, **kwargs)

        class surface_mesh(TUIMenu):
            """
            Enters the Surface Mesh menu.
            """
            def __init__(self, path, service):
                self.path = path
                self.service = service
                super().__init__(path, service)
            def delete(self, *args, **kwargs):
                """
                Deletes surface mesh.
                """
                return PyMenu(self.service, "/mesh/surface_mesh/delete").execute(*args, **kwargs)
            def read(self, *args, **kwargs):
                """
                Reads surface meshes.
                """
                return PyMenu(self.service, "/mesh/surface_mesh/read").execute(*args, **kwargs)
            def display(self, *args, **kwargs):
                """
                Displays surface meshes.
                """
                return PyMenu(self.service, "/mesh/surface_mesh/display").execute(*args, **kwargs)

        class geometry(TUIMenu):
            """
            Enter the geometry menu.
            """
            def __init__(self, path, service):
                self.path = path
                self.service = service
                super().__init__(path, service)
            def add(self, *args, **kwargs):
                """
                Add a new object.
                """
                return PyMenu(self.service, "/mesh/geometry/add").execute(*args, **kwargs)
            def display(self, *args, **kwargs):
                """
                Display geometry.
                """
                return PyMenu(self.service, "/mesh/geometry/display").execute(*args, **kwargs)
            def list(self, *args, **kwargs):
                """
                List objects.
                """
                return PyMenu(self.service, "/mesh/geometry/list").execute(*args, **kwargs)
            def list_properties(self, *args, **kwargs):
                """
                List properties of an object.
                """
                return PyMenu(self.service, "/mesh/geometry/list_properties").execute(*args, **kwargs)
            def edit(self, *args, **kwargs):
                """
                Edit an object.
                """
                return PyMenu(self.service, "/mesh/geometry/edit").execute(*args, **kwargs)
            def delete(self, *args, **kwargs):
                """
                Delete an object.
                """
                return PyMenu(self.service, "/mesh/geometry/delete").execute(*args, **kwargs)

        class reorder(TUIMenu):
            """
            Reorders domain menu.
            """
            def __init__(self, path, service):
                self.path = path
                self.service = service
                super().__init__(path, service)
            def band_width(self, *args, **kwargs):
                """
                Prints cell bandwidth.
                """
                return PyMenu(self.service, "/mesh/reorder/band_width").execute(*args, **kwargs)
            def reorder_domain(self, *args, **kwargs):
                """
                Reorders cells and faces using the reverse Cuthill-McKee algorithm. Note that you must save a new case file (and a data file, if data exists) after reordering with this text command, as well as recreate any ray files and/or surface cluster information.
                """
                return PyMenu(self.service, "/mesh/reorder/reorder_domain").execute(*args, **kwargs)
            def reorder_zones(self, *args, **kwargs):
                """
                Reorders zones by partition, type, and ID.
                """
                return PyMenu(self.service, "/mesh/reorder/reorder_zones").execute(*args, **kwargs)

        class modify_zones(TUIMenu):
            """
            Enters the zone modification menu. For a description of the items in this menu, see define/boundary-conditions/modify-zones.
            """
            def __init__(self, path, service):
                self.path = path
                self.service = service
                super().__init__(path, service)
            def slit_periodic(self, *args, **kwargs):
                """
                Slit a periodic zone into two symmetry zones.
                """
                return PyMenu(self.service, "/mesh/modify_zones/slit_periodic").execute(*args, **kwargs)
            def zone_name(self, *args, **kwargs):
                """
                Give a zone a new name.
                """
                return PyMenu(self.service, "/mesh/modify_zones/zone_name").execute(*args, **kwargs)
            def slit_interior_between_diff_solids(self, *args, **kwargs):
                """
                Slit interior created between different solids into coupled walls.
                """
                return PyMenu(self.service, "/mesh/modify_zones/slit_interior_between_diff_solids").execute(*args, **kwargs)
            def merge_zones(self, *args, **kwargs):
                """
                Merge zones of the same type and condition into one.
                """
                return PyMenu(self.service, "/mesh/modify_zones/merge_zones").execute(*args, **kwargs)
            def rotate_zone(self, *args, **kwargs):
                """
                Rotate nodal coordinates of input cell zones.
                """
                return PyMenu(self.service, "/mesh/modify_zones/rotate_zone").execute(*args, **kwargs)
            def matching_tolerance(self, *args, **kwargs):
                """
                Set the normalized tolerance used for finding coincident nodes.
                """
                return PyMenu(self.service, "/mesh/modify_zones/matching_tolerance").execute(*args, **kwargs)
            def fuse_face_zones(self, *args, **kwargs):
                """
                Attempt to fuse zones by removing duplicate faces and nodes.
                """
                return PyMenu(self.service, "/mesh/modify_zones/fuse_face_zones").execute(*args, **kwargs)
            def sep_face_zone_region(self, *args, **kwargs):
                """
                Separate a face zone based on contiguous regions.
                """
                return PyMenu(self.service, "/mesh/modify_zones/sep_face_zone_region").execute(*args, **kwargs)
            def sep_face_zone_mark(self, *args, **kwargs):
                """
                Separate a face zone based on cell marking.
                """
                return PyMenu(self.service, "/mesh/modify_zones/sep_face_zone_mark").execute(*args, **kwargs)
            def zone_type(self, *args, **kwargs):
                """
                Set a zone's type.
                """
                return PyMenu(self.service, "/mesh/modify_zones/zone_type").execute(*args, **kwargs)
            def translate_zone(self, *args, **kwargs):
                """
                Translate nodal coordinates of input cell zones.
                """
                return PyMenu(self.service, "/mesh/modify_zones/translate_zone").execute(*args, **kwargs)
            def scale_zone(self, *args, **kwargs):
                """
                Scale nodal coordinates of input cell zones.
                """
                return PyMenu(self.service, "/mesh/modify_zones/scale_zone").execute(*args, **kwargs)
            def copy_mrf_to_mesh_motion(self, *args, **kwargs):
                """
                Copy motion variable values for origin, axis and velocities from Frame Motion to Mesh Motion.
                """
                return PyMenu(self.service, "/mesh/modify_zones/copy_mrf_to_mesh_motion").execute(*args, **kwargs)
            def sep_face_zone_angle(self, *args, **kwargs):
                """
                Separate a face zone based on significant angle.
                """
                return PyMenu(self.service, "/mesh/modify_zones/sep_face_zone_angle").execute(*args, **kwargs)
            def deactivate_cell_zone(self, *args, **kwargs):
                """
                Deactivate cell thread.
                """
                return PyMenu(self.service, "/mesh/modify_zones/deactivate_cell_zone").execute(*args, **kwargs)
            def change_zone_state(self, *args, **kwargs):
                """
                Change the realgas material state for a zone.
                """
                return PyMenu(self.service, "/mesh/modify_zones/change_zone_state").execute(*args, **kwargs)
            def delete_cell_zone(self, *args, **kwargs):
                """
                Delete a cell thread.
                """
                return PyMenu(self.service, "/mesh/modify_zones/delete_cell_zone").execute(*args, **kwargs)
            def extrude_face_zone_delta(self, *args, **kwargs):
                """
                Extrude a face thread a specified distance based on a list of deltas.
                """
                return PyMenu(self.service, "/mesh/modify_zones/extrude_face_zone_delta").execute(*args, **kwargs)
            def copy_move_cell_zone(self, *args, **kwargs):
                """
                Copy and translate or rotate a cell zone.
                """
                return PyMenu(self.service, "/mesh/modify_zones/copy_move_cell_zone").execute(*args, **kwargs)
            def replace_zone(self, *args, **kwargs):
                """
                Replace a cell zone.
                """
                return PyMenu(self.service, "/mesh/modify_zones/replace_zone").execute(*args, **kwargs)
            def change_zone_phase(self, *args, **kwargs):
                """
                Change the realgas phase for a zone.
                """
                return PyMenu(self.service, "/mesh/modify_zones/change_zone_phase").execute(*args, **kwargs)
            def mrf_to_sliding_mesh(self, *args, **kwargs):
                """
                Change motion specification from MRF to moving mesh.
                """
                return PyMenu(self.service, "/mesh/modify_zones/mrf_to_sliding_mesh").execute(*args, **kwargs)
            def extrude_face_zone_para(self, *args, **kwargs):
                """
                Extrude a face thread a specified distance based on a distance and a list of parametric locations between 0 and 1 (eg. 0 0.2 0.4 0.8 1.0).
                """
                return PyMenu(self.service, "/mesh/modify_zones/extrude_face_zone_para").execute(*args, **kwargs)
            def create_periodic_interface(self, *args, **kwargs):
                """
                Create a conformal or non-conformal periodic interface.
                """
                return PyMenu(self.service, "/mesh/modify_zones/create_periodic_interface").execute(*args, **kwargs)
            def convert_all_solid_mrf_to_solid_motion(self, *args, **kwargs):
                """
                Change all solid zones motion specification from MRF to solid motion.
                """
                return PyMenu(self.service, "/mesh/modify_zones/convert_all_solid_mrf_to_solid_motion").execute(*args, **kwargs)
            def append_mesh(self, *args, **kwargs):
                """
                Append new mesh.
                """
                return PyMenu(self.service, "/mesh/modify_zones/append_mesh").execute(*args, **kwargs)
            def list_zones(self, *args, **kwargs):
                """
                List zone IDs, types, kinds, and names.
                """
                return PyMenu(self.service, "/mesh/modify_zones/list_zones").execute(*args, **kwargs)
            def sep_cell_zone_mark(self, *args, **kwargs):
                """
                Separate a cell zone based on cell marking.
                """
                return PyMenu(self.service, "/mesh/modify_zones/sep_cell_zone_mark").execute(*args, **kwargs)
            def delete_all_shells(self, *args, **kwargs):
                """
                Delete all shell zones and switch off shell conduction on all the walls. These zones can be recreated using the command recreate-all-shells.
                """
                return PyMenu(self.service, "/mesh/modify_zones/delete_all_shells").execute(*args, **kwargs)
            def make_periodic(self, *args, **kwargs):
                """
                Attempt to establish conformal periodic face zone connectivity.
                """
                return PyMenu(self.service, "/mesh/modify_zones/make_periodic").execute(*args, **kwargs)
            def orient_face_zone(self, *args, **kwargs):
                """
                Orient the face zone.
                """
                return PyMenu(self.service, "/mesh/modify_zones/orient_face_zone").execute(*args, **kwargs)
            def activate_cell_zone(self, *args, **kwargs):
                """
                Activate a cell thread.
                """
                return PyMenu(self.service, "/mesh/modify_zones/activate_cell_zone").execute(*args, **kwargs)
            def recreate_all_shells(self, *args, **kwargs):
                """
                Create shell on all the walls where which were deleted using the command delete-all-shells.
                """
                return PyMenu(self.service, "/mesh/modify_zones/recreate_all_shells").execute(*args, **kwargs)
            def slit_face_zone(self, *args, **kwargs):
                """
                Slit a two-sided wall into two connected wall zones.
                """
                return PyMenu(self.service, "/mesh/modify_zones/slit_face_zone").execute(*args, **kwargs)
            def copy_mesh_to_mrf_motion(self, *args, **kwargs):
                """
                Copy motion variable values for origin, axis and velocities from Mesh Motion to Frame Motion.
                """
                return PyMenu(self.service, "/mesh/modify_zones/copy_mesh_to_mrf_motion").execute(*args, **kwargs)
            def sep_cell_zone_region(self, *args, **kwargs):
                """
                Separate a cell zone based on contiguous regions.
                """
                return PyMenu(self.service, "/mesh/modify_zones/sep_cell_zone_region").execute(*args, **kwargs)
            def sep_face_zone_face(self, *args, **kwargs):
                """
                Separate each face in a zone into unique zone.
                """
                return PyMenu(self.service, "/mesh/modify_zones/sep_face_zone_face").execute(*args, **kwargs)
            def create_all_shell_threads(self, *args, **kwargs):
                """
                Mark all finite thickness wall for shell creation. Shell zones will be created at the start of iterations.
                """
                return PyMenu(self.service, "/mesh/modify_zones/create_all_shell_threads").execute(*args, **kwargs)
            def append_mesh_data(self, *args, **kwargs):
                """
                Append new mesh with data.
                """
                return PyMenu(self.service, "/mesh/modify_zones/append_mesh_data").execute(*args, **kwargs)

        class adapt(TUIMenu):
            """
            Enters the mesh adaption menu.
            """
            def __init__(self, path, service):
                self.path = path
                self.service = service
                self.manage_criteria = self.__class__.manage_criteria(path + ["manage_criteria"], service)
                self.multi_layer_refinement = self.__class__.multi_layer_refinement(path + ["multi_layer_refinement"], service)
                self.cell_registers = self.__class__.cell_registers(path + ["cell_registers"], service)
                self.set = self.__class__.set(path + ["set"], service)
                self.profile = self.__class__.profile(path + ["profile"], service)
                self.geometry = self.__class__.geometry(path + ["geometry"], service)
                super().__init__(path, service)
            def anisotropic_adaption(self, *args, **kwargs):
                """
                Applies legacy anisotropic adaption to refine the boundary layers or registers. Cells will be split in the normal direction to the boundary face. Note that this text command is only available for 3D cases that have the adaption method set to hanging node.
                """
                return PyMenu(self.service, "/mesh/adapt/anisotropic_adaption").execute(*args, **kwargs)
            def display_adaption_cells(self, *args, **kwargs):
                """
                Displays the cells that are marked for adaption in the graphics window.
                """
                return PyMenu(self.service, "/mesh/adapt/display_adaption_cells").execute(*args, **kwargs)
            def coarsening_criteria(self, *args, **kwargs):
                """
                Allows you to provide an expression for the coarsening criterion.
                """
                return PyMenu(self.service, "/mesh/adapt/coarsening_criteria").execute(*args, **kwargs)
            def refinement_criteria(self, *args, **kwargs):
                """
                Allows you to provide an expression for the refinement criterion.
                """
                return PyMenu(self.service, "/mesh/adapt/refinement_criteria").execute(*args, **kwargs)
            def manual_refinement_criteria(self, *args, **kwargs):
                """
                Set expression for manual refinement criterion.
                """
                return PyMenu(self.service, "/mesh/adapt/manual_refinement_criteria").execute(*args, **kwargs)
            def manual_coarsening_criteria(self, *args, **kwargs):
                """
                Set expression for manual coarsening criterion.
                """
                return PyMenu(self.service, "/mesh/adapt/manual_coarsening_criteria").execute(*args, **kwargs)
            def free_hierarchy(self, *args, **kwargs):
                """
                Deletes the defined adaption hierarchy.
                """
                return PyMenu(self.service, "/mesh/adapt/free_hierarchy").execute(*args, **kwargs)
            def list_adaption_cells(self, *args, **kwargs):
                """
                Prints the number of cells marked for refinement, coarsening, and both to the console.
                """
                return PyMenu(self.service, "/mesh/adapt/list_adaption_cells").execute(*args, **kwargs)
            def adapt_mesh(self, *args, **kwargs):
                """
                Performs manual adaption on the mesh according to the methods and settings that you specified.
                """
                return PyMenu(self.service, "/mesh/adapt/adapt_mesh").execute(*args, **kwargs)

            class manage_criteria(TUIMenu):
                """
                Enters the manage criteria menu, which provides text commands for managing automatic adaption criteria.
                """
                def __init__(self, path, service):
                    self.path = path
                    self.service = service
                    super().__init__(path, service)
                def delete(self, *args, **kwargs):
                    """
                    Deletes an existing automatic adaption criterion.
                    """
                    return PyMenu(self.service, "/mesh/adapt/manage_criteria/delete").execute(*args, **kwargs)
                def list(self, *args, **kwargs):
                    """
                    Lists all the existing automatic adaption criteria.
                    """
                    return PyMenu(self.service, "/mesh/adapt/manage_criteria/list").execute(*args, **kwargs)
                def list_properties(self, *args, **kwargs):
                    """
                    Lists the properties of an existing automatic adaption criterion.
                    """
                    return PyMenu(self.service, "/mesh/adapt/manage_criteria/list_properties").execute(*args, **kwargs)
                def edit(self, *args, **kwargs):
                    """
                    Edits an existing automatic adaption criterion.
                    """
                    return PyMenu(self.service, "/mesh/adapt/manage_criteria/edit").execute(*args, **kwargs)
                def add(self, *args, **kwargs):
                    """
                    Adds a new automatic adaption criterion.
                    """
                    return PyMenu(self.service, "/mesh/adapt/manage_criteria/add").execute(*args, **kwargs)

            class multi_layer_refinement(TUIMenu):
                """
                Enter the multiple boundary layer refinement menu.
                """
                def __init__(self, path, service):
                    self.path = path
                    self.service = service
                    super().__init__(path, service)
                def parameters(self, *args, **kwargs):
                    """
                    Specify parameters for multiple boundary layer refinement.
                    """
                    return PyMenu(self.service, "/mesh/adapt/multi_layer_refinement/parameters").execute(*args, **kwargs)
                def refine_mesh(self, *args, **kwargs):
                    """
                    Refine the mesh for multiple boundary layers.
                    """
                    return PyMenu(self.service, "/mesh/adapt/multi_layer_refinement/refine_mesh").execute(*args, **kwargs)
                def boundary_zones(self, *args, **kwargs):
                    """
                    Specify boundary zones for refinement.
                    """
                    return PyMenu(self.service, "/mesh/adapt/multi_layer_refinement/boundary_zones").execute(*args, **kwargs)
                def layer_count(self, *args, **kwargs):
                    """
                    Specify the layer count for refinement.
                    """
                    return PyMenu(self.service, "/mesh/adapt/multi_layer_refinement/layer_count").execute(*args, **kwargs)

            class cell_registers(TUIMenu):
                """
                Enters the cell registers menu.
                """
                def __init__(self, path, service):
                    self.path = path
                    self.service = service
                    super().__init__(path, service)
                def list(self, *args, **kwargs):
                    """
                    Lists all of the currently defined cell registers.
                    """
                    return PyMenu(self.service, "/mesh/adapt/cell_registers/list").execute(*args, **kwargs)
                def coarsen(self, *args, **kwargs):
                    """
                    Coarsen the mesh based on a cell register.
                    """
                    return PyMenu(self.service, "/mesh/adapt/cell_registers/coarsen").execute(*args, **kwargs)
                def adapt(self, *args, **kwargs):
                    """
                    Adapt cell register objects.
                    """
                    return PyMenu(self.service, "/mesh/adapt/cell_registers/adapt").execute(*args, **kwargs)
                def edit(self, *args, **kwargs):
                    """
                    Edit an object.
                    """
                    return PyMenu(self.service, "/mesh/adapt/cell_registers/edit").execute(*args, **kwargs)
                def list_properties(self, *args, **kwargs):
                    """
                    Lists the properties of a cell register.
                    """
                    return PyMenu(self.service, "/mesh/adapt/cell_registers/list_properties").execute(*args, **kwargs)
                def add(self, *args, **kwargs):
                    """
                    Add a new object.
                    """
                    return PyMenu(self.service, "/mesh/adapt/cell_registers/add").execute(*args, **kwargs)
                def delete(self, *args, **kwargs):
                    """
                    Deletes a cell register.
                    """
                    return PyMenu(self.service, "/mesh/adapt/cell_registers/delete").execute(*args, **kwargs)
                def display(self, *args, **kwargs):
                    """
                    Displays a cell register.
                    """
                    return PyMenu(self.service, "/mesh/adapt/cell_registers/display").execute(*args, **kwargs)
                def refine(self, *args, **kwargs):
                    """
                    Refine the mesh based on a cell register.
                    """
                    return PyMenu(self.service, "/mesh/adapt/cell_registers/refine").execute(*args, **kwargs)
                def apply_poor_mesh_numerics(self, *args, **kwargs):
                    """
                    Applies poor mesh numerics to the mesh of a cell register.
                    """
                    return PyMenu(self.service, "/mesh/adapt/cell_registers/apply_poor_mesh_numerics").execute(*args, **kwargs)

            class set(TUIMenu):
                """
                Enters the set menu.
                """
                def __init__(self, path, service):
                    self.path = path
                    self.service = service
                    super().__init__(path, service)
                def dynamic_adaption_frequency(self, *args, **kwargs):
                    """
                    Set frequency for dynamic adaption.
                    """
                    return PyMenu(self.service, "/mesh/adapt/set/dynamic_adaption_frequency").execute(*args, **kwargs)
                def maximum_refinement_level(self, *args, **kwargs):
                    """
                    Controls the number of levels of refinement used to split cells during the adaption.
                    """
                    return PyMenu(self.service, "/mesh/adapt/set/maximum_refinement_level").execute(*args, **kwargs)
                def encapsulate_children(self, *args, **kwargs):
                    """
                    Encapsulate all children of parent cells on the same partition.
                    """
                    return PyMenu(self.service, "/mesh/adapt/set/encapsulate_children").execute(*args, **kwargs)
                def maximum_cell_count(self, *args, **kwargs):
                    """
                    Sets an approximate limit to the total cell count of the mesh during adaption. Fluent uses this value to determine when to stop marking cells for refinement. A value of zero places no limits on the number of cells.
                    """
                    return PyMenu(self.service, "/mesh/adapt/set/maximum_cell_count").execute(*args, **kwargs)
                def additional_refinement_layers(self, *args, **kwargs):
                    """
                    Allows you to specify additional refinement layers (this is an advanced control).
                    """
                    return PyMenu(self.service, "/mesh/adapt/set/additional_refinement_layers").execute(*args, **kwargs)
                def verbosity(self, *args, **kwargs):
                    """
                    Allows you set how much information about the adaption is printed to the console.
                    """
                    return PyMenu(self.service, "/mesh/adapt/set/verbosity").execute(*args, **kwargs)
                def cell_zones(self, *args, **kwargs):
                    """
                    Sets cell zones to be used for marking adaption. An empty list specifies that all zones are considered for adaption.
                    """
                    return PyMenu(self.service, "/mesh/adapt/set/cell_zones").execute(*args, **kwargs)
                def overset_adapt_dead_cells(self, *args, **kwargs):
                    """
                    Enables/disables the adaption of dead cells in overset meshes.
                    """
                    return PyMenu(self.service, "/mesh/adapt/set/overset_adapt_dead_cells").execute(*args, **kwargs)
                def anisotropic_adaption(self, *args, **kwargs):
                    """
                    Enables / disables anisotropic adaption for prismatic cells as part of manual adaption. Note that this text command requires that the adaption method is set to PUMA.
                    """
                    return PyMenu(self.service, "/mesh/adapt/set/anisotropic_adaption").execute(*args, **kwargs)
                def dynamic_adaption(self, *args, **kwargs):
                    """
                    Adapt the mesh during solution.
                    """
                    return PyMenu(self.service, "/mesh/adapt/set/dynamic_adaption").execute(*args, **kwargs)
                def anisotropic_split_ratio(self, *args, **kwargs):
                    """
                    Sets the split ratio for the cells as part of anisotropic refinement with the PUMA method.
                    """
                    return PyMenu(self.service, "/mesh/adapt/set/anisotropic_split_ratio").execute(*args, **kwargs)
                def anisotropic_boundary_zones(self, *args, **kwargs):
                    """
                    Allows you to select the boundary zones that specify directions for anisotropic refinement with the PUMA method.
                    """
                    return PyMenu(self.service, "/mesh/adapt/set/anisotropic_boundary_zones").execute(*args, **kwargs)
                def display_settings(self, *args, **kwargs):
                    """
                    Sets the graphics display options for the refinement, coarsening, and common cells.
                    """
                    return PyMenu(self.service, "/mesh/adapt/set/display_settings").execute(*args, **kwargs)
                def minimum_cell_quality(self, *args, **kwargs):
                    """
                    Sets the minimum value allowed for the orthogonal quality of cells during adaption. If your solution diverges, you may find that using a higher minimum quality value resolves the issue. This text command is only available with the PUMA 3D adaption method.
                    """
                    return PyMenu(self.service, "/mesh/adapt/set/minimum_cell_quality").execute(*args, **kwargs)
                def method(self, *args, **kwargs):
                    """
                    Sets the adaption method.
                    """
                    return PyMenu(self.service, "/mesh/adapt/set/method").execute(*args, **kwargs)
                def minimum_edge_length(self, *args, **kwargs):
                    """
                    Sets an approximate limit to the edge length for cells that are considered for refinement. Even if a cell is marked for refinement, it will not be refined if (for 3D) its volume is less than the cube of this field or (for 2D) its area is less than the square of this field. The default value of zero places no limits on the size of cells that are refined.
                    """
                    return PyMenu(self.service, "/mesh/adapt/set/minimum_edge_length").execute(*args, **kwargs)

            class profile(TUIMenu):
                """
                Enters the profile menu.
                """
                def __init__(self, path, service):
                    self.path = path
                    self.service = service
                    super().__init__(path, service)
                def print(self, *args, **kwargs):
                    """
                    Prints adaption profiling results.
                    """
                    return PyMenu(self.service, "/mesh/adapt/profile/print").execute(*args, **kwargs)
                def enable(self, *args, **kwargs):
                    """
                    Enables adaption profiling.
                    """
                    return PyMenu(self.service, "/mesh/adapt/profile/enable").execute(*args, **kwargs)
                def disable(self, *args, **kwargs):
                    """
                    Disables adaption profiling.
                    """
                    return PyMenu(self.service, "/mesh/adapt/profile/disable").execute(*args, **kwargs)
                def clear(self, *args, **kwargs):
                    """
                    Clears the adaption profiling counters.
                    """
                    return PyMenu(self.service, "/mesh/adapt/profile/clear").execute(*args, **kwargs)

            class geometry(TUIMenu):
                """
                Enters the geometry menu. Note that this text command menu is not available unless the adaption method is set to hanging node.
                """
                def __init__(self, path, service):
                    self.path = path
                    self.service = service
                    super().__init__(path, service)
                def set_geometry_controls(self, *args, **kwargs):
                    """
                    Sets geometry controls for wall zones.
                    """
                    return PyMenu(self.service, "/mesh/adapt/geometry/set_geometry_controls").execute(*args, **kwargs)
                def reconstruct_geometry(self, *args, **kwargs):
                    """
                    Enables/disables geometry-based adaption.
                    """
                    return PyMenu(self.service, "/mesh/adapt/geometry/reconstruct_geometry").execute(*args, **kwargs)

        class polyhedra(TUIMenu):
            """
            Enters the polyhedra menu.
            """
            def __init__(self, path, service):
                self.path = path
                self.service = service
                self.options = self.__class__.options(path + ["options"], service)
                super().__init__(path, service)
            def convert_hanging_nodes_zones(self, *args, **kwargs):
                """
                Convert selected cell zones with hanging nodes and faces to polyhedra.
                The selected cell zones cannot be connected to other zones.
                """
                return PyMenu(self.service, "/mesh/polyhedra/convert_hanging_nodes_zones").execute(*args, **kwargs)
            def convert_hanging_nodes(self, *args, **kwargs):
                """
                Converts cells with hanging nodes/edges to polyhedra.
                """
                return PyMenu(self.service, "/mesh/polyhedra/convert_hanging_nodes").execute(*args, **kwargs)
            def convert_skewed_cells(self, *args, **kwargs):
                """
                Converts skewed cells to polyhedra.
                """
                return PyMenu(self.service, "/mesh/polyhedra/convert_skewed_cells").execute(*args, **kwargs)
            def convert_domain(self, *args, **kwargs):
                """
                Converts the entire domain to polyhedra cells.
                """
                return PyMenu(self.service, "/mesh/polyhedra/convert_domain").execute(*args, **kwargs)

            class options(TUIMenu):
                """
                Enters the polyhedra options menu.
                """
                def __init__(self, path, service):
                    self.path = path
                    self.service = service
                    super().__init__(path, service)
                def migrate_and_reorder(self, *args, **kwargs):
                    """
                    Enables / disables the migration of newly created partitions to the compute-nodes and the reordering of the domain as part of polyhedra conversion. This is disabled by default, because it requires significant additional memory; when disabled, it is recommended that you save the case file after conversion, read it in a new Fluent session (so that the new / stored partitions become active), and then manually reorder using the mesh/reorder/reorder-domain text command. If you want to run the calculation in the current Fluent session you can enable the migrate-and-reorder? text command prior to conversion, but you must ensure that no more than half of the available memory of your system is currently used.
                    """
                    return PyMenu(self.service, "/mesh/polyhedra/options/migrate_and_reorder").execute(*args, **kwargs)
                def preserve_boundary_layer(self, *args, **kwargs):
                    """
                    Specifies whether boundary layer cells will be preserved when the domain is converted to polyhedra. When the value is set to 0 (default) ANSYS Fluent checks for high aspect ratio cells at the boundary layer and if any are found, Fluent asks if you want to preserve the boundary layer. When the value is set to 1, the boundary layer cells are never preserved; when it is set to 2, the boundary layer cells are always preserved (regardless of the aspect ratio of the boundary layer cells).
                    """
                    return PyMenu(self.service, "/mesh/polyhedra/options/preserve_boundary_layer").execute(*args, **kwargs)
                def preserve_interior_zones(self, *args, **kwargs):
                    """
                    Enables the preservation of surfaces (that is, manifold zones of type interior) during the conversion of the domain to polyhedra. Note that only those zones with a name that includes the string you specify will be preserved.
                    """
                    return PyMenu(self.service, "/mesh/polyhedra/options/preserve_interior_zones").execute(*args, **kwargs)

        class repair_improve(TUIMenu):
            """
            Enter the repair and improve quality menu.
            """
            def __init__(self, path, service):
                self.path = path
                self.service = service
                super().__init__(path, service)
            def repair(self, *args, **kwargs):
                """
                Repairs mesh problems identified by the mesh check, if possible. The repairs include fixing cells that have the wrong node order, the wrong face handedness, faces that are small or nonexistent, or very poor quality. Only interior nodes are repositioned by default; boundary nodes may be repositioned if the  mesh/repair-improve/allow-repair-at-boundaries text command is enabled. Note that highly skewed cells may be converted into polyhedra, depending on whether the  mesh/repair-improve/include-local-polyhedra-conversion-in-repair text command is enabled.
                """
                return PyMenu(self.service, "/mesh/repair_improve/repair").execute(*args, **kwargs)
            def allow_repair_at_boundaries(self, *args, **kwargs):
                """
                Allows the adjustment of the positions of nodes on boundaries as part of the mesh repairs performed by the mesh/repair-improve/repair text command.
                """
                return PyMenu(self.service, "/mesh/repair_improve/allow_repair_at_boundaries").execute(*args, **kwargs)
            def repair_face_node_order(self, *args, **kwargs):
                """
                Modifies face nodes to repair faces with improper face node order and, therefore, eliminates any resulting left-handed faces.
                """
                return PyMenu(self.service, "/mesh/repair_improve/repair_face_node_order").execute(*args, **kwargs)
            def repair_periodic(self, *args, **kwargs):
                """
                Modifies the mesh to enforce a rotational angle or translational distance for periodic boundaries. For translationally periodic boundaries, the command computes an average translation distance and adjusts the node coordinates on the shadow face zone to match this distance. For rotationally periodic boundaries, the command prompts for an angle and adjusts the node coordinates on the shadow face zone using this angle and the defined rotational axis for the cell zone.
                """
                return PyMenu(self.service, "/mesh/repair_improve/repair_periodic").execute(*args, **kwargs)
            def improve_quality(self, *args, **kwargs):
                """
                Improves poor quality cells in the mesh, if possible.
                """
                return PyMenu(self.service, "/mesh/repair_improve/improve_quality").execute(*args, **kwargs)
            def repair_wall_distance(self, *args, **kwargs):
                """
                Corrects wall distance at very high aspect ratio hexahedral/polyhedral cells.
                """
                return PyMenu(self.service, "/mesh/repair_improve/repair_wall_distance").execute(*args, **kwargs)
            def repair_face_handedness(self, *args, **kwargs):
                """
                Modifies cell centroids to repair meshes that contain left-handed faces without face node order problems.
                """
                return PyMenu(self.service, "/mesh/repair_improve/repair_face_handedness").execute(*args, **kwargs)
            def include_local_polyhedra_conversion_in_repair(self, *args, **kwargs):
                """
                Enables/disables the local conversion of degenerate cells into polyhedra based on skewness criteria as part of the mesh repairs performed by the  mesh/repair-improve/repair text command.
                """
                return PyMenu(self.service, "/mesh/repair_improve/include_local_polyhedra_conversion_in_repair").execute(*args, **kwargs)
            def report_poor_elements(self, *args, **kwargs):
                """
                Reports invalid and poor quality elements.
                """
                return PyMenu(self.service, "/mesh/repair_improve/report_poor_elements").execute(*args, **kwargs)

    class parameters__and__customization(TUIMenu):
        """
        Enter Parameters and custom menu.
        """
        def __init__(self, path, service):
            self.path = path
            self.service = service
            self.parameters = self.__class__.parameters(path + ["parameters"], service)
            self.user_defined = self.__class__.user_defined(path + ["user_defined"], service)
            super().__init__(path, service)

        class parameters(TUIMenu):
            """
            Enter the parameters menu.
            """
            def __init__(self, path, service):
                self.path = path
                self.service = service
                self.list_parameters = self.__class__.list_parameters(path + ["list_parameters"], service)
                self.output_parameters = self.__class__.output_parameters(path + ["output_parameters"], service)
                self.input_parameters = self.__class__.input_parameters(path + ["input_parameters"], service)
                super().__init__(path, service)
            def enable_in_TUI(self, *args, **kwargs):
                """
                Enable/disable parameters in the text user interface.
                """
                return PyMenu(self.service, "/parameters__and__customization/parameters/enable_in_TUI").execute(*args, **kwargs)

            class list_parameters(TUIMenu):
                """
                Enter list-param menu.
                """
                def __init__(self, path, service):
                    self.path = path
                    self.service = service
                    super().__init__(path, service)
                def output_parameters(self, *args, **kwargs):
                    """
                    List all output parameters.
                    """
                    return PyMenu(self.service, "/parameters__and__customization/parameters/list_parameters/output_parameters").execute(*args, **kwargs)
                def input_parameters(self, *args, **kwargs):
                    """
                    List all input parameters.
                    """
                    return PyMenu(self.service, "/parameters__and__customization/parameters/list_parameters/input_parameters").execute(*args, **kwargs)

            class output_parameters(TUIMenu):
                """
                Enter the output-parameters menu.
                """
                def __init__(self, path, service):
                    self.path = path
                    self.service = service
                    super().__init__(path, service)
                def delete(self, *args, **kwargs):
                    """
                    Delete an output parameter.
                    """
                    return PyMenu(self.service, "/parameters__and__customization/parameters/output_parameters/delete").execute(*args, **kwargs)
                def rename(self, *args, **kwargs):
                    """
                    Rename an output parameter.
                    """
                    return PyMenu(self.service, "/parameters__and__customization/parameters/output_parameters/rename").execute(*args, **kwargs)
                def edit(self, *args, **kwargs):
                    """
                    Edit an output parameter.
                    """
                    return PyMenu(self.service, "/parameters__and__customization/parameters/output_parameters/edit").execute(*args, **kwargs)
                def write_to_file(self, *args, **kwargs):
                    """
                    Write parameter value to file.
                    """
                    return PyMenu(self.service, "/parameters__and__customization/parameters/output_parameters/write_to_file").execute(*args, **kwargs)
                def print_all_to_console(self, *args, **kwargs):
                    """
                    Print all parameter values to console.
                    """
                    return PyMenu(self.service, "/parameters__and__customization/parameters/output_parameters/print_all_to_console").execute(*args, **kwargs)
                def create(self, *args, **kwargs):
                    """
                    Create an output parameter.
                    """
                    return PyMenu(self.service, "/parameters__and__customization/parameters/output_parameters/create").execute(*args, **kwargs)
                def print_to_console(self, *args, **kwargs):
                    """
                    Print parameter value to console.
                    """
                    return PyMenu(self.service, "/parameters__and__customization/parameters/output_parameters/print_to_console").execute(*args, **kwargs)
                def write_all_to_file(self, *args, **kwargs):
                    """
                    Write all parameter values to file.
                    """
                    return PyMenu(self.service, "/parameters__and__customization/parameters/output_parameters/write_all_to_file").execute(*args, **kwargs)

            class input_parameters(TUIMenu):
                """
                Enter the input-parameters menu.
                """
                def __init__(self, path, service):
                    self.path = path
                    self.service = service
                    self.advance = self.__class__.advance(path + ["advance"], service)
                    super().__init__(path, service)
                def edit(self, *args, **kwargs):
                    """
                    Edit an input parameter.
                    """
                    return PyMenu(self.service, "/parameters__and__customization/parameters/input_parameters/edit").execute(*args, **kwargs)
                def delete(self, *args, **kwargs):
                    """
                    Delete an input parameter.
                    """
                    return PyMenu(self.service, "/parameters__and__customization/parameters/input_parameters/delete").execute(*args, **kwargs)

                class advance(TUIMenu):
                    """
                    Define custom variable to use input parameter.
                    """
                    def __init__(self, path, service):
                        self.path = path
                        self.service = service
                        super().__init__(path, service)
                    def use_in(self, *args, **kwargs):
                        """
                        Use input parameter in solver-udf or in scheme-procedure.
                        """
                        return PyMenu(self.service, "/parameters__and__customization/parameters/input_parameters/advance/use_in").execute(*args, **kwargs)
                    def delete(self, *args, **kwargs):
                        """
                        Delete selected custom-input-parameters.
                        """
                        return PyMenu(self.service, "/parameters__and__customization/parameters/input_parameters/advance/delete").execute(*args, **kwargs)
                    def list(self, *args, **kwargs):
                        """
                        List of custom-input-parameters.
                        """
                        return PyMenu(self.service, "/parameters__and__customization/parameters/input_parameters/advance/list").execute(*args, **kwargs)

        class user_defined(TUIMenu):
            """
            Enter the user-defined functions and scalars menu.
            """
            def __init__(self, path, service):
                self.path = path
                self.service = service
                self.real_gas_models = self.__class__.real_gas_models(path + ["real_gas_models"], service)
                super().__init__(path, service)
            def interpreted_functions(self, *args, **kwargs):
                """
                Load interpreted user-defined functions.
                """
                return PyMenu(self.service, "/parameters__and__customization/user_defined/interpreted_functions").execute(*args, **kwargs)
            def function_hooks(self, *args, **kwargs):
                """
                Hook up user-defined functions.
                """
                return PyMenu(self.service, "/parameters__and__customization/user_defined/function_hooks").execute(*args, **kwargs)
            def execute_on_demand(self, *args, **kwargs):
                """
                Execute UDFs on demand.
                """
                return PyMenu(self.service, "/parameters__and__customization/user_defined/execute_on_demand").execute(*args, **kwargs)
            def use_contributed_cpp(self, *args, **kwargs):
                """
                Enable/disable use of cpp from the Fluent.Inc/contrib directory.
                """
                return PyMenu(self.service, "/parameters__and__customization/user_defined/use_contributed_cpp").execute(*args, **kwargs)
            def fan_model(self, *args, **kwargs):
                """
                Configure user-defined fan model.
                """
                return PyMenu(self.service, "/parameters__and__customization/user_defined/fan_model").execute(*args, **kwargs)
            def auto_compile_compiled_udfs(self, *args, **kwargs):
                """
                For this Fluent session, specify whether to allow auto-compilation of compiled UDF when a case file (or settings file) is read.
                """
                return PyMenu(self.service, "/parameters__and__customization/user_defined/auto_compile_compiled_udfs").execute(*args, **kwargs)
            def user_defined_node_memory(self, *args, **kwargs):
                """
                Allocate user-defined node memory.
                """
                return PyMenu(self.service, "/parameters__and__customization/user_defined/user_defined_node_memory").execute(*args, **kwargs)
            def one_D_coupling(self, *args, **kwargs):
                """
                Load 1D library.
                """
                return PyMenu(self.service, "/parameters__and__customization/user_defined/one_D_coupling").execute(*args, **kwargs)
            def use_built_in_compiler(self, *args, **kwargs):
                """
                Enable/disable the use of the built-in compiler.
                """
                return PyMenu(self.service, "/parameters__and__customization/user_defined/use_built_in_compiler").execute(*args, **kwargs)
            def compiled_functions(self, *args, **kwargs):
                """
                Open user-defined function library.
                """
                return PyMenu(self.service, "/parameters__and__customization/user_defined/compiled_functions").execute(*args, **kwargs)
            def compile_customized_addon_module(self, *args, **kwargs):
                """
                Compile customized addon module?.
                """
                return PyMenu(self.service, "/parameters__and__customization/user_defined/compile_customized_addon_module").execute(*args, **kwargs)
            def user_defined_memory(self, *args, **kwargs):
                """
                Allocate user-defined memory.
                """
                return PyMenu(self.service, "/parameters__and__customization/user_defined/user_defined_memory").execute(*args, **kwargs)
            def user_defined_scalars(self, *args, **kwargs):
                """
                Define user-defined scalars.
                """
                return PyMenu(self.service, "/parameters__and__customization/user_defined/user_defined_scalars").execute(*args, **kwargs)
            def enable_udf_on_gpu(self, *args, **kwargs):
                """
                Compile UDFs with OpenCL support.
                """
                return PyMenu(self.service, "/parameters__and__customization/user_defined/enable_udf_on_gpu").execute(*args, **kwargs)

            class real_gas_models(TUIMenu):
                """
                Enable/configure real gas model.
                """
                def __init__(self, path, service):
                    self.path = path
                    self.service = service
                    super().__init__(path, service)
                def nist_real_gas_model(self, *args, **kwargs):
                    """
                    Load NIST real gas library.
                    """
                    return PyMenu(self.service, "/parameters__and__customization/user_defined/real_gas_models/nist_real_gas_model").execute(*args, **kwargs)
                def user_defined_multispecies_real_gas_model(self, *args, **kwargs):
                    """
                    Load user-defined multispecies real gas library.
                    """
                    return PyMenu(self.service, "/parameters__and__customization/user_defined/real_gas_models/user_defined_multispecies_real_gas_model").execute(*args, **kwargs)
                def set_state(self, *args, **kwargs):
                    """
                    Select state for NIST real gas model.
                    """
                    return PyMenu(self.service, "/parameters__and__customization/user_defined/real_gas_models/set_state").execute(*args, **kwargs)
                def nist_settings(self, *args, **kwargs):
                    """
                    Select refprop library.
                    """
                    return PyMenu(self.service, "/parameters__and__customization/user_defined/real_gas_models/nist_settings").execute(*args, **kwargs)
                def nist_multispecies_real_gas_model(self, *args, **kwargs):
                    """
                    Load NIST real gas library.
                    """
                    return PyMenu(self.service, "/parameters__and__customization/user_defined/real_gas_models/nist_multispecies_real_gas_model").execute(*args, **kwargs)
                def user_defined_real_gas_model(self, *args, **kwargs):
                    """
                    Load user-defined real gas library.
                    """
                    return PyMenu(self.service, "/parameters__and__customization/user_defined/real_gas_models/user_defined_real_gas_model").execute(*args, **kwargs)

    class plot(TUIMenu):
        """
        Enter the XY plot menu.
        """
        def __init__(self, path, service):
            self.path = path
            self.service = service
            self.flamelet_curves = self.__class__.flamelet_curves(path + ["flamelet_curves"], service)
            self.ansys_sound_analysis = self.__class__.ansys_sound_analysis(path + ["ansys_sound_analysis"], service)
            self.cumulative_plot = self.__class__.cumulative_plot(path + ["cumulative_plot"], service)
            super().__init__(path, service)
        def plot_direction(self, *args, **kwargs):
            """
            Sets plot direction for XY plot.
            """
            return PyMenu(self.service, "/plot/plot_direction").execute(*args, **kwargs)
        def datasources(self, *args, **kwargs):
            """
            Enters the menu for creating and modifying plots containing multiple data sources.
            """
            return PyMenu(self.service, "/plot/datasources").execute(*args, **kwargs)
        def fft_set(self, *args, **kwargs):
            """
            Enter the menu to set histogram plot parameters.
            """
            return PyMenu(self.service, "/plot/fft_set").execute(*args, **kwargs)
        def circum_avg_radial(self, *args, **kwargs):
            """
            Computes iso-radial band surfaces and plots data vs. radius on them.
            """
            return PyMenu(self.service, "/plot/circum_avg_radial").execute(*args, **kwargs)
        def solution_set(self, *args, **kwargs):
            """
            Sets solution plot parameters. Sub-menu items are the same as file-set/ above.
            """
            return PyMenu(self.service, "/plot/solution_set").execute(*args, **kwargs)
        def set_boundary_val_off(self, *args, **kwargs):
            """
            Disables the use of boundary face values when node values are disabled in solution XY plots. This option is disabled by default, that is, boundary face values are used when node values are disabled.
            """
            return PyMenu(self.service, "/plot/set_boundary_val_off").execute(*args, **kwargs)
        def file_list(self, *args, **kwargs):
            """
            Plots data from multiple external files.
            """
            return PyMenu(self.service, "/plot/file_list").execute(*args, **kwargs)
        def display_profile_data(self, *args, **kwargs):
            """
            Plots profile data.
            """
            return PyMenu(self.service, "/plot/display_profile_data").execute(*args, **kwargs)
        def residuals(self, *args, **kwargs):
            """
            Contains commands that allow you to select the variables for which you want to display XY plots of residual histories in the active graphics window.
            """
            return PyMenu(self.service, "/plot/residuals").execute(*args, **kwargs)
        def solution(self, *args, **kwargs):
            """
            Plots solution on surfaces and/or zones. Zone and surface names can be indicated using a  wildcard (\*).
            """
            return PyMenu(self.service, "/plot/solution").execute(*args, **kwargs)
        def circum_avg_axial(self, *args, **kwargs):
            """
            Computes iso-axial band surfaces and plots data vs. axial coordinate on them.
            """
            return PyMenu(self.service, "/plot/circum_avg_axial").execute(*args, **kwargs)
        def histogram_set(self, *args, **kwargs):
            """
            Sets histogram plot parameters. Sub-menu items are the same as file-set/ above.
            """
            return PyMenu(self.service, "/plot/histogram_set").execute(*args, **kwargs)
        def file_set(self, *args, **kwargs):
            """
            Sets file plot parameters.
            """
            return PyMenu(self.service, "/plot/file_set").execute(*args, **kwargs)
        def label_alignment(self, *args, **kwargs):
            """
            Set the orientation of XY plot axis labels as either horizontal or axis-aligned.
            """
            return PyMenu(self.service, "/plot/label_alignment").execute(*args, **kwargs)
        def plot(self, *args, **kwargs):
            """
            Plots solution on surfaces.
            """
            return PyMenu(self.service, "/plot/plot").execute(*args, **kwargs)
        def residuals_set(self, *args, **kwargs):
            """
            Sets residual plot parameters. Sub-menu items are the same as file-set/ above.
            """
            return PyMenu(self.service, "/plot/residuals_set").execute(*args, **kwargs)
        def histogram(self, *args, **kwargs):
            """
            Plots a histogram of the specified solution variable using the defined range and number of intervals.
            """
            return PyMenu(self.service, "/plot/histogram").execute(*args, **kwargs)
        def fft(self, *args, **kwargs):
            """
            Plots fast Fourier transform (FFT) of file data. If you respond yes to Acoustic Analysis?, then additional Y axis functions are made available.
            """
            return PyMenu(self.service, "/plot/fft").execute(*args, **kwargs)
        def file(self, *args, **kwargs):
            """
            Plots data from an external file.
            """
            return PyMenu(self.service, "/plot/file").execute(*args, **kwargs)
        def change_fft_ref_pressure(self, *args, **kwargs):
            """
            Changes reference acoustic pressure.
            """
            return PyMenu(self.service, "/plot/change_fft_ref_pressure").execute(*args, **kwargs)

        class flamelet_curves(TUIMenu):
            """
            Enters the flamelet curves menu.
            """
            def __init__(self, path, service):
                self.path = path
                self.service = service
                super().__init__(path, service)
            def plot_curves(self, *args, **kwargs):
                """
                Plots of a curve property.
                """
                return PyMenu(self.service, "/plot/flamelet_curves/plot_curves").execute(*args, **kwargs)
            def write_to_file(self, *args, **kwargs):
                """
                Writes curve to a file instead of plot.
                """
                return PyMenu(self.service, "/plot/flamelet_curves/write_to_file").execute(*args, **kwargs)

        class ansys_sound_analysis(TUIMenu):
            """
            Enter the Ansys sound analysis menu.
            """
            def __init__(self, path, service):
                self.path = path
                self.service = service
                super().__init__(path, service)
            def print_indicators(self, *args, **kwargs):
                """
                Read in a pressure signal or spectrum file, then optionally read in a frequency response function (FRF) or transfer function file, before printing the acoustics indicators.
                """
                return PyMenu(self.service, "/plot/ansys_sound_analysis/print_indicators").execute(*args, **kwargs)
            def write_files(self, *args, **kwargs):
                """
                Read in a pressure signal or spectrum file, then optionally read in a frequency response function (FRF) or transfer function file, before writing a WAV, output pressure, and/or acoustic indicators file.
                """
                return PyMenu(self.service, "/plot/ansys_sound_analysis/write_files").execute(*args, **kwargs)

        class cumulative_plot(TUIMenu):
            """
            Plot the development of force, force coefficient, moment, or moment coefficient across the specified wall zones.
            """
            def __init__(self, path, service):
                self.path = path
                self.service = service
                super().__init__(path, service)
            def list(self, *args, **kwargs):
                """
                Print the names of the existing cumulative plot objects to the console.
                """
                return PyMenu(self.service, "/plot/cumulative_plot/list").execute(*args, **kwargs)
            def write(self, *args, **kwargs):
                """
                Write a cumulative plot to a file.
                """
                return PyMenu(self.service, "/plot/cumulative_plot/write").execute(*args, **kwargs)
            def delete(self, *args, **kwargs):
                """
                Delete an existing cumulative plot object.
                """
                return PyMenu(self.service, "/plot/cumulative_plot/delete").execute(*args, **kwargs)
            def curves(self, *args, **kwargs):
                """
                Set curves options of an object.
                """
                return PyMenu(self.service, "/plot/cumulative_plot/curves").execute(*args, **kwargs)
            def axes(self, *args, **kwargs):
                """
                Set axes options of an object.
                """
                return PyMenu(self.service, "/plot/cumulative_plot/axes").execute(*args, **kwargs)
            def add(self, *args, **kwargs):
                """
                Create a new cumulative plot.
                """
                return PyMenu(self.service, "/plot/cumulative_plot/add").execute(*args, **kwargs)
            def plot(self, *args, **kwargs):
                """
                Plot a cumulative plot in the graphics window.
                """
                return PyMenu(self.service, "/plot/cumulative_plot/plot").execute(*args, **kwargs)
            def edit(self, *args, **kwargs):
                """
                Edit an existing cumulative plot object.
                """
                return PyMenu(self.service, "/plot/cumulative_plot/edit").execute(*args, **kwargs)
            def list_properties(self, *args, **kwargs):
                """
                Print the properties of the specified cumulative plot object to the console.
                """
                return PyMenu(self.service, "/plot/cumulative_plot/list_properties").execute(*args, **kwargs)
            def print(self, *args, **kwargs):
                """
                Print the value of a cumulative plot to the console.
                """
                return PyMenu(self.service, "/plot/cumulative_plot/print").execute(*args, **kwargs)

    class report(TUIMenu):
        """
        Enter the report menu.
        """
        def __init__(self, path, service):
            self.path = path
            self.service = service
            self.dpm_histogram = self.__class__.dpm_histogram(path + ["dpm_histogram"], service)
            self.forces = self.__class__.forces(path + ["forces"], service)
            self.population_balance = self.__class__.population_balance(path + ["population_balance"], service)
            self.icing = self.__class__.icing(path + ["icing"], service)
            self.modified_setting = self.__class__.modified_setting(path + ["modified_setting"], service)
            self.system = self.__class__.system(path + ["system"], service)
            self.reference_values = self.__class__.reference_values(path + ["reference_values"], service)
            self.heat_exchanger = self.__class__.heat_exchanger(path + ["heat_exchanger"], service)
            self.fluxes = self.__class__.fluxes(path + ["fluxes"], service)
            self.simulation_reports = self.__class__.simulation_reports(path + ["simulation_reports"], service)
            super().__init__(path, service)
        def mphase_summary(self, *args, **kwargs):
            """
            Prints summary report for a multiphase case setup.
            """
            return PyMenu(self.service, "/report/mphase_summary").execute(*args, **kwargs)
        def summary(self, *args, **kwargs):
            """
            Prints the current settings for physical models, boundary conditions, material properties, and solution parameters.
            """
            return PyMenu(self.service, "/report/summary").execute(*args, **kwargs)
        def dpm_sample(self, *args, **kwargs):
            """
            Samples trajectories at boundaries and lines/planes.
            """
            return PyMenu(self.service, "/report/dpm_sample").execute(*args, **kwargs)
        def projected_surface_area(self, *args, **kwargs):
            """
            Computes the area of the projection of selected surfaces along the  ,  , or   axis.
            """
            return PyMenu(self.service, "/report/projected_surface_area").execute(*args, **kwargs)
        def uds_flow(self, *args, **kwargs):
            """
            Prints list of user-defined scalar flow rate at boundaries.
            """
            return PyMenu(self.service, "/report/uds_flow").execute(*args, **kwargs)
        def dpm_sample_sort_file(self, *args, **kwargs):
            """
            Enables/disables writing of sorted DPM sample files.
            """
            return PyMenu(self.service, "/report/dpm_sample_sort_file").execute(*args, **kwargs)
        def surface_integrals(self, *args, **kwargs):
            """
            Enters the surface integral menu.
            """
            return PyMenu(self.service, "/report/surface_integrals").execute(*args, **kwargs)
        def aero_optical_distortions(self, *args, **kwargs):
            """
            Optics report menu.
            """
            return PyMenu(self.service, "/report/aero_optical_distortions").execute(*args, **kwargs)
        def particle_summary(self, *args, **kwargs):
            """
            Prints summary report for all current particles.
            """
            return PyMenu(self.service, "/report/particle_summary").execute(*args, **kwargs)
        def dpm_sample_output_udf(self, *args, **kwargs):
            """
            Allows you to hook a previously loaded DEFINE_DPM_OUTPUT UDF for file format specification for sampling of trajectories and VOF-to-DPM lump conversion transcripts.
            """
            return PyMenu(self.service, "/report/dpm_sample_output_udf").execute(*args, **kwargs)
        def path_line_summary(self, *args, **kwargs):
            """
            Prints pathline summary report.
            """
            return PyMenu(self.service, "/report/path_line_summary").execute(*args, **kwargs)
        def print_histogram(self, *args, **kwargs):
            """
            Prints a histogram of a scalar quantity.
            """
            return PyMenu(self.service, "/report/print_histogram").execute(*args, **kwargs)
        def dpm_zone_summaries_per_injection(self, *args, **kwargs):
            """
            Enables/disables calculation of the escaped mass per injection. Note that for unsteady particle tracking, if you want to report the mass of escaped particles per injection, this text command must be enabled before any particles are injected into the domain.
            """
            return PyMenu(self.service, "/report/dpm_zone_summaries_per_injection").execute(*args, **kwargs)
        def species_mass_flow(self, *args, **kwargs):
            """
            Prints list of species mass flow rate at inlets and outlets. This reports the mass flow rates of all species (in kg/s) flowing through the simulation boundaries.
            """
            return PyMenu(self.service, "/report/species_mass_flow").execute(*args, **kwargs)
        def dpm_summary(self, *args, **kwargs):
            """
            Prints discrete phase summary report.
            """
            return PyMenu(self.service, "/report/dpm_summary").execute(*args, **kwargs)
        def element_mass_flow(self, *args, **kwargs):
            """
            Prints list of element flow rate at inlets and outlets. This reports the mass flow rates of all chemical elements (in kg/s) flowing through the simulation boundaries.
            """
            return PyMenu(self.service, "/report/element_mass_flow").execute(*args, **kwargs)
        def dpm_extended_summary(self, *args, **kwargs):
            """
            Create an extended discrete phase summary report of the discrete phase injection(s). You can choose whether you want to save the extended report to a file or print it in the console window. For unsteady tracking, you will be asked whether you want to include in-domain particle/tracks in the report. You will be also prompted whether you want to select a single injection for the summary report. By default, all injections are included. The output depends on whether you have enabled the report/dpm-zone-summaries-per-injection? text command, in which case additional information is printed for escaped particles, such as per-injection data. Note that, for unsteady particle tracking, it is necessary to enable the report/dpm-zone-summaries-per-injection? text command before any particle parcels are injected into the domain.
            """
            return PyMenu(self.service, "/report/dpm_extended_summary").execute(*args, **kwargs)
        def write_histogram(self, *args, **kwargs):
            """
            Write a histogram of a scalar quantity to a file.
            """
            return PyMenu(self.service, "/report/write_histogram").execute(*args, **kwargs)
        def volume_integrals(self, *args, **kwargs):
            """
            Enters the volume integral menu.
            """
            return PyMenu(self.service, "/report/volume_integrals").execute(*args, **kwargs)

        class dpm_histogram(TUIMenu):
            """
            Enters the DPM histogram menu.
            """
            def __init__(self, path, service):
                self.path = path
                self.service = service
                self.set = self.__class__.set(path + ["set"], service)
                self.setup_reduction = self.__class__.setup_reduction(path + ["setup_reduction"], service)
                super().__init__(path, service)
            def compute_sample(self, *args, **kwargs):
                """
                Computes the minimum/maximum of a sample variable.
                """
                return PyMenu(self.service, "/report/dpm_histogram/compute_sample").execute(*args, **kwargs)
            def delete_sample(self, *args, **kwargs):
                """
                Deletes a sample from the loaded sample list.
                """
                return PyMenu(self.service, "/report/dpm_histogram/delete_sample").execute(*args, **kwargs)
            def plot_sample(self, *args, **kwargs):
                """
                Plots a histogram of a loaded sample.
                """
                return PyMenu(self.service, "/report/dpm_histogram/plot_sample").execute(*args, **kwargs)
            def read_sample(self, *args, **kwargs):
                """
                Reads a sample file and adds it to the sample list.
                """
                return PyMenu(self.service, "/report/dpm_histogram/read_sample").execute(*args, **kwargs)
            def write_sample(self, *args, **kwargs):
                """
                Write a histogram of a loaded sample into a file.
                """
                return PyMenu(self.service, "/report/dpm_histogram/write_sample").execute(*args, **kwargs)
            def pick_sample_to_reduce(self, *args, **kwargs):
                """
                Select a sample to be reduced.
                """
                return PyMenu(self.service, "/report/dpm_histogram/pick_sample_to_reduce").execute(*args, **kwargs)
            def list_samples(self, *args, **kwargs):
                """
                Shows all samples in a loaded sample list.
                """
                return PyMenu(self.service, "/report/dpm_histogram/list_samples").execute(*args, **kwargs)
            def prep_dpm_sample_cont_plot_exprs(self, *args, **kwargs):
                """
                Prepare named expressions from data in a DPM sample file (collected at a cut plane surface) for contour plotting.
                """
                return PyMenu(self.service, "/report/dpm_histogram/prep_dpm_sample_cont_plot_exprs").execute(*args, **kwargs)
            def reduce_picked_sample(self, *args, **kwargs):
                """
                Reduce a sample as specified by the data reduction parameters. This command is available only after you selected the sample using the pick-sample-to-reduce text command.
                """
                return PyMenu(self.service, "/report/dpm_histogram/reduce_picked_sample").execute(*args, **kwargs)

            class set(TUIMenu):
                """
                Enters the settings menu for the histogram.
                """
                def __init__(self, path, service):
                    self.path = path
                    self.service = service
                    super().__init__(path, service)
                def logarithmic(self, *args, **kwargs):
                    """
                    Enables/disables the use of logarithmic scaling on the abscissa of the histogram.
                    """
                    return PyMenu(self.service, "/report/dpm_histogram/set/logarithmic").execute(*args, **kwargs)
                def maximum(self, *args, **kwargs):
                    """
                    Specifies the maximum value of the x-axis variable for histogram plots.
                    """
                    return PyMenu(self.service, "/report/dpm_histogram/set/maximum").execute(*args, **kwargs)
                def number_of_bins(self, *args, **kwargs):
                    """
                    Specifies the number of bins.
                    """
                    return PyMenu(self.service, "/report/dpm_histogram/set/number_of_bins").execute(*args, **kwargs)
                def variable_power_3(self, *args, **kwargs):
                    """
                    Use the cubic of the cumulation variable during computation of the cumulative curve.
                    When the particle mass was not sampled, the diameter can be used instead.
                    """
                    return PyMenu(self.service, "/report/dpm_histogram/set/variable_power_3").execute(*args, **kwargs)
                def auto_range(self, *args, **kwargs):
                    """
                    Automatically computes the range of the sampling variable for histogram plots.
                    """
                    return PyMenu(self.service, "/report/dpm_histogram/set/auto_range").execute(*args, **kwargs)
                def cumulation_curve(self, *args, **kwargs):
                    """
                    Computes a cumulative curve for the sampling variable or correlation variable when correlation? is specified.
                    """
                    return PyMenu(self.service, "/report/dpm_histogram/set/cumulation_curve").execute(*args, **kwargs)
                def correlation(self, *args, **kwargs):
                    """
                    Computes the correlation of the sampling variable with another variable.
                    """
                    return PyMenu(self.service, "/report/dpm_histogram/set/correlation").execute(*args, **kwargs)
                def weighting(self, *args, **kwargs):
                    """
                    Uses weighting with additional variables when sorting data into samples.
                    """
                    return PyMenu(self.service, "/report/dpm_histogram/set/weighting").execute(*args, **kwargs)
                def histogram_mode(self, *args, **kwargs):
                    """
                    Uses bars for the histogram plot or xy-style.
                    """
                    return PyMenu(self.service, "/report/dpm_histogram/set/histogram_mode").execute(*args, **kwargs)
                def percentage(self, *args, **kwargs):
                    """
                    Uses percentages of bins to be computed.
                    """
                    return PyMenu(self.service, "/report/dpm_histogram/set/percentage").execute(*args, **kwargs)
                def minimum(self, *args, **kwargs):
                    """
                    Specifies the minimum value of the x-axis variable for histogram plots.
                    """
                    return PyMenu(self.service, "/report/dpm_histogram/set/minimum").execute(*args, **kwargs)
                def diameter_statistics(self, *args, **kwargs):
                    """
                    Computes the Rosin Rammler parameters, Sauter, and other mean diameters.
                    """
                    return PyMenu(self.service, "/report/dpm_histogram/set/diameter_statistics").execute(*args, **kwargs)

            class setup_reduction(TUIMenu):
                """
                Set up the sample data reduction by specifying all relevant options and setting parameters as desired.
                """
                def __init__(self, path, service):
                    self.path = path
                    self.service = service
                    super().__init__(path, service)
                def maximum(self, *args, **kwargs):
                    """
                    Set the maximum value of the range to be considered for a specific variable in the data reduction.
                    """
                    return PyMenu(self.service, "/report/dpm_histogram/setup_reduction/maximum").execute(*args, **kwargs)
                def logarithmic(self, *args, **kwargs):
                    """
                    Switch on or off logarithmic scaling to be used for a specific variable in the data reduction.
                    """
                    return PyMenu(self.service, "/report/dpm_histogram/setup_reduction/logarithmic").execute(*args, **kwargs)
                def reset_min_and_max(self, *args, **kwargs):
                    """
                    Reset the min and max values of the range to be considered for a specific variable in the data reduction.
                    """
                    return PyMenu(self.service, "/report/dpm_histogram/setup_reduction/reset_min_and_max").execute(*args, **kwargs)
                def number_of_bins(self, *args, **kwargs):
                    """
                    Set the number of bins to be used for a specific variable in the data reduction.
                    """
                    return PyMenu(self.service, "/report/dpm_histogram/setup_reduction/number_of_bins").execute(*args, **kwargs)
                def make_steady_from_unsteady_file(self, *args, **kwargs):
                    """
                    Specify whether the unsteady sample is to be reduced into a steady-state injection file.
                    """
                    return PyMenu(self.service, "/report/dpm_histogram/setup_reduction/make_steady_from_unsteady_file").execute(*args, **kwargs)
                def weighting_variable(self, *args, **kwargs):
                    """
                    Choose the weighting variable for the averaging in each bin in the data reduction.
                    """
                    return PyMenu(self.service, "/report/dpm_histogram/setup_reduction/weighting_variable").execute(*args, **kwargs)
                def use_weighting(self, *args, **kwargs):
                    """
                    Specify whether to use any weighting in the averaging that is done in each bin in the data reduction.
                    """
                    return PyMenu(self.service, "/report/dpm_histogram/setup_reduction/use_weighting").execute(*args, **kwargs)
                def list_settings(self, *args, **kwargs):
                    """
                    List all user inputs for the sample picked for data reduction.
                    """
                    return PyMenu(self.service, "/report/dpm_histogram/setup_reduction/list_settings").execute(*args, **kwargs)
                def minimum(self, *args, **kwargs):
                    """
                    Set the minimum value of the range to be considered for a specific variable in the data reduction.
                    """
                    return PyMenu(self.service, "/report/dpm_histogram/setup_reduction/minimum").execute(*args, **kwargs)
                def all_variables_number_of_bins(self, *args, **kwargs):
                    """
                    Set the number of bins to be used for ALL variables in the data reduction.
                    """
                    return PyMenu(self.service, "/report/dpm_histogram/setup_reduction/all_variables_number_of_bins").execute(*args, **kwargs)

        class forces(TUIMenu):
            """
            Enters the forces menu.
            """
            def __init__(self, path, service):
                self.path = path
                self.service = service
                super().__init__(path, service)
            def wall_moments(self, *args, **kwargs):
                """
                Computes the moments about the specified moment center for all wall zones.
                """
                return PyMenu(self.service, "/report/forces/wall_moments").execute(*args, **kwargs)
            def wall_forces(self, *args, **kwargs):
                """
                Computes the forces along the specified force vector for all wall zones.
                """
                return PyMenu(self.service, "/report/forces/wall_forces").execute(*args, **kwargs)
            def pressure_center(self, *args, **kwargs):
                """
                Prints the center of pressure on wall zones.
                """
                return PyMenu(self.service, "/report/forces/pressure_center").execute(*args, **kwargs)

        class population_balance(TUIMenu):
            """
            Population Balance menu.
            """
            def __init__(self, path, service):
                self.path = path
                self.service = service
                super().__init__(path, service)
            def moments(self, *args, **kwargs):
                """
                Set moments for population balance.
                """
                return PyMenu(self.service, "/report/population_balance/moments").execute(*args, **kwargs)
            def number_density(self, *args, **kwargs):
                """
                Set number density functions.
                """
                return PyMenu(self.service, "/report/population_balance/number_density").execute(*args, **kwargs)

        class icing(TUIMenu):
            """
            Icing reports menu.
            """
            def __init__(self, path, service):
                self.path = path
                self.service = service
                super().__init__(path, service)
            def icing_energy_of_conduction(self, *args, **kwargs):
                """
                Print Energy of Conduction.
                """
                return PyMenu(self.service, "/report/icing/icing_energy_of_conduction").execute(*args, **kwargs)
            def particles_droplets_collection_eff(self, *args, **kwargs):
                """
                Print Droplets Collection Efficiency.
                """
                return PyMenu(self.service, "/report/icing/particles_droplets_collection_eff").execute(*args, **kwargs)
            def energy_of_ice_formation(self, *args, **kwargs):
                """
                Print Energy of Ice Formation.
                """
                return PyMenu(self.service, "/report/icing/energy_of_ice_formation").execute(*args, **kwargs)
            def particles_crystals_collection_eff(self, *args, **kwargs):
                """
                Print Crystals Collection Efficiency.
                """
                return PyMenu(self.service, "/report/icing/particles_crystals_collection_eff").execute(*args, **kwargs)
            def energy_of_water_impinged(self, *args, **kwargs):
                """
                Print Energy of Water Impingement.
                """
                return PyMenu(self.service, "/report/icing/energy_of_water_impinged").execute(*args, **kwargs)
            def mass_of_water_impinged(self, *args, **kwargs):
                """
                Print Mass of Water Impingement.
                """
                return PyMenu(self.service, "/report/icing/mass_of_water_impinged").execute(*args, **kwargs)
            def mass_of_ice(self, *args, **kwargs):
                """
                Print Mass of Ice Accretion.
                """
                return PyMenu(self.service, "/report/icing/mass_of_ice").execute(*args, **kwargs)

        class modified_setting(TUIMenu):
            """
            Enter the modified settings menu.
            """
            def __init__(self, path, service):
                self.path = path
                self.service = service
                super().__init__(path, service)
            def write_user_setting(self, *args, **kwargs):
                """
                Write the contents of the Modified Settings Summary table to a file.
                """
                return PyMenu(self.service, "/report/modified_setting/write_user_setting").execute(*args, **kwargs)
            def modified_setting(self, *args, **kwargs):
                """
                Specify which areas of setup will be checked for non-default settings for generating the Modified Settings Summary table. The table is displayed tabbed with the graphics window.
                """
                return PyMenu(self.service, "/report/modified_setting/modified_setting").execute(*args, **kwargs)

        class system(TUIMenu):
            """
            Enters the system menu.
            """
            def __init__(self, path, service):
                self.path = path
                self.service = service
                super().__init__(path, service)
            def sys_stats(self, *args, **kwargs):
                """
                System information. This is used to report the CPU configuration of the machines where ANSYS Fluent processes have been spawned.
                """
                return PyMenu(self.service, "/report/system/sys_stats").execute(*args, **kwargs)
            def proc_stats(self, *args, **kwargs):
                """
                Prints ANSYS Fluent process information. This is used to report the memory usage of each of the ANSYS Fluent processes.
                """
                return PyMenu(self.service, "/report/system/proc_stats").execute(*args, **kwargs)
            def gpgpu_stats(self, *args, **kwargs):
                """
                Prints information about installed general purpose graphical processing units.
                """
                return PyMenu(self.service, "/report/system/gpgpu_stats").execute(*args, **kwargs)
            def time_stats(self, *args, **kwargs):
                """
                Timer information. This is used to report CPU timings for user and kernel processes and detailed solver timings.
                """
                return PyMenu(self.service, "/report/system/time_stats").execute(*args, **kwargs)

        class reference_values(TUIMenu):
            """
            Enters the reference value menu.
            """
            def __init__(self, path, service):
                self.path = path
                self.service = service
                self.compute = self.__class__.compute(path + ["compute"], service)
                super().__init__(path, service)
            def area(self, *args, **kwargs):
                """
                Sets reference area for normalization.
                """
                return PyMenu(self.service, "/report/reference_values/area").execute(*args, **kwargs)
            def density(self, *args, **kwargs):
                """
                Sets reference density for normalization.
                """
                return PyMenu(self.service, "/report/reference_values/density").execute(*args, **kwargs)
            def viscosity(self, *args, **kwargs):
                """
                Sets reference viscosity for normalization.
                """
                return PyMenu(self.service, "/report/reference_values/viscosity").execute(*args, **kwargs)
            def temperature(self, *args, **kwargs):
                """
                Sets reference temperature for normalization.
                """
                return PyMenu(self.service, "/report/reference_values/temperature").execute(*args, **kwargs)
            def list(self, *args, **kwargs):
                """
                Lists current reference values.
                """
                return PyMenu(self.service, "/report/reference_values/list").execute(*args, **kwargs)
            def velocity(self, *args, **kwargs):
                """
                Sets reference velocity for normalization.
                """
                return PyMenu(self.service, "/report/reference_values/velocity").execute(*args, **kwargs)
            def yplus(self, *args, **kwargs):
                """
                Sets reference yplus for calculation of Yplus Based Heat Transfer Coefficient.
                """
                return PyMenu(self.service, "/report/reference_values/yplus").execute(*args, **kwargs)
            def depth(self, *args, **kwargs):
                """
                Sets reference depth for volume calculation.
                """
                return PyMenu(self.service, "/report/reference_values/depth").execute(*args, **kwargs)
            def enthalpy(self, *args, **kwargs):
                """
                Sets reference enthalpy for enthalpy damping and normalization.
                """
                return PyMenu(self.service, "/report/reference_values/enthalpy").execute(*args, **kwargs)
            def length(self, *args, **kwargs):
                """
                Sets reference length for normalization.
                """
                return PyMenu(self.service, "/report/reference_values/length").execute(*args, **kwargs)
            def pressure(self, *args, **kwargs):
                """
                Sets reference pressure for normalization.
                """
                return PyMenu(self.service, "/report/reference_values/pressure").execute(*args, **kwargs)
            def zone(self, *args, **kwargs):
                """
                Sets reference zone.
                """
                return PyMenu(self.service, "/report/reference_values/zone").execute(*args, **kwargs)

            class compute(TUIMenu):
                """
                Computes reference values from zone boundary conditions.
                """
                def __init__(self, path, service):
                    self.path = path
                    self.service = service
                    super().__init__(path, service)
                def wall(self, *args, **kwargs):
                    """
                    Compute reference values from a zone of this type.
                    """
                    return PyMenu(self.service, "/report/reference_values/compute/wall").execute(*args, **kwargs)
                def network(self, *args, **kwargs):
                    """
                    Compute reference values from a zone of this type.
                    """
                    return PyMenu(self.service, "/report/reference_values/compute/network").execute(*args, **kwargs)
                def dummy_entry(self, *args, **kwargs):
                    """
                    .
                    """
                    return PyMenu(self.service, "/report/reference_values/compute/dummy_entry").execute(*args, **kwargs)
                def outlet_vent(self, *args, **kwargs):
                    """
                    Compute reference values from a zone of this type.
                    """
                    return PyMenu(self.service, "/report/reference_values/compute/outlet_vent").execute(*args, **kwargs)
                def solid(self, *args, **kwargs):
                    """
                    Compute reference values from a zone of this type.
                    """
                    return PyMenu(self.service, "/report/reference_values/compute/solid").execute(*args, **kwargs)
                def mass_flow_outlet(self, *args, **kwargs):
                    """
                    Compute reference values from a zone of this type.
                    """
                    return PyMenu(self.service, "/report/reference_values/compute/mass_flow_outlet").execute(*args, **kwargs)
                def outflow(self, *args, **kwargs):
                    """
                    Compute reference values from a zone of this type.
                    """
                    return PyMenu(self.service, "/report/reference_values/compute/outflow").execute(*args, **kwargs)
                def geometry(self, *args, **kwargs):
                    """
                    Compute reference values from a zone of this type.
                    """
                    return PyMenu(self.service, "/report/reference_values/compute/geometry").execute(*args, **kwargs)
                def shadow(self, *args, **kwargs):
                    """
                    Compute reference values from a zone of this type.
                    """
                    return PyMenu(self.service, "/report/reference_values/compute/shadow").execute(*args, **kwargs)
                def overset(self, *args, **kwargs):
                    """
                    Compute reference values from a zone of this type.
                    """
                    return PyMenu(self.service, "/report/reference_values/compute/overset").execute(*args, **kwargs)
                def exhaust_fan(self, *args, **kwargs):
                    """
                    Compute reference values from a zone of this type.
                    """
                    return PyMenu(self.service, "/report/reference_values/compute/exhaust_fan").execute(*args, **kwargs)
                def rans_les_interface(self, *args, **kwargs):
                    """
                    Compute reference values from a zone of this type.
                    """
                    return PyMenu(self.service, "/report/reference_values/compute/rans_les_interface").execute(*args, **kwargs)
                def recirculation_inlet(self, *args, **kwargs):
                    """
                    Compute reference values from a zone of this type.
                    """
                    return PyMenu(self.service, "/report/reference_values/compute/recirculation_inlet").execute(*args, **kwargs)
                def network_end(self, *args, **kwargs):
                    """
                    Compute reference values from a zone of this type.
                    """
                    return PyMenu(self.service, "/report/reference_values/compute/network_end").execute(*args, **kwargs)
                def pressure_inlet(self, *args, **kwargs):
                    """
                    Compute reference values from a zone of this type.
                    """
                    return PyMenu(self.service, "/report/reference_values/compute/pressure_inlet").execute(*args, **kwargs)
                def degassing(self, *args, **kwargs):
                    """
                    Compute reference values from a zone of this type.
                    """
                    return PyMenu(self.service, "/report/reference_values/compute/degassing").execute(*args, **kwargs)
                def periodic(self, *args, **kwargs):
                    """
                    Compute reference values from a zone of this type.
                    """
                    return PyMenu(self.service, "/report/reference_values/compute/periodic").execute(*args, **kwargs)
                def fluid(self, *args, **kwargs):
                    """
                    Compute reference values from a zone of this type.
                    """
                    return PyMenu(self.service, "/report/reference_values/compute/fluid").execute(*args, **kwargs)
                def velocity_inlet(self, *args, **kwargs):
                    """
                    Compute reference values from a zone of this type.
                    """
                    return PyMenu(self.service, "/report/reference_values/compute/velocity_inlet").execute(*args, **kwargs)
                def recirculation_outlet(self, *args, **kwargs):
                    """
                    Compute reference values from a zone of this type.
                    """
                    return PyMenu(self.service, "/report/reference_values/compute/recirculation_outlet").execute(*args, **kwargs)
                def pressure_outlet(self, *args, **kwargs):
                    """
                    Compute reference values from a zone of this type.
                    """
                    return PyMenu(self.service, "/report/reference_values/compute/pressure_outlet").execute(*args, **kwargs)
                def inlet_vent(self, *args, **kwargs):
                    """
                    Compute reference values from a zone of this type.
                    """
                    return PyMenu(self.service, "/report/reference_values/compute/inlet_vent").execute(*args, **kwargs)
                def radiator(self, *args, **kwargs):
                    """
                    Compute reference values from a zone of this type.
                    """
                    return PyMenu(self.service, "/report/reference_values/compute/radiator").execute(*args, **kwargs)
                def intake_fan(self, *args, **kwargs):
                    """
                    Compute reference values from a zone of this type.
                    """
                    return PyMenu(self.service, "/report/reference_values/compute/intake_fan").execute(*args, **kwargs)
                def fan(self, *args, **kwargs):
                    """
                    Compute reference values from a zone of this type.
                    """
                    return PyMenu(self.service, "/report/reference_values/compute/fan").execute(*args, **kwargs)
                def axis(self, *args, **kwargs):
                    """
                    Compute reference values from a zone of this type.
                    """
                    return PyMenu(self.service, "/report/reference_values/compute/axis").execute(*args, **kwargs)
                def pressure_far_field(self, *args, **kwargs):
                    """
                    Compute reference values from a zone of this type.
                    """
                    return PyMenu(self.service, "/report/reference_values/compute/pressure_far_field").execute(*args, **kwargs)
                def interior(self, *args, **kwargs):
                    """
                    Compute reference values from a zone of this type.
                    """
                    return PyMenu(self.service, "/report/reference_values/compute/interior").execute(*args, **kwargs)
                def symmetry(self, *args, **kwargs):
                    """
                    Compute reference values from a zone of this type.
                    """
                    return PyMenu(self.service, "/report/reference_values/compute/symmetry").execute(*args, **kwargs)
                def mass_flow_inlet(self, *args, **kwargs):
                    """
                    Compute reference values from a zone of this type.
                    """
                    return PyMenu(self.service, "/report/reference_values/compute/mass_flow_inlet").execute(*args, **kwargs)
                def porous_jump(self, *args, **kwargs):
                    """
                    Compute reference values from a zone of this type.
                    """
                    return PyMenu(self.service, "/report/reference_values/compute/porous_jump").execute(*args, **kwargs)
                def interface(self, *args, **kwargs):
                    """
                    Compute reference values from a zone of this type.
                    """
                    return PyMenu(self.service, "/report/reference_values/compute/interface").execute(*args, **kwargs)

        class heat_exchanger(TUIMenu):
            """
            Enters the heat exchanger menu.
            """
            def __init__(self, path, service):
                self.path = path
                self.service = service
                super().__init__(path, service)
            def outlet_temperature(self, *args, **kwargs):
                """
                Prints outlet temperature.
                """
                return PyMenu(self.service, "/report/heat_exchanger/outlet_temperature").execute(*args, **kwargs)
            def mass_flow_rate(self, *args, **kwargs):
                """
                Prints mass flow rate.
                """
                return PyMenu(self.service, "/report/heat_exchanger/mass_flow_rate").execute(*args, **kwargs)
            def inlet_temperature(self, *args, **kwargs):
                """
                Prints inlet temperature.
                """
                return PyMenu(self.service, "/report/heat_exchanger/inlet_temperature").execute(*args, **kwargs)
            def specific_heat(self, *args, **kwargs):
                """
                Prints fluid’s specific heat.
                """
                return PyMenu(self.service, "/report/heat_exchanger/specific_heat").execute(*args, **kwargs)
            def computed_heat_rejection(self, *args, **kwargs):
                """
                Prints total heat rejection.
                """
                return PyMenu(self.service, "/report/heat_exchanger/computed_heat_rejection").execute(*args, **kwargs)

        class fluxes(TUIMenu):
            """
            Enters the fluxes menu.
            """
            def __init__(self, path, service):
                self.path = path
                self.service = service
                super().__init__(path, service)
            def film_mass_flow(self, *args, **kwargs):
                """
                Prints wall film mass flow rate at boundaries. This text command is only available when you enable the Eulerian wall film model.
                """
                return PyMenu(self.service, "/report/fluxes/film_mass_flow").execute(*args, **kwargs)
            def pressure_work(self, *args, **kwargs):
                """
                Prints the pressure work rate at the boundaries. This text command is only available when the energy equation is enabled, the absolute velocity formulation is selected, and zone motion is enabled for a fluid cell zone.
                """
                return PyMenu(self.service, "/report/fluxes/pressure_work").execute(*args, **kwargs)
            def heat_transfer(self, *args, **kwargs):
                """
                Prints heat transfer rate at boundaries.
                """
                return PyMenu(self.service, "/report/fluxes/heat_transfer").execute(*args, **kwargs)
            def mass_flow(self, *args, **kwargs):
                """
                Prints mass flow rate at inlets and outlets.
                """
                return PyMenu(self.service, "/report/fluxes/mass_flow").execute(*args, **kwargs)
            def heat_transfer_sensible(self, *args, **kwargs):
                """
                Prints the sensible heat transfer rate at the boundaries.
                """
                return PyMenu(self.service, "/report/fluxes/heat_transfer_sensible").execute(*args, **kwargs)
            def film_heat_transfer(self, *args, **kwargs):
                """
                Prints wall film heat transfer rate at boundaries. This text command is only available when you enable the Eulerian wall film model.
                """
                return PyMenu(self.service, "/report/fluxes/film_heat_transfer").execute(*args, **kwargs)
            def viscous_work(self, *args, **kwargs):
                """
                Prints the viscous work rate at the boundaries. This text command is only available when the energy equation is enabled and the pressure-based solver is selected.
                """
                return PyMenu(self.service, "/report/fluxes/viscous_work").execute(*args, **kwargs)
            def rad_heat_trans(self, *args, **kwargs):
                """
                Prints radiation heat transfer rate at boundaries.
                """
                return PyMenu(self.service, "/report/fluxes/rad_heat_trans").execute(*args, **kwargs)

        class simulation_reports(TUIMenu):
            """
            Enter the simulation reports menu.
            """
            def __init__(self, path, service):
                self.path = path
                self.service = service
                self.parametric_study = self.__class__.parametric_study(path + ["parametric_study"], service)
                super().__init__(path, service)
            def list_simulation_reports(self, *args, **kwargs):
                """
                List all report names.
                """
                return PyMenu(self.service, "/report/simulation_reports/list_simulation_reports").execute(*args, **kwargs)
            def export_simulation_report_as_pdf(self, *args, **kwargs):
                """
                Export the provided simulation report as a PDF file.
                """
                return PyMenu(self.service, "/report/simulation_reports/export_simulation_report_as_pdf").execute(*args, **kwargs)
            def generate_simulation_report(self, *args, **kwargs):
                """
                Generate a new simulation report or regenerate an existing simulation report with the provided name.
                """
                return PyMenu(self.service, "/report/simulation_reports/generate_simulation_report").execute(*args, **kwargs)
            def rename_simulation_report(self, *args, **kwargs):
                """
                Rename a report which has already been generated.
                """
                return PyMenu(self.service, "/report/simulation_reports/rename_simulation_report").execute(*args, **kwargs)
            def duplicate_simulation_report(self, *args, **kwargs):
                """
                Duplicate a report and all of its settings to a new report.
                """
                return PyMenu(self.service, "/report/simulation_reports/duplicate_simulation_report").execute(*args, **kwargs)
            def export_simulation_report_as_pptx(self, *args, **kwargs):
                """
                Export the provided simulation report as a PPT file.
                """
                return PyMenu(self.service, "/report/simulation_reports/export_simulation_report_as_pptx").execute(*args, **kwargs)
            def delete_simulation_report(self, *args, **kwargs):
                """
                Delete the provided simulation report.
                """
                return PyMenu(self.service, "/report/simulation_reports/delete_simulation_report").execute(*args, **kwargs)
            def write_report_names_to_file(self, *args, **kwargs):
                """
                Write the list of currently generated report names to a txt file.
                """
                return PyMenu(self.service, "/report/simulation_reports/write_report_names_to_file").execute(*args, **kwargs)
            def export_simulation_report_as_html(self, *args, **kwargs):
                """
                Export the provided simulation report as HTML.
                """
                return PyMenu(self.service, "/report/simulation_reports/export_simulation_report_as_html").execute(*args, **kwargs)
            def write_simulation_report_template_file(self, *args, **kwargs):
                """
                Write a JSON template file with this case's Simulation Report settings.
                """
                return PyMenu(self.service, "/report/simulation_reports/write_simulation_report_template_file").execute(*args, **kwargs)
            def view_simulation_report(self, *args, **kwargs):
                """
                View a simulation report that has already been generated. In batch mode this will print the report's URL.
                """
                return PyMenu(self.service, "/report/simulation_reports/view_simulation_report").execute(*args, **kwargs)
            def read_simulation_report_template_file(self, *args, **kwargs):
                """
                Read a JSON template file with existing Simulation Report settings.
                """
                return PyMenu(self.service, "/report/simulation_reports/read_simulation_report_template_file").execute(*args, **kwargs)
            def reset_report_to_defaults(self, *args, **kwargs):
                """
                Reset all report settings to default for the provided simulation report.
                """
                return PyMenu(self.service, "/report/simulation_reports/reset_report_to_defaults").execute(*args, **kwargs)

            class parametric_study(TUIMenu):
                """
                Enter the parametric study menu.
                """
                def __init__(self, path, service):
                    self.path = path
                    self.service = service
                    super().__init__(path, service)
                def generate_design_point_report(self, *args, **kwargs):
                    """
                    Generate a simulation report for an updated design point.
                    """
                    return PyMenu(self.service, "/report/simulation_reports/parametric_study/generate_design_point_report").execute(*args, **kwargs)
                def generate_parametric_report(self, *args, **kwargs):
                    """
                    Generate a parametric report for your study.
                    """
                    return PyMenu(self.service, "/report/simulation_reports/parametric_study/generate_parametric_report").execute(*args, **kwargs)

    class preferences(TUIMenu):
        """
        Set preferences.
        """
        def __init__(self, path, service):
            self.path = path
            self.service = service
            self.graphics = self.__class__.graphics(path + ["graphics"], service)
            self.meshing_workflow = self.__class__.meshing_workflow(path + ["meshing_workflow"], service)
            self.mat_pro_app = self.__class__.mat_pro_app(path + ["mat_pro_app"], service)
            self.turbo_workflow = self.__class__.turbo_workflow(path + ["turbo_workflow"], service)
            self.simulation = self.__class__.simulation(path + ["simulation"], service)
            self.general = self.__class__.general(path + ["general"], service)
            self.navigation = self.__class__.navigation(path + ["navigation"], service)
            self.appearance = self.__class__.appearance(path + ["appearance"], service)
            self.gpuapp = self.__class__.gpuapp(path + ["gpuapp"], service)
            self.parametric_study = self.__class__.parametric_study(path + ["parametric_study"], service)
            super().__init__(path, service)

        class graphics(TUIMenu):
            """
            .
            """
            def __init__(self, path, service):
                self.path = path
                self.service = service
                self.meshing_mode = self.__class__.meshing_mode(path + ["meshing_mode"], service)
                self.colormap_settings = self.__class__.colormap_settings(path + ["colormap_settings"], service)
                self.embedded_windows = self.__class__.embedded_windows(path + ["embedded_windows"], service)
                self.transparency = self.__class__.transparency(path + ["transparency"], service)
                self.vector_settings = self.__class__.vector_settings(path + ["vector_settings"], service)
                self.material_effects = self.__class__.material_effects(path + ["material_effects"], service)
                self.lighting = self.__class__.lighting(path + ["lighting"], service)
                self.export_video_settings = self.__class__.export_video_settings(path + ["export_video_settings"], service)
                self.boundary_markers = self.__class__.boundary_markers(path + ["boundary_markers"], service)
                self.manage_hoops_memory = self.__class__.manage_hoops_memory(path + ["manage_hoops_memory"], service)
                self.graphics_effects = self.__class__.graphics_effects(path + ["graphics_effects"], service)
                self.performance = self.__class__.performance(path + ["performance"], service)
                self.hardcopy_settings = self.__class__.hardcopy_settings(path + ["hardcopy_settings"], service)
                super().__init__(path, service)
            def max_graphics_text_size(self, *args, **kwargs):
                """
                .
                """
                return PyMenu(self.service, "/preferences/graphics/max_graphics_text_size").execute(*args, **kwargs)
            def remove_partition_lines(self, *args, **kwargs):
                """
                .
                """
                return PyMenu(self.service, "/preferences/graphics/remove_partition_lines").execute(*args, **kwargs)
            def graphics_window_point_symbol(self, *args, **kwargs):
                """
                .
                """
                return PyMenu(self.service, "/preferences/graphics/graphics_window_point_symbol").execute(*args, **kwargs)
            def higher_resolution_graphics_window_line_width(self, *args, **kwargs):
                """
                .
                """
                return PyMenu(self.service, "/preferences/graphics/higher_resolution_graphics_window_line_width").execute(*args, **kwargs)
            def min_graphics_text_size(self, *args, **kwargs):
                """
                .
                """
                return PyMenu(self.service, "/preferences/graphics/min_graphics_text_size").execute(*args, **kwargs)
            def event_poll_timeout(self, *args, **kwargs):
                """
                .
                """
                return PyMenu(self.service, "/preferences/graphics/event_poll_timeout").execute(*args, **kwargs)
            def hidden_surface_removal_method(self, *args, **kwargs):
                """
                .
                """
                return PyMenu(self.service, "/preferences/graphics/hidden_surface_removal_method").execute(*args, **kwargs)
            def lower_resolution_graphics_window_line_width(self, *args, **kwargs):
                """
                .
                """
                return PyMenu(self.service, "/preferences/graphics/lower_resolution_graphics_window_line_width").execute(*args, **kwargs)
            def double_buffering(self, *args, **kwargs):
                """
                .
                """
                return PyMenu(self.service, "/preferences/graphics/double_buffering").execute(*args, **kwargs)
            def test_use_external_function(self, *args, **kwargs):
                """
                .
                """
                return PyMenu(self.service, "/preferences/graphics/test_use_external_function").execute(*args, **kwargs)
            def set_camera_normal_to_surface_increments(self, *args, **kwargs):
                """
                .
                """
                return PyMenu(self.service, "/preferences/graphics/set_camera_normal_to_surface_increments").execute(*args, **kwargs)
            def graphics_window_line_width(self, *args, **kwargs):
                """
                .
                """
                return PyMenu(self.service, "/preferences/graphics/graphics_window_line_width").execute(*args, **kwargs)
            def animation_option(self, *args, **kwargs):
                """
                .
                """
                return PyMenu(self.service, "/preferences/graphics/animation_option").execute(*args, **kwargs)
            def remove_partition_lines_tolerance(self, *args, **kwargs):
                """
                .
                """
                return PyMenu(self.service, "/preferences/graphics/remove_partition_lines_tolerance").execute(*args, **kwargs)
            def switch_to_open_glfor_remote_visualization(self, *args, **kwargs):
                """
                .
                """
                return PyMenu(self.service, "/preferences/graphics/switch_to_open_glfor_remote_visualization").execute(*args, **kwargs)
            def show_hidden_surfaces(self, *args, **kwargs):
                """
                .
                """
                return PyMenu(self.service, "/preferences/graphics/show_hidden_surfaces").execute(*args, **kwargs)
            def enable_non_object_based_workflow(self, *args, **kwargs):
                """
                .
                """
                return PyMenu(self.service, "/preferences/graphics/enable_non_object_based_workflow").execute(*args, **kwargs)
            def force_key_frame_animation_markers_to_off(self, *args, **kwargs):
                """
                .
                """
                return PyMenu(self.service, "/preferences/graphics/force_key_frame_animation_markers_to_off").execute(*args, **kwargs)
            def text_window_line_width(self, *args, **kwargs):
                """
                .
                """
                return PyMenu(self.service, "/preferences/graphics/text_window_line_width").execute(*args, **kwargs)
            def rotation_centerpoint_visible(self, *args, **kwargs):
                """
                .
                """
                return PyMenu(self.service, "/preferences/graphics/rotation_centerpoint_visible").execute(*args, **kwargs)
            def event_poll_interval(self, *args, **kwargs):
                """
                .
                """
                return PyMenu(self.service, "/preferences/graphics/event_poll_interval").execute(*args, **kwargs)
            def show_hidden_lines(self, *args, **kwargs):
                """
                .
                """
                return PyMenu(self.service, "/preferences/graphics/show_hidden_lines").execute(*args, **kwargs)
            def plot_legend_margin(self, *args, **kwargs):
                """
                .
                """
                return PyMenu(self.service, "/preferences/graphics/plot_legend_margin").execute(*args, **kwargs)
            def scroll_wheel_event_end_timer(self, *args, **kwargs):
                """
                .
                """
                return PyMenu(self.service, "/preferences/graphics/scroll_wheel_event_end_timer").execute(*args, **kwargs)
            def point_tool_size(self, *args, **kwargs):
                """
                .
                """
                return PyMenu(self.service, "/preferences/graphics/point_tool_size").execute(*args, **kwargs)
            def marker_drawing_mode(self, *args, **kwargs):
                """
                .
                """
                return PyMenu(self.service, "/preferences/graphics/marker_drawing_mode").execute(*args, **kwargs)

            class meshing_mode(TUIMenu):
                """
                .
                """
                def __init__(self, path, service):
                    self.path = path
                    self.service = service
                    super().__init__(path, service)
                def graphics_window_display_timeout(self, *args, **kwargs):
                    """
                    .
                    """
                    return PyMenu(self.service, "/preferences/graphics/meshing_mode/graphics_window_display_timeout").execute(*args, **kwargs)
                def graphics_window_display_timeout_value(self, *args, **kwargs):
                    """
                    .
                    """
                    return PyMenu(self.service, "/preferences/graphics/meshing_mode/graphics_window_display_timeout_value").execute(*args, **kwargs)

            class colormap_settings(TUIMenu):
                """
                .
                """
                def __init__(self, path, service):
                    self.path = path
                    self.service = service
                    super().__init__(path, service)
                def text_truncation_limit_for_vertical_colormaps(self, *args, **kwargs):
                    """
                    .
                    """
                    return PyMenu(self.service, "/preferences/graphics/colormap_settings/text_truncation_limit_for_vertical_colormaps").execute(*args, **kwargs)
                def text_font_automatic_horizontal_size(self, *args, **kwargs):
                    """
                    .
                    """
                    return PyMenu(self.service, "/preferences/graphics/colormap_settings/text_font_automatic_horizontal_size").execute(*args, **kwargs)
                def aspect_ratio_when_horizontal(self, *args, **kwargs):
                    """
                    .
                    """
                    return PyMenu(self.service, "/preferences/graphics/colormap_settings/aspect_ratio_when_horizontal").execute(*args, **kwargs)
                def text_font_automatic_vertical_size(self, *args, **kwargs):
                    """
                    .
                    """
                    return PyMenu(self.service, "/preferences/graphics/colormap_settings/text_font_automatic_vertical_size").execute(*args, **kwargs)
                def auto_refit_on_resize(self, *args, **kwargs):
                    """
                    .
                    """
                    return PyMenu(self.service, "/preferences/graphics/colormap_settings/auto_refit_on_resize").execute(*args, **kwargs)
                def border_style(self, *args, **kwargs):
                    """
                    .
                    """
                    return PyMenu(self.service, "/preferences/graphics/colormap_settings/border_style").execute(*args, **kwargs)
                def show_colormap(self, *args, **kwargs):
                    """
                    .
                    """
                    return PyMenu(self.service, "/preferences/graphics/colormap_settings/show_colormap").execute(*args, **kwargs)
                def use_no_sub_windows(self, *args, **kwargs):
                    """
                    .
                    """
                    return PyMenu(self.service, "/preferences/graphics/colormap_settings/use_no_sub_windows").execute(*args, **kwargs)
                def text_font_fixed_units(self, *args, **kwargs):
                    """
                    .
                    """
                    return PyMenu(self.service, "/preferences/graphics/colormap_settings/text_font_fixed_units").execute(*args, **kwargs)
                def text_behavior(self, *args, **kwargs):
                    """
                    .
                    """
                    return PyMenu(self.service, "/preferences/graphics/colormap_settings/text_behavior").execute(*args, **kwargs)
                def text_truncation_limit_for_horizontal_colormaps(self, *args, **kwargs):
                    """
                    .
                    """
                    return PyMenu(self.service, "/preferences/graphics/colormap_settings/text_truncation_limit_for_horizontal_colormaps").execute(*args, **kwargs)
                def text_font_automatic_size(self, *args, **kwargs):
                    """
                    .
                    """
                    return PyMenu(self.service, "/preferences/graphics/colormap_settings/text_font_automatic_size").execute(*args, **kwargs)
                def levels(self, *args, **kwargs):
                    """
                    .
                    """
                    return PyMenu(self.service, "/preferences/graphics/colormap_settings/levels").execute(*args, **kwargs)
                def text_font_fixed_vertical_size(self, *args, **kwargs):
                    """
                    .
                    """
                    return PyMenu(self.service, "/preferences/graphics/colormap_settings/text_font_fixed_vertical_size").execute(*args, **kwargs)
                def margin_from_edge_to_screen_ratio(self, *args, **kwargs):
                    """
                    .
                    """
                    return PyMenu(self.service, "/preferences/graphics/colormap_settings/margin_from_edge_to_screen_ratio").execute(*args, **kwargs)
                def isolines_position_offset(self, *args, **kwargs):
                    """
                    .
                    """
                    return PyMenu(self.service, "/preferences/graphics/colormap_settings/isolines_position_offset").execute(*args, **kwargs)
                def alignment(self, *args, **kwargs):
                    """
                    .
                    """
                    return PyMenu(self.service, "/preferences/graphics/colormap_settings/alignment").execute(*args, **kwargs)
                def min_size_scale_factor(self, *args, **kwargs):
                    """
                    .
                    """
                    return PyMenu(self.service, "/preferences/graphics/colormap_settings/min_size_scale_factor").execute(*args, **kwargs)
                def major_length_to_screen_ratio_when_vertical(self, *args, **kwargs):
                    """
                    .
                    """
                    return PyMenu(self.service, "/preferences/graphics/colormap_settings/major_length_to_screen_ratio_when_vertical").execute(*args, **kwargs)
                def colormap(self, *args, **kwargs):
                    """
                    .
                    """
                    return PyMenu(self.service, "/preferences/graphics/colormap_settings/colormap").execute(*args, **kwargs)
                def type(self, *args, **kwargs):
                    """
                    .
                    """
                    return PyMenu(self.service, "/preferences/graphics/colormap_settings/type").execute(*args, **kwargs)
                def text_font_fixed_horizontal_size(self, *args, **kwargs):
                    """
                    .
                    """
                    return PyMenu(self.service, "/preferences/graphics/colormap_settings/text_font_fixed_horizontal_size").execute(*args, **kwargs)
                def labels(self, *args, **kwargs):
                    """
                    .
                    """
                    return PyMenu(self.service, "/preferences/graphics/colormap_settings/labels").execute(*args, **kwargs)
                def number_format_type(self, *args, **kwargs):
                    """
                    .
                    """
                    return PyMenu(self.service, "/preferences/graphics/colormap_settings/number_format_type").execute(*args, **kwargs)
                def skip_value(self, *args, **kwargs):
                    """
                    .
                    """
                    return PyMenu(self.service, "/preferences/graphics/colormap_settings/skip_value").execute(*args, **kwargs)
                def aspect_ratio_when_vertical(self, *args, **kwargs):
                    """
                    .
                    """
                    return PyMenu(self.service, "/preferences/graphics/colormap_settings/aspect_ratio_when_vertical").execute(*args, **kwargs)
                def text_font_fixed_size(self, *args, **kwargs):
                    """
                    .
                    """
                    return PyMenu(self.service, "/preferences/graphics/colormap_settings/text_font_fixed_size").execute(*args, **kwargs)
                def number_format_precision(self, *args, **kwargs):
                    """
                    .
                    """
                    return PyMenu(self.service, "/preferences/graphics/colormap_settings/number_format_precision").execute(*args, **kwargs)
                def automatic_resize(self, *args, **kwargs):
                    """
                    .
                    """
                    return PyMenu(self.service, "/preferences/graphics/colormap_settings/automatic_resize").execute(*args, **kwargs)
                def log_scale(self, *args, **kwargs):
                    """
                    .
                    """
                    return PyMenu(self.service, "/preferences/graphics/colormap_settings/log_scale").execute(*args, **kwargs)
                def text_font_automatic_units(self, *args, **kwargs):
                    """
                    .
                    """
                    return PyMenu(self.service, "/preferences/graphics/colormap_settings/text_font_automatic_units").execute(*args, **kwargs)
                def text_font_name(self, *args, **kwargs):
                    """
                    .
                    """
                    return PyMenu(self.service, "/preferences/graphics/colormap_settings/text_font_name").execute(*args, **kwargs)
                def max_size_scale_factor(self, *args, **kwargs):
                    """
                    .
                    """
                    return PyMenu(self.service, "/preferences/graphics/colormap_settings/max_size_scale_factor").execute(*args, **kwargs)
                def preserve_aspect_ratio_for_hardcopy(self, *args, **kwargs):
                    """
                    .
                    """
                    return PyMenu(self.service, "/preferences/graphics/colormap_settings/preserve_aspect_ratio_for_hardcopy").execute(*args, **kwargs)
                def major_length_to_screen_ratio_when_horizontal(self, *args, **kwargs):
                    """
                    .
                    """
                    return PyMenu(self.service, "/preferences/graphics/colormap_settings/major_length_to_screen_ratio_when_horizontal").execute(*args, **kwargs)

            class embedded_windows(TUIMenu):
                """
                .
                """
                def __init__(self, path, service):
                    self.path = path
                    self.service = service
                    super().__init__(path, service)
                def default_embedded_mesh_windows_view(self, *args, **kwargs):
                    """
                    .
                    """
                    return PyMenu(self.service, "/preferences/graphics/embedded_windows/default_embedded_mesh_windows_view").execute(*args, **kwargs)
                def show_border_for_embedded_window(self, *args, **kwargs):
                    """
                    .
                    """
                    return PyMenu(self.service, "/preferences/graphics/embedded_windows/show_border_for_embedded_window").execute(*args, **kwargs)
                def save_embedded_window_layout(self, *args, **kwargs):
                    """
                    .
                    """
                    return PyMenu(self.service, "/preferences/graphics/embedded_windows/save_embedded_window_layout").execute(*args, **kwargs)
                def default_embedded_windows_view(self, *args, **kwargs):
                    """
                    .
                    """
                    return PyMenu(self.service, "/preferences/graphics/embedded_windows/default_embedded_windows_view").execute(*args, **kwargs)

            class transparency(TUIMenu):
                """
                .
                """
                def __init__(self, path, service):
                    self.path = path
                    self.service = service
                    super().__init__(path, service)
                def quick_moves(self, *args, **kwargs):
                    """
                    .
                    """
                    return PyMenu(self.service, "/preferences/graphics/transparency/quick_moves").execute(*args, **kwargs)
                def algorithm_for_modern_drivers(self, *args, **kwargs):
                    """
                    .
                    """
                    return PyMenu(self.service, "/preferences/graphics/transparency/algorithm_for_modern_drivers").execute(*args, **kwargs)
                def depth_peeling_preference(self, *args, **kwargs):
                    """
                    .
                    """
                    return PyMenu(self.service, "/preferences/graphics/transparency/depth_peeling_preference").execute(*args, **kwargs)
                def depth_peeling_layers(self, *args, **kwargs):
                    """
                    .
                    """
                    return PyMenu(self.service, "/preferences/graphics/transparency/depth_peeling_layers").execute(*args, **kwargs)
                def zsort_options(self, *args, **kwargs):
                    """
                    .
                    """
                    return PyMenu(self.service, "/preferences/graphics/transparency/zsort_options").execute(*args, **kwargs)

            class vector_settings(TUIMenu):
                """
                .
                """
                def __init__(self, path, service):
                    self.path = path
                    self.service = service
                    super().__init__(path, service)
                def line_arrow3_dperpendicular_radius(self, *args, **kwargs):
                    """
                    .
                    """
                    return PyMenu(self.service, "/preferences/graphics/vector_settings/line_arrow3_dperpendicular_radius").execute(*args, **kwargs)
                def arrow3_dradius1_factor(self, *args, **kwargs):
                    """
                    .
                    """
                    return PyMenu(self.service, "/preferences/graphics/vector_settings/arrow3_dradius1_factor").execute(*args, **kwargs)
                def arrow3_dradius2_factor(self, *args, **kwargs):
                    """
                    .
                    """
                    return PyMenu(self.service, "/preferences/graphics/vector_settings/arrow3_dradius2_factor").execute(*args, **kwargs)
                def arrowhead3_dradius1_factor(self, *args, **kwargs):
                    """
                    .
                    """
                    return PyMenu(self.service, "/preferences/graphics/vector_settings/arrowhead3_dradius1_factor").execute(*args, **kwargs)

            class material_effects(TUIMenu):
                """
                .
                """
                def __init__(self, path, service):
                    self.path = path
                    self.service = service
                    super().__init__(path, service)
                def decimation_filter(self, *args, **kwargs):
                    """
                    .
                    """
                    return PyMenu(self.service, "/preferences/graphics/material_effects/decimation_filter").execute(*args, **kwargs)
                def parameterization_source(self, *args, **kwargs):
                    """
                    .
                    """
                    return PyMenu(self.service, "/preferences/graphics/material_effects/parameterization_source").execute(*args, **kwargs)
                def tiling_style(self, *args, **kwargs):
                    """
                    .
                    """
                    return PyMenu(self.service, "/preferences/graphics/material_effects/tiling_style").execute(*args, **kwargs)

            class lighting(TUIMenu):
                """
                .
                """
                def __init__(self, path, service):
                    self.path = path
                    self.service = service
                    super().__init__(path, service)
                def lighting_method(self, *args, **kwargs):
                    """
                    .
                    """
                    return PyMenu(self.service, "/preferences/graphics/lighting/lighting_method").execute(*args, **kwargs)
                def headlight_intensity(self, *args, **kwargs):
                    """
                    .
                    """
                    return PyMenu(self.service, "/preferences/graphics/lighting/headlight_intensity").execute(*args, **kwargs)
                def headlight(self, *args, **kwargs):
                    """
                    .
                    """
                    return PyMenu(self.service, "/preferences/graphics/lighting/headlight").execute(*args, **kwargs)
                def ambient_light_intensity(self, *args, **kwargs):
                    """
                    .
                    """
                    return PyMenu(self.service, "/preferences/graphics/lighting/ambient_light_intensity").execute(*args, **kwargs)

            class export_video_settings(TUIMenu):
                """
                .
                """
                def __init__(self, path, service):
                    self.path = path
                    self.service = service
                    self.advanced_video_quality_options = self.__class__.advanced_video_quality_options(path + ["advanced_video_quality_options"], service)
                    super().__init__(path, service)
                def video_scale(self, *args, **kwargs):
                    """
                    .
                    """
                    return PyMenu(self.service, "/preferences/graphics/export_video_settings/video_scale").execute(*args, **kwargs)
                def video_quality(self, *args, **kwargs):
                    """
                    .
                    """
                    return PyMenu(self.service, "/preferences/graphics/export_video_settings/video_quality").execute(*args, **kwargs)
                def video_use_frame_resolution(self, *args, **kwargs):
                    """
                    .
                    """
                    return PyMenu(self.service, "/preferences/graphics/export_video_settings/video_use_frame_resolution").execute(*args, **kwargs)
                def video_resoution_x(self, *args, **kwargs):
                    """
                    .
                    """
                    return PyMenu(self.service, "/preferences/graphics/export_video_settings/video_resoution_x").execute(*args, **kwargs)
                def video_smooth_scaling(self, *args, **kwargs):
                    """
                    .
                    """
                    return PyMenu(self.service, "/preferences/graphics/export_video_settings/video_smooth_scaling").execute(*args, **kwargs)
                def video_resoution_y(self, *args, **kwargs):
                    """
                    .
                    """
                    return PyMenu(self.service, "/preferences/graphics/export_video_settings/video_resoution_y").execute(*args, **kwargs)
                def video_format(self, *args, **kwargs):
                    """
                    .
                    """
                    return PyMenu(self.service, "/preferences/graphics/export_video_settings/video_format").execute(*args, **kwargs)
                def video_fps(self, *args, **kwargs):
                    """
                    .
                    """
                    return PyMenu(self.service, "/preferences/graphics/export_video_settings/video_fps").execute(*args, **kwargs)

                class advanced_video_quality_options(TUIMenu):
                    """
                    .
                    """
                    def __init__(self, path, service):
                        self.path = path
                        self.service = service
                        super().__init__(path, service)
                    def bitrate(self, *args, **kwargs):
                        """
                        .
                        """
                        return PyMenu(self.service, "/preferences/graphics/export_video_settings/advanced_video_quality_options/bitrate").execute(*args, **kwargs)
                    def bit_rate_quality(self, *args, **kwargs):
                        """
                        .
                        """
                        return PyMenu(self.service, "/preferences/graphics/export_video_settings/advanced_video_quality_options/bit_rate_quality").execute(*args, **kwargs)
                    def compression_method(self, *args, **kwargs):
                        """
                        .
                        """
                        return PyMenu(self.service, "/preferences/graphics/export_video_settings/advanced_video_quality_options/compression_method").execute(*args, **kwargs)
                    def enable_h264(self, *args, **kwargs):
                        """
                        .
                        """
                        return PyMenu(self.service, "/preferences/graphics/export_video_settings/advanced_video_quality_options/enable_h264").execute(*args, **kwargs)

            class boundary_markers(TUIMenu):
                """
                .
                """
                def __init__(self, path, service):
                    self.path = path
                    self.service = service
                    super().__init__(path, service)
                def marker_fraction(self, *args, **kwargs):
                    """
                    .
                    """
                    return PyMenu(self.service, "/preferences/graphics/boundary_markers/marker_fraction").execute(*args, **kwargs)
                def marker_size_limiting_scale_multiplier(self, *args, **kwargs):
                    """
                    .
                    """
                    return PyMenu(self.service, "/preferences/graphics/boundary_markers/marker_size_limiting_scale_multiplier").execute(*args, **kwargs)
                def color_option(self, *args, **kwargs):
                    """
                    .
                    """
                    return PyMenu(self.service, "/preferences/graphics/boundary_markers/color_option").execute(*args, **kwargs)
                def exclude_from_bounding(self, *args, **kwargs):
                    """
                    .
                    """
                    return PyMenu(self.service, "/preferences/graphics/boundary_markers/exclude_from_bounding").execute(*args, **kwargs)
                def inlet_color(self, *args, **kwargs):
                    """
                    .
                    """
                    return PyMenu(self.service, "/preferences/graphics/boundary_markers/inlet_color").execute(*args, **kwargs)
                def markers_limit(self, *args, **kwargs):
                    """
                    .
                    """
                    return PyMenu(self.service, "/preferences/graphics/boundary_markers/markers_limit").execute(*args, **kwargs)
                def scale_marker(self, *args, **kwargs):
                    """
                    .
                    """
                    return PyMenu(self.service, "/preferences/graphics/boundary_markers/scale_marker").execute(*args, **kwargs)
                def enabled(self, *args, **kwargs):
                    """
                    .
                    """
                    return PyMenu(self.service, "/preferences/graphics/boundary_markers/enabled").execute(*args, **kwargs)
                def show_inlet_markers(self, *args, **kwargs):
                    """
                    .
                    """
                    return PyMenu(self.service, "/preferences/graphics/boundary_markers/show_inlet_markers").execute(*args, **kwargs)
                def outlet_color(self, *args, **kwargs):
                    """
                    .
                    """
                    return PyMenu(self.service, "/preferences/graphics/boundary_markers/outlet_color").execute(*args, **kwargs)
                def show_outlet_markers(self, *args, **kwargs):
                    """
                    .
                    """
                    return PyMenu(self.service, "/preferences/graphics/boundary_markers/show_outlet_markers").execute(*args, **kwargs)

            class manage_hoops_memory(TUIMenu):
                """
                .
                """
                def __init__(self, path, service):
                    self.path = path
                    self.service = service
                    super().__init__(path, service)
                def hsfimport_limit(self, *args, **kwargs):
                    """
                    .
                    """
                    return PyMenu(self.service, "/preferences/graphics/manage_hoops_memory/hsfimport_limit").execute(*args, **kwargs)
                def enabled(self, *args, **kwargs):
                    """
                    .
                    """
                    return PyMenu(self.service, "/preferences/graphics/manage_hoops_memory/enabled").execute(*args, **kwargs)

            class graphics_effects(TUIMenu):
                """
                .
                """
                def __init__(self, path, service):
                    self.path = path
                    self.service = service
                    super().__init__(path, service)
                def show_marker_reflections(self, *args, **kwargs):
                    """
                    .
                    """
                    return PyMenu(self.service, "/preferences/graphics/graphics_effects/show_marker_reflections").execute(*args, **kwargs)
                def update_after_mouse_release(self, *args, **kwargs):
                    """
                    .
                    """
                    return PyMenu(self.service, "/preferences/graphics/graphics_effects/update_after_mouse_release").execute(*args, **kwargs)
                def grid_plane_enabled(self, *args, **kwargs):
                    """
                    .
                    """
                    return PyMenu(self.service, "/preferences/graphics/graphics_effects/grid_plane_enabled").execute(*args, **kwargs)
                def ambient_occlusion_enabled(self, *args, **kwargs):
                    """
                    .
                    """
                    return PyMenu(self.service, "/preferences/graphics/graphics_effects/ambient_occlusion_enabled").execute(*args, **kwargs)
                def anti_aliasing(self, *args, **kwargs):
                    """
                    .
                    """
                    return PyMenu(self.service, "/preferences/graphics/graphics_effects/anti_aliasing").execute(*args, **kwargs)
                def grid_plane_offset(self, *args, **kwargs):
                    """
                    .
                    """
                    return PyMenu(self.service, "/preferences/graphics/graphics_effects/grid_plane_offset").execute(*args, **kwargs)
                def grid_plane_count(self, *args, **kwargs):
                    """
                    .
                    """
                    return PyMenu(self.service, "/preferences/graphics/graphics_effects/grid_plane_count").execute(*args, **kwargs)
                def bloom_blur(self, *args, **kwargs):
                    """
                    .
                    """
                    return PyMenu(self.service, "/preferences/graphics/graphics_effects/bloom_blur").execute(*args, **kwargs)
                def shadow_map_enabled(self, *args, **kwargs):
                    """
                    .
                    """
                    return PyMenu(self.service, "/preferences/graphics/graphics_effects/shadow_map_enabled").execute(*args, **kwargs)
                def bloom_strength(self, *args, **kwargs):
                    """
                    .
                    """
                    return PyMenu(self.service, "/preferences/graphics/graphics_effects/bloom_strength").execute(*args, **kwargs)
                def simple_shadows_enabled(self, *args, **kwargs):
                    """
                    .
                    """
                    return PyMenu(self.service, "/preferences/graphics/graphics_effects/simple_shadows_enabled").execute(*args, **kwargs)
                def reflections_enabled(self, *args, **kwargs):
                    """
                    .
                    """
                    return PyMenu(self.service, "/preferences/graphics/graphics_effects/reflections_enabled").execute(*args, **kwargs)
                def grid_plane_size_factor(self, *args, **kwargs):
                    """
                    .
                    """
                    return PyMenu(self.service, "/preferences/graphics/graphics_effects/grid_plane_size_factor").execute(*args, **kwargs)
                def ambient_occlusion_quality(self, *args, **kwargs):
                    """
                    .
                    """
                    return PyMenu(self.service, "/preferences/graphics/graphics_effects/ambient_occlusion_quality").execute(*args, **kwargs)
                def bloom_enabled(self, *args, **kwargs):
                    """
                    .
                    """
                    return PyMenu(self.service, "/preferences/graphics/graphics_effects/bloom_enabled").execute(*args, **kwargs)
                def grid_color(self, *args, **kwargs):
                    """
                    .
                    """
                    return PyMenu(self.service, "/preferences/graphics/graphics_effects/grid_color").execute(*args, **kwargs)
                def show_edge_reflections(self, *args, **kwargs):
                    """
                    .
                    """
                    return PyMenu(self.service, "/preferences/graphics/graphics_effects/show_edge_reflections").execute(*args, **kwargs)
                def ambient_occlusion_strength(self, *args, **kwargs):
                    """
                    .
                    """
                    return PyMenu(self.service, "/preferences/graphics/graphics_effects/ambient_occlusion_strength").execute(*args, **kwargs)
                def plane_direction(self, *args, **kwargs):
                    """
                    .
                    """
                    return PyMenu(self.service, "/preferences/graphics/graphics_effects/plane_direction").execute(*args, **kwargs)

            class performance(TUIMenu):
                """
                .
                """
                def __init__(self, path, service):
                    self.path = path
                    self.service = service
                    self.fast_display_mode = self.__class__.fast_display_mode(path + ["fast_display_mode"], service)
                    self.minimum_frame_rate = self.__class__.minimum_frame_rate(path + ["minimum_frame_rate"], service)
                    super().__init__(path, service)
                def optimize_for(self, *args, **kwargs):
                    """
                    .
                    """
                    return PyMenu(self.service, "/preferences/graphics/performance/optimize_for").execute(*args, **kwargs)
                def ratio_of_target_frame_rate_to_classify_heavy_geometry(self, *args, **kwargs):
                    """
                    .
                    """
                    return PyMenu(self.service, "/preferences/graphics/performance/ratio_of_target_frame_rate_to_classify_heavy_geometry").execute(*args, **kwargs)
                def ratio_of_target_frame_rate_to_declassify_heavy_geometry(self, *args, **kwargs):
                    """
                    .
                    """
                    return PyMenu(self.service, "/preferences/graphics/performance/ratio_of_target_frame_rate_to_declassify_heavy_geometry").execute(*args, **kwargs)

                class fast_display_mode(TUIMenu):
                    """
                    .
                    """
                    def __init__(self, path, service):
                        self.path = path
                        self.service = service
                        super().__init__(path, service)
                    def culling(self, *args, **kwargs):
                        """
                        .
                        """
                        return PyMenu(self.service, "/preferences/graphics/performance/fast_display_mode/culling").execute(*args, **kwargs)
                    def status(self, *args, **kwargs):
                        """
                        .
                        """
                        return PyMenu(self.service, "/preferences/graphics/performance/fast_display_mode/status").execute(*args, **kwargs)
                    def perimeter_edges_shown(self, *args, **kwargs):
                        """
                        .
                        """
                        return PyMenu(self.service, "/preferences/graphics/performance/fast_display_mode/perimeter_edges_shown").execute(*args, **kwargs)
                    def silhouette_shown(self, *args, **kwargs):
                        """
                        .
                        """
                        return PyMenu(self.service, "/preferences/graphics/performance/fast_display_mode/silhouette_shown").execute(*args, **kwargs)
                    def transparency(self, *args, **kwargs):
                        """
                        .
                        """
                        return PyMenu(self.service, "/preferences/graphics/performance/fast_display_mode/transparency").execute(*args, **kwargs)
                    def nodes_shown(self, *args, **kwargs):
                        """
                        .
                        """
                        return PyMenu(self.service, "/preferences/graphics/performance/fast_display_mode/nodes_shown").execute(*args, **kwargs)
                    def markers_decimation(self, *args, **kwargs):
                        """
                        .
                        """
                        return PyMenu(self.service, "/preferences/graphics/performance/fast_display_mode/markers_decimation").execute(*args, **kwargs)
                    def faces_shown(self, *args, **kwargs):
                        """
                        .
                        """
                        return PyMenu(self.service, "/preferences/graphics/performance/fast_display_mode/faces_shown").execute(*args, **kwargs)

                class minimum_frame_rate(TUIMenu):
                    """
                    .
                    """
                    def __init__(self, path, service):
                        self.path = path
                        self.service = service
                        super().__init__(path, service)
                    def maximum_culling_threshold(self, *args, **kwargs):
                        """
                        .
                        """
                        return PyMenu(self.service, "/preferences/graphics/performance/minimum_frame_rate/maximum_culling_threshold").execute(*args, **kwargs)
                    def target_fps(self, *args, **kwargs):
                        """
                        .
                        """
                        return PyMenu(self.service, "/preferences/graphics/performance/minimum_frame_rate/target_fps").execute(*args, **kwargs)
                    def dynamic_adjustment(self, *args, **kwargs):
                        """
                        .
                        """
                        return PyMenu(self.service, "/preferences/graphics/performance/minimum_frame_rate/dynamic_adjustment").execute(*args, **kwargs)
                    def enabled(self, *args, **kwargs):
                        """
                        .
                        """
                        return PyMenu(self.service, "/preferences/graphics/performance/minimum_frame_rate/enabled").execute(*args, **kwargs)
                    def fixed_culling_value(self, *args, **kwargs):
                        """
                        .
                        """
                        return PyMenu(self.service, "/preferences/graphics/performance/minimum_frame_rate/fixed_culling_value").execute(*args, **kwargs)
                    def minimum_culling_threshold(self, *args, **kwargs):
                        """
                        .
                        """
                        return PyMenu(self.service, "/preferences/graphics/performance/minimum_frame_rate/minimum_culling_threshold").execute(*args, **kwargs)

            class hardcopy_settings(TUIMenu):
                """
                .
                """
                def __init__(self, path, service):
                    self.path = path
                    self.service = service
                    super().__init__(path, service)
                def hardware_image_accel(self, *args, **kwargs):
                    """
                    .
                    """
                    return PyMenu(self.service, "/preferences/graphics/hardcopy_settings/hardware_image_accel").execute(*args, **kwargs)
                def hardcopy_driver(self, *args, **kwargs):
                    """
                    .
                    """
                    return PyMenu(self.service, "/preferences/graphics/hardcopy_settings/hardcopy_driver").execute(*args, **kwargs)
                def save_embedded_windows_in_hardcopy(self, *args, **kwargs):
                    """
                    .
                    """
                    return PyMenu(self.service, "/preferences/graphics/hardcopy_settings/save_embedded_windows_in_hardcopy").execute(*args, **kwargs)
                def save_embedded_hardcopies_separately(self, *args, **kwargs):
                    """
                    .
                    """
                    return PyMenu(self.service, "/preferences/graphics/hardcopy_settings/save_embedded_hardcopies_separately").execute(*args, **kwargs)
                def transparent_embedded_windows(self, *args, **kwargs):
                    """
                    .
                    """
                    return PyMenu(self.service, "/preferences/graphics/hardcopy_settings/transparent_embedded_windows").execute(*args, **kwargs)
                def hardcopy_line_width(self, *args, **kwargs):
                    """
                    .
                    """
                    return PyMenu(self.service, "/preferences/graphics/hardcopy_settings/hardcopy_line_width").execute(*args, **kwargs)
                def export_edges_for_avz(self, *args, **kwargs):
                    """
                    .
                    """
                    return PyMenu(self.service, "/preferences/graphics/hardcopy_settings/export_edges_for_avz").execute(*args, **kwargs)
                def post_script_permission_override(self, *args, **kwargs):
                    """
                    .
                    """
                    return PyMenu(self.service, "/preferences/graphics/hardcopy_settings/post_script_permission_override").execute(*args, **kwargs)

        class meshing_workflow(TUIMenu):
            """
            .
            """
            def __init__(self, path, service):
                self.path = path
                self.service = service
                self.draw_settings = self.__class__.draw_settings(path + ["draw_settings"], service)
                super().__init__(path, service)
            def templates_folder(self, *args, **kwargs):
                """
                .
                """
                return PyMenu(self.service, "/preferences/meshing_workflow/templates_folder").execute(*args, **kwargs)
            def checkpointing_option(self, *args, **kwargs):
                """
                .
                """
                return PyMenu(self.service, "/preferences/meshing_workflow/checkpointing_option").execute(*args, **kwargs)
            def save_checkpoint_files(self, *args, **kwargs):
                """
                .
                """
                return PyMenu(self.service, "/preferences/meshing_workflow/save_checkpoint_files").execute(*args, **kwargs)
            def temp_folder(self, *args, **kwargs):
                """
                .
                """
                return PyMenu(self.service, "/preferences/meshing_workflow/temp_folder").execute(*args, **kwargs)
            def verbosity(self, *args, **kwargs):
                """
                .
                """
                return PyMenu(self.service, "/preferences/meshing_workflow/verbosity").execute(*args, **kwargs)

            class draw_settings(TUIMenu):
                """
                .
                """
                def __init__(self, path, service):
                    self.path = path
                    self.service = service
                    super().__init__(path, service)
                def face_zone_limit(self, *args, **kwargs):
                    """
                    .
                    """
                    return PyMenu(self.service, "/preferences/meshing_workflow/draw_settings/face_zone_limit").execute(*args, **kwargs)
                def auto_draw(self, *args, **kwargs):
                    """
                    .
                    """
                    return PyMenu(self.service, "/preferences/meshing_workflow/draw_settings/auto_draw").execute(*args, **kwargs)
                def facet_limit(self, *args, **kwargs):
                    """
                    .
                    """
                    return PyMenu(self.service, "/preferences/meshing_workflow/draw_settings/facet_limit").execute(*args, **kwargs)

        class mat_pro_app(TUIMenu):
            """
            .
            """
            def __init__(self, path, service):
                self.path = path
                self.service = service
                super().__init__(path, service)
            def warning(self, *args, **kwargs):
                """
                .
                """
                return PyMenu(self.service, "/preferences/mat_pro_app/warning").execute(*args, **kwargs)
            def focus(self, *args, **kwargs):
                """
                .
                """
                return PyMenu(self.service, "/preferences/mat_pro_app/focus").execute(*args, **kwargs)
            def beta_features(self, *args, **kwargs):
                """
                .
                """
                return PyMenu(self.service, "/preferences/mat_pro_app/beta_features").execute(*args, **kwargs)

        class turbo_workflow(TUIMenu):
            """
            .
            """
            def __init__(self, path, service):
                self.path = path
                self.service = service
                self.graphics_settings = self.__class__.graphics_settings(path + ["graphics_settings"], service)
                self.cell_zone_settings = self.__class__.cell_zone_settings(path + ["cell_zone_settings"], service)
                self.face_zone_settings = self.__class__.face_zone_settings(path + ["face_zone_settings"], service)
                super().__init__(path, service)
            def save_checkpoint_files(self, *args, **kwargs):
                """
                .
                """
                return PyMenu(self.service, "/preferences/turbo_workflow/save_checkpoint_files").execute(*args, **kwargs)
            def checkpointing_option(self, *args, **kwargs):
                """
                .
                """
                return PyMenu(self.service, "/preferences/turbo_workflow/checkpointing_option").execute(*args, **kwargs)

            class graphics_settings(TUIMenu):
                """
                .
                """
                def __init__(self, path, service):
                    self.path = path
                    self.service = service
                    super().__init__(path, service)
                def auto_draw(self, *args, **kwargs):
                    """
                    .
                    """
                    return PyMenu(self.service, "/preferences/turbo_workflow/graphics_settings/auto_draw").execute(*args, **kwargs)

            class cell_zone_settings(TUIMenu):
                """
                .
                """
                def __init__(self, path, service):
                    self.path = path
                    self.service = service
                    super().__init__(path, service)
                def rotating(self, *args, **kwargs):
                    """
                    .
                    """
                    return PyMenu(self.service, "/preferences/turbo_workflow/cell_zone_settings/rotating").execute(*args, **kwargs)
                def czsearch_order(self, *args, **kwargs):
                    """
                    .
                    """
                    return PyMenu(self.service, "/preferences/turbo_workflow/cell_zone_settings/czsearch_order").execute(*args, **kwargs)
                def stationary(self, *args, **kwargs):
                    """
                    .
                    """
                    return PyMenu(self.service, "/preferences/turbo_workflow/cell_zone_settings/stationary").execute(*args, **kwargs)

            class face_zone_settings(TUIMenu):
                """
                .
                """
                def __init__(self, path, service):
                    self.path = path
                    self.service = service
                    super().__init__(path, service)
                def interior_region(self, *args, **kwargs):
                    """
                    .
                    """
                    return PyMenu(self.service, "/preferences/turbo_workflow/face_zone_settings/interior_region").execute(*args, **kwargs)
                def symmetry_region(self, *args, **kwargs):
                    """
                    .
                    """
                    return PyMenu(self.service, "/preferences/turbo_workflow/face_zone_settings/symmetry_region").execute(*args, **kwargs)
                def shroud_region(self, *args, **kwargs):
                    """
                    .
                    """
                    return PyMenu(self.service, "/preferences/turbo_workflow/face_zone_settings/shroud_region").execute(*args, **kwargs)
                def periodic1_region(self, *args, **kwargs):
                    """
                    .
                    """
                    return PyMenu(self.service, "/preferences/turbo_workflow/face_zone_settings/periodic1_region").execute(*args, **kwargs)
                def inlet_region(self, *args, **kwargs):
                    """
                    .
                    """
                    return PyMenu(self.service, "/preferences/turbo_workflow/face_zone_settings/inlet_region").execute(*args, **kwargs)
                def fzsearch_order(self, *args, **kwargs):
                    """
                    .
                    """
                    return PyMenu(self.service, "/preferences/turbo_workflow/face_zone_settings/fzsearch_order").execute(*args, **kwargs)
                def tip2_region(self, *args, **kwargs):
                    """
                    .
                    """
                    return PyMenu(self.service, "/preferences/turbo_workflow/face_zone_settings/tip2_region").execute(*args, **kwargs)
                def periodic2_region(self, *args, **kwargs):
                    """
                    .
                    """
                    return PyMenu(self.service, "/preferences/turbo_workflow/face_zone_settings/periodic2_region").execute(*args, **kwargs)
                def outlet_region(self, *args, **kwargs):
                    """
                    .
                    """
                    return PyMenu(self.service, "/preferences/turbo_workflow/face_zone_settings/outlet_region").execute(*args, **kwargs)
                def tip1_region(self, *args, **kwargs):
                    """
                    .
                    """
                    return PyMenu(self.service, "/preferences/turbo_workflow/face_zone_settings/tip1_region").execute(*args, **kwargs)
                def blade_region(self, *args, **kwargs):
                    """
                    .
                    """
                    return PyMenu(self.service, "/preferences/turbo_workflow/face_zone_settings/blade_region").execute(*args, **kwargs)
                def hub_region(self, *args, **kwargs):
                    """
                    .
                    """
                    return PyMenu(self.service, "/preferences/turbo_workflow/face_zone_settings/hub_region").execute(*args, **kwargs)

        class simulation(TUIMenu):
            """
            .
            """
            def __init__(self, path, service):
                self.path = path
                self.service = service
                self.report_definitions = self.__class__.report_definitions(path + ["report_definitions"], service)
                super().__init__(path, service)
            def flow_model(self, *args, **kwargs):
                """
                .
                """
                return PyMenu(self.service, "/preferences/simulation/flow_model").execute(*args, **kwargs)
            def local_residual_scaling(self, *args, **kwargs):
                """
                .
                """
                return PyMenu(self.service, "/preferences/simulation/local_residual_scaling").execute(*args, **kwargs)

            class report_definitions(TUIMenu):
                """
                .
                """
                def __init__(self, path, service):
                    self.path = path
                    self.service = service
                    super().__init__(path, service)
                def report_plot_history_data_size(self, *args, **kwargs):
                    """
                    .
                    """
                    return PyMenu(self.service, "/preferences/simulation/report_definitions/report_plot_history_data_size").execute(*args, **kwargs)
                def automatic_plot_file(self, *args, **kwargs):
                    """
                    .
                    """
                    return PyMenu(self.service, "/preferences/simulation/report_definitions/automatic_plot_file").execute(*args, **kwargs)

        class general(TUIMenu):
            """
            .
            """
            def __init__(self, path, service):
                self.path = path
                self.service = service
                super().__init__(path, service)
            def flow_model(self, *args, **kwargs):
                """
                .
                """
                return PyMenu(self.service, "/preferences/general/flow_model").execute(*args, **kwargs)
            def idle_timeout(self, *args, **kwargs):
                """
                .
                """
                return PyMenu(self.service, "/preferences/general/idle_timeout").execute(*args, **kwargs)
            def key_behavioral_changes_message(self, *args, **kwargs):
                """
                .
                """
                return PyMenu(self.service, "/preferences/general/key_behavioral_changes_message").execute(*args, **kwargs)
            def qaservice_message(self, *args, **kwargs):
                """
                .
                """
                return PyMenu(self.service, "/preferences/general/qaservice_message").execute(*args, **kwargs)
            def enable_parametric_study(self, *args, **kwargs):
                """
                .
                """
                return PyMenu(self.service, "/preferences/general/enable_parametric_study").execute(*args, **kwargs)
            def dock_editor(self, *args, **kwargs):
                """
                .
                """
                return PyMenu(self.service, "/preferences/general/dock_editor").execute(*args, **kwargs)
            def initial_physics_volume_definitions(self, *args, **kwargs):
                """
                .
                """
                return PyMenu(self.service, "/preferences/general/initial_physics_volume_definitions").execute(*args, **kwargs)
            def laplace_auto_partition_default(self, *args, **kwargs):
                """
                .
                """
                return PyMenu(self.service, "/preferences/general/laplace_auto_partition_default").execute(*args, **kwargs)
            def automatic_transcript(self, *args, **kwargs):
                """
                .
                """
                return PyMenu(self.service, "/preferences/general/automatic_transcript").execute(*args, **kwargs)
            def utlmode(self, *args, **kwargs):
                """
                .
                """
                return PyMenu(self.service, "/preferences/general/utlmode").execute(*args, **kwargs)
            def advanced_partition(self, *args, **kwargs):
                """
                .
                """
                return PyMenu(self.service, "/preferences/general/advanced_partition").execute(*args, **kwargs)
            def default_ioformat(self, *args, **kwargs):
                """
                .
                """
                return PyMenu(self.service, "/preferences/general/default_ioformat").execute(*args, **kwargs)
            def utlcreate_physics_on_mode_change(self, *args, **kwargs):
                """
                .
                """
                return PyMenu(self.service, "/preferences/general/utlcreate_physics_on_mode_change").execute(*args, **kwargs)

        class navigation(TUIMenu):
            """
            .
            """
            def __init__(self, path, service):
                self.path = path
                self.service = service
                self.mouse_mapping = self.__class__.mouse_mapping(path + ["mouse_mapping"], service)
                super().__init__(path, service)

            class mouse_mapping(TUIMenu):
                """
                .
                """
                def __init__(self, path, service):
                    self.path = path
                    self.service = service
                    self.additional = self.__class__.additional(path + ["additional"], service)
                    self.basic = self.__class__.basic(path + ["basic"], service)
                    super().__init__(path, service)
                def mousemaptheme(self, *args, **kwargs):
                    """
                    .
                    """
                    return PyMenu(self.service, "/preferences/navigation/mouse_mapping/mousemaptheme").execute(*args, **kwargs)

                class additional(TUIMenu):
                    """
                    .
                    """
                    def __init__(self, path, service):
                        self.path = path
                        self.service = service
                        super().__init__(path, service)
                    def mousewheel(self, *args, **kwargs):
                        """
                        .
                        """
                        return PyMenu(self.service, "/preferences/navigation/mouse_mapping/additional/mousewheel").execute(*args, **kwargs)
                    def shiftlmbclick(self, *args, **kwargs):
                        """
                        .
                        """
                        return PyMenu(self.service, "/preferences/navigation/mouse_mapping/additional/shiftlmbclick").execute(*args, **kwargs)
                    def shiftmmbdrag(self, *args, **kwargs):
                        """
                        .
                        """
                        return PyMenu(self.service, "/preferences/navigation/mouse_mapping/additional/shiftmmbdrag").execute(*args, **kwargs)
                    def shiftrmbdrag(self, *args, **kwargs):
                        """
                        .
                        """
                        return PyMenu(self.service, "/preferences/navigation/mouse_mapping/additional/shiftrmbdrag").execute(*args, **kwargs)
                    def ctrllmbdrag(self, *args, **kwargs):
                        """
                        .
                        """
                        return PyMenu(self.service, "/preferences/navigation/mouse_mapping/additional/ctrllmbdrag").execute(*args, **kwargs)
                    def ctrlmmbdrag(self, *args, **kwargs):
                        """
                        .
                        """
                        return PyMenu(self.service, "/preferences/navigation/mouse_mapping/additional/ctrlmmbdrag").execute(*args, **kwargs)
                    def shiftlmbdrag(self, *args, **kwargs):
                        """
                        .
                        """
                        return PyMenu(self.service, "/preferences/navigation/mouse_mapping/additional/shiftlmbdrag").execute(*args, **kwargs)
                    def ctrlmmbclick(self, *args, **kwargs):
                        """
                        .
                        """
                        return PyMenu(self.service, "/preferences/navigation/mouse_mapping/additional/ctrlmmbclick").execute(*args, **kwargs)
                    def shiftrmbclick(self, *args, **kwargs):
                        """
                        .
                        """
                        return PyMenu(self.service, "/preferences/navigation/mouse_mapping/additional/shiftrmbclick").execute(*args, **kwargs)
                    def ctrlrmbclick(self, *args, **kwargs):
                        """
                        .
                        """
                        return PyMenu(self.service, "/preferences/navigation/mouse_mapping/additional/ctrlrmbclick").execute(*args, **kwargs)
                    def reversewheeldirection(self, *args, **kwargs):
                        """
                        .
                        """
                        return PyMenu(self.service, "/preferences/navigation/mouse_mapping/additional/reversewheeldirection").execute(*args, **kwargs)
                    def shiftmmbclick(self, *args, **kwargs):
                        """
                        .
                        """
                        return PyMenu(self.service, "/preferences/navigation/mouse_mapping/additional/shiftmmbclick").execute(*args, **kwargs)
                    def mouseprobe(self, *args, **kwargs):
                        """
                        .
                        """
                        return PyMenu(self.service, "/preferences/navigation/mouse_mapping/additional/mouseprobe").execute(*args, **kwargs)
                    def ctrlrmbdrag(self, *args, **kwargs):
                        """
                        .
                        """
                        return PyMenu(self.service, "/preferences/navigation/mouse_mapping/additional/ctrlrmbdrag").execute(*args, **kwargs)
                    def ctrllmbclick(self, *args, **kwargs):
                        """
                        .
                        """
                        return PyMenu(self.service, "/preferences/navigation/mouse_mapping/additional/ctrllmbclick").execute(*args, **kwargs)
                    def mousewheelsensitivity(self, *args, **kwargs):
                        """
                        .
                        """
                        return PyMenu(self.service, "/preferences/navigation/mouse_mapping/additional/mousewheelsensitivity").execute(*args, **kwargs)

                class basic(TUIMenu):
                    """
                    .
                    """
                    def __init__(self, path, service):
                        self.path = path
                        self.service = service
                        super().__init__(path, service)
                    def rmbclick(self, *args, **kwargs):
                        """
                        .
                        """
                        return PyMenu(self.service, "/preferences/navigation/mouse_mapping/basic/rmbclick").execute(*args, **kwargs)
                    def lmb(self, *args, **kwargs):
                        """
                        .
                        """
                        return PyMenu(self.service, "/preferences/navigation/mouse_mapping/basic/lmb").execute(*args, **kwargs)
                    def mmb(self, *args, **kwargs):
                        """
                        .
                        """
                        return PyMenu(self.service, "/preferences/navigation/mouse_mapping/basic/mmb").execute(*args, **kwargs)
                    def lmbclick(self, *args, **kwargs):
                        """
                        .
                        """
                        return PyMenu(self.service, "/preferences/navigation/mouse_mapping/basic/lmbclick").execute(*args, **kwargs)
                    def mmbclick(self, *args, **kwargs):
                        """
                        .
                        """
                        return PyMenu(self.service, "/preferences/navigation/mouse_mapping/basic/mmbclick").execute(*args, **kwargs)
                    def rmb(self, *args, **kwargs):
                        """
                        .
                        """
                        return PyMenu(self.service, "/preferences/navigation/mouse_mapping/basic/rmb").execute(*args, **kwargs)

        class appearance(TUIMenu):
            """
            .
            """
            def __init__(self, path, service):
                self.path = path
                self.service = service
                self.charts = self.__class__.charts(path + ["charts"], service)
                self.ansys_logo = self.__class__.ansys_logo(path + ["ansys_logo"], service)
                self.selections = self.__class__.selections(path + ["selections"], service)
                super().__init__(path, service)
            def graphics_edge_color(self, *args, **kwargs):
                """
                .
                """
                return PyMenu(self.service, "/preferences/appearance/graphics_edge_color").execute(*args, **kwargs)
            def graphics_default_manual_node_color(self, *args, **kwargs):
                """
                .
                """
                return PyMenu(self.service, "/preferences/appearance/graphics_default_manual_node_color").execute(*args, **kwargs)
            def titles_border_offset(self, *args, **kwargs):
                """
                .
                """
                return PyMenu(self.service, "/preferences/appearance/titles_border_offset").execute(*args, **kwargs)
            def titles(self, *args, **kwargs):
                """
                .
                """
                return PyMenu(self.service, "/preferences/appearance/titles").execute(*args, **kwargs)
            def graphics_foreground_color(self, *args, **kwargs):
                """
                .
                """
                return PyMenu(self.service, "/preferences/appearance/graphics_foreground_color").execute(*args, **kwargs)
            def graphics_color_theme(self, *args, **kwargs):
                """
                .
                """
                return PyMenu(self.service, "/preferences/appearance/graphics_color_theme").execute(*args, **kwargs)
            def surface_specularity(self, *args, **kwargs):
                """
                .
                """
                return PyMenu(self.service, "/preferences/appearance/surface_specularity").execute(*args, **kwargs)
            def pastel_color_value(self, *args, **kwargs):
                """
                .
                """
                return PyMenu(self.service, "/preferences/appearance/pastel_color_value").execute(*args, **kwargs)
            def color_theme(self, *args, **kwargs):
                """
                .
                """
                return PyMenu(self.service, "/preferences/appearance/color_theme").execute(*args, **kwargs)
            def graphics_view(self, *args, **kwargs):
                """
                .
                """
                return PyMenu(self.service, "/preferences/appearance/graphics_view").execute(*args, **kwargs)
            def graphics_wall_face_color(self, *args, **kwargs):
                """
                .
                """
                return PyMenu(self.service, "/preferences/appearance/graphics_wall_face_color").execute(*args, **kwargs)
            def graphics_surface_color(self, *args, **kwargs):
                """
                .
                """
                return PyMenu(self.service, "/preferences/appearance/graphics_surface_color").execute(*args, **kwargs)
            def graphics_default_manual_face_color(self, *args, **kwargs):
                """
                .
                """
                return PyMenu(self.service, "/preferences/appearance/graphics_default_manual_face_color").execute(*args, **kwargs)
            def graphics_background_color2(self, *args, **kwargs):
                """
                .
                """
                return PyMenu(self.service, "/preferences/appearance/graphics_background_color2").execute(*args, **kwargs)
            def quick_property_view(self, *args, **kwargs):
                """
                .
                """
                return PyMenu(self.service, "/preferences/appearance/quick_property_view").execute(*args, **kwargs)
            def graphics_partition_boundary_color(self, *args, **kwargs):
                """
                .
                """
                return PyMenu(self.service, "/preferences/appearance/graphics_partition_boundary_color").execute(*args, **kwargs)
            def group_by_tree_view(self, *args, **kwargs):
                """
                .
                """
                return PyMenu(self.service, "/preferences/appearance/group_by_tree_view").execute(*args, **kwargs)
            def show_enabled_models(self, *args, **kwargs):
                """
                .
                """
                return PyMenu(self.service, "/preferences/appearance/show_enabled_models").execute(*args, **kwargs)
            def graphics_background_color1(self, *args, **kwargs):
                """
                .
                """
                return PyMenu(self.service, "/preferences/appearance/graphics_background_color1").execute(*args, **kwargs)
            def number_of_pastel_colors(self, *args, **kwargs):
                """
                .
                """
                return PyMenu(self.service, "/preferences/appearance/number_of_pastel_colors").execute(*args, **kwargs)
            def graphics_title_window_framecolor(self, *args, **kwargs):
                """
                .
                """
                return PyMenu(self.service, "/preferences/appearance/graphics_title_window_framecolor").execute(*args, **kwargs)
            def default_view(self, *args, **kwargs):
                """
                .
                """
                return PyMenu(self.service, "/preferences/appearance/default_view").execute(*args, **kwargs)
            def graphics_background_style(self, *args, **kwargs):
                """
                .
                """
                return PyMenu(self.service, "/preferences/appearance/graphics_background_style").execute(*args, **kwargs)
            def show_interface_children_zone(self, *args, **kwargs):
                """
                .
                """
                return PyMenu(self.service, "/preferences/appearance/show_interface_children_zone").execute(*args, **kwargs)
            def solution_mode_edge_color_in_meshing_mode(self, *args, **kwargs):
                """
                .
                """
                return PyMenu(self.service, "/preferences/appearance/solution_mode_edge_color_in_meshing_mode").execute(*args, **kwargs)
            def ruler(self, *args, **kwargs):
                """
                .
                """
                return PyMenu(self.service, "/preferences/appearance/ruler").execute(*args, **kwargs)
            def number_of_files_recently_used(self, *args, **kwargs):
                """
                .
                """
                return PyMenu(self.service, "/preferences/appearance/number_of_files_recently_used").execute(*args, **kwargs)
            def axis_triad(self, *args, **kwargs):
                """
                .
                """
                return PyMenu(self.service, "/preferences/appearance/axis_triad").execute(*args, **kwargs)
            def custom_title_bar(self, *args, **kwargs):
                """
                .
                """
                return PyMenu(self.service, "/preferences/appearance/custom_title_bar").execute(*args, **kwargs)
            def surface_emissivity(self, *args, **kwargs):
                """
                .
                """
                return PyMenu(self.service, "/preferences/appearance/surface_emissivity").execute(*args, **kwargs)
            def pastel_color_saturation(self, *args, **kwargs):
                """
                .
                """
                return PyMenu(self.service, "/preferences/appearance/pastel_color_saturation").execute(*args, **kwargs)
            def show_model_edges(self, *args, **kwargs):
                """
                .
                """
                return PyMenu(self.service, "/preferences/appearance/show_model_edges").execute(*args, **kwargs)
            def application_font_size(self, *args, **kwargs):
                """
                .
                """
                return PyMenu(self.service, "/preferences/appearance/application_font_size").execute(*args, **kwargs)
            def completer(self, *args, **kwargs):
                """
                .
                """
                return PyMenu(self.service, "/preferences/appearance/completer").execute(*args, **kwargs)
            def model_color_scheme(self, *args, **kwargs):
                """
                .
                """
                return PyMenu(self.service, "/preferences/appearance/model_color_scheme").execute(*args, **kwargs)
            def surface_specularity_for_contours(self, *args, **kwargs):
                """
                .
                """
                return PyMenu(self.service, "/preferences/appearance/surface_specularity_for_contours").execute(*args, **kwargs)

            class charts(TUIMenu):
                """
                .
                """
                def __init__(self, path, service):
                    self.path = path
                    self.service = service
                    self.text_color = self.__class__.text_color(path + ["text_color"], service)
                    self.font = self.__class__.font(path + ["font"], service)
                    super().__init__(path, service)
                def legend_alignment(self, *args, **kwargs):
                    """
                    .
                    """
                    return PyMenu(self.service, "/preferences/appearance/charts/legend_alignment").execute(*args, **kwargs)
                def legend_visibility(self, *args, **kwargs):
                    """
                    .
                    """
                    return PyMenu(self.service, "/preferences/appearance/charts/legend_visibility").execute(*args, **kwargs)
                def curve_colors(self, *args, **kwargs):
                    """
                    .
                    """
                    return PyMenu(self.service, "/preferences/appearance/charts/curve_colors").execute(*args, **kwargs)
                def print_plot_data(self, *args, **kwargs):
                    """
                    .
                    """
                    return PyMenu(self.service, "/preferences/appearance/charts/print_plot_data").execute(*args, **kwargs)
                def plots_behavior(self, *args, **kwargs):
                    """
                    .
                    """
                    return PyMenu(self.service, "/preferences/appearance/charts/plots_behavior").execute(*args, **kwargs)
                def modern_plots_enabled(self, *args, **kwargs):
                    """
                    .
                    """
                    return PyMenu(self.service, "/preferences/appearance/charts/modern_plots_enabled").execute(*args, **kwargs)
                def threshold(self, *args, **kwargs):
                    """
                    .
                    """
                    return PyMenu(self.service, "/preferences/appearance/charts/threshold").execute(*args, **kwargs)
                def modern_plots_points_threshold(self, *args, **kwargs):
                    """
                    .
                    """
                    return PyMenu(self.service, "/preferences/appearance/charts/modern_plots_points_threshold").execute(*args, **kwargs)
                def tooltip_interpolation(self, *args, **kwargs):
                    """
                    .
                    """
                    return PyMenu(self.service, "/preferences/appearance/charts/tooltip_interpolation").execute(*args, **kwargs)
                def print_residuals_data(self, *args, **kwargs):
                    """
                    .
                    """
                    return PyMenu(self.service, "/preferences/appearance/charts/print_residuals_data").execute(*args, **kwargs)
                def enable_open_glfor_modern_plots(self, *args, **kwargs):
                    """
                    .
                    """
                    return PyMenu(self.service, "/preferences/appearance/charts/enable_open_glfor_modern_plots").execute(*args, **kwargs)

                class text_color(TUIMenu):
                    """
                    .
                    """
                    def __init__(self, path, service):
                        self.path = path
                        self.service = service
                        super().__init__(path, service)
                    def title(self, *args, **kwargs):
                        """
                        .
                        """
                        return PyMenu(self.service, "/preferences/appearance/charts/text_color/title").execute(*args, **kwargs)
                    def legend(self, *args, **kwargs):
                        """
                        .
                        """
                        return PyMenu(self.service, "/preferences/appearance/charts/text_color/legend").execute(*args, **kwargs)
                    def axes(self, *args, **kwargs):
                        """
                        .
                        """
                        return PyMenu(self.service, "/preferences/appearance/charts/text_color/axes").execute(*args, **kwargs)
                    def axes_titles(self, *args, **kwargs):
                        """
                        .
                        """
                        return PyMenu(self.service, "/preferences/appearance/charts/text_color/axes_titles").execute(*args, **kwargs)

                class font(TUIMenu):
                    """
                    .
                    """
                    def __init__(self, path, service):
                        self.path = path
                        self.service = service
                        super().__init__(path, service)
                    def legend(self, *args, **kwargs):
                        """
                        .
                        """
                        return PyMenu(self.service, "/preferences/appearance/charts/font/legend").execute(*args, **kwargs)
                    def title(self, *args, **kwargs):
                        """
                        .
                        """
                        return PyMenu(self.service, "/preferences/appearance/charts/font/title").execute(*args, **kwargs)
                    def axes(self, *args, **kwargs):
                        """
                        .
                        """
                        return PyMenu(self.service, "/preferences/appearance/charts/font/axes").execute(*args, **kwargs)
                    def axes_titles(self, *args, **kwargs):
                        """
                        .
                        """
                        return PyMenu(self.service, "/preferences/appearance/charts/font/axes_titles").execute(*args, **kwargs)

            class ansys_logo(TUIMenu):
                """
                .
                """
                def __init__(self, path, service):
                    self.path = path
                    self.service = service
                    super().__init__(path, service)
                def color(self, *args, **kwargs):
                    """
                    .
                    """
                    return PyMenu(self.service, "/preferences/appearance/ansys_logo/color").execute(*args, **kwargs)
                def visible(self, *args, **kwargs):
                    """
                    .
                    """
                    return PyMenu(self.service, "/preferences/appearance/ansys_logo/visible").execute(*args, **kwargs)

            class selections(TUIMenu):
                """
                .
                """
                def __init__(self, path, service):
                    self.path = path
                    self.service = service
                    super().__init__(path, service)
                def highlight_gloss(self, *args, **kwargs):
                    """
                    .
                    """
                    return PyMenu(self.service, "/preferences/appearance/selections/highlight_gloss").execute(*args, **kwargs)
                def highlight_edge_color(self, *args, **kwargs):
                    """
                    .
                    """
                    return PyMenu(self.service, "/preferences/appearance/selections/highlight_edge_color").execute(*args, **kwargs)
                def probe_tooltip_show_delay_timer(self, *args, **kwargs):
                    """
                    .
                    """
                    return PyMenu(self.service, "/preferences/appearance/selections/probe_tooltip_show_delay_timer").execute(*args, **kwargs)
                def highlight_specular_component(self, *args, **kwargs):
                    """
                    .
                    """
                    return PyMenu(self.service, "/preferences/appearance/selections/highlight_specular_component").execute(*args, **kwargs)
                def mouse_over_highlight_enabled(self, *args, **kwargs):
                    """
                    .
                    """
                    return PyMenu(self.service, "/preferences/appearance/selections/mouse_over_highlight_enabled").execute(*args, **kwargs)
                def highlight_face_color(self, *args, **kwargs):
                    """
                    .
                    """
                    return PyMenu(self.service, "/preferences/appearance/selections/highlight_face_color").execute(*args, **kwargs)
                def mouse_hover_probe_values_enabled(self, *args, **kwargs):
                    """
                    .
                    """
                    return PyMenu(self.service, "/preferences/appearance/selections/mouse_hover_probe_values_enabled").execute(*args, **kwargs)
                def highlight_edge_weight(self, *args, **kwargs):
                    """
                    .
                    """
                    return PyMenu(self.service, "/preferences/appearance/selections/highlight_edge_weight").execute(*args, **kwargs)
                def highlight_transparency(self, *args, **kwargs):
                    """
                    .
                    """
                    return PyMenu(self.service, "/preferences/appearance/selections/highlight_transparency").execute(*args, **kwargs)
                def general_displacement(self, *args, **kwargs):
                    """
                    .
                    """
                    return PyMenu(self.service, "/preferences/appearance/selections/general_displacement").execute(*args, **kwargs)
                def probe_tooltip_hide_delay_timer(self, *args, **kwargs):
                    """
                    .
                    """
                    return PyMenu(self.service, "/preferences/appearance/selections/probe_tooltip_hide_delay_timer").execute(*args, **kwargs)

        class gpuapp(TUIMenu):
            """
            .
            """
            def __init__(self, path, service):
                self.path = path
                self.service = service
                super().__init__(path, service)
            def alpha_features(self, *args, **kwargs):
                """
                .
                """
                return PyMenu(self.service, "/preferences/gpuapp/alpha_features").execute(*args, **kwargs)

        class parametric_study(TUIMenu):
            """
            .
            """
            def __init__(self, path, service):
                self.path = path
                self.service = service
                self.update_options = self.__class__.update_options(path + ["update_options"], service)
                self.layout_options = self.__class__.layout_options(path + ["layout_options"], service)
                super().__init__(path, service)

            class update_options(TUIMenu):
                """
                .
                """
                def __init__(self, path, service):
                    self.path = path
                    self.service = service
                    super().__init__(path, service)
                def enable_auto_refresh(self, *args, **kwargs):
                    """
                    .
                    """
                    return PyMenu(self.service, "/preferences/parametric_study/update_options/enable_auto_refresh").execute(*args, **kwargs)
                def capture_sim_report_data(self, *args, **kwargs):
                    """
                    .
                    """
                    return PyMenu(self.service, "/preferences/parametric_study/update_options/capture_sim_report_data").execute(*args, **kwargs)
                def write_data(self, *args, **kwargs):
                    """
                    .
                    """
                    return PyMenu(self.service, "/preferences/parametric_study/update_options/write_data").execute(*args, **kwargs)
                def save_project_after_dpupdate(self, *args, **kwargs):
                    """
                    .
                    """
                    return PyMenu(self.service, "/preferences/parametric_study/update_options/save_project_after_dpupdate").execute(*args, **kwargs)
                def auto_refresh_time(self, *args, **kwargs):
                    """
                    .
                    """
                    return PyMenu(self.service, "/preferences/parametric_study/update_options/auto_refresh_time").execute(*args, **kwargs)

            class layout_options(TUIMenu):
                """
                .
                """
                def __init__(self, path, service):
                    self.path = path
                    self.service = service
                    super().__init__(path, service)
                def parametric_study_tree(self, *args, **kwargs):
                    """
                    .
                    """
                    return PyMenu(self.service, "/preferences/parametric_study/layout_options/parametric_study_tree").execute(*args, **kwargs)
                def current_case_parameters(self, *args, **kwargs):
                    """
                    .
                    """
                    return PyMenu(self.service, "/preferences/parametric_study/layout_options/current_case_parameters").execute(*args, **kwargs)

    class server(TUIMenu):
        """
        Enter the server menu.
        """
        def __init__(self, path, service):
            self.path = path
            self.service = service
            super().__init__(path, service)
        def start_client(self, *args, **kwargs):
            """
            Start the ANSYS Fluent remote visualization client.
            """
            return PyMenu(self.service, "/server/start_client").execute(*args, **kwargs)
        def print_server_address(self, *args, **kwargs):
            """
            Prints the host address and port number of the server to the console.
            """
            return PyMenu(self.service, "/server/print_server_address").execute(*args, **kwargs)
        def write_or_reset_server_info(self, *args, **kwargs):
            """
            Allows you to create a new server_info.txt file (with any name you specify), which resets the password for connecting to this server session. It does not restart the server.
            """
            return PyMenu(self.service, "/server/write_or_reset_server_info").execute(*args, **kwargs)
        def stop_web_server(self, *args, **kwargs):
            """
            Stop web server.
            """
            return PyMenu(self.service, "/server/stop_web_server").execute(*args, **kwargs)
        def shutdown_server(self, *args, **kwargs):
            """
            Shuts-down the server and disconnects the connected client.
            """
            return PyMenu(self.service, "/server/shutdown_server").execute(*args, **kwargs)
        def start_web_server(self, *args, **kwargs):
            """
            Start web server.
            """
            return PyMenu(self.service, "/server/start_web_server").execute(*args, **kwargs)
        def start_server(self, *args, **kwargs):
            """
            Starts the server for the ANSYS Fluent remote visualization client.
            """
            return PyMenu(self.service, "/server/start_server").execute(*args, **kwargs)
        def print_connected_clients(self, *args, **kwargs):
            """
            Prints the name of the connected client and its IP address to the console.
            """
            return PyMenu(self.service, "/server/print_connected_clients").execute(*args, **kwargs)

    class file(TUIMenu):
        """
        Enter the file menu.
        """
        def __init__(self, path, service):
            self.path = path
            self.service = service
            self.auto_save = self.__class__.auto_save(path + ["auto_save"], service)
            self.import_ = self.__class__.import_(path + ["import"], service)
            self.cffio_options = self.__class__.cffio_options(path + ["cffio_options"], service)
            self.em_mapping = self.__class__.em_mapping(path + ["em_mapping"], service)
            self.table_manager = self.__class__.table_manager(path + ["table_manager"], service)
            self.transient_export = self.__class__.transient_export(path + ["transient_export"], service)
            self.solution_files = self.__class__.solution_files(path + ["solution_files"], service)
            self.project = self.__class__.project(path + ["project[beta]"], service)
            self.fsi = self.__class__.fsi(path + ["fsi"], service)
            self.parametric_project = self.__class__.parametric_project(path + ["parametric_project"], service)
            self.export = self.__class__.export(path + ["export"], service)
            self.interpolate = self.__class__.interpolate(path + ["interpolate"], service)
            super().__init__(path, service)
        def read_field_functions(self, *args, **kwargs):
            """
            Reads custom field function definitions from a file.
            """
            return PyMenu(self.service, "/file/read_field_functions").execute(*args, **kwargs)
        def set_tui_version(self, *args, **kwargs):
            """
            Set the version of the TUI commands.
            """
            return PyMenu(self.service, "/file/set_tui_version").execute(*args, **kwargs)
        def write_selected_defined_profiles(self, *args, **kwargs):
            """
            Set profile names, only these profile names which will be used during writing of \*.csv profiles.
            """
            return PyMenu(self.service, "/file/write_selected_defined_profiles").execute(*args, **kwargs)
        def sync_workbench(self, *args, **kwargs):
            """
            Directly updates Workbench with the most recent Fluent changes. This command is only available when running ANSYS Fluent in Workbench.
            """
            return PyMenu(self.service, "/file/sync_workbench").execute(*args, **kwargs)
        def read_rays(self, *args, **kwargs):
            """
            Reads a ray file.
            """
            return PyMenu(self.service, "/file/read_rays").execute(*args, **kwargs)
        def write_case_data(self, *args, **kwargs):
            """
            Writes a case and a data file.
            """
            return PyMenu(self.service, "/file/write_case_data").execute(*args, **kwargs)
        def set_batch_options(self, *args, **kwargs):
            """
            Sets the batch options.
            """
            return PyMenu(self.service, "/file/set_batch_options").execute(*args, **kwargs)
        def read_viewfactors(self, *args, **kwargs):
            """
            Reads view factors from a file.
            """
            return PyMenu(self.service, "/file/read_viewfactors").execute(*args, **kwargs)
        def read_settings(self, *args, **kwargs):
            """
            Reads and sets boundary conditions from a specified file.
            """
            return PyMenu(self.service, "/file/read_settings").execute(*args, **kwargs)
        def read_isat_table(self, *args, **kwargs):
            """
            Reads ISAT Table.
            """
            return PyMenu(self.service, "/file/read_isat_table").execute(*args, **kwargs)
        def set_idle_timeout(self, *args, **kwargs):
            """
            Set the idle timeout.
            """
            return PyMenu(self.service, "/file/set_idle_timeout").execute(*args, **kwargs)
        def read_journal(self, *args, **kwargs):
            """
            Read a journal file.
            """
            return PyMenu(self.service, "/file/read_journal").execute(*args, **kwargs)
        def export_to_cfd_post(self, *args, **kwargs):
            """
            Exports data files that are compatible with CFD-Post and EnSight (that is, .cdat and .cst files) and opens CFD-Post, if desired.
            """
            return PyMenu(self.service, "/file/export_to_cfd_post").execute(*args, **kwargs)
        def write_injections(self, *args, **kwargs):
            """
            Writes out selected DPM injections to a file.
            """
            return PyMenu(self.service, "/file/write_injections").execute(*args, **kwargs)
        def write_flamelet(self, *args, **kwargs):
            """
            Writes a flamelet file.
            """
            return PyMenu(self.service, "/file/write_flamelet").execute(*args, **kwargs)
        def write_case(self, *args, **kwargs):
            """
            Write a case file.
            """
            return PyMenu(self.service, "/file/write_case").execute(*args, **kwargs)
        def show_configuration(self, *args, **kwargs):
            """
            Display current release and version information.
            """
            return PyMenu(self.service, "/file/show_configuration").execute(*args, **kwargs)
        def load_act_tool(self, *args, **kwargs):
            """
            Load ACT Start Page.
            """
            return PyMenu(self.service, "/file/load_act_tool").execute(*args, **kwargs)
        def read_profile(self, *args, **kwargs):
            """
            Reads boundary profile data.
            """
            return PyMenu(self.service, "/file/read_profile").execute(*args, **kwargs)
        def write_settings(self, *args, **kwargs):
            """
            Writes out current boundary conditions in use.
            """
            return PyMenu(self.service, "/file/write_settings").execute(*args, **kwargs)
        def stop_journal(self, *args, **kwargs):
            """
            Stop recording input and close the journal file.
            """
            return PyMenu(self.service, "/file/stop_journal").execute(*args, **kwargs)
        def binary_legacy_files(self, *args, **kwargs):
            """
            Indicate whether to write binary or text format case and data files.
            """
            return PyMenu(self.service, "/file/binary_legacy_files").execute(*args, **kwargs)
        def cff_files(self, *args, **kwargs):
            """
            Indicate whether to write ANSYS common fluids format (CFF) files or legacy case and data files.
            """
            return PyMenu(self.service, "/file/cff_files").execute(*args, **kwargs)
        def read_surface_clusters(self, *args, **kwargs):
            """
            Reads surface clusters from a file.
            """
            return PyMenu(self.service, "/file/read_surface_clusters").execute(*args, **kwargs)
        def write_pdf(self, *args, **kwargs):
            """
            Writes a pdf file.
            """
            return PyMenu(self.service, "/file/write_pdf").execute(*args, **kwargs)
        def define_macro(self, *args, **kwargs):
            """
            Saves input to a named macro.
            """
            return PyMenu(self.service, "/file/define_macro").execute(*args, **kwargs)
        def execute_macro(self, *args, **kwargs):
            """
            Runs a previously defined macro.
            """
            return PyMenu(self.service, "/file/execute_macro").execute(*args, **kwargs)
        def write_isat_table(self, *args, **kwargs):
            """
            Writes ISAT Table.
            """
            return PyMenu(self.service, "/file/write_isat_table").execute(*args, **kwargs)
        def read_case_settings(self, *args, **kwargs):
            """
            Read a case file while skipping mesh elements.
            """
            return PyMenu(self.service, "/file/read_case_settings").execute(*args, **kwargs)
        def write_currently_defined_profiles(self, *args, **kwargs):
            """
            Write currently defined profiles. To use \*.csv format specify filename with .csv suffix.
            """
            return PyMenu(self.service, "/file/write_currently_defined_profiles").execute(*args, **kwargs)
        def read_macros(self, *args, **kwargs):
            """
            Reads macro definitions from a file.
            """
            return PyMenu(self.service, "/file/read_macros").execute(*args, **kwargs)
        def stop_macro(self, *args, **kwargs):
            """
            Stops recording input to a macro.
            """
            return PyMenu(self.service, "/file/stop_macro").execute(*args, **kwargs)
        def read_pdf(self, *args, **kwargs):
            """
            Reads a PDF file.
            """
            return PyMenu(self.service, "/file/read_pdf").execute(*args, **kwargs)
        def write_cleanup_script(self, *args, **kwargs):
            """
            Writes the cleanup-script-file for ANSYS Fluent.
            """
            return PyMenu(self.service, "/file/write_cleanup_script").execute(*args, **kwargs)
        def write_data(self, *args, **kwargs):
            """
            Writes a data file.
            """
            return PyMenu(self.service, "/file/write_data").execute(*args, **kwargs)
        def start_transcript(self, *args, **kwargs):
            """
            Start recording input and output in a file.
            """
            return PyMenu(self.service, "/file/start_transcript").execute(*args, **kwargs)
        def data_file_options(self, *args, **kwargs):
            """
            Sets derived quantities to be written in data file.
            """
            return PyMenu(self.service, "/file/data_file_options").execute(*args, **kwargs)
        def write_fan_profile(self, *args, **kwargs):
            """
            Computes radial profiles for a fan zone and writes them to a profile file.
            """
            return PyMenu(self.service, "/file/write_fan_profile").execute(*args, **kwargs)
        def write_circumferential_averaged_profile(self, *args, **kwargs):
            """
            Write surface data as a boundary profile file. To use \*.csv format specify filename with .csv suffix.
            """
            return PyMenu(self.service, "/file/write_circumferential_averaged_profile").execute(*args, **kwargs)
        def write_field_functions(self, *args, **kwargs):
            """
            Writes the currently defined custom field functions to a file.
            """
            return PyMenu(self.service, "/file/write_field_functions").execute(*args, **kwargs)
        def set_err_on_inval_cmd(self, *args, **kwargs):
            """
            Set whether to abort journal replay on invalid command.
            """
            return PyMenu(self.service, "/file/set_err_on_inval_cmd").execute(*args, **kwargs)
        def replace_mesh(self, *args, **kwargs):
            """
            Replaces the mesh with a new one while preserving settings.
            """
            return PyMenu(self.service, "/file/replace_mesh").execute(*args, **kwargs)
        def write_merge_profiles(self, *args, **kwargs):
            """
            Writes a .csv file with the selected surfaces consolidated into one set of data points.
            """
            return PyMenu(self.service, "/file/write_merge_profiles").execute(*args, **kwargs)
        def start_journal(self, *args, **kwargs):
            """
            Start recording all input in a file.
            """
            return PyMenu(self.service, "/file/start_journal").execute(*args, **kwargs)
        def read_case_info(self, *args, **kwargs):
            """
            Read basic case info.
            """
            return PyMenu(self.service, "/file/read_case_info").execute(*args, **kwargs)
        def reload_setup(self, *args, **kwargs):
            """
            Discards any changes in the current ANSYS Fluent in Workbench session and removes any corresponding data from the Solution cell. This command is only available when running ANSYS Fluent in Workbench.
            """
            return PyMenu(self.service, "/file/reload_setup").execute(*args, **kwargs)
        def write_macros(self, *args, **kwargs):
            """
            Writes the currently defined macros to a file.
            """
            return PyMenu(self.service, "/file/write_macros").execute(*args, **kwargs)
        def read_transient_table(self, *args, **kwargs):
            """
            Reads table of transient boundary profile data.
            """
            return PyMenu(self.service, "/file/read_transient_table").execute(*args, **kwargs)
        def write_profile(self, *args, **kwargs):
            """
            Writes surface data as a boundary profile file.
            """
            return PyMenu(self.service, "/file/write_profile").execute(*args, **kwargs)
        def close_without_save(self, *args, **kwargs):
            """
            Exits ANSYS Fluent without saving data in Workbench. This command is only available when running ANSYS Fluent in Workbench.
            """
            return PyMenu(self.service, "/file/close_without_save").execute(*args, **kwargs)
        def stop_transcript(self, *args, **kwargs):
            """
            Stop recording input and output and close the transcript file.
            """
            return PyMenu(self.service, "/file/stop_transcript").execute(*args, **kwargs)
        def read_case(self, *args, **kwargs):
            """
            Read a case file.
            """
            return PyMenu(self.service, "/file/read_case").execute(*args, **kwargs)
        def confirm_overwrite(self, *args, **kwargs):
            """
            Indicate whether or not to confirm attempts to overwrite existing files.
            """
            return PyMenu(self.service, "/file/confirm_overwrite").execute(*args, **kwargs)
        def write_boundary_mesh(self, *args, **kwargs):
            """
            Writes the boundary mesh to a file.
            """
            return PyMenu(self.service, "/file/write_boundary_mesh").execute(*args, **kwargs)
        def write_pdat(self, *args, **kwargs):
            """
            Enables / disables the attempt to save .pdat files. Note that this text command is no longer supported.
            """
            return PyMenu(self.service, "/file/write_pdat").execute(*args, **kwargs)
        def async_optimize(self, *args, **kwargs):
            """
            Chooses whether to optimize file I/O using scratch disks and asynchronous operations.
            """
            return PyMenu(self.service, "/file/async_optimize").execute(*args, **kwargs)
        def single_precision_coordinates(self, *args, **kwargs):
            """
            Specifies whether the nodal coordinates should be written in single precision (rather than the default double precision). This text command is only available in the single-precision version of ANSYS Fluent.
            """
            return PyMenu(self.service, "/file/single_precision_coordinates").execute(*args, **kwargs)
        def read_case_data(self, *args, **kwargs):
            """
            Reads a case and a data file.
            """
            return PyMenu(self.service, "/file/read_case_data").execute(*args, **kwargs)
        def read_injections(self, *args, **kwargs):
            """
            Reads all DPM injections from a file.
            """
            return PyMenu(self.service, "/file/read_injections").execute(*args, **kwargs)
        def set_target_reference_frame_for_write_profiles(self, *args, **kwargs):
            """
            Set reference frame options, which will be used for position transformation during writing of profiles.
            """
            return PyMenu(self.service, "/file/set_target_reference_frame_for_write_profiles").execute(*args, **kwargs)
        def read_data(self, *args, **kwargs):
            """
            Reads a data file.
            """
            return PyMenu(self.service, "/file/read_data").execute(*args, **kwargs)

        class auto_save(TUIMenu):
            """
            Enters the auto save menu.
            """
            def __init__(self, path, service):
                self.path = path
                self.service = service
                super().__init__(path, service)
            def retain_most_recent_files(self, *args, **kwargs):
                """
                Sets autosave to retain the 5 most recent files.
                """
                return PyMenu(self.service, "/file/auto_save/retain_most_recent_files").execute(*args, **kwargs)
            def max_files(self, *args, **kwargs):
                """
                Sets the maximum number of files. Once the maximum is reached, files will be erased as new files are written.
                """
                return PyMenu(self.service, "/file/auto_save/max_files").execute(*args, **kwargs)
            def data_frequency(self, *args, **kwargs):
                """
                Specifies the frequency (in iterations, time steps, or flow time) with which data files are saved.
                """
                return PyMenu(self.service, "/file/auto_save/data_frequency").execute(*args, **kwargs)
            def append_file_name_with(self, *args, **kwargs):
                """
                Sets the suffix for auto-saved files. The file name can be appended by flow-time, time-step value, or by user-specified flags in file name.
                """
                return PyMenu(self.service, "/file/auto_save/append_file_name_with").execute(*args, **kwargs)
            def case_frequency(self, *args, **kwargs):
                """
                Specifies the frequency (in iterations, time steps, or flow time) with which case files are saved.
                """
                return PyMenu(self.service, "/file/auto_save/case_frequency").execute(*args, **kwargs)
            def save_data_file_every(self, *args, **kwargs):
                """
                Specifies the type and frequency of the data file to be saved.
                """
                return PyMenu(self.service, "/file/auto_save/save_data_file_every").execute(*args, **kwargs)
            def root_name(self, *args, **kwargs):
                """
                Specifies the root name for the files that are saved.
                """
                return PyMenu(self.service, "/file/auto_save/root_name").execute(*args, **kwargs)

        class import_(TUIMenu):
            """
            Enter the import menu.
            """
            def __init__(self, path, service):
                self.path = path
                self.service = service
                self.nastran = self.__class__.nastran(path + ["nastran"], service)
                self.abaqus = self.__class__.abaqus(path + ["abaqus"], service)
                self.lstc = self.__class__.lstc(path + ["lstc"], service)
                self.tecplot = self.__class__.tecplot(path + ["tecplot"], service)
                self.cfx = self.__class__.cfx(path + ["cfx"], service)
                self.cgns = self.__class__.cgns(path + ["cgns"], service)
                self.plot3d = self.__class__.plot3d(path + ["plot3d"], service)
                self.partition = self.__class__.partition(path + ["partition"], service)
                self.mechanical_apdl = self.__class__.mechanical_apdl(path + ["mechanical_apdl"], service)
                self.patran = self.__class__.patran(path + ["patran"], service)
                super().__init__(path, service)
            def hypermesh(self, *args, **kwargs):
                """
                Reads a HYPERMESH file as a case file.
                """
                return PyMenu(self.service, "/file/import/hypermesh").execute(*args, **kwargs)
            def fmu_file(self, *args, **kwargs):
                """
                Enters the import FMU file menu.
                """
                return PyMenu(self.service, "/file/import/fmu_file").execute(*args, **kwargs)
            def gambit(self, *args, **kwargs):
                """
                Imports a GAMBIT neutral file.
                """
                return PyMenu(self.service, "/file/import/gambit").execute(*args, **kwargs)
            def chemkin_report_each_line(self, *args, **kwargs):
                """
                Enables/disables reporting after reading each line.
                """
                return PyMenu(self.service, "/file/import/chemkin_report_each_line").execute(*args, **kwargs)
            def ptc_mechanica(self, *args, **kwargs):
                """
                Reads a PTC Mechanica Design file as a case file.
                """
                return PyMenu(self.service, "/file/import/ptc_mechanica").execute(*args, **kwargs)
            def marc_post(self, *args, **kwargs):
                """
                Reads a MARC POST file as a case file.
                """
                return PyMenu(self.service, "/file/import/marc_post").execute(*args, **kwargs)
            def chemkin_mechanism(self, *args, **kwargs):
                """
                Reads a CHEMKIN mechanism file.
                """
                return PyMenu(self.service, "/file/import/chemkin_mechanism").execute(*args, **kwargs)
            def ensight(self, *args, **kwargs):
                """
                Reads an EnSight file as a case file.
                """
                return PyMenu(self.service, "/file/import/ensight").execute(*args, **kwargs)
            def flamelet(self, *