from pydantic import Field
from pydantic_schemaorg.MedicalEntity import MedicalEntity
from typing import List, Optional, Union


class MedicalCause(MedicalEntity):
    """The causative agent(s) that are responsible for the pathophysiologic process that"
     "eventually results in a medical condition, symptom or sign. In this schema, unless otherwise"
     "specified this is meant to be the proximate cause of the medical condition, symptom or"
     "sign. The proximate cause is defined as the causative agent that most directly results"
     "in the medical condition, symptom or sign. For example, the HIV virus could be considered"
     "a cause of AIDS. Or in a diagnostic context, if a patient fell and sustained a hip fracture"
     "and two days later sustained a pulmonary embolism which eventuated in a cardiac arrest,"
     "the cause of the cardiac arrest (the proximate cause) would be the pulmonary embolism"
     "and not the fall. Medical causes can include cardiovascular, chemical, dermatologic,"
     "endocrine, environmental, gastroenterologic, genetic, hematologic, gynecologic,"
     "iatrogenic, infectious, musculoskeletal, neurologic, nutritional, obstetric,"
     "oncologic, otolaryngologic, pharmacologic, psychiatric, pulmonary, renal, rheumatologic,"
     "toxic, traumatic, or urologic causes; medical conditions can be causes as well.

    See https://schema.org/MedicalCause.

    """
    type_: str = Field("MedicalCause", const=True, alias='@type')
    causeOf: Optional[Union[List[Union[MedicalEntity, str]], Union[MedicalEntity, str]]] = Field(
        None,
        description="The condition, complication, symptom, sign, etc. caused.",
    )
    

MedicalCause.update_forward_refs()
