from pydantic import Field
from typing import List, Optional, Any, Union
from pydantic_schemaorg.Article import Article


class Report(Article):
    """A Report generated by governmental or non-governmental organization.

    See https://schema.org/Report.

    """
    type_: str = Field("Report", const=True, alias='@type')
    reportNumber: Optional[Union[List[str], str]] = Field(
        None,
        description="The number or other unique designator assigned to a Report by the publishing organization.",
    )
    

Report.update_forward_refs()
