# -*- coding: utf-8 -*-
from setuptools import setup

packages = \
['fastapi_mvc',
 'fastapi_mvc.cli',
 'fastapi_mvc.cli.commands',
 'fastapi_mvc.template',
 'fastapi_mvc.template.hooks',
 'fastapi_mvc.template.{{cookiecutter.folder_name}}.tests',
 'fastapi_mvc.template.{{cookiecutter.folder_name}}.tests.integration',
 'fastapi_mvc.template.{{cookiecutter.folder_name}}.tests.unit',
 'fastapi_mvc.template.{{cookiecutter.folder_name}}.tests.unit.app',
 'fastapi_mvc.template.{{cookiecutter.folder_name}}.tests.unit.app.controllers',
 'fastapi_mvc.template.{{cookiecutter.folder_name}}.tests.unit.app.controllers.api',
 'fastapi_mvc.template.{{cookiecutter.folder_name}}.tests.unit.app.controllers.api.v1',
 'fastapi_mvc.template.{{cookiecutter.folder_name}}.tests.unit.app.exceptions',
 'fastapi_mvc.template.{{cookiecutter.folder_name}}.tests.unit.app.models',
 'fastapi_mvc.template.{{cookiecutter.folder_name}}.tests.unit.app.utils',
 'fastapi_mvc.template.{{cookiecutter.folder_name}}.tests.unit.cli',
 'fastapi_mvc.template.{{cookiecutter.folder_name}}.tests.unit.cli.commands',
 'fastapi_mvc.template.{{cookiecutter.folder_name}}.{{cookiecutter.package_name}}',
 'fastapi_mvc.template.{{cookiecutter.folder_name}}.{{cookiecutter.package_name}}.app',
 'fastapi_mvc.template.{{cookiecutter.folder_name}}.{{cookiecutter.package_name}}.app.controllers',
 'fastapi_mvc.template.{{cookiecutter.folder_name}}.{{cookiecutter.package_name}}.app.controllers.api',
 'fastapi_mvc.template.{{cookiecutter.folder_name}}.{{cookiecutter.package_name}}.app.controllers.api.v1',
 'fastapi_mvc.template.{{cookiecutter.folder_name}}.{{cookiecutter.package_name}}.app.exceptions',
 'fastapi_mvc.template.{{cookiecutter.folder_name}}.{{cookiecutter.package_name}}.app.models',
 'fastapi_mvc.template.{{cookiecutter.folder_name}}.{{cookiecutter.package_name}}.app.utils',
 'fastapi_mvc.template.{{cookiecutter.folder_name}}.{{cookiecutter.package_name}}.cli',
 'fastapi_mvc.template.{{cookiecutter.folder_name}}.{{cookiecutter.package_name}}.cli.commands',
 'fastapi_mvc.template.{{cookiecutter.folder_name}}.{{cookiecutter.package_name}}.config']

package_data = \
{'': ['*'],
 'fastapi_mvc.template': ['{{cookiecutter.folder_name}}/*',
                          '{{cookiecutter.folder_name}}/.github/workflows/*',
                          '{{cookiecutter.folder_name}}/build/*',
                          '{{cookiecutter.folder_name}}/charts/{{cookiecutter.chart_name}}/*',
                          '{{cookiecutter.folder_name}}/charts/{{cookiecutter.chart_name}}/templates/*',
                          '{{cookiecutter.folder_name}}/charts/{{cookiecutter.chart_name}}/templates/tests/*',
                          '{{cookiecutter.folder_name}}/manifests/*']}

install_requires = \
['click>=7.1.2,<7.2.0', 'cookiecutter>=1.7.3,<1.8.0']

entry_points = \
{'console_scripts': ['fastapi-mvc = fastapi_mvc.cli.cli:cli']}

setup_kwargs = {
    'name': 'fastapi-mvc',
    'version': '0.5.0rc0',
    'description': 'Generate and manage FastAPI projects',
    'long_description': '# FastAPI-MVC-template\n\n\n[![CI](https://github.com/rszamszur/fastapi-mvc/actions/workflows/main.yml/badge.svg?branch=master)](https://github.com/rszamszur/fastapi-mvc/actions/workflows/main.yml)\n[![codecov](https://codecov.io/gh/rszamszur/fastapi-mvc/branch/master/graph/badge.svg?token=7ESV30TYZS)](https://codecov.io/gh/rszamszur/fastapi-mvc)\n[![K8s integration](https://github.com/rszamszur/fastapi-mvc/actions/workflows/integration.yml/badge.svg)](https://github.com/rszamszur/fastapi-mvc/actions/workflows/integration.yml)\n[![Code style: black](https://img.shields.io/badge/code%20style-black-000000.svg)](https://github.com/psf/black)\n![GitHub](https://img.shields.io/badge/fastapi-v.0.70.0-blue)\n![GitHub](https://img.shields.io/badge/python-3.7%20%7C%203.8%20%7C%203.9-blue)\n![GitHub](https://img.shields.io/github/license/rszamszur/fastapi-mvc?color=blue)\n\n---\n\nFastAPI project core implemented using MVC architectural pattern with base utilities, tests, and pipeline to speed up creating new projects based on FastAPI. \nAdditionally, this repo includes Kubernetes Helm chart, and a script for bootstrapping local development cluster with High Availability Redis cluster deployed using [spotathome/redis-operator](https://github.com/spotahome/redis-operator).\n\nAs of today [FastAPI](https://fastapi.tiangolo.com/) doesn\'t have any project generator like other known web frameworks ex: Django, Rails, etc., which makes creating new projects based on it that much more time-consuming.\nThe idea behind this template is that, one can fork this repo, rename package and then start implementing endpoints logic straightaway, rather than creating the whole project from scratch.\nMoreover, the project is structured in MVC architectural pattern to help developers who don\'t know FastAPI yet but are familiar with MVC to get up to speed quickly.\n\nLast but not least this application utilizes WSGI + ASGI combination for the best performance possible. Mainly because web servers like Nginx don\'t know how to async and WSGI is single synchronous callable. You can further read about this [here](https://asgi.readthedocs.io/en/latest/introduction.html).\nAdditionally, here are some benchmarks done by wonderful people of StackOverflow:\n* https://stackoverflow.com/a/62977786/10566747\n* https://stackoverflow.com/a/63427961/10566747\n\n### Kubernetes local development cluster\n\n[Helm chart for application](https://github.com/rszamszur/fastapi-mvc/tree/master/charts/fastapi-mvc)\n\nApplication stack in Kubernetes:\n![k8s_arch](https://github.com/rszamszur/fastapi-mvc/blob/master/assets/k8s_arch.png?raw=true)\n\n### Project structure\n\n```\n├── build                           Makefile build scripts\n├── charts                          Helm chart for application\n│\xa0\xa0 └── fastapi-mvc\n├── fastapi_mvc            Python project root\n│\xa0\xa0 ├── app                         FastAPI core implementation\n│\xa0\xa0 │\xa0\xa0 ├── controllers             FastAPI controllers\n│\xa0\xa0 │\xa0\xa0 ├── models                  FastAPI models\n│\xa0\xa0 │\xa0\xa0 ├── utils                   FastAPI utilities: RedisClient, AiohttpClient\n│\xa0\xa0 │\xa0\xa0 ├── exceptions              FastAPI custom exceptions and exception handlers\n│\xa0\xa0 │\xa0\xa0 ├── asgi.py                 FastAPI ASGI node\n│\xa0\xa0 ├── config                      FastAPI configuration: routes, variables\n│\xa0\xa0 ├── cli                         Application command line interface implementation\n│\xa0\xa0 ├── version.py                  Application version\n│\xa0\xa0 └── wsgi.py                     Application master node: WSGI\n├── tests\n│\xa0\xa0 ├── integration                 Integration test implementation\n│\xa0\xa0 └── unit                        Unit tests implementation\n├── manifests                       Manifests for spotathome/redis-operator\n├── CHANGELOG.md\n├── Dockerfile\n├── LICENSE\n├── Makefile\n├── README.md\n├── requirements.txt\n├── setup.py\n├── TAG             \n└── Vagrantfile                     Virtualized environment definiton\n```\n\n## Prerequisites\n\nIf You want to go easy way and use provided virtualized environment You\'ll need to have installed:\n* rsync \n* Vagrant [How to install vagrant](https://www.vagrantup.com/downloads)\n* (Optional) Enabled virtualization in BIOS\n\nOtherwise, for local complete project environment with k8s infrastructure bootstrapping You\'ll need:\n\nFor application:\n* Python 3.7 or later installed [How to install python](https://docs.python-guide.org/starting/installation/)\n* Poetry [How to install poetry](https://python-poetry.org/docs/#installation)\n\nFor infrastructure:\n* make, gcc, golang\n* minikube version 1.22.0 [How_to_install_minikube](https://minikube.sigs.k8s.io/docs/start/)\n* helm version 3.0.0 or higher [How_to_install_helm](https://helm.sh/docs/intro/install/)\n* kubectl version 1.16 up to 1.20.8 [How_to_install_kubectl](https://kubernetes.io/docs/tasks/tools/install-kubectl-linux/)\n* Container runtime interface. NOTE! dev-env script uses docker for minikube, for other CRI you\'ll need to modify this line in dev-env.sh `MINIKUBE_IN_STYLE=0 minikube start --driver=docker 2>/dev/null`\n\n## Quickstart\nFirst run `vagrant up` in project root directory and enter virtualized environment using `vagrant ssh`\nThen run following commands to bootstrap local development cluster exposing `fastapi-mvc` application.\n```sh\n$ cd /syncd\n$ make dev-env\n```\n*Note: this process may take a while on first run.*\n\nOnce development cluster is up and running you should see summary listing application address:\n```\nKubernetes cluster ready\n\nfastapi-mvc available under: http://fastapi-mvc.192.168.49.2.nip.io/\n\nYou can delete dev-env by issuing: minikube delete\n```\n*Note: above address may be different for your installation.*\n\n*Note: provided virtualized env doesn\'t have port forwarding configured which means, that bootstrapped application stack in k8s won\'t be accessible on Host OS.*\n\nDeployed application stack in Kubernetes:\n```shell\nvagrant@ubuntu-focal:/syncd$ make dev-env\n...\n...\n...\nKubernetes cluster ready\nFastAPI available under: http://fastapi-mvc.192.168.49.2.nip.io/\nYou can delete dev-env by issuing: make clean\nvagrant@ubuntu-focal:/syncd$ kubectl get all -n fastapi-mvc\nNAME                                                     READY   STATUS    RESTARTS   AGE\npod/fastapi-mvc-7f4dd8dc7f-p2kr7                1/1     Running   0          55s\npod/rfr-redisfailover-persistent-keep-0                  1/1     Running   0          3m39s\npod/rfr-redisfailover-persistent-keep-1                  1/1     Running   0          3m39s\npod/rfr-redisfailover-persistent-keep-2                  1/1     Running   0          3m39s\npod/rfs-redisfailover-persistent-keep-5d46b5bcf8-2r7th   1/1     Running   0          3m39s\npod/rfs-redisfailover-persistent-keep-5d46b5bcf8-6kqv5   1/1     Running   0          3m39s\npod/rfs-redisfailover-persistent-keep-5d46b5bcf8-sgtvv   1/1     Running   0          3m39s\n\nNAME                                        TYPE        CLUSTER-IP      EXTERNAL-IP   PORT(S)     AGE\nservice/fastapi-mvc                ClusterIP   10.110.42.252   <none>        8000/TCP    56s\nservice/rfs-redisfailover-persistent-keep   ClusterIP   10.110.4.24     <none>        26379/TCP   3m39s\n\nNAME                                                READY   UP-TO-DATE   AVAILABLE   AGE\ndeployment.apps/fastapi-mvc                1/1     1            1           55s\ndeployment.apps/rfs-redisfailover-persistent-keep   3/3     3            3           3m39s\n\nNAME                                                           DESIRED   CURRENT   READY   AGE\nreplicaset.apps/fastapi-mvc-7f4dd8dc7f                1         1         1       55s\nreplicaset.apps/rfs-redisfailover-persistent-keep-5d46b5bcf8   3         3         3       3m39s\n\nNAME                                                 READY   AGE\nstatefulset.apps/rfr-redisfailover-persistent-keep   3/3     3m39s\n\nNAME                                                                  AGE\nredisfailover.databases.spotahome.com/redisfailover-persistent-keep   3m39s\nvagrant@ubuntu-focal:/syncd$ curl http://fastapi-mvc.192.168.49.2.nip.io/api/ready\n{"status":"ok"}\n```\n\n## Installation\n\nUsing poetry directly:\n```shell\npoetry install --extras "aioredis aiohttp"\n```\n\nOr using make:\n```shell\nmake install\n```\n\nYou can customize poetry installation with [environment variables](https://python-poetry.org/docs/configuration/#using-environment-variables) \n```shell\nexport POETRY_HOME=/custom/poetry/path\nexport POETRY_CACHE_DIR=/custom/poetry/path/cache\nexport POETRY_VIRTUALENVS_IN_PROJECT=true\nmake install\n```\n\nTo bootstrap local minikube Kubernetes cluster exposing `fastapi-mvc` application:\n```shell\ncd fastapi-mvc\n$ make dev-env\n```\n\n## CLI\n\nThis package exposes simple CLI for easier interaction:\n\n```shell\n$ fastapi --help\nUsage: fastapi [OPTIONS] COMMAND [ARGS]...\n\n  fastapi-mvc CLI root.\n\nOptions:\n  -v, --verbose  Enable verbose logging.\n  --help         Show this message and exit.\n\nCommands:\n  serve  fastapi-mvc CLI serve command.\n$ fastapi serve --help\nUsage: fastapi serve [OPTIONS]\n\n  fastapi-mvc CLI serve command.\n\nOptions:\n  --host TEXT                  Host to bind.  [default: localhost]\n  -p, --port INTEGER           Port to bind.  [default: 8000]\n  -w, --workers INTEGER RANGE  The number of worker processes for handling\n                               requests.  [default: 2;1<=x<=8]\n  --help                       Show this message and exit.\n```\n\n*NOTE: Maximum number of workers may be different in your case, it\'s limited to `multiprocessing.cpu_count()`*\n\nTo serve application simply run:\n\n```shell\n$ fastapi serve\n```\n\nTo confirm it\'s working:\n\n```shell\n$ curl localhost:8000/api/ready\n{"status":"ok"}\n```\n\n## Dockerfile\n\nThis repository provides Dockerfile for virtualized environment.\n\n*NOTE: Replace podman with docker if it\'s yours containerization engine.*\n```shell\n$ make image\n$ podman run -dit --name fastapi-mvc -p 8000:8000 fastapi-mvc:$(cat TAG)\nf41e5fa7ffd512aea8f1aad1c12157bf1e66f961aeb707f51993e9ac343f7a4b\n$ podman ps\nCONTAINER ID  IMAGE                                 COMMAND               CREATED        STATUS            PORTS                   NAMES\nf41e5fa7ffd5  localhost/fastapi-mvc:0.1.0  /usr/bin/fastapi ...  2 seconds ago  Up 3 seconds ago  0.0.0.0:8000->8000/tcp  fastapi-mvc\n$ curl localhost:8000/api/ready\n{"status":"ok"}\n```\n\n## Application configuration\n\nThis application provides flexibility of configuration. \nAll significant settings are defined by the environment variables, each with the default value. \nMoreover, package CLI allows overriding core ones: host, port, workers. \nYou can modify all other available configuration settings in the gunicorn.conf.py file.\n\nPriority of overriding configuration:\n1. cli\n2. environment variables\n3. gunicorn.conf.py\n\nAll application configuration is available in `fastapi_mvc.config` submodule.\n\n### Environment variables\n\n#### Application configuration\n\n| Key                  | Default                  | Description                                                    |\n|----------------------|--------------------------|----------------------------------------------------------------|\n| FASTAPI_HOST         | `"127.0.0.1"`            | FastAPI host to bind.                                          |\n| FASTAPI_PORT         | `"8000"`                 | FastAPI port to bind.                                          |\n| FASTAPI_WORKERS      | `"2"`                    | Number of gunicorn workers (uvicorn.workers.UvicornWorker)     |\n| FASTAPI_DEBUG        | `"True"`                 | FastAPI logging level. You should disable this for production. |\n| FASTAPI_PROJECT_NAME | `"fastapi_mvc"` | FastAPI project name.                                          |\n| FASTAPI_VERSION      | `"0.4.0"`                | Application version.                                           |\n| FASTAPI_DOCS_URL     | `"/"`                    | Path where swagger ui will be served at.                       |\n| FASTAPI_USE_REDIS    | `"False"`                | Whether or not to use Redis.                                   |\n| FASTAPI_GUNICORN_LOG_LEVEL | `"info"` | The granularity of gunicorn log output |\n| FASTAPI_GUNICORN_LOG_FORMAT | `\'%(h)s %(l)s %(u)s %(t)s "%(r)s" %(s)s %(b)s "%(f)s" "%(a)s"\'` | Gunicorn log format |\n\n\n#### Redis configuration\n\n| Key                        | Default       | Description                               |\n|----------------------------|---------------|-------------------------------------------|\n| FASTAPI_REDIS_HOTS         | `"127.0.0.1"` | Redis host.                               |\n| FASTAPI_REDIS_PORT         | `"6379"`      | Redis port.                               |\n| FASTAPI_REDIS_USERNAME     | `""`          | Redis username.                           |\n| FASTAPI_REDIS_PASSWORD     | `""`          | Redis password.                           |\n| FASTAPI_REDIS_USE_SENTINEL | `"False"`     | If provided Redis config is for Sentinel. |\n\n### gunicorn.conf.py\n\n1. [Source](https://github.com/rszamszur/fastapi-mvc/blob/master/fastapi_mvc/config/gunicorn.conf.py)\n2. [Gunicorn configuration file documentation](https://docs.gunicorn.org/en/latest/settings.html)\n\n### Routes definition\n\nEndpoints are defined in `fastapi_mvc.config.router`. Just simply import your controller and include it to FastAPI router:\n\n```python\nfrom fastapi import APIRouter\nfrom fastapi_mvc.app.controllers.api.v1 import ready\n\nrouter = APIRouter(\n    prefix="/api"\n)\n\nrouter.include_router(ready.router, tags=["ready"])\n```\n\n## Development\n\nYou can implement your own web routes logic straight away in `.app.controllers.api.v1` submodule. For more information please see [FastAPI documentation](https://fastapi.tiangolo.com/tutorial/).\n\n### Utilities\n\nFor your discretion, I\'ve provided some basic utilities:\n* RedisClient `.app.utils.redis`\n* AiohttpClient `.app.utils.aiohttp_client`\n\nThey\'re initialized in `asgi.py` on FastAPI startup event handler:\n\n```python\nasync def on_startup():\n    """Fastapi startup event handler.\n\n    Creates RedisClient and AiohttpClient session.\n\n    """\n    log.debug("Execute FastAPI startup event handler.")\n    # Initialize utilities for whole FastAPI application without passing object\n    # instances within the logic. Feel free to disable it if you don\'t need it.\n    if settings.USE_REDIS:\n        await RedisClient.open_redis_client()\n\n    AiohttpClient.get_aiohttp_client()\n\n\nasync def on_shutdown():\n    """Fastapi shutdown event handler.\n\n    Destroys RedisClient and AiohttpClient session.\n\n    """\n    log.debug("Execute FastAPI shutdown event handler.")\n    # Gracefully close utilities.\n    if settings.USE_REDIS:\n        await RedisClient.close_redis_client()\n\n    await AiohttpClient.close_aiohttp_client()\n```\n\nand are available for whole application scope without passing object instances. In order to utilize it just execute classmethods directly.\n\nExample:\n```python\nfrom fastapi_mvc.app.utils import RedisClient\n\nresponse = RedisClient.get("Key")\n```\n```python\nfrom fastapi_mvc.app.utils import AiohttpClient\n\nresponse = AiohttpClient.get("http://foo.bar")\n```\n\nIf you don\'t need it just simply remove the utility, init on start up and tests.\n\n### Exceptions\n\n#### [HTTPException and handler](https://github.com/rszamszur/fastapi-mvc/blob/master/fastapi_mvc/app/exceptions/http.py)\n\nThis exception combined with `http_exception_handler` method allows you to use it the same manner as you\'d use `FastAPI.HTTPException` with one difference. \nYou have freedom to define returned response body, whereas in `FastAPI.HTTPException` content is returned under "detail" JSON key.\nIn this application custom handler is added in `asgi.py` while initializing FastAPI application. \nThis is needed in order to handle it globally.\n\n[Example usage in ready controller](https://github.com/rszamszur/fastapi-mvc/blob/master/fastapi_mvc/app/controllers/api/v1/ready.py)\n\n### Web Routes\nAll routes documentation is available on:\n* `/` with Swagger\n* `/redoc` or ReDoc.\n\n## Renaming\n\nTo your discretion I\'ve provided simple bash script for renaming whole project, although I do not guarantee it will work with all possible names.\n\nIt takes two parameters:\n1) new project name *NOTE: if your project name contains \'-\' this script should automatically change \'-\' to \'_\' wherever it\'s needed.*\n2) new project url\n\n```shell\n#!/usr/bin/env bash\n\nif [ -n "$DEBUG" ]; then\n  set -x\nfi\n\nset -o errexit\nset -o nounset\nset -o pipefail\n\nif [[ -z "$1" ]]; then\n  echo "Parameter project name is empty."\n  exit 1\nfi\n\nif [[ -z "$2" ]]; then\n  echo "Parameter project url is empty."\n  exit 1\nfi\n\ngrep -rl "https://github.com/rszamszur/fastapi-mvc" | xargs sed -i "s/https:\\/\\/github.com\\/rszamszur\\/fastapi-mvc/${2//\\//\\\\/}/g"\nmv charts/fastapi-mvc charts/$1\n\nif [[ $1 == *"-"* ]]; then\n  mv fastapi_mvc ${1//-/_}\n  grep -rl --exclude-dir=.git fastapi_mvc | xargs sed -i "s/fastapi_mvc/${1//-/_}/g"\nelse\n  mv fastapi_mvc $1\n  grep -rl --exclude-dir=.git fastapi_mvc | xargs sed -i "s/fastapi_mvc/$1/g"\nfi\n\ngrep -rl --exclude-dir=.git fastapi-mvc | xargs sed -i "s/fastapi-mvc/$1/g"\ngrep -rl --exclude-dir=.git \'fastapi-mvc\' | xargs sed -i "s/fastapi-mvc/$1/g"\ngrep -rl --exclude-dir=.git \'Fastapi MVC template\' | xargs sed -i "s/fastapi-mvc/$1/g"\n```\n*NOTE: Afterwards you may still want to edit some docstrings or descriptions.*\n\n## Contributing\n\nQuestions, comments or improvements? Please create an issue on Github. I do my best to include every contribution proposed in any way that I can.\n\n## License\n\n[MIT](https://github.com/rszamszur/fastapi-mvc/blob/master/LICENSE)\n',
    'author': 'Radosław Szamszur',
    'author_email': 'radoslawszamszur@gmail.com',
    'maintainer': None,
    'maintainer_email': None,
    'url': 'https://github.com/rszamszur/fastapi-mvc',
    'packages': packages,
    'package_data': package_data,
    'install_requires': install_requires,
    'entry_points': entry_points,
    'python_requires': '>=3.7,<4.0',
}


setup(**setup_kwargs)
