# lodgea-python
LODGEA SDK for python. Check out https://docs.lodgea.io for more information.

This Python package is automatically generated by the [OpenAPI Generator](https://openapi-generator.tech) project:

- API version: 1.2.0
- Package version: 1.2.0
- Build package: org.openapitools.codegen.languages.PythonClientCodegen

## Requirements.

Python >=3.6

## Installation & Usage
### pip install

If the python package is hosted on a repository, you can install directly using:

```sh
pip install git+https://github.com/GIT_USER_ID/GIT_REPO_ID.git
```
(you may need to run `pip` with root permission: `sudo pip install git+https://github.com/GIT_USER_ID/GIT_REPO_ID.git`)

Then import the package:
```python
import lodgea-python
```

### Setuptools

Install via [Setuptools](http://pypi.python.org/pypi/setuptools).

```sh
python setup.py install --user
```
(or `sudo python setup.py install` to install the package for all users)

Then import the package:
```python
import lodgea-python
```

## Getting Started

Please follow the [installation procedure](#installation--usage) and then run the following:

```python

import time
import lodgea-python
from pprint import pprint
from com.lodgea.controllers import default_api
from lodgea-python.model.inline_object import InlineObject
from lodgea-python.model.inline_object1 import InlineObject1
from lodgea-python.model.inline_response200 import InlineResponse200
from lodgea-python.model.inline_response2001 import InlineResponse2001
from lodgea-python.model.inline_response2002 import InlineResponse2002
from lodgea-python.model.inline_response2003 import InlineResponse2003
from lodgea-python.model.inline_response2004 import InlineResponse2004
from lodgea-python.model.inline_response400 import InlineResponse400
from lodgea-python.model.inline_response4001 import InlineResponse4001
# Defining the host is optional and defaults to https://api.eu.lodgea.io/v1
# See configuration.py for a list of all supported configuration parameters.
configuration = lodgea-python.Configuration(
    host = "https://api.eu.lodgea.io/v1"
)

# The client must configure the authentication and authorization parameters
# in accordance with the API server security policy.
# Examples for each auth method are provided below, use the example that
# satisfies your auth use case.

# Configure API key authorization: ApiKeyAuth
configuration.api_key['ApiKeyAuth'] = 'YOUR_API_KEY'

# Uncomment below to setup prefix (e.g. Bearer) for API key, if needed
# configuration.api_key_prefix['ApiKeyAuth'] = 'Bearer'


# Enter a context with an instance of the API client
with lodgea-python.ApiClient(configuration) as api_client:
    # Create an instance of the API class
    api_instance = default_api.DefaultApi(api_client)
    inline_object1 = InlineObject1(
        adult_count=2,
        child_count=2,
        child_age_list=[4,7],
        currency_code="EUR",
        language_code="en",
        unit_system="metric",
        min_length_of_stay=1,
        max_length_of_stay=27,
        location_name="Oberbayern",
        location_type="locality",
        earliest_arrival="2022-09-01",
        latest_return="2022-09-08",
        sort="price",
        service_list=[1,2],
        type_list=[3,4],
        unit_type_list=[5,6],
        unit_amenity_list=[7,8],
        meal_plan_list=[9,10],
    ) # InlineObject1 |  (optional)

    try:
        # Search for availability
        api_response = api_instance.availability_search_post(inline_object1=inline_object1)
        pprint(api_response)
    except lodgea-python.ApiException as e:
        print("Exception when calling DefaultApi->availability_search_post: %s\n" % e)
```

## Documentation for API Endpoints

All URIs are relative to *https://api.eu.lodgea.io/v1*

Class | Method | HTTP request | Description
------------ | ------------- | ------------- | -------------
*DefaultApi* | [**availability_search_post**](docs/DefaultApi.md#availability_search_post) | **POST** /availability/search | Search for availability
*DefaultApi* | [**location_search_post**](docs/DefaultApi.md#location_search_post) | **POST** /location/search | Search for location
*DefaultApi* | [**properties_get**](docs/DefaultApi.md#properties_get) | **GET** /properties | List (filtered) properties
*DefaultApi* | [**properties_property_id_availability_get**](docs/DefaultApi.md#properties_property_id_availability_get) | **GET** /properties/{propertyId}/availability | Get a properties availability
*DefaultApi* | [**properties_property_id_get**](docs/DefaultApi.md#properties_property_id_get) | **GET** /properties/{propertyId} | Get a properties details


## Documentation For Models

 - [InlineObject](docs/InlineObject.md)
 - [InlineObject1](docs/InlineObject1.md)
 - [InlineResponse200](docs/InlineResponse200.md)
 - [InlineResponse2001](docs/InlineResponse2001.md)
 - [InlineResponse2001AttractionList](docs/InlineResponse2001AttractionList.md)
 - [InlineResponse2001Distance](docs/InlineResponse2001Distance.md)
 - [InlineResponse2001Geo](docs/InlineResponse2001Geo.md)
 - [InlineResponse2001GeoLocation](docs/InlineResponse2001GeoLocation.md)
 - [InlineResponse2001List](docs/InlineResponse2001List.md)
 - [InlineResponse2001LowestPrice](docs/InlineResponse2001LowestPrice.md)
 - [InlineResponse2001MediaList](docs/InlineResponse2001MediaList.md)
 - [InlineResponse2002](docs/InlineResponse2002.md)
 - [InlineResponse2002List](docs/InlineResponse2002List.md)
 - [InlineResponse2003](docs/InlineResponse2003.md)
 - [InlineResponse2003PolicyInfo](docs/InlineResponse2003PolicyInfo.md)
 - [InlineResponse2003PolicyInfoFeePolicyList](docs/InlineResponse2003PolicyInfoFeePolicyList.md)
 - [InlineResponse2003PolicyInfoTaxPolicyList](docs/InlineResponse2003PolicyInfoTaxPolicyList.md)
 - [InlineResponse2003PricingList](docs/InlineResponse2003PricingList.md)
 - [InlineResponse2003ProductList](docs/InlineResponse2003ProductList.md)
 - [InlineResponse2003Property](docs/InlineResponse2003Property.md)
 - [InlineResponse2003PropertyAddressList](docs/InlineResponse2003PropertyAddressList.md)
 - [InlineResponse2003PropertyAwardList](docs/InlineResponse2003PropertyAwardList.md)
 - [InlineResponse2003PropertyCancellationGracePeriod](docs/InlineResponse2003PropertyCancellationGracePeriod.md)
 - [InlineResponse2003PropertyCancellationPolicyList](docs/InlineResponse2003PropertyCancellationPolicyList.md)
 - [InlineResponse2003PropertyContactList](docs/InlineResponse2003PropertyContactList.md)
 - [InlineResponse2003PropertyFacilityInfo](docs/InlineResponse2003PropertyFacilityInfo.md)
 - [InlineResponse2003PropertyFacilityInfoAmenityList](docs/InlineResponse2003PropertyFacilityInfoAmenityList.md)
 - [InlineResponse2003PropertyFacilityInfoGuestRoomList](docs/InlineResponse2003PropertyFacilityInfoGuestRoomList.md)
 - [InlineResponse2003PropertyFacilityInfoMediaList](docs/InlineResponse2003PropertyFacilityInfoMediaList.md)
 - [InlineResponse2003PropertyFacilityInfoMessageList](docs/InlineResponse2003PropertyFacilityInfoMessageList.md)
 - [InlineResponse2003PropertyFeePolicyList](docs/InlineResponse2003PropertyFeePolicyList.md)
 - [InlineResponse2003PropertyGuaranteePolicy](docs/InlineResponse2003PropertyGuaranteePolicy.md)
 - [InlineResponse2003PropertyGuestInfo](docs/InlineResponse2003PropertyGuestInfo.md)
 - [InlineResponse2003PropertyMediaList](docs/InlineResponse2003PropertyMediaList.md)
 - [InlineResponse2003PropertyOperationTimeList](docs/InlineResponse2003PropertyOperationTimeList.md)
 - [InlineResponse2003PropertyPetsPolicy](docs/InlineResponse2003PropertyPetsPolicy.md)
 - [InlineResponse2003PropertyPolicyList](docs/InlineResponse2003PropertyPolicyList.md)
 - [InlineResponse2003PropertyPropertyInfo](docs/InlineResponse2003PropertyPropertyInfo.md)
 - [InlineResponse2003PropertyPropertyInfoAcceptedPaymentList](docs/InlineResponse2003PropertyPropertyInfoAcceptedPaymentList.md)
 - [InlineResponse2003PropertyPropertyInfoMessageList](docs/InlineResponse2003PropertyPropertyInfoMessageList.md)
 - [InlineResponse2003PropertyRecordCreated](docs/InlineResponse2003PropertyRecordCreated.md)
 - [InlineResponse2003PropertyRecordModified](docs/InlineResponse2003PropertyRecordModified.md)
 - [InlineResponse2003PropertyServiceList](docs/InlineResponse2003PropertyServiceList.md)
 - [InlineResponse2003PropertyTaxPolicyList](docs/InlineResponse2003PropertyTaxPolicyList.md)
 - [InlineResponse2003RatePlanList](docs/InlineResponse2003RatePlanList.md)
 - [InlineResponse2004](docs/InlineResponse2004.md)
 - [InlineResponse2004AvailabilityList](docs/InlineResponse2004AvailabilityList.md)
 - [InlineResponse2004PricingList](docs/InlineResponse2004PricingList.md)
 - [InlineResponse2004RatePlanList](docs/InlineResponse2004RatePlanList.md)
 - [InlineResponse200List](docs/InlineResponse200List.md)
 - [InlineResponse400](docs/InlineResponse400.md)
 - [InlineResponse4001](docs/InlineResponse4001.md)
 - [InlineResponse4001ValidationErrors](docs/InlineResponse4001ValidationErrors.md)
 - [InlineResponse400ValidationErrors](docs/InlineResponse400ValidationErrors.md)


## Documentation For Authorization


## ApiKeyAuth

- **Type**: API key
- **API key parameter name**: apiKey
- **Location**: HTTP header


## Author

support@lodgea.com


## Notes for Large OpenAPI documents
If the OpenAPI document is large, imports in lodgea-python.apis and lodgea-python.models may fail with a
RecursionError indicating the maximum recursion limit has been exceeded. In that case, there are a couple of solutions:

Solution 1:
Use specific imports for apis and models like:
- `from lodgea-python.api.default_api import DefaultApi`
- `from lodgea-python.model.pet import Pet`

Solution 2:
Before importing the package, adjust the maximum recursion limit as shown below:
```
import sys
sys.setrecursionlimit(1500)
import lodgea-python
from lodgea-python.apis import *
from lodgea-python.models import *
```

