# Generated by Django 2.2.28 on 2023-03-14 12:54

from django.conf import settings
from django.db import migrations, models
import django.db.models.deletion
import djangoldp.fields


class Migration(migrations.Migration):

    initial = True

    dependencies = [
        migrations.swappable_dependency(settings.AUTH_USER_MODEL),
        ('djangoldp_component', '0001_initial'),
    ]

    operations = [
        migrations.CreateModel(
            name='ApplicationTemplate',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('urlid', djangoldp.fields.LDPUrlField(blank=True, null=True, unique=True)),
                ('is_backlink', models.BooleanField(default=False, help_text='set automatically to indicate the Model is a backlink')),
                ('allow_create_backlink', models.BooleanField(default=True, help_text='set to False to disable backlink creation after Model save')),
                ('friendly_name', models.CharField(blank=True, max_length=255, null=True)),
                ('short_description', models.CharField(blank=True, max_length=255, null=True)),
                ('slug', models.SlugField(blank=True, null=True, unique=True)),
                ('creator', models.ForeignKey(blank=True, null=True, on_delete=django.db.models.deletion.SET_NULL, related_name='templates', to=settings.AUTH_USER_MODEL)),
                ('repository', models.CharField(blank=True, max_length=255, null=True)),
            ],
            options={
                'verbose_name': 'template',
                'verbose_name_plural': 'templates',
                'ordering': ['slug'],
                'abstract': False,
                'default_permissions': ['add', 'change', 'delete', 'view', 'control'],
                'lookup_field': 'slug',
                'rdf_type': 'sib:template',
                'rdf_context': {'creator': 'foaf:user', 'friendly_name': 'sib:friendlyName', 'short_description': 'sib:shortDescription'},
                'auto_author': 'creator',
                'owner_field': 'creator',
                'container_path': '/templates/',
                'serializer_fields': ['@id', 'friendly_name', 'short_description', 'creator', 'components', 'packages'],
                'nested_fields': ['components', 'packages'],
                'depth': 1,
                'anonymous_perms': ['view'],
                'authenticated_perms': ['inherit', 'add'],
                'owner_perms': ['inherit', 'change', 'delete'],
                'superuser_perms': ['view'],
            },
        ),
        migrations.CreateModel(
            name='Application',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('urlid', djangoldp.fields.LDPUrlField(blank=True, null=True, unique=True)),
                ('is_backlink', models.BooleanField(default=False, help_text='set automatically to indicate the Model is a backlink')),
                ('allow_create_backlink', models.BooleanField(default=True, help_text='set to False to disable backlink creation after Model save')),
                ('friendly_name', models.CharField(blank=True, max_length=255, null=True)),
                ('short_description', models.CharField(blank=True, max_length=255, null=True)),
                ('slug', models.SlugField(blank=True, null=True, unique=True)),
                ('creator', models.ForeignKey(blank=True, null=True, on_delete=django.db.models.deletion.SET_NULL, related_name='applications', to=settings.AUTH_USER_MODEL)),
                ('application_logo', models.CharField(blank=True, max_length=255, null=True)),
                ('application_title', models.CharField(blank=True, max_length=255, null=True)),
                ('client_url', models.CharField(blank=True, max_length=255, null=True)),
                ('template', models.ForeignKey(blank=True, null=True, on_delete=django.db.models.deletion.CASCADE, related_name='applications', to='djangoldp_application.ApplicationTemplate')),
            ],
            options={
                'verbose_name': 'application',
                'verbose_name_plural': 'applications',
                'ordering': ['slug'],
                'abstract': False,
                'default_permissions': ['add', 'change', 'delete', 'view', 'control'],
                'lookup_field': 'slug',
                'rdf_type': 'sib:application',
                'rdf_context': {'creator': 'foaf:user', 'friendly_name': 'sib:friendlyName', 'short_description': 'sib:shortDescription'},
                'auto_author': 'creator',
                'owner_field': 'creator',
                'container_path': '/applications/',
                'serializer_fields': ['@id', 'friendly_name', 'short_description', 'creator'],
                'depth': 1,
                'anonymous_perms': ['view'],
                'authenticated_perms': ['inherit', 'add'],
                'owner_perms': ['inherit', 'change', 'delete'],
                'superuser_perms': ['view'],
            },
        ),
        migrations.CreateModel(
            name='TemplateRequiredPackage',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('urlid', djangoldp.fields.LDPUrlField(blank=True, null=True, unique=True)),
                ('is_backlink', models.BooleanField(default=False, help_text='set automatically to indicate the Model is a backlink')),
                ('allow_create_backlink', models.BooleanField(default=True, help_text='set to False to disable backlink creation after Model save')),
                ('package', models.ForeignKey(blank=True, null=True, on_delete=django.db.models.deletion.CASCADE, related_name='templates', to='djangoldp_component.Package')),
                ('template', models.ForeignKey(blank=True, null=True, on_delete=django.db.models.deletion.CASCADE, related_name='packages', to='djangoldp_application.ApplicationTemplate')),
            ],
            options={
                'verbose_name': 'template required package',
                'verbose_name_plural': 'template required packages',
                'abstract': False,
                'default_permissions': ['add', 'change', 'delete', 'view', 'control'],
                'rdf_type': 'sib:dependency',
                'rdf_context': {'package': 'sib:package', 'template': 'sib:template'},
                'owner_field': 'template__creator',
                'container_path': 'template-required-packages/',
                'serializer_fields': ['@id', 'package'],
                'nested_fields': ['package'],
                'depth': 0,
                'anonymous_perms': ['view'],
                'authenticated_perms': ['inherit'],
                'owner_perms': ['inherit', 'change', 'delete'],
                'superuser_perms': ['inherit'],
            },
        ),
        migrations.CreateModel(
            name='TemplateRequiredComponent',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('urlid', djangoldp.fields.LDPUrlField(blank=True, null=True, unique=True)),
                ('is_backlink', models.BooleanField(default=False, help_text='set automatically to indicate the Model is a backlink')),
                ('allow_create_backlink', models.BooleanField(default=True, help_text='set to False to disable backlink creation after Model save')),
                ('component', models.ForeignKey(blank=True, null=True, on_delete=django.db.models.deletion.CASCADE, related_name='templates', to='djangoldp_component.Component')),
                ('template', models.ForeignKey(blank=True, null=True, on_delete=django.db.models.deletion.CASCADE, related_name='components', to='djangoldp_application.ApplicationTemplate')),
            ],
            options={
                'verbose_name': 'template required component',
                'verbose_name_plural': 'template required components',
                'abstract': False,
                'default_permissions': ['add', 'change', 'delete', 'view', 'control'],
                'rdf_type': 'sib:dependency',
                'rdf_context': {'component': 'sib:component', 'template': 'sib:template'},
                'owner_field': 'template__creator',
                'container_path': 'template-required-components/',
                'serializer_fields': ['@id', 'component'],
                'nested_fields': ['component'],
                'depth': 0,
                'anonymous_perms': ['view'],
                'authenticated_perms': ['inherit'],
                'owner_perms': ['inherit', 'change', 'delete'],
                'superuser_perms': ['inherit'],
            },
        ),
        migrations.CreateModel(
            name='Federation',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('urlid', djangoldp.fields.LDPUrlField(blank=True, null=True, unique=True)),
                ('is_backlink', models.BooleanField(default=False, help_text='set automatically to indicate the Model is a backlink')),
                ('allow_create_backlink', models.BooleanField(default=True, help_text='set to False to disable backlink creation after Model save')),
                ('application', models.ForeignKey(blank=True, null=True, on_delete=django.db.models.deletion.CASCADE, related_name='federation', to='djangoldp_application.Application')),
                ('target', models.ForeignKey(blank=True, null=True, on_delete=django.db.models.deletion.CASCADE, related_name='targeted_federation', to='djangoldp_application.Application')),
            ],
            options={
                'verbose_name': 'federation',
                'verbose_name_plural': 'federations',
                'ordering': ['application__urlid', 'target__urlid'],
                'abstract': False,
                'default_permissions': ['add', 'change', 'delete', 'view', 'control'],
                'rdf_type': 'sib:federation',
                'rdf_context': {'application': 'sib:application', 'target': 'sib:application'},
                'owner_field': 'application__creator',
                'container_path': '/federations/',
                'serializer_fields': ['@id', 'target'],
                'depth': 0,
                'anonymous_perms': ['view'],
                'authenticated_perms': ['inherit', 'add'],
                'owner_perms': ['inherit', 'change', 'delete'],
                'superuser_perms': ['view'],
            },
        ),
        migrations.CreateModel(
            name='ApplicationComponent',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('urlid', djangoldp.fields.LDPUrlField(blank=True, null=True, unique=True)),
                ('is_backlink', models.BooleanField(default=False, help_text='set automatically to indicate the Model is a backlink')),
                ('allow_create_backlink', models.BooleanField(default=True, help_text='set to False to disable backlink creation after Model save')),
                ('application', models.ForeignKey(blank=True, null=True, on_delete=django.db.models.deletion.CASCADE, related_name='components', to='djangoldp_application.Application')),
                ('component', models.ForeignKey(blank=True, null=True, on_delete=django.db.models.deletion.CASCADE, related_name='applications', to='djangoldp_component.Component')),
            ],
            options={
                'verbose_name': 'application component',
                'verbose_name_plural': 'application components',
                'abstract': False,
                'default_permissions': ['add', 'change', 'delete', 'view', 'control'],
                'rdf_type': 'sib:dependency',
                'rdf_context': {'application': 'sib:application', 'component': 'sib:component'},
                'owner_field': 'application__creator',
                'container_path': 'application-components/',
                'serializer_fields': ['@id', 'component'],
                'nested_fields': ['component'],
                'depth': 0,
                'anonymous_perms': ['view'],
                'authenticated_perms': ['inherit'],
                'owner_perms': ['inherit', 'change', 'delete'],
                'superuser_perms': ['inherit'],
            },
        ),
        migrations.CreateModel(
            name='ApplicationPackage',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('urlid', djangoldp.fields.LDPUrlField(blank=True, null=True, unique=True)),
                ('is_backlink', models.BooleanField(default=False, help_text='set automatically to indicate the Model is a backlink')),
                ('allow_create_backlink', models.BooleanField(default=True, help_text='set to False to disable backlink creation after Model save')),
                ('application', models.ForeignKey(blank=True, null=True, on_delete=django.db.models.deletion.CASCADE, related_name='packages', to='djangoldp_application.Application')),
                ('package', models.ForeignKey(blank=True, null=True, on_delete=django.db.models.deletion.CASCADE, related_name='applications', to='djangoldp_component.Package')),
            ],
            options={
                'verbose_name': 'application package',
                'verbose_name_plural': 'application packages',
                'abstract': False,
                'default_permissions': ['add', 'change', 'delete', 'view', 'control'],
                'rdf_type': 'sib:dependency',
                'rdf_context': {'application': 'sib:application', 'package': 'sib:package'},
                'owner_field': 'application__creator',
                'container_path': 'application-packages/',
                'serializer_fields': ['@id', 'package', 'parameters'],
                'nested_fields': ['package', 'parameters'],
                'depth': 0,
                'anonymous_perms': ['view'],
                'authenticated_perms': ['inherit'],
                'owner_perms': ['inherit', 'change', 'delete'],
                'superuser_perms': ['inherit'],
            },
        ),
        migrations.CreateModel(
            name='ApplicationPackageParameter',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('urlid', djangoldp.fields.LDPUrlField(blank=True, null=True, unique=True)),
                ('is_backlink', models.BooleanField(default=False, help_text='set automatically to indicate the Model is a backlink')),
                ('allow_create_backlink', models.BooleanField(default=True, help_text='set to False to disable backlink creation after Model save')),
                ('key', models.CharField(blank=True, max_length=255, null=True)),
                ('value', models.CharField(blank=True, max_length=255, null=True)),
                ('package', models.ForeignKey(blank=True, null=True, on_delete=django.db.models.deletion.CASCADE, related_name='parameters', to='djangoldp_application.ApplicationPackage')),
            ],
            options={
                'verbose_name': 'package parameter',
                'verbose_name_plural': 'package parameters',
                'abstract': False,
                'default_permissions': ['add', 'change', 'delete', 'view', 'control'],
                'rdf_type': 'sib:parameter',
                'rdf_context': {'key': 'sib:key', 'package': 'sib:dependency', 'value': 'sib:value'},
                'owner_field': 'package__application__creator',
                'container_path': 'application-package-parameters/',
                'serializer_fields': ['@id', 'key', 'value'],
                'depth': 0,
                'anonymous_perms': ['view'],
                'authenticated_perms': ['inherit'],
                'owner_perms': ['inherit', 'change', 'delete'],
                'superuser_perms': ['inherit'],
            },
        ),
        migrations.CreateModel(
            name='ApplicationComponentParameter',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('urlid', djangoldp.fields.LDPUrlField(blank=True, null=True, unique=True)),
                ('is_backlink', models.BooleanField(default=False, help_text='set automatically to indicate the Model is a backlink')),
                ('allow_create_backlink', models.BooleanField(default=True, help_text='set to False to disable backlink creation after Model save')),
                ('key', models.CharField(blank=True, max_length=255, null=True)),
                ('value', models.CharField(blank=True, max_length=255, null=True)),
                ('component', models.ForeignKey(blank=True, null=True, on_delete=django.db.models.deletion.CASCADE, related_name='parameters', to='djangoldp_application.ApplicationComponent')),
            ],
            options={
                'verbose_name': 'component parameter',
                'verbose_name_plural': 'component parameters',
                'abstract': False,
                'default_permissions': ['add', 'change', 'delete', 'view', 'control'],
                'rdf_type': 'sib:parameter',
                'rdf_context': {'component': 'sib:dependency', 'key': 'sib:key', 'value': 'sib:value'},
                'owner_field': 'component__application__creator',
                'container_path': 'application-component-parameters/',
                'serializer_fields': ['@id', 'key', 'value'],
                'depth': 0,
                'anonymous_perms': ['view'],
                'authenticated_perms': ['inherit'],
                'owner_perms': ['inherit', 'change', 'delete'],
                'superuser_perms': ['inherit'],
            },
        ),
    ]
