import numpy as np

# TR48 data

TR48_A = np.array( 
    [[100000,   273,  1272,   744,  1138,  1972,  1580,  1878,  1539,  1457,
        429,  1129,  1251,  1421,   588,   334,   837,  1364,   229,   961,
        754,  1169,  1488,   720,  1280,   816,   664,  1178,   939,  1698,
        983,  1119,  1029,  1815,   721,  1753,   330,  1499,  1107,  1576,
        942,   484,   617,   896,  1184,  1030,  1718,   604],
    [   273,100000,   999,   809,   866,  1722,  1338,  1640,  1266,  1185,
        440,   894,   992,  1173,   334,   358,   626,  1124,   358,   847,
        533,   915,  1219,   481,  1009,   543,   937,   915,   667,  1441,
        812,   848,   776,  1560,   526,  1494,   598,  1244,  1304,  1306,
        685,   668,   444,  1157,  1359,  1176,  1475,   335],
    [  1272,   999,100000,  1519,   140,   937,   697,   951,   267,   227,
        1229,   587,   369,   554,   721,  1212,   739,   596,  1291,  1114,
        701,   426,   285,   676,   155,   456,  1936,   319,   337,   604,
        907,   214,   424,   748,   817,   666,  1592,   521,  2172,   356,
        467,  1583,   882,  2139,  2182,  1961,   781,   678],
    [   744,   809,  1519,100000,  1425,  1861,  1473,  1713,  1761,  1617,
        370,  1073,  1304,  1369,  1092,   453,   798,  1283,   973,   565,
        1315,  1204,  1796,   846,  1447,  1143,   959,  1275,  1213,  2085,
        742,  1309,  1479,  1760,   703,  1727,   872,  1479,   686,  1698,
        1057,   387,  1252,   904,   668,   443,  1600,   930],
    [  1138,   866,   140,  1425,100000,  1052,   776,  1049,   402,   361,
        1119,   578,   406,   618,   581,  1095,   670,   641,  1152,  1060,
        567,   433,   374,   579,   235,   325,  1802,   331,   217,   665,
        862,   182,   312,   864,   732,   783,  1456,   608,  2066,   491,
        400,  1466,   744,  2013,  2082,  1865,   875,   552],
    [  1972,  1722,   937,  1861,  1052,100000,   400,   182,   820,   721,
        1735,   851,   740,   551,  1551,  1769,  1159,   613,  2072,  1300,
        1605,   807,  1017,  1251,   818,  1259,  2596,   826,  1137,  1255,
        1123,   943,  1359,   188,  1282,   271,  2300,   483,  2540,   609,
        1038,  2099,  1766,  2699,  2493,  2266,   264,  1398],
    [  1580,  1338,   697,  1473,   776,   400,100000,   304,   699,   538,
        1335,   454,   393,   173,  1198,  1370,   760,   216,  1692,   919,
        1286,   435,   879,   861,   548,   913,  2198,   483,   803,  1181,
        731,   627,  1086,   292,   883,   279,  1906,   178,  2156,   490,
        662,  1699,  1430,  2300,  2117,  1888,   138,  1023],
    [  1878,  1640,   951,  1713,  1049,   182,   304,100000,   884,   755,
        1612,   749,   690,   476,  1501,  1654,  1049,   516,  1995,  1149,
        1580,   739,  1079,  1161,   815,  1214,  2485,   780,  1100,  1347,
        985,   916,  1361,   260,  1171,   328,  2202,   445,  2385,   665,
        966,  1969,  1729,  2568,  2333,  2108,   177,  1327],
    [  1539,  1266,   267,  1761,   402,   820,   699,   884,100000,   177,
        1486,   757,   506,   609,   981,  1474,   967,   681,  1552,  1317,
        936,   594,   197,   928,   316,   723,  2203,   500,   604,   482,
        1104,   455,   630,   641,  1058,   562,  1857,   528,  2425,   220,
        704,  1845,  1122,  2405,  2428,  2204,   738,   945],
    [  1457,  1185,   227,  1617,   361,   721,   538,   755,   177,100000,
        1362,   587,   335,   435,   930,  1358,   819,   504,  1496,  1153,
        927,   428,   341,   803,   180,   649,  2119,   343,   521,   652,
        939,   340,   649,   533,   918,   451,  1783,   362,  2290,   130,
        568,  1727,  1105,  2301,  2285,  2059,   595,   853],
    [   429,   440,  1229,   370,  1119,  1735,  1335,  1612,  1486,  1362,
    100000,   891,  1082,  1199,   726,    96,   583,  1125,   653,   563,
        947,   986,  1493,   560,  1183,   813,   882,  1033,   902,  1763,
        642,  1032,  1131,  1604,   463,  1556,   663,  1298,   947,  1461,
        795,   371,   882,   967,   973,   768,  1472,   588],
    [  1129,   894,   587,  1073,   578,   851,   454,   749,   757,   587,
        891,100000,   252,   308,   803,   920,   309,   238,  1252,   569,
        940,   165,   863,   414,   454,   552,  1745,   269,   482,  1188,
        355,   397,   833,   713,   432,   666,  1453,   410,  1758,   642,
        262,  1260,  1051,  1858,  1737,  1508,   592,   598],
    [  1251,   992,   369,  1304,   406,   740,   393,   690,   506,   335,
        1082,   252,100000,   222,   814,  1094,   510,   235,  1335,   820,
        892,   100,   626,   541,   219,   524,  1897,    90,   410,   952,
        605,   238,   706,   570,   622,   503,  1581,   257,  1985,   396,
        309,  1453,  1039,  2043,  1972,  1744,   514,   661],
    [  1421,  1173,   554,  1369,   618,   551,   173,   476,   609,   435,
        1199,   308,   222,100000,  1025,  1227,   617,    90,  1525,   835,
        1114,   263,   770,   700,   400,   740,  2049,   311,   630,  1087,
        630,   459,   924,   405,   739,   360,  1749,   115,  2055,   428,
        492,  1568,  1256,  2166,  2026,  1796,   303,   853],
    [   588,   334,   721,  1092,   581,  1551,  1198,  1501,   981,   930,
        726,   803,   814,  1025,100000,   663,   632,   999,   572,   972,
        225,   763,   908,   451,   767,   293,  1240,   726,   420,  1111,
        862,   617,   443,  1374,   586,  1299,   887,  1070,  1633,  1057,
        547,   999,   252,  1483,  1681,  1489,  1326,   236],
    [   334,   358,  1212,   453,  1095,  1769,  1370,  1654,  1474,  1358,
        96,   920,  1094,  1227,   663,100000,   610,  1156,   557,   642,
        879,  1000,  1467,   558,  1178,   780,   831,  1038,   879,  1726,
        700,  1023,  1082,  1631,   488,  1579,   586,  1320,   982,  1463,
        796,   371,   802,   949,  1021,   826,  1508,   550],
    [   837,   626,   739,   798,   670,  1159,   760,  1049,   967,   819,
        583,   309,   510,   617,   632,   610,100000,   546,   983,   397,
        821,   411,  1023,   180,   651,   478,  1438,   476,   485,  1333,
        235,   525,   827,  1022,   123,   973,  1155,   715,  1475,   902,
        273,   953,   882,  1550,  1467,  1240,   898,   396],
    [  1364,  1124,   596,  1283,   641,   613,   216,   516,   681,   504,
        1125,   238,   235,    90,   999,  1156,   546,100000,  1479,   745,
        1105,   240,   831,   645,   442,   723,  1983,   316,   623,  1152,
        543,   470,   939,   482,   669,   443,  1690,   205,  1969,   510,
        455,  1492,  1238,  2091,  1938,  1709,   354,   813],
    [   229,   358,  1291,   973,  1152,  2072,  1692,  1995,  1552,  1496,
        653,  1252,  1335,  1525,   572,   557,   983,  1479,100000,  1163,
        676,  1264,  1473,   839,  1326,   847,   801,  1254,   976,  1643,
        1157,  1169,   983,  1905,   878,  1836,   346,  1590,  1286,  1621,
        1034,   689,   503,   995,  1376,  1239,  1828,   674],
    [   961,   847,  1114,   565,  1060,  1300,   919,  1149,  1317,  1153,
        563,   569,   820,   835,   972,   642,   397,   745,  1163,100000,
        1183,   725,  1399,   549,  1004,   869,  1427,   818,   882,  1716,
        214,   902,  1222,  1210,   390,  1184,  1225,   949,  1239,  1210,
        660,   863,  1207,  1446,  1197,   969,  1042,   741],
    [   754,   533,   701,  1315,   567,  1605,  1286,  1580,   936,   927,
        947,   940,   892,  1114,   225,   879,   821,  1105,   676,  1183,
    100000,   865,   821,   644,   790,   388,  1374,   803,   484,   968,
        1056,   665,   318,  1420,   794,  1341,  1017,  1137,  1836,  1056,
        679,  1200,   189,  1645,  1891,  1704,  1403,   442],
    [  1169,   915,   426,  1204,   433,   807,   435,   739,   594,   428,
        986,   165,   100,   263,   763,  1000,   411,   240,  1264,   725,
        865,100000,   699,   453,   290,   483,  1809,   107,   384,  1024,
        511,   251,   712,   646,   525,   585,  1499,   330,  1885,   495,
        231,  1356,   999,  1949,  1872,  1644,   567,   591],
    [  1488,  1219,   285,  1796,   374,  1017,   879,  1079,   197,   341,
        1493,   863,   626,   770,   908,  1467,  1023,   831,  1473,  1399,
        821,   699,100000,   950,   410,   690,  2147,   594,   590,   326,
        1191,   499,   504,   838,  1098,   758,  1794,   703,  2439,   414,
        751,  1837,  1011,  2374,  2455,  2237,   928,   921],
    [   720,   481,   676,   846,   579,  1251,   861,  1161,   928,   803,
        560,   414,   541,   700,   451,   558,   180,   645,   839,   549,
        644,   453,   950,100000,   624,   325,  1356,   480,   369,  1241,
        413,   473,   680,  1097,   166,  1038,  1049,   781,  1497,   905,
        238,   925,   702,  1506,  1506,  1287,   998,   216],
    [  1280,  1009,   155,  1447,   235,   818,   548,   815,   316,   180,
        1183,   454,   219,   400,   767,  1178,   651,   442,  1326,  1004,
        790,   290,   410,   624,100000,   479,  1941,   188,   350,   736,
        792,   161,   547,   632,   745,   552,  1607,   375,  2115,   296,
        392,  1547,   959,  2121,  2114,  1890,   641,   676],
    [   816,   543,   456,  1143,   325,  1259,   913,  1214,   723,   649,
        813,   552,   524,   740,   293,   780,   478,   723,   847,   869,
        388,   483,   690,   325,   479,100000,  1480,   435,   129,   949,
        708,   325,   355,  1081,   492,  1007,  1137,   779,  1759,   774,
        291,  1148,   516,  1688,  1785,  1573,  1038,   231],
    [   664,   937,  1936,   959,  1802,  2596,  2198,  2485,  2203,  2119,
        882,  1745,  1897,  2049,  1240,   831,  1438,  1983,   801,  1427,
        1374,  1809,  2147,  1356,  1941,  1480,100000,  1829,  1603,  2339,
        1524,  1780,  1673,  2421,  1315,  2394,   357,  2136,   825,  2237,
        1589,   579,  1204,   347,   959,   940,  2336,  1266],
    [  1178,   915,   319,  1275,   331,   826,   483,   780,   500,   343,
        1033,   269,    90,   311,   726,  1038,   476,   316,  1254,   818,
        803,   107,   594,   480,   188,   435,  1829,100000,   320,   919,
        605,   154,   623,   652,   580,   582,  1508,   344,  1950,   429,
        242,  1402,   949,  1986,  1943,  1717,   603,   582],
    [   939,   667,   337,  1213,   217,  1137,   803,  1100,   604,   521,
        902,   482,   410,   630,   420,   879,   485,   623,   976,   882,
        484,   384,   590,   369,   350,   129,  1603,   320,100000,   872,
        699,   197,   358,   957,   529,   881,  1263,   660,  1849,   645,
        240,  1250,   631,  1802,  1867,  1650,   923,   341],
    [  1698,  1441,   604,  2085,   665,  1255,  1181,  1347,   482,   652,
        1763,  1188,   952,  1087,  1111,  1726,  1333,  1152,  1643,  1716,
        968,  1024,   326,  1241,   736,   949,  2339,   919,   872,100000,
        1511,   815,   669,  1092,  1397,  1019,  1982,  1010,  2708,   695,
        1061,  2089,  1148,  2594,  2734,  2520,  1212,  1176],
    [   983,   812,   907,   742,   862,  1123,   731,   985,  1104,   939,
        642,   355,   605,   630,   862,   700,   235,   543,  1157,   214,
        1056,   511,  1191,   413,   792,   708,  1524,   605,   699,  1511,
    100000,   697,  1051,  1018,   290,   985,  1280,   743,  1427,   996,
        466,   987,  1110,  1584,  1395,  1166,   861,   626],
    [  1119,   848,   214,  1309,   182,   943,   627,   916,   455,   340,
        1032,   397,   238,   459,   617,  1023,   525,   470,  1169,   902,
        665,   251,   499,   473,   161,   325,  1780,   154,   197,   815,
        697,100000,   469,   761,   607,   685,  1446,   472,  1969,   457,
        254,  1393,   823,  1963,  1975,  1752,   739,   515],
    [  1029,   776,   424,  1479,   312,  1359,  1086,  1361,   630,   649,
        1131,   833,   706,   924,   443,  1082,   827,   939,   983,  1222,
        318,   712,   504,   680,   547,   355,  1673,   623,   358,   669,
        1051,   469,100000,  1171,   847,  1089,  1316,   919,  2063,   776,
        598,  1434,   507,  1926,  2101,  1898,  1187,   548],
    [  1815,  1560,   748,  1760,   864,   188,   292,   260,   641,   533,
        1604,   713,   570,   405,  1374,  1631,  1022,   482,  1905,  1210,
        1420,   646,   838,  1097,   632,  1081,  2421,   652,   957,  1092,
        1018,   761,  1171,100000,  1144,    83,  2145,   317,  2445,   426,
        875,  1972,  1584,  2571,  2408,  2179,   194,  1231],
    [   721,   526,   817,   703,   732,  1282,   883,  1171,  1058,   918,
        463,   432,   622,   739,   586,   488,   123,   669,   878,   390,
        794,   525,  1098,   166,   745,   492,  1315,   580,   529,  1397,
        290,   607,   847,  1144,100000,  1094,  1036,   836,  1371,  1008,
        354,   833,   828,  1429,  1369,  1146,  1021,   352],
    [  1753,  1494,   666,  1727,   783,   271,   279,   328,   562,   451,
        1556,   666,   503,   360,  1299,  1579,   973,   443,  1836,  1184,
        1341,   585,   758,  1038,   552,  1007,  2394,   582,   881,  1019,
        985,   685,  1089,    83,  1094,100000,  2083,   259,  2412,   345,
        811,  1925,  1507,  2523,  2380,  2151,   220,  1163],
    [   330,   598,  1592,   872,  1456,  2300,  1906,  2202,  1857,  1783,
        663,  1453,  1581,  1749,   887,   586,  1155,  1690,   346,  1225,
        1017,  1499,  1794,  1049,  1607,  1137,   357,  1508,  1263,  1982,
        1280,  1446,  1316,  2145,  1036,  2083,100000,  1628,  1005,  1903,
        1272,   504,   849,   653,  1114,  1019,  2044,   932],
    [  1499,  1244,   521,  1479,   608,   483,   178,   445,   528,   362,
        1298,   410,   257,   115,  1070,  1320,   715,   205,  1590,   949,
        1137,   330,   703,   781,   375,   779,  2136,   344,   660,  1010,
        743,   472,   919,   317,   836,   259,  1628,100000,  2165,   330,
        559,  1668,  1291,  2264,  2138,  1908,   268,   917],
    [  1107,  1304,  2172,   686,  2066,  2540,  2156,  2385,  2425,  2290,
        947,  1758,  1985,  2055,  1633,   982,  1475,  1969,  1286,  1239,
        1836,  1885,  2439,  1497,  2115,  1759,   825,  1950,  1849,  2708,
        1427,  1969,  2063,  2445,  1371,  2412,  1005,  2165,100000,  2377,
        1723,   636,  1720,   534,   145,   290,  2281,  1531],
    [  1576,  1306,   356,  1698,   491,   609,   490,   665,   220,   130,
        1461,   642,   396,   428,  1057,  1463,   902,   510,  1621,  1210,
        1056,   495,   414,   905,   296,   774,  2237,   429,   645,   695,
        996,   457,   776,   426,  1008,   345,  1903,   330,  2377,100000,
        667,  1829,  1235,  2410,  2367,  2139,   519,   972],
    [   942,   685,   467,  1057,   400,  1038,   662,   966,   704,   568,
        795,   262,   309,   492,   547,   796,   273,   455,  1034,   660,
        679,   231,   751,   238,   392,   291,  1589,   242,   240,  1061,
        466,   254,   598,   875,   354,   811,  1272,   559,  1723,   667,
    100000,  1162,   792,  1744,  1724,  1500,   796,   361],
    [   484,   668,  1583,   387,  1466,  2099,  1699,  1969,  1845,  1727,
        371,  1260,  1453,  1568,   999,   371,   953,  1492,   689,   863,
        1200,  1356,  1837,   925,  1547,  1148,   579,  1402,  1250,  2089,
        987,  1393,  1434,  1972,   833,  1925,   504,  1668,   636,  1829,
        1162,100000,  1087,   600,   701,   550,  1835,   917],
    [   617,   444,   882,  1252,   744,  1766,  1430,  1729,  1122,  1105,
        882,  1051,  1039,  1256,   252,   802,   882,  1238,   503,  1207,
        189,   999,  1011,   702,   959,   516,  1204,   949,   631,  1148,
        1110,   823,   507,  1584,   828,  1507,   849,  1291,  1720,  1235,
        792,  1087,100000,  1490,  1787,  1614,  1553,   486],
    [   896,  1157,  2139,   904,  2013,  2699,  2300,  2568,  2405,  2301,
        967,  1858,  2043,  2166,  1483,   949,  1550,  2091,   995,  1446,
        1645,  1949,  2374,  1506,  2121,  1688,   347,  1986,  1802,  2594,
        1584,  1963,  1926,  2571,  1429,  2523,   653,  2264,   534,  2410,
        1744,   600,  1490,100000,   678,   727,  2435,  1461],
    [  1184,  1359,  2182,   668,  2082,  2493,  2117,  2333,  2428,  2285,
        973,  1737,  1972,  2026,  1681,  1021,  1467,  1938,  1376,  1197,
        1891,  1872,  2455,  1506,  2114,  1785,   959,  1943,  1867,  2734,
        1395,  1975,  2101,  2408,  1369,  2380,  1114,  2138,   145,  2367,
        1724,   701,  1787,   678,100000,   229,  2238,  1560],
    [  1030,  1176,  1961,   443,  1865,  2266,  1888,  2108,  2204,  2059,
        768,  1508,  1744,  1796,  1489,   826,  1240,  1709,  1239,   969,
        1704,  1644,  2237,  1287,  1890,  1573,   940,  1717,  1650,  2520,
        1166,  1752,  1898,  2179,  1146,  2151,  1019,  1908,   290,  2139,
        1500,   550,  1614,   727,   229,100000,  2010,  1353],
    [  1718,  1475,   781,  1600,   875,   264,   138,   177,   738,   595,
        1472,   592,   514,   303,  1326,  1508,   898,   354,  1828,  1042,
        1403,   567,   928,   998,   641,  1038,  2336,   603,   923,  1212,
        861,   739,  1187,   194,  1021,   220,  2044,   268,  2281,   519,
        796,  1835,  1553,  2435,  2238,  2010,100000,  1157],
    [   604,   335,   678,   930,   552,  1398,  1023,  1327,   945,   853,
        588,   598,   661,   853,   236,   550,   396,   813,   674,   741,
        442,   591,   921,   216,   676,   231,  1266,   582,   341,  1176,
        626,   515,   548,  1231,   352,  1163,   932,   917,  1531,   972,
        361,   917,   486,  1461,  1560,  1353,  1157,100000]], dtype = float
    )
TR48_D = np.array(
    [61,67,24,84,13,86,89,46,48,50,74,75,88,40,29,45,32,21,61,21,51,14,89,79,
    38,20,97,19,10,73,59,92,52,66,89,65,63,47, 7,61,87,19,36,43, 9,12, 8,67], dtype=float
)
TR48_S = np.array(
    [22,53,64,15,66,37,16,23,67,18,52,69,17,29,50,13,95,34,59,36,22,94,28,34,
     36,38,55,77,45,34,32,58,30,88,74,59,93,54,89,30,79,46,35,41,99,52,76,93], dtype=float
)
TR48_OP = np.array(
    [ 144, 257,   0, 483,  89,-165, -72,-252, -88,-178, 311, 126,   7,-135,
    158, 209, 101, -92, 229,  80,  95,  71,-244, 102, -12, 132, 337,  61,
    104,  41, 261, 118,  99,-246, 156,-270, 330,-130, 952, -62, 161, 484,
    122, 474,1086, 861,-170, 206], dtype=float
)

A48_OP = np.array(
            [-38., 42., -3., 12.,-62., 22.,-17.,  0., 15.,-75.,-12., 11.,-55.,-73.,
        7.,-12.,-20., 17.,-20.,  0.,-56.,-45.,-57.,-13.,-47.,-19.,-10.,-54.,
        -16.,150.,  0.,  3.,169.,  0.,-32.,  0., 79., 42.,-14.,-32., 46., 32.,
        40., 71.,-75., 70.,  8., 24.]
        )

# MaxQuad data
mqA = np.array( 
    [[[ 6.28401714, 6.7905379 , 1.05386943, 5.65172173, 7.161146  ],
    [-0.57734178,-0.62387819,-0.09682387, 0.51924987, 0.65792767],
    [-1.16261488,-1.256327  ,-0.19497787, 1.04563301, 1.32489372],
    [-0.70624241,-0.7631688 ,-0.11844132, 0.63518057, 0.80482037],
    [ 0.2915409 , 0.31504044, 0.04889325,-0.26220616,-0.33223444],
    [ 0.95448657, 1.03142259, 0.16007344,-0.85844649,-1.08771468],
    [ 0.73180649, 0.79079347, 0.12272858,-0.6581724 ,-0.83395271],
    [-0.13873596,-0.14991872,-0.0232669 , 0.1247764 , 0.15810085],
    [-0.85679034,-0.92585159,-0.14368916, 0.77058042, 0.97638191],
    [-0.78031073,-0.84320737,-0.13086305, 0.70179616, 0.88922722]],

    [[-0.57734178,-0.62387819,-0.09682387, 0.51924987, 0.65792767],
    [ 6.86664013, 7.42012299, 1.15157899, 6.17572142, 7.82509204],
    [ 1.57368231, 1.70052836, 0.26391648,-1.41533899,-1.79333832],
    [-0.20185963,-0.21813045,-0.03385314, 0.18154859, 0.23003539],
    [-1.05330931,-1.1382109 ,-0.17664664, 0.94732573, 1.20033119],
    [ 0.99099455, 1.07087328, 0.16619606,-0.89128105,-1.12931847],
    [ 0.15311228, 0.16545384, 0.0256779 ,-0.13770618,-0.17448383],
    [-1.03472247,-1.11812587,-0.1735295 , 0.93060909, 1.17914997],
    [ 0.69390708, 0.74983919, 0.11637261,-0.62408641,-0.79076326],
    [ 0.41941653, 0.45322344, 0.07033881,-0.377215  ,-0.47795908]],

    [[-1.16261488,-1.256327  ,-0.19497787, 1.04563301, 1.32489372],
    [ 1.57368231, 1.70052836, 0.26391648,-1.41533899,-1.79333832],
    [ 8.31799692, 8.98846583, 1.39498071, 7.48104324, 9.47903054],
    [ 1.50323645, 1.62440424, 0.25210226,-1.35198138,-1.71305957],
    [-1.16479917,-1.25868735,-0.19534419, 1.04759752, 1.3273829 ],
    [ 0.91609112, 0.98993229, 0.15363428,-0.82391438,-1.04395996],
    [-0.7075079 ,-0.7645363 ,-0.11865355, 0.63631873, 0.8062625 ],
    [ 0.51933638, 0.56119729, 0.087096  ,-0.46708095,-0.59182583],
    [-0.34307828,-0.37073197,-0.0575364 , 0.30855788, 0.39096546],
    [ 0.17520913, 0.1893318 , 0.02938368,-0.15757966,-0.19966499]],

    [[-0.70624241,-0.7631688 ,-0.11844132, 0.63518057, 0.80482037],
    [-0.20185963,-0.21813045,-0.03385314, 0.18154859, 0.23003539],
    [ 1.50323645, 1.62440424, 0.25210226,-1.35198138,-1.71305957],
    [ 7.8042423 , 8.43330022, 1.30882081, 7.01898241, 8.89356557],
    [ 0.76422675, 0.82582695, 0.12816566,-0.68733055,-0.87089822],
    [ 0.69521314, 0.75125052, 0.11659164,-0.62526106,-0.79225163],
    [-1.4343526 ,-1.54996803,-0.24055001, 1.29002859, 1.63456085],
    [ 1.15736071, 1.25064932, 0.19409671,-1.04090751,-1.31890617],
    [-0.16793672,-0.1814732 ,-0.02816405, 0.15103899, 0.19137748],
    [-0.83722549,-0.90470972,-0.14040801, 0.75298418, 0.95408619]],

    [[ 0.2915409 , 0.31504044, 0.04889325,-0.26220616,-0.33223444],
    [-1.05330931,-1.1382109 ,-0.17664664, 0.94732573, 1.20033119],
    [-1.16479917,-1.25868735,-0.19534419, 1.04759752, 1.3273829 ],
    [ 0.76422675, 0.82582695, 0.12816566,-0.68733055,-0.87089822],
    [ 8.70429076, 9.40589674, 1.45976463, 7.82846834, 9.91924363],
    [ 0.29866234, 0.32273591, 0.05008756,-0.26861105,-0.34034991],
    [-1.55335252,-1.6785599 ,-0.26050705, 1.39705478, 1.77017088],
    [-1.0484765 ,-1.13298854,-0.17583614, 0.94297919, 1.19482381],
    [ 0.77044109, 0.8325422 , 0.12920785,-0.6929196 ,-0.87797996],
    [ 1.33874669, 1.44665585, 0.22451629,-1.20404251,-1.52561018]],

    [[ 0.95448657, 1.03142259, 0.16007344,-0.85844649,-1.08771468],
    [ 0.99099455, 1.07087328, 0.16619606,-0.89128105,-1.12931847],
    [ 0.91609112, 0.98993229, 0.15363428,-0.82391438,-1.04395996],
    [ 0.69521314, 0.75125052, 0.11659164,-0.62526106,-0.79225163],
    [ 0.29866234, 0.32273591, 0.05008756,-0.26861105,-0.34034991],
    [ 9.11329749, 9.8478713 , 1.52835765, 8.19632098,10.38533989],
    [-0.79311398,-0.85704263,-0.13301023, 0.71331115, 0.90381756],
    [-1.14034934,-1.23226676,-0.1912438 , 1.02560783, 1.29952035],
    [-1.35920704,-1.46876539,-0.22794762, 1.22244414, 1.5489264 ],
    [-1.46029682,-1.57800348,-0.24490102, 1.31336231, 1.66412639]],

    [[ 0.73180649, 0.79079347, 0.12272858,-0.6581724 ,-0.83395271],
    [ 0.15311228, 0.16545384, 0.0256779 ,-0.13770618,-0.17448383],
    [-0.7075079 ,-0.7645363 ,-0.11865355, 0.63631873, 0.8062625 ],
    [-1.4343526 ,-1.54996803,-0.24055001, 1.29002859, 1.63456085],
    [-1.55335252,-1.6785599 ,-0.26050705, 1.39705478, 1.77017088],
    [-0.79311398,-0.85704263,-0.13301023, 0.71331115, 0.90381756],
    [10.56347996,11.41494516, 1.77156242, 9.50058663,12.03794015],
    [ 1.72229642, 1.86112145, 0.28884001,-1.54899961,-1.96269613],
    [ 1.80573952, 1.95129045, 0.30283394,-1.6240467 ,-2.0577863 ],
    [ 1.07316856, 1.15967089, 0.17997716,-0.96518675,-1.22296241]],

    [[-0.13873596,-0.14991872,-0.0232669 , 0.1247764 , 0.15810085],
    [-1.03472247,-1.11812587,-0.1735295 , 0.93060909, 1.17914997],
    [ 0.51933638, 0.56119729, 0.087096  ,-0.46708095,-0.59182583],
    [ 1.15736071, 1.25064932, 0.19409671,-1.04090751,-1.31890617],
    [-1.0484765 ,-1.13298854,-0.17583614, 0.94297919, 1.19482381],
    [-1.14034934,-1.23226676,-0.1912438 , 1.02560783, 1.29952035],
    [ 1.72229642, 1.86112145, 0.28884001,-1.54899961,-1.96269613],
    [ 9.6209633 ,10.39645731, 1.61349642, 8.65290564,10.96386616],
    [-1.97978344,-2.13936312,-0.33202221, 1.78057839, 2.25612342],
    [-0.2067253 ,-0.22338831,-0.03466914, 0.18592467, 0.2355802 ]],

    [[-0.85679034,-0.92585159,-0.14368916, 0.77058042, 0.97638191],
    [ 0.69390708, 0.74983919, 0.11637261,-0.62408641,-0.79076326],
    [-0.34307828,-0.37073197,-0.0575364 , 0.30855788, 0.39096546],
    [-0.16793672,-0.1814732 ,-0.02816405, 0.15103899, 0.19137748],
    [ 0.77044109, 0.8325422 , 0.12920785,-0.6929196 ,-0.87797996],
    [-1.35920704,-1.46876539,-0.22794762, 1.22244414, 1.5489264 ],
    [ 1.80573952, 1.95129045, 0.30283394,-1.6240467 ,-2.0577863 ],
    [-1.97978344,-2.13936312,-0.33202221, 1.78057839, 2.25612342],
    [ 9.66157848,10.44034626, 1.62030784, 8.68943414,11.01015044],
    [-0.92737109,-1.00212147,-0.155526  , 0.83405936, 1.05681439]],

    [[-0.78031073,-0.84320737,-0.13086305, 0.70179616, 0.88922722],
    [ 0.41941653, 0.45322344, 0.07033881,-0.377215  ,-0.47795908],
    [ 0.17520913, 0.1893318 , 0.02938368,-0.15757966,-0.19966499],
    [-0.83722549,-0.90470972,-0.14040801, 0.75298418, 0.95408619],
    [ 1.33874669, 1.44665585, 0.22451629,-1.20404251,-1.52561018],
    [-1.46029682,-1.57800348,-0.24490102, 1.31336231, 1.66412639],
    [ 1.07316856, 1.15967089, 0.17997716,-0.96518675,-1.22296241],
    [-0.2067253 ,-0.22338831,-0.03466914, 0.18592467, 0.2355802 ],
    [-0.92737109,-1.00212147,-0.155526  , 0.83405936, 1.05681439],
    [ 8.05994132, 8.70960976, 1.35170315, 7.2489531 , 9.18495531]]]
  )

mqB = np.array(
    [[ 2.28735529e+00, 1.49917801e+00, 1.96948837e-01,-9.71753639e-01,-1.17123275e+00],
    [ 6.71884970e+00,-2.05720247e+00,-5.44227077e-01, 1.63117599e+00,-8.11584129e-01],
    [ 2.83447113e+00,-1.25225338e+00, 1.12025419e+00,-1.13592488e+00,1.18490170e+00],
    [-4.13200162e+01, 7.31042359e+00,-2.03557945e+00,-7.82602354e-01,2.03179702e+00],
    [-1.42316981e+02,-6.62753390e+00, 3.44294250e+00, 3.18649203e+00,-3.59769357e-01],
    [-1.12724257e+02,-1.07773552e+01,-5.54908690e+00,-4.05852065e+00,-3.28038052e+00],
    [ 7.20473289e+02, 3.28044103e+01, 8.62780922e+00, 1.55895517e+00,-1.73636635e+00],
    [ 2.94923537e+03,-1.57189885e+01,-1.30330078e+01, 4.07452268e+00,3.69056964e+00],
    [ 3.33943067e+03,-6.76017176e+01, 1.92093240e+01,-9.40973577e+00,5.14766635e+00],
    [-1.19828624e+04, 1.35493089e+02,-2.76961319e+01, 9.07733658e+00,-1.93870251e+00]]
)

# Shor data
shA = np.array( [
    [0,0,0,0,0],
    [2,1,1,1,3],
    [1,2,1,1,2],
    [1,4,1,2,2],
    [3,2,1,0,1],
    [0,2,1,0,1],
    [1,1,1,1,1],
    [1,0,1,2,1],
    [0,0,2,1,0],
    [1,1,2,0,0]
])

shB = np.array( [1,5,10,2,4,3,1.7,2.5,6,3.5])
