"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.PDKPipelinePyProject = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
/*! Copyright [Amazon.com](http://amazon.com/), Inc. or its affiliates. All Rights Reserved.
SPDX-License-Identifier: Apache-2.0 */
const fs = require("fs");
const path = require("path");
const projen_1 = require("projen");
const awscdk_1 = require("projen/lib/awscdk");
const python_1 = require("projen/lib/python");
/**
 * Synthesizes a Python Project with a CI/CD pipeline.
 *
 * @pjid pdk-pipeline-py
 */
class PDKPipelinePyProject extends awscdk_1.AwsCdkPythonApp {
    constructor(options) {
        super({
            github: false,
            sample: false,
            pytest: false,
            ...options,
            appEntrypoint: options.appEntrypoint || `${options.moduleName}/pipeline.py`,
        });
        ["aws_prototyping_sdk", "cdk-nag", "pyhumps"].forEach((dep) => this.addDependency(dep));
        this.addDevDependency("pytest");
        new projen_1.SampleDir(this, this.moduleName, {
            sourceDir: path.join(__dirname, "..", "samples", "python", "infra"),
        });
        this.pytest = new python_1.Pytest(this, options.pytestOptions);
        new projen_1.SampleDir(this, this.testdir, {
            files: {
                "__init__.py": "",
                "test_pipeline.py": fs
                    .readFileSync(path.join(__dirname, "..", "samples", "python", "tests", "test_pipeline.py"))
                    .toString()
                    .replace("infra.", `${this.moduleName}.`),
            },
        });
    }
}
exports.PDKPipelinePyProject = PDKPipelinePyProject;
_a = JSII_RTTI_SYMBOL_1;
PDKPipelinePyProject[_a] = { fqn: "aws-prototyping-sdk.pipeline.PDKPipelinePyProject", version: "0.12.37" };
//# sourceMappingURL=data:application/json;base64,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