from tkinter import simpledialog
from tkinter.ttk import Notebook
from ScrollText import *
from tkinter import *
from tkinter import messagebox
import socket, threading,select
import SettingsDialog
from wgplib import *


class TerminalWindow(ScrollText):
    pages:Notebook=None
    getstack:bool=False
    setstackvisible=None
    stack:Text=None
    errorverb:str=""
    arglist={}
    verblist=[]
    namelist={}
    lastobj:str=""
    lvVerbs:ttk.Treeview=None
    dumpobject:str=""

    ColorTable = (
        "#000000",
        "#c00000",
        "#00c000",
        "#c0c000",
        "#0000c0",
        "#c000c0",
        "#00c0c0",
        "#c0c0c0",
    )
    ColorTableBold = (
        "#000000",
        "#ff0000",
        "#00ff00",
        "#ffff00",
        "#0000ff",
        "#ff00ff",
        "#00ffff",
        "#ffffff",
    )
    ColorX256 = (
        "#000000",
        "#800000",
        "#008000",
        "#808000",
        "#000080",
        "#800080",
        "#008080",
        "#c0c0c0",
        "#808080",
        "#ff0000",
        "#00ff00",
        "#ffff00",
        "#0000ff",
        "#ff00ff",
        "#00ffff",
        "#ffffff",
        "#000000",
        "#00005f",
        "#000087",
        "#0000af",
        "#0000d7",
        "#0000ff",
        "#005f00",
        "#005f5f",
        "#005f87",
        "#005faf",
        "#005fd7",
        "#005fff",
        "#008700",
        "#00875f",
        "#008787",
        "#0087af",
        "#0087d7",
        "#0087ff",
        "#00af00",
        "#00af5f",
        "#00af87",
        "#00afaf",
        "#00afd7",
        "#00afff",
        "#00d700",
        "#00d75f",
        "#00d787",
        "#00d7af",
        "#00d7d7",
        "#00d7ff",
        "#00ff00",
        "#00ff5f",
        "#00ff87",
        "#00ffaf",
        "#00ffd7",
        "#00ffff",
        "#5f0000",
        "#5f005f",
        "#5f0087",
        "#5f00af",
        "#5f00d7",
        "#5f00ff",
        "#5f5f00",
        "#5f5f5f",
        "#5f5f87",
        "#5f5faf",
        "#5f5fd7",
        "#5f5fff",
        "#5f8700",
        "#5f875f",
        "#5f8787",
        "#5f87af",
        "#5f87d7",
        "#5f87ff",
        "#5faf00",
        "#5faf5f",
        "#5faf87",
        "#5fafaf",
        "#5fafd7",
        "#5fafff",
        "#5fd700",
        "#5fd75f",
        "#5fd787",
        "#5fd7af",
        "#5fd7d7",
        "#5fd7ff",
        "#5fff00",
        "#5fff5f",
        "#5fff87",
        "#5fffaf",
        "#5fffd7",
        "#5fffff",
        "#870000",
        "#87005f",
        "#870087",
        "#8700af",
        "#8700d7",
        "#8700ff",
        "#875f00",
        "#875f5f",
        "#875f87",
        "#875faf",
        "#875fd7",
        "#875fff",
        "#878700",
        "#87875f",
        "#878787",
        "#8787af",
        "#8787d7",
        "#8787ff",
        "#87af00",
        "#87af5f",
        "#87af87",
        "#87afaf",
        "#87afd7",
        "#87afff",
        "#87d700",
        "#87d75f",
        "#87d787",
        "#87d7af",
        "#87d7d7",
        "#87d7ff",
        "#87ff00",
        "#87ff5f",
        "#87ff87",
        "#87ffaf",
        "#87ffd7",
        "#87ffff",
        "#af0000",
        "#af005f",
        "#af0087",
        "#af00af",
        "#af00d7",
        "#af00ff",
        "#af5f00",
        "#af5f5f",
        "#af5f87",
        "#af5faf",
        "#af5fd7",
        "#af5fff",
        "#af8700",
        "#af875f",
        "#af8787",
        "#af87af",
        "#af87d7",
        "#af87ff",
        "#afaf00",
        "#afaf5f",
        "#afaf87",
        "#afafaf",
        "#afafd7",
        "#afafff",
        "#afd700",
        "#afd75f",
        "#afd787",
        "#afd7af",
        "#afd7d7",
        "#afd7ff",
        "#afff00",
        "#afff5f",
        "#afff87",
        "#afffaf",
        "#afffd7",
        "#afffff",
        "#d70000",
        "#d7005f",
        "#d70087",
        "#d700af",
        "#d700d7",
        "#d700ff",
        "#d75f00",
        "#d75f5f",
        "#d75f87",
        "#d75faf",
        "#d75fd7",
        "#d75fff",
        "#d78700",
        "#d7875f",
        "#d78787",
        "#d787af",
        "#d787d7",
        "#d787ff",
        "#d7af00",
        "#d7af5f",
        "#d7af87",
        "#d7afaf",
        "#d7afd7",
        "#d7afff",
        "#d7d700",
        "#d7d75f",
        "#d7d787",
        "#d7d7af",
        "#d7d7d7",
        "#d7d7ff",
        "#d7ff00",
        "#d7ff5f",
        "#d7ff87",
        "#d7ffaf",
        "#d7ffd7",
        "#d7ffff",
        "#ff0000",
        "#ff005f",
        "#ff0087",
        "#ff00af",
        "#ff00d7",
        "#ff00ff",
        "#ff5f00",
        "#ff5f5f",
        "#ff5f87",
        "#ff5faf",
        "#ff5fd7",
        "#ff5fff",
        "#ff8700",
        "#ff875f",
        "#ff8787",
        "#ff87af",
        "#ff87d7",
        "#ff87ff",
        "#ffaf00",
        "#ffaf5f",
        "#ffaf87",
        "#ffafaf",
        "#ffafd7",
        "#ffafff",
        "#ffd700",
        "#ffd75f",
        "#ffd787",
        "#ffd7af",
        "#ffd7d7",
        "#ffd7ff",
        "#ffff00",
        "#ffff5f",
        "#ffff87",
        "#ffffaf",
        "#ffffd7",
        "#ffffff",
        "#080808",
        "#121212",
        "#1c1c1c",
        "#262626",
        "#303030",
        "#3a3a3a",
        "#444444",
        "#4e4e4e",
        "#585858",
        "#626262",
        "#6c6c6c",
        "#767676",
        "#808080",
        "#8a8a8a",
        "#949494",
        "#9e9e9e",
        "#a8a8a8",
        "#b2b2b2",
        "#bcbcbc",
        "#c6c6c6",
        "#d0d0d0",
        "#dadada",
        "#e4e4e4",
        "#eeeeee",
    )

    def history(self,event):
        print("Event: ",event)
        if event.keysym=="Up":
            self.historyidx+=1
            if self.historyidx>=len(self.historylst):
                self.historyidx=0
        elif event.keysym=="Down":
            self.historyidx-=1
            if self.historyidx<0:
                self.historyidx=len(self.historylst)-1
        if (self.historyidx>=0 and self.historyidx<len(self.historylst)):
            self.mytext.set(self.historylst[self.historyidx])

    def __init__(self, parent, **kwargs):
        super().__init__(parent, **kwargs)
        self.bottom = Frame(self, bg="LightGray")
        self.bottom.pack(side=BOTTOM, fill=X)
        self.sendbtn = Button(self.bottom, text="Snd", command=self.doSend)
        self.mytext = StringVar()
        self.sendEntry = Entry(self.bottom, textvariable=self.mytext)
        self.sendbtn.pack(side=RIGHT)
        self.sendEntry.pack(fill=X, expand=True)
        self.sendEntry.bind("<Return>",self.doSendEvent)
        self.sendEntry.bind("<Up>", self.history)
        self.sendEntry.bind("<Down>", self.history)
        self.socket = socket.socket(socket.AF_INET, socket.SOCK_STREAM)

        self.iscsi = False
        self.isesc = False
        self.parameters = []
        self.currentparam = ""
        self.ResetStyle()
        self.output=""
        self.currenttag=""
        self.taglist = []
        self.settag()
        self.listenthread=None
        self.connectString=""
        self.stopping=False
        self.lastline=""
        self.capturestr=""
        self.capturemode=0
        self.capturefunc=None
        self.external_edit=""
        self.verbcollect=''
        self.onExamineLine=None

        self.historylst=[]
        self.historyidx=0
        ifile=SettingsDialog.getConfig()
        if ifile.has_section("history"):
            for (key,value) in ifile.items("history"):
                if key.isnumeric():
                    self.historylst.append(value)

    def settag(self):
        tagname = self.myfontcolor + ";" + self.mycolor
        if (tagname!=self.currenttag):
            self.flush()
        if not (tagname in self.taglist):
            cfg = {"background": self.mycolor, "foreground": self.myfontcolor}
            self.textbox.tag_config(tagname, cfg)
            self.taglist.append(tagname)
        self.currenttag = tagname
    
    def parseVerb(self,value):
        """Return (obj,verb), or False if not valid."""
        if value.startswith('@'):
             value=parse(value)[1]
        (obj,value)=parsesep(value,':')
        (verb,value)=parse(value)
        if verb.startswith('"'):
             verb=getsepfield(verb,1,'"')
        i=verb.find("*")
        if (i>=0):
            verb=verb[0:i]
        if (verb!='') and (obj!=''):
            return (obj,verb)
        return False

    def addtext(self, msg):
        for c in msg:
            self.addchar(c)
        self.textbox.see("end")

    def rgb(self, r, g, b):
        return "#%02x%02x%02x" % (r, g, b)
    
    def flush(self):
        if self.output!="":
            self.textbox.insert("end",self.output,self.currenttag)
            self.output=""
            self.textbox.see("end")

    def saveSettings(self):
        ifile=SettingsDialog.getConfig()
        if (ifile.has_section("history")):
            ifile.remove_section("history")
        ifile.add_section("history")
        h=ifile["history"]
        for i in range(10):
            if i>=len(self.historylst):
                break
            h[str(i)]=self.historylst[i]
        ifile["settings"]['LastDump']=self.dumpobject
        SettingsDialog.saveConfig(ifile)

    def ResetStyle(self):
        self.isbold = False
        self.isunderline = False
        self.isitalic = False
        self.isstrikeout = False
        self.myfontcolor = "#c0c0c0"
        self.mycolor = "#000000"

    def setbold(self, bold):
        if bold != self.isbold:
            if bold:
                ix = self.ColorTable.index(self.myfontcolor)
                if ix >= 0:
                    self.myfontcolor = self.ColorTableBold[ix]
                else:
                    self.myfontcolor = "#ffffff"
            else:
                ix = self.ColorTableBold.index(self.myfontcolor)
                if ix >= 0:
                    self.myfontcolor = self.ColorTable[ix]
                else:
                    self.myfontcolor = "#c0c0c0"
        self.isbold = bold

    def setattributes(self):
        extended = 0
        secondary = 0
        back = False
        xrgb = [0, 0, 0]
        for n in self.parameters:
            if extended > 0:
                if extended == 1:
                    secondary = n
                elif secondary == 5:  # X256
                    if back:
                        self.mycolor = self.ColorX256[n & 0xFF]
                    else:
                        self.myfontcolor = self.ColorX256[n & 0xFF]
                    extended = 0
                    continue
                elif secondary == 2:
                    xrgb[extended - 2] = n & 0xFF
                    if extended == 4:
                        if back:
                            self.mycolor = self.rgb(xrgb[0], xrgb[1], xrgb[2])
                        else:
                            self.myfontcolor = self.rgb(xrgb[0], xrgb[1], xrgb[2])
                        extended = 0
                        continue
                extended += 1
                continue
            if n == 0:
                self.ResetStyle()
            elif n == 1:
                self.setbold(True)
            elif n == 2 or n == 22:
                self.setbold(False)
            elif n == 3:
                self.isitalic = True
            elif n == 4:
                self.isunderline = True
            elif n == 9:
                self.isstrikeout = True
            elif n >= 30 and n <= 37:
                if self.isbold:
                    self.myfontcolor = self.ColorTableBold[n % 10]
                else:
                    self.myfontcolor = self.ColorTable[n % 10]
            elif n == 38:
                back = False
                extended = 1
            elif n >= 40 and n <= 47:
                if self.isbold:
                    self.mycolor = self.ColorTableBold[n % 10]
                else:
                    self.mycolor = self.ColorTable[n % 10]
            elif n == 48:
                back = True
                extended = 1
        # print("fg=",self.myfontcolor," bg=",self.mycolor)
        self.settag()

    def addchar(self, c: str):
        if self.isesc:
            if self.iscsi:
                if c.isalpha():
                    self.iscsi = False
                    self.isesc = False
                    self.parameters.append(int(self.currentparam))
                    self.currentparam = ""
                    if c == "m":
                        self.setattributes()
                elif c.isnumeric():
                    self.currentparam += c
                elif c == ";":
                    self.parameters.append(int(self.currentparam))
                    self.currentparam = ""
            elif c == "[":
                self.iscsi = True
                self.parameters = []
                self.currentparam = ""
        elif c == "\x1b":
            self.isesc = True
        else:
            self.isesc = False
            self.iscsi = False
            self.currentparam = ""
            if self.capturemode!=1:
                self.output+=c
        if (c=="\n"):
            self.processLine()
            self.lastline=""
        elif c!="\r":
            self.lastline+=c

    def processLine(self):
        if self.capturemode==0:
            if self.lastline.startswith("#$# edit"):
                self.external_edit=self.lastline
                self.capturemode=1
                self.capturestr=""
            elif self.onExamineLine:
                self.onExamineLine(self.lastline)
        elif self.capturemode==1:
            if self.capturestr!="":
                self.capturestr+="\n"
            self.capturestr+=self.lastline
            if (self.lastline=="."):
                self.capturemode=0
                (name,upload)=self.parseExternal()
                self.capturefunc(self.capturestr,name)

    def selectError(self,obj:str,verb:str,lno:int)->bool:
        tabs=self.pages.tabs()
        for i in range(2,len(tabs)):
            w=self.pages.nametowidget(tabs[i])
            if (type(w) is ScrollText):
                re:Text=w.textbox
                lines=re.get("1.0","end").splitlines()
                if (len(lines)>0 and (lines[0]+" ").lower().find(obj+':'+verb+' ')>=0):
                    self.pages.select(i)
                    start=str(lno+1)+'.0'
                    end=str(lno+1)+".end"
                    re.see(start)
                    re.focus_set()
                    re.tag_add(SEL,start,end)
                    #pagesChange(self);
                    return True
        return False
    
    def currentEditor(self)->Text:
        w=self.currentPage()
        if (type(w) is ScrollText):
            return w.textbox
        return None

    def currentPage(self)->ScrollText:
        w=self.nametowidget(self.pages.select())
        if (type(w) is ScrollText):
            return w
        return None

    def addtarget(self,dest:Text, line:str):
        dest.insert("end",line+"\n")
        dest.see("end")

    def doCheckTest(self,line:str):
        """Check for stack trace messages"""
        if self.getstack: 
            self.addtarget(self.stack,line)
        # #540:test (this == #540), line 5:  Type mismatch (expected integer; got float)
        # #151:+attacks, line 9:  Verb not found: #548:energy_cast()
        # #151:+deploy deploy, line 28:  Range error
        if line.startswith('#') and line.find(', line')>=0:
            startline=line
            (prog,line)=parsesep(line,',')
            line=parse(line)[1] # Skip "line"
            (lno,line)=parsesep(line,':')
            (obj,verb)=self.parseVerb(prog)    #Should strip out trailing defs.
            error=line
            self.getstack=True
            self.stack.delete("1.0","end")
            self.addtarget(self.stack,'Stack')
            self.addtarget(self.stack,error)
            self.addtarget(self.stack,obj+':'+verb+', line '+lno)
            self.setstackvisible(True)
            self.errorverb=''
            if not self.selectError(obj,verb,int(lno)):
                self.errorverb=verb
                self.errorobj=obj
                self.lastlno=int(lno)
        elif (line=='(End of traceback)'):
            self.getstack=False
            if self.errorverb!='':
                self.findVerb(self.errorobj,self.errorverb,self.lastlno)
            self.errorverb=''
    
    def doCheckCompile(self,line:str)->None:
        """Check that verb has compiled"""
#        var lno,x,n:Integer; s1,s2:String;  e:TEdit;
#        adddebug(line);
        if (line.startswith('Line ')):
            (s1,line)=parsesep(line,':');
            lno=atol(s1[4:])
            self.stack.delete("1.0","end")
            self.stack.insert("1.0","Compile Error\n"+line)
            self.setstackvisible(True)
            re=self.currentEditor()
            ix=str(lno+1)+".0"
            re.mark_set(INSERT,ix)
            re.see(ix)
            re.tag_add(SEL,ix,str(lno+1)+".end")
            re.focus_set()
#            adddebug('Error found: '+line);
        elif line=='Verb not programmed.':
            self.onExamineLine=self.doCheckTest
        elif line=='Verb programmed.':
#            adddebug('Compiled OK.');
            self.onExamineLine=self.doCheckTest
            if False:
#            SetChanged(CurrentEditor,false);
#            e:=CurrentTest;
#            if assigned(e) and (trim(e.Text)<>'') then
#            begin
#            msgqueue.add(e.Text);
#            testtab:=pages.ActivePage;
#            onExamineLine:=DoChecktest;
                self.getstack=False
                self.pages.select(self)
            else:
                 self.showmessage(line)

    def addTab(self,caption:str,text:str,tabtype:int):
        t=ScrollText(self.pages,background="black",foreground="white",font=("Courier",12,"bold"),insertbackground="white")
        self.pages.add(t,text=caption)
        t.textbox.insert("1.0",text)
        t.tabtype=tabtype

    def doCheckVerb(self, line:str):
        if (line=='***finished***'):
            self.onExamineLine=self.doCheckTest
            t=self.verbcollect.splitlines()
            t.append(".")
            prog=t[0]
            if (prog=='That object does not define that verb.'):
                messagebox.showwarning("MooCoderPy",'Verb not found.')
                return
            for i in range(len(t)):
                if t[i].endswith('[normal]'): # Stupid ansi is stupid.
                    s=t[i]
                    t[i]=s[0:len(s)-len('[normal]')]
            (obj,prog)=parsesep(prog,':')
            args=prog;
            if (args.startswith('"')):
                args=args.replace('"','').strip()
            (verb,prog)=parse(prog)
            if (verb.startswith('"')):
                verb=getsepfield(verb,1,'"')
            i=verb.find('*')
            if (i>=0):
                verb=verb[0:i]
            t[0]='@program '+obj+':'+verb
            if self.selectError(obj,verb,self.lastlno):
                re=self.currentEditor()
                re.delete("1.0","end")
                re.insert("1.0","\n".join(t))
                re.see(str(self.lastlno)+":0")
            else:
                self.addTab(obj+':'+verb,"\n".join(t),1)
                self.selectError(obj,verb,self.lastlno)
            self.lastlno=0
            self.checkName(obj)
            self.arglist[obj+':'+verb]=args
            self.verblist.append(obj+':'+verb)
            self.updateVerbs()
        else:
            self.verbcollect+=line+"\n"
    
    def checkName(self,obj:str)->None:
        """Check that we know the name of an object."""
        if not(obj in self.namelist):
            self.sendCmd(';'+obj+'.name')
            self.onExamineLine=self.doCheckName
        self.lastobj=obj
    
    def doCheckName(self,line:str):
        """Examine stream for name of object."""
        if line.lower().find('***finished***')>=0:
            return # Ignore trailing stuff.
        if line.startswith('=> 0'):
            return # tailing result.
        self.onExamineLine=self.doCheckTest
        if not(line.startswith('=>')):
            self.addln('Name not found.')
            return
        aname=getsepfield(line,1,'"')
        self.namelist[self.lastobj]=aname
        self.updateVerbs()
    
    def findVerbHelp(self,obj:str,verb:str)->str:
        return ""

    def updateVerbs(self)->None:
        """Update Verb list window"""
#        var nd:TListItem; s:String; obj,verb:String;
#            oldverb,oldobj:String; i:Integer;
#        lvVerbs.Items.BeginUpdate;
        oldverb=''
        nd=self.lvVerbs.item(self.lvVerbs.focus())
        if nd["text"]!="":
            oldobj=nd["text"].lower()
            oldverb=nd["values"][1].lower()
        for i in self.lvVerbs.get_children(): #Clear list
            self.lvVerbs.delete(i)
        for s in self.verblist:
            obj=getsepfield(s,0,':')
            verb=getsepfield(s,1,':')
            name=self.namelist[obj] if obj in self.namelist else obj
            args=self.arglist[s] if s in self.arglist else ""
            values=(name,verb,args,self.findVerbHelp(obj,verb))
            self.lvVerbs.insert("","end",text=obj,values=values)
        self.fitListContents(self.lvVerbs)
        if oldverb!="":
            for i in self.lvVerbs.get_children():
                nd=self.lvVerbs.item(i)
                if nd["text"].lower()==oldobj and nd["values"][1].lower()==oldverb:
                    self.lvVerbs.selection_set(i)
                    self.lvVerbs.see(i)
                    break

    def fitListContents(self,alist:ttk.Treeview):
        cols=alist.cget("columns")
        colnames=["#0"]+list(cols)
        print("cols",cols,colnames)
        

    def parseExternal(self):
        try:
            t=self.external_edit.split(" name: ")[1]
            tt=t.split(" upload: ")
            return (tt[0].strip(),tt[1].strip())
        except:
            return("","")
    
    def doupdate(self,text:str):
        if self.external_edit=="":
            messagebox.showwarning("Send Update","Not in @edit mode")
            return False
        upload=self.parseExternal()[1]    
        self.sendCmd(upload)
        self.sendCmd(text)
        self.after(500,self.sendtext,"Update complete\n")
        return True
    
    def docompile(self,page:ScrollText):
        if not(type(page) is ScrollText):
            return
        self.sendCmd(page.textbox.get("1.0","end"))
        self.onExamineLine=self.doCheckCompile

    def doSend(self):
        s = self.mytext.get()
        print("Send:", s)
        self.mytext.set("")
        if self.socket != None:
            self.socket.send((s + "\n").encode("utf-8"))
            self.historylst.insert(0,s)
            self.historyidx=0

    def doSendEvent(self,event):
        self.doSend()
        
    def doConnect(self, server, port):
        self.disconnect()
        self.sendtext("Connecting to %s %d\n" % (server,port))
        self.socket = socket.socket(socket.AF_INET, socket.SOCK_STREAM)
        self.socket.connect((server, port))
        self.stopping=False
        self.listenthread = threading.Thread(target=self.doListen)
        self.listenthread.start()
        if (self.connectString!=""):
            self.after(1000,self.sendCmd,self.connectString)
        print("Connected")
    def showmessage(self,msg):
        messagebox.showinfo("MooCoderPy",msg)

    def loadVerb(self,verbdef):
        v=self.parseVerb(verbdef)
        if not v:
            self.showmessage("Invalid Verb Syntax")
            return
        (obj,verb)=v
        self.findVerb(obj,verb,0)

    def findVerb(self,obj:str,verb:str, lno:int):
        self.lastlno=lno
        if (obj=='#-1'):
            return # Not a real verb.
        #if not(self.selectError(obj,verb,lno)):
        self.fetchVerb(obj,verb)
    
    def fetchVerb(self,obj,verb):
        self.sendCmd('@list '+obj+':'+verb+' without numbers')
        self.sendCmd(';player:tell("***finished***")')
        self.verbcollect=''
        self.onExamineLine=self.doCheckVerb;

    def sendCmd(self,cmd):
        buf=(cmd+"\n").encode("utf-8")
        self.socket.sendall(buf)
        

    def doConnectStr(self):
        if (self.connectString!=""):
            self.sendCmd(self.connectString)

    def disconnect(self):
        print("Disconnecting...")
        try:
            self.stopping=True
            self.socket.close()
            if (self.listenthread!=None):
                threading.join(self.listenthread)
            self.listenthread=None
        except:
            pass

    def doListen(self):
        try:
            while True:
                (readlist,writelist,exceptlist)=select.select([self.socket],[],[],1) 
                if self.stopping:
                    print("Listen thread stopping.")
                    break
                if self.socket in readlist:
                    b = self.socket.recv(128)
                    self.sendtext(b.decode("utf-8"))
        except Exception as err:
            print("Connection error: {0}".format(err))
            try:
                self.sendtext("Connection error: {0}".format(err))
            except:
                pass
    def getVerbs(self,event:Event=None):
        s=simpledialog.askstring('Verbs','Load Verb list for object:', initialvalue=self.dumpobject)
        if (s):
            self.dumpobject=s
            self.sendCmd('@verbs '+self.dumpobject)
            self.onExamineLine=self.doCheckVerbs

    def doCheckVerbs(self,line:str)->None:
        """Fetch verbs for an object"""
        self.onExamineLine=self.doCheckTest
        if not(line.lower().startswith(';verb')):
            messagebox.showerror("MooCoderPy","Verb not found.\n"+line)
            return
        line=parsesep(line,'(')[1]
        (obj,line)=parsesep(line,')')
        line=parsesep(line,'{')[1]
        line=line.strip()
        if line.endswith('}'):
            line=line[0:len(line)-1]
        self.verblist=[x for x in self.verblist if not(x.startswith(obj+":"))]    
        t=line.split(",")
        for s1 in t:
            s=s1.strip()[1:]
            s=s[0:len(s)-1]
            verb=getfield(s,0)
            self.verblist.append(obj+':'+verb);
        self.checkName(obj)
        self.updateVerbs()
