"""
    The Plaid API

    The Plaid REST API. Please see https://plaid.com/docs/api for more details.  # noqa: E501
    Generated by: https://openapi-generator.tech
"""


import re  # noqa: F401
import sys  # noqa: F401

from plaid.api_client import ApiClient, Endpoint as _Endpoint
from plaid.model_utils import (  # noqa: F401
    check_allowed_values,
    check_validations,
    date,
    datetime,
    file_type,
    none_type,
    validate_and_convert_types
)
from plaid.model.accounts_balance_get_request import AccountsBalanceGetRequest
from plaid.model.accounts_get_request import AccountsGetRequest
from plaid.model.accounts_get_response import AccountsGetResponse
from plaid.model.application_get_request import ApplicationGetRequest
from plaid.model.application_get_response import ApplicationGetResponse
from plaid.model.asset_report_audit_copy_create_request import AssetReportAuditCopyCreateRequest
from plaid.model.asset_report_audit_copy_create_response import AssetReportAuditCopyCreateResponse
from plaid.model.asset_report_audit_copy_get_request import AssetReportAuditCopyGetRequest
from plaid.model.asset_report_audit_copy_remove_request import AssetReportAuditCopyRemoveRequest
from plaid.model.asset_report_audit_copy_remove_response import AssetReportAuditCopyRemoveResponse
from plaid.model.asset_report_create_request import AssetReportCreateRequest
from plaid.model.asset_report_create_response import AssetReportCreateResponse
from plaid.model.asset_report_filter_request import AssetReportFilterRequest
from plaid.model.asset_report_filter_response import AssetReportFilterResponse
from plaid.model.asset_report_get_request import AssetReportGetRequest
from plaid.model.asset_report_get_response import AssetReportGetResponse
from plaid.model.asset_report_pdf_get_request import AssetReportPDFGetRequest
from plaid.model.asset_report_refresh_request import AssetReportRefreshRequest
from plaid.model.asset_report_refresh_response import AssetReportRefreshResponse
from plaid.model.asset_report_relay_create_request import AssetReportRelayCreateRequest
from plaid.model.asset_report_relay_create_response import AssetReportRelayCreateResponse
from plaid.model.asset_report_relay_get_request import AssetReportRelayGetRequest
from plaid.model.asset_report_relay_refresh_request import AssetReportRelayRefreshRequest
from plaid.model.asset_report_relay_refresh_response import AssetReportRelayRefreshResponse
from plaid.model.asset_report_relay_remove_request import AssetReportRelayRemoveRequest
from plaid.model.asset_report_relay_remove_response import AssetReportRelayRemoveResponse
from plaid.model.asset_report_remove_request import AssetReportRemoveRequest
from plaid.model.asset_report_remove_response import AssetReportRemoveResponse
from plaid.model.auth_get_request import AuthGetRequest
from plaid.model.auth_get_response import AuthGetResponse
from plaid.model.bank_transfer_balance_get_request import BankTransferBalanceGetRequest
from plaid.model.bank_transfer_balance_get_response import BankTransferBalanceGetResponse
from plaid.model.bank_transfer_cancel_request import BankTransferCancelRequest
from plaid.model.bank_transfer_cancel_response import BankTransferCancelResponse
from plaid.model.bank_transfer_create_request import BankTransferCreateRequest
from plaid.model.bank_transfer_create_response import BankTransferCreateResponse
from plaid.model.bank_transfer_event_list_request import BankTransferEventListRequest
from plaid.model.bank_transfer_event_list_response import BankTransferEventListResponse
from plaid.model.bank_transfer_event_sync_request import BankTransferEventSyncRequest
from plaid.model.bank_transfer_event_sync_response import BankTransferEventSyncResponse
from plaid.model.bank_transfer_get_request import BankTransferGetRequest
from plaid.model.bank_transfer_get_response import BankTransferGetResponse
from plaid.model.bank_transfer_list_request import BankTransferListRequest
from plaid.model.bank_transfer_list_response import BankTransferListResponse
from plaid.model.bank_transfer_migrate_account_request import BankTransferMigrateAccountRequest
from plaid.model.bank_transfer_migrate_account_response import BankTransferMigrateAccountResponse
from plaid.model.bank_transfer_sweep_get_request import BankTransferSweepGetRequest
from plaid.model.bank_transfer_sweep_get_response import BankTransferSweepGetResponse
from plaid.model.bank_transfer_sweep_list_request import BankTransferSweepListRequest
from plaid.model.bank_transfer_sweep_list_response import BankTransferSweepListResponse
from plaid.model.categories_get_response import CategoriesGetResponse
from plaid.model.create_entity_screening_request import CreateEntityScreeningRequest
from plaid.model.create_entity_watchlist_screening_review_request import CreateEntityWatchlistScreeningReviewRequest
from plaid.model.create_individual_watchlist_screening_review_request import CreateIndividualWatchlistScreeningReviewRequest
from plaid.model.credit_audit_copy_token_create_request import CreditAuditCopyTokenCreateRequest
from plaid.model.credit_audit_copy_token_create_response import CreditAuditCopyTokenCreateResponse
from plaid.model.credit_bank_income_get_request import CreditBankIncomeGetRequest
from plaid.model.credit_bank_income_get_response import CreditBankIncomeGetResponse
from plaid.model.credit_bank_income_refresh_request import CreditBankIncomeRefreshRequest
from plaid.model.credit_bank_income_refresh_response import CreditBankIncomeRefreshResponse
from plaid.model.credit_employment_get_request import CreditEmploymentGetRequest
from plaid.model.credit_employment_get_response import CreditEmploymentGetResponse
from plaid.model.credit_payroll_income_get_request import CreditPayrollIncomeGetRequest
from plaid.model.credit_payroll_income_get_response import CreditPayrollIncomeGetResponse
from plaid.model.credit_payroll_income_precheck_request import CreditPayrollIncomePrecheckRequest
from plaid.model.credit_payroll_income_precheck_response import CreditPayrollIncomePrecheckResponse
from plaid.model.credit_payroll_income_refresh_request import CreditPayrollIncomeRefreshRequest
from plaid.model.credit_payroll_income_refresh_response import CreditPayrollIncomeRefreshResponse
from plaid.model.credit_relay_create_request import CreditRelayCreateRequest
from plaid.model.credit_relay_create_response import CreditRelayCreateResponse
from plaid.model.dashboard_user_response import DashboardUserResponse
from plaid.model.deposit_switch_alt_create_request import DepositSwitchAltCreateRequest
from plaid.model.deposit_switch_alt_create_response import DepositSwitchAltCreateResponse
from plaid.model.deposit_switch_create_request import DepositSwitchCreateRequest
from plaid.model.deposit_switch_create_response import DepositSwitchCreateResponse
from plaid.model.deposit_switch_get_request import DepositSwitchGetRequest
from plaid.model.deposit_switch_get_response import DepositSwitchGetResponse
from plaid.model.deposit_switch_token_create_request import DepositSwitchTokenCreateRequest
from plaid.model.deposit_switch_token_create_response import DepositSwitchTokenCreateResponse
from plaid.model.employers_search_request import EmployersSearchRequest
from plaid.model.employers_search_response import EmployersSearchResponse
from plaid.model.employment_verification_get_request import EmploymentVerificationGetRequest
from plaid.model.employment_verification_get_response import EmploymentVerificationGetResponse
from plaid.model.entity_watchlist_program_response import EntityWatchlistProgramResponse
from plaid.model.entity_watchlist_screening_response import EntityWatchlistScreeningResponse
from plaid.model.entity_watchlist_screening_review_response import EntityWatchlistScreeningReviewResponse
from plaid.model.error import Error
from plaid.model.get_dashboard_user_request import GetDashboardUserRequest
from plaid.model.get_entity_watchlist_screening_request import GetEntityWatchlistScreeningRequest
from plaid.model.get_identity_verification_request import GetIdentityVerificationRequest
from plaid.model.get_individual_watchlist_screening_request import GetIndividualWatchlistScreeningRequest
from plaid.model.get_watchlist_screening_entity_program_request import GetWatchlistScreeningEntityProgramRequest
from plaid.model.get_watchlist_screening_individual_program_request import GetWatchlistScreeningIndividualProgramRequest
from plaid.model.identity_get_request import IdentityGetRequest
from plaid.model.identity_get_response import IdentityGetResponse
from plaid.model.identity_verification_create_request import IdentityVerificationCreateRequest
from plaid.model.identity_verification_response import IdentityVerificationResponse
from plaid.model.identity_verification_retry_request import IdentityVerificationRetryRequest
from plaid.model.income_verification_create_request import IncomeVerificationCreateRequest
from plaid.model.income_verification_create_response import IncomeVerificationCreateResponse
from plaid.model.income_verification_documents_download_request import IncomeVerificationDocumentsDownloadRequest
from plaid.model.income_verification_paystubs_get_request import IncomeVerificationPaystubsGetRequest
from plaid.model.income_verification_paystubs_get_response import IncomeVerificationPaystubsGetResponse
from plaid.model.income_verification_precheck_request import IncomeVerificationPrecheckRequest
from plaid.model.income_verification_precheck_response import IncomeVerificationPrecheckResponse
from plaid.model.income_verification_refresh_request import IncomeVerificationRefreshRequest
from plaid.model.income_verification_refresh_response import IncomeVerificationRefreshResponse
from plaid.model.income_verification_taxforms_get_request import IncomeVerificationTaxformsGetRequest
from plaid.model.income_verification_taxforms_get_response import IncomeVerificationTaxformsGetResponse
from plaid.model.individual_watchlist_program_response import IndividualWatchlistProgramResponse
from plaid.model.institutions_get_by_id_request import InstitutionsGetByIdRequest
from plaid.model.institutions_get_by_id_response import InstitutionsGetByIdResponse
from plaid.model.institutions_get_request import InstitutionsGetRequest
from plaid.model.institutions_get_response import InstitutionsGetResponse
from plaid.model.institutions_search_request import InstitutionsSearchRequest
from plaid.model.institutions_search_response import InstitutionsSearchResponse
from plaid.model.investments_holdings_get_request import InvestmentsHoldingsGetRequest
from plaid.model.investments_holdings_get_response import InvestmentsHoldingsGetResponse
from plaid.model.investments_transactions_get_request import InvestmentsTransactionsGetRequest
from plaid.model.investments_transactions_get_response import InvestmentsTransactionsGetResponse
from plaid.model.item_access_token_invalidate_request import ItemAccessTokenInvalidateRequest
from plaid.model.item_access_token_invalidate_response import ItemAccessTokenInvalidateResponse
from plaid.model.item_application_list_request import ItemApplicationListRequest
from plaid.model.item_application_list_response import ItemApplicationListResponse
from plaid.model.item_application_scopes_update_request import ItemApplicationScopesUpdateRequest
from plaid.model.item_application_scopes_update_response import ItemApplicationScopesUpdateResponse
from plaid.model.item_get_request import ItemGetRequest
from plaid.model.item_get_response import ItemGetResponse
from plaid.model.item_import_request import ItemImportRequest
from plaid.model.item_import_response import ItemImportResponse
from plaid.model.item_public_token_create_request import ItemPublicTokenCreateRequest
from plaid.model.item_public_token_create_response import ItemPublicTokenCreateResponse
from plaid.model.item_public_token_exchange_request import ItemPublicTokenExchangeRequest
from plaid.model.item_public_token_exchange_response import ItemPublicTokenExchangeResponse
from plaid.model.item_remove_request import ItemRemoveRequest
from plaid.model.item_remove_response import ItemRemoveResponse
from plaid.model.item_webhook_update_request import ItemWebhookUpdateRequest
from plaid.model.item_webhook_update_response import ItemWebhookUpdateResponse
from plaid.model.liabilities_get_request import LiabilitiesGetRequest
from plaid.model.liabilities_get_response import LiabilitiesGetResponse
from plaid.model.link_token_create_request import LinkTokenCreateRequest
from plaid.model.link_token_create_response import LinkTokenCreateResponse
from plaid.model.link_token_get_request import LinkTokenGetRequest
from plaid.model.link_token_get_response import LinkTokenGetResponse
from plaid.model.list_dashboard_user_request import ListDashboardUserRequest
from plaid.model.list_entity_watchlist_screening_request import ListEntityWatchlistScreeningRequest
from plaid.model.list_identity_verification_request import ListIdentityVerificationRequest
from plaid.model.list_individual_watchlist_screening_request import ListIndividualWatchlistScreeningRequest
from plaid.model.list_watchlist_screening_entity_history_request import ListWatchlistScreeningEntityHistoryRequest
from plaid.model.list_watchlist_screening_entity_hit_request import ListWatchlistScreeningEntityHitRequest
from plaid.model.list_watchlist_screening_entity_programs_request import ListWatchlistScreeningEntityProgramsRequest
from plaid.model.list_watchlist_screening_entity_reviews_request import ListWatchlistScreeningEntityReviewsRequest
from plaid.model.list_watchlist_screening_individual_history_request import ListWatchlistScreeningIndividualHistoryRequest
from plaid.model.list_watchlist_screening_individual_hit_request import ListWatchlistScreeningIndividualHitRequest
from plaid.model.list_watchlist_screening_individual_programs_request import ListWatchlistScreeningIndividualProgramsRequest
from plaid.model.list_watchlist_screening_individual_reviews_request import ListWatchlistScreeningIndividualReviewsRequest
from plaid.model.paginated_dashboard_user_list_response import PaginatedDashboardUserListResponse
from plaid.model.paginated_entity_watchlist_program_list_response import PaginatedEntityWatchlistProgramListResponse
from plaid.model.paginated_entity_watchlist_screening_hit_list_response import PaginatedEntityWatchlistScreeningHitListResponse
from plaid.model.paginated_entity_watchlist_screening_list_response import PaginatedEntityWatchlistScreeningListResponse
from plaid.model.paginated_entity_watchlist_screening_review_list_response import PaginatedEntityWatchlistScreeningReviewListResponse
from plaid.model.paginated_identity_verification_list_response import PaginatedIdentityVerificationListResponse
from plaid.model.paginated_individual_watchlist_program_list_response import PaginatedIndividualWatchlistProgramListResponse
from plaid.model.paginated_individual_watchlist_screening_hit_list_response import PaginatedIndividualWatchlistScreeningHitListResponse
from plaid.model.paginated_individual_watchlist_screening_list_response import PaginatedIndividualWatchlistScreeningListResponse
from plaid.model.paginated_individual_watchlist_screening_review_list_response import PaginatedIndividualWatchlistScreeningReviewListResponse
from plaid.model.payment_initiation_consent_create_request import PaymentInitiationConsentCreateRequest
from plaid.model.payment_initiation_consent_create_response import PaymentInitiationConsentCreateResponse
from plaid.model.payment_initiation_consent_get_request import PaymentInitiationConsentGetRequest
from plaid.model.payment_initiation_consent_get_response import PaymentInitiationConsentGetResponse
from plaid.model.payment_initiation_consent_payment_execute_request import PaymentInitiationConsentPaymentExecuteRequest
from plaid.model.payment_initiation_consent_payment_execute_response import PaymentInitiationConsentPaymentExecuteResponse
from plaid.model.payment_initiation_consent_revoke_request import PaymentInitiationConsentRevokeRequest
from plaid.model.payment_initiation_consent_revoke_response import PaymentInitiationConsentRevokeResponse
from plaid.model.payment_initiation_payment_create_request import PaymentInitiationPaymentCreateRequest
from plaid.model.payment_initiation_payment_create_response import PaymentInitiationPaymentCreateResponse
from plaid.model.payment_initiation_payment_get_request import PaymentInitiationPaymentGetRequest
from plaid.model.payment_initiation_payment_get_response import PaymentInitiationPaymentGetResponse
from plaid.model.payment_initiation_payment_list_request import PaymentInitiationPaymentListRequest
from plaid.model.payment_initiation_payment_list_response import PaymentInitiationPaymentListResponse
from plaid.model.payment_initiation_payment_reverse_request import PaymentInitiationPaymentReverseRequest
from plaid.model.payment_initiation_payment_reverse_response import PaymentInitiationPaymentReverseResponse
from plaid.model.payment_initiation_payment_token_create_request import PaymentInitiationPaymentTokenCreateRequest
from plaid.model.payment_initiation_payment_token_create_response import PaymentInitiationPaymentTokenCreateResponse
from plaid.model.payment_initiation_recipient_create_request import PaymentInitiationRecipientCreateRequest
from plaid.model.payment_initiation_recipient_create_response import PaymentInitiationRecipientCreateResponse
from plaid.model.payment_initiation_recipient_get_request import PaymentInitiationRecipientGetRequest
from plaid.model.payment_initiation_recipient_get_response import PaymentInitiationRecipientGetResponse
from plaid.model.payment_initiation_recipient_list_request import PaymentInitiationRecipientListRequest
from plaid.model.payment_initiation_recipient_list_response import PaymentInitiationRecipientListResponse
from plaid.model.processor_apex_processor_token_create_request import ProcessorApexProcessorTokenCreateRequest
from plaid.model.processor_auth_get_request import ProcessorAuthGetRequest
from plaid.model.processor_auth_get_response import ProcessorAuthGetResponse
from plaid.model.processor_balance_get_request import ProcessorBalanceGetRequest
from plaid.model.processor_balance_get_response import ProcessorBalanceGetResponse
from plaid.model.processor_bank_transfer_create_request import ProcessorBankTransferCreateRequest
from plaid.model.processor_bank_transfer_create_response import ProcessorBankTransferCreateResponse
from plaid.model.processor_identity_get_request import ProcessorIdentityGetRequest
from plaid.model.processor_identity_get_response import ProcessorIdentityGetResponse
from plaid.model.processor_stripe_bank_account_token_create_request import ProcessorStripeBankAccountTokenCreateRequest
from plaid.model.processor_stripe_bank_account_token_create_response import ProcessorStripeBankAccountTokenCreateResponse
from plaid.model.processor_token_create_request import ProcessorTokenCreateRequest
from plaid.model.processor_token_create_response import ProcessorTokenCreateResponse
from plaid.model.sandbox_bank_transfer_fire_webhook_request import SandboxBankTransferFireWebhookRequest
from plaid.model.sandbox_bank_transfer_fire_webhook_response import SandboxBankTransferFireWebhookResponse
from plaid.model.sandbox_bank_transfer_simulate_request import SandboxBankTransferSimulateRequest
from plaid.model.sandbox_bank_transfer_simulate_response import SandboxBankTransferSimulateResponse
from plaid.model.sandbox_income_fire_webhook_request import SandboxIncomeFireWebhookRequest
from plaid.model.sandbox_income_fire_webhook_response import SandboxIncomeFireWebhookResponse
from plaid.model.sandbox_item_fire_webhook_request import SandboxItemFireWebhookRequest
from plaid.model.sandbox_item_fire_webhook_response import SandboxItemFireWebhookResponse
from plaid.model.sandbox_item_reset_login_request import SandboxItemResetLoginRequest
from plaid.model.sandbox_item_reset_login_response import SandboxItemResetLoginResponse
from plaid.model.sandbox_item_set_verification_status_request import SandboxItemSetVerificationStatusRequest
from plaid.model.sandbox_item_set_verification_status_response import SandboxItemSetVerificationStatusResponse
from plaid.model.sandbox_oauth_select_accounts_request import SandboxOauthSelectAccountsRequest
from plaid.model.sandbox_oauth_select_accounts_response import SandboxOauthSelectAccountsResponse
from plaid.model.sandbox_processor_token_create_request import SandboxProcessorTokenCreateRequest
from plaid.model.sandbox_processor_token_create_response import SandboxProcessorTokenCreateResponse
from plaid.model.sandbox_public_token_create_request import SandboxPublicTokenCreateRequest
from plaid.model.sandbox_public_token_create_response import SandboxPublicTokenCreateResponse
from plaid.model.sandbox_transfer_fire_webhook_request import SandboxTransferFireWebhookRequest
from plaid.model.sandbox_transfer_fire_webhook_response import SandboxTransferFireWebhookResponse
from plaid.model.sandbox_transfer_repayment_simulate_request import SandboxTransferRepaymentSimulateRequest
from plaid.model.sandbox_transfer_repayment_simulate_response import SandboxTransferRepaymentSimulateResponse
from plaid.model.sandbox_transfer_simulate_request import SandboxTransferSimulateRequest
from plaid.model.sandbox_transfer_simulate_response import SandboxTransferSimulateResponse
from plaid.model.sandbox_transfer_sweep_simulate_request import SandboxTransferSweepSimulateRequest
from plaid.model.sandbox_transfer_sweep_simulate_response import SandboxTransferSweepSimulateResponse
from plaid.model.signal_decision_report_request import SignalDecisionReportRequest
from plaid.model.signal_decision_report_response import SignalDecisionReportResponse
from plaid.model.signal_evaluate_request import SignalEvaluateRequest
from plaid.model.signal_evaluate_response import SignalEvaluateResponse
from plaid.model.signal_prepare_request import SignalPrepareRequest
from plaid.model.signal_prepare_response import SignalPrepareResponse
from plaid.model.signal_return_report_request import SignalReturnReportRequest
from plaid.model.signal_return_report_response import SignalReturnReportResponse
from plaid.model.transactions_enhance_get_request import TransactionsEnhanceGetRequest
from plaid.model.transactions_enhance_get_response import TransactionsEnhanceGetResponse
from plaid.model.transactions_get_request import TransactionsGetRequest
from plaid.model.transactions_get_response import TransactionsGetResponse
from plaid.model.transactions_recurring_get_request import TransactionsRecurringGetRequest
from plaid.model.transactions_recurring_get_response import TransactionsRecurringGetResponse
from plaid.model.transactions_refresh_request import TransactionsRefreshRequest
from plaid.model.transactions_refresh_response import TransactionsRefreshResponse
from plaid.model.transactions_rules_create_request import TransactionsRulesCreateRequest
from plaid.model.transactions_rules_create_response import TransactionsRulesCreateResponse
from plaid.model.transactions_rules_list_request import TransactionsRulesListRequest
from plaid.model.transactions_rules_list_response import TransactionsRulesListResponse
from plaid.model.transactions_rules_remove_request import TransactionsRulesRemoveRequest
from plaid.model.transactions_rules_remove_response import TransactionsRulesRemoveResponse
from plaid.model.transactions_sync_request import TransactionsSyncRequest
from plaid.model.transactions_sync_response import TransactionsSyncResponse
from plaid.model.transfer_authorization_create_request import TransferAuthorizationCreateRequest
from plaid.model.transfer_authorization_create_response import TransferAuthorizationCreateResponse
from plaid.model.transfer_cancel_request import TransferCancelRequest
from plaid.model.transfer_cancel_response import TransferCancelResponse
from plaid.model.transfer_create_request import TransferCreateRequest
from plaid.model.transfer_create_response import TransferCreateResponse
from plaid.model.transfer_event_list_request import TransferEventListRequest
from plaid.model.transfer_event_list_response import TransferEventListResponse
from plaid.model.transfer_event_sync_request import TransferEventSyncRequest
from plaid.model.transfer_event_sync_response import TransferEventSyncResponse
from plaid.model.transfer_get_request import TransferGetRequest
from plaid.model.transfer_get_response import TransferGetResponse
from plaid.model.transfer_intent_create_request import TransferIntentCreateRequest
from plaid.model.transfer_intent_create_response import TransferIntentCreateResponse
from plaid.model.transfer_intent_get_request import TransferIntentGetRequest
from plaid.model.transfer_intent_get_response import TransferIntentGetResponse
from plaid.model.transfer_list_request import TransferListRequest
from plaid.model.transfer_list_response import TransferListResponse
from plaid.model.transfer_migrate_account_request import TransferMigrateAccountRequest
from plaid.model.transfer_migrate_account_response import TransferMigrateAccountResponse
from plaid.model.transfer_repayment_list_request import TransferRepaymentListRequest
from plaid.model.transfer_repayment_list_response import TransferRepaymentListResponse
from plaid.model.transfer_repayment_return_list_request import TransferRepaymentReturnListRequest
from plaid.model.transfer_repayment_return_list_response import TransferRepaymentReturnListResponse
from plaid.model.transfer_sweep_get_request import TransferSweepGetRequest
from plaid.model.transfer_sweep_get_response import TransferSweepGetResponse
from plaid.model.transfer_sweep_list_request import TransferSweepListRequest
from plaid.model.transfer_sweep_list_response import TransferSweepListResponse
from plaid.model.update_entity_screening_request import UpdateEntityScreeningRequest
from plaid.model.update_individual_screening_request import UpdateIndividualScreeningRequest
from plaid.model.user_create_request import UserCreateRequest
from plaid.model.user_create_response import UserCreateResponse
from plaid.model.wallet_create_request import WalletCreateRequest
from plaid.model.wallet_create_response import WalletCreateResponse
from plaid.model.wallet_get_request import WalletGetRequest
from plaid.model.wallet_get_response import WalletGetResponse
from plaid.model.wallet_list_request import WalletListRequest
from plaid.model.wallet_list_response import WalletListResponse
from plaid.model.wallet_transaction_execute_request import WalletTransactionExecuteRequest
from plaid.model.wallet_transaction_execute_response import WalletTransactionExecuteResponse
from plaid.model.wallet_transaction_get_request import WalletTransactionGetRequest
from plaid.model.wallet_transaction_get_response import WalletTransactionGetResponse
from plaid.model.wallet_transactions_list_request import WalletTransactionsListRequest
from plaid.model.wallet_transactions_list_response import WalletTransactionsListResponse
from plaid.model.watchlist_screening_create_request import WatchlistScreeningCreateRequest
from plaid.model.watchlist_screening_individual_response import WatchlistScreeningIndividualResponse
from plaid.model.watchlist_screening_review_response import WatchlistScreeningReviewResponse
from plaid.model.webhook_verification_key_get_request import WebhookVerificationKeyGetRequest
from plaid.model.webhook_verification_key_get_response import WebhookVerificationKeyGetResponse


class PlaidApi(object):
    """NOTE: This class is auto generated by OpenAPI Generator
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """

    def __init__(self, api_client=None):
        if api_client is None:
            api_client = ApiClient()
        self.api_client = api_client

        def __accounts_balance_get(
            self,
            accounts_balance_get_request,
            **kwargs
        ):
            """Retrieve real-time balance data  # noqa: E501

            The `/accounts/balance/get` endpoint returns the real-time balance for each of an Item's accounts. While other endpoints may return a balance object, only `/accounts/balance/get` forces the available and current balance fields to be refreshed rather than cached. This endpoint can be used for existing Items that were added via any of Plaid’s other products. This endpoint can be used as long as Link has been initialized with any other product, `balance` itself is not a product that can be used to initialize Link.  # noqa: E501
            This method makes a synchronous HTTP request by default. To make an
            asynchronous HTTP request, please pass async_req=True

            >>> thread = api.accounts_balance_get(accounts_balance_get_request, async_req=True)
            >>> result = thread.get()

            Args:
                accounts_balance_get_request (AccountsBalanceGetRequest):

            Keyword Args:
                _return_http_data_only (bool): response data without head status
                    code and headers. Default is True.
                _preload_content (bool): if False, the urllib3.HTTPResponse object
                    will be returned without reading/decoding response data.
                    Default is True.
                _request_timeout (float/tuple): timeout setting for this request. If one
                    number provided, it will be total request timeout. It can also
                    be a pair (tuple) of (connection, read) timeouts.
                    Default is None.
                _check_input_type (bool): specifies if type checking
                    should be done one the data sent to the server.
                    Default is True.
                _check_return_type (bool): specifies if type checking
                    should be done one the data received from the server.
                    Default is True.
                _host_index (int/None): specifies the index of the server
                    that we want to use.
                    Default is read from the configuration.
                async_req (bool): execute request asynchronously

            Returns:
                AccountsGetResponse
                    If the method is called asynchronously, returns the request
                    thread.
            """
            kwargs['async_req'] = kwargs.get(
                'async_req', False
            )
            kwargs['_return_http_data_only'] = kwargs.get(
                '_return_http_data_only', True
            )
            kwargs['_preload_content'] = kwargs.get(
                '_preload_content', True
            )
            kwargs['_request_timeout'] = kwargs.get(
                '_request_timeout', None
            )
            kwargs['_check_input_type'] = kwargs.get(
                '_check_input_type', True
            )
            kwargs['_check_return_type'] = kwargs.get(
                '_check_return_type', True
            )
            kwargs['_host_index'] = kwargs.get('_host_index')
            kwargs['accounts_balance_get_request'] = \
                accounts_balance_get_request
            return self.call_with_http_info(**kwargs)

        self.accounts_balance_get = _Endpoint(
            settings={
                'response_type': (AccountsGetResponse,),
                'auth': [
                    'clientId',
                    'plaidVersion',
                    'secret'
                ],
                'endpoint_path': '/accounts/balance/get',
                'operation_id': 'accounts_balance_get',
                'http_method': 'POST',
                'servers': None,
            },
            params_map={
                'all': [
                    'accounts_balance_get_request',
                ],
                'required': [
                    'accounts_balance_get_request',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'accounts_balance_get_request':
                        (AccountsBalanceGetRequest,),
                },
                'attribute_map': {
                },
                'location_map': {
                    'accounts_balance_get_request': 'body',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [
                    'application/json'
                ]
            },
            api_client=api_client,
            callable=__accounts_balance_get
        )

        def __accounts_get(
            self,
            accounts_get_request,
            **kwargs
        ):
            """Retrieve accounts  # noqa: E501

            The `/accounts/get` endpoint can be used to retrieve a list of accounts associated with any linked Item. Plaid will only return active bank accounts — that is, accounts that are not closed and are capable of carrying a balance. For items that went through the updated account selection pane, this endpoint only returns accounts that were permissioned by the user when they initially created the Item. If a user creates a new account after the initial link, you can capture this event through the [`NEW_ACCOUNTS_AVAILABLE`](https://plaid.com/docs/api/items/#new_accounts_available) webhook and then use Link's [update mode](https://plaid.com/docs/link/update-mode/) to request that the user share this new account with you.  This endpoint retrieves cached information, rather than extracting fresh information from the institution. As a result, balances returned may not be up-to-date; for realtime balance information, use `/accounts/balance/get` instead. Note that some information is nullable.  # noqa: E501
            This method makes a synchronous HTTP request by default. To make an
            asynchronous HTTP request, please pass async_req=True

            >>> thread = api.accounts_get(accounts_get_request, async_req=True)
            >>> result = thread.get()

            Args:
                accounts_get_request (AccountsGetRequest):

            Keyword Args:
                _return_http_data_only (bool): response data without head status
                    code and headers. Default is True.
                _preload_content (bool): if False, the urllib3.HTTPResponse object
                    will be returned without reading/decoding response data.
                    Default is True.
                _request_timeout (float/tuple): timeout setting for this request. If one
                    number provided, it will be total request timeout. It can also
                    be a pair (tuple) of (connection, read) timeouts.
                    Default is None.
                _check_input_type (bool): specifies if type checking
                    should be done one the data sent to the server.
                    Default is True.
                _check_return_type (bool): specifies if type checking
                    should be done one the data received from the server.
                    Default is True.
                _host_index (int/None): specifies the index of the server
                    that we want to use.
                    Default is read from the configuration.
                async_req (bool): execute request asynchronously

            Returns:
                AccountsGetResponse
                    If the method is called asynchronously, returns the request
                    thread.
            """
            kwargs['async_req'] = kwargs.get(
                'async_req', False
            )
            kwargs['_return_http_data_only'] = kwargs.get(
                '_return_http_data_only', True
            )
            kwargs['_preload_content'] = kwargs.get(
                '_preload_content', True
            )
            kwargs['_request_timeout'] = kwargs.get(
                '_request_timeout', None
            )
            kwargs['_check_input_type'] = kwargs.get(
                '_check_input_type', True
            )
            kwargs['_check_return_type'] = kwargs.get(
                '_check_return_type', True
            )
            kwargs['_host_index'] = kwargs.get('_host_index')
            kwargs['accounts_get_request'] = \
                accounts_get_request
            return self.call_with_http_info(**kwargs)

        self.accounts_get = _Endpoint(
            settings={
                'response_type': (AccountsGetResponse,),
                'auth': [
                    'clientId',
                    'plaidVersion',
                    'secret'
                ],
                'endpoint_path': '/accounts/get',
                'operation_id': 'accounts_get',
                'http_method': 'POST',
                'servers': None,
            },
            params_map={
                'all': [
                    'accounts_get_request',
                ],
                'required': [
                    'accounts_get_request',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'accounts_get_request':
                        (AccountsGetRequest,),
                },
                'attribute_map': {
                },
                'location_map': {
                    'accounts_get_request': 'body',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [
                    'application/json'
                ]
            },
            api_client=api_client,
            callable=__accounts_get
        )

        def __application_get(
            self,
            application_get_request,
            **kwargs
        ):
            """Retrieve information about a Plaid application  # noqa: E501

            Allows financial institutions to retrieve information about Plaid clients for the purpose of building control-tower experiences  # noqa: E501
            This method makes a synchronous HTTP request by default. To make an
            asynchronous HTTP request, please pass async_req=True

            >>> thread = api.application_get(application_get_request, async_req=True)
            >>> result = thread.get()

            Args:
                application_get_request (ApplicationGetRequest):

            Keyword Args:
                _return_http_data_only (bool): response data without head status
                    code and headers. Default is True.
                _preload_content (bool): if False, the urllib3.HTTPResponse object
                    will be returned without reading/decoding response data.
                    Default is True.
                _request_timeout (float/tuple): timeout setting for this request. If one
                    number provided, it will be total request timeout. It can also
                    be a pair (tuple) of (connection, read) timeouts.
                    Default is None.
                _check_input_type (bool): specifies if type checking
                    should be done one the data sent to the server.
                    Default is True.
                _check_return_type (bool): specifies if type checking
                    should be done one the data received from the server.
                    Default is True.
                _host_index (int/None): specifies the index of the server
                    that we want to use.
                    Default is read from the configuration.
                async_req (bool): execute request asynchronously

            Returns:
                ApplicationGetResponse
                    If the method is called asynchronously, returns the request
                    thread.
            """
            kwargs['async_req'] = kwargs.get(
                'async_req', False
            )
            kwargs['_return_http_data_only'] = kwargs.get(
                '_return_http_data_only', True
            )
            kwargs['_preload_content'] = kwargs.get(
                '_preload_content', True
            )
            kwargs['_request_timeout'] = kwargs.get(
                '_request_timeout', None
            )
            kwargs['_check_input_type'] = kwargs.get(
                '_check_input_type', True
            )
            kwargs['_check_return_type'] = kwargs.get(
                '_check_return_type', True
            )
            kwargs['_host_index'] = kwargs.get('_host_index')
            kwargs['application_get_request'] = \
                application_get_request
            return self.call_with_http_info(**kwargs)

        self.application_get = _Endpoint(
            settings={
                'response_type': (ApplicationGetResponse,),
                'auth': [
                    'clientId',
                    'plaidVersion',
                    'secret'
                ],
                'endpoint_path': '/application/get',
                'operation_id': 'application_get',
                'http_method': 'POST',
                'servers': None,
            },
            params_map={
                'all': [
                    'application_get_request',
                ],
                'required': [
                    'application_get_request',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'application_get_request':
                        (ApplicationGetRequest,),
                },
                'attribute_map': {
                },
                'location_map': {
                    'application_get_request': 'body',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [
                    'application/json'
                ]
            },
            api_client=api_client,
            callable=__application_get
        )

        def __asset_report_audit_copy_create(
            self,
            asset_report_audit_copy_create_request,
            **kwargs
        ):
            """Create Asset Report Audit Copy  # noqa: E501

            Plaid can provide an Audit Copy of any Asset Report directly to a participating third party on your behalf. For example, Plaid can supply an Audit Copy directly to Fannie Mae on your behalf if you participate in the Day 1 Certainty™ program. An Audit Copy contains the same underlying data as the Asset Report.  To grant access to an Audit Copy, use the `/asset_report/audit_copy/create` endpoint to create an `audit_copy_token` and then pass that token to the third party who needs access. Each third party has its own `auditor_id`, for example `fannie_mae`. You’ll need to create a separate Audit Copy for each third party to whom you want to grant access to the Report.  # noqa: E501
            This method makes a synchronous HTTP request by default. To make an
            asynchronous HTTP request, please pass async_req=True

            >>> thread = api.asset_report_audit_copy_create(asset_report_audit_copy_create_request, async_req=True)
            >>> result = thread.get()

            Args:
                asset_report_audit_copy_create_request (AssetReportAuditCopyCreateRequest):

            Keyword Args:
                _return_http_data_only (bool): response data without head status
                    code and headers. Default is True.
                _preload_content (bool): if False, the urllib3.HTTPResponse object
                    will be returned without reading/decoding response data.
                    Default is True.
                _request_timeout (float/tuple): timeout setting for this request. If one
                    number provided, it will be total request timeout. It can also
                    be a pair (tuple) of (connection, read) timeouts.
                    Default is None.
                _check_input_type (bool): specifies if type checking
                    should be done one the data sent to the server.
                    Default is True.
                _check_return_type (bool): specifies if type checking
                    should be done one the data received from the server.
                    Default is True.
                _host_index (int/None): specifies the index of the server
                    that we want to use.
                    Default is read from the configuration.
                async_req (bool): execute request asynchronously

            Returns:
                AssetReportAuditCopyCreateResponse
                    If the method is called asynchronously, returns the request
                    thread.
            """
            kwargs['async_req'] = kwargs.get(
                'async_req', False
            )
            kwargs['_return_http_data_only'] = kwargs.get(
                '_return_http_data_only', True
            )
            kwargs['_preload_content'] = kwargs.get(
                '_preload_content', True
            )
            kwargs['_request_timeout'] = kwargs.get(
                '_request_timeout', None
            )
            kwargs['_check_input_type'] = kwargs.get(
                '_check_input_type', True
            )
            kwargs['_check_return_type'] = kwargs.get(
                '_check_return_type', True
            )
            kwargs['_host_index'] = kwargs.get('_host_index')
            kwargs['asset_report_audit_copy_create_request'] = \
                asset_report_audit_copy_create_request
            return self.call_with_http_info(**kwargs)

        self.asset_report_audit_copy_create = _Endpoint(
            settings={
                'response_type': (AssetReportAuditCopyCreateResponse,),
                'auth': [
                    'clientId',
                    'plaidVersion',
                    'secret'
                ],
                'endpoint_path': '/asset_report/audit_copy/create',
                'operation_id': 'asset_report_audit_copy_create',
                'http_method': 'POST',
                'servers': None,
            },
            params_map={
                'all': [
                    'asset_report_audit_copy_create_request',
                ],
                'required': [
                    'asset_report_audit_copy_create_request',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'asset_report_audit_copy_create_request':
                        (AssetReportAuditCopyCreateRequest,),
                },
                'attribute_map': {
                },
                'location_map': {
                    'asset_report_audit_copy_create_request': 'body',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [
                    'application/json'
                ]
            },
            api_client=api_client,
            callable=__asset_report_audit_copy_create
        )

        def __asset_report_audit_copy_get(
            self,
            asset_report_audit_copy_get_request,
            **kwargs
        ):
            """Retrieve an Asset Report Audit Copy  # noqa: E501

            `/asset_report/audit_copy/get` allows auditors to get a copy of an Asset Report that was previously shared via the `/asset_report/audit_copy/create` endpoint.  The caller of `/asset_report/audit_copy/create` must provide the `audit_copy_token` to the auditor.  This token can then be used to call `/asset_report/audit_copy/create`.  # noqa: E501
            This method makes a synchronous HTTP request by default. To make an
            asynchronous HTTP request, please pass async_req=True

            >>> thread = api.asset_report_audit_copy_get(asset_report_audit_copy_get_request, async_req=True)
            >>> result = thread.get()

            Args:
                asset_report_audit_copy_get_request (AssetReportAuditCopyGetRequest):

            Keyword Args:
                _return_http_data_only (bool): response data without head status
                    code and headers. Default is True.
                _preload_content (bool): if False, the urllib3.HTTPResponse object
                    will be returned without reading/decoding response data.
                    Default is True.
                _request_timeout (float/tuple): timeout setting for this request. If one
                    number provided, it will be total request timeout. It can also
                    be a pair (tuple) of (connection, read) timeouts.
                    Default is None.
                _check_input_type (bool): specifies if type checking
                    should be done one the data sent to the server.
                    Default is True.
                _check_return_type (bool): specifies if type checking
                    should be done one the data received from the server.
                    Default is True.
                _host_index (int/None): specifies the index of the server
                    that we want to use.
                    Default is read from the configuration.
                async_req (bool): execute request asynchronously

            Returns:
                AssetReportGetResponse
                    If the method is called asynchronously, returns the request
                    thread.
            """
            kwargs['async_req'] = kwargs.get(
                'async_req', False
            )
            kwargs['_return_http_data_only'] = kwargs.get(
                '_return_http_data_only', True
            )
            kwargs['_preload_content'] = kwargs.get(
                '_preload_content', True
            )
            kwargs['_request_timeout'] = kwargs.get(
                '_request_timeout', None
            )
            kwargs['_check_input_type'] = kwargs.get(
                '_check_input_type', True
            )
            kwargs['_check_return_type'] = kwargs.get(
                '_check_return_type', True
            )
            kwargs['_host_index'] = kwargs.get('_host_index')
            kwargs['asset_report_audit_copy_get_request'] = \
                asset_report_audit_copy_get_request
            return self.call_with_http_info(**kwargs)

        self.asset_report_audit_copy_get = _Endpoint(
            settings={
                'response_type': (AssetReportGetResponse,),
                'auth': [
                    'clientId',
                    'plaidVersion',
                    'secret'
                ],
                'endpoint_path': '/asset_report/audit_copy/get',
                'operation_id': 'asset_report_audit_copy_get',
                'http_method': 'POST',
                'servers': None,
            },
            params_map={
                'all': [
                    'asset_report_audit_copy_get_request',
                ],
                'required': [
                    'asset_report_audit_copy_get_request',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'asset_report_audit_copy_get_request':
                        (AssetReportAuditCopyGetRequest,),
                },
                'attribute_map': {
                },
                'location_map': {
                    'asset_report_audit_copy_get_request': 'body',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [
                    'application/json'
                ]
            },
            api_client=api_client,
            callable=__asset_report_audit_copy_get
        )

        def __asset_report_audit_copy_remove(
            self,
            asset_report_audit_copy_remove_request,
            **kwargs
        ):
            """Remove Asset Report Audit Copy  # noqa: E501

            The `/asset_report/audit_copy/remove` endpoint allows you to remove an Audit Copy. Removing an Audit Copy invalidates the `audit_copy_token` associated with it, meaning both you and any third parties holding the token will no longer be able to use it to access Report data. Items associated with the Asset Report, the Asset Report itself and other Audit Copies of it are not affected and will remain accessible after removing the given Audit Copy.  # noqa: E501
            This method makes a synchronous HTTP request by default. To make an
            asynchronous HTTP request, please pass async_req=True

            >>> thread = api.asset_report_audit_copy_remove(asset_report_audit_copy_remove_request, async_req=True)
            >>> result = thread.get()

            Args:
                asset_report_audit_copy_remove_request (AssetReportAuditCopyRemoveRequest):

            Keyword Args:
                _return_http_data_only (bool): response data without head status
                    code and headers. Default is True.
                _preload_content (bool): if False, the urllib3.HTTPResponse object
                    will be returned without reading/decoding response data.
                    Default is True.
                _request_timeout (float/tuple): timeout setting for this request. If one
                    number provided, it will be total request timeout. It can also
                    be a pair (tuple) of (connection, read) timeouts.
                    Default is None.
                _check_input_type (bool): specifies if type checking
                    should be done one the data sent to the server.
                    Default is True.
                _check_return_type (bool): specifies if type checking
                    should be done one the data received from the server.
                    Default is True.
                _host_index (int/None): specifies the index of the server
                    that we want to use.
                    Default is read from the configuration.
                async_req (bool): execute request asynchronously

            Returns:
                AssetReportAuditCopyRemoveResponse
                    If the method is called asynchronously, returns the request
                    thread.
            """
            kwargs['async_req'] = kwargs.get(
                'async_req', False
            )
            kwargs['_return_http_data_only'] = kwargs.get(
                '_return_http_data_only', True
            )
            kwargs['_preload_content'] = kwargs.get(
                '_preload_content', True
            )
            kwargs['_request_timeout'] = kwargs.get(
                '_request_timeout', None
            )
            kwargs['_check_input_type'] = kwargs.get(
                '_check_input_type', True
            )
            kwargs['_check_return_type'] = kwargs.get(
                '_check_return_type', True
            )
            kwargs['_host_index'] = kwargs.get('_host_index')
            kwargs['asset_report_audit_copy_remove_request'] = \
                asset_report_audit_copy_remove_request
            return self.call_with_http_info(**kwargs)

        self.asset_report_audit_copy_remove = _Endpoint(
            settings={
                'response_type': (AssetReportAuditCopyRemoveResponse,),
                'auth': [
                    'clientId',
                    'plaidVersion',
                    'secret'
                ],
                'endpoint_path': '/asset_report/audit_copy/remove',
                'operation_id': 'asset_report_audit_copy_remove',
                'http_method': 'POST',
                'servers': None,
            },
            params_map={
                'all': [
                    'asset_report_audit_copy_remove_request',
                ],
                'required': [
                    'asset_report_audit_copy_remove_request',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'asset_report_audit_copy_remove_request':
                        (AssetReportAuditCopyRemoveRequest,),
                },
                'attribute_map': {
                },
                'location_map': {
                    'asset_report_audit_copy_remove_request': 'body',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [
                    'application/json'
                ]
            },
            api_client=api_client,
            callable=__asset_report_audit_copy_remove
        )

        def __asset_report_create(
            self,
            asset_report_create_request,
            **kwargs
        ):
            """Create an Asset Report  # noqa: E501

            The `/asset_report/create` endpoint initiates the process of creating an Asset Report, which can then be retrieved by passing the `asset_report_token` return value to the `/asset_report/get` or `/asset_report/pdf/get` endpoints.  The Asset Report takes some time to be created and is not available immediately after calling `/asset_report/create`. When the Asset Report is ready to be retrieved using `/asset_report/get` or `/asset_report/pdf/get`, Plaid will fire a `PRODUCT_READY` webhook. For full details of the webhook schema, see [Asset Report webhooks](https://plaid.com/docs/api/products/assets/#webhooks).  The `/asset_report/create` endpoint creates an Asset Report at a moment in time. Asset Reports are immutable. To get an updated Asset Report, use the `/asset_report/refresh` endpoint.  # noqa: E501
            This method makes a synchronous HTTP request by default. To make an
            asynchronous HTTP request, please pass async_req=True

            >>> thread = api.asset_report_create(asset_report_create_request, async_req=True)
            >>> result = thread.get()

            Args:
                asset_report_create_request (AssetReportCreateRequest):

            Keyword Args:
                _return_http_data_only (bool): response data without head status
                    code and headers. Default is True.
                _preload_content (bool): if False, the urllib3.HTTPResponse object
                    will be returned without reading/decoding response data.
                    Default is True.
                _request_timeout (float/tuple): timeout setting for this request. If one
                    number provided, it will be total request timeout. It can also
                    be a pair (tuple) of (connection, read) timeouts.
                    Default is None.
                _check_input_type (bool): specifies if type checking
                    should be done one the data sent to the server.
                    Default is True.
                _check_return_type (bool): specifies if type checking
                    should be done one the data received from the server.
                    Default is True.
                _host_index (int/None): specifies the index of the server
                    that we want to use.
                    Default is read from the configuration.
                async_req (bool): execute request asynchronously

            Returns:
                AssetReportCreateResponse
                    If the method is called asynchronously, returns the request
                    thread.
            """
            kwargs['async_req'] = kwargs.get(
                'async_req', False
            )
            kwargs['_return_http_data_only'] = kwargs.get(
                '_return_http_data_only', True
            )
            kwargs['_preload_content'] = kwargs.get(
                '_preload_content', True
            )
            kwargs['_request_timeout'] = kwargs.get(
                '_request_timeout', None
            )
            kwargs['_check_input_type'] = kwargs.get(
                '_check_input_type', True
            )
            kwargs['_check_return_type'] = kwargs.get(
                '_check_return_type', True
            )
            kwargs['_host_index'] = kwargs.get('_host_index')
            kwargs['asset_report_create_request'] = \
                asset_report_create_request
            return self.call_with_http_info(**kwargs)

        self.asset_report_create = _Endpoint(
            settings={
                'response_type': (AssetReportCreateResponse,),
                'auth': [
                    'clientId',
                    'plaidVersion',
                    'secret'
                ],
                'endpoint_path': '/asset_report/create',
                'operation_id': 'asset_report_create',
                'http_method': 'POST',
                'servers': None,
            },
            params_map={
                'all': [
                    'asset_report_create_request',
                ],
                'required': [
                    'asset_report_create_request',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'asset_report_create_request':
                        (AssetReportCreateRequest,),
                },
                'attribute_map': {
                },
                'location_map': {
                    'asset_report_create_request': 'body',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [
                    'application/json'
                ]
            },
            api_client=api_client,
            callable=__asset_report_create
        )

        def __asset_report_filter(
            self,
            asset_report_filter_request,
            **kwargs
        ):
            """Filter Asset Report  # noqa: E501

            By default, an Asset Report will contain all of the accounts on a given Item. In some cases, you may not want the Asset Report to contain all accounts. For example, you might have the end user choose which accounts are relevant in Link using the Account Select view, which you can enable in the dashboard. Or, you might always exclude certain account types or subtypes, which you can identify by using the `/accounts/get` endpoint. To narrow an Asset Report to only a subset of accounts, use the `/asset_report/filter` endpoint.  To exclude certain Accounts from an Asset Report, first use the `/asset_report/create` endpoint to create the report, then send the `asset_report_token` along with a list of `account_ids` to exclude to the `/asset_report/filter` endpoint, to create a new Asset Report which contains only a subset of the original Asset Report's data.  Because Asset Reports are immutable, calling `/asset_report/filter` does not alter the original Asset Report in any way; rather, `/asset_report/filter` creates a new Asset Report with a new token and id. Asset Reports created via `/asset_report/filter` do not contain new Asset data, and are not billed.  Plaid will fire a [`PRODUCT_READY`](https://plaid.com/docs/api/products/assets/#product_ready) webhook once generation of the filtered Asset Report has completed.  # noqa: E501
            This method makes a synchronous HTTP request by default. To make an
            asynchronous HTTP request, please pass async_req=True

            >>> thread = api.asset_report_filter(asset_report_filter_request, async_req=True)
            >>> result = thread.get()

            Args:
                asset_report_filter_request (AssetReportFilterRequest):

            Keyword Args:
                _return_http_data_only (bool): response data without head status
                    code and headers. Default is True.
                _preload_content (bool): if False, the urllib3.HTTPResponse object
                    will be returned without reading/decoding response data.
                    Default is True.
                _request_timeout (float/tuple): timeout setting for this request. If one
                    number provided, it will be total request timeout. It can also
                    be a pair (tuple) of (connection, read) timeouts.
                    Default is None.
                _check_input_type (bool): specifies if type checking
                    should be done one the data sent to the server.
                    Default is True.
                _check_return_type (bool): specifies if type checking
                    should be done one the data received from the server.
                    Default is True.
                _host_index (int/None): specifies the index of the server
                    that we want to use.
                    Default is read from the configuration.
                async_req (bool): execute request asynchronously

            Returns:
                AssetReportFilterResponse
                    If the method is called asynchronously, returns the request
                    thread.
            """
            kwargs['async_req'] = kwargs.get(
                'async_req', False
            )
            kwargs['_return_http_data_only'] = kwargs.get(
                '_return_http_data_only', True
            )
            kwargs['_preload_content'] = kwargs.get(
                '_preload_content', True
            )
            kwargs['_request_timeout'] = kwargs.get(
                '_request_timeout', None
            )
            kwargs['_check_input_type'] = kwargs.get(
                '_check_input_type', True
            )
            kwargs['_check_return_type'] = kwargs.get(
                '_check_return_type', True
            )
            kwargs['_host_index'] = kwargs.get('_host_index')
            kwargs['asset_report_filter_request'] = \
                asset_report_filter_request
            return self.call_with_http_info(**kwargs)

        self.asset_report_filter = _Endpoint(
            settings={
                'response_type': (AssetReportFilterResponse,),
                'auth': [
                    'clientId',
                    'plaidVersion',
                    'secret'
                ],
                'endpoint_path': '/asset_report/filter',
                'operation_id': 'asset_report_filter',
                'http_method': 'POST',
                'servers': None,
            },
            params_map={
                'all': [
                    'asset_report_filter_request',
                ],
                'required': [
                    'asset_report_filter_request',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'asset_report_filter_request':
                        (AssetReportFilterRequest,),
                },
                'attribute_map': {
                },
                'location_map': {
                    'asset_report_filter_request': 'body',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [
                    'application/json'
                ]
            },
            api_client=api_client,
            callable=__asset_report_filter
        )

        def __asset_report_get(
            self,
            asset_report_get_request,
            **kwargs
        ):
            """Retrieve an Asset Report  # noqa: E501

            The `/asset_report/get` endpoint retrieves the Asset Report in JSON format. Before calling `/asset_report/get`, you must first create the Asset Report using `/asset_report/create` (or filter an Asset Report using `/asset_report/filter`) and then wait for the [`PRODUCT_READY`](https://plaid.com/docs/api/products/assets/#product_ready) webhook to fire, indicating that the Report is ready to be retrieved.  By default, an Asset Report includes transaction descriptions as returned by the bank, as opposed to parsed and categorized by Plaid. You can also receive cleaned and categorized transactions, as well as additional insights like merchant name or location information. We call this an Asset Report with Insights. An Asset Report with Insights provides transaction category, location, and merchant information in addition to the transaction strings provided in a standard Asset Report.  To retrieve an Asset Report with Insights, call the `/asset_report/get` endpoint with `include_insights` set to `true`.  # noqa: E501
            This method makes a synchronous HTTP request by default. To make an
            asynchronous HTTP request, please pass async_req=True

            >>> thread = api.asset_report_get(asset_report_get_request, async_req=True)
            >>> result = thread.get()

            Args:
                asset_report_get_request (AssetReportGetRequest):

            Keyword Args:
                _return_http_data_only (bool): response data without head status
                    code and headers. Default is True.
                _preload_content (bool): if False, the urllib3.HTTPResponse object
                    will be returned without reading/decoding response data.
                    Default is True.
                _request_timeout (float/tuple): timeout setting for this request. If one
                    number provided, it will be total request timeout. It can also
                    be a pair (tuple) of (connection, read) timeouts.
                    Default is None.
                _check_input_type (bool): specifies if type checking
                    should be done one the data sent to the server.
                    Default is True.
                _check_return_type (bool): specifies if type checking
                    should be done one the data received from the server.
                    Default is True.
                _host_index (int/None): specifies the index of the server
                    that we want to use.
                    Default is read from the configuration.
                async_req (bool): execute request asynchronously

            Returns:
                AssetReportGetResponse
                    If the method is called asynchronously, returns the request
                    thread.
            """
            kwargs['async_req'] = kwargs.get(
                'async_req', False
            )
            kwargs['_return_http_data_only'] = kwargs.get(
                '_return_http_data_only', True
            )
            kwargs['_preload_content'] = kwargs.get(
                '_preload_content', True
            )
            kwargs['_request_timeout'] = kwargs.get(
                '_request_timeout', None
            )
            kwargs['_check_input_type'] = kwargs.get(
                '_check_input_type', True
            )
            kwargs['_check_return_type'] = kwargs.get(
                '_check_return_type', True
            )
            kwargs['_host_index'] = kwargs.get('_host_index')
            kwargs['asset_report_get_request'] = \
                asset_report_get_request
            return self.call_with_http_info(**kwargs)

        self.asset_report_get = _Endpoint(
            settings={
                'response_type': (AssetReportGetResponse,),
                'auth': [
                    'clientId',
                    'plaidVersion',
                    'secret'
                ],
                'endpoint_path': '/asset_report/get',
                'operation_id': 'asset_report_get',
                'http_method': 'POST',
                'servers': None,
            },
            params_map={
                'all': [
                    'asset_report_get_request',
                ],
                'required': [
                    'asset_report_get_request',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'asset_report_get_request':
                        (AssetReportGetRequest,),
                },
                'attribute_map': {
                },
                'location_map': {
                    'asset_report_get_request': 'body',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [
                    'application/json'
                ]
            },
            api_client=api_client,
            callable=__asset_report_get
        )

        def __asset_report_pdf_get(
            self,
            asset_report_pdf_get_request,
            **kwargs
        ):
            """Retrieve a PDF Asset Report  # noqa: E501

            The `/asset_report/pdf/get` endpoint retrieves the Asset Report in PDF format. Before calling `/asset_report/pdf/get`, you must first create the Asset Report using `/asset_report/create` (or filter an Asset Report using `/asset_report/filter`) and then wait for the [`PRODUCT_READY`](https://plaid.com/docs/api/products/assets/#product_ready) webhook to fire, indicating that the Report is ready to be retrieved.  The response to `/asset_report/pdf/get` is the PDF binary data. The `request_id`  is returned in the `Plaid-Request-ID` header.  [View a sample PDF Asset Report](https://plaid.com/documents/sample-asset-report.pdf).  # noqa: E501
            This method makes a synchronous HTTP request by default. To make an
            asynchronous HTTP request, please pass async_req=True

            >>> thread = api.asset_report_pdf_get(asset_report_pdf_get_request, async_req=True)
            >>> result = thread.get()

            Args:
                asset_report_pdf_get_request (AssetReportPDFGetRequest):

            Keyword Args:
                _return_http_data_only (bool): response data without head status
                    code and headers. Default is True.
                _preload_content (bool): if False, the urllib3.HTTPResponse object
                    will be returned without reading/decoding response data.
                    Default is True.
                _request_timeout (float/tuple): timeout setting for this request. If one
                    number provided, it will be total request timeout. It can also
                    be a pair (tuple) of (connection, read) timeouts.
                    Default is None.
                _check_input_type (bool): specifies if type checking
                    should be done one the data sent to the server.
                    Default is True.
                _check_return_type (bool): specifies if type checking
                    should be done one the data received from the server.
                    Default is True.
                _host_index (int/None): specifies the index of the server
                    that we want to use.
                    Default is read from the configuration.
                async_req (bool): execute request asynchronously

            Returns:
                file_type
                    If the method is called asynchronously, returns the request
                    thread.
            """
            kwargs['async_req'] = kwargs.get(
                'async_req', False
            )
            kwargs['_return_http_data_only'] = kwargs.get(
                '_return_http_data_only', True
            )
            kwargs['_preload_content'] = kwargs.get(
                '_preload_content', True
            )
            kwargs['_request_timeout'] = kwargs.get(
                '_request_timeout', None
            )
            kwargs['_check_input_type'] = kwargs.get(
                '_check_input_type', True
            )
            kwargs['_check_return_type'] = kwargs.get(
                '_check_return_type', True
            )
            kwargs['_host_index'] = kwargs.get('_host_index')
            kwargs['asset_report_pdf_get_request'] = \
                asset_report_pdf_get_request
            return self.call_with_http_info(**kwargs)

        self.asset_report_pdf_get = _Endpoint(
            settings={
                'response_type': (file_type,),
                'auth': [
                    'clientId',
                    'plaidVersion',
                    'secret'
                ],
                'endpoint_path': '/asset_report/pdf/get',
                'operation_id': 'asset_report_pdf_get',
                'http_method': 'POST',
                'servers': None,
            },
            params_map={
                'all': [
                    'asset_report_pdf_get_request',
                ],
                'required': [
                    'asset_report_pdf_get_request',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'asset_report_pdf_get_request':
                        (AssetReportPDFGetRequest,),
                },
                'attribute_map': {
                },
                'location_map': {
                    'asset_report_pdf_get_request': 'body',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/pdf'
                ],
                'content_type': [
                    'application/json'
                ]
            },
            api_client=api_client,
            callable=__asset_report_pdf_get
        )

        def __asset_report_refresh(
            self,
            asset_report_refresh_request,
            **kwargs
        ):
            """Refresh an Asset Report  # noqa: E501

            An Asset Report is an immutable snapshot of a user's assets. In order to \"refresh\" an Asset Report you created previously, you can use the `/asset_report/refresh` endpoint to create a new Asset Report based on the old one, but with the most recent data available.  The new Asset Report will contain the same Items as the original Report, as well as the same filters applied by any call to `/asset_report/filter`. By default, the new Asset Report will also use the same parameters you submitted with your original `/asset_report/create` request, but the original `days_requested` value and the values of any parameters in the `options` object can be overridden with new values. To change these arguments, simply supply new values for them in your request to `/asset_report/refresh`. Submit an empty string (\"\") for any previously-populated fields you would like set as empty.  # noqa: E501
            This method makes a synchronous HTTP request by default. To make an
            asynchronous HTTP request, please pass async_req=True

            >>> thread = api.asset_report_refresh(asset_report_refresh_request, async_req=True)
            >>> result = thread.get()

            Args:
                asset_report_refresh_request (AssetReportRefreshRequest):

            Keyword Args:
                _return_http_data_only (bool): response data without head status
                    code and headers. Default is True.
                _preload_content (bool): if False, the urllib3.HTTPResponse object
                    will be returned without reading/decoding response data.
                    Default is True.
                _request_timeout (float/tuple): timeout setting for this request. If one
                    number provided, it will be total request timeout. It can also
                    be a pair (tuple) of (connection, read) timeouts.
                    Default is None.
                _check_input_type (bool): specifies if type checking
                    should be done one the data sent to the server.
                    Default is True.
                _check_return_type (bool): specifies if type checking
                    should be done one the data received from the server.
                    Default is True.
                _host_index (int/None): specifies the index of the server
                    that we want to use.
                    Default is read from the configuration.
                async_req (bool): execute request asynchronously

            Returns:
                AssetReportRefreshResponse
                    If the method is called asynchronously, returns the request
                    thread.
            """
            kwargs['async_req'] = kwargs.get(
                'async_req', False
            )
            kwargs['_return_http_data_only'] = kwargs.get(
                '_return_http_data_only', True
            )
            kwargs['_preload_content'] = kwargs.get(
                '_preload_content', True
            )
            kwargs['_request_timeout'] = kwargs.get(
                '_request_timeout', None
            )
            kwargs['_check_input_type'] = kwargs.get(
                '_check_input_type', True
            )
            kwargs['_check_return_type'] = kwargs.get(
                '_check_return_type', True
            )
            kwargs['_host_index'] = kwargs.get('_host_index')
            kwargs['asset_report_refresh_request'] = \
                asset_report_refresh_request
            return self.call_with_http_info(**kwargs)

        self.asset_report_refresh = _Endpoint(
            settings={
                'response_type': (AssetReportRefreshResponse,),
                'auth': [
                    'clientId',
                    'plaidVersion',
                    'secret'
                ],
                'endpoint_path': '/asset_report/refresh',
                'operation_id': 'asset_report_refresh',
                'http_method': 'POST',
                'servers': None,
            },
            params_map={
                'all': [
                    'asset_report_refresh_request',
                ],
                'required': [
                    'asset_report_refresh_request',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'asset_report_refresh_request':
                        (AssetReportRefreshRequest,),
                },
                'attribute_map': {
                },
                'location_map': {
                    'asset_report_refresh_request': 'body',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [
                    'application/json'
                ]
            },
            api_client=api_client,
            callable=__asset_report_refresh
        )

        def __asset_report_relay_create(
            self,
            asset_report_relay_create_request,
            **kwargs
        ):
            """Create an `asset_relay_token` to share an Asset Report with a partner client  # noqa: E501

            Plaid can share an Asset Report directly with a participating third party on your behalf. The shared Asset Report is the exact same Asset Report originally created in `/asset_report/create`.  To grant access to an Asset Report to a third party, use the `/asset_report/relay/create` endpoint to create an `asset_relay_token` and then pass that token to the third party who needs access. Each third party has its own `secondary_client_id`, for example `ce5bd328dcd34123456`. You'll need to create a separate `asset_relay_token` for each third party to whom you want to grant access to the Report.  # noqa: E501
            This method makes a synchronous HTTP request by default. To make an
            asynchronous HTTP request, please pass async_req=True

            >>> thread = api.asset_report_relay_create(asset_report_relay_create_request, async_req=True)
            >>> result = thread.get()

            Args:
                asset_report_relay_create_request (AssetReportRelayCreateRequest):

            Keyword Args:
                _return_http_data_only (bool): response data without head status
                    code and headers. Default is True.
                _preload_content (bool): if False, the urllib3.HTTPResponse object
                    will be returned without reading/decoding response data.
                    Default is True.
                _request_timeout (float/tuple): timeout setting for this request. If one
                    number provided, it will be total request timeout. It can also
                    be a pair (tuple) of (connection, read) timeouts.
                    Default is None.
                _check_input_type (bool): specifies if type checking
                    should be done one the data sent to the server.
                    Default is True.
                _check_return_type (bool): specifies if type checking
                    should be done one the data received from the server.
                    Default is True.
                _host_index (int/None): specifies the index of the server
                    that we want to use.
                    Default is read from the configuration.
                async_req (bool): execute request asynchronously

            Returns:
                AssetReportRelayCreateResponse
                    If the method is called asynchronously, returns the request
                    thread.
            """
            kwargs['async_req'] = kwargs.get(
                'async_req', False
            )
            kwargs['_return_http_data_only'] = kwargs.get(
                '_return_http_data_only', True
            )
            kwargs['_preload_content'] = kwargs.get(
                '_preload_content', True
            )
            kwargs['_request_timeout'] = kwargs.get(
                '_request_timeout', None
            )
            kwargs['_check_input_type'] = kwargs.get(
                '_check_input_type', True
            )
            kwargs['_check_return_type'] = kwargs.get(
                '_check_return_type', True
            )
            kwargs['_host_index'] = kwargs.get('_host_index')
            kwargs['asset_report_relay_create_request'] = \
                asset_report_relay_create_request
            return self.call_with_http_info(**kwargs)

        self.asset_report_relay_create = _Endpoint(
            settings={
                'response_type': (AssetReportRelayCreateResponse,),
                'auth': [
                    'clientId',
                    'plaidVersion',
                    'secret'
                ],
                'endpoint_path': '/asset_report/relay/create',
                'operation_id': 'asset_report_relay_create',
                'http_method': 'POST',
                'servers': None,
            },
            params_map={
                'all': [
                    'asset_report_relay_create_request',
                ],
                'required': [
                    'asset_report_relay_create_request',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'asset_report_relay_create_request':
                        (AssetReportRelayCreateRequest,),
                },
                'attribute_map': {
                },
                'location_map': {
                    'asset_report_relay_create_request': 'body',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [
                    'application/json'
                ]
            },
            api_client=api_client,
            callable=__asset_report_relay_create
        )

        def __asset_report_relay_get(
            self,
            asset_report_relay_get_request,
            **kwargs
        ):
            """Retrieve an Asset Report that was shared with you  # noqa: E501

            `/asset_report/relay/get` allows third parties to get an Asset Report that was shared with them, using an `asset_relay_token` that was created by the report owner.  # noqa: E501
            This method makes a synchronous HTTP request by default. To make an
            asynchronous HTTP request, please pass async_req=True

            >>> thread = api.asset_report_relay_get(asset_report_relay_get_request, async_req=True)
            >>> result = thread.get()

            Args:
                asset_report_relay_get_request (AssetReportRelayGetRequest):

            Keyword Args:
                _return_http_data_only (bool): response data without head status
                    code and headers. Default is True.
                _preload_content (bool): if False, the urllib3.HTTPResponse object
                    will be returned without reading/decoding response data.
                    Default is True.
                _request_timeout (float/tuple): timeout setting for this request. If one
                    number provided, it will be total request timeout. It can also
                    be a pair (tuple) of (connection, read) timeouts.
                    Default is None.
                _check_input_type (bool): specifies if type checking
                    should be done one the data sent to the server.
                    Default is True.
                _check_return_type (bool): specifies if type checking
                    should be done one the data received from the server.
                    Default is True.
                _host_index (int/None): specifies the index of the server
                    that we want to use.
                    Default is read from the configuration.
                async_req (bool): execute request asynchronously

            Returns:
                AssetReportGetResponse
                    If the method is called asynchronously, returns the request
                    thread.
            """
            kwargs['async_req'] = kwargs.get(
                'async_req', False
            )
            kwargs['_return_http_data_only'] = kwargs.get(
                '_return_http_data_only', True
            )
            kwargs['_preload_content'] = kwargs.get(
                '_preload_content', True
            )
            kwargs['_request_timeout'] = kwargs.get(
                '_request_timeout', None
            )
            kwargs['_check_input_type'] = kwargs.get(
                '_check_input_type', True
            )
            kwargs['_check_return_type'] = kwargs.get(
                '_check_return_type', True
            )
            kwargs['_host_index'] = kwargs.get('_host_index')
            kwargs['asset_report_relay_get_request'] = \
                asset_report_relay_get_request
            return self.call_with_http_info(**kwargs)

        self.asset_report_relay_get = _Endpoint(
            settings={
                'response_type': (AssetReportGetResponse,),
                'auth': [
                    'clientId',
                    'plaidVersion',
                    'secret'
                ],
                'endpoint_path': '/asset_report/relay/get',
                'operation_id': 'asset_report_relay_get',
                'http_method': 'POST',
                'servers': None,
            },
            params_map={
                'all': [
                    'asset_report_relay_get_request',
                ],
                'required': [
                    'asset_report_relay_get_request',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'asset_report_relay_get_request':
                        (AssetReportRelayGetRequest,),
                },
                'attribute_map': {
                },
                'location_map': {
                    'asset_report_relay_get_request': 'body',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [
                    'application/json'
                ]
            },
            api_client=api_client,
            callable=__asset_report_relay_get
        )

        def __asset_report_relay_refresh(
            self,
            asset_report_relay_refresh_request,
            **kwargs
        ):
            """Refresh a Relay Token's Asset Report  # noqa: E501

            The `/asset_report/relay/refresh` endpoint allows third parties to refresh an Asset Report that was relayed to them, using an `asset_relay_token` that was created by the report owner. A new Asset Report will be created based on the old one, but with the most recent data available.  # noqa: E501
            This method makes a synchronous HTTP request by default. To make an
            asynchronous HTTP request, please pass async_req=True

            >>> thread = api.asset_report_relay_refresh(asset_report_relay_refresh_request, async_req=True)
            >>> result = thread.get()

            Args:
                asset_report_relay_refresh_request (AssetReportRelayRefreshRequest):

            Keyword Args:
                _return_http_data_only (bool): response data without head status
                    code and headers. Default is True.
                _preload_content (bool): if False, the urllib3.HTTPResponse object
                    will be returned without reading/decoding response data.
                    Default is True.
                _request_timeout (float/tuple): timeout setting for this request. If one
                    number provided, it will be total request timeout. It can also
                    be a pair (tuple) of (connection, read) timeouts.
                    Default is None.
                _check_input_type (bool): specifies if type checking
                    should be done one the data sent to the server.
                    Default is True.
                _check_return_type (bool): specifies if type checking
                    should be done one the data received from the server.
                    Default is True.
                _host_index (int/None): specifies the index of the server
                    that we want to use.
                    Default is read from the configuration.
                async_req (bool): execute request asynchronously

            Returns:
                AssetReportRelayRefreshResponse
                    If the method is called asynchronously, returns the request
                    thread.
            """
            kwargs['async_req'] = kwargs.get(
                'async_req', False
            )
            kwargs['_return_http_data_only'] = kwargs.get(
                '_return_http_data_only', True
            )
            kwargs['_preload_content'] = kwargs.get(
                '_preload_content', True
            )
            kwargs['_request_timeout'] = kwargs.get(
                '_request_timeout', None
            )
            kwargs['_check_input_type'] = kwargs.get(
                '_check_input_type', True
            )
            kwargs['_check_return_type'] = kwargs.get(
                '_check_return_type', True
            )
            kwargs['_host_index'] = kwargs.get('_host_index')
            kwargs['asset_report_relay_refresh_request'] = \
                asset_report_relay_refresh_request
            return self.call_with_http_info(**kwargs)

        self.asset_report_relay_refresh = _Endpoint(
            settings={
                'response_type': (AssetReportRelayRefreshResponse,),
                'auth': [
                    'clientId',
                    'plaidVersion',
                    'secret'
                ],
                'endpoint_path': '/asset_report/relay/refresh',
                'operation_id': 'asset_report_relay_refresh',
                'http_method': 'POST',
                'servers': None,
            },
            params_map={
                'all': [
                    'asset_report_relay_refresh_request',
                ],
                'required': [
                    'asset_report_relay_refresh_request',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'asset_report_relay_refresh_request':
                        (AssetReportRelayRefreshRequest,),
                },
                'attribute_map': {
                },
                'location_map': {
                    'asset_report_relay_refresh_request': 'body',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [
                    'application/json'
                ]
            },
            api_client=api_client,
            callable=__asset_report_relay_refresh
        )

        def __asset_report_relay_remove(
            self,
            asset_report_relay_remove_request,
            **kwargs
        ):
            """Remove Asset Report Relay Token  # noqa: E501

            The `/asset_report/relay/remove` endpoint allows you to invalidate an `asset_relay_token`, meaning the third party holding the token will no longer be able to use it to access the Asset Report to which the `asset_relay_token` gives access to. The Asset Report, Items associated with it, and other Asset Relay Tokens that provide access to the same Asset Report are not affected and will remain accessible after removing the given `asset_relay_token.  # noqa: E501
            This method makes a synchronous HTTP request by default. To make an
            asynchronous HTTP request, please pass async_req=True

            >>> thread = api.asset_report_relay_remove(asset_report_relay_remove_request, async_req=True)
            >>> result = thread.get()

            Args:
                asset_report_relay_remove_request (AssetReportRelayRemoveRequest):

            Keyword Args:
                _return_http_data_only (bool): response data without head status
                    code and headers. Default is True.
                _preload_content (bool): if False, the urllib3.HTTPResponse object
                    will be returned without reading/decoding response data.
                    Default is True.
                _request_timeout (float/tuple): timeout setting for this request. If one
                    number provided, it will be total request timeout. It can also
                    be a pair (tuple) of (connection, read) timeouts.
                    Default is None.
                _check_input_type (bool): specifies if type checking
                    should be done one the data sent to the server.
                    Default is True.
                _check_return_type (bool): specifies if type checking
                    should be done one the data received from the server.
                    Default is True.
                _host_index (int/None): specifies the index of the server
                    that we want to use.
                    Default is read from the configuration.
                async_req (bool): execute request asynchronously

            Returns:
                AssetReportRelayRemoveResponse
                    If the method is called asynchronously, returns the request
                    thread.
            """
            kwargs['async_req'] = kwargs.get(
                'async_req', False
            )
            kwargs['_return_http_data_only'] = kwargs.get(
                '_return_http_data_only', True
            )
            kwargs['_preload_content'] = kwargs.get(
                '_preload_content', True
            )
            kwargs['_request_timeout'] = kwargs.get(
                '_request_timeout', None
            )
            kwargs['_check_input_type'] = kwargs.get(
                '_check_input_type', True
            )
            kwargs['_check_return_type'] = kwargs.get(
                '_check_return_type', True
            )
            kwargs['_host_index'] = kwargs.get('_host_index')
            kwargs['asset_report_relay_remove_request'] = \
                asset_report_relay_remove_request
            return self.call_with_http_info(**kwargs)

        self.asset_report_relay_remove = _Endpoint(
            settings={
                'response_type': (AssetReportRelayRemoveResponse,),
                'auth': [
                    'clientId',
                    'plaidVersion',
                    'secret'
                ],
                'endpoint_path': '/asset_report/relay/remove',
                'operation_id': 'asset_report_relay_remove',
                'http_method': 'POST',
                'servers': None,
            },
            params_map={
                'all': [
                    'asset_report_relay_remove_request',
                ],
                'required': [
                    'asset_report_relay_remove_request',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'asset_report_relay_remove_request':
                        (AssetReportRelayRemoveRequest,),
                },
                'attribute_map': {
                },
                'location_map': {
                    'asset_report_relay_remove_request': 'body',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [
                    'application/json'
                ]
            },
            api_client=api_client,
            callable=__asset_report_relay_remove
        )

        def __asset_report_remove(
            self,
            asset_report_remove_request,
            **kwargs
        ):
            """Delete an Asset Report  # noqa: E501

            The `/item/remove` endpoint allows you to invalidate an `access_token`, meaning you will not be able to create new Asset Reports with it. Removing an Item does not affect any Asset Reports or Audit Copies you have already created, which will remain accessible until you remove them specifically.  The `/asset_report/remove` endpoint allows you to remove an Asset Report. Removing an Asset Report invalidates its `asset_report_token`, meaning you will no longer be able to use it to access Report data or create new Audit Copies. Removing an Asset Report does not affect the underlying Items, but does invalidate any `audit_copy_tokens` associated with the Asset Report.  # noqa: E501
            This method makes a synchronous HTTP request by default. To make an
            asynchronous HTTP request, please pass async_req=True

            >>> thread = api.asset_report_remove(asset_report_remove_request, async_req=True)
            >>> result = thread.get()

            Args:
                asset_report_remove_request (AssetReportRemoveRequest):

            Keyword Args:
                _return_http_data_only (bool): response data without head status
                    code and headers. Default is True.
                _preload_content (bool): if False, the urllib3.HTTPResponse object
                    will be returned without reading/decoding response data.
                    Default is True.
                _request_timeout (float/tuple): timeout setting for this request. If one
                    number provided, it will be total request timeout. It can also
                    be a pair (tuple) of (connection, read) timeouts.
                    Default is None.
                _check_input_type (bool): specifies if type checking
                    should be done one the data sent to the server.
                    Default is True.
                _check_return_type (bool): specifies if type checking
                    should be done one the data received from the server.
                    Default is True.
                _host_index (int/None): specifies the index of the server
                    that we want to use.
                    Default is read from the configuration.
                async_req (bool): execute request asynchronously

            Returns:
                AssetReportRemoveResponse
                    If the method is called asynchronously, returns the request
                    thread.
            """
            kwargs['async_req'] = kwargs.get(
                'async_req', False
            )
            kwargs['_return_http_data_only'] = kwargs.get(
                '_return_http_data_only', True
            )
            kwargs['_preload_content'] = kwargs.get(
                '_preload_content', True
            )
            kwargs['_request_timeout'] = kwargs.get(
                '_request_timeout', None
            )
            kwargs['_check_input_type'] = kwargs.get(
                '_check_input_type', True
            )
            kwargs['_check_return_type'] = kwargs.get(
                '_check_return_type', True
            )
            kwargs['_host_index'] = kwargs.get('_host_index')
            kwargs['asset_report_remove_request'] = \
                asset_report_remove_request
            return self.call_with_http_info(**kwargs)

        self.asset_report_remove = _Endpoint(
            settings={
                'response_type': (AssetReportRemoveResponse,),
                'auth': [
                    'clientId',
                    'plaidVersion',
                    'secret'
                ],
                'endpoint_path': '/asset_report/remove',
                'operation_id': 'asset_report_remove',
                'http_method': 'POST',
                'servers': None,
            },
            params_map={
                'all': [
                    'asset_report_remove_request',
                ],
                'required': [
                    'asset_report_remove_request',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'asset_report_remove_request':
                        (AssetReportRemoveRequest,),
                },
                'attribute_map': {
                },
                'location_map': {
                    'asset_report_remove_request': 'body',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [
                    'application/json'
                ]
            },
            api_client=api_client,
            callable=__asset_report_remove
        )

        def __auth_get(
            self,
            auth_get_request,
            **kwargs
        ):
            """Retrieve auth data  # noqa: E501

            The `/auth/get` endpoint returns the bank account and bank identification numbers (such as routing numbers, for US accounts) associated with an Item's checking and savings accounts, along with high-level account data and balances when available.  Note: This request may take some time to complete if `auth` was not specified as an initial product when creating the Item. This is because Plaid must communicate directly with the institution to retrieve the data.  Also note that `/auth/get` will not return data for any new accounts opened after the Item was created. To obtain data for new accounts, create a new Item.  Versioning note: In API version 2017-03-08, the schema of the `numbers` object returned by this endpoint is substantially different. For details, see [Plaid API versioning](https://plaid.com/docs/api/versioning/#version-2018-05-22).  # noqa: E501
            This method makes a synchronous HTTP request by default. To make an
            asynchronous HTTP request, please pass async_req=True

            >>> thread = api.auth_get(auth_get_request, async_req=True)
            >>> result = thread.get()

            Args:
                auth_get_request (AuthGetRequest):

            Keyword Args:
                _return_http_data_only (bool): response data without head status
                    code and headers. Default is True.
                _preload_content (bool): if False, the urllib3.HTTPResponse object
                    will be returned without reading/decoding response data.
                    Default is True.
                _request_timeout (float/tuple): timeout setting for this request. If one
                    number provided, it will be total request timeout. It can also
                    be a pair (tuple) of (connection, read) timeouts.
                    Default is None.
                _check_input_type (bool): specifies if type checking
                    should be done one the data sent to the server.
                    Default is True.
                _check_return_type (bool): specifies if type checking
                    should be done one the data received from the server.
                    Default is True.
                _host_index (int/None): specifies the index of the server
                    that we want to use.
                    Default is read from the configuration.
                async_req (bool): execute request asynchronously

            Returns:
                AuthGetResponse
                    If the method is called asynchronously, returns the request
                    thread.
            """
            kwargs['async_req'] = kwargs.get(
                'async_req', False
            )
            kwargs['_return_http_data_only'] = kwargs.get(
                '_return_http_data_only', True
            )
            kwargs['_preload_content'] = kwargs.get(
                '_preload_content', True
            )
            kwargs['_request_timeout'] = kwargs.get(
                '_request_timeout', None
            )
            kwargs['_check_input_type'] = kwargs.get(
                '_check_input_type', True
            )
            kwargs['_check_return_type'] = kwargs.get(
                '_check_return_type', True
            )
            kwargs['_host_index'] = kwargs.get('_host_index')
            kwargs['auth_get_request'] = \
                auth_get_request
            return self.call_with_http_info(**kwargs)

        self.auth_get = _Endpoint(
            settings={
                'response_type': (AuthGetResponse,),
                'auth': [
                    'clientId',
                    'plaidVersion',
                    'secret'
                ],
                'endpoint_path': '/auth/get',
                'operation_id': 'auth_get',
                'http_method': 'POST',
                'servers': None,
            },
            params_map={
                'all': [
                    'auth_get_request',
                ],
                'required': [
                    'auth_get_request',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'auth_get_request':
                        (AuthGetRequest,),
                },
                'attribute_map': {
                },
                'location_map': {
                    'auth_get_request': 'body',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [
                    'application/json'
                ]
            },
            api_client=api_client,
            callable=__auth_get
        )

        def __bank_transfer_balance_get(
            self,
            bank_transfer_balance_get_request,
            **kwargs
        ):
            """Get balance of your Bank Transfer account  # noqa: E501

            Use the `/bank_transfer/balance/get` endpoint to see the available balance in your bank transfer account. Debit transfers increase this balance once their status is posted. Credit transfers decrease this balance when they are created.  The transactable balance shows the amount in your account that you are able to use for transfers, and is essentially your available balance minus your minimum balance.  Note that this endpoint can only be used with FBO accounts, when using Bank Transfers in the Full Service configuration. It cannot be used on your own account when using Bank Transfers in the BTS Platform configuration.  # noqa: E501
            This method makes a synchronous HTTP request by default. To make an
            asynchronous HTTP request, please pass async_req=True

            >>> thread = api.bank_transfer_balance_get(bank_transfer_balance_get_request, async_req=True)
            >>> result = thread.get()

            Args:
                bank_transfer_balance_get_request (BankTransferBalanceGetRequest):

            Keyword Args:
                _return_http_data_only (bool): response data without head status
                    code and headers. Default is True.
                _preload_content (bool): if False, the urllib3.HTTPResponse object
                    will be returned without reading/decoding response data.
                    Default is True.
                _request_timeout (float/tuple): timeout setting for this request. If one
                    number provided, it will be total request timeout. It can also
                    be a pair (tuple) of (connection, read) timeouts.
                    Default is None.
                _check_input_type (bool): specifies if type checking
                    should be done one the data sent to the server.
                    Default is True.
                _check_return_type (bool): specifies if type checking
                    should be done one the data received from the server.
                    Default is True.
                _host_index (int/None): specifies the index of the server
                    that we want to use.
                    Default is read from the configuration.
                async_req (bool): execute request asynchronously

            Returns:
                BankTransferBalanceGetResponse
                    If the method is called asynchronously, returns the request
                    thread.
            """
            kwargs['async_req'] = kwargs.get(
                'async_req', False
            )
            kwargs['_return_http_data_only'] = kwargs.get(
                '_return_http_data_only', True
            )
            kwargs['_preload_content'] = kwargs.get(
                '_preload_content', True
            )
            kwargs['_request_timeout'] = kwargs.get(
                '_request_timeout', None
            )
            kwargs['_check_input_type'] = kwargs.get(
                '_check_input_type', True
            )
            kwargs['_check_return_type'] = kwargs.get(
                '_check_return_type', True
            )
            kwargs['_host_index'] = kwargs.get('_host_index')
            kwargs['bank_transfer_balance_get_request'] = \
                bank_transfer_balance_get_request
            return self.call_with_http_info(**kwargs)

        self.bank_transfer_balance_get = _Endpoint(
            settings={
                'response_type': (BankTransferBalanceGetResponse,),
                'auth': [
                    'clientId',
                    'plaidVersion',
                    'secret'
                ],
                'endpoint_path': '/bank_transfer/balance/get',
                'operation_id': 'bank_transfer_balance_get',
                'http_method': 'POST',
                'servers': None,
            },
            params_map={
                'all': [
                    'bank_transfer_balance_get_request',
                ],
                'required': [
                    'bank_transfer_balance_get_request',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'bank_transfer_balance_get_request':
                        (BankTransferBalanceGetRequest,),
                },
                'attribute_map': {
                },
                'location_map': {
                    'bank_transfer_balance_get_request': 'body',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [
                    'application/json'
                ]
            },
            api_client=api_client,
            callable=__bank_transfer_balance_get
        )

        def __bank_transfer_cancel(
            self,
            bank_transfer_cancel_request,
            **kwargs
        ):
            """Cancel a bank transfer  # noqa: E501

            Use the `/bank_transfer/cancel` endpoint to cancel a bank transfer.  A transfer is eligible for cancelation if the `cancellable` property returned by `/bank_transfer/get` is `true`.  # noqa: E501
            This method makes a synchronous HTTP request by default. To make an
            asynchronous HTTP request, please pass async_req=True

            >>> thread = api.bank_transfer_cancel(bank_transfer_cancel_request, async_req=True)
            >>> result = thread.get()

            Args:
                bank_transfer_cancel_request (BankTransferCancelRequest):

            Keyword Args:
                _return_http_data_only (bool): response data without head status
                    code and headers. Default is True.
                _preload_content (bool): if False, the urllib3.HTTPResponse object
                    will be returned without reading/decoding response data.
                    Default is True.
                _request_timeout (float/tuple): timeout setting for this request. If one
                    number provided, it will be total request timeout. It can also
                    be a pair (tuple) of (connection, read) timeouts.
                    Default is None.
                _check_input_type (bool): specifies if type checking
                    should be done one the data sent to the server.
                    Default is True.
                _check_return_type (bool): specifies if type checking
                    should be done one the data received from the server.
                    Default is True.
                _host_index (int/None): specifies the index of the server
                    that we want to use.
                    Default is read from the configuration.
                async_req (bool): execute request asynchronously

            Returns:
                BankTransferCancelResponse
                    If the method is called asynchronously, returns the request
                    thread.
            """
            kwargs['async_req'] = kwargs.get(
                'async_req', False
            )
            kwargs['_return_http_data_only'] = kwargs.get(
                '_return_http_data_only', True
            )
            kwargs['_preload_content'] = kwargs.get(
                '_preload_content', True
            )
            kwargs['_request_timeout'] = kwargs.get(
                '_request_timeout', None
            )
            kwargs['_check_input_type'] = kwargs.get(
                '_check_input_type', True
            )
            kwargs['_check_return_type'] = kwargs.get(
                '_check_return_type', True
            )
            kwargs['_host_index'] = kwargs.get('_host_index')
            kwargs['bank_transfer_cancel_request'] = \
                bank_transfer_cancel_request
            return self.call_with_http_info(**kwargs)

        self.bank_transfer_cancel = _Endpoint(
            settings={
                'response_type': (BankTransferCancelResponse,),
                'auth': [
                    'clientId',
                    'plaidVersion',
                    'secret'
                ],
                'endpoint_path': '/bank_transfer/cancel',
                'operation_id': 'bank_transfer_cancel',
                'http_method': 'POST',
                'servers': None,
            },
            params_map={
                'all': [
                    'bank_transfer_cancel_request',
                ],
                'required': [
                    'bank_transfer_cancel_request',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'bank_transfer_cancel_request':
                        (BankTransferCancelRequest,),
                },
                'attribute_map': {
                },
                'location_map': {
                    'bank_transfer_cancel_request': 'body',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [
                    'application/json'
                ]
            },
            api_client=api_client,
            callable=__bank_transfer_cancel
        )

        def __bank_transfer_create(
            self,
            bank_transfer_create_request,
            **kwargs
        ):
            """Create a bank transfer  # noqa: E501

            Use the `/bank_transfer/create` endpoint to initiate a new bank transfer.  # noqa: E501
            This method makes a synchronous HTTP request by default. To make an
            asynchronous HTTP request, please pass async_req=True

            >>> thread = api.bank_transfer_create(bank_transfer_create_request, async_req=True)
            >>> result = thread.get()

            Args:
                bank_transfer_create_request (BankTransferCreateRequest):

            Keyword Args:
                _return_http_data_only (bool): response data without head status
                    code and headers. Default is True.
                _preload_content (bool): if False, the urllib3.HTTPResponse object
                    will be returned without reading/decoding response data.
                    Default is True.
                _request_timeout (float/tuple): timeout setting for this request. If one
                    number provided, it will be total request timeout. It can also
                    be a pair (tuple) of (connection, read) timeouts.
                    Default is None.
                _check_input_type (bool): specifies if type checking
                    should be done one the data sent to the server.
                    Default is True.
                _check_return_type (bool): specifies if type checking
                    should be done one the data received from the server.
                    Default is True.
                _host_index (int/None): specifies the index of the server
                    that we want to use.
                    Default is read from the configuration.
                async_req (bool): execute request asynchronously

            Returns:
                BankTransferCreateResponse
                    If the method is called asynchronously, returns the request
                    thread.
            """
            kwargs['async_req'] = kwargs.get(
                'async_req', False
            )
            kwargs['_return_http_data_only'] = kwargs.get(
                '_return_http_data_only', True
            )
            kwargs['_preload_content'] = kwargs.get(
                '_preload_content', True
            )
            kwargs['_request_timeout'] = kwargs.get(
                '_request_timeout', None
            )
            kwargs['_check_input_type'] = kwargs.get(
                '_check_input_type', True
            )
            kwargs['_check_return_type'] = kwargs.get(
                '_check_return_type', True
            )
            kwargs['_host_index'] = kwargs.get('_host_index')
            kwargs['bank_transfer_create_request'] = \
                bank_transfer_create_request
            return self.call_with_http_info(**kwargs)

        self.bank_transfer_create = _Endpoint(
            settings={
                'response_type': (BankTransferCreateResponse,),
                'auth': [
                    'clientId',
                    'plaidVersion',
                    'secret'
                ],
                'endpoint_path': '/bank_transfer/create',
                'operation_id': 'bank_transfer_create',
                'http_method': 'POST',
                'servers': None,
            },
            params_map={
                'all': [
                    'bank_transfer_create_request',
                ],
                'required': [
                    'bank_transfer_create_request',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'bank_transfer_create_request':
                        (BankTransferCreateRequest,),
                },
                'attribute_map': {
                },
                'location_map': {
                    'bank_transfer_create_request': 'body',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [
                    'application/json'
                ]
            },
            api_client=api_client,
            callable=__bank_transfer_create
        )

        def __bank_transfer_event_list(
            self,
            bank_transfer_event_list_request,
            **kwargs
        ):
            """List bank transfer events  # noqa: E501

            Use the `/bank_transfer/event/list` endpoint to get a list of bank transfer events based on specified filter criteria.  # noqa: E501
            This method makes a synchronous HTTP request by default. To make an
            asynchronous HTTP request, please pass async_req=True

            >>> thread = api.bank_transfer_event_list(bank_transfer_event_list_request, async_req=True)
            >>> result = thread.get()

            Args:
                bank_transfer_event_list_request (BankTransferEventListRequest):

            Keyword Args:
                _return_http_data_only (bool): response data without head status
                    code and headers. Default is True.
                _preload_content (bool): if False, the urllib3.HTTPResponse object
                    will be returned without reading/decoding response data.
                    Default is True.
                _request_timeout (float/tuple): timeout setting for this request. If one
                    number provided, it will be total request timeout. It can also
                    be a pair (tuple) of (connection, read) timeouts.
                    Default is None.
                _check_input_type (bool): specifies if type checking
                    should be done one the data sent to the server.
                    Default is True.
                _check_return_type (bool): specifies if type checking
                    should be done one the data received from the server.
                    Default is True.
                _host_index (int/None): specifies the index of the server
                    that we want to use.
                    Default is read from the configuration.
                async_req (bool): execute request asynchronously

            Returns:
                BankTransferEventListResponse
                    If the method is called asynchronously, returns the request
                    thread.
            """
            kwargs['async_req'] = kwargs.get(
                'async_req', False
            )
            kwargs['_return_http_data_only'] = kwargs.get(
                '_return_http_data_only', True
            )
            kwargs['_preload_content'] = kwargs.get(
                '_preload_content', True
            )
            kwargs['_request_timeout'] = kwargs.get(
                '_request_timeout', None
            )
            kwargs['_check_input_type'] = kwargs.get(
                '_check_input_type', True
            )
            kwargs['_check_return_type'] = kwargs.get(
                '_check_return_type', True
            )
            kwargs['_host_index'] = kwargs.get('_host_index')
            kwargs['bank_transfer_event_list_request'] = \
                bank_transfer_event_list_request
            return self.call_with_http_info(**kwargs)

        self.bank_transfer_event_list = _Endpoint(
            settings={
                'response_type': (BankTransferEventListResponse,),
                'auth': [
                    'clientId',
                    'plaidVersion',
                    'secret'
                ],
                'endpoint_path': '/bank_transfer/event/list',
                'operation_id': 'bank_transfer_event_list',
                'http_method': 'POST',
                'servers': None,
            },
            params_map={
                'all': [
                    'bank_transfer_event_list_request',
                ],
                'required': [
                    'bank_transfer_event_list_request',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'bank_transfer_event_list_request':
                        (BankTransferEventListRequest,),
                },
                'attribute_map': {
                },
                'location_map': {
                    'bank_transfer_event_list_request': 'body',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [
                    'application/json'
                ]
            },
            api_client=api_client,
            callable=__bank_transfer_event_list
        )

        def __bank_transfer_event_sync(
            self,
            bank_transfer_event_sync_request,
            **kwargs
        ):
            """Sync bank transfer events  # noqa: E501

            `/bank_transfer/event/sync` allows you to request up to the next 25 bank transfer events that happened after a specific `event_id`. Use the `/bank_transfer/event/sync` endpoint to guarantee you have seen all bank transfer events.  # noqa: E501
            This method makes a synchronous HTTP request by default. To make an
            asynchronous HTTP request, please pass async_req=True

            >>> thread = api.bank_transfer_event_sync(bank_transfer_event_sync_request, async_req=True)
            >>> result = thread.get()

            Args:
                bank_transfer_event_sync_request (BankTransferEventSyncRequest):

            Keyword Args:
                _return_http_data_only (bool): response data without head status
                    code and headers. Default is True.
                _preload_content (bool): if False, the urllib3.HTTPResponse object
                    will be returned without reading/decoding response data.
                    Default is True.
                _request_timeout (float/tuple): timeout setting for this request. If one
                    number provided, it will be total request timeout. It can also
                    be a pair (tuple) of (connection, read) timeouts.
                    Default is None.
                _check_input_type (bool): specifies if type checking
                    should be done one the data sent to the server.
                    Default is True.
                _check_return_type (bool): specifies if type checking
                    should be done one the data received from the server.
                    Default is True.
                _host_index (int/None): specifies the index of the server
                    that we want to use.
                    Default is read from the configuration.
                async_req (bool): execute request asynchronously

            Returns:
                BankTransferEventSyncResponse
                    If the method is called asynchronously, returns the request
                    thread.
            """
            kwargs['async_req'] = kwargs.get(
                'async_req', False
            )
            kwargs['_return_http_data_only'] = kwargs.get(
                '_return_http_data_only', True
            )
            kwargs['_preload_content'] = kwargs.get(
                '_preload_content', True
            )
            kwargs['_request_timeout'] = kwargs.get(
                '_request_timeout', None
            )
            kwargs['_check_input_type'] = kwargs.get(
                '_check_input_type', True
            )
            kwargs['_check_return_type'] = kwargs.get(
                '_check_return_type', True
            )
            kwargs['_host_index'] = kwargs.get('_host_index')
            kwargs['bank_transfer_event_sync_request'] = \
                bank_transfer_event_sync_request
            return self.call_with_http_info(**kwargs)

        self.bank_transfer_event_sync = _Endpoint(
            settings={
                'response_type': (BankTransferEventSyncResponse,),
                'auth': [
                    'clientId',
                    'plaidVersion',
                    'secret'
                ],
                'endpoint_path': '/bank_transfer/event/sync',
                'operation_id': 'bank_transfer_event_sync',
                'http_method': 'POST',
                'servers': None,
            },
            params_map={
                'all': [
                    'bank_transfer_event_sync_request',
                ],
                'required': [
                    'bank_transfer_event_sync_request',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'bank_transfer_event_sync_request':
                        (BankTransferEventSyncRequest,),
                },
                'attribute_map': {
                },
                'location_map': {
                    'bank_transfer_event_sync_request': 'body',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [
                    'application/json'
                ]
            },
            api_client=api_client,
            callable=__bank_transfer_event_sync
        )

        def __bank_transfer_get(
            self,
            bank_transfer_get_request,
            **kwargs
        ):
            """Retrieve a bank transfer  # noqa: E501

            The `/bank_transfer/get` fetches information about the bank transfer corresponding to the given `bank_transfer_id`.  # noqa: E501
            This method makes a synchronous HTTP request by default. To make an
            asynchronous HTTP request, please pass async_req=True

            >>> thread = api.bank_transfer_get(bank_transfer_get_request, async_req=True)
            >>> result = thread.get()

            Args:
                bank_transfer_get_request (BankTransferGetRequest):

            Keyword Args:
                _return_http_data_only (bool): response data without head status
                    code and headers. Default is True.
                _preload_content (bool): if False, the urllib3.HTTPResponse object
                    will be returned without reading/decoding response data.
                    Default is True.
                _request_timeout (float/tuple): timeout setting for this request. If one
                    number provided, it will be total request timeout. It can also
                    be a pair (tuple) of (connection, read) timeouts.
                    Default is None.
                _check_input_type (bool): specifies if type checking
                    should be done one the data sent to the server.
                    Default is True.
                _check_return_type (bool): specifies if type checking
                    should be done one the data received from the server.
                    Default is True.
                _host_index (int/None): specifies the index of the server
                    that we want to use.
                    Default is read from the configuration.
                async_req (bool): execute request asynchronously

            Returns:
                BankTransferGetResponse
                    If the method is called asynchronously, returns the request
                    thread.
            """
            kwargs['async_req'] = kwargs.get(
                'async_req', False
            )
            kwargs['_return_http_data_only'] = kwargs.get(
                '_return_http_data_only', True
            )
            kwargs['_preload_content'] = kwargs.get(
                '_preload_content', True
            )
            kwargs['_request_timeout'] = kwargs.get(
                '_request_timeout', None
            )
            kwargs['_check_input_type'] = kwargs.get(
                '_check_input_type', True
            )
            kwargs['_check_return_type'] = kwargs.get(
                '_check_return_type', True
            )
            kwargs['_host_index'] = kwargs.get('_host_index')
            kwargs['bank_transfer_get_request'] = \
                bank_transfer_get_request
            return self.call_with_http_info(**kwargs)

        self.bank_transfer_get = _Endpoint(
            settings={
                'response_type': (BankTransferGetResponse,),
                'auth': [
                    'clientId',
                    'plaidVersion',
                    'secret'
                ],
                'endpoint_path': '/bank_transfer/get',
                'operation_id': 'bank_transfer_get',
                'http_method': 'POST',
                'servers': None,
            },
            params_map={
                'all': [
                    'bank_transfer_get_request',
                ],
                'required': [
                    'bank_transfer_get_request',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'bank_transfer_get_request':
                        (BankTransferGetRequest,),
                },
                'attribute_map': {
                },
                'location_map': {
                    'bank_transfer_get_request': 'body',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [
                    'application/json'
                ]
            },
            api_client=api_client,
            callable=__bank_transfer_get
        )

        def __bank_transfer_list(
            self,
            bank_transfer_list_request,
            **kwargs
        ):
            """List bank transfers  # noqa: E501

            Use the `/bank_transfer/list` endpoint to see a list of all your bank transfers and their statuses. Results are paginated; use the `count` and `offset` query parameters to retrieve the desired bank transfers.   # noqa: E501
            This method makes a synchronous HTTP request by default. To make an
            asynchronous HTTP request, please pass async_req=True

            >>> thread = api.bank_transfer_list(bank_transfer_list_request, async_req=True)
            >>> result = thread.get()

            Args:
                bank_transfer_list_request (BankTransferListRequest):

            Keyword Args:
                _return_http_data_only (bool): response data without head status
                    code and headers. Default is True.
                _preload_content (bool): if False, the urllib3.HTTPResponse object
                    will be returned without reading/decoding response data.
                    Default is True.
                _request_timeout (float/tuple): timeout setting for this request. If one
                    number provided, it will be total request timeout. It can also
                    be a pair (tuple) of (connection, read) timeouts.
                    Default is None.
                _check_input_type (bool): specifies if type checking
                    should be done one the data sent to the server.
                    Default is True.
                _check_return_type (bool): specifies if type checking
                    should be done one the data received from the server.
                    Default is True.
                _host_index (int/None): specifies the index of the server
                    that we want to use.
                    Default is read from the configuration.
                async_req (bool): execute request asynchronously

            Returns:
                BankTransferListResponse
                    If the method is called asynchronously, returns the request
                    thread.
            """
            kwargs['async_req'] = kwargs.get(
                'async_req', False
            )
            kwargs['_return_http_data_only'] = kwargs.get(
                '_return_http_data_only', True
            )
            kwargs['_preload_content'] = kwargs.get(
                '_preload_content', True
            )
            kwargs['_request_timeout'] = kwargs.get(
                '_request_timeout', None
            )
            kwargs['_check_input_type'] = kwargs.get(
                '_check_input_type', True
            )
            kwargs['_check_return_type'] = kwargs.get(
                '_check_return_type', True
            )
            kwargs['_host_index'] = kwargs.get('_host_index')
            kwargs['bank_transfer_list_request'] = \
                bank_transfer_list_request
            return self.call_with_http_info(**kwargs)

        self.bank_transfer_list = _Endpoint(
            settings={
                'response_type': (BankTransferListResponse,),
                'auth': [
                    'clientId',
                    'plaidVersion',
                    'secret'
                ],
                'endpoint_path': '/bank_transfer/list',
                'operation_id': 'bank_transfer_list',
                'http_method': 'POST',
                'servers': None,
            },
            params_map={
                'all': [
                    'bank_transfer_list_request',
                ],
                'required': [
                    'bank_transfer_list_request',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'bank_transfer_list_request':
                        (BankTransferListRequest,),
                },
                'attribute_map': {
                },
                'location_map': {
                    'bank_transfer_list_request': 'body',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [
                    'application/json'
                ]
            },
            api_client=api_client,
            callable=__bank_transfer_list
        )

        def __bank_transfer_migrate_account(
            self,
            bank_transfer_migrate_account_request,
            **kwargs
        ):
            """Migrate account into Bank Transfers  # noqa: E501

            As an alternative to adding Items via Link, you can also use the `/bank_transfer/migrate_account` endpoint to migrate known account and routing numbers to Plaid Items.  Note that Items created in this way are not compatible with endpoints for other products, such as `/accounts/balance/get`, and can only be used with Bank Transfer endpoints.  If you require access to other endpoints, create the Item through Link instead.  Access to `/bank_transfer/migrate_account` is not enabled by default; to obtain access, contact your Plaid Account Manager.  # noqa: E501
            This method makes a synchronous HTTP request by default. To make an
            asynchronous HTTP request, please pass async_req=True

            >>> thread = api.bank_transfer_migrate_account(bank_transfer_migrate_account_request, async_req=True)
            >>> result = thread.get()

            Args:
                bank_transfer_migrate_account_request (BankTransferMigrateAccountRequest):

            Keyword Args:
                _return_http_data_only (bool): response data without head status
                    code and headers. Default is True.
                _preload_content (bool): if False, the urllib3.HTTPResponse object
                    will be returned without reading/decoding response data.
                    Default is True.
                _request_timeout (float/tuple): timeout setting for this request. If one
                    number provided, it will be total request timeout. It can also
                    be a pair (tuple) of (connection, read) timeouts.
                    Default is None.
                _check_input_type (bool): specifies if type checking
                    should be done one the data sent to the server.
                    Default is True.
                _check_return_type (bool): specifies if type checking
                    should be done one the data received from the server.
                    Default is True.
                _host_index (int/None): specifies the index of the server
                    that we want to use.
                    Default is read from the configuration.
                async_req (bool): execute request asynchronously

            Returns:
                BankTransferMigrateAccountResponse
                    If the method is called asynchronously, returns the request
                    thread.
            """
            kwargs['async_req'] = kwargs.get(
                'async_req', False
            )
            kwargs['_return_http_data_only'] = kwargs.get(
                '_return_http_data_only', True
            )
            kwargs['_preload_content'] = kwargs.get(
                '_preload_content', True
            )
            kwargs['_request_timeout'] = kwargs.get(
                '_request_timeout', None
            )
            kwargs['_check_input_type'] = kwargs.get(
                '_check_input_type', True
            )
            kwargs['_check_return_type'] = kwargs.get(
                '_check_return_type', True
            )
            kwargs['_host_index'] = kwargs.get('_host_index')
            kwargs['bank_transfer_migrate_account_request'] = \
                bank_transfer_migrate_account_request
            return self.call_with_http_info(**kwargs)

        self.bank_transfer_migrate_account = _Endpoint(
            settings={
                'response_type': (BankTransferMigrateAccountResponse,),
                'auth': [
                    'clientId',
                    'plaidVersion',
                    'secret'
                ],
                'endpoint_path': '/bank_transfer/migrate_account',
                'operation_id': 'bank_transfer_migrate_account',
                'http_method': 'POST',
                'servers': None,
            },
            params_map={
                'all': [
                    'bank_transfer_migrate_account_request',
                ],
                'required': [
                    'bank_transfer_migrate_account_request',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'bank_transfer_migrate_account_request':
                        (BankTransferMigrateAccountRequest,),
                },
                'attribute_map': {
                },
                'location_map': {
                    'bank_transfer_migrate_account_request': 'body',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [
                    'application/json'
                ]
            },
            api_client=api_client,
            callable=__bank_transfer_migrate_account
        )

        def __bank_transfer_sweep_get(
            self,
            bank_transfer_sweep_get_request,
            **kwargs
        ):
            """Retrieve a sweep  # noqa: E501

            The `/bank_transfer/sweep/get` endpoint fetches information about the sweep corresponding to the given `sweep_id`.  # noqa: E501
            This method makes a synchronous HTTP request by default. To make an
            asynchronous HTTP request, please pass async_req=True

            >>> thread = api.bank_transfer_sweep_get(bank_transfer_sweep_get_request, async_req=True)
            >>> result = thread.get()

            Args:
                bank_transfer_sweep_get_request (BankTransferSweepGetRequest):

            Keyword Args:
                _return_http_data_only (bool): response data without head status
                    code and headers. Default is True.
                _preload_content (bool): if False, the urllib3.HTTPResponse object
                    will be returned without reading/decoding response data.
                    Default is True.
                _request_timeout (float/tuple): timeout setting for this request. If one
                    number provided, it will be total request timeout. It can also
                    be a pair (tuple) of (connection, read) timeouts.
                    Default is None.
                _check_input_type (bool): specifies if type checking
                    should be done one the data sent to the server.
                    Default is True.
                _check_return_type (bool): specifies if type checking
                    should be done one the data received from the server.
                    Default is True.
                _host_index (int/None): specifies the index of the server
                    that we want to use.
                    Default is read from the configuration.
                async_req (bool): execute request asynchronously

            Returns:
                BankTransferSweepGetResponse
                    If the method is called asynchronously, returns the request
                    thread.
            """
            kwargs['async_req'] = kwargs.get(
                'async_req', False
            )
            kwargs['_return_http_data_only'] = kwargs.get(
                '_return_http_data_only', True
            )
            kwargs['_preload_content'] = kwargs.get(
                '_preload_content', True
            )
            kwargs['_request_timeout'] = kwargs.get(
                '_request_timeout', None
            )
            kwargs['_check_input_type'] = kwargs.get(
                '_check_input_type', True
            )
            kwargs['_check_return_type'] = kwargs.get(
                '_check_return_type', True
            )
            kwargs['_host_index'] = kwargs.get('_host_index')
            kwargs['bank_transfer_sweep_get_request'] = \
                bank_transfer_sweep_get_request
            return self.call_with_http_info(**kwargs)

        self.bank_transfer_sweep_get = _Endpoint(
            settings={
                'response_type': (BankTransferSweepGetResponse,),
                'auth': [
                    'clientId',
                    'plaidVersion',
                    'secret'
                ],
                'endpoint_path': '/bank_transfer/sweep/get',
                'operation_id': 'bank_transfer_sweep_get',
                'http_method': 'POST',
                'servers': None,
            },
            params_map={
                'all': [
                    'bank_transfer_sweep_get_request',
                ],
                'required': [
                    'bank_transfer_sweep_get_request',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'bank_transfer_sweep_get_request':
                        (BankTransferSweepGetRequest,),
                },
                'attribute_map': {
                },
                'location_map': {
                    'bank_transfer_sweep_get_request': 'body',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [
                    'application/json'
                ]
            },
            api_client=api_client,
            callable=__bank_transfer_sweep_get
        )

        def __bank_transfer_sweep_list(
            self,
            bank_transfer_sweep_list_request,
            **kwargs
        ):
            """List sweeps  # noqa: E501

            The `/bank_transfer/sweep/list` endpoint fetches information about the sweeps matching the given filters.  # noqa: E501
            This method makes a synchronous HTTP request by default. To make an
            asynchronous HTTP request, please pass async_req=True

            >>> thread = api.bank_transfer_sweep_list(bank_transfer_sweep_list_request, async_req=True)
            >>> result = thread.get()

            Args:
                bank_transfer_sweep_list_request (BankTransferSweepListRequest):

            Keyword Args:
                _return_http_data_only (bool): response data without head status
                    code and headers. Default is True.
                _preload_content (bool): if False, the urllib3.HTTPResponse object
                    will be returned without reading/decoding response data.
                    Default is True.
                _request_timeout (float/tuple): timeout setting for this request. If one
                    number provided, it will be total request timeout. It can also
                    be a pair (tuple) of (connection, read) timeouts.
                    Default is None.
                _check_input_type (bool): specifies if type checking
                    should be done one the data sent to the server.
                    Default is True.
                _check_return_type (bool): specifies if type checking
                    should be done one the data received from the server.
                    Default is True.
                _host_index (int/None): specifies the index of the server
                    that we want to use.
                    Default is read from the configuration.
                async_req (bool): execute request asynchronously

            Returns:
                BankTransferSweepListResponse
                    If the method is called asynchronously, returns the request
                    thread.
            """
            kwargs['async_req'] = kwargs.get(
                'async_req', False
            )
            kwargs['_return_http_data_only'] = kwargs.get(
                '_return_http_data_only', True
            )
            kwargs['_preload_content'] = kwargs.get(
                '_preload_content', True
            )
            kwargs['_request_timeout'] = kwargs.get(
                '_request_timeout', None
            )
            kwargs['_check_input_type'] = kwargs.get(
                '_check_input_type', True
            )
            kwargs['_check_return_type'] = kwargs.get(
                '_check_return_type', True
            )
            kwargs['_host_index'] = kwargs.get('_host_index')
            kwargs['bank_transfer_sweep_list_request'] = \
                bank_transfer_sweep_list_request
            return self.call_with_http_info(**kwargs)

        self.bank_transfer_sweep_list = _Endpoint(
            settings={
                'response_type': (BankTransferSweepListResponse,),
                'auth': [
                    'clientId',
                    'plaidVersion',
                    'secret'
                ],
                'endpoint_path': '/bank_transfer/sweep/list',
                'operation_id': 'bank_transfer_sweep_list',
                'http_method': 'POST',
                'servers': None,
            },
            params_map={
                'all': [
                    'bank_transfer_sweep_list_request',
                ],
                'required': [
                    'bank_transfer_sweep_list_request',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'bank_transfer_sweep_list_request':
                        (BankTransferSweepListRequest,),
                },
                'attribute_map': {
                },
                'location_map': {
                    'bank_transfer_sweep_list_request': 'body',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [
                    'application/json'
                ]
            },
            api_client=api_client,
            callable=__bank_transfer_sweep_list
        )

        def __categories_get(
            self,
            body,
            **kwargs
        ):
            """Get Categories  # noqa: E501

            Send a request to the `/categories/get` endpoint to get detailed information on categories returned by Plaid. This endpoint does not require authentication.  # noqa: E501
            This method makes a synchronous HTTP request by default. To make an
            asynchronous HTTP request, please pass async_req=True

            >>> thread = api.categories_get(body, async_req=True)
            >>> result = thread.get()

            Args:
                body ({str: (bool, date, datetime, dict, float, int, list, str, none_type)}):

            Keyword Args:
                _return_http_data_only (bool): response data without head status
                    code and headers. Default is True.
                _preload_content (bool): if False, the urllib3.HTTPResponse object
                    will be returned without reading/decoding response data.
                    Default is True.
                _request_timeout (float/tuple): timeout setting for this request. If one
                    number provided, it will be total request timeout. It can also
                    be a pair (tuple) of (connection, read) timeouts.
                    Default is None.
                _check_input_type (bool): specifies if type checking
                    should be done one the data sent to the server.
                    Default is True.
                _check_return_type (bool): specifies if type checking
                    should be done one the data received from the server.
                    Default is True.
                _host_index (int/None): specifies the index of the server
                    that we want to use.
                    Default is read from the configuration.
                async_req (bool): execute request asynchronously

            Returns:
                CategoriesGetResponse
                    If the method is called asynchronously, returns the request
                    thread.
            """
            kwargs['async_req'] = kwargs.get(
                'async_req', False
            )
            kwargs['_return_http_data_only'] = kwargs.get(
                '_return_http_data_only', True
            )
            kwargs['_preload_content'] = kwargs.get(
                '_preload_content', True
            )
            kwargs['_request_timeout'] = kwargs.get(
                '_request_timeout', None
            )
            kwargs['_check_input_type'] = kwargs.get(
                '_check_input_type', True
            )
            kwargs['_check_return_type'] = kwargs.get(
                '_check_return_type', True
            )
            kwargs['_host_index'] = kwargs.get('_host_index')
            kwargs['body'] = \
                body
            return self.call_with_http_info(**kwargs)

        self.categories_get = _Endpoint(
            settings={
                'response_type': (CategoriesGetResponse,),
                'auth': [],
                'endpoint_path': '/categories/get',
                'operation_id': 'categories_get',
                'http_method': 'POST',
                'servers': None,
            },
            params_map={
                'all': [
                    'body',
                ],
                'required': [
                    'body',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'body':
                        ({str: (bool, date, datetime, dict, float, int, list, str, none_type)},),
                },
                'attribute_map': {
                },
                'location_map': {
                    'body': 'body',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [
                    'application/json'
                ]
            },
            api_client=api_client,
            callable=__categories_get
        )

        def __create_payment_token(
            self,
            payment_initiation_payment_token_create_request,
            **kwargs
        ):
            """Create payment token  # noqa: E501

            The `/payment_initiation/payment/token/create` endpoint has been deprecated. New Plaid customers will be unable to use this endpoint, and existing customers are encouraged to migrate to the newer, `link_token`-based flow. The recommended flow is to provide the `payment_id` to `/link/token/create`, which returns a `link_token` used to initialize Link.  The `/payment_initiation/payment/token/create` is used to create a `payment_token`, which can then be used in Link initialization to enter a payment initiation flow. You can only use a `payment_token` once. If this attempt fails, the end user aborts the flow, or the token expires, you will need to create a new payment token. Creating a new payment token does not require end user input.  # noqa: E501
            This method makes a synchronous HTTP request by default. To make an
            asynchronous HTTP request, please pass async_req=True

            >>> thread = api.create_payment_token(payment_initiation_payment_token_create_request, async_req=True)
            >>> result = thread.get()

            Args:
                payment_initiation_payment_token_create_request (PaymentInitiationPaymentTokenCreateRequest):

            Keyword Args:
                _return_http_data_only (bool): response data without head status
                    code and headers. Default is True.
                _preload_content (bool): if False, the urllib3.HTTPResponse object
                    will be returned without reading/decoding response data.
                    Default is True.
                _request_timeout (float/tuple): timeout setting for this request. If one
                    number provided, it will be total request timeout. It can also
                    be a pair (tuple) of (connection, read) timeouts.
                    Default is None.
                _check_input_type (bool): specifies if type checking
                    should be done one the data sent to the server.
                    Default is True.
                _check_return_type (bool): specifies if type checking
                    should be done one the data received from the server.
                    Default is True.
                _host_index (int/None): specifies the index of the server
                    that we want to use.
                    Default is read from the configuration.
                async_req (bool): execute request asynchronously

            Returns:
                PaymentInitiationPaymentTokenCreateResponse
                    If the method is called asynchronously, returns the request
                    thread.
            """
            kwargs['async_req'] = kwargs.get(
                'async_req', False
            )
            kwargs['_return_http_data_only'] = kwargs.get(
                '_return_http_data_only', True
            )
            kwargs['_preload_content'] = kwargs.get(
                '_preload_content', True
            )
            kwargs['_request_timeout'] = kwargs.get(
                '_request_timeout', None
            )
            kwargs['_check_input_type'] = kwargs.get(
                '_check_input_type', True
            )
            kwargs['_check_return_type'] = kwargs.get(
                '_check_return_type', True
            )
            kwargs['_host_index'] = kwargs.get('_host_index')
            kwargs['payment_initiation_payment_token_create_request'] = \
                payment_initiation_payment_token_create_request
            return self.call_with_http_info(**kwargs)

        self.create_payment_token = _Endpoint(
            settings={
                'response_type': (PaymentInitiationPaymentTokenCreateResponse,),
                'auth': [
                    'clientId',
                    'plaidVersion',
                    'secret'
                ],
                'endpoint_path': '/payment_initiation/payment/token/create',
                'operation_id': 'create_payment_token',
                'http_method': 'POST',
                'servers': None,
            },
            params_map={
                'all': [
                    'payment_initiation_payment_token_create_request',
                ],
                'required': [
                    'payment_initiation_payment_token_create_request',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'payment_initiation_payment_token_create_request':
                        (PaymentInitiationPaymentTokenCreateRequest,),
                },
                'attribute_map': {
                },
                'location_map': {
                    'payment_initiation_payment_token_create_request': 'body',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [
                    'application/json'
                ]
            },
            api_client=api_client,
            callable=__create_payment_token
        )

        def __credit_audit_copy_token_create(
            self,
            credit_audit_copy_token_create_request,
            **kwargs
        ):
            """Create Asset or Income Report Audit Copy Token  # noqa: E501

            Plaid can provide an Audit Copy token of an Asset Report and/or Income Report directly to a participating third party on your behalf. For example, Plaid can supply an Audit Copy token directly to Fannie Mae on your behalf if you participate in the Day 1 Certainty™ program. An Audit Copy token contains the same underlying data as the Asset Report and/or Income Report (result of /credit/payroll_income/get).  To grant access to an Audit Copy token, use the `/credit/audit_copy_token/create` endpoint to create an `audit_copy_token` and then pass that token to the third party who needs access. Each third party has its own `auditor_id`, for example `fannie_mae`. You’ll need to create a separate Audit Copy for each third party to whom you want to grant access to the Report.  # noqa: E501
            This method makes a synchronous HTTP request by default. To make an
            asynchronous HTTP request, please pass async_req=True

            >>> thread = api.credit_audit_copy_token_create(credit_audit_copy_token_create_request, async_req=True)
            >>> result = thread.get()

            Args:
                credit_audit_copy_token_create_request (CreditAuditCopyTokenCreateRequest):

            Keyword Args:
                _return_http_data_only (bool): response data without head status
                    code and headers. Default is True.
                _preload_content (bool): if False, the urllib3.HTTPResponse object
                    will be returned without reading/decoding response data.
                    Default is True.
                _request_timeout (float/tuple): timeout setting for this request. If one
                    number provided, it will be total request timeout. It can also
                    be a pair (tuple) of (connection, read) timeouts.
                    Default is None.
                _check_input_type (bool): specifies if type checking
                    should be done one the data sent to the server.
                    Default is True.
                _check_return_type (bool): specifies if type checking
                    should be done one the data received from the server.
                    Default is True.
                _host_index (int/None): specifies the index of the server
                    that we want to use.
                    Default is read from the configuration.
                async_req (bool): execute request asynchronously

            Returns:
                CreditAuditCopyTokenCreateResponse
                    If the method is called asynchronously, returns the request
                    thread.
            """
            kwargs['async_req'] = kwargs.get(
                'async_req', False
            )
            kwargs['_return_http_data_only'] = kwargs.get(
                '_return_http_data_only', True
            )
            kwargs['_preload_content'] = kwargs.get(
                '_preload_content', True
            )
            kwargs['_request_timeout'] = kwargs.get(
                '_request_timeout', None
            )
            kwargs['_check_input_type'] = kwargs.get(
                '_check_input_type', True
            )
            kwargs['_check_return_type'] = kwargs.get(
                '_check_return_type', True
            )
            kwargs['_host_index'] = kwargs.get('_host_index')
            kwargs['credit_audit_copy_token_create_request'] = \
                credit_audit_copy_token_create_request
            return self.call_with_http_info(**kwargs)

        self.credit_audit_copy_token_create = _Endpoint(
            settings={
                'response_type': (CreditAuditCopyTokenCreateResponse,),
                'auth': [
                    'clientId',
                    'plaidVersion',
                    'secret'
                ],
                'endpoint_path': '/credit/audit_copy_token/create',
                'operation_id': 'credit_audit_copy_token_create',
                'http_method': 'POST',
                'servers': None,
            },
            params_map={
                'all': [
                    'credit_audit_copy_token_create_request',
                ],
                'required': [
                    'credit_audit_copy_token_create_request',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'credit_audit_copy_token_create_request':
                        (CreditAuditCopyTokenCreateRequest,),
                },
                'attribute_map': {
                },
                'location_map': {
                    'credit_audit_copy_token_create_request': 'body',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [
                    'application/json'
                ]
            },
            api_client=api_client,
            callable=__credit_audit_copy_token_create
        )

        def __credit_bank_income_get(
            self,
            credit_bank_income_get_request,
            **kwargs
        ):
            """Retrieve information from the bank accounts used for income verification  # noqa: E501

            `/credit/bank_income/get` returns the bank income report(s) for a specified user.  # noqa: E501
            This method makes a synchronous HTTP request by default. To make an
            asynchronous HTTP request, please pass async_req=True

            >>> thread = api.credit_bank_income_get(credit_bank_income_get_request, async_req=True)
            >>> result = thread.get()

            Args:
                credit_bank_income_get_request (CreditBankIncomeGetRequest):

            Keyword Args:
                _return_http_data_only (bool): response data without head status
                    code and headers. Default is True.
                _preload_content (bool): if False, the urllib3.HTTPResponse object
                    will be returned without reading/decoding response data.
                    Default is True.
                _request_timeout (float/tuple): timeout setting for this request. If one
                    number provided, it will be total request timeout. It can also
                    be a pair (tuple) of (connection, read) timeouts.
                    Default is None.
                _check_input_type (bool): specifies if type checking
                    should be done one the data sent to the server.
                    Default is True.
                _check_return_type (bool): specifies if type checking
                    should be done one the data received from the server.
                    Default is True.
                _host_index (int/None): specifies the index of the server
                    that we want to use.
                    Default is read from the configuration.
                async_req (bool): execute request asynchronously

            Returns:
                CreditBankIncomeGetResponse
                    If the method is called asynchronously, returns the request
                    thread.
            """
            kwargs['async_req'] = kwargs.get(
                'async_req', False
            )
            kwargs['_return_http_data_only'] = kwargs.get(
                '_return_http_data_only', True
            )
            kwargs['_preload_content'] = kwargs.get(
                '_preload_content', True
            )
            kwargs['_request_timeout'] = kwargs.get(
                '_request_timeout', None
            )
            kwargs['_check_input_type'] = kwargs.get(
                '_check_input_type', True
            )
            kwargs['_check_return_type'] = kwargs.get(
                '_check_return_type', True
            )
            kwargs['_host_index'] = kwargs.get('_host_index')
            kwargs['credit_bank_income_get_request'] = \
                credit_bank_income_get_request
            return self.call_with_http_info(**kwargs)

        self.credit_bank_income_get = _Endpoint(
            settings={
                'response_type': (CreditBankIncomeGetResponse,),
                'auth': [
                    'clientId',
                    'plaidVersion',
                    'secret'
                ],
                'endpoint_path': '/credit/bank_income/get',
                'operation_id': 'credit_bank_income_get',
                'http_method': 'POST',
                'servers': None,
            },
            params_map={
                'all': [
                    'credit_bank_income_get_request',
                ],
                'required': [
                    'credit_bank_income_get_request',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'credit_bank_income_get_request':
                        (CreditBankIncomeGetRequest,),
                },
                'attribute_map': {
                },
                'location_map': {
                    'credit_bank_income_get_request': 'body',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [
                    'application/json'
                ]
            },
            api_client=api_client,
            callable=__credit_bank_income_get
        )

        def __credit_bank_income_refresh(
            self,
            credit_bank_income_refresh_request,
            **kwargs
        ):
            """Refresh a user's bank income information  # noqa: E501

            `/credit/bank_income/refresh` refreshes the bank income report data for a specific user.  # noqa: E501
            This method makes a synchronous HTTP request by default. To make an
            asynchronous HTTP request, please pass async_req=True

            >>> thread = api.credit_bank_income_refresh(credit_bank_income_refresh_request, async_req=True)
            >>> result = thread.get()

            Args:
                credit_bank_income_refresh_request (CreditBankIncomeRefreshRequest):

            Keyword Args:
                _return_http_data_only (bool): response data without head status
                    code and headers. Default is True.
                _preload_content (bool): if False, the urllib3.HTTPResponse object
                    will be returned without reading/decoding response data.
                    Default is True.
                _request_timeout (float/tuple): timeout setting for this request. If one
                    number provided, it will be total request timeout. It can also
                    be a pair (tuple) of (connection, read) timeouts.
                    Default is None.
                _check_input_type (bool): specifies if type checking
                    should be done one the data sent to the server.
                    Default is True.
                _check_return_type (bool): specifies if type checking
                    should be done one the data received from the server.
                    Default is True.
                _host_index (int/None): specifies the index of the server
                    that we want to use.
                    Default is read from the configuration.
                async_req (bool): execute request asynchronously

            Returns:
                CreditBankIncomeRefreshResponse
                    If the method is called asynchronously, returns the request
                    thread.
            """
            kwargs['async_req'] = kwargs.get(
                'async_req', False
            )
            kwargs['_return_http_data_only'] = kwargs.get(
                '_return_http_data_only', True
            )
            kwargs['_preload_content'] = kwargs.get(
                '_preload_content', True
            )
            kwargs['_request_timeout'] = kwargs.get(
                '_request_timeout', None
            )
            kwargs['_check_input_type'] = kwargs.get(
                '_check_input_type', True
            )
            kwargs['_check_return_type'] = kwargs.get(
                '_check_return_type', True
            )
            kwargs['_host_index'] = kwargs.get('_host_index')
            kwargs['credit_bank_income_refresh_request'] = \
                credit_bank_income_refresh_request
            return self.call_with_http_info(**kwargs)

        self.credit_bank_income_refresh = _Endpoint(
            settings={
                'response_type': (CreditBankIncomeRefreshResponse,),
                'auth': [
                    'clientId',
                    'plaidVersion',
                    'secret'
                ],
                'endpoint_path': '/credit/bank_income/refresh',
                'operation_id': 'credit_bank_income_refresh',
                'http_method': 'POST',
                'servers': None,
            },
            params_map={
                'all': [
                    'credit_bank_income_refresh_request',
                ],
                'required': [
                    'credit_bank_income_refresh_request',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'credit_bank_income_refresh_request':
                        (CreditBankIncomeRefreshRequest,),
                },
                'attribute_map': {
                },
                'location_map': {
                    'credit_bank_income_refresh_request': 'body',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [
                    'application/json'
                ]
            },
            api_client=api_client,
            callable=__credit_bank_income_refresh
        )

        def __credit_employment_get(
            self,
            credit_employment_get_request,
            **kwargs
        ):
            """Retrieve a summary of an individual's employment information  # noqa: E501

            `/credit/employment/get` returns a list of items with employment information from a user's payroll provider that was verified by an end user.  # noqa: E501
            This method makes a synchronous HTTP request by default. To make an
            asynchronous HTTP request, please pass async_req=True

            >>> thread = api.credit_employment_get(credit_employment_get_request, async_req=True)
            >>> result = thread.get()

            Args:
                credit_employment_get_request (CreditEmploymentGetRequest):

            Keyword Args:
                _return_http_data_only (bool): response data without head status
                    code and headers. Default is True.
                _preload_content (bool): if False, the urllib3.HTTPResponse object
                    will be returned without reading/decoding response data.
                    Default is True.
                _request_timeout (float/tuple): timeout setting for this request. If one
                    number provided, it will be total request timeout. It can also
                    be a pair (tuple) of (connection, read) timeouts.
                    Default is None.
                _check_input_type (bool): specifies if type checking
                    should be done one the data sent to the server.
                    Default is True.
                _check_return_type (bool): specifies if type checking
                    should be done one the data received from the server.
                    Default is True.
                _host_index (int/None): specifies the index of the server
                    that we want to use.
                    Default is read from the configuration.
                async_req (bool): execute request asynchronously

            Returns:
                CreditEmploymentGetResponse
                    If the method is called asynchronously, returns the request
                    thread.
            """
            kwargs['async_req'] = kwargs.get(
                'async_req', False
            )
            kwargs['_return_http_data_only'] = kwargs.get(
                '_return_http_data_only', True
            )
            kwargs['_preload_content'] = kwargs.get(
                '_preload_content', True
            )
            kwargs['_request_timeout'] = kwargs.get(
                '_request_timeout', None
            )
            kwargs['_check_input_type'] = kwargs.get(
                '_check_input_type', True
            )
            kwargs['_check_return_type'] = kwargs.get(
                '_check_return_type', True
            )
            kwargs['_host_index'] = kwargs.get('_host_index')
            kwargs['credit_employment_get_request'] = \
                credit_employment_get_request
            return self.call_with_http_info(**kwargs)

        self.credit_employment_get = _Endpoint(
            settings={
                'response_type': (CreditEmploymentGetResponse,),
                'auth': [
                    'clientId',
                    'plaidVersion',
                    'secret'
                ],
                'endpoint_path': '/credit/employment/get',
                'operation_id': 'credit_employment_get',
                'http_method': 'POST',
                'servers': None,
            },
            params_map={
                'all': [
                    'credit_employment_get_request',
                ],
                'required': [
                    'credit_employment_get_request',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'credit_employment_get_request':
                        (CreditEmploymentGetRequest,),
                },
                'attribute_map': {
                },
                'location_map': {
                    'credit_employment_get_request': 'body',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [
                    'application/json'
                ]
            },
            api_client=api_client,
            callable=__credit_employment_get
        )

        def __credit_payroll_income_get(
            self,
            credit_payroll_income_get_request,
            **kwargs
        ):
            """Retrieve a user's payroll information  # noqa: E501

            This endpoint gets payroll income information for a specific user, either as a result of the user connecting to their payroll provider or uploading a pay related document.  # noqa: E501
            This method makes a synchronous HTTP request by default. To make an
            asynchronous HTTP request, please pass async_req=True

            >>> thread = api.credit_payroll_income_get(credit_payroll_income_get_request, async_req=True)
            >>> result = thread.get()

            Args:
                credit_payroll_income_get_request (CreditPayrollIncomeGetRequest):

            Keyword Args:
                _return_http_data_only (bool): response data without head status
                    code and headers. Default is True.
                _preload_content (bool): if False, the urllib3.HTTPResponse object
                    will be returned without reading/decoding response data.
                    Default is True.
                _request_timeout (float/tuple): timeout setting for this request. If one
                    number provided, it will be total request timeout. It can also
                    be a pair (tuple) of (connection, read) timeouts.
                    Default is None.
                _check_input_type (bool): specifies if type checking
                    should be done one the data sent to the server.
                    Default is True.
                _check_return_type (bool): specifies if type checking
                    should be done one the data received from the server.
                    Default is True.
                _host_index (int/None): specifies the index of the server
                    that we want to use.
                    Default is read from the configuration.
                async_req (bool): execute request asynchronously

            Returns:
                CreditPayrollIncomeGetResponse
                    If the method is called asynchronously, returns the request
                    thread.
            """
            kwargs['async_req'] = kwargs.get(
                'async_req', False
            )
            kwargs['_return_http_data_only'] = kwargs.get(
                '_return_http_data_only', True
            )
            kwargs['_preload_content'] = kwargs.get(
                '_preload_content', True
            )
            kwargs['_request_timeout'] = kwargs.get(
                '_request_timeout', None
            )
            kwargs['_check_input_type'] = kwargs.get(
                '_check_input_type', True
            )
            kwargs['_check_return_type'] = kwargs.get(
                '_check_return_type', True
            )
            kwargs['_host_index'] = kwargs.get('_host_index')
            kwargs['credit_payroll_income_get_request'] = \
                credit_payroll_income_get_request
            return self.call_with_http_info(**kwargs)

        self.credit_payroll_income_get = _Endpoint(
            settings={
                'response_type': (CreditPayrollIncomeGetResponse,),
                'auth': [
                    'clientId',
                    'plaidVersion',
                    'secret'
                ],
                'endpoint_path': '/credit/payroll_income/get',
                'operation_id': 'credit_payroll_income_get',
                'http_method': 'POST',
                'servers': None,
            },
            params_map={
                'all': [
                    'credit_payroll_income_get_request',
                ],
                'required': [
                    'credit_payroll_income_get_request',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'credit_payroll_income_get_request':
                        (CreditPayrollIncomeGetRequest,),
                },
                'attribute_map': {
                },
                'location_map': {
                    'credit_payroll_income_get_request': 'body',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [
                    'application/json'
                ]
            },
            api_client=api_client,
            callable=__credit_payroll_income_get
        )

        def __credit_payroll_income_precheck(
            self,
            credit_payroll_income_precheck_request,
            **kwargs
        ):
            """Check income verification eligibility and optimize conversion  # noqa: E501

            `/credit/payroll_income/precheck` is an optional endpoint that can be called before initializing a Link session for income verification. It evaluates whether a given user is supportable by digital income verification. If the user is eligible for digital verification, that information will be associated with the user token, and in this way will generate a Link UI optimized for the end user and their specific employer. If the user cannot be confirmed as eligible, the user can still use the income verification flow, but they may be required to manually upload a paystub to verify their income.  While all request fields are optional, providing `employer` data will increase the chance of receiving a useful result.  # noqa: E501
            This method makes a synchronous HTTP request by default. To make an
            asynchronous HTTP request, please pass async_req=True

            >>> thread = api.credit_payroll_income_precheck(credit_payroll_income_precheck_request, async_req=True)
            >>> result = thread.get()

            Args:
                credit_payroll_income_precheck_request (CreditPayrollIncomePrecheckRequest):

            Keyword Args:
                _return_http_data_only (bool): response data without head status
                    code and headers. Default is True.
                _preload_content (bool): if False, the urllib3.HTTPResponse object
                    will be returned without reading/decoding response data.
                    Default is True.
                _request_timeout (float/tuple): timeout setting for this request. If one
                    number provided, it will be total request timeout. It can also
                    be a pair (tuple) of (connection, read) timeouts.
                    Default is None.
                _check_input_type (bool): specifies if type checking
                    should be done one the data sent to the server.
                    Default is True.
                _check_return_type (bool): specifies if type checking
                    should be done one the data received from the server.
                    Default is True.
                _host_index (int/None): specifies the index of the server
                    that we want to use.
                    Default is read from the configuration.
                async_req (bool): execute request asynchronously

            Returns:
                CreditPayrollIncomePrecheckResponse
                    If the method is called asynchronously, returns the request
                    thread.
            """
            kwargs['async_req'] = kwargs.get(
                'async_req', False
            )
            kwargs['_return_http_data_only'] = kwargs.get(
                '_return_http_data_only', True
            )
            kwargs['_preload_content'] = kwargs.get(
                '_preload_content', True
            )
            kwargs['_request_timeout'] = kwargs.get(
                '_request_timeout', None
            )
            kwargs['_check_input_type'] = kwargs.get(
                '_check_input_type', True
            )
            kwargs['_check_return_type'] = kwargs.get(
                '_check_return_type', True
            )
            kwargs['_host_index'] = kwargs.get('_host_index')
            kwargs['credit_payroll_income_precheck_request'] = \
                credit_payroll_income_precheck_request
            return self.call_with_http_info(**kwargs)

        self.credit_payroll_income_precheck = _Endpoint(
            settings={
                'response_type': (CreditPayrollIncomePrecheckResponse,),
                'auth': [
                    'clientId',
                    'plaidVersion',
                    'secret'
                ],
                'endpoint_path': '/credit/payroll_income/precheck',
                'operation_id': 'credit_payroll_income_precheck',
                'http_method': 'POST',
                'servers': None,
            },
            params_map={
                'all': [
                    'credit_payroll_income_precheck_request',
                ],
                'required': [
                    'credit_payroll_income_precheck_request',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'credit_payroll_income_precheck_request':
                        (CreditPayrollIncomePrecheckRequest,),
                },
                'attribute_map': {
                },
                'location_map': {
                    'credit_payroll_income_precheck_request': 'body',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [
                    'application/json'
                ]
            },
            api_client=api_client,
            callable=__credit_payroll_income_precheck
        )

        def __credit_payroll_income_refresh(
            self,
            credit_payroll_income_refresh_request,
            **kwargs
        ):
            """Refresh a digital payroll income verification  # noqa: E501

            `/credit/payroll_income/refresh` refreshes a given digital payroll income verification.  # noqa: E501
            This method makes a synchronous HTTP request by default. To make an
            asynchronous HTTP request, please pass async_req=True

            >>> thread = api.credit_payroll_income_refresh(credit_payroll_income_refresh_request, async_req=True)
            >>> result = thread.get()

            Args:
                credit_payroll_income_refresh_request (CreditPayrollIncomeRefreshRequest):

            Keyword Args:
                _return_http_data_only (bool): response data without head status
                    code and headers. Default is True.
                _preload_content (bool): if False, the urllib3.HTTPResponse object
                    will be returned without reading/decoding response data.
                    Default is True.
                _request_timeout (float/tuple): timeout setting for this request. If one
                    number provided, it will be total request timeout. It can also
                    be a pair (tuple) of (connection, read) timeouts.
                    Default is None.
                _check_input_type (bool): specifies if type checking
                    should be done one the data sent to the server.
                    Default is True.
                _check_return_type (bool): specifies if type checking
                    should be done one the data received from the server.
                    Default is True.
                _host_index (int/None): specifies the index of the server
                    that we want to use.
                    Default is read from the configuration.
                async_req (bool): execute request asynchronously

            Returns:
                CreditPayrollIncomeRefreshResponse
                    If the method is called asynchronously, returns the request
                    thread.
            """
            kwargs['async_req'] = kwargs.get(
                'async_req', False
            )
            kwargs['_return_http_data_only'] = kwargs.get(
                '_return_http_data_only', True
            )
            kwargs['_preload_content'] = kwargs.get(
                '_preload_content', True
            )
            kwargs['_request_timeout'] = kwargs.get(
                '_request_timeout', None
            )
            kwargs['_check_input_type'] = kwargs.get(
                '_check_input_type', True
            )
            kwargs['_check_return_type'] = kwargs.get(
                '_check_return_type', True
            )
            kwargs['_host_index'] = kwargs.get('_host_index')
            kwargs['credit_payroll_income_refresh_request'] = \
                credit_payroll_income_refresh_request
            return self.call_with_http_info(**kwargs)

        self.credit_payroll_income_refresh = _Endpoint(
            settings={
                'response_type': (CreditPayrollIncomeRefreshResponse,),
                'auth': [
                    'clientId',
                    'plaidVersion',
                    'secret'
                ],
                'endpoint_path': '/credit/payroll_income/refresh',
                'operation_id': 'credit_payroll_income_refresh',
                'http_method': 'POST',
                'servers': None,
            },
            params_map={
                'all': [
                    'credit_payroll_income_refresh_request',
                ],
                'required': [
                    'credit_payroll_income_refresh_request',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'credit_payroll_income_refresh_request':
                        (CreditPayrollIncomeRefreshRequest,),
                },
                'attribute_map': {
                },
                'location_map': {
                    'credit_payroll_income_refresh_request': 'body',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [
                    'application/json'
                ]
            },
            api_client=api_client,
            callable=__credit_payroll_income_refresh
        )

        def __credit_relay_create(
            self,
            credit_relay_create_request,
            **kwargs
        ):
            """Create a `relay_token` to share an Asset Report with a partner client  # noqa: E501

            Plaid can share an Asset Report directly with a participating third party on your behalf. The shared Asset Report is the exact same Asset Report originally created in `/asset_report/create`.  To grant access to an Asset Report to a third party, use the `/credit/relay/create` endpoint to create a `relay_token` and then pass that token to the third party who needs access. Each third party has its own `secondary_client_id`, for example `ce5bd328dcd34123456`. You'll need to create a separate `relay_token` for each third party to whom you want to grant access to the Report.  # noqa: E501
            This method makes a synchronous HTTP request by default. To make an
            asynchronous HTTP request, please pass async_req=True

            >>> thread = api.credit_relay_create(credit_relay_create_request, async_req=True)
            >>> result = thread.get()

            Args:
                credit_relay_create_request (CreditRelayCreateRequest):

            Keyword Args:
                _return_http_data_only (bool): response data without head status
                    code and headers. Default is True.
                _preload_content (bool): if False, the urllib3.HTTPResponse object
                    will be returned without reading/decoding response data.
                    Default is True.
                _request_timeout (float/tuple): timeout setting for this request. If one
                    number provided, it will be total request timeout. It can also
                    be a pair (tuple) of (connection, read) timeouts.
                    Default is None.
                _check_input_type (bool): specifies if type checking
                    should be done one the data sent to the server.
                    Default is True.
                _check_return_type (bool): specifies if type checking
                    should be done one the data received from the server.
                    Default is True.
                _host_index (int/None): specifies the index of the server
                    that we want to use.
                    Default is read from the configuration.
                async_req (bool): execute request asynchronously

            Returns:
                CreditRelayCreateResponse
                    If the method is called asynchronously, returns the request
                    thread.
            """
            kwargs['async_req'] = kwargs.get(
                'async_req', False
            )
            kwargs['_return_http_data_only'] = kwargs.get(
                '_return_http_data_only', True
            )
            kwargs['_preload_content'] = kwargs.get(
                '_preload_content', True
            )
            kwargs['_request_timeout'] = kwargs.get(
                '_request_timeout', None
            )
            kwargs['_check_input_type'] = kwargs.get(
                '_check_input_type', True
            )
            kwargs['_check_return_type'] = kwargs.get(
                '_check_return_type', True
            )
            kwargs['_host_index'] = kwargs.get('_host_index')
            kwargs['credit_relay_create_request'] = \
                credit_relay_create_request
            return self.call_with_http_info(**kwargs)

        self.credit_relay_create = _Endpoint(
            settings={
                'response_type': (CreditRelayCreateResponse,),
                'auth': [
                    'clientId',
                    'plaidVersion',
                    'secret'
                ],
                'endpoint_path': '/credit/relay/create',
                'operation_id': 'credit_relay_create',
                'http_method': 'POST',
                'servers': None,
            },
            params_map={
                'all': [
                    'credit_relay_create_request',
                ],
                'required': [
                    'credit_relay_create_request',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'credit_relay_create_request':
                        (CreditRelayCreateRequest,),
                },
                'attribute_map': {
                },
                'location_map': {
                    'credit_relay_create_request': 'body',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [
                    'application/json'
                ]
            },
            api_client=api_client,
            callable=__credit_relay_create
        )

        def __dashboard_user_list(
            self,
            list_dashboard_user_request,
            **kwargs
        ):
            """List dashboard users  # noqa: E501

            List all dashboard users associated with your account.  # noqa: E501
            This method makes a synchronous HTTP request by default. To make an
            asynchronous HTTP request, please pass async_req=True

            >>> thread = api.dashboard_user_list(list_dashboard_user_request, async_req=True)
            >>> result = thread.get()

            Args:
                list_dashboard_user_request (ListDashboardUserRequest):

            Keyword Args:
                _return_http_data_only (bool): response data without head status
                    code and headers. Default is True.
                _preload_content (bool): if False, the urllib3.HTTPResponse object
                    will be returned without reading/decoding response data.
                    Default is True.
                _request_timeout (float/tuple): timeout setting for this request. If one
                    number provided, it will be total request timeout. It can also
                    be a pair (tuple) of (connection, read) timeouts.
                    Default is None.
                _check_input_type (bool): specifies if type checking
                    should be done one the data sent to the server.
                    Default is True.
                _check_return_type (bool): specifies if type checking
                    should be done one the data received from the server.
                    Default is True.
                _host_index (int/None): specifies the index of the server
                    that we want to use.
                    Default is read from the configuration.
                async_req (bool): execute request asynchronously

            Returns:
                PaginatedDashboardUserListResponse
                    If the method is called asynchronously, returns the request
                    thread.
            """
            kwargs['async_req'] = kwargs.get(
                'async_req', False
            )
            kwargs['_return_http_data_only'] = kwargs.get(
                '_return_http_data_only', True
            )
            kwargs['_preload_content'] = kwargs.get(
                '_preload_content', True
            )
            kwargs['_request_timeout'] = kwargs.get(
                '_request_timeout', None
            )
            kwargs['_check_input_type'] = kwargs.get(
                '_check_input_type', True
            )
            kwargs['_check_return_type'] = kwargs.get(
                '_check_return_type', True
            )
            kwargs['_host_index'] = kwargs.get('_host_index')
            kwargs['list_dashboard_user_request'] = \
                list_dashboard_user_request
            return self.call_with_http_info(**kwargs)

        self.dashboard_user_list = _Endpoint(
            settings={
                'response_type': (PaginatedDashboardUserListResponse,),
                'auth': [
                    'clientId',
                    'plaidVersion',
                    'secret'
                ],
                'endpoint_path': '/dashboard_user/list',
                'operation_id': 'dashboard_user_list',
                'http_method': 'POST',
                'servers': None,
            },
            params_map={
                'all': [
                    'list_dashboard_user_request',
                ],
                'required': [
                    'list_dashboard_user_request',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'list_dashboard_user_request':
                        (ListDashboardUserRequest,),
                },
                'attribute_map': {
                },
                'location_map': {
                    'list_dashboard_user_request': 'body',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [
                    'application/json'
                ]
            },
            api_client=api_client,
            callable=__dashboard_user_list
        )

        def __dashobard_user_get(
            self,
            get_dashboard_user_request,
            **kwargs
        ):
            """Retrieve a dashboard user  # noqa: E501

            Retrieve information about a dashboard user.  # noqa: E501
            This method makes a synchronous HTTP request by default. To make an
            asynchronous HTTP request, please pass async_req=True

            >>> thread = api.dashobard_user_get(get_dashboard_user_request, async_req=True)
            >>> result = thread.get()

            Args:
                get_dashboard_user_request (GetDashboardUserRequest):

            Keyword Args:
                _return_http_data_only (bool): response data without head status
                    code and headers. Default is True.
                _preload_content (bool): if False, the urllib3.HTTPResponse object
                    will be returned without reading/decoding response data.
                    Default is True.
                _request_timeout (float/tuple): timeout setting for this request. If one
                    number provided, it will be total request timeout. It can also
                    be a pair (tuple) of (connection, read) timeouts.
                    Default is None.
                _check_input_type (bool): specifies if type checking
                    should be done one the data sent to the server.
                    Default is True.
                _check_return_type (bool): specifies if type checking
                    should be done one the data received from the server.
                    Default is True.
                _host_index (int/None): specifies the index of the server
                    that we want to use.
                    Default is read from the configuration.
                async_req (bool): execute request asynchronously

            Returns:
                DashboardUserResponse
                    If the method is called asynchronously, returns the request
                    thread.
            """
            kwargs['async_req'] = kwargs.get(
                'async_req', False
            )
            kwargs['_return_http_data_only'] = kwargs.get(
                '_return_http_data_only', True
            )
            kwargs['_preload_content'] = kwargs.get(
                '_preload_content', True
            )
            kwargs['_request_timeout'] = kwargs.get(
                '_request_timeout', None
            )
            kwargs['_check_input_type'] = kwargs.get(
                '_check_input_type', True
            )
            kwargs['_check_return_type'] = kwargs.get(
                '_check_return_type', True
            )
            kwargs['_host_index'] = kwargs.get('_host_index')
            kwargs['get_dashboard_user_request'] = \
                get_dashboard_user_request
            return self.call_with_http_info(**kwargs)

        self.dashobard_user_get = _Endpoint(
            settings={
                'response_type': (DashboardUserResponse,),
                'auth': [
                    'clientId',
                    'plaidVersion',
                    'secret'
                ],
                'endpoint_path': '/dashboard_user/get',
                'operation_id': 'dashobard_user_get',
                'http_method': 'POST',
                'servers': None,
            },
            params_map={
                'all': [
                    'get_dashboard_user_request',
                ],
                'required': [
                    'get_dashboard_user_request',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'get_dashboard_user_request':
                        (GetDashboardUserRequest,),
                },
                'attribute_map': {
                },
                'location_map': {
                    'get_dashboard_user_request': 'body',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [
                    'application/json'
                ]
            },
            api_client=api_client,
            callable=__dashobard_user_get
        )

        def __deposit_switch_alt_create(
            self,
            deposit_switch_alt_create_request,
            **kwargs
        ):
            """Create a deposit switch without using Plaid Exchange  # noqa: E501

            This endpoint provides an alternative to `/deposit_switch/create` for customers who have not yet fully integrated with Plaid Exchange. Like `/deposit_switch/create`, it creates a deposit switch entity that will be persisted throughout the lifecycle of the switch.  # noqa: E501
            This method makes a synchronous HTTP request by default. To make an
            asynchronous HTTP request, please pass async_req=True

            >>> thread = api.deposit_switch_alt_create(deposit_switch_alt_create_request, async_req=True)
            >>> result = thread.get()

            Args:
                deposit_switch_alt_create_request (DepositSwitchAltCreateRequest):

            Keyword Args:
                _return_http_data_only (bool): response data without head status
                    code and headers. Default is True.
                _preload_content (bool): if False, the urllib3.HTTPResponse object
                    will be returned without reading/decoding response data.
                    Default is True.
                _request_timeout (float/tuple): timeout setting for this request. If one
                    number provided, it will be total request timeout. It can also
                    be a pair (tuple) of (connection, read) timeouts.
                    Default is None.
                _check_input_type (bool): specifies if type checking
                    should be done one the data sent to the server.
                    Default is True.
                _check_return_type (bool): specifies if type checking
                    should be done one the data received from the server.
                    Default is True.
                _host_index (int/None): specifies the index of the server
                    that we want to use.
                    Default is read from the configuration.
                async_req (bool): execute request asynchronously

            Returns:
                DepositSwitchAltCreateResponse
                    If the method is called asynchronously, returns the request
                    thread.
            """
            kwargs['async_req'] = kwargs.get(
                'async_req', False
            )
            kwargs['_return_http_data_only'] = kwargs.get(
                '_return_http_data_only', True
            )
            kwargs['_preload_content'] = kwargs.get(
                '_preload_content', True
            )
            kwargs['_request_timeout'] = kwargs.get(
                '_request_timeout', None
            )
            kwargs['_check_input_type'] = kwargs.get(
                '_check_input_type', True
            )
            kwargs['_check_return_type'] = kwargs.get(
                '_check_return_type', True
            )
            kwargs['_host_index'] = kwargs.get('_host_index')
            kwargs['deposit_switch_alt_create_request'] = \
                deposit_switch_alt_create_request
            return self.call_with_http_info(**kwargs)

        self.deposit_switch_alt_create = _Endpoint(
            settings={
                'response_type': (DepositSwitchAltCreateResponse,),
                'auth': [
                    'clientId',
                    'plaidVersion',
                    'secret'
                ],
                'endpoint_path': '/deposit_switch/alt/create',
                'operation_id': 'deposit_switch_alt_create',
                'http_method': 'POST',
                'servers': None,
            },
            params_map={
                'all': [
                    'deposit_switch_alt_create_request',
                ],
                'required': [
                    'deposit_switch_alt_create_request',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'deposit_switch_alt_create_request':
                        (DepositSwitchAltCreateRequest,),
                },
                'attribute_map': {
                },
                'location_map': {
                    'deposit_switch_alt_create_request': 'body',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [
                    'application/json'
                ]
            },
            api_client=api_client,
            callable=__deposit_switch_alt_create
        )

        def __deposit_switch_create(
            self,
            deposit_switch_create_request,
            **kwargs
        ):
            """Create a deposit switch  # noqa: E501

            This endpoint creates a deposit switch entity that will be persisted throughout the lifecycle of the switch.  # noqa: E501
            This method makes a synchronous HTTP request by default. To make an
            asynchronous HTTP request, please pass async_req=True

            >>> thread = api.deposit_switch_create(deposit_switch_create_request, async_req=True)
            >>> result = thread.get()

            Args:
                deposit_switch_create_request (DepositSwitchCreateRequest):

            Keyword Args:
                _return_http_data_only (bool): response data without head status
                    code and headers. Default is True.
                _preload_content (bool): if False, the urllib3.HTTPResponse object
                    will be returned without reading/decoding response data.
                    Default is True.
                _request_timeout (float/tuple): timeout setting for this request. If one
                    number provided, it will be total request timeout. It can also
                    be a pair (tuple) of (connection, read) timeouts.
                    Default is None.
                _check_input_type (bool): specifies if type checking
                    should be done one the data sent to the server.
                    Default is True.
                _check_return_type (bool): specifies if type checking
                    should be done one the data received from the server.
                    Default is True.
                _host_index (int/None): specifies the index of the server
                    that we want to use.
                    Default is read from the configuration.
                async_req (bool): execute request asynchronously

            Returns:
                DepositSwitchCreateResponse
                    If the method is called asynchronously, returns the request
                    thread.
            """
            kwargs['async_req'] = kwargs.get(
                'async_req', False
            )
            kwargs['_return_http_data_only'] = kwargs.get(
                '_return_http_data_only', True
            )
            kwargs['_preload_content'] = kwargs.get(
                '_preload_content', True
            )
            kwargs['_request_timeout'] = kwargs.get(
                '_request_timeout', None
            )
            kwargs['_check_input_type'] = kwargs.get(
                '_check_input_type', True
            )
            kwargs['_check_return_type'] = kwargs.get(
                '_check_return_type', True
            )
            kwargs['_host_index'] = kwargs.get('_host_index')
            kwargs['deposit_switch_create_request'] = \
                deposit_switch_create_request
            return self.call_with_http_info(**kwargs)

        self.deposit_switch_create = _Endpoint(
            settings={
                'response_type': (DepositSwitchCreateResponse,),
                'auth': [
                    'clientId',
                    'plaidVersion',
                    'secret'
                ],
                'endpoint_path': '/deposit_switch/create',
                'operation_id': 'deposit_switch_create',
                'http_method': 'POST',
                'servers': None,
            },
            params_map={
                'all': [
                    'deposit_switch_create_request',
                ],
                'required': [
                    'deposit_switch_create_request',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'deposit_switch_create_request':
                        (DepositSwitchCreateRequest,),
                },
                'attribute_map': {
                },
                'location_map': {
                    'deposit_switch_create_request': 'body',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [
                    'application/json'
                ]
            },
            api_client=api_client,
            callable=__deposit_switch_create
        )

        def __deposit_switch_get(
            self,
            deposit_switch_get_request,
            **kwargs
        ):
            """Retrieve a deposit switch  # noqa: E501

            This endpoint returns information related to how the user has configured their payroll allocation and the state of the switch. You can use this information to build logic related to the user's direct deposit allocation preferences.  # noqa: E501
            This method makes a synchronous HTTP request by default. To make an
            asynchronous HTTP request, please pass async_req=True

            >>> thread = api.deposit_switch_get(deposit_switch_get_request, async_req=True)
            >>> result = thread.get()

            Args:
                deposit_switch_get_request (DepositSwitchGetRequest):

            Keyword Args:
                _return_http_data_only (bool): response data without head status
                    code and headers. Default is True.
                _preload_content (bool): if False, the urllib3.HTTPResponse object
                    will be returned without reading/decoding response data.
                    Default is True.
                _request_timeout (float/tuple): timeout setting for this request. If one
                    number provided, it will be total request timeout. It can also
                    be a pair (tuple) of (connection, read) timeouts.
                    Default is None.
                _check_input_type (bool): specifies if type checking
                    should be done one the data sent to the server.
                    Default is True.
                _check_return_type (bool): specifies if type checking
                    should be done one the data received from the server.
                    Default is True.
                _host_index (int/None): specifies the index of the server
                    that we want to use.
                    Default is read from the configuration.
                async_req (bool): execute request asynchronously

            Returns:
                DepositSwitchGetResponse
                    If the method is called asynchronously, returns the request
                    thread.
            """
            kwargs['async_req'] = kwargs.get(
                'async_req', False
            )
            kwargs['_return_http_data_only'] = kwargs.get(
                '_return_http_data_only', True
            )
            kwargs['_preload_content'] = kwargs.get(
                '_preload_content', True
            )
            kwargs['_request_timeout'] = kwargs.get(
                '_request_timeout', None
            )
            kwargs['_check_input_type'] = kwargs.get(
                '_check_input_type', True
            )
            kwargs['_check_return_type'] = kwargs.get(
                '_check_return_type', True
            )
            kwargs['_host_index'] = kwargs.get('_host_index')
            kwargs['deposit_switch_get_request'] = \
                deposit_switch_get_request
            return self.call_with_http_info(**kwargs)

        self.deposit_switch_get = _Endpoint(
            settings={
                'response_type': (DepositSwitchGetResponse,),
                'auth': [
                    'clientId',
                    'plaidVersion',
                    'secret'
                ],
                'endpoint_path': '/deposit_switch/get',
                'operation_id': 'deposit_switch_get',
                'http_method': 'POST',
                'servers': None,
            },
            params_map={
                'all': [
                    'deposit_switch_get_request',
                ],
                'required': [
                    'deposit_switch_get_request',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'deposit_switch_get_request':
                        (DepositSwitchGetRequest,),
                },
                'attribute_map': {
                },
                'location_map': {
                    'deposit_switch_get_request': 'body',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [
                    'application/json'
                ]
            },
            api_client=api_client,
            callable=__deposit_switch_get
        )

        def __deposit_switch_token_create(
            self,
            deposit_switch_token_create_request,
            **kwargs
        ):
            """Create a deposit switch token  # noqa: E501

            In order for the end user to take action, you will need to create a public token representing the deposit switch. This token is used to initialize Link. It can be used one time and expires after 30 minutes.   # noqa: E501
            This method makes a synchronous HTTP request by default. To make an
            asynchronous HTTP request, please pass async_req=True

            >>> thread = api.deposit_switch_token_create(deposit_switch_token_create_request, async_req=True)
            >>> result = thread.get()

            Args:
                deposit_switch_token_create_request (DepositSwitchTokenCreateRequest):

            Keyword Args:
                _return_http_data_only (bool): response data without head status
                    code and headers. Default is True.
                _preload_content (bool): if False, the urllib3.HTTPResponse object
                    will be returned without reading/decoding response data.
                    Default is True.
                _request_timeout (float/tuple): timeout setting for this request. If one
                    number provided, it will be total request timeout. It can also
                    be a pair (tuple) of (connection, read) timeouts.
                    Default is None.
                _check_input_type (bool): specifies if type checking
                    should be done one the data sent to the server.
                    Default is True.
                _check_return_type (bool): specifies if type checking
                    should be done one the data received from the server.
                    Default is True.
                _host_index (int/None): specifies the index of the server
                    that we want to use.
                    Default is read from the configuration.
                async_req (bool): execute request asynchronously

            Returns:
                DepositSwitchTokenCreateResponse
                    If the method is called asynchronously, returns the request
                    thread.
            """
            kwargs['async_req'] = kwargs.get(
                'async_req', False
            )
            kwargs['_return_http_data_only'] = kwargs.get(
                '_return_http_data_only', True
            )
            kwargs['_preload_content'] = kwargs.get(
                '_preload_content', True
            )
            kwargs['_request_timeout'] = kwargs.get(
                '_request_timeout', None
            )
            kwargs['_check_input_type'] = kwargs.get(
                '_check_input_type', True
            )
            kwargs['_check_return_type'] = kwargs.get(
                '_check_return_type', True
            )
            kwargs['_host_index'] = kwargs.get('_host_index')
            kwargs['deposit_switch_token_create_request'] = \
                deposit_switch_token_create_request
            return self.call_with_http_info(**kwargs)

        self.deposit_switch_token_create = _Endpoint(
            settings={
                'response_type': (DepositSwitchTokenCreateResponse,),
                'auth': [
                    'clientId',
                    'plaidVersion',
                    'secret'
                ],
                'endpoint_path': '/deposit_switch/token/create',
                'operation_id': 'deposit_switch_token_create',
                'http_method': 'POST',
                'servers': None,
            },
            params_map={
                'all': [
                    'deposit_switch_token_create_request',
                ],
                'required': [
                    'deposit_switch_token_create_request',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'deposit_switch_token_create_request':
                        (DepositSwitchTokenCreateRequest,),
                },
                'attribute_map': {
                },
                'location_map': {
                    'deposit_switch_token_create_request': 'body',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [
                    'application/json'
                ]
            },
            api_client=api_client,
            callable=__deposit_switch_token_create
        )

        def __employers_search(
            self,
            employers_search_request,
            **kwargs
        ):
            """Search employer database  # noqa: E501

            `/employers/search` allows you the ability to search Plaid’s database of known employers, for use with Deposit Switch. You can use this endpoint to look up a user's employer in order to confirm that they are supported. Users with non-supported employers can then be routed out of the Deposit Switch flow.  The data in the employer database is currently limited. As the Deposit Switch and Income products progress through their respective beta periods, more employers are being regularly added. Because the employer database is frequently updated, we recommend that you do not cache or store data from this endpoint for more than a day.  # noqa: E501
            This method makes a synchronous HTTP request by default. To make an
            asynchronous HTTP request, please pass async_req=True

            >>> thread = api.employers_search(employers_search_request, async_req=True)
            >>> result = thread.get()

            Args:
                employers_search_request (EmployersSearchRequest):

            Keyword Args:
                _return_http_data_only (bool): response data without head status
                    code and headers. Default is True.
                _preload_content (bool): if False, the urllib3.HTTPResponse object
                    will be returned without reading/decoding response data.
                    Default is True.
                _request_timeout (float/tuple): timeout setting for this request. If one
                    number provided, it will be total request timeout. It can also
                    be a pair (tuple) of (connection, read) timeouts.
                    Default is None.
                _check_input_type (bool): specifies if type checking
                    should be done one the data sent to the server.
                    Default is True.
                _check_return_type (bool): specifies if type checking
                    should be done one the data received from the server.
                    Default is True.
                _host_index (int/None): specifies the index of the server
                    that we want to use.
                    Default is read from the configuration.
                async_req (bool): execute request asynchronously

            Returns:
                EmployersSearchResponse
                    If the method is called asynchronously, returns the request
                    thread.
            """
            kwargs['async_req'] = kwargs.get(
                'async_req', False
            )
            kwargs['_return_http_data_only'] = kwargs.get(
                '_return_http_data_only', True
            )
            kwargs['_preload_content'] = kwargs.get(
                '_preload_content', True
            )
            kwargs['_request_timeout'] = kwargs.get(
                '_request_timeout', None
            )
            kwargs['_check_input_type'] = kwargs.get(
                '_check_input_type', True
            )
            kwargs['_check_return_type'] = kwargs.get(
                '_check_return_type', True
            )
            kwargs['_host_index'] = kwargs.get('_host_index')
            kwargs['employers_search_request'] = \
                employers_search_request
            return self.call_with_http_info(**kwargs)

        self.employers_search = _Endpoint(
            settings={
                'response_type': (EmployersSearchResponse,),
                'auth': [
                    'clientId',
                    'plaidVersion',
                    'secret'
                ],
                'endpoint_path': '/employers/search',
                'operation_id': 'employers_search',
                'http_method': 'POST',
                'servers': None,
            },
            params_map={
                'all': [
                    'employers_search_request',
                ],
                'required': [
                    'employers_search_request',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'employers_search_request':
                        (EmployersSearchRequest,),
                },
                'attribute_map': {
                },
                'location_map': {
                    'employers_search_request': 'body',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [
                    'application/json'
                ]
            },
            api_client=api_client,
            callable=__employers_search
        )

        def __employment_verification_get(
            self,
            employment_verification_get_request,
            **kwargs
        ):
            """(Deprecated) Retrieve a summary of an individual's employment information  # noqa: E501

            `/employment/verification/get` returns a list of employments through a user payroll that was verified by an end user.  This endpoint has been deprecated; new integrations should use `/credit/employment/get` instead.  # noqa: E501
            This method makes a synchronous HTTP request by default. To make an
            asynchronous HTTP request, please pass async_req=True

            >>> thread = api.employment_verification_get(employment_verification_get_request, async_req=True)
            >>> result = thread.get()

            Args:
                employment_verification_get_request (EmploymentVerificationGetRequest):

            Keyword Args:
                _return_http_data_only (bool): response data without head status
                    code and headers. Default is True.
                _preload_content (bool): if False, the urllib3.HTTPResponse object
                    will be returned without reading/decoding response data.
                    Default is True.
                _request_timeout (float/tuple): timeout setting for this request. If one
                    number provided, it will be total request timeout. It can also
                    be a pair (tuple) of (connection, read) timeouts.
                    Default is None.
                _check_input_type (bool): specifies if type checking
                    should be done one the data sent to the server.
                    Default is True.
                _check_return_type (bool): specifies if type checking
                    should be done one the data received from the server.
                    Default is True.
                _host_index (int/None): specifies the index of the server
                    that we want to use.
                    Default is read from the configuration.
                async_req (bool): execute request asynchronously

            Returns:
                EmploymentVerificationGetResponse
                    If the method is called asynchronously, returns the request
                    thread.
            """
            kwargs['async_req'] = kwargs.get(
                'async_req', False
            )
            kwargs['_return_http_data_only'] = kwargs.get(
                '_return_http_data_only', True
            )
            kwargs['_preload_content'] = kwargs.get(
                '_preload_content', True
            )
            kwargs['_request_timeout'] = kwargs.get(
                '_request_timeout', None
            )
            kwargs['_check_input_type'] = kwargs.get(
                '_check_input_type', True
            )
            kwargs['_check_return_type'] = kwargs.get(
                '_check_return_type', True
            )
            kwargs['_host_index'] = kwargs.get('_host_index')
            kwargs['employment_verification_get_request'] = \
                employment_verification_get_request
            return self.call_with_http_info(**kwargs)

        self.employment_verification_get = _Endpoint(
            settings={
                'response_type': (EmploymentVerificationGetResponse,),
                'auth': [
                    'clientId',
                    'plaidVersion',
                    'secret'
                ],
                'endpoint_path': '/employment/verification/get',
                'operation_id': 'employment_verification_get',
                'http_method': 'POST',
                'servers': None,
            },
            params_map={
                'all': [
                    'employment_verification_get_request',
                ],
                'required': [
                    'employment_verification_get_request',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'employment_verification_get_request':
                        (EmploymentVerificationGetRequest,),
                },
                'attribute_map': {
                },
                'location_map': {
                    'employment_verification_get_request': 'body',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [
                    'application/json'
                ]
            },
            api_client=api_client,
            callable=__employment_verification_get
        )

        def __identity_get(
            self,
            identity_get_request,
            **kwargs
        ):
            """Retrieve identity data  # noqa: E501

            The `/identity/get` endpoint allows you to retrieve various account holder information on file with the financial institution, including names, emails, phone numbers, and addresses. Only name data is guaranteed to be returned; other fields will be empty arrays if not provided by the institution.  This request may take some time to complete if identity was not specified as an initial product when creating the Item. This is because Plaid must communicate directly with the institution to retrieve the data.  Note: In API versions 2018-05-22 and earlier, the `owners` object is not returned, and instead identity information is returned in the top level `identity` object. For more details, see [Plaid API versioning](https://plaid.com/docs/api/versioning/#version-2019-05-29).  # noqa: E501
            This method makes a synchronous HTTP request by default. To make an
            asynchronous HTTP request, please pass async_req=True

            >>> thread = api.identity_get(identity_get_request, async_req=True)
            >>> result = thread.get()

            Args:
                identity_get_request (IdentityGetRequest):

            Keyword Args:
                _return_http_data_only (bool): response data without head status
                    code and headers. Default is True.
                _preload_content (bool): if False, the urllib3.HTTPResponse object
                    will be returned without reading/decoding response data.
                    Default is True.
                _request_timeout (float/tuple): timeout setting for this request. If one
                    number provided, it will be total request timeout. It can also
                    be a pair (tuple) of (connection, read) timeouts.
                    Default is None.
                _check_input_type (bool): specifies if type checking
                    should be done one the data sent to the server.
                    Default is True.
                _check_return_type (bool): specifies if type checking
                    should be done one the data received from the server.
                    Default is True.
                _host_index (int/None): specifies the index of the server
                    that we want to use.
                    Default is read from the configuration.
                async_req (bool): execute request asynchronously

            Returns:
                IdentityGetResponse
                    If the method is called asynchronously, returns the request
                    thread.
            """
            kwargs['async_req'] = kwargs.get(
                'async_req', False
            )
            kwargs['_return_http_data_only'] = kwargs.get(
                '_return_http_data_only', True
            )
            kwargs['_preload_content'] = kwargs.get(
                '_preload_content', True
            )
            kwargs['_request_timeout'] = kwargs.get(
                '_request_timeout', None
            )
            kwargs['_check_input_type'] = kwargs.get(
                '_check_input_type', True
            )
            kwargs['_check_return_type'] = kwargs.get(
                '_check_return_type', True
            )
            kwargs['_host_index'] = kwargs.get('_host_index')
            kwargs['identity_get_request'] = \
                identity_get_request
            return self.call_with_http_info(**kwargs)

        self.identity_get = _Endpoint(
            settings={
                'response_type': (IdentityGetResponse,),
                'auth': [
                    'clientId',
                    'plaidVersion',
                    'secret'
                ],
                'endpoint_path': '/identity/get',
                'operation_id': 'identity_get',
                'http_method': 'POST',
                'servers': None,
            },
            params_map={
                'all': [
                    'identity_get_request',
                ],
                'required': [
                    'identity_get_request',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'identity_get_request':
                        (IdentityGetRequest,),
                },
                'attribute_map': {
                },
                'location_map': {
                    'identity_get_request': 'body',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [
                    'application/json'
                ]
            },
            api_client=api_client,
            callable=__identity_get
        )

        def __identity_verification_create(
            self,
            identity_verification_create_request,
            **kwargs
        ):
            """Create a new identity verification  # noqa: E501

            Create a new Identity Verification for the user specified by the `client_user_id` field. The requirements and behavior of the verification are determined by the `template_id` provided. If you don't know whether the associated user already has an active Identity Verification, you can specify `\"is_idempotent\": true` in the request body. With idempotency enabled, a new Identity Verification will only be created if one does not already exist for the associated `client_user_id` and `template_id`. If an Identity Verification is found, it will be returned unmodified with an `200 OK` HTTP status code.   # noqa: E501
            This method makes a synchronous HTTP request by default. To make an
            asynchronous HTTP request, please pass async_req=True

            >>> thread = api.identity_verification_create(identity_verification_create_request, async_req=True)
            >>> result = thread.get()

            Args:
                identity_verification_create_request (IdentityVerificationCreateRequest):

            Keyword Args:
                _return_http_data_only (bool): response data without head status
                    code and headers. Default is True.
                _preload_content (bool): if False, the urllib3.HTTPResponse object
                    will be returned without reading/decoding response data.
                    Default is True.
                _request_timeout (float/tuple): timeout setting for this request. If one
                    number provided, it will be total request timeout. It can also
                    be a pair (tuple) of (connection, read) timeouts.
                    Default is None.
                _check_input_type (bool): specifies if type checking
                    should be done one the data sent to the server.
                    Default is True.
                _check_return_type (bool): specifies if type checking
                    should be done one the data received from the server.
                    Default is True.
                _host_index (int/None): specifies the index of the server
                    that we want to use.
                    Default is read from the configuration.
                async_req (bool): execute request asynchronously

            Returns:
                IdentityVerificationResponse
                    If the method is called asynchronously, returns the request
                    thread.
            """
            kwargs['async_req'] = kwargs.get(
                'async_req', False
            )
            kwargs['_return_http_data_only'] = kwargs.get(
                '_return_http_data_only', True
            )
            kwargs['_preload_content'] = kwargs.get(
                '_preload_content', True
            )
            kwargs['_request_timeout'] = kwargs.get(
                '_request_timeout', None
            )
            kwargs['_check_input_type'] = kwargs.get(
                '_check_input_type', True
            )
            kwargs['_check_return_type'] = kwargs.get(
                '_check_return_type', True
            )
            kwargs['_host_index'] = kwargs.get('_host_index')
            kwargs['identity_verification_create_request'] = \
                identity_verification_create_request
            return self.call_with_http_info(**kwargs)

        self.identity_verification_create = _Endpoint(
            settings={
                'response_type': (IdentityVerificationResponse,),
                'auth': [
                    'clientId',
                    'plaidVersion',
                    'secret'
                ],
                'endpoint_path': '/identity_verification/create',
                'operation_id': 'identity_verification_create',
                'http_method': 'POST',
                'servers': None,
            },
            params_map={
                'all': [
                    'identity_verification_create_request',
                ],
                'required': [
                    'identity_verification_create_request',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'identity_verification_create_request':
                        (IdentityVerificationCreateRequest,),
                },
                'attribute_map': {
                },
                'location_map': {
                    'identity_verification_create_request': 'body',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [
                    'application/json'
                ]
            },
            api_client=api_client,
            callable=__identity_verification_create
        )

        def __identity_verification_get(
            self,
            get_identity_verification_request,
            **kwargs
        ):
            """Retrieve Identity Verification  # noqa: E501

            Retrieve a previously created identity verification  # noqa: E501
            This method makes a synchronous HTTP request by default. To make an
            asynchronous HTTP request, please pass async_req=True

            >>> thread = api.identity_verification_get(get_identity_verification_request, async_req=True)
            >>> result = thread.get()

            Args:
                get_identity_verification_request (GetIdentityVerificationRequest):

            Keyword Args:
                _return_http_data_only (bool): response data without head status
                    code and headers. Default is True.
                _preload_content (bool): if False, the urllib3.HTTPResponse object
                    will be returned without reading/decoding response data.
                    Default is True.
                _request_timeout (float/tuple): timeout setting for this request. If one
                    number provided, it will be total request timeout. It can also
                    be a pair (tuple) of (connection, read) timeouts.
                    Default is None.
                _check_input_type (bool): specifies if type checking
                    should be done one the data sent to the server.
                    Default is True.
                _check_return_type (bool): specifies if type checking
                    should be done one the data received from the server.
                    Default is True.
                _host_index (int/None): specifies the index of the server
                    that we want to use.
                    Default is read from the configuration.
                async_req (bool): execute request asynchronously

            Returns:
                IdentityVerificationResponse
                    If the method is called asynchronously, returns the request
                    thread.
            """
            kwargs['async_req'] = kwargs.get(
                'async_req', False
            )
            kwargs['_return_http_data_only'] = kwargs.get(
                '_return_http_data_only', True
            )
            kwargs['_preload_content'] = kwargs.get(
                '_preload_content', True
            )
            kwargs['_request_timeout'] = kwargs.get(
                '_request_timeout', None
            )
            kwargs['_check_input_type'] = kwargs.get(
                '_check_input_type', True
            )
            kwargs['_check_return_type'] = kwargs.get(
                '_check_return_type', True
            )
            kwargs['_host_index'] = kwargs.get('_host_index')
            kwargs['get_identity_verification_request'] = \
                get_identity_verification_request
            return self.call_with_http_info(**kwargs)

        self.identity_verification_get = _Endpoint(
            settings={
                'response_type': (IdentityVerificationResponse,),
                'auth': [
                    'clientId',
                    'plaidVersion',
                    'secret'
                ],
                'endpoint_path': '/identity_verification/get',
                'operation_id': 'identity_verification_get',
                'http_method': 'POST',
                'servers': None,
            },
            params_map={
                'all': [
                    'get_identity_verification_request',
                ],
                'required': [
                    'get_identity_verification_request',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'get_identity_verification_request':
                        (GetIdentityVerificationRequest,),
                },
                'attribute_map': {
                },
                'location_map': {
                    'get_identity_verification_request': 'body',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [
                    'application/json'
                ]
            },
            api_client=api_client,
            callable=__identity_verification_get
        )

        def __identity_verification_list(
            self,
            list_identity_verification_request,
            **kwargs
        ):
            """List Identity Verifications  # noqa: E501

            Filter and list Identity Verifications created by your account  # noqa: E501
            This method makes a synchronous HTTP request by default. To make an
            asynchronous HTTP request, please pass async_req=True

            >>> thread = api.identity_verification_list(list_identity_verification_request, async_req=True)
            >>> result = thread.get()

            Args:
                list_identity_verification_request (ListIdentityVerificationRequest):

            Keyword Args:
                _return_http_data_only (bool): response data without head status
                    code and headers. Default is True.
                _preload_content (bool): if False, the urllib3.HTTPResponse object
                    will be returned without reading/decoding response data.
                    Default is True.
                _request_timeout (float/tuple): timeout setting for this request. If one
                    number provided, it will be total request timeout. It can also
                    be a pair (tuple) of (connection, read) timeouts.
                    Default is None.
                _check_input_type (bool): specifies if type checking
                    should be done one the data sent to the server.
                    Default is True.
                _check_return_type (bool): specifies if type checking
                    should be done one the data received from the server.
                    Default is True.
                _host_index (int/None): specifies the index of the server
                    that we want to use.
                    Default is read from the configuration.
                async_req (bool): execute request asynchronously

            Returns:
                PaginatedIdentityVerificationListResponse
                    If the method is called asynchronously, returns the request
                    thread.
            """
            kwargs['async_req'] = kwargs.get(
                'async_req', False
            )
            kwargs['_return_http_data_only'] = kwargs.get(
                '_return_http_data_only', True
            )
            kwargs['_preload_content'] = kwargs.get(
                '_preload_content', True
            )
            kwargs['_request_timeout'] = kwargs.get(
                '_request_timeout', None
            )
            kwargs['_check_input_type'] = kwargs.get(
                '_check_input_type', True
            )
            kwargs['_check_return_type'] = kwargs.get(
                '_check_return_type', True
            )
            kwargs['_host_index'] = kwargs.get('_host_index')
            kwargs['list_identity_verification_request'] = \
                list_identity_verification_request
            return self.call_with_http_info(**kwargs)

        self.identity_verification_list = _Endpoint(
            settings={
                'response_type': (PaginatedIdentityVerificationListResponse,),
                'auth': [
                    'clientId',
                    'plaidVersion',
                    'secret'
                ],
                'endpoint_path': '/identity_verification/list',
                'operation_id': 'identity_verification_list',
                'http_method': 'POST',
                'servers': None,
            },
            params_map={
                'all': [
                    'list_identity_verification_request',
                ],
                'required': [
                    'list_identity_verification_request',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'list_identity_verification_request':
                        (ListIdentityVerificationRequest,),
                },
                'attribute_map': {
                },
                'location_map': {
                    'list_identity_verification_request': 'body',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [
                    'application/json'
                ]
            },
            api_client=api_client,
            callable=__identity_verification_list
        )

        def __identity_verification_retry(
            self,
            identity_verification_retry_request,
            **kwargs
        ):
            """Retry an Identity Verification  # noqa: E501

            Allow a customer to retry their identity verification  # noqa: E501
            This method makes a synchronous HTTP request by default. To make an
            asynchronous HTTP request, please pass async_req=True

            >>> thread = api.identity_verification_retry(identity_verification_retry_request, async_req=True)
            >>> result = thread.get()

            Args:
                identity_verification_retry_request (IdentityVerificationRetryRequest):

            Keyword Args:
                _return_http_data_only (bool): response data without head status
                    code and headers. Default is True.
                _preload_content (bool): if False, the urllib3.HTTPResponse object
                    will be returned without reading/decoding response data.
                    Default is True.
                _request_timeout (float/tuple): timeout setting for this request. If one
                    number provided, it will be total request timeout. It can also
                    be a pair (tuple) of (connection, read) timeouts.
                    Default is None.
                _check_input_type (bool): specifies if type checking
                    should be done one the data sent to the server.
                    Default is True.
                _check_return_type (bool): specifies if type checking
                    should be done one the data received from the server.
                    Default is True.
                _host_index (int/None): specifies the index of the server
                    that we want to use.
                    Default is read from the configuration.
                async_req (bool): execute request asynchronously

            Returns:
                IdentityVerificationResponse
                    If the method is called asynchronously, returns the request
                    thread.
            """
            kwargs['async_req'] = kwargs.get(
                'async_req', False
            )
            kwargs['_return_http_data_only'] = kwargs.get(
                '_return_http_data_only', True
            )
            kwargs['_preload_content'] = kwargs.get(
                '_preload_content', True
            )
            kwargs['_request_timeout'] = kwargs.get(
                '_request_timeout', None
            )
            kwargs['_check_input_type'] = kwargs.get(
                '_check_input_type', True
            )
            kwargs['_check_return_type'] = kwargs.get(
                '_check_return_type', True
            )
            kwargs['_host_index'] = kwargs.get('_host_index')
            kwargs['identity_verification_retry_request'] = \
                identity_verification_retry_request
            return self.call_with_http_info(**kwargs)

        self.identity_verification_retry = _Endpoint(
            settings={
                'response_type': (IdentityVerificationResponse,),
                'auth': [
                    'clientId',
                    'plaidVersion',
                    'secret'
                ],
                'endpoint_path': '/identity_verification/retry',
                'operation_id': 'identity_verification_retry',
                'http_method': 'POST',
                'servers': None,
            },
            params_map={
                'all': [
                    'identity_verification_retry_request',
                ],
                'required': [
                    'identity_verification_retry_request',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'identity_verification_retry_request':
                        (IdentityVerificationRetryRequest,),
                },
                'attribute_map': {
                },
                'location_map': {
                    'identity_verification_retry_request': 'body',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [
                    'application/json'
                ]
            },
            api_client=api_client,
            callable=__identity_verification_retry
        )

        def __income_verification_create(
            self,
            income_verification_create_request,
            **kwargs
        ):
            """(Deprecated) Create an income verification instance  # noqa: E501

            `/income/verification/create` begins the income verification process by returning an `income_verification_id`. You can then provide the `income_verification_id` to `/link/token/create` under the `income_verification` parameter in order to create a Link instance that will prompt the user to go through the income verification flow. Plaid will fire an `INCOME` webhook once the user completes the Payroll Income flow, or when the uploaded documents in the Document Income flow have finished processing.   # noqa: E501
            This method makes a synchronous HTTP request by default. To make an
            asynchronous HTTP request, please pass async_req=True

            >>> thread = api.income_verification_create(income_verification_create_request, async_req=True)
            >>> result = thread.get()

            Args:
                income_verification_create_request (IncomeVerificationCreateRequest):

            Keyword Args:
                _return_http_data_only (bool): response data without head status
                    code and headers. Default is True.
                _preload_content (bool): if False, the urllib3.HTTPResponse object
                    will be returned without reading/decoding response data.
                    Default is True.
                _request_timeout (float/tuple): timeout setting for this request. If one
                    number provided, it will be total request timeout. It can also
                    be a pair (tuple) of (connection, read) timeouts.
                    Default is None.
                _check_input_type (bool): specifies if type checking
                    should be done one the data sent to the server.
                    Default is True.
                _check_return_type (bool): specifies if type checking
                    should be done one the data received from the server.
                    Default is True.
                _host_index (int/None): specifies the index of the server
                    that we want to use.
                    Default is read from the configuration.
                async_req (bool): execute request asynchronously

            Returns:
                IncomeVerificationCreateResponse
                    If the method is called asynchronously, returns the request
                    thread.
            """
            kwargs['async_req'] = kwargs.get(
                'async_req', False
            )
            kwargs['_return_http_data_only'] = kwargs.get(
                '_return_http_data_only', True
            )
            kwargs['_preload_content'] = kwargs.get(
                '_preload_content', True
            )
            kwargs['_request_timeout'] = kwargs.get(
                '_request_timeout', None
            )
            kwargs['_check_input_type'] = kwargs.get(
                '_check_input_type', True
            )
            kwargs['_check_return_type'] = kwargs.get(
                '_check_return_type', True
            )
            kwargs['_host_index'] = kwargs.get('_host_index')
            kwargs['income_verification_create_request'] = \
                income_verification_create_request
            return self.call_with_http_info(**kwargs)

        self.income_verification_create = _Endpoint(
            settings={
                'response_type': (IncomeVerificationCreateResponse,),
                'auth': [
                    'clientId',
                    'plaidVersion',
                    'secret'
                ],
                'endpoint_path': '/income/verification/create',
                'operation_id': 'income_verification_create',
                'http_method': 'POST',
                'servers': None,
            },
            params_map={
                'all': [
                    'income_verification_create_request',
                ],
                'required': [
                    'income_verification_create_request',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'income_verification_create_request':
                        (IncomeVerificationCreateRequest,),
                },
                'attribute_map': {
                },
                'location_map': {
                    'income_verification_create_request': 'body',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [
                    'application/json'
                ]
            },
            api_client=api_client,
            callable=__income_verification_create
        )

        def __income_verification_documents_download(
            self,
            income_verification_documents_download_request,
            **kwargs
        ):
            """(Deprecated) Download the original documents used for income verification  # noqa: E501

            `/income/verification/documents/download` provides the ability to download the source documents associated with the verification.  If Document Income was used, the documents will be those the user provided in Link. For Payroll Income, the most recent files available for download from the payroll provider will be available from this endpoint.  The response to `/income/verification/documents/download` is a ZIP file in binary data. If a `document_id` is passed, a single document will be contained in this file. If not, the response will contain all documents associated with the verification.  The `request_id` is returned in the `Plaid-Request-ID` header.  # noqa: E501
            This method makes a synchronous HTTP request by default. To make an
            asynchronous HTTP request, please pass async_req=True

            >>> thread = api.income_verification_documents_download(income_verification_documents_download_request, async_req=True)
            >>> result = thread.get()

            Args:
                income_verification_documents_download_request (IncomeVerificationDocumentsDownloadRequest):

            Keyword Args:
                _return_http_data_only (bool): response data without head status
                    code and headers. Default is True.
                _preload_content (bool): if False, the urllib3.HTTPResponse object
                    will be returned without reading/decoding response data.
                    Default is True.
                _request_timeout (float/tuple): timeout setting for this request. If one
                    number provided, it will be total request timeout. It can also
                    be a pair (tuple) of (connection, read) timeouts.
                    Default is None.
                _check_input_type (bool): specifies if type checking
                    should be done one the data sent to the server.
                    Default is True.
                _check_return_type (bool): specifies if type checking
                    should be done one the data received from the server.
                    Default is True.
                _host_index (int/None): specifies the index of the server
                    that we want to use.
                    Default is read from the configuration.
                async_req (bool): execute request asynchronously

            Returns:
                file_type
                    If the method is called asynchronously, returns the request
                    thread.
            """
            kwargs['async_req'] = kwargs.get(
                'async_req', False
            )
            kwargs['_return_http_data_only'] = kwargs.get(
                '_return_http_data_only', True
            )
            kwargs['_preload_content'] = kwargs.get(
                '_preload_content', True
            )
            kwargs['_request_timeout'] = kwargs.get(
                '_request_timeout', None
            )
            kwargs['_check_input_type'] = kwargs.get(
                '_check_input_type', True
            )
            kwargs['_check_return_type'] = kwargs.get(
                '_check_return_type', True
            )
            kwargs['_host_index'] = kwargs.get('_host_index')
            kwargs['income_verification_documents_download_request'] = \
                income_verification_documents_download_request
            return self.call_with_http_info(**kwargs)

        self.income_verification_documents_download = _Endpoint(
            settings={
                'response_type': (file_type,),
                'auth': [
                    'clientId',
                    'plaidVersion',
                    'secret'
                ],
                'endpoint_path': '/income/verification/documents/download',
                'operation_id': 'income_verification_documents_download',
                'http_method': 'POST',
                'servers': None,
            },
            params_map={
                'all': [
                    'income_verification_documents_download_request',
                ],
                'required': [
                    'income_verification_documents_download_request',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'income_verification_documents_download_request':
                        (IncomeVerificationDocumentsDownloadRequest,),
                },
                'attribute_map': {
                },
                'location_map': {
                    'income_verification_documents_download_request': 'body',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/zip'
                ],
                'content_type': [
                    'application/json'
                ]
            },
            api_client=api_client,
            callable=__income_verification_documents_download
        )

        def __income_verification_paystubs_get(
            self,
            income_verification_paystubs_get_request,
            **kwargs
        ):
            """(Deprecated) Retrieve information from the paystubs used for income verification  # noqa: E501

            `/income/verification/paystubs/get` returns the information collected from the paystubs that were used to verify an end user's income. It can be called once the status of the verification has been set to `VERIFICATION_STATUS_PROCESSING_COMPLETE`, as reported by the `INCOME: verification_status` webhook. Attempting to call the endpoint before verification has been completed will result in an error.  This endpoint has been deprecated; new integrations should use `/credit/payroll_income/get` instead.  # noqa: E501
            This method makes a synchronous HTTP request by default. To make an
            asynchronous HTTP request, please pass async_req=True

            >>> thread = api.income_verification_paystubs_get(income_verification_paystubs_get_request, async_req=True)
            >>> result = thread.get()

            Args:
                income_verification_paystubs_get_request (IncomeVerificationPaystubsGetRequest):

            Keyword Args:
                _return_http_data_only (bool): response data without head status
                    code and headers. Default is True.
                _preload_content (bool): if False, the urllib3.HTTPResponse object
                    will be returned without reading/decoding response data.
                    Default is True.
                _request_timeout (float/tuple): timeout setting for this request. If one
                    number provided, it will be total request timeout. It can also
                    be a pair (tuple) of (connection, read) timeouts.
                    Default is None.
                _check_input_type (bool): specifies if type checking
                    should be done one the data sent to the server.
                    Default is True.
                _check_return_type (bool): specifies if type checking
                    should be done one the data received from the server.
                    Default is True.
                _host_index (int/None): specifies the index of the server
                    that we want to use.
                    Default is read from the configuration.
                async_req (bool): execute request asynchronously

            Returns:
                IncomeVerificationPaystubsGetResponse
                    If the method is called asynchronously, returns the request
                    thread.
            """
            kwargs['async_req'] = kwargs.get(
                'async_req', False
            )
            kwargs['_return_http_data_only'] = kwargs.get(
                '_return_http_data_only', True
            )
            kwargs['_preload_content'] = kwargs.get(
                '_preload_content', True
            )
            kwargs['_request_timeout'] = kwargs.get(
                '_request_timeout', None
            )
            kwargs['_check_input_type'] = kwargs.get(
                '_check_input_type', True
            )
            kwargs['_check_return_type'] = kwargs.get(
                '_check_return_type', True
            )
            kwargs['_host_index'] = kwargs.get('_host_index')
            kwargs['income_verification_paystubs_get_request'] = \
                income_verification_paystubs_get_request
            return self.call_with_http_info(**kwargs)

        self.income_verification_paystubs_get = _Endpoint(
            settings={
                'response_type': (IncomeVerificationPaystubsGetResponse,),
                'auth': [
                    'clientId',
                    'plaidVersion',
                    'secret'
                ],
                'endpoint_path': '/income/verification/paystubs/get',
                'operation_id': 'income_verification_paystubs_get',
                'http_method': 'POST',
                'servers': None,
            },
            params_map={
                'all': [
                    'income_verification_paystubs_get_request',
                ],
                'required': [
                    'income_verification_paystubs_get_request',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'income_verification_paystubs_get_request':
                        (IncomeVerificationPaystubsGetRequest,),
                },
                'attribute_map': {
                },
                'location_map': {
                    'income_verification_paystubs_get_request': 'body',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [
                    'application/json'
                ]
            },
            api_client=api_client,
            callable=__income_verification_paystubs_get
        )

        def __income_verification_precheck(
            self,
            income_verification_precheck_request,
            **kwargs
        ):
            """(Deprecated) Check digital income verification eligibility and optimize conversion  # noqa: E501

            `/income/verification/precheck` is an optional endpoint that can be called before initializing a Link session for income verification. It evaluates whether a given user is supportable by digital income verification and returns a `precheck_id` that can be provided to `/link/token/create`. If the user is eligible for digital verification, providing the `precheck_id` in this way will generate a Link UI optimized for the end user and their specific employer. If the user cannot be confirmed as eligible, the `precheck_id` can still be provided to `/link/token/create` and the user can still use the income verification flow, but they may be required to manually upload a paystub to verify their income.  While all request fields are optional, providing either `employer` or `transactions_access_tokens` data will increase the chance of receiving a useful result.  This endpoint has been deprecated; new integrations should use `/credit/payroll_income/precheck` instead.  # noqa: E501
            This method makes a synchronous HTTP request by default. To make an
            asynchronous HTTP request, please pass async_req=True

            >>> thread = api.income_verification_precheck(income_verification_precheck_request, async_req=True)
            >>> result = thread.get()

            Args:
                income_verification_precheck_request (IncomeVerificationPrecheckRequest):

            Keyword Args:
                _return_http_data_only (bool): response data without head status
                    code and headers. Default is True.
                _preload_content (bool): if False, the urllib3.HTTPResponse object
                    will be returned without reading/decoding response data.
                    Default is True.
                _request_timeout (float/tuple): timeout setting for this request. If one
                    number provided, it will be total request timeout. It can also
                    be a pair (tuple) of (connection, read) timeouts.
                    Default is None.
                _check_input_type (bool): specifies if type checking
                    should be done one the data sent to the server.
                    Default is True.
                _check_return_type (bool): specifies if type checking
                    should be done one the data received from the server.
                    Default is True.
                _host_index (int/None): specifies the index of the server
                    that we want to use.
                    Default is read from the configuration.
                async_req (bool): execute request asynchronously

            Returns:
                IncomeVerificationPrecheckResponse
                    If the method is called asynchronously, returns the request
                    thread.
            """
            kwargs['async_req'] = kwargs.get(
                'async_req', False
            )
            kwargs['_return_http_data_only'] = kwargs.get(
                '_return_http_data_only', True
            )
            kwargs['_preload_content'] = kwargs.get(
                '_preload_content', True
            )
            kwargs['_request_timeout'] = kwargs.get(
                '_request_timeout', None
            )
            kwargs['_check_input_type'] = kwargs.get(
                '_check_input_type', True
            )
            kwargs['_check_return_type'] = kwargs.get(
                '_check_return_type', True
            )
            kwargs['_host_index'] = kwargs.get('_host_index')
            kwargs['income_verification_precheck_request'] = \
                income_verification_precheck_request
            return self.call_with_http_info(**kwargs)

        self.income_verification_precheck = _Endpoint(
            settings={
                'response_type': (IncomeVerificationPrecheckResponse,),
                'auth': [
                    'clientId',
                    'plaidVersion',
                    'secret'
                ],
                'endpoint_path': '/income/verification/precheck',
                'operation_id': 'income_verification_precheck',
                'http_method': 'POST',
                'servers': None,
            },
            params_map={
                'all': [
                    'income_verification_precheck_request',
                ],
                'required': [
                    'income_verification_precheck_request',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'income_verification_precheck_request':
                        (IncomeVerificationPrecheckRequest,),
                },
                'attribute_map': {
                },
                'location_map': {
                    'income_verification_precheck_request': 'body',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [
                    'application/json'
                ]
            },
            api_client=api_client,
            callable=__income_verification_precheck
        )

        def __income_verification_refresh(
            self,
            income_verification_refresh_request,
            **kwargs
        ):
            """(Deprecated) Refresh an income verification  # noqa: E501

            `/income/verification/refresh` refreshes a given income verification.  # noqa: E501
            This method makes a synchronous HTTP request by default. To make an
            asynchronous HTTP request, please pass async_req=True

            >>> thread = api.income_verification_refresh(income_verification_refresh_request, async_req=True)
            >>> result = thread.get()

            Args:
                income_verification_refresh_request (IncomeVerificationRefreshRequest):

            Keyword Args:
                _return_http_data_only (bool): response data without head status
                    code and headers. Default is True.
                _preload_content (bool): if False, the urllib3.HTTPResponse object
                    will be returned without reading/decoding response data.
                    Default is True.
                _request_timeout (float/tuple): timeout setting for this request. If one
                    number provided, it will be total request timeout. It can also
                    be a pair (tuple) of (connection, read) timeouts.
                    Default is None.
                _check_input_type (bool): specifies if type checking
                    should be done one the data sent to the server.
                    Default is True.
                _check_return_type (bool): specifies if type checking
                    should be done one the data received from the server.
                    Default is True.
                _host_index (int/None): specifies the index of the server
                    that we want to use.
                    Default is read from the configuration.
                async_req (bool): execute request asynchronously

            Returns:
                IncomeVerificationRefreshResponse
                    If the method is called asynchronously, returns the request
                    thread.
            """
            kwargs['async_req'] = kwargs.get(
                'async_req', False
            )
            kwargs['_return_http_data_only'] = kwargs.get(
                '_return_http_data_only', True
            )
            kwargs['_preload_content'] = kwargs.get(
                '_preload_content', True
            )
            kwargs['_request_timeout'] = kwargs.get(
                '_request_timeout', None
            )
            kwargs['_check_input_type'] = kwargs.get(
                '_check_input_type', True
            )
            kwargs['_check_return_type'] = kwargs.get(
                '_check_return_type', True
            )
            kwargs['_host_index'] = kwargs.get('_host_index')
            kwargs['income_verification_refresh_request'] = \
                income_verification_refresh_request
            return self.call_with_http_info(**kwargs)

        self.income_verification_refresh = _Endpoint(
            settings={
                'response_type': (IncomeVerificationRefreshResponse,),
                'auth': [
                    'clientId',
                    'plaidVersion',
                    'secret'
                ],
                'endpoint_path': '/income/verification/refresh',
                'operation_id': 'income_verification_refresh',
                'http_method': 'POST',
                'servers': None,
            },
            params_map={
                'all': [
                    'income_verification_refresh_request',
                ],
                'required': [
                    'income_verification_refresh_request',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'income_verification_refresh_request':
                        (IncomeVerificationRefreshRequest,),
                },
                'attribute_map': {
                },
                'location_map': {
                    'income_verification_refresh_request': 'body',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [
                    'application/json'
                ]
            },
            api_client=api_client,
            callable=__income_verification_refresh
        )

        def __income_verification_taxforms_get(
            self,
            income_verification_taxforms_get_request,
            **kwargs
        ):
            """(Deprecated) Retrieve information from the tax documents used for income verification  # noqa: E501

            `/income/verification/taxforms/get` returns the information collected from forms that were used to verify an end user''s income. It can be called once the status of the verification has been set to `VERIFICATION_STATUS_PROCESSING_COMPLETE`, as reported by the `INCOME: verification_status` webhook. Attempting to call the endpoint before verification has been completed will result in an error.  This endpoint has been deprecated; new integrations should use `/credit/payroll_income/get` instead.  # noqa: E501
            This method makes a synchronous HTTP request by default. To make an
            asynchronous HTTP request, please pass async_req=True

            >>> thread = api.income_verification_taxforms_get(income_verification_taxforms_get_request, async_req=True)
            >>> result = thread.get()

            Args:
                income_verification_taxforms_get_request (IncomeVerificationTaxformsGetRequest):

            Keyword Args:
                _return_http_data_only (bool): response data without head status
                    code and headers. Default is True.
                _preload_content (bool): if False, the urllib3.HTTPResponse object
                    will be returned without reading/decoding response data.
                    Default is True.
                _request_timeout (float/tuple): timeout setting for this request. If one
                    number provided, it will be total request timeout. It can also
                    be a pair (tuple) of (connection, read) timeouts.
                    Default is None.
                _check_input_type (bool): specifies if type checking
                    should be done one the data sent to the server.
                    Default is True.
                _check_return_type (bool): specifies if type checking
                    should be done one the data received from the server.
                    Default is True.
                _host_index (int/None): specifies the index of the server
                    that we want to use.
                    Default is read from the configuration.
                async_req (bool): execute request asynchronously

            Returns:
                IncomeVerificationTaxformsGetResponse
                    If the method is called asynchronously, returns the request
                    thread.
            """
            kwargs['async_req'] = kwargs.get(
                'async_req', False
            )
            kwargs['_return_http_data_only'] = kwargs.get(
                '_return_http_data_only', True
            )
            kwargs['_preload_content'] = kwargs.get(
                '_preload_content', True
            )
            kwargs['_request_timeout'] = kwargs.get(
                '_request_timeout', None
            )
            kwargs['_check_input_type'] = kwargs.get(
                '_check_input_type', True
            )
            kwargs['_check_return_type'] = kwargs.get(
                '_check_return_type', True
            )
            kwargs['_host_index'] = kwargs.get('_host_index')
            kwargs['income_verification_taxforms_get_request'] = \
                income_verification_taxforms_get_request
            return self.call_with_http_info(**kwargs)

        self.income_verification_taxforms_get = _Endpoint(
            settings={
                'response_type': (IncomeVerificationTaxformsGetResponse,),
                'auth': [
                    'clientId',
                    'plaidVersion',
                    'secret'
                ],
                'endpoint_path': '/income/verification/taxforms/get',
                'operation_id': 'income_verification_taxforms_get',
                'http_method': 'POST',
                'servers': None,
            },
            params_map={
                'all': [
                    'income_verification_taxforms_get_request',
                ],
                'required': [
                    'income_verification_taxforms_get_request',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'income_verification_taxforms_get_request':
                        (IncomeVerificationTaxformsGetRequest,),
                },
                'attribute_map': {
                },
                'location_map': {
                    'income_verification_taxforms_get_request': 'body',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [
                    'application/json'
                ]
            },
            api_client=api_client,
            callable=__income_verification_taxforms_get
        )

        def __institutions_get(
            self,
            institutions_get_request,
            **kwargs
        ):
            """Get details of all supported institutions  # noqa: E501

            Returns a JSON response containing details on all financial institutions currently supported by Plaid. Because Plaid supports thousands of institutions, results are paginated.  If there is no overlap between an institution’s enabled products and a client’s enabled products, then the institution will be filtered out from the response. As a result, the number of institutions returned may not match the count specified in the call.  # noqa: E501
            This method makes a synchronous HTTP request by default. To make an
            asynchronous HTTP request, please pass async_req=True

            >>> thread = api.institutions_get(institutions_get_request, async_req=True)
            >>> result = thread.get()

            Args:
                institutions_get_request (InstitutionsGetRequest):

            Keyword Args:
                _return_http_data_only (bool): response data without head status
                    code and headers. Default is True.
                _preload_content (bool): if False, the urllib3.HTTPResponse object
                    will be returned without reading/decoding response data.
                    Default is True.
                _request_timeout (float/tuple): timeout setting for this request. If one
                    number provided, it will be total request timeout. It can also
                    be a pair (tuple) of (connection, read) timeouts.
                    Default is None.
                _check_input_type (bool): specifies if type checking
                    should be done one the data sent to the server.
                    Default is True.
                _check_return_type (bool): specifies if type checking
                    should be done one the data received from the server.
                    Default is True.
                _host_index (int/None): specifies the index of the server
                    that we want to use.
                    Default is read from the configuration.
                async_req (bool): execute request asynchronously

            Returns:
                InstitutionsGetResponse
                    If the method is called asynchronously, returns the request
                    thread.
            """
            kwargs['async_req'] = kwargs.get(
                'async_req', False
            )
            kwargs['_return_http_data_only'] = kwargs.get(
                '_return_http_data_only', True
            )
            kwargs['_preload_content'] = kwargs.get(
                '_preload_content', True
            )
            kwargs['_request_timeout'] = kwargs.get(
                '_request_timeout', None
            )
            kwargs['_check_input_type'] = kwargs.get(
                '_check_input_type', True
            )
            kwargs['_check_return_type'] = kwargs.get(
                '_check_return_type', True
            )
            kwargs['_host_index'] = kwargs.get('_host_index')
            kwargs['institutions_get_request'] = \
                institutions_get_request
            return self.call_with_http_info(**kwargs)

        self.institutions_get = _Endpoint(
            settings={
                'response_type': (InstitutionsGetResponse,),
                'auth': [
                    'clientId',
                    'plaidVersion',
                    'secret'
                ],
                'endpoint_path': '/institutions/get',
                'operation_id': 'institutions_get',
                'http_method': 'POST',
                'servers': None,
            },
            params_map={
                'all': [
                    'institutions_get_request',
                ],
                'required': [
                    'institutions_get_request',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'institutions_get_request':
                        (InstitutionsGetRequest,),
                },
                'attribute_map': {
                },
                'location_map': {
                    'institutions_get_request': 'body',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [
                    'application/json'
                ]
            },
            api_client=api_client,
            callable=__institutions_get
        )

        def __institutions_get_by_id(
            self,
            institutions_get_by_id_request,
            **kwargs
        ):
            """Get details of an institution  # noqa: E501

            Returns a JSON response containing details on a specified financial institution currently supported by Plaid.  Versioning note: API versions 2019-05-29 and earlier allow use of the `public_key` parameter instead of the `client_id` and `secret` to authenticate to this endpoint. The `public_key` has been deprecated; all customers are encouraged to use `client_id` and `secret` instead.   # noqa: E501
            This method makes a synchronous HTTP request by default. To make an
            asynchronous HTTP request, please pass async_req=True

            >>> thread = api.institutions_get_by_id(institutions_get_by_id_request, async_req=True)
            >>> result = thread.get()

            Args:
                institutions_get_by_id_request (InstitutionsGetByIdRequest):

            Keyword Args:
                _return_http_data_only (bool): response data without head status
                    code and headers. Default is True.
                _preload_content (bool): if False, the urllib3.HTTPResponse object
                    will be returned without reading/decoding response data.
                    Default is True.
                _request_timeout (float/tuple): timeout setting for this request. If one
                    number provided, it will be total request timeout. It can also
                    be a pair (tuple) of (connection, read) timeouts.
                    Default is None.
                _check_input_type (bool): specifies if type checking
                    should be done one the data sent to the server.
                    Default is True.
                _check_return_type (bool): specifies if type checking
                    should be done one the data received from the server.
                    Default is True.
                _host_index (int/None): specifies the index of the server
                    that we want to use.
                    Default is read from the configuration.
                async_req (bool): execute request asynchronously

            Returns:
                InstitutionsGetByIdResponse
                    If the method is called asynchronously, returns the request
                    thread.
            """
            kwargs['async_req'] = kwargs.get(
                'async_req', False
            )
            kwargs['_return_http_data_only'] = kwargs.get(
                '_return_http_data_only', True
            )
            kwargs['_preload_content'] = kwargs.get(
                '_preload_content', True
            )
            kwargs['_request_timeout'] = kwargs.get(
                '_request_timeout', None
            )
            kwargs['_check_input_type'] = kwargs.get(
                '_check_input_type', True
            )
            kwargs['_check_return_type'] = kwargs.get(
                '_check_return_type', True
            )
            kwargs['_host_index'] = kwargs.get('_host_index')
            kwargs['institutions_get_by_id_request'] = \
                institutions_get_by_id_request
            return self.call_with_http_info(**kwargs)

        self.institutions_get_by_id = _Endpoint(
            settings={
                'response_type': (InstitutionsGetByIdResponse,),
                'auth': [
                    'clientId',
                    'plaidVersion',
                    'secret'
                ],
                'endpoint_path': '/institutions/get_by_id',
                'operation_id': 'institutions_get_by_id',
                'http_method': 'POST',
                'servers': None,
            },
            params_map={
                'all': [
                    'institutions_get_by_id_request',
                ],
                'required': [
                    'institutions_get_by_id_request',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'institutions_get_by_id_request':
                        (InstitutionsGetByIdRequest,),
                },
                'attribute_map': {
                },
                'location_map': {
                    'institutions_get_by_id_request': 'body',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [
                    'application/json'
                ]
            },
            api_client=api_client,
            callable=__institutions_get_by_id
        )

        def __institutions_search(
            self,
            institutions_search_request,
            **kwargs
        ):
            """Search institutions  # noqa: E501

            Returns a JSON response containing details for institutions that match the query parameters, up to a maximum of ten institutions per query.  Versioning note: API versions 2019-05-29 and earlier allow use of the `public_key` parameter instead of the `client_id` and `secret` parameters to authenticate to this endpoint. The `public_key` parameter has since been deprecated; all customers are encouraged to use `client_id` and `secret` instead.   # noqa: E501
            This method makes a synchronous HTTP request by default. To make an
            asynchronous HTTP request, please pass async_req=True

            >>> thread = api.institutions_search(institutions_search_request, async_req=True)
            >>> result = thread.get()

            Args:
                institutions_search_request (InstitutionsSearchRequest):

            Keyword Args:
                _return_http_data_only (bool): response data without head status
                    code and headers. Default is True.
                _preload_content (bool): if False, the urllib3.HTTPResponse object
                    will be returned without reading/decoding response data.
                    Default is True.
                _request_timeout (float/tuple): timeout setting for this request. If one
                    number provided, it will be total request timeout. It can also
                    be a pair (tuple) of (connection, read) timeouts.
                    Default is None.
                _check_input_type (bool): specifies if type checking
                    should be done one the data sent to the server.
                    Default is True.
                _check_return_type (bool): specifies if type checking
                    should be done one the data received from the server.
                    Default is True.
                _host_index (int/None): specifies the index of the server
                    that we want to use.
                    Default is read from the configuration.
                async_req (bool): execute request asynchronously

            Returns:
                InstitutionsSearchResponse
                    If the method is called asynchronously, returns the request
                    thread.
            """
            kwargs['async_req'] = kwargs.get(
                'async_req', False
            )
            kwargs['_return_http_data_only'] = kwargs.get(
                '_return_http_data_only', True
            )
            kwargs['_preload_content'] = kwargs.get(
                '_preload_content', True
            )
            kwargs['_request_timeout'] = kwargs.get(
                '_request_timeout', None
            )
            kwargs['_check_input_type'] = kwargs.get(
                '_check_input_type', True
            )
            kwargs['_check_return_type'] = kwargs.get(
                '_check_return_type', True
            )
            kwargs['_host_index'] = kwargs.get('_host_index')
            kwargs['institutions_search_request'] = \
                institutions_search_request
            return self.call_with_http_info(**kwargs)

        self.institutions_search = _Endpoint(
            settings={
                'response_type': (InstitutionsSearchResponse,),
                'auth': [
                    'clientId',
                    'plaidVersion',
                    'secret'
                ],
                'endpoint_path': '/institutions/search',
                'operation_id': 'institutions_search',
                'http_method': 'POST',
                'servers': None,
            },
            params_map={
                'all': [
                    'institutions_search_request',
                ],
                'required': [
                    'institutions_search_request',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'institutions_search_request':
                        (InstitutionsSearchRequest,),
                },
                'attribute_map': {
                },
                'location_map': {
                    'institutions_search_request': 'body',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [
                    'application/json'
                ]
            },
            api_client=api_client,
            callable=__institutions_search
        )

        def __investments_holdings_get(
            self,
            investments_holdings_get_request,
            **kwargs
        ):
            """Get Investment holdings  # noqa: E501

            The `/investments/holdings/get` endpoint allows developers to receive user-authorized stock position data for `investment`-type accounts.  # noqa: E501
            This method makes a synchronous HTTP request by default. To make an
            asynchronous HTTP request, please pass async_req=True

            >>> thread = api.investments_holdings_get(investments_holdings_get_request, async_req=True)
            >>> result = thread.get()

            Args:
                investments_holdings_get_request (InvestmentsHoldingsGetRequest):

            Keyword Args:
                _return_http_data_only (bool): response data without head status
                    code and headers. Default is True.
                _preload_content (bool): if False, the urllib3.HTTPResponse object
                    will be returned without reading/decoding response data.
                    Default is True.
                _request_timeout (float/tuple): timeout setting for this request. If one
                    number provided, it will be total request timeout. It can also
                    be a pair (tuple) of (connection, read) timeouts.
                    Default is None.
                _check_input_type (bool): specifies if type checking
                    should be done one the data sent to the server.
                    Default is True.
                _check_return_type (bool): specifies if type checking
                    should be done one the data received from the server.
                    Default is True.
                _host_index (int/None): specifies the index of the server
                    that we want to use.
                    Default is read from the configuration.
                async_req (bool): execute request asynchronously

            Returns:
                InvestmentsHoldingsGetResponse
                    If the method is called asynchronously, returns the request
                    thread.
            """
            kwargs['async_req'] = kwargs.get(
                'async_req', False
            )
            kwargs['_return_http_data_only'] = kwargs.get(
                '_return_http_data_only', True
            )
            kwargs['_preload_content'] = kwargs.get(
                '_preload_content', True
            )
            kwargs['_request_timeout'] = kwargs.get(
                '_request_timeout', None
            )
            kwargs['_check_input_type'] = kwargs.get(
                '_check_input_type', True
            )
            kwargs['_check_return_type'] = kwargs.get(
                '_check_return_type', True
            )
            kwargs['_host_index'] = kwargs.get('_host_index')
            kwargs['investments_holdings_get_request'] = \
                investments_holdings_get_request
            return self.call_with_http_info(**kwargs)

        self.investments_holdings_get = _Endpoint(
            settings={
                'response_type': (InvestmentsHoldingsGetResponse,),
                'auth': [
                    'clientId',
                    'plaidVersion',
                    'secret'
                ],
                'endpoint_path': '/investments/holdings/get',
                'operation_id': 'investments_holdings_get',
                'http_method': 'POST',
                'servers': None,
            },
            params_map={
                'all': [
                    'investments_holdings_get_request',
                ],
                'required': [
                    'investments_holdings_get_request',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'investments_holdings_get_request':
                        (InvestmentsHoldingsGetRequest,),
                },
                'attribute_map': {
                },
                'location_map': {
                    'investments_holdings_get_request': 'body',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [
                    'application/json'
                ]
            },
            api_client=api_client,
            callable=__investments_holdings_get
        )

        def __investments_transactions_get(
            self,
            investments_transactions_get_request,
            **kwargs
        ):
            """Get investment transactions  # noqa: E501

            The `/investments/transactions/get` endpoint allows developers to retrieve up to 24 months of user-authorized transaction data for investment accounts.  Transactions are returned in reverse-chronological order, and the sequence of transaction ordering is stable and will not shift.  Due to the potentially large number of investment transactions associated with an Item, results are paginated. Manipulate the count and offset parameters in conjunction with the `total_investment_transactions` response body field to fetch all available investment transactions.  # noqa: E501
            This method makes a synchronous HTTP request by default. To make an
            asynchronous HTTP request, please pass async_req=True

            >>> thread = api.investments_transactions_get(investments_transactions_get_request, async_req=True)
            >>> result = thread.get()

            Args:
                investments_transactions_get_request (InvestmentsTransactionsGetRequest):

            Keyword Args:
                _return_http_data_only (bool): response data without head status
                    code and headers. Default is True.
                _preload_content (bool): if False, the urllib3.HTTPResponse object
                    will be returned without reading/decoding response data.
                    Default is True.
                _request_timeout (float/tuple): timeout setting for this request. If one
                    number provided, it will be total request timeout. It can also
                    be a pair (tuple) of (connection, read) timeouts.
                    Default is None.
                _check_input_type (bool): specifies if type checking
                    should be done one the data sent to the server.
                    Default is True.
                _check_return_type (bool): specifies if type checking
                    should be done one the data received from the server.
                    Default is True.
                _host_index (int/None): specifies the index of the server
                    that we want to use.
                    Default is read from the configuration.
                async_req (bool): execute request asynchronously

            Returns:
                InvestmentsTransactionsGetResponse
                    If the method is called asynchronously, returns the request
                    thread.
            """
            kwargs['async_req'] = kwargs.get(
                'async_req', False
            )
            kwargs['_return_http_data_only'] = kwargs.get(
                '_return_http_data_only', True
            )
            kwargs['_preload_content'] = kwargs.get(
                '_preload_content', True
            )
            kwargs['_request_timeout'] = kwargs.get(
                '_request_timeout', None
            )
            kwargs['_check_input_type'] = kwargs.get(
                '_check_input_type', True
            )
            kwargs['_check_return_type'] = kwargs.get(
                '_check_return_type', True
            )
            kwargs['_host_index'] = kwargs.get('_host_index')
            kwargs['investments_transactions_get_request'] = \
                investments_transactions_get_request
            return self.call_with_http_info(**kwargs)

        self.investments_transactions_get = _Endpoint(
            settings={
                'response_type': (InvestmentsTransactionsGetResponse,),
                'auth': [
                    'clientId',
                    'plaidVersion',
                    'secret'
                ],
                'endpoint_path': '/investments/transactions/get',
                'operation_id': 'investments_transactions_get',
                'http_method': 'POST',
                'servers': None,
            },
            params_map={
                'all': [
                    'investments_transactions_get_request',
                ],
                'required': [
                    'investments_transactions_get_request',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'investments_transactions_get_request':
                        (InvestmentsTransactionsGetRequest,),
                },
                'attribute_map': {
                },
                'location_map': {
                    'investments_transactions_get_request': 'body',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [
                    'application/json'
                ]
            },
            api_client=api_client,
            callable=__investments_transactions_get
        )

        def __item_access_token_invalidate(
            self,
            item_access_token_invalidate_request,
            **kwargs
        ):
            """Invalidate access_token  # noqa: E501

            By default, the `access_token` associated with an Item does not expire and should be stored in a persistent, secure manner.  You can use the `/item/access_token/invalidate` endpoint to rotate the `access_token` associated with an Item. The endpoint returns a new `access_token` and immediately invalidates the previous `access_token`.   # noqa: E501
            This method makes a synchronous HTTP request by default. To make an
            asynchronous HTTP request, please pass async_req=True

            >>> thread = api.item_access_token_invalidate(item_access_token_invalidate_request, async_req=True)
            >>> result = thread.get()

            Args:
                item_access_token_invalidate_request (ItemAccessTokenInvalidateRequest):

            Keyword Args:
                _return_http_data_only (bool): response data without head status
                    code and headers. Default is True.
                _preload_content (bool): if False, the urllib3.HTTPResponse object
                    will be returned without reading/decoding response data.
                    Default is True.
                _request_timeout (float/tuple): timeout setting for this request. If one
                    number provided, it will be total request timeout. It can also
                    be a pair (tuple) of (connection, read) timeouts.
                    Default is None.
                _check_input_type (bool): specifies if type checking
                    should be done one the data sent to the server.
                    Default is True.
                _check_return_type (bool): specifies if type checking
                    should be done one the data received from the server.
                    Default is True.
                _host_index (int/None): specifies the index of the server
                    that we want to use.
                    Default is read from the configuration.
                async_req (bool): execute request asynchronously

            Returns:
                ItemAccessTokenInvalidateResponse
                    If the method is called asynchronously, returns the request
                    thread.
            """
            kwargs['async_req'] = kwargs.get(
                'async_req', False
            )
            kwargs['_return_http_data_only'] = kwargs.get(
                '_return_http_data_only', True
            )
            kwargs['_preload_content'] = kwargs.get(
                '_preload_content', True
            )
            kwargs['_request_timeout'] = kwargs.get(
                '_request_timeout', None
            )
            kwargs['_check_input_type'] = kwargs.get(
                '_check_input_type', True
            )
            kwargs['_check_return_type'] = kwargs.get(
                '_check_return_type', True
            )
            kwargs['_host_index'] = kwargs.get('_host_index')
            kwargs['item_access_token_invalidate_request'] = \
                item_access_token_invalidate_request
            return self.call_with_http_info(**kwargs)

        self.item_access_token_invalidate = _Endpoint(
            settings={
                'response_type': (ItemAccessTokenInvalidateResponse,),
                'auth': [
                    'clientId',
                    'plaidVersion',
                    'secret'
                ],
                'endpoint_path': '/item/access_token/invalidate',
                'operation_id': 'item_access_token_invalidate',
                'http_method': 'POST',
                'servers': None,
            },
            params_map={
                'all': [
                    'item_access_token_invalidate_request',
                ],
                'required': [
                    'item_access_token_invalidate_request',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'item_access_token_invalidate_request':
                        (ItemAccessTokenInvalidateRequest,),
                },
                'attribute_map': {
                },
                'location_map': {
                    'item_access_token_invalidate_request': 'body',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [
                    'application/json'
                ]
            },
            api_client=api_client,
            callable=__item_access_token_invalidate
        )

        def __item_application_list(
            self,
            item_application_list_request,
            **kwargs
        ):
            """List a user’s connected applications  # noqa: E501

            List a user’s connected applications  # noqa: E501
            This method makes a synchronous HTTP request by default. To make an
            asynchronous HTTP request, please pass async_req=True

            >>> thread = api.item_application_list(item_application_list_request, async_req=True)
            >>> result = thread.get()

            Args:
                item_application_list_request (ItemApplicationListRequest):

            Keyword Args:
                _return_http_data_only (bool): response data without head status
                    code and headers. Default is True.
                _preload_content (bool): if False, the urllib3.HTTPResponse object
                    will be returned without reading/decoding response data.
                    Default is True.
                _request_timeout (float/tuple): timeout setting for this request. If one
                    number provided, it will be total request timeout. It can also
                    be a pair (tuple) of (connection, read) timeouts.
                    Default is None.
                _check_input_type (bool): specifies if type checking
                    should be done one the data sent to the server.
                    Default is True.
                _check_return_type (bool): specifies if type checking
                    should be done one the data received from the server.
                    Default is True.
                _host_index (int/None): specifies the index of the server
                    that we want to use.
                    Default is read from the configuration.
                async_req (bool): execute request asynchronously

            Returns:
                ItemApplicationListResponse
                    If the method is called asynchronously, returns the request
                    thread.
            """
            kwargs['async_req'] = kwargs.get(
                'async_req', False
            )
            kwargs['_return_http_data_only'] = kwargs.get(
                '_return_http_data_only', True
            )
            kwargs['_preload_content'] = kwargs.get(
                '_preload_content', True
            )
            kwargs['_request_timeout'] = kwargs.get(
                '_request_timeout', None
            )
            kwargs['_check_input_type'] = kwargs.get(
                '_check_input_type', True
            )
            kwargs['_check_return_type'] = kwargs.get(
                '_check_return_type', True
            )
            kwargs['_host_index'] = kwargs.get('_host_index')
            kwargs['item_application_list_request'] = \
                item_application_list_request
            return self.call_with_http_info(**kwargs)

        self.item_application_list = _Endpoint(
            settings={
                'response_type': (ItemApplicationListResponse,),
                'auth': [
                    'clientId',
                    'plaidVersion',
                    'secret'
                ],
                'endpoint_path': '/item/application/list',
                'operation_id': 'item_application_list',
                'http_method': 'POST',
                'servers': None,
            },
            params_map={
                'all': [
                    'item_application_list_request',
                ],
                'required': [
                    'item_application_list_request',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'item_application_list_request':
                        (ItemApplicationListRequest,),
                },
                'attribute_map': {
                },
                'location_map': {
                    'item_application_list_request': 'body',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [
                    'application/json'
                ]
            },
            api_client=api_client,
            callable=__item_application_list
        )

        def __item_application_scopes_update(
            self,
            item_application_scopes_update_request,
            **kwargs
        ):
            """Update the scopes of access for a particular application  # noqa: E501

            Enable consumers to update product access on selected accounts for an application.  # noqa: E501
            This method makes a synchronous HTTP request by default. To make an
            asynchronous HTTP request, please pass async_req=True

            >>> thread = api.item_application_scopes_update(item_application_scopes_update_request, async_req=True)
            >>> result = thread.get()

            Args:
                item_application_scopes_update_request (ItemApplicationScopesUpdateRequest):

            Keyword Args:
                _return_http_data_only (bool): response data without head status
                    code and headers. Default is True.
                _preload_content (bool): if False, the urllib3.HTTPResponse object
                    will be returned without reading/decoding response data.
                    Default is True.
                _request_timeout (float/tuple): timeout setting for this request. If one
                    number provided, it will be total request timeout. It can also
                    be a pair (tuple) of (connection, read) timeouts.
                    Default is None.
                _check_input_type (bool): specifies if type checking
                    should be done one the data sent to the server.
                    Default is True.
                _check_return_type (bool): specifies if type checking
                    should be done one the data received from the server.
                    Default is True.
                _host_index (int/None): specifies the index of the server
                    that we want to use.
                    Default is read from the configuration.
                async_req (bool): execute request asynchronously

            Returns:
                ItemApplicationScopesUpdateResponse
                    If the method is called asynchronously, returns the request
                    thread.
            """
            kwargs['async_req'] = kwargs.get(
                'async_req', False
            )
            kwargs['_return_http_data_only'] = kwargs.get(
                '_return_http_data_only', True
            )
            kwargs['_preload_content'] = kwargs.get(
                '_preload_content', True
            )
            kwargs['_request_timeout'] = kwargs.get(
                '_request_timeout', None
            )
            kwargs['_check_input_type'] = kwargs.get(
                '_check_input_type', True
            )
            kwargs['_check_return_type'] = kwargs.get(
                '_check_return_type', True
            )
            kwargs['_host_index'] = kwargs.get('_host_index')
            kwargs['item_application_scopes_update_request'] = \
                item_application_scopes_update_request
            return self.call_with_http_info(**kwargs)

        self.item_application_scopes_update = _Endpoint(
            settings={
                'response_type': (ItemApplicationScopesUpdateResponse,),
                'auth': [
                    'clientId',
                    'plaidVersion',
                    'secret'
                ],
                'endpoint_path': '/item/application/scopes/update',
                'operation_id': 'item_application_scopes_update',
                'http_method': 'POST',
                'servers': None,
            },
            params_map={
                'all': [
                    'item_application_scopes_update_request',
                ],
                'required': [
                    'item_application_scopes_update_request',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'item_application_scopes_update_request':
                        (ItemApplicationScopesUpdateRequest,),
                },
                'attribute_map': {
                },
                'location_map': {
                    'item_application_scopes_update_request': 'body',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [
                    'application/json'
                ]
            },
            api_client=api_client,
            callable=__item_application_scopes_update
        )

        def __item_create_public_token(
            self,
            item_public_token_create_request,
            **kwargs
        ):
            """Create public token  # noqa: E501

            Note: As of July 2020, the `/item/public_token/create` endpoint is deprecated. Instead, use `/link/token/create` with an `access_token` to create a Link token for use with [update mode](https://plaid.com/docs/link/update-mode).  If you need your user to take action to restore or resolve an error associated with an Item, generate a public token with the `/item/public_token/create` endpoint and then initialize Link with that `public_token`.  A `public_token` is one-time use and expires after 30 minutes. You use a `public_token` to initialize Link in [update mode](https://plaid.com/docs/link/update-mode) for a particular Item. You can generate a `public_token` for an Item even if you did not use Link to create the Item originally.  The `/item/public_token/create` endpoint is **not** used to create your initial `public_token`. If you have not already received an `access_token` for a specific Item, use Link to obtain your `public_token` instead. See the [Quickstart](https://plaid.com/docs/quickstart) for more information.  # noqa: E501
            This method makes a synchronous HTTP request by default. To make an
            asynchronous HTTP request, please pass async_req=True

            >>> thread = api.item_create_public_token(item_public_token_create_request, async_req=True)
            >>> result = thread.get()

            Args:
                item_public_token_create_request (ItemPublicTokenCreateRequest):

            Keyword Args:
                _return_http_data_only (bool): response data without head status
                    code and headers. Default is True.
                _preload_content (bool): if False, the urllib3.HTTPResponse object
                    will be returned without reading/decoding response data.
                    Default is True.
                _request_timeout (float/tuple): timeout setting for this request. If one
                    number provided, it will be total request timeout. It can also
                    be a pair (tuple) of (connection, read) timeouts.
                    Default is None.
                _check_input_type (bool): specifies if type checking
                    should be done one the data sent to the server.
                    Default is True.
                _check_return_type (bool): specifies if type checking
                    should be done one the data received from the server.
                    Default is True.
                _host_index (int/None): specifies the index of the server
                    that we want to use.
                    Default is read from the configuration.
                async_req (bool): execute request asynchronously

            Returns:
                ItemPublicTokenCreateResponse
                    If the method is called asynchronously, returns the request
                    thread.
            """
            kwargs['async_req'] = kwargs.get(
                'async_req', False
            )
            kwargs['_return_http_data_only'] = kwargs.get(
                '_return_http_data_only', True
            )
            kwargs['_preload_content'] = kwargs.get(
                '_preload_content', True
            )
            kwargs['_request_timeout'] = kwargs.get(
                '_request_timeout', None
            )
            kwargs['_check_input_type'] = kwargs.get(
                '_check_input_type', True
            )
            kwargs['_check_return_type'] = kwargs.get(
                '_check_return_type', True
            )
            kwargs['_host_index'] = kwargs.get('_host_index')
            kwargs['item_public_token_create_request'] = \
                item_public_token_create_request
            return self.call_with_http_info(**kwargs)

        self.item_create_public_token = _Endpoint(
            settings={
                'response_type': (ItemPublicTokenCreateResponse,),
                'auth': [
                    'clientId',
                    'plaidVersion',
                    'secret'
                ],
                'endpoint_path': '/item/public_token/create',
                'operation_id': 'item_create_public_token',
                'http_method': 'POST',
                'servers': None,
            },
            params_map={
                'all': [
                    'item_public_token_create_request',
                ],
                'required': [
                    'item_public_token_create_request',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'item_public_token_create_request':
                        (ItemPublicTokenCreateRequest,),
                },
                'attribute_map': {
                },
                'location_map': {
                    'item_public_token_create_request': 'body',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [
                    'application/json'
                ]
            },
            api_client=api_client,
            callable=__item_create_public_token
        )

        def __item_get(
            self,
            item_get_request,
            **kwargs
        ):
            """Retrieve an Item  # noqa: E501

            Returns information about the status of an Item.  # noqa: E501
            This method makes a synchronous HTTP request by default. To make an
            asynchronous HTTP request, please pass async_req=True

            >>> thread = api.item_get(item_get_request, async_req=True)
            >>> result = thread.get()

            Args:
                item_get_request (ItemGetRequest):

            Keyword Args:
                _return_http_data_only (bool): response data without head status
                    code and headers. Default is True.
                _preload_content (bool): if False, the urllib3.HTTPResponse object
                    will be returned without reading/decoding response data.
                    Default is True.
                _request_timeout (float/tuple): timeout setting for this request. If one
                    number provided, it will be total request timeout. It can also
                    be a pair (tuple) of (connection, read) timeouts.
                    Default is None.
                _check_input_type (bool): specifies if type checking
                    should be done one the data sent to the server.
                    Default is True.
                _check_return_type (bool): specifies if type checking
                    should be done one the data received from the server.
                    Default is True.
                _host_index (int/None): specifies the index of the server
                    that we want to use.
                    Default is read from the configuration.
                async_req (bool): execute request asynchronously

            Returns:
                ItemGetResponse
                    If the method is called asynchronously, returns the request
                    thread.
            """
            kwargs['async_req'] = kwargs.get(
                'async_req', False
            )
            kwargs['_return_http_data_only'] = kwargs.get(
                '_return_http_data_only', True
            )
            kwargs['_preload_content'] = kwargs.get(
                '_preload_content', True
            )
            kwargs['_request_timeout'] = kwargs.get(
                '_request_timeout', None
            )
            kwargs['_check_input_type'] = kwargs.get(
                '_check_input_type', True
            )
            kwargs['_check_return_type'] = kwargs.get(
                '_check_return_type', True
            )
            kwargs['_host_index'] = kwargs.get('_host_index')
            kwargs['item_get_request'] = \
                item_get_request
            return self.call_with_http_info(**kwargs)

        self.item_get = _Endpoint(
            settings={
                'response_type': (ItemGetResponse,),
                'auth': [
                    'clientId',
                    'plaidVersion',
                    'secret'
                ],
                'endpoint_path': '/item/get',
                'operation_id': 'item_get',
                'http_method': 'POST',
                'servers': None,
            },
            params_map={
                'all': [
                    'item_get_request',
                ],
                'required': [
                    'item_get_request',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'item_get_request':
                        (ItemGetRequest,),
                },
                'attribute_map': {
                },
                'location_map': {
                    'item_get_request': 'body',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [
                    'application/json'
                ]
            },
            api_client=api_client,
            callable=__item_get
        )

        def __item_import(
            self,
            item_import_request,
            **kwargs
        ):
            """Import Item  # noqa: E501

            `/item/import` creates an Item via your Plaid Exchange Integration and returns an `access_token`. As part of an `/item/import` request, you will include a User ID (`user_auth.user_id`) and Authentication Token (`user_auth.auth_token`) that enable data aggregation through your Plaid Exchange API endpoints. These authentication principals are to be chosen by you.  Upon creating an Item via `/item/import`, Plaid will automatically begin an extraction of that Item through the Plaid Exchange infrastructure you have already integrated. This will automatically generate the Plaid native account ID for the account the user will switch their direct deposit to (`target_account_id`).  # noqa: E501
            This method makes a synchronous HTTP request by default. To make an
            asynchronous HTTP request, please pass async_req=True

            >>> thread = api.item_import(item_import_request, async_req=True)
            >>> result = thread.get()

            Args:
                item_import_request (ItemImportRequest):

            Keyword Args:
                _return_http_data_only (bool): response data without head status
                    code and headers. Default is True.
                _preload_content (bool): if False, the urllib3.HTTPResponse object
                    will be returned without reading/decoding response data.
                    Default is True.
                _request_timeout (float/tuple): timeout setting for this request. If one
                    number provided, it will be total request timeout. It can also
                    be a pair (tuple) of (connection, read) timeouts.
                    Default is None.
                _check_input_type (bool): specifies if type checking
                    should be done one the data sent to the server.
                    Default is True.
                _check_return_type (bool): specifies if type checking
                    should be done one the data received from the server.
                    Default is True.
                _host_index (int/None): specifies the index of the server
                    that we want to use.
                    Default is read from the configuration.
                async_req (bool): execute request asynchronously

            Returns:
                ItemImportResponse
                    If the method is called asynchronously, returns the request
                    thread.
            """
            kwargs['async_req'] = kwargs.get(
                'async_req', False
            )
            kwargs['_return_http_data_only'] = kwargs.get(
                '_return_http_data_only', True
            )
            kwargs['_preload_content'] = kwargs.get(
                '_preload_content', True
            )
            kwargs['_request_timeout'] = kwargs.get(
                '_request_timeout', None
            )
            kwargs['_check_input_type'] = kwargs.get(
                '_check_input_type', True
            )
            kwargs['_check_return_type'] = kwargs.get(
                '_check_return_type', True
            )
            kwargs['_host_index'] = kwargs.get('_host_index')
            kwargs['item_import_request'] = \
                item_import_request
            return self.call_with_http_info(**kwargs)

        self.item_import = _Endpoint(
            settings={
                'response_type': (ItemImportResponse,),
                'auth': [
                    'clientId',
                    'plaidVersion',
                    'secret'
                ],
                'endpoint_path': '/item/import',
                'operation_id': 'item_import',
                'http_method': 'POST',
                'servers': None,
            },
            params_map={
                'all': [
                    'item_import_request',
                ],
                'required': [
                    'item_import_request',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'item_import_request':
                        (ItemImportRequest,),
                },
                'attribute_map': {
                },
                'location_map': {
                    'item_import_request': 'body',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [
                    'application/json'
                ]
            },
            api_client=api_client,
            callable=__item_import
        )

        def __item_public_token_exchange(
            self,
            item_public_token_exchange_request,
            **kwargs
        ):
            """Exchange public token for an access token  # noqa: E501

            Exchange a Link `public_token` for an API `access_token`. Link hands off the `public_token` client-side via the `onSuccess` callback once a user has successfully created an Item. The `public_token` is ephemeral and expires after 30 minutes. An `access_token` does not expire, but can be revoked by calling `/item/remove`.  The response also includes an `item_id` that should be stored with the `access_token`. The `item_id` is used to identify an Item in a webhook. The `item_id` can also be retrieved by making an `/item/get` request.  # noqa: E501
            This method makes a synchronous HTTP request by default. To make an
            asynchronous HTTP request, please pass async_req=True

            >>> thread = api.item_public_token_exchange(item_public_token_exchange_request, async_req=True)
            >>> result = thread.get()

            Args:
                item_public_token_exchange_request (ItemPublicTokenExchangeRequest):

            Keyword Args:
                _return_http_data_only (bool): response data without head status
                    code and headers. Default is True.
                _preload_content (bool): if False, the urllib3.HTTPResponse object
                    will be returned without reading/decoding response data.
                    Default is True.
                _request_timeout (float/tuple): timeout setting for this request. If one
                    number provided, it will be total request timeout. It can also
                    be a pair (tuple) of (connection, read) timeouts.
                    Default is None.
                _check_input_type (bool): specifies if type checking
                    should be done one the data sent to the server.
                    Default is True.
                _check_return_type (bool): specifies if type checking
                    should be done one the data received from the server.
                    Default is True.
                _host_index (int/None): specifies the index of the server
                    that we want to use.
                    Default is read from the configuration.
                async_req (bool): execute request asynchronously

            Returns:
                ItemPublicTokenExchangeResponse
                    If the method is called asynchronously, returns the request
                    thread.
            """
            kwargs['async_req'] = kwargs.get(
                'async_req', False
            )
            kwargs['_return_http_data_only'] = kwargs.get(
                '_return_http_data_only', True
            )
            kwargs['_preload_content'] = kwargs.get(
                '_preload_content', True
            )
            kwargs['_request_timeout'] = kwargs.get(
                '_request_timeout', None
            )
            kwargs['_check_input_type'] = kwargs.get(
                '_check_input_type', True
            )
            kwargs['_check_return_type'] = kwargs.get(
                '_check_return_type', True
            )
            kwargs['_host_index'] = kwargs.get('_host_index')
            kwargs['item_public_token_exchange_request'] = \
                item_public_token_exchange_request
            return self.call_with_http_info(**kwargs)

        self.item_public_token_exchange = _Endpoint(
            settings={
                'response_type': (ItemPublicTokenExchangeResponse,),
                'auth': [
                    'clientId',
                    'plaidVersion',
                    'secret'
                ],
                'endpoint_path': '/item/public_token/exchange',
                'operation_id': 'item_public_token_exchange',
                'http_method': 'POST',
                'servers': None,
            },
            params_map={
                'all': [
                    'item_public_token_exchange_request',
                ],
                'required': [
                    'item_public_token_exchange_request',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'item_public_token_exchange_request':
                        (ItemPublicTokenExchangeRequest,),
                },
                'attribute_map': {
                },
                'location_map': {
                    'item_public_token_exchange_request': 'body',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [
                    'application/json'
                ]
            },
            api_client=api_client,
            callable=__item_public_token_exchange
        )

        def __item_remove(
            self,
            item_remove_request,
            **kwargs
        ):
            """Remove an Item  # noqa: E501

            The `/item/remove` endpoint allows you to remove an Item. Once removed, the `access_token`, as well as any processor tokens or bank account tokens associated with the Item, is no longer valid and cannot be used to access any data that was associated with the Item.  Note that in the Development environment, issuing an `/item/remove`  request will not decrement your live credential count. To increase your credential account in Development, contact Support.  Also note that for certain OAuth-based institutions, an Item removed via `/item/remove` may still show as an active connection in the institution's OAuth permission manager.  API versions 2019-05-29 and earlier return a `removed` boolean as part of the response.  # noqa: E501
            This method makes a synchronous HTTP request by default. To make an
            asynchronous HTTP request, please pass async_req=True

            >>> thread = api.item_remove(item_remove_request, async_req=True)
            >>> result = thread.get()

            Args:
                item_remove_request (ItemRemoveRequest):

            Keyword Args:
                _return_http_data_only (bool): response data without head status
                    code and headers. Default is True.
                _preload_content (bool): if False, the urllib3.HTTPResponse object
                    will be returned without reading/decoding response data.
                    Default is True.
                _request_timeout (float/tuple): timeout setting for this request. If one
                    number provided, it will be total request timeout. It can also
                    be a pair (tuple) of (connection, read) timeouts.
                    Default is None.
                _check_input_type (bool): specifies if type checking
                    should be done one the data sent to the server.
                    Default is True.
                _check_return_type (bool): specifies if type checking
                    should be done one the data received from the server.
                    Default is True.
                _host_index (int/None): specifies the index of the server
                    that we want to use.
                    Default is read from the configuration.
                async_req (bool): execute request asynchronously

            Returns:
                ItemRemoveResponse
                    If the method is called asynchronously, returns the request
                    thread.
            """
            kwargs['async_req'] = kwargs.get(
                'async_req', False
            )
            kwargs['_return_http_data_only'] = kwargs.get(
                '_return_http_data_only', True
            )
            kwargs['_preload_content'] = kwargs.get(
                '_preload_content', True
            )
            kwargs['_request_timeout'] = kwargs.get(
                '_request_timeout', None
            )
            kwargs['_check_input_type'] = kwargs.get(
                '_check_input_type', True
            )
            kwargs['_check_return_type'] = kwargs.get(
                '_check_return_type', True
            )
            kwargs['_host_index'] = kwargs.get('_host_index')
            kwargs['item_remove_request'] = \
                item_remove_request
            return self.call_with_http_info(**kwargs)

        self.item_remove = _Endpoint(
            settings={
                'response_type': (ItemRemoveResponse,),
                'auth': [
                    'clientId',
                    'plaidVersion',
                    'secret'
                ],
                'endpoint_path': '/item/remove',
                'operation_id': 'item_remove',
                'http_method': 'POST',
                'servers': None,
            },
            params_map={
                'all': [
                    'item_remove_request',
                ],
                'required': [
                    'item_remove_request',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'item_remove_request':
                        (ItemRemoveRequest,),
                },
                'attribute_map': {
                },
                'location_map': {
                    'item_remove_request': 'body',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [
                    'application/json'
                ]
            },
            api_client=api_client,
            callable=__item_remove
        )

        def __item_webhook_update(
            self,
            item_webhook_update_request,
            **kwargs
        ):
            """Update Webhook URL  # noqa: E501

            The POST `/item/webhook/update` allows you to update the webhook URL associated with an Item. This request triggers a [`WEBHOOK_UPDATE_ACKNOWLEDGED`](https://plaid.com/docs/api/items/#webhook_update_acknowledged) webhook to the newly specified webhook URL.  # noqa: E501
            This method makes a synchronous HTTP request by default. To make an
            asynchronous HTTP request, please pass async_req=True

            >>> thread = api.item_webhook_update(item_webhook_update_request, async_req=True)
            >>> result = thread.get()

            Args:
                item_webhook_update_request (ItemWebhookUpdateRequest):

            Keyword Args:
                _return_http_data_only (bool): response data without head status
                    code and headers. Default is True.
                _preload_content (bool): if False, the urllib3.HTTPResponse object
                    will be returned without reading/decoding response data.
                    Default is True.
                _request_timeout (float/tuple): timeout setting for this request. If one
                    number provided, it will be total request timeout. It can also
                    be a pair (tuple) of (connection, read) timeouts.
                    Default is None.
                _check_input_type (bool): specifies if type checking
                    should be done one the data sent to the server.
                    Default is True.
                _check_return_type (bool): specifies if type checking
                    should be done one the data received from the server.
                    Default is True.
                _host_index (int/None): specifies the index of the server
                    that we want to use.
                    Default is read from the configuration.
                async_req (bool): execute request asynchronously

            Returns:
                ItemWebhookUpdateResponse
                    If the method is called asynchronously, returns the request
                    thread.
            """
            kwargs['async_req'] = kwargs.get(
                'async_req', False
            )
            kwargs['_return_http_data_only'] = kwargs.get(
                '_return_http_data_only', True
            )
            kwargs['_preload_content'] = kwargs.get(
                '_preload_content', True
            )
            kwargs['_request_timeout'] = kwargs.get(
                '_request_timeout', None
            )
            kwargs['_check_input_type'] = kwargs.get(
                '_check_input_type', True
            )
            kwargs['_check_return_type'] = kwargs.get(
                '_check_return_type', True
            )
            kwargs['_host_index'] = kwargs.get('_host_index')
            kwargs['item_webhook_update_request'] = \
                item_webhook_update_request
            return self.call_with_http_info(**kwargs)

        self.item_webhook_update = _Endpoint(
            settings={
                'response_type': (ItemWebhookUpdateResponse,),
                'auth': [
                    'clientId',
                    'plaidVersion',
                    'secret'
                ],
                'endpoint_path': '/item/webhook/update',
                'operation_id': 'item_webhook_update',
                'http_method': 'POST',
                'servers': None,
            },
            params_map={
                'all': [
                    'item_webhook_update_request',
                ],
                'required': [
                    'item_webhook_update_request',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'item_webhook_update_request':
                        (ItemWebhookUpdateRequest,),
                },
                'attribute_map': {
                },
                'location_map': {
                    'item_webhook_update_request': 'body',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [
                    'application/json'
                ]
            },
            api_client=api_client,
            callable=__item_webhook_update
        )

        def __liabilities_get(
            self,
            liabilities_get_request,
            **kwargs
        ):
            """Retrieve Liabilities data  # noqa: E501

            The `/liabilities/get` endpoint returns various details about an Item with loan or credit accounts. Liabilities data is available primarily for US financial institutions, with some limited coverage of Canadian institutions. Currently supported account types are account type `credit` with account subtype `credit card` or `paypal`, and account type `loan` with account subtype `student` or `mortgage`. To limit accounts listed in Link to types and subtypes supported by Liabilities, you can use the `account_filters` parameter when [creating a Link token](https://plaid.com/docs/api/tokens/#linktokencreate).  The types of information returned by Liabilities can include balances and due dates, loan terms, and account details such as original loan amount and guarantor. Data is refreshed approximately once per day; the latest data can be retrieved by calling `/liabilities/get`.  Note: This request may take some time to complete if `liabilities` was not specified as an initial product when creating the Item. This is because Plaid must communicate directly with the institution to retrieve the additional data.  # noqa: E501
            This method makes a synchronous HTTP request by default. To make an
            asynchronous HTTP request, please pass async_req=True

            >>> thread = api.liabilities_get(liabilities_get_request, async_req=True)
            >>> result = thread.get()

            Args:
                liabilities_get_request (LiabilitiesGetRequest):

            Keyword Args:
                _return_http_data_only (bool): response data without head status
                    code and headers. Default is True.
                _preload_content (bool): if False, the urllib3.HTTPResponse object
                    will be returned without reading/decoding response data.
                    Default is True.
                _request_timeout (float/tuple): timeout setting for this request. If one
                    number provided, it will be total request timeout. It can also
                    be a pair (tuple) of (connection, read) timeouts.
                    Default is None.
                _check_input_type (bool): specifies if type checking
                    should be done one the data sent to the server.
                    Default is True.
                _check_return_type (bool): specifies if type checking
                    should be done one the data received from the server.
                    Default is True.
                _host_index (int/None): specifies the index of the server
                    that we want to use.
                    Default is read from the configuration.
                async_req (bool): execute request asynchronously

            Returns:
                LiabilitiesGetResponse
                    If the method is called asynchronously, returns the request
                    thread.
            """
            kwargs['async_req'] = kwargs.get(
                'async_req', False
            )
            kwargs['_return_http_data_only'] = kwargs.get(
                '_return_http_data_only', True
            )
            kwargs['_preload_content'] = kwargs.get(
                '_preload_content', True
            )
            kwargs['_request_timeout'] = kwargs.get(
                '_request_timeout', None
            )
            kwargs['_check_input_type'] = kwargs.get(
                '_check_input_type', True
            )
            kwargs['_check_return_type'] = kwargs.get(
                '_check_return_type', True
            )
            kwargs['_host_index'] = kwargs.get('_host_index')
            kwargs['liabilities_get_request'] = \
                liabilities_get_request
            return self.call_with_http_info(**kwargs)

        self.liabilities_get = _Endpoint(
            settings={
                'response_type': (LiabilitiesGetResponse,),
                'auth': [
                    'clientId',
                    'plaidVersion',
                    'secret'
                ],
                'endpoint_path': '/liabilities/get',
                'operation_id': 'liabilities_get',
                'http_method': 'POST',
                'servers': None,
            },
            params_map={
                'all': [
                    'liabilities_get_request',
                ],
                'required': [
                    'liabilities_get_request',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'liabilities_get_request':
                        (LiabilitiesGetRequest,),
                },
                'attribute_map': {
                },
                'location_map': {
                    'liabilities_get_request': 'body',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [
                    'application/json'
                ]
            },
            api_client=api_client,
            callable=__liabilities_get
        )

        def __link_token_create(
            self,
            link_token_create_request,
            **kwargs
        ):
            """Create Link Token  # noqa: E501

            The `/link/token/create` endpoint creates a `link_token`, which is required as a parameter when initializing Link. Once Link has been initialized, it returns a `public_token`, which can then be exchanged for an `access_token` via `/item/public_token/exchange` as part of the main Link flow.  A `link_token` generated by `/link/token/create` is also used to initialize other Link flows, such as the update mode flow for tokens with expired credentials, or the Payment Initiation (Europe) flow.  # noqa: E501
            This method makes a synchronous HTTP request by default. To make an
            asynchronous HTTP request, please pass async_req=True

            >>> thread = api.link_token_create(link_token_create_request, async_req=True)
            >>> result = thread.get()

            Args:
                link_token_create_request (LinkTokenCreateRequest):

            Keyword Args:
                _return_http_data_only (bool): response data without head status
                    code and headers. Default is True.
                _preload_content (bool): if False, the urllib3.HTTPResponse object
                    will be returned without reading/decoding response data.
                    Default is True.
                _request_timeout (float/tuple): timeout setting for this request. If one
                    number provided, it will be total request timeout. It can also
                    be a pair (tuple) of (connection, read) timeouts.
                    Default is None.
                _check_input_type (bool): specifies if type checking
                    should be done one the data sent to the server.
                    Default is True.
                _check_return_type (bool): specifies if type checking
                    should be done one the data received from the server.
                    Default is True.
                _host_index (int/None): specifies the index of the server
                    that we want to use.
                    Default is read from the configuration.
                async_req (bool): execute request asynchronously

            Returns:
                LinkTokenCreateResponse
                    If the method is called asynchronously, returns the request
                    thread.
            """
            kwargs['async_req'] = kwargs.get(
                'async_req', False
            )
            kwargs['_return_http_data_only'] = kwargs.get(
                '_return_http_data_only', True
            )
            kwargs['_preload_content'] = kwargs.get(
                '_preload_content', True
            )
            kwargs['_request_timeout'] = kwargs.get(
                '_request_timeout', None
            )
            kwargs['_check_input_type'] = kwargs.get(
                '_check_input_type', True
            )
            kwargs['_check_return_type'] = kwargs.get(
                '_check_return_type', True
            )
            kwargs['_host_index'] = kwargs.get('_host_index')
            kwargs['link_token_create_request'] = \
                link_token_create_request
            return self.call_with_http_info(**kwargs)

        self.link_token_create = _Endpoint(
            settings={
                'response_type': (LinkTokenCreateResponse,),
                'auth': [
                    'clientId',
                    'plaidVersion',
                    'secret'
                ],
                'endpoint_path': '/link/token/create',
                'operation_id': 'link_token_create',
                'http_method': 'POST',
                'servers': None,
            },
            params_map={
                'all': [
                    'link_token_create_request',
                ],
                'required': [
                    'link_token_create_request',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'link_token_create_request':
                        (LinkTokenCreateRequest,),
                },
                'attribute_map': {
                },
                'location_map': {
                    'link_token_create_request': 'body',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [
                    'application/json'
                ]
            },
            api_client=api_client,
            callable=__link_token_create
        )

        def __link_token_get(
            self,
            link_token_get_request,
            **kwargs
        ):
            """Get Link Token  # noqa: E501

            The `/link/token/get` endpoint gets information about a previously-created `link_token` using the `/link/token/create` endpoint. It can be useful for debugging purposes.  # noqa: E501
            This method makes a synchronous HTTP request by default. To make an
            asynchronous HTTP request, please pass async_req=True

            >>> thread = api.link_token_get(link_token_get_request, async_req=True)
            >>> result = thread.get()

            Args:
                link_token_get_request (LinkTokenGetRequest):

            Keyword Args:
                _return_http_data_only (bool): response data without head status
                    code and headers. Default is True.
                _preload_content (bool): if False, the urllib3.HTTPResponse object
                    will be returned without reading/decoding response data.
                    Default is True.
                _request_timeout (float/tuple): timeout setting for this request. If one
                    number provided, it will be total request timeout. It can also
                    be a pair (tuple) of (connection, read) timeouts.
                    Default is None.
                _check_input_type (bool): specifies if type checking
                    should be done one the data sent to the server.
                    Default is True.
                _check_return_type (bool): specifies if type checking
                    should be done one the data received from the server.
                    Default is True.
                _host_index (int/None): specifies the index of the server
                    that we want to use.
                    Default is read from the configuration.
                async_req (bool): execute request asynchronously

            Returns:
                LinkTokenGetResponse
                    If the method is called asynchronously, returns the request
                    thread.
            """
            kwargs['async_req'] = kwargs.get(
                'async_req', False
            )
            kwargs['_return_http_data_only'] = kwargs.get(
                '_return_http_data_only', True
            )
            kwargs['_preload_content'] = kwargs.get(
                '_preload_content', True
            )
            kwargs['_request_timeout'] = kwargs.get(
                '_request_timeout', None
            )
            kwargs['_check_input_type'] = kwargs.get(
                '_check_input_type', True
            )
            kwargs['_check_return_type'] = kwargs.get(
                '_check_return_type', True
            )
            kwargs['_host_index'] = kwargs.get('_host_index')
            kwargs['link_token_get_request'] = \
                link_token_get_request
            return self.call_with_http_info(**kwargs)

        self.link_token_get = _Endpoint(
            settings={
                'response_type': (LinkTokenGetResponse,),
                'auth': [
                    'clientId',
                    'plaidVersion',
                    'secret'
                ],
                'endpoint_path': '/link/token/get',
                'operation_id': 'link_token_get',
                'http_method': 'POST',
                'servers': None,
            },
            params_map={
                'all': [
                    'link_token_get_request',
                ],
                'required': [
                    'link_token_get_request',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'link_token_get_request':
                        (LinkTokenGetRequest,),
                },
                'attribute_map': {
                },
                'location_map': {
                    'link_token_get_request': 'body',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [
                    'application/json'
                ]
            },
            api_client=api_client,
            callable=__link_token_get
        )

        def __payment_initiation_consent_create(
            self,
            payment_initiation_consent_create_request,
            **kwargs
        ):
            """Create payment consent  # noqa: E501

            The `/payment_initiation/consent/create` endpoint is used to create a payment consent, which can be used to initiate payments on behalf of the user. Payment consents are created with `UNAUTHORISED` status by default and must be authorised by the user before payments can be initiated.  Consents can be limited in time and scope, and have constraints that describe limitations for payments.  # noqa: E501
            This method makes a synchronous HTTP request by default. To make an
            asynchronous HTTP request, please pass async_req=True

            >>> thread = api.payment_initiation_consent_create(payment_initiation_consent_create_request, async_req=True)
            >>> result = thread.get()

            Args:
                payment_initiation_consent_create_request (PaymentInitiationConsentCreateRequest):

            Keyword Args:
                _return_http_data_only (bool): response data without head status
                    code and headers. Default is True.
                _preload_content (bool): if False, the urllib3.HTTPResponse object
                    will be returned without reading/decoding response data.
                    Default is True.
                _request_timeout (float/tuple): timeout setting for this request. If one
                    number provided, it will be total request timeout. It can also
                    be a pair (tuple) of (connection, read) timeouts.
                    Default is None.
                _check_input_type (bool): specifies if type checking
                    should be done one the data sent to the server.
                    Default is True.
                _check_return_type (bool): specifies if type checking
                    should be done one the data received from the server.
                    Default is True.
                _host_index (int/None): specifies the index of the server
                    that we want to use.
                    Default is read from the configuration.
                async_req (bool): execute request asynchronously

            Returns:
                PaymentInitiationConsentCreateResponse
                    If the method is called asynchronously, returns the request
                    thread.
            """
            kwargs['async_req'] = kwargs.get(
                'async_req', False
            )
            kwargs['_return_http_data_only'] = kwargs.get(
                '_return_http_data_only', True
            )
            kwargs['_preload_content'] = kwargs.get(
                '_preload_content', True
            )
            kwargs['_request_timeout'] = kwargs.get(
                '_request_timeout', None
            )
            kwargs['_check_input_type'] = kwargs.get(
                '_check_input_type', True
            )
            kwargs['_check_return_type'] = kwargs.get(
                '_check_return_type', True
            )
            kwargs['_host_index'] = kwargs.get('_host_index')
            kwargs['payment_initiation_consent_create_request'] = \
                payment_initiation_consent_create_request
            return self.call_with_http_info(**kwargs)

        self.payment_initiation_consent_create = _Endpoint(
            settings={
                'response_type': (PaymentInitiationConsentCreateResponse,),
                'auth': [
                    'clientId',
                    'plaidVersion',
                    'secret'
                ],
                'endpoint_path': '/payment_initiation/consent/create',
                'operation_id': 'payment_initiation_consent_create',
                'http_method': 'POST',
                'servers': None,
            },
            params_map={
                'all': [
                    'payment_initiation_consent_create_request',
                ],
                'required': [
                    'payment_initiation_consent_create_request',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'payment_initiation_consent_create_request':
                        (PaymentInitiationConsentCreateRequest,),
                },
                'attribute_map': {
                },
                'location_map': {
                    'payment_initiation_consent_create_request': 'body',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [
                    'application/json'
                ]
            },
            api_client=api_client,
            callable=__payment_initiation_consent_create
        )

        def __payment_initiation_consent_get(
            self,
            payment_initiation_consent_get_request,
            **kwargs
        ):
            """Get payment consent  # noqa: E501

            The `/payment_initiation/consent/get` endpoint can be used to check the status of a payment consent, as well as to receive basic information such as recipient and constraints.  # noqa: E501
            This method makes a synchronous HTTP request by default. To make an
            asynchronous HTTP request, please pass async_req=True

            >>> thread = api.payment_initiation_consent_get(payment_initiation_consent_get_request, async_req=True)
            >>> result = thread.get()

            Args:
                payment_initiation_consent_get_request (PaymentInitiationConsentGetRequest):

            Keyword Args:
                _return_http_data_only (bool): response data without head status
                    code and headers. Default is True.
                _preload_content (bool): if False, the urllib3.HTTPResponse object
                    will be returned without reading/decoding response data.
                    Default is True.
                _request_timeout (float/tuple): timeout setting for this request. If one
                    number provided, it will be total request timeout. It can also
                    be a pair (tuple) of (connection, read) timeouts.
                    Default is None.
                _check_input_type (bool): specifies if type checking
                    should be done one the data sent to the server.
                    Default is True.
                _check_return_type (bool): specifies if type checking
                    should be done one the data received from the server.
                    Default is True.
                _host_index (int/None): specifies the index of the server
                    that we want to use.
                    Default is read from the configuration.
                async_req (bool): execute request asynchronously

            Returns:
                PaymentInitiationConsentGetResponse
                    If the method is called asynchronously, returns the request
                    thread.
            """
            kwargs['async_req'] = kwargs.get(
                'async_req', False
            )
            kwargs['_return_http_data_only'] = kwargs.get(
                '_return_http_data_only', True
            )
            kwargs['_preload_content'] = kwargs.get(
                '_preload_content', True
            )
            kwargs['_request_timeout'] = kwargs.get(
                '_request_timeout', None
            )
            kwargs['_check_input_type'] = kwargs.get(
                '_check_input_type', True
            )
            kwargs['_check_return_type'] = kwargs.get(
                '_check_return_type', True
            )
            kwargs['_host_index'] = kwargs.get('_host_index')
            kwargs['payment_initiation_consent_get_request'] = \
                payment_initiation_consent_get_request
            return self.call_with_http_info(**kwargs)

        self.payment_initiation_consent_get = _Endpoint(
            settings={
                'response_type': (PaymentInitiationConsentGetResponse,),
                'auth': [
                    'clientId',
                    'plaidVersion',
                    'secret'
                ],
                'endpoint_path': '/payment_initiation/consent/get',
                'operation_id': 'payment_initiation_consent_get',
                'http_method': 'POST',
                'servers': None,
            },
            params_map={
                'all': [
                    'payment_initiation_consent_get_request',
                ],
                'required': [
                    'payment_initiation_consent_get_request',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'payment_initiation_consent_get_request':
                        (PaymentInitiationConsentGetRequest,),
                },
                'attribute_map': {
                },
                'location_map': {
                    'payment_initiation_consent_get_request': 'body',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [
                    'application/json'
                ]
            },
            api_client=api_client,
            callable=__payment_initiation_consent_get
        )

        def __payment_initiation_consent_payment_execute(
            self,
            payment_initiation_consent_payment_execute_request,
            **kwargs
        ):
            """Execute a single payment using consent  # noqa: E501

            The `/payment_initiation/consent/payment/execute` endpoint can be used to execute payments using payment consent.  # noqa: E501
            This method makes a synchronous HTTP request by default. To make an
            asynchronous HTTP request, please pass async_req=True

            >>> thread = api.payment_initiation_consent_payment_execute(payment_initiation_consent_payment_execute_request, async_req=True)
            >>> result = thread.get()

            Args:
                payment_initiation_consent_payment_execute_request (PaymentInitiationConsentPaymentExecuteRequest):

            Keyword Args:
                _return_http_data_only (bool): response data without head status
                    code and headers. Default is True.
                _preload_content (bool): if False, the urllib3.HTTPResponse object
                    will be returned without reading/decoding response data.
                    Default is True.
                _request_timeout (float/tuple): timeout setting for this request. If one
                    number provided, it will be total request timeout. It can also
                    be a pair (tuple) of (connection, read) timeouts.
                    Default is None.
                _check_input_type (bool): specifies if type checking
                    should be done one the data sent to the server.
                    Default is True.
                _check_return_type (bool): specifies if type checking
                    should be done one the data received from the server.
                    Default is True.
                _host_index (int/None): specifies the index of the server
                    that we want to use.
                    Default is read from the configuration.
                async_req (bool): execute request asynchronously

            Returns:
                PaymentInitiationConsentPaymentExecuteResponse
                    If the method is called asynchronously, returns the request
                    thread.
            """
            kwargs['async_req'] = kwargs.get(
                'async_req', False
            )
            kwargs['_return_http_data_only'] = kwargs.get(
                '_return_http_data_only', True
            )
            kwargs['_preload_content'] = kwargs.get(
                '_preload_content', True
            )
            kwargs['_request_timeout'] = kwargs.get(
                '_request_timeout', None
            )
            kwargs['_check_input_type'] = kwargs.get(
                '_check_input_type', True
            )
            kwargs['_check_return_type'] = kwargs.get(
                '_check_return_type', True
            )
            kwargs['_host_index'] = kwargs.get('_host_index')
            kwargs['payment_initiation_consent_payment_execute_request'] = \
                payment_initiation_consent_payment_execute_request
            return self.call_with_http_info(**kwargs)

        self.payment_initiation_consent_payment_execute = _Endpoint(
            settings={
                'response_type': (PaymentInitiationConsentPaymentExecuteResponse,),
                'auth': [
                    'clientId',
                    'plaidVersion',
                    'secret'
                ],
                'endpoint_path': '/payment_initiation/consent/payment/execute',
                'operation_id': 'payment_initiation_consent_payment_execute',
                'http_method': 'POST',
                'servers': None,
            },
            params_map={
                'all': [
                    'payment_initiation_consent_payment_execute_request',
                ],
                'required': [
                    'payment_initiation_consent_payment_execute_request',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'payment_initiation_consent_payment_execute_request':
                        (PaymentInitiationConsentPaymentExecuteRequest,),
                },
                'attribute_map': {
                },
                'location_map': {
                    'payment_initiation_consent_payment_execute_request': 'body',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [
                    'application/json'
                ]
            },
            api_client=api_client,
            callable=__payment_initiation_consent_payment_execute
        )

        def __payment_initiation_consent_revoke(
            self,
            payment_initiation_consent_revoke_request,
            **kwargs
        ):
            """Revoke payment consent  # noqa: E501

            The `/payment_initiation/consent/revoke` endpoint can be used to revoke the payment consent. Once the consent is revoked, it is not possible to initiate payments using it.  # noqa: E501
            This method makes a synchronous HTTP request by default. To make an
            asynchronous HTTP request, please pass async_req=True

            >>> thread = api.payment_initiation_consent_revoke(payment_initiation_consent_revoke_request, async_req=True)
            >>> result = thread.get()

            Args:
                payment_initiation_consent_revoke_request (PaymentInitiationConsentRevokeRequest):

            Keyword Args:
                _return_http_data_only (bool): response data without head status
                    code and headers. Default is True.
                _preload_content (bool): if False, the urllib3.HTTPResponse object
                    will be returned without reading/decoding response data.
                    Default is True.
                _request_timeout (float/tuple): timeout setting for this request. If one
                    number provided, it will be total request timeout. It can also
                    be a pair (tuple) of (connection, read) timeouts.
                    Default is None.
                _check_input_type (bool): specifies if type checking
                    should be done one the data sent to the server.
                    Default is True.
                _check_return_type (bool): specifies if type checking
                    should be done one the data received from the server.
                    Default is True.
                _host_index (int/None): specifies the index of the server
                    that we want to use.
                    Default is read from the configuration.
                async_req (bool): execute request asynchronously

            Returns:
                PaymentInitiationConsentRevokeResponse
                    If the method is called asynchronously, returns the request
                    thread.
            """
            kwargs['async_req'] = kwargs.get(
                'async_req', False
            )
            kwargs['_return_http_data_only'] = kwargs.get(
                '_return_http_data_only', True
            )
            kwargs['_preload_content'] = kwargs.get(
                '_preload_content', True
            )
            kwargs['_request_timeout'] = kwargs.get(
                '_request_timeout', None
            )
            kwargs['_check_input_type'] = kwargs.get(
                '_check_input_type', True
            )
            kwargs['_check_return_type'] = kwargs.get(
                '_check_return_type', True
            )
            kwargs['_host_index'] = kwargs.get('_host_index')
            kwargs['payment_initiation_consent_revoke_request'] = \
                payment_initiation_consent_revoke_request
            return self.call_with_http_info(**kwargs)

        self.payment_initiation_consent_revoke = _Endpoint(
            settings={
                'response_type': (PaymentInitiationConsentRevokeResponse,),
                'auth': [
                    'clientId',
                    'plaidVersion',
                    'secret'
                ],
                'endpoint_path': '/payment_initiation/consent/revoke',
                'operation_id': 'payment_initiation_consent_revoke',
                'http_method': 'POST',
                'servers': None,
            },
            params_map={
                'all': [
                    'payment_initiation_consent_revoke_request',
                ],
                'required': [
                    'payment_initiation_consent_revoke_request',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'payment_initiation_consent_revoke_request':
                        (PaymentInitiationConsentRevokeRequest,),
                },
                'attribute_map': {
                },
                'location_map': {
                    'payment_initiation_consent_revoke_request': 'body',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [
                    'application/json'
                ]
            },
            api_client=api_client,
            callable=__payment_initiation_consent_revoke
        )

        def __payment_initiation_payment_create(
            self,
            payment_initiation_payment_create_request,
            **kwargs
        ):
            """Create a payment  # noqa: E501

            After creating a payment recipient, you can use the `/payment_initiation/payment/create` endpoint to create a payment to that recipient.  Payments can be one-time or standing order (recurring) and can be denominated in either EUR or GBP.  If making domestic GBP-denominated payments, your recipient must have been created with BACS numbers. In general, EUR-denominated payments will be sent via SEPA Credit Transfer and GBP-denominated payments will be sent via the Faster Payments network, but the payment network used will be determined by the institution. Payments sent via Faster Payments will typically arrive immediately, while payments sent via SEPA Credit Transfer will typically arrive in one business day.  Standing orders (recurring payments) must be denominated in GBP and can only be sent to recipients in the UK. Once created, standing order payments cannot be modified or canceled via the API. An end user can cancel or modify a standing order directly on their banking application or website, or by contacting the bank. Standing orders will follow the payment rules of the underlying rails (Faster Payments in UK). Payments can be sent Monday to Friday, excluding bank holidays. If the pre-arranged date falls on a weekend or bank holiday, the payment is made on the next working day. It is not possible to guarantee the exact time the payment will reach the recipient’s account, although at least 90% of standing order payments are sent by 6am.  In the Development environment, payments must be below 5 GBP / EUR. For details on any payment limits in Production, contact your Plaid Account Manager.  # noqa: E501
            This method makes a synchronous HTTP request by default. To make an
            asynchronous HTTP request, please pass async_req=True

            >>> thread = api.payment_initiation_payment_create(payment_initiation_payment_create_request, async_req=True)
            >>> result = thread.get()

            Args:
                payment_initiation_payment_create_request (PaymentInitiationPaymentCreateRequest):

            Keyword Args:
                _return_http_data_only (bool): response data without head status
                    code and headers. Default is True.
                _preload_content (bool): if False, the urllib3.HTTPResponse object
                    will be returned without reading/decoding response data.
                    Default is True.
                _request_timeout (float/tuple): timeout setting for this request. If one
                    number provided, it will be total request timeout. It can also
                    be a pair (tuple) of (connection, read) timeouts.
                    Default is None.
                _check_input_type (bool): specifies if type checking
                    should be done one the data sent to the server.
                    Default is True.
                _check_return_type (bool): specifies if type checking
                    should be done one the data received from the server.
                    Default is True.
                _host_index (int/None): specifies the index of the server
                    that we want to use.
                    Default is read from the configuration.
                async_req (bool): execute request asynchronously

            Returns:
                PaymentInitiationPaymentCreateResponse
                    If the method is called asynchronously, returns the request
                    thread.
            """
            kwargs['async_req'] = kwargs.get(
                'async_req', False
            )
            kwargs['_return_http_data_only'] = kwargs.get(
                '_return_http_data_only', True
            )
            kwargs['_preload_content'] = kwargs.get(
                '_preload_content', True
            )
            kwargs['_request_timeout'] = kwargs.get(
                '_request_timeout', None
            )
            kwargs['_check_input_type'] = kwargs.get(
                '_check_input_type', True
            )
            kwargs['_check_return_type'] = kwargs.get(
                '_check_return_type', True
            )
            kwargs['_host_index'] = kwargs.get('_host_index')
            kwargs['payment_initiation_payment_create_request'] = \
                payment_initiation_payment_create_request
            return self.call_with_http_info(**kwargs)

        self.payment_initiation_payment_create = _Endpoint(
            settings={
                'response_type': (PaymentInitiationPaymentCreateResponse,),
                'auth': [
                    'clientId',
                    'plaidVersion',
                    'secret'
                ],
                'endpoint_path': '/payment_initiation/payment/create',
                'operation_id': 'payment_initiation_payment_create',
                'http_method': 'POST',
                'servers': None,
            },
            params_map={
                'all': [
                    'payment_initiation_payment_create_request',
                ],
                'required': [
                    'payment_initiation_payment_create_request',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'payment_initiation_payment_create_request':
                        (PaymentInitiationPaymentCreateRequest,),
                },
                'attribute_map': {
                },
                'location_map': {
                    'payment_initiation_payment_create_request': 'body',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [
                    'application/json'
                ]
            },
            api_client=api_client,
            callable=__payment_initiation_payment_create
        )

        def __payment_initiation_payment_get(
            self,
            payment_initiation_payment_get_request,
            **kwargs
        ):
            """Get payment details  # noqa: E501

            The `/payment_initiation/payment/get` endpoint can be used to check the status of a payment, as well as to receive basic information such as recipient and payment amount. In the case of standing orders, the `/payment_initiation/payment/get` endpoint will provide information about the status of the overall standing order itself; the API cannot be used to retrieve payment status for individual payments within a standing order.  # noqa: E501
            This method makes a synchronous HTTP request by default. To make an
            asynchronous HTTP request, please pass async_req=True

            >>> thread = api.payment_initiation_payment_get(payment_initiation_payment_get_request, async_req=True)
            >>> result = thread.get()

            Args:
                payment_initiation_payment_get_request (PaymentInitiationPaymentGetRequest):

            Keyword Args:
                _return_http_data_only (bool): response data without head status
                    code and headers. Default is True.
                _preload_content (bool): if False, the urllib3.HTTPResponse object
                    will be returned without reading/decoding response data.
                    Default is True.
                _request_timeout (float/tuple): timeout setting for this request. If one
                    number provided, it will be total request timeout. It can also
                    be a pair (tuple) of (connection, read) timeouts.
                    Default is None.
                _check_input_type (bool): specifies if type checking
                    should be done one the data sent to the server.
                    Default is True.
                _check_return_type (bool): specifies if type checking
                    should be done one the data received from the server.
                    Default is True.
                _host_index (int/None): specifies the index of the server
                    that we want to use.
                    Default is read from the configuration.
                async_req (bool): execute request asynchronously

            Returns:
                PaymentInitiationPaymentGetResponse
                    If the method is called asynchronously, returns the request
                    thread.
            """
            kwargs['async_req'] = kwargs.get(
                'async_req', False
            )
            kwargs['_return_http_data_only'] = kwargs.get(
                '_return_http_data_only', True
            )
            kwargs['_preload_content'] = kwargs.get(
                '_preload_content', True
            )
            kwargs['_request_timeout'] = kwargs.get(
                '_request_timeout', None
            )
            kwargs['_check_input_type'] = kwargs.get(
                '_check_input_type', True
            )
            kwargs['_check_return_type'] = kwargs.get(
                '_check_return_type', True
            )
            kwargs['_host_index'] = kwargs.get('_host_index')
            kwargs['payment_initiation_payment_get_request'] = \
                payment_initiation_payment_get_request
            return self.call_with_http_info(**kwargs)

        self.payment_initiation_payment_get = _Endpoint(
            settings={
                'response_type': (PaymentInitiationPaymentGetResponse,),
                'auth': [
                    'clientId',
                    'plaidVersion',
                    'secret'
                ],
                'endpoint_path': '/payment_initiation/payment/get',
                'operation_id': 'payment_initiation_payment_get',
                'http_method': 'POST',
                'servers': None,
            },
            params_map={
                'all': [
                    'payment_initiation_payment_get_request',
                ],
                'required': [
                    'payment_initiation_payment_get_request',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'payment_initiation_payment_get_request':
                        (PaymentInitiationPaymentGetRequest,),
                },
                'attribute_map': {
                },
                'location_map': {
                    'payment_initiation_payment_get_request': 'body',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [
                    'application/json'
                ]
            },
            api_client=api_client,
            callable=__payment_initiation_payment_get
        )

        def __payment_initiation_payment_list(
            self,
            payment_initiation_payment_list_request,
            **kwargs
        ):
            """List payments  # noqa: E501

            The `/payment_initiation/payment/list` endpoint can be used to retrieve all created payments. By default, the 10 most recent payments are returned. You can request more payments and paginate through the results using the optional `count` and `cursor` parameters.  # noqa: E501
            This method makes a synchronous HTTP request by default. To make an
            asynchronous HTTP request, please pass async_req=True

            >>> thread = api.payment_initiation_payment_list(payment_initiation_payment_list_request, async_req=True)
            >>> result = thread.get()

            Args:
                payment_initiation_payment_list_request (PaymentInitiationPaymentListRequest):

            Keyword Args:
                _return_http_data_only (bool): response data without head status
                    code and headers. Default is True.
                _preload_content (bool): if False, the urllib3.HTTPResponse object
                    will be returned without reading/decoding response data.
                    Default is True.
                _request_timeout (float/tuple): timeout setting for this request. If one
                    number provided, it will be total request timeout. It can also
                    be a pair (tuple) of (connection, read) timeouts.
                    Default is None.
                _check_input_type (bool): specifies if type checking
                    should be done one the data sent to the server.
                    Default is True.
                _check_return_type (bool): specifies if type checking
                    should be done one the data received from the server.
                    Default is True.
                _host_index (int/None): specifies the index of the server
                    that we want to use.
                    Default is read from the configuration.
                async_req (bool): execute request asynchronously

            Returns:
                PaymentInitiationPaymentListResponse
                    If the method is called asynchronously, returns the request
                    thread.
            """
            kwargs['async_req'] = kwargs.get(
                'async_req', False
            )
            kwargs['_return_http_data_only'] = kwargs.get(
                '_return_http_data_only', True
            )
            kwargs['_preload_content'] = kwargs.get(
                '_preload_content', True
            )
            kwargs['_request_timeout'] = kwargs.get(
                '_request_timeout', None
            )
            kwargs['_check_input_type'] = kwargs.get(
                '_check_input_type', True
            )
            kwargs['_check_return_type'] = kwargs.get(
                '_check_return_type', True
            )
            kwargs['_host_index'] = kwargs.get('_host_index')
            kwargs['payment_initiation_payment_list_request'] = \
                payment_initiation_payment_list_request
            return self.call_with_http_info(**kwargs)

        self.payment_initiation_payment_list = _Endpoint(
            settings={
                'response_type': (PaymentInitiationPaymentListResponse,),
                'auth': [
                    'clientId',
                    'plaidVersion',
                    'secret'
                ],
                'endpoint_path': '/payment_initiation/payment/list',
                'operation_id': 'payment_initiation_payment_list',
                'http_method': 'POST',
                'servers': None,
            },
            params_map={
                'all': [
                    'payment_initiation_payment_list_request',
                ],
                'required': [
                    'payment_initiation_payment_list_request',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'payment_initiation_payment_list_request':
                        (PaymentInitiationPaymentListRequest,),
                },
                'attribute_map': {
                },
                'location_map': {
                    'payment_initiation_payment_list_request': 'body',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [
                    'application/json'
                ]
            },
            api_client=api_client,
            callable=__payment_initiation_payment_list
        )

        def __payment_initiation_payment_reverse(
            self,
            payment_initiation_payment_reverse_request,
            **kwargs
        ):
            """Reverse an existing payment  # noqa: E501

            Reverse a previously initiated payment.  A payment can only be reversed once and will be refunded to the original sender's account.   # noqa: E501
            This method makes a synchronous HTTP request by default. To make an
            asynchronous HTTP request, please pass async_req=True

            >>> thread = api.payment_initiation_payment_reverse(payment_initiation_payment_reverse_request, async_req=True)
            >>> result = thread.get()

            Args:
                payment_initiation_payment_reverse_request (PaymentInitiationPaymentReverseRequest):

            Keyword Args:
                _return_http_data_only (bool): response data without head status
                    code and headers. Default is True.
                _preload_content (bool): if False, the urllib3.HTTPResponse object
                    will be returned without reading/decoding response data.
                    Default is True.
                _request_timeout (float/tuple): timeout setting for this request. If one
                    number provided, it will be total request timeout. It can also
                    be a pair (tuple) of (connection, read) timeouts.
                    Default is None.
                _check_input_type (bool): specifies if type checking
                    should be done one the data sent to the server.
                    Default is True.
                _check_return_type (bool): specifies if type checking
                    should be done one the data received from the server.
                    Default is True.
                _host_index (int/None): specifies the index of the server
                    that we want to use.
                    Default is read from the configuration.
                async_req (bool): execute request asynchronously

            Returns:
                PaymentInitiationPaymentReverseResponse
                    If the method is called asynchronously, returns the request
                    thread.
            """
            kwargs['async_req'] = kwargs.get(
                'async_req', False
            )
            kwargs['_return_http_data_only'] = kwargs.get(
                '_return_http_data_only', True
            )
            kwargs['_preload_content'] = kwargs.get(
                '_preload_content', True
            )
            kwargs['_request_timeout'] = kwargs.get(
                '_request_timeout', None
            )
            kwargs['_check_input_type'] = kwargs.get(
                '_check_input_type', True
            )
            kwargs['_check_return_type'] = kwargs.get(
                '_check_return_type', True
            )
            kwargs['_host_index'] = kwargs.get('_host_index')
            kwargs['payment_initiation_payment_reverse_request'] = \
                payment_initiation_payment_reverse_request
            return self.call_with_http_info(**kwargs)

        self.payment_initiation_payment_reverse = _Endpoint(
            settings={
                'response_type': (PaymentInitiationPaymentReverseResponse,),
                'auth': [
                    'clientId',
                    'plaidVersion',
                    'secret'
                ],
                'endpoint_path': '/payment_initiation/payment/reverse',
                'operation_id': 'payment_initiation_payment_reverse',
                'http_method': 'POST',
                'servers': None,
            },
            params_map={
                'all': [
                    'payment_initiation_payment_reverse_request',
                ],
                'required': [
                    'payment_initiation_payment_reverse_request',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'payment_initiation_payment_reverse_request':
                        (PaymentInitiationPaymentReverseRequest,),
                },
                'attribute_map': {
                },
                'location_map': {
                    'payment_initiation_payment_reverse_request': 'body',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [
                    'application/json'
                ]
            },
            api_client=api_client,
            callable=__payment_initiation_payment_reverse
        )

        def __payment_initiation_recipient_create(
            self,
            payment_initiation_recipient_create_request,
            **kwargs
        ):
            """Create payment recipient  # noqa: E501

            Create a payment recipient for payment initiation.  The recipient must be in Europe, within a country that is a member of the Single Euro Payment Area (SEPA).  For a standing order (recurring) payment, the recipient must be in the UK.  The endpoint is idempotent: if a developer has already made a request with the same payment details, Plaid will return the same `recipient_id`.   # noqa: E501
            This method makes a synchronous HTTP request by default. To make an
            asynchronous HTTP request, please pass async_req=True

            >>> thread = api.payment_initiation_recipient_create(payment_initiation_recipient_create_request, async_req=True)
            >>> result = thread.get()

            Args:
                payment_initiation_recipient_create_request (PaymentInitiationRecipientCreateRequest):

            Keyword Args:
                _return_http_data_only (bool): response data without head status
                    code and headers. Default is True.
                _preload_content (bool): if False, the urllib3.HTTPResponse object
                    will be returned without reading/decoding response data.
                    Default is True.
                _request_timeout (float/tuple): timeout setting for this request. If one
                    number provided, it will be total request timeout. It can also
                    be a pair (tuple) of (connection, read) timeouts.
                    Default is None.
                _check_input_type (bool): specifies if type checking
                    should be done one the data sent to the server.
                    Default is True.
                _check_return_type (bool): specifies if type checking
                    should be done one the data received from the server.
                    Default is True.
                _host_index (int/None): specifies the index of the server
                    that we want to use.
                    Default is read from the configuration.
                async_req (bool): execute request asynchronously

            Returns:
                PaymentInitiationRecipientCreateResponse
                    If the method is called asynchronously, returns the request
                    thread.
            """
            kwargs['async_req'] = kwargs.get(
                'async_req', False
            )
            kwargs['_return_http_data_only'] = kwargs.get(
                '_return_http_data_only', True
            )
            kwargs['_preload_content'] = kwargs.get(
                '_preload_content', True
            )
            kwargs['_request_timeout'] = kwargs.get(
                '_request_timeout', None
            )
            kwargs['_check_input_type'] = kwargs.get(
                '_check_input_type', True
            )
            kwargs['_check_return_type'] = kwargs.get(
                '_check_return_type', True
            )
            kwargs['_host_index'] = kwargs.get('_host_index')
            kwargs['payment_initiation_recipient_create_request'] = \
                payment_initiation_recipient_create_request
            return self.call_with_http_info(**kwargs)

        self.payment_initiation_recipient_create = _Endpoint(
            settings={
                'response_type': (PaymentInitiationRecipientCreateResponse,),
                'auth': [
                    'clientId',
                    'plaidVersion',
                    'secret'
                ],
                'endpoint_path': '/payment_initiation/recipient/create',
                'operation_id': 'payment_initiation_recipient_create',
                'http_method': 'POST',
                'servers': None,
            },
            params_map={
                'all': [
                    'payment_initiation_recipient_create_request',
                ],
                'required': [
                    'payment_initiation_recipient_create_request',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'payment_initiation_recipient_create_request':
                        (PaymentInitiationRecipientCreateRequest,),
                },
                'attribute_map': {
                },
                'location_map': {
                    'payment_initiation_recipient_create_request': 'body',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [
                    'application/json'
                ]
            },
            api_client=api_client,
            callable=__payment_initiation_recipient_create
        )

        def __payment_initiation_recipient_get(
            self,
            payment_initiation_recipient_get_request,
            **kwargs
        ):
            """Get payment recipient  # noqa: E501

            Get details about a payment recipient you have previously created.  # noqa: E501
            This method makes a synchronous HTTP request by default. To make an
            asynchronous HTTP request, please pass async_req=True

            >>> thread = api.payment_initiation_recipient_get(payment_initiation_recipient_get_request, async_req=True)
            >>> result = thread.get()

            Args:
                payment_initiation_recipient_get_request (PaymentInitiationRecipientGetRequest):

            Keyword Args:
                _return_http_data_only (bool): response data without head status
                    code and headers. Default is True.
                _preload_content (bool): if False, the urllib3.HTTPResponse object
                    will be returned without reading/decoding response data.
                    Default is True.
                _request_timeout (float/tuple): timeout setting for this request. If one
                    number provided, it will be total request timeout. It can also
                    be a pair (tuple) of (connection, read) timeouts.
                    Default is None.
                _check_input_type (bool): specifies if type checking
                    should be done one the data sent to the server.
                    Default is True.
                _check_return_type (bool): specifies if type checking
                    should be done one the data received from the server.
                    Default is True.
                _host_index (int/None): specifies the index of the server
                    that we want to use.
                    Default is read from the configuration.
                async_req (bool): execute request asynchronously

            Returns:
                PaymentInitiationRecipientGetResponse
                    If the method is called asynchronously, returns the request
                    thread.
            """
            kwargs['async_req'] = kwargs.get(
                'async_req', False
            )
            kwargs['_return_http_data_only'] = kwargs.get(
                '_return_http_data_only', True
            )
            kwargs['_preload_content'] = kwargs.get(
                '_preload_content', True
            )
            kwargs['_request_timeout'] = kwargs.get(
                '_request_timeout', None
            )
            kwargs['_check_input_type'] = kwargs.get(
                '_check_input_type', True
            )
            kwargs['_check_return_type'] = kwargs.get(
                '_check_return_type', True
            )
            kwargs['_host_index'] = kwargs.get('_host_index')
            kwargs['payment_initiation_recipient_get_request'] = \
                payment_initiation_recipient_get_request
            return self.call_with_http_info(**kwargs)

        self.payment_initiation_recipient_get = _Endpoint(
            settings={
                'response_type': (PaymentInitiationRecipientGetResponse,),
                'auth': [
                    'clientId',
                    'plaidVersion',
                    'secret'
                ],
                'endpoint_path': '/payment_initiation/recipient/get',
                'operation_id': 'payment_initiation_recipient_get',
                'http_method': 'POST',
                'servers': None,
            },
            params_map={
                'all': [
                    'payment_initiation_recipient_get_request',
                ],
                'required': [
                    'payment_initiation_recipient_get_request',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'payment_initiation_recipient_get_request':
                        (PaymentInitiationRecipientGetRequest,),
                },
                'attribute_map': {
                },
                'location_map': {
                    'payment_initiation_recipient_get_request': 'body',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [
                    'application/json'
                ]
            },
            api_client=api_client,
            callable=__payment_initiation_recipient_get
        )

        def __payment_initiation_recipient_list(
            self,
            payment_initiation_recipient_list_request,
            **kwargs
        ):
            """List payment recipients  # noqa: E501

            The `/payment_initiation/recipient/list` endpoint list the payment recipients that you have previously created.  # noqa: E501
            This method makes a synchronous HTTP request by default. To make an
            asynchronous HTTP request, please pass async_req=True

            >>> thread = api.payment_initiation_recipient_list(payment_initiation_recipient_list_request, async_req=True)
            >>> result = thread.get()

            Args:
                payment_initiation_recipient_list_request (PaymentInitiationRecipientListRequest):

            Keyword Args:
                _return_http_data_only (bool): response data without head status
                    code and headers. Default is True.
                _preload_content (bool): if False, the urllib3.HTTPResponse object
                    will be returned without reading/decoding response data.
                    Default is True.
                _request_timeout (float/tuple): timeout setting for this request. If one
                    number provided, it will be total request timeout. It can also
                    be a pair (tuple) of (connection, read) timeouts.
                    Default is None.
                _check_input_type (bool): specifies if type checking
                    should be done one the data sent to the server.
                    Default is True.
                _check_return_type (bool): specifies if type checking
                    should be done one the data received from the server.
                    Default is True.
                _host_index (int/None): specifies the index of the server
                    that we want to use.
                    Default is read from the configuration.
                async_req (bool): execute request asynchronously

            Returns:
                PaymentInitiationRecipientListResponse
                    If the method is called asynchronously, returns the request
                    thread.
            """
            kwargs['async_req'] = kwargs.get(
                'async_req', False
            )
            kwargs['_return_http_data_only'] = kwargs.get(
                '_return_http_data_only', True
            )
            kwargs['_preload_content'] = kwargs.get(
                '_preload_content', True
            )
            kwargs['_request_timeout'] = kwargs.get(
                '_request_timeout', None
            )
            kwargs['_check_input_type'] = kwargs.get(
                '_check_input_type', True
            )
            kwargs['_check_return_type'] = kwargs.get(
                '_check_return_type', True
            )
            kwargs['_host_index'] = kwargs.get('_host_index')
            kwargs['payment_initiation_recipient_list_request'] = \
                payment_initiation_recipient_list_request
            return self.call_with_http_info(**kwargs)

        self.payment_initiation_recipient_list = _Endpoint(
            settings={
                'response_type': (PaymentInitiationRecipientListResponse,),
                'auth': [
                    'clientId',
                    'plaidVersion',
                    'secret'
                ],
                'endpoint_path': '/payment_initiation/recipient/list',
                'operation_id': 'payment_initiation_recipient_list',
                'http_method': 'POST',
                'servers': None,
            },
            params_map={
                'all': [
                    'payment_initiation_recipient_list_request',
                ],
                'required': [
                    'payment_initiation_recipient_list_request',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'payment_initiation_recipient_list_request':
                        (PaymentInitiationRecipientListRequest,),
                },
                'attribute_map': {
                },
                'location_map': {
                    'payment_initiation_recipient_list_request': 'body',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [
                    'application/json'
                ]
            },
            api_client=api_client,
            callable=__payment_initiation_recipient_list
        )

        def __processor_apex_processor_token_create(
            self,
            processor_apex_processor_token_create_request,
            **kwargs
        ):
            """Create Apex bank account token  # noqa: E501

            Used to create a token suitable for sending to Apex to enable Plaid-Apex integrations.  # noqa: E501
            This method makes a synchronous HTTP request by default. To make an
            asynchronous HTTP request, please pass async_req=True

            >>> thread = api.processor_apex_processor_token_create(processor_apex_processor_token_create_request, async_req=True)
            >>> result = thread.get()

            Args:
                processor_apex_processor_token_create_request (ProcessorApexProcessorTokenCreateRequest):

            Keyword Args:
                _return_http_data_only (bool): response data without head status
                    code and headers. Default is True.
                _preload_content (bool): if False, the urllib3.HTTPResponse object
                    will be returned without reading/decoding response data.
                    Default is True.
                _request_timeout (float/tuple): timeout setting for this request. If one
                    number provided, it will be total request timeout. It can also
                    be a pair (tuple) of (connection, read) timeouts.
                    Default is None.
                _check_input_type (bool): specifies if type checking
                    should be done one the data sent to the server.
                    Default is True.
                _check_return_type (bool): specifies if type checking
                    should be done one the data received from the server.
                    Default is True.
                _host_index (int/None): specifies the index of the server
                    that we want to use.
                    Default is read from the configuration.
                async_req (bool): execute request asynchronously

            Returns:
                ProcessorTokenCreateResponse
                    If the method is called asynchronously, returns the request
                    thread.
            """
            kwargs['async_req'] = kwargs.get(
                'async_req', False
            )
            kwargs['_return_http_data_only'] = kwargs.get(
                '_return_http_data_only', True
            )
            kwargs['_preload_content'] = kwargs.get(
                '_preload_content', True
            )
            kwargs['_request_timeout'] = kwargs.get(
                '_request_timeout', None
            )
            kwargs['_check_input_type'] = kwargs.get(
                '_check_input_type', True
            )
            kwargs['_check_return_type'] = kwargs.get(
                '_check_return_type', True
            )
            kwargs['_host_index'] = kwargs.get('_host_index')
            kwargs['processor_apex_processor_token_create_request'] = \
                processor_apex_processor_token_create_request
            return self.call_with_http_info(**kwargs)

        self.processor_apex_processor_token_create = _Endpoint(
            settings={
                'response_type': (ProcessorTokenCreateResponse,),
                'auth': [
                    'clientId',
                    'plaidVersion',
                    'secret'
                ],
                'endpoint_path': '/processor/apex/processor_token/create',
                'operation_id': 'processor_apex_processor_token_create',
                'http_method': 'POST',
                'servers': None,
            },
            params_map={
                'all': [
                    'processor_apex_processor_token_create_request',
                ],
                'required': [
                    'processor_apex_processor_token_create_request',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'processor_apex_processor_token_create_request':
                        (ProcessorApexProcessorTokenCreateRequest,),
                },
                'attribute_map': {
                },
                'location_map': {
                    'processor_apex_processor_token_create_request': 'body',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [
                    'application/json'
                ]
            },
            api_client=api_client,
            callable=__processor_apex_processor_token_create
        )

        def __processor_auth_get(
            self,
            processor_auth_get_request,
            **kwargs
        ):
            """Retrieve Auth data  # noqa: E501

            The `/processor/auth/get` endpoint returns the bank account and bank identification number (such as the routing number, for US accounts), for a checking or savings account that''s associated with a given `processor_token`. The endpoint also returns high-level account data and balances when available.  Versioning note: API versions 2019-05-29 and earlier use a different schema for the `numbers` object returned by this endpoint. For details, see [Plaid API versioning](https://plaid.com/docs/api/versioning/#version-2020-09-14).   # noqa: E501
            This method makes a synchronous HTTP request by default. To make an
            asynchronous HTTP request, please pass async_req=True

            >>> thread = api.processor_auth_get(processor_auth_get_request, async_req=True)
            >>> result = thread.get()

            Args:
                processor_auth_get_request (ProcessorAuthGetRequest):

            Keyword Args:
                _return_http_data_only (bool): response data without head status
                    code and headers. Default is True.
                _preload_content (bool): if False, the urllib3.HTTPResponse object
                    will be returned without reading/decoding response data.
                    Default is True.
                _request_timeout (float/tuple): timeout setting for this request. If one
                    number provided, it will be total request timeout. It can also
                    be a pair (tuple) of (connection, read) timeouts.
                    Default is None.
                _check_input_type (bool): specifies if type checking
                    should be done one the data sent to the server.
                    Default is True.
                _check_return_type (bool): specifies if type checking
                    should be done one the data received from the server.
                    Default is True.
                _host_index (int/None): specifies the index of the server
                    that we want to use.
                    Default is read from the configuration.
                async_req (bool): execute request asynchronously

            Returns:
                ProcessorAuthGetResponse
                    If the method is called asynchronously, returns the request
                    thread.
            """
            kwargs['async_req'] = kwargs.get(
                'async_req', False
            )
            kwargs['_return_http_data_only'] = kwargs.get(
                '_return_http_data_only', True
            )
            kwargs['_preload_content'] = kwargs.get(
                '_preload_content', True
            )
            kwargs['_request_timeout'] = kwargs.get(
                '_request_timeout', None
            )
            kwargs['_check_input_type'] = kwargs.get(
                '_check_input_type', True
            )
            kwargs['_check_return_type'] = kwargs.get(
                '_check_return_type', True
            )
            kwargs['_host_index'] = kwargs.get('_host_index')
            kwargs['processor_auth_get_request'] = \
                processor_auth_get_request
            return self.call_with_http_info(**kwargs)

        self.processor_auth_get = _Endpoint(
            settings={
                'response_type': (ProcessorAuthGetResponse,),
                'auth': [
                    'clientId',
                    'plaidVersion',
                    'secret'
                ],
                'endpoint_path': '/processor/auth/get',
                'operation_id': 'processor_auth_get',
                'http_method': 'POST',
                'servers': None,
            },
            params_map={
                'all': [
                    'processor_auth_get_request',
                ],
                'required': [
                    'processor_auth_get_request',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'processor_auth_get_request':
                        (ProcessorAuthGetRequest,),
                },
                'attribute_map': {
                },
                'location_map': {
                    'processor_auth_get_request': 'body',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [
                    'application/json'
                ]
            },
            api_client=api_client,
            callable=__processor_auth_get
        )

        def __processor_balance_get(
            self,
            processor_balance_get_request,
            **kwargs
        ):
            """Retrieve Balance data  # noqa: E501

            The `/processor/balance/get` endpoint returns the real-time balance for each of an Item's accounts. While other endpoints may return a balance object, only `/processor/balance/get` forces the available and current balance fields to be refreshed rather than cached.   # noqa: E501
            This method makes a synchronous HTTP request by default. To make an
            asynchronous HTTP request, please pass async_req=True

            >>> thread = api.processor_balance_get(processor_balance_get_request, async_req=True)
            >>> result = thread.get()

            Args:
                processor_balance_get_request (ProcessorBalanceGetRequest): The `/processor/balance/get` endpoint returns the real-time balance for the account associated with a given `processor_token`.  The current balance is the total amount of funds in the account. The available balance is the current balance less any outstanding holds or debits that have not yet posted to the account.  Note that not all institutions calculate the available balance. In the event that available balance is unavailable from the institution, Plaid will return an available balance value of `null`.

            Keyword Args:
                _return_http_data_only (bool): response data without head status
                    code and headers. Default is True.
                _preload_content (bool): if False, the urllib3.HTTPResponse object
                    will be returned without reading/decoding response data.
                    Default is True.
                _request_timeout (float/tuple): timeout setting for this request. If one
                    number provided, it will be total request timeout. It can also
                    be a pair (tuple) of (connection, read) timeouts.
                    Default is None.
                _check_input_type (bool): specifies if type checking
                    should be done one the data sent to the server.
                    Default is True.
                _check_return_type (bool): specifies if type checking
                    should be done one the data received from the server.
                    Default is True.
                _host_index (int/None): specifies the index of the server
                    that we want to use.
                    Default is read from the configuration.
                async_req (bool): execute request asynchronously

            Returns:
                ProcessorBalanceGetResponse
                    If the method is called asynchronously, returns the request
                    thread.
            """
            kwargs['async_req'] = kwargs.get(
                'async_req', False
            )
            kwargs['_return_http_data_only'] = kwargs.get(
                '_return_http_data_only', True
            )
            kwargs['_preload_content'] = kwargs.get(
                '_preload_content', True
            )
            kwargs['_request_timeout'] = kwargs.get(
                '_request_timeout', None
            )
            kwargs['_check_input_type'] = kwargs.get(
                '_check_input_type', True
            )
            kwargs['_check_return_type'] = kwargs.get(
                '_check_return_type', True
            )
            kwargs['_host_index'] = kwargs.get('_host_index')
            kwargs['processor_balance_get_request'] = \
                processor_balance_get_request
            return self.call_with_http_info(**kwargs)

        self.processor_balance_get = _Endpoint(
            settings={
                'response_type': (ProcessorBalanceGetResponse,),
                'auth': [
                    'clientId',
                    'plaidVersion',
                    'secret'
                ],
                'endpoint_path': '/processor/balance/get',
                'operation_id': 'processor_balance_get',
                'http_method': 'POST',
                'servers': None,
            },
            params_map={
                'all': [
                    'processor_balance_get_request',
                ],
                'required': [
                    'processor_balance_get_request',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'processor_balance_get_request':
                        (ProcessorBalanceGetRequest,),
                },
                'attribute_map': {
                },
                'location_map': {
                    'processor_balance_get_request': 'body',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [
                    'application/json'
                ]
            },
            api_client=api_client,
            callable=__processor_balance_get
        )

        def __processor_bank_transfer_create(
            self,
            processor_bank_transfer_create_request,
            **kwargs
        ):
            """Create a bank transfer as a processor  # noqa: E501

            Use the `/processor/bank_transfer/create` endpoint to initiate a new bank transfer as a processor  # noqa: E501
            This method makes a synchronous HTTP request by default. To make an
            asynchronous HTTP request, please pass async_req=True

            >>> thread = api.processor_bank_transfer_create(processor_bank_transfer_create_request, async_req=True)
            >>> result = thread.get()

            Args:
                processor_bank_transfer_create_request (ProcessorBankTransferCreateRequest):

            Keyword Args:
                _return_http_data_only (bool): response data without head status
                    code and headers. Default is True.
                _preload_content (bool): if False, the urllib3.HTTPResponse object
                    will be returned without reading/decoding response data.
                    Default is True.
                _request_timeout (float/tuple): timeout setting for this request. If one
                    number provided, it will be total request timeout. It can also
                    be a pair (tuple) of (connection, read) timeouts.
                    Default is None.
                _check_input_type (bool): specifies if type checking
                    should be done one the data sent to the server.
                    Default is True.
                _check_return_type (bool): specifies if type checking
                    should be done one the data received from the server.
                    Default is True.
                _host_index (int/None): specifies the index of the server
                    that we want to use.
                    Default is read from the configuration.
                async_req (bool): execute request asynchronously

            Returns:
                ProcessorBankTransferCreateResponse
                    If the method is called asynchronously, returns the request
                    thread.
            """
            kwargs['async_req'] = kwargs.get(
                'async_req', False
            )
            kwargs['_return_http_data_only'] = kwargs.get(
                '_return_http_data_only', True
            )
            kwargs['_preload_content'] = kwargs.get(
                '_preload_content', True
            )
            kwargs['_request_timeout'] = kwargs.get(
                '_request_timeout', None
            )
            kwargs['_check_input_type'] = kwargs.get(
                '_check_input_type', True
            )
            kwargs['_check_return_type'] = kwargs.get(
                '_check_return_type', True
            )
            kwargs['_host_index'] = kwargs.get('_host_index')
            kwargs['processor_bank_transfer_create_request'] = \
                processor_bank_transfer_create_request
            return self.call_with_http_info(**kwargs)

        self.processor_bank_transfer_create = _Endpoint(
            settings={
                'response_type': (ProcessorBankTransferCreateResponse,),
                'auth': [
                    'clientId',
                    'plaidVersion',
                    'secret'
                ],
                'endpoint_path': '/processor/bank_transfer/create',
                'operation_id': 'processor_bank_transfer_create',
                'http_method': 'POST',
                'servers': None,
            },
            params_map={
                'all': [
                    'processor_bank_transfer_create_request',
                ],
                'required': [
                    'processor_bank_transfer_create_request',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'processor_bank_transfer_create_request':
                        (ProcessorBankTransferCreateRequest,),
                },
                'attribute_map': {
                },
                'location_map': {
                    'processor_bank_transfer_create_request': 'body',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [
                    'application/json'
                ]
            },
            api_client=api_client,
            callable=__processor_bank_transfer_create
        )

        def __processor_identity_get(
            self,
            processor_identity_get_request,
            **kwargs
        ):
            """Retrieve Identity data  # noqa: E501

            The `/processor/identity/get` endpoint allows you to retrieve various account holder information on file with the financial institution, including names, emails, phone numbers, and addresses.  # noqa: E501
            This method makes a synchronous HTTP request by default. To make an
            asynchronous HTTP request, please pass async_req=True

            >>> thread = api.processor_identity_get(processor_identity_get_request, async_req=True)
            >>> result = thread.get()

            Args:
                processor_identity_get_request (ProcessorIdentityGetRequest):

            Keyword Args:
                _return_http_data_only (bool): response data without head status
                    code and headers. Default is True.
                _preload_content (bool): if False, the urllib3.HTTPResponse object
                    will be returned without reading/decoding response data.
                    Default is True.
                _request_timeout (float/tuple): timeout setting for this request. If one
                    number provided, it will be total request timeout. It can also
                    be a pair (tuple) of (connection, read) timeouts.
                    Default is None.
                _check_input_type (bool): specifies if type checking
                    should be done one the data sent to the server.
                    Default is True.
                _check_return_type (bool): specifies if type checking
                    should be done one the data received from the server.
                    Default is True.
                _host_index (int/None): specifies the index of the server
                    that we want to use.
                    Default is read from the configuration.
                async_req (bool): execute request asynchronously

            Returns:
                ProcessorIdentityGetResponse
                    If the method is called asynchronously, returns the request
                    thread.
            """
            kwargs['async_req'] = kwargs.get(
                'async_req', False
            )
            kwargs['_return_http_data_only'] = kwargs.get(
                '_return_http_data_only', True
            )
            kwargs['_preload_content'] = kwargs.get(
                '_preload_content', True
            )
            kwargs['_request_timeout'] = kwargs.get(
                '_request_timeout', None
            )
            kwargs['_check_input_type'] = kwargs.get(
                '_check_input_type', True
            )
            kwargs['_check_return_type'] = kwargs.get(
                '_check_return_type', True
            )
            kwargs['_host_index'] = kwargs.get('_host_index')
            kwargs['processor_identity_get_request'] = \
                processor_identity_get_request
            return self.call_with_http_info(**kwargs)

        self.processor_identity_get = _Endpoint(
            settings={
                'response_type': (ProcessorIdentityGetResponse,),
                'auth': [
                    'clientId',
                    'plaidVersion',
                    'secret'
                ],
                'endpoint_path': '/processor/identity/get',
                'operation_id': 'processor_identity_get',
                'http_method': 'POST',
                'servers': None,
            },
            params_map={
                'all': [
                    'processor_identity_get_request',
                ],
                'required': [
                    'processor_identity_get_request',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'processor_identity_get_request':
                        (ProcessorIdentityGetRequest,),
                },
                'attribute_map': {
                },
                'location_map': {
                    'processor_identity_get_request': 'body',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [
                    'application/json'
                ]
            },
            api_client=api_client,
            callable=__processor_identity_get
        )

        def __processor_stripe_bank_account_token_create(
            self,
            processor_stripe_bank_account_token_create_request,
            **kwargs
        ):
            """Create Stripe bank account token  # noqa: E501

            Used to create a token suitable for sending to Stripe to enable Plaid-Stripe integrations. For a detailed guide on integrating Stripe, see [Add Stripe to your app](https://plaid.com/docs/auth/partnerships/stripe/). Bank account tokens can also be revoked, using `/item/remove`.  # noqa: E501
            This method makes a synchronous HTTP request by default. To make an
            asynchronous HTTP request, please pass async_req=True

            >>> thread = api.processor_stripe_bank_account_token_create(processor_stripe_bank_account_token_create_request, async_req=True)
            >>> result = thread.get()

            Args:
                processor_stripe_bank_account_token_create_request (ProcessorStripeBankAccountTokenCreateRequest):

            Keyword Args:
                _return_http_data_only (bool): response data without head status
                    code and headers. Default is True.
                _preload_content (bool): if False, the urllib3.HTTPResponse object
                    will be returned without reading/decoding response data.
                    Default is True.
                _request_timeout (float/tuple): timeout setting for this request. If one
                    number provided, it will be total request timeout. It can also
                    be a pair (tuple) of (connection, read) timeouts.
                    Default is None.
                _check_input_type (bool): specifies if type checking
                    should be done one the data sent to the server.
                    Default is True.
                _check_return_type (bool): specifies if type checking
                    should be done one the data received from the server.
                    Default is True.
                _host_index (int/None): specifies the index of the server
                    that we want to use.
                    Default is read from the configuration.
                async_req (bool): execute request asynchronously

            Returns:
                ProcessorStripeBankAccountTokenCreateResponse
                    If the method is called asynchronously, returns the request
                    thread.
            """
            kwargs['async_req'] = kwargs.get(
                'async_req', False
            )
            kwargs['_return_http_data_only'] = kwargs.get(
                '_return_http_data_only', True
            )
            kwargs['_preload_content'] = kwargs.get(
                '_preload_content', True
            )
            kwargs['_request_timeout'] = kwargs.get(
                '_request_timeout', None
            )
            kwargs['_check_input_type'] = kwargs.get(
                '_check_input_type', True
            )
            kwargs['_check_return_type'] = kwargs.get(
                '_check_return_type', True
            )
            kwargs['_host_index'] = kwargs.get('_host_index')
            kwargs['processor_stripe_bank_account_token_create_request'] = \
                processor_stripe_bank_account_token_create_request
            return self.call_with_http_info(**kwargs)

        self.processor_stripe_bank_account_token_create = _Endpoint(
            settings={
                'response_type': (ProcessorStripeBankAccountTokenCreateResponse,),
                'auth': [
                    'clientId',
                    'plaidVersion',
                    'secret'
                ],
                'endpoint_path': '/processor/stripe/bank_account_token/create',
                'operation_id': 'processor_stripe_bank_account_token_create',
                'http_method': 'POST',
                'servers': None,
            },
            params_map={
                'all': [
                    'processor_stripe_bank_account_token_create_request',
                ],
                'required': [
                    'processor_stripe_bank_account_token_create_request',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'processor_stripe_bank_account_token_create_request':
                        (ProcessorStripeBankAccountTokenCreateRequest,),
                },
                'attribute_map': {
                },
                'location_map': {
                    'processor_stripe_bank_account_token_create_request': 'body',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [
                    'application/json'
                ]
            },
            api_client=api_client,
            callable=__processor_stripe_bank_account_token_create
        )

        def __processor_token_create(
            self,
            processor_token_create_request,
            **kwargs
        ):
            """Create processor token  # noqa: E501

            Used to create a token suitable for sending to one of Plaid's partners to enable integrations. Note that Stripe partnerships use bank account tokens instead; see `/processor/stripe/bank_account_token/create` for creating tokens for use with Stripe integrations. Processor tokens can also be revoked, using `/item/remove`.  # noqa: E501
            This method makes a synchronous HTTP request by default. To make an
            asynchronous HTTP request, please pass async_req=True

            >>> thread = api.processor_token_create(processor_token_create_request, async_req=True)
            >>> result = thread.get()

            Args:
                processor_token_create_request (ProcessorTokenCreateRequest):

            Keyword Args:
                _return_http_data_only (bool): response data without head status
                    code and headers. Default is True.
                _preload_content (bool): if False, the urllib3.HTTPResponse object
                    will be returned without reading/decoding response data.
                    Default is True.
                _request_timeout (float/tuple): timeout setting for this request. If one
                    number provided, it will be total request timeout. It can also
                    be a pair (tuple) of (connection, read) timeouts.
                    Default is None.
                _check_input_type (bool): specifies if type checking
                    should be done one the data sent to the server.
                    Default is True.
                _check_return_type (bool): specifies if type checking
                    should be done one the data received from the server.
                    Default is True.
                _host_index (int/None): specifies the index of the server
                    that we want to use.
                    Default is read from the configuration.
                async_req (bool): execute request asynchronously

            Returns:
                ProcessorTokenCreateResponse
                    If the method is called asynchronously, returns the request
                    thread.
            """
            kwargs['async_req'] = kwargs.get(
                'async_req', False
            )
            kwargs['_return_http_data_only'] = kwargs.get(
                '_return_http_data_only', True
            )
            kwargs['_preload_content'] = kwargs.get(
                '_preload_content', True
            )
            kwargs['_request_timeout'] = kwargs.get(
                '_request_timeout', None
            )
            kwargs['_check_input_type'] = kwargs.get(
                '_check_input_type', True
            )
            kwargs['_check_return_type'] = kwargs.get(
                '_check_return_type', True
            )
            kwargs['_host_index'] = kwargs.get('_host_index')
            kwargs['processor_token_create_request'] = \
                processor_token_create_request
            return self.call_with_http_info(**kwargs)

        self.processor_token_create = _Endpoint(
            settings={
                'response_type': (ProcessorTokenCreateResponse,),
                'auth': [
                    'clientId',
                    'plaidVersion',
                    'secret'
                ],
                'endpoint_path': '/processor/token/create',
                'operation_id': 'processor_token_create',
                'http_method': 'POST',
                'servers': None,
            },
            params_map={
                'all': [
                    'processor_token_create_request',
                ],
                'required': [
                    'processor_token_create_request',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'processor_token_create_request':
                        (ProcessorTokenCreateRequest,),
                },
                'attribute_map': {
                },
                'location_map': {
                    'processor_token_create_request': 'body',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [
                    'application/json'
                ]
            },
            api_client=api_client,
            callable=__processor_token_create
        )

        def __sandbox_bank_transfer_fire_webhook(
            self,
            sandbox_bank_transfer_fire_webhook_request,
            **kwargs
        ):
            """Manually fire a Bank Transfer webhook  # noqa: E501

            Use the `/sandbox/bank_transfer/fire_webhook` endpoint to manually trigger a Bank Transfers webhook in the Sandbox environment.  # noqa: E501
            This method makes a synchronous HTTP request by default. To make an
            asynchronous HTTP request, please pass async_req=True

            >>> thread = api.sandbox_bank_transfer_fire_webhook(sandbox_bank_transfer_fire_webhook_request, async_req=True)
            >>> result = thread.get()

            Args:
                sandbox_bank_transfer_fire_webhook_request (SandboxBankTransferFireWebhookRequest):

            Keyword Args:
                _return_http_data_only (bool): response data without head status
                    code and headers. Default is True.
                _preload_content (bool): if False, the urllib3.HTTPResponse object
                    will be returned without reading/decoding response data.
                    Default is True.
                _request_timeout (float/tuple): timeout setting for this request. If one
                    number provided, it will be total request timeout. It can also
                    be a pair (tuple) of (connection, read) timeouts.
                    Default is None.
                _check_input_type (bool): specifies if type checking
                    should be done one the data sent to the server.
                    Default is True.
                _check_return_type (bool): specifies if type checking
                    should be done one the data received from the server.
                    Default is True.
                _host_index (int/None): specifies the index of the server
                    that we want to use.
                    Default is read from the configuration.
                async_req (bool): execute request asynchronously

            Returns:
                SandboxBankTransferFireWebhookResponse
                    If the method is called asynchronously, returns the request
                    thread.
            """
            kwargs['async_req'] = kwargs.get(
                'async_req', False
            )
            kwargs['_return_http_data_only'] = kwargs.get(
                '_return_http_data_only', True
            )
            kwargs['_preload_content'] = kwargs.get(
                '_preload_content', True
            )
            kwargs['_request_timeout'] = kwargs.get(
                '_request_timeout', None
            )
            kwargs['_check_input_type'] = kwargs.get(
                '_check_input_type', True
            )
            kwargs['_check_return_type'] = kwargs.get(
                '_check_return_type', True
            )
            kwargs['_host_index'] = kwargs.get('_host_index')
            kwargs['sandbox_bank_transfer_fire_webhook_request'] = \
                sandbox_bank_transfer_fire_webhook_request
            return self.call_with_http_info(**kwargs)

        self.sandbox_bank_transfer_fire_webhook = _Endpoint(
            settings={
                'response_type': (SandboxBankTransferFireWebhookResponse,),
                'auth': [
                    'clientId',
                    'plaidVersion',
                    'secret'
                ],
                'endpoint_path': '/sandbox/bank_transfer/fire_webhook',
                'operation_id': 'sandbox_bank_transfer_fire_webhook',
                'http_method': 'POST',
                'servers': None,
            },
            params_map={
                'all': [
                    'sandbox_bank_transfer_fire_webhook_request',
                ],
                'required': [
                    'sandbox_bank_transfer_fire_webhook_request',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'sandbox_bank_transfer_fire_webhook_request':
                        (SandboxBankTransferFireWebhookRequest,),
                },
                'attribute_map': {
                },
                'location_map': {
                    'sandbox_bank_transfer_fire_webhook_request': 'body',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [
                    'application/json'
                ]
            },
            api_client=api_client,
            callable=__sandbox_bank_transfer_fire_webhook
        )

        def __sandbox_bank_transfer_simulate(
            self,
            sandbox_bank_transfer_simulate_request,
            **kwargs
        ):
            """Simulate a bank transfer event in Sandbox  # noqa: E501

            Use the `/sandbox/bank_transfer/simulate` endpoint to simulate a bank transfer event in the Sandbox environment.  Note that while an event will be simulated and will appear when using endpoints such as `/bank_transfer/event/sync` or `/bank_transfer/event/list`, no transactions will actually take place and funds will not move between accounts, even within the Sandbox.  # noqa: E501
            This method makes a synchronous HTTP request by default. To make an
            asynchronous HTTP request, please pass async_req=True

            >>> thread = api.sandbox_bank_transfer_simulate(sandbox_bank_transfer_simulate_request, async_req=True)
            >>> result = thread.get()

            Args:
                sandbox_bank_transfer_simulate_request (SandboxBankTransferSimulateRequest):

            Keyword Args:
                _return_http_data_only (bool): response data without head status
                    code and headers. Default is True.
                _preload_content (bool): if False, the urllib3.HTTPResponse object
                    will be returned without reading/decoding response data.
                    Default is True.
                _request_timeout (float/tuple): timeout setting for this request. If one
                    number provided, it will be total request timeout. It can also
                    be a pair (tuple) of (connection, read) timeouts.
                    Default is None.
                _check_input_type (bool): specifies if type checking
                    should be done one the data sent to the server.
                    Default is True.
                _check_return_type (bool): specifies if type checking
                    should be done one the data received from the server.
                    Default is True.
                _host_index (int/None): specifies the index of the server
                    that we want to use.
                    Default is read from the configuration.
                async_req (bool): execute request asynchronously

            Returns:
                SandboxBankTransferSimulateResponse
                    If the method is called asynchronously, returns the request
                    thread.
            """
            kwargs['async_req'] = kwargs.get(
                'async_req', False
            )
            kwargs['_return_http_data_only'] = kwargs.get(
                '_return_http_data_only', True
            )
            kwargs['_preload_content'] = kwargs.get(
                '_preload_content', True
            )
            kwargs['_request_timeout'] = kwargs.get(
                '_request_timeout', None
            )
            kwargs['_check_input_type'] = kwargs.get(
                '_check_input_type', True
            )
            kwargs['_check_return_type'] = kwargs.get(
                '_check_return_type', True
            )
            kwargs['_host_index'] = kwargs.get('_host_index')
            kwargs['sandbox_bank_transfer_simulate_request'] = \
                sandbox_bank_transfer_simulate_request
            return self.call_with_http_info(**kwargs)

        self.sandbox_bank_transfer_simulate = _Endpoint(
            settings={
                'response_type': (SandboxBankTransferSimulateResponse,),
                'auth': [
                    'clientId',
                    'plaidVersion',
                    'secret'
                ],
                'endpoint_path': '/sandbox/bank_transfer/simulate',
                'operation_id': 'sandbox_bank_transfer_simulate',
                'http_method': 'POST',
                'servers': None,
            },
            params_map={
                'all': [
                    'sandbox_bank_transfer_simulate_request',
                ],
                'required': [
                    'sandbox_bank_transfer_simulate_request',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'sandbox_bank_transfer_simulate_request':
                        (SandboxBankTransferSimulateRequest,),
                },
                'attribute_map': {
                },
                'location_map': {
                    'sandbox_bank_transfer_simulate_request': 'body',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [
                    'application/json'
                ]
            },
            api_client=api_client,
            callable=__sandbox_bank_transfer_simulate
        )

        def __sandbox_income_fire_webhook(
            self,
            sandbox_income_fire_webhook_request,
            **kwargs
        ):
            """Manually fire an Income webhook  # noqa: E501

            Use the `/sandbox/income/fire_webhook` endpoint to manually trigger an Income webhook in the Sandbox environment.  # noqa: E501
            This method makes a synchronous HTTP request by default. To make an
            asynchronous HTTP request, please pass async_req=True

            >>> thread = api.sandbox_income_fire_webhook(sandbox_income_fire_webhook_request, async_req=True)
            >>> result = thread.get()

            Args:
                sandbox_income_fire_webhook_request (SandboxIncomeFireWebhookRequest):

            Keyword Args:
                _return_http_data_only (bool): response data without head status
                    code and headers. Default is True.
                _preload_content (bool): if False, the urllib3.HTTPResponse object
                    will be returned without reading/decoding response data.
                    Default is True.
                _request_timeout (float/tuple): timeout setting for this request. If one
                    number provided, it will be total request timeout. It can also
                    be a pair (tuple) of (connection, read) timeouts.
                    Default is None.
                _check_input_type (bool): specifies if type checking
                    should be done one the data sent to the server.
                    Default is True.
                _check_return_type (bool): specifies if type checking
                    should be done one the data received from the server.
                    Default is True.
                _host_index (int/None): specifies the index of the server
                    that we want to use.
                    Default is read from the configuration.
                async_req (bool): execute request asynchronously

            Returns:
                SandboxIncomeFireWebhookResponse
                    If the method is called asynchronously, returns the request
                    thread.
            """
            kwargs['async_req'] = kwargs.get(
                'async_req', False
            )
            kwargs['_return_http_data_only'] = kwargs.get(
                '_return_http_data_only', True
            )
            kwargs['_preload_content'] = kwargs.get(
                '_preload_content', True
            )
            kwargs['_request_timeout'] = kwargs.get(
                '_request_timeout', None
            )
            kwargs['_check_input_type'] = kwargs.get(
                '_check_input_type', True
            )
            kwargs['_check_return_type'] = kwargs.get(
                '_check_return_type', True
            )
            kwargs['_host_index'] = kwargs.get('_host_index')
            kwargs['sandbox_income_fire_webhook_request'] = \
                sandbox_income_fire_webhook_request
            return self.call_with_http_info(**kwargs)

        self.sandbox_income_fire_webhook = _Endpoint(
            settings={
                'response_type': (SandboxIncomeFireWebhookResponse,),
                'auth': [
                    'clientId',
                    'plaidVersion',
                    'secret'
                ],
                'endpoint_path': '/sandbox/income/fire_webhook',
                'operation_id': 'sandbox_income_fire_webhook',
                'http_method': 'POST',
                'servers': None,
            },
            params_map={
                'all': [
                    'sandbox_income_fire_webhook_request',
                ],
                'required': [
                    'sandbox_income_fire_webhook_request',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'sandbox_income_fire_webhook_request':
                        (SandboxIncomeFireWebhookRequest,),
                },
                'attribute_map': {
                },
                'location_map': {
                    'sandbox_income_fire_webhook_request': 'body',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [
                    'application/json'
                ]
            },
            api_client=api_client,
            callable=__sandbox_income_fire_webhook
        )

        def __sandbox_item_fire_webhook(
            self,
            sandbox_item_fire_webhook_request,
            **kwargs
        ):
            """Fire a test webhook  # noqa: E501

            The `/sandbox/item/fire_webhook` endpoint is used to test that code correctly handles webhooks. This endpoint can trigger the following webhooks:  `DEFAULT_UPDATE`: Transactions update webhook to be fired for a given Sandbox Item. If the Item does not support Transactions, a `SANDBOX_PRODUCT_NOT_ENABLED` error will result.  `NEW_ACCOUNTS_AVAILABLE`: Webhook to be fired for a given Sandbox Item created with Account Select v2.  `AUTH_DATA_UPDATE`: Webhook to be fired for a given Sandbox Item created with Auth as an enabled product.  Note that this endpoint is provided for developer ease-of-use and is not required for testing webhooks; webhooks will also fire in Sandbox under the same conditions that they would in Production or Development'  # noqa: E501
            This method makes a synchronous HTTP request by default. To make an
            asynchronous HTTP request, please pass async_req=True

            >>> thread = api.sandbox_item_fire_webhook(sandbox_item_fire_webhook_request, async_req=True)
            >>> result = thread.get()

            Args:
                sandbox_item_fire_webhook_request (SandboxItemFireWebhookRequest):

            Keyword Args:
                _return_http_data_only (bool): response data without head status
                    code and headers. Default is True.
                _preload_content (bool): if False, the urllib3.HTTPResponse object
                    will be returned without reading/decoding response data.
                    Default is True.
                _request_timeout (float/tuple): timeout setting for this request. If one
                    number provided, it will be total request timeout. It can also
                    be a pair (tuple) of (connection, read) timeouts.
                    Default is None.
                _check_input_type (bool): specifies if type checking
                    should be done one the data sent to the server.
                    Default is True.
                _check_return_type (bool): specifies if type checking
                    should be done one the data received from the server.
                    Default is True.
                _host_index (int/None): specifies the index of the server
                    that we want to use.
                    Default is read from the configuration.
                async_req (bool): execute request asynchronously

            Returns:
                SandboxItemFireWebhookResponse
                    If the method is called asynchronously, returns the request
                    thread.
            """
            kwargs['async_req'] = kwargs.get(
                'async_req', False
            )
            kwargs['_return_http_data_only'] = kwargs.get(
                '_return_http_data_only', True
            )
            kwargs['_preload_content'] = kwargs.get(
                '_preload_content', True
            )
            kwargs['_request_timeout'] = kwargs.get(
                '_request_timeout', None
            )
            kwargs['_check_input_type'] = kwargs.get(
                '_check_input_type', True
            )
            kwargs['_check_return_type'] = kwargs.get(
                '_check_return_type', True
            )
            kwargs['_host_index'] = kwargs.get('_host_index')
            kwargs['sandbox_item_fire_webhook_request'] = \
                sandbox_item_fire_webhook_request
            return self.call_with_http_info(**kwargs)

        self.sandbox_item_fire_webhook = _Endpoint(
            settings={
                'response_type': (SandboxItemFireWebhookResponse,),
                'auth': [
                    'clientId',
                    'plaidVersion',
                    'secret'
                ],
                'endpoint_path': '/sandbox/item/fire_webhook',
                'operation_id': 'sandbox_item_fire_webhook',
                'http_method': 'POST',
                'servers': None,
            },
            params_map={
                'all': [
                    'sandbox_item_fire_webhook_request',
                ],
                'required': [
                    'sandbox_item_fire_webhook_request',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'sandbox_item_fire_webhook_request':
                        (SandboxItemFireWebhookRequest,),
                },
                'attribute_map': {
                },
                'location_map': {
                    'sandbox_item_fire_webhook_request': 'body',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [
                    'application/json'
                ]
            },
            api_client=api_client,
            callable=__sandbox_item_fire_webhook
        )

        def __sandbox_item_reset_login(
            self,
            sandbox_item_reset_login_request,
            **kwargs
        ):
            """Force a Sandbox Item into an error state  # noqa: E501

            `/sandbox/item/reset_login/` forces an Item into an `ITEM_LOGIN_REQUIRED` state in order to simulate an Item whose login is no longer valid. This makes it easy to test Link's [update mode](https://plaid.com/docs/link/update-mode) flow in the Sandbox environment.  After calling `/sandbox/item/reset_login`, You can then use Plaid Link update mode to restore the Item to a good state. An `ITEM_LOGIN_REQUIRED` webhook will also be fired after a call to this endpoint, if one is associated with the Item.   In the Sandbox, Items will transition to an `ITEM_LOGIN_REQUIRED` error state automatically after 30 days, even if this endpoint is not called.  # noqa: E501
            This method makes a synchronous HTTP request by default. To make an
            asynchronous HTTP request, please pass async_req=True

            >>> thread = api.sandbox_item_reset_login(sandbox_item_reset_login_request, async_req=True)
            >>> result = thread.get()

            Args:
                sandbox_item_reset_login_request (SandboxItemResetLoginRequest):

            Keyword Args:
                _return_http_data_only (bool): response data without head status
                    code and headers. Default is True.
                _preload_content (bool): if False, the urllib3.HTTPResponse object
                    will be returned without reading/decoding response data.
                    Default is True.
                _request_timeout (float/tuple): timeout setting for this request. If one
                    number provided, it will be total request timeout. It can also
                    be a pair (tuple) of (connection, read) timeouts.
                    Default is None.
                _check_input_type (bool): specifies if type checking
                    should be done one the data sent to the server.
                    Default is True.
                _check_return_type (bool): specifies if type checking
                    should be done one the data received from the server.
                    Default is True.
                _host_index (int/None): specifies the index of the server
                    that we want to use.
                    Default is read from the configuration.
                async_req (bool): execute request asynchronously

            Returns:
                SandboxItemResetLoginResponse
                    If the method is called asynchronously, returns the request
                    thread.
            """
            kwargs['async_req'] = kwargs.get(
                'async_req', False
            )
            kwargs['_return_http_data_only'] = kwargs.get(
                '_return_http_data_only', True
            )
            kwargs['_preload_content'] = kwargs.get(
                '_preload_content', True
            )
            kwargs['_request_timeout'] = kwargs.get(
                '_request_timeout', None
            )
            kwargs['_check_input_type'] = kwargs.get(
                '_check_input_type', True
            )
            kwargs['_check_return_type'] = kwargs.get(
                '_check_return_type', True
            )
            kwargs['_host_index'] = kwargs.get('_host_index')
            kwargs['sandbox_item_reset_login_request'] = \
                sandbox_item_reset_login_request
            return self.call_with_http_info(**kwargs)

        self.sandbox_item_reset_login = _Endpoint(
            settings={
                'response_type': (SandboxItemResetLoginResponse,),
                'auth': [
                    'clientId',
                    'plaidVersion',
                    'secret'
                ],
                'endpoint_path': '/sandbox/item/reset_login',
                'operation_id': 'sandbox_item_reset_login',
                'http_method': 'POST',
                'servers': None,
            },
            params_map={
                'all': [
                    'sandbox_item_reset_login_request',
                ],
                'required': [
                    'sandbox_item_reset_login_request',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'sandbox_item_reset_login_request':
                        (SandboxItemResetLoginRequest,),
                },
                'attribute_map': {
                },
                'location_map': {
                    'sandbox_item_reset_login_request': 'body',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [
                    'application/json'
                ]
            },
            api_client=api_client,
            callable=__sandbox_item_reset_login
        )

        def __sandbox_item_set_verification_status(
            self,
            sandbox_item_set_verification_status_request,
            **kwargs
        ):
            """Set verification status for Sandbox account  # noqa: E501

            The `/sandbox/item/set_verification_status` endpoint can be used to change the verification status of an Item in in the Sandbox in order to simulate the Automated Micro-deposit flow.  Note that not all Plaid developer accounts are enabled for micro-deposit based verification by default. Your account must be enabled for this feature in order to test it in Sandbox. To enable this features or check your status, contact your account manager or [submit a product access Support ticket](https://dashboard.plaid.com/support/new/product-and-development/product-troubleshooting/request-product-access).  For more information on testing Automated Micro-deposits in Sandbox, see [Auth full coverage testing](https://plaid.com/docs/auth/coverage/testing#).  # noqa: E501
            This method makes a synchronous HTTP request by default. To make an
            asynchronous HTTP request, please pass async_req=True

            >>> thread = api.sandbox_item_set_verification_status(sandbox_item_set_verification_status_request, async_req=True)
            >>> result = thread.get()

            Args:
                sandbox_item_set_verification_status_request (SandboxItemSetVerificationStatusRequest):

            Keyword Args:
                _return_http_data_only (bool): response data without head status
                    code and headers. Default is True.
                _preload_content (bool): if False, the urllib3.HTTPResponse object
                    will be returned without reading/decoding response data.
                    Default is True.
                _request_timeout (float/tuple): timeout setting for this request. If one
                    number provided, it will be total request timeout. It can also
                    be a pair (tuple) of (connection, read) timeouts.
                    Default is None.
                _check_input_type (bool): specifies if type checking
                    should be done one the data sent to the server.
                    Default is True.
                _check_return_type (bool): specifies if type checking
                    should be done one the data received from the server.
                    Default is True.
                _host_index (int/None): specifies the index of the server
                    that we want to use.
                    Default is read from the configuration.
                async_req (bool): execute request asynchronously

            Returns:
                SandboxItemSetVerificationStatusResponse
                    If the method is called asynchronously, returns the request
                    thread.
            """
            kwargs['async_req'] = kwargs.get(
                'async_req', False
            )
            kwargs['_return_http_data_only'] = kwargs.get(
                '_return_http_data_only', True
            )
            kwargs['_preload_content'] = kwargs.get(
                '_preload_content', True
            )
            kwargs['_request_timeout'] = kwargs.get(
                '_request_timeout', None
            )
            kwargs['_check_input_type'] = kwargs.get(
                '_check_input_type', True
            )
            kwargs['_check_return_type'] = kwargs.get(
                '_check_return_type', True
            )
            kwargs['_host_index'] = kwargs.get('_host_index')
            kwargs['sandbox_item_set_verification_status_request'] = \
                sandbox_item_set_verification_status_request
            return self.call_with_http_info(**kwargs)

        self.sandbox_item_set_verification_status = _Endpoint(
            settings={
                'response_type': (SandboxItemSetVerificationStatusResponse,),
                'auth': [
                    'clientId',
                    'plaidVersion',
                    'secret'
                ],
                'endpoint_path': '/sandbox/item/set_verification_status',
                'operation_id': 'sandbox_item_set_verification_status',
                'http_method': 'POST',
                'servers': None,
            },
            params_map={
                'all': [
                    'sandbox_item_set_verification_status_request',
                ],
                'required': [
                    'sandbox_item_set_verification_status_request',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'sandbox_item_set_verification_status_request':
                        (SandboxItemSetVerificationStatusRequest,),
                },
                'attribute_map': {
                },
                'location_map': {
                    'sandbox_item_set_verification_status_request': 'body',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [
                    'application/json'
                ]
            },
            api_client=api_client,
            callable=__sandbox_item_set_verification_status
        )

        def __sandbox_oauth_select_accounts(
            self,
            sandbox_oauth_select_accounts_request,
            **kwargs
        ):
            """Save the selected accounts when connecting to the Platypus Oauth institution  # noqa: E501

            Save the selected accounts when connecting to the Platypus Oauth institution  # noqa: E501
            This method makes a synchronous HTTP request by default. To make an
            asynchronous HTTP request, please pass async_req=True

            >>> thread = api.sandbox_oauth_select_accounts(sandbox_oauth_select_accounts_request, async_req=True)
            >>> result = thread.get()

            Args:
                sandbox_oauth_select_accounts_request (SandboxOauthSelectAccountsRequest):

            Keyword Args:
                _return_http_data_only (bool): response data without head status
                    code and headers. Default is True.
                _preload_content (bool): if False, the urllib3.HTTPResponse object
                    will be returned without reading/decoding response data.
                    Default is True.
                _request_timeout (float/tuple): timeout setting for this request. If one
                    number provided, it will be total request timeout. It can also
                    be a pair (tuple) of (connection, read) timeouts.
                    Default is None.
                _check_input_type (bool): specifies if type checking
                    should be done one the data sent to the server.
                    Default is True.
                _check_return_type (bool): specifies if type checking
                    should be done one the data received from the server.
                    Default is True.
                _host_index (int/None): specifies the index of the server
                    that we want to use.
                    Default is read from the configuration.
                async_req (bool): execute request asynchronously

            Returns:
                SandboxOauthSelectAccountsResponse
                    If the method is called asynchronously, returns the request
                    thread.
            """
            kwargs['async_req'] = kwargs.get(
                'async_req', False
            )
            kwargs['_return_http_data_only'] = kwargs.get(
                '_return_http_data_only', True
            )
            kwargs['_preload_content'] = kwargs.get(
                '_preload_content', True
            )
            kwargs['_request_timeout'] = kwargs.get(
                '_request_timeout', None
            )
            kwargs['_check_input_type'] = kwargs.get(
                '_check_input_type', True
            )
            kwargs['_check_return_type'] = kwargs.get(
                '_check_return_type', True
            )
            kwargs['_host_index'] = kwargs.get('_host_index')
            kwargs['sandbox_oauth_select_accounts_request'] = \
                sandbox_oauth_select_accounts_request
            return self.call_with_http_info(**kwargs)

        self.sandbox_oauth_select_accounts = _Endpoint(
            settings={
                'response_type': (SandboxOauthSelectAccountsResponse,),
                'auth': [
                    'clientId',
                    'plaidVersion',
                    'secret'
                ],
                'endpoint_path': '/sandbox/oauth/select_accounts',
                'operation_id': 'sandbox_oauth_select_accounts',
                'http_method': 'POST',
                'servers': None,
            },
            params_map={
                'all': [
                    'sandbox_oauth_select_accounts_request',
                ],
                'required': [
                    'sandbox_oauth_select_accounts_request',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'sandbox_oauth_select_accounts_request':
                        (SandboxOauthSelectAccountsRequest,),
                },
                'attribute_map': {
                },
                'location_map': {
                    'sandbox_oauth_select_accounts_request': 'body',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [
                    'application/json'
                ]
            },
            api_client=api_client,
            callable=__sandbox_oauth_select_accounts
        )

        def __sandbox_processor_token_create(
            self,
            sandbox_processor_token_create_request,
            **kwargs
        ):
            """Create a test Item and processor token  # noqa: E501

            Use the `/sandbox/processor_token/create` endpoint to create a valid `processor_token` for an arbitrary institution ID and test credentials. The created `processor_token` corresponds to a new Sandbox Item. You can then use this `processor_token` with the `/processor/` API endpoints in Sandbox. You can also use `/sandbox/processor_token/create` with the [`user_custom` test username](https://plaid.com/docs/sandbox/user-custom) to generate a test account with custom data.  # noqa: E501
            This method makes a synchronous HTTP request by default. To make an
            asynchronous HTTP request, please pass async_req=True

            >>> thread = api.sandbox_processor_token_create(sandbox_processor_token_create_request, async_req=True)
            >>> result = thread.get()

            Args:
                sandbox_processor_token_create_request (SandboxProcessorTokenCreateRequest):

            Keyword Args:
                _return_http_data_only (bool): response data without head status
                    code and headers. Default is True.
                _preload_content (bool): if False, the urllib3.HTTPResponse object
                    will be returned without reading/decoding response data.
                    Default is True.
                _request_timeout (float/tuple): timeout setting for this request. If one
                    number provided, it will be total request timeout. It can also
                    be a pair (tuple) of (connection, read) timeouts.
                    Default is None.
                _check_input_type (bool): specifies if type checking
                    should be done one the data sent to the server.
                    Default is True.
                _check_return_type (bool): specifies if type checking
                    should be done one the data received from the server.
                    Default is True.
                _host_index (int/None): specifies the index of the server
                    that we want to use.
                    Default is read from the configuration.
                async_req (bool): execute request asynchronously

            Returns:
                SandboxProcessorTokenCreateResponse
                    If the method is called asynchronously, returns the request
                    thread.
            """
            kwargs['async_req'] = kwargs.get(
                'async_req', False
            )
            kwargs['_return_http_data_only'] = kwargs.get(
                '_return_http_data_only', True
            )
            kwargs['_preload_content'] = kwargs.get(
                '_preload_content', True
            )
            kwargs['_request_timeout'] = kwargs.get(
                '_request_timeout', None
            )
            kwargs['_check_input_type'] = kwargs.get(
                '_check_input_type', True
            )
            kwargs['_check_return_type'] = kwargs.get(
                '_check_return_type', True
            )
            kwargs['_host_index'] = kwargs.get('_host_index')
            kwargs['sandbox_processor_token_create_request'] = \
                sandbox_processor_token_create_request
            return self.call_with_http_info(**kwargs)

        self.sandbox_processor_token_create = _Endpoint(
            settings={
                'response_type': (SandboxProcessorTokenCreateResponse,),
                'auth': [
                    'clientId',
                    'plaidVersion',
                    'secret'
                ],
                'endpoint_path': '/sandbox/processor_token/create',
                'operation_id': 'sandbox_processor_token_create',
                'http_method': 'POST',
                'servers': None,
            },
            params_map={
                'all': [
                    'sandbox_processor_token_create_request',
                ],
                'required': [
                    'sandbox_processor_token_create_request',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'sandbox_processor_token_create_request':
                        (SandboxProcessorTokenCreateRequest,),
                },
                'attribute_map': {
                },
                'location_map': {
                    'sandbox_processor_token_create_request': 'body',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [
                    'application/json'
                ]
            },
            api_client=api_client,
            callable=__sandbox_processor_token_create
        )

        def __sandbox_public_token_create(
            self,
            sandbox_public_token_create_request,
            **kwargs
        ):
            """Create a test Item  # noqa: E501

            Use the `/sandbox/public_token/create` endpoint to create a valid `public_token`  for an arbitrary institution ID, initial products, and test credentials. The created `public_token` maps to a new Sandbox Item. You can then call `/item/public_token/exchange` to exchange the `public_token` for an `access_token` and perform all API actions. `/sandbox/public_token/create` can also be used with the [`user_custom` test username](https://plaid.com/docs/sandbox/user-custom) to generate a test account with custom data. `/sandbox/public_token/create` cannot be used with OAuth institutions.  # noqa: E501
            This method makes a synchronous HTTP request by default. To make an
            asynchronous HTTP request, please pass async_req=True

            >>> thread = api.sandbox_public_token_create(sandbox_public_token_create_request, async_req=True)
            >>> result = thread.get()

            Args:
                sandbox_public_token_create_request (SandboxPublicTokenCreateRequest):

            Keyword Args:
                _return_http_data_only (bool): response data without head status
                    code and headers. Default is True.
                _preload_content (bool): if False, the urllib3.HTTPResponse object
                    will be returned without reading/decoding response data.
                    Default is True.
                _request_timeout (float/tuple): timeout setting for this request. If one
                    number provided, it will be total request timeout. It can also
                    be a pair (tuple) of (connection, read) timeouts.
                    Default is None.
                _check_input_type (bool): specifies if type checking
                    should be done one the data sent to the server.
                    Default is True.
                _check_return_type (bool): specifies if type checking
                    should be done one the data received from the server.
                    Default is True.
                _host_index (int/None): specifies the index of the server
                    that we want to use.
                    Default is read from the configuration.
                async_req (bool): execute request asynchronously

            Returns:
                SandboxPublicTokenCreateResponse
                    If the method is called asynchronously, returns the request
                    thread.
            """
            kwargs['async_req'] = kwargs.get(
                'async_req', False
            )
            kwargs['_return_http_data_only'] = kwargs.get(
                '_return_http_data_only', True
            )
            kwargs['_preload_content'] = kwargs.get(
                '_preload_content', True
            )
            kwargs['_request_timeout'] = kwargs.get(
                '_request_timeout', None
            )
            kwargs['_check_input_type'] = kwargs.get(
                '_check_input_type', True
            )
            kwargs['_check_return_type'] = kwargs.get(
                '_check_return_type', True
            )
            kwargs['_host_index'] = kwargs.get('_host_index')
            kwargs['sandbox_public_token_create_request'] = \
                sandbox_public_token_create_request
            return self.call_with_http_info(**kwargs)

        self.sandbox_public_token_create = _Endpoint(
            settings={
                'response_type': (SandboxPublicTokenCreateResponse,),
                'auth': [
                    'clientId',
                    'plaidVersion',
                    'secret'
                ],
                'endpoint_path': '/sandbox/public_token/create',
                'operation_id': 'sandbox_public_token_create',
                'http_method': 'POST',
                'servers': None,
            },
            params_map={
                'all': [
                    'sandbox_public_token_create_request',
                ],
                'required': [
                    'sandbox_public_token_create_request',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'sandbox_public_token_create_request':
                        (SandboxPublicTokenCreateRequest,),
                },
                'attribute_map': {
                },
                'location_map': {
                    'sandbox_public_token_create_request': 'body',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [
                    'application/json'
                ]
            },
            api_client=api_client,
            callable=__sandbox_public_token_create
        )

        def __sandbox_transfer_fire_webhook(
            self,
            sandbox_transfer_fire_webhook_request,
            **kwargs
        ):
            """Manually fire a Transfer webhook  # noqa: E501

            Use the `/sandbox/transfer/fire_webhook` endpoint to manually trigger a Transfer webhook in the Sandbox environment.  # noqa: E501
            This method makes a synchronous HTTP request by default. To make an
            asynchronous HTTP request, please pass async_req=True

            >>> thread = api.sandbox_transfer_fire_webhook(sandbox_transfer_fire_webhook_request, async_req=True)
            >>> result = thread.get()

            Args:
                sandbox_transfer_fire_webhook_request (SandboxTransferFireWebhookRequest):

            Keyword Args:
                _return_http_data_only (bool): response data without head status
                    code and headers. Default is True.
                _preload_content (bool): if False, the urllib3.HTTPResponse object
                    will be returned without reading/decoding response data.
                    Default is True.
                _request_timeout (float/tuple): timeout setting for this request. If one
                    number provided, it will be total request timeout. It can also
                    be a pair (tuple) of (connection, read) timeouts.
                    Default is None.
                _check_input_type (bool): specifies if type checking
                    should be done one the data sent to the server.
                    Default is True.
                _check_return_type (bool): specifies if type checking
                    should be done one the data received from the server.
                    Default is True.
                _host_index (int/None): specifies the index of the server
                    that we want to use.
                    Default is read from the configuration.
                async_req (bool): execute request asynchronously

            Returns:
                SandboxTransferFireWebhookResponse
                    If the method is called asynchronously, returns the request
                    thread.
            """
            kwargs['async_req'] = kwargs.get(
                'async_req', False
            )
            kwargs['_return_http_data_only'] = kwargs.get(
                '_return_http_data_only', True
            )
            kwargs['_preload_content'] = kwargs.get(
                '_preload_content', True
            )
            kwargs['_request_timeout'] = kwargs.get(
                '_request_timeout', None
            )
            kwargs['_check_input_type'] = kwargs.get(
                '_check_input_type', True
            )
            kwargs['_check_return_type'] = kwargs.get(
                '_check_return_type', True
            )
            kwargs['_host_index'] = kwargs.get('_host_index')
            kwargs['sandbox_transfer_fire_webhook_request'] = \
                sandbox_transfer_fire_webhook_request
            return self.call_with_http_info(**kwargs)

        self.sandbox_transfer_fire_webhook = _Endpoint(
            settings={
                'response_type': (SandboxTransferFireWebhookResponse,),
                'auth': [
                    'clientId',
                    'plaidVersion',
                    'secret'
                ],
                'endpoint_path': '/sandbox/transfer/fire_webhook',
                'operation_id': 'sandbox_transfer_fire_webhook',
                'http_method': 'POST',
                'servers': None,
            },
            params_map={
                'all': [
                    'sandbox_transfer_fire_webhook_request',
                ],
                'required': [
                    'sandbox_transfer_fire_webhook_request',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'sandbox_transfer_fire_webhook_request':
                        (SandboxTransferFireWebhookRequest,),
                },
                'attribute_map': {
                },
                'location_map': {
                    'sandbox_transfer_fire_webhook_request': 'body',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [
                    'application/json'
                ]
            },
            api_client=api_client,
            callable=__sandbox_transfer_fire_webhook
        )

        def __sandbox_transfer_repayment_simulate(
            self,
            sandbox_transfer_repayment_simulate_request,
            **kwargs
        ):
            """Trigger the creation of a repayment  # noqa: E501

            Use the `/sandbox/transfer/repayment/simulate` endpoint to trigger the creation of a repayment. As a side effect of calling this route, a repayment is created that includes all unreimbursed returns of guaranteed transfers. If there are no such returns, an 400 error is returned.  # noqa: E501
            This method makes a synchronous HTTP request by default. To make an
            asynchronous HTTP request, please pass async_req=True

            >>> thread = api.sandbox_transfer_repayment_simulate(sandbox_transfer_repayment_simulate_request, async_req=True)
            >>> result = thread.get()

            Args:
                sandbox_transfer_repayment_simulate_request (SandboxTransferRepaymentSimulateRequest):

            Keyword Args:
                _return_http_data_only (bool): response data without head status
                    code and headers. Default is True.
                _preload_content (bool): if False, the urllib3.HTTPResponse object
                    will be returned without reading/decoding response data.
                    Default is True.
                _request_timeout (float/tuple): timeout setting for this request. If one
                    number provided, it will be total request timeout. It can also
                    be a pair (tuple) of (connection, read) timeouts.
                    Default is None.
                _check_input_type (bool): specifies if type checking
                    should be done one the data sent to the server.
                    Default is True.
                _check_return_type (bool): specifies if type checking
                    should be done one the data received from the server.
                    Default is True.
                _host_index (int/None): specifies the index of the server
                    that we want to use.
                    Default is read from the configuration.
                async_req (bool): execute request asynchronously

            Returns:
                SandboxTransferRepaymentSimulateResponse
                    If the method is called asynchronously, returns the request
                    thread.
            """
            kwargs['async_req'] = kwargs.get(
                'async_req', False
            )
            kwargs['_return_http_data_only'] = kwargs.get(
                '_return_http_data_only', True
            )
            kwargs['_preload_content'] = kwargs.get(
                '_preload_content', True
            )
            kwargs['_request_timeout'] = kwargs.get(
                '_request_timeout', None
            )
            kwargs['_check_input_type'] = kwargs.get(
                '_check_input_type', True
            )
            kwargs['_check_return_type'] = kwargs.get(
                '_check_return_type', True
            )
            kwargs['_host_index'] = kwargs.get('_host_index')
            kwargs['sandbox_transfer_repayment_simulate_request'] = \
                sandbox_transfer_repayment_simulate_request
            return self.call_with_http_info(**kwargs)

        self.sandbox_transfer_repayment_simulate = _Endpoint(
            settings={
                'response_type': (SandboxTransferRepaymentSimulateResponse,),
                'auth': [
                    'clientId',
                    'plaidVersion',
                    'secret'
                ],
                'endpoint_path': '/sandbox/transfer/repayment/simulate',
                'operation_id': 'sandbox_transfer_repayment_simulate',
                'http_method': 'POST',
                'servers': None,
            },
            params_map={
                'all': [
                    'sandbox_transfer_repayment_simulate_request',
                ],
                'required': [
                    'sandbox_transfer_repayment_simulate_request',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'sandbox_transfer_repayment_simulate_request':
                        (SandboxTransferRepaymentSimulateRequest,),
                },
                'attribute_map': {
                },
                'location_map': {
                    'sandbox_transfer_repayment_simulate_request': 'body',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [
                    'application/json'
                ]
            },
            api_client=api_client,
            callable=__sandbox_transfer_repayment_simulate
        )

        def __sandbox_transfer_simulate(
            self,
            sandbox_transfer_simulate_request,
            **kwargs
        ):
            """Simulate a transfer event in Sandbox  # noqa: E501

            Use the `/sandbox/transfer/simulate` endpoint to simulate a transfer event in the Sandbox environment.  Note that while an event will be simulated and will appear when using endpoints such as `/transfer/event/sync` or `/transfer/event/list`, no transactions will actually take place and funds will not move between accounts, even within the Sandbox.  # noqa: E501
            This method makes a synchronous HTTP request by default. To make an
            asynchronous HTTP request, please pass async_req=True

            >>> thread = api.sandbox_transfer_simulate(sandbox_transfer_simulate_request, async_req=True)
            >>> result = thread.get()

            Args:
                sandbox_transfer_simulate_request (SandboxTransferSimulateRequest):

            Keyword Args:
                _return_http_data_only (bool): response data without head status
                    code and headers. Default is True.
                _preload_content (bool): if False, the urllib3.HTTPResponse object
                    will be returned without reading/decoding response data.
                    Default is True.
                _request_timeout (float/tuple): timeout setting for this request. If one
                    number provided, it will be total request timeout. It can also
                    be a pair (tuple) of (connection, read) timeouts.
                    Default is None.
                _check_input_type (bool): specifies if type checking
                    should be done one the data sent to the server.
                    Default is True.
                _check_return_type (bool): specifies if type checking
                    should be done one the data received from the server.
                    Default is True.
                _host_index (int/None): specifies the index of the server
                    that we want to use.
                    Default is read from the configuration.
                async_req (bool): execute request asynchronously

            Returns:
                SandboxTransferSimulateResponse
                    If the method is called asynchronously, returns the request
                    thread.
            """
            kwargs['async_req'] = kwargs.get(
                'async_req', False
            )
            kwargs['_return_http_data_only'] = kwargs.get(
                '_return_http_data_only', True
            )
            kwargs['_preload_content'] = kwargs.get(
                '_preload_content', True
            )
            kwargs['_request_timeout'] = kwargs.get(
                '_request_timeout', None
            )
            kwargs['_check_input_type'] = kwargs.get(
                '_check_input_type', True
            )
            kwargs['_check_return_type'] = kwargs.get(
                '_check_return_type', True
            )
            kwargs['_host_index'] = kwargs.get('_host_index')
            kwargs['sandbox_transfer_simulate_request'] = \
                sandbox_transfer_simulate_request
            return self.call_with_http_info(**kwargs)

        self.sandbox_transfer_simulate = _Endpoint(
            settings={
                'response_type': (SandboxTransferSimulateResponse,),
                'auth': [
                    'clientId',
                    'plaidVersion',
                    'secret'
                ],
                'endpoint_path': '/sandbox/transfer/simulate',
                'operation_id': 'sandbox_transfer_simulate',
                'http_method': 'POST',
                'servers': None,
            },
            params_map={
                'all': [
                    'sandbox_transfer_simulate_request',
                ],
                'required': [
                    'sandbox_transfer_simulate_request',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'sandbox_transfer_simulate_request':
                        (SandboxTransferSimulateRequest,),
                },
                'attribute_map': {
                },
                'location_map': {
                    'sandbox_transfer_simulate_request': 'body',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [
                    'application/json'
                ]
            },
            api_client=api_client,
            callable=__sandbox_transfer_simulate
        )

        def __sandbox_transfer_sweep_simulate(
            self,
            sandbox_transfer_sweep_simulate_request,
            **kwargs
        ):
            """Simulate creating a sweep  # noqa: E501

            Use the `/sandbox/transfer/sweep/simulate` endpoint to create a sweep and associated events in the Sandbox environment. Upon calling this endpoint, all `posted` or `pending` transfers with a sweep status of `unswept` will become `swept`, and all `returned` transfers with a sweep status of `swept` will become `return_swept`.  # noqa: E501
            This method makes a synchronous HTTP request by default. To make an
            asynchronous HTTP request, please pass async_req=True

            >>> thread = api.sandbox_transfer_sweep_simulate(sandbox_transfer_sweep_simulate_request, async_req=True)
            >>> result = thread.get()

            Args:
                sandbox_transfer_sweep_simulate_request (SandboxTransferSweepSimulateRequest):

            Keyword Args:
                _return_http_data_only (bool): response data without head status
                    code and headers. Default is True.
                _preload_content (bool): if False, the urllib3.HTTPResponse object
                    will be returned without reading/decoding response data.
                    Default is True.
                _request_timeout (float/tuple): timeout setting for this request. If one
                    number provided, it will be total request timeout. It can also
                    be a pair (tuple) of (connection, read) timeouts.
                    Default is None.
                _check_input_type (bool): specifies if type checking
                    should be done one the data sent to the server.
                    Default is True.
                _check_return_type (bool): specifies if type checking
                    should be done one the data received from the server.
                    Default is True.
                _host_index (int/None): specifies the index of the server
                    that we want to use.
                    Default is read from the configuration.
                async_req (bool): execute request asynchronously

            Returns:
                SandboxTransferSweepSimulateResponse
                    If the method is called asynchronously, returns the request
                    thread.
            """
            kwargs['async_req'] = kwargs.get(
                'async_req', False
            )
            kwargs['_return_http_data_only'] = kwargs.get(
                '_return_http_data_only', True
            )
            kwargs['_preload_content'] = kwargs.get(
                '_preload_content', True
            )
            kwargs['_request_timeout'] = kwargs.get(
                '_request_timeout', None
            )
            kwargs['_check_input_type'] = kwargs.get(
                '_check_input_type', True
            )
            kwargs['_check_return_type'] = kwargs.get(
                '_check_return_type', True
            )
            kwargs['_host_index'] = kwargs.get('_host_index')
            kwargs['sandbox_transfer_sweep_simulate_request'] = \
                sandbox_transfer_sweep_simulate_request
            return self.call_with_http_info(**kwargs)

        self.sandbox_transfer_sweep_simulate = _Endpoint(
            settings={
                'response_type': (SandboxTransferSweepSimulateResponse,),
                'auth': [
                    'clientId',
                    'plaidVersion',
                    'secret'
                ],
                'endpoint_path': '/sandbox/transfer/sweep/simulate',
                'operation_id': 'sandbox_transfer_sweep_simulate',
                'http_method': 'POST',
                'servers': None,
            },
            params_map={
                'all': [
                    'sandbox_transfer_sweep_simulate_request',
                ],
                'required': [
                    'sandbox_transfer_sweep_simulate_request',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'sandbox_transfer_sweep_simulate_request':
                        (SandboxTransferSweepSimulateRequest,),
                },
                'attribute_map': {
                },
                'location_map': {
                    'sandbox_transfer_sweep_simulate_request': 'body',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [
                    'application/json'
                ]
            },
            api_client=api_client,
            callable=__sandbox_transfer_sweep_simulate
        )

        def __signal_decision_report(
            self,
            signal_decision_report_request,
            **kwargs
        ):
            """Report whether you initiated an ACH transaction  # noqa: E501

            After calling `/signal/evaluate`, call `/signal/decision/report` to report whether the transaction was initiated. This endpoint will return an `INVALID_REQUEST` error if called a second time with a different value for `initiated`.  # noqa: E501
            This method makes a synchronous HTTP request by default. To make an
            asynchronous HTTP request, please pass async_req=True

            >>> thread = api.signal_decision_report(signal_decision_report_request, async_req=True)
            >>> result = thread.get()

            Args:
                signal_decision_report_request (SignalDecisionReportRequest):

            Keyword Args:
                _return_http_data_only (bool): response data without head status
                    code and headers. Default is True.
                _preload_content (bool): if False, the urllib3.HTTPResponse object
                    will be returned without reading/decoding response data.
                    Default is True.
                _request_timeout (float/tuple): timeout setting for this request. If one
                    number provided, it will be total request timeout. It can also
                    be a pair (tuple) of (connection, read) timeouts.
                    Default is None.
                _check_input_type (bool): specifies if type checking
                    should be done one the data sent to the server.
                    Default is True.
                _check_return_type (bool): specifies if type checking
                    should be done one the data received from the server.
                    Default is True.
                _host_index (int/None): specifies the index of the server
                    that we want to use.
                    Default is read from the configuration.
                async_req (bool): execute request asynchronously

            Returns:
                SignalDecisionReportResponse
                    If the method is called asynchronously, returns the request
                    thread.
            """
            kwargs['async_req'] = kwargs.get(
                'async_req', False
            )
            kwargs['_return_http_data_only'] = kwargs.get(
                '_return_http_data_only', True
            )
            kwargs['_preload_content'] = kwargs.get(
                '_preload_content', True
            )
            kwargs['_request_timeout'] = kwargs.get(
                '_request_timeout', None
            )
            kwargs['_check_input_type'] = kwargs.get(
                '_check_input_type', True
            )
            kwargs['_check_return_type'] = kwargs.get(
                '_check_return_type', True
            )
            kwargs['_host_index'] = kwargs.get('_host_index')
            kwargs['signal_decision_report_request'] = \
                signal_decision_report_request
            return self.call_with_http_info(**kwargs)

        self.signal_decision_report = _Endpoint(
            settings={
                'response_type': (SignalDecisionReportResponse,),
                'auth': [
                    'clientId',
                    'plaidVersion',
                    'secret'
                ],
                'endpoint_path': '/signal/decision/report',
                'operation_id': 'signal_decision_report',
                'http_method': 'POST',
                'servers': None,
            },
            params_map={
                'all': [
                    'signal_decision_report_request',
                ],
                'required': [
                    'signal_decision_report_request',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'signal_decision_report_request':
                        (SignalDecisionReportRequest,),
                },
                'attribute_map': {
                },
                'location_map': {
                    'signal_decision_report_request': 'body',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [
                    'application/json'
                ]
            },
            api_client=api_client,
            callable=__signal_decision_report
        )

        def __signal_evaluate(
            self,
            signal_evaluate_request,
            **kwargs
        ):
            """Evaluate a planned ACH transaction  # noqa: E501

            Use `/signal/evaluate` to evaluate a planned ACH transaction to get a return risk assessment (such as a risk score and risk tier) and additional risk signals.  In order to obtain a valid score for an ACH transaction, Plaid must have an access token for the account, and the Item must be healthy (receiving product updates) or have recently been in a healthy state. If the transaction does not meet eligibility requirements, an error will be returned corresponding to the underlying cause. If `/signal/evaluate` is called on the same transaction multiple times within a 24-hour period, cached results may be returned.  # noqa: E501
            This method makes a synchronous HTTP request by default. To make an
            asynchronous HTTP request, please pass async_req=True

            >>> thread = api.signal_evaluate(signal_evaluate_request, async_req=True)
            >>> result = thread.get()

            Args:
                signal_evaluate_request (SignalEvaluateRequest):

            Keyword Args:
                _return_http_data_only (bool): response data without head status
                    code and headers. Default is True.
                _preload_content (bool): if False, the urllib3.HTTPResponse object
                    will be returned without reading/decoding response data.
                    Default is True.
                _request_timeout (float/tuple): timeout setting for this request. If one
                    number provided, it will be total request timeout. It can also
                    be a pair (tuple) of (connection, read) timeouts.
                    Default is None.
                _check_input_type (bool): specifies if type checking
                    should be done one the data sent to the server.
                    Default is True.
                _check_return_type (bool): specifies if type checking
                    should be done one the data received from the server.
                    Default is True.
                _host_index (int/None): specifies the index of the server
                    that we want to use.
                    Default is read from the configuration.
                async_req (bool): execute request asynchronously

            Returns:
                SignalEvaluateResponse
                    If the method is called asynchronously, returns the request
                    thread.
            """
            kwargs['async_req'] = kwargs.get(
                'async_req', False
            )
            kwargs['_return_http_data_only'] = kwargs.get(
                '_return_http_data_only', True
            )
            kwargs['_preload_content'] = kwargs.get(
                '_preload_content', True
            )
            kwargs['_request_timeout'] = kwargs.get(
                '_request_timeout', None
            )
            kwargs['_check_input_type'] = kwargs.get(
                '_check_input_type', True
            )
            kwargs['_check_return_type'] = kwargs.get(
                '_check_return_type', True
            )
            kwargs['_host_index'] = kwargs.get('_host_index')
            kwargs['signal_evaluate_request'] = \
                signal_evaluate_request
            return self.call_with_http_info(**kwargs)

        self.signal_evaluate = _Endpoint(
            settings={
                'response_type': (SignalEvaluateResponse,),
                'auth': [
                    'clientId',
                    'plaidVersion',
                    'secret'
                ],
                'endpoint_path': '/signal/evaluate',
                'operation_id': 'signal_evaluate',
                'http_method': 'POST',
                'servers': None,
            },
            params_map={
                'all': [
                    'signal_evaluate_request',
                ],
                'required': [
                    'signal_evaluate_request',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'signal_evaluate_request':
                        (SignalEvaluateRequest,),
                },
                'attribute_map': {
                },
                'location_map': {
                    'signal_evaluate_request': 'body',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [
                    'application/json'
                ]
            },
            api_client=api_client,
            callable=__signal_evaluate
        )

        def __signal_prepare(
            self,
            signal_prepare_request,
            **kwargs
        ):
            """Prepare the Signal product before calling `/signal/evaluate`  # noqa: E501

            Call `/signal/prepare` with Plaid-linked bank account information at least 10 seconds before calling `/signal/evaluate` or as soon as an end-user enters the ACH deposit flow in your application.  # noqa: E501
            This method makes a synchronous HTTP request by default. To make an
            asynchronous HTTP request, please pass async_req=True

            >>> thread = api.signal_prepare(signal_prepare_request, async_req=True)
            >>> result = thread.get()

            Args:
                signal_prepare_request (SignalPrepareRequest):

            Keyword Args:
                _return_http_data_only (bool): response data without head status
                    code and headers. Default is True.
                _preload_content (bool): if False, the urllib3.HTTPResponse object
                    will be returned without reading/decoding response data.
                    Default is True.
                _request_timeout (float/tuple): timeout setting for this request. If one
                    number provided, it will be total request timeout. It can also
                    be a pair (tuple) of (connection, read) timeouts.
                    Default is None.
                _check_input_type (bool): specifies if type checking
                    should be done one the data sent to the server.
                    Default is True.
                _check_return_type (bool): specifies if type checking
                    should be done one the data received from the server.
                    Default is True.
                _host_index (int/None): specifies the index of the server
                    that we want to use.
                    Default is read from the configuration.
                async_req (bool): execute request asynchronously

            Returns:
                SignalPrepareResponse
                    If the method is called asynchronously, returns the request
                    thread.
            """
            kwargs['async_req'] = kwargs.get(
                'async_req', False
            )
            kwargs['_return_http_data_only'] = kwargs.get(
                '_return_http_data_only', True
            )
            kwargs['_preload_content'] = kwargs.get(
                '_preload_content', True
            )
            kwargs['_request_timeout'] = kwargs.get(
                '_request_timeout', None
            )
            kwargs['_check_input_type'] = kwargs.get(
                '_check_input_type', True
            )
            kwargs['_check_return_type'] = kwargs.get(
                '_check_return_type', True
            )
            kwargs['_host_index'] = kwargs.get('_host_index')
            kwargs['signal_prepare_request'] = \
                signal_prepare_request
            return self.call_with_http_info(**kwargs)

        self.signal_prepare = _Endpoint(
            settings={
                'response_type': (SignalPrepareResponse,),
                'auth': [
                    'clientId',
                    'plaidVersion',
                    'secret'
                ],
                'endpoint_path': '/signal/prepare',
                'operation_id': 'signal_prepare',
                'http_method': 'POST',
                'servers': None,
            },
            params_map={
                'all': [
                    'signal_prepare_request',
                ],
                'required': [
                    'signal_prepare_request',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'signal_prepare_request':
                        (SignalPrepareRequest,),
                },
                'attribute_map': {
                },
                'location_map': {
                    'signal_prepare_request': 'body',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [
                    'application/json'
                ]
            },
            api_client=api_client,
            callable=__signal_prepare
        )

        def __signal_return_report(
            self,
            signal_return_report_request,
            **kwargs
        ):
            """Report a return for an ACH transaction  # noqa: E501

            Call the `/signal/return/report` endpoint to report a returned transaction that was previously sent to the `/signal/evaluate` endpoint. Your feedback will be used by the model to incorporate the latest risk trend in your portfolio.  # noqa: E501
            This method makes a synchronous HTTP request by default. To make an
            asynchronous HTTP request, please pass async_req=True

            >>> thread = api.signal_return_report(signal_return_report_request, async_req=True)
            >>> result = thread.get()

            Args:
                signal_return_report_request (SignalReturnReportRequest):

            Keyword Args:
                _return_http_data_only (bool): response data without head status
                    code and headers. Default is True.
                _preload_content (bool): if False, the urllib3.HTTPResponse object
                    will be returned without reading/decoding response data.
                    Default is True.
                _request_timeout (float/tuple): timeout setting for this request. If one
                    number provided, it will be total request timeout. It can also
                    be a pair (tuple) of (connection, read) timeouts.
                    Default is None.
                _check_input_type (bool): specifies if type checking
                    should be done one the data sent to the server.
                    Default is True.
                _check_return_type (bool): specifies if type checking
                    should be done one the data received from the server.
                    Default is True.
                _host_index (int/None): specifies the index of the server
                    that we want to use.
                    Default is read from the configuration.
                async_req (bool): execute request asynchronously

            Returns:
                SignalReturnReportResponse
                    If the method is called asynchronously, returns the request
                    thread.
            """
            kwargs['async_req'] = kwargs.get(
                'async_req', False
            )
            kwargs['_return_http_data_only'] = kwargs.get(
                '_return_http_data_only', True
            )
            kwargs['_preload_content'] = kwargs.get(
                '_preload_content', True
            )
            kwargs['_request_timeout'] = kwargs.get(
                '_request_timeout', None
            )
            kwargs['_check_input_type'] = kwargs.get(
                '_check_input_type', True
            )
            kwargs['_check_return_type'] = kwargs.get(
                '_check_return_type', True
            )
            kwargs['_host_index'] = kwargs.get('_host_index')
            kwargs['signal_return_report_request'] = \
                signal_return_report_request
            return self.call_with_http_info(**kwargs)

        self.signal_return_report = _Endpoint(
            settings={
                'response_type': (SignalReturnReportResponse,),
                'auth': [
                    'clientId',
                    'plaidVersion',
                    'secret'
                ],
                'endpoint_path': '/signal/return/report',
                'operation_id': 'signal_return_report',
                'http_method': 'POST',
                'servers': None,
            },
            params_map={
                'all': [
                    'signal_return_report_request',
                ],
                'required': [
                    'signal_return_report_request',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'signal_return_report_request':
                        (SignalReturnReportRequest,),
                },
                'attribute_map': {
                },
                'location_map': {
                    'signal_return_report_request': 'body',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [
                    'application/json'
                ]
            },
            api_client=api_client,
            callable=__signal_return_report
        )

        def __transactions_enhance(
            self,
            transactions_enhance_get_request,
            **kwargs
        ):
            """enhance locally-held transaction data  # noqa: E501

            The '/beta/transactions/v1/enhance' endpoint enriches raw transaction data provided directly by clients.  The product is currently in beta.  # noqa: E501
            This method makes a synchronous HTTP request by default. To make an
            asynchronous HTTP request, please pass async_req=True

            >>> thread = api.transactions_enhance(transactions_enhance_get_request, async_req=True)
            >>> result = thread.get()

            Args:
                transactions_enhance_get_request (TransactionsEnhanceGetRequest):

            Keyword Args:
                _return_http_data_only (bool): response data without head status
                    code and headers. Default is True.
                _preload_content (bool): if False, the urllib3.HTTPResponse object
                    will be returned without reading/decoding response data.
                    Default is True.
                _request_timeout (float/tuple): timeout setting for this request. If one
                    number provided, it will be total request timeout. It can also
                    be a pair (tuple) of (connection, read) timeouts.
                    Default is None.
                _check_input_type (bool): specifies if type checking
                    should be done one the data sent to the server.
                    Default is True.
                _check_return_type (bool): specifies if type checking
                    should be done one the data received from the server.
                    Default is True.
                _host_index (int/None): specifies the index of the server
                    that we want to use.
                    Default is read from the configuration.
                async_req (bool): execute request asynchronously

            Returns:
                TransactionsEnhanceGetResponse
                    If the method is called asynchronously, returns the request
                    thread.
            """
            kwargs['async_req'] = kwargs.get(
                'async_req', False
            )
            kwargs['_return_http_data_only'] = kwargs.get(
                '_return_http_data_only', True
            )
            kwargs['_preload_content'] = kwargs.get(
                '_preload_content', True
            )
            kwargs['_request_timeout'] = kwargs.get(
                '_request_timeout', None
            )
            kwargs['_check_input_type'] = kwargs.get(
                '_check_input_type', True
            )
            kwargs['_check_return_type'] = kwargs.get(
                '_check_return_type', True
            )
            kwargs['_host_index'] = kwargs.get('_host_index')
            kwargs['transactions_enhance_get_request'] = \
                transactions_enhance_get_request
            return self.call_with_http_info(**kwargs)

        self.transactions_enhance = _Endpoint(
            settings={
                'response_type': (TransactionsEnhanceGetResponse,),
                'auth': [
                    'clientId',
                    'plaidVersion',
                    'secret'
                ],
                'endpoint_path': '/beta/transactions/v1/enhance',
                'operation_id': 'transactions_enhance',
                'http_method': 'POST',
                'servers': None,
            },
            params_map={
                'all': [
                    'transactions_enhance_get_request',
                ],
                'required': [
                    'transactions_enhance_get_request',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'transactions_enhance_get_request':
                        (TransactionsEnhanceGetRequest,),
                },
                'attribute_map': {
                },
                'location_map': {
                    'transactions_enhance_get_request': 'body',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [
                    'application/json'
                ]
            },
            api_client=api_client,
            callable=__transactions_enhance
        )

        def __transactions_get(
            self,
            transactions_get_request,
            **kwargs
        ):
            """Get transaction data  # noqa: E501

            The `/transactions/get` endpoint allows developers to receive user-authorized transaction data for credit, depository, and some loan-type accounts (only those with account subtype `student`; coverage may be limited). For transaction history from investments accounts, use the [Investments endpoint](https://plaid.com/docs/api/products/investments/) instead. Transaction data is standardized across financial institutions, and in many cases transactions are linked to a clean name, entity type, location, and category. Similarly, account data is standardized and returned with a clean name, number, balance, and other meta information where available.  Transactions are returned in reverse-chronological order, and the sequence of transaction ordering is stable and will not shift.  Transactions are not immutable and can also be removed altogether by the institution; a removed transaction will no longer appear in `/transactions/get`.  For more details, see [Pending and posted transactions](https://plaid.com/docs/transactions/transactions-data/#pending-and-posted-transactions).  Due to the potentially large number of transactions associated with an Item, results are paginated. Manipulate the `count` and `offset` parameters in conjunction with the `total_transactions` response body field to fetch all available transactions.  Data returned by `/transactions/get` will be the data available for the Item as of the most recent successful check for new transactions. Plaid typically checks for new data multiple times a day, but these checks may occur less frequently, such as once a day, depending on the institution. An Item's `status.transactions.last_successful_update` field will show the timestamp of the most recent successful update. To force Plaid to check for new transactions, you can use the `/transactions/refresh` endpoint.  Note that data may not be immediately available to `/transactions/get`. Plaid will begin to prepare transactions data upon Item link, if Link was initialized with `transactions`, or upon the first call to `/transactions/get`, if it wasn't. To be alerted when transaction data is ready to be fetched, listen for the [`INITIAL_UPDATE`](https://plaid.com/docs/api/products/transactions/#initial_update) and [`HISTORICAL_UPDATE`](https://plaid.com/docs/api/products/transactions/#historical_update) webhooks. If no transaction history is ready when `/transactions/get` is called, it will return a `PRODUCT_NOT_READY` error.  # noqa: E501
            This method makes a synchronous HTTP request by default. To make an
            asynchronous HTTP request, please pass async_req=True

            >>> thread = api.transactions_get(transactions_get_request, async_req=True)
            >>> result = thread.get()

            Args:
                transactions_get_request (TransactionsGetRequest):

            Keyword Args:
                _return_http_data_only (bool): response data without head status
                    code and headers. Default is True.
                _preload_content (bool): if False, the urllib3.HTTPResponse object
                    will be returned without reading/decoding response data.
                    Default is True.
                _request_timeout (float/tuple): timeout setting for this request. If one
                    number provided, it will be total request timeout. It can also
                    be a pair (tuple) of (connection, read) timeouts.
                    Default is None.
                _check_input_type (bool): specifies if type checking
                    should be done one the data sent to the server.
                    Default is True.
                _check_return_type (bool): specifies if type checking
                    should be done one the data received from the server.
                    Default is True.
                _host_index (int/None): specifies the index of the server
                    that we want to use.
                    Default is read from the configuration.
                async_req (bool): execute request asynchronously

            Returns:
                TransactionsGetResponse
                    If the method is called asynchronously, returns the request
                    thread.
            """
            kwargs['async_req'] = kwargs.get(
                'async_req', False
            )
            kwargs['_return_http_data_only'] = kwargs.get(
                '_return_http_data_only', True
            )
            kwargs['_preload_content'] = kwargs.get(
                '_preload_content', True
            )
            kwargs['_request_timeout'] = kwargs.get(
                '_request_timeout', None
            )
            kwargs['_check_input_type'] = kwargs.get(
                '_check_input_type', True
            )
            kwargs['_check_return_type'] = kwargs.get(
                '_check_return_type', True
            )
            kwargs['_host_index'] = kwargs.get('_host_index')
            kwargs['transactions_get_request'] = \
                transactions_get_request
            return self.call_with_http_info(**kwargs)

        self.transactions_get = _Endpoint(
            settings={
                'response_type': (TransactionsGetResponse,),
                'auth': [
                    'clientId',
                    'plaidVersion',
                    'secret'
                ],
                'endpoint_path': '/transactions/get',
                'operation_id': 'transactions_get',
                'http_method': 'POST',
                'servers': None,
            },
            params_map={
                'all': [
                    'transactions_get_request',
                ],
                'required': [
                    'transactions_get_request',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'transactions_get_request':
                        (TransactionsGetRequest,),
                },
                'attribute_map': {
                },
                'location_map': {
                    'transactions_get_request': 'body',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [
                    'application/json'
                ]
            },
            api_client=api_client,
            callable=__transactions_get
        )

        def __transactions_recurring_get(
            self,
            transactions_recurring_get_request,
            **kwargs
        ):
            """Fetch recurring transaction streams  # noqa: E501

            The `/transactions/recurring/get` endpoint allows developers to receive a summary of the recurring outflow and inflow streams (expenses and deposits) from a user’s checking, savings or credit card accounts. Additionally, Plaid provides key insights about each recurring stream including the category, merchant, last amount, and more. Developers can use these insights to build tools and experiences that help their users better manage cash flow, monitor subscriptions, reduce spend, and stay on track with bill payments.  This endpoint is not included by default as part of Transactions. To request access to this endpoint and learn more about pricing, contact your Plaid account manager.  Note that unlike `/transactions/get`, `/transactions/recurring/get` will not initialize an Item with Transactions. The Item must already have been initialized with Transactions (either during Link, by specifying it in `/link/token/create`, or after Link, by calling `/transactions/get`) before calling this endpoint. Data is available to `/transactions/recurring/get` approximately 5 seconds after the [`HISTORICAL_UPDATE`](https://plaid.com/docs/api/products/transactions/#historical_update) webhook has fired (about 1-2 minutes after initialization).  After the initial call, you can call `/transactions/recurring/get` endpoint at any point in the future to retrieve the latest summary of recurring streams. Since recurring streams do not change often, it will typically not be necessary to call this endpoint more than once per day.  # noqa: E501
            This method makes a synchronous HTTP request by default. To make an
            asynchronous HTTP request, please pass async_req=True

            >>> thread = api.transactions_recurring_get(transactions_recurring_get_request, async_req=True)
            >>> result = thread.get()

            Args:
                transactions_recurring_get_request (TransactionsRecurringGetRequest):

            Keyword Args:
                _return_http_data_only (bool): response data without head status
                    code and headers. Default is True.
                _preload_content (bool): if False, the urllib3.HTTPResponse object
                    will be returned without reading/decoding response data.
                    Default is True.
                _request_timeout (float/tuple): timeout setting for this request. If one
                    number provided, it will be total request timeout. It can also
                    be a pair (tuple) of (connection, read) timeouts.
                    Default is None.
                _check_input_type (bool): specifies if type checking
                    should be done one the data sent to the server.
                    Default is True.
                _check_return_type (bool): specifies if type checking
                    should be done one the data received from the server.
                    Default is True.
                _host_index (int/None): specifies the index of the server
                    that we want to use.
                    Default is read from the configuration.
                async_req (bool): execute request asynchronously

            Returns:
                TransactionsRecurringGetResponse
                    If the method is called asynchronously, returns the request
                    thread.
            """
            kwargs['async_req'] = kwargs.get(
                'async_req', False
            )
            kwargs['_return_http_data_only'] = kwargs.get(
                '_return_http_data_only', True
            )
            kwargs['_preload_content'] = kwargs.get(
                '_preload_content', True
            )
            kwargs['_request_timeout'] = kwargs.get(
                '_request_timeout', None
            )
            kwargs['_check_input_type'] = kwargs.get(
                '_check_input_type', True
            )
            kwargs['_check_return_type'] = kwargs.get(
                '_check_return_type', True
            )
            kwargs['_host_index'] = kwargs.get('_host_index')
            kwargs['transactions_recurring_get_request'] = \
                transactions_recurring_get_request
            return self.call_with_http_info(**kwargs)

        self.transactions_recurring_get = _Endpoint(
            settings={
                'response_type': (TransactionsRecurringGetResponse,),
                'auth': [
                    'clientId',
                    'plaidVersion',
                    'secret'
                ],
                'endpoint_path': '/transactions/recurring/get',
                'operation_id': 'transactions_recurring_get',
                'http_method': 'POST',
                'servers': None,
            },
            params_map={
                'all': [
                    'transactions_recurring_get_request',
                ],
                'required': [
                    'transactions_recurring_get_request',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'transactions_recurring_get_request':
                        (TransactionsRecurringGetRequest,),
                },
                'attribute_map': {
                },
                'location_map': {
                    'transactions_recurring_get_request': 'body',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [
                    'application/json'
                ]
            },
            api_client=api_client,
            callable=__transactions_recurring_get
        )

        def __transactions_refresh(
            self,
            transactions_refresh_request,
            **kwargs
        ):
            """Refresh transaction data  # noqa: E501

            `/transactions/refresh` is an optional endpoint for users of the Transactions product. It initiates an on-demand extraction to fetch the newest transactions for an Item. This on-demand extraction takes place in addition to the periodic extractions that automatically occur multiple times a day for any Transactions-enabled Item. If changes to transactions are discovered after calling `/transactions/refresh`, Plaid will fire a webhook: [`TRANSACTIONS_REMOVED`](https://plaid.com/docs/api/products/transactions/#transactions_removed) will be fired if any removed transactions are detected, and [`DEFAULT_UPDATE`](https://plaid.com/docs/api/products/transactions/#default_update) will be fired if any new transactions are detected. New transactions can be fetched by calling `/transactions/get`.  Access to `/transactions/refresh` in Production is specific to certain pricing plans. If you cannot access `/transactions/refresh` in Production, [contact Sales](https://www.plaid.com/contact) for assistance.  # noqa: E501
            This method makes a synchronous HTTP request by default. To make an
            asynchronous HTTP request, please pass async_req=True

            >>> thread = api.transactions_refresh(transactions_refresh_request, async_req=True)
            >>> result = thread.get()

            Args:
                transactions_refresh_request (TransactionsRefreshRequest):

            Keyword Args:
                _return_http_data_only (bool): response data without head status
                    code and headers. Default is True.
                _preload_content (bool): if False, the urllib3.HTTPResponse object
                    will be returned without reading/decoding response data.
                    Default is True.
                _request_timeout (float/tuple): timeout setting for this request. If one
                    number provided, it will be total request timeout. It can also
                    be a pair (tuple) of (connection, read) timeouts.
                    Default is None.
                _check_input_type (bool): specifies if type checking
                    should be done one the data sent to the server.
                    Default is True.
                _check_return_type (bool): specifies if type checking
                    should be done one the data received from the server.
                    Default is True.
                _host_index (int/None): specifies the index of the server
                    that we want to use.
                    Default is read from the configuration.
                async_req (bool): execute request asynchronously

            Returns:
                TransactionsRefreshResponse
                    If the method is called asynchronously, returns the request
                    thread.
            """
            kwargs['async_req'] = kwargs.get(
                'async_req', False
            )
            kwargs['_return_http_data_only'] = kwargs.get(
                '_return_http_data_only', True
            )
            kwargs['_preload_content'] = kwargs.get(
                '_preload_content', True
            )
            kwargs['_request_timeout'] = kwargs.get(
                '_request_timeout', None
            )
            kwargs['_check_input_type'] = kwargs.get(
                '_check_input_type', True
            )
            kwargs['_check_return_type'] = kwargs.get(
                '_check_return_type', True
            )
            kwargs['_host_index'] = kwargs.get('_host_index')
            kwargs['transactions_refresh_request'] = \
                transactions_refresh_request
            return self.call_with_http_info(**kwargs)

        self.transactions_refresh = _Endpoint(
            settings={
                'response_type': (TransactionsRefreshResponse,),
                'auth': [
                    'clientId',
                    'plaidVersion',
                    'secret'
                ],
                'endpoint_path': '/transactions/refresh',
                'operation_id': 'transactions_refresh',
                'http_method': 'POST',
                'servers': None,
            },
            params_map={
                'all': [
                    'transactions_refresh_request',
                ],
                'required': [
                    'transactions_refresh_request',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'transactions_refresh_request':
                        (TransactionsRefreshRequest,),
                },
                'attribute_map': {
                },
                'location_map': {
                    'transactions_refresh_request': 'body',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [
                    'application/json'
                ]
            },
            api_client=api_client,
            callable=__transactions_refresh
        )

        def __transactions_rules_create(
            self,
            transactions_rules_create_request,
            **kwargs
        ):
            """Create transaction category rule  # noqa: E501

            The `/transactions/rules/v1/create` endpoint creates transaction categorization rules.  Rules will be applied on the Item's transactions returned in `/transactions/get` response.  The product is currently in beta. To request access, contact transactions-feedback@plaid.com.  # noqa: E501
            This method makes a synchronous HTTP request by default. To make an
            asynchronous HTTP request, please pass async_req=True

            >>> thread = api.transactions_rules_create(transactions_rules_create_request, async_req=True)
            >>> result = thread.get()

            Args:
                transactions_rules_create_request (TransactionsRulesCreateRequest):

            Keyword Args:
                _return_http_data_only (bool): response data without head status
                    code and headers. Default is True.
                _preload_content (bool): if False, the urllib3.HTTPResponse object
                    will be returned without reading/decoding response data.
                    Default is True.
                _request_timeout (float/tuple): timeout setting for this request. If one
                    number provided, it will be total request timeout. It can also
                    be a pair (tuple) of (connection, read) timeouts.
                    Default is None.
                _check_input_type (bool): specifies if type checking
                    should be done one the data sent to the server.
                    Default is True.
                _check_return_type (bool): specifies if type checking
                    should be done one the data received from the server.
                    Default is True.
                _host_index (int/None): specifies the index of the server
                    that we want to use.
                    Default is read from the configuration.
                async_req (bool): execute request asynchronously

            Returns:
                TransactionsRulesCreateResponse
                    If the method is called asynchronously, returns the request
                    thread.
            """
            kwargs['async_req'] = kwargs.get(
                'async_req', False
            )
            kwargs['_return_http_data_only'] = kwargs.get(
                '_return_http_data_only', True
            )
            kwargs['_preload_content'] = kwargs.get(
                '_preload_content', True
            )
            kwargs['_request_timeout'] = kwargs.get(
                '_request_timeout', None
            )
            kwargs['_check_input_type'] = kwargs.get(
                '_check_input_type', True
            )
            kwargs['_check_return_type'] = kwargs.get(
                '_check_return_type', True
            )
            kwargs['_host_index'] = kwargs.get('_host_index')
            kwargs['transactions_rules_create_request'] = \
                transactions_rules_create_request
            return self.call_with_http_info(**kwargs)

        self.transactions_rules_create = _Endpoint(
            settings={
                'response_type': (TransactionsRulesCreateResponse,),
                'auth': [
                    'clientId',
                    'plaidVersion',
                    'secret'
                ],
                'endpoint_path': '/beta/transactions/rules/v1/create',
                'operation_id': 'transactions_rules_create',
                'http_method': 'POST',
                'servers': None,
            },
            params_map={
                'all': [
                    'transactions_rules_create_request',
                ],
                'required': [
                    'transactions_rules_create_request',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'transactions_rules_create_request':
                        (TransactionsRulesCreateRequest,),
                },
                'attribute_map': {
                },
                'location_map': {
                    'transactions_rules_create_request': 'body',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [
                    'application/json'
                ]
            },
            api_client=api_client,
            callable=__transactions_rules_create
        )

        def __transactions_rules_list(
            self,
            transactions_rules_list_request,
            **kwargs
        ):
            """Return a list of rules created for the Item associated with the access token.  # noqa: E501

            The `/transactions/rules/v1/list` returns a list of transaction rules created for the Item associated with the access token.  # noqa: E501
            This method makes a synchronous HTTP request by default. To make an
            asynchronous HTTP request, please pass async_req=True

            >>> thread = api.transactions_rules_list(transactions_rules_list_request, async_req=True)
            >>> result = thread.get()

            Args:
                transactions_rules_list_request (TransactionsRulesListRequest):

            Keyword Args:
                _return_http_data_only (bool): response data without head status
                    code and headers. Default is True.
                _preload_content (bool): if False, the urllib3.HTTPResponse object
                    will be returned without reading/decoding response data.
                    Default is True.
                _request_timeout (float/tuple): timeout setting for this request. If one
                    number provided, it will be total request timeout. It can also
                    be a pair (tuple) of (connection, read) timeouts.
                    Default is None.
                _check_input_type (bool): specifies if type checking
                    should be done one the data sent to the server.
                    Default is True.
                _check_return_type (bool): specifies if type checking
                    should be done one the data received from the server.
                    Default is True.
                _host_index (int/None): specifies the index of the server
                    that we want to use.
                    Default is read from the configuration.
                async_req (bool): execute request asynchronously

            Returns:
                TransactionsRulesListResponse
                    If the method is called asynchronously, returns the request
                    thread.
            """
            kwargs['async_req'] = kwargs.get(
                'async_req', False
            )
            kwargs['_return_http_data_only'] = kwargs.get(
                '_return_http_data_only', True
            )
            kwargs['_preload_content'] = kwargs.get(
                '_preload_content', True
            )
            kwargs['_request_timeout'] = kwargs.get(
                '_request_timeout', None
            )
            kwargs['_check_input_type'] = kwargs.get(
                '_check_input_type', True
            )
            kwargs['_check_return_type'] = kwargs.get(
                '_check_return_type', True
            )
            kwargs['_host_index'] = kwargs.get('_host_index')
            kwargs['transactions_rules_list_request'] = \
                transactions_rules_list_request
            return self.call_with_http_info(**kwargs)

        self.transactions_rules_list = _Endpoint(
            settings={
                'response_type': (TransactionsRulesListResponse,),
                'auth': [
                    'clientId',
                    'plaidVersion',
                    'secret'
                ],
                'endpoint_path': '/beta/transactions/rules/v1/list',
                'operation_id': 'transactions_rules_list',
                'http_method': 'POST',
                'servers': None,
            },
            params_map={
                'all': [
                    'transactions_rules_list_request',
                ],
                'required': [
                    'transactions_rules_list_request',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'transactions_rules_list_request':
                        (TransactionsRulesListRequest,),
                },
                'attribute_map': {
                },
                'location_map': {
                    'transactions_rules_list_request': 'body',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [
                    'application/json'
                ]
            },
            api_client=api_client,
            callable=__transactions_rules_list
        )

        def __transactions_rules_remove(
            self,
            transactions_rules_remove_request,
            **kwargs
        ):
            """Remove transaction rule  # noqa: E501

            The `/transactions/rules/v1/remove` endpoint is used to remove a transaction rule.  # noqa: E501
            This method makes a synchronous HTTP request by default. To make an
            asynchronous HTTP request, please pass async_req=True

            >>> thread = api.transactions_rules_remove(transactions_rules_remove_request, async_req=True)
            >>> result = thread.get()

            Args:
                transactions_rules_remove_request (TransactionsRulesRemoveRequest):

            Keyword Args:
                _return_http_data_only (bool): response data without head status
                    code and headers. Default is True.
                _preload_content (bool): if False, the urllib3.HTTPResponse object
                    will be returned without reading/decoding response data.
                    Default is True.
                _request_timeout (float/tuple): timeout setting for this request. If one
                    number provided, it will be total request timeout. It can also
                    be a pair (tuple) of (connection, read) timeouts.
                    Default is None.
                _check_input_type (bool): specifies if type checking
                    should be done one the data sent to the server.
                    Default is True.
                _check_return_type (bool): specifies if type checking
                    should be done one the data received from the server.
                    Default is True.
                _host_index (int/None): specifies the index of the server
                    that we want to use.
                    Default is read from the configuration.
                async_req (bool): execute request asynchronously

            Returns:
                TransactionsRulesRemoveResponse
                    If the method is called asynchronously, returns the request
                    thread.
            """
            kwargs['async_req'] = kwargs.get(
                'async_req', False
            )
            kwargs['_return_http_data_only'] = kwargs.get(
                '_return_http_data_only', True
            )
            kwargs['_preload_content'] = kwargs.get(
                '_preload_content', True
            )
            kwargs['_request_timeout'] = kwargs.get(
                '_request_timeout', None
            )
            kwargs['_check_input_type'] = kwargs.get(
                '_check_input_type', True
            )
            kwargs['_check_return_type'] = kwargs.get(
                '_check_return_type', True
            )
            kwargs['_host_index'] = kwargs.get('_host_index')
            kwargs['transactions_rules_remove_request'] = \
                transactions_rules_remove_request
            return self.call_with_http_info(**kwargs)

        self.transactions_rules_remove = _Endpoint(
            settings={
                'response_type': (TransactionsRulesRemoveResponse,),
                'auth': [
                    'clientId',
                    'plaidVersion',
                    'secret'
                ],
                'endpoint_path': '/beta/transactions/rules/v1/remove',
                'operation_id': 'transactions_rules_remove',
                'http_method': 'POST',
                'servers': None,
            },
            params_map={
                'all': [
                    'transactions_rules_remove_request',
                ],
                'required': [
                    'transactions_rules_remove_request',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'transactions_rules_remove_request':
                        (TransactionsRulesRemoveRequest,),
                },
                'attribute_map': {
                },
                'location_map': {
                    'transactions_rules_remove_request': 'body',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [
                    'application/json'
                ]
            },
            api_client=api_client,
            callable=__transactions_rules_remove
        )

        def __transactions_sync(
            self,
            transactions_sync_request,
            **kwargs
        ):
            """Get incremental transaction updates on an Item  # noqa: E501

            This endpoint replaces `/transactions/get` and its associated webhooks for most common use-cases.  The `/transactions/sync` endpoint allows developers to subscribe to all transactions associated with an Item and get updates synchronously in a stream-like manner, using a cursor to track which updates have already been seen. `/transactions/sync` provides the same functionality as `/transactions/get` and can be used instead of `/transactions/get` to simplify the process of tracking transactions updates.  This endpoint provides user-authorized transaction data for `credit`, `depository`, and some loan-type accounts (only those with account subtype `student`; coverage may be limited). For transaction history from `investments` accounts, use `/investments/transactions/get` instead.  Returned transactions data is grouped into three types of update, indicating whether the transaction was added, removed, or modified since the last call to the API.  In the first call to `/transactions/sync` for an Item, the endpoint will return all historical transactions data associated with that Item up until the time of the API call (as \"adds\"), which then generates a `latest_cursor` for that Item. In subsequent calls, send the `latest_cursor` to receive only the changes that have occurred since the previous call.  Due to the potentially large number of transactions associated with an Item, results are paginated. The `has_more` field specifies if additional calls are necessary to fetch all available transaction updates.  Whenever new or updated transaction data becomes available, `/transactions/sync` will provide these updates. Plaid typically checks for new data multiple times a day, but these checks may occur less frequently, such as once a day, depending on the institution. An Item's `status.transactions.last_successful_update` field will show the timestamp of the most recent successful update. To force Plaid to check for new transactions, use the `/transactions/refresh` endpoint.  Note that for newly created Items, data may not be immediately available to `/transactions/sync`. Plaid begins preparing transactions data when the Item is created, but the process can take anywhere from a few seconds to several minutes to complete, depending on the number of transactions available.  To be alerted when new data is available, listen for the [`SYNC_UPDATES_AVAILABLE`](https://plaid.com/docs/api/products/transactions/#sync_updates_available) webhook.  # noqa: E501
            This method makes a synchronous HTTP request by default. To make an
            asynchronous HTTP request, please pass async_req=True

            >>> thread = api.transactions_sync(transactions_sync_request, async_req=True)
            >>> result = thread.get()

            Args:
                transactions_sync_request (TransactionsSyncRequest):

            Keyword Args:
                _return_http_data_only (bool): response data without head status
                    code and headers. Default is True.
                _preload_content (bool): if False, the urllib3.HTTPResponse object
                    will be returned without reading/decoding response data.
                    Default is True.
                _request_timeout (float/tuple): timeout setting for this request. If one
                    number provided, it will be total request timeout. It can also
                    be a pair (tuple) of (connection, read) timeouts.
                    Default is None.
                _check_input_type (bool): specifies if type checking
                    should be done one the data sent to the server.
                    Default is True.
                _check_return_type (bool): specifies if type checking
                    should be done one the data received from the server.
                    Default is True.
                _host_index (int/None): specifies the index of the server
                    that we want to use.
                    Default is read from the configuration.
                async_req (bool): execute request asynchronously

            Returns:
                TransactionsSyncResponse
                    If the method is called asynchronously, returns the request
                    thread.
            """
            kwargs['async_req'] = kwargs.get(
                'async_req', False
            )
            kwargs['_return_http_data_only'] = kwargs.get(
                '_return_http_data_only', True
            )
            kwargs['_preload_content'] = kwargs.get(
                '_preload_content', True
            )
            kwargs['_request_timeout'] = kwargs.get(
                '_request_timeout', None
            )
            kwargs['_check_input_type'] = kwargs.get(
                '_check_input_type', True
            )
            kwargs['_check_return_type'] = kwargs.get(
                '_check_return_type', True
            )
            kwargs['_host_index'] = kwargs.get('_host_index')
            kwargs['transactions_sync_request'] = \
                transactions_sync_request
            return self.call_with_http_info(**kwargs)

        self.transactions_sync = _Endpoint(
            settings={
                'response_type': (TransactionsSyncResponse,),
                'auth': [
                    'clientId',
                    'plaidVersion',
                    'secret'
                ],
                'endpoint_path': '/transactions/sync',
                'operation_id': 'transactions_sync',
                'http_method': 'POST',
                'servers': None,
            },
            params_map={
                'all': [
                    'transactions_sync_request',
                ],
                'required': [
                    'transactions_sync_request',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'transactions_sync_request':
                        (TransactionsSyncRequest,),
                },
                'attribute_map': {
                },
                'location_map': {
                    'transactions_sync_request': 'body',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [
                    'application/json'
                ]
            },
            api_client=api_client,
            callable=__transactions_sync
        )

        def __transfer_authorization_create(
            self,
            transfer_authorization_create_request,
            **kwargs
        ):
            """Create a transfer authorization  # noqa: E501

            Use the `/transfer/authorization/create` endpoint to determine transfer failure risk.  In Plaid's sandbox environment the decisions will be returned as follows:    - To approve a transfer with null rationale code, make an authorization request with an `amount` less than the available balance in the account.    - To approve a transfer with the rationale code `MANUALLY_VERIFIED_ITEM`, create an Item in Link through the [Same Day Micro-deposits flow](https://plaid.com/docs/auth/coverage/testing/#testing-same-day-micro-deposits).    - To approve a transfer with the rationale code `LOGIN_REQUIRED`, [reset the login for an Item](https://plaid.com/docs/sandbox/#item_login_required).    - To decline a transfer with the rationale code `NSF`, the available balance on the account must be less than the authorization `amount`. See [Create Sandbox test data](https://plaid.com/docs/sandbox/user-custom/) for details on how to customize data in Sandbox.    - To decline a transfer with the rationale code `RISK`, the available balance on the account must be exactly $0. See [Create Sandbox test data](https://plaid.com/docs/sandbox/user-custom/) for details on how to customize data in Sandbox.  # noqa: E501
            This method makes a synchronous HTTP request by default. To make an
            asynchronous HTTP request, please pass async_req=True

            >>> thread = api.transfer_authorization_create(transfer_authorization_create_request, async_req=True)
            >>> result = thread.get()

            Args:
                transfer_authorization_create_request (TransferAuthorizationCreateRequest):

            Keyword Args:
                _return_http_data_only (bool): response data without head status
                    code and headers. Default is True.
                _preload_content (bool): if False, the urllib3.HTTPResponse object
                    will be returned without reading/decoding response data.
                    Default is True.
                _request_timeout (float/tuple): timeout setting for this request. If one
                    number provided, it will be total request timeout. It can also
                    be a pair (tuple) of (connection, read) timeouts.
                    Default is None.
                _check_input_type (bool): specifies if type checking
                    should be done one the data sent to the server.
                    Default is True.
                _check_return_type (bool): specifies if type checking
                    should be done one the data received from the server.
                    Default is True.
                _host_index (int/None): specifies the index of the server
                    that we want to use.
                    Default is read from the configuration.
                async_req (bool): execute request asynchronously

            Returns:
                TransferAuthorizationCreateResponse
                    If the method is called asynchronously, returns the request
                    thread.
            """
            kwargs['async_req'] = kwargs.get(
                'async_req', False
            )
            kwargs['_return_http_data_only'] = kwargs.get(
                '_return_http_data_only', True
            )
            kwargs['_preload_content'] = kwargs.get(
                '_preload_content', True
            )
            kwargs['_request_timeout'] = kwargs.get(
                '_request_timeout', None
            )
            kwargs['_check_input_type'] = kwargs.get(
                '_check_input_type', True
            )
            kwargs['_check_return_type'] = kwargs.get(
                '_check_return_type', True
            )
            kwargs['_host_index'] = kwargs.get('_host_index')
            kwargs['transfer_authorization_create_request'] = \
                transfer_authorization_create_request
            return self.call_with_http_info(**kwargs)

        self.transfer_authorization_create = _Endpoint(
            settings={
                'response_type': (TransferAuthorizationCreateResponse,),
                'auth': [
                    'clientId',
                    'plaidVersion',
                    'secret'
                ],
                'endpoint_path': '/transfer/authorization/create',
                'operation_id': 'transfer_authorization_create',
                'http_method': 'POST',
                'servers': None,
            },
            params_map={
                'all': [
                    'transfer_authorization_create_request',
                ],
                'required': [
                    'transfer_authorization_create_request',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'transfer_authorization_create_request':
                        (TransferAuthorizationCreateRequest,),
                },
                'attribute_map': {
                },
                'location_map': {
                    'transfer_authorization_create_request': 'body',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [
                    'application/json'
                ]
            },
            api_client=api_client,
            callable=__transfer_authorization_create
        )

        def __transfer_cancel(
            self,
            transfer_cancel_request,
            **kwargs
        ):
            """Cancel a transfer  # noqa: E501

            Use the `/transfer/cancel` endpoint to cancel a transfer.  A transfer is eligible for cancelation if the `cancellable` property returned by `/transfer/get` is `true`.  # noqa: E501
            This method makes a synchronous HTTP request by default. To make an
            asynchronous HTTP request, please pass async_req=True

            >>> thread = api.transfer_cancel(transfer_cancel_request, async_req=True)
            >>> result = thread.get()

            Args:
                transfer_cancel_request (TransferCancelRequest):

            Keyword Args:
                _return_http_data_only (bool): response data without head status
                    code and headers. Default is True.
                _preload_content (bool): if False, the urllib3.HTTPResponse object
                    will be returned without reading/decoding response data.
                    Default is True.
                _request_timeout (float/tuple): timeout setting for this request. If one
                    number provided, it will be total request timeout. It can also
                    be a pair (tuple) of (connection, read) timeouts.
                    Default is None.
                _check_input_type (bool): specifies if type checking
                    should be done one the data sent to the server.
                    Default is True.
                _check_return_type (bool): specifies if type checking
                    should be done one the data received from the server.
                    Default is True.
                _host_index (int/None): specifies the index of the server
                    that we want to use.
                    Default is read from the configuration.
                async_req (bool): execute request asynchronously

            Returns:
                TransferCancelResponse
                    If the method is called asynchronously, returns the request
                    thread.
            """
            kwargs['async_req'] = kwargs.get(
                'async_req', False
            )
            kwargs['_return_http_data_only'] = kwargs.get(
                '_return_http_data_only', True
            )
            kwargs['_preload_content'] = kwargs.get(
                '_preload_content', True
            )
            kwargs['_request_timeout'] = kwargs.get(
                '_request_timeout', None
            )
            kwargs['_check_input_type'] = kwargs.get(
                '_check_input_type', True
            )
            kwargs['_check_return_type'] = kwargs.get(
                '_check_return_type', True
            )
            kwargs['_host_index'] = kwargs.get('_host_index')
            kwargs['transfer_cancel_request'] = \
                transfer_cancel_request
            return self.call_with_http_info(**kwargs)

        self.transfer_cancel = _Endpoint(
            settings={
                'response_type': (TransferCancelResponse,),
                'auth': [
                    'clientId',
                    'plaidVersion',
                    'secret'
                ],
                'endpoint_path': '/transfer/cancel',
                'operation_id': 'transfer_cancel',
                'http_method': 'POST',
                'servers': None,
            },
            params_map={
                'all': [
                    'transfer_cancel_request',
                ],
                'required': [
                    'transfer_cancel_request',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'transfer_cancel_request':
                        (TransferCancelRequest,),
                },
                'attribute_map': {
                },
                'location_map': {
                    'transfer_cancel_request': 'body',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [
                    'application/json'
                ]
            },
            api_client=api_client,
            callable=__transfer_cancel
        )

        def __transfer_create(
            self,
            transfer_create_request,
            **kwargs
        ):
            """Create a transfer  # noqa: E501

            Use the `/transfer/create` endpoint to initiate a new transfer.  # noqa: E501
            This method makes a synchronous HTTP request by default. To make an
            asynchronous HTTP request, please pass async_req=True

            >>> thread = api.transfer_create(transfer_create_request, async_req=True)
            >>> result = thread.get()

            Args:
                transfer_create_request (TransferCreateRequest):

            Keyword Args:
                _return_http_data_only (bool): response data without head status
                    code and headers. Default is True.
                _preload_content (bool): if False, the urllib3.HTTPResponse object
                    will be returned without reading/decoding response data.
                    Default is True.
                _request_timeout (float/tuple): timeout setting for this request. If one
                    number provided, it will be total request timeout. It can also
                    be a pair (tuple) of (connection, read) timeouts.
                    Default is None.
                _check_input_type (bool): specifies if type checking
                    should be done one the data sent to the server.
                    Default is True.
                _check_return_type (bool): specifies if type checking
                    should be done one the data received from the server.
                    Default is True.
                _host_index (int/None): specifies the index of the server
                    that we want to use.
                    Default is read from the configuration.
                async_req (bool): execute request asynchronously

            Returns:
                TransferCreateResponse
                    If the method is called asynchronously, returns the request
                    thread.
            """
            kwargs['async_req'] = kwargs.get(
                'async_req', False
            )
            kwargs['_return_http_data_only'] = kwargs.get(
                '_return_http_data_only', True
            )
            kwargs['_preload_content'] = kwargs.get(
                '_preload_content', True
            )
            kwargs['_request_timeout'] = kwargs.get(
                '_request_timeout', None
            )
            kwargs['_check_input_type'] = kwargs.get(
                '_check_input_type', True
            )
            kwargs['_check_return_type'] = kwargs.get(
                '_check_return_type', True
            )
            kwargs['_host_index'] = kwargs.get('_host_index')
            kwargs['transfer_create_request'] = \
                transfer_create_request
            return self.call_with_http_info(**kwargs)

        self.transfer_create = _Endpoint(
            settings={
                'response_type': (TransferCreateResponse,),
                'auth': [
                    'clientId',
                    'plaidVersion',
                    'secret'
                ],
                'endpoint_path': '/transfer/create',
                'operation_id': 'transfer_create',
                'http_method': 'POST',
                'servers': None,
            },
            params_map={
                'all': [
                    'transfer_create_request',
                ],
                'required': [
                    'transfer_create_request',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'transfer_create_request':
                        (TransferCreateRequest,),
                },
                'attribute_map': {
                },
                'location_map': {
                    'transfer_create_request': 'body',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [
                    'application/json'
                ]
            },
            api_client=api_client,
            callable=__transfer_create
        )

        def __transfer_event_list(
            self,
            transfer_event_list_request,
            **kwargs
        ):
            """List transfer events  # noqa: E501

            Use the `/transfer/event/list` endpoint to get a list of transfer events based on specified filter criteria.  # noqa: E501
            This method makes a synchronous HTTP request by default. To make an
            asynchronous HTTP request, please pass async_req=True

            >>> thread = api.transfer_event_list(transfer_event_list_request, async_req=True)
            >>> result = thread.get()

            Args:
                transfer_event_list_request (TransferEventListRequest):

            Keyword Args:
                _return_http_data_only (bool): response data without head status
                    code and headers. Default is True.
                _preload_content (bool): if False, the urllib3.HTTPResponse object
                    will be returned without reading/decoding response data.
                    Default is True.
                _request_timeout (float/tuple): timeout setting for this request. If one
                    number provided, it will be total request timeout. It can also
                    be a pair (tuple) of (connection, read) timeouts.
                    Default is None.
                _check_input_type (bool): specifies if type checking
                    should be done one the data sent to the server.
                    Default is True.
                _check_return_type (bool): specifies if type checking
                    should be done one the data received from the server.
                    Default is True.
                _host_index (int/None): specifies the index of the server
                    that we want to use.
                    Default is read from the configuration.
                async_req (bool): execute request asynchronously

            Returns:
                TransferEventListResponse
                    If the method is called asynchronously, returns the request
                    thread.
            """
            kwargs['async_req'] = kwargs.get(
                'async_req', False
            )
            kwargs['_return_http_data_only'] = kwargs.get(
                '_return_http_data_only', True
            )
            kwargs['_preload_content'] = kwargs.get(
                '_preload_content', True
            )
            kwargs['_request_timeout'] = kwargs.get(
                '_request_timeout', None
            )
            kwargs['_check_input_type'] = kwargs.get(
                '_check_input_type', True
            )
            kwargs['_check_return_type'] = kwargs.get(
                '_check_return_type', True
            )
            kwargs['_host_index'] = kwargs.get('_host_index')
            kwargs['transfer_event_list_request'] = \
                transfer_event_list_request
            return self.call_with_http_info(**kwargs)

        self.transfer_event_list = _Endpoint(
            settings={
                'response_type': (TransferEventListResponse,),
                'auth': [
                    'clientId',
                    'plaidVersion',
                    'secret'
                ],
                'endpoint_path': '/transfer/event/list',
                'operation_id': 'transfer_event_list',
                'http_method': 'POST',
                'servers': None,
            },
            params_map={
                'all': [
                    'transfer_event_list_request',
                ],
                'required': [
                    'transfer_event_list_request',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'transfer_event_list_request':
                        (TransferEventListRequest,),
                },
                'attribute_map': {
                },
                'location_map': {
                    'transfer_event_list_request': 'body',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [
                    'application/json'
                ]
            },
            api_client=api_client,
            callable=__transfer_event_list
        )

        def __transfer_event_sync(
            self,
            transfer_event_sync_request,
            **kwargs
        ):
            """Sync transfer events  # noqa: E501

            `/transfer/event/sync` allows you to request up to the next 25 transfer events that happened after a specific `event_id`. Use the `/transfer/event/sync` endpoint to guarantee you have seen all transfer events.  # noqa: E501
            This method makes a synchronous HTTP request by default. To make an
            asynchronous HTTP request, please pass async_req=True

            >>> thread = api.transfer_event_sync(transfer_event_sync_request, async_req=True)
            >>> result = thread.get()

            Args:
                transfer_event_sync_request (TransferEventSyncRequest):

            Keyword Args:
                _return_http_data_only (bool): response data without head status
                    code and headers. Default is True.
                _preload_content (bool): if False, the urllib3.HTTPResponse object
                    will be returned without reading/decoding response data.
                    Default is True.
                _request_timeout (float/tuple): timeout setting for this request. If one
                    number provided, it will be total request timeout. It can also
                    be a pair (tuple) of (connection, read) timeouts.
                    Default is None.
                _check_input_type (bool): specifies if type checking
                    should be done one the data sent to the server.
                    Default is True.
                _check_return_type (bool): specifies if type checking
                    should be done one the data received from the server.
                    Default is True.
                _host_index (int/None): specifies the index of the server
                    that we want to use.
                    Default is read from the configuration.
                async_req (bool): execute request asynchronously

            Returns:
                TransferEventSyncResponse
                    If the method is called asynchronously, returns the request
                    thread.
            """
            kwargs['async_req'] = kwargs.get(
                'async_req', False
            )
            kwargs['_return_http_data_only'] = kwargs.get(
                '_return_http_data_only', True
            )
            kwargs['_preload_content'] = kwargs.get(
                '_preload_content', True
            )
            kwargs['_request_timeout'] = kwargs.get(
                '_request_timeout', None
            )
            kwargs['_check_input_type'] = kwargs.get(
                '_check_input_type', True
            )
            kwargs['_check_return_type'] = kwargs.get(
                '_check_return_type', True
            )
            kwargs['_host_index'] = kwargs.get('_host_index')
            kwargs['transfer_event_sync_request'] = \
                transfer_event_sync_request
            return self.call_with_http_info(**kwargs)

        self.transfer_event_sync = _Endpoint(
            settings={
                'response_type': (TransferEventSyncResponse,),
                'auth': [
                    'clientId',
                    'plaidVersion',
                    'secret'
                ],
                'endpoint_path': '/transfer/event/sync',
                'operation_id': 'transfer_event_sync',
                'http_method': 'POST',
                'servers': None,
            },
            params_map={
                'all': [
                    'transfer_event_sync_request',
                ],
                'required': [
                    'transfer_event_sync_request',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'transfer_event_sync_request':
                        (TransferEventSyncRequest,),
                },
                'attribute_map': {
                },
                'location_map': {
                    'transfer_event_sync_request': 'body',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [
                    'application/json'
                ]
            },
            api_client=api_client,
            callable=__transfer_event_sync
        )

        def __transfer_get(
            self,
            transfer_get_request,
            **kwargs
        ):
            """Retrieve a transfer  # noqa: E501

            The `/transfer/get` fetches information about the transfer corresponding to the given `transfer_id`.  # noqa: E501
            This method makes a synchronous HTTP request by default. To make an
            asynchronous HTTP request, please pass async_req=True

            >>> thread = api.transfer_get(transfer_get_request, async_req=True)
            >>> result = thread.get()

            Args:
                transfer_get_request (TransferGetRequest):

            Keyword Args:
                _return_http_data_only (bool): response data without head status
                    code and headers. Default is True.
                _preload_content (bool): if False, the urllib3.HTTPResponse object
                    will be returned without reading/decoding response data.
                    Default is True.
                _request_timeout (float/tuple): timeout setting for this request. If one
                    number provided, it will be total request timeout. It can also
                    be a pair (tuple) of (connection, read) timeouts.
                    Default is None.
                _check_input_type (bool): specifies if type checking
                    should be done one the data sent to the server.
                    Default is True.
                _check_return_type (bool): specifies if type checking
                    should be done one the data received from the server.
                    Default is True.
                _host_index (int/None): specifies the index of the server
                    that we want to use.
                    Default is read from the configuration.
                async_req (bool): execute request asynchronously

            Returns:
                TransferGetResponse
                    If the method is called asynchronously, returns the request
                    thread.
            """
            kwargs['async_req'] = kwargs.get(
                'async_req', False
            )
            kwargs['_return_http_data_only'] = kwargs.get(
                '_return_http_data_only', True
            )
            kwargs['_preload_content'] = kwargs.get(
                '_preload_content', True
            )
            kwargs['_request_timeout'] = kwargs.get(
                '_request_timeout', None
            )
            kwargs['_check_input_type'] = kwargs.get(
                '_check_input_type', True
            )
            kwargs['_check_return_type'] = kwargs.get(
                '_check_return_type', True
            )
            kwargs['_host_index'] = kwargs.get('_host_index')
            kwargs['transfer_get_request'] = \
                transfer_get_request
            return self.call_with_http_info(**kwargs)

        self.transfer_get = _Endpoint(
            settings={
                'response_type': (TransferGetResponse,),
                'auth': [
                    'clientId',
                    'plaidVersion',
                    'secret'
                ],
                'endpoint_path': '/transfer/get',
                'operation_id': 'transfer_get',
                'http_method': 'POST',
                'servers': None,
            },
            params_map={
                'all': [
                    'transfer_get_request',
                ],
                'required': [
                    'transfer_get_request',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'transfer_get_request':
                        (TransferGetRequest,),
                },
                'attribute_map': {
                },
                'location_map': {
                    'transfer_get_request': 'body',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [
                    'application/json'
                ]
            },
            api_client=api_client,
            callable=__transfer_get
        )

        def __transfer_intent_create(
            self,
            transfer_intent_create_request,
            **kwargs
        ):
            """Create a transfer intent object to invoke the Transfer UI  # noqa: E501

            Use the `/transfer/intent/create` endpoint to generate a transfer intent object and invoke the Transfer UI.  # noqa: E501
            This method makes a synchronous HTTP request by default. To make an
            asynchronous HTTP request, please pass async_req=True

            >>> thread = api.transfer_intent_create(transfer_intent_create_request, async_req=True)
            >>> result = thread.get()

            Args:
                transfer_intent_create_request (TransferIntentCreateRequest):

            Keyword Args:
                _return_http_data_only (bool): response data without head status
                    code and headers. Default is True.
                _preload_content (bool): if False, the urllib3.HTTPResponse object
                    will be returned without reading/decoding response data.
                    Default is True.
                _request_timeout (float/tuple): timeout setting for this request. If one
                    number provided, it will be total request timeout. It can also
                    be a pair (tuple) of (connection, read) timeouts.
                    Default is None.
                _check_input_type (bool): specifies if type checking
                    should be done one the data sent to the server.
                    Default is True.
                _check_return_type (bool): specifies if type checking
                    should be done one the data received from the server.
                    Default is True.
                _host_index (int/None): specifies the index of the server
                    that we want to use.
                    Default is read from the configuration.
                async_req (bool): execute request asynchronously

            Returns:
                TransferIntentCreateResponse
                    If the method is called asynchronously, returns the request
                    thread.
            """
            kwargs['async_req'] = kwargs.get(
                'async_req', False
            )
            kwargs['_return_http_data_only'] = kwargs.get(
                '_return_http_data_only', True
            )
            kwargs['_preload_content'] = kwargs.get(
                '_preload_content', True
            )
            kwargs['_request_timeout'] = kwargs.get(
                '_request_timeout', None
            )
            kwargs['_check_input_type'] = kwargs.get(
                '_check_input_type', True
            )
            kwargs['_check_return_type'] = kwargs.get(
                '_check_return_type', True
            )
            kwargs['_host_index'] = kwargs.get('_host_index')
            kwargs['transfer_intent_create_request'] = \
                transfer_intent_create_request
            return self.call_with_http_info(**kwargs)

        self.transfer_intent_create = _Endpoint(
            settings={
                'response_type': (TransferIntentCreateResponse,),
                'auth': [
                    'clientId',
                    'plaidVersion',
                    'secret'
                ],
                'endpoint_path': '/transfer/intent/create',
                'operation_id': 'transfer_intent_create',
                'http_method': 'POST',
                'servers': None,
            },
            params_map={
                'all': [
                    'transfer_intent_create_request',
                ],
                'required': [
                    'transfer_intent_create_request',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'transfer_intent_create_request':
                        (TransferIntentCreateRequest,),
                },
                'attribute_map': {
                },
                'location_map': {
                    'transfer_intent_create_request': 'body',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [
                    'application/json'
                ]
            },
            api_client=api_client,
            callable=__transfer_intent_create
        )

        def __transfer_intent_get(
            self,
            transfer_intent_get_request,
            **kwargs
        ):
            """Retrieve more information about a transfer intent  # noqa: E501

            Use the `/transfer/intent/get` endpoint to retrieve more information about a transfer intent.  # noqa: E501
            This method makes a synchronous HTTP request by default. To make an
            asynchronous HTTP request, please pass async_req=True

            >>> thread = api.transfer_intent_get(transfer_intent_get_request, async_req=True)
            >>> result = thread.get()

            Args:
                transfer_intent_get_request (TransferIntentGetRequest):

            Keyword Args:
                _return_http_data_only (bool): response data without head status
                    code and headers. Default is True.
                _preload_content (bool): if False, the urllib3.HTTPResponse object
                    will be returned without reading/decoding response data.
                    Default is True.
                _request_timeout (float/tuple): timeout setting for this request. If one
                    number provided, it will be total request timeout. It can also
                    be a pair (tuple) of (connection, read) timeouts.
                    Default is None.
                _check_input_type (bool): specifies if type checking
                    should be done one the data sent to the server.
                    Default is True.
                _check_return_type (bool): specifies if type checking
                    should be done one the data received from the server.
                    Default is True.
                _host_index (int/None): specifies the index of the server
                    that we want to use.
                    Default is read from the configuration.
                async_req (bool): execute request asynchronously

            Returns:
                TransferIntentGetResponse
                    If the method is called asynchronously, returns the request
                    thread.
            """
            kwargs['async_req'] = kwargs.get(
                'async_req', False
            )
            kwargs['_return_http_data_only'] = kwargs.get(
                '_return_http_data_only', True
            )
            kwargs['_preload_content'] = kwargs.get(
                '_preload_content', True
            )
            kwargs['_request_timeout'] = kwargs.get(
                '_request_timeout', None
            )
            kwargs['_check_input_type'] = kwargs.get(
                '_check_input_type', True
            )
            kwargs['_check_return_type'] = kwargs.get(
                '_check_return_type', True
            )
            kwargs['_host_index'] = kwargs.get('_host_index')
            kwargs['transfer_intent_get_request'] = \
                transfer_intent_get_request
            return self.call_with_http_info(**kwargs)

        self.transfer_intent_get = _Endpoint(
            settings={
                'response_type': (TransferIntentGetResponse,),
                'auth': [
                    'clientId',
                    'plaidVersion',
                    'secret'
                ],
                'endpoint_path': '/transfer/intent/get',
                'operation_id': 'transfer_intent_get',
                'http_method': 'POST',
                'servers': None,
            },
            params_map={
                'all': [
                    'transfer_intent_get_request',
                ],
                'required': [
                    'transfer_intent_get_request',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'transfer_intent_get_request':
                        (TransferIntentGetRequest,),
                },
                'attribute_map': {
                },
                'location_map': {
                    'transfer_intent_get_request': 'body',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [
                    'application/json'
                ]
            },
            api_client=api_client,
            callable=__transfer_intent_get
        )

        def __transfer_list(
            self,
            transfer_list_request,
            **kwargs
        ):
            """List transfers  # noqa: E501

            Use the `/transfer/list` endpoint to see a list of all your transfers and their statuses. Results are paginated; use the `count` and `offset` query parameters to retrieve the desired transfers.   # noqa: E501
            This method makes a synchronous HTTP request by default. To make an
            asynchronous HTTP request, please pass async_req=True

            >>> thread = api.transfer_list(transfer_list_request, async_req=True)
            >>> result = thread.get()

            Args:
                transfer_list_request (TransferListRequest):

            Keyword Args:
                _return_http_data_only (bool): response data without head status
                    code and headers. Default is True.
                _preload_content (bool): if False, the urllib3.HTTPResponse object
                    will be returned without reading/decoding response data.
                    Default is True.
                _request_timeout (float/tuple): timeout setting for this request. If one
                    number provided, it will be total request timeout. It can also
                    be a pair (tuple) of (connection, read) timeouts.
                    Default is None.
                _check_input_type (bool): specifies if type checking
                    should be done one the data sent to the server.
                    Default is True.
                _check_return_type (bool): specifies if type checking
                    should be done one the data received from the server.
                    Default is True.
                _host_index (int/None): specifies the index of the server
                    that we want to use.
                    Default is read from the configuration.
                async_req (bool): execute request asynchronously

            Returns:
                TransferListResponse
                    If the method is called asynchronously, returns the request
                    thread.
            """
            kwargs['async_req'] = kwargs.get(
                'async_req', False
            )
            kwargs['_return_http_data_only'] = kwargs.get(
                '_return_http_data_only', True
            )
            kwargs['_preload_content'] = kwargs.get(
                '_preload_content', True
            )
            kwargs['_request_timeout'] = kwargs.get(
                '_request_timeout', None
            )
            kwargs['_check_input_type'] = kwargs.get(
                '_check_input_type', True
            )
            kwargs['_check_return_type'] = kwargs.get(
                '_check_return_type', True
            )
            kwargs['_host_index'] = kwargs.get('_host_index')
            kwargs['transfer_list_request'] = \
                transfer_list_request
            return self.call_with_http_info(**kwargs)

        self.transfer_list = _Endpoint(
            settings={
                'response_type': (TransferListResponse,),
                'auth': [
                    'clientId',
                    'plaidVersion',
                    'secret'
                ],
                'endpoint_path': '/transfer/list',
                'operation_id': 'transfer_list',
                'http_method': 'POST',
                'servers': None,
            },
            params_map={
                'all': [
                    'transfer_list_request',
                ],
                'required': [
                    'transfer_list_request',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'transfer_list_request':
                        (TransferListRequest,),
                },
                'attribute_map': {
                },
                'location_map': {
                    'transfer_list_request': 'body',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [
                    'application/json'
                ]
            },
            api_client=api_client,
            callable=__transfer_list
        )

        def __transfer_migrate_account(
            self,
            transfer_migrate_account_request,
            **kwargs
        ):
            """Migrate account into Transfers  # noqa: E501

            As an alternative to adding Items via Link, you can also use the `/transfer/migrate_account` endpoint to migrate known account and routing numbers to Plaid Items.  Note that Items created in this way are not compatible with endpoints for other products, such as `/accounts/balance/get`, and can only be used with Transfer endpoints.  If you require access to other endpoints, create the Item through Link instead.  Access to `/transfer/migrate_account` is not enabled by default; to obtain access, contact your Plaid Account Manager.  # noqa: E501
            This method makes a synchronous HTTP request by default. To make an
            asynchronous HTTP request, please pass async_req=True

            >>> thread = api.transfer_migrate_account(transfer_migrate_account_request, async_req=True)
            >>> result = thread.get()

            Args:
                transfer_migrate_account_request (TransferMigrateAccountRequest):

            Keyword Args:
                _return_http_data_only (bool): response data without head status
                    code and headers. Default is True.
                _preload_content (bool): if False, the urllib3.HTTPResponse object
                    will be returned without reading/decoding response data.
                    Default is True.
                _request_timeout (float/tuple): timeout setting for this request. If one
                    number provided, it will be total request timeout. It can also
                    be a pair (tuple) of (connection, read) timeouts.
                    Default is None.
                _check_input_type (bool): specifies if type checking
                    should be done one the data sent to the server.
                    Default is True.
                _check_return_type (bool): specifies if type checking
                    should be done one the data received from the server.
                    Default is True.
                _host_index (int/None): specifies the index of the server
                    that we want to use.
                    Default is read from the configuration.
                async_req (bool): execute request asynchronously

            Returns:
                TransferMigrateAccountResponse
                    If the method is called asynchronously, returns the request
                    thread.
            """
            kwargs['async_req'] = kwargs.get(
                'async_req', False
            )
            kwargs['_return_http_data_only'] = kwargs.get(
                '_return_http_data_only', True
            )
            kwargs['_preload_content'] = kwargs.get(
                '_preload_content', True
            )
            kwargs['_request_timeout'] = kwargs.get(
                '_request_timeout', None
            )
            kwargs['_check_input_type'] = kwargs.get(
                '_check_input_type', True
            )
            kwargs['_check_return_type'] = kwargs.get(
                '_check_return_type', True
            )
            kwargs['_host_index'] = kwargs.get('_host_index')
            kwargs['transfer_migrate_account_request'] = \
                transfer_migrate_account_request
            return self.call_with_http_info(**kwargs)

        self.transfer_migrate_account = _Endpoint(
            settings={
                'response_type': (TransferMigrateAccountResponse,),
                'auth': [
                    'clientId',
                    'plaidVersion',
                    'secret'
                ],
                'endpoint_path': '/transfer/migrate_account',
                'operation_id': 'transfer_migrate_account',
                'http_method': 'POST',
                'servers': None,
            },
            params_map={
                'all': [
                    'transfer_migrate_account_request',
                ],
                'required': [
                    'transfer_migrate_account_request',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'transfer_migrate_account_request':
                        (TransferMigrateAccountRequest,),
                },
                'attribute_map': {
                },
                'location_map': {
                    'transfer_migrate_account_request': 'body',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [
                    'application/json'
                ]
            },
            api_client=api_client,
            callable=__transfer_migrate_account
        )

        def __transfer_repayment_list(
            self,
            transfer_repayment_list_request,
            **kwargs
        ):
            """Lists historical repayments  # noqa: E501

            The `/transfer/repayment/list` endpoint fetches repayments matching the given filters. Repayments are returned in reverse-chronological order (most recent first) starting at the given `start_time`.  # noqa: E501
            This method makes a synchronous HTTP request by default. To make an
            asynchronous HTTP request, please pass async_req=True

            >>> thread = api.transfer_repayment_list(transfer_repayment_list_request, async_req=True)
            >>> result = thread.get()

            Args:
                transfer_repayment_list_request (TransferRepaymentListRequest):

            Keyword Args:
                _return_http_data_only (bool): response data without head status
                    code and headers. Default is True.
                _preload_content (bool): if False, the urllib3.HTTPResponse object
                    will be returned without reading/decoding response data.
                    Default is True.
                _request_timeout (float/tuple): timeout setting for this request. If one
                    number provided, it will be total request timeout. It can also
                    be a pair (tuple) of (connection, read) timeouts.
                    Default is None.
                _check_input_type (bool): specifies if type checking
                    should be done one the data sent to the server.
                    Default is True.
                _check_return_type (bool): specifies if type checking
                    should be done one the data received from the server.
                    Default is True.
                _host_index (int/None): specifies the index of the server
                    that we want to use.
                    Default is read from the configuration.
                async_req (bool): execute request asynchronously

            Returns:
                TransferRepaymentListResponse
                    If the method is called asynchronously, returns the request
                    thread.
            """
            kwargs['async_req'] = kwargs.get(
                'async_req', False
            )
            kwargs['_return_http_data_only'] = kwargs.get(
                '_return_http_data_only', True
            )
            kwargs['_preload_content'] = kwargs.get(
                '_preload_content', True
            )
            kwargs['_request_timeout'] = kwargs.get(
                '_request_timeout', None
            )
            kwargs['_check_input_type'] = kwargs.get(
                '_check_input_type', True
            )
            kwargs['_check_return_type'] = kwargs.get(
                '_check_return_type', True
            )
            kwargs['_host_index'] = kwargs.get('_host_index')
            kwargs['transfer_repayment_list_request'] = \
                transfer_repayment_list_request
            return self.call_with_http_info(**kwargs)

        self.transfer_repayment_list = _Endpoint(
            settings={
                'response_type': (TransferRepaymentListResponse,),
                'auth': [
                    'clientId',
                    'plaidVersion',
                    'secret'
                ],
                'endpoint_path': '/transfer/repayment/list',
                'operation_id': 'transfer_repayment_list',
                'http_method': 'POST',
                'servers': None,
            },
            params_map={
                'all': [
                    'transfer_repayment_list_request',
                ],
                'required': [
                    'transfer_repayment_list_request',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'transfer_repayment_list_request':
                        (TransferRepaymentListRequest,),
                },
                'attribute_map': {
                },
                'location_map': {
                    'transfer_repayment_list_request': 'body',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [
                    'application/json'
                ]
            },
            api_client=api_client,
            callable=__transfer_repayment_list
        )

        def __transfer_repayment_return_list(
            self,
            transfer_repayment_return_list_request,
            **kwargs
        ):
            """List the returns included in a repayment  # noqa: E501

            The `/transfer/repayment/return/list` endpoint retrieves the set of returns that were batched together into the specified repayment. The sum of amounts of returns retrieved by this request equals the amount of the repayment.  # noqa: E501
            This method makes a synchronous HTTP request by default. To make an
            asynchronous HTTP request, please pass async_req=True

            >>> thread = api.transfer_repayment_return_list(transfer_repayment_return_list_request, async_req=True)
            >>> result = thread.get()

            Args:
                transfer_repayment_return_list_request (TransferRepaymentReturnListRequest):

            Keyword Args:
                _return_http_data_only (bool): response data without head status
                    code and headers. Default is True.
                _preload_content (bool): if False, the urllib3.HTTPResponse object
                    will be returned without reading/decoding response data.
                    Default is True.
                _request_timeout (float/tuple): timeout setting for this request. If one
                    number provided, it will be total request timeout. It can also
                    be a pair (tuple) of (connection, read) timeouts.
                    Default is None.
                _check_input_type (bool): specifies if type checking
                    should be done one the data sent to the server.
                    Default is True.
                _check_return_type (bool): specifies if type checking
                    should be done one the data received from the server.
                    Default is True.
                _host_index (int/None): specifies the index of the server
                    that we want to use.
                    Default is read from the configuration.
                async_req (bool): execute request asynchronously

            Returns:
                TransferRepaymentReturnListResponse
                    If the method is called asynchronously, returns the request
                    thread.
            """
            kwargs['async_req'] = kwargs.get(
                'async_req', False
            )
            kwargs['_return_http_data_only'] = kwargs.get(
                '_return_http_data_only', True
            )
            kwargs['_preload_content'] = kwargs.get(
                '_preload_content', True
            )
            kwargs['_request_timeout'] = kwargs.get(
                '_request_timeout', None
            )
            kwargs['_check_input_type'] = kwargs.get(
                '_check_input_type', True
            )
            kwargs['_check_return_type'] = kwargs.get(
                '_check_return_type', True
            )
            kwargs['_host_index'] = kwargs.get('_host_index')
            kwargs['transfer_repayment_return_list_request'] = \
                transfer_repayment_return_list_request
            return self.call_with_http_info(**kwargs)

        self.transfer_repayment_return_list = _Endpoint(
            settings={
                'response_type': (TransferRepaymentReturnListResponse,),
                'auth': [
                    'clientId',
                    'plaidVersion',
                    'secret'
                ],
                'endpoint_path': '/transfer/repayment/return/list',
                'operation_id': 'transfer_repayment_return_list',
                'http_method': 'POST',
                'servers': None,
            },
            params_map={
                'all': [
                    'transfer_repayment_return_list_request',
                ],
                'required': [
                    'transfer_repayment_return_list_request',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'transfer_repayment_return_list_request':
                        (TransferRepaymentReturnListRequest,),
                },
                'attribute_map': {
                },
                'location_map': {
                    'transfer_repayment_return_list_request': 'body',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [
                    'application/json'
                ]
            },
            api_client=api_client,
            callable=__transfer_repayment_return_list
        )

        def __transfer_sweep_get(
            self,
            transfer_sweep_get_request,
            **kwargs
        ):
            """Retrieve a sweep  # noqa: E501

            The `/transfer/sweep/get` endpoint fetches a sweep corresponding to the given `sweep_id`.  # noqa: E501
            This method makes a synchronous HTTP request by default. To make an
            asynchronous HTTP request, please pass async_req=True

            >>> thread = api.transfer_sweep_get(transfer_sweep_get_request, async_req=True)
            >>> result = thread.get()

            Args:
                transfer_sweep_get_request (TransferSweepGetRequest):

            Keyword Args:
                _return_http_data_only (bool): response data without head status
                    code and headers. Default is True.
                _preload_content (bool): if False, the urllib3.HTTPResponse object
                    will be returned without reading/decoding response data.
                    Default is True.
                _request_timeout (float/tuple): timeout setting for this request. If one
                    number provided, it will be total request timeout. It can also
                    be a pair (tuple) of (connection, read) timeouts.
                    Default is None.
                _check_input_type (bool): specifies if type checking
                    should be done one the data sent to the server.
                    Default is True.
                _check_return_type (bool): specifies if type checking
                    should be done one the data received from the server.
                    Default is True.
                _host_index (int/None): specifies the index of the server
                    that we want to use.
                    Default is read from the configuration.
                async_req (bool): execute request asynchronously

            Returns:
                TransferSweepGetResponse
                    If the method is called asynchronously, returns the request
                    thread.
            """
            kwargs['async_req'] = kwargs.get(
                'async_req', False
            )
            kwargs['_return_http_data_only'] = kwargs.get(
                '_return_http_data_only', True
            )
            kwargs['_preload_content'] = kwargs.get(
                '_preload_content', True
            )
            kwargs['_request_timeout'] = kwargs.get(
                '_request_timeout', None
            )
            kwargs['_check_input_type'] = kwargs.get(
                '_check_input_type', True
            )
            kwargs['_check_return_type'] = kwargs.get(
                '_check_return_type', True
            )
            kwargs['_host_index'] = kwargs.get('_host_index')
            kwargs['transfer_sweep_get_request'] = \
                transfer_sweep_get_request
            return self.call_with_http_info(**kwargs)

        self.transfer_sweep_get = _Endpoint(
            settings={
                'response_type': (TransferSweepGetResponse,),
                'auth': [
                    'clientId',
                    'plaidVersion',
                    'secret'
                ],
                'endpoint_path': '/transfer/sweep/get',
                'operation_id': 'transfer_sweep_get',
                'http_method': 'POST',
                'servers': None,
            },
            params_map={
                'all': [
                    'transfer_sweep_get_request',
                ],
                'required': [
                    'transfer_sweep_get_request',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'transfer_sweep_get_request':
                        (TransferSweepGetRequest,),
                },
                'attribute_map': {
                },
                'location_map': {
                    'transfer_sweep_get_request': 'body',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [
                    'application/json'
                ]
            },
            api_client=api_client,
            callable=__transfer_sweep_get
        )

        def __transfer_sweep_list(
            self,
            transfer_sweep_list_request,
            **kwargs
        ):
            """List sweeps  # noqa: E501

            The `/transfer/sweep/list` endpoint fetches sweeps matching the given filters.  # noqa: E501
            This method makes a synchronous HTTP request by default. To make an
            asynchronous HTTP request, please pass async_req=True

            >>> thread = api.transfer_sweep_list(transfer_sweep_list_request, async_req=True)
            >>> result = thread.get()

            Args:
                transfer_sweep_list_request (TransferSweepListRequest):

            Keyword Args:
                _return_http_data_only (bool): response data without head status
                    code and headers. Default is True.
                _preload_content (bool): if False, the urllib3.HTTPResponse object
                    will be returned without reading/decoding response data.
                    Default is True.
                _request_timeout (float/tuple): timeout setting for this request. If one
                    number provided, it will be total request timeout. It can also
                    be a pair (tuple) of (connection, read) timeouts.
                    Default is None.
                _check_input_type (bool): specifies if type checking
                    should be done one the data sent to the server.
                    Default is True.
                _check_return_type (bool): specifies if type checking
                    should be done one the data received from the server.
                    Default is True.
                _host_index (int/None): specifies the index of the server
                    that we want to use.
                    Default is read from the configuration.
                async_req (bool): execute request asynchronously

            Returns:
                TransferSweepListResponse
                    If the method is called asynchronously, returns the request
                    thread.
            """
            kwargs['async_req'] = kwargs.get(
                'async_req', False
            )
            kwargs['_return_http_data_only'] = kwargs.get(
                '_return_http_data_only', True
            )
            kwargs['_preload_content'] = kwargs.get(
                '_preload_content', True
            )
            kwargs['_request_timeout'] = kwargs.get(
                '_request_timeout', None
            )
            kwargs['_check_input_type'] = kwargs.get(
                '_check_input_type', True
            )
            kwargs['_check_return_type'] = kwargs.get(
                '_check_return_type', True
            )
            kwargs['_host_index'] = kwargs.get('_host_index')
            kwargs['transfer_sweep_list_request'] = \
                transfer_sweep_list_request
            return self.call_with_http_info(**kwargs)

        self.transfer_sweep_list = _Endpoint(
            settings={
                'response_type': (TransferSweepListResponse,),
                'auth': [
                    'clientId',
                    'plaidVersion',
                    'secret'
                ],
                'endpoint_path': '/transfer/sweep/list',
                'operation_id': 'transfer_sweep_list',
                'http_method': 'POST',
                'servers': None,
            },
            params_map={
                'all': [
                    'transfer_sweep_list_request',
                ],
                'required': [
                    'transfer_sweep_list_request',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'transfer_sweep_list_request':
                        (TransferSweepListRequest,),
                },
                'attribute_map': {
                },
                'location_map': {
                    'transfer_sweep_list_request': 'body',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [
                    'application/json'
                ]
            },
            api_client=api_client,
            callable=__transfer_sweep_list
        )

        def __user_create(
            self,
            user_create_request,
            **kwargs
        ):
            """Create user  # noqa: E501

            This endpoint should be called for each of your end users before they begin a Plaid income flow. This provides you a single token to access all income data associated with the user. You should only create one per end user.  If you call the endpoint multiple times with the same client_user_id, the first creation call will succeed and the rest will fail with an error message indicating that the user has been created for the given client_user_id.  # noqa: E501
            This method makes a synchronous HTTP request by default. To make an
            asynchronous HTTP request, please pass async_req=True

            >>> thread = api.user_create(user_create_request, async_req=True)
            >>> result = thread.get()

            Args:
                user_create_request (UserCreateRequest):

            Keyword Args:
                _return_http_data_only (bool): response data without head status
                    code and headers. Default is True.
                _preload_content (bool): if False, the urllib3.HTTPResponse object
                    will be returned without reading/decoding response data.
                    Default is True.
                _request_timeout (float/tuple): timeout setting for this request. If one
                    number provided, it will be total request timeout. It can also
                    be a pair (tuple) of (connection, read) timeouts.
                    Default is None.
                _check_input_type (bool): specifies if type checking
                    should be done one the data sent to the server.
                    Default is True.
                _check_return_type (bool): specifies if type checking
                    should be done one the data received from the server.
                    Default is True.
                _host_index (int/None): specifies the index of the server
                    that we want to use.
                    Default is read from the configuration.
                async_req (bool): execute request asynchronously

            Returns:
                UserCreateResponse
                    If the method is called asynchronously, returns the request
                    thread.
            """
            kwargs['async_req'] = kwargs.get(
                'async_req', False
            )
            kwargs['_return_http_data_only'] = kwargs.get(
                '_return_http_data_only', True
            )
            kwargs['_preload_content'] = kwargs.get(
                '_preload_content', True
            )
            kwargs['_request_timeout'] = kwargs.get(
                '_request_timeout', None
            )
            kwargs['_check_input_type'] = kwargs.get(
                '_check_input_type', True
            )
            kwargs['_check_return_type'] = kwargs.get(
                '_check_return_type', True
            )
            kwargs['_host_index'] = kwargs.get('_host_index')
            kwargs['user_create_request'] = \
                user_create_request
            return self.call_with_http_info(**kwargs)

        self.user_create = _Endpoint(
            settings={
                'response_type': (UserCreateResponse,),
                'auth': [
                    'clientId',
                    'plaidVersion',
                    'secret'
                ],
                'endpoint_path': '/user/create',
                'operation_id': 'user_create',
                'http_method': 'POST',
                'servers': None,
            },
            params_map={
                'all': [
                    'user_create_request',
                ],
                'required': [
                    'user_create_request',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'user_create_request':
                        (UserCreateRequest,),
                },
                'attribute_map': {
                },
                'location_map': {
                    'user_create_request': 'body',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [
                    'application/json'
                ]
            },
            api_client=api_client,
            callable=__user_create
        )

        def __wallet_create(
            self,
            wallet_create_request,
            **kwargs
        ):
            """Create an e-wallet  # noqa: E501

            Create an e-wallet. The response is the newly created e-wallet object.  # noqa: E501
            This method makes a synchronous HTTP request by default. To make an
            asynchronous HTTP request, please pass async_req=True

            >>> thread = api.wallet_create(wallet_create_request, async_req=True)
            >>> result = thread.get()

            Args:
                wallet_create_request (WalletCreateRequest):

            Keyword Args:
                _return_http_data_only (bool): response data without head status
                    code and headers. Default is True.
                _preload_content (bool): if False, the urllib3.HTTPResponse object
                    will be returned without reading/decoding response data.
                    Default is True.
                _request_timeout (float/tuple): timeout setting for this request. If one
                    number provided, it will be total request timeout. It can also
                    be a pair (tuple) of (connection, read) timeouts.
                    Default is None.
                _check_input_type (bool): specifies if type checking
                    should be done one the data sent to the server.
                    Default is True.
                _check_return_type (bool): specifies if type checking
                    should be done one the data received from the server.
                    Default is True.
                _host_index (int/None): specifies the index of the server
                    that we want to use.
                    Default is read from the configuration.
                async_req (bool): execute request asynchronously

            Returns:
                WalletCreateResponse
                    If the method is called asynchronously, returns the request
                    thread.
            """
            kwargs['async_req'] = kwargs.get(
                'async_req', False
            )
            kwargs['_return_http_data_only'] = kwargs.get(
                '_return_http_data_only', True
            )
            kwargs['_preload_content'] = kwargs.get(
                '_preload_content', True
            )
            kwargs['_request_timeout'] = kwargs.get(
                '_request_timeout', None
            )
            kwargs['_check_input_type'] = kwargs.get(
                '_check_input_type', True
            )
            kwargs['_check_return_type'] = kwargs.get(
                '_check_return_type', True
            )
            kwargs['_host_index'] = kwargs.get('_host_index')
            kwargs['wallet_create_request'] = \
                wallet_create_request
            return self.call_with_http_info(**kwargs)

        self.wallet_create = _Endpoint(
            settings={
                'response_type': (WalletCreateResponse,),
                'auth': [
                    'clientId',
                    'plaidVersion',
                    'secret'
                ],
                'endpoint_path': '/wallet/create',
                'operation_id': 'wallet_create',
                'http_method': 'POST',
                'servers': None,
            },
            params_map={
                'all': [
                    'wallet_create_request',
                ],
                'required': [
                    'wallet_create_request',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'wallet_create_request':
                        (WalletCreateRequest,),
                },
                'attribute_map': {
                },
                'location_map': {
                    'wallet_create_request': 'body',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [
                    'application/json'
                ]
            },
            api_client=api_client,
            callable=__wallet_create
        )

        def __wallet_get(
            self,
            wallet_get_request,
            **kwargs
        ):
            """Fetch an e-wallet  # noqa: E501

            Fetch an e-wallet. The response includes the current balance.  # noqa: E501
            This method makes a synchronous HTTP request by default. To make an
            asynchronous HTTP request, please pass async_req=True

            >>> thread = api.wallet_get(wallet_get_request, async_req=True)
            >>> result = thread.get()

            Args:
                wallet_get_request (WalletGetRequest):

            Keyword Args:
                _return_http_data_only (bool): response data without head status
                    code and headers. Default is True.
                _preload_content (bool): if False, the urllib3.HTTPResponse object
                    will be returned without reading/decoding response data.
                    Default is True.
                _request_timeout (float/tuple): timeout setting for this request. If one
                    number provided, it will be total request timeout. It can also
                    be a pair (tuple) of (connection, read) timeouts.
                    Default is None.
                _check_input_type (bool): specifies if type checking
                    should be done one the data sent to the server.
                    Default is True.
                _check_return_type (bool): specifies if type checking
                    should be done one the data received from the server.
                    Default is True.
                _host_index (int/None): specifies the index of the server
                    that we want to use.
                    Default is read from the configuration.
                async_req (bool): execute request asynchronously

            Returns:
                WalletGetResponse
                    If the method is called asynchronously, returns the request
                    thread.
            """
            kwargs['async_req'] = kwargs.get(
                'async_req', False
            )
            kwargs['_return_http_data_only'] = kwargs.get(
                '_return_http_data_only', True
            )
            kwargs['_preload_content'] = kwargs.get(
                '_preload_content', True
            )
            kwargs['_request_timeout'] = kwargs.get(
                '_request_timeout', None
            )
            kwargs['_check_input_type'] = kwargs.get(
                '_check_input_type', True
            )
            kwargs['_check_return_type'] = kwargs.get(
                '_check_return_type', True
            )
            kwargs['_host_index'] = kwargs.get('_host_index')
            kwargs['wallet_get_request'] = \
                wallet_get_request
            return self.call_with_http_info(**kwargs)

        self.wallet_get = _Endpoint(
            settings={
                'response_type': (WalletGetResponse,),
                'auth': [
                    'clientId',
                    'plaidVersion',
                    'secret'
                ],
                'endpoint_path': '/wallet/get',
                'operation_id': 'wallet_get',
                'http_method': 'POST',
                'servers': None,
            },
            params_map={
                'all': [
                    'wallet_get_request',
                ],
                'required': [
                    'wallet_get_request',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'wallet_get_request':
                        (WalletGetRequest,),
                },
                'attribute_map': {
                },
                'location_map': {
                    'wallet_get_request': 'body',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [
                    'application/json'
                ]
            },
            api_client=api_client,
            callable=__wallet_get
        )

        def __wallet_list(
            self,
            wallet_list_request,
            **kwargs
        ):
            """Fetch a list of e-wallets  # noqa: E501

            This endpoint lists all e-wallets in descending order of creation.  # noqa: E501
            This method makes a synchronous HTTP request by default. To make an
            asynchronous HTTP request, please pass async_req=True

            >>> thread = api.wallet_list(wallet_list_request, async_req=True)
            >>> result = thread.get()

            Args:
                wallet_list_request (WalletListRequest):

            Keyword Args:
                _return_http_data_only (bool): response data without head status
                    code and headers. Default is True.
                _preload_content (bool): if False, the urllib3.HTTPResponse object
                    will be returned without reading/decoding response data.
                    Default is True.
                _request_timeout (float/tuple): timeout setting for this request. If one
                    number provided, it will be total request timeout. It can also
                    be a pair (tuple) of (connection, read) timeouts.
                    Default is None.
                _check_input_type (bool): specifies if type checking
                    should be done one the data sent to the server.
                    Default is True.
                _check_return_type (bool): specifies if type checking
                    should be done one the data received from the server.
                    Default is True.
                _host_index (int/None): specifies the index of the server
                    that we want to use.
                    Default is read from the configuration.
                async_req (bool): execute request asynchronously

            Returns:
                WalletListResponse
                    If the method is called asynchronously, returns the request
                    thread.
            """
            kwargs['async_req'] = kwargs.get(
                'async_req', False
            )
            kwargs['_return_http_data_only'] = kwargs.get(
                '_return_http_data_only', True
            )
            kwargs['_preload_content'] = kwargs.get(
                '_preload_content', True
            )
            kwargs['_request_timeout'] = kwargs.get(
                '_request_timeout', None
            )
            kwargs['_check_input_type'] = kwargs.get(
                '_check_input_type', True
            )
            kwargs['_check_return_type'] = kwargs.get(
                '_check_return_type', True
            )
            kwargs['_host_index'] = kwargs.get('_host_index')
            kwargs['wallet_list_request'] = \
                wallet_list_request
            return self.call_with_http_info(**kwargs)

        self.wallet_list = _Endpoint(
            settings={
                'response_type': (WalletListResponse,),
                'auth': [
                    'clientId',
                    'plaidVersion',
                    'secret'
                ],
                'endpoint_path': '/wallet/list',
                'operation_id': 'wallet_list',
                'http_method': 'POST',
                'servers': None,
            },
            params_map={
                'all': [
                    'wallet_list_request',
                ],
                'required': [
                    'wallet_list_request',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'wallet_list_request':
                        (WalletListRequest,),
                },
                'attribute_map': {
                },
                'location_map': {
                    'wallet_list_request': 'body',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [
                    'application/json'
                ]
            },
            api_client=api_client,
            callable=__wallet_list
        )

        def __wallet_transaction_execute(
            self,
            wallet_transaction_execute_request,
            **kwargs
        ):
            """Execute a transaction using an e-wallet  # noqa: E501

            Execute a transaction using the specified e-wallet. Specify the e-wallet to debit from, the counterparty to credit to, the idempotency key to prevent duplicate payouts, the amount and reference for the payout. The payouts are executed over the Faster Payment rails, where settlement usually only takes a few seconds.  # noqa: E501
            This method makes a synchronous HTTP request by default. To make an
            asynchronous HTTP request, please pass async_req=True

            >>> thread = api.wallet_transaction_execute(wallet_transaction_execute_request, async_req=True)
            >>> result = thread.get()

            Args:
                wallet_transaction_execute_request (WalletTransactionExecuteRequest):

            Keyword Args:
                _return_http_data_only (bool): response data without head status
                    code and headers. Default is True.
                _preload_content (bool): if False, the urllib3.HTTPResponse object
                    will be returned without reading/decoding response data.
                    Default is True.
                _request_timeout (float/tuple): timeout setting for this request. If one
                    number provided, it will be total request timeout. It can also
                    be a pair (tuple) of (connection, read) timeouts.
                    Default is None.
                _check_input_type (bool): specifies if type checking
                    should be done one the data sent to the server.
                    Default is True.
                _check_return_type (bool): specifies if type checking
                    should be done one the data received from the server.
                    Default is True.
                _host_index (int/None): specifies the index of the server
                    that we want to use.
                    Default is read from the configuration.
                async_req (bool): execute request asynchronously

            Returns:
                WalletTransactionExecuteResponse
                    If the method is called asynchronously, returns the request
                    thread.
            """
            kwargs['async_req'] = kwargs.get(
                'async_req', False
            )
            kwargs['_return_http_data_only'] = kwargs.get(
                '_return_http_data_only', True
            )
            kwargs['_preload_content'] = kwargs.get(
                '_preload_content', True
            )
            kwargs['_request_timeout'] = kwargs.get(
                '_request_timeout', None
            )
            kwargs['_check_input_type'] = kwargs.get(
                '_check_input_type', True
            )
            kwargs['_check_return_type'] = kwargs.get(
                '_check_return_type', True
            )
            kwargs['_host_index'] = kwargs.get('_host_index')
            kwargs['wallet_transaction_execute_request'] = \
                wallet_transaction_execute_request
            return self.call_with_http_info(**kwargs)

        self.wallet_transaction_execute = _Endpoint(
            settings={
                'response_type': (WalletTransactionExecuteResponse,),
                'auth': [
                    'clientId',
                    'plaidVersion',
                    'secret'
                ],
                'endpoint_path': '/wallet/transaction/execute',
                'operation_id': 'wallet_transaction_execute',
                'http_method': 'POST',
                'servers': None,
            },
            params_map={
                'all': [
                    'wallet_transaction_execute_request',
                ],
                'required': [
                    'wallet_transaction_execute_request',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'wallet_transaction_execute_request':
                        (WalletTransactionExecuteRequest,),
                },
                'attribute_map': {
                },
                'location_map': {
                    'wallet_transaction_execute_request': 'body',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [
                    'application/json'
                ]
            },
            api_client=api_client,
            callable=__wallet_transaction_execute
        )

        def __wallet_transaction_get(
            self,
            wallet_transaction_get_request,
            **kwargs
        ):
            """wallet_transaction_get  # noqa: E501

            Fetch a specific e-wallet transaction  # noqa: E501
            This method makes a synchronous HTTP request by default. To make an
            asynchronous HTTP request, please pass async_req=True

            >>> thread = api.wallet_transaction_get(wallet_transaction_get_request, async_req=True)
            >>> result = thread.get()

            Args:
                wallet_transaction_get_request (WalletTransactionGetRequest):

            Keyword Args:
                _return_http_data_only (bool): response data without head status
                    code and headers. Default is True.
                _preload_content (bool): if False, the urllib3.HTTPResponse object
                    will be returned without reading/decoding response data.
                    Default is True.
                _request_timeout (float/tuple): timeout setting for this request. If one
                    number provided, it will be total request timeout. It can also
                    be a pair (tuple) of (connection, read) timeouts.
                    Default is None.
                _check_input_type (bool): specifies if type checking
                    should be done one the data sent to the server.
                    Default is True.
                _check_return_type (bool): specifies if type checking
                    should be done one the data received from the server.
                    Default is True.
                _host_index (int/None): specifies the index of the server
                    that we want to use.
                    Default is read from the configuration.
                async_req (bool): execute request asynchronously

            Returns:
                WalletTransactionGetResponse
                    If the method is called asynchronously, returns the request
                    thread.
            """
            kwargs['async_req'] = kwargs.get(
                'async_req', False
            )
            kwargs['_return_http_data_only'] = kwargs.get(
                '_return_http_data_only', True
            )
            kwargs['_preload_content'] = kwargs.get(
                '_preload_content', True
            )
            kwargs['_request_timeout'] = kwargs.get(
                '_request_timeout', None
            )
            kwargs['_check_input_type'] = kwargs.get(
                '_check_input_type', True
            )
            kwargs['_check_return_type'] = kwargs.get(
                '_check_return_type', True
            )
            kwargs['_host_index'] = kwargs.get('_host_index')
            kwargs['wallet_transaction_get_request'] = \
                wallet_transaction_get_request
            return self.call_with_http_info(**kwargs)

        self.wallet_transaction_get = _Endpoint(
            settings={
                'response_type': (WalletTransactionGetResponse,),
                'auth': [
                    'clientId',
                    'plaidVersion',
                    'secret'
                ],
                'endpoint_path': '/wallet/transaction/get',
                'operation_id': 'wallet_transaction_get',
                'http_method': 'POST',
                'servers': None,
            },
            params_map={
                'all': [
                    'wallet_transaction_get_request',
                ],
                'required': [
                    'wallet_transaction_get_request',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'wallet_transaction_get_request':
                        (WalletTransactionGetRequest,),
                },
                'attribute_map': {
                },
                'location_map': {
                    'wallet_transaction_get_request': 'body',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [
                    'application/json'
                ]
            },
            api_client=api_client,
            callable=__wallet_transaction_get
        )

        def __wallet_transactions_list(
            self,
            wallet_transactions_list_request,
            **kwargs
        ):
            """List e-wallet transactions  # noqa: E501

            This endpoint lists the latest transactions of the specified e-wallet. Transactions are returned in descending order by the `created_at` time.  # noqa: E501
            This method makes a synchronous HTTP request by default. To make an
            asynchronous HTTP request, please pass async_req=True

            >>> thread = api.wallet_transactions_list(wallet_transactions_list_request, async_req=True)
            >>> result = thread.get()

            Args:
                wallet_transactions_list_request (WalletTransactionsListRequest):

            Keyword Args:
                _return_http_data_only (bool): response data without head status
                    code and headers. Default is True.
                _preload_content (bool): if False, the urllib3.HTTPResponse object
                    will be returned without reading/decoding response data.
                    Default is True.
                _request_timeout (float/tuple): timeout setting for this request. If one
                    number provided, it will be total request timeout. It can also
                    be a pair (tuple) of (connection, read) timeouts.
                    Default is None.
                _check_input_type (bool): specifies if type checking
                    should be done one the data sent to the server.
                    Default is True.
                _check_return_type (bool): specifies if type checking
                    should be done one the data received from the server.
                    Default is True.
                _host_index (int/None): specifies the index of the server
                    that we want to use.
                    Default is read from the configuration.
                async_req (bool): execute request asynchronously

            Returns:
                WalletTransactionsListResponse
                    If the method is called asynchronously, returns the request
                    thread.
            """
            kwargs['async_req'] = kwargs.get(
                'async_req', False
            )
            kwargs['_return_http_data_only'] = kwargs.get(
                '_return_http_data_only', True
            )
            kwargs['_preload_content'] = kwargs.get(
                '_preload_content', True
            )
            kwargs['_request_timeout'] = kwargs.get(
                '_request_timeout', None
            )
            kwargs['_check_input_type'] = kwargs.get(
                '_check_input_type', True
            )
            kwargs['_check_return_type'] = kwargs.get(
                '_check_return_type', True
            )
            kwargs['_host_index'] = kwargs.get('_host_index')
            kwargs['wallet_transactions_list_request'] = \
                wallet_transactions_list_request
            return self.call_with_http_info(**kwargs)

        self.wallet_transactions_list = _Endpoint(
            settings={
                'response_type': (WalletTransactionsListResponse,),
                'auth': [
                    'clientId',
                    'plaidVersion',
                    'secret'
                ],
                'endpoint_path': '/wallet/transactions/list',
                'operation_id': 'wallet_transactions_list',
                'http_method': 'POST',
                'servers': None,
            },
            params_map={
                'all': [
                    'wallet_transactions_list_request',
                ],
                'required': [
                    'wallet_transactions_list_request',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'wallet_transactions_list_request':
                        (WalletTransactionsListRequest,),
                },
                'attribute_map': {
                },
                'location_map': {
                    'wallet_transactions_list_request': 'body',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [
                    'application/json'
                ]
            },
            api_client=api_client,
            callable=__wallet_transactions_list
        )

        def __watchlist_screening_entity_create(
            self,
            create_entity_screening_request,
            **kwargs
        ):
            """Create a watchlist screening for an entity  # noqa: E501

            Create a new entity watchlist screening to check your customer against watchlists defined in the associated entity watchlist program. If your associated program has ongoing screening enabled, this is the profile information that will be used to monitor your customer over time.  # noqa: E501
            This method makes a synchronous HTTP request by default. To make an
            asynchronous HTTP request, please pass async_req=True

            >>> thread = api.watchlist_screening_entity_create(create_entity_screening_request, async_req=True)
            >>> result = thread.get()

            Args:
                create_entity_screening_request (CreateEntityScreeningRequest):

            Keyword Args:
                _return_http_data_only (bool): response data without head status
                    code and headers. Default is True.
                _preload_content (bool): if False, the urllib3.HTTPResponse object
                    will be returned without reading/decoding response data.
                    Default is True.
                _request_timeout (float/tuple): timeout setting for this request. If one
                    number provided, it will be total request timeout. It can also
                    be a pair (tuple) of (connection, read) timeouts.
                    Default is None.
                _check_input_type (bool): specifies if type checking
                    should be done one the data sent to the server.
                    Default is True.
                _check_return_type (bool): specifies if type checking
                    should be done one the data received from the server.
                    Default is True.
                _host_index (int/None): specifies the index of the server
                    that we want to use.
                    Default is read from the configuration.
                async_req (bool): execute request asynchronously

            Returns:
                EntityWatchlistScreeningResponse
                    If the method is called asynchronously, returns the request
                    thread.
            """
            kwargs['async_req'] = kwargs.get(
                'async_req', False
            )
            kwargs['_return_http_data_only'] = kwargs.get(
                '_return_http_data_only', True
            )
            kwargs['_preload_content'] = kwargs.get(
                '_preload_content', True
            )
            kwargs['_request_timeout'] = kwargs.get(
                '_request_timeout', None
            )
            kwargs['_check_input_type'] = kwargs.get(
                '_check_input_type', True
            )
            kwargs['_check_return_type'] = kwargs.get(
                '_check_return_type', True
            )
            kwargs['_host_index'] = kwargs.get('_host_index')
            kwargs['create_entity_screening_request'] = \
                create_entity_screening_request
            return self.call_with_http_info(**kwargs)

        self.watchlist_screening_entity_create = _Endpoint(
            settings={
                'response_type': (EntityWatchlistScreeningResponse,),
                'auth': [
                    'clientId',
                    'plaidVersion',
                    'secret'
                ],
                'endpoint_path': '/watchlist_screening/entity/create',
                'operation_id': 'watchlist_screening_entity_create',
                'http_method': 'POST',
                'servers': None,
            },
            params_map={
                'all': [
                    'create_entity_screening_request',
                ],
                'required': [
                    'create_entity_screening_request',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'create_entity_screening_request':
                        (CreateEntityScreeningRequest,),
                },
                'attribute_map': {
                },
                'location_map': {
                    'create_entity_screening_request': 'body',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [
                    'application/json'
                ]
            },
            api_client=api_client,
            callable=__watchlist_screening_entity_create
        )

        def __watchlist_screening_entity_get(
            self,
            get_entity_watchlist_screening_request,
            **kwargs
        ):
            """Get an entity screening  # noqa: E501

            Retrieve an entity watchlist screening.  # noqa: E501
            This method makes a synchronous HTTP request by default. To make an
            asynchronous HTTP request, please pass async_req=True

            >>> thread = api.watchlist_screening_entity_get(get_entity_watchlist_screening_request, async_req=True)
            >>> result = thread.get()

            Args:
                get_entity_watchlist_screening_request (GetEntityWatchlistScreeningRequest):

            Keyword Args:
                _return_http_data_only (bool): response data without head status
                    code and headers. Default is True.
                _preload_content (bool): if False, the urllib3.HTTPResponse object
                    will be returned without reading/decoding response data.
                    Default is True.
                _request_timeout (float/tuple): timeout setting for this request. If one
                    number provided, it will be total request timeout. It can also
                    be a pair (tuple) of (connection, read) timeouts.
                    Default is None.
                _check_input_type (bool): specifies if type checking
                    should be done one the data sent to the server.
                    Default is True.
                _check_return_type (bool): specifies if type checking
                    should be done one the data received from the server.
                    Default is True.
                _host_index (int/None): specifies the index of the server
                    that we want to use.
                    Default is read from the configuration.
                async_req (bool): execute request asynchronously

            Returns:
                EntityWatchlistScreeningResponse
                    If the method is called asynchronously, returns the request
                    thread.
            """
            kwargs['async_req'] = kwargs.get(
                'async_req', False
            )
            kwargs['_return_http_data_only'] = kwargs.get(
                '_return_http_data_only', True
            )
            kwargs['_preload_content'] = kwargs.get(
                '_preload_content', True
            )
            kwargs['_request_timeout'] = kwargs.get(
                '_request_timeout', None
            )
            kwargs['_check_input_type'] = kwargs.get(
                '_check_input_type', True
            )
            kwargs['_check_return_type'] = kwargs.get(
                '_check_return_type', True
            )
            kwargs['_host_index'] = kwargs.get('_host_index')
            kwargs['get_entity_watchlist_screening_request'] = \
                get_entity_watchlist_screening_request
            return self.call_with_http_info(**kwargs)

        self.watchlist_screening_entity_get = _Endpoint(
            settings={
                'response_type': (EntityWatchlistScreeningResponse,),
                'auth': [
                    'clientId',
                    'plaidVersion',
                    'secret'
                ],
                'endpoint_path': '/watchlist_screening/entity/get',
                'operation_id': 'watchlist_screening_entity_get',
                'http_method': 'POST',
                'servers': None,
            },
            params_map={
                'all': [
                    'get_entity_watchlist_screening_request',
                ],
                'required': [
                    'get_entity_watchlist_screening_request',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'get_entity_watchlist_screening_request':
                        (GetEntityWatchlistScreeningRequest,),
                },
                'attribute_map': {
                },
                'location_map': {
                    'get_entity_watchlist_screening_request': 'body',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [
                    'application/json'
                ]
            },
            api_client=api_client,
            callable=__watchlist_screening_entity_get
        )

        def __watchlist_screening_entity_history_list(
            self,
            list_watchlist_screening_entity_history_request,
            **kwargs
        ):
            """List history for entity watchlist screenings  # noqa: E501

            List all changes to the entity watchlist screening in reverse-chronological order. If the watchlist screening has not been edited, no history will be returned.  # noqa: E501
            This method makes a synchronous HTTP request by default. To make an
            asynchronous HTTP request, please pass async_req=True

            >>> thread = api.watchlist_screening_entity_history_list(list_watchlist_screening_entity_history_request, async_req=True)
            >>> result = thread.get()

            Args:
                list_watchlist_screening_entity_history_request (ListWatchlistScreeningEntityHistoryRequest):

            Keyword Args:
                _return_http_data_only (bool): response data without head status
                    code and headers. Default is True.
                _preload_content (bool): if False, the urllib3.HTTPResponse object
                    will be returned without reading/decoding response data.
                    Default is True.
                _request_timeout (float/tuple): timeout setting for this request. If one
                    number provided, it will be total request timeout. It can also
                    be a pair (tuple) of (connection, read) timeouts.
                    Default is None.
                _check_input_type (bool): specifies if type checking
                    should be done one the data sent to the server.
                    Default is True.
                _check_return_type (bool): specifies if type checking
                    should be done one the data received from the server.
                    Default is True.
                _host_index (int/None): specifies the index of the server
                    that we want to use.
                    Default is read from the configuration.
                async_req (bool): execute request asynchronously

            Returns:
                PaginatedEntityWatchlistScreeningListResponse
                    If the method is called asynchronously, returns the request
                    thread.
            """
            kwargs['async_req'] = kwargs.get(
                'async_req', False
            )
            kwargs['_return_http_data_only'] = kwargs.get(
                '_return_http_data_only', True
            )
            kwargs['_preload_content'] = kwargs.get(
                '_preload_content', True
            )
            kwargs['_request_timeout'] = kwargs.get(
                '_request_timeout', None
            )
            kwargs['_check_input_type'] = kwargs.get(
                '_check_input_type', True
            )
            kwargs['_check_return_type'] = kwargs.get(
                '_check_return_type', True
            )
            kwargs['_host_index'] = kwargs.get('_host_index')
            kwargs['list_watchlist_screening_entity_history_request'] = \
                list_watchlist_screening_entity_history_request
            return self.call_with_http_info(**kwargs)

        self.watchlist_screening_entity_history_list = _Endpoint(
            settings={
                'response_type': (PaginatedEntityWatchlistScreeningListResponse,),
                'auth': [
                    'clientId',
                    'plaidVersion',
                    'secret'
                ],
                'endpoint_path': '/watchlist_screening/entity/history/list',
                'operation_id': 'watchlist_screening_entity_history_list',
                'http_method': 'POST',
                'servers': None,
            },
            params_map={
                'all': [
                    'list_watchlist_screening_entity_history_request',
                ],
                'required': [
                    'list_watchlist_screening_entity_history_request',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'list_watchlist_screening_entity_history_request':
                        (ListWatchlistScreeningEntityHistoryRequest,),
                },
                'attribute_map': {
                },
                'location_map': {
                    'list_watchlist_screening_entity_history_request': 'body',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [
                    'application/json'
                ]
            },
            api_client=api_client,
            callable=__watchlist_screening_entity_history_list
        )

        def __watchlist_screening_entity_hits_list(
            self,
            list_watchlist_screening_entity_hit_request,
            **kwargs
        ):
            """List hits for entity watchlist screenings  # noqa: E501

            List all hits for the entity watchlist screening.  # noqa: E501
            This method makes a synchronous HTTP request by default. To make an
            asynchronous HTTP request, please pass async_req=True

            >>> thread = api.watchlist_screening_entity_hits_list(list_watchlist_screening_entity_hit_request, async_req=True)
            >>> result = thread.get()

            Args:
                list_watchlist_screening_entity_hit_request (ListWatchlistScreeningEntityHitRequest):

            Keyword Args:
                _return_http_data_only (bool): response data without head status
                    code and headers. Default is True.
                _preload_content (bool): if False, the urllib3.HTTPResponse object
                    will be returned without reading/decoding response data.
                    Default is True.
                _request_timeout (float/tuple): timeout setting for this request. If one
                    number provided, it will be total request timeout. It can also
                    be a pair (tuple) of (connection, read) timeouts.
                    Default is None.
                _check_input_type (bool): specifies if type checking
                    should be done one the data sent to the server.
                    Default is True.
                _check_return_type (bool): specifies if type checking
                    should be done one the data received from the server.
                    Default is True.
                _host_index (int/None): specifies the index of the server
                    that we want to use.
                    Default is read from the configuration.
                async_req (bool): execute request asynchronously

            Returns:
                PaginatedEntityWatchlistScreeningHitListResponse
                    If the method is called asynchronously, returns the request
                    thread.
            """
            kwargs['async_req'] = kwargs.get(
                'async_req', False
            )
            kwargs['_return_http_data_only'] = kwargs.get(
                '_return_http_data_only', True
            )
            kwargs['_preload_content'] = kwargs.get(
                '_preload_content', True
            )
            kwargs['_request_timeout'] = kwargs.get(
                '_request_timeout', None
            )
            kwargs['_check_input_type'] = kwargs.get(
                '_check_input_type', True
            )
            kwargs['_check_return_type'] = kwargs.get(
                '_check_return_type', True
            )
            kwargs['_host_index'] = kwargs.get('_host_index')
            kwargs['list_watchlist_screening_entity_hit_request'] = \
                list_watchlist_screening_entity_hit_request
            return self.call_with_http_info(**kwargs)

        self.watchlist_screening_entity_hits_list = _Endpoint(
            settings={
                'response_type': (PaginatedEntityWatchlistScreeningHitListResponse,),
                'auth': [
                    'clientId',
                    'plaidVersion',
                    'secret'
                ],
                'endpoint_path': '/watchlist_screening/entity/hit/list',
                'operation_id': 'watchlist_screening_entity_hits_list',
                'http_method': 'POST',
                'servers': None,
            },
            params_map={
                'all': [
                    'list_watchlist_screening_entity_hit_request',
                ],
                'required': [
                    'list_watchlist_screening_entity_hit_request',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'list_watchlist_screening_entity_hit_request':
                        (ListWatchlistScreeningEntityHitRequest,),
                },
                'attribute_map': {
                },
                'location_map': {
                    'list_watchlist_screening_entity_hit_request': 'body',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [
                    'application/json'
                ]
            },
            api_client=api_client,
            callable=__watchlist_screening_entity_hits_list
        )

        def __watchlist_screening_entity_list(
            self,
            list_entity_watchlist_screening_request,
            **kwargs
        ):
            """List entity watchlist screenings  # noqa: E501

            List all entity screenings.  # noqa: E501
            This method makes a synchronous HTTP request by default. To make an
            asynchronous HTTP request, please pass async_req=True

            >>> thread = api.watchlist_screening_entity_list(list_entity_watchlist_screening_request, async_req=True)
            >>> result = thread.get()

            Args:
                list_entity_watchlist_screening_request (ListEntityWatchlistScreeningRequest):

            Keyword Args:
                _return_http_data_only (bool): response data without head status
                    code and headers. Default is True.
                _preload_content (bool): if False, the urllib3.HTTPResponse object
                    will be returned without reading/decoding response data.
                    Default is True.
                _request_timeout (float/tuple): timeout setting for this request. If one
                    number provided, it will be total request timeout. It can also
                    be a pair (tuple) of (connection, read) timeouts.
                    Default is None.
                _check_input_type (bool): specifies if type checking
                    should be done one the data sent to the server.
                    Default is True.
                _check_return_type (bool): specifies if type checking
                    should be done one the data received from the server.
                    Default is True.
                _host_index (int/None): specifies the index of the server
                    that we want to use.
                    Default is read from the configuration.
                async_req (bool): execute request asynchronously

            Returns:
                PaginatedEntityWatchlistScreeningListResponse
                    If the method is called asynchronously, returns the request
                    thread.
            """
            kwargs['async_req'] = kwargs.get(
                'async_req', False
            )
            kwargs['_return_http_data_only'] = kwargs.get(
                '_return_http_data_only', True
            )
            kwargs['_preload_content'] = kwargs.get(
                '_preload_content', True
            )
            kwargs['_request_timeout'] = kwargs.get(
                '_request_timeout', None
            )
            kwargs['_check_input_type'] = kwargs.get(
                '_check_input_type', True
            )
            kwargs['_check_return_type'] = kwargs.get(
                '_check_return_type', True
            )
            kwargs['_host_index'] = kwargs.get('_host_index')
            kwargs['list_entity_watchlist_screening_request'] = \
                list_entity_watchlist_screening_request
            return self.call_with_http_info(**kwargs)

        self.watchlist_screening_entity_list = _Endpoint(
            settings={
                'response_type': (PaginatedEntityWatchlistScreeningListResponse,),
                'auth': [
                    'clientId',
                    'plaidVersion',
                    'secret'
                ],
                'endpoint_path': '/watchlist_screening/entity/list',
                'operation_id': 'watchlist_screening_entity_list',
                'http_method': 'POST',
                'servers': None,
            },
            params_map={
                'all': [
                    'list_entity_watchlist_screening_request',
                ],
                'required': [
                    'list_entity_watchlist_screening_request',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'list_entity_watchlist_screening_request':
                        (ListEntityWatchlistScreeningRequest,),
                },
                'attribute_map': {
                },
                'location_map': {
                    'list_entity_watchlist_screening_request': 'body',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [
                    'application/json'
                ]
            },
            api_client=api_client,
            callable=__watchlist_screening_entity_list
        )

        def __watchlist_screening_entity_program_get(
            self,
            get_watchlist_screening_entity_program_request,
            **kwargs
        ):
            """Get entity watchlist screening program  # noqa: E501

            Get an entity watchlist screening program  # noqa: E501
            This method makes a synchronous HTTP request by default. To make an
            asynchronous HTTP request, please pass async_req=True

            >>> thread = api.watchlist_screening_entity_program_get(get_watchlist_screening_entity_program_request, async_req=True)
            >>> result = thread.get()

            Args:
                get_watchlist_screening_entity_program_request (GetWatchlistScreeningEntityProgramRequest):

            Keyword Args:
                _return_http_data_only (bool): response data without head status
                    code and headers. Default is True.
                _preload_content (bool): if False, the urllib3.HTTPResponse object
                    will be returned without reading/decoding response data.
                    Default is True.
                _request_timeout (float/tuple): timeout setting for this request. If one
                    number provided, it will be total request timeout. It can also
                    be a pair (tuple) of (connection, read) timeouts.
                    Default is None.
                _check_input_type (bool): specifies if type checking
                    should be done one the data sent to the server.
                    Default is True.
                _check_return_type (bool): specifies if type checking
                    should be done one the data received from the server.
                    Default is True.
                _host_index (int/None): specifies the index of the server
                    that we want to use.
                    Default is read from the configuration.
                async_req (bool): execute request asynchronously

            Returns:
                EntityWatchlistProgramResponse
                    If the method is called asynchronously, returns the request
                    thread.
            """
            kwargs['async_req'] = kwargs.get(
                'async_req', False
            )
            kwargs['_return_http_data_only'] = kwargs.get(
                '_return_http_data_only', True
            )
            kwargs['_preload_content'] = kwargs.get(
                '_preload_content', True
            )
            kwargs['_request_timeout'] = kwargs.get(
                '_request_timeout', None
            )
            kwargs['_check_input_type'] = kwargs.get(
                '_check_input_type', True
            )
            kwargs['_check_return_type'] = kwargs.get(
                '_check_return_type', True
            )
            kwargs['_host_index'] = kwargs.get('_host_index')
            kwargs['get_watchlist_screening_entity_program_request'] = \
                get_watchlist_screening_entity_program_request
            return self.call_with_http_info(**kwargs)

        self.watchlist_screening_entity_program_get = _Endpoint(
            settings={
                'response_type': (EntityWatchlistProgramResponse,),
                'auth': [
                    'clientId',
                    'plaidVersion',
                    'secret'
                ],
                'endpoint_path': '/watchlist_screening/entity/program/get',
                'operation_id': 'watchlist_screening_entity_program_get',
                'http_method': 'POST',
                'servers': None,
            },
            params_map={
                'all': [
                    'get_watchlist_screening_entity_program_request',
                ],
                'required': [
                    'get_watchlist_screening_entity_program_request',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'get_watchlist_screening_entity_program_request':
                        (GetWatchlistScreeningEntityProgramRequest,),
                },
                'attribute_map': {
                },
                'location_map': {
                    'get_watchlist_screening_entity_program_request': 'body',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [
                    'application/json'
                ]
            },
            api_client=api_client,
            callable=__watchlist_screening_entity_program_get
        )

        def __watchlist_screening_entity_program_list(
            self,
            list_watchlist_screening_entity_programs_request,
            **kwargs
        ):
            """List entity watchlist screening programs  # noqa: E501

            List all entity watchlist screening programs  # noqa: E501
            This method makes a synchronous HTTP request by default. To make an
            asynchronous HTTP request, please pass async_req=True

            >>> thread = api.watchlist_screening_entity_program_list(list_watchlist_screening_entity_programs_request, async_req=True)
            >>> result = thread.get()

            Args:
                list_watchlist_screening_entity_programs_request (ListWatchlistScreeningEntityProgramsRequest):

            Keyword Args:
                _return_http_data_only (bool): response data without head status
                    code and headers. Default is True.
                _preload_content (bool): if False, the urllib3.HTTPResponse object
                    will be returned without reading/decoding response data.
                    Default is True.
                _request_timeout (float/tuple): timeout setting for this request. If one
                    number provided, it will be total request timeout. It can also
                    be a pair (tuple) of (connection, read) timeouts.
                    Default is None.
                _check_input_type (bool): specifies if type checking
                    should be done one the data sent to the server.
                    Default is True.
                _check_return_type (bool): specifies if type checking
                    should be done one the data received from the server.
                    Default is True.
                _host_index (int/None): specifies the index of the server
                    that we want to use.
                    Default is read from the configuration.
                async_req (bool): execute request asynchronously

            Returns:
                PaginatedEntityWatchlistProgramListResponse
                    If the method is called asynchronously, returns the request
                    thread.
            """
            kwargs['async_req'] = kwargs.get(
                'async_req', False
            )
            kwargs['_return_http_data_only'] = kwargs.get(
                '_return_http_data_only', True
            )
            kwargs['_preload_content'] = kwargs.get(
                '_preload_content', True
            )
            kwargs['_request_timeout'] = kwargs.get(
                '_request_timeout', None
            )
            kwargs['_check_input_type'] = kwargs.get(
                '_check_input_type', True
            )
            kwargs['_check_return_type'] = kwargs.get(
                '_check_return_type', True
            )
            kwargs['_host_index'] = kwargs.get('_host_index')
            kwargs['list_watchlist_screening_entity_programs_request'] = \
                list_watchlist_screening_entity_programs_request
            return self.call_with_http_info(**kwargs)

        self.watchlist_screening_entity_program_list = _Endpoint(
            settings={
                'response_type': (PaginatedEntityWatchlistProgramListResponse,),
                'auth': [
                    'clientId',
                    'plaidVersion',
                    'secret'
                ],
                'endpoint_path': '/watchlist_screening/entity/program/list',
                'operation_id': 'watchlist_screening_entity_program_list',
                'http_method': 'POST',
                'servers': None,
            },
            params_map={
                'all': [
                    'list_watchlist_screening_entity_programs_request',
                ],
                'required': [
                    'list_watchlist_screening_entity_programs_request',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'list_watchlist_screening_entity_programs_request':
                        (ListWatchlistScreeningEntityProgramsRequest,),
                },
                'attribute_map': {
                },
                'location_map': {
                    'list_watchlist_screening_entity_programs_request': 'body',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [
                    'application/json'
                ]
            },
            api_client=api_client,
            callable=__watchlist_screening_entity_program_list
        )

        def __watchlist_screening_entity_review_create(
            self,
            create_entity_watchlist_screening_review_request,
            **kwargs
        ):
            """Create a review for an entity watchlist screening  # noqa: E501

            Create a review for an entity watchlist screening. Reviews are compliance reports created by users in your organization regarding the relevance of potential hits found by Plaid.  # noqa: E501
            This method makes a synchronous HTTP request by default. To make an
            asynchronous HTTP request, please pass async_req=True

            >>> thread = api.watchlist_screening_entity_review_create(create_entity_watchlist_screening_review_request, async_req=True)
            >>> result = thread.get()

            Args:
                create_entity_watchlist_screening_review_request (CreateEntityWatchlistScreeningReviewRequest):

            Keyword Args:
                _return_http_data_only (bool): response data without head status
                    code and headers. Default is True.
                _preload_content (bool): if False, the urllib3.HTTPResponse object
                    will be returned without reading/decoding response data.
                    Default is True.
                _request_timeout (float/tuple): timeout setting for this request. If one
                    number provided, it will be total request timeout. It can also
                    be a pair (tuple) of (connection, read) timeouts.
                    Default is None.
                _check_input_type (bool): specifies if type checking
                    should be done one the data sent to the server.
                    Default is True.
                _check_return_type (bool): specifies if type checking
                    should be done one the data received from the server.
                    Default is True.
                _host_index (int/None): specifies the index of the server
                    that we want to use.
                    Default is read from the configuration.
                async_req (bool): execute request asynchronously

            Returns:
                EntityWatchlistScreeningReviewResponse
                    If the method is called asynchronously, returns the request
                    thread.
            """
            kwargs['async_req'] = kwargs.get(
                'async_req', False
            )
            kwargs['_return_http_data_only'] = kwargs.get(
                '_return_http_data_only', True
            )
            kwargs['_preload_content'] = kwargs.get(
                '_preload_content', True
            )
            kwargs['_request_timeout'] = kwargs.get(
                '_request_timeout', None
            )
            kwargs['_check_input_type'] = kwargs.get(
                '_check_input_type', True
            )
            kwargs['_check_return_type'] = kwargs.get(
                '_check_return_type', True
            )
            kwargs['_host_index'] = kwargs.get('_host_index')
            kwargs['create_entity_watchlist_screening_review_request'] = \
                create_entity_watchlist_screening_review_request
            return self.call_with_http_info(**kwargs)

        self.watchlist_screening_entity_review_create = _Endpoint(
            settings={
                'response_type': (EntityWatchlistScreeningReviewResponse,),
                'auth': [
                    'clientId',
                    'plaidVersion',
                    'secret'
                ],
                'endpoint_path': '/watchlist_screening/entity/review/create',
                'operation_id': 'watchlist_screening_entity_review_create',
                'http_method': 'POST',
                'servers': None,
            },
            params_map={
                'all': [
                    'create_entity_watchlist_screening_review_request',
                ],
                'required': [
                    'create_entity_watchlist_screening_review_request',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'create_entity_watchlist_screening_review_request':
                        (CreateEntityWatchlistScreeningReviewRequest,),
                },
                'attribute_map': {
                },
                'location_map': {
                    'create_entity_watchlist_screening_review_request': 'body',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [
                    'application/json'
                ]
            },
            api_client=api_client,
            callable=__watchlist_screening_entity_review_create
        )

        def __watchlist_screening_entity_review_list(
            self,
            list_watchlist_screening_entity_reviews_request,
            **kwargs
        ):
            """List reviews for entity watchlist screenings  # noqa: E501

            List all reviews for a particular entity watchlist screening. Reviews are compliance reports created by users in your organization regarding the relevance of potential hits found by Plaid.  # noqa: E501
            This method makes a synchronous HTTP request by default. To make an
            asynchronous HTTP request, please pass async_req=True

            >>> thread = api.watchlist_screening_entity_review_list(list_watchlist_screening_entity_reviews_request, async_req=True)
            >>> result = thread.get()

            Args:
                list_watchlist_screening_entity_reviews_request (ListWatchlistScreeningEntityReviewsRequest):

            Keyword Args:
                _return_http_data_only (bool): response data without head status
                    code and headers. Default is True.
                _preload_content (bool): if False, the urllib3.HTTPResponse object
                    will be returned without reading/decoding response data.
                    Default is True.
                _request_timeout (float/tuple): timeout setting for this request. If one
                    number provided, it will be total request timeout. It can also
                    be a pair (tuple) of (connection, read) timeouts.
                    Default is None.
                _check_input_type (bool): specifies if type checking
                    should be done one the data sent to the server.
                    Default is True.
                _check_return_type (bool): specifies if type checking
                    should be done one the data received from the server.
                    Default is True.
                _host_index (int/None): specifies the index of the server
                    that we want to use.
                    Default is read from the configuration.
                async_req (bool): execute request asynchronously

            Returns:
                PaginatedEntityWatchlistScreeningReviewListResponse
                    If the method is called asynchronously, returns the request
                    thread.
            """
            kwargs['async_req'] = kwargs.get(
                'async_req', False
            )
            kwargs['_return_http_data_only'] = kwargs.get(
                '_return_http_data_only', True
            )
            kwargs['_preload_content'] = kwargs.get(
                '_preload_content', True
            )
            kwargs['_request_timeout'] = kwargs.get(
                '_request_timeout', None
            )
            kwargs['_check_input_type'] = kwargs.get(
                '_check_input_type', True
            )
            kwargs['_check_return_type'] = kwargs.get(
                '_check_return_type', True
            )
            kwargs['_host_index'] = kwargs.get('_host_index')
            kwargs['list_watchlist_screening_entity_reviews_request'] = \
                list_watchlist_screening_entity_reviews_request
            return self.call_with_http_info(**kwargs)

        self.watchlist_screening_entity_review_list = _Endpoint(
            settings={
                'response_type': (PaginatedEntityWatchlistScreeningReviewListResponse,),
                'auth': [
                    'clientId',
                    'plaidVersion',
                    'secret'
                ],
                'endpoint_path': '/watchlist_screening/entity/review/list',
                'operation_id': 'watchlist_screening_entity_review_list',
                'http_method': 'POST',
                'servers': None,
            },
            params_map={
                'all': [
                    'list_watchlist_screening_entity_reviews_request',
                ],
                'required': [
                    'list_watchlist_screening_entity_reviews_request',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'list_watchlist_screening_entity_reviews_request':
                        (ListWatchlistScreeningEntityReviewsRequest,),
                },
                'attribute_map': {
                },
                'location_map': {
                    'list_watchlist_screening_entity_reviews_request': 'body',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [
                    'application/json'
                ]
            },
            api_client=api_client,
            callable=__watchlist_screening_entity_review_list
        )

        def __watchlist_screening_entity_update(
            self,
            update_entity_screening_request,
            **kwargs
        ):
            """Update an entity screening  # noqa: E501

            Update an entity watchlist screening.  # noqa: E501
            This method makes a synchronous HTTP request by default. To make an
            asynchronous HTTP request, please pass async_req=True

            >>> thread = api.watchlist_screening_entity_update(update_entity_screening_request, async_req=True)
            >>> result = thread.get()

            Args:
                update_entity_screening_request (UpdateEntityScreeningRequest): The entity screening was successfully updated.

            Keyword Args:
                _return_http_data_only (bool): response data without head status
                    code and headers. Default is True.
                _preload_content (bool): if False, the urllib3.HTTPResponse object
                    will be returned without reading/decoding response data.
                    Default is True.
                _request_timeout (float/tuple): timeout setting for this request. If one
                    number provided, it will be total request timeout. It can also
                    be a pair (tuple) of (connection, read) timeouts.
                    Default is None.
                _check_input_type (bool): specifies if type checking
                    should be done one the data sent to the server.
                    Default is True.
                _check_return_type (bool): specifies if type checking
                    should be done one the data received from the server.
                    Default is True.
                _host_index (int/None): specifies the index of the server
                    that we want to use.
                    Default is read from the configuration.
                async_req (bool): execute request asynchronously

            Returns:
                EntityWatchlistScreeningResponse
                    If the method is called asynchronously, returns the request
                    thread.
            """
            kwargs['async_req'] = kwargs.get(
                'async_req', False
            )
            kwargs['_return_http_data_only'] = kwargs.get(
                '_return_http_data_only', True
            )
            kwargs['_preload_content'] = kwargs.get(
                '_preload_content', True
            )
            kwargs['_request_timeout'] = kwargs.get(
                '_request_timeout', None
            )
            kwargs['_check_input_type'] = kwargs.get(
                '_check_input_type', True
            )
            kwargs['_check_return_type'] = kwargs.get(
                '_check_return_type', True
            )
            kwargs['_host_index'] = kwargs.get('_host_index')
            kwargs['update_entity_screening_request'] = \
                update_entity_screening_request
            return self.call_with_http_info(**kwargs)

        self.watchlist_screening_entity_update = _Endpoint(
            settings={
                'response_type': (EntityWatchlistScreeningResponse,),
                'auth': [
                    'clientId',
                    'plaidVersion',
                    'secret'
                ],
                'endpoint_path': '/watchlist_screening/entity/update',
                'operation_id': 'watchlist_screening_entity_update',
                'http_method': 'POST',
                'servers': None,
            },
            params_map={
                'all': [
                    'update_entity_screening_request',
                ],
                'required': [
                    'update_entity_screening_request',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'update_entity_screening_request':
                        (UpdateEntityScreeningRequest,),
                },
                'attribute_map': {
                },
                'location_map': {
                    'update_entity_screening_request': 'body',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [
                    'application/json'
                ]
            },
            api_client=api_client,
            callable=__watchlist_screening_entity_update
        )

        def __watchlist_screening_individual_create(
            self,
            watchlist_screening_create_request,
            **kwargs
        ):
            """Create a watchlist screening for a person  # noqa: E501

            Create a new Watchlist Screening to check your customer against watchlists defined in the associated Watchlist Program. If your associated program has ongoing screening enabled, this is the profile information that will be used to monitor your customer over time.  # noqa: E501
            This method makes a synchronous HTTP request by default. To make an
            asynchronous HTTP request, please pass async_req=True

            >>> thread = api.watchlist_screening_individual_create(watchlist_screening_create_request, async_req=True)
            >>> result = thread.get()

            Args:
                watchlist_screening_create_request (WatchlistScreeningCreateRequest):

            Keyword Args:
                _return_http_data_only (bool): response data without head status
                    code and headers. Default is True.
                _preload_content (bool): if False, the urllib3.HTTPResponse object
                    will be returned without reading/decoding response data.
                    Default is True.
                _request_timeout (float/tuple): timeout setting for this request. If one
                    number provided, it will be total request timeout. It can also
                    be a pair (tuple) of (connection, read) timeouts.
                    Default is None.
                _check_input_type (bool): specifies if type checking
                    should be done one the data sent to the server.
                    Default is True.
                _check_return_type (bool): specifies if type checking
                    should be done one the data received from the server.
                    Default is True.
                _host_index (int/None): specifies the index of the server
                    that we want to use.
                    Default is read from the configuration.
                async_req (bool): execute request asynchronously

            Returns:
                WatchlistScreeningIndividualResponse
                    If the method is called asynchronously, returns the request
                    thread.
            """
            kwargs['async_req'] = kwargs.get(
                'async_req', False
            )
            kwargs['_return_http_data_only'] = kwargs.get(
                '_return_http_data_only', True
            )
            kwargs['_preload_content'] = kwargs.get(
                '_preload_content', True
            )
            kwargs['_request_timeout'] = kwargs.get(
                '_request_timeout', None
            )
            kwargs['_check_input_type'] = kwargs.get(
                '_check_input_type', True
            )
            kwargs['_check_return_type'] = kwargs.get(
                '_check_return_type', True
            )
            kwargs['_host_index'] = kwargs.get('_host_index')
            kwargs['watchlist_screening_create_request'] = \
                watchlist_screening_create_request
            return self.call_with_http_info(**kwargs)

        self.watchlist_screening_individual_create = _Endpoint(
            settings={
                'response_type': (WatchlistScreeningIndividualResponse,),
                'auth': [
                    'clientId',
                    'plaidVersion',
                    'secret'
                ],
                'endpoint_path': '/watchlist_screening/individual/create',
                'operation_id': 'watchlist_screening_individual_create',
                'http_method': 'POST',
                'servers': None,
            },
            params_map={
                'all': [
                    'watchlist_screening_create_request',
                ],
                'required': [
                    'watchlist_screening_create_request',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'watchlist_screening_create_request':
                        (WatchlistScreeningCreateRequest,),
                },
                'attribute_map': {
                },
                'location_map': {
                    'watchlist_screening_create_request': 'body',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [
                    'application/json'
                ]
            },
            api_client=api_client,
            callable=__watchlist_screening_individual_create
        )

        def __watchlist_screening_individual_get(
            self,
            get_individual_watchlist_screening_request,
            **kwargs
        ):
            """Retrieve an individual watchlist screening  # noqa: E501

            Retrieve a previously created individual watchlist screening  # noqa: E501
            This method makes a synchronous HTTP request by default. To make an
            asynchronous HTTP request, please pass async_req=True

            >>> thread = api.watchlist_screening_individual_get(get_individual_watchlist_screening_request, async_req=True)
            >>> result = thread.get()

            Args:
                get_individual_watchlist_screening_request (GetIndividualWatchlistScreeningRequest):

            Keyword Args:
                _return_http_data_only (bool): response data without head status
                    code and headers. Default is True.
                _preload_content (bool): if False, the urllib3.HTTPResponse object
                    will be returned without reading/decoding response data.
                    Default is True.
                _request_timeout (float/tuple): timeout setting for this request. If one
                    number provided, it will be total request timeout. It can also
                    be a pair (tuple) of (connection, read) timeouts.
                    Default is None.
                _check_input_type (bool): specifies if type checking
                    should be done one the data sent to the server.
                    Default is True.
                _check_return_type (bool): specifies if type checking
                    should be done one the data received from the server.
                    Default is True.
                _host_index (int/None): specifies the index of the server
                    that we want to use.
                    Default is read from the configuration.
                async_req (bool): execute request asynchronously

            Returns:
                WatchlistScreeningIndividualResponse
                    If the method is called asynchronously, returns the request
                    thread.
            """
            kwargs['async_req'] = kwargs.get(
                'async_req', False
            )
            kwargs['_return_http_data_only'] = kwargs.get(
                '_return_http_data_only', True
            )
            kwargs['_preload_content'] = kwargs.get(
                '_preload_content', True
            )
            kwargs['_request_timeout'] = kwargs.get(
                '_request_timeout', None
            )
            kwargs['_check_input_type'] = kwargs.get(
                '_check_input_type', True
            )
            kwargs['_check_return_type'] = kwargs.get(
                '_check_return_type', True
            )
            kwargs['_host_index'] = kwargs.get('_host_index')
            kwargs['get_individual_watchlist_screening_request'] = \
                get_individual_watchlist_screening_request
            return self.call_with_http_info(**kwargs)

        self.watchlist_screening_individual_get = _Endpoint(
            settings={
                'response_type': (WatchlistScreeningIndividualResponse,),
                'auth': [
                    'clientId',
                    'plaidVersion',
                    'secret'
                ],
                'endpoint_path': '/watchlist_screening/individual/get',
                'operation_id': 'watchlist_screening_individual_get',
                'http_method': 'POST',
                'servers': None,
            },
            params_map={
                'all': [
                    'get_individual_watchlist_screening_request',
                ],
                'required': [
                    'get_individual_watchlist_screening_request',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'get_individual_watchlist_screening_request':
                        (GetIndividualWatchlistScreeningRequest,),
                },
                'attribute_map': {
                },
                'location_map': {
                    'get_individual_watchlist_screening_request': 'body',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [
                    'application/json'
                ]
            },
            api_client=api_client,
            callable=__watchlist_screening_individual_get
        )

        def __watchlist_screening_individual_history_list(
            self,
            list_watchlist_screening_individual_history_request,
            **kwargs
        ):
            """List history for individual watchlist screenings  # noqa: E501

            List all changes to the individual watchlist screening in reverse-chronological order. If the watchlist screening has not been edited, no history will be returned.  # noqa: E501
            This method makes a synchronous HTTP request by default. To make an
            asynchronous HTTP request, please pass async_req=True

            >>> thread = api.watchlist_screening_individual_history_list(list_watchlist_screening_individual_history_request, async_req=True)
            >>> result = thread.get()

            Args:
                list_watchlist_screening_individual_history_request (ListWatchlistScreeningIndividualHistoryRequest):

            Keyword Args:
                _return_http_data_only (bool): response data without head status
                    code and headers. Default is True.
                _preload_content (bool): if False, the urllib3.HTTPResponse object
                    will be returned without reading/decoding response data.
                    Default is True.
                _request_timeout (float/tuple): timeout setting for this request. If one
                    number provided, it will be total request timeout. It can also
                    be a pair (tuple) of (connection, read) timeouts.
                    Default is None.
                _check_input_type (bool): specifies if type checking
                    should be done one the data sent to the server.
                    Default is True.
                _check_return_type (bool): specifies if type checking
                    should be done one the data received from the server.
                    Default is True.
                _host_index (int/None): specifies the index of the server
                    that we want to use.
                    Default is read from the configuration.
                async_req (bool): execute request asynchronously

            Returns:
                PaginatedIndividualWatchlistScreeningListResponse
                    If the method is called asynchronously, returns the request
                    thread.
            """
            kwargs['async_req'] = kwargs.get(
                'async_req', False
            )
            kwargs['_return_http_data_only'] = kwargs.get(
                '_return_http_data_only', True
            )
            kwargs['_preload_content'] = kwargs.get(
                '_preload_content', True
            )
            kwargs['_request_timeout'] = kwargs.get(
                '_request_timeout', None
            )
            kwargs['_check_input_type'] = kwargs.get(
                '_check_input_type', True
            )
            kwargs['_check_return_type'] = kwargs.get(
                '_check_return_type', True
            )
            kwargs['_host_index'] = kwargs.get('_host_index')
            kwargs['list_watchlist_screening_individual_history_request'] = \
                list_watchlist_screening_individual_history_request
            return self.call_with_http_info(**kwargs)

        self.watchlist_screening_individual_history_list = _Endpoint(
            settings={
                'response_type': (PaginatedIndividualWatchlistScreeningListResponse,),
                'auth': [
                    'clientId',
                    'plaidVersion',
                    'secret'
                ],
                'endpoint_path': '/watchlist_screening/individual/history/list',
                'operation_id': 'watchlist_screening_individual_history_list',
                'http_method': 'POST',
                'servers': None,
            },
            params_map={
                'all': [
                    'list_watchlist_screening_individual_history_request',
                ],
                'required': [
                    'list_watchlist_screening_individual_history_request',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'list_watchlist_screening_individual_history_request':
                        (ListWatchlistScreeningIndividualHistoryRequest,),
                },
                'attribute_map': {
                },
                'location_map': {
                    'list_watchlist_screening_individual_history_request': 'body',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [
                    'application/json'
                ]
            },
            api_client=api_client,
            callable=__watchlist_screening_individual_history_list
        )

        def __watchlist_screening_individual_hit_list(
            self,
            list_watchlist_screening_individual_hit_request,
            **kwargs
        ):
            """List hits for individual watchlist screening  # noqa: E501

            List all hits found by Plaid for a particular individual watchlist screening.  # noqa: E501
            This method makes a synchronous HTTP request by default. To make an
            asynchronous HTTP request, please pass async_req=True

            >>> thread = api.watchlist_screening_individual_hit_list(list_watchlist_screening_individual_hit_request, async_req=True)
            >>> result = thread.get()

            Args:
                list_watchlist_screening_individual_hit_request (ListWatchlistScreeningIndividualHitRequest):

            Keyword Args:
                _return_http_data_only (bool): response data without head status
                    code and headers. Default is True.
                _preload_content (bool): if False, the urllib3.HTTPResponse object
                    will be returned without reading/decoding response data.
                    Default is True.
                _request_timeout (float/tuple): timeout setting for this request. If one
                    number provided, it will be total request timeout. It can also
                    be a pair (tuple) of (connection, read) timeouts.
                    Default is None.
                _check_input_type (bool): specifies if type checking
                    should be done one the data sent to the server.
                    Default is True.
                _check_return_type (bool): specifies if type checking
                    should be done one the data received from the server.
                    Default is True.
                _host_index (int/None): specifies the index of the server
                    that we want to use.
                    Default is read from the configuration.
                async_req (bool): execute request asynchronously

            Returns:
                PaginatedIndividualWatchlistScreeningHitListResponse
                    If the method is called asynchronously, returns the request
                    thread.
            """
            kwargs['async_req'] = kwargs.get(
                'async_req', False
            )
            kwargs['_return_http_data_only'] = kwargs.get(
                '_return_http_data_only', True
            )
            kwargs['_preload_content'] = kwargs.get(
                '_preload_content', True
            )
            kwargs['_request_timeout'] = kwargs.get(
                '_request_timeout', None
            )
            kwargs['_check_input_type'] = kwargs.get(
                '_check_input_type', True
            )
            kwargs['_check_return_type'] = kwargs.get(
                '_check_return_type', True
            )
            kwargs['_host_index'] = kwargs.get('_host_index')
            kwargs['list_watchlist_screening_individual_hit_request'] = \
                list_watchlist_screening_individual_hit_request
            return self.call_with_http_info(**kwargs)

        self.watchlist_screening_individual_hit_list = _Endpoint(
            settings={
                'response_type': (PaginatedIndividualWatchlistScreeningHitListResponse,),
                'auth': [
                    'clientId',
                    'plaidVersion',
                    'secret'
                ],
                'endpoint_path': '/watchlist_screening/individual/hit/list',
                'operation_id': 'watchlist_screening_individual_hit_list',
                'http_method': 'POST',
                'servers': None,
            },
            params_map={
                'all': [
                    'list_watchlist_screening_individual_hit_request',
                ],
                'required': [
                    'list_watchlist_screening_individual_hit_request',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'list_watchlist_screening_individual_hit_request':
                        (ListWatchlistScreeningIndividualHitRequest,),
                },
                'attribute_map': {
                },
                'location_map': {
                    'list_watchlist_screening_individual_hit_request': 'body',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [
                    'application/json'
                ]
            },
            api_client=api_client,
            callable=__watchlist_screening_individual_hit_list
        )

        def __watchlist_screening_individual_list(
            self,
            list_individual_watchlist_screening_request,
            **kwargs
        ):
            """List Individual Watchlist Screenings  # noqa: E501

            List previously created watchlist screenings for individuals  # noqa: E501
            This method makes a synchronous HTTP request by default. To make an
            asynchronous HTTP request, please pass async_req=True

            >>> thread = api.watchlist_screening_individual_list(list_individual_watchlist_screening_request, async_req=True)
            >>> result = thread.get()

            Args:
                list_individual_watchlist_screening_request (ListIndividualWatchlistScreeningRequest):

            Keyword Args:
                _return_http_data_only (bool): response data without head status
                    code and headers. Default is True.
                _preload_content (bool): if False, the urllib3.HTTPResponse object
                    will be returned without reading/decoding response data.
                    Default is True.
                _request_timeout (float/tuple): timeout setting for this request. If one
                    number provided, it will be total request timeout. It can also
                    be a pair (tuple) of (connection, read) timeouts.
                    Default is None.
                _check_input_type (bool): specifies if type checking
                    should be done one the data sent to the server.
                    Default is True.
                _check_return_type (bool): specifies if type checking
                    should be done one the data received from the server.
                    Default is True.
                _host_index (int/None): specifies the index of the server
                    that we want to use.
                    Default is read from the configuration.
                async_req (bool): execute request asynchronously

            Returns:
                PaginatedIndividualWatchlistScreeningListResponse
                    If the method is called asynchronously, returns the request
                    thread.
            """
            kwargs['async_req'] = kwargs.get(
                'async_req', False
            )
            kwargs['_return_http_data_only'] = kwargs.get(
                '_return_http_data_only', True
            )
            kwargs['_preload_content'] = kwargs.get(
                '_preload_content', True
            )
            kwargs['_request_timeout'] = kwargs.get(
                '_request_timeout', None
            )
            kwargs['_check_input_type'] = kwargs.get(
                '_check_input_type', True
            )
            kwargs['_check_return_type'] = kwargs.get(
                '_check_return_type', True
            )
            kwargs['_host_index'] = kwargs.get('_host_index')
            kwargs['list_individual_watchlist_screening_request'] = \
                list_individual_watchlist_screening_request
            return self.call_with_http_info(**kwargs)

        self.watchlist_screening_individual_list = _Endpoint(
            settings={
                'response_type': (PaginatedIndividualWatchlistScreeningListResponse,),
                'auth': [
                    'clientId',
                    'plaidVersion',
                    'secret'
                ],
                'endpoint_path': '/watchlist_screening/individual/list',
                'operation_id': 'watchlist_screening_individual_list',
                'http_method': 'POST',
                'servers': None,
            },
            params_map={
                'all': [
                    'list_individual_watchlist_screening_request',
                ],
                'required': [
                    'list_individual_watchlist_screening_request',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'list_individual_watchlist_screening_request':
                        (ListIndividualWatchlistScreeningRequest,),
                },
                'attribute_map': {
                },
                'location_map': {
                    'list_individual_watchlist_screening_request': 'body',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [
                    'application/json'
                ]
            },
            api_client=api_client,
            callable=__watchlist_screening_individual_list
        )

        def __watchlist_screening_individual_program_get(
            self,
            get_watchlist_screening_individual_program_request,
            **kwargs
        ):
            """Get individual watchlist screening program  # noqa: E501

            Get an individual watchlist screening program  # noqa: E501
            This method makes a synchronous HTTP request by default. To make an
            asynchronous HTTP request, please pass async_req=True

            >>> thread = api.watchlist_screening_individual_program_get(get_watchlist_screening_individual_program_request, async_req=True)
            >>> result = thread.get()

            Args:
                get_watchlist_screening_individual_program_request (GetWatchlistScreeningIndividualProgramRequest):

            Keyword Args:
                _return_http_data_only (bool): response data without head status
                    code and headers. Default is True.
                _preload_content (bool): if False, the urllib3.HTTPResponse object
                    will be returned without reading/decoding response data.
                    Default is True.
                _request_timeout (float/tuple): timeout setting for this request. If one
                    number provided, it will be total request timeout. It can also
                    be a pair (tuple) of (connection, read) timeouts.
                    Default is None.
                _check_input_type (bool): specifies if type checking
                    should be done one the data sent to the server.
                    Default is True.
                _check_return_type (bool): specifies if type checking
                    should be done one the data received from the server.
                    Default is True.
                _host_index (int/None): specifies the index of the server
                    that we want to use.
                    Default is read from the configuration.
                async_req (bool): execute request asynchronously

            Returns:
                IndividualWatchlistProgramResponse
                    If the method is called asynchronously, returns the request
                    thread.
            """
            kwargs['async_req'] = kwargs.get(
                'async_req', False
            )
            kwargs['_return_http_data_only'] = kwargs.get(
                '_return_http_data_only', True
            )
            kwargs['_preload_content'] = kwargs.get(
                '_preload_content', True
            )
            kwargs['_request_timeout'] = kwargs.get(
                '_request_timeout', None
            )
            kwargs['_check_input_type'] = kwargs.get(
                '_check_input_type', True
            )
            kwargs['_check_return_type'] = kwargs.get(
                '_check_return_type', True
            )
            kwargs['_host_index'] = kwargs.get('_host_index')
            kwargs['get_watchlist_screening_individual_program_request'] = \
                get_watchlist_screening_individual_program_request
            return self.call_with_http_info(**kwargs)

        self.watchlist_screening_individual_program_get = _Endpoint(
            settings={
                'response_type': (IndividualWatchlistProgramResponse,),
                'auth': [
                    'clientId',
                    'plaidVersion',
                    'secret'
                ],
                'endpoint_path': '/watchlist_screening/individual/program/get',
                'operation_id': 'watchlist_screening_individual_program_get',
                'http_method': 'POST',
                'servers': None,
            },
            params_map={
                'all': [
                    'get_watchlist_screening_individual_program_request',
                ],
                'required': [
                    'get_watchlist_screening_individual_program_request',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'get_watchlist_screening_individual_program_request':
                        (GetWatchlistScreeningIndividualProgramRequest,),
                },
                'attribute_map': {
                },
                'location_map': {
                    'get_watchlist_screening_individual_program_request': 'body',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [
                    'application/json'
                ]
            },
            api_client=api_client,
            callable=__watchlist_screening_individual_program_get
        )

        def __watchlist_screening_individual_program_list(
            self,
            list_watchlist_screening_individual_programs_request,
            **kwargs
        ):
            """List individual watchlist screening programs  # noqa: E501

            List all individual watchlist screening programs  # noqa: E501
            This method makes a synchronous HTTP request by default. To make an
            asynchronous HTTP request, please pass async_req=True

            >>> thread = api.watchlist_screening_individual_program_list(list_watchlist_screening_individual_programs_request, async_req=True)
            >>> result = thread.get()

            Args:
                list_watchlist_screening_individual_programs_request (ListWatchlistScreeningIndividualProgramsRequest):

            Keyword Args:
                _return_http_data_only (bool): response data without head status
                    code and headers. Default is True.
                _preload_content (bool): if False, the urllib3.HTTPResponse object
                    will be returned without reading/decoding response data.
                    Default is True.
                _request_timeout (float/tuple): timeout setting for this request. If one
                    number provided, it will be total request timeout. It can also
                    be a pair (tuple) of (connection, read) timeouts.
                    Default is None.
                _check_input_type (bool): specifies if type checking
                    should be done one the data sent to the server.
                    Default is True.
                _check_return_type (bool): specifies if type checking
                    should be done one the data received from the server.
                    Default is True.
                _host_index (int/None): specifies the index of the server
                    that we want to use.
                    Default is read from the configuration.
                async_req (bool): execute request asynchronously

            Returns:
                PaginatedIndividualWatchlistProgramListResponse
                    If the method is called asynchronously, returns the request
                    thread.
            """
            kwargs['async_req'] = kwargs.get(
                'async_req', False
            )
            kwargs['_return_http_data_only'] = kwargs.get(
                '_return_http_data_only', True
            )
            kwargs['_preload_content'] = kwargs.get(
                '_preload_content', True
            )
            kwargs['_request_timeout'] = kwargs.get(
                '_request_timeout', None
            )
            kwargs['_check_input_type'] = kwargs.get(
                '_check_input_type', True
            )
            kwargs['_check_return_type'] = kwargs.get(
                '_check_return_type', True
            )
            kwargs['_host_index'] = kwargs.get('_host_index')
            kwargs['list_watchlist_screening_individual_programs_request'] = \
                list_watchlist_screening_individual_programs_request
            return self.call_with_http_info(**kwargs)

        self.watchlist_screening_individual_program_list = _Endpoint(
            settings={
                'response_type': (PaginatedIndividualWatchlistProgramListResponse,),
                'auth': [
                    'clientId',
                    'plaidVersion',
                    'secret'
                ],
                'endpoint_path': '/watchlist_screening/individual/program/list',
                'operation_id': 'watchlist_screening_individual_program_list',
                'http_method': 'POST',
                'servers': None,
            },
            params_map={
                'all': [
                    'list_watchlist_screening_individual_programs_request',
                ],
                'required': [
                    'list_watchlist_screening_individual_programs_request',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'list_watchlist_screening_individual_programs_request':
                        (ListWatchlistScreeningIndividualProgramsRequest,),
                },
                'attribute_map': {
                },
                'location_map': {
                    'list_watchlist_screening_individual_programs_request': 'body',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [
                    'application/json'
                ]
            },
            api_client=api_client,
            callable=__watchlist_screening_individual_program_list
        )

        def __watchlist_screening_individual_review_create(
            self,
            create_individual_watchlist_screening_review_request,
            **kwargs
        ):
            """Create a review for an individual watchlist screening  # noqa: E501

            Create a review for the individual watchlist screening. Reviews are compliance reports created by users in your organization regarding the relevance of potential hits found by Plaid.  # noqa: E501
            This method makes a synchronous HTTP request by default. To make an
            asynchronous HTTP request, please pass async_req=True

            >>> thread = api.watchlist_screening_individual_review_create(create_individual_watchlist_screening_review_request, async_req=True)
            >>> result = thread.get()

            Args:
                create_individual_watchlist_screening_review_request (CreateIndividualWatchlistScreeningReviewRequest):

            Keyword Args:
                _return_http_data_only (bool): response data without head status
                    code and headers. Default is True.
                _preload_content (bool): if False, the urllib3.HTTPResponse object
                    will be returned without reading/decoding response data.
                    Default is True.
                _request_timeout (float/tuple): timeout setting for this request. If one
                    number provided, it will be total request timeout. It can also
                    be a pair (tuple) of (connection, read) timeouts.
                    Default is None.
                _check_input_type (bool): specifies if type checking
                    should be done one the data sent to the server.
                    Default is True.
                _check_return_type (bool): specifies if type checking
                    should be done one the data received from the server.
                    Default is True.
                _host_index (int/None): specifies the index of the server
                    that we want to use.
                    Default is read from the configuration.
                async_req (bool): execute request asynchronously

            Returns:
                WatchlistScreeningReviewResponse
                    If the method is called asynchronously, returns the request
                    thread.
            """
            kwargs['async_req'] = kwargs.get(
                'async_req', False
            )
            kwargs['_return_http_data_only'] = kwargs.get(
                '_return_http_data_only', True
            )
            kwargs['_preload_content'] = kwargs.get(
                '_preload_content', True
            )
            kwargs['_request_timeout'] = kwargs.get(
                '_request_timeout', None
            )
            kwargs['_check_input_type'] = kwargs.get(
                '_check_input_type', True
            )
            kwargs['_check_return_type'] = kwargs.get(
                '_check_return_type', True
            )
            kwargs['_host_index'] = kwargs.get('_host_index')
            kwargs['create_individual_watchlist_screening_review_request'] = \
                create_individual_watchlist_screening_review_request
            return self.call_with_http_info(**kwargs)

        self.watchlist_screening_individual_review_create = _Endpoint(
            settings={
                'response_type': (WatchlistScreeningReviewResponse,),
                'auth': [
                    'clientId',
                    'plaidVersion',
                    'secret'
                ],
                'endpoint_path': '/watchlist_screening/individual/review/create',
                'operation_id': 'watchlist_screening_individual_review_create',
                'http_method': 'POST',
                'servers': None,
            },
            params_map={
                'all': [
                    'create_individual_watchlist_screening_review_request',
                ],
                'required': [
                    'create_individual_watchlist_screening_review_request',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'create_individual_watchlist_screening_review_request':
                        (CreateIndividualWatchlistScreeningReviewRequest,),
                },
                'attribute_map': {
                },
                'location_map': {
                    'create_individual_watchlist_screening_review_request': 'body',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [
                    'application/json'
                ]
            },
            api_client=api_client,
            callable=__watchlist_screening_individual_review_create
        )

        def __watchlist_screening_individual_reviews_list(
            self,
            list_watchlist_screening_individual_reviews_request,
            **kwargs
        ):
            """List reviews for individual watchlist screenings  # noqa: E501

            List all reviews for the individual watchlist screening.  # noqa: E501
            This method makes a synchronous HTTP request by default. To make an
            asynchronous HTTP request, please pass async_req=True

            >>> thread = api.watchlist_screening_individual_reviews_list(list_watchlist_screening_individual_reviews_request, async_req=True)
            >>> result = thread.get()

            Args:
                list_watchlist_screening_individual_reviews_request (ListWatchlistScreeningIndividualReviewsRequest):

            Keyword Args:
                _return_http_data_only (bool): response data without head status
                    code and headers. Default is True.
                _preload_content (bool): if False, the urllib3.HTTPResponse object
                    will be returned without reading/decoding response data.
                    Default is True.
                _request_timeout (float/tuple): timeout setting for this request. If one
                    number provided, it will be total request timeout. It can also
                    be a pair (tuple) of (connection, read) timeouts.
                    Default is None.
                _check_input_type (bool): specifies if type checking
                    should be done one the data sent to the server.
                    Default is True.
                _check_return_type (bool): specifies if type checking
                    should be done one the data received from the server.
                    Default is True.
                _host_index (int/None): specifies the index of the server
                    that we want to use.
                    Default is read from the configuration.
                async_req (bool): execute request asynchronously

            Returns:
                PaginatedIndividualWatchlistScreeningReviewListResponse
                    If the method is called asynchronously, returns the request
                    thread.
            """
            kwargs['async_req'] = kwargs.get(
                'async_req', False
            )
            kwargs['_return_http_data_only'] = kwargs.get(
                '_return_http_data_only', True
            )
            kwargs['_preload_content'] = kwargs.get(
                '_preload_content', True
            )
            kwargs['_request_timeout'] = kwargs.get(
                '_request_timeout', None
            )
            kwargs['_check_input_type'] = kwargs.get(
                '_check_input_type', True
            )
            kwargs['_check_return_type'] = kwargs.get(
                '_check_return_type', True
            )
            kwargs['_host_index'] = kwargs.get('_host_index')
            kwargs['list_watchlist_screening_individual_reviews_request'] = \
                list_watchlist_screening_individual_reviews_request
            return self.call_with_http_info(**kwargs)

        self.watchlist_screening_individual_reviews_list = _Endpoint(
            settings={
                'response_type': (PaginatedIndividualWatchlistScreeningReviewListResponse,),
                'auth': [
                    'clientId',
                    'plaidVersion',
                    'secret'
                ],
                'endpoint_path': '/watchlist_screening/individual/review/list',
                'operation_id': 'watchlist_screening_individual_reviews_list',
                'http_method': 'POST',
                'servers': None,
            },
            params_map={
                'all': [
                    'list_watchlist_screening_individual_reviews_request',
                ],
                'required': [
                    'list_watchlist_screening_individual_reviews_request',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'list_watchlist_screening_individual_reviews_request':
                        (ListWatchlistScreeningIndividualReviewsRequest,),
                },
                'attribute_map': {
                },
                'location_map': {
                    'list_watchlist_screening_individual_reviews_request': 'body',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [
                    'application/json'
                ]
            },
            api_client=api_client,
            callable=__watchlist_screening_individual_reviews_list
        )

        def __watchlist_screening_individual_update(
            self,
            update_individual_screening_request,
            **kwargs
        ):
            """Update individual watchlist screening  # noqa: E501

            Update a specific individual watchlist screening. This endpoint can be used to add additional customer information, correct outdated information, add a reference id, assign the individual to a reviewer, and update which program it is associated with. Please note that you may not update `search_terms` and `status` at the same time since editing `search_terms` may trigger an automatic `status` change.  # noqa: E501
            This method makes a synchronous HTTP request by default. To make an
            asynchronous HTTP request, please pass async_req=True

            >>> thread = api.watchlist_screening_individual_update(update_individual_screening_request, async_req=True)
            >>> result = thread.get()

            Args:
                update_individual_screening_request (UpdateIndividualScreeningRequest):

            Keyword Args:
                _return_http_data_only (bool): response data without head status
                    code and headers. Default is True.
                _preload_content (bool): if False, the urllib3.HTTPResponse object
                    will be returned without reading/decoding response data.
                    Default is True.
                _request_timeout (float/tuple): timeout setting for this request. If one
                    number provided, it will be total request timeout. It can also
                    be a pair (tuple) of (connection, read) timeouts.
                    Default is None.
                _check_input_type (bool): specifies if type checking
                    should be done one the data sent to the server.
                    Default is True.
                _check_return_type (bool): specifies if type checking
                    should be done one the data received from the server.
                    Default is True.
                _host_index (int/None): specifies the index of the server
                    that we want to use.
                    Default is read from the configuration.
                async_req (bool): execute request asynchronously

            Returns:
                WatchlistScreeningIndividualResponse
                    If the method is called asynchronously, returns the request
                    thread.
            """
            kwargs['async_req'] = kwargs.get(
                'async_req', False
            )
            kwargs['_return_http_data_only'] = kwargs.get(
                '_return_http_data_only', True
            )
            kwargs['_preload_content'] = kwargs.get(
                '_preload_content', True
            )
            kwargs['_request_timeout'] = kwargs.get(
                '_request_timeout', None
            )
            kwargs['_check_input_type'] = kwargs.get(
                '_check_input_type', True
            )
            kwargs['_check_return_type'] = kwargs.get(
                '_check_return_type', True
            )
            kwargs['_host_index'] = kwargs.get('_host_index')
            kwargs['update_individual_screening_request'] = \
                update_individual_screening_request
            return self.call_with_http_info(**kwargs)

        self.watchlist_screening_individual_update = _Endpoint(
            settings={
                'response_type': (WatchlistScreeningIndividualResponse,),
                'auth': [
                    'clientId',
                    'plaidVersion',
                    'secret'
                ],
                'endpoint_path': '/watchlist_screening/individual/update',
                'operation_id': 'watchlist_screening_individual_update',
                'http_method': 'POST',
                'servers': None,
            },
            params_map={
                'all': [
                    'update_individual_screening_request',
                ],
                'required': [
                    'update_individual_screening_request',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'update_individual_screening_request':
                        (UpdateIndividualScreeningRequest,),
                },
                'attribute_map': {
                },
                'location_map': {
                    'update_individual_screening_request': 'body',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [
                    'application/json'
                ]
            },
            api_client=api_client,
            callable=__watchlist_screening_individual_update
        )

        def __webhook_verification_key_get(
            self,
            webhook_verification_key_get_request,
            **kwargs
        ):
            """Get webhook verification key  # noqa: E501

            Plaid signs all outgoing webhooks and provides JSON Web Tokens (JWTs) so that you can verify the authenticity of any incoming webhooks to your application. A message signature is included in the `Plaid-Verification` header.  The `/webhook_verification_key/get` endpoint provides a JSON Web Key (JWK) that can be used to verify a JWT.  # noqa: E501
            This method makes a synchronous HTTP request by default. To make an
            asynchronous HTTP request, please pass async_req=True

            >>> thread = api.webhook_verification_key_get(webhook_verification_key_get_request, async_req=True)
            >>> result = thread.get()

            Args:
                webhook_verification_key_get_request (WebhookVerificationKeyGetRequest):

            Keyword Args:
                _return_http_data_only (bool): response data without head status
                    code and headers. Default is True.
                _preload_content (bool): if False, the urllib3.HTTPResponse object
                    will be returned without reading/decoding response data.
                    Default is True.
                _request_timeout (float/tuple): timeout setting for this request. If one
                    number provided, it will be total request timeout. It can also
                    be a pair (tuple) of (connection, read) timeouts.
                    Default is None.
                _check_input_type (bool): specifies if type checking
                    should be done one the data sent to the server.
                    Default is True.
                _check_return_type (bool): specifies if type checking
                    should be done one the data received from the server.
                    Default is True.
                _host_index (int/None): specifies the index of the server
                    that we want to use.
                    Default is read from the configuration.
                async_req (bool): execute request asynchronously

            Returns:
                WebhookVerificationKeyGetResponse
                    If the method is called asynchronously, returns the request
                    thread.
            """
            kwargs['async_req'] = kwargs.get(
                'async_req', False
            )
            kwargs['_return_http_data_only'] = kwargs.get(
                '_return_http_data_only', True
            )
            kwargs['_preload_content'] = kwargs.get(
                '_preload_content', True
            )
            kwargs['_request_timeout'] = kwargs.get(
                '_request_timeout', None
            )
            kwargs['_check_input_type'] = kwargs.get(
                '_check_input_type', True
            )
            kwargs['_check_return_type'] = kwargs.get(
                '_check_return_type', True
            )
            kwargs['_host_index'] = kwargs.get('_host_index')
            kwargs['webhook_verification_key_get_request'] = \
                webhook_verification_key_get_request
            return self.call_with_http_info(**kwargs)

        self.webhook_verification_key_get = _Endpoint(
            settings={
                'response_type': (WebhookVerificationKeyGetResponse,),
                'auth': [
                    'clientId',
                    'plaidVersion',
                    'secret'
                ],
                'endpoint_path': '/webhook_verification_key/get',
                'operation_id': 'webhook_verification_key_get',
                'http_method': 'POST',
                'servers': None,
            },
            params_map={
                'all': [
                    'webhook_verification_key_get_request',
                ],
                'required': [
                    'webhook_verification_key_get_request',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'webhook_verification_key_get_request':
                        (WebhookVerificationKeyGetRequest,),
                },
                'attribute_map': {
                },
                'location_map': {
                    'webhook_verification_key_get_request': 'body',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [
                    'application/json'
                ]
            },
            api_client=api_client,
            callable=__webhook_verification_key_get
        )
