"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.shellOut = void 0;
const child_process_1 = require("child_process");
/**
 * Executes the specified command in a sub-shell, and asserts success.
 */
function shellOut(cmd, ...args) {
    return new Promise((ok, ko) => {
        const child = child_process_1.spawn(cmd, args, { stdio: ['ignore', 'inherit', 'inherit'] });
        child.once('error', ko);
        child.once('close', (code, signal) => {
            if (code === 0) {
                return ok();
            }
            const reason = code != null
                ? `exit code ${code}`
                : `signal ${signal}`;
            ko(new Error(`Command "${cmd} ${args.join(' ')}" failed with ${reason}`));
        });
    });
}
exports.shellOut = shellOut;
//# sourceMappingURL=data:application/json;base64,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