"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.ConstructHub = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const ec2 = require("@aws-cdk/aws-ec2");
const aws_iam_1 = require("@aws-cdk/aws-iam");
const s3 = require("@aws-cdk/aws-s3");
const aws_s3_1 = require("@aws-cdk/aws-s3");
const core_1 = require("@aws-cdk/core");
const backend_1 = require("./backend");
const backend_dashboard_1 = require("./backend-dashboard");
const inventory_1 = require("./backend/inventory");
const license_list_1 = require("./backend/license-list");
const orchestration_1 = require("./backend/orchestration");
const package_stats_1 = require("./backend/package-stats");
const constants_1 = require("./backend/shared/constants");
const repository_1 = require("./codeartifact/repository");
const monitoring_1 = require("./monitoring");
const package_sources_1 = require("./package-sources");
const spdx_license_1 = require("./spdx-license");
const webapp_1 = require("./webapp");
/**
 * (experimental) Construct Hub.
 *
 * @experimental
 */
class ConstructHub extends core_1.Construct {
    /**
     * @experimental
     */
    constructor(scope, id, props = {}) {
        var _b, _c, _d, _e, _f, _g, _h, _j;
        super(scope, id);
        const monitoring = new monitoring_1.Monitoring(this, 'Monitoring', {
            alarmActions: props.alarmActions,
        });
        const packageData = new s3.Bucket(this, 'PackageData', {
            blockPublicAccess: aws_s3_1.BlockPublicAccess.BLOCK_ALL,
            enforceSSL: true,
            encryption: s3.BucketEncryption.S3_MANAGED,
            lifecycleRules: [
                // Abort multi-part uploads after 1 day
                { abortIncompleteMultipartUploadAfter: core_1.Duration.days(1) },
                // Transition non-current object versions to IA after 1 month
                {
                    noncurrentVersionTransitions: [
                        {
                            storageClass: s3.StorageClass.INFREQUENT_ACCESS,
                            transitionAfter: core_1.Duration.days(31),
                        },
                    ],
                },
                // Permanently delete non-current object versions after 3 months
                {
                    noncurrentVersionExpiration: core_1.Duration.days(90),
                    expiredObjectDeleteMarker: true,
                },
                // Permanently delete non-current versions of catalog.json earlier
                { noncurrentVersionExpiration: core_1.Duration.days(7), prefix: constants_1.CATALOG_KEY },
            ],
            versioned: true,
        });
        const codeArtifact = new repository_1.Repository(this, 'CodeArtifact', {
            description: 'Proxy to npmjs.com for ConstructHub',
            domainName: (_b = props.codeArtifactDomain) === null || _b === void 0 ? void 0 : _b.name,
            domainExists: props.codeArtifactDomain != null,
            upstreams: (_c = props.codeArtifactDomain) === null || _c === void 0 ? void 0 : _c.upstreams,
        });
        const { vpc, vpcEndpoints, vpcSubnets } = this.createVpc(props, codeArtifact);
        const denyList = new backend_1.DenyList(this, 'DenyList', {
            rules: (_d = props.denyList) !== null && _d !== void 0 ? _d : [],
            packageDataBucket: packageData,
            packageDataKeyPrefix: constants_1.STORAGE_KEY_PREFIX,
            monitoring: monitoring,
        });
        // disable fetching package stats by default if a different package
        // source is configured
        const fetchPackageStats = (_e = props.fetchPackageStats) !== null && _e !== void 0 ? _e : (props.packageSources ? false : true);
        let packageStats;
        const statsKey = 'stats.json';
        if (fetchPackageStats) {
            packageStats = new package_stats_1.PackageStats(this, 'Stats', {
                bucket: packageData,
                monitoring,
                logRetention: props.logRetention,
                objectKey: statsKey,
            });
        }
        const orchestration = new orchestration_1.Orchestration(this, 'Orchestration', {
            bucket: packageData,
            codeArtifact,
            denyList,
            logRetention: props.logRetention,
            monitoring,
            vpc,
            vpcEndpoints,
            vpcSubnets,
        });
        // rebuild the catalog when the deny list changes.
        denyList.prune.onChangeInvoke(orchestration.catalogBuilder.function);
        const packageTagsSerialized = (_g = (_f = props.packageTags) === null || _f === void 0 ? void 0 : _f.map((config) => {
            return {
                ...config,
                condition: config.condition.bind(),
            };
        })) !== null && _g !== void 0 ? _g : [];
        this.ingestion = new backend_1.Ingestion(this, 'Ingestion', {
            bucket: packageData,
            orchestration,
            logRetention: props.logRetention,
            monitoring,
            packageLinks: props.packageLinks,
            packageTags: packageTagsSerialized,
        });
        const licenseList = new license_list_1.LicenseList(this, 'LicenseList', {
            licenses: (_h = props.allowedLicenses) !== null && _h !== void 0 ? _h : [
                ...spdx_license_1.SpdxLicense.apache(),
                ...spdx_license_1.SpdxLicense.bsd(),
                ...spdx_license_1.SpdxLicense.mit(),
            ],
        });
        const sources = new core_1.Construct(this, 'Sources');
        const packageSources = ((_j = props.packageSources) !== null && _j !== void 0 ? _j : [new package_sources_1.NpmJs()]).map((source) => source.bind(sources, {
            denyList,
            ingestion: this.ingestion,
            licenseList,
            monitoring,
            queue: this.ingestion.queue,
            repository: codeArtifact,
        }));
        const inventory = new inventory_1.Inventory(this, 'InventoryCanary', { bucket: packageData, logRetention: props.logRetention, monitoring });
        new backend_dashboard_1.BackendDashboard(this, 'BackendDashboard', {
            packageData,
            dashboardName: props.backendDashboardName,
            packageSources,
            ingestion: this.ingestion,
            inventory,
            orchestration,
            denyList,
            packageStats,
        });
        new webapp_1.WebApp(this, 'WebApp', {
            domain: props.domain,
            monitoring,
            packageData,
            packageLinks: props.packageLinks,
            packageTags: packageTagsSerialized,
            featuredPackages: props.featuredPackages,
            packageStats,
            featureFlags: props.featureFlags,
        });
    }
    /**
     * (experimental) The principal to grant permissions to.
     *
     * @experimental
     */
    get grantPrincipal() {
        return this.ingestion.grantPrincipal;
    }
    /**
     * @experimental
     */
    get ingestionQueue() {
        return this.ingestion.queue;
    }
    createVpc(props, codeArtifact) {
        if (props.isolateSensitiveTasks === false) {
            return { vpc: undefined, vpcEndpoints: undefined, vpcSubnets: undefined };
        }
        const vpc = new ec2.Vpc(this, 'Lambda-VPC', {
            enableDnsHostnames: true,
            enableDnsSupport: true,
            natGateways: 0,
            // Pre-allocating PUBLIC / PRIVATE / INTERNAL subnets, regardless of use, so we don't create
            // a whole new VPC if we ever need to introduce subnets of these types.
            subnetConfiguration: [
                // If there is a PRIVATE subnet, there must also have a PUBLIC subnet (for NAT gateways).
                { name: 'Public', subnetType: ec2.SubnetType.PUBLIC, reserved: true },
                { name: 'Private', subnetType: ec2.SubnetType.PRIVATE, reserved: true },
                { name: 'Isolated', subnetType: ec2.SubnetType.ISOLATED },
            ],
        });
        const vpcSubnets = { subnetType: ec2.SubnetType.ISOLATED };
        // We'll only use VPC endpoints if we are configured to run in an ISOLATED subnet.
        const vpcEndpoints = {
            codeArtifactApi: vpc.addInterfaceEndpoint('CodeArtifact.API', {
                privateDnsEnabled: false,
                service: new ec2.InterfaceVpcEndpointAwsService('codeartifact.api'),
                subnets: vpcSubnets,
            }),
            codeArtifact: vpc.addInterfaceEndpoint('CodeArtifact', {
                privateDnsEnabled: true,
                service: new ec2.InterfaceVpcEndpointAwsService('codeartifact.repositories'),
                subnets: vpcSubnets,
            }),
            // This is needed so that ECS workloads can use the awslogs driver
            cloudWatchLogs: vpc.addInterfaceEndpoint('CloudWatch.Logs', {
                privateDnsEnabled: true,
                service: ec2.InterfaceVpcEndpointAwsService.CLOUDWATCH_LOGS,
                subnets: vpcSubnets,
            }),
            // These are needed for ECS workloads to be able to pull images
            ecrApi: vpc.addInterfaceEndpoint('ECR.API', {
                privateDnsEnabled: true,
                service: ec2.InterfaceVpcEndpointAwsService.ECR,
                subnets: vpcSubnets,
            }),
            ecr: vpc.addInterfaceEndpoint('ECR.Docker', {
                privateDnsEnabled: true,
                service: ec2.InterfaceVpcEndpointAwsService.ECR_DOCKER,
                subnets: vpcSubnets,
            }),
            // This is needed (among others) for CodeArtifact registry usage
            s3: vpc.addGatewayEndpoint('S3', {
                service: ec2.GatewayVpcEndpointAwsService.S3,
                subnets: [vpcSubnets],
            }),
            // This is useful for getting results from ECS tasks within workflows
            stepFunctions: vpc.addInterfaceEndpoint('StepFunctions', {
                privateDnsEnabled: true,
                service: ec2.InterfaceVpcEndpointAwsService.STEP_FUNCTIONS,
                subnets: vpcSubnets,
            }),
        };
        // The S3 access is necessary for the CodeArtifact Repository and ECR Docker
        // endpoints to be used (they serve objects from S3).
        vpcEndpoints.s3.addToPolicy(new aws_iam_1.PolicyStatement({
            effect: aws_iam_1.Effect.ALLOW,
            actions: ['s3:GetObject'],
            resources: [
                // The in-region CodeArtifact S3 Bucket
                `${codeArtifact.s3BucketArn}/*`,
                // The in-region ECR layer bucket
                `arn:aws:s3:::prod-${core_1.Stack.of(this).region}-starport-layer-bucket/*`,
            ],
            // It doesn't seem we can constrain principals for these grants (unclear
            // which principal those calls are made from, or if that is something we
            // could name here).
            principals: [new aws_iam_1.AnyPrincipal()],
            sid: 'Allow-CodeArtifact-and-ECR',
        }));
        return { vpc, vpcEndpoints, vpcSubnets };
    }
}
exports.ConstructHub = ConstructHub;
_a = JSII_RTTI_SYMBOL_1;
ConstructHub[_a] = { fqn: "construct-hub.ConstructHub", version: "0.2.64" };
//# sourceMappingURL=data:application/json;base64,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