# An open-source Python framework for Browser Automation : browser-automationpy
<p align="center">
  <a href="https://github.com/chandraveshchaudhari/browser-automationpy">
    <img width="60%" height="60%" src="https://raw.githubusercontent.com/browser-automationpy/data/browser-automationpy_logo.png">
  </a>
</p>

- [Introduction](#introduction)
- [Features](#features)
- [Installation](#installation)
- [Contact](#contact)
- [Contribution](#contribution)

## Introduction
The main objective of the Python framework is easily launching custom automated browser. 
This framework doesn't ask you to download any browser binaries. Browser automation is very useful in data mining and 
automation of monotonous work.

### Project Authors
The packages [systematic-reviewpy](https://github.com/chandraveshchaudhari/systematic-reviewpy) and 
[browser-automationpy](https://github.com/chandraveshchaudhari/browser-automationpy) are part of Research paper 
`An open-source Python framework for systematic review based on PRISMA` created by Chandravesh chaudhari, Doctoral 
candidate at christ university, Bangalore under supervision of Dr. Geetanjali purswani. 

> Citation

## Features
- one line code to install all supported browsers.
- easy customisation for browsers such as adding extensions and changing download paths.
- easy methods for clicking buttons or inputting data into web elements.
- support for chrome, safari, mozilla, edge etc.
- No need to download binary.

#### Advantages over manual methods
- Saves time
- Automate monotonous tasks

## Installation 
This project is available at [PyPI](https://github.com/chandraveshchaudhari/browser-automationpy). For help in 
installation check [instructions](https://packaging.python.org/tutorials/installing-packages/#installing-from-pypi)
```bash
python3 -m pip install browser-automationpy  
```

### Dependencies
##### Required
- [webdriver-manager](https://pypi.org/project/webdriver-manager/) - Library provides the way to automatically manage drivers for different browsers
- [selenium](https://pypi.org/project/selenium/) - The selenium package is used to automate web browser interaction from Python.
##### Optional
- [PyAutoGUI](https://pypi.org/project/PyAutoGUI/) - PyAutoGUI lets Python control the mouse and keyboard, and other GUI automation tasks.

## Important links
- [Documentation](documentation link)
- [Quick tour](tutorial file link)
- [Project maintainer (feel free to contact)](mailto:chandraveshchaudhari@gmail.com?subject=[GitHub]%20Source%20browser-automationpy)
- [Future Improvements](https://github.com/chandraveshchaudhari/browser-automationpy/projects)
- [License](https://github.com/chandraveshchaudhari/browser-automationpy/blob/master/LICENSE.txt)

## Contribution
all kinds of contributions are appreciated.
- [Improving readability of documentation](documentation link)
- [Feature Request](https://github.com/chandraveshchaudhari/browser-automationpy/issues/new/choose)
- [Reporting bugs](https://github.com/chandraveshchaudhari/browser-automationpy/issues/new/choose)
- [Contribute code](https://github.com/chandraveshchaudhari/browser-automationpy/compare)
- [Asking questions in discussions](https://github.com/chandraveshchaudhari/browser-automationpy/discussions)
