"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.CfnCluster = exports.toJson_Compute = exports.toJson_DiskGb = exports.toJson_Specs = exports.toJson_AdvancedAutoScaling = exports.toJson_Endpoint = exports.toJson_AdvancedRegionConfig = exports.toJson_PrivateEndpoint = exports.toJson_AdvancedReplicationSpec = exports.toJson_CfnClusterPropsLabels = exports.CfnClusterPropsEncryptionAtRestProvider = exports.toJson_ConnectionStrings = exports.toJson_CfnClusterPropsBiConnector = exports.toJson_ProcessArgs = exports.toJson_CfnClusterProps = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
// Generated by cdk-import
const cdk = require("aws-cdk-lib");
/**
 * Converts an object of type 'CfnClusterProps' to JSON representation.
 */
/* eslint-disable max-len, quote-props */
function toJson_CfnClusterProps(obj) {
    if (obj === undefined) {
        return undefined;
    }
    const result = {
        'AdvancedSettings': toJson_ProcessArgs(obj.advancedSettings),
        'BackupEnabled': obj.backupEnabled,
        'BiConnector': toJson_CfnClusterPropsBiConnector(obj.biConnector),
        'ClusterType': obj.clusterType,
        'ConnectionStrings': toJson_ConnectionStrings(obj.connectionStrings),
        'DiskSizeGB': obj.diskSizeGb,
        'EncryptionAtRestProvider': obj.encryptionAtRestProvider,
        'Profile': obj.profile,
        'ProjectId': obj.projectId,
        'Labels': obj.labels?.map(y => toJson_CfnClusterPropsLabels(y)),
        'MongoDBMajorVersion': obj.mongoDbMajorVersion,
        'Name': obj.name,
        'Paused': obj.paused,
        'PitEnabled': obj.pitEnabled,
        'ReplicationSpecs': obj.replicationSpecs?.map(y => toJson_AdvancedReplicationSpec(y)),
        'RootCertType': obj.rootCertType,
        'VersionReleaseSystem': obj.versionReleaseSystem,
        'TerminationProtectionEnabled': obj.terminationProtectionEnabled,
    };
    // filter undefined values
    return Object.entries(result).reduce((r, i) => (i[1] === undefined) ? r : ({ ...r, [i[0]]: i[1] }), {});
}
exports.toJson_CfnClusterProps = toJson_CfnClusterProps;
/**
 * Converts an object of type 'ProcessArgs' to JSON representation.
 */
/* eslint-disable max-len, quote-props */
function toJson_ProcessArgs(obj) {
    if (obj === undefined) {
        return undefined;
    }
    const result = {
        'DefaultReadConcern': obj.defaultReadConcern,
        'DefaultWriteConcern': obj.defaultWriteConcern,
        'FailIndexKeyTooLong': obj.failIndexKeyTooLong,
        'JavascriptEnabled': obj.javascriptEnabled,
        'MinimumEnabledTLSProtocol': obj.minimumEnabledTlsProtocol,
        'NoTableScan': obj.noTableScan,
        'OplogSizeMB': obj.oplogSizeMb,
        'SampleSizeBIConnector': obj.sampleSizeBiConnector,
        'SampleRefreshIntervalBIConnector': obj.sampleRefreshIntervalBiConnector,
    };
    // filter undefined values
    return Object.entries(result).reduce((r, i) => (i[1] === undefined) ? r : ({ ...r, [i[0]]: i[1] }), {});
}
exports.toJson_ProcessArgs = toJson_ProcessArgs;
/**
 * Converts an object of type 'CfnClusterPropsBiConnector' to JSON representation.
 */
/* eslint-disable max-len, quote-props */
function toJson_CfnClusterPropsBiConnector(obj) {
    if (obj === undefined) {
        return undefined;
    }
    const result = {
        'ReadPreference': obj.readPreference,
        'Enabled': obj.enabled,
    };
    // filter undefined values
    return Object.entries(result).reduce((r, i) => (i[1] === undefined) ? r : ({ ...r, [i[0]]: i[1] }), {});
}
exports.toJson_CfnClusterPropsBiConnector = toJson_CfnClusterPropsBiConnector;
/**
 * Converts an object of type 'ConnectionStrings' to JSON representation.
 */
/* eslint-disable max-len, quote-props */
function toJson_ConnectionStrings(obj) {
    if (obj === undefined) {
        return undefined;
    }
    const result = {
        'Standard': obj.standard,
        'StandardSrv': obj.standardSrv,
        'Private': obj.private,
        'PrivateSrv': obj.privateSrv,
        'PrivateEndpoint': obj.privateEndpoint?.map(y => toJson_PrivateEndpoint(y)),
        'AwsPrivateLinkSrv': obj.awsPrivateLinkSrv,
        'AwsPrivateLink': obj.awsPrivateLink,
    };
    // filter undefined values
    return Object.entries(result).reduce((r, i) => (i[1] === undefined) ? r : ({ ...r, [i[0]]: i[1] }), {});
}
exports.toJson_ConnectionStrings = toJson_ConnectionStrings;
/* eslint-enable max-len, quote-props */
/**
 * Cloud service provider that manages your customer keys to provide an additional layer of encryption at rest for the cluster. To enable customer key management for encryption at rest, the cluster replicationSpecs[n].regionConfigs[m].{type}Specs.instanceSize setting must be M10 or higher and "backupEnabled" : false or omitted entirely.
 *
 * @schema CfnClusterPropsEncryptionAtRestProvider
 */
var CfnClusterPropsEncryptionAtRestProvider;
(function (CfnClusterPropsEncryptionAtRestProvider) {
    /** AWS */
    CfnClusterPropsEncryptionAtRestProvider["AWS"] = "AWS";
    /** GCP */
    CfnClusterPropsEncryptionAtRestProvider["GCP"] = "GCP";
    /** AZURE */
    CfnClusterPropsEncryptionAtRestProvider["AZURE"] = "AZURE";
    /** NONE */
    CfnClusterPropsEncryptionAtRestProvider["NONE"] = "NONE";
})(CfnClusterPropsEncryptionAtRestProvider = exports.CfnClusterPropsEncryptionAtRestProvider || (exports.CfnClusterPropsEncryptionAtRestProvider = {}));
/**
 * Converts an object of type 'CfnClusterPropsLabels' to JSON representation.
 */
/* eslint-disable max-len, quote-props */
function toJson_CfnClusterPropsLabels(obj) {
    if (obj === undefined) {
        return undefined;
    }
    const result = {
        'Key': obj.key,
        'Value': obj.value,
    };
    // filter undefined values
    return Object.entries(result).reduce((r, i) => (i[1] === undefined) ? r : ({ ...r, [i[0]]: i[1] }), {});
}
exports.toJson_CfnClusterPropsLabels = toJson_CfnClusterPropsLabels;
/**
 * Converts an object of type 'AdvancedReplicationSpec' to JSON representation.
 */
/* eslint-disable max-len, quote-props */
function toJson_AdvancedReplicationSpec(obj) {
    if (obj === undefined) {
        return undefined;
    }
    const result = {
        'ID': obj.id,
        'NumShards': obj.numShards,
        'AdvancedRegionConfigs': obj.advancedRegionConfigs?.map(y => toJson_AdvancedRegionConfig(y)),
        'ZoneName': obj.zoneName,
    };
    // filter undefined values
    return Object.entries(result).reduce((r, i) => (i[1] === undefined) ? r : ({ ...r, [i[0]]: i[1] }), {});
}
exports.toJson_AdvancedReplicationSpec = toJson_AdvancedReplicationSpec;
/**
 * Converts an object of type 'PrivateEndpoint' to JSON representation.
 */
/* eslint-disable max-len, quote-props */
function toJson_PrivateEndpoint(obj) {
    if (obj === undefined) {
        return undefined;
    }
    const result = {
        'ConnectionString': obj.connectionString,
        'Endpoints': obj.endpoints?.map(y => toJson_Endpoint(y)),
        'SRVConnectionString': obj.srvConnectionString,
        'Type': obj.type,
    };
    // filter undefined values
    return Object.entries(result).reduce((r, i) => (i[1] === undefined) ? r : ({ ...r, [i[0]]: i[1] }), {});
}
exports.toJson_PrivateEndpoint = toJson_PrivateEndpoint;
/**
 * Converts an object of type 'AdvancedRegionConfig' to JSON representation.
 */
/* eslint-disable max-len, quote-props */
function toJson_AdvancedRegionConfig(obj) {
    if (obj === undefined) {
        return undefined;
    }
    const result = {
        'AnalyticsAutoScaling': toJson_AdvancedAutoScaling(obj.analyticsAutoScaling),
        'AutoScaling': toJson_AdvancedAutoScaling(obj.autoScaling),
        'RegionName': obj.regionName,
        'AnalyticsSpecs': toJson_Specs(obj.analyticsSpecs),
        'ElectableSpecs': toJson_Specs(obj.electableSpecs),
        'Priority': obj.priority,
        'ReadOnlySpecs': toJson_Specs(obj.readOnlySpecs),
    };
    // filter undefined values
    return Object.entries(result).reduce((r, i) => (i[1] === undefined) ? r : ({ ...r, [i[0]]: i[1] }), {});
}
exports.toJson_AdvancedRegionConfig = toJson_AdvancedRegionConfig;
/**
 * Converts an object of type 'Endpoint' to JSON representation.
 */
/* eslint-disable max-len, quote-props */
function toJson_Endpoint(obj) {
    if (obj === undefined) {
        return undefined;
    }
    const result = {
        'EndpointID': obj.endpointId,
        'ProviderName': obj.providerName,
        'Region': obj.region,
    };
    // filter undefined values
    return Object.entries(result).reduce((r, i) => (i[1] === undefined) ? r : ({ ...r, [i[0]]: i[1] }), {});
}
exports.toJson_Endpoint = toJson_Endpoint;
/**
 * Converts an object of type 'AdvancedAutoScaling' to JSON representation.
 */
/* eslint-disable max-len, quote-props */
function toJson_AdvancedAutoScaling(obj) {
    if (obj === undefined) {
        return undefined;
    }
    const result = {
        'DiskGB': toJson_DiskGb(obj.diskGb),
        'Compute': toJson_Compute(obj.compute),
    };
    // filter undefined values
    return Object.entries(result).reduce((r, i) => (i[1] === undefined) ? r : ({ ...r, [i[0]]: i[1] }), {});
}
exports.toJson_AdvancedAutoScaling = toJson_AdvancedAutoScaling;
/**
 * Converts an object of type 'Specs' to JSON representation.
 */
/* eslint-disable max-len, quote-props */
function toJson_Specs(obj) {
    if (obj === undefined) {
        return undefined;
    }
    const result = {
        'DiskIOPS': obj.diskIops,
        'EbsVolumeType': obj.ebsVolumeType,
        'InstanceSize': obj.instanceSize,
        'NodeCount': obj.nodeCount,
    };
    // filter undefined values
    return Object.entries(result).reduce((r, i) => (i[1] === undefined) ? r : ({ ...r, [i[0]]: i[1] }), {});
}
exports.toJson_Specs = toJson_Specs;
/**
 * Converts an object of type 'DiskGb' to JSON representation.
 */
/* eslint-disable max-len, quote-props */
function toJson_DiskGb(obj) {
    if (obj === undefined) {
        return undefined;
    }
    const result = {
        'Enabled': obj.enabled,
    };
    // filter undefined values
    return Object.entries(result).reduce((r, i) => (i[1] === undefined) ? r : ({ ...r, [i[0]]: i[1] }), {});
}
exports.toJson_DiskGb = toJson_DiskGb;
/**
 * Converts an object of type 'Compute' to JSON representation.
 */
/* eslint-disable max-len, quote-props */
function toJson_Compute(obj) {
    if (obj === undefined) {
        return undefined;
    }
    const result = {
        'Enabled': obj.enabled,
        'ScaleDownEnabled': obj.scaleDownEnabled,
        'MinInstanceSize': obj.minInstanceSize,
        'MaxInstanceSize': obj.maxInstanceSize,
    };
    // filter undefined values
    return Object.entries(result).reduce((r, i) => (i[1] === undefined) ? r : ({ ...r, [i[0]]: i[1] }), {});
}
exports.toJson_Compute = toJson_Compute;
/* eslint-enable max-len, quote-props */
/**
 * A CloudFormation `MongoDB::Atlas::Cluster`
 *
 * @cloudformationResource MongoDB::Atlas::Cluster
 * @stability external
 */
class CfnCluster extends cdk.CfnResource {
    /**
     * Create a new `MongoDB::Atlas::Cluster`.
     *
     * @param scope - scope in which this resource is defined
     * @param id    - scoped id of the resource
     * @param props - resource properties
     */
    constructor(scope, id, props) {
        super(scope, id, { type: CfnCluster.CFN_RESOURCE_TYPE_NAME, properties: toJson_CfnClusterProps(props) });
        this.props = props;
        this.attrStateName = cdk.Token.asString(this.getAtt('StateName'));
        this.attrMongoDBVersion = cdk.Token.asString(this.getAtt('MongoDBVersion'));
        this.attrCreatedDate = cdk.Token.asString(this.getAtt('CreatedDate'));
        this.attrId = cdk.Token.asString(this.getAtt('Id'));
    }
}
exports.CfnCluster = CfnCluster;
_a = JSII_RTTI_SYMBOL_1;
CfnCluster[_a] = { fqn: "@mongodbatlas-awscdk/cluster.CfnCluster", version: "1.0.2" };
/**
* The CloudFormation resource type name for this resource class.
*/
CfnCluster.CFN_RESOURCE_TYPE_NAME = 'MongoDB::Atlas::Cluster';
//# sourceMappingURL=data:application/json;base64,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