# Generated by Django 2.2.20 on 2021-05-03 17:09

from django.conf import settings
from django.db import migrations, models
import django.db.models.deletion
import jsonfield.fields


class Migration(migrations.Migration):

    initial = True

    dependencies = [
        migrations.swappable_dependency(settings.AUTH_USER_MODEL),
    ]

    operations = [
        migrations.CreateModel(
            name='OpenIDAgreement',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('text', models.TextField()),
                ('text_en', models.TextField(null=True)),
                ('text_cs', models.TextField(null=True)),
                ('obligatory', models.BooleanField()),
                ('allowed_scopes', jsonfield.fields.JSONField(default=list, verbose_name='List of allowed scopes for this agreement.')),
                ('allowed_claims', jsonfield.fields.JSONField(default=list, verbose_name='List of allowed claims for this agreement')),
                ('username_auto_agreement_regexp', models.CharField(blank=True, max_length=256, null=True, verbose_name='Usernames matching this regexp will have this agreement automatically agreed to')),
            ],
        ),
        migrations.CreateModel(
            name='OpenIDClient',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('client_id', models.CharField(max_length=128, unique=True)),
                ('redirect_uris', models.TextField(default='')),
                ('client_auth_type', models.CharField(choices=[('basic', 'Basic Authentication'), ('post', 'Authentication data in POST request'), ('sjwt', 'JSON Web token with pre-shared secret'), ('pkjwt', 'JSON Web token with public/private key'), ('none', 'No client authentication performed')], max_length=8)),
                ('client_hashed_secret', models.CharField(max_length=128)),
                ('client_code', models.CharField(blank=True, max_length=32, null=True)),
                ('client_name', models.CharField(max_length=128)),
                ('client_name_en', models.CharField(max_length=128, null=True)),
                ('client_name_cs', models.CharField(max_length=128, null=True)),
                ('allowed_scopes', jsonfield.fields.JSONField(blank=True, null=True, verbose_name='List of allowed scopes. If None, all scopes are allowed')),
                ('allowed_claims', jsonfield.fields.JSONField(blank=True, null=True, verbose_name='List of allowed claims. If None, all claims from allowed scopes are returned')),
                ('sub_hash', models.CharField(blank=True, max_length=256, null=True, verbose_name='If set, &lt;&lt;sub&gt;&gt; values (that is, username) will be concatenated with this value and sha256')),
                ('client_registration_data', jsonfield.fields.JSONField(default=dict)),
                ('jwks', models.TextField(default='{}')),
            ],
        ),
        migrations.CreateModel(
            name='OpenIDUserAgreement',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('agreed_on', models.DateTimeField()),
                ('agreed_by_user', models.BooleanField(default=False, verbose_name='If set to False, the agreement was created automatically, otherwise it was created explicitly by user')),
                ('agreement', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, related_name='user_agreements', to='openid_connect_op.OpenIDAgreement')),
                ('user', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, related_name='user_agreements', to=settings.AUTH_USER_MODEL)),
            ],
        ),
        migrations.CreateModel(
            name='OpenIDToken',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('token_hash', models.CharField(max_length=64, unique=True)),
                ('token_type', models.CharField(max_length=4)),
                ('token_data', jsonfield.fields.JSONField(default=dict)),
                ('expiration', models.DateTimeField()),
                ('client', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, to='openid_connect_op.OpenIDClient')),
                ('root_token', models.ForeignKey(blank=True, null=True, on_delete=django.db.models.deletion.PROTECT, related_name='related_tokens', to='openid_connect_op.OpenIDToken')),
                ('user', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, to=settings.AUTH_USER_MODEL)),
            ],
        ),
        migrations.AddField(
            model_name='openidagreement',
            name='client',
            field=models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, related_name='agreements', to='openid_connect_op.OpenIDClient'),
        ),
    ]
