# AUTOGENERATED! DO NOT EDIT! File to edit: 00_core.ipynb (unless otherwise specified).

__all__ = ['prompter']

# Cell

import json, re, pandas as pd, openai
import random, numpy as np
from collections import Counter

# Cell

class prompter():

  def __init__(self, oldPrompter=None):
    """
      To allow for quickly testing new capabilities, the prompter class can just copy itself
      This allows adding new functions to a prompter and then prompting again
    """
    if oldParser:
      self.labeled = oldPrompter.labeled
      self.working = oldPrompter.working
      self.data = oldPrompter.data
    else:
      self.labeled = pd.DataFrame()
      self.working = pd.DataFrame()
      self.data = {}

  def load_newsdata(self, publisher, date):
    """
    loads from my CoverageTrends repo
    publisher is cnn, foxnews, newyorktimes, and a bunch of others
    date is YYYMMDD
    Updated headlines every 30 minutes. Except when it breaks.
    """

    try:
      data = pd.read_csv("https://raw.githubusercontent.com/brockmanmatt/CoverageTrends/master/archived_links/{}/{}/{}_{}.csv".format(publisher, date[:-2], publisher, date))
    except:
      raise

    self.data["{}_{}".format(publisher, date)] = data

  def formatExample(self, example):
    """
    takes example and formats it for me to standard format for gpt to learn
    """
    prompt = "Headline: {}\nEntities: {}\nThemes: {}\n\n".format(example["headlines"].strip(), example["entities"].strip(), example["themes"].strip())
    return prompt

  def createGPTQuery(self, exampleList:[{"headline":str, "people":str, "themes":str}], query):
    """
    takes takes a list of examples and a query and returns for sending to GPT
    """

    prompt = ""
    for example in exampleList:
      prompt += self.formatExample(example)
    prompt += query + "\nEntities:"

    return prompt

  def queryFromDefault(self, query, **kwargs):
    """
      Query's GPT with the query with API kwargs
    """
    examples = [
      {"headlines":"Live updates Americans should 'go out' for holiday, Fauci says", "entities":"Tony Facui, Americans", "themes":"Holidays"},
      {"headlines":"Dr. Fauci is 'cautiously optimistic' about this finding	", "entities":"Tony Facui", "themes":"Disease"},
      {"headlines":"Universal Orlando reveals proposed reopening date", "entities":"Universal", "themes":"Travel"},
      {"headlines":"Woman makes more on unemployment than when she worked", "entities":"Woman", "themes":"Economy"},
      {"headlines":"Analysis: What's the right way to open schools?", "entities":"Schools", "themes":"Education"},
      {"headlines":"Early results are in on Sweden's 'herd immunity' strategy", "entities":"Sweden", "themes":"Disease"},
      {"headlines":"US updates: America records 1.5 million cases", "entities":"America", "themes":"Disease"},
      {"headlines":"US records highest one-day infection total. Pence says things are going well", "entities":"Mike Pence, United States", "themes":"Disease"},
      {"headlines":"Pompeo ordered officials to find a way to justify Saudi arms sale being probed by fired watchdog	", "entities":"Michael Pompeo, Saudi Arabia, Watchdog", "themes":"Foreign Policy, Governmental Oversight"}
    ]

    prompt = self.createGPTQuery(examples, query)

    r = openai.Completion.create(prompt = prompt, **kwargs)
    return r

  def updateLabelsFromData(self, df, func, n=100, inplace=True, **kwargs):
    """
      query GPT and update self.label
      df: name of df in data to update
      func: which function to use to update:
        options:
          -queryFromDefault: uses defult thing above
          -more to be built later
      n: number of examples to label
      ** kwargs: parameters for the GPT API

    """

    queries = [x for x in self.data[df].text.unique() if not x.startswith("\n")][:n]

    newLabels = pd.DataFrame(queries, columns=["headlines"])
    labels = []
    for label in newLabels.headlines:
      r = func(label, **kwargs)["choices"][0]["text"]

      lines = r.split("\n")
      entities = ""
      themes = ""

      try:
        entities = lines[0]
        themes = lines[1].split("Themes: ")[1]
      except:
        pass
      labels.append({"headlines":label, "entities":entities, "themes":themes})

    newLabels = pd.DataFrame(labels)
    #just in case, remove duplicates
    newLabels.entities = newLabels.entities.fillna("").apply(lambda x: ", ".join(set(x.split(", "))).strip())
    newLabels.themes = newLabels.themes.fillna("").apply(lambda x: ", ".join(set(x.split(", "))).strip())

    if inplace:
      if len(self.labeled)==0:
        self.labeled = newLabels
      else:
        self.labeled = pd.concat([self.labeled[~self.labeled.headlines.isin(newLabels.headlines)], newLabels])

    else:
      return newLabels

  def getMostSimilarLastLabeled(self, query, topnResults=10, **kwargs):
    """
    get n most similar of the last 200 labeled articles
    """
    domain = self.labeled[-200:]
    domain = domain[domain.headlines != query]
    domain = domain[(domain.entities != "None") & (domain.themes!="") & (domain.entities != " None")]

    similarity = openai.Engine("davinci").search(documents=domain.headlines.fillna("").to_list(),query=query, **kwargs)

    domain = domain[domain.headlines != query].reset_index(drop=True)
    domain["similarity"] = pd.DataFrame(similarity["data"])["score"]
    domain.sort_values(by="similarity", ascending=False, inplace=True)
    domain = domain[:topnResults]
    return domain

  def queryFromMostSimilarLabeled(self, query, **kwargs):
    """
      Query's GPT with the query using the most similar labeled examples as the prompt
    """

    examples = self.getMostSimilarLastLabeled(query, **kwargs) ##I'm passing the same keywords as continue, might break
    examples = examples[["headlines", "entities", "themes"]].to_dict("records")

    prompt = self.createGPTQuery(examples, query)

    r = openai.Completion.create(prompt = prompt, **kwargs)
    return r