"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.CustomActionRegistration = void 0;
const jsiiDeprecationWarnings = require("../.warnings.jsii.js");
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const codepipeline_generated_1 = require("./codepipeline.generated");
// keep this import separate from other imports to reduce chance for merge conflicts with v2-main
// eslint-disable-next-line no-duplicate-imports, import/order
const core_1 = require("@aws-cdk/core");
/**
 * The resource representing registering a custom Action with CodePipeline.
 * For the Action to be usable, it has to be registered for every region and every account it's used in.
 * In addition to this class, you should most likely also provide your clients a class
 * representing your custom Action, extending the Action class,
 * and taking the `actionProperties` as properly typed, construction properties.
 */
class CustomActionRegistration extends core_1.Construct {
    constructor(scope, id, props) {
        var _b;
        super(scope, id);
        try {
            jsiiDeprecationWarnings._aws_cdk_aws_codepipeline_CustomActionRegistrationProps(props);
        }
        catch (error) {
            if (process.env.JSII_DEBUG !== "1" && error.name === "DeprecationError") {
                Error.captureStackTrace(error, this.constructor);
            }
            throw error;
        }
        new codepipeline_generated_1.CfnCustomActionType(this, 'Resource', {
            category: props.category,
            inputArtifactDetails: {
                minimumCount: props.artifactBounds.minInputs,
                maximumCount: props.artifactBounds.maxInputs,
            },
            outputArtifactDetails: {
                minimumCount: props.artifactBounds.minOutputs,
                maximumCount: props.artifactBounds.maxOutputs,
            },
            provider: props.provider,
            version: props.version || '1',
            settings: {
                entityUrlTemplate: props.entityUrl,
                executionUrlTemplate: props.executionUrl,
            },
            configurationProperties: (_b = props.actionProperties) === null || _b === void 0 ? void 0 : _b.map((ap) => {
                return {
                    key: ap.key || false,
                    secret: ap.secret || false,
                    ...ap,
                };
            }),
        });
    }
}
exports.CustomActionRegistration = CustomActionRegistration;
_a = JSII_RTTI_SYMBOL_1;
CustomActionRegistration[_a] = { fqn: "@aws-cdk/aws-codepipeline.CustomActionRegistration", version: "1.157.0" };
//# sourceMappingURL=data:application/json;base64,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