# coding: utf-8

"""
    CyberSource Merged Spec

    All CyberSource API specs merged together. These are available at https://developer.cybersource.com/api/reference/api-reference.html

    OpenAPI spec version: 0.0.1
    
    Generated by: https://github.com/swagger-api/swagger-codegen.git
"""


from pprint import pformat
from six import iteritems
import re


class Ptsv2paymentsProcessingInformationAuthorizationOptions(object):
    """
    NOTE: This class is auto generated by the swagger code generator program.
    Do not edit the class manually.
    """


    """
    Attributes:
      swagger_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    swagger_types = {
        'auth_type': 'str',
        'pan_return_indicator': 'str',
        'verbal_auth_code': 'str',
        'verbal_auth_transaction_id': 'str',
        'auth_indicator': 'str',
        'partial_auth_indicator': 'bool',
        'balance_inquiry': 'bool',
        'ignore_avs_result': 'bool',
        'decline_avs_flags': 'list[str]',
        'ignore_cv_result': 'bool',
        'initiator': 'Ptsv2paymentsProcessingInformationAuthorizationOptionsInitiator',
        'bill_payment': 'bool',
        'bill_payment_type': 'str',
        'redemption_inquiry': 'bool',
        'transportation_mode': 'str',
        'aggregated_auth_indicator': 'str',
        'debt_recovery_indicator': 'str',
        'deferred_auth_indicator': 'bool'
    }

    attribute_map = {
        'auth_type': 'authType',
        'pan_return_indicator': 'panReturnIndicator',
        'verbal_auth_code': 'verbalAuthCode',
        'verbal_auth_transaction_id': 'verbalAuthTransactionId',
        'auth_indicator': 'authIndicator',
        'partial_auth_indicator': 'partialAuthIndicator',
        'balance_inquiry': 'balanceInquiry',
        'ignore_avs_result': 'ignoreAvsResult',
        'decline_avs_flags': 'declineAvsFlags',
        'ignore_cv_result': 'ignoreCvResult',
        'initiator': 'initiator',
        'bill_payment': 'billPayment',
        'bill_payment_type': 'billPaymentType',
        'redemption_inquiry': 'redemptionInquiry',
        'transportation_mode': 'transportationMode',
        'aggregated_auth_indicator': 'aggregatedAuthIndicator',
        'debt_recovery_indicator': 'debtRecoveryIndicator',
        'deferred_auth_indicator': 'deferredAuthIndicator'
    }

    def __init__(self, auth_type=None, pan_return_indicator=None, verbal_auth_code=None, verbal_auth_transaction_id=None, auth_indicator=None, partial_auth_indicator=None, balance_inquiry=None, ignore_avs_result=False, decline_avs_flags=None, ignore_cv_result=False, initiator=None, bill_payment=None, bill_payment_type=None, redemption_inquiry=None, transportation_mode=None, aggregated_auth_indicator=None, debt_recovery_indicator=None, deferred_auth_indicator=None):
        """
        Ptsv2paymentsProcessingInformationAuthorizationOptions - a model defined in Swagger
        """

        self._auth_type = None
        self._pan_return_indicator = None
        self._verbal_auth_code = None
        self._verbal_auth_transaction_id = None
        self._auth_indicator = None
        self._partial_auth_indicator = None
        self._balance_inquiry = None
        self._ignore_avs_result = None
        self._decline_avs_flags = None
        self._ignore_cv_result = None
        self._initiator = None
        self._bill_payment = None
        self._bill_payment_type = None
        self._redemption_inquiry = None
        self._transportation_mode = None
        self._aggregated_auth_indicator = None
        self._debt_recovery_indicator = None
        self._deferred_auth_indicator = None

        if auth_type is not None:
          self.auth_type = auth_type
        if pan_return_indicator is not None:
          self.pan_return_indicator = pan_return_indicator
        if verbal_auth_code is not None:
          self.verbal_auth_code = verbal_auth_code
        if verbal_auth_transaction_id is not None:
          self.verbal_auth_transaction_id = verbal_auth_transaction_id
        if auth_indicator is not None:
          self.auth_indicator = auth_indicator
        if partial_auth_indicator is not None:
          self.partial_auth_indicator = partial_auth_indicator
        if balance_inquiry is not None:
          self.balance_inquiry = balance_inquiry
        if ignore_avs_result is not None:
          self.ignore_avs_result = ignore_avs_result
        if decline_avs_flags is not None:
          self.decline_avs_flags = decline_avs_flags
        if ignore_cv_result is not None:
          self.ignore_cv_result = ignore_cv_result
        if initiator is not None:
          self.initiator = initiator
        if bill_payment is not None:
          self.bill_payment = bill_payment
        if bill_payment_type is not None:
          self.bill_payment_type = bill_payment_type
        if redemption_inquiry is not None:
          self.redemption_inquiry = redemption_inquiry
        if transportation_mode is not None:
          self.transportation_mode = transportation_mode
        if aggregated_auth_indicator is not None:
          self.aggregated_auth_indicator = aggregated_auth_indicator
        if debt_recovery_indicator is not None:
          self.debt_recovery_indicator = debt_recovery_indicator
        if deferred_auth_indicator is not None:
          self.deferred_auth_indicator = deferred_auth_indicator

    @property
    def auth_type(self):
        """
        Gets the auth_type of this Ptsv2paymentsProcessingInformationAuthorizationOptions.
        Authorization type. Possible values:   - `AUTOCAPTURE`: automatic capture.  - `STANDARDCAPTURE`: standard capture.  - `VERBAL`: forced capture. Include it in the payment request for a forced capture. Include it in the capture request for a verbal payment.  #### Asia, Middle East, and Africa Gateway; Cielo; Comercio Latino; and CyberSource Latin American Processing Set this field to `AUTOCAPTURE` and include it in a bundled request to indicate that you are requesting an automatic capture. If your account is configured to enable automatic captures, set this field to `STANDARDCAPTURE` and include it in a standard authorization or bundled request to indicate that you are overriding an automatic capture. For more information, see the `auth_type` field description in [Credit Card Services Using the SCMP API Guide.](https://apps.cybersource.com/library/documentation/dev_guides/CC_Svcs_SCMP_API/html/)  #### Forced Capture Set this field to `VERBAL` and include it in the authorization request to indicate that you are performing a forced capture; therefore, you receive the authorization code outside the CyberSource system.  #### Verbal Authorization Set this field to `VERBAL` and include it in the capture request to indicate that the request is for a verbal authorization. For more information, see \"Verbal Authorizations\" in [Credit Card Services Using the SCMP API](http://apps.cybersource.com/library/documentation/dev_guides/CC_Svcs_SCMP_API/html). 

        :return: The auth_type of this Ptsv2paymentsProcessingInformationAuthorizationOptions.
        :rtype: str
        """
        return self._auth_type

    @auth_type.setter
    def auth_type(self, auth_type):
        """
        Sets the auth_type of this Ptsv2paymentsProcessingInformationAuthorizationOptions.
        Authorization type. Possible values:   - `AUTOCAPTURE`: automatic capture.  - `STANDARDCAPTURE`: standard capture.  - `VERBAL`: forced capture. Include it in the payment request for a forced capture. Include it in the capture request for a verbal payment.  #### Asia, Middle East, and Africa Gateway; Cielo; Comercio Latino; and CyberSource Latin American Processing Set this field to `AUTOCAPTURE` and include it in a bundled request to indicate that you are requesting an automatic capture. If your account is configured to enable automatic captures, set this field to `STANDARDCAPTURE` and include it in a standard authorization or bundled request to indicate that you are overriding an automatic capture. For more information, see the `auth_type` field description in [Credit Card Services Using the SCMP API Guide.](https://apps.cybersource.com/library/documentation/dev_guides/CC_Svcs_SCMP_API/html/)  #### Forced Capture Set this field to `VERBAL` and include it in the authorization request to indicate that you are performing a forced capture; therefore, you receive the authorization code outside the CyberSource system.  #### Verbal Authorization Set this field to `VERBAL` and include it in the capture request to indicate that the request is for a verbal authorization. For more information, see \"Verbal Authorizations\" in [Credit Card Services Using the SCMP API](http://apps.cybersource.com/library/documentation/dev_guides/CC_Svcs_SCMP_API/html). 

        :param auth_type: The auth_type of this Ptsv2paymentsProcessingInformationAuthorizationOptions.
        :type: str
        """

        self._auth_type = auth_type

    @property
    def pan_return_indicator(self):
        """
        Gets the pan_return_indicator of this Ptsv2paymentsProcessingInformationAuthorizationOptions.
        #### Visa Platform Connect The field contains the PAN translation indicator for American Express Contactless Transaction. Valid value is   1- Expresspay Translation, PAN request 2- Expresspay Translation, PAN and Expiry date request 

        :return: The pan_return_indicator of this Ptsv2paymentsProcessingInformationAuthorizationOptions.
        :rtype: str
        """
        return self._pan_return_indicator

    @pan_return_indicator.setter
    def pan_return_indicator(self, pan_return_indicator):
        """
        Sets the pan_return_indicator of this Ptsv2paymentsProcessingInformationAuthorizationOptions.
        #### Visa Platform Connect The field contains the PAN translation indicator for American Express Contactless Transaction. Valid value is   1- Expresspay Translation, PAN request 2- Expresspay Translation, PAN and Expiry date request 

        :param pan_return_indicator: The pan_return_indicator of this Ptsv2paymentsProcessingInformationAuthorizationOptions.
        :type: str
        """

        self._pan_return_indicator = pan_return_indicator

    @property
    def verbal_auth_code(self):
        """
        Gets the verbal_auth_code of this Ptsv2paymentsProcessingInformationAuthorizationOptions.
        Authorization code.  #### Forced Capture Use this field to send the authorization code you received from a payment that you authorized outside the CyberSource system.  #### PIN debit Authorization code that is returned by the processor.  Returned by PIN debit purchase.  #### Verbal Authorization Use this field in CAPTURE API to send the verbally received authorization code.  For processor-specific information, see the `auth_code` field description in [Credit Card Services Using the SCMP API](http://apps.cybersource.com/library/documentation/dev_guides/CC_Svcs_SCMP_API/html). 

        :return: The verbal_auth_code of this Ptsv2paymentsProcessingInformationAuthorizationOptions.
        :rtype: str
        """
        return self._verbal_auth_code

    @verbal_auth_code.setter
    def verbal_auth_code(self, verbal_auth_code):
        """
        Sets the verbal_auth_code of this Ptsv2paymentsProcessingInformationAuthorizationOptions.
        Authorization code.  #### Forced Capture Use this field to send the authorization code you received from a payment that you authorized outside the CyberSource system.  #### PIN debit Authorization code that is returned by the processor.  Returned by PIN debit purchase.  #### Verbal Authorization Use this field in CAPTURE API to send the verbally received authorization code.  For processor-specific information, see the `auth_code` field description in [Credit Card Services Using the SCMP API](http://apps.cybersource.com/library/documentation/dev_guides/CC_Svcs_SCMP_API/html). 

        :param verbal_auth_code: The verbal_auth_code of this Ptsv2paymentsProcessingInformationAuthorizationOptions.
        :type: str
        """

        self._verbal_auth_code = verbal_auth_code

    @property
    def verbal_auth_transaction_id(self):
        """
        Gets the verbal_auth_transaction_id of this Ptsv2paymentsProcessingInformationAuthorizationOptions.
        Transaction ID (TID).  #### FDMS South This field is required for verbal authorizations and forced captures with the American Express card type to comply with the CAPN requirements: - Forced capture: Obtain the value for this field from the authorization response. - Verbal authorization: You cannot obtain a value for this field so CyberSource uses the default value of `000000000000000` (15 zeros). 

        :return: The verbal_auth_transaction_id of this Ptsv2paymentsProcessingInformationAuthorizationOptions.
        :rtype: str
        """
        return self._verbal_auth_transaction_id

    @verbal_auth_transaction_id.setter
    def verbal_auth_transaction_id(self, verbal_auth_transaction_id):
        """
        Sets the verbal_auth_transaction_id of this Ptsv2paymentsProcessingInformationAuthorizationOptions.
        Transaction ID (TID).  #### FDMS South This field is required for verbal authorizations and forced captures with the American Express card type to comply with the CAPN requirements: - Forced capture: Obtain the value for this field from the authorization response. - Verbal authorization: You cannot obtain a value for this field so CyberSource uses the default value of `000000000000000` (15 zeros). 

        :param verbal_auth_transaction_id: The verbal_auth_transaction_id of this Ptsv2paymentsProcessingInformationAuthorizationOptions.
        :type: str
        """

        self._verbal_auth_transaction_id = verbal_auth_transaction_id

    @property
    def auth_indicator(self):
        """
        Gets the auth_indicator of this Ptsv2paymentsProcessingInformationAuthorizationOptions.
        Flag that specifies the purpose of the authorization.  Possible values:  - **0**: Preauthorization  - **1**: Final authorization  To set the default for this field, contact CyberSource Customer Support.  #### Barclays and Elavon The default for Barclays and Elavon is 1 (final authorization). To change the default for this field, contact CyberSource Customer Support.  #### CyberSource through VisaNet When the value for this field is 0, it corresponds to the following data in the TC 33 capture file:  - Record: CP01 TCR0  - Position: 164  - Field: Additional Authorization Indicators When the value for this field is 1, it does not correspond to any data in the TC 33 capture file. 

        :return: The auth_indicator of this Ptsv2paymentsProcessingInformationAuthorizationOptions.
        :rtype: str
        """
        return self._auth_indicator

    @auth_indicator.setter
    def auth_indicator(self, auth_indicator):
        """
        Sets the auth_indicator of this Ptsv2paymentsProcessingInformationAuthorizationOptions.
        Flag that specifies the purpose of the authorization.  Possible values:  - **0**: Preauthorization  - **1**: Final authorization  To set the default for this field, contact CyberSource Customer Support.  #### Barclays and Elavon The default for Barclays and Elavon is 1 (final authorization). To change the default for this field, contact CyberSource Customer Support.  #### CyberSource through VisaNet When the value for this field is 0, it corresponds to the following data in the TC 33 capture file:  - Record: CP01 TCR0  - Position: 164  - Field: Additional Authorization Indicators When the value for this field is 1, it does not correspond to any data in the TC 33 capture file. 

        :param auth_indicator: The auth_indicator of this Ptsv2paymentsProcessingInformationAuthorizationOptions.
        :type: str
        """

        self._auth_indicator = auth_indicator

    @property
    def partial_auth_indicator(self):
        """
        Gets the partial_auth_indicator of this Ptsv2paymentsProcessingInformationAuthorizationOptions.
        Flag that indicates whether the transaction is enabled for partial authorization. When the request includes this field, this value overrides the information in your account. Possible values: - `true`: Enable the transaction for partial authorization. - `false`: Do not enable the transaction for partial authorization.  #### PIN debit Required field for partial authorizations that use PIN debit purchase; otherwise, not used.  #### Used by **Authorization** Optional field.  #### CyberSource through VisaNet To set the default for this field, contact CyberSource Customer Support. The value for this field corresponds to the following data in the TC 33 capture file5: - Record: CP01 TCR0 - Position: 164 - Field: Additional Authorization Indicators 

        :return: The partial_auth_indicator of this Ptsv2paymentsProcessingInformationAuthorizationOptions.
        :rtype: bool
        """
        return self._partial_auth_indicator

    @partial_auth_indicator.setter
    def partial_auth_indicator(self, partial_auth_indicator):
        """
        Sets the partial_auth_indicator of this Ptsv2paymentsProcessingInformationAuthorizationOptions.
        Flag that indicates whether the transaction is enabled for partial authorization. When the request includes this field, this value overrides the information in your account. Possible values: - `true`: Enable the transaction for partial authorization. - `false`: Do not enable the transaction for partial authorization.  #### PIN debit Required field for partial authorizations that use PIN debit purchase; otherwise, not used.  #### Used by **Authorization** Optional field.  #### CyberSource through VisaNet To set the default for this field, contact CyberSource Customer Support. The value for this field corresponds to the following data in the TC 33 capture file5: - Record: CP01 TCR0 - Position: 164 - Field: Additional Authorization Indicators 

        :param partial_auth_indicator: The partial_auth_indicator of this Ptsv2paymentsProcessingInformationAuthorizationOptions.
        :type: bool
        """

        self._partial_auth_indicator = partial_auth_indicator

    @property
    def balance_inquiry(self):
        """
        Gets the balance_inquiry of this Ptsv2paymentsProcessingInformationAuthorizationOptions.
        Flag that indicates whether to return balance information.  Possible values: - `true`: Return balance information. - `false`: Do not return balance information.  #### Used by **Authorization** Required for a balance inquiry; otherwise, not used.  #### PIN debit Required for a balance inquiry request of a PIN debit purchase; otherwise, not used. 

        :return: The balance_inquiry of this Ptsv2paymentsProcessingInformationAuthorizationOptions.
        :rtype: bool
        """
        return self._balance_inquiry

    @balance_inquiry.setter
    def balance_inquiry(self, balance_inquiry):
        """
        Sets the balance_inquiry of this Ptsv2paymentsProcessingInformationAuthorizationOptions.
        Flag that indicates whether to return balance information.  Possible values: - `true`: Return balance information. - `false`: Do not return balance information.  #### Used by **Authorization** Required for a balance inquiry; otherwise, not used.  #### PIN debit Required for a balance inquiry request of a PIN debit purchase; otherwise, not used. 

        :param balance_inquiry: The balance_inquiry of this Ptsv2paymentsProcessingInformationAuthorizationOptions.
        :type: bool
        """

        self._balance_inquiry = balance_inquiry

    @property
    def ignore_avs_result(self):
        """
        Gets the ignore_avs_result of this Ptsv2paymentsProcessingInformationAuthorizationOptions.
        Flag for a sale request that indicates whether to allow the capture service to run even when the authorization receives an AVS decline, as indicated by a reply flag value of DAVSNO.  Possible values: - `true`: Ignore the results of AVS checking and run the capture service. - `false` (default): If the authorization receives an AVS decline, do not run the capture service. When the value of this field is `true`, the list in the `processingInformation.authorizationOptions.declineAvsFlags` field is ignored.  #### Used by **Authorization** Optional field. String (3) 

        :return: The ignore_avs_result of this Ptsv2paymentsProcessingInformationAuthorizationOptions.
        :rtype: bool
        """
        return self._ignore_avs_result

    @ignore_avs_result.setter
    def ignore_avs_result(self, ignore_avs_result):
        """
        Sets the ignore_avs_result of this Ptsv2paymentsProcessingInformationAuthorizationOptions.
        Flag for a sale request that indicates whether to allow the capture service to run even when the authorization receives an AVS decline, as indicated by a reply flag value of DAVSNO.  Possible values: - `true`: Ignore the results of AVS checking and run the capture service. - `false` (default): If the authorization receives an AVS decline, do not run the capture service. When the value of this field is `true`, the list in the `processingInformation.authorizationOptions.declineAvsFlags` field is ignored.  #### Used by **Authorization** Optional field. String (3) 

        :param ignore_avs_result: The ignore_avs_result of this Ptsv2paymentsProcessingInformationAuthorizationOptions.
        :type: bool
        """

        self._ignore_avs_result = ignore_avs_result

    @property
    def decline_avs_flags(self):
        """
        Gets the decline_avs_flags of this Ptsv2paymentsProcessingInformationAuthorizationOptions.
        Comma-separated list of AVS flags that cause the reply flag `DAVSNO` to be returned.  **Important** To receive declines for the AVS code `N`, you must include the value `N` in the comma-separated list.    ### AVS Codes for Cielo 3.0 and CyberSource Latin American Processing    **Note** CyberSource Latin American Processing is the name of a specific processing connection that CyberSource supports.   In the CyberSource API documentation, CyberSource Latin American Processing does not refer to the general topic of processing in Latin America.   The information in this section is for the specific processing connection called CyberSource Latin American Processing.   It is not for any other Latin American processors that CyberSource supports.  |AVS Code|Description| |--- |--- | |D|Partial match: postal code and address match.| |E|Not supported: AVS is not supported for this card type. _or_ Invalid: the acquirer returned an unrecognized value for the AVS response.| |F|Partial match: postal code matches, but CPF and address do not match.*| |G|Not supported: AVS not supported or not verified.| |I|No match: AVS information is not available.| |K|Partial match: CPF matches, but postal code and address do not match.*| |L|Partial match: postal code and CPF match, but address does not match.*| |N|No match: postal code, CPF, and address do not match.*| |O|Partial match: CPF and address match, but postal code does not match.*| |R|Not supported: your implementation does not support AVS _or_ System unavailable.| |T|Partial match: address matches, but postal code and CPF do not match.*| |V|Match: postal code, CPF, and address match.*| |* CPF (Cadastro de Pessoas Fisicas) is required only for Redecard in Brazil.||  ### AVS Codes for All Other Processors  **Note** The list of AVS codes for all other processors follows these descriptions of the processor-specific information for these codes.  #### American Express Cards For American Express cards only, you can receive Visa and CyberSource AVS codes in addition to the American Express AVS codes.  **Note** For CyberSource through VisaNet, the American Express AVS codes are converted to Visa AVS codes before they are returned to you. As a result, you will not receive American Express AVS codes for the American Express card type.<br/><br/>  _American Express Card codes_: `F`, `H`, `K`, `L`, `O`, `T`, `V`  #### Domestic and International Visa Cards The international and domestic alphabetic AVS codes are the Visa standard AVS codes. CyberSource maps the standard AVS return codes for other types of payment cards, including American Express cards, to the Visa standard AVS codes.  AVS is considered either domestic or international, depending on the location of the bank that issued the customer's payment card: - When the bank is in the U.S., the AVS is domestic. - When the bank is outside the U.S., the AVS is international.  You should be prepared to handle both domestic and international AVS result codes: - For international cards, you can receive domestic AVS codes in addition to the international AVS codes. - For domestic cards, you can receive international AVS codes in addition to the domestic AVS codes.  _International Visa Codes_: `B`, `C`, `D`, `G`, `I`, `M`, `P`  _Domestic Visa Codes_: `A`, `E`,`N`, `R`, `S`, `U`, `W`, `X`, `Y`, `Z`  #### CyberSource Codes The numeric AVS codes are created by CyberSource and are not standard Visa codes. These AVS codes can be returned for any card type.  _CyberSource Codes_: `1`, `2`, `3`, `4`  ### Table of AVS Codes for All Other Processors  |AVS Code|Description| |--- |--- | |A|Partial match: street address matches, but 5-digit and 9-digit postal codes do not match.| |B|Partial match: street address matches, but postal code is not verified. Returned only for Visa cards not issued in the U.S.| |C|No match: street address and postal code do not match. Returned only for Visa cards not issued in the U.S.| |D & M|Match: street address and postal code match. Returned only for Visa cards not issued in the U.S.| |E|Invalid: AVS data is invalid or AVS is not allowed for this card type.| |F|Partial match: card member’s name does not match, but billing postal code matches.| |G|Not supported: issuing bank outside the U.S. does not support AVS.| |H|Partial match: card member’s name does not match, but street address and postal code match. Returned only for the American Express card type.| |I|No match: address not verified. Returned only for Visa cards not issued in the U.S.| |K|Partial match: card member’s name matches, but billing address and billing postal code do not match. Returned only for the American Express card type.| |L|Partial match: card member’s name and billing postal code match, but billing address does not match. Returned only for the American Express card type.| |M|See the entry for D & M.| |N|No match: one of the following: street address and postal code do not match _or_ (American Express card type only) card member’s name, street address, and postal code do not match.| |O|Partial match: card member’s name and billing address match, but billing postal code does not match. Returned only for the American Express card type.| |P|Partial match: postal code matches, but street address not verified. Returned only for Visa cards not issued in the U.S.| |R|System unavailable.| |S|Not supported: issuing bank in the U.S. does not support AVS.| |T|Partial match: card member’s name does not match, but street address matches. Returned only for the American Express card type.| |U|System unavailable: address information unavailable for one of these reasons: The U.S. bank does not support AVS outside the U.S. _or_ The AVS in a U.S. bank is not functioning properly.| |V|Match: card member’s name, billing address, and billing postal code match. Returned only for the American Express card type.| |W|Partial match: street address does not match, but 9-digit postal code matches.| |X|Match: street address and 9-digit postal code match.| |Y|Match: street address and 5-digit postal code match.| |Z|Partial match: street address does not match, but 5-digit postal code matches.| |1|Not supported: one of the following: AVS is not supported for this processor or card type _or_ AVS is disabled for your CyberSource account. To enable AVS, contact CyberSource Customer Support.| |2|Unrecognized: the processor returned an unrecognized value for the AVS response.| |3|Match: address is confirmed. Returned only for PayPal Express Checkout.| |4|No match: address is not confirmed. Returned only for PayPal Express Checkout.| |5|No match: no AVS code was returned by the processor.| 

        :return: The decline_avs_flags of this Ptsv2paymentsProcessingInformationAuthorizationOptions.
        :rtype: list[str]
        """
        return self._decline_avs_flags

    @decline_avs_flags.setter
    def decline_avs_flags(self, decline_avs_flags):
        """
        Sets the decline_avs_flags of this Ptsv2paymentsProcessingInformationAuthorizationOptions.
        Comma-separated list of AVS flags that cause the reply flag `DAVSNO` to be returned.  **Important** To receive declines for the AVS code `N`, you must include the value `N` in the comma-separated list.    ### AVS Codes for Cielo 3.0 and CyberSource Latin American Processing    **Note** CyberSource Latin American Processing is the name of a specific processing connection that CyberSource supports.   In the CyberSource API documentation, CyberSource Latin American Processing does not refer to the general topic of processing in Latin America.   The information in this section is for the specific processing connection called CyberSource Latin American Processing.   It is not for any other Latin American processors that CyberSource supports.  |AVS Code|Description| |--- |--- | |D|Partial match: postal code and address match.| |E|Not supported: AVS is not supported for this card type. _or_ Invalid: the acquirer returned an unrecognized value for the AVS response.| |F|Partial match: postal code matches, but CPF and address do not match.*| |G|Not supported: AVS not supported or not verified.| |I|No match: AVS information is not available.| |K|Partial match: CPF matches, but postal code and address do not match.*| |L|Partial match: postal code and CPF match, but address does not match.*| |N|No match: postal code, CPF, and address do not match.*| |O|Partial match: CPF and address match, but postal code does not match.*| |R|Not supported: your implementation does not support AVS _or_ System unavailable.| |T|Partial match: address matches, but postal code and CPF do not match.*| |V|Match: postal code, CPF, and address match.*| |* CPF (Cadastro de Pessoas Fisicas) is required only for Redecard in Brazil.||  ### AVS Codes for All Other Processors  **Note** The list of AVS codes for all other processors follows these descriptions of the processor-specific information for these codes.  #### American Express Cards For American Express cards only, you can receive Visa and CyberSource AVS codes in addition to the American Express AVS codes.  **Note** For CyberSource through VisaNet, the American Express AVS codes are converted to Visa AVS codes before they are returned to you. As a result, you will not receive American Express AVS codes for the American Express card type.<br/><br/>  _American Express Card codes_: `F`, `H`, `K`, `L`, `O`, `T`, `V`  #### Domestic and International Visa Cards The international and domestic alphabetic AVS codes are the Visa standard AVS codes. CyberSource maps the standard AVS return codes for other types of payment cards, including American Express cards, to the Visa standard AVS codes.  AVS is considered either domestic or international, depending on the location of the bank that issued the customer's payment card: - When the bank is in the U.S., the AVS is domestic. - When the bank is outside the U.S., the AVS is international.  You should be prepared to handle both domestic and international AVS result codes: - For international cards, you can receive domestic AVS codes in addition to the international AVS codes. - For domestic cards, you can receive international AVS codes in addition to the domestic AVS codes.  _International Visa Codes_: `B`, `C`, `D`, `G`, `I`, `M`, `P`  _Domestic Visa Codes_: `A`, `E`,`N`, `R`, `S`, `U`, `W`, `X`, `Y`, `Z`  #### CyberSource Codes The numeric AVS codes are created by CyberSource and are not standard Visa codes. These AVS codes can be returned for any card type.  _CyberSource Codes_: `1`, `2`, `3`, `4`  ### Table of AVS Codes for All Other Processors  |AVS Code|Description| |--- |--- | |A|Partial match: street address matches, but 5-digit and 9-digit postal codes do not match.| |B|Partial match: street address matches, but postal code is not verified. Returned only for Visa cards not issued in the U.S.| |C|No match: street address and postal code do not match. Returned only for Visa cards not issued in the U.S.| |D & M|Match: street address and postal code match. Returned only for Visa cards not issued in the U.S.| |E|Invalid: AVS data is invalid or AVS is not allowed for this card type.| |F|Partial match: card member’s name does not match, but billing postal code matches.| |G|Not supported: issuing bank outside the U.S. does not support AVS.| |H|Partial match: card member’s name does not match, but street address and postal code match. Returned only for the American Express card type.| |I|No match: address not verified. Returned only for Visa cards not issued in the U.S.| |K|Partial match: card member’s name matches, but billing address and billing postal code do not match. Returned only for the American Express card type.| |L|Partial match: card member’s name and billing postal code match, but billing address does not match. Returned only for the American Express card type.| |M|See the entry for D & M.| |N|No match: one of the following: street address and postal code do not match _or_ (American Express card type only) card member’s name, street address, and postal code do not match.| |O|Partial match: card member’s name and billing address match, but billing postal code does not match. Returned only for the American Express card type.| |P|Partial match: postal code matches, but street address not verified. Returned only for Visa cards not issued in the U.S.| |R|System unavailable.| |S|Not supported: issuing bank in the U.S. does not support AVS.| |T|Partial match: card member’s name does not match, but street address matches. Returned only for the American Express card type.| |U|System unavailable: address information unavailable for one of these reasons: The U.S. bank does not support AVS outside the U.S. _or_ The AVS in a U.S. bank is not functioning properly.| |V|Match: card member’s name, billing address, and billing postal code match. Returned only for the American Express card type.| |W|Partial match: street address does not match, but 9-digit postal code matches.| |X|Match: street address and 9-digit postal code match.| |Y|Match: street address and 5-digit postal code match.| |Z|Partial match: street address does not match, but 5-digit postal code matches.| |1|Not supported: one of the following: AVS is not supported for this processor or card type _or_ AVS is disabled for your CyberSource account. To enable AVS, contact CyberSource Customer Support.| |2|Unrecognized: the processor returned an unrecognized value for the AVS response.| |3|Match: address is confirmed. Returned only for PayPal Express Checkout.| |4|No match: address is not confirmed. Returned only for PayPal Express Checkout.| |5|No match: no AVS code was returned by the processor.| 

        :param decline_avs_flags: The decline_avs_flags of this Ptsv2paymentsProcessingInformationAuthorizationOptions.
        :type: list[str]
        """

        self._decline_avs_flags = decline_avs_flags

    @property
    def ignore_cv_result(self):
        """
        Gets the ignore_cv_result of this Ptsv2paymentsProcessingInformationAuthorizationOptions.
        Flag for a sale request that indicates whether to allow the capture service to run even when the authorization receives a CVN decline, as indicated by an `processorInformation.cardVerification.resultCode` value of `D` or `N`. Possible values: - `true`: Ignore the results of CVN checking and run the capture service. - `false` (default): If the authorization receives a CVN decline, do not run the capture service.  #### Used by **Authorization** Optional field. 

        :return: The ignore_cv_result of this Ptsv2paymentsProcessingInformationAuthorizationOptions.
        :rtype: bool
        """
        return self._ignore_cv_result

    @ignore_cv_result.setter
    def ignore_cv_result(self, ignore_cv_result):
        """
        Sets the ignore_cv_result of this Ptsv2paymentsProcessingInformationAuthorizationOptions.
        Flag for a sale request that indicates whether to allow the capture service to run even when the authorization receives a CVN decline, as indicated by an `processorInformation.cardVerification.resultCode` value of `D` or `N`. Possible values: - `true`: Ignore the results of CVN checking and run the capture service. - `false` (default): If the authorization receives a CVN decline, do not run the capture service.  #### Used by **Authorization** Optional field. 

        :param ignore_cv_result: The ignore_cv_result of this Ptsv2paymentsProcessingInformationAuthorizationOptions.
        :type: bool
        """

        self._ignore_cv_result = ignore_cv_result

    @property
    def initiator(self):
        """
        Gets the initiator of this Ptsv2paymentsProcessingInformationAuthorizationOptions.

        :return: The initiator of this Ptsv2paymentsProcessingInformationAuthorizationOptions.
        :rtype: Ptsv2paymentsProcessingInformationAuthorizationOptionsInitiator
        """
        return self._initiator

    @initiator.setter
    def initiator(self, initiator):
        """
        Sets the initiator of this Ptsv2paymentsProcessingInformationAuthorizationOptions.

        :param initiator: The initiator of this Ptsv2paymentsProcessingInformationAuthorizationOptions.
        :type: Ptsv2paymentsProcessingInformationAuthorizationOptionsInitiator
        """

        self._initiator = initiator

    @property
    def bill_payment(self):
        """
        Gets the bill_payment of this Ptsv2paymentsProcessingInformationAuthorizationOptions.
        Indicates payment for bill or payment towards existing contractual loan.  Possible values: - `true`: Bill payment or loan payment. - `false` (default): Not a bill payment or loan payment.  Optional request field. 

        :return: The bill_payment of this Ptsv2paymentsProcessingInformationAuthorizationOptions.
        :rtype: bool
        """
        return self._bill_payment

    @bill_payment.setter
    def bill_payment(self, bill_payment):
        """
        Sets the bill_payment of this Ptsv2paymentsProcessingInformationAuthorizationOptions.
        Indicates payment for bill or payment towards existing contractual loan.  Possible values: - `true`: Bill payment or loan payment. - `false` (default): Not a bill payment or loan payment.  Optional request field. 

        :param bill_payment: The bill_payment of this Ptsv2paymentsProcessingInformationAuthorizationOptions.
        :type: bool
        """

        self._bill_payment = bill_payment

    @property
    def bill_payment_type(self):
        """
        Gets the bill_payment_type of this Ptsv2paymentsProcessingInformationAuthorizationOptions.
        Reason for the payment.  Possible values: - 001: Utility payment - 002: Government services - 003: Mobile phone top-up - 004: Coupon payment  The value for this field corresponds to the following data in the TC 33 capture file5: - Record: CP07 TCR0 - Position: 48-50 - Field: Bill Payment Transaction Type Identifier  This field is supported only for bill payments in Brazil with Mastercard on CyberSource through VisaNet. 

        :return: The bill_payment_type of this Ptsv2paymentsProcessingInformationAuthorizationOptions.
        :rtype: str
        """
        return self._bill_payment_type

    @bill_payment_type.setter
    def bill_payment_type(self, bill_payment_type):
        """
        Sets the bill_payment_type of this Ptsv2paymentsProcessingInformationAuthorizationOptions.
        Reason for the payment.  Possible values: - 001: Utility payment - 002: Government services - 003: Mobile phone top-up - 004: Coupon payment  The value for this field corresponds to the following data in the TC 33 capture file5: - Record: CP07 TCR0 - Position: 48-50 - Field: Bill Payment Transaction Type Identifier  This field is supported only for bill payments in Brazil with Mastercard on CyberSource through VisaNet. 

        :param bill_payment_type: The bill_payment_type of this Ptsv2paymentsProcessingInformationAuthorizationOptions.
        :type: str
        """

        self._bill_payment_type = bill_payment_type

    @property
    def redemption_inquiry(self):
        """
        Gets the redemption_inquiry of this Ptsv2paymentsProcessingInformationAuthorizationOptions.
        Flag that indicates the payment request is a redemption inquiry.  Possible values:   - `true`   - `false` 

        :return: The redemption_inquiry of this Ptsv2paymentsProcessingInformationAuthorizationOptions.
        :rtype: bool
        """
        return self._redemption_inquiry

    @redemption_inquiry.setter
    def redemption_inquiry(self, redemption_inquiry):
        """
        Sets the redemption_inquiry of this Ptsv2paymentsProcessingInformationAuthorizationOptions.
        Flag that indicates the payment request is a redemption inquiry.  Possible values:   - `true`   - `false` 

        :param redemption_inquiry: The redemption_inquiry of this Ptsv2paymentsProcessingInformationAuthorizationOptions.
        :type: bool
        """

        self._redemption_inquiry = redemption_inquiry

    @property
    def transportation_mode(self):
        """
        Gets the transportation_mode of this Ptsv2paymentsProcessingInformationAuthorizationOptions.
        Type of transportation mode :  Possible Values: - 00 = Unknown - 01 = Urban bus - 02 = Interurban bus - 03=Lighttrainmasstransit(Underground Metro LTR) - 04 = Train - 05 = Commuter train - 06 = Water-borne vehicle - 07 = Toll - 08 = Parking - 09 = Taxi - 10 = High-speed train - 11 = Rural bus - 12 = Express commuter train - 13 = Para transit - 14 = Self drive vehicle - 15 = Coach - 16 = Locomotive - 17 = Powered motor coach - 18 = Trailer - 19 = Regional train - 20 = Inter-city - 21 = Funicular train - 22 = Cable car 

        :return: The transportation_mode of this Ptsv2paymentsProcessingInformationAuthorizationOptions.
        :rtype: str
        """
        return self._transportation_mode

    @transportation_mode.setter
    def transportation_mode(self, transportation_mode):
        """
        Sets the transportation_mode of this Ptsv2paymentsProcessingInformationAuthorizationOptions.
        Type of transportation mode :  Possible Values: - 00 = Unknown - 01 = Urban bus - 02 = Interurban bus - 03=Lighttrainmasstransit(Underground Metro LTR) - 04 = Train - 05 = Commuter train - 06 = Water-borne vehicle - 07 = Toll - 08 = Parking - 09 = Taxi - 10 = High-speed train - 11 = Rural bus - 12 = Express commuter train - 13 = Para transit - 14 = Self drive vehicle - 15 = Coach - 16 = Locomotive - 17 = Powered motor coach - 18 = Trailer - 19 = Regional train - 20 = Inter-city - 21 = Funicular train - 22 = Cable car 

        :param transportation_mode: The transportation_mode of this Ptsv2paymentsProcessingInformationAuthorizationOptions.
        :type: str
        """

        self._transportation_mode = transportation_mode

    @property
    def aggregated_auth_indicator(self):
        """
        Gets the aggregated_auth_indicator of this Ptsv2paymentsProcessingInformationAuthorizationOptions.
        Indicates if transaction is an aggregated auth  Possible values: - **true** - **false** 

        :return: The aggregated_auth_indicator of this Ptsv2paymentsProcessingInformationAuthorizationOptions.
        :rtype: str
        """
        return self._aggregated_auth_indicator

    @aggregated_auth_indicator.setter
    def aggregated_auth_indicator(self, aggregated_auth_indicator):
        """
        Sets the aggregated_auth_indicator of this Ptsv2paymentsProcessingInformationAuthorizationOptions.
        Indicates if transaction is an aggregated auth  Possible values: - **true** - **false** 

        :param aggregated_auth_indicator: The aggregated_auth_indicator of this Ptsv2paymentsProcessingInformationAuthorizationOptions.
        :type: str
        """

        self._aggregated_auth_indicator = aggregated_auth_indicator

    @property
    def debt_recovery_indicator(self):
        """
        Gets the debt_recovery_indicator of this Ptsv2paymentsProcessingInformationAuthorizationOptions.
        Indicates if transaction is a debt recovery request  Possible values: - **true** - **false** 

        :return: The debt_recovery_indicator of this Ptsv2paymentsProcessingInformationAuthorizationOptions.
        :rtype: str
        """
        return self._debt_recovery_indicator

    @debt_recovery_indicator.setter
    def debt_recovery_indicator(self, debt_recovery_indicator):
        """
        Sets the debt_recovery_indicator of this Ptsv2paymentsProcessingInformationAuthorizationOptions.
        Indicates if transaction is a debt recovery request  Possible values: - **true** - **false** 

        :param debt_recovery_indicator: The debt_recovery_indicator of this Ptsv2paymentsProcessingInformationAuthorizationOptions.
        :type: str
        """

        self._debt_recovery_indicator = debt_recovery_indicator

    @property
    def deferred_auth_indicator(self):
        """
        Gets the deferred_auth_indicator of this Ptsv2paymentsProcessingInformationAuthorizationOptions.
        Flag that indicates whether the authorization request was delayed because connectivity was interrupted.  Possible values:   - `true` (Deferred authorization)   - `false` (default: Not a deferred authorization) 

        :return: The deferred_auth_indicator of this Ptsv2paymentsProcessingInformationAuthorizationOptions.
        :rtype: bool
        """
        return self._deferred_auth_indicator

    @deferred_auth_indicator.setter
    def deferred_auth_indicator(self, deferred_auth_indicator):
        """
        Sets the deferred_auth_indicator of this Ptsv2paymentsProcessingInformationAuthorizationOptions.
        Flag that indicates whether the authorization request was delayed because connectivity was interrupted.  Possible values:   - `true` (Deferred authorization)   - `false` (default: Not a deferred authorization) 

        :param deferred_auth_indicator: The deferred_auth_indicator of this Ptsv2paymentsProcessingInformationAuthorizationOptions.
        :type: bool
        """

        self._deferred_auth_indicator = deferred_auth_indicator

    def to_dict(self):
        """
        Returns the model properties as a dict
        """
        result = {}

        for attr, _ in iteritems(self.swagger_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value

        return result

    def to_str(self):
        """
        Returns the string representation of the model
        """
        return pformat(self.to_dict())

    def __repr__(self):
        """
        For `print` and `pprint`
        """
        return self.to_str()

    def __eq__(self, other):
        """
        Returns true if both objects are equal
        """
        if not isinstance(other, Ptsv2paymentsProcessingInformationAuthorizationOptions):
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """
        Returns true if both objects are not equal
        """
        return not self == other
