"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.LambdaToElasticSearchAndKibana = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const defaults = require("@aws-solutions-constructs/core");
// Note: To ensure CDKv2 compatibility, keep the import statement for Construct separate
const core_1 = require("@aws-cdk/core");
class LambdaToElasticSearchAndKibana extends core_1.Construct {
    /**
     * @summary Constructs a new instance of the CognitoToApiGatewayToLambda class.
     * @param {cdk.App} scope - represents the scope for all the resources.
     * @param {string} id - this is a a scope-unique id.
     * @param {CognitoToApiGatewayToLambdaProps} props - user provided props for the construct
     * @since 0.8.0
     * @access public
     */
    constructor(scope, id, props) {
        var _b;
        super(scope, id);
        defaults.CheckProps(props);
        this.lambdaFunction = defaults.buildLambdaFunction(this, {
            existingLambdaObj: props.existingLambdaObj,
            lambdaFunctionProps: props.lambdaFunctionProps
        });
        // Find the lambda service Role ARN
        const lambdaFunctionRoleARN = (_b = this.lambdaFunction.role) === null || _b === void 0 ? void 0 : _b.roleArn;
        this.userPool = defaults.buildUserPool(this);
        this.userPoolClient = defaults.buildUserPoolClient(this, this.userPool);
        this.identityPool = defaults.buildIdentityPool(this, this.userPool, this.userPoolClient);
        let cognitoDomainName = props.domainName;
        if (props.cognitoDomainName) {
            cognitoDomainName = props.cognitoDomainName;
        }
        const cognitoAuthorizedRole = defaults.setupCognitoForElasticSearch(this, cognitoDomainName, {
            userpool: this.userPool,
            identitypool: this.identityPool,
            userpoolclient: this.userPoolClient
        });
        [this.elasticsearchDomain, this.elasticsearchRole] = defaults.buildElasticSearch(this, props.domainName, {
            userpool: this.userPool,
            identitypool: this.identityPool,
            cognitoAuthorizedRoleARN: cognitoAuthorizedRole.roleArn,
            serviceRoleARN: lambdaFunctionRoleARN
        }, props.esDomainProps);
        // Add ES Domain to lambda envrionment variable
        const domainEndpointEnvironmentVariableName = props.domainEndpointEnvironmentVariableName || 'DOMAIN_ENDPOINT';
        this.lambdaFunction.addEnvironment(domainEndpointEnvironmentVariableName, this.elasticsearchDomain.attrDomainEndpoint);
        if (props.createCloudWatchAlarms === undefined || props.createCloudWatchAlarms) {
            // Deploy best practices CW Alarms for ES
            this.cloudwatchAlarms = defaults.buildElasticSearchCWAlarms(this);
        }
    }
}
exports.LambdaToElasticSearchAndKibana = LambdaToElasticSearchAndKibana;
_a = JSII_RTTI_SYMBOL_1;
LambdaToElasticSearchAndKibana[_a] = { fqn: "@aws-solutions-constructs/aws-lambda-elasticsearch-kibana.LambdaToElasticSearchAndKibana", version: "1.149.0" };
//# sourceMappingURL=data:application/json;base64,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