from setuptools import setup, find_packages

setup(
    name='compose.db2',
    version='0.2.0.1',
    description='compose db2 management library',
    author='Pandu Mutyala',
    author_email='pmutyala@ca.ibm.com',
    packages=find_packages(),
    namespace_packages=['compose'],
    install_requires=["cdb==6.0.0", "requests>=2.26", "jinja2>=2.10",
                      "boto3>=1.17.98", "kubernetes==17.17.0",
                      "prometheus_client>=0.11", "urllib3>=1.26.4", "dnspython==2.1", "ibm_db==3.0.4.2",
                      "ibm-cos-sdk", "debroni_client==0.0.23.8", "bitmath", "python-etcd",
                      "s3cmd"],
    extras_require={
        'tests': [
            'tox==3.5.3',
            'pytest==4.3.1',
            'pytest-cov==2.6.1',
            'pluggy>=0.7.0',
            'mock==2.0.0',
            'moto==1.3.14',
            'bitmath'
        ],
        'dev': [
            'ipdb==0.10.3',
            'pylint',
            'yapf'
        ]
    },
    include_package_data=True,
    entry_points={
        'cdb.commands.db2': [
            'start = compose.db2:start',
            'stop = compose.db2:stop',
            'stop_standby = compose.db2:stop_standby',
            'backup = compose.db2:backup',
            'backup_info = compose.db2:backup_info',
            'backup_window_start = compose.db2:backup_window_start',
            'change_password = compose.db2:change_password',
            'create_lite_password = compose.db2:create_lite_password',
            'configure = compose.db2:configure',
            'configure_backup = compose.db2:configure_backup',
            'delete_backups = compose.db2:delete_backups',
            'create_user = compose.db2:create_user',
            'create_lite_user = compose.db2:create_lite_user',
            'create_lite_user_schema = compose.db2:create_lite_user_schema',
            'create_lite_user_tablespace = compose.db2:create_lite_user_tablespace',
            'grant_lite_user_privilege = compose.db2:grant_lite_user_privilege',
            'grant_lite_user_role = compose.db2:grant_lite_user_role',
            'delete_user = compose.db2:delete_user',
            'delete_lite_user = compose.db2:delete_lite_user',
            'remove_lite_user_table = compose.db2:remove_lite_user_table',
            'remove_error_schema = compose.db2:remove_error_schema',
            'remove_spatial_reference = compose.db2:remove_spatial_reference',
            'sync_users = compose.db2:sync_users',
            'modify_user = compose.db2:modify_user',
            'change_password_bluuser = compose.db2:change_password_bluuser',
            'change_password_liteuser = compose.db2:change_password_liteuser',
            'lock_operation = compose.db2:lock_operation',
            'lite_lock_operation = compose.db2:lite_lock_operation',
            'is_leader = compose.db2:is_leader',
            'buildback = compose.db2:buildback',
            'restore = compose.db2:restore',
            'copy = compose.db2:copy',
            'status = compose.db2:status',
            'takeover = compose.db2:takeover',
            'unpause_debroni = compose.db2:unpause_debroni',
            'pause_debroni = compose.db2:pause_debroni',
            'debroni_info = compose.db2:debroni_info',
            'debroni_database_details = compose.db2:debroni_database_details',
            'usage = compose.db2:usage',
            'kill_all_connections = compose.db2:kill_all_connections',
            'kill_user_connections = compose.db2:kill_user_connections',
            'ha_status = compose.db2:ha_status',
            'sleep = compose.db2:sleep',
            'db_summary = compose.db2:db_summary',
            'flip_sync = compose.db2:flip_sync',
            'rotate_primary = compose.db2:rotate_primary',
            'eviction_score = compose.db2:eviction_score',
            'pre_evict = compose.db2:pre_evict',
            'scale = compose.db2:scale',
            'prescale = compose.db2:prescale',
            'assert_db_updated = compose.db2:assert_db_updated',
            'update_instance = compose.db2:update_instance',
            'update_db = compose.db2:update_db',
            'increase_logging = compose.db2:increase_logging',
            'decrease_logging = compose.db2:decrease_logging',
            'debroni_init_restore = compose.db2:debroni_init_restore',
            'debroni_init_buildback = compose.db2:debroni_init_buildback',
            'debroni_init = compose.db2:debroni_init',
            'upload_userfile_cos = compose.db2:upload_userfile_cos',
            'construct_user_table = compose.db2:construct_user_table',
            'cp_user_data = compose.db2:cp_user_data',
            'db2_validate_hadr = compose.db2:db2_validate_hadr',
            'db2_validate_primary = compose.db2:db2_validate_primary',
            'db2_run_select = compose.db2:db2_run_select',
            'disable_network = compose.db2:disable_network',
            'rotate_db2inst1 = compose.db2:rotate_db2inst1',
            'verify_single_replica = compose.db2:verify_single_replica',
            'configure_lite_plan =  compose.db2:configure_lite_plan',
            'verify_not_primary = compose.db2:verify_not_primary',
            'wait_for_cos_file = compose.db2:wait_for_cos_file',
            'publish_ports = compose.db2:publish_ports',
            'remote_ports = compose.db2:remote_ports',
            'dr_takeover = compose.db2:dr_takeover',
            'backup_hadr_config = compose.db2:backup_hadr_config',
            'configure_disaster_recovery = compose.db2:configure_disaster_recovery',
            'unconfigure_disaster_recovery = compose.db2:unconfigure_disaster_recovery',
            'is_disaster_recovery_site = compose.db2:is_disaster_recovery_site',
            'validate_dr_connected = compose.db2:validate_dr_connected',
            'validate_recent_backup = compose.db2:validate_recent_backup',
            'backup_forbb = compose.db2:backup_forbb',
            'update_db2_keystore =  compose.db2:update_db2_keystore'],
        'cdb.configuration': [
            'db2 = compose.db2.configuration:Configuration'
        ],
        "cdb.measures": [
            "db2 = compose.measures.db2",
            "refresh = compose.measures.db2:refresh"
        ]
    }
)
