import * as iam from 'aws-cdk-lib/aws-iam';
import { Construct } from 'constructs';
import { LoginConfig } from './login';
/**
 * Source information
 */
export interface SourceConfig {
    /**
     * The source image URI.
     */
    readonly imageUri: string;
    /**
     * The login command and region.
     */
    readonly loginConfig: LoginConfig;
    /**
     * The source tag.
     */
    readonly imageTag: string;
}
/**
 * Bind context for Source
 */
export interface SourceContext {
    /**
     * The role for the handler.
     */
    readonly handlerRole: iam.IRole;
}
/**
 * Specifies docker image deployment source
 *
 * Usage:
 *
 * ```ts
 * import * as path from 'path';
 * const path = path.join(__dirname, 'path/to/directory');
 * const sourceDirectory = Source.directory(path);
 * ```
 *
 */
export declare abstract class Source {
    /**
     * Uses a local image built from a Dockerfile in a local directory as the source.
     *
     * @param path - path to the directory containing your Dockerfile (not a path to a file)
     */
    static directory(path: string): Source;
    /**
     * Bind grants the CodeBuild role permissions to pull from a repository if necessary.
     * Bind should be invoked by the caller to get the SourceConfig.
     */
    abstract bind(scope: Construct, context: SourceContext): SourceConfig;
}
