# Generated by Django 2.2.28 on 2023-03-31 06:56

from django.db import migrations, models
import django.db.models.deletion
import djangoldp.fields


class Migration(migrations.Migration):

    dependencies = [
        ('djangoldp_application', '0005_auto_20230331_0850'),
    ]

    operations = [
        migrations.CreateModel(
            name='ApplicationService',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('urlid', djangoldp.fields.LDPUrlField(blank=True, null=True, unique=True)),
                ('is_backlink', models.BooleanField(default=False, help_text='set automatically to indicate the Model is a backlink')),
                ('allow_create_backlink', models.BooleanField(default=True, help_text='set to False to disable backlink creation after Model save')),
                ('primary_key', models.CharField(blank=True, max_length=255, null=True)),
                ('key', models.CharField(blank=True, max_length=255, null=True)),
                ('value', models.CharField(blank=True, max_length=255, null=True)),
                ('application', models.ForeignKey(blank=True, null=True, on_delete=django.db.models.deletion.CASCADE, related_name='services', to='djangoldp_application.Application')),
            ],
            options={
                'verbose_name': 'application service',
                'verbose_name_plural': 'application services',
                'abstract': False,
                'default_permissions': ['add', 'change', 'delete', 'view', 'control'],
                'rdf_type': 'sib:service',
                'rdf_context': {'application': 'sib:application', 'key': 'sib:key', 'primary_key': 'sib:key', 'value': 'sib:value'},
                'owner_field': 'application__creator',
                'container_path': 'application-services/',
                'serializer_fields': ['@id', 'primary_key', 'key', 'value'],
                'depth': 0,
                'anonymous_perms': ['view'],
                'authenticated_perms': ['inherit'],
                'owner_perms': ['inherit', 'change', 'delete'],
                'superuser_perms': ['inherit'],
            },
        ),
    ]
