import { Metric, MetricOptions } from '@aws-cdk/aws-cloudwatch';
import { RetentionDays } from '@aws-cdk/aws-logs';
import { IBucket } from '@aws-cdk/aws-s3';
import { Construct, Duration } from '@aws-cdk/core';
import { Monitoring } from '../../monitoring';
export interface InventoryProps {
    /**
     * The data storage bucket.
     */
    readonly bucket: IBucket;
    /**
     * The `Monitoring` instance to use for reporting this canary's health.
     */
    readonly monitoring: Monitoring;
    /**
     * How long should canary logs be retained?
     */
    readonly logRetention?: RetentionDays;
    /**
     * The rate at which the canary should run.
     *
     * @default Duration.minutes(5)
     */
    readonly scheduleRate?: Duration;
}
/**
 * Periodically computes an inventory of all indexed packages into the storage
 * bucket, and produces metrics with an overview of the index' state.
 */
export declare class Inventory extends Construct {
    private readonly canary;
    constructor(scope: Construct, id: string, props: InventoryProps);
    metricMissingPackageMetadataCount(opts?: MetricOptions): Metric;
    metricMissingAssemblyCount(opts?: MetricOptions): Metric;
    metricPackageCount(opts?: MetricOptions): Metric;
    metricPackageMajorCount(opts?: MetricOptions): Metric;
    metricPackageVersionCount(opts?: MetricOptions): Metric;
    metricMissingPythonDocsCount(opts?: MetricOptions): Metric;
    metricMissingTypeScriptDocsCount(opts?: MetricOptions): Metric;
    metricMissingPackageTarballCount(opts?: MetricOptions): Metric;
    metricSubmoduleCount(opts?: MetricOptions): Metric;
    metricUnknownObjectCount(opts?: MetricOptions): Metric;
}
