"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.reset = exports.stepFunctions = exports.sqs = exports.s3ObjectExists = exports.s3 = void 0;
const _AWS = require("aws-sdk");
const AWSXRay = require("aws-xray-sdk-core");
// Do nothing if there is no XRay trace context
AWSXRay.setContextMissingStrategy(() => { });
const AWS = AWSXRay.captureAWS(_AWS);
let _s3;
let _sqs;
let _sfn;
function s3() {
    if (_s3 == null) {
        _s3 = new AWS.S3();
    }
    return _s3;
}
exports.s3 = s3;
/**
 * Checks whether an object exists in S3 at the provided bucket and key.
 */
function s3ObjectExists(bucket, key) {
    return s3().headObject({
        Bucket: bucket,
        Key: key,
    }).promise()
        .then(() => true, (cause) => {
        if (cause.code === 'NotFound') {
            return false;
        }
        return Promise.reject(cause);
    });
}
exports.s3ObjectExists = s3ObjectExists;
function sqs() {
    if (_sqs == null) {
        _sqs = new AWS.SQS();
    }
    return _sqs;
}
exports.sqs = sqs;
function stepFunctions() {
    if (_sfn == null) {
        _sfn = new AWS.StepFunctions();
    }
    return _sfn;
}
exports.stepFunctions = stepFunctions;
/**
 * Resets all clients vended by this module. This is useful in unit tests when
 * `aws-sdk-mocks` is used, so that new mocks are injected as intended.
 */
function reset() {
    _s3 = _sqs = _sfn = undefined;
}
exports.reset = reset;
//# sourceMappingURL=data:application/json;base64,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