/**
 * Supported languages to generate documentation in.
 */
export declare class DocumentationLanguage {
    private readonly lang;
    /**
     * TypeScript.
     */
    static readonly TYPESCRIPT: DocumentationLanguage;
    /**
     * Python.
     */
    static readonly PYTHON: DocumentationLanguage;
    /**
     * Java.
     */
    static readonly JAVA: DocumentationLanguage;
    /**
     * CSharp.
     */
    static readonly CSHARP: DocumentationLanguage;
    /**
     * All supported languages.
     */
    static readonly ALL: readonly [DocumentationLanguage, DocumentationLanguage, DocumentationLanguage, DocumentationLanguage];
    /**
     * Transform a literal string to the `DocumentationLanguage` object.
     *
     * Throws an `UnsupportedLanguageError` if the language is not supported.
     */
    static fromString(lang: string): DocumentationLanguage;
    private constructor();
    toString(): string;
}
export declare class UnsupportedLanguageError extends Error {
    constructor(lang: string, supported: readonly DocumentationLanguage[]);
}
