"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
const aws_lambda_1 = require("@aws-cdk/aws-lambda");
const core_1 = require("@aws-cdk/core");
const license_list_1 = require("../../../backend/license-list/license-list");
const spdx_license_1 = require("../../../spdx-license");
test('empty set', () => {
    // GIVEN
    const app = new core_1.App();
    const stack = new core_1.Stack(app, 'TestStack');
    const lambda = new aws_lambda_1.Function(stack, 'Function', { code: aws_lambda_1.Code.fromInline('/* ... */'), runtime: aws_lambda_1.Runtime.NODEJS_12_X, handler: 'index.handler' });
    // WHEN
    new license_list_1.LicenseList(stack, 'LicenseList', { licenses: [] }).grantRead(lambda);
    // THEN
    expect(app.synth().getStackByName(stack.stackName).template).toMatchSnapshot();
});
test('Apache licenses only', () => {
    // GIVEN
    const app = new core_1.App();
    const stack = new core_1.Stack(app, 'TestStack');
    const lambda = new aws_lambda_1.Function(stack, 'Function', { code: aws_lambda_1.Code.fromInline('/* ... */'), runtime: aws_lambda_1.Runtime.NODEJS_12_X, handler: 'index.handler' });
    // WHEN
    new license_list_1.LicenseList(stack, 'LicenseList', { licenses: spdx_license_1.SpdxLicense.apache() }).grantRead(lambda);
    // THEN
    expect(app.synth().getStackByName(stack.stackName).template).toMatchSnapshot();
});
test('BSD licenses only', () => {
    // GIVEN
    const app = new core_1.App();
    const stack = new core_1.Stack(app, 'TestStack');
    const lambda = new aws_lambda_1.Function(stack, 'Function', { code: aws_lambda_1.Code.fromInline('/* ... */'), runtime: aws_lambda_1.Runtime.NODEJS_12_X, handler: 'index.handler' });
    // WHEN
    new license_list_1.LicenseList(stack, 'LicenseList', { licenses: spdx_license_1.SpdxLicense.bsd() }).grantRead(lambda);
    // THEN
    expect(app.synth().getStackByName(stack.stackName).template).toMatchSnapshot();
});
test('MIT licenses only', () => {
    // GIVEN
    const app = new core_1.App();
    const stack = new core_1.Stack(app, 'TestStack');
    const lambda = new aws_lambda_1.Function(stack, 'Function', { code: aws_lambda_1.Code.fromInline('/* ... */'), runtime: aws_lambda_1.Runtime.NODEJS_12_X, handler: 'index.handler' });
    // WHEN
    new license_list_1.LicenseList(stack, 'LicenseList', { licenses: spdx_license_1.SpdxLicense.mit() }).grantRead(lambda);
    // THEN
    expect(app.synth().getStackByName(stack.stackName).template).toMatchSnapshot();
});
test('OSI-Approved licenses only', () => {
    // GIVEN
    const app = new core_1.App();
    const stack = new core_1.Stack(app, 'TestStack');
    const lambda = new aws_lambda_1.Function(stack, 'Function', { code: aws_lambda_1.Code.fromInline('/* ... */'), runtime: aws_lambda_1.Runtime.NODEJS_12_X, handler: 'index.handler' });
    // WHEN
    new license_list_1.LicenseList(stack, 'LicenseList', { licenses: spdx_license_1.SpdxLicense.osiApproved() }).grantRead(lambda);
    // THEN
    expect(app.synth().getStackByName(stack.stackName).template).toMatchSnapshot();
});
test('All licenses', () => {
    // GIVEN
    const app = new core_1.App();
    const stack = new core_1.Stack(app, 'TestStack');
    const lambda = new aws_lambda_1.Function(stack, 'Function', { code: aws_lambda_1.Code.fromInline('/* ... */'), runtime: aws_lambda_1.Runtime.NODEJS_12_X, handler: 'index.handler' });
    // WHEN
    new license_list_1.LicenseList(stack, 'LicenseList', { licenses: spdx_license_1.SpdxLicense.all() }).grantRead(lambda);
    // THEN
    expect(app.synth().getStackByName(stack.stackName).template).toMatchSnapshot();
});
//# sourceMappingURL=data:application/json;base64,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