import { IBucket } from '@aws-cdk/aws-s3';
import { Construct } from '@aws-cdk/core';
import { DenyList } from './backend/deny-list';
import { Discovery } from './backend/discovery';
import { Ingestion } from './backend/ingestion';
import { Inventory } from './backend/inventory';
import { Orchestration } from './backend/orchestration';
export interface BackendDashboardProps {
    readonly dashboardName?: string;
    readonly discovery: Discovery;
    readonly ingestion: Ingestion;
    readonly orchestration: Orchestration;
    readonly inventory: Inventory;
    readonly denyList: DenyList;
    readonly packageData: IBucket;
}
export declare class BackendDashboard extends Construct {
    constructor(scope: Construct, id: string, props: BackendDashboardProps);
    private catalogOverviewLanguageSections;
}
