import * as lambda from '@aws-cdk/aws-lambda';
import * as s3 from '@aws-cdk/aws-s3';
import { Construct } from '@aws-cdk/core';
import { SpdxLicense } from '../../spdx-license';
export interface LicenseListProps {
    /**
     * All SPDX licenses to be included in the list.
     */
    readonly licenses: SpdxLicense[];
}
/**
 * A list of licenses, which can be used to control filter packages before
 * indexing.
 */
export declare class LicenseList extends Construct {
    /**
     * The S3 bucket in which the license list is stored.
     */
    readonly bucket: s3.IBucket;
    /**
     * The object key i which the license list is stored.
     */
    readonly objectKey = "allowed-licenses.json";
    private readonly upload;
    constructor(scope: Construct, id: string, props: LicenseListProps);
    /**
     * Grants an AWS Lambda function permissions to read the license allow list,
     * and adds the relevant environment variables expected by the
     * `LicenseListClient`.
     */
    grantRead(handler: lambda.Function): void;
    private createAsset;
}
